import{s as dl,o as ul,n as rl}from"../chunks/scheduler.8c3d61f6.js";import{S as yl,i as ml,g as i,s as a,r as M,A as hl,h as p,f as l,c as n,j as ol,u as r,x as o,k as cl,y as Jl,a as s,v as d,d as u,t as y,w as m}from"../chunks/index.da70eac4.js";import{T as Ml}from"../chunks/Tip.1d9b8c37.js";import{C as J}from"../chunks/CodeBlock.a9c4becf.js";import{H as ft,E as Tl}from"../chunks/getInferenceSnippets.c28dea0b.js";function Ul(we){let c,T="🧪 <strong>Experimental Feature</strong>: Modular Diffusers is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){c=i("p"),c.innerHTML=T},l(h){c=p(h,"P",{"data-svelte-h":!0}),o(c)!=="svelte-11qh5l3"&&(c.innerHTML=T)},m(h,U){s(h,c,U)},p:rl,d(h){h&&l(c)}}}function wl(we){let c,T='<strong>Important</strong>: <code>PipelineBlock</code>s are definitions/specifications, not runnable pipelines. They define what a block should do and what data it needs, but you need to convert them into a <code>ModularPipeline</code> to actually execute them. For information on creating and running pipelines, see the <a href="./modular_pipeline.md">Modular Pipeline guide</a>.';return{c(){c=i("p"),c.innerHTML=T},l(h){c=p(h,"P",{"data-svelte-h":!0}),o(c)!=="svelte-q936yf"&&(c.innerHTML=T)},m(h,U){s(h,c,U)},p:rl,d(h){h&&l(c)}}}function jl(we){let c,T,h,U,b,be,w,fe,f,It="In Modular Diffusers, you build your workflow using <code>ModularPipelineBlocks</code>. We support 4 different types of blocks: <code>PipelineBlock</code>, <code>SequentialPipelineBlocks</code>, <code>LoopSequentialPipelineBlocks</code>, and <code>AutoPipelineBlocks</code>. Among them, <code>PipelineBlock</code> is the most fundamental building block of the whole system - it’s like a brick in a Lego system. These blocks are designed to easily connect with each other, allowing for modular construction of creative and potentially very complex workflows.",Ie,j,Ce,I,Ct="In this tutorial, we will focus on how to write a basic <code>PipelineBlock</code> and how it interacts with the pipeline state.",Be,C,ke,B,Bt='Before we dive into creating <code>PipelineBlock</code>s, make sure you have a basic understanding of <code>PipelineState</code>. It acts as the global state container that all blocks operate on - each block gets a local view (<code>BlockState</code>) of the relevant variables it needs from <code>PipelineState</code>, performs its operations, and then updates <code>PipelineState</code> with any changes. See the <a href="./modular_diffusers_states.md">PipelineState and BlockState guide</a> for more details.',_e,k,Ge,_,kt="To write a <code>PipelineBlock</code> class, you need to define a few properties that determine how your block interacts with the pipeline state. Understanding these properties is crucial - they define what data your block can access and what it can produce.",ge,G,_t="The three main properties you need to define are:",Ze,g,Gt="<li><code>inputs</code>: Immutable values from the user that cannot be modified</li> <li><code>intermediate_inputs</code>: Mutable values from previous blocks that can be read and modified</li> <li><code>intermediate_outputs</code>: New values your block creates for subsequent blocks and user access</li>",Re,Z,gt="Let’s explore each one and understand how they work with the pipeline state.",ve,R,Zt="<strong>Inputs: Immutable User Values</strong>",Xe,v,Rt="Inputs are variables your block needs from the immutable pipeline state - these are user-provided values that cannot be modified by any block. You define them using <code>InputParam</code>:",Se,X,We,S,vt="When you list something as an input, you’re saying “I need this value directly from the end user, and I will talk to them directly, telling them what I need in the ‘description’ field. They will provide it and it will come to me unchanged.”",Ne,W,Xt="This is especially useful for raw values that serve as the “source of truth” in your workflow. For example, with a raw image, many workflows require preprocessing steps like resizing that a previous block might have performed. But in many cases, you also want the raw PIL image. In some inpainting workflows, you need the original image to overlay with the generated result for better control and consistency.",Ye,N,St="<strong>Intermediate Inputs: Mutable Values from Previous Blocks, or Users</strong>",Ae,Y,Wt="Intermediate inputs are variables your block needs from the mutable pipeline state - these are values that can be read and modified. They’re typically created by previous blocks, but could also be directly provided by the user if not the case:",Ve,A,Qe,V,Nt="When you list something as an intermediate input, you’re saying “I need this value, but I want to work with a different block that has already created it. I already know for sure that I can get it from this other block, but it’s okay if other developers want use something different.”",$e,Q,Yt="<strong>Intermediate Outputs: New Values for Subsequent Blocks and User Access</strong>",Ee,$,At="Intermediate outputs are new variables your block creates and adds to the mutable pipeline state. They serve two purposes:",He,E,Vt="<li><strong>For subsequent blocks</strong>: They can be used as intermediate inputs by other blocks in the pipeline</li> <li><strong>For users</strong>: They become available as final outputs that users can access when running the pipeline</li>",xe,H,ze,x,Qt="Intermediate inputs and intermediate outputs work together like Lego studs and anti-studs - they’re the connection points that make blocks modular. When one block produces an intermediate output, it becomes available as an intermediate input for subsequent blocks. This is where the “modular” nature of the system really shines - blocks can be connected and reconnected in different ways as long as their inputs and outputs match.",Fe,z,$t="Additionally, all intermediate outputs are accessible to users when they run the pipeline, typically you would only need the final images, but they are also able to access intermediate results like latents, embeddings, or other processing steps.",Pe,F,Et="<strong>The <code>__call__</code> Method Structure</strong>",Le,P,Ht="Your <code>PipelineBlock</code>’s <code>__call__</code> method should follow this structure:",qe,L,De,q,xt="The <code>block_state</code> object contains all the variables you defined in <code>inputs</code> and <code>intermediate_inputs</code>, making them easily accessible for your computation.",Ke,D,zt="<strong>Components and Configs</strong>",Oe,K,Ft="You can define the components and pipeline-level configs your block needs using <code>ComponentSpec</code> and <code>ConfigSpec</code>:",et,O,tt,ee,Pt='<strong>Components</strong>: In the <code>ComponentSpec</code>, you must provide a <code>name</code> and ideally a <code>type_hint</code>. You can also specify a <code>default_creation_method</code> to indicate whether the component should be loaded from a pretrained model or created with default configurations. The actual loading details (<code>repo</code>, <code>subfolder</code>, <code>variant</code> and <code>revision</code> fields) are typically specified when creating the pipeline, as we covered in the <a href="./modular_pipeline.md">Modular Pipeline Guide</a>.',lt,te,Lt="<strong>Configs</strong>: Pipeline-level settings that control behavior across all blocks.",st,le,qt="When you convert your blocks into a pipeline using <code>blocks.init_pipeline()</code>, the pipeline collects all component requirements from the blocks and fetches the loading specs from the modular repository. The components are then made available to your block as the first argument of the <code>__call__</code> method. You can access any component you need using dot notation:",at,se,nt,ae,Dt="That’s all you need to define in order to create a <code>PipelineBlock</code>. There is no hidden complexity. In fact we are going to create a helper function that take exactly these variables as input and return a pipeline block. We will use this helper function through out the tutorial to create test blocks",it,ne,Kt="Note that for <code>__call__</code> method, the only part you should implement differently is the part between <code>self.get_block_state()</code> and <code>self.set_block_state()</code>, which can be abstracted into a simple function that takes <code>block_state</code> and returns the updated state. Our helper function accepts a <code>block_fn</code> that does exactly that.",pt,ie,Ot="<strong>Helper Function</strong>",ot,pe,ct,oe,Mt,ce,el="Let’s create a simple block to see how these definitions interact with the pipeline state. To better understand what’s happening, we’ll print out the states before and after updates to inspect them:",rt,Me,dt,re,tl="Let’s check the pipeline’s docstring to see what inputs it expects:",ut,de,yt,ue,ll="Notice that <code>batch_size</code> appears as an input even though we defined it as an intermediate input. This happens because no previous block provided it, so the pipeline makes it available as a user input. However, unlike regular inputs, this value goes directly into the mutable intermediate state.",mt,ye,sl="Now let’s run the pipeline:",ht,me,Jt,he,Tt,Je,al="<strong>Key Observations:</strong>",Ut,Te,nl="<li><p><strong>Before the update</strong>: <code>image</code> (the input) goes to the immutable inputs dict, while <code>batch_size</code> (the intermediate_input) goes to the mutable intermediates dict, and both are available in <code>block_state</code>.</p></li> <li><p><strong>After the update</strong>:</p> <ul><li><strong><code>image</code> (inputs)</strong> changed in <code>block_state</code> but not in <code>pipeline_state</code> - this change is local to the block only.</li> <li><strong><code>batch_size (intermediate_inputs)</code></strong> was updated in both <code>block_state</code> and <code>pipeline_state</code> - this change affects subsequent blocks (we didn’t need to declare it as an intermediate output since it was already in the intermediates dict)</li> <li><strong><code>image_latents (intermediate_outputs)</code></strong> was added to <code>pipeline_state</code> because it was declared as an intermediate output</li> <li><strong><code>processed_image</code></strong> was not added to <code>pipeline_state</code> because it wasn’t declared as an intermediate output</li></ul></li>",wt,Ue,jt,je,bt;return b=new ft({props:{title:"PipelineBlock",local:"pipelineblock",headingTag:"h1"}}),w=new Ml({props:{warning:!0,$$slots:{default:[Ul]},$$scope:{ctx:we}}}),j=new Ml({props:{$$slots:{default:[wl]},$$scope:{ctx:we}}}),C=new ft({props:{title:"PipelineState",local:"pipelinestate",headingTag:"h2"}}),k=new ft({props:{title:"Define a PipelineBlock",local:"define-a-pipelineblock",headingTag:"h2"}}),X=new J({props:{code:"dXNlcl9pbnB1dHMlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBJbnB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZSUyMiUyQyUyMHR5cGVfaGludCUzRCUyMlBJTC5JbWFnZSUyMiUyQyUyMGRlc2NyaXB0aW9uJTNEJTIycmF3JTIwaW5wdXQlMjBpbWFnZSUyMHRvJTIwcHJvY2VzcyUyMiklMEElNUQ=",highlighted:`user_inputs = [
    InputParam(name=<span class="hljs-string">&quot;image&quot;</span>, type_hint=<span class="hljs-string">&quot;PIL.Image&quot;</span>, description=<span class="hljs-string">&quot;raw input image to process&quot;</span>)
]`,wrap:!1}}),A=new J({props:{code:"dXNlcl9pbnRlcm1lZGlhdGVfaW5wdXRzJTIwJTNEJTIwJTVCJTBBJTIwJTIwJTIwJTIwSW5wdXRQYXJhbShuYW1lJTNEJTIycHJvY2Vzc2VkX2ltYWdlJTIyJTJDJTIwdHlwZV9oaW50JTNEJTIydG9yY2guVGVuc29yJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJpbWFnZSUyMHRoYXQlMjBoYXMlMjBiZWVuJTIwcHJlcHJvY2Vzc2VkJTIwYW5kJTIwbm9ybWFsaXplZCUyMiklMkMlMEElNUQ=",highlighted:`user_intermediate_inputs = [
    InputParam(name=<span class="hljs-string">&quot;processed_image&quot;</span>, type_hint=<span class="hljs-string">&quot;torch.Tensor&quot;</span>, description=<span class="hljs-string">&quot;image that has been preprocessed and normalized&quot;</span>),
]`,wrap:!1}}),H=new J({props:{code:"dXNlcl9pbnRlcm1lZGlhdGVfb3V0cHV0cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyME91dHB1dFBhcmFtKG5hbWUlM0QlMjJpbWFnZV9sYXRlbnRzJTIyJTJDJTIwZGVzY3JpcHRpb24lM0QlMjJsYXRlbnRzJTIwcmVwcmVzZW50aW5nJTIwdGhlJTIwaW1hZ2UlMjIpJTBBJTVE",highlighted:`user_intermediate_outputs = [
    OutputParam(name=<span class="hljs-string">&quot;image_latents&quot;</span>, description=<span class="hljs-string">&quot;latents representing the image&quot;</span>)
]`,wrap:!1}}),L=new J({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBHZXQlMjBhJTIwbG9jYWwlMjB2aWV3JTIwb2YlMjB0aGUlMjBzdGF0ZSUyMHZhcmlhYmxlcyUyMHRoaXMlMjBibG9jayUyMG5lZWRzJTBBJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmdldF9ibG9ja19zdGF0ZShzdGF0ZSklMEElMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjMlMjBZb3VyJTIwY29tcHV0YXRpb24lMjBsb2dpYyUyMGhlcmUlMEElMjAlMjAlMjAlMjAlMjMlMjBibG9ja19zdGF0ZSUyMGNvbnRhaW5zJTIwYWxsJTIweW91ciUyMGlucHV0cyUyMGFuZCUyMGludGVybWVkaWF0ZV9pbnB1dHMlMEElMjAlMjAlMjAlMjAlMjMlMjBZb3UlMjBjYW4lMjBhY2Nlc3MlMjB0aGVtJTIwbGlrZSUzQSUyMGJsb2NrX3N0YXRlLmltYWdlJTJDJTIwYmxvY2tfc3RhdGUucHJvY2Vzc2VkX2ltYWdlJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBkYXRlJTIwdGhlJTIwcGlwZWxpbmUlMjBzdGF0ZSUyMHdpdGglMjB5b3VyJTIwdXBkYXRlZCUyMGJsb2NrX3N0YXRlcyUwQSUyMCUyMCUyMCUyMHNlbGYuc2V0X2Jsb2NrX3N0YXRlKHN0YXRlJTJDJTIwYmxvY2tfc3RhdGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMHN0YXRl",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Get a local view of the state variables this block needs</span>
    block_state = self.get_block_state(state)
    
    <span class="hljs-comment"># Your computation logic here</span>
    <span class="hljs-comment"># block_state contains all your inputs and intermediate_inputs</span>
    <span class="hljs-comment"># You can access them like: block_state.image, block_state.processed_image</span>
    
    <span class="hljs-comment"># Update the pipeline state with your updated block_states</span>
    self.set_block_state(state, block_state)
    <span class="hljs-keyword">return</span> components, state`,wrap:!1}}),O=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudFNwZWMlMkMlMjBDb25maWdTcGVjJTBBJTBBJTIzJTIwRGVmaW5lJTIwY29tcG9uZW50cyUyMHlvdXIlMjBibG9jayUyMG5lZWRzJTBBZXhwZWN0ZWRfY29tcG9uZW50cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbXBvbmVudFNwZWMobmFtZSUzRCUyMnVuZXQlMjIlMkMlMjB0eXBlX2hpbnQlM0RVTmV0MkRDb25kaXRpb25Nb2RlbCklMkMlMEElMjAlMjAlMjAlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJzY2hlZHVsZXIlMjIlMkMlMjB0eXBlX2hpbnQlM0RFdWxlckRpc2NyZXRlU2NoZWR1bGVyKSUwQSU1RCUwQSUwQSUyMyUyMERlZmluZSUyMHBpcGVsaW5lLWxldmVsJTIwY29uZmlncyUwQWV4cGVjdGVkX2NvbmZpZyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMENvbmZpZ1NwZWMoJTIyZm9yY2VfemVyb3NfZm9yX2VtcHR5X3Byb21wdCUyMiUyQyUyMFRydWUpJTBBJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentSpec, ConfigSpec

<span class="hljs-comment"># Define components your block needs</span>
expected_components = [
    ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>, type_hint=UNet2DConditionModel),
    ComponentSpec(name=<span class="hljs-string">&quot;scheduler&quot;</span>, type_hint=EulerDiscreteScheduler)
]

<span class="hljs-comment"># Define pipeline-level configs</span>
expected_config = [
    ConfigSpec(<span class="hljs-string">&quot;force_zeros_for_empty_prompt&quot;</span>, <span class="hljs-literal">True</span>)
]`,wrap:!1}}),se=new J({props:{code:"ZGVmJTIwX19jYWxsX18oc2VsZiUyQyUyMGNvbXBvbmVudHMlMkMlMjBzdGF0ZSklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBBY2Nlc3MlMjBjb21wb25lbnRzJTIwdXNpbmclMjBkb3QlMjBub3RhdGlvbiUwQSUyMCUyMCUyMCUyMHVuZXQlMjAlM0QlMjBjb21wb25lbnRzLnVuZXQlMEElMjAlMjAlMjAlMjB2YWUlMjAlM0QlMjBjb21wb25lbnRzLnZhZSUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUyMCUzRCUyMGNvbXBvbmVudHMuc2NoZWR1bGVy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
    <span class="hljs-comment"># Access components using dot notation</span>
    unet = components.unet
    vae = components.vae
    scheduler = components.scheduler`,wrap:!1}}),pe=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcyUyMGltcG9ydCUyMFBpcGVsaW5lQmxvY2slMkMlMjBJbnB1dFBhcmFtJTJDJTIwT3V0cHV0UGFyYW0lMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRlZiUyMG1ha2VfYmxvY2soaW5wdXRzJTNEJTVCJTVEJTJDJTIwaW50ZXJtZWRpYXRlX2lucHV0cyUzRCU1QiU1RCUyQyUyMGludGVybWVkaWF0ZV9vdXRwdXRzJTNEJTVCJTVEJTJDJTIwYmxvY2tfZm4lM0ROb25lJTJDJTIwZGVzY3JpcHRpb24lM0ROb25lKSUzQSUwQSUyMCUyMCUyMCUyMGNsYXNzJTIwVGVzdEJsb2NrKFBpcGVsaW5lQmxvY2spJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxfbmFtZSUyMCUzRCUyMCUyMnRlc3QlMjIlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMGlucHV0cyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGlucHV0cyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU0MHByb3BlcnR5JTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZGVmJTIwaW50ZXJtZWRpYXRlX2lucHV0cyhzZWxmKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGludGVybWVkaWF0ZV9pbnB1dHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMGludGVybWVkaWF0ZV9vdXRwdXRzKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwaW50ZXJtZWRpYXRlX291dHB1dHMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlNDBwcm9wZXJ0eSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMGRlc2NyaXB0aW9uKHNlbGYpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwZGVzY3JpcHRpb24lMjBpZiUyMGRlc2NyaXB0aW9uJTIwaXMlMjBub3QlMjBOb25lJTIwZWxzZSUyMCUyMiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlZiUyMF9fY2FsbF9fKHNlbGYlMkMlMjBjb21wb25lbnRzJTJDJTIwc3RhdGUpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBzZWxmLmdldF9ibG9ja19zdGF0ZShzdGF0ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZiUyMGJsb2NrX2ZuJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmxvY2tfc3RhdGUlMjAlM0QlMjBibG9ja19mbihibG9ja19zdGF0ZSUyQyUyMHN0YXRlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNlbGYuc2V0X2Jsb2NrX3N0YXRlKHN0YXRlJTJDJTIwYmxvY2tfc3RhdGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwY29tcG9uZW50cyUyQyUyMHN0YXRlJTBBJTIwJTIwJTIwJTIwJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwVGVzdEJsb2Nr",highlighted:`<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> PipelineBlock, InputParam, OutputParam
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_block</span>(<span class="hljs-params">inputs=[], intermediate_inputs=[], intermediate_outputs=[], block_fn=<span class="hljs-literal">None</span>, description=<span class="hljs-literal">None</span></span>):
    <span class="hljs-keyword">class</span> <span class="hljs-title class_">TestBlock</span>(<span class="hljs-title class_ inherited__">PipelineBlock</span>):
        model_name = <span class="hljs-string">&quot;test&quot;</span>
        
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">inputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> inputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_inputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> intermediate_inputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">intermediate_outputs</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> intermediate_outputs
            
<span class="hljs-meta">        @property</span>
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">description</span>(<span class="hljs-params">self</span>):
            <span class="hljs-keyword">return</span> description <span class="hljs-keyword">if</span> description <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;&quot;</span>
            
        <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, components, state</span>):
            block_state = self.get_block_state(state)
            <span class="hljs-keyword">if</span> block_fn <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
                block_state = block_fn(block_state, state)
            self.set_block_state(state, block_state)
            <span class="hljs-keyword">return</span> components, state
    
    <span class="hljs-keyword">return</span> TestBlock`,wrap:!1}}),oe=new ft({props:{title:"Example: Creating a Simple Pipeline Block",local:"example-creating-a-simple-pipeline-block",headingTag:"h2"}}),Me=new J({props:{code:"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",highlighted:`inputs = [
    InputParam(name=<span class="hljs-string">&quot;image&quot;</span>, type_hint=<span class="hljs-string">&quot;PIL.Image&quot;</span>, description=<span class="hljs-string">&quot;raw input image to process&quot;</span>)
]

intermediate_inputs = [InputParam(name=<span class="hljs-string">&quot;batch_size&quot;</span>, type_hint=<span class="hljs-built_in">int</span>)]

intermediate_outputs = [
    OutputParam(name=<span class="hljs-string">&quot;image_latents&quot;</span>, description=<span class="hljs-string">&quot;latents representing the image&quot;</span>)
]

<span class="hljs-keyword">def</span> <span class="hljs-title function_">image_encoder_block_fn</span>(<span class="hljs-params">block_state, pipeline_state</span>):
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;pipeline_state (before update): <span class="hljs-subst">{pipeline_state}</span>&quot;</span>)
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;block_state (before update): <span class="hljs-subst">{block_state}</span>&quot;</span>)
    
    <span class="hljs-comment"># Simulate processing the image</span>
    block_state.image = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>)
    block_state.batch_size = block_state.batch_size * <span class="hljs-number">2</span>
    block_state.processed_image = [torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, <span class="hljs-number">512</span>, <span class="hljs-number">512</span>)] * block_state.batch_size
    block_state.image_latents = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">4</span>, <span class="hljs-number">64</span>, <span class="hljs-number">64</span>)
    
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;block_state (after update): <span class="hljs-subst">{block_state}</span>&quot;</span>)
    <span class="hljs-keyword">return</span> block_state

<span class="hljs-comment"># Create a block with our definitions</span>
image_encoder_block_cls = make_block(
    inputs=inputs, 
    intermediate_inputs=intermediate_inputs,
    intermediate_outputs=intermediate_outputs, 
    block_fn=image_encoder_block_fn,
    description=<span class="hljs-string">&quot;Encode raw image into its latent presentation&quot;</span>
)
image_encoder_block = image_encoder_block_cls()
pipe = image_encoder_block.init_pipeline()`,wrap:!1}}),de=new J({props:{code:"cHJpbnQocGlwZS5kb2MpJTBBJTBBJTBBJTBBJTBBJTBB",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(pipe.doc)
<span class="hljs-keyword">class</span> <span class="hljs-title class_">TestBlock</span>

  Encode raw image into its latent presentation

  Inputs:

      image (\`PIL.Image\`, *optional*):
          raw <span class="hljs-built_in">input</span> image to process

      batch_size (\`<span class="hljs-built_in">int</span>\`, *optional*):

  Outputs:

      image_latents (\`<span class="hljs-literal">None</span>\`):
          latents representing the image`,wrap:!1}}),me=new J({props:{code:"ZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFpbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGaW1hZ2Vfb2Zfc3F1aXJyZWxfcGFpbnRpbmcucG5nJTIyKSUwQXN0YXRlJTIwJTNEJTIwcGlwZShpbWFnZSUzRGltYWdlJTJDJTIwYmF0Y2hfc2l6ZSUzRDIpJTBBcHJpbnQoZiUyMnBpcGVsaW5lX3N0YXRlJTIwKGFmdGVyJTIwdXBkYXRlKSUzQSUyMCU3QnN0YXRlJTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/image_of_squirrel_painting.png&quot;</span>)
state = pipe(image=image, batch_size=<span class="hljs-number">2</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;pipeline_state (after update): <span class="hljs-subst">{state}</span>&quot;</span>)`,wrap:!1}}),he=new J({props:{code:"cGlwZWxpbmVfc3RhdGUlMjAoYmVmb3JlJTIwdXBkYXRlKSUzQSUyMFBpcGVsaW5lU3RhdGUoJTBBJTIwJTIwaW5wdXRzJTNEJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RSR0IlMjBzaXplJTNENTEyeDUxMiUyMGF0JTIwMHg3RjNFQ0M0OTQ1NTAlM0UlMEElMjAlMjAlN0QlMkMlMEElMjAlMjBpbnRlcm1lZGlhdGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzQSUyMDIlMEElMjAlMjAlN0QlMkMlMEEpJTBBYmxvY2tfc3RhdGUlMjAoYmVmb3JlJTIwdXBkYXRlKSUzQSUyMEJsb2NrU3RhdGUoJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RSR0IlMjBzaXplJTNENTEyeDUxMiUyMGF0JTIwMHg3RjNFQ0M0OTQ2NDAlM0UlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNBJTIwMiUwQSklMEElMEFibG9ja19zdGF0ZSUyMChhZnRlciUyMHVwZGF0ZSklM0ElMjBCbG9ja1N0YXRlKCUwQSUyMCUyMCUyMCUyMGltYWdlJTNBJTIwVGVuc29yKGR0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUyMHNoYXBlJTNEdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDUxMiUyQyUyMDUxMiU1RCkpJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzQSUyMDQlMEElMjAlMjAlMjAlMjBwcm9jZXNzZWRfaW1hZ2UlM0ElMjBMaXN0JTVCNCU1RCUyMG9mJTIwVGVuc29ycyUyMHdpdGglMjBzaGFwZXMlMjAlNUJ0b3JjaC5TaXplKCU1QjElMkMlMjAzJTJDJTIwNTEyJTJDJTIwNTEyJTVEKSUyQyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDMlMkMlMjA1MTIlMkMlMjA1MTIlNUQpJTJDJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMyUyQyUyMDUxMiUyQyUyMDUxMiU1RCklMkMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAzJTJDJTIwNTEyJTJDJTIwNTEyJTVEKSU1RCUwQSUyMCUyMCUyMCUyMGltYWdlX2xhdGVudHMlM0ElMjBUZW5zb3IoZHR5cGUlM0R0b3JjaC5mbG9hdDMyJTJDJTIwc2hhcGUlM0R0b3JjaC5TaXplKCU1QjElMkMlMjA0JTJDJTIwNjQlMkMlMjA2NCU1RCkpJTBBKSUwQXBpcGVsaW5lX3N0YXRlJTIwKGFmdGVyJTIwdXBkYXRlKSUzQSUyMFBpcGVsaW5lU3RhdGUoJTBBJTIwJTIwaW5wdXRzJTNEJTdCJTBBJTIwJTIwJTIwJTIwaW1hZ2UlM0ElMjAlM0NQSUwuSW1hZ2UuSW1hZ2UlMjBpbWFnZSUyMG1vZGUlM0RSR0IlMjBzaXplJTNENTEyeDUxMiUyMGF0JTIwMHg3RjNFQ0M0OTQ1NTAlM0UlMEElMjAlMjAlN0QlMkMlMEElMjAlMjBpbnRlcm1lZGlhdGVzJTNEJTdCJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzQSUyMDQlMEElMjAlMjAlMjAlMjBpbWFnZV9sYXRlbnRzJTNBJTIwVGVuc29yKGR0eXBlJTNEdG9yY2guZmxvYXQzMiUyQyUyMHNoYXBlJTNEdG9yY2guU2l6ZSglNUIxJTJDJTIwNCUyQyUyMDY0JTJDJTIwNjQlNUQpKSUwQSUyMCUyMCU3RCUyQyUwQSk=",highlighted:`pipeline_state (before update): <span class="hljs-built_in">PipelineState</span>(
  inputs={
    image: &lt;PIL<span class="hljs-selector-class">.Image</span><span class="hljs-selector-class">.Image</span> image mode=RGB size=<span class="hljs-number">512</span>x512 at <span class="hljs-number">0</span>x7F3ECC494550&gt;
  },
  intermediates={
    batch_size: <span class="hljs-number">2</span>
  },
)
block_state (before update): <span class="hljs-built_in">BlockState</span>(
    image: &lt;PIL<span class="hljs-selector-class">.Image</span><span class="hljs-selector-class">.Image</span> image mode=RGB size=<span class="hljs-number">512</span>x512 at <span class="hljs-number">0</span>x7F3ECC494640&gt;
    batch_size: <span class="hljs-number">2</span>
)

block_state (after update): <span class="hljs-built_in">BlockState</span>(
    image: <span class="hljs-built_in">Tensor</span>(dtype=torch<span class="hljs-selector-class">.float32</span>, shape=torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 3, 512, 512]</span>))
    batch_size: <span class="hljs-number">4</span>
    processed_image: List<span class="hljs-selector-attr">[4]</span> of Tensors with shapes <span class="hljs-selector-attr">[torch.Size([1, 3, 512, 512]</span>), torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 3, 512, 512]</span>), torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 3, 512, 512]</span>), torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 3, 512, 512]</span>)]
    image_latents: <span class="hljs-built_in">Tensor</span>(dtype=torch<span class="hljs-selector-class">.float32</span>, shape=torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 4, 64, 64]</span>))
)
pipeline_state (after update): <span class="hljs-built_in">PipelineState</span>(
  inputs={
    image: &lt;PIL<span class="hljs-selector-class">.Image</span><span class="hljs-selector-class">.Image</span> image mode=RGB size=<span class="hljs-number">512</span>x512 at <span class="hljs-number">0</span>x7F3ECC494550&gt;
  },
  intermediates={
    batch_size: <span class="hljs-number">4</span>
    image_latents: <span class="hljs-built_in">Tensor</span>(dtype=torch<span class="hljs-selector-class">.float32</span>, shape=torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 4, 64, 64]</span>))
  },
)`,wrap:!1}}),Ue=new Tl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/pipeline_block.md"}}),{c(){c=i("meta"),T=a(),h=i("p"),U=a(),M(b.$$.fragment),be=a(),M(w.$$.fragment),fe=a(),f=i("p"),f.innerHTML=It,Ie=a(),M(j.$$.fragment),Ce=a(),I=i("p"),I.innerHTML=Ct,Be=a(),M(C.$$.fragment),ke=a(),B=i("p"),B.innerHTML=Bt,_e=a(),M(k.$$.fragment),Ge=a(),_=i("p"),_.innerHTML=kt,ge=a(),G=i("p"),G.textContent=_t,Ze=a(),g=i("ul"),g.innerHTML=Gt,Re=a(),Z=i("p"),Z.textContent=gt,ve=a(),R=i("p"),R.innerHTML=Zt,Xe=a(),v=i("p"),v.innerHTML=Rt,Se=a(),M(X.$$.fragment),We=a(),S=i("p"),S.textContent=vt,Ne=a(),W=i("p"),W.textContent=Xt,Ye=a(),N=i("p"),N.innerHTML=St,Ae=a(),Y=i("p"),Y.textContent=Wt,Ve=a(),M(A.$$.fragment),Qe=a(),V=i("p"),V.textContent=Nt,$e=a(),Q=i("p"),Q.innerHTML=Yt,Ee=a(),$=i("p"),$.textContent=At,He=a(),E=i("ol"),E.innerHTML=Vt,xe=a(),M(H.$$.fragment),ze=a(),x=i("p"),x.textContent=Qt,Fe=a(),z=i("p"),z.textContent=$t,Pe=a(),F=i("p"),F.innerHTML=Et,Le=a(),P=i("p"),P.innerHTML=Ht,qe=a(),M(L.$$.fragment),De=a(),q=i("p"),q.innerHTML=xt,Ke=a(),D=i("p"),D.innerHTML=zt,Oe=a(),K=i("p"),K.innerHTML=Ft,et=a(),M(O.$$.fragment),tt=a(),ee=i("p"),ee.innerHTML=Pt,lt=a(),te=i("p"),te.innerHTML=Lt,st=a(),le=i("p"),le.innerHTML=qt,at=a(),M(se.$$.fragment),nt=a(),ae=i("p"),ae.innerHTML=Dt,it=a(),ne=i("p"),ne.innerHTML=Kt,pt=a(),ie=i("p"),ie.innerHTML=Ot,ot=a(),M(pe.$$.fragment),ct=a(),M(oe.$$.fragment),Mt=a(),ce=i("p"),ce.textContent=el,rt=a(),M(Me.$$.fragment),dt=a(),re=i("p"),re.textContent=tl,ut=a(),M(de.$$.fragment),yt=a(),ue=i("p"),ue.innerHTML=ll,mt=a(),ye=i("p"),ye.textContent=sl,ht=a(),M(me.$$.fragment),Jt=a(),M(he.$$.fragment),Tt=a(),Je=i("p"),Je.innerHTML=al,Ut=a(),Te=i("ol"),Te.innerHTML=nl,wt=a(),M(Ue.$$.fragment),jt=a(),je=i("p"),this.h()},l(e){const t=hl("svelte-u9bgzb",document.head);c=p(t,"META",{name:!0,content:!0}),t.forEach(l),T=n(e),h=p(e,"P",{}),ol(h).forEach(l),U=n(e),r(b.$$.fragment,e),be=n(e),r(w.$$.fragment,e),fe=n(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-vdiinu"&&(f.innerHTML=It),Ie=n(e),r(j.$$.fragment,e),Ce=n(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-10bbsrk"&&(I.innerHTML=Ct),Be=n(e),r(C.$$.fragment,e),ke=n(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-t8ueug"&&(B.innerHTML=Bt),_e=n(e),r(k.$$.fragment,e),Ge=n(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-rvctvc"&&(_.innerHTML=kt),ge=n(e),G=p(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-1ub30ui"&&(G.textContent=_t),Ze=n(e),g=p(e,"UL",{"data-svelte-h":!0}),o(g)!=="svelte-a7j8z4"&&(g.innerHTML=Gt),Re=n(e),Z=p(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-5klfe5"&&(Z.textContent=gt),ve=n(e),R=p(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1np57bv"&&(R.innerHTML=Zt),Xe=n(e),v=p(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-tdwnkq"&&(v.innerHTML=Rt),Se=n(e),r(X.$$.fragment,e),We=n(e),S=p(e,"P",{"data-svelte-h":!0}),o(S)!=="svelte-1w3m1da"&&(S.textContent=vt),Ne=n(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-1bhjkc9"&&(W.textContent=Xt),Ye=n(e),N=p(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1ll0q1h"&&(N.innerHTML=St),Ae=n(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-1bdn1iq"&&(Y.textContent=Wt),Ve=n(e),r(A.$$.fragment,e),Qe=n(e),V=p(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-12wyppb"&&(V.textContent=Nt),$e=n(e),Q=p(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-1ah8lju"&&(Q.innerHTML=Yt),Ee=n(e),$=p(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-o5am1z"&&($.textContent=At),He=n(e),E=p(e,"OL",{"data-svelte-h":!0}),o(E)!=="svelte-4eunrr"&&(E.innerHTML=Vt),xe=n(e),r(H.$$.fragment,e),ze=n(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1ydjnk3"&&(x.textContent=Qt),Fe=n(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1d6fha4"&&(z.textContent=$t),Pe=n(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1hhw7iz"&&(F.innerHTML=Et),Le=n(e),P=p(e,"P",{"data-svelte-h":!0}),o(P)!=="svelte-1psrn2q"&&(P.innerHTML=Ht),qe=n(e),r(L.$$.fragment,e),De=n(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1v6w6tn"&&(q.innerHTML=xt),Ke=n(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-16m8czf"&&(D.innerHTML=zt),Oe=n(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1arw3aj"&&(K.innerHTML=Ft),et=n(e),r(O.$$.fragment,e),tt=n(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-119wvlh"&&(ee.innerHTML=Pt),lt=n(e),te=p(e,"P",{"data-svelte-h":!0}),o(te)!=="svelte-nn0usy"&&(te.innerHTML=Lt),st=n(e),le=p(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-p1dzbe"&&(le.innerHTML=qt),at=n(e),r(se.$$.fragment,e),nt=n(e),ae=p(e,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-f1vrkr"&&(ae.innerHTML=Dt),it=n(e),ne=p(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-778h92"&&(ne.innerHTML=Kt),pt=n(e),ie=p(e,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-1doi555"&&(ie.innerHTML=Ot),ot=n(e),r(pe.$$.fragment,e),ct=n(e),r(oe.$$.fragment,e),Mt=n(e),ce=p(e,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-175q5jp"&&(ce.textContent=el),rt=n(e),r(Me.$$.fragment,e),dt=n(e),re=p(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-12m4bv"&&(re.textContent=tl),ut=n(e),r(de.$$.fragment,e),yt=n(e),ue=p(e,"P",{"data-svelte-h":!0}),o(ue)!=="svelte-tge411"&&(ue.innerHTML=ll),mt=n(e),ye=p(e,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-py4f7n"&&(ye.textContent=sl),ht=n(e),r(me.$$.fragment,e),Jt=n(e),r(he.$$.fragment,e),Tt=n(e),Je=p(e,"P",{"data-svelte-h":!0}),o(Je)!=="svelte-1erus9"&&(Je.innerHTML=al),Ut=n(e),Te=p(e,"OL",{"data-svelte-h":!0}),o(Te)!=="svelte-1gxhe6q"&&(Te.innerHTML=nl),wt=n(e),r(Ue.$$.fragment,e),jt=n(e),je=p(e,"P",{}),ol(je).forEach(l),this.h()},h(){cl(c,"name","hf:doc:metadata"),cl(c,"content",bl)},m(e,t){Jl(document.head,c),s(e,T,t),s(e,h,t),s(e,U,t),d(b,e,t),s(e,be,t),d(w,e,t),s(e,fe,t),s(e,f,t),s(e,Ie,t),d(j,e,t),s(e,Ce,t),s(e,I,t),s(e,Be,t),d(C,e,t),s(e,ke,t),s(e,B,t),s(e,_e,t),d(k,e,t),s(e,Ge,t),s(e,_,t),s(e,ge,t),s(e,G,t),s(e,Ze,t),s(e,g,t),s(e,Re,t),s(e,Z,t),s(e,ve,t),s(e,R,t),s(e,Xe,t),s(e,v,t),s(e,Se,t),d(X,e,t),s(e,We,t),s(e,S,t),s(e,Ne,t),s(e,W,t),s(e,Ye,t),s(e,N,t),s(e,Ae,t),s(e,Y,t),s(e,Ve,t),d(A,e,t),s(e,Qe,t),s(e,V,t),s(e,$e,t),s(e,Q,t),s(e,Ee,t),s(e,$,t),s(e,He,t),s(e,E,t),s(e,xe,t),d(H,e,t),s(e,ze,t),s(e,x,t),s(e,Fe,t),s(e,z,t),s(e,Pe,t),s(e,F,t),s(e,Le,t),s(e,P,t),s(e,qe,t),d(L,e,t),s(e,De,t),s(e,q,t),s(e,Ke,t),s(e,D,t),s(e,Oe,t),s(e,K,t),s(e,et,t),d(O,e,t),s(e,tt,t),s(e,ee,t),s(e,lt,t),s(e,te,t),s(e,st,t),s(e,le,t),s(e,at,t),d(se,e,t),s(e,nt,t),s(e,ae,t),s(e,it,t),s(e,ne,t),s(e,pt,t),s(e,ie,t),s(e,ot,t),d(pe,e,t),s(e,ct,t),d(oe,e,t),s(e,Mt,t),s(e,ce,t),s(e,rt,t),d(Me,e,t),s(e,dt,t),s(e,re,t),s(e,ut,t),d(de,e,t),s(e,yt,t),s(e,ue,t),s(e,mt,t),s(e,ye,t),s(e,ht,t),d(me,e,t),s(e,Jt,t),d(he,e,t),s(e,Tt,t),s(e,Je,t),s(e,Ut,t),s(e,Te,t),s(e,wt,t),d(Ue,e,t),s(e,jt,t),s(e,je,t),bt=!0},p(e,[t]){const il={};t&2&&(il.$$scope={dirty:t,ctx:e}),w.$set(il);const pl={};t&2&&(pl.$$scope={dirty:t,ctx:e}),j.$set(pl)},i(e){bt||(u(b.$$.fragment,e),u(w.$$.fragment,e),u(j.$$.fragment,e),u(C.$$.fragment,e),u(k.$$.fragment,e),u(X.$$.fragment,e),u(A.$$.fragment,e),u(H.$$.fragment,e),u(L.$$.fragment,e),u(O.$$.fragment,e),u(se.$$.fragment,e),u(pe.$$.fragment,e),u(oe.$$.fragment,e),u(Me.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(Ue.$$.fragment,e),bt=!0)},o(e){y(b.$$.fragment,e),y(w.$$.fragment,e),y(j.$$.fragment,e),y(C.$$.fragment,e),y(k.$$.fragment,e),y(X.$$.fragment,e),y(A.$$.fragment,e),y(H.$$.fragment,e),y(L.$$.fragment,e),y(O.$$.fragment,e),y(se.$$.fragment,e),y(pe.$$.fragment,e),y(oe.$$.fragment,e),y(Me.$$.fragment,e),y(de.$$.fragment,e),y(me.$$.fragment,e),y(he.$$.fragment,e),y(Ue.$$.fragment,e),bt=!1},d(e){e&&(l(T),l(h),l(U),l(be),l(fe),l(f),l(Ie),l(Ce),l(I),l(Be),l(ke),l(B),l(_e),l(Ge),l(_),l(ge),l(G),l(Ze),l(g),l(Re),l(Z),l(ve),l(R),l(Xe),l(v),l(Se),l(We),l(S),l(Ne),l(W),l(Ye),l(N),l(Ae),l(Y),l(Ve),l(Qe),l(V),l($e),l(Q),l(Ee),l($),l(He),l(E),l(xe),l(ze),l(x),l(Fe),l(z),l(Pe),l(F),l(Le),l(P),l(qe),l(De),l(q),l(Ke),l(D),l(Oe),l(K),l(et),l(tt),l(ee),l(lt),l(te),l(st),l(le),l(at),l(nt),l(ae),l(it),l(ne),l(pt),l(ie),l(ot),l(ct),l(Mt),l(ce),l(rt),l(dt),l(re),l(ut),l(yt),l(ue),l(mt),l(ye),l(ht),l(Jt),l(Tt),l(Je),l(Ut),l(Te),l(wt),l(jt),l(je)),l(c),m(b,e),m(w,e),m(j,e),m(C,e),m(k,e),m(X,e),m(A,e),m(H,e),m(L,e),m(O,e),m(se,e),m(pe,e),m(oe,e),m(Me,e),m(de,e),m(me,e),m(he,e),m(Ue,e)}}}const bl='{"title":"PipelineBlock","local":"pipelineblock","sections":[{"title":"PipelineState","local":"pipelinestate","sections":[],"depth":2},{"title":"Define a PipelineBlock","local":"define-a-pipelineblock","sections":[],"depth":2},{"title":"Example: Creating a Simple Pipeline Block","local":"example-creating-a-simple-pipeline-block","sections":[],"depth":2}],"depth":1}';function fl(we){return ul(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Gl extends yl{constructor(c){super(),ml(this,c,fl,jl,dl,{})}}export{Gl as component};
