import{s as ol,o as pl,n as rl}from"../chunks/scheduler.8c3d61f6.js";import{S as cl,i as dl,g as n,s,r as c,A as ml,h as r,f as l,c as i,j as sl,u as d,x as o,k as il,y as fl,a,v as m,d as f,t as u,w as M}from"../chunks/index.da70eac4.js";import{T as nl}from"../chunks/Tip.1d9b8c37.js";import{C as y}from"../chunks/CodeBlock.a9c4becf.js";import{H as Je,E as ul}from"../chunks/getInferenceSnippets.c28dea0b.js";function Ml(ge){let p,w='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){p=n("p"),p.innerHTML=w},l(h){p=r(h,"P",{"data-svelte-h":!0}),o(p)!=="svelte-1qbiqsn"&&(p.innerHTML=w)},m(h,b){a(h,p,b)},p:rl,d(h){h&&l(p)}}}function hl(ge){let p,w='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){p=n("p"),p.innerHTML=w},l(h){p=r(h,"P",{"data-svelte-h":!0}),o(p)!=="svelte-zx7n4c"&&(p.innerHTML=w)},m(h,b){a(h,p,b)},p:rl,d(h){h&&l(p)}}}function yl(ge){let p,w,h,b,g,Ue,_,Ct='<a href="https://hf.co/papers/2310.04378" rel="nofollow">Latent Consistency Models (LCMs)</a> are able to generate high-quality images in just a few steps, representing a big leap forward because many pipelines require at least 25+ steps. LCMs are produced by applying the latent consistency distillation method to any Stable Diffusion model. This method works by applying <em>one-stage guided distillation</em> to the latent space, and incorporating a <em>skipping-step</em> method to consistently skip timesteps to accelerate the distillation process (refer to section 4.1, 4.2, and 4.3 of the paper for more details).',je,U,$t='If you’re training on a GPU with limited vRAM, try enabling <code>gradient_checkpointing</code>, <code>gradient_accumulation_steps</code>, and <code>mixed_precision</code> to reduce memory-usage and speedup training. You can reduce your memory-usage even more by enabling memory-efficient attention with <a href="../optimization/xformers">xFormers</a> and <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes’</a> 8-bit optimizer.',Ce,j,Zt='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sd_wds.py" rel="nofollow">train_lcm_distill_sd_wds.py</a> script to help you become more familiar with it, and how you can adapt it for your own use-case.',$e,C,It="Before running the script, make sure you install the library from source:",Ze,$,Ie,Z,Wt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",We,I,Re,T,xe,W,Rt="Initialize an 🤗 Accelerate environment (try enabling <code>torch.compile</code> to significantly speedup training):",Xe,R,ve,x,xt="To setup a default 🤗 Accelerate environment without choosing any configurations:",Ge,X,Ne,v,Xt="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",Le,G,ke,N,vt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ve,L,Be,J,He,k,Gt='The training script provides many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L419" rel="nofollow"><code>parse_args()</code></a> function. This function provides default values for each parameter, such as the training batch size and learning rate, but you can also set your own values in the training command if you’d like.',Qe,V,Nt="For example, to speedup training with mixed precision using the fp16 format, add the <code>--mixed_precision</code> parameter to the training command:",Fe,B,Ye,H,Lt='Most of the parameters are identical to the parameters in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so you’ll focus on the parameters that are relevant to latent consistency distillation in this guide.',Se,Q,kt='<li><code>--pretrained_teacher_model</code>: the path to a pretrained latent diffusion model to use as the teacher model</li> <li><code>--pretrained_vae_model_name_or_path</code>: path to a pretrained VAE; the SDXL VAE is known to suffer from numerical instability, so this parameter allows you to specify an alternative VAE (like this <a href="(https://huggingface.co/madebyollin/sdxl-vae-fp16-fix)">VAE</a> by madebyollin which works in fp16)</li> <li><code>--w_min</code> and <code>--w_max</code>: the minimum and maximum guidance scale values for guidance scale sampling</li> <li><code>--num_ddim_timesteps</code>: the number of timesteps for DDIM sampling</li> <li><code>--loss_type</code>: the type of loss (L2 or Huber) to calculate for latent consistency distillation; Huber loss is generally preferred because it’s more robust to outliers</li> <li><code>--huber_c</code>: the Huber loss parameter</li>',ze,F,Ae,Y,Vt='The training script starts by creating a dataset class - <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L141" rel="nofollow"><code>Text2ImageDataset</code></a> - for preprocessing the images and creating a training dataset.',Ee,S,De,z,Bt='For improved performance on reading and writing large datasets stored in the cloud, this script uses the <a href="https://github.com/webdataset/webdataset" rel="nofollow">WebDataset</a> format to create a preprocessing pipeline to apply transforms and create a dataset and dataloader for training. Images are processed and fed to the training loop without having to download the full dataset first.',qe,A,Pe,E,Ht='In the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L768" rel="nofollow"><code>main()</code></a> function, all the necessary components like the noise scheduler, tokenizers, text encoders, and VAE are loaded. The teacher UNet is also loaded here and then you can create a student UNet from the teacher UNet. The student UNet is updated by the optimizer during training.',Ke,D,Oe,q,Qt='Now you can create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L979" rel="nofollow">optimizer</a> to update the UNet parameters:',et,P,tt,K,Ft='Create the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L994" rel="nofollow">dataset</a>:',lt,O,at,ee,Yt='Next, you’re ready to setup the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1049" rel="nofollow">training loop</a> and implement the latent consistency distillation method (see Algorithm 1 in the paper for more details). This section of the script takes care of adding noise to the latents, sampling and creating a guidance scale embedding, and predicting the original image from the noise.',st,te,it,le,St='It gets the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1172" rel="nofollow">teacher model predictions</a> and the <a href="https://github.com/huggingface/diffusers/blob/3b37488fa3280aed6a95de044d7a42ffdcb565ef/examples/consistency_distillation/train_lcm_distill_sd_wds.py#L1209" rel="nofollow">LCM predictions</a> next, calculates the loss, and then backpropagates it to the LCM.',nt,ae,rt,se,zt='If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers tutorial</a> which breaks down the basic pattern of the denoising process.',ot,ie,pt,ne,At="Now you’re ready to launch the training script and start distilling!",ct,re,Et='For this guide, you’ll use the <code>--train_shards_path_or_url</code> to specify the path to the <a href="https://github.com/google-research-datasets/conceptual-12m" rel="nofollow">Conceptual Captions 12M</a> dataset stored on the Hub <a href="https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset" rel="nofollow">here</a>. Set the <code>MODEL_DIR</code> environment variable to the name of the teacher model and <code>OUTPUT_DIR</code> to where you want to save the model.',dt,oe,mt,pe,Dt="Once training is complete, you can use your new LCM for inference.",ft,ce,ut,de,Mt,me,qt='LoRA is a training technique for significantly reducing the number of trainable parameters. As a result, training is faster and it is easier to store the resulting weights because they are a lot smaller (~100MBs). Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sd_wds.py" rel="nofollow">train_lcm_distill_lora_sd_wds.py</a> or <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_lora_sdxl_wds.py" rel="nofollow">train_lcm_distill_lora_sdxl.wds.py</a> script to train with LoRA.',ht,fe,Pt='The LoRA training script is discussed in more detail in the <a href="lora">LoRA training</a> guide.',yt,ue,wt,Me,Kt='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/consistency_distillation/train_lcm_distill_sdxl_wds.py" rel="nofollow">train_lcm_distill_sdxl_wds.py</a> script to train a SDXL model with LoRA.',bt,he,Ot='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',Tt,ye,Jt,we,el="Congratulations on distilling a LCM model! To learn more about LCM, the following may be helpful:",gt,be,tl='<li>Learn how to use <a href="../using-diffusers/lcm">LCMs for inference</a> for text-to-image, image-to-image, and with LoRA checkpoints.</li> <li>Read the <a href="https://huggingface.co/blog/lcm_lora" rel="nofollow">SDXL in 4 steps with Latent Consistency LoRAs</a> blog post to learn more about SDXL LCM-LoRA’s for super fast inference, quality comparisons, benchmarks, and more.</li>',_t,Te,Ut,_e,jt;return g=new Je({props:{title:"Latent Consistency Distillation",local:"latent-consistency-distillation",headingTag:"h1"}}),$=new y({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),I=new y({props:{code:"Y2QlMjBleGFtcGxlcyUyRmNvbnNpc3RlbmN5X2Rpc3RpbGxhdGlvbiUwQXBpcCUyMGluc3RhbGwlMjAtciUyMHJlcXVpcmVtZW50cy50eHQ=",highlighted:`<span class="hljs-built_in">cd</span> examples/consistency_distillation
pip install -r requirements.txt`,wrap:!1}}),T=new nl({props:{$$slots:{default:[Ml]},$$scope:{ctx:ge}}}),R=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),X=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),L=new Je({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),J=new nl({props:{$$slots:{default:[hl]},$$scope:{ctx:ge}}}),B=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2xjbV9kaXN0aWxsX3NkX3dkcy5weSUyMCU1QyUwQSUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMg==",highlighted:`accelerate launch train_lcm_distill_sd_wds.py \\
  --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span>`,wrap:!1}}),F=new Je({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),S=new y({props:{code:"ZGVmJTIwdHJhbnNmb3JtKGV4YW1wbGUpJTNBJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnJlc2l6ZShpbWFnZSUyQyUyMHJlc29sdXRpb24lMkMlMjBpbnRlcnBvbGF0aW9uJTNEdHJhbnNmb3Jtcy5JbnRlcnBvbGF0aW9uTW9kZS5CSUxJTkVBUiklMEElMEElMjAlMjAlMjAlMjBjX3RvcCUyQyUyMGNfbGVmdCUyQyUyMF8lMkMlMjBfJTIwJTNEJTIwdHJhbnNmb3Jtcy5SYW5kb21Dcm9wLmdldF9wYXJhbXMoaW1hZ2UlMkMlMjBvdXRwdXRfc2l6ZSUzRChyZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbikpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBURi5jcm9wKGltYWdlJTJDJTIwY190b3AlMkMlMjBjX2xlZnQlMkMlMjByZXNvbHV0aW9uJTJDJTIwcmVzb2x1dGlvbiklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLnRvX3RlbnNvcihpbWFnZSklMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMFRGLm5vcm1hbGl6ZShpbWFnZSUyQyUyMCU1QjAuNSU1RCUyQyUyMCU1QjAuNSU1RCklMEElMEElMjAlMjAlMjAlMjBleGFtcGxlJTVCJTIyaW1hZ2UlMjIlNUQlMjAlM0QlMjBpbWFnZSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGV4YW1wbGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">transform</span>(<span class="hljs-params">example</span>):
    image = example[<span class="hljs-string">&quot;image&quot;</span>]
    image = TF.resize(image, resolution, interpolation=transforms.InterpolationMode.BILINEAR)

    c_top, c_left, _, _ = transforms.RandomCrop.get_params(image, output_size=(resolution, resolution))
    image = TF.crop(image, c_top, c_left, resolution, resolution)
    image = TF.to_tensor(image)
    image = TF.normalize(image, [<span class="hljs-number">0.5</span>], [<span class="hljs-number">0.5</span>])

    example[<span class="hljs-string">&quot;image&quot;</span>] = image
    <span class="hljs-keyword">return</span> example`,wrap:!1}}),A=new y({props:{code:"cHJvY2Vzc2luZ19waXBlbGluZSUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMHdkcy5kZWNvZGUoJTIycGlsJTIyJTJDJTIwaGFuZGxlciUzRHdkcy5pZ25vcmVfYW5kX2NvbnRpbnVlKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5yZW5hbWUoaW1hZ2UlM0QlMjJqcGclM0JwbmclM0JqcGVnJTNCd2VicCUyMiUyQyUyMHRleHQlM0QlMjJ0ZXh0JTNCdHh0JTNCY2FwdGlvbiUyMiUyQyUyMGhhbmRsZXIlM0R3ZHMud2Fybl9hbmRfY29udGludWUpJTJDJTBBJTIwJTIwJTIwJTIwd2RzLm1hcChmaWx0ZXJfa2V5cyglN0IlMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIlN0QpKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy5tYXAodHJhbnNmb3JtKSUyQyUwQSUyMCUyMCUyMCUyMHdkcy50b190dXBsZSglMjJpbWFnZSUyMiUyQyUyMCUyMnRleHQlMjIpJTJDJTBBJTVE",highlighted:`processing_pipeline = [
    wds.decode(<span class="hljs-string">&quot;pil&quot;</span>, handler=wds.ignore_and_continue),
    wds.rename(image=<span class="hljs-string">&quot;jpg;png;jpeg;webp&quot;</span>, text=<span class="hljs-string">&quot;text;txt;caption&quot;</span>, handler=wds.warn_and_continue),
    wds.<span class="hljs-built_in">map</span>(filter_keys({<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>})),
    wds.<span class="hljs-built_in">map</span>(transform),
    wds.to_tuple(<span class="hljs-string">&quot;image&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>),
]`,wrap:!1}}),D=new y({props:{code:"dGVhY2hlcl91bmV0JTIwJTNEJTIwVU5ldDJEQ29uZGl0aW9uTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMGFyZ3MucHJldHJhaW5lZF90ZWFjaGVyX21vZGVsJTJDJTIwc3ViZm9sZGVyJTNEJTIydW5ldCUyMiUyQyUyMHJldmlzaW9uJTNEYXJncy50ZWFjaGVyX3JldmlzaW9uJTBBKSUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbCgqKnRlYWNoZXJfdW5ldC5jb25maWcpJTBBdW5ldC5sb2FkX3N0YXRlX2RpY3QodGVhY2hlcl91bmV0LnN0YXRlX2RpY3QoKSUyQyUyMHN0cmljdCUzREZhbHNlKSUwQXVuZXQudHJhaW4oKQ==",highlighted:`teacher_unet = UNet2DConditionModel.from_pretrained(
    args.pretrained_teacher_model, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, revision=args.teacher_revision
)

unet = UNet2DConditionModel(**teacher_unet.config)
unet.load_state_dict(teacher_unet.state_dict(), strict=<span class="hljs-literal">False</span>)
unet.train()`,wrap:!1}}),P=new y({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NsYXNzKCUwQSUyMCUyMCUyMCUyMHVuZXQucGFyYW1ldGVycygpJTJDJTBBJTIwJTIwJTIwJTIwbHIlM0RhcmdzLmxlYXJuaW5nX3JhdGUlMkMlMEElMjAlMjAlMjAlMjBiZXRhcyUzRChhcmdzLmFkYW1fYmV0YTElMkMlMjBhcmdzLmFkYW1fYmV0YTIpJTJDJTBBJTIwJTIwJTIwJTIwd2VpZ2h0X2RlY2F5JTNEYXJncy5hZGFtX3dlaWdodF9kZWNheSUyQyUwQSUyMCUyMCUyMCUyMGVwcyUzRGFyZ3MuYWRhbV9lcHNpbG9uJTJDJTBBKQ==",highlighted:`optimizer = optimizer_class(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),O=new y({props:{code:"ZGF0YXNldCUyMCUzRCUyMFRleHQySW1hZ2VEYXRhc2V0KCUwQSUyMCUyMCUyMCUyMHRyYWluX3NoYXJkc19wYXRoX29yX3VybCUzRGFyZ3MudHJhaW5fc2hhcmRzX3BhdGhfb3JfdXJsJTJDJTBBJTIwJTIwJTIwJTIwbnVtX3RyYWluX2V4YW1wbGVzJTNEYXJncy5tYXhfdHJhaW5fc2FtcGxlcyUyQyUwQSUyMCUyMCUyMCUyMHBlcl9ncHVfYmF0Y2hfc2l6ZSUzRGFyZ3MudHJhaW5fYmF0Y2hfc2l6ZSUyQyUwQSUyMCUyMCUyMCUyMGdsb2JhbF9iYXRjaF9zaXplJTNEYXJncy50cmFpbl9iYXRjaF9zaXplJTIwKiUyMGFjY2VsZXJhdG9yLm51bV9wcm9jZXNzZXMlMkMlMEElMjAlMjAlMjAlMjBudW1fd29ya2VycyUzRGFyZ3MuZGF0YWxvYWRlcl9udW1fd29ya2VycyUyQyUwQSUyMCUyMCUyMCUyMHJlc29sdXRpb24lM0RhcmdzLnJlc29sdXRpb24lMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlX2J1ZmZlcl9zaXplJTNEMTAwMCUyQyUwQSUyMCUyMCUyMCUyMHBpbl9tZW1vcnklM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwcGVyc2lzdGVudF93b3JrZXJzJTNEVHJ1ZSUyQyUwQSklMEF0cmFpbl9kYXRhbG9hZGVyJTIwJTNEJTIwZGF0YXNldC50cmFpbl9kYXRhbG9hZGVy",highlighted:`dataset = Text2ImageDataset(
    train_shards_path_or_url=args.train_shards_path_or_url,
    num_train_examples=args.max_train_samples,
    per_gpu_batch_size=args.train_batch_size,
    global_batch_size=args.train_batch_size * accelerator.num_processes,
    num_workers=args.dataloader_num_workers,
    resolution=args.resolution,
    shuffle_buffer_size=<span class="hljs-number">1000</span>,
    pin_memory=<span class="hljs-literal">True</span>,
    persistent_workers=<span class="hljs-literal">True</span>,
)
train_dataloader = dataset.train_dataloader`,wrap:!1}}),te=new y({props:{code:"cHJlZF94XzAlMjAlM0QlMjBwcmVkaWN0ZWRfb3JpZ2luKCUwQSUyMCUyMCUyMCUyMG5vaXNlX3ByZWQlMkMlMEElMjAlMjAlMjAlMjBzdGFydF90aW1lc3RlcHMlMkMlMEElMjAlMjAlMjAlMjBub2lzeV9tb2RlbF9pbnB1dCUyQyUwQSUyMCUyMCUyMCUyMG5vaXNlX3NjaGVkdWxlci5jb25maWcucHJlZGljdGlvbl90eXBlJTJDJTBBJTIwJTIwJTIwJTIwYWxwaGFfc2NoZWR1bGUlMkMlMEElMjAlMjAlMjAlMjBzaWdtYV9zY2hlZHVsZSUyQyUwQSklMEElMEFtb2RlbF9wcmVkJTIwJTNEJTIwY19za2lwX3N0YXJ0JTIwKiUyMG5vaXN5X21vZGVsX2lucHV0JTIwJTJCJTIwY19vdXRfc3RhcnQlMjAqJTIwcHJlZF94XzA=",highlighted:`pred_x_0 = predicted_origin(
    noise_pred,
    start_timesteps,
    noisy_model_input,
    noise_scheduler.config.prediction_type,
    alpha_schedule,
    sigma_schedule,
)

model_pred = c_skip_start * noisy_model_input + c_out_start * pred_x_0`,wrap:!1}}),ae=new y({props:{code:"aWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmwyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMEYubXNlX2xvc3MobW9kZWxfcHJlZC5mbG9hdCgpJTJDJTIwdGFyZ2V0LmZsb2F0KCklMkMlMjByZWR1Y3Rpb24lM0QlMjJtZWFuJTIyKSUwQWVsaWYlMjBhcmdzLmxvc3NfdHlwZSUyMCUzRCUzRCUyMCUyMmh1YmVyJTIyJTNBJTBBJTIwJTIwJTIwJTIwbG9zcyUyMCUzRCUyMHRvcmNoLm1lYW4oJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guc3FydCgobW9kZWxfcHJlZC5mbG9hdCgpJTIwLSUyMHRhcmdldC5mbG9hdCgpKSUyMCoqJTIwMiUyMCUyQiUyMGFyZ3MuaHViZXJfYyoqMiklMjAtJTIwYXJncy5odWJlcl9jJTBBJTIwJTIwJTIwJTIwKQ==",highlighted:`<span class="hljs-keyword">if</span> args.loss_type == <span class="hljs-string">&quot;l2&quot;</span>:
    loss = F.mse_loss(model_pred.<span class="hljs-built_in">float</span>(), target.<span class="hljs-built_in">float</span>(), reduction=<span class="hljs-string">&quot;mean&quot;</span>)
<span class="hljs-keyword">elif</span> args.loss_type == <span class="hljs-string">&quot;huber&quot;</span>:
    loss = torch.mean(
        torch.sqrt((model_pred.<span class="hljs-built_in">float</span>() - target.<span class="hljs-built_in">float</span>()) ** <span class="hljs-number">2</span> + args.huber_c**<span class="hljs-number">2</span>) - args.huber_c
    )`,wrap:!1}}),ie=new Je({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),oe=new y({props:{code:"ZXhwb3J0JTIwTU9ERUxfRElSJTNEJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBZXhwb3J0JTIwT1VUUFVUX0RJUiUzRCUyMnBhdGglMkZ0byUyRnNhdmVkJTJGbW9kZWwlMjIlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwdHJhaW5fbGNtX2Rpc3RpbGxfc2Rfd2RzLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wcmV0cmFpbmVkX3RlYWNoZXJfbW9kZWwlM0QlMjRNT0RFTF9ESVIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW91dHB1dF9kaXIlM0QlMjRPVVRQVVRfRElSJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1taXhlZF9wcmVjaXNpb24lM0RmcDE2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNENTEyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNEMWUtNiUyMC0tbG9zc190eXBlJTNEJTIyaHViZXIlMjIlMjAtLWVtYV9kZWNheSUzRDAuOTUlMjAtLWFkYW1fd2VpZ2h0X2RlY2F5JTNEMC4wJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdHJhaW5fc3RlcHMlM0QxMDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXhfdHJhaW5fc2FtcGxlcyUzRDQwMDAwMDAlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFsb2FkZXJfbnVtX3dvcmtlcnMlM0Q4JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cmFpbl9zaGFyZHNfcGF0aF9vcl91cmwlM0QlMjJwaXBlJTNBY3VybCUyMC1MJTIwLXMlMjBodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZsYWlvbiUyRmNvbmNlcHR1YWwtY2FwdGlvbnMtMTJtLXdlYmRhdGFzZXQlMkZyZXNvbHZlJTJGbWFpbiUyRmRhdGElMkYlN0IwMDAwMC4uMDEwOTklN0QudGFyJTNGZG93bmxvYWQlM0R0cnVlJTIyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS12YWxpZGF0aW9uX3N0ZXBzJTNEMjAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNEMjAwJTIwLS1jaGVja3BvaW50c190b3RhbF9saW1pdCUzRDEwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cmFpbl9iYXRjaF9zaXplJTNEMTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAtLWVuYWJsZV94Zm9ybWVyc19tZW1vcnlfZWZmaWNpZW50X2F0dGVudGlvbiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdXNlXzhiaXRfYWRhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVzdW1lX2Zyb21fY2hlY2twb2ludCUzRGxhdGVzdCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tcmVwb3J0X3RvJTNEd2FuZGIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXNlZWQlM0Q0NTM2NDU2MzQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLXB1c2hfdG9faHVi",highlighted:`<span class="hljs-built_in">export</span> MODEL_DIR=<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
<span class="hljs-built_in">export</span> OUTPUT_DIR=<span class="hljs-string">&quot;path/to/saved/model&quot;</span>

accelerate launch train_lcm_distill_sd_wds.py \\
    --pretrained_teacher_model=<span class="hljs-variable">$MODEL_DIR</span> \\
    --output_dir=<span class="hljs-variable">$OUTPUT_DIR</span> \\
    --mixed_precision=fp16 \\
    --resolution=512 \\
    --learning_rate=1e-6 --loss_type=<span class="hljs-string">&quot;huber&quot;</span> --ema_decay=0.95 --adam_weight_decay=0.0 \\
    --max_train_steps=1000 \\
    --max_train_samples=4000000 \\
    --dataloader_num_workers=8 \\
    --train_shards_path_or_url=<span class="hljs-string">&quot;pipe:curl -L -s https://huggingface.co/datasets/laion/conceptual-captions-12m-webdataset/resolve/main/data/{00000..01099}.tar?download=true&quot;</span> \\
    --validation_steps=200 \\
    --checkpointing_steps=200 --checkpoints_total_limit=10 \\
    --train_batch_size=12 \\
    --gradient_checkpointing --enable_xformers_memory_efficient_attention \\
    --gradient_accumulation_steps=1 \\
    --use_8bit_adam \\
    --resume_from_checkpoint=latest \\
    --report_to=wandb \\
    --seed=453645634 \\
    --push_to_hub`,wrap:!1}}),ce=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTJDJTIwRGlmZnVzaW9uUGlwZWxpbmUlMkMlMjBMQ01TY2hlZHVsZXIlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXVuZXQlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyeW91ci11c2VybmFtZSUyRnlvdXItbW9kZWwlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1bmV0JTNEdW5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMExDTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjJzdXNoaSUyMHJvbGxzJTIwaW4lMjB0aGUlMjBmb3JtJTIwb2YlMjBwYW5kYSUyMGhlYWRzJTJDJTIwc3VzaGklMjBwbGF0dGVyJTIyJTBBJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNENCUyQyUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel, DiffusionPipeline, LCMScheduler
<span class="hljs-keyword">import</span> torch

unet = UNet2DConditionModel.from_pretrained(<span class="hljs-string">&quot;your-username/your-model&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, unet=unet, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

pipeline.scheduler = LCMScheduler.from_config(pipe.scheduler.config)
pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;sushi rolls in the form of panda heads, sushi platter&quot;</span>

image = pipeline(prompt, num_inference_steps=<span class="hljs-number">4</span>, guidance_scale=<span class="hljs-number">1.0</span>).images[<span class="hljs-number">0</span>]`,wrap:!1}}),de=new Je({props:{title:"LoRA",local:"lora",headingTag:"h2"}}),ue=new Je({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),ye=new Je({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Te=new ul({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/lcm_distill.md"}}),{c(){p=n("meta"),w=s(),h=n("p"),b=s(),c(g.$$.fragment),Ue=s(),_=n("p"),_.innerHTML=Ct,je=s(),U=n("p"),U.innerHTML=$t,Ce=s(),j=n("p"),j.innerHTML=Zt,$e=s(),C=n("p"),C.textContent=It,Ze=s(),c($.$$.fragment),Ie=s(),Z=n("p"),Z.textContent=Wt,We=s(),c(I.$$.fragment),Re=s(),c(T.$$.fragment),xe=s(),W=n("p"),W.innerHTML=Rt,Xe=s(),c(R.$$.fragment),ve=s(),x=n("p"),x.textContent=xt,Ge=s(),c(X.$$.fragment),Ne=s(),v=n("p"),v.textContent=Xt,Le=s(),c(G.$$.fragment),ke=s(),N=n("p"),N.innerHTML=vt,Ve=s(),c(L.$$.fragment),Be=s(),c(J.$$.fragment),He=s(),k=n("p"),k.innerHTML=Gt,Qe=s(),V=n("p"),V.innerHTML=Nt,Fe=s(),c(B.$$.fragment),Ye=s(),H=n("p"),H.innerHTML=Lt,Se=s(),Q=n("ul"),Q.innerHTML=kt,ze=s(),c(F.$$.fragment),Ae=s(),Y=n("p"),Y.innerHTML=Vt,Ee=s(),c(S.$$.fragment),De=s(),z=n("p"),z.innerHTML=Bt,qe=s(),c(A.$$.fragment),Pe=s(),E=n("p"),E.innerHTML=Ht,Ke=s(),c(D.$$.fragment),Oe=s(),q=n("p"),q.innerHTML=Qt,et=s(),c(P.$$.fragment),tt=s(),K=n("p"),K.innerHTML=Ft,lt=s(),c(O.$$.fragment),at=s(),ee=n("p"),ee.innerHTML=Yt,st=s(),c(te.$$.fragment),it=s(),le=n("p"),le.innerHTML=St,nt=s(),c(ae.$$.fragment),rt=s(),se=n("p"),se.innerHTML=zt,ot=s(),c(ie.$$.fragment),pt=s(),ne=n("p"),ne.textContent=At,ct=s(),re=n("p"),re.innerHTML=Et,dt=s(),c(oe.$$.fragment),mt=s(),pe=n("p"),pe.textContent=Dt,ft=s(),c(ce.$$.fragment),ut=s(),c(de.$$.fragment),Mt=s(),me=n("p"),me.innerHTML=qt,ht=s(),fe=n("p"),fe.innerHTML=Pt,yt=s(),c(ue.$$.fragment),wt=s(),Me=n("p"),Me.innerHTML=Kt,bt=s(),he=n("p"),he.innerHTML=Ot,Tt=s(),c(ye.$$.fragment),Jt=s(),we=n("p"),we.textContent=el,gt=s(),be=n("ul"),be.innerHTML=tl,_t=s(),c(Te.$$.fragment),Ut=s(),_e=n("p"),this.h()},l(e){const t=ml("svelte-u9bgzb",document.head);p=r(t,"META",{name:!0,content:!0}),t.forEach(l),w=i(e),h=r(e,"P",{}),sl(h).forEach(l),b=i(e),d(g.$$.fragment,e),Ue=i(e),_=r(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1oefohu"&&(_.innerHTML=Ct),je=i(e),U=r(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-w1dbtu"&&(U.innerHTML=$t),Ce=i(e),j=r(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-1izwzxl"&&(j.innerHTML=Zt),$e=i(e),C=r(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-l7dm2q"&&(C.textContent=It),Ze=i(e),d($.$$.fragment,e),Ie=i(e),Z=r(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-z4z0b9"&&(Z.textContent=Wt),We=i(e),d(I.$$.fragment,e),Re=i(e),d(T.$$.fragment,e),xe=i(e),W=r(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-h7f7kz"&&(W.innerHTML=Rt),Xe=i(e),d(R.$$.fragment,e),ve=i(e),x=r(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-di6juu"&&(x.textContent=xt),Ge=i(e),d(X.$$.fragment,e),Ne=i(e),v=r(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-tsz4qp"&&(v.textContent=Xt),Le=i(e),d(G.$$.fragment,e),ke=i(e),N=r(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-1fkfdql"&&(N.innerHTML=vt),Ve=i(e),d(L.$$.fragment,e),Be=i(e),d(J.$$.fragment,e),He=i(e),k=r(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-z8r4ny"&&(k.innerHTML=Gt),Qe=i(e),V=r(e,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1r0bv1x"&&(V.innerHTML=Nt),Fe=i(e),d(B.$$.fragment,e),Ye=i(e),H=r(e,"P",{"data-svelte-h":!0}),o(H)!=="svelte-opb00x"&&(H.innerHTML=Lt),Se=i(e),Q=r(e,"UL",{"data-svelte-h":!0}),o(Q)!=="svelte-q5d022"&&(Q.innerHTML=kt),ze=i(e),d(F.$$.fragment,e),Ae=i(e),Y=r(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-xygc62"&&(Y.innerHTML=Vt),Ee=i(e),d(S.$$.fragment,e),De=i(e),z=r(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1fe8qlp"&&(z.innerHTML=Bt),qe=i(e),d(A.$$.fragment,e),Pe=i(e),E=r(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-184frii"&&(E.innerHTML=Ht),Ke=i(e),d(D.$$.fragment,e),Oe=i(e),q=r(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-he12t1"&&(q.innerHTML=Qt),et=i(e),d(P.$$.fragment,e),tt=i(e),K=r(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-1c3frfx"&&(K.innerHTML=Ft),lt=i(e),d(O.$$.fragment,e),at=i(e),ee=r(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-4kbgth"&&(ee.innerHTML=Yt),st=i(e),d(te.$$.fragment,e),it=i(e),le=r(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-1g18b9r"&&(le.innerHTML=St),nt=i(e),d(ae.$$.fragment,e),rt=i(e),se=r(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-1pefyrm"&&(se.innerHTML=zt),ot=i(e),d(ie.$$.fragment,e),pt=i(e),ne=r(e,"P",{"data-svelte-h":!0}),o(ne)!=="svelte-5c8ldp"&&(ne.textContent=At),ct=i(e),re=r(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-14rdptq"&&(re.innerHTML=Et),dt=i(e),d(oe.$$.fragment,e),mt=i(e),pe=r(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-2n690z"&&(pe.textContent=Dt),ft=i(e),d(ce.$$.fragment,e),ut=i(e),d(de.$$.fragment,e),Mt=i(e),me=r(e,"P",{"data-svelte-h":!0}),o(me)!=="svelte-21u499"&&(me.innerHTML=qt),ht=i(e),fe=r(e,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1sxi0tl"&&(fe.innerHTML=Pt),yt=i(e),d(ue.$$.fragment,e),wt=i(e),Me=r(e,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-swritx"&&(Me.innerHTML=Kt),bt=i(e),he=r(e,"P",{"data-svelte-h":!0}),o(he)!=="svelte-6dxtva"&&(he.innerHTML=Ot),Tt=i(e),d(ye.$$.fragment,e),Jt=i(e),we=r(e,"P",{"data-svelte-h":!0}),o(we)!=="svelte-1bflftn"&&(we.textContent=el),gt=i(e),be=r(e,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-e624yw"&&(be.innerHTML=tl),_t=i(e),d(Te.$$.fragment,e),Ut=i(e),_e=r(e,"P",{}),sl(_e).forEach(l),this.h()},h(){il(p,"name","hf:doc:metadata"),il(p,"content",wl)},m(e,t){fl(document.head,p),a(e,w,t),a(e,h,t),a(e,b,t),m(g,e,t),a(e,Ue,t),a(e,_,t),a(e,je,t),a(e,U,t),a(e,Ce,t),a(e,j,t),a(e,$e,t),a(e,C,t),a(e,Ze,t),m($,e,t),a(e,Ie,t),a(e,Z,t),a(e,We,t),m(I,e,t),a(e,Re,t),m(T,e,t),a(e,xe,t),a(e,W,t),a(e,Xe,t),m(R,e,t),a(e,ve,t),a(e,x,t),a(e,Ge,t),m(X,e,t),a(e,Ne,t),a(e,v,t),a(e,Le,t),m(G,e,t),a(e,ke,t),a(e,N,t),a(e,Ve,t),m(L,e,t),a(e,Be,t),m(J,e,t),a(e,He,t),a(e,k,t),a(e,Qe,t),a(e,V,t),a(e,Fe,t),m(B,e,t),a(e,Ye,t),a(e,H,t),a(e,Se,t),a(e,Q,t),a(e,ze,t),m(F,e,t),a(e,Ae,t),a(e,Y,t),a(e,Ee,t),m(S,e,t),a(e,De,t),a(e,z,t),a(e,qe,t),m(A,e,t),a(e,Pe,t),a(e,E,t),a(e,Ke,t),m(D,e,t),a(e,Oe,t),a(e,q,t),a(e,et,t),m(P,e,t),a(e,tt,t),a(e,K,t),a(e,lt,t),m(O,e,t),a(e,at,t),a(e,ee,t),a(e,st,t),m(te,e,t),a(e,it,t),a(e,le,t),a(e,nt,t),m(ae,e,t),a(e,rt,t),a(e,se,t),a(e,ot,t),m(ie,e,t),a(e,pt,t),a(e,ne,t),a(e,ct,t),a(e,re,t),a(e,dt,t),m(oe,e,t),a(e,mt,t),a(e,pe,t),a(e,ft,t),m(ce,e,t),a(e,ut,t),m(de,e,t),a(e,Mt,t),a(e,me,t),a(e,ht,t),a(e,fe,t),a(e,yt,t),m(ue,e,t),a(e,wt,t),a(e,Me,t),a(e,bt,t),a(e,he,t),a(e,Tt,t),m(ye,e,t),a(e,Jt,t),a(e,we,t),a(e,gt,t),a(e,be,t),a(e,_t,t),m(Te,e,t),a(e,Ut,t),a(e,_e,t),jt=!0},p(e,[t]){const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),T.$set(ll);const al={};t&2&&(al.$$scope={dirty:t,ctx:e}),J.$set(al)},i(e){jt||(f(g.$$.fragment,e),f($.$$.fragment,e),f(I.$$.fragment,e),f(T.$$.fragment,e),f(R.$$.fragment,e),f(X.$$.fragment,e),f(G.$$.fragment,e),f(L.$$.fragment,e),f(J.$$.fragment,e),f(B.$$.fragment,e),f(F.$$.fragment,e),f(S.$$.fragment,e),f(A.$$.fragment,e),f(D.$$.fragment,e),f(P.$$.fragment,e),f(O.$$.fragment,e),f(te.$$.fragment,e),f(ae.$$.fragment,e),f(ie.$$.fragment,e),f(oe.$$.fragment,e),f(ce.$$.fragment,e),f(de.$$.fragment,e),f(ue.$$.fragment,e),f(ye.$$.fragment,e),f(Te.$$.fragment,e),jt=!0)},o(e){u(g.$$.fragment,e),u($.$$.fragment,e),u(I.$$.fragment,e),u(T.$$.fragment,e),u(R.$$.fragment,e),u(X.$$.fragment,e),u(G.$$.fragment,e),u(L.$$.fragment,e),u(J.$$.fragment,e),u(B.$$.fragment,e),u(F.$$.fragment,e),u(S.$$.fragment,e),u(A.$$.fragment,e),u(D.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(oe.$$.fragment,e),u(ce.$$.fragment,e),u(de.$$.fragment,e),u(ue.$$.fragment,e),u(ye.$$.fragment,e),u(Te.$$.fragment,e),jt=!1},d(e){e&&(l(w),l(h),l(b),l(Ue),l(_),l(je),l(U),l(Ce),l(j),l($e),l(C),l(Ze),l(Ie),l(Z),l(We),l(Re),l(xe),l(W),l(Xe),l(ve),l(x),l(Ge),l(Ne),l(v),l(Le),l(ke),l(N),l(Ve),l(Be),l(He),l(k),l(Qe),l(V),l(Fe),l(Ye),l(H),l(Se),l(Q),l(ze),l(Ae),l(Y),l(Ee),l(De),l(z),l(qe),l(Pe),l(E),l(Ke),l(Oe),l(q),l(et),l(tt),l(K),l(lt),l(at),l(ee),l(st),l(it),l(le),l(nt),l(rt),l(se),l(ot),l(pt),l(ne),l(ct),l(re),l(dt),l(mt),l(pe),l(ft),l(ut),l(Mt),l(me),l(ht),l(fe),l(yt),l(wt),l(Me),l(bt),l(he),l(Tt),l(Jt),l(we),l(gt),l(be),l(_t),l(Ut),l(_e)),l(p),M(g,e),M($,e),M(I,e),M(T,e),M(R,e),M(X,e),M(G,e),M(L,e),M(J,e),M(B,e),M(F,e),M(S,e),M(A,e),M(D,e),M(P,e),M(O,e),M(te,e),M(ae,e),M(ie,e),M(oe,e),M(ce,e),M(de,e),M(ue,e),M(ye,e),M(Te,e)}}}const wl='{"title":"Latent Consistency Distillation","local":"latent-consistency-distillation","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"LoRA","local":"lora","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function bl(ge){return pl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class jl extends cl{constructor(p){super(),dl(this,p,bl,yl,ol,{})}}export{jl as component};
