import{s as Te,o as fe,n as ie}from"../chunks/scheduler.8c3d61f6.js";import{S as we,i as Ue,g as b,s as M,r as j,A as je,h as T,f as t,c as d,j as ge,u as Z,x as U,k as be,l as w,y as Ze,a,v as C,d as W,t as I,w as G}from"../chunks/index.da70eac4.js";import{T as Ce}from"../chunks/Tip.1d9b8c37.js";import{C as _}from"../chunks/CodeBlock.a9c4becf.js";import{H as oe,E as We}from"../chunks/getInferenceSnippets.c28dea0b.js";import{H as Ie,a as pe}from"../chunks/HfOption.6ab18950.js";function Ge(R){let n,f='ControlNets are available to many models such as <a href="../api/pipelines/controlnet_flux">Flux</a>, <a href="../api/pipelines/controlnet_hunyuandit">Hunyuan-DiT</a>, <a href="../api/pipelines/controlnet_sd3">Stable Diffusion 3</a>, and more. The examples in this guide use Flux and Stable Diffusion XL.';return{c(){n=b("p"),n.innerHTML=f},l(m){n=T(m,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1ybagwx"&&(n.innerHTML=f)},m(m,r){a(m,n,r)},p:ie,d(m){m&&t(n)}}}function Be(R){let n,f='Generate a canny image with <a href="https://github.com/opencv/opencv-python" rel="nofollow">opencv-python</a>.',m,r,y,c,i="Pass the canny image to the pipeline. Use the <code>controlnet_conditioning_scale</code> parameter to determine how much weight to assign to the control.",J,u,h,o,B='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat-generated.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',g;return r=new _({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEElMEFvcmlnaW5hbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGZGlmZnVzZXJzJTJGbm9uLWVuaGFuY2VkLXByb21wdC5wbmclMjIlMEEpJTBBJTBBaW1hZ2UlMjAlM0QlMjBucC5hcnJheShvcmlnaW5hbF9pbWFnZSklMEElMEFsb3dfdGhyZXNob2xkJTIwJTNEJTIwMTAwJTBBaGlnaF90aHJlc2hvbGQlMjAlM0QlMjAyMDAlMEElMEFpbWFnZSUyMCUzRCUyMGN2Mi5DYW5ueShpbWFnZSUyQyUyMGxvd190aHJlc2hvbGQlMkMlMjBoaWdoX3RocmVzaG9sZCklMEFpbWFnZSUyMCUzRCUyMGltYWdlJTVCJTNBJTJDJTIwJTNBJTJDJTIwTm9uZSU1RCUwQWltYWdlJTIwJTNEJTIwbnAuY29uY2F0ZW5hdGUoJTVCaW1hZ2UlMkMlMjBpbWFnZSUyQyUyMGltYWdlJTVEJTJDJTIwYXhpcyUzRDIpJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBJbWFnZS5mcm9tYXJyYXkoaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

original_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
)

image = np.array(original_image)

low_threshold = <span class="hljs-number">100</span>
high_threshold = <span class="hljs-number">200</span>

image = cv2.Canny(image, low_threshold, high_threshold)
image = image[:, :, <span class="hljs-literal">None</span>]
image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
canny_image = Image.fromarray(image)`,wrap:!1}}),u=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBGbHV4Q29udHJvbE5ldFBpcGVsaW5lJTJDJTIwRmx1eENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBGbHV4Q29udHJvbE5ldE1vZGVsLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJJbnN0YW50WCUyRkZMVVguMS1kZXYtQ29udHJvbG5ldC1DYW5ueSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBGbHV4Q29udHJvbE5ldFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJibGFjay1mb3Jlc3QtbGFicyUyRkZMVVguMS1kZXYlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyJTIyJTIyJTBBQSUyMHBob3RvcmVhbGlzdGljJTIwb3ZlcmhlYWQlMjBpbWFnZSUyMG9mJTIwYSUyMGNhdCUyMHJlY2xpbmluZyUyMHNpZGV3YXlzJTIwaW4lMjBhJTIwZmxhbWluZ28lMjBwb29sJTIwZmxvYXRpZSUyMGhvbGRpbmclMjBhJTIwbWFyZ2FyaXRhLiUyMCUwQVRoZSUyMGNhdCUyMGlzJTIwZmxvYXRpbmclMjBsZWlzdXJlbHklMjBpbiUyMHRoZSUyMHBvb2wlMjBhbmQlMjBjb21wbGV0ZWx5JTIwcmVsYXhlZCUyMGFuZCUyMGhhcHB5LiUwQSUyMiUyMiUyMiUwQSUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUyMCUwQSUyMCUyMCUyMCUyMGNvbnRyb2xfaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTNEMC41JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwJTBBJTIwJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0QzLjUlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FluxControlNetPipeline, FluxControlNetModel

controlnet = FluxControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;InstantX/FLUX.1-dev-Controlnet-Canny&quot;</span>, torch_dtype=torch.bfloat16
)
pipeline = FluxControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;black-forest-labs/FLUX.1-dev&quot;</span>, controlnet=controlnet, torch_dtype=torch.bfloat16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
A photorealistic overhead image of a cat reclining sideways in a flamingo pool floatie holding a margarita. 
The cat is floating leisurely in the pool and completely relaxed and happy.
&quot;&quot;&quot;</span>

pipeline(
    prompt, 
    control_image=canny_image,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    num_inference_steps=<span class="hljs-number">50</span>, 
    guidance_scale=<span class="hljs-number">3.5</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=b("p"),n.innerHTML=f,m=M(),j(r.$$.fragment),y=M(),c=b("p"),c.innerHTML=i,J=M(),j(u.$$.fragment),h=M(),o=b("div"),o.innerHTML=B,this.h()},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-odtmr5"&&(n.innerHTML=f),m=d(l),Z(r.$$.fragment,l),y=d(l),c=T(l,"P",{"data-svelte-h":!0}),U(c)!=="svelte-zjofbt"&&(c.innerHTML=i),J=d(l),Z(u.$$.fragment,l),h=d(l),o=T(l,"DIV",{style:!0,"data-svelte-h":!0}),U(o)!=="svelte-y2w2wd"&&(o.innerHTML=B),this.h()},h(){w(o,"display","flex"),w(o,"gap","10px"),w(o,"justify-content","space-around"),w(o,"align-items","flex-end")},m(l,p){a(l,n,p),a(l,m,p),C(r,l,p),a(l,y,p),a(l,c,p),a(l,J,p),C(u,l,p),a(l,h,p),a(l,o,p),g=!0},p:ie,i(l){g||(W(r.$$.fragment,l),W(u.$$.fragment,l),g=!0)},o(l){I(r.$$.fragment,l),I(u.$$.fragment,l),g=!1},d(l){l&&(t(n),t(m),t(y),t(c),t(J),t(h),t(o)),G(r,l),G(u,l)}}}function Re(R){let n,f="Generate a depth map with a depth estimation pipeline from Transformers.",m,r,y,c,i="Pass the depth map to the pipeline. Use the <code>controlnet_conditioning_scale</code> parameter to determine how much weight to assign to the control.",J,u,h,o,B='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_depth_image.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">depth map</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_depth_cat.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',g;return r=new _({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DPTImageProcessor, DPTForDepthEstimation
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ControlNetModel, StableDiffusionXLControlNetImg2ImgPipeline, AutoencoderKL
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image


depth_estimator = DPTForDepthEstimation.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
feature_extractor = DPTImageProcessor.from_pretrained(<span class="hljs-string">&quot;Intel/dpt-hybrid-midas&quot;</span>)

<span class="hljs-keyword">def</span> <span class="hljs-title function_">get_depth_map</span>(<span class="hljs-params">image</span>):
    image = feature_extractor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values.to(<span class="hljs-string">&quot;cuda&quot;</span>)
    <span class="hljs-keyword">with</span> torch.no_grad(), torch.autocast(<span class="hljs-string">&quot;cuda&quot;</span>):
        depth_map = depth_estimator(image).predicted_depth

    depth_map = torch.nn.functional.interpolate(
        depth_map.unsqueeze(<span class="hljs-number">1</span>),
        size=(<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>),
        mode=<span class="hljs-string">&quot;bicubic&quot;</span>,
        align_corners=<span class="hljs-literal">False</span>,
    )
    depth_min = torch.amin(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
    depth_max = torch.amax(depth_map, dim=[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>], keepdim=<span class="hljs-literal">True</span>)
    depth_map = (depth_map - depth_min) / (depth_max - depth_min)
    image = torch.cat([depth_map] * <span class="hljs-number">3</span>, dim=<span class="hljs-number">1</span>)
    image = image.permute(<span class="hljs-number">0</span>, <span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">1</span>).cpu().numpy()[<span class="hljs-number">0</span>]
    image = Image.fromarray((image * <span class="hljs-number">255.0</span>).clip(<span class="hljs-number">0</span>, <span class="hljs-number">255</span>).astype(np.uint8))
    <span class="hljs-keyword">return</span> image

depth_image = get_depth_map(image)`,wrap:!1}}),u=new _({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1kZXB0aC1zZHhsLTEuMC1zbWFsbCUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSklMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uWExDb250cm9sTmV0SW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUwQSUyMCUyMCUyMCUyMHZhZSUzRHZhZSUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSkudG8oJTIyY3VkYSUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlMjIlMjIlMEFBJTIwcGhvdG9yZWFsaXN0aWMlMjBvdmVyaGVhZCUyMGltYWdlJTIwb2YlMjBhJTIwY2F0JTIwcmVjbGluaW5nJTIwc2lkZXdheXMlMjBpbiUyMGElMjBmbGFtaW5nbyUyMHBvb2wlMjBmbG9hdGllJTIwaG9sZGluZyUyMGElMjBtYXJnYXJpdGEuJTIwJTBBVGhlJTIwY2F0JTIwaXMlMjBmbG9hdGluZyUyMGxlaXN1cmVseSUyMGluJTIwdGhlJTIwcG9vbCUyMGFuZCUyMGNvbXBsZXRlbHklMjByZWxheGVkJTIwYW5kJTIwaGFwcHkuJTBBJTIyJTIyJTIyJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUwQSUyMCUyMCUyMCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRm5vbi1lbmhhbmNlZC1wcm9tcHQucG5nJTIyJTBBKS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEFjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUyMCUzRCUyMDAuNSUyMCUwQXBpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sX2ltYWdlJTNEZGVwdGhfaW1hZ2UlMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRGNvbnRyb2xuZXRfY29uZGl0aW9uaW5nX3NjYWxlJTJDJTBBJTIwJTIwJTIwJTIwc3RyZW5ndGglM0QwLjk5JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwMCUyQyUwQSkuaW1hZ2VzJTVCMCU1RA==",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>,
    torch_dtype=torch.float16,
)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLControlNetImg2ImgPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
    controlnet=controlnet,
    vae=vae,
    torch_dtype=torch.float16,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
A photorealistic overhead image of a cat reclining sideways in a flamingo pool floatie holding a margarita. 
The cat is floating leisurely in the pool and completely relaxed and happy.
&quot;&quot;&quot;</span>
image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
).resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
controlnet_conditioning_scale = <span class="hljs-number">0.5</span> 
pipeline(
    prompt,
    image=image,
    control_image=depth_image,
    controlnet_conditioning_scale=controlnet_conditioning_scale,
    strength=<span class="hljs-number">0.99</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=f,m=M(),j(r.$$.fragment),y=M(),c=b("p"),c.innerHTML=i,J=M(),j(u.$$.fragment),h=M(),o=b("div"),o.innerHTML=B,this.h()},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1gx6o1u"&&(n.textContent=f),m=d(l),Z(r.$$.fragment,l),y=d(l),c=T(l,"P",{"data-svelte-h":!0}),U(c)!=="svelte-19jdy5i"&&(c.innerHTML=i),J=d(l),Z(u.$$.fragment,l),h=d(l),o=T(l,"DIV",{style:!0,"data-svelte-h":!0}),U(o)!=="svelte-1ac87db"&&(o.innerHTML=B),this.h()},h(){w(o,"display","flex"),w(o,"gap","10px"),w(o,"justify-content","space-around"),w(o,"align-items","flex-end")},m(l,p){a(l,n,p),a(l,m,p),C(r,l,p),a(l,y,p),a(l,c,p),a(l,J,p),C(u,l,p),a(l,h,p),a(l,o,p),g=!0},p:ie,i(l){g||(W(r.$$.fragment,l),W(u.$$.fragment,l),g=!0)},o(l){I(r.$$.fragment,l),I(u.$$.fragment,l),g=!1},d(l){l&&(t(n),t(m),t(y),t(c),t(J),t(h),t(o)),G(r,l),G(u,l)}}}function ke(R){let n,f="Generate a mask image and convert it to a tensor to mark the pixels in the original image as masked if the corresponding pixel in the mask image is over a certain threshold.",m,r,y,c,i="Pass the mask and control image to the pipeline. Use the <code>controlnet_conditioning_scale</code> parameter to determine how much weight to assign to the control.",J,u,h,o,B='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">original image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat_mask.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">mask image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_rabbit_inpaint.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',g;return r=new _({props:{code:"aW1wb3J0JTIwY3YyJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFmcm9tJTIwUElMJTIwaW1wb3J0JTIwSW1hZ2UlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRJbnBhaW50UGlwZWxpbmUlMkMlMjBDb250cm9sTmV0TW9kZWwlMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZub24tZW5oYW5jZWQtcHJvbXB0LnBuZyUyMiUwQSklMEFpbml0X2ltYWdlJTIwJTNEJTIwaW5pdF9pbWFnZS5yZXNpemUoKDEwMjQlMkMlMjAxMDI0KSklMEFtYXNrX2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMEElMjAlMjAlMjAlMjAlMjIlMkZjb250ZW50JTJGY2F0X21hc2sucG5nJTIyJTBBKSUwQW1hc2tfaW1hZ2UlMjAlM0QlMjBtYXNrX2ltYWdlLnJlc2l6ZSgoMTAyNCUyQyUyMDEwMjQpKSUwQSUwQWRlZiUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGltYWdlKSUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwbnAuYXJyYXkoaW1hZ2UpJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBjdjIuQ2FubnkoaW1hZ2UlMkMlMjAxMDAlMkMlMjAyMDApJTBBJTIwJTIwJTIwJTIwaW1hZ2UlMjAlM0QlMjBpbWFnZSU1QiUzQSUyQyUyMCUzQSUyQyUyME5vbmUlNUQlMEElMjAlMjAlMjAlMjBpbWFnZSUyMCUzRCUyMG5wLmNvbmNhdGVuYXRlKCU1QmltYWdlJTJDJTIwaW1hZ2UlMkMlMjBpbWFnZSU1RCUyQyUyMGF4aXMlM0QyKSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwSW1hZ2UuZnJvbWFycmF5KGltYWdlKSUwQSUyMCUyMCUyMCUyMHJldHVybiUyMGltYWdlJTBBJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMG1ha2VfY2FubnlfY29uZGl0aW9uKGluaXRfaW1hZ2Up",highlighted:`<span class="hljs-keyword">import</span> cv2
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetInpaintPipeline, ControlNetModel

init_image = load_image(
    <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/non-enhanced-prompt.png&quot;</span>
)
init_image = init_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))
mask_image = load_image(
    <span class="hljs-string">&quot;/content/cat_mask.png&quot;</span>
)
mask_image = mask_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))

<span class="hljs-keyword">def</span> <span class="hljs-title function_">make_canny_condition</span>(<span class="hljs-params">image</span>):
    image = np.array(image)
    image = cv2.Canny(image, <span class="hljs-number">100</span>, <span class="hljs-number">200</span>)
    image = image[:, :, <span class="hljs-literal">None</span>]
    image = np.concatenate([image, image, image], axis=<span class="hljs-number">2</span>)
    image = Image.fromarray(image)
    <span class="hljs-keyword">return</span> image

control_image = make_canny_condition(init_image)`,wrap:!1}}),u=new _({props:{code:"Y29udHJvbG5ldCUyMCUzRCUyMENvbnRyb2xOZXRNb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTJGY29udHJvbG5ldC1jYW5ueS1zZHhsLTEuMCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMQ29udHJvbE5ldElucGFpbnRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIyYSUyMGN1dGUlMjBhbmQlMjBmbHVmZnklMjBidW5ueSUyMHJhYmJpdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxMDAlMkMlMEElMjAlMjAlMjAlMjBzdHJlbmd0aCUzRDAuOTklMkMlMEElMjAlMjAlMjAlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNSUyQyUwQSUyMCUyMCUyMCUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG1hc2tfaW1hZ2UlM0RtYXNrX2ltYWdlJTJDJTBBJTIwJTIwJTIwJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMEEpLmltYWdlcyU1QjAlNUQ=",highlighted:`controlnet = ControlNetModel.from_pretrained(
    <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLControlNetInpaintPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
)
pipeline(
    <span class="hljs-string">&quot;a cute and fluffy bunny rabbit&quot;</span>,
    num_inference_steps=<span class="hljs-number">100</span>,
    strength=<span class="hljs-number">0.99</span>,
    controlnet_conditioning_scale=<span class="hljs-number">0.5</span>,
    image=init_image,
    mask_image=mask_image,
    control_image=control_image,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){n=b("p"),n.textContent=f,m=M(),j(r.$$.fragment),y=M(),c=b("p"),c.innerHTML=i,J=M(),j(u.$$.fragment),h=M(),o=b("div"),o.innerHTML=B,this.h()},l(l){n=T(l,"P",{"data-svelte-h":!0}),U(n)!=="svelte-1y2qw8o"&&(n.textContent=f),m=d(l),Z(r.$$.fragment,l),y=d(l),c=T(l,"P",{"data-svelte-h":!0}),U(c)!=="svelte-24u084"&&(c.innerHTML=i),J=d(l),Z(u.$$.fragment,l),h=d(l),o=T(l,"DIV",{style:!0,"data-svelte-h":!0}),U(o)!=="svelte-ggobk5"&&(o.innerHTML=B),this.h()},h(){w(o,"display","flex"),w(o,"gap","10px"),w(o,"justify-content","space-around"),w(o,"align-items","flex-end")},m(l,p){a(l,n,p),a(l,m,p),C(r,l,p),a(l,y,p),a(l,c,p),a(l,J,p),C(u,l,p),a(l,h,p),a(l,o,p),g=!0},p:ie,i(l){g||(W(r.$$.fragment,l),W(u.$$.fragment,l),g=!0)},o(l){I(r.$$.fragment,l),I(u.$$.fragment,l),g=!1},d(l){l&&(t(n),t(m),t(y),t(c),t(J),t(h),t(o)),G(r,l),G(u,l)}}}function ve(R){let n,f,m,r,y,c;return n=new pe({props:{id:"usage",option:"text-to-image",$$slots:{default:[Be]},$$scope:{ctx:R}}}),m=new pe({props:{id:"usage",option:"image-to-image",$$slots:{default:[Re]},$$scope:{ctx:R}}}),y=new pe({props:{id:"usage",option:"inpainting",$$slots:{default:[ke]},$$scope:{ctx:R}}}),{c(){j(n.$$.fragment),f=M(),j(m.$$.fragment),r=M(),j(y.$$.fragment)},l(i){Z(n.$$.fragment,i),f=d(i),Z(m.$$.fragment,i),r=d(i),Z(y.$$.fragment,i)},m(i,J){C(n,i,J),a(i,f,J),C(m,i,J),a(i,r,J),C(y,i,J),c=!0},p(i,J){const u={};J&2&&(u.$$scope={dirty:J,ctx:i}),n.$set(u);const h={};J&2&&(h.$$scope={dirty:J,ctx:i}),m.$set(h);const o={};J&2&&(o.$$scope={dirty:J,ctx:i}),y.$set(o)},i(i){c||(W(n.$$.fragment,i),W(m.$$.fragment,i),W(y.$$.fragment,i),c=!0)},o(i){I(n.$$.fragment,i),I(m.$$.fragment,i),I(y.$$.fragment,i),c=!1},d(i){i&&(t(f),t(r)),G(n,i),G(m,i),G(y,i)}}}function Xe(R){let n,f,m,r,y,c,i,J='<a href="https://huggingface.co/papers/2302.05543" rel="nofollow">ControlNet</a> is an adapter that enables controllable generation such as generating an image of a cat in a <em>specific pose</em> or following the lines in a sketch of a <em>specific</em> cat. It works by adding a smaller network of “zero convolution” layers and progressively training these to avoid disrupting with the original model. The original model parameters are frozen to avoid retraining it.',u,h,o="A ControlNet is conditioned on extra visual information or “structural controls” (canny edge, depth maps, human pose, etc.) that can be combined with text prompts to generate images that are guided by the visual input.",B,g,l,p,me='Load a ControlNet conditioned on a specific control, such as canny edge, and pass it to the pipeline in <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',A,X,z,N,D,Y,re="You can compose multiple ControlNet conditionings, such as canny image and a depth map, to create a <em>MultiControlNet</em>. For the best rersults, you should mask conditionings so they don’t overlap and experiment with different <code>controlnet_conditioning_scale</code> parameters to adjust how much weight is assigned to each control input.",L,x,ce="The example below composes a canny image and depth map.",q,Q,Me="Pass the ControlNets as a list to the pipeline and resize the images to the expected input size.",K,E,P,k,de='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Generated image (prompt only)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/multicontrolnet_depth.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">depth map</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/sdxl_multi_controlnet.png" width="300" alt="Generated image (ControlNet + prompt)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',O,F,ee,V,ye='<a href="https://github.com/lllyasviel/ControlNet/discussions/188" rel="nofollow">Guess mode</a> generates an image from <strong>only</strong> the control input (canny edge, depth map, pose, etc.) and without guidance from a prompt. It adjusts the scale of the ControlNet’s output residuals by a fixed ratio depending on block depth. The earlier <code>DownBlock</code> is only scaled by <code>0.1</code> and the <code>MidBlock</code> is fully scaled by <code>1.0</code>.',le,S,te,v,ue='<figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png" width="300" alt="Control image (Canny edges)"/> <figcaption style="text-align: center;">canny image</figcaption></figure> <figure><img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/guess_mode.png" width="300" alt="Generated image (Guess mode)"/> <figcaption style="text-align: center;">generated image</figcaption></figure>',ae,$,ne,H,se;return y=new oe({props:{title:"ControlNet",local:"controlnet",headingTag:"h1"}}),g=new Ce({props:{warning:!1,$$slots:{default:[Ge]},$$scope:{ctx:R}}}),X=new Ie({props:{id:"usage",options:["text-to-image","image-to-image","inpainting"],$$slots:{default:[ve]},$$scope:{ctx:R}}}),N=new oe({props:{title:"Multi-ControlNet",local:"multi-controlnet",headingTag:"h2"}}),E=new _({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel, AutoencoderKL

controlnets = [
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-depth-sdxl-1.0-small&quot;</span>, torch_dtype=torch.float16
    ),
    ControlNetModel.from_pretrained(
        <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16,
    ),
]

vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16)
pipeline = StableDiffusionXLControlNetPipeline.from_pretrained(
    <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, controlnet=controlnets, vae=vae, torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;&quot;&quot;
a relaxed rabbit sitting on a striped towel next to a pool with a tropical drink nearby, 
bright sunny day, vacation scene, 35mm photograph, film, professional, 4k, highly detailed
&quot;&quot;&quot;</span>
negative_prompt = <span class="hljs-string">&quot;lowres, bad anatomy, worst quality, low quality, deformed, ugly&quot;</span>

images = [canny_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>)), depth_image.resize((<span class="hljs-number">1024</span>, <span class="hljs-number">1024</span>))]

pipeline(
    prompt,
    negative_prompt=negative_prompt,
    image=images,
    num_inference_steps=<span class="hljs-number">100</span>,
    controlnet_conditioning_scale=[<span class="hljs-number">0.5</span>, <span class="hljs-number">0.5</span>],
    strength=<span class="hljs-number">0.7</span>,
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),F=new oe({props:{title:"guess_mode",local:"guessmode",headingTag:"h2"}}),S=new _({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pYW1nZSUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZSUyQyUyMENvbnRyb2xOZXRNb2RlbCUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMmRpZmZ1c2VycyUyRmNvbnRyb2xuZXQtY2Fubnktc2R4bC0xLjAlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTENvbnRyb2xOZXRQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTBBJTIwJTIwY29udHJvbG5ldCUzRGNvbnRyb2xuZXQlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMEEpLnRvKCUyMmN1ZGElMjIpJTBBJTBBY2FubnlfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhbm55LWNhdC5wbmclMjIpJTBBcGlwZWxpbmUoJTBBJTIwJTIwJTIyJTIyJTJDJTBBJTIwJTIwaW1hZ2UlM0RjYW5ueV9pbWFnZSUyQyUwQSUyMCUyMGd1ZXNzX21vZGUlM0RUcnVlJTBBKS5pbWFnZXMlNUIwJTVE",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_iamge
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLControlNetPipeline, ControlNetModel

controlnet = ControlNetModel.from_pretrained(
  <span class="hljs-string">&quot;diffusers/controlnet-canny-sdxl-1.0&quot;</span>, torch_dtype=torch.float16
)
pipeline = StableDiffusionXLControlNetPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  controlnet=controlnet,
  torch_dtype=torch.float16
).to(<span class="hljs-string">&quot;cuda&quot;</span>)

canny_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/canny-cat.png&quot;</span>)
pipeline(
  <span class="hljs-string">&quot;&quot;</span>,
  image=canny_image,
  guess_mode=<span class="hljs-literal">True</span>
).images[<span class="hljs-number">0</span>]`,wrap:!1}}),$=new We({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/controlnet.md"}}),{c(){n=b("meta"),f=M(),m=b("p"),r=M(),j(y.$$.fragment),c=M(),i=b("p"),i.innerHTML=J,u=M(),h=b("p"),h.textContent=o,B=M(),j(g.$$.fragment),l=M(),p=b("p"),p.innerHTML=me,A=M(),j(X.$$.fragment),z=M(),j(N.$$.fragment),D=M(),Y=b("p"),Y.innerHTML=re,L=M(),x=b("p"),x.textContent=ce,q=M(),Q=b("p"),Q.textContent=Me,K=M(),j(E.$$.fragment),P=M(),k=b("div"),k.innerHTML=de,O=M(),j(F.$$.fragment),ee=M(),V=b("p"),V.innerHTML=ye,le=M(),j(S.$$.fragment),te=M(),v=b("div"),v.innerHTML=ue,ae=M(),j($.$$.fragment),ne=M(),H=b("p"),this.h()},l(e){const s=je("svelte-u9bgzb",document.head);n=T(s,"META",{name:!0,content:!0}),s.forEach(t),f=d(e),m=T(e,"P",{}),ge(m).forEach(t),r=d(e),Z(y.$$.fragment,e),c=d(e),i=T(e,"P",{"data-svelte-h":!0}),U(i)!=="svelte-1n3ntx6"&&(i.innerHTML=J),u=d(e),h=T(e,"P",{"data-svelte-h":!0}),U(h)!=="svelte-1qp3bo6"&&(h.textContent=o),B=d(e),Z(g.$$.fragment,e),l=d(e),p=T(e,"P",{"data-svelte-h":!0}),U(p)!=="svelte-88bwwp"&&(p.innerHTML=me),A=d(e),Z(X.$$.fragment,e),z=d(e),Z(N.$$.fragment,e),D=d(e),Y=T(e,"P",{"data-svelte-h":!0}),U(Y)!=="svelte-11jp78z"&&(Y.innerHTML=re),L=d(e),x=T(e,"P",{"data-svelte-h":!0}),U(x)!=="svelte-ueyms4"&&(x.textContent=ce),q=d(e),Q=T(e,"P",{"data-svelte-h":!0}),U(Q)!=="svelte-1yb2pw9"&&(Q.textContent=Me),K=d(e),Z(E.$$.fragment,e),P=d(e),k=T(e,"DIV",{style:!0,"data-svelte-h":!0}),U(k)!=="svelte-1ols1y"&&(k.innerHTML=de),O=d(e),Z(F.$$.fragment,e),ee=d(e),V=T(e,"P",{"data-svelte-h":!0}),U(V)!=="svelte-1cijut3"&&(V.innerHTML=ye),le=d(e),Z(S.$$.fragment,e),te=d(e),v=T(e,"DIV",{style:!0,"data-svelte-h":!0}),U(v)!=="svelte-193ffwv"&&(v.innerHTML=ue),ae=d(e),Z($.$$.fragment,e),ne=d(e),H=T(e,"P",{}),ge(H).forEach(t),this.h()},h(){be(n,"name","hf:doc:metadata"),be(n,"content",_e),w(k,"display","flex"),w(k,"gap","10px"),w(k,"justify-content","space-around"),w(k,"align-items","flex-end"),w(v,"display","flex"),w(v,"gap","10px"),w(v,"justify-content","space-around"),w(v,"align-items","flex-end")},m(e,s){Ze(document.head,n),a(e,f,s),a(e,m,s),a(e,r,s),C(y,e,s),a(e,c,s),a(e,i,s),a(e,u,s),a(e,h,s),a(e,B,s),C(g,e,s),a(e,l,s),a(e,p,s),a(e,A,s),C(X,e,s),a(e,z,s),C(N,e,s),a(e,D,s),a(e,Y,s),a(e,L,s),a(e,x,s),a(e,q,s),a(e,Q,s),a(e,K,s),C(E,e,s),a(e,P,s),a(e,k,s),a(e,O,s),C(F,e,s),a(e,ee,s),a(e,V,s),a(e,le,s),C(S,e,s),a(e,te,s),a(e,v,s),a(e,ae,s),C($,e,s),a(e,ne,s),a(e,H,s),se=!0},p(e,[s]){const Je={};s&2&&(Je.$$scope={dirty:s,ctx:e}),g.$set(Je);const he={};s&2&&(he.$$scope={dirty:s,ctx:e}),X.$set(he)},i(e){se||(W(y.$$.fragment,e),W(g.$$.fragment,e),W(X.$$.fragment,e),W(N.$$.fragment,e),W(E.$$.fragment,e),W(F.$$.fragment,e),W(S.$$.fragment,e),W($.$$.fragment,e),se=!0)},o(e){I(y.$$.fragment,e),I(g.$$.fragment,e),I(X.$$.fragment,e),I(N.$$.fragment,e),I(E.$$.fragment,e),I(F.$$.fragment,e),I(S.$$.fragment,e),I($.$$.fragment,e),se=!1},d(e){e&&(t(f),t(m),t(r),t(c),t(i),t(u),t(h),t(B),t(l),t(p),t(A),t(z),t(D),t(Y),t(L),t(x),t(q),t(Q),t(K),t(P),t(k),t(O),t(ee),t(V),t(le),t(te),t(v),t(ae),t(ne),t(H)),t(n),G(y,e),G(g,e),G(X,e),G(N,e),G(E,e),G(F,e),G(S,e),G($,e)}}}const _e='{"title":"ControlNet","local":"controlnet","sections":[{"title":"Multi-ControlNet","local":"multi-controlnet","sections":[],"depth":2},{"title":"guess_mode","local":"guessmode","sections":[],"depth":2}],"depth":1}';function Ne(R){return fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Se extends we{constructor(n){super(),Ue(this,n,Ne,Xe,Te,{})}}export{Se as component};
