import{s as si,o as li,n as G}from"../chunks/scheduler.8c3d61f6.js";import{S as ti,i as ii,g as f,s as a,r as y,A as ni,h as r,f as l,c as p,j as ei,u as h,x as u,k as rs,y as ai,a as t,v as U,d as J,t as T,w as b}from"../chunks/index.da70eac4.js";import{T as El}from"../chunks/Tip.1d9b8c37.js";import{C as j}from"../chunks/CodeBlock.a9c4becf.js";import{D as pi}from"../chunks/DocNotebookDropdown.48852948.js";import{H as $,E as oi}from"../chunks/getInferenceSnippets.c28dea0b.js";import{H as Al,a as us}from"../chunks/HfOption.6ab18950.js";function fi(w){let i,c='Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you’re interested in an explanation about how the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){i=f("p"),i.innerHTML=c},l(n){i=r(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-1u8oykr"&&(i.innerHTML=c)},m(n,d){t(n,i,d)},p:G,d(n){n&&l(i)}}}function ri(w){let i,c='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is a simple and generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. It uses the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method to automatically detect the correct pipeline class for a task from the checkpoint, downloads and caches all the required configuration and weight files, and returns a pipeline ready for inference.',n,d,o,m,Z='This same checkpoint can also be used for an image-to-image task. The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class can handle any task as long as you provide the appropriate inputs. For example, for an image-to-image task, you need to pass an initial image to the pipeline.',g,v,C;return d=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMEFpbml0X2ltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZodWdnaW5nZmFjZSUyRmRvY3VtZW50YXRpb24taW1hZ2VzJTJGcmVzb2x2ZSUyRm1haW4lMkZkaWZmdXNlcnMlMkZpbWcyaW1nLWluaXQucG5nJTIyKSUwQXByb21wdCUyMCUzRCUyMCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKCUyMkFzdHJvbmF1dCUyMGluJTIwYSUyMGp1bmdsZSUyQyUyMGNvbGQlMjBjb2xvciUyMHBhbGV0dGUlMkMlMjBtdXRlZCUyMGNvbG9ycyUyQyUyMGRldGFpbGVkJTJDJTIwOGslMjIlMkMlMjBpbWFnZSUzRGluaXRfaW1hZ2UpLmltYWdlcyU1QjAlNUQ=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/img2img-init.png&quot;</span>)
prompt = <span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>
image = pipeline(<span class="hljs-string">&quot;Astronaut in a jungle, cold color palette, muted colors, detailed, 8k&quot;</span>, image=init_image).images[<span class="hljs-number">0</span>]`,wrap:!1}}),{c(){i=f("p"),i.innerHTML=c,n=a(),y(d.$$.fragment),o=a(),m=f("p"),m.innerHTML=Z,g=a(),y(v.$$.fragment)},l(M){i=r(M,"P",{"data-svelte-h":!0}),u(i)!=="svelte-193oq91"&&(i.innerHTML=c),n=p(M),h(d.$$.fragment,M),o=p(M),m=r(M,"P",{"data-svelte-h":!0}),u(m)!=="svelte-1thtl5s"&&(m.innerHTML=Z),g=p(M),h(v.$$.fragment,M)},m(M,I){t(M,i,I),t(M,n,I),U(d,M,I),t(M,o,I),t(M,m,I),t(M,g,I),U(v,M,I),C=!0},p:G,i(M){C||(J(d.$$.fragment,M),J(v.$$.fragment,M),C=!0)},o(M){T(d.$$.fragment,M),T(v.$$.fragment,M),C=!1},d(M){M&&(l(i),l(n),l(o),l(m),l(g)),b(d,M),b(v,M)}}}function ui(w){let i,c='Checkpoints can be loaded by their specific pipeline class if you already know it. For example, to load a Stable Diffusion model, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class.',n,d,o,m,Z='This same checkpoint may also be used for another task like image-to-image. To differentiate what task you want to use the checkpoint for, you have to use the corresponding task-specific pipeline class. For example, to use the same checkpoint for image-to-image, use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/img2img#diffusers.StableDiffusionImg2ImgPipeline">StableDiffusionImg2ImgPipeline</a> class.',g,v,C;return d=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

pipeline = StableDiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),v=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

pipeline = StableDiffusionImg2ImgPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),{c(){i=f("p"),i.innerHTML=c,n=a(),y(d.$$.fragment),o=a(),m=f("p"),m.innerHTML=Z,g=a(),y(v.$$.fragment)},l(M){i=r(M,"P",{"data-svelte-h":!0}),u(i)!=="svelte-b1p9rv"&&(i.innerHTML=c),n=p(M),h(d.$$.fragment,M),o=p(M),m=r(M,"P",{"data-svelte-h":!0}),u(m)!=="svelte-14muyt8"&&(m.innerHTML=Z),g=p(M),h(v.$$.fragment,M)},m(M,I){t(M,i,I),t(M,n,I),U(d,M,I),t(M,o,I),t(M,m,I),t(M,g,I),U(v,M,I),C=!0},p:G,i(M){C||(J(d.$$.fragment,M),J(v.$$.fragment,M),C=!0)},o(M){T(d.$$.fragment,M),T(v.$$.fragment,M),C=!1},d(M){M&&(l(i),l(n),l(o),l(m),l(g)),b(d,M),b(v,M)}}}function ci(w){let i,c,n,d;return i=new us({props:{id:"pipelines",option:"generic pipeline",$$slots:{default:[ri]},$$scope:{ctx:w}}}),n=new us({props:{id:"pipelines",option:"specific pipeline",$$slots:{default:[ui]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),c=p(o),h(n.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(n,o,m),d=!0},p(o,m){const Z={};m&2&&(Z.$$scope={dirty:m,ctx:o}),i.$set(Z);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),n.$set(g)},i(o){d||(J(i.$$.fragment,o),J(n.$$.fragment,o),d=!0)},o(o){T(i.$$.fragment,o),T(n.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(n,o)}}}function di(w){let i,c='To switch between tasks (rather than features), use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method with the <a href="../api/pipelines/auto_pipeline">AutoPipeline</a> class, which automatically identifies the pipeline class based on the task (learn more in the <a href="../tutorials/autopipeline">AutoPipeline</a> tutorial).';return{c(){i=f("p"),i.innerHTML=c},l(n){i=r(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-16alrk5"&&(i.innerHTML=c)},m(n,d){t(n,i,d)},p:G,d(n){n&&l(i)}}}function mi(w){let i,c='Some pipeline methods may not function properly on new pipelines created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>. For instance, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.enable_model_cpu_offload">enable_model_cpu_offload()</a> method installs hooks on the model components based on a unique offloading sequence for each pipeline. If the models are executed in a different order in the new pipeline, the CPU offloading may not work correctly.',n,d,o='To ensure everything works as expected, we recommend re-applying a pipeline method on a new pipeline created with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a>.';return{c(){i=f("p"),i.innerHTML=c,n=a(),d=f("p"),d.innerHTML=o},l(m){i=r(m,"P",{"data-svelte-h":!0}),u(i)!=="svelte-150boki"&&(i.innerHTML=c),n=p(m),d=r(m,"P",{"data-svelte-h":!0}),u(d)!=="svelte-gydtfi"&&(d.innerHTML=o)},m(m,Z){t(m,i,Z),t(m,n,Z),t(m,d,Z)},p:G,d(m){m&&(l(i),l(n),l(d))}}}function Mi(w){let i,c='When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories. For example, <a href="https://hf.co/stabilityai/stable-diffusion-2" rel="nofollow">stabilityai/stable-diffusion-2</a> and <a href="https://hf.co/stabilityai/stable-diffusion-2-1" rel="nofollow">stabilityai/stable-diffusion-2-1</a> are stored in separate repositories.';return{c(){i=f("p"),i.innerHTML=c},l(n){i=r(n,"P",{"data-svelte-h":!0}),u(i)!=="svelte-11b88rc"&&(i.innerHTML=c)},m(n,d){t(n,i,d)},p:G,d(n){n&&l(i)}}}function yi(w){let i,c;return i=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjJzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:G,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function hi(w){let i,c;return i=new j({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:G,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function Ui(w){let i,c,n,d;return i=new us({props:{id:"variants",option:"fp16",$$slots:{default:[yi]},$$scope:{ctx:w}}}),n=new us({props:{id:"variants",option:"non-EMA",$$slots:{default:[hi]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),c=p(o),h(n.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(n,o,m),d=!0},p(o,m){const Z={};m&2&&(Z.$$scope={dirty:m,ctx:o}),i.$set(Z);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),n.$set(g)},i(o){d||(J(i.$$.fragment,o),J(n.$$.fragment,o),d=!0)},o(o){T(i.$$.fragment,o),T(n.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(n,o)}}}function Ji(w){let i,c;return i=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)`,wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:G,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function Ti(w){let i,c;return i=new j({props:{code:"cGlwZWxpbmUuc2F2ZV9wcmV0cmFpbmVkKCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:'pipeline.save_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)',wrap:!1}}),{c(){y(i.$$.fragment)},l(n){h(i.$$.fragment,n)},m(n,d){U(i,n,d),c=!0},p:G,i(n){c||(J(i.$$.fragment,n),c=!0)},o(n){T(i.$$.fragment,n),c=!1},d(n){b(i,n)}}}function bi(w){let i,c,n,d;return i=new us({props:{id:"save",option:"fp16",$$slots:{default:[Ji]},$$scope:{ctx:w}}}),n=new us({props:{id:"save",option:"non_ema",$$slots:{default:[Ti]},$$scope:{ctx:w}}}),{c(){y(i.$$.fragment),c=a(),y(n.$$.fragment)},l(o){h(i.$$.fragment,o),c=p(o),h(n.$$.fragment,o)},m(o,m){U(i,o,m),t(o,c,m),U(n,o,m),d=!0},p(o,m){const Z={};m&2&&(Z.$$scope={dirty:m,ctx:o}),i.$set(Z);const g={};m&2&&(g.$$scope={dirty:m,ctx:o}),n.$set(g)},i(o){d||(J(i.$$.fragment,o),J(n.$$.fragment,o),d=!0)},o(o){T(i.$$.fragment,o),T(n.$$.fragment,o),d=!1},d(o){o&&l(c),b(i,o),b(n,o)}}}function wi(w){let i,c,n,d,o,m,Z,g,v,C='Diffusion systems consist of multiple components like parameterized models and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API. At the same time, the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> is entirely customizable so you can modify each component to build a diffusion system for your use case.',M,I,Ll="This guide will show you how to load:",ds,q,Pl="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>multiple pipelines without increasing memory usage</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li>",ms,z,Ms,_,ys,F,Ol="There are two ways to load a pipeline for a task:",hs,D,Kl='<li>Load the generic <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class and allow it to automatically detect the correct pipeline class from the checkpoint.</li> <li>Load a specific pipeline class for a specific task.</li>',Us,V,Js,H,et="Use the Space below to gauge a pipeline’s memory requirements before you download and load it to see if it runs on your hardware.",Ts,k,st='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=light" width="850" height="1600"></iframe>',bs,W,lt='<iframe src="https://diffusers-compute-pipeline-size.hf.space?__theme=dark" width="850" height="1600"></iframe>',ws,E,js,A,tt="You can customize the data types for individual sub-models by passing a dictionary to the <code>torch_dtype</code> parameter. This allows you to load different components of a pipeline in different floating point precisions. For instance, if you want to load the transformer with <code>torch.bfloat16</code> and all other components with <code>torch.float16</code>, you can pass a dictionary mapping:",Zs,L,gs,P,it="If a component is not explicitly specified in the dictionary and no <code>default</code> is provided, it will be loaded with <code>torch.float32</code>.",vs,O,Is,K,nt='To load a pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow">git-lfs</a> to manually download a checkpoint to your local disk.',Cs,ee,$s,se,at='This creates a local folder, ./stable-diffusion-v1-5, on your disk and you should pass its path to <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>.',Gs,le,_s,te,pt='The <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',Vs,ie,ks,ne,ot="You can customize a pipeline by loading different components into it. This is important because you can:",Ws,ae,ft="<li>change to a scheduler with faster generation speed or higher generation quality depending on your needs (call the <code>scheduler.compatibles</code> method on your pipeline to see compatible schedulers)</li> <li>change a default pipeline component to a newer and better performing one</li>",Rs,pe,rt='For example, let’s customize the default <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0" rel="nofollow">stabilityai/stable-diffusion-xl-base-1.0</a> checkpoint with:',Bs,oe,ut='<li>The <a href="/docs/diffusers/main/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a> to generate higher quality images at the expense of slower generation speed. You must pass the <code>subfolder=&quot;scheduler&quot;</code> parameter in <a href="/docs/diffusers/main/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">from_pretrained()</a> to load the scheduler configuration into the correct <a href="https://hf.co/stabilityai/stable-diffusion-xl-base-1.0/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.</li> <li>A more stable VAE that runs in fp16.</li>',Ns,fe,Xs,re,ct='Now pass the new scheduler and VAE to the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/stable_diffusion_xl#diffusers.StableDiffusionXLPipeline">StableDiffusionXLPipeline</a>.',Qs,ue,Ss,ce,Ys,de,dt="When you load multiple pipelines that share the same model components, it makes sense to reuse the shared components instead of reloading everything into memory again, especially if your hardware is memory-constrained. For example:",xs,me,mt='<li>You generated an image with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> but you want to improve its quality with the <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>. Both of these pipelines share the same pretrained model, so it’d be a waste of memory to load the same model twice.</li> <li>You want to add a model component, like a <a href="../api/pipelines/animatediff#animatediffpipeline"><code>MotionAdapter</code></a>, to <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> which was instantiated from an existing <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>. Again, both pipelines share the same pretrained model, so it’d be a waste of memory to load an entirely new pipeline again.</li>',qs,Me,Mt='With the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">DiffusionPipeline.from_pipe()</a> API, you can switch between multiple pipelines to take advantage of their different features without increasing memory-usage. It is similar to turning on and off a feature in your pipeline.',zs,R,Fs,ye,yt='Let’s start with a <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and then reuse the loaded model components to create a <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> to increase generation quality. You’ll use the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> with an <a href="./ip_adapter">IP-Adapter</a> to generate a bear eating pizza.',Ds,he,Hs,B,ht='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sd_0.png"/>',Es,Ue,Ut="For reference, you can check how much memory this process consumed.",As,Je,Ls,Te,Jt='Now, reuse the same pipeline components from <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> in <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> with the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> method.',Ps,N,Os,be,Ks,X,Tt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_sag_1.png"/>',el,we,bt='If you check the memory usage, you’ll see it remains the same as before because <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> and <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a> are sharing the same pipeline components. This allows you to use them interchangeably without any additional memory overhead.',sl,je,ll,Ze,wt='Let’s animate the image with the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> and also add a <code>MotionAdapter</code> module to the pipeline. For the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>, you need to unload the IP-Adapter first and reload it <em>after</em> you’ve created your new pipeline (this only applies to the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>).',tl,ge,il,Q,jt='<img class="rounded-xl" src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/from_pipe_out_animate_3.gif"/>',nl,ve,Zt='The <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> is more memory-intensive and consumes 15GB of memory (see the <a href="#memory-usage-of-from_pipe">Memory-usage of from_pipe</a> section to learn what this means for your memory-usage).',al,Ie,pl,Ce,ol,$e,gt='Pipelines loaded with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> can be customized with different model components or methods. However, whenever you modify the <em>state</em> of the model components, it affects all the other pipelines that share the same components. For example, if you call <a href="/docs/diffusers/main/en/api/loaders/ip_adapter#diffusers.loaders.IPAdapterMixin.unload_ip_adapter">unload_ip_adapter()</a> on the <a href="/docs/diffusers/main/en/api/pipelines/self_attention_guidance#diffusers.StableDiffusionSAGPipeline">StableDiffusionSAGPipeline</a>, you won’t be able to use IP-Adapter with the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> because it’s been removed from their shared components.',fl,Ge,rl,_e,ul,Ve,vt='The memory requirement of loading multiple pipelines with <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pipe">from_pipe()</a> is determined by the pipeline with the highest memory-usage regardless of the number of pipelines you create.',cl,ke,It="<thead><tr><th>Pipeline</th> <th>Memory usage (GB)</th></tr></thead> <tbody><tr><td>StableDiffusionPipeline</td> <td>4.400</td></tr> <tr><td>StableDiffusionSAGPipeline</td> <td>4.400</td></tr> <tr><td>AnimateDiffPipeline</td> <td>15.178</td></tr></tbody>",dl,We,Ct='The <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a> has the highest memory requirement, so the <em>total memory-usage</em> is based only on the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Your memory-usage will not increase if you create additional pipelines as long as their memory requirements doesn’t exceed that of the <a href="/docs/diffusers/main/en/api/pipelines/animatediff#diffusers.AnimateDiffPipeline">AnimateDiffPipeline</a>. Each pipeline can be used interchangeably without any additional memory overhead.',ml,Re,Ml,Be,$t='Diffusers implements a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> for Stable Diffusion models which can generate harmful content. The safety checker screens the generated output against known hardcoded not-safe-for-work (NSFW) content. If for whatever reason you’d like to disable the safety checker, pass <code>safety_checker=None</code> to the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method.',yl,Ne,hl,Xe,Ul,Qe,Gt="A checkpoint variant is usually a checkpoint whose weights are:",Jl,Se,_t='<li>Stored in a different floating point type, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow">torch.float16</a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights which shouldn’t be used for inference. You should use this variant to continue finetuning a model.</li>',Tl,S,bl,Ye,Vt='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">safetensors</a>), model structure, and their weights have identical tensor shapes.',wl,xe,kt="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.safetensors</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.safetensors</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.safetensors</td> <td><code>variant</code></td></tr></tbody>",jl,qe,Wt="There are two important arguments for loading variants:",Zl,ze,Rt='<li><p><code>torch_dtype</code> specifies the floating point precision of the loaded checkpoint. For example, if you want to save bandwidth by loading a fp16 variant, you should set <code>variant=&quot;fp16&quot;</code> and <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to fp16. Otherwise, the fp16 weights are converted to the default fp32 precision.</p> <p>If you only set <code>torch_dtype=torch.float16</code>, the default fp32 weights are downloaded first and then converted to fp16.</p></li> <li><p><code>variant</code> specifies which files should be loaded from the repository. For example, if you want to load a non-EMA variant of a UNet from <a href="https://hf.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main/unet" rel="nofollow">stable-diffusion-v1-5/stable-diffusion-v1-5</a>, set <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> file.</p></li>',gl,Y,vl,Fe,Bt='Use the <code>variant</code> parameter in the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method to save a checkpoint as a different floating point type or as a non-EMA variant. You should try save a variant to the same folder as the original checkpoint, so you have the option of loading both from the same folder.',Il,x,Cl,De,Nt="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint.",$l,He,Gl,Ee,_l,Ae,Xt='As a class method, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',Vl,Le,Qt='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',kl,Pe,St='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a>.',Wl,Oe,Rl,Ke,Yt='You’ll see pipeline is an instance of <a href="/docs/diffusers/main/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',Bl,es,xt='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',Nl,ss,Xl,ls,qt='Compare the components of the pipeline instance to the <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>stable-diffusion-v1-5/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',Ql,ts,Sl,is,zt="You can access each of the components of the pipeline as an attribute to view its configuration:",Yl,ns,xl,as,Ft='Every pipeline expects a <a href="https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',ql,ps,Dt="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",zl,os,Fl,fs,Dl,cs,Hl;return o=new $({props:{title:"Load pipelines",local:"load-pipelines",headingTag:"h1"}}),Z=new pi({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),z=new $({props:{title:"Load a pipeline",local:"load-a-pipeline",headingTag:"h2"}}),_=new El({props:{warning:!1,$$slots:{default:[fi]},$$scope:{ctx:w}}}),V=new Al({props:{id:"pipelines",options:["generic pipeline","specific pipeline"],$$slots:{default:[ci]},$$scope:{ctx:w}}}),E=new $({props:{title:"Specifying Component-Specific Data Types",local:"specifying-component-specific-data-types",headingTag:"h3"}}),L=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEh1bnl1YW5WaWRlb1BpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlJTIwJTNEJTIwSHVueXVhblZpZGVvUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMmh1bnl1YW52aWRlby1jb21tdW5pdHklMkZIdW55dWFuVmlkZW8lMjIlMkMlMEElMjAlMjAlMjAlMjB0b3JjaF9kdHlwZSUzRCU3QiUyMnRyYW5zZm9ybWVyJTIyJTNBJTIwdG9yY2guYmZsb2F0MTYlMkMlMjAlMjJkZWZhdWx0JTIyJTNBJTIwdG9yY2guZmxvYXQxNiU3RCUyQyUwQSklMEFwcmludChwaXBlLnRyYW5zZm9ybWVyLmR0eXBlJTJDJTIwcGlwZS52YWUuZHR5cGUpJTIwJTIwJTIzJTIwKHRvcmNoLmJmbG9hdDE2JTJDJTIwdG9yY2guZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> HunyuanVideoPipeline
<span class="hljs-keyword">import</span> torch

pipe = HunyuanVideoPipeline.from_pretrained(
    <span class="hljs-string">&quot;hunyuanvideo-community/HunyuanVideo&quot;</span>,
    torch_dtype={<span class="hljs-string">&quot;transformer&quot;</span>: torch.bfloat16, <span class="hljs-string">&quot;default&quot;</span>: torch.float16},
)
<span class="hljs-built_in">print</span>(pipe.transformer.dtype, pipe.vae.dtype)  <span class="hljs-comment"># (torch.bfloat16, torch.float16)</span>`,wrap:!1}}),O=new $({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),ee=new j({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTU=",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/stable-diffusion-v1-5/stable-diffusion-v1-5`,wrap:!1}}),le=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

stable_diffusion = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ie=new $({props:{title:"Customize a pipeline",local:"customize-a-pipeline",headingTag:"h2"}}),fe=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMjBBdXRvZW5jb2RlcktMJTBBaW1wb3J0JTIwdG9yY2glMEElMEFzY2hlZHVsZXIlMjAlM0QlMjBIZXVuRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEF2YWUlMjAlM0QlMjBBdXRvZW5jb2RlcktMLmZyb21fcHJldHJhaW5lZCglMjJtYWRlYnlvbGxpbiUyRnNkeGwtdmFlLWZwMTYtZml4JTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, HeunDiscreteScheduler, AutoencoderKL
<span class="hljs-keyword">import</span> torch

scheduler = HeunDiscreteScheduler.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
vae = AutoencoderKL.from_pretrained(<span class="hljs-string">&quot;madebyollin/sdxl-vae-fp16-fix&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ue=new j({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25YTFBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjJzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlMjIlMkMlMEElMjAlMjBzY2hlZHVsZXIlM0RzY2hlZHVsZXIlMkMlMEElMjAlMjB2YWUlM0R2YWUlMkMlMEElMjAlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEElMjAlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUwQSUyMCUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpLnRvKCUyMmN1ZGElMjIp",highlighted:`pipeline = StableDiffusionXLPipeline.from_pretrained(
  <span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>,
  scheduler=scheduler,
  vae=vae,
  torch_dtype=torch.float16,
  variant=<span class="hljs-string">&quot;fp16&quot;</span>,
  use_safetensors=<span class="hljs-literal">True</span>
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),ce=new $({props:{title:"Reuse a pipeline",local:"reuse-a-pipeline",headingTag:"h2"}}),R=new El({props:{warning:!1,$$slots:{default:[di]},$$scope:{ctx:w}}}),he=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uU0FHUGlwZWxpbmUlMEFpbXBvcnQlMjB0b3JjaCUwQWltcG9ydCUyMGdjJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMEFmcm9tJTIwYWNjZWxlcmF0ZS51dGlscyUyMGltcG9ydCUyMGNvbXB1dGVfbW9kdWxlX3NpemVzJTBBJTBBaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmxvYWRfbmVnX2VtYmVkLnBuZyUyMiklMEElMEFwaXBlX3NkJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMlNHMTYxMjIyJTJGUmVhbGlzdGljX1Zpc2lvbl9WNi4wX0IxX25vVkFFJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KSUwQXBpcGVfc2QubG9hZF9pcF9hZGFwdGVyKCUyMmg5NCUyRklQLUFkYXB0ZXIlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJtb2RlbHMlMjIlMkMlMjB3ZWlnaHRfbmFtZSUzRCUyMmlwLWFkYXB0ZXJfc2QxNS5iaW4lMjIpJTBBcGlwZV9zZC5zZXRfaXBfYWRhcHRlcl9zY2FsZSgwLjYpJTBBcGlwZV9zZC50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zZA==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, StableDiffusionSAGPipeline
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image
<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> compute_module_sizes

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/load_neg_embed.png&quot;</span>)

pipe_sd = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;SG161222/Realistic_Vision_V6.0_B1_noVAE&quot;</span>, torch_dtype=torch.float16)
pipe_sd.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_sd.set_ip_adapter_scale(<span class="hljs-number">0.6</span>)
pipe_sd.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
out_sd`,wrap:!1}}),Je=new j({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQXByaW50KGYlMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjAlN0JieXRlc190b19naWdhX2J5dGVzKHRvcmNoLmN1ZGEubWF4X21lbW9yeV9hbGxvY2F0ZWQoKSklN0QlMjBHQiUyMiklMEElMjJNYXglMjBtZW1vcnklMjBhbGxvY2F0ZWQlM0ElMjA0LjQwNjIxMzI4MzUzODgxOCUyMEdCJTIy",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
    <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),N=new El({props:{warning:!0,$$slots:{default:[mi]},$$scope:{ctx:w}}}),be=new j({props:{code:"cGlwZV9zYWclMjAlM0QlMjBTdGFibGVEaWZmdXNpb25TQUdQaXBlbGluZS5mcm9tX3BpcGUoJTBBJTIwJTIwJTIwJTIwcGlwZV9zZCUwQSklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3B1JTIyKS5tYW51YWxfc2VlZCgzMyklMEFvdXRfc2FnJTIwJTNEJTIwcGlwZV9zYWcoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSUyMCUyMCUyMCUyMGd1aWRhbmNlX3NjYWxlJTNEMS4wJTJDJTBBJTIwJTIwJTIwJTIwc2FnX3NjYWxlJTNEMC43NSUwQSkuaW1hZ2VzJTVCMCU1RCUwQW91dF9zYWc=",highlighted:`pipe_sag = StableDiffusionSAGPipeline.from_pipe(
    pipe_sd
)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sag = pipe_sag(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
    guidance_scale=<span class="hljs-number">1.0</span>,
    sag_scale=<span class="hljs-number">0.75</span>
).images[<span class="hljs-number">0</span>]
out_sag`,wrap:!1}}),je=new j({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDQuNDA2MjEzMjgzNTM4ODE4JTIwR0IlMjI=",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 4.406213283538818 GB&quot;</span>`,wrap:!1}}),ge=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEFuaW1hdGVEaWZmUGlwZWxpbmUlMkMlMjBNb3Rpb25BZGFwdGVyJTJDJTIwRERJTVNjaGVkdWxlciUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBleHBvcnRfdG9fZ2lmJTBBJTBBcGlwZV9zYWcudW5sb2FkX2lwX2FkYXB0ZXIoKSUwQWFkYXB0ZXIlMjAlM0QlMjBNb3Rpb25BZGFwdGVyLmZyb21fcHJldHJhaW5lZCglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tYWRhcHRlci12MS01LTIlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTBBcGlwZV9hbmltYXRlJTIwJTNEJTIwQW5pbWF0ZURpZmZQaXBlbGluZS5mcm9tX3BpcGUocGlwZV9zZCUyQyUyMG1vdGlvbl9hZGFwdGVyJTNEYWRhcHRlciklMEFwaXBlX2FuaW1hdGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlX2FuaW1hdGUuc2NoZWR1bGVyLmNvbmZpZyUyQyUyMGJldGFfc2NoZWR1bGUlM0QlMjJsaW5lYXIlMjIpJTBBJTIzJTIwbG9hZCUyMElQLUFkYXB0ZXIlMjBhbmQlMjBMb1JBJTIwd2VpZ2h0cyUyMGFnYWluJTBBcGlwZV9hbmltYXRlLmxvYWRfaXBfYWRhcHRlciglMjJoOTQlMkZJUC1BZGFwdGVyJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIybW9kZWxzJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJpcC1hZGFwdGVyX3NkMTUuYmluJTIyKSUwQXBpcGVfYW5pbWF0ZS5sb2FkX2xvcmFfd2VpZ2h0cyglMjJndW95d3clMkZhbmltYXRlZGlmZi1tb3Rpb24tbG9yYS16b29tLW91dCUyMiUyQyUyMGFkYXB0ZXJfbmFtZSUzRCUyMnpvb20tb3V0JTIyKSUwQXBpcGVfYW5pbWF0ZS50byglMjJjdWRhJTIyKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQXBpcGVfYW5pbWF0ZS5zZXRfYWRhcHRlcnMoJTIyem9vbS1vdXQlMjIlMkMlMjBhZGFwdGVyX3dlaWdodHMlM0QwLjc1KSUwQW91dCUyMCUzRCUyMHBpcGVfYW5pbWF0ZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlM0QlMjJiZWFyJTIwZWF0cyUyMHBpenphJTIyJTJDJTBBJTIwJTIwJTIwJTIwbnVtX2ZyYW1lcyUzRDE2JTJDJTBBJTIwJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTBBJTIwJTIwJTIwJTIwaXBfYWRhcHRlcl9pbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5mcmFtZXMlNUIwJTVEJTBBZXhwb3J0X3RvX2dpZihvdXQlMkMlMjAlMjJvdXRfYW5pbWF0ZS5naWYlMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AnimateDiffPipeline, MotionAdapter, DDIMScheduler
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> export_to_gif

pipe_sag.unload_ip_adapter()
adapter = MotionAdapter.from_pretrained(<span class="hljs-string">&quot;guoyww/animatediff-motion-adapter-v1-5-2&quot;</span>, torch_dtype=torch.float16)

pipe_animate = AnimateDiffPipeline.from_pipe(pipe_sd, motion_adapter=adapter)
pipe_animate.scheduler = DDIMScheduler.from_config(pipe_animate.scheduler.config, beta_schedule=<span class="hljs-string">&quot;linear&quot;</span>)
<span class="hljs-comment"># load IP-Adapter and LoRA weights again</span>
pipe_animate.load_ip_adapter(<span class="hljs-string">&quot;h94/IP-Adapter&quot;</span>, subfolder=<span class="hljs-string">&quot;models&quot;</span>, weight_name=<span class="hljs-string">&quot;ip-adapter_sd15.bin&quot;</span>)
pipe_animate.load_lora_weights(<span class="hljs-string">&quot;guoyww/animatediff-motion-lora-zoom-out&quot;</span>, adapter_name=<span class="hljs-string">&quot;zoom-out&quot;</span>)
pipe_animate.to(<span class="hljs-string">&quot;cuda&quot;</span>)

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
pipe_animate.set_adapters(<span class="hljs-string">&quot;zoom-out&quot;</span>, adapter_weights=<span class="hljs-number">0.75</span>)
out = pipe_animate(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    num_frames=<span class="hljs-number">16</span>,
    num_inference_steps=<span class="hljs-number">50</span>,
    ip_adapter_image=image,
    generator=generator,
).frames[<span class="hljs-number">0</span>]
export_to_gif(out, <span class="hljs-string">&quot;out_animate.gif&quot;</span>)`,wrap:!1}}),Ie=new j({props:{code:"cHJpbnQoZiUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMCU3QmJ5dGVzX3RvX2dpZ2FfYnl0ZXModG9yY2guY3VkYS5tYXhfbWVtb3J5X2FsbG9jYXRlZCgpKSU3RCUyMEdCJTIyKSUwQSUyMk1heCUyMG1lbW9yeSUyMGFsbG9jYXRlZCUzQSUyMDE1LjE3ODY2NDIwNzQ1ODQ5NiUyMEdCJTIy",highlighted:`<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Max memory allocated: <span class="hljs-subst">{bytes_to_giga_bytes(torch.cuda.max_memory_allocated())}</span> GB&quot;</span>)
<span class="hljs-string">&quot;Max memory allocated: 15.178664207458496 GB&quot;</span>`,wrap:!1}}),Ce=new $({props:{title:"Modify from_pipe components",local:"modify-frompipe-components",headingTag:"h3"}}),Ge=new j({props:{code:"cGlwZS5zYWdfdW5sb2FkX2lwX2FkYXB0ZXIoKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDMzKSUwQW91dF9zZCUyMCUzRCUyMHBpcGVfc2QoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyYmVhciUyMGVhdHMlMjBwaXp6YSUyMiUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRCUyMndyb25nJTIwd2hpdGUlMjBiYWxhbmNlJTJDJTIwZGFyayUyQyUyMHNrZXRjaGVzJTJDd29yc3QlMjBxdWFsaXR5JTJDbG93JTIwcXVhbGl0eSUyMiUyQyUwQSUyMCUyMCUyMCUyMGlwX2FkYXB0ZXJfaW1hZ2UlM0RpbWFnZSUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQSUyMkF0dHJpYnV0ZUVycm9yJTNBJTIwJ05vbmVUeXBlJyUyMG9iamVjdCUyMGhhcyUyMG5vJTIwYXR0cmlidXRlJTIwJ2ltYWdlX3Byb2plY3Rpb25fbGF5ZXJzJyUyMg==",highlighted:`pipe.sag_unload_ip_adapter()

generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">33</span>)
out_sd = pipe_sd(
    prompt=<span class="hljs-string">&quot;bear eats pizza&quot;</span>,
    negative_prompt=<span class="hljs-string">&quot;wrong white balance, dark, sketches,worst quality,low quality&quot;</span>,
    ip_adapter_image=image,
    num_inference_steps=<span class="hljs-number">50</span>,
    generator=generator,
).images[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;AttributeError: &#x27;NoneType&#x27; object has no attribute &#x27;image_projection_layers&#x27;&quot;</span>`,wrap:!1}}),_e=new $({props:{title:"Memory usage of from_pipe",local:"memory-usage-of-frompipe",headingTag:"h3"}}),Re=new $({props:{title:"Safety checker",local:"safety-checker",headingTag:"h2"}}),Ne=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmxlLWRpZmZ1c2lvbi12MS01JTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

pipeline = DiffusionPipeline.from_pretrained(<span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),Xe=new $({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),S=new El({props:{warning:!1,$$slots:{default:[Mi]},$$scope:{ctx:w}}}),Y=new Al({props:{id:"variants",options:["fp16","non-EMA"],$$slots:{default:[Ui]},$$scope:{ctx:w}}}),x=new Al({props:{id:"save",options:["fp16","non_ema"],$$slots:{default:[bi]},$$scope:{ctx:w}}}),He=new j({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMCVGMCU5RiU5MSU4RCUyMHRoaXMlMjB3b3JrcyUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Ee=new $({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),Oe=new j({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGVsaW5lJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQXByaW50KHBpcGVsaW5lKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;stable-diffusion-v1-5/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),ss=new j({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),ts=new j({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),ns=new j({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),os=new j({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),fs=new oi({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/loading.md"}}),{c(){i=f("meta"),c=a(),n=f("p"),d=a(),y(o.$$.fragment),m=a(),y(Z.$$.fragment),g=a(),v=f("p"),v.innerHTML=C,M=a(),I=f("p"),I.textContent=Ll,ds=a(),q=f("ul"),q.innerHTML=Pl,ms=a(),y(z.$$.fragment),Ms=a(),y(_.$$.fragment),ys=a(),F=f("p"),F.textContent=Ol,hs=a(),D=f("ol"),D.innerHTML=Kl,Us=a(),y(V.$$.fragment),Js=a(),H=f("p"),H.textContent=et,Ts=a(),k=f("div"),k.innerHTML=st,bs=a(),W=f("div"),W.innerHTML=lt,ws=a(),y(E.$$.fragment),js=a(),A=f("p"),A.innerHTML=tt,Zs=a(),y(L.$$.fragment),gs=a(),P=f("p"),P.innerHTML=it,vs=a(),y(O.$$.fragment),Is=a(),K=f("p"),K.innerHTML=nt,Cs=a(),y(ee.$$.fragment),$s=a(),se=f("p"),se.innerHTML=at,Gs=a(),y(le.$$.fragment),_s=a(),te=f("p"),te.innerHTML=pt,Vs=a(),y(ie.$$.fragment),ks=a(),ne=f("p"),ne.textContent=ot,Ws=a(),ae=f("ul"),ae.innerHTML=ft,Rs=a(),pe=f("p"),pe.innerHTML=rt,Bs=a(),oe=f("ul"),oe.innerHTML=ut,Ns=a(),y(fe.$$.fragment),Xs=a(),re=f("p"),re.innerHTML=ct,Qs=a(),y(ue.$$.fragment),Ss=a(),y(ce.$$.fragment),Ys=a(),de=f("p"),de.textContent=dt,xs=a(),me=f("ol"),me.innerHTML=mt,qs=a(),Me=f("p"),Me.innerHTML=Mt,zs=a(),y(R.$$.fragment),Fs=a(),ye=f("p"),ye.innerHTML=yt,Ds=a(),y(he.$$.fragment),Hs=a(),B=f("div"),B.innerHTML=ht,Es=a(),Ue=f("p"),Ue.textContent=Ut,As=a(),y(Je.$$.fragment),Ls=a(),Te=f("p"),Te.innerHTML=Jt,Ps=a(),y(N.$$.fragment),Os=a(),y(be.$$.fragment),Ks=a(),X=f("div"),X.innerHTML=Tt,el=a(),we=f("p"),we.innerHTML=bt,sl=a(),y(je.$$.fragment),ll=a(),Ze=f("p"),Ze.innerHTML=wt,tl=a(),y(ge.$$.fragment),il=a(),Q=f("div"),Q.innerHTML=jt,nl=a(),ve=f("p"),ve.innerHTML=Zt,al=a(),y(Ie.$$.fragment),pl=a(),y(Ce.$$.fragment),ol=a(),$e=f("p"),$e.innerHTML=gt,fl=a(),y(Ge.$$.fragment),rl=a(),y(_e.$$.fragment),ul=a(),Ve=f("p"),Ve.innerHTML=vt,cl=a(),ke=f("table"),ke.innerHTML=It,dl=a(),We=f("p"),We.innerHTML=Ct,ml=a(),y(Re.$$.fragment),Ml=a(),Be=f("p"),Be.innerHTML=$t,yl=a(),y(Ne.$$.fragment),hl=a(),y(Xe.$$.fragment),Ul=a(),Qe=f("p"),Qe.textContent=Gt,Jl=a(),Se=f("ul"),Se.innerHTML=_t,Tl=a(),y(S.$$.fragment),bl=a(),Ye=f("p"),Ye.innerHTML=Vt,wl=a(),xe=f("table"),xe.innerHTML=kt,jl=a(),qe=f("p"),qe.textContent=Wt,Zl=a(),ze=f("ul"),ze.innerHTML=Rt,gl=a(),y(Y.$$.fragment),vl=a(),Fe=f("p"),Fe.innerHTML=Bt,Il=a(),y(x.$$.fragment),Cl=a(),De=f("p"),De.innerHTML=Nt,$l=a(),y(He.$$.fragment),Gl=a(),y(Ee.$$.fragment),_l=a(),Ae=f("p"),Ae.innerHTML=Xt,Vl=a(),Le=f("ul"),Le.innerHTML=Qt,kl=a(),Pe=f("p"),Pe.innerHTML=St,Wl=a(),y(Oe.$$.fragment),Rl=a(),Ke=f("p"),Ke.innerHTML=Yt,Bl=a(),es=f("ul"),es.innerHTML=xt,Nl=a(),y(ss.$$.fragment),Xl=a(),ls=f("p"),ls.innerHTML=qt,Ql=a(),y(ts.$$.fragment),Sl=a(),is=f("p"),is.textContent=zt,Yl=a(),y(ns.$$.fragment),xl=a(),as=f("p"),as.innerHTML=Ft,ql=a(),ps=f("ul"),ps.innerHTML=Dt,zl=a(),y(os.$$.fragment),Fl=a(),y(fs.$$.fragment),Dl=a(),cs=f("p"),this.h()},l(e){const s=ni("svelte-u9bgzb",document.head);i=r(s,"META",{name:!0,content:!0}),s.forEach(l),c=p(e),n=r(e,"P",{}),ei(n).forEach(l),d=p(e),h(o.$$.fragment,e),m=p(e),h(Z.$$.fragment,e),g=p(e),v=r(e,"P",{"data-svelte-h":!0}),u(v)!=="svelte-1mjzpt7"&&(v.innerHTML=C),M=p(e),I=r(e,"P",{"data-svelte-h":!0}),u(I)!=="svelte-b6mpdv"&&(I.textContent=Ll),ds=p(e),q=r(e,"UL",{"data-svelte-h":!0}),u(q)!=="svelte-1eibdva"&&(q.innerHTML=Pl),ms=p(e),h(z.$$.fragment,e),Ms=p(e),h(_.$$.fragment,e),ys=p(e),F=r(e,"P",{"data-svelte-h":!0}),u(F)!=="svelte-1fp1qkh"&&(F.textContent=Ol),hs=p(e),D=r(e,"OL",{"data-svelte-h":!0}),u(D)!=="svelte-1hgg7us"&&(D.innerHTML=Kl),Us=p(e),h(V.$$.fragment,e),Js=p(e),H=r(e,"P",{"data-svelte-h":!0}),u(H)!=="svelte-x1hybx"&&(H.textContent=et),Ts=p(e),k=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(k)!=="svelte-1eacg44"&&(k.innerHTML=st),bs=p(e),W=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(W)!=="svelte-1scmarz"&&(W.innerHTML=lt),ws=p(e),h(E.$$.fragment,e),js=p(e),A=r(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-mf3fth"&&(A.innerHTML=tt),Zs=p(e),h(L.$$.fragment,e),gs=p(e),P=r(e,"P",{"data-svelte-h":!0}),u(P)!=="svelte-8ntfez"&&(P.innerHTML=it),vs=p(e),h(O.$$.fragment,e),Is=p(e),K=r(e,"P",{"data-svelte-h":!0}),u(K)!=="svelte-19d3ik7"&&(K.innerHTML=nt),Cs=p(e),h(ee.$$.fragment,e),$s=p(e),se=r(e,"P",{"data-svelte-h":!0}),u(se)!=="svelte-13irge8"&&(se.innerHTML=at),Gs=p(e),h(le.$$.fragment,e),_s=p(e),te=r(e,"P",{"data-svelte-h":!0}),u(te)!=="svelte-g0yd3u"&&(te.innerHTML=pt),Vs=p(e),h(ie.$$.fragment,e),ks=p(e),ne=r(e,"P",{"data-svelte-h":!0}),u(ne)!=="svelte-1ifrszd"&&(ne.textContent=ot),Ws=p(e),ae=r(e,"UL",{"data-svelte-h":!0}),u(ae)!=="svelte-1ln6l0l"&&(ae.innerHTML=ft),Rs=p(e),pe=r(e,"P",{"data-svelte-h":!0}),u(pe)!=="svelte-pkpme0"&&(pe.innerHTML=rt),Bs=p(e),oe=r(e,"UL",{"data-svelte-h":!0}),u(oe)!=="svelte-niwzp6"&&(oe.innerHTML=ut),Ns=p(e),h(fe.$$.fragment,e),Xs=p(e),re=r(e,"P",{"data-svelte-h":!0}),u(re)!=="svelte-1tnhj53"&&(re.innerHTML=ct),Qs=p(e),h(ue.$$.fragment,e),Ss=p(e),h(ce.$$.fragment,e),Ys=p(e),de=r(e,"P",{"data-svelte-h":!0}),u(de)!=="svelte-14g5ay7"&&(de.textContent=dt),xs=p(e),me=r(e,"OL",{"data-svelte-h":!0}),u(me)!=="svelte-1vxntr0"&&(me.innerHTML=mt),qs=p(e),Me=r(e,"P",{"data-svelte-h":!0}),u(Me)!=="svelte-jst5ua"&&(Me.innerHTML=Mt),zs=p(e),h(R.$$.fragment,e),Fs=p(e),ye=r(e,"P",{"data-svelte-h":!0}),u(ye)!=="svelte-1urnmn2"&&(ye.innerHTML=yt),Ds=p(e),h(he.$$.fragment,e),Hs=p(e),B=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(B)!=="svelte-ye42mk"&&(B.innerHTML=ht),Es=p(e),Ue=r(e,"P",{"data-svelte-h":!0}),u(Ue)!=="svelte-1u6h93y"&&(Ue.textContent=Ut),As=p(e),h(Je.$$.fragment,e),Ls=p(e),Te=r(e,"P",{"data-svelte-h":!0}),u(Te)!=="svelte-1cvgfbk"&&(Te.innerHTML=Jt),Ps=p(e),h(N.$$.fragment,e),Os=p(e),h(be.$$.fragment,e),Ks=p(e),X=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(X)!=="svelte-5lltp7"&&(X.innerHTML=Tt),el=p(e),we=r(e,"P",{"data-svelte-h":!0}),u(we)!=="svelte-1js9yxv"&&(we.innerHTML=bt),sl=p(e),h(je.$$.fragment,e),ll=p(e),Ze=r(e,"P",{"data-svelte-h":!0}),u(Ze)!=="svelte-1wtawsa"&&(Ze.innerHTML=wt),tl=p(e),h(ge.$$.fragment,e),il=p(e),Q=r(e,"DIV",{class:!0,"data-svelte-h":!0}),u(Q)!=="svelte-cbprhg"&&(Q.innerHTML=jt),nl=p(e),ve=r(e,"P",{"data-svelte-h":!0}),u(ve)!=="svelte-1hscc5j"&&(ve.innerHTML=Zt),al=p(e),h(Ie.$$.fragment,e),pl=p(e),h(Ce.$$.fragment,e),ol=p(e),$e=r(e,"P",{"data-svelte-h":!0}),u($e)!=="svelte-1dz1nqo"&&($e.innerHTML=gt),fl=p(e),h(Ge.$$.fragment,e),rl=p(e),h(_e.$$.fragment,e),ul=p(e),Ve=r(e,"P",{"data-svelte-h":!0}),u(Ve)!=="svelte-3tn4b0"&&(Ve.innerHTML=vt),cl=p(e),ke=r(e,"TABLE",{"data-svelte-h":!0}),u(ke)!=="svelte-170u8iz"&&(ke.innerHTML=It),dl=p(e),We=r(e,"P",{"data-svelte-h":!0}),u(We)!=="svelte-1w0v69h"&&(We.innerHTML=Ct),ml=p(e),h(Re.$$.fragment,e),Ml=p(e),Be=r(e,"P",{"data-svelte-h":!0}),u(Be)!=="svelte-1dz5d7t"&&(Be.innerHTML=$t),yl=p(e),h(Ne.$$.fragment,e),hl=p(e),h(Xe.$$.fragment,e),Ul=p(e),Qe=r(e,"P",{"data-svelte-h":!0}),u(Qe)!=="svelte-144ljdh"&&(Qe.textContent=Gt),Jl=p(e),Se=r(e,"UL",{"data-svelte-h":!0}),u(Se)!=="svelte-86xcrp"&&(Se.innerHTML=_t),Tl=p(e),h(S.$$.fragment,e),bl=p(e),Ye=r(e,"P",{"data-svelte-h":!0}),u(Ye)!=="svelte-naaguo"&&(Ye.innerHTML=Vt),wl=p(e),xe=r(e,"TABLE",{"data-svelte-h":!0}),u(xe)!=="svelte-1xwvx35"&&(xe.innerHTML=kt),jl=p(e),qe=r(e,"P",{"data-svelte-h":!0}),u(qe)!=="svelte-9nwb1f"&&(qe.textContent=Wt),Zl=p(e),ze=r(e,"UL",{"data-svelte-h":!0}),u(ze)!=="svelte-kz39jt"&&(ze.innerHTML=Rt),gl=p(e),h(Y.$$.fragment,e),vl=p(e),Fe=r(e,"P",{"data-svelte-h":!0}),u(Fe)!=="svelte-k0wnr6"&&(Fe.innerHTML=Bt),Il=p(e),h(x.$$.fragment,e),Cl=p(e),De=r(e,"P",{"data-svelte-h":!0}),u(De)!=="svelte-s6vvaz"&&(De.innerHTML=Nt),$l=p(e),h(He.$$.fragment,e),Gl=p(e),h(Ee.$$.fragment,e),_l=p(e),Ae=r(e,"P",{"data-svelte-h":!0}),u(Ae)!=="svelte-nr77qh"&&(Ae.innerHTML=Xt),Vl=p(e),Le=r(e,"UL",{"data-svelte-h":!0}),u(Le)!=="svelte-17dcgvz"&&(Le.innerHTML=Qt),kl=p(e),Pe=r(e,"P",{"data-svelte-h":!0}),u(Pe)!=="svelte-kb1186"&&(Pe.innerHTML=St),Wl=p(e),h(Oe.$$.fragment,e),Rl=p(e),Ke=r(e,"P",{"data-svelte-h":!0}),u(Ke)!=="svelte-102ytrs"&&(Ke.innerHTML=Yt),Bl=p(e),es=r(e,"UL",{"data-svelte-h":!0}),u(es)!=="svelte-1e5gxzy"&&(es.innerHTML=xt),Nl=p(e),h(ss.$$.fragment,e),Xl=p(e),ls=r(e,"P",{"data-svelte-h":!0}),u(ls)!=="svelte-16nw0pl"&&(ls.innerHTML=qt),Ql=p(e),h(ts.$$.fragment,e),Sl=p(e),is=r(e,"P",{"data-svelte-h":!0}),u(is)!=="svelte-5jik9b"&&(is.textContent=zt),Yl=p(e),h(ns.$$.fragment,e),xl=p(e),as=r(e,"P",{"data-svelte-h":!0}),u(as)!=="svelte-1jvh1d2"&&(as.innerHTML=Ft),ql=p(e),ps=r(e,"UL",{"data-svelte-h":!0}),u(ps)!=="svelte-hr84vt"&&(ps.innerHTML=Dt),zl=p(e),h(os.$$.fragment,e),Fl=p(e),h(fs.$$.fragment,e),Dl=p(e),cs=r(e,"P",{}),ei(cs).forEach(l),this.h()},h(){rs(i,"name","hf:doc:metadata"),rs(i,"content",ji),rs(k,"class","block dark:hidden"),rs(W,"class","hidden dark:block"),rs(B,"class","flex justify-center"),rs(X,"class","flex justify-center"),rs(Q,"class","flex justify-center")},m(e,s){ai(document.head,i),t(e,c,s),t(e,n,s),t(e,d,s),U(o,e,s),t(e,m,s),U(Z,e,s),t(e,g,s),t(e,v,s),t(e,M,s),t(e,I,s),t(e,ds,s),t(e,q,s),t(e,ms,s),U(z,e,s),t(e,Ms,s),U(_,e,s),t(e,ys,s),t(e,F,s),t(e,hs,s),t(e,D,s),t(e,Us,s),U(V,e,s),t(e,Js,s),t(e,H,s),t(e,Ts,s),t(e,k,s),t(e,bs,s),t(e,W,s),t(e,ws,s),U(E,e,s),t(e,js,s),t(e,A,s),t(e,Zs,s),U(L,e,s),t(e,gs,s),t(e,P,s),t(e,vs,s),U(O,e,s),t(e,Is,s),t(e,K,s),t(e,Cs,s),U(ee,e,s),t(e,$s,s),t(e,se,s),t(e,Gs,s),U(le,e,s),t(e,_s,s),t(e,te,s),t(e,Vs,s),U(ie,e,s),t(e,ks,s),t(e,ne,s),t(e,Ws,s),t(e,ae,s),t(e,Rs,s),t(e,pe,s),t(e,Bs,s),t(e,oe,s),t(e,Ns,s),U(fe,e,s),t(e,Xs,s),t(e,re,s),t(e,Qs,s),U(ue,e,s),t(e,Ss,s),U(ce,e,s),t(e,Ys,s),t(e,de,s),t(e,xs,s),t(e,me,s),t(e,qs,s),t(e,Me,s),t(e,zs,s),U(R,e,s),t(e,Fs,s),t(e,ye,s),t(e,Ds,s),U(he,e,s),t(e,Hs,s),t(e,B,s),t(e,Es,s),t(e,Ue,s),t(e,As,s),U(Je,e,s),t(e,Ls,s),t(e,Te,s),t(e,Ps,s),U(N,e,s),t(e,Os,s),U(be,e,s),t(e,Ks,s),t(e,X,s),t(e,el,s),t(e,we,s),t(e,sl,s),U(je,e,s),t(e,ll,s),t(e,Ze,s),t(e,tl,s),U(ge,e,s),t(e,il,s),t(e,Q,s),t(e,nl,s),t(e,ve,s),t(e,al,s),U(Ie,e,s),t(e,pl,s),U(Ce,e,s),t(e,ol,s),t(e,$e,s),t(e,fl,s),U(Ge,e,s),t(e,rl,s),U(_e,e,s),t(e,ul,s),t(e,Ve,s),t(e,cl,s),t(e,ke,s),t(e,dl,s),t(e,We,s),t(e,ml,s),U(Re,e,s),t(e,Ml,s),t(e,Be,s),t(e,yl,s),U(Ne,e,s),t(e,hl,s),U(Xe,e,s),t(e,Ul,s),t(e,Qe,s),t(e,Jl,s),t(e,Se,s),t(e,Tl,s),U(S,e,s),t(e,bl,s),t(e,Ye,s),t(e,wl,s),t(e,xe,s),t(e,jl,s),t(e,qe,s),t(e,Zl,s),t(e,ze,s),t(e,gl,s),U(Y,e,s),t(e,vl,s),t(e,Fe,s),t(e,Il,s),U(x,e,s),t(e,Cl,s),t(e,De,s),t(e,$l,s),U(He,e,s),t(e,Gl,s),U(Ee,e,s),t(e,_l,s),t(e,Ae,s),t(e,Vl,s),t(e,Le,s),t(e,kl,s),t(e,Pe,s),t(e,Wl,s),U(Oe,e,s),t(e,Rl,s),t(e,Ke,s),t(e,Bl,s),t(e,es,s),t(e,Nl,s),U(ss,e,s),t(e,Xl,s),t(e,ls,s),t(e,Ql,s),U(ts,e,s),t(e,Sl,s),t(e,is,s),t(e,Yl,s),U(ns,e,s),t(e,xl,s),t(e,as,s),t(e,ql,s),t(e,ps,s),t(e,zl,s),U(os,e,s),t(e,Fl,s),U(fs,e,s),t(e,Dl,s),t(e,cs,s),Hl=!0},p(e,[s]){const Ht={};s&2&&(Ht.$$scope={dirty:s,ctx:e}),_.$set(Ht);const Et={};s&2&&(Et.$$scope={dirty:s,ctx:e}),V.$set(Et);const At={};s&2&&(At.$$scope={dirty:s,ctx:e}),R.$set(At);const Lt={};s&2&&(Lt.$$scope={dirty:s,ctx:e}),N.$set(Lt);const Pt={};s&2&&(Pt.$$scope={dirty:s,ctx:e}),S.$set(Pt);const Ot={};s&2&&(Ot.$$scope={dirty:s,ctx:e}),Y.$set(Ot);const Kt={};s&2&&(Kt.$$scope={dirty:s,ctx:e}),x.$set(Kt)},i(e){Hl||(J(o.$$.fragment,e),J(Z.$$.fragment,e),J(z.$$.fragment,e),J(_.$$.fragment,e),J(V.$$.fragment,e),J(E.$$.fragment,e),J(L.$$.fragment,e),J(O.$$.fragment,e),J(ee.$$.fragment,e),J(le.$$.fragment,e),J(ie.$$.fragment,e),J(fe.$$.fragment,e),J(ue.$$.fragment,e),J(ce.$$.fragment,e),J(R.$$.fragment,e),J(he.$$.fragment,e),J(Je.$$.fragment,e),J(N.$$.fragment,e),J(be.$$.fragment,e),J(je.$$.fragment,e),J(ge.$$.fragment,e),J(Ie.$$.fragment,e),J(Ce.$$.fragment,e),J(Ge.$$.fragment,e),J(_e.$$.fragment,e),J(Re.$$.fragment,e),J(Ne.$$.fragment,e),J(Xe.$$.fragment,e),J(S.$$.fragment,e),J(Y.$$.fragment,e),J(x.$$.fragment,e),J(He.$$.fragment,e),J(Ee.$$.fragment,e),J(Oe.$$.fragment,e),J(ss.$$.fragment,e),J(ts.$$.fragment,e),J(ns.$$.fragment,e),J(os.$$.fragment,e),J(fs.$$.fragment,e),Hl=!0)},o(e){T(o.$$.fragment,e),T(Z.$$.fragment,e),T(z.$$.fragment,e),T(_.$$.fragment,e),T(V.$$.fragment,e),T(E.$$.fragment,e),T(L.$$.fragment,e),T(O.$$.fragment,e),T(ee.$$.fragment,e),T(le.$$.fragment,e),T(ie.$$.fragment,e),T(fe.$$.fragment,e),T(ue.$$.fragment,e),T(ce.$$.fragment,e),T(R.$$.fragment,e),T(he.$$.fragment,e),T(Je.$$.fragment,e),T(N.$$.fragment,e),T(be.$$.fragment,e),T(je.$$.fragment,e),T(ge.$$.fragment,e),T(Ie.$$.fragment,e),T(Ce.$$.fragment,e),T(Ge.$$.fragment,e),T(_e.$$.fragment,e),T(Re.$$.fragment,e),T(Ne.$$.fragment,e),T(Xe.$$.fragment,e),T(S.$$.fragment,e),T(Y.$$.fragment,e),T(x.$$.fragment,e),T(He.$$.fragment,e),T(Ee.$$.fragment,e),T(Oe.$$.fragment,e),T(ss.$$.fragment,e),T(ts.$$.fragment,e),T(ns.$$.fragment,e),T(os.$$.fragment,e),T(fs.$$.fragment,e),Hl=!1},d(e){e&&(l(c),l(n),l(d),l(m),l(g),l(v),l(M),l(I),l(ds),l(q),l(ms),l(Ms),l(ys),l(F),l(hs),l(D),l(Us),l(Js),l(H),l(Ts),l(k),l(bs),l(W),l(ws),l(js),l(A),l(Zs),l(gs),l(P),l(vs),l(Is),l(K),l(Cs),l($s),l(se),l(Gs),l(_s),l(te),l(Vs),l(ks),l(ne),l(Ws),l(ae),l(Rs),l(pe),l(Bs),l(oe),l(Ns),l(Xs),l(re),l(Qs),l(Ss),l(Ys),l(de),l(xs),l(me),l(qs),l(Me),l(zs),l(Fs),l(ye),l(Ds),l(Hs),l(B),l(Es),l(Ue),l(As),l(Ls),l(Te),l(Ps),l(Os),l(Ks),l(X),l(el),l(we),l(sl),l(ll),l(Ze),l(tl),l(il),l(Q),l(nl),l(ve),l(al),l(pl),l(ol),l($e),l(fl),l(rl),l(ul),l(Ve),l(cl),l(ke),l(dl),l(We),l(ml),l(Ml),l(Be),l(yl),l(hl),l(Ul),l(Qe),l(Jl),l(Se),l(Tl),l(bl),l(Ye),l(wl),l(xe),l(jl),l(qe),l(Zl),l(ze),l(gl),l(vl),l(Fe),l(Il),l(Cl),l(De),l($l),l(Gl),l(_l),l(Ae),l(Vl),l(Le),l(kl),l(Pe),l(Wl),l(Rl),l(Ke),l(Bl),l(es),l(Nl),l(Xl),l(ls),l(Ql),l(Sl),l(is),l(Yl),l(xl),l(as),l(ql),l(ps),l(zl),l(Fl),l(Dl),l(cs)),l(i),b(o,e),b(Z,e),b(z,e),b(_,e),b(V,e),b(E,e),b(L,e),b(O,e),b(ee,e),b(le,e),b(ie,e),b(fe,e),b(ue,e),b(ce,e),b(R,e),b(he,e),b(Je,e),b(N,e),b(be,e),b(je,e),b(ge,e),b(Ie,e),b(Ce,e),b(Ge,e),b(_e,e),b(Re,e),b(Ne,e),b(Xe,e),b(S,e),b(Y,e),b(x,e),b(He,e),b(Ee,e),b(Oe,e),b(ss,e),b(ts,e),b(ns,e),b(os,e),b(fs,e)}}}const ji='{"title":"Load pipelines","local":"load-pipelines","sections":[{"title":"Load a pipeline","local":"load-a-pipeline","sections":[{"title":"Specifying Component-Specific Data Types","local":"specifying-component-specific-data-types","sections":[],"depth":3},{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3}],"depth":2},{"title":"Customize a pipeline","local":"customize-a-pipeline","sections":[],"depth":2},{"title":"Reuse a pipeline","local":"reuse-a-pipeline","sections":[{"title":"Modify from_pipe components","local":"modify-frompipe-components","sections":[],"depth":3},{"title":"Memory usage of from_pipe","local":"memory-usage-of-frompipe","sections":[],"depth":3}],"depth":2},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function Zi(w){return li(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vi extends ti{constructor(i){super(),ii(this,i,Zi,wi,si,{})}}export{Vi as component};
