import{s as Ut,o as jt,n as ct}from"../chunks/scheduler.8c3d61f6.js";import{S as Jt,i as $t,g as l,s as o,r as g,A as Wt,h as d,f as t,c as i,j as P,u as f,x as y,k as I,y as a,a as s,v as _,d as u,t as h,w as b}from"../chunks/index.da70eac4.js";import{T as zt}from"../chunks/Tip.1d9b8c37.js";import{D as M}from"../chunks/Docstring.51c5065f.js";import{C as Lt}from"../chunks/CodeBlock.a9c4becf.js";import{E as kt}from"../chunks/ExampleCodeBlock.0c1f5b64.js";import{H as Ee,E as Zt}from"../chunks/getInferenceSnippets.c28dea0b.js";function Gt($){let p,w='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-a-pipeline">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){p=l("p"),p.innerHTML=w},l(m){p=d(m,"P",{"data-svelte-h":!0}),y(p)!=="svelte-1qn15hi"&&(p.innerHTML=w)},m(m,c){s(m,p,c)},p:ct,d(m){m&&t(p)}}}function Ft($){let p,w="Examples:",m,c,v;return c=new Lt({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwU3RhYmxlRGlmZnVzaW9uM0NvbnRyb2xOZXRQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMubW9kZWxzJTIwaW1wb3J0JTIwU0QzQ29udHJvbE5ldE1vZGVsJTJDJTIwU0QzTXVsdGlDb250cm9sTmV0TW9kZWwlMEFmcm9tJTIwZGlmZnVzZXJzLnV0aWxzJTIwaW1wb3J0JTIwbG9hZF9pbWFnZSUwQSUwQWNvbnRyb2xuZXQlMjAlM0QlMjBTRDNDb250cm9sTmV0TW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMkluc3RhbnRYJTJGU0QzLUNvbnRyb2xuZXQtQ2FubnklMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYpJTBBJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvbjNDb250cm9sTmV0UGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi0zLW1lZGl1bS1kaWZmdXNlcnMlMjIlMkMlMjBjb250cm9sbmV0JTNEY29udHJvbG5ldCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUwQSklMEFwaXBlLnRvKCUyMmN1ZGElMjIpJTBBY29udHJvbF9pbWFnZSUyMCUzRCUyMGxvYWRfaW1hZ2UoJTBBJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaGYtaW50ZXJuYWwtdGVzdGluZyUyRmRpZmZ1c2Vycy1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnNkX2NvbnRyb2xuZXQlMkZiaXJkX2Nhbm55LnBuZyUyMiUwQSklMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwYmlyZCUyMGluJTIwc3BhY2UlMjIlMEFpbWFnZSUyMCUzRCUyMHBpcGUoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTJDJTIwY29udHJvbF9pbWFnZSUzRGNvbnRyb2xfaW1hZ2UlMkMlMjBoZWlnaHQlM0QxMDI0JTJDJTIwd2lkdGglM0Q3NjglMkMlMjBjb250cm9sbmV0X2NvbmRpdGlvbmluZ19zY2FsZSUzRDAuNyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWltYWdlLnNhdmUoJTIyc2QzLnBuZyUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusion3ControlNetPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.models <span class="hljs-keyword">import</span> SD3ControlNetModel, SD3MultiControlNetModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = SD3ControlNetModel.from_pretrained(<span class="hljs-string">&quot;InstantX/SD3-Controlnet-Canny&quot;</span>, torch_dtype=torch.float16)

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3ControlNetPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>, controlnet=controlnet, torch_dtype=torch.float16
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>control_image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/datasets/hf-internal-testing/diffusers-images/resolve/main/sd_controlnet/bird_canny.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A bird in space&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = pipe(
<span class="hljs-meta">... </span>    prompt, control_image=control_image, height=<span class="hljs-number">1024</span>, width=<span class="hljs-number">768</span>, controlnet_conditioning_scale=<span class="hljs-number">0.7</span>
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,m=o(),g(c.$$.fragment)},l(r){p=d(r,"P",{"data-svelte-h":!0}),y(p)!=="svelte-kvfsh7"&&(p.textContent=w),m=i(r),f(c.$$.fragment,r)},m(r,T){s(r,p,T),s(r,m,T),_(c,r,T),v=!0},p:ct,i(r){v||(u(c.$$.fragment,r),v=!0)},o(r){h(c.$$.fragment,r),v=!1},d(r){r&&(t(p),t(m)),b(c,r)}}}function Rt($){let p,w="Examples:",m,c,v;return c=new Lt({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, check_min_version
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.pipelines <span class="hljs-keyword">import</span> StableDiffusion3ControlNetInpaintingPipeline
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers.models.controlnet_sd3 <span class="hljs-keyword">import</span> SD3ControlNetModel

<span class="hljs-meta">&gt;&gt;&gt; </span>controlnet = SD3ControlNetModel.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;alimama-creative/SD3-Controlnet-Inpainting&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>, extra_conditioning_channels=<span class="hljs-number">1</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = StableDiffusion3ControlNetInpaintingPipeline.from_pretrained(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;stabilityai/stable-diffusion-3-medium-diffusers&quot;</span>,
<span class="hljs-meta">... </span>    controlnet=controlnet,
<span class="hljs-meta">... </span>    torch_dtype=torch.float16,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.text_encoder.to(torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.controlnet.to(torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>image = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/alimama-creative/SD3-Controlnet-Inpainting/resolve/main/images/dog.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>mask = load_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;https://huggingface.co/alimama-creative/SD3-Controlnet-Inpainting/resolve/main/images/dog_mask.png&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>width = <span class="hljs-number">1024</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>height = <span class="hljs-number">1024</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;A cat is sitting next to a puppy.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">24</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>res_image = pipe(
<span class="hljs-meta">... </span>    negative_prompt=<span class="hljs-string">&quot;deformed, distorted, disfigured, poorly drawn, bad anatomy, wrong anatomy, extra limb, missing limb, floating limbs, mutated hands and fingers, disconnected limbs, mutation, mutated, ugly, disgusting, blurry, amputation, NSFW&quot;</span>,
<span class="hljs-meta">... </span>    prompt=prompt,
<span class="hljs-meta">... </span>    height=height,
<span class="hljs-meta">... </span>    width=width,
<span class="hljs-meta">... </span>    control_image=image,
<span class="hljs-meta">... </span>    control_mask=mask,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">28</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>    controlnet_conditioning_scale=<span class="hljs-number">0.95</span>,
<span class="hljs-meta">... </span>    guidance_scale=<span class="hljs-number">7</span>,
<span class="hljs-meta">... </span>).images[<span class="hljs-number">0</span>]
<span class="hljs-meta">&gt;&gt;&gt; </span>res_image.save(<span class="hljs-string">f&quot;sd3.png&quot;</span>)`,wrap:!1}}),{c(){p=l("p"),p.textContent=w,m=o(),g(c.$$.fragment)},l(r){p=d(r,"P",{"data-svelte-h":!0}),y(p)!=="svelte-kvfsh7"&&(p.textContent=w),m=i(r),f(c.$$.fragment,r)},m(r,T){s(r,p,T),s(r,m,T),_(c,r,T),v=!0},p:ct,i(r){v||(u(c.$$.fragment,r),v=!0)},o(r){h(c.$$.fragment,r),v=!1},d(r){r&&(t(p),t(m)),b(c,r)}}}function Xt($){let p,w,m,c,v,r,T,mt='<img alt="LoRA" src="https://img.shields.io/badge/LoRA-d8b4fe?style=flat"/>',Ne,R,gt="StableDiffusion3ControlNetPipeline is an implementation of ControlNet for Stable Diffusion 3.",Pe,X,ft='ControlNet was introduced in <a href="https://huggingface.co/papers/2302.05543" rel="nofollow">Adding Conditional Control to Text-to-Image Diffusion Models</a> by Lvmin Zhang, Anyi Rao, and Maneesh Agrawala.',Me,B,_t="With a ControlNet model, you can provide an additional control image to condition and control Stable Diffusion generation. For example, if you provide a depth map, the ControlNet model generates an image that’ll preserve the spatial information from the depth map. It is a more flexible and accurate way to control the image generation process.",De,E,ut="The abstract from the paper is:",Se,Q,ht="<em>We present ControlNet, a neural network architecture to add spatial conditioning controls to large, pretrained text-to-image diffusion models. ControlNet locks the production-ready large diffusion models, and reuses their deep and robust encoding layers pretrained with billions of images as a strong backbone to learn a diverse set of conditional controls. The neural architecture is connected with “zero convolutions” (zero-initialized convolution layers) that progressively grow the parameters from zero and ensure that no harmful noise could affect the finetuning. We test various conditioning controls, eg, edges, depth, segmentation, human pose, etc, with Stable Diffusion, using single or multiple conditions, with or without prompts. We show that the training of ControlNets is robust with small (&lt;50k) and large (&gt;1m) datasets. Extensive results show that ControlNet may facilitate wider applications to control image diffusion models.</em>",ke,V,bt='This controlnet code is mainly implemented by <a href="https://huggingface.co/InstantX" rel="nofollow">The InstantX Team</a>. The inpainting-related code was developed by <a href="https://huggingface.co/alimama-creative" rel="nofollow">The Alimama Creative Team</a>. You can find pre-trained checkpoints for SD3-ControlNet in the table below:',Le,Y,yt='<thead><tr><th>ControlNet type</th> <th>Developer</th> <th>Link</th></tr></thead> <tbody><tr><td>Canny</td> <td><a href="https://huggingface.co/InstantX" rel="nofollow">The InstantX Team</a></td> <td><a href="https://huggingface.co/InstantX/SD3-Controlnet-Canny" rel="nofollow">Link</a></td></tr> <tr><td>Depth</td> <td><a href="https://huggingface.co/InstantX" rel="nofollow">The InstantX Team</a></td> <td><a href="https://huggingface.co/InstantX/SD3-Controlnet-Depth" rel="nofollow">Link</a></td></tr> <tr><td>Pose</td> <td><a href="https://huggingface.co/InstantX" rel="nofollow">The InstantX Team</a></td> <td><a href="https://huggingface.co/InstantX/SD3-Controlnet-Pose" rel="nofollow">Link</a></td></tr> <tr><td>Tile</td> <td><a href="https://huggingface.co/InstantX" rel="nofollow">The InstantX Team</a></td> <td><a href="https://huggingface.co/InstantX/SD3-Controlnet-Tile" rel="nofollow">Link</a></td></tr> <tr><td>Inpainting</td> <td><a href="https://huggingface.co/alimama-creative" rel="nofollow">The AlimamaCreative Team</a></td> <td><a href="https://huggingface.co/alimama-creative/SD3-Controlnet-Inpainting" rel="nofollow">link</a></td></tr></tbody>',Ue,W,je,A,Je,x,H,Qe,D,O,Ve,ce,vt="Function invoked when calling the pipeline for generation.",Ye,z,Ae,Z,q,He,me,Tt="Encodes the given image into a feature representation using a pre-trained image encoder.",Oe,ge,K,qe,S,ee,Ke,fe,xt="Prepares image embeddings for use in the IP-Adapter.",et,_e,Ct="Either <code>ip_adapter_image</code> or <code>ip_adapter_image_embeds</code> must be passed.",$e,te,We,C,ne,tt,k,oe,nt,ue,It="Function invoked when calling the pipeline for generation.",ot,G,it,F,ie,at,he,wt="Encodes the given image into a feature representation using a pre-trained image encoder.",st,be,ae,rt,L,se,lt,ye,Nt="Prepares image embeddings for use in the IP-Adapter.",dt,ve,Pt="Either <code>ip_adapter_image</code> or <code>ip_adapter_image_embeds</code> must be passed.",ze,re,Ze,j,le,pt,Te,Mt="Output class for Stable Diffusion pipelines.",Ge,de,Fe,we,Re;return v=new Ee({props:{title:"ControlNet with Stable Diffusion 3",local:"controlnet-with-stable-diffusion-3",headingTag:"h1"}}),W=new zt({props:{$$slots:{default:[Gt]},$$scope:{ctx:$}}}),A=new Ee({props:{title:"StableDiffusion3ControlNetPipeline",local:"diffusers.StableDiffusion3ControlNetPipeline",headingTag:"h2"}}),H=new M({props:{name:"class diffusers.StableDiffusion3ControlNetPipeline",anchor:"diffusers.StableDiffusion3ControlNetPipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_sd3.SD3ControlNetModel, typing.List[diffusers.models.controlnets.controlnet_sd3.SD3ControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet_sd3.SD3ControlNetModel], diffusers.models.controlnets.controlnet_sd3.SD3MultiControlNetModel]"},{name:"image_encoder",val:": typing.Optional[transformers.models.siglip.modeling_siglip.SiglipVisionModel] = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.siglip.image_processing_siglip.SiglipImageProcessor] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet_sd3#diffusers.SD3ControlNetModel">SD3ControlNetModel</a> or <code>List[SD3ControlNetModel]</code> or <code>SD3MultiControlNetModel</code>) &#x2014;
Provides additional conditioning to the <code>unet</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>SiglipVisionModel</code>, <em>optional</em>) &#x2014;
Pre-trained Vision Model for IP Adapter.`,name:"image_encoder"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>SiglipImageProcessor</code>, <em>optional</em>) &#x2014;
Image processor for IP Adapter.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet.py#L143"}}),O=new M({props:{name:"__call__",anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"controlnet_pooled_projections",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>, &#x2014;
<code>List[List[torch.Tensor]]</code>, <code>List[List[np.ndarray]]</code> or <code>List[List[PIL.Image.Image]]</code>):
The ControlNet input condition to provide guidance to the <code>unet</code> for generation. If the type is
specified as <code>torch.Tensor</code>, it is passed to ControlNet as is. <code>PIL.Image.Image</code> can also be accepted
as an image. The dimensions of the output image defaults to <code>image</code>&#x2019;s dimensions. If height and/or
width are passed, <code>image</code> is resized accordingly. If multiple ControlNets are specified in <code>init</code>,
images must be passed as a list such that each element of the list can be correctly batched for input
to a single ControlNet.`,name:"control_image"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.controlnet_pooled_projections",description:`<strong>controlnet_pooled_projections</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, projection_dim)</code>) &#x2014;
Embeddings projected from the embeddings of controlnet input conditions.`,name:"controlnet_pooled_projections"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet.py#L818",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),z=new kt({props:{anchor:"diffusers.StableDiffusion3ControlNetPipeline.__call__.example",$$slots:{default:[Ft]},$$scope:{ctx:$}}}),q=new M({props:{name:"encode_image",anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_image",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"device",val:": device"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_image.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input image to be encoded.`,name:"image"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_image.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
Torch device.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet.py#L741",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The encoded image feature representation.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),K=new M({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_3",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet.py#L364"}}),ee=new M({props:{name:"prepare_ip_adapter_image_embeds",anchor:"diffusers.StableDiffusion3ControlNetPipeline.prepare_ip_adapter_image_embeds",parameters:[{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetPipeline.prepare_ip_adapter_image_embeds.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
The input image to extract features from for IP-Adapter.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.prepare_ip_adapter_image_embeds.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Precomputed image embeddings.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.prepare_ip_adapter_image_embeds.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
Torch device.`,name:"device"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.prepare_ip_adapter_image_embeds.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
Number of images that should be generated per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetPipeline.prepare_ip_adapter_image_embeds.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, defaults to True) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet.py#L761"}}),te=new Ee({props:{title:"StableDiffusion3ControlNetInpaintingPipeline",local:"diffusers.StableDiffusion3ControlNetInpaintingPipeline",headingTag:"h2"}}),ne=new M({props:{name:"class diffusers.StableDiffusion3ControlNetInpaintingPipeline",anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline",parameters:[{name:"transformer",val:": SD3Transformer2DModel"},{name:"scheduler",val:": FlowMatchEulerDiscreteScheduler"},{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": CLIPTextModelWithProjection"},{name:"tokenizer",val:": CLIPTokenizer"},{name:"text_encoder_2",val:": CLIPTextModelWithProjection"},{name:"tokenizer_2",val:": CLIPTokenizer"},{name:"text_encoder_3",val:": T5EncoderModel"},{name:"tokenizer_3",val:": T5TokenizerFast"},{name:"controlnet",val:": typing.Union[diffusers.models.controlnets.controlnet_sd3.SD3ControlNetModel, typing.List[diffusers.models.controlnets.controlnet_sd3.SD3ControlNetModel], typing.Tuple[diffusers.models.controlnets.controlnet_sd3.SD3ControlNetModel], diffusers.models.controlnets.controlnet_sd3.SD3MultiControlNetModel]"},{name:"image_encoder",val:": SiglipModel = None"},{name:"feature_extractor",val:": typing.Optional[transformers.models.siglip.image_processing_siglip.SiglipImageProcessor] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.transformer",description:`<strong>transformer</strong> (<a href="/docs/diffusers/main/en/api/models/sd3_transformer2d#diffusers.SD3Transformer2DModel">SD3Transformer2DModel</a>) &#x2014;
Conditional Transformer (MMDiT) architecture to denoise the encoded image latents.`,name:"transformer"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/main/en/api/schedulers/flow_match_euler_discrete#diffusers.FlowMatchEulerDiscreteScheduler">FlowMatchEulerDiscreteScheduler</a>) &#x2014;
A scheduler to be used in combination with <code>transformer</code> to denoise the encoded image latents.`,name:"scheduler"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/main/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) Model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.text_encoder",description:`<strong>text_encoder</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the <a href="https://huggingface.co/openai/clip-vit-large-patch14" rel="nofollow">clip-vit-large-patch14</a> variant,
with an additional added projection layer that is initialized with a diagonal matrix with the <code>hidden_size</code>
as its dimension.`,name:"text_encoder"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> (<code>CLIPTextModelWithProjection</code>) &#x2014;
<a href="https://huggingface.co/docs/transformers/model_doc/clip#transformers.CLIPTextModelWithProjection" rel="nofollow">CLIP</a>,
specifically the
<a href="https://huggingface.co/laion/CLIP-ViT-bigG-14-laion2B-39B-b160k" rel="nofollow">laion/CLIP-ViT-bigG-14-laion2B-39B-b160k</a>
variant.`,name:"text_encoder_2"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.text_encoder_3",description:`<strong>text_encoder_3</strong> (<code>T5EncoderModel</code>) &#x2014;
Frozen text-encoder. Stable Diffusion 3 uses
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/t5-v1_1-xxl" rel="nofollow">t5-v1_1-xxl</a> variant.`,name:"text_encoder_3"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.tokenizer",description:`<strong>tokenizer</strong> (<code>CLIPTokenizer</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> (<code>CLIPTokenizer</code>) &#x2014;
Second Tokenizer of class
<a href="https://huggingface.co/docs/transformers/v4.21.0/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a>.`,name:"tokenizer_2"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.tokenizer_3",description:`<strong>tokenizer_3</strong> (<code>T5TokenizerFast</code>) &#x2014;
Tokenizer of class
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5Tokenizer" rel="nofollow">T5Tokenizer</a>.`,name:"tokenizer_3"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.controlnet",description:`<strong>controlnet</strong> (<a href="/docs/diffusers/main/en/api/models/controlnet_sd3#diffusers.SD3ControlNetModel">SD3ControlNetModel</a> or <code>List[SD3ControlNetModel]</code> or <code>SD3MultiControlNetModel</code>) &#x2014;
Provides additional conditioning to the <code>transformer</code> during the denoising process. If you set multiple
ControlNets as a list, the outputs from each ControlNet are added together to create one combined
additional conditioning.`,name:"controlnet"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.image_encoder",description:`<strong>image_encoder</strong> (<code>PreTrainedModel</code>, <em>optional</em>) &#x2014;
Pre-trained Vision Model for IP Adapter.`,name:"image_encoder"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<code>BaseImageProcessor</code>, <em>optional</em>) &#x2014;
Image processor for IP Adapter.`,name:"feature_extractor"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet_inpainting.py#L164"}}),oe=new M({props:{name:"__call__",anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]] = None"},{name:"prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"height",val:": typing.Optional[int] = None"},{name:"width",val:": typing.Optional[int] = None"},{name:"num_inference_steps",val:": int = 28"},{name:"sigmas",val:": typing.Optional[typing.List[float]] = None"},{name:"guidance_scale",val:": float = 7.0"},{name:"control_guidance_start",val:": typing.Union[float, typing.List[float]] = 0.0"},{name:"control_guidance_end",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"control_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"control_mask",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]] = None"},{name:"controlnet_conditioning_scale",val:": typing.Union[float, typing.List[float]] = 1.0"},{name:"controlnet_pooled_projections",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"num_images_per_prompt",val:": typing.Optional[int] = 1"},{name:"generator",val:": typing.Union[torch._C.Generator, typing.List[torch._C.Generator], NoneType] = None"},{name:"latents",val:": typing.Optional[torch.FloatTensor] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"output_type",val:": typing.Optional[str] = 'pil'"},{name:"return_dict",val:": bool = True"},{name:"joint_attention_kwargs",val:": typing.Optional[typing.Dict[str, typing.Any]] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"callback_on_step_end",val:": typing.Optional[typing.Callable[[int, int, typing.Dict], NoneType]] = None"},{name:"callback_on_step_end_tensor_inputs",val:": typing.List[str] = ['latents']"},{name:"max_sequence_length",val:": int = 256"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide the image generation. If not defined, one has to pass <code>prompt_embeds</code>.
instead.`,name:"prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
will be used instead`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.height",description:`<strong>height</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The height in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"height"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.width",description:`<strong>width</strong> (<code>int</code>, <em>optional</em>, defaults to self.unet.config.sample_size * self.vae_scale_factor) &#x2014;
The width in pixels of the generated image. This is set to 1024 by default for the best results.`,name:"width"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 50) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality image at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.sigmas",description:`<strong>sigmas</strong> (<code>List[float]</code>, <em>optional</em>) &#x2014;
Custom sigmas to use for the denoising process with schedulers which support a <code>sigmas</code> argument in
their <code>set_timesteps</code> method. If not defined, the default behavior when <code>num_inference_steps</code> is passed
will be used.`,name:"sigmas"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 5.0) &#x2014;
Guidance scale as defined in <a href="https://huggingface.co/papers/2207.12598" rel="nofollow">Classifier-Free Diffusion
Guidance</a>. <code>guidance_scale</code> is defined as <code>w</code> of equation 2.
of <a href="https://huggingface.co/papers/2205.11487" rel="nofollow">Imagen Paper</a>. Guidance scale is enabled by setting
<code>guidance_scale &gt; 1</code>. Higher guidance scale encourages to generate images that are closely linked to
the text <code>prompt</code>, usually at the expense of lower image quality.`,name:"guidance_scale"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.control_guidance_start",description:`<strong>control_guidance_start</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 0.0) &#x2014;
The percentage of total steps at which the ControlNet starts applying.`,name:"control_guidance_start"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.control_guidance_end",description:`<strong>control_guidance_end</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The percentage of total steps at which the ControlNet stops applying.`,name:"control_guidance_end"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.control_image",description:`<strong>control_image</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to be inpainted (which parts of the image to
be masked out with <code>control_mask</code> and repainted according to <code>prompt</code>). For both numpy array and
pytorch tensor, the expected value range is between <code>[0, 1]</code> If it&#x2019;s a tensor or a list or tensors, the
expected shape should be <code>(B, C, H, W)</code>. If it is a numpy array or a list of arrays, the expected shape
should be <code>(B, H, W, C)</code> or <code>(H, W, C)</code>.`,name:"control_image"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.control_mask",description:`<strong>control_mask</strong> (<code>torch.Tensor</code>, <code>PIL.Image.Image</code>, <code>np.ndarray</code>, <code>List[torch.Tensor]</code>, <code>List[PIL.Image.Image]</code>, <code>List[np.ndarray]</code>) &#x2014;
<code>Image</code>, numpy array or tensor representing an image batch to mask <code>image</code>. White pixels in the mask
are repainted while black pixels are preserved. If <code>mask_image</code> is a PIL image, it is converted to a
single channel (luminance) before use. If it&#x2019;s a numpy array or pytorch tensor, it should contain one
color channel (L) instead of 3, so the expected shape for pytorch tensor would be <code>(B, 1, H, W)</code>. And
for numpy array would be for <code>(B, H, W, 1)</code>, <code>(B, H, W)</code>, <code>(H, W, 1)</code>, or <code>(H, W)</code>.`,name:"control_mask"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.controlnet_conditioning_scale",description:`<strong>controlnet_conditioning_scale</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to 1.0) &#x2014;
The outputs of the ControlNet are multiplied by <code>controlnet_conditioning_scale</code> before they are added
to the residual in the original <code>unet</code>. If multiple ControlNets are specified in <code>init</code>, you can set
the corresponding scale as a list.`,name:"controlnet_conditioning_scale"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.controlnet_pooled_projections",description:`<strong>controlnet_pooled_projections</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, projection_dim)</code>) &#x2014;
Embeddings projected from the embeddings of controlnet input conditions.`,name:"controlnet_pooled_projections"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used instead`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of images to generate per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
One or a list of <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow">torch generator(s)</a>
to make generation deterministic.`,name:"generator"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents, sampled from a Gaussian distribution, to be used as inputs for image
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor will ge generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
Optional image input to work with IP Adapters.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated image embeddings for IP-Adapter. Should be a tensor of shape <code>(batch_size, num_images, emb_dim)</code>. It should contain the negative image embedding if <code>do_classifier_free_guidance</code> is set to
<code>True</code>. If not provided, embeddings are computed from the <code>ip_adapter_image</code> input argument.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;pil&quot;</code>) &#x2014;
The output format of the generate image. Choose between
<a href="https://pillow.readthedocs.io/en/stable/" rel="nofollow">PIL</a>: <code>PIL.Image.Image</code> or <code>np.array</code>.`,name:"output_type"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> instead
of a plain tuple.`,name:"return_dict"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.joint_attention_kwargs",description:`<strong>joint_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined under
<code>self.processor</code> in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow">diffusers.models.attention_processor</a>.`,name:"joint_attention_kwargs"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.callback_on_step_end",description:`<strong>callback_on_step_end</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls at the end of each denoising steps during the inference. The function is called
with the following arguments: <code>callback_on_step_end(self: DiffusionPipeline, step: int, timestep: int, callback_kwargs: Dict)</code>. <code>callback_kwargs</code> will include a list of all tensors as specified by
<code>callback_on_step_end_tensor_inputs</code>.`,name:"callback_on_step_end"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.callback_on_step_end_tensor_inputs",description:`<strong>callback_on_step_end_tensor_inputs</strong> (<code>List</code>, <em>optional</em>) &#x2014;
The list of tensor inputs for the <code>callback_on_step_end</code> function. The tensors specified in the list
will be passed as <code>callback_kwargs</code> argument. You will only be able to include variables listed in the
<code>._callback_tensor_inputs</code> attribute of your pipeline class.`,name:"callback_on_step_end_tensor_inputs"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.max_sequence_length",description:"<strong>max_sequence_length</strong> (<code>int</code> defaults to 256) &#x2014; Maximum sequence length to use with the <code>prompt</code>.",name:"max_sequence_length"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet_inpainting.py#L868",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> if <code>return_dict</code> is True, otherwise a
<code>tuple</code>. When returning a tuple, the first element is a list with the generated images.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>~pipelines.stable_diffusion_xl.StableDiffusionXLPipelineOutput</code> or <code>tuple</code></p>
`}}),G=new kt({props:{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.__call__.example",$$slots:{default:[Rt]},$$scope:{ctx:$}}}),ie=new M({props:{name:"encode_image",anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_image",parameters:[{name:"image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor]]"},{name:"device",val:": device"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_image.image",description:`<strong>image</strong> (<code>PipelineImageInput</code>) &#x2014;
Input image to be encoded.`,name:"image"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_image.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
Torch device.`,name:"device"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet_inpainting.py#L791",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The encoded image feature representation.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>torch.Tensor</code></p>
`}}),ae=new M({props:{name:"encode_prompt",anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt",parameters:[{name:"prompt",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_2",val:": typing.Union[str, typing.List[str]]"},{name:"prompt_3",val:": typing.Union[str, typing.List[str]]"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"},{name:"negative_prompt",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_2",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"negative_prompt_3",val:": typing.Union[str, typing.List[str], NoneType] = None"},{name:"prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"negative_pooled_prompt_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"clip_skip",val:": typing.Optional[int] = None"},{name:"max_sequence_length",val:": int = 256"},{name:"lora_scale",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.prompt_2",description:`<strong>prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_2</code> and <code>text_encoder_2</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.prompt_3",description:`<strong>prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to be sent to the <code>tokenizer_3</code> and <code>text_encoder_3</code>. If not defined, <code>prompt</code> is
used in all text-encoders`,name:"prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>):
torch device`,name:"device"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>) &#x2014;
number of images that should be generated per prompt`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.negative_prompt_2",description:`<strong>negative_prompt_2</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_2</code> and
<code>text_encoder_2</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_2"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.negative_prompt_3",description:`<strong>negative_prompt_3</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the image generation to be sent to <code>tokenizer_3</code> and
<code>text_encoder_3</code>. If not defined, <code>negative_prompt</code> is used in all the text-encoders.`,name:"negative_prompt_3"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting. If not
provided, text embeddings will be generated from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, negative_prompt_embeds will be generated from <code>negative_prompt</code> input
argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.pooled_prompt_embeds",description:`<strong>pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt weighting.
If not provided, pooled text embeddings will be generated from <code>prompt</code> input argument.`,name:"pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.negative_pooled_prompt_embeds",description:`<strong>negative_pooled_prompt_embeds</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative pooled text embeddings. Can be used to easily tweak text inputs, <em>e.g.</em> prompt
weighting. If not provided, pooled negative_prompt_embeds will be generated from <code>negative_prompt</code>
input argument.`,name:"negative_pooled_prompt_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.clip_skip",description:`<strong>clip_skip</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Number of layers to be skipped from CLIP while computing the prompt embeddings. A value of 1 means that
the output of the pre-final layer will be used for computing the prompt embeddings.`,name:"clip_skip"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.encode_prompt.lora_scale",description:`<strong>lora_scale</strong> (<code>float</code>, <em>optional</em>) &#x2014;
A lora scale that will be applied to all LoRA layers of the text encoder if LoRA layers are loaded.`,name:"lora_scale"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet_inpainting.py#L382"}}),se=new M({props:{name:"prepare_ip_adapter_image_embeds",anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.prepare_ip_adapter_image_embeds",parameters:[{name:"ip_adapter_image",val:": typing.Union[PIL.Image.Image, numpy.ndarray, torch.Tensor, typing.List[PIL.Image.Image], typing.List[numpy.ndarray], typing.List[torch.Tensor], NoneType] = None"},{name:"ip_adapter_image_embeds",val:": typing.Optional[torch.Tensor] = None"},{name:"device",val:": typing.Optional[torch.device] = None"},{name:"num_images_per_prompt",val:": int = 1"},{name:"do_classifier_free_guidance",val:": bool = True"}],parametersDescription:[{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.prepare_ip_adapter_image_embeds.ip_adapter_image",description:`<strong>ip_adapter_image</strong> (<code>PipelineImageInput</code>, <em>optional</em>) &#x2014;
The input image to extract features from for IP-Adapter.`,name:"ip_adapter_image"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.prepare_ip_adapter_image_embeds.ip_adapter_image_embeds",description:`<strong>ip_adapter_image_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Precomputed image embeddings.`,name:"ip_adapter_image_embeds"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.prepare_ip_adapter_image_embeds.device",description:`<strong>device</strong> &#x2014; (<code>torch.device</code>, <em>optional</em>):
Torch device.`,name:"device"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.prepare_ip_adapter_image_embeds.num_images_per_prompt",description:`<strong>num_images_per_prompt</strong> (<code>int</code>, defaults to 1) &#x2014;
Number of images that should be generated per prompt.`,name:"num_images_per_prompt"},{anchor:"diffusers.StableDiffusion3ControlNetInpaintingPipeline.prepare_ip_adapter_image_embeds.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>, defaults to True) &#x2014;
Whether to use classifier free guidance or not.`,name:"do_classifier_free_guidance"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/controlnet_sd3/pipeline_stable_diffusion_3_controlnet_inpainting.py#L811"}}),re=new Ee({props:{title:"StableDiffusion3PipelineOutput",local:"diffusers.pipelines.stable_diffusion_3.pipeline_output.StableDiffusion3PipelineOutput",headingTag:"h2"}}),le=new M({props:{name:"class diffusers.pipelines.stable_diffusion_3.pipeline_output.StableDiffusion3PipelineOutput",anchor:"diffusers.pipelines.stable_diffusion_3.pipeline_output.StableDiffusion3PipelineOutput",parameters:[{name:"images",val:": typing.Union[typing.List[PIL.Image.Image], numpy.ndarray]"}],parametersDescription:[{anchor:"diffusers.pipelines.stable_diffusion_3.pipeline_output.StableDiffusion3PipelineOutput.images",description:`<strong>images</strong> (<code>List[PIL.Image.Image]</code> or <code>np.ndarray</code>) &#x2014;
List of denoised PIL images of length <code>batch_size</code> or numpy array of shape <code>(batch_size, height, width, num_channels)</code>. PIL images or numpy array present the denoised images of the diffusion pipeline.`,name:"images"}],source:"https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion_3/pipeline_output.py#L10"}}),de=new Zt({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/controlnet_sd3.md"}}),{c(){p=l("meta"),w=o(),m=l("p"),c=o(),g(v.$$.fragment),r=o(),T=l("div"),T.innerHTML=mt,Ne=o(),R=l("p"),R.textContent=gt,Pe=o(),X=l("p"),X.innerHTML=ft,Me=o(),B=l("p"),B.textContent=_t,De=o(),E=l("p"),E.textContent=ut,Se=o(),Q=l("p"),Q.innerHTML=ht,ke=o(),V=l("p"),V.innerHTML=bt,Le=o(),Y=l("table"),Y.innerHTML=yt,Ue=o(),g(W.$$.fragment),je=o(),g(A.$$.fragment),Je=o(),x=l("div"),g(H.$$.fragment),Qe=o(),D=l("div"),g(O.$$.fragment),Ve=o(),ce=l("p"),ce.textContent=vt,Ye=o(),g(z.$$.fragment),Ae=o(),Z=l("div"),g(q.$$.fragment),He=o(),me=l("p"),me.textContent=Tt,Oe=o(),ge=l("div"),g(K.$$.fragment),qe=o(),S=l("div"),g(ee.$$.fragment),Ke=o(),fe=l("p"),fe.textContent=xt,et=o(),_e=l("p"),_e.innerHTML=Ct,$e=o(),g(te.$$.fragment),We=o(),C=l("div"),g(ne.$$.fragment),tt=o(),k=l("div"),g(oe.$$.fragment),nt=o(),ue=l("p"),ue.textContent=It,ot=o(),g(G.$$.fragment),it=o(),F=l("div"),g(ie.$$.fragment),at=o(),he=l("p"),he.textContent=wt,st=o(),be=l("div"),g(ae.$$.fragment),rt=o(),L=l("div"),g(se.$$.fragment),lt=o(),ye=l("p"),ye.textContent=Nt,dt=o(),ve=l("p"),ve.innerHTML=Pt,ze=o(),g(re.$$.fragment),Ze=o(),j=l("div"),g(le.$$.fragment),pt=o(),Te=l("p"),Te.textContent=Mt,Ge=o(),g(de.$$.fragment),Fe=o(),we=l("p"),this.h()},l(e){const n=Wt("svelte-u9bgzb",document.head);p=d(n,"META",{name:!0,content:!0}),n.forEach(t),w=i(e),m=d(e,"P",{}),P(m).forEach(t),c=i(e),f(v.$$.fragment,e),r=i(e),T=d(e,"DIV",{class:!0,"data-svelte-h":!0}),y(T)!=="svelte-si9ct8"&&(T.innerHTML=mt),Ne=i(e),R=d(e,"P",{"data-svelte-h":!0}),y(R)!=="svelte-1rzqysx"&&(R.textContent=gt),Pe=i(e),X=d(e,"P",{"data-svelte-h":!0}),y(X)!=="svelte-1v2xz23"&&(X.innerHTML=ft),Me=i(e),B=d(e,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1dn0wji"&&(B.textContent=_t),De=i(e),E=d(e,"P",{"data-svelte-h":!0}),y(E)!=="svelte-1cwsb16"&&(E.textContent=ut),Se=i(e),Q=d(e,"P",{"data-svelte-h":!0}),y(Q)!=="svelte-fbiw6t"&&(Q.innerHTML=ht),ke=i(e),V=d(e,"P",{"data-svelte-h":!0}),y(V)!=="svelte-ngc2x1"&&(V.innerHTML=bt),Le=i(e),Y=d(e,"TABLE",{"data-svelte-h":!0}),y(Y)!=="svelte-ho40dk"&&(Y.innerHTML=yt),Ue=i(e),f(W.$$.fragment,e),je=i(e),f(A.$$.fragment,e),Je=i(e),x=d(e,"DIV",{class:!0});var N=P(x);f(H.$$.fragment,N),Qe=i(N),D=d(N,"DIV",{class:!0});var J=P(D);f(O.$$.fragment,J),Ve=i(J),ce=d(J,"P",{"data-svelte-h":!0}),y(ce)!=="svelte-v78lg8"&&(ce.textContent=vt),Ye=i(J),f(z.$$.fragment,J),J.forEach(t),Ae=i(N),Z=d(N,"DIV",{class:!0});var pe=P(Z);f(q.$$.fragment,pe),He=i(pe),me=d(pe,"P",{"data-svelte-h":!0}),y(me)!=="svelte-vi6ux7"&&(me.textContent=Tt),pe.forEach(t),Oe=i(N),ge=d(N,"DIV",{class:!0});var Dt=P(ge);f(K.$$.fragment,Dt),Dt.forEach(t),qe=i(N),S=d(N,"DIV",{class:!0});var xe=P(S);f(ee.$$.fragment,xe),Ke=i(xe),fe=d(xe,"P",{"data-svelte-h":!0}),y(fe)!=="svelte-fimzys"&&(fe.textContent=xt),et=i(xe),_e=d(xe,"P",{"data-svelte-h":!0}),y(_e)!=="svelte-gkgg1h"&&(_e.innerHTML=Ct),xe.forEach(t),N.forEach(t),$e=i(e),f(te.$$.fragment,e),We=i(e),C=d(e,"DIV",{class:!0});var U=P(C);f(ne.$$.fragment,U),tt=i(U),k=d(U,"DIV",{class:!0});var Ce=P(k);f(oe.$$.fragment,Ce),nt=i(Ce),ue=d(Ce,"P",{"data-svelte-h":!0}),y(ue)!=="svelte-v78lg8"&&(ue.textContent=It),ot=i(Ce),f(G.$$.fragment,Ce),Ce.forEach(t),it=i(U),F=d(U,"DIV",{class:!0});var Xe=P(F);f(ie.$$.fragment,Xe),at=i(Xe),he=d(Xe,"P",{"data-svelte-h":!0}),y(he)!=="svelte-vi6ux7"&&(he.textContent=wt),Xe.forEach(t),st=i(U),be=d(U,"DIV",{class:!0});var St=P(be);f(ae.$$.fragment,St),St.forEach(t),rt=i(U),L=d(U,"DIV",{class:!0});var Ie=P(L);f(se.$$.fragment,Ie),lt=i(Ie),ye=d(Ie,"P",{"data-svelte-h":!0}),y(ye)!=="svelte-fimzys"&&(ye.textContent=Nt),dt=i(Ie),ve=d(Ie,"P",{"data-svelte-h":!0}),y(ve)!=="svelte-gkgg1h"&&(ve.innerHTML=Pt),Ie.forEach(t),U.forEach(t),ze=i(e),f(re.$$.fragment,e),Ze=i(e),j=d(e,"DIV",{class:!0});var Be=P(j);f(le.$$.fragment,Be),pt=i(Be),Te=d(Be,"P",{"data-svelte-h":!0}),y(Te)!=="svelte-1qpjiuf"&&(Te.textContent=Mt),Be.forEach(t),Ge=i(e),f(de.$$.fragment,e),Fe=i(e),we=d(e,"P",{}),P(we).forEach(t),this.h()},h(){I(p,"name","hf:doc:metadata"),I(p,"content",Bt),I(T,"class","flex flex-wrap space-x-1"),I(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(L,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),I(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,n){a(document.head,p),s(e,w,n),s(e,m,n),s(e,c,n),_(v,e,n),s(e,r,n),s(e,T,n),s(e,Ne,n),s(e,R,n),s(e,Pe,n),s(e,X,n),s(e,Me,n),s(e,B,n),s(e,De,n),s(e,E,n),s(e,Se,n),s(e,Q,n),s(e,ke,n),s(e,V,n),s(e,Le,n),s(e,Y,n),s(e,Ue,n),_(W,e,n),s(e,je,n),_(A,e,n),s(e,Je,n),s(e,x,n),_(H,x,null),a(x,Qe),a(x,D),_(O,D,null),a(D,Ve),a(D,ce),a(D,Ye),_(z,D,null),a(x,Ae),a(x,Z),_(q,Z,null),a(Z,He),a(Z,me),a(x,Oe),a(x,ge),_(K,ge,null),a(x,qe),a(x,S),_(ee,S,null),a(S,Ke),a(S,fe),a(S,et),a(S,_e),s(e,$e,n),_(te,e,n),s(e,We,n),s(e,C,n),_(ne,C,null),a(C,tt),a(C,k),_(oe,k,null),a(k,nt),a(k,ue),a(k,ot),_(G,k,null),a(C,it),a(C,F),_(ie,F,null),a(F,at),a(F,he),a(C,st),a(C,be),_(ae,be,null),a(C,rt),a(C,L),_(se,L,null),a(L,lt),a(L,ye),a(L,dt),a(L,ve),s(e,ze,n),_(re,e,n),s(e,Ze,n),s(e,j,n),_(le,j,null),a(j,pt),a(j,Te),s(e,Ge,n),_(de,e,n),s(e,Fe,n),s(e,we,n),Re=!0},p(e,[n]){const N={};n&2&&(N.$$scope={dirty:n,ctx:e}),W.$set(N);const J={};n&2&&(J.$$scope={dirty:n,ctx:e}),z.$set(J);const pe={};n&2&&(pe.$$scope={dirty:n,ctx:e}),G.$set(pe)},i(e){Re||(u(v.$$.fragment,e),u(W.$$.fragment,e),u(A.$$.fragment,e),u(H.$$.fragment,e),u(O.$$.fragment,e),u(z.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(G.$$.fragment,e),u(ie.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(de.$$.fragment,e),Re=!0)},o(e){h(v.$$.fragment,e),h(W.$$.fragment,e),h(A.$$.fragment,e),h(H.$$.fragment,e),h(O.$$.fragment,e),h(z.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(oe.$$.fragment,e),h(G.$$.fragment,e),h(ie.$$.fragment,e),h(ae.$$.fragment,e),h(se.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(de.$$.fragment,e),Re=!1},d(e){e&&(t(w),t(m),t(c),t(r),t(T),t(Ne),t(R),t(Pe),t(X),t(Me),t(B),t(De),t(E),t(Se),t(Q),t(ke),t(V),t(Le),t(Y),t(Ue),t(je),t(Je),t(x),t($e),t(We),t(C),t(ze),t(Ze),t(j),t(Ge),t(Fe),t(we)),t(p),b(v,e),b(W,e),b(A,e),b(H),b(O),b(z),b(q),b(K),b(ee),b(te,e),b(ne),b(oe),b(G),b(ie),b(ae),b(se),b(re,e),b(le),b(de,e)}}}const Bt='{"title":"ControlNet with Stable Diffusion 3","local":"controlnet-with-stable-diffusion-3","sections":[{"title":"StableDiffusion3ControlNetPipeline","local":"diffusers.StableDiffusion3ControlNetPipeline","sections":[],"depth":2},{"title":"StableDiffusion3ControlNetInpaintingPipeline","local":"diffusers.StableDiffusion3ControlNetInpaintingPipeline","sections":[],"depth":2},{"title":"StableDiffusion3PipelineOutput","local":"diffusers.pipelines.stable_diffusion_3.pipeline_output.StableDiffusion3PipelineOutput","sections":[],"depth":2}],"depth":1}';function Et($){return jt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Kt extends Jt{constructor(p){super(),$t(this,p,Et,Xt,Ut,{})}}export{Kt as component};
