import{s as ta,f as sa,n as la,o as na}from"../chunks/scheduler.39a43cde.js";import{S as aa,i as ia,g as i,s as n,r as c,A as oa,h as o,f as s,c as a,j as ea,u as p,x as r,k as Bl,y as ra,a as l,v as m,d as h,t as M,w as u}from"../chunks/index.23ec2204.js";import{D as ca,C as d}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as y,E as pa}from"../chunks/EditOnGithub.f2d09226.js";function ma(Zl){let w,It,bt,gt,f,vt,T,$t,j,Wl='<em>Authored by:<a href="https://github.com/peremartra" rel="nofollow">Pere Martra</a></em>',xt,J,_l="In this notebook, we will explore a typical RAG solution where we will utilize an open-source model and the vector database Chroma DB. <strong>However, we will integrate a semantic cache system that will store various user queries and decide whether to generate the prompt enriched with information from the vector database or the cache.</strong>",Gt,U,Nl="A semantic caching system aims to identify similar or identical user requests. When a matching request is found, the system retrieves the corresponding information from the cache, reducing the need to fetch it from the original source.",kt,b,Rl="As the comparison takes into account the semantic meaning of the requests, they don’t have to be identical for the system to recognize them as the same question.  They can be formulated differently or contain inaccuracies, be they typographical or in the sentence structure, and we can identify that the user is actually requesting the same information.",At,C,Sl="For instance, queries like <strong>What is the capital of France?</strong>, <strong>Tell me the name of the capital of France?</strong>, and <strong>What The capital of France is?</strong> all convey the same intent and should be identified as the same question.",Bt,I,Vl="While the model’s response may differ based on the request for a concise answer in the second example, the information retrieved from the vector database should be the same. This is why I’m placing the cache system between the user and the vector database, not between the user and the Large Language Model.",Zt,Ut,zl,Wt,g,ql="Most tutorials that guide you through creating a RAG system are designed for single-user use, meant to operate in a testing environment. In other words, within a notebook, interacting with a local vector database and making API calls or using a locally stored model.",_t,v,El="This architecture quickly becomes insufficient when attempting to transition one of these models to production, where they might encounter from tens to thousands of recurrent requests.",Nt,$,Ql="One way to enhance performance is through one or multiple semantic caches. This cache retains the results of previous requests, and before resolving a new request, it checks if a similar one has been received before. If so, instead of re-executing the process, it retrieves the information from the cache.",Rt,x,Yl="In a RAG system, there are two points that are time consuming:",St,G,Hl="<li>Retrieve the information used to construct the enriched prompt:</li> <li>Call the Large Language Model to obtain the response.</li>",Vt,k,Xl="In both points, a semantic cache system can be implemented, and we could even have two caches, one for each point.",zt,A,Fl="Placing it at the model’s response point may lead to a loss of influence over the obtained response. Our cache system could consider “Explain the French Revolution in 10 words” and “Explain the French Revolution in a hundred words” as the same query. If our cache system stores model responses, users might think that their instructions are not being followed accurately.",qt,B,Ll="But both requests will require the same information to enrich the prompt. This is the main reason why I chose to place the semantic cache system between the user’s request and the retrieval of information from the vector database.",Et,Z,Pl="However, this is a design decision. Depending on the type of responses and system requests, it can be placed at one point or another. It’s evident that caching model responses would yield the most time savings, but as I’ve already explained, it comes at the cost of losing user influence over the response.",Qt,W,Yt,_,Dl="To start we need to install the necesary Python packages.",Ht,N,Kl='<li><strong><a href="http:/www.sbert.net/" rel="nofollow">sentence transformers</a></strong>. This library is necessary to transform the sentences into fixed-length vectors, also know as embeddings.</li> <li><strong><a href="https://github.com/facebookresearch/xformers" rel="nofollow">xformers</a></strong>. it’s a package that provides libraries an utilities to facilitate the work with transformers models. We need to install in order to avoid an error when we work with the model and embeddings.</li> <li><strong><a href="https://www.trychroma.com/" rel="nofollow">chromadb</a></strong>. This is our vector Database. ChromaDB is easy to use and open source, maybe the most used Vector Database used to store embeddings.</li> <li><strong><a href="https://github.com/huggingface/accelerate" rel="nofollow">accelerate</a></strong> Necesary to run the Model in a GPU.</li>',Xt,R,Ft,S,Lt,V,Pt,z,Ol="As we are working in a free and limited space, and we can use just a few GB of memory I limited the number of rows to use from the Dataset with the variable <code>MAX_ROWS</code>.",Dt,q,Kt,E,Ot,Q,en="ChromaDB requires that the data has a unique identifier. We can make it with this statement, which will create a new column called <strong>Id</strong>.",es,Y,ts,H,ss,X,ls,F,ns,L,tn="To store the information, I’ve chosen to use ChromaDB, one of the most well-known and widely used open-source vector databases.",as,P,sn="First we need to import ChromaDB.",is,D,os,K,ln="Now we only need to indicate the path where the vector database will be stored.",rs,O,cs,ee,ps,te,nn="The Data in ChromaDB is stored in collections. If the collection exist we need to delete it.",ms,se,an="In the next lines, we are creating the collection by calling the <code>create_collection</code> function in the <code>chroma_client</code> created above.",hs,le,Ms,ne,on="We are now ready to add the data to the collection using the <code>add</code> function. This function requires three key pieces of information:",us,ae,rn="<li>In the <strong>document</strong> we store the content of the <code>Answer</code> column in the Dataset.</li> <li>In <strong>metadatas</strong>, we can inform a list of topics. I used the value in the column <code>qtype</code>.</li> <li>In <strong>id</strong> we need to inform an unique identificator for each row. I’m creating the ID using the range of <code>MAX_ROWS</code>.</li>",ds,ie,ys,oe,cn="Once we have the information in the Database we can query it, and ask for data that matches our needs. The search is done inside the content of the document, and it dosn’t look for the exact word, or phrase. The results will be based on the similarity between the search terms and the content of documents.",ws,re,pn="Metadata isn’t directly involved in the initial search process, it can be used to filter or refine the results after retrieval, enabling further customization and precision.",fs,ce,mn="Let’s define a function to query the ChromaDB Database.",Ts,pe,js,me,Js,he,hn="To implement the cache system, we will use Faiss, a library that allows storing embeddings in memory. It’s quite similar to what Chroma does, but without its persistence.",Us,Me,Mn="For this purpose, we will create a class called <code>semantic_cache</code> that will work with its own encoder and provide the necessary functions for the user to perform queries.",bs,ue,un="In this class, we first query the cache implemented with Faiss, that contains the previous petitions, and if the returned results are above a specified threshold, it will return the content of the cache. Otherwise, it will fetch the result from the Chroma database.",Cs,de,dn="The cache is stored in a .json file.",Is,ye,gs,we,vs,fe,yn="The <code>init_cache()</code> function below initializes the semantic cache.",$s,Te,wn="It employs the FlatLS index, which might not be the fastest but is ideal for small datasets. Depending on the characteristics of the data intended for the cache and the expected dataset size, another index such as HNSW or IVF could be utilized.",xs,je,fn="I chose this index because it aligns well with the example. It can be used with vectors of high dimensions, consumes minimal memory, and performs well with small datasets.",Gs,Je,Tn="I outline the key features of the various indices available with Faiss.",ks,Ue,jn="<li>FlatL2 or FlatIP. Well-suited for small datasets, it may not be the fastest, but its memory consumption is not excessive.</li> <li>LSH. It works effectively with small datasets and is recommended for use with vectors of up to 128 dimensions.</li> <li>HNSW. Very fast but demands a substantial amount of RAM.</li> <li>IVF. Works well with large datasets without consuming much memory or compromising performance.</li>",As,be,Jn='More information about the different indices available with Faiss can be found at this link: <a href="https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index" rel="nofollow">https://github.com/facebookresearch/faiss/wiki/Guidelines-to-choose-an-index</a>',Bs,Ce,Zs,Ie,Un="In the <code>retrieve_cache</code> function, the .json file is retrieved from disk in case there is a need to reuse the cache across sessions.",Ws,ge,_s,ve,bn="The <code>store_cache</code> function saves the file containing the cache data to disk.",Ns,$e,Rs,xe,Cn="These functions will be used within the <code>SemanticCache</code> class, which includes the search function and its initialization function.",Ss,Ge,In="Even though the <code>ask</code> function has a substantial amount of code, its purpose is quite straightforward. It looks in the cache for the closest question to the one just made by the user.",Vs,ke,gn="Afterward, checks if it is within the specified threshold. If positive, it directly returns the response from the cache; otherwise, it calls the <code>query_database</code> function to retrieve the data from ChromaDB.",zs,Ae,vn="I’ve used Euclidean distance instead of Cosine, which is widely employed in vector comparisons. This choice is based on the fact that Euclidean distance is the default metric used by Faiss. Although Cosine distance can also be calculated, doing so adds complexity that may not significantly contribute to the final result.",qs,Be,Es,Ze,Qs,We,Ys,_e,$n=`Index trained
`,Hs,Ne,Xs,Re,xn=`Answer recovered from ChromaDB. 
response_text: Summary : Shots may hurt a little, but the diseases they can prevent are a lot worse. Some are even life-threatening. Immunization shots, or vaccinations, are essential. They protect against things like measles, mumps, rubella, hepatitis B, polio, tetanus, diphtheria, and pertussis (whooping cough). Immunizations are important for adults as well as children.    Your immune system helps your body fight germs by producing substances to combat them. Once it does, the immune system "remembers" the germ and can fight it again. Vaccines contain germs that have been killed or weakened. When given to a healthy person, the vaccine triggers the immune system to respond and thus build immunity.     Before vaccines, people became immune only by actually getting a disease and surviving it. Immunizations are an easier and less risky way to become immune.     NIH: National Institute of Allergy and Infectious Diseases
Time taken: 0.057 seconds
`,Fs,Se,Gn="As expected, this response has been obtained from ChromaDB. The class then stores it in the cache.",Ls,Ve,kn="Now, if we send a second question that is quite different, the response should also be retrieved from ChromaDB. This is because the question stored previously is so dissimilar that it would surpass the specified threshold in terms of Euclidean distance.",Ps,ze,Ds,qe,An=`Answer recovered from ChromaDB. 
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.082 seconds
`,Ks,Ee,Bn="Perfect, the semantic cache system is behaving as expected.",Os,Qe,Zn="Let’s proceed to test it with a question very similar to the one we just asked.",el,Ye,Wn="In this case, the response should come directly from the cache without the need to access the ChromaDB database.",tl,He,sl,Xe,_n=`Answer recovered from Cache. 
0.028 smaller than 0.35
Found cache in row: 1 with score 0.028
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.019 seconds
`,ll,Fe,Nn="The two questions are so similar that their Euclidean distance is truly minimal, almost as if they were identical.",nl,Le,Rn="Now, let’s try another question, this time a bit more distinct, and observe how the system behaves.",al,Pe,il,De,Sn=`Answer recovered from Cache. 
0.228 smaller than 0.35
Found cache in row: 1 with score 0.228
response_text: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.
Time taken: 0.016 seconds
`,ol,Ke,Vn="We observe that the Euclidean distance has increased, but it still remains within the specified threshold. Therefore, it continues to return the response directly from the cache.",rl,Oe,cl,et,zn='Time to use the library <strong>transformers</strong>, the most famous library from <a href="https://huggingface.co/" rel="nofollow">hugging face</a> for working with language models.',pl,tt,qn="We are importing:",ml,st,En='<li><strong>Autotokenizer</strong>: It is a utility class for tokenizing text inputs that are compatible with various pre-trained language models.</li> <li><strong>AutoModelForCausalLM</strong>: it provides an interface to pre-trained language models specifically designed for language generation tasks using causal language modeling (e.g., GPT models), or the model used in this notebook <a href="https://huggingface.co/google/gemma-2b-it" rel="nofollow">Gemma-2b-it</a>.</li>',hl,lt,Qn='Please, feel free to test <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;sort=trending" rel="nofollow">different Models</a>, you need to search for NLP models trained for text-generation.',Ml,nt,ul,at,dl,it,yl,ot,wl,rt,Yn="To create the prompt we use the result from query the ‘semantic_cache’ class  and the question introduced by the user.",fl,ct,Hn="The prompt have two parts, the <strong>relevant context</strong> that is the information recovered from the database and the <strong>user’s question</strong>.",Tl,pt,Xn="We only need to put the two parts together to create the prompt then send it to the model.",jl,mt,Jl,ht,Ul,Mt,Fn="Now all that remains is to send the prompt to the model and wait for its response!",bl,ut,Cl,dt,Ln=`<bos>Relevant context: Sydenham chorea (SD) is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS), the bacterium that causes rheumatic fever. SD is characterized by rapid, irregular, and aimless involuntary movements of the arms and legs, trunk, and facial muscles. It affects girls more often than boys and typically occurs between 5 and 15 years of age. Some children will have a sore throat several weeks before the symptoms begin, but the disorder can also strike up to 6 months after the fever or infection has cleared. Symptoms can appear gradually or all at once, and also may include uncoordinated movements, muscular weakness, stumbling and falling, slurred speech, difficulty concentrating and writing, and emotional instability. The symptoms of SD can vary from a halting gait and slight grimacing to involuntary movements that are frequent and severe enough to be incapacitating. The random, writhing movements of chorea are caused by an auto-immune reaction to the bacterium that interferes with the normal function of a part of the brain (the basal ganglia) that controls motor movements. Due to better sanitary conditions and the use of antibiotics to treat streptococcal infections, rheumatic fever, and consequently SD, are rare in North America and Europe. The disease can still be found in developing nations.

 The user&#39;s question: Write in 20 words what is a Sydenham chorea.

Sure, here is a 20-word answer:

Sydenham chorea is a neurological disorder of childhood resulting from infection via Group A beta-hemolytic streptococcus (GABHS).<eos>
</eos></bos>`,Il,yt,gl,wt,Pn="There’s a 50% reduction in data retrieval time between accessing ChromaDB and going directly to the cache. However, in larger projects, this difference increases, leading to enhancements of 90-95%.",vl,ft,Dn="We have very few data in Chroma, and only a single instance of the cache class. Typically, the data behind the cache system is much larger, possibly involving more than just a query to a vector database but sourced from various places.",$l,Tt,Kn="It’s common to have multiple instances of the cache class, usually based on user typology, as questions tend to repeat more among users who share common traits.",xl,jt,On="In summary, we have created a very simple RAG (Retrieval-Augmented Generation) system and enhanced it with a semantic cache layer between the user’s question and obtaining the information necessary to create the enriched prompt.",Gl,Jt,kl,Ct,Al;return f=new ca({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/semantic_cache_chroma_vector_database.ipynb"}]}}),T=new y({props:{title:"Implementing semantic cache to improve a RAG system with FAISS.",local:"implementing-semantic-cache-to-improve-a-rag-system-with-faiss",headingTag:"h1"}}),W=new y({props:{title:"Import and load the libraries.",local:"import-and-load-the-libraries",headingTag:"h1"}}),R=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMHRyYW5zZm9ybWVycyUzRCUzRDQuMzguMSUwQSFwaXAlMjBpbnN0YWxsJTIwLXElMjBhY2NlbGVyYXRlJTNEJTNEMC4yNy4yJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUzRCUzRDIuNS4xJTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMHhmb3JtZXJzJTNEJTNEMC4wLjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGNocm9tYWRiJTNEJTNEMC40LjI0JTBBIXBpcCUyMGluc3RhbGwlMjAtcSUyMGRhdGFzZXRzJTNEJTNEMi4xNy4x",highlighted:`!pip install -q transformers==<span class="hljs-number">4.38</span><span class="hljs-number">.1</span>
!pip install -q accelerate==<span class="hljs-number">0.27</span><span class="hljs-number">.2</span>
!pip install -q sentence-transformers==<span class="hljs-number">2.5</span><span class="hljs-number">.1</span>
!pip install -q xformers==<span class="hljs-number">0.0</span><span class="hljs-number">.24</span>
!pip install -q chromadb==<span class="hljs-number">0.4</span><span class="hljs-number">.24</span>
!pip install -q datasets==<span class="hljs-number">2.17</span><span class="hljs-number">.1</span>`,wrap:!1}}),S=new d({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZA==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd`,wrap:!1}}),V=new y({props:{title:"Load the Dataset",local:"load-the-dataset",headingTag:"h1"}}),q=new d({props:{code:"JTIzTG9naW4lMjB0byUyMEh1Z2dpbmclMjBGYWNlLiUyMEl0JTIwaXMlMjBtYW5kYXRvcnklMjB0byUyMHVzZSUyMHRoZSUyMEdlbW1hJTIwTW9kZWwlMkMlMEElMjNhbmQlMjByZWNvbW1lbmRlZCUyMHRvJTIwYWNjZXMlMjBwdWJsaWMlMjBtb2RlbHMlMjBhbmQlMjBEYXRhc2V0cy4lMEFmcm9tJTIwZ2V0cGFzcyUyMGltcG9ydCUyMGdldHBhc3MlMEFpZiUyMCdoZl9rZXknJTIwbm90JTIwaW4lMjBsb2NhbHMoKSUzQSUwQSUyMCUyMGhmX2tleSUyMCUzRCUyMGdldHBhc3MoJTIyWW91ciUyMEh1Z2dpbmclMjBGYWNlJTIwQVBJJTIwS2V5JTNBJTIwJTIyKSUwQSFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUyMC0tdG9rZW4lMjAlMjRoZl9rZXk=",highlighted:`<span class="hljs-comment">#Login to Hugging Face. It is mandatory to use the Gemma Model,</span>
<span class="hljs-comment">#and recommended to acces public models and Datasets.</span>
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">if</span> <span class="hljs-string">&#x27;hf_key&#x27;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">locals</span>():
  hf_key = getpass(<span class="hljs-string">&quot;Your Hugging Face API Key: &quot;</span>)
!huggingface-cli login --token $hf_key`,wrap:!1}}),E=new d({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YSUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJrZWl2YWx5YSUyRk1lZFF1YWQtTWVkaWNhbFFuQURhdGFzZXQlMjIlMkMlMjBzcGxpdCUzRCUyMnRyYWluJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

data = load_dataset(<span class="hljs-string">&quot;keivalya/MedQuad-MedicalQnADataset&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),Y=new d({props:{code:"ZGF0YSUyMCUzRCUyMGRhdGEudG9fcGFuZGFzKCklMEFkYXRhJTVCJTIyaWQlMjIlNUQlMjAlM0QlMjBkYXRhLmluZGV4JTBBZGF0YS5oZWFkKDEwKQ==",highlighted:`data = data.to_pandas()
data[<span class="hljs-string">&quot;id&quot;</span>] = data.index
data.head(<span class="hljs-number">10</span>)`,wrap:!1}}),H=new d({props:{code:"TUFYX1JPV1MlMjAlM0QlMjAxNTAwMCUwQURPQ1VNRU5UJTIwJTNEJTIwJTIyQW5zd2VyJTIyJTBBVE9QSUMlMjAlM0QlMjAlMjJxdHlwZSUyMg==",highlighted:`MAX_ROWS = <span class="hljs-number">15000</span>
DOCUMENT = <span class="hljs-string">&quot;Answer&quot;</span>
TOPIC = <span class="hljs-string">&quot;qtype&quot;</span>`,wrap:!1}}),X=new d({props:{code:"JTIzJTIwQmVjYXVzZSUyMGl0JTIwaXMlMjBqdXN0JTIwYSUyMHNhbXBsZSUyMHdlJTIwc2VsZWN0JTIwYSUyMHNtYWxsJTIwcG9ydGlvbiUyMG9mJTIwTmV3cy4lMEFzdWJzZXRfZGF0YSUyMCUzRCUyMGRhdGEuaGVhZChNQVhfUk9XUyk=",highlighted:`<span class="hljs-comment"># Because it is just a sample we select a small portion of News.</span>
subset_data = data.head(MAX_ROWS)`,wrap:!1}}),F=new y({props:{title:"Import and configure the Vector Database",local:"import-and-configure-the-vector-database",headingTag:"h1"}}),D=new d({props:{code:"aW1wb3J0JTIwY2hyb21hZGI=",highlighted:'<span class="hljs-keyword">import</span> chromadb',wrap:!1}}),O=new d({props:{code:"Y2hyb21hX2NsaWVudCUyMCUzRCUyMGNocm9tYWRiLlBlcnNpc3RlbnRDbGllbnQocGF0aCUzRCUyMiUyRnBhdGglMkZ0byUyRnBlcnNpc3QlMkZkaXJlY3RvcnklMjIp",highlighted:'chroma_client = chromadb.PersistentClient(path=<span class="hljs-string">&quot;/path/to/persist/directory&quot;</span>)',wrap:!1}}),ee=new y({props:{title:"Filling and Querying the ChromaDB Database",local:"filling-and-querying-the-chromadb-database",headingTag:"h1"}}),le=new d({props:{code:"Y29sbGVjdGlvbl9uYW1lJTIwJTNEJTIwJTIybmV3c19jb2xsZWN0aW9uJTIyJTBBaWYlMjBsZW4oY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCkpJTIwJTNFJTIwMCUyMGFuZCUyMGNvbGxlY3Rpb25fbmFtZSUyMGluJTIwJTVCY2hyb21hX2NsaWVudC5saXN0X2NvbGxlY3Rpb25zKCklNUIwJTVELm5hbWUlNUQlM0ElMEElMjAlMjAlMjAlMjBjaHJvbWFfY2xpZW50LmRlbGV0ZV9jb2xsZWN0aW9uKG5hbWUlM0Rjb2xsZWN0aW9uX25hbWUpJTBBJTBBY29sbGVjdGlvbiUyMCUzRCUyMGNocm9tYV9jbGllbnQuY3JlYXRlX2NvbGxlY3Rpb24obmFtZSUzRGNvbGxlY3Rpb25fbmFtZSk=",highlighted:`collection_name = <span class="hljs-string">&quot;news_collection&quot;</span>
<span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(chroma_client.list_collections()) &gt; <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> collection_name <span class="hljs-keyword">in</span> [chroma_client.list_collections()[<span class="hljs-number">0</span>].name]:
    chroma_client.delete_collection(name=collection_name)

collection = chroma_client.create_collection(name=collection_name)`,wrap:!1}}),ie=new d({props:{code:"Y29sbGVjdGlvbi5hZGQoJTBBJTIwJTIwJTIwJTIwZG9jdW1lbnRzJTNEc3Vic2V0X2RhdGElNUJET0NVTUVOVCU1RC50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMG1ldGFkYXRhcyUzRCU1QiU3QlRPUElDJTNBJTIwdG9waWMlN0QlMjBmb3IlMjB0b3BpYyUyMGluJTIwc3Vic2V0X2RhdGElNUJUT1BJQyU1RC50b2xpc3QoKSU1RCUyQyUwQSUyMCUyMCUyMCUyMGlkcyUzRCU1QmYlMjJpZCU3QnglN0QlMjIlMjBmb3IlMjB4JTIwaW4lMjByYW5nZShNQVhfUk9XUyklNUQlMkMlMEEp",highlighted:`collection.add(
    documents=subset_data[DOCUMENT].tolist(),
    metadatas=[{TOPIC: topic} <span class="hljs-keyword">for</span> topic <span class="hljs-keyword">in</span> subset_data[TOPIC].tolist()],
    ids=[<span class="hljs-string">f&quot;id<span class="hljs-subst">{x}</span>&quot;</span> <span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(MAX_ROWS)],
)`,wrap:!1}}),pe=new d({props:{code:"ZGVmJTIwcXVlcnlfZGF0YWJhc2UocXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRDEwKSUzQSUwQSUyMCUyMCUyMCUyMHJlc3VsdHMlMjAlM0QlMjBjb2xsZWN0aW9uLnF1ZXJ5KHF1ZXJ5X3RleHRzJTNEcXVlcnlfdGV4dCUyQyUyMG5fcmVzdWx0cyUzRG5fcmVzdWx0cyklMEElMjAlMjAlMjAlMjByZXR1cm4lMjByZXN1bHRz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">query_database</span>(<span class="hljs-params">query_text, n_results=<span class="hljs-number">10</span></span>):
    results = collection.query(query_texts=query_text, n_results=n_results)
    <span class="hljs-keyword">return</span> results`,wrap:!1}}),me=new y({props:{title:"Creating the semantic cache system",local:"creating-the-semantic-cache-system",headingTag:"h2"}}),ye=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGZhaXNzLWNwdSUzRCUzRDEuOC4w",highlighted:'!pip install -q faiss-cpu==<span class="hljs-number">1.8</span><span class="hljs-number">.0</span>',wrap:!1}}),we=new d({props:{code:"aW1wb3J0JTIwZmFpc3MlMEFmcm9tJTIwc2VudGVuY2VfdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwU2VudGVuY2VUcmFuc2Zvcm1lciUwQWltcG9ydCUyMHRpbWUlMEFpbXBvcnQlMjBqc29u",highlighted:`<span class="hljs-keyword">import</span> faiss
<span class="hljs-keyword">from</span> sentence_transformers <span class="hljs-keyword">import</span> SentenceTransformer
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> json`,wrap:!1}}),Ce=new d({props:{code:"ZGVmJTIwaW5pdF9jYWNoZSgpJTNBJTBBJTIwJTIwJTIwJTIwaW5kZXglMjAlM0QlMjBmYWlzcy5JbmRleEZsYXRMMig3NjgpJTBBJTIwJTIwJTIwJTIwaWYlMjBpbmRleC5pc190cmFpbmVkJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTIySW5kZXglMjB0cmFpbmVkJTIyKSUwQSUwQSUyMCUyMCUyMCUyMCUyMyUyMEluaXRpYWxpemUlMjBTZW50ZW5jZSUyMFRyYW5zZm9ybWVyJTIwbW9kZWwlMEElMjAlMjAlMjAlMjBlbmNvZGVyJTIwJTNEJTIwU2VudGVuY2VUcmFuc2Zvcm1lciglMjJhbGwtbXBuZXQtYmFzZS12MiUyMiklMEElMEElMjAlMjAlMjAlMjByZXR1cm4lMjBpbmRleCUyQyUyMGVuY29kZXI=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">init_cache</span>():
    index = faiss.IndexFlatL2(<span class="hljs-number">768</span>)
    <span class="hljs-keyword">if</span> index.is_trained:
        <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Index trained&quot;</span>)

    <span class="hljs-comment"># Initialize Sentence Transformer model</span>
    encoder = SentenceTransformer(<span class="hljs-string">&quot;all-mpnet-base-v2&quot;</span>)

    <span class="hljs-keyword">return</span> index, encoder`,wrap:!1}}),ge=new d({props:{code:"ZGVmJTIwcmV0cmlldmVfY2FjaGUoanNvbl9maWxlKSUzQSUwQSUyMCUyMCUyMCUyMHRyeSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHdpdGglMjBvcGVuKGpzb25fZmlsZSUyQyUyMCUyMnIlMjIpJTIwYXMlMjBmaWxlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY2FjaGUlMjAlM0QlMjBqc29uLmxvYWQoZmlsZSklMEElMjAlMjAlMjAlMjBleGNlcHQlMjBGaWxlTm90Rm91bmRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGNhY2hlJTIwJTNEJTIwJTdCJTIycXVlc3Rpb25zJTIyJTNBJTIwJTVCJTVEJTJDJTIwJTIyZW1iZWRkaW5ncyUyMiUzQSUyMCU1QiU1RCUyQyUyMCUyMmFuc3dlcnMlMjIlM0ElMjAlNUIlNUQlMkMlMjAlMjJyZXNwb25zZV90ZXh0JTIyJTNBJTIwJTVCJTVEJTdEJTBBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwY2FjaGU=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">retrieve_cache</span>(<span class="hljs-params">json_file</span>):
    <span class="hljs-keyword">try</span>:
        <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> file:
            cache = json.load(file)
    <span class="hljs-keyword">except</span> FileNotFoundError:
        cache = {<span class="hljs-string">&quot;questions&quot;</span>: [], <span class="hljs-string">&quot;embeddings&quot;</span>: [], <span class="hljs-string">&quot;answers&quot;</span>: [], <span class="hljs-string">&quot;response_text&quot;</span>: []}

    <span class="hljs-keyword">return</span> cache`,wrap:!1}}),$e=new d({props:{code:"ZGVmJTIwc3RvcmVfY2FjaGUoanNvbl9maWxlJTJDJTIwY2FjaGUpJTNBJTBBJTIwJTIwJTIwJTIwd2l0aCUyMG9wZW4oanNvbl9maWxlJTJDJTIwJTIydyUyMiklMjBhcyUyMGZpbGUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uLmR1bXAoY2FjaGUlMkMlMjBmaWxlKQ==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">store_cache</span>(<span class="hljs-params">json_file, cache</span>):
    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(json_file, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> file:
        json.dump(cache, file)`,wrap:!1}}),Be=new d({props:{code:"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",highlighted:`<span class="hljs-keyword">class</span> <span class="hljs-title class_">semantic_cache</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, json_file=<span class="hljs-string">&quot;cache_file.json&quot;</span>, thresold=<span class="hljs-number">0.35</span></span>):
        <span class="hljs-comment"># Initialize Faiss index with Euclidean distance</span>
        self.index, self.encoder = init_cache()

        <span class="hljs-comment"># Set Euclidean distance threshold</span>
        <span class="hljs-comment"># a distance of 0 means identicals sentences</span>
        <span class="hljs-comment"># We only return from cache sentences under this thresold</span>
        self.euclidean_threshold = thresold

        self.json_file = json_file
        self.cache = retrieve_cache(self.json_file)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">ask</span>(<span class="hljs-params">self, question: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-comment"># Method to retrieve an answer from the cache or generate a new one</span>
        start_time = time.time()
        <span class="hljs-keyword">try</span>:
            <span class="hljs-comment"># First we obtain the embeddings corresponding to the user question</span>
            embedding = self.encoder.encode([question])

            <span class="hljs-comment"># Search for the nearest neighbor in the index</span>
            self.index.nprobe = <span class="hljs-number">8</span>
            D, I = self.index.search(embedding, <span class="hljs-number">1</span>)

            <span class="hljs-keyword">if</span> D[<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span>:
                <span class="hljs-keyword">if</span> I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &gt;= <span class="hljs-number">0</span> <span class="hljs-keyword">and</span> D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>] &lt;= self.euclidean_threshold:
                    row_id = <span class="hljs-built_in">int</span>(I[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>])

                    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer recovered from Cache. &quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span> smaller than <span class="hljs-subst">{self.euclidean_threshold}</span>&quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Found cache in row: <span class="hljs-subst">{row_id}</span> with score <span class="hljs-subst">{D[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]:<span class="hljs-number">.3</span>f}</span>&quot;</span>)
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;response_text: &quot;</span> + self.cache[<span class="hljs-string">&quot;response_text&quot;</span>][row_id])

                    end_time = time.time()
                    elapsed_time = end_time - start_time
                    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)
                    <span class="hljs-keyword">return</span> self.cache[<span class="hljs-string">&quot;response_text&quot;</span>][row_id]

            <span class="hljs-comment"># Handle the case when there are not enough results</span>
            <span class="hljs-comment"># or Euclidean distance is not met, asking to chromaDB.</span>
            answer = query_database([question], <span class="hljs-number">1</span>)
            response_text = answer[<span class="hljs-string">&quot;documents&quot;</span>][<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]

            self.cache[<span class="hljs-string">&quot;questions&quot;</span>].append(question)
            self.cache[<span class="hljs-string">&quot;embeddings&quot;</span>].append(embedding[<span class="hljs-number">0</span>].tolist())
            self.cache[<span class="hljs-string">&quot;answers&quot;</span>].append(answer)
            self.cache[<span class="hljs-string">&quot;response_text&quot;</span>].append(response_text)

            <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Answer recovered from ChromaDB. &quot;</span>)
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;response_text: <span class="hljs-subst">{response_text}</span>&quot;</span>)

            self.index.add(embedding)
            store_cache(self.json_file, self.cache)
            end_time = time.time()
            elapsed_time = end_time - start_time
            <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time taken: <span class="hljs-subst">{elapsed_time:<span class="hljs-number">.3</span>f}</span> seconds&quot;</span>)

            <span class="hljs-keyword">return</span> response_text
        <span class="hljs-keyword">except</span> Exception <span class="hljs-keyword">as</span> e:
            <span class="hljs-keyword">raise</span> RuntimeError(<span class="hljs-string">f&quot;Error during &#x27;ask&#x27; method: <span class="hljs-subst">{e}</span>&quot;</span>)`,wrap:!1}}),Ze=new y({props:{title:"Testing the semantic_cache class.",local:"testing-the-semanticcache-class",headingTag:"h3"}}),We=new d({props:{code:"JTIzJTIwSW5pdGlhbGl6ZSUyMHRoZSUyMGNhY2hlLiUwQWNhY2hlJTIwJTNEJTIwc2VtYW50aWNfY2FjaGUoJTIyNGNhY2hlLmpzb24lMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initialize the cache.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>cache = semantic_cache(<span class="hljs-string">&quot;4cache.json&quot;</span>)`,wrap:!1}}),Ne=new d({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJIb3clMjBkbyUyMHZhY2NpbmVzJTIwd29yayUzRiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;How do vaccines work?&quot;</span>)',wrap:!1}}),ze=new d({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJFeHBsYWluJTIwYnJpZWZseSUyMHdoYXQlMjBpcyUyMGElMjBTeWRlbmhhbSUyMGNob3JlYSUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Explain briefly what is a Sydenham chorea&quot;</span>)',wrap:!1}}),He=new d({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayglMjJCcmllZmx5JTIwZXhwbGFpbiUyMG1lJTIwd2hhdCUyMGlzJTIwYSUyMFN5ZGVuaGFtJTIwY2hvcmVhLiUyMik=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(<span class="hljs-string">&quot;Briefly explain me what is a Sydenham chorea.&quot;</span>)',wrap:!1}}),Pe=new d({props:{code:"cXVlc3Rpb25fZGVmJTIwJTNEJTIwJTIyV3JpdGUlMjBpbiUyMDIwJTIwd29yZHMlMjB3aGF0JTIwaXMlMjBhJTIwU3lkZW5oYW0lMjBjaG9yZWEuJTIyJTBBcmVzdWx0cyUyMCUzRCUyMGNhY2hlLmFzayhxdWVzdGlvbl9kZWYp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>question_def = <span class="hljs-string">&quot;Write in 20 words what is a Sydenham chorea.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>results = cache.ask(question_def)`,wrap:!1}}),Oe=new y({props:{title:"Loading the model and creating the prompt",local:"loading-the-model-and-creating-the-prompt",headingTag:"h1"}}),nt=new d({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0b3JjaA==",highlighted:"!pip install torch",wrap:!1}}),at=new d({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwY3VkYSUyQyUyMHRvcmNoJTBBJTBBJTIzJTIwSW4lMjBhJTIwTUFDJTIwU2lsaWNvbiUyMHRoZSUyMGRldmljZSUyMG11c3QlMjBiZSUyMCdtcHMnJTBBJTIzJTIwZGV2aWNlJTIwJTNEJTIwdG9yY2guZGV2aWNlKCdtcHMnKSUyMCUyM3RvJTIwdXNlJTIwd2l0aCUyME1BQyUyMFNpbGljb24lMEFkZXZpY2UlMjAlM0QlMjBmJTIyY3VkYSUzQSU3QmN1ZGEuY3VycmVudF9kZXZpY2UoKSU3RCUyMiUyMGlmJTIwY3VkYS5pc19hdmFpbGFibGUoKSUyMGVsc2UlMjAlMjJjcHUlMjI=",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> cuda, torch

<span class="hljs-comment"># In a MAC Silicon the device must be &#x27;mps&#x27;</span>
<span class="hljs-comment"># device = torch.device(&#x27;mps&#x27;) #to use with MAC Silicon</span>
device = <span class="hljs-string">f&quot;cuda:<span class="hljs-subst">{cuda.current_device()}</span>&quot;</span> <span class="hljs-keyword">if</span> cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&quot;cpu&quot;</span>`,wrap:!1}}),it=new d({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTSUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZ2VtbWEtMmItaXQlMjIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCklMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMGRldmljZV9tYXAlM0QlMjJjdWRhJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, AutoModelForCausalLM

model_id = <span class="hljs-string">&quot;google/gemma-2b-it&quot;</span>
tokenizer = AutoTokenizer.from_pretrained(model_id)
model = AutoModelForCausalLM.from_pretrained(model_id, device_map=<span class="hljs-string">&quot;cuda&quot;</span>, torch_dtype=torch.bfloat16)`,wrap:!1}}),ot=new y({props:{title:"Creating the extended prompt",local:"creating-the-extended-prompt",headingTag:"h2"}}),mt=new d({props:{code:"cHJvbXB0X3RlbXBsYXRlJTIwJTNEJTIwZiUyMlJlbGV2YW50JTIwY29udGV4dCUzQSUyMCU3QnJlc3VsdHMlN0QlNUNuJTVDbiUyMFRoZSUyMHVzZXIncyUyMHF1ZXN0aW9uJTNBJTIwJTdCcXVlc3Rpb25fZGVmJTdEJTIyJTBBcHJvbXB0X3RlbXBsYXRl",highlighted:`prompt_template = <span class="hljs-string">f&quot;Relevant context: <span class="hljs-subst">{results}</span>\\n\\n The user&#x27;s question: <span class="hljs-subst">{question_def}</span>&quot;</span>
prompt_template`,wrap:!1}}),ht=new d({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdF90ZW1wbGF0ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnRvKCUyMmN1ZGElMjIp",highlighted:'input_ids = tokenizer(prompt_template, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),ut=new d({props:{code:"b3V0cHV0cyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRfaWRzJTJDJTIwbWF4X25ld190b2tlbnMlM0QyNTYpJTBBcHJpbnQodG9rZW5pemVyLmRlY29kZShvdXRwdXRzJTVCMCU1RCkp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model.generate(**input_ids, max_new_tokens=<span class="hljs-number">256</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(tokenizer.decode(outputs[<span class="hljs-number">0</span>]))`,wrap:!1}}),yt=new y({props:{title:"Conclusion.",local:"conclusion",headingTag:"h1"}}),Jt=new pa({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/semantic_cache_chroma_vector_database.md"}}),{c(){w=i("meta"),It=n(),bt=i("p"),gt=n(),c(f.$$.fragment),vt=n(),c(T.$$.fragment),$t=n(),j=i("p"),j.innerHTML=Wl,xt=n(),J=i("p"),J.innerHTML=_l,Gt=n(),U=i("p"),U.textContent=Nl,kt=n(),b=i("p"),b.textContent=Rl,At=n(),C=i("p"),C.innerHTML=Sl,Bt=n(),I=i("p"),I.textContent=Vl,Zt=n(),Ut=i("img"),Wt=n(),g=i("p"),g.textContent=ql,_t=n(),v=i("p"),v.textContent=El,Nt=n(),$=i("p"),$.textContent=Ql,Rt=n(),x=i("p"),x.textContent=Yl,St=n(),G=i("ul"),G.innerHTML=Hl,Vt=n(),k=i("p"),k.textContent=Xl,zt=n(),A=i("p"),A.textContent=Fl,qt=n(),B=i("p"),B.textContent=Ll,Et=n(),Z=i("p"),Z.textContent=Pl,Qt=n(),c(W.$$.fragment),Yt=n(),_=i("p"),_.textContent=Dl,Ht=n(),N=i("ul"),N.innerHTML=Kl,Xt=n(),c(R.$$.fragment),Ft=n(),c(S.$$.fragment),Lt=n(),c(V.$$.fragment),Pt=n(),z=i("p"),z.innerHTML=Ol,Dt=n(),c(q.$$.fragment),Kt=n(),c(E.$$.fragment),Ot=n(),Q=i("p"),Q.innerHTML=en,es=n(),c(Y.$$.fragment),ts=n(),c(H.$$.fragment),ss=n(),c(X.$$.fragment),ls=n(),c(F.$$.fragment),ns=n(),L=i("p"),L.textContent=tn,as=n(),P=i("p"),P.textContent=sn,is=n(),c(D.$$.fragment),os=n(),K=i("p"),K.textContent=ln,rs=n(),c(O.$$.fragment),cs=n(),c(ee.$$.fragment),ps=n(),te=i("p"),te.textContent=nn,ms=n(),se=i("p"),se.innerHTML=an,hs=n(),c(le.$$.fragment),Ms=n(),ne=i("p"),ne.innerHTML=on,us=n(),ae=i("ul"),ae.innerHTML=rn,ds=n(),c(ie.$$.fragment),ys=n(),oe=i("p"),oe.textContent=cn,ws=n(),re=i("p"),re.textContent=pn,fs=n(),ce=i("p"),ce.textContent=mn,Ts=n(),c(pe.$$.fragment),js=n(),c(me.$$.fragment),Js=n(),he=i("p"),he.textContent=hn,Us=n(),Me=i("p"),Me.innerHTML=Mn,bs=n(),ue=i("p"),ue.textContent=un,Cs=n(),de=i("p"),de.textContent=dn,Is=n(),c(ye.$$.fragment),gs=n(),c(we.$$.fragment),vs=n(),fe=i("p"),fe.innerHTML=yn,$s=n(),Te=i("p"),Te.textContent=wn,xs=n(),je=i("p"),je.textContent=fn,Gs=n(),Je=i("p"),Je.textContent=Tn,ks=n(),Ue=i("ul"),Ue.innerHTML=jn,As=n(),be=i("p"),be.innerHTML=Jn,Bs=n(),c(Ce.$$.fragment),Zs=n(),Ie=i("p"),Ie.innerHTML=Un,Ws=n(),c(ge.$$.fragment),_s=n(),ve=i("p"),ve.innerHTML=bn,Ns=n(),c($e.$$.fragment),Rs=n(),xe=i("p"),xe.innerHTML=Cn,Ss=n(),Ge=i("p"),Ge.innerHTML=In,Vs=n(),ke=i("p"),ke.innerHTML=gn,zs=n(),Ae=i("p"),Ae.textContent=vn,qs=n(),c(Be.$$.fragment),Es=n(),c(Ze.$$.fragment),Qs=n(),c(We.$$.fragment),Ys=n(),_e=i("pre"),_e.textContent=$n,Hs=n(),c(Ne.$$.fragment),Xs=n(),Re=i("pre"),Re.textContent=xn,Fs=n(),Se=i("p"),Se.textContent=Gn,Ls=n(),Ve=i("p"),Ve.textContent=kn,Ps=n(),c(ze.$$.fragment),Ds=n(),qe=i("pre"),qe.textContent=An,Ks=n(),Ee=i("p"),Ee.textContent=Bn,Os=n(),Qe=i("p"),Qe.textContent=Zn,el=n(),Ye=i("p"),Ye.textContent=Wn,tl=n(),c(He.$$.fragment),sl=n(),Xe=i("pre"),Xe.textContent=_n,ll=n(),Fe=i("p"),Fe.textContent=Nn,nl=n(),Le=i("p"),Le.textContent=Rn,al=n(),c(Pe.$$.fragment),il=n(),De=i("pre"),De.textContent=Sn,ol=n(),Ke=i("p"),Ke.textContent=Vn,rl=n(),c(Oe.$$.fragment),cl=n(),et=i("p"),et.innerHTML=zn,pl=n(),tt=i("p"),tt.textContent=qn,ml=n(),st=i("ul"),st.innerHTML=En,hl=n(),lt=i("p"),lt.innerHTML=Qn,Ml=n(),c(nt.$$.fragment),ul=n(),c(at.$$.fragment),dl=n(),c(it.$$.fragment),yl=n(),c(ot.$$.fragment),wl=n(),rt=i("p"),rt.textContent=Yn,fl=n(),ct=i("p"),ct.innerHTML=Hn,Tl=n(),pt=i("p"),pt.textContent=Xn,jl=n(),c(mt.$$.fragment),Jl=n(),c(ht.$$.fragment),Ul=n(),Mt=i("p"),Mt.textContent=Fn,bl=n(),c(ut.$$.fragment),Cl=n(),dt=i("pre"),dt.innerHTML=Ln,Il=n(),c(yt.$$.fragment),gl=n(),wt=i("p"),wt.textContent=Pn,vl=n(),ft=i("p"),ft.textContent=Dn,$l=n(),Tt=i("p"),Tt.textContent=Kn,xl=n(),jt=i("p"),jt.textContent=On,Gl=n(),c(Jt.$$.fragment),kl=n(),Ct=i("p"),this.h()},l(e){const t=oa("svelte-u9bgzb",document.head);w=o(t,"META",{name:!0,content:!0}),t.forEach(s),It=a(e),bt=o(e,"P",{}),ea(bt).forEach(s),gt=a(e),p(f.$$.fragment,e),vt=a(e),p(T.$$.fragment,e),$t=a(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-ighhqz"&&(j.innerHTML=Wl),xt=a(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-ydrdum"&&(J.innerHTML=_l),Gt=a(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1ci1eds"&&(U.textContent=Nl),kt=a(e),b=o(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-5pgs5c"&&(b.textContent=Rl),At=a(e),C=o(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-1dk0w68"&&(C.innerHTML=Sl),Bt=a(e),I=o(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-cppufu"&&(I.textContent=Vl),Zt=a(e),Ut=o(e,"IMG",{src:!0}),Wt=a(e),g=o(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1uya4d0"&&(g.textContent=ql),_t=a(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1y3an9l"&&(v.textContent=El),Nt=a(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-17nn2tu"&&($.textContent=Ql),Rt=a(e),x=o(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-1g6n4rl"&&(x.textContent=Yl),St=a(e),G=o(e,"UL",{"data-svelte-h":!0}),r(G)!=="svelte-4taq2a"&&(G.innerHTML=Hl),Vt=a(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-hn5gp7"&&(k.textContent=Xl),zt=a(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-j8wl7v"&&(A.textContent=Fl),qt=a(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1ssmgpb"&&(B.textContent=Ll),Et=a(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-h63eiv"&&(Z.textContent=Pl),Qt=a(e),p(W.$$.fragment,e),Yt=a(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1ejfgk5"&&(_.textContent=Dl),Ht=a(e),N=o(e,"UL",{"data-svelte-h":!0}),r(N)!=="svelte-lid6ym"&&(N.innerHTML=Kl),Xt=a(e),p(R.$$.fragment,e),Ft=a(e),p(S.$$.fragment,e),Lt=a(e),p(V.$$.fragment,e),Pt=a(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-mfr2mw"&&(z.innerHTML=Ol),Dt=a(e),p(q.$$.fragment,e),Kt=a(e),p(E.$$.fragment,e),Ot=a(e),Q=o(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1sfl7nk"&&(Q.innerHTML=en),es=a(e),p(Y.$$.fragment,e),ts=a(e),p(H.$$.fragment,e),ss=a(e),p(X.$$.fragment,e),ls=a(e),p(F.$$.fragment,e),ns=a(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-185gao8"&&(L.textContent=tn),as=a(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-e6nnzy"&&(P.textContent=sn),is=a(e),p(D.$$.fragment,e),os=a(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-18dzsym"&&(K.textContent=ln),rs=a(e),p(O.$$.fragment,e),cs=a(e),p(ee.$$.fragment,e),ps=a(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-1t01wav"&&(te.textContent=nn),ms=a(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-j98tvi"&&(se.innerHTML=an),hs=a(e),p(le.$$.fragment,e),Ms=a(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1r056o8"&&(ne.innerHTML=on),us=a(e),ae=o(e,"UL",{"data-svelte-h":!0}),r(ae)!=="svelte-1tnbgvc"&&(ae.innerHTML=rn),ds=a(e),p(ie.$$.fragment,e),ys=a(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-im901f"&&(oe.textContent=cn),ws=a(e),re=o(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-1jamuql"&&(re.textContent=pn),fs=a(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-18zgdsy"&&(ce.textContent=mn),Ts=a(e),p(pe.$$.fragment,e),js=a(e),p(me.$$.fragment,e),Js=a(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-xnkl8w"&&(he.textContent=hn),Us=a(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1aurt77"&&(Me.innerHTML=Mn),bs=a(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1yzpy08"&&(ue.textContent=un),Cs=a(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-o1h7a"&&(de.textContent=dn),Is=a(e),p(ye.$$.fragment,e),gs=a(e),p(we.$$.fragment,e),vs=a(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-185bjpp"&&(fe.innerHTML=yn),$s=a(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-6ni6w3"&&(Te.textContent=wn),xs=a(e),je=o(e,"P",{"data-svelte-h":!0}),r(je)!=="svelte-1suwwfe"&&(je.textContent=fn),Gs=a(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-a1a2e1"&&(Je.textContent=Tn),ks=a(e),Ue=o(e,"UL",{"data-svelte-h":!0}),r(Ue)!=="svelte-1sr1vnc"&&(Ue.innerHTML=jn),As=a(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-dbx09b"&&(be.innerHTML=Jn),Bs=a(e),p(Ce.$$.fragment,e),Zs=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-1x7rcj0"&&(Ie.innerHTML=Un),Ws=a(e),p(ge.$$.fragment,e),_s=a(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-1tajk60"&&(ve.innerHTML=bn),Ns=a(e),p($e.$$.fragment,e),Rs=a(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-p9izsn"&&(xe.innerHTML=Cn),Ss=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-ist138"&&(Ge.innerHTML=In),Vs=a(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-11wavvk"&&(ke.innerHTML=gn),zs=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-113m94f"&&(Ae.textContent=vn),qs=a(e),p(Be.$$.fragment,e),Es=a(e),p(Ze.$$.fragment,e),Qs=a(e),p(We.$$.fragment,e),Ys=a(e),_e=o(e,"PRE",{"data-svelte-h":!0}),r(_e)!=="svelte-mqrnyt"&&(_e.textContent=$n),Hs=a(e),p(Ne.$$.fragment,e),Xs=a(e),Re=o(e,"PRE",{"data-svelte-h":!0}),r(Re)!=="svelte-ick26y"&&(Re.textContent=xn),Fs=a(e),Se=o(e,"P",{"data-svelte-h":!0}),r(Se)!=="svelte-wmkk7m"&&(Se.textContent=Gn),Ls=a(e),Ve=o(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1t94ag6"&&(Ve.textContent=kn),Ps=a(e),p(ze.$$.fragment,e),Ds=a(e),qe=o(e,"PRE",{"data-svelte-h":!0}),r(qe)!=="svelte-we3tc3"&&(qe.textContent=An),Ks=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-fu67dr"&&(Ee.textContent=Bn),Os=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-11he3hz"&&(Qe.textContent=Zn),el=a(e),Ye=o(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-wkh4v1"&&(Ye.textContent=Wn),tl=a(e),p(He.$$.fragment,e),sl=a(e),Xe=o(e,"PRE",{"data-svelte-h":!0}),r(Xe)!=="svelte-zuw07a"&&(Xe.textContent=_n),ll=a(e),Fe=o(e,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-9995rt"&&(Fe.textContent=Nn),nl=a(e),Le=o(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1u7ud9q"&&(Le.textContent=Rn),al=a(e),p(Pe.$$.fragment,e),il=a(e),De=o(e,"PRE",{"data-svelte-h":!0}),r(De)!=="svelte-158wm6z"&&(De.textContent=Sn),ol=a(e),Ke=o(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-qcml34"&&(Ke.textContent=Vn),rl=a(e),p(Oe.$$.fragment,e),cl=a(e),et=o(e,"P",{"data-svelte-h":!0}),r(et)!=="svelte-1fxal5n"&&(et.innerHTML=zn),pl=a(e),tt=o(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-165ddml"&&(tt.textContent=qn),ml=a(e),st=o(e,"UL",{"data-svelte-h":!0}),r(st)!=="svelte-mhvp7d"&&(st.innerHTML=En),hl=a(e),lt=o(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-i89iqv"&&(lt.innerHTML=Qn),Ml=a(e),p(nt.$$.fragment,e),ul=a(e),p(at.$$.fragment,e),dl=a(e),p(it.$$.fragment,e),yl=a(e),p(ot.$$.fragment,e),wl=a(e),rt=o(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-15c3jn4"&&(rt.textContent=Yn),fl=a(e),ct=o(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-3bfxya"&&(ct.innerHTML=Hn),Tl=a(e),pt=o(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-nl1n48"&&(pt.textContent=Xn),jl=a(e),p(mt.$$.fragment,e),Jl=a(e),p(ht.$$.fragment,e),Ul=a(e),Mt=o(e,"P",{"data-svelte-h":!0}),r(Mt)!=="svelte-1qfx2ub"&&(Mt.textContent=Fn),bl=a(e),p(ut.$$.fragment,e),Cl=a(e),dt=o(e,"PRE",{"data-svelte-h":!0}),r(dt)!=="svelte-1uv406t"&&(dt.innerHTML=Ln),Il=a(e),p(yt.$$.fragment,e),gl=a(e),wt=o(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-8m24ut"&&(wt.textContent=Pn),vl=a(e),ft=o(e,"P",{"data-svelte-h":!0}),r(ft)!=="svelte-rknvvb"&&(ft.textContent=Dn),$l=a(e),Tt=o(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-wq8jse"&&(Tt.textContent=Kn),xl=a(e),jt=o(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-11y4pel"&&(jt.textContent=On),Gl=a(e),p(Jt.$$.fragment,e),kl=a(e),Ct=o(e,"P",{}),ea(Ct).forEach(s),this.h()},h(){Bl(w,"name","hf:doc:metadata"),Bl(w,"content",ha),sa(Ut.src,zl="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/semantic_cache.jpg")||Bl(Ut,"src",zl)},m(e,t){ra(document.head,w),l(e,It,t),l(e,bt,t),l(e,gt,t),m(f,e,t),l(e,vt,t),m(T,e,t),l(e,$t,t),l(e,j,t),l(e,xt,t),l(e,J,t),l(e,Gt,t),l(e,U,t),l(e,kt,t),l(e,b,t),l(e,At,t),l(e,C,t),l(e,Bt,t),l(e,I,t),l(e,Zt,t),l(e,Ut,t),l(e,Wt,t),l(e,g,t),l(e,_t,t),l(e,v,t),l(e,Nt,t),l(e,$,t),l(e,Rt,t),l(e,x,t),l(e,St,t),l(e,G,t),l(e,Vt,t),l(e,k,t),l(e,zt,t),l(e,A,t),l(e,qt,t),l(e,B,t),l(e,Et,t),l(e,Z,t),l(e,Qt,t),m(W,e,t),l(e,Yt,t),l(e,_,t),l(e,Ht,t),l(e,N,t),l(e,Xt,t),m(R,e,t),l(e,Ft,t),m(S,e,t),l(e,Lt,t),m(V,e,t),l(e,Pt,t),l(e,z,t),l(e,Dt,t),m(q,e,t),l(e,Kt,t),m(E,e,t),l(e,Ot,t),l(e,Q,t),l(e,es,t),m(Y,e,t),l(e,ts,t),m(H,e,t),l(e,ss,t),m(X,e,t),l(e,ls,t),m(F,e,t),l(e,ns,t),l(e,L,t),l(e,as,t),l(e,P,t),l(e,is,t),m(D,e,t),l(e,os,t),l(e,K,t),l(e,rs,t),m(O,e,t),l(e,cs,t),m(ee,e,t),l(e,ps,t),l(e,te,t),l(e,ms,t),l(e,se,t),l(e,hs,t),m(le,e,t),l(e,Ms,t),l(e,ne,t),l(e,us,t),l(e,ae,t),l(e,ds,t),m(ie,e,t),l(e,ys,t),l(e,oe,t),l(e,ws,t),l(e,re,t),l(e,fs,t),l(e,ce,t),l(e,Ts,t),m(pe,e,t),l(e,js,t),m(me,e,t),l(e,Js,t),l(e,he,t),l(e,Us,t),l(e,Me,t),l(e,bs,t),l(e,ue,t),l(e,Cs,t),l(e,de,t),l(e,Is,t),m(ye,e,t),l(e,gs,t),m(we,e,t),l(e,vs,t),l(e,fe,t),l(e,$s,t),l(e,Te,t),l(e,xs,t),l(e,je,t),l(e,Gs,t),l(e,Je,t),l(e,ks,t),l(e,Ue,t),l(e,As,t),l(e,be,t),l(e,Bs,t),m(Ce,e,t),l(e,Zs,t),l(e,Ie,t),l(e,Ws,t),m(ge,e,t),l(e,_s,t),l(e,ve,t),l(e,Ns,t),m($e,e,t),l(e,Rs,t),l(e,xe,t),l(e,Ss,t),l(e,Ge,t),l(e,Vs,t),l(e,ke,t),l(e,zs,t),l(e,Ae,t),l(e,qs,t),m(Be,e,t),l(e,Es,t),m(Ze,e,t),l(e,Qs,t),m(We,e,t),l(e,Ys,t),l(e,_e,t),l(e,Hs,t),m(Ne,e,t),l(e,Xs,t),l(e,Re,t),l(e,Fs,t),l(e,Se,t),l(e,Ls,t),l(e,Ve,t),l(e,Ps,t),m(ze,e,t),l(e,Ds,t),l(e,qe,t),l(e,Ks,t),l(e,Ee,t),l(e,Os,t),l(e,Qe,t),l(e,el,t),l(e,Ye,t),l(e,tl,t),m(He,e,t),l(e,sl,t),l(e,Xe,t),l(e,ll,t),l(e,Fe,t),l(e,nl,t),l(e,Le,t),l(e,al,t),m(Pe,e,t),l(e,il,t),l(e,De,t),l(e,ol,t),l(e,Ke,t),l(e,rl,t),m(Oe,e,t),l(e,cl,t),l(e,et,t),l(e,pl,t),l(e,tt,t),l(e,ml,t),l(e,st,t),l(e,hl,t),l(e,lt,t),l(e,Ml,t),m(nt,e,t),l(e,ul,t),m(at,e,t),l(e,dl,t),m(it,e,t),l(e,yl,t),m(ot,e,t),l(e,wl,t),l(e,rt,t),l(e,fl,t),l(e,ct,t),l(e,Tl,t),l(e,pt,t),l(e,jl,t),m(mt,e,t),l(e,Jl,t),m(ht,e,t),l(e,Ul,t),l(e,Mt,t),l(e,bl,t),m(ut,e,t),l(e,Cl,t),l(e,dt,t),l(e,Il,t),m(yt,e,t),l(e,gl,t),l(e,wt,t),l(e,vl,t),l(e,ft,t),l(e,$l,t),l(e,Tt,t),l(e,xl,t),l(e,jt,t),l(e,Gl,t),m(Jt,e,t),l(e,kl,t),l(e,Ct,t),Al=!0},p:la,i(e){Al||(h(f.$$.fragment,e),h(T.$$.fragment,e),h(W.$$.fragment,e),h(R.$$.fragment,e),h(S.$$.fragment,e),h(V.$$.fragment,e),h(q.$$.fragment,e),h(E.$$.fragment,e),h(Y.$$.fragment,e),h(H.$$.fragment,e),h(X.$$.fragment,e),h(F.$$.fragment,e),h(D.$$.fragment,e),h(O.$$.fragment,e),h(ee.$$.fragment,e),h(le.$$.fragment,e),h(ie.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ye.$$.fragment,e),h(we.$$.fragment,e),h(Ce.$$.fragment,e),h(ge.$$.fragment,e),h($e.$$.fragment,e),h(Be.$$.fragment,e),h(Ze.$$.fragment,e),h(We.$$.fragment,e),h(Ne.$$.fragment,e),h(ze.$$.fragment,e),h(He.$$.fragment,e),h(Pe.$$.fragment,e),h(Oe.$$.fragment,e),h(nt.$$.fragment,e),h(at.$$.fragment,e),h(it.$$.fragment,e),h(ot.$$.fragment,e),h(mt.$$.fragment,e),h(ht.$$.fragment,e),h(ut.$$.fragment,e),h(yt.$$.fragment,e),h(Jt.$$.fragment,e),Al=!0)},o(e){M(f.$$.fragment,e),M(T.$$.fragment,e),M(W.$$.fragment,e),M(R.$$.fragment,e),M(S.$$.fragment,e),M(V.$$.fragment,e),M(q.$$.fragment,e),M(E.$$.fragment,e),M(Y.$$.fragment,e),M(H.$$.fragment,e),M(X.$$.fragment,e),M(F.$$.fragment,e),M(D.$$.fragment,e),M(O.$$.fragment,e),M(ee.$$.fragment,e),M(le.$$.fragment,e),M(ie.$$.fragment,e),M(pe.$$.fragment,e),M(me.$$.fragment,e),M(ye.$$.fragment,e),M(we.$$.fragment,e),M(Ce.$$.fragment,e),M(ge.$$.fragment,e),M($e.$$.fragment,e),M(Be.$$.fragment,e),M(Ze.$$.fragment,e),M(We.$$.fragment,e),M(Ne.$$.fragment,e),M(ze.$$.fragment,e),M(He.$$.fragment,e),M(Pe.$$.fragment,e),M(Oe.$$.fragment,e),M(nt.$$.fragment,e),M(at.$$.fragment,e),M(it.$$.fragment,e),M(ot.$$.fragment,e),M(mt.$$.fragment,e),M(ht.$$.fragment,e),M(ut.$$.fragment,e),M(yt.$$.fragment,e),M(Jt.$$.fragment,e),Al=!1},d(e){e&&(s(It),s(bt),s(gt),s(vt),s($t),s(j),s(xt),s(J),s(Gt),s(U),s(kt),s(b),s(At),s(C),s(Bt),s(I),s(Zt),s(Ut),s(Wt),s(g),s(_t),s(v),s(Nt),s($),s(Rt),s(x),s(St),s(G),s(Vt),s(k),s(zt),s(A),s(qt),s(B),s(Et),s(Z),s(Qt),s(Yt),s(_),s(Ht),s(N),s(Xt),s(Ft),s(Lt),s(Pt),s(z),s(Dt),s(Kt),s(Ot),s(Q),s(es),s(ts),s(ss),s(ls),s(ns),s(L),s(as),s(P),s(is),s(os),s(K),s(rs),s(cs),s(ps),s(te),s(ms),s(se),s(hs),s(Ms),s(ne),s(us),s(ae),s(ds),s(ys),s(oe),s(ws),s(re),s(fs),s(ce),s(Ts),s(js),s(Js),s(he),s(Us),s(Me),s(bs),s(ue),s(Cs),s(de),s(Is),s(gs),s(vs),s(fe),s($s),s(Te),s(xs),s(je),s(Gs),s(Je),s(ks),s(Ue),s(As),s(be),s(Bs),s(Zs),s(Ie),s(Ws),s(_s),s(ve),s(Ns),s(Rs),s(xe),s(Ss),s(Ge),s(Vs),s(ke),s(zs),s(Ae),s(qs),s(Es),s(Qs),s(Ys),s(_e),s(Hs),s(Xs),s(Re),s(Fs),s(Se),s(Ls),s(Ve),s(Ps),s(Ds),s(qe),s(Ks),s(Ee),s(Os),s(Qe),s(el),s(Ye),s(tl),s(sl),s(Xe),s(ll),s(Fe),s(nl),s(Le),s(al),s(il),s(De),s(ol),s(Ke),s(rl),s(cl),s(et),s(pl),s(tt),s(ml),s(st),s(hl),s(lt),s(Ml),s(ul),s(dl),s(yl),s(wl),s(rt),s(fl),s(ct),s(Tl),s(pt),s(jl),s(Jl),s(Ul),s(Mt),s(bl),s(Cl),s(dt),s(Il),s(gl),s(wt),s(vl),s(ft),s($l),s(Tt),s(xl),s(jt),s(Gl),s(kl),s(Ct)),s(w),u(f,e),u(T,e),u(W,e),u(R,e),u(S,e),u(V,e),u(q,e),u(E,e),u(Y,e),u(H,e),u(X,e),u(F,e),u(D,e),u(O,e),u(ee,e),u(le,e),u(ie,e),u(pe,e),u(me,e),u(ye,e),u(we,e),u(Ce,e),u(ge,e),u($e,e),u(Be,e),u(Ze,e),u(We,e),u(Ne,e),u(ze,e),u(He,e),u(Pe,e),u(Oe,e),u(nt,e),u(at,e),u(it,e),u(ot,e),u(mt,e),u(ht,e),u(ut,e),u(yt,e),u(Jt,e)}}}const ha='{"title":"Implementing semantic cache to improve a RAG system with FAISS.","local":"implementing-semantic-cache-to-improve-a-rag-system-with-faiss","sections":[],"depth":1}';function Ma(Zl){return na(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fa extends aa{constructor(w){super(),ia(this,w,Ma,ma,ta,{})}}export{fa as component};
