import{s as $l,o as Al,n as tl}from"../chunks/scheduler.9039eef2.js";import{S as Xl,i as zl,g as o,s as n,r as M,A as vl,h as p,f as t,c as i,j as Wl,u as d,x as T,k as al,y as Cl,a,v as w,d as y,t as h,w as u}from"../chunks/index.cdcc3d35.js";import{T as ll}from"../chunks/Tip.6f74db41.js";import{C as B}from"../chunks/CodeBlock.e3ac94d9.js";import{H as X}from"../chunks/Heading.96ce3702.js";function Rl(I){let s,b="All the example scripts provided in the optimum-neuron repo have those features implemented via the <code>NeuronTrainer</code>.";return{c(){s=o("p"),s.innerHTML=b},l(m){s=p(m,"P",{"data-svelte-h":!0}),T(s)!=="svelte-18pumv8"&&(s.innerHTML=b)},m(m,J){a(m,s,J)},p:tl,d(m){m&&t(s)}}}function Gl(I){let s,b=`Since the example scripts use the <code>NeuronTrainer</code>, you can enable ZeRO-1 when using them by add the <code>--zero_1</code> flag
to your command line.`,m,J,j="For example:",f,c,_;return c=new B({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGbGFuZ3VhZ2UtbW9kZWxpbmclMkZydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYwLjYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmYxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0temVyb18xJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkYlMEE=",highlighted:`torchrun --nproc_per_node=2 examples/language-modeling/run_clm.py \\
    --model_name_or_path TinyLlama/TinyLlama-1.1B-Chat-v0.6 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --zero_1 \\
    --output_dir my_training/
`,wrap:!1}}),{c(){s=o("p"),s.innerHTML=b,m=n(),J=o("p"),J.textContent=j,f=n(),M(c.$$.fragment)},l(r){s=p(r,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1971m31"&&(s.innerHTML=b),m=i(r),J=p(r,"P",{"data-svelte-h":!0}),T(J)!=="svelte-1gkqha7"&&(J.textContent=j),f=i(r),d(c.$$.fragment,r)},m(r,U){a(r,s,U),a(r,m,U),a(r,J,U),a(r,f,U),w(c,r,U),_=!0},p:tl,i(r){_||(y(c.$$.fragment,r),_=!0)},o(r){h(c.$$.fragment,r),_=!1},d(r){r&&(t(s),t(m),t(J),t(f)),u(c,r)}}}function Zl(I){let s,b=`Since the example scripts use the <code>NeuronTrainer</code>, you can enable Tensor Parallelism when using them by specifying the <code>--tensor_parallel_size</code> argument, and optionally the <code>disable_embedding_parallelization</code> and <code>disable_sequence_parallel</code> flags.
to your command line.`,m,J,j="For example:",f,c,_;return c=new B({props:{code:"dG9yY2hydW4lMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMGV4YW1wbGVzJTJGbGFuZ3VhZ2UtbW9kZWxpbmclMkZydW5fY2xtLnB5JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tb2RlbF9uYW1lX29yX3BhdGglMjBUaW55TGxhbWElMkZUaW55TGxhbWEtMS4xQi1DaGF0LXYwLjYlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRhdGFzZXRfbmFtZSUyMHdpa2l0ZXh0JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1kYXRhc2V0X2NvbmZpZ19uYW1lJTIwd2lraXRleHQtMi1yYXctdjElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlMjAxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1ibG9ja19zaXplJTIwMTAyNCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tYmYxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdGVuc29yX3BhcmFsbGVsX3NpemUlMjAyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1vdXRwdXRfZGlyJTIwbXlfdHJhaW5pbmclMkY=",highlighted:`torchrun --nproc_per_node=2 examples/language-modeling/run_clm.py \\
    --model_name_or_path TinyLlama/TinyLlama-1.1B-Chat-v0.6 \\
    --dataset_name wikitext \\
    --dataset_config_name wikitext-2-raw-v1 \\
    --do_train \\
    --per_device_train_batch_size 1 \\
    --block_size 1024 \\
    --bf16 \\
    --tensor_parallel_size 2 \\
    --output_dir my_training/`,wrap:!1}}),{c(){s=o("p"),s.innerHTML=b,m=n(),J=o("p"),J.textContent=j,f=n(),M(c.$$.fragment)},l(r){s=p(r,"P",{"data-svelte-h":!0}),T(s)!=="svelte-ar8hdp"&&(s.innerHTML=b),m=i(r),J=p(r,"P",{"data-svelte-h":!0}),T(J)!=="svelte-1gkqha7"&&(J.textContent=j),f=i(r),d(c.$$.fragment,r)},m(r,U){a(r,s,U),a(r,m,U),a(r,J,U),a(r,f,U),w(c,r,U),_=!0},p:tl,i(r){_||(y(c.$$.fragment,r),_=!0)},o(r){h(c.$$.fragment,r),_=!1},d(r){r&&(t(s),t(m),t(J),t(f)),u(c,r)}}}function Ql(I){let s,b="The sharded checkpoints are saved under a directory called <code>tensor_parallel_shards</code>. The <code>optimum-cli neuron consolidate</code> command accept as input both a directory that contains a <code>tensor_parallel_shards</code> directory, or the <code>tensor_parallel_shards</code> directory itself.";return{c(){s=o("p"),s.innerHTML=b},l(m){s=p(m,"P",{"data-svelte-h":!0}),T(s)!=="svelte-1rjmyzp"&&(s.innerHTML=b)},m(m,J){a(m,s,J)},p:tl,d(m){m&&t(s)}}}function Vl(I){let s,b,m,J,j,f,c,_='<a href="https://aws.amazon.com/machine-learning/trainium/" rel="nofollow">AWS Trainium instances</a> are great to train models. They can contain up to 16 Neuron devices, each device containing 2 Neuron cores and has 32GB of memory (16GB per core). For example a <code>trn1.32xlarge</code> instance has 32 x 16 = 512GB of memory.',r,U,nl="But there is a caveat: each Neuron core is an independent data-parallel worker by default. It means that the model, the gradient state and the optimizer state, amounting to approximately 4 times the model size, must fit in each of the Neuron cores (16GB) to be able to train. If that is the case, then the activations must also fit in the remaining memory.",Me,z,il="To alleviate that, <code>optimum-neuron</code> supports parallelism features enabling you to harness the full power of your Trainium instance:",de,v,rl='<li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/frameworks/torch/torch-neuronx/tutorials/training/zero1_gpt2.html" rel="nofollow">ZeRO-1</a>: It is an optimization of data-parallelism which consists in sharding the optimizer state (which usually represents half of the memory needed on the device) over the data-parallel ranks.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/tensor_parallelism_overview.html" rel="nofollow">Tensor Parallelism</a>: It is a technique which consists in sharding each of your model parameters along a given dimension on multiple devices. The number of devices to shard your parameters on is called the <code>tensor_parallel_size</code>.</li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/libraries/neuronx-distributed/pipeline_parallelism_overview.html" rel="nofollow">Pipeline Parallelism</a>: <strong>coming soon!</strong></li>',we,C,sl="The good news is that is it possible to combine those techniques, and <code>optimum-neuron</code> makes it very easy!",ye,g,he,R,ue,G,ol='Whether you use the <a href="/docs/optimum.neuron/v0.0.16/en/package_reference/trainer#optimum.neuron.NeuronTrainer">NeuronTrainer</a> or decide to have your own training script that uses the <code>NeuronAccelerator</code>, it is very easy to enable the ZeRO-1 optimization.',Ue,Z,be,Q,fe,k,je,V,_e,Y,pl="There is a little bit more work to do when not using the <code>NeuronTrainer</code>:",Ie,x,Tl="<li>(Optional) Wrap the optimizer class to make it lazy. When ZeRO-1 is enabled the original optimizer is overridden to use a sharded version of it. Hence, it is possible to load the original optimizer lazily so that the optimizer state is not materialized until it is actually sharded.</li>",Be,E,ge,W,ml="<li>Set the <code>zero_1</code> argument to <code>True</code> when instantiating the <code>NeuronAccelerator</code>.</li>",ke,N,We,F,$e,H,Jl='Just as for ZeRO-1, it is possible to apply Tensor Parallelism either with the <a href="/docs/optimum.neuron/v0.0.16/en/package_reference/trainer#optimum.neuron.NeuronTrainer">NeuronTrainer</a> or the <code>NeuronAccelerator</code>.',Ae,L,cl="When doing Tensor Parallelism, you have different settings:",Xe,O,Ml=`<li>The <code>tensor_parallel_size</code>. Ideally it should be smallest value for which the model fits.</li> <li>Whether or not sequence parallelism should be enabled. <a href="https://arxiv.org/pdf/2205.05198.pdf" rel="nofollow">Sequence parallelism</a> shards the activations on the sequence axis outside of the tensor parallel regions.
It is useful because it saves memory by sharding the activations.</li> <li>Whether or not parallelization of the embedding layer should be done. By default it is done because it offers multiple benefits:</li>`,ze,S,dl=`<li>Parallelizing the embedding layer saves memory, which can enable fitting a bigger batch size and/or sequence length.</li> <li>For language models, where the embedding layer weights and the language-modeling head weights are usually tied, the language-modeling head ends up parallel
and does not require to <code>all-gather</code> its output since it is fed to a cross entropy loss compatible with parallelism, saving expensive communication.</li>`,ve,D,wl="On top of that, it is very important to make sure that the original model is loaded in an efficient manner: the training script is going to be called by <code>torchrun</code>, which will dispatch it to workers, one worker per core. If each worker (there are 32 of them in  a <code>trn1.32xlarge</code> instance) loads the full model weights, it can take a lot of time and go out-of-memory really fast.",Ce,P,yl='<code>optimum-neuron</code> provides a context-manager <a href="/docs/optimum.neuron/v0.0.16/en/package_reference/distributed#optimum.neuron.distributed.lazy_load_for_parallelism">distributed.lazy_load_for_parallelism()</a> that loads the model lazily to prevent that, only the parameters of the corresponding model shard will be materialized in each worker.',Re,q,Ge,K,Ze,$,Qe,ee,Ve,le,hl="Just as for ZeRO-1, it is possible to wrap the optimizer class to make it lazy. Since the model parameters are going to be sharded, it is not needed to materialize the optimizer state prior to model parallelization: the wrapper makes sure that it stays unmaterialized.",Ye,te,xe,ae,Ee,ne,ul="Since Tensor Parallelism consists in sharding the model weights accross different workers, only sharded checkpoints will be saved during training. It is necessary to consolidate the sharded checkpoints to be able to share and use them outside of the specific training configuration there were created under.",Ne,ie,Ul="The Optimum CLI provides a way of doing that very easily via the <code>optimum neuron consolidate</code> command:",Fe,re,He,se,bl=`All you need to do is specify the sharded checkpoints directory and the output directory that will contain the consolidated checkpoints, and the command takes care of the rest.
It is also possible to specify the output format of the consolidated checkpoints, by default it will export them to the <code>safetensors</code> format, which is the recommend format to use.`,Le,oe,fl="Example:",Oe,pe,jl="Training with Tensor Parallelism just completed and the output dir is called <code>my_training</code>. The directory looks like the following:",Se,Te,De,me,_l="It is possible to consolidate the sharded checkpoints in <code>my_training/tensor_parallel_shards</code>, which correspond to the sharded checkpoints saved at the end of the training, by running the following command:",Pe,Je,qe,A,Ke,ce,el;return j=new X({props:{title:"Distributed Training with optimum-neuron",local:"distributed-training-with-optimum-neuron",headingTag:"h1"}}),g=new ll({props:{$$slots:{default:[Rl]},$$scope:{ctx:I}}}),R=new X({props:{title:"How to enable ZeRO-1?",local:"how-to-enable-zero-1",headingTag:"h2"}}),Z=new X({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),Q=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBJTBBJTIzJTIwVG8lMjBlbmFibGUlMjBaZVJPLTElMkMlMjBzZXQlMjB0aGUlMjAlNjB6ZXJvXzElNjAlMjBhcmd1bWVudCUyMHRvJTIwJTYwVHJ1ZSU2MCUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMuJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyME5ldXJvblRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHplcm9fMSUzRFRydWUlMkMlMEEpJTBBJTBBdHJhaW5lciUyMCUzRCUyME5ldXJvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer

<span class="hljs-comment"># To enable ZeRO-1, set the \`zero_1\` argument to \`True\` in the training arguments.</span>
training_args = NeuronTrainingArguments(
    ...,
    zero_1=<span class="hljs-literal">True</span>,
)

trainer = NeuronTrainer(
    model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),k=new ll({props:{$$slots:{default:[Gl]},$$scope:{ctx:I}}}),V=new X({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),E=new B({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBtYWtlX29wdGltaXplcl9jb25zdHJ1Y3Rvcl9sYXp5JTBBJTBBbGF6eV9hZGFtdyUyMCUzRCUyMG1ha2Vfb3B0aW1pemVyX2NvbnN0cnVjdG9yX2xhenkoQWRhbVcp",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> make_optimizer_constructor_lazy

lazy_adamw = make_optimizer_constructor_lazy(AdamW)`,wrap:!1}}),N=new B({props:{code:"YWNjZWxlcmF0b3IlMjAlM0QlMjBOZXVyb25BY2NlbGVyYXRvciglMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjB6ZXJvXzElM0RUcnVlJTJDJTBBKSUwQSUwQW1vZGVsJTIwJTNEJTIwLi4uJTBBbGF6eV9vcHRpbWl6ZXIlMjAlM0QlMjBsYXp5X2FkYW13KC4uLiklMjAlMjMlMjBBY3R1YWxseSUyMGluc3RhbnRpYXRlJTIwdGhlJTIwb3B0aW1pemVyLiUwQSUwQSUwQW1vZGVsJTJDJTIwb3B0aW1pemVyJTIwJTNEJTIwYWNjZWxlcmF0b3IucHJlcGFyZShtb2RlbCUyQyUyMGxhenlfb3B0aW1pemVyKQ==",highlighted:`accelerator = NeuronAccelerator(
    ...
    zero_1=<span class="hljs-literal">True</span>,
)

model = ...
lazy_optimizer = lazy_adamw(...) <span class="hljs-comment"># Actually instantiate the optimizer.</span>


model, optimizer = accelerator.prepare(model, lazy_optimizer)`,wrap:!1}}),F=new X({props:{title:"How to enable Tensor Parallelism?",local:"how-to-enable-tensor-parallelism",headingTag:"h2"}}),q=new X({props:{title:"Via the NeuronTrainer",local:"via-the-neurontrainer",headingTag:"h3"}}),K=new B({props:{code:"ZnJvbSUyMG9wdGltdW0ubmV1cm9uJTIwaW1wb3J0JTIwTmV1cm9uVHJhaW5pbmdBcmd1bWVudHMlMkMlMjBOZXVyb25UcmFpbmVyJTBBZnJvbSUyMG9wdGltdW0ubmV1cm9uLmRpc3RyaWJ1dGVkJTIwaW1wb3J0JTIwbGF6eV9sb2FkX2Zvcl9wYXJhbGxlbGlzbSUwQSUwQSUyMyUyMFNwZWNpZnklMjB0aGUlMjAlNjB0ZW5zb3JfcGFyYWxsZWxfc2l6ZSU2MCUyMGluJTIwdGhlJTIwdHJhaW5pbmclMjBhcmd1bWVudHMuJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyME5ldXJvblRyYWluaW5nQXJndW1lbnRzKCUwQSUyMCUyMCUyMCUyMC4uLiUyQyUwQSUyMCUyMCUyMCUyMHRlbnNvcl9wYXJhbGxlbF9zaXplJTNEOCUyQyUwQSUyMCUyMCUyMCUyMGRpc2FibGVfZW1iZWRkaW5nX3BhcmFsbGVsaXphdGlvbiUzREZhbHNlJTJDJTIwJTIzJTIwSXQlMjBpcyUyMCU2MEZhbHNlJTYwJTIwYnklMjBkZWZhdWx0LiUwQSUyMCUyMCUyMCUyMGRpc2FibGVfc2VxdWVuY2VfcGFyYWxsZWwlM0RGYWxzZSUyQyUyMCUyMyUyMEl0JTIwaXMlMjAlNjBGYWxzZSU2MCUyMGJ5JTIwZGVmYXVsdC4lMEEpJTBBJTBBd2l0aCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20odGVuc29yX3BhcmFsbGVsX3NpemUlM0R0cmFpbmluZ19hcmdzLnRlbnNvcl9wYXJhbGxlbF9zaXplKSUzQSUwQSUyMCUyMCUyMCUyMG1vZGVsJTIwJTNEJTIwLi4uJTBBJTBBJTBBdHJhaW5lciUyMCUzRCUyME5ldXJvblRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlMkMlMEElMjAlMjAlMjAlMjBhcmdzJTNEdHJhaW5pbmdfYXJncyUyQyUwQSUyMCUyMCUyMCUyMHRyYWluX2RhdGFzZXQlM0R0cmFpbl9kYXRhc2V0JTJDJTBBJTIwJTIwJTIwJTIwZXZhbF9kYXRhc2V0JTNEZXZhbF9kYXRhc2V0JTJDJTBBKSUwQSUwQXRyYWluZXIudHJhaW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronTrainingArguments, NeuronTrainer
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

<span class="hljs-comment"># Specify the \`tensor_parallel_size\` in the training arguments.</span>
training_args = NeuronTrainingArguments(
    ...,
    tensor_parallel_size=<span class="hljs-number">8</span>,
    disable_embedding_parallelization=<span class="hljs-literal">False</span>, <span class="hljs-comment"># It is \`False\` by default.</span>
    disable_sequence_parallel=<span class="hljs-literal">False</span>, <span class="hljs-comment"># It is \`False\` by default.</span>
)

<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=training_args.tensor_parallel_size):
    model = ...


trainer = NeuronTrainer(
    model,
    args=training_args,
    train_dataset=train_dataset,
    eval_dataset=eval_dataset,
)

trainer.train()`,wrap:!1}}),$=new ll({props:{$$slots:{default:[Zl]},$$scope:{ctx:I}}}),ee=new X({props:{title:"Via the NeuronAccelerator",local:"via-the-neuronaccelerator",headingTag:"h3"}}),te=new B({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEFmcm9tJTIwb3B0aW11bS5uZXVyb24lMjBpbXBvcnQlMjBOZXVyb25BY2NlbGVyYXRvciUwQWZyb20lMjBvcHRpbXVtLm5ldXJvbi5hY2NlbGVyYXRlLnV0aWxzJTIwaW1wb3J0JTIwVGVuc29yUGFyYWxsZWxpc21QbHVnaW4lMEFmcm9tJTIwb3B0aW11bS5uZXVyb24uZGlzdHJpYnV0ZWQlMjBpbXBvcnQlMjBsYXp5X2xvYWRfZm9yX3BhcmFsbGVsaXNtJTBBJTBBdGVuc29yX3BhcmFsbGVsX3NpemUlMjAlM0QlMjA4JTBBdHBfcGx1Z2luJTIwJTNEJTIwVGVuc29yUGFyYWxsZWxpc21QbHVnaW4oJTBBJTIwJTIwJTIwJTIwdGVuc29yX3BhcmFsbGVsX3NpemUlMkMlMEElMjAlMjAlMjAlMjBwYXJhbGxlbGl6ZV9lbWJlZGRpbmdzJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHNlcXVlbmNlX3BhcmFsbGVsX2VuYWJsZWQlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwY2hlY2twb2ludF9kaXIlM0ROb25lJTJDJTIwJTIzJTIwQ2FuJTIwYmUlMjBzcGVjaWZpZWQlMjB3aGVuJTIwcmVzdW1pbmclMjBmcm9tJTIwY2hlY2twb2ludC4lMEEpJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBOZXVyb25BY2NlbGVyYXRvciglMEElMjAlMjAlMjAlMjAuLi4lMEElMjAlMjAlMjAlMjB0cF9wbHVnaW4lM0R0cF9wbHVnaW4lMkMlMEEpJTBBJTBBd2l0aCUyMGxhenlfbG9hZF9mb3JfcGFyYWxsZWxpc20odGVuc29yX3BhcmFsbGVsX3NpemUlM0R0ZW5zb3JfcGFyYWxsZWxfc2l6ZSklM0ElMEElMjAlMjAlMjAlMjBtb2RlbCUyMCUzRCUyMC4uLiUwQSUwQWxhenlfYWRhbXclMjAlM0QlMjBtYWtlX29wdGltaXplcl9jb25zdHJ1Y3Rvcl9sYXp5KEFkYW1XKSUwQWxhenlfb3B0aW1pemVyJTIwJTNEJTIwbGF6eV9hZGFtdyguLi4pJTIwJTIzJTIwQWN0dWFsbHklMjBpbnN0YW50aWF0ZSUyMHRoZSUyMG9wdGltaXplci4lMEElMEFtb2RlbCUyQyUyMG9wdGltaXplciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobW9kZWwlMkMlMjBsYXp5X29wdGltaXplcik=",highlighted:`<span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW
<span class="hljs-keyword">from</span> optimum.neuron <span class="hljs-keyword">import</span> NeuronAccelerator
<span class="hljs-keyword">from</span> optimum.neuron.accelerate.utils <span class="hljs-keyword">import</span> TensorParallelismPlugin
<span class="hljs-keyword">from</span> optimum.neuron.distributed <span class="hljs-keyword">import</span> lazy_load_for_parallelism

tensor_parallel_size = <span class="hljs-number">8</span>
tp_plugin = TensorParallelismPlugin(
    tensor_parallel_size,
    parallelize_embeddings=<span class="hljs-literal">True</span>,
    sequence_parallel_enabled=<span class="hljs-literal">True</span>,
    checkpoint_dir=<span class="hljs-literal">None</span>, <span class="hljs-comment"># Can be specified when resuming from checkpoint.</span>
)

accelerator = NeuronAccelerator(
    ...
    tp_plugin=tp_plugin,
)

<span class="hljs-keyword">with</span> lazy_load_for_parallelism(tensor_parallel_size=tensor_parallel_size):
    model = ...

lazy_adamw = make_optimizer_constructor_lazy(AdamW)
lazy_optimizer = lazy_adamw(...) <span class="hljs-comment"># Actually instantiate the optimizer.</span>

model, optimizer = accelerator.prepare(model, lazy_optimizer)`,wrap:!1}}),ae=new X({props:{title:"Checkpoint consolidation",local:"checkpoint-consolidation",headingTag:"h3"}}),re=new B({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMC0taGVscCUwQSUwQXVzYWdlJTNBJTIwb3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMCU1Qi1oJTVEJTIwJTVCLWYlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlNUQlMjBjaGVja3BvaW50X2RpciUyMG91dHB1dF9kaXIlMEElMEFwb3NpdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwY2hlY2twb2ludF9kaXIlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBwYXRoJTIwdG8lMjB0aGUlMjBkaXJlY3RvcnklMjBjb250YWluaW5nJTIwdGhlJTIwY2hlY2twb2ludHMuJTBBJTIwJTIwb3V0cHV0X2RpciUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFRoZSUyMHBhdGglMjB0byUyMHRoZSUyMG91dHB1dCUyMGRpcmVjdG9yeSUyMGNvbnRhaW5pbmclMjB0aGUlMjBjb25zb2xpZGF0ZWQlMjBjaGVja3BvaW50LiUwQSUwQW9wdGlvbmFsJTIwYXJndW1lbnRzJTNBJTBBJTIwJTIwLWglMkMlMjAtLWhlbHAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzaG93JTIwdGhpcyUyMGhlbHAlMjBtZXNzYWdlJTIwYW5kJTIwZXhpdCUwQSUyMCUyMC1mJTIwJTdCcHl0b3JjaCUyQ3NhZmV0ZW5zb3JzJTdEJTJDJTIwLS1mb3JtYXQlMjAlN0JweXRvcmNoJTJDc2FmZXRlbnNvcnMlN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBUaGUlMjBmb3JtYXQlMjB1c2VkJTIwdG8lMjBzYXZlJTIwdGhlJTIwY29uc29saWRhdGVkJTIwY2hlY2twb2ludC4lMEE=",highlighted:`optimum-cli neuron consolidate --help

usage: optimum-cli neuron consolidate [-h] [-f {pytorch,safetensors}] checkpoint_dir output_dir

positional arguments:
  checkpoint_dir        The path to the directory containing the checkpoints.
  output_dir            The path to the output directory containing the consolidated checkpoint.

optional arguments:
  -h, --help            show this help message and <span class="hljs-keyword">exit</span>
  -f {pytorch,safetensors}, --format {pytorch,safetensors}
                        The format used to save the consolidated checkpoint.
`,wrap:!1}}),Te=new B({props:{code:"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",highlighted:`my_training/
├── README.md
├── all_results.json 
├── checkpoint-10 
│   ├── config.json
│   ├── scheduler.pt
│   ├── special_tokens_map.json
│   ├── tensor_parallel_shards
│   ├── tokenizer.json
│   ├── tokenizer.model
│   ├── tokenizer_config.json
│   ├── trainer_state.json
│   └── training_args.bin
├── config.json
├── special_tokens_map.json
├── tensor_parallel_shards
│   ├── tp_rank_00_pp_rank_00
│   ├── tp_rank_01_pp_rank_00
│   ├── tp_rank_02_pp_rank_00
│   ├── tp_rank_03_pp_rank_00
│   ├── tp_rank_04_pp_rank_00
│   ├── tp_rank_05_pp_rank_00
│   ├── tp_rank_06_pp_rank_00
│   └── tp_rank_07_pp_rank_00
├── tokenizer.json
├── tokenizer.model
├── tokenizer_config.json
├── train_results.json
├── trainer_state.json
└── training_args.bin`,wrap:!1}}),Je=new B({props:{code:"b3B0aW11bS1jbGklMjBuZXVyb24lMjBjb25zb2xpZGF0ZSUyMG15X3RyYWluaW5nJTIwbXlfdHJhaW5pbmdfY29uc29saWRhdGVkX2NoZWNrcG9pbnQ=",highlighted:"optimum-cli neuron consolidate my_training my_training_consolidated_checkpoint",wrap:!1}}),A=new ll({props:{$$slots:{default:[Ql]},$$scope:{ctx:I}}}),{c(){s=o("meta"),b=n(),m=o("p"),J=n(),M(j.$$.fragment),f=n(),c=o("p"),c.innerHTML=_,r=n(),U=o("p"),U.textContent=nl,Me=n(),z=o("p"),z.innerHTML=il,de=n(),v=o("ol"),v.innerHTML=rl,we=n(),C=o("p"),C.innerHTML=sl,ye=n(),M(g.$$.fragment),he=n(),M(R.$$.fragment),ue=n(),G=o("p"),G.innerHTML=ol,Ue=n(),M(Z.$$.fragment),be=n(),M(Q.$$.fragment),fe=n(),M(k.$$.fragment),je=n(),M(V.$$.fragment),_e=n(),Y=o("p"),Y.innerHTML=pl,Ie=n(),x=o("ol"),x.innerHTML=Tl,Be=n(),M(E.$$.fragment),ge=n(),W=o("ol"),W.innerHTML=ml,ke=n(),M(N.$$.fragment),We=n(),M(F.$$.fragment),$e=n(),H=o("p"),H.innerHTML=Jl,Ae=n(),L=o("p"),L.textContent=cl,Xe=n(),O=o("ol"),O.innerHTML=Ml,ze=n(),S=o("ul"),S.innerHTML=dl,ve=n(),D=o("p"),D.innerHTML=wl,Ce=n(),P=o("p"),P.innerHTML=yl,Re=n(),M(q.$$.fragment),Ge=n(),M(K.$$.fragment),Ze=n(),M($.$$.fragment),Qe=n(),M(ee.$$.fragment),Ve=n(),le=o("p"),le.textContent=hl,Ye=n(),M(te.$$.fragment),xe=n(),M(ae.$$.fragment),Ee=n(),ne=o("p"),ne.textContent=ul,Ne=n(),ie=o("p"),ie.innerHTML=Ul,Fe=n(),M(re.$$.fragment),He=n(),se=o("p"),se.innerHTML=bl,Le=n(),oe=o("p"),oe.textContent=fl,Oe=n(),pe=o("p"),pe.innerHTML=jl,Se=n(),M(Te.$$.fragment),De=n(),me=o("p"),me.innerHTML=_l,Pe=n(),M(Je.$$.fragment),qe=n(),M(A.$$.fragment),Ke=n(),ce=o("p"),this.h()},l(e){const l=vl("svelte-u9bgzb",document.head);s=p(l,"META",{name:!0,content:!0}),l.forEach(t),b=i(e),m=p(e,"P",{}),Wl(m).forEach(t),J=i(e),d(j.$$.fragment,e),f=i(e),c=p(e,"P",{"data-svelte-h":!0}),T(c)!=="svelte-1cdv2fm"&&(c.innerHTML=_),r=i(e),U=p(e,"P",{"data-svelte-h":!0}),T(U)!=="svelte-trqv6g"&&(U.textContent=nl),Me=i(e),z=p(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1rlk2kz"&&(z.innerHTML=il),de=i(e),v=p(e,"OL",{"data-svelte-h":!0}),T(v)!=="svelte-hfxbx7"&&(v.innerHTML=rl),we=i(e),C=p(e,"P",{"data-svelte-h":!0}),T(C)!=="svelte-ogaike"&&(C.innerHTML=sl),ye=i(e),d(g.$$.fragment,e),he=i(e),d(R.$$.fragment,e),ue=i(e),G=p(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-y2hyf4"&&(G.innerHTML=ol),Ue=i(e),d(Z.$$.fragment,e),be=i(e),d(Q.$$.fragment,e),fe=i(e),d(k.$$.fragment,e),je=i(e),d(V.$$.fragment,e),_e=i(e),Y=p(e,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-la2f2b"&&(Y.innerHTML=pl),Ie=i(e),x=p(e,"OL",{"data-svelte-h":!0}),T(x)!=="svelte-6khx73"&&(x.innerHTML=Tl),Be=i(e),d(E.$$.fragment,e),ge=i(e),W=p(e,"OL",{start:!0,"data-svelte-h":!0}),T(W)!=="svelte-1ufjyew"&&(W.innerHTML=ml),ke=i(e),d(N.$$.fragment,e),We=i(e),d(F.$$.fragment,e),$e=i(e),H=p(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-1wc0axo"&&(H.innerHTML=Jl),Ae=i(e),L=p(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-c14p9h"&&(L.textContent=cl),Xe=i(e),O=p(e,"OL",{"data-svelte-h":!0}),T(O)!=="svelte-gly1sh"&&(O.innerHTML=Ml),ze=i(e),S=p(e,"UL",{"data-svelte-h":!0}),T(S)!=="svelte-19rx9yl"&&(S.innerHTML=dl),ve=i(e),D=p(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-v8xmeb"&&(D.innerHTML=wl),Ce=i(e),P=p(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-1d2bcy7"&&(P.innerHTML=yl),Re=i(e),d(q.$$.fragment,e),Ge=i(e),d(K.$$.fragment,e),Ze=i(e),d($.$$.fragment,e),Qe=i(e),d(ee.$$.fragment,e),Ve=i(e),le=p(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1gks0nu"&&(le.textContent=hl),Ye=i(e),d(te.$$.fragment,e),xe=i(e),d(ae.$$.fragment,e),Ee=i(e),ne=p(e,"P",{"data-svelte-h":!0}),T(ne)!=="svelte-bc8xo9"&&(ne.textContent=ul),Ne=i(e),ie=p(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-24042q"&&(ie.innerHTML=Ul),Fe=i(e),d(re.$$.fragment,e),He=i(e),se=p(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-1xib7ue"&&(se.innerHTML=bl),Le=i(e),oe=p(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-11lpom8"&&(oe.textContent=fl),Oe=i(e),pe=p(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-u3s5ug"&&(pe.innerHTML=jl),Se=i(e),d(Te.$$.fragment,e),De=i(e),me=p(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-14t9mzj"&&(me.innerHTML=_l),Pe=i(e),d(Je.$$.fragment,e),qe=i(e),d(A.$$.fragment,e),Ke=i(e),ce=p(e,"P",{}),Wl(ce).forEach(t),this.h()},h(){al(s,"name","hf:doc:metadata"),al(s,"content",Yl),al(W,"start","2")},m(e,l){Cl(document.head,s),a(e,b,l),a(e,m,l),a(e,J,l),w(j,e,l),a(e,f,l),a(e,c,l),a(e,r,l),a(e,U,l),a(e,Me,l),a(e,z,l),a(e,de,l),a(e,v,l),a(e,we,l),a(e,C,l),a(e,ye,l),w(g,e,l),a(e,he,l),w(R,e,l),a(e,ue,l),a(e,G,l),a(e,Ue,l),w(Z,e,l),a(e,be,l),w(Q,e,l),a(e,fe,l),w(k,e,l),a(e,je,l),w(V,e,l),a(e,_e,l),a(e,Y,l),a(e,Ie,l),a(e,x,l),a(e,Be,l),w(E,e,l),a(e,ge,l),a(e,W,l),a(e,ke,l),w(N,e,l),a(e,We,l),w(F,e,l),a(e,$e,l),a(e,H,l),a(e,Ae,l),a(e,L,l),a(e,Xe,l),a(e,O,l),a(e,ze,l),a(e,S,l),a(e,ve,l),a(e,D,l),a(e,Ce,l),a(e,P,l),a(e,Re,l),w(q,e,l),a(e,Ge,l),w(K,e,l),a(e,Ze,l),w($,e,l),a(e,Qe,l),w(ee,e,l),a(e,Ve,l),a(e,le,l),a(e,Ye,l),w(te,e,l),a(e,xe,l),w(ae,e,l),a(e,Ee,l),a(e,ne,l),a(e,Ne,l),a(e,ie,l),a(e,Fe,l),w(re,e,l),a(e,He,l),a(e,se,l),a(e,Le,l),a(e,oe,l),a(e,Oe,l),a(e,pe,l),a(e,Se,l),w(Te,e,l),a(e,De,l),a(e,me,l),a(e,Pe,l),w(Je,e,l),a(e,qe,l),w(A,e,l),a(e,Ke,l),a(e,ce,l),el=!0},p(e,[l]){const Il={};l&2&&(Il.$$scope={dirty:l,ctx:e}),g.$set(Il);const Bl={};l&2&&(Bl.$$scope={dirty:l,ctx:e}),k.$set(Bl);const gl={};l&2&&(gl.$$scope={dirty:l,ctx:e}),$.$set(gl);const kl={};l&2&&(kl.$$scope={dirty:l,ctx:e}),A.$set(kl)},i(e){el||(y(j.$$.fragment,e),y(g.$$.fragment,e),y(R.$$.fragment,e),y(Z.$$.fragment,e),y(Q.$$.fragment,e),y(k.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(N.$$.fragment,e),y(F.$$.fragment,e),y(q.$$.fragment,e),y(K.$$.fragment,e),y($.$$.fragment,e),y(ee.$$.fragment,e),y(te.$$.fragment,e),y(ae.$$.fragment,e),y(re.$$.fragment,e),y(Te.$$.fragment,e),y(Je.$$.fragment,e),y(A.$$.fragment,e),el=!0)},o(e){h(j.$$.fragment,e),h(g.$$.fragment,e),h(R.$$.fragment,e),h(Z.$$.fragment,e),h(Q.$$.fragment,e),h(k.$$.fragment,e),h(V.$$.fragment,e),h(E.$$.fragment,e),h(N.$$.fragment,e),h(F.$$.fragment,e),h(q.$$.fragment,e),h(K.$$.fragment,e),h($.$$.fragment,e),h(ee.$$.fragment,e),h(te.$$.fragment,e),h(ae.$$.fragment,e),h(re.$$.fragment,e),h(Te.$$.fragment,e),h(Je.$$.fragment,e),h(A.$$.fragment,e),el=!1},d(e){e&&(t(b),t(m),t(J),t(f),t(c),t(r),t(U),t(Me),t(z),t(de),t(v),t(we),t(C),t(ye),t(he),t(ue),t(G),t(Ue),t(be),t(fe),t(je),t(_e),t(Y),t(Ie),t(x),t(Be),t(ge),t(W),t(ke),t(We),t($e),t(H),t(Ae),t(L),t(Xe),t(O),t(ze),t(S),t(ve),t(D),t(Ce),t(P),t(Re),t(Ge),t(Ze),t(Qe),t(Ve),t(le),t(Ye),t(xe),t(Ee),t(ne),t(Ne),t(ie),t(Fe),t(He),t(se),t(Le),t(oe),t(Oe),t(pe),t(Se),t(De),t(me),t(Pe),t(qe),t(Ke),t(ce)),t(s),u(j,e),u(g,e),u(R,e),u(Z,e),u(Q,e),u(k,e),u(V,e),u(E,e),u(N,e),u(F,e),u(q,e),u(K,e),u($,e),u(ee,e),u(te,e),u(ae,e),u(re,e),u(Te,e),u(Je,e),u(A,e)}}}const Yl='{"title":"Distributed Training with optimum-neuron","local":"distributed-training-with-optimum-neuron","sections":[{"title":"How to enable ZeRO-1?","local":"how-to-enable-zero-1","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3}],"depth":2},{"title":"How to enable Tensor Parallelism?","local":"how-to-enable-tensor-parallelism","sections":[{"title":"Via the NeuronTrainer","local":"via-the-neurontrainer","sections":[],"depth":3},{"title":"Via the NeuronAccelerator","local":"via-the-neuronaccelerator","sections":[],"depth":3},{"title":"Checkpoint consolidation","local":"checkpoint-consolidation","sections":[],"depth":3}],"depth":2}],"depth":1}';function xl(I){return Al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ol extends Xl{constructor(s){super(),zl(this,s,xl,Vl,$l,{})}}export{Ol as component};
