import{s as ys,o as js,n as bs}from"../chunks/scheduler.182ea377.js";import{S as ws,i as Zs,g as i,s as n,r as c,A as Js,h as r,f as s,c as a,j as fs,u,x as p,k,y as Ts,a as t,v as d,d as h,t as M,w as m}from"../chunks/index.abf12888.js";import{T as gs}from"../chunks/Tip.230e2334.js";import{C as f}from"../chunks/CodeBlock.57fe6e13.js";import{D as Us}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as ve}from"../chunks/Heading.16916d63.js";function Gs(ke){let o,W="The following Flax schedulers are <em>not yet compatible</em> with the Flax Stable Diffusion Pipeline:",w,j,Z="<li><code>FlaxLMSDiscreteScheduler</code></li> <li><code>FlaxDDPMScheduler</code></li>";return{c(){o=i("p"),o.innerHTML=W,w=n(),j=i("ul"),j.innerHTML=Z},l(y){o=r(y,"P",{"data-svelte-h":!0}),p(o)!=="svelte-18uc691"&&(o.innerHTML=W),w=a(y),j=r(y,"UL",{"data-svelte-h":!0}),p(j)!=="svelte-pfgls0"&&(j.innerHTML=Z)},m(y,b){t(y,o,b),t(y,w,b),t(y,j,b)},p:bs,d(y){y&&(s(o),s(w),s(j))}}}function vs(ke){let o,W,w,j,Z,y,b,We,_,Xl=`Diffusion pipelines are inherently a collection of diffusion models and schedulers that are partly independent from each other. This means that one is able to switch out parts of the pipeline to better customize
a pipeline to one’s use case. The best example of this is the <a href="../api/schedulers/overview">Schedulers</a>.`,_e,$,Il=`Whereas diffusion models usually simply define the forward pass from noise to a less noisy sample,
schedulers define the whole denoising process, <em>i.e.</em>:`,$e,S,Bl="<li>How many denoising steps?</li> <li>Stochastic or deterministic?</li> <li>What algorithm to use to find the denoised sample?</li>",Se,x,Nl=`They can be quite complex and often define a trade-off between <strong>denoising speed</strong> and <strong>denoising quality</strong>.
It is extremely difficult to measure quantitatively which scheduler works best for a given diffusion pipeline, so it is often recommended to simply try out which works best.`,xe,X,Cl="The following paragraphs show how to do so with the 🧨 Diffusers library.",Xe,I,Ie,B,Rl='Let’s start by loading the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> model in the <a href="/docs/diffusers/v0.24.0/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Be,N,Ne,C,Hl="Next, we move it to GPU:",Ce,R,Re,H,He,E,El=`The scheduler is always one of the components of the pipeline and is usually called <code>&quot;scheduler&quot;</code>.
So it can be accessed via the <code>&quot;scheduler&quot;</code> property.`,Ee,A,Ae,D,Al="<strong>Output</strong>:",De,F,Fe,z,Dl=`We can see that the scheduler is of type <a href="/docs/diffusers/v0.24.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.
Cool, now let’s compare the scheduler in its performance to other schedulers.
First we define a prompt on which we will test all the different schedulers:`,ze,L,Le,Q,Fl="Next, we create a generator from a random seed that will ensure that we can generate similar images as well as run the pipeline:",Qe,Y,Ye,J,zl='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_pndm.png" width="400"/> <br/>',Pe,P,qe,q,Ll=`Now we show how easy it is to change the scheduler of a pipeline. Every scheduler has a property <code>compatibles</code>
which defines all compatible schedulers. You can take a look at all available, compatible schedulers for the Stable Diffusion pipeline as follows.`,Ke,K,Oe,O,Ql="<strong>Output</strong>:",el,ee,ll,le,Yl="Cool, lots of schedulers to look at. Feel free to have a look at their respective class definitions:",sl,se,Pl='<li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddpm#diffusers.DDPMScheduler">DDPMScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/heun#diffusers.HeunDiscreteScheduler">HeunDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/deis#diffusers.DEISMultistepScheduler">DEISMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/unipc#diffusers.UniPCMultistepScheduler">UniPCMultistepScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/dpm_discrete#diffusers.KDPM2DiscreteScheduler">KDPM2DiscreteScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/singlestep_dpm_solver#diffusers.DPMSolverSinglestepScheduler">DPMSolverSinglestepScheduler</a>,</li> <li><a href="/docs/diffusers/v0.24.0/en/api/schedulers/dpm_discrete_ancestral#diffusers.KDPM2AncestralDiscreteScheduler">KDPM2AncestralDiscreteScheduler</a>.</li>',tl,te,ql=`We will now compare the input prompt with all other schedulers. To change the scheduler of the pipeline you can make use of the
convenient <code>config</code> property in combination with the <a href="/docs/diffusers/v0.24.0/en/api/configuration#diffusers.ConfigMixin.from_config">from_config()</a> function.`,nl,ne,al,ae,Kl="returns a dictionary of the configuration of the scheduler:",il,ie,Ol="<strong>Output</strong>:",rl,re,pl,pe,es=`This configuration can then be used to instantiate a scheduler
of a different class that is compatible with the pipeline. Here,
we change the scheduler to the <a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.`,cl,ce,ul,ue,ls="Cool, now we can run the pipeline again to compare the generation quality.",dl,de,hl,T,ss='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_ddim.png" width="400"/> <br/>',Ml,he,ts='If you are a JAX/Flax user, please check <a href="#changing-the-scheduler-in-flax">this section</a> instead.',ml,Me,ol,me,ns=`So far we have tried running the stable diffusion pipeline with two schedulers: <a href="/docs/diffusers/v0.24.0/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> and <a href="/docs/diffusers/v0.24.0/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>.
A number of better schedulers have been released that can be run with much fewer steps; let’s compare them here:`,fl,oe,as='<a href="/docs/diffusers/v0.24.0/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a> usually leads to better results:',yl,fe,jl,g,is='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_lms.png" width="400"/> <br/>',bl,ye,rs='<a href="/docs/diffusers/v0.24.0/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> and <a href="/docs/diffusers/v0.24.0/en/api/schedulers/euler_ancestral#diffusers.EulerAncestralDiscreteScheduler">EulerAncestralDiscreteScheduler</a> can generate high quality results with as little as 30 steps.',wl,je,Zl,U,ps='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_discrete.png" width="400"/> <br/>',Jl,be,cs="and:",Tl,we,gl,G,us='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_euler_ancestral.png" width="400"/> <br/>',Ul,Ze,ds='<a href="/docs/diffusers/v0.24.0/en/api/schedulers/multistep_dpm_solver#diffusers.DPMSolverMultistepScheduler">DPMSolverMultistepScheduler</a> gives a reasonable speed/quality trade-off and can be run with as little as 20 steps.',Gl,Je,vl,v,hs='<br/> <img src="https://huggingface.co/datasets/patrickvonplaten/images/resolve/main/diffusers_docs/astronaut_dpm.png" width="400"/> <br/>',Vl,Te,Ms=`As you can see, most images look very similar and are arguably of very similar quality. It often really depends on the specific use case which scheduler to choose. A good approach is always to run multiple different
schedulers to compare results.`,kl,ge,Wl,Ue,ms='If you are a JAX/Flax user, you can also change the default pipeline scheduler. This is a complete example of how to run inference using the Flax Stable Diffusion pipeline and the super-fast <a href="../api/schedulers/multistep_dpm_solver">DPM-Solver++ scheduler</a>:',_l,Ge,$l,V,Sl,Ve,xl;return Z=new ve({props:{title:"Schedulers",local:"schedulers",headingTag:"h1"}}),b=new Us({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/schedulers.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/schedulers.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/schedulers.ipynb"}]}}),I=new ve({props:{title:"Load pipeline",local:"load-pipeline",headingTag:"h2"}}),N=new f({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGxvZ2luJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFsb2dpbigpJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

login()

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),R=new f({props:{code:"cGlwZWxpbmUudG8oJTIyY3VkYSUyMik=",highlighted:'pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),H=new ve({props:{title:"Access the scheduler",local:"access-the-scheduler",headingTag:"h2"}}),A=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVy",highlighted:"pipeline.scheduler",wrap:!1}}),F=new f({props:{code:"UE5ETVNjaGVkdWxlciUyMCU3QiUwQSUyMCUyMCUyMl9jbGFzc19uYW1lJTIyJTNBJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuMjEuNCUyMiUyQyUwQSUyMCUyMCUyMmJldGFfZW5kJTIyJTNBJTIwMC4wMTIlMkMlMEElMjAlMjAlMjJiZXRhX3NjaGVkdWxlJTIyJTNBJTIwJTIyc2NhbGVkX2xpbmVhciUyMiUyQyUwQSUyMCUyMCUyMmJldGFfc3RhcnQlMjIlM0ElMjAwLjAwMDg1JTJDJTBBJTIwJTIwJTIyY2xpcF9zYW1wbGUlMjIlM0ElMjBmYWxzZSUyQyUwQSUyMCUyMCUyMm51bV90cmFpbl90aW1lc3RlcHMlMjIlM0ElMjAxMDAwJTJDJTBBJTIwJTIwJTIyc2V0X2FscGhhX3RvX29uZSUyMiUzQSUyMGZhbHNlJTJDJTBBJTIwJTIwJTIyc2tpcF9wcmtfc3RlcHMlMjIlM0ElMjB0cnVlJTJDJTBBJTIwJTIwJTIyc3RlcHNfb2Zmc2V0JTIyJTNBJTIwMSUyQyUwQSUyMCUyMCUyMnRpbWVzdGVwX3NwYWNpbmclMjIlM0ElMjAlMjJsZWFkaW5nJTIyJTJDJTBBJTIwJTIwJTIydHJhaW5lZF9iZXRhcyUyMiUzQSUyMG51bGwlMEElN0Q=",highlighted:`PNDMScheduler {
  <span class="hljs-string">&quot;_class_name&quot;</span>: <span class="hljs-string">&quot;PNDMScheduler&quot;</span>,
  <span class="hljs-string">&quot;_diffusers_version&quot;</span>: <span class="hljs-string">&quot;0.21.4&quot;</span>,
  <span class="hljs-string">&quot;beta_end&quot;</span>: <span class="hljs-number">0.012</span>,
  <span class="hljs-string">&quot;beta_schedule&quot;</span>: <span class="hljs-string">&quot;scaled_linear&quot;</span>,
  <span class="hljs-string">&quot;beta_start&quot;</span>: <span class="hljs-number">0.00085</span>,
  <span class="hljs-string">&quot;clip_sample&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;num_train_timesteps&quot;</span>: <span class="hljs-number">1000</span>,
  <span class="hljs-string">&quot;set_alpha_to_one&quot;</span>: <span class="hljs-literal">false</span>,
  <span class="hljs-string">&quot;skip_prk_steps&quot;</span>: <span class="hljs-literal">true</span>,
  <span class="hljs-string">&quot;steps_offset&quot;</span>: <span class="hljs-number">1</span>,
  <span class="hljs-string">&quot;timestep_spacing&quot;</span>: <span class="hljs-string">&quot;leading&quot;</span>,
  <span class="hljs-string">&quot;trained_betas&quot;</span>: <span class="hljs-literal">null</span>
}`,wrap:!1}}),L=new f({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyQSUyMHBob3RvZ3JhcGglMjBvZiUyMGFuJTIwYXN0cm9uYXV0JTIwcmlkaW5nJTIwYSUyMGhvcnNlJTIwb24lMjBNYXJzJTJDJTIwaGlnaCUyMHJlc29sdXRpb24lMkMlMjBoaWdoJTIwZGVmaW5pdGlvbi4lMjI=",highlighted:'prompt = <span class="hljs-string">&quot;A photograph of an astronaut riding a horse on Mars, high resolution, high definition.&quot;</span>',wrap:!1}}),Y=new f({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),P=new ve({props:{title:"Changing the scheduler",local:"changing-the-scheduler",headingTag:"h2"}}),K=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbXBhdGlibGVz",highlighted:"pipeline.scheduler.compatibles",wrap:!1}}),ee=new f({props:{code:"JTVCZGlmZnVzZXJzLnV0aWxzLmR1bW15X3RvcmNoX2FuZF90b3JjaHNkZV9vYmplY3RzLkRQTVNvbHZlclNERVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZXVsZXJfZGlzY3JldGUuRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfbG1zX2Rpc2NyZXRlLkxNU0Rpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZGltLkRESU1TY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RkcG0uRERQTVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfaGV1bl9kaXNjcmV0ZS5IZXVuRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2RwbXNvbHZlcl9tdWx0aXN0ZXAuRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19kZWlzX211bHRpc3RlcC5ERUlTTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ19wbmRtLlBORE1TY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2V1bGVyX2FuY2VzdHJhbF9kaXNjcmV0ZS5FdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwZGlmZnVzZXJzLnNjaGVkdWxlcnMuc2NoZWR1bGluZ191bmlwY19tdWx0aXN0ZXAuVW5pUENNdWx0aXN0ZXBTY2hlZHVsZXIlMkMlMEElMjBkaWZmdXNlcnMuc2NoZWR1bGVycy5zY2hlZHVsaW5nX2tfZHBtXzJfZGlzY3JldGUuS0RQTTJEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfZHBtc29sdmVyX3NpbmdsZXN0ZXAuRFBNU29sdmVyU2luZ2xlc3RlcFNjaGVkdWxlciUyQyUwQSUyMGRpZmZ1c2Vycy5zY2hlZHVsZXJzLnNjaGVkdWxpbmdfa19kcG1fMl9hbmNlc3RyYWxfZGlzY3JldGUuS0RQTTJBbmNlc3RyYWxEaXNjcmV0ZVNjaGVkdWxlciU1RA==",highlighted:`[<span class="hljs-keyword">diffusers.utils.dummy_torch_and_torchsde_objects.DPMSolverSDEScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_discrete.EulerDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_lms_discrete.LMSDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddim.DDIMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_ddpm.DDPMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_heun_discrete.HeunDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_dpmsolver_multistep.DPMSolverMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_deis_multistep.DEISMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_pndm.PNDMScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_euler_ancestral_discrete.EulerAncestralDiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_unipc_multistep.UniPCMultistepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_k_dpm_2_discrete.KDPM2DiscreteScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_dpmsolver_singlestep.DPMSolverSinglestepScheduler,
</span> <span class="hljs-keyword">diffusers.schedulers.scheduling_k_dpm_2_ancestral_discrete.KDPM2AncestralDiscreteScheduler]</span>`,wrap:!1}}),ne=new f({props:{code:"cGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZw==",highlighted:"pipeline.scheduler.config",wrap:!1}}),re=new f({props:{code:"RnJvemVuRGljdCglNUIoJ251bV90cmFpbl90aW1lc3RlcHMnJTJDJTIwMTAwMCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfc3RhcnQnJTJDJTIwMC4wMDA4NSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2JldGFfZW5kJyUyQyUyMDAuMDEyKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnYmV0YV9zY2hlZHVsZSclMkMlMjAnc2NhbGVkX2xpbmVhcicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0cmFpbmVkX2JldGFzJyUyQyUyME5vbmUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCdza2lwX3Bya19zdGVwcyclMkMlMjBUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnc2V0X2FscGhhX3RvX29uZSclMkMlMjBGYWxzZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3ByZWRpY3Rpb25fdHlwZSclMkMlMjAnZXBzaWxvbicpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKCd0aW1lc3RlcF9zcGFjaW5nJyUyQyUyMCdsZWFkaW5nJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ3N0ZXBzX29mZnNldCclMkMlMjAxKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCgnX3VzZV9kZWZhdWx0X3ZhbHVlcyclMkMlMjAlNUIndGltZXN0ZXBfc3BhY2luZyclMkMlMjAncHJlZGljdGlvbl90eXBlJyU1RCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ19jbGFzc19uYW1lJyUyQyUyMCdQTkRNU2NoZWR1bGVyJyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ19kaWZmdXNlcnNfdmVyc2lvbiclMkMlMjAnMC4yMS40JyklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAoJ2NsaXBfc2FtcGxlJyUyQyUyMEZhbHNlKSU1RCk=",highlighted:`FrozenDict([(<span class="hljs-string">&#x27;num_train_timesteps&#x27;</span>, <span class="hljs-number">1000</span>),
            (<span class="hljs-string">&#x27;beta_start&#x27;</span>, <span class="hljs-number">0.00085</span>),
            (<span class="hljs-string">&#x27;beta_end&#x27;</span>, <span class="hljs-number">0.012</span>),
            (<span class="hljs-string">&#x27;beta_schedule&#x27;</span>, <span class="hljs-string">&#x27;scaled_linear&#x27;</span>),
            (<span class="hljs-string">&#x27;trained_betas&#x27;</span>, <span class="hljs-literal">None</span>),
            (<span class="hljs-string">&#x27;skip_prk_steps&#x27;</span>, <span class="hljs-literal">True</span>),
            (<span class="hljs-string">&#x27;set_alpha_to_one&#x27;</span>, <span class="hljs-literal">False</span>),
            (<span class="hljs-string">&#x27;prediction_type&#x27;</span>, <span class="hljs-string">&#x27;epsilon&#x27;</span>),
            (<span class="hljs-string">&#x27;timestep_spacing&#x27;</span>, <span class="hljs-string">&#x27;leading&#x27;</span>),
            (<span class="hljs-string">&#x27;steps_offset&#x27;</span>, <span class="hljs-number">1</span>),
            (<span class="hljs-string">&#x27;_use_default_values&#x27;</span>, [<span class="hljs-string">&#x27;timestep_spacing&#x27;</span>, <span class="hljs-string">&#x27;prediction_type&#x27;</span>]),
            (<span class="hljs-string">&#x27;_class_name&#x27;</span>, <span class="hljs-string">&#x27;PNDMScheduler&#x27;</span>),
            (<span class="hljs-string">&#x27;_diffusers_version&#x27;</span>, <span class="hljs-string">&#x27;0.21.4&#x27;</span>),
            (<span class="hljs-string">&#x27;clip_sample&#x27;</span>, <span class="hljs-literal">False</span>)])`,wrap:!1}}),ce=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1TY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler

pipeline.scheduler = DDIMScheduler.from_config(pipeline.scheduler.config)`,wrap:!1}}),de=new f({props:{code:"Z2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Me=new ve({props:{title:"Compare schedulers",local:"compare-schedulers",headingTag:"h2"}}),fe=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyJTBBJTBBcGlwZWxpbmUuc2NoZWR1bGVyJTIwJTNEJTIwTE1TRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9jb25maWcocGlwZWxpbmUuc2NoZWR1bGVyLmNvbmZpZyklMEElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoOCklMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lKHByb21wdCUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTVCMCU1RCUwQWltYWdl",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> LMSDiscreteScheduler

pipeline.scheduler = LMSDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),je=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerDiscreteScheduler

pipeline.scheduler = EulerDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),we=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMEElMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWcpJTBBJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDgpJTBBaW1hZ2UlMjAlM0QlMjBwaXBlbGluZShwcm9tcHQlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMzApLmltYWdlcyU1QjAlNUQlMEFpbWFnZQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> EulerAncestralDiscreteScheduler

pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">30</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),Je=new f({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlciUwQSUwQXBpcGVsaW5lLnNjaGVkdWxlciUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlbGluZS5zY2hlZHVsZXIuY29uZmlnKSUwQSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKS5tYW51YWxfc2VlZCg4KSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmUocHJvbXB0JTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDIwKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DPMSolverMultistepScheduler

pipeline.scheduler = DPMSolverMultistepScheduler.from_config(pipeline.scheduler.config)

generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">8</span>)
image = pipeline(prompt, generator=generator, num_inference_steps=<span class="hljs-number">20</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),ge=new ve({props:{title:"Changing the Scheduler in Flax",local:"changing-the-scheduler-in-flax",headingTag:"h2"}}),Ge=new f({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> jax
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">from</span> flax.jax_utils <span class="hljs-keyword">import</span> replicate
<span class="hljs-keyword">from</span> flax.training.common_utils <span class="hljs-keyword">import</span> shard

<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> FlaxStableDiffusionPipeline, FlaxDPMSolverMultistepScheduler

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler, scheduler_state = FlaxDPMSolverMultistepScheduler.from_pretrained(
    model_id,
    subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>
)
pipeline, params = FlaxStableDiffusionPipeline.from_pretrained(
    model_id,
    scheduler=scheduler,
    revision=<span class="hljs-string">&quot;bf16&quot;</span>,
    dtype=jax.numpy.bfloat16,
)
params[<span class="hljs-string">&quot;scheduler&quot;</span>] = scheduler_state

<span class="hljs-comment"># Generate 1 image per parallel device (8 on TPUv2-8 or TPUv3-8)</span>
prompt = <span class="hljs-string">&quot;a photo of an astronaut riding a horse on mars&quot;</span>
num_samples = jax.device_count()
prompt_ids = pipeline.prepare_inputs([prompt] * num_samples)

prng_seed = jax.random.PRNGKey(<span class="hljs-number">0</span>)
num_inference_steps = <span class="hljs-number">25</span>

<span class="hljs-comment"># shard inputs and rng</span>
params = replicate(params)
prng_seed = jax.random.split(prng_seed, jax.device_count())
prompt_ids = shard(prompt_ids)

images = pipeline(prompt_ids, params, prng_seed, num_inference_steps, jit=<span class="hljs-literal">True</span>).images
images = pipeline.numpy_to_pil(np.asarray(images.reshape((num_samples,) + images.shape[-<span class="hljs-number">3</span>:])))`,wrap:!1}}),V=new gs({props:{warning:!0,$$slots:{default:[Gs]},$$scope:{ctx:ke}}}),{c(){o=i("meta"),W=n(),w=i("p"),j=n(),c(Z.$$.fragment),y=n(),c(b.$$.fragment),We=n(),_=i("p"),_.innerHTML=Xl,_e=n(),$=i("p"),$.innerHTML=Il,$e=n(),S=i("ul"),S.innerHTML=Bl,Se=n(),x=i("p"),x.innerHTML=Nl,xe=n(),X=i("p"),X.textContent=Cl,Xe=n(),c(I.$$.fragment),Ie=n(),B=i("p"),B.innerHTML=Rl,Be=n(),c(N.$$.fragment),Ne=n(),C=i("p"),C.textContent=Hl,Ce=n(),c(R.$$.fragment),Re=n(),c(H.$$.fragment),He=n(),E=i("p"),E.innerHTML=El,Ee=n(),c(A.$$.fragment),Ae=n(),D=i("p"),D.innerHTML=Al,De=n(),c(F.$$.fragment),Fe=n(),z=i("p"),z.innerHTML=Dl,ze=n(),c(L.$$.fragment),Le=n(),Q=i("p"),Q.textContent=Fl,Qe=n(),c(Y.$$.fragment),Ye=n(),J=i("p"),J.innerHTML=zl,Pe=n(),c(P.$$.fragment),qe=n(),q=i("p"),q.innerHTML=Ll,Ke=n(),c(K.$$.fragment),Oe=n(),O=i("p"),O.innerHTML=Ql,el=n(),c(ee.$$.fragment),ll=n(),le=i("p"),le.textContent=Yl,sl=n(),se=i("ul"),se.innerHTML=Pl,tl=n(),te=i("p"),te.innerHTML=ql,nl=n(),c(ne.$$.fragment),al=n(),ae=i("p"),ae.textContent=Kl,il=n(),ie=i("p"),ie.innerHTML=Ol,rl=n(),c(re.$$.fragment),pl=n(),pe=i("p"),pe.innerHTML=es,cl=n(),c(ce.$$.fragment),ul=n(),ue=i("p"),ue.textContent=ls,dl=n(),c(de.$$.fragment),hl=n(),T=i("p"),T.innerHTML=ss,Ml=n(),he=i("p"),he.innerHTML=ts,ml=n(),c(Me.$$.fragment),ol=n(),me=i("p"),me.innerHTML=ns,fl=n(),oe=i("p"),oe.innerHTML=as,yl=n(),c(fe.$$.fragment),jl=n(),g=i("p"),g.innerHTML=is,bl=n(),ye=i("p"),ye.innerHTML=rs,wl=n(),c(je.$$.fragment),Zl=n(),U=i("p"),U.innerHTML=ps,Jl=n(),be=i("p"),be.textContent=cs,Tl=n(),c(we.$$.fragment),gl=n(),G=i("p"),G.innerHTML=us,Ul=n(),Ze=i("p"),Ze.innerHTML=ds,Gl=n(),c(Je.$$.fragment),vl=n(),v=i("p"),v.innerHTML=hs,Vl=n(),Te=i("p"),Te.textContent=Ms,kl=n(),c(ge.$$.fragment),Wl=n(),Ue=i("p"),Ue.innerHTML=ms,_l=n(),c(Ge.$$.fragment),$l=n(),c(V.$$.fragment),Sl=n(),Ve=i("p"),this.h()},l(e){const l=Js("svelte-u9bgzb",document.head);o=r(l,"META",{name:!0,content:!0}),l.forEach(s),W=a(e),w=r(e,"P",{}),fs(w).forEach(s),j=a(e),u(Z.$$.fragment,e),y=a(e),u(b.$$.fragment,e),We=a(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1xyod4r"&&(_.innerHTML=Xl),_e=a(e),$=r(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-pj1fnh"&&($.innerHTML=Il),$e=a(e),S=r(e,"UL",{"data-svelte-h":!0}),p(S)!=="svelte-1387f55"&&(S.innerHTML=Bl),Se=a(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-7vywvj"&&(x.innerHTML=Nl),xe=a(e),X=r(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-1h9ag03"&&(X.textContent=Cl),Xe=a(e),u(I.$$.fragment,e),Ie=a(e),B=r(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-xqxz6p"&&(B.innerHTML=Rl),Be=a(e),u(N.$$.fragment,e),Ne=a(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1pntiyw"&&(C.textContent=Hl),Ce=a(e),u(R.$$.fragment,e),Re=a(e),u(H.$$.fragment,e),He=a(e),E=r(e,"P",{"data-svelte-h":!0}),p(E)!=="svelte-ifniwj"&&(E.innerHTML=El),Ee=a(e),u(A.$$.fragment,e),Ae=a(e),D=r(e,"P",{"data-svelte-h":!0}),p(D)!=="svelte-jl1fz0"&&(D.innerHTML=Al),De=a(e),u(F.$$.fragment,e),Fe=a(e),z=r(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-rc12e5"&&(z.innerHTML=Dl),ze=a(e),u(L.$$.fragment,e),Le=a(e),Q=r(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-1crup8"&&(Q.textContent=Fl),Qe=a(e),u(Y.$$.fragment,e),Ye=a(e),J=r(e,"P",{align:!0,"data-svelte-h":!0}),p(J)!=="svelte-4ve60e"&&(J.innerHTML=zl),Pe=a(e),u(P.$$.fragment,e),qe=a(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-tey2p6"&&(q.innerHTML=Ll),Ke=a(e),u(K.$$.fragment,e),Oe=a(e),O=r(e,"P",{"data-svelte-h":!0}),p(O)!=="svelte-jl1fz0"&&(O.innerHTML=Ql),el=a(e),u(ee.$$.fragment,e),ll=a(e),le=r(e,"P",{"data-svelte-h":!0}),p(le)!=="svelte-1km1sb3"&&(le.textContent=Yl),sl=a(e),se=r(e,"UL",{"data-svelte-h":!0}),p(se)!=="svelte-1e2f91t"&&(se.innerHTML=Pl),tl=a(e),te=r(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-179pqic"&&(te.innerHTML=ql),nl=a(e),u(ne.$$.fragment,e),al=a(e),ae=r(e,"P",{"data-svelte-h":!0}),p(ae)!=="svelte-sih4ln"&&(ae.textContent=Kl),il=a(e),ie=r(e,"P",{"data-svelte-h":!0}),p(ie)!=="svelte-jl1fz0"&&(ie.innerHTML=Ol),rl=a(e),u(re.$$.fragment,e),pl=a(e),pe=r(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-f3lva8"&&(pe.innerHTML=es),cl=a(e),u(ce.$$.fragment,e),ul=a(e),ue=r(e,"P",{"data-svelte-h":!0}),p(ue)!=="svelte-zqrmvv"&&(ue.textContent=ls),dl=a(e),u(de.$$.fragment,e),hl=a(e),T=r(e,"P",{align:!0,"data-svelte-h":!0}),p(T)!=="svelte-cbz2yl"&&(T.innerHTML=ss),Ml=a(e),he=r(e,"P",{"data-svelte-h":!0}),p(he)!=="svelte-1g5sqb9"&&(he.innerHTML=ts),ml=a(e),u(Me.$$.fragment,e),ol=a(e),me=r(e,"P",{"data-svelte-h":!0}),p(me)!=="svelte-i4vpaw"&&(me.innerHTML=ns),fl=a(e),oe=r(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-djirps"&&(oe.innerHTML=as),yl=a(e),u(fe.$$.fragment,e),jl=a(e),g=r(e,"P",{align:!0,"data-svelte-h":!0}),p(g)!=="svelte-1grq2s7"&&(g.innerHTML=is),bl=a(e),ye=r(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-qp6vlz"&&(ye.innerHTML=rs),wl=a(e),u(je.$$.fragment,e),Zl=a(e),U=r(e,"P",{align:!0,"data-svelte-h":!0}),p(U)!=="svelte-49gzme"&&(U.innerHTML=ps),Jl=a(e),be=r(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-1x72rsv"&&(be.textContent=cs),Tl=a(e),u(we.$$.fragment,e),gl=a(e),G=r(e,"P",{align:!0,"data-svelte-h":!0}),p(G)!=="svelte-14z2yp4"&&(G.innerHTML=us),Ul=a(e),Ze=r(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-hjjp2m"&&(Ze.innerHTML=ds),Gl=a(e),u(Je.$$.fragment,e),vl=a(e),v=r(e,"P",{align:!0,"data-svelte-h":!0}),p(v)!=="svelte-y1ydb2"&&(v.innerHTML=hs),Vl=a(e),Te=r(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-im52jk"&&(Te.textContent=Ms),kl=a(e),u(ge.$$.fragment,e),Wl=a(e),Ue=r(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-141dnef"&&(Ue.innerHTML=ms),_l=a(e),u(Ge.$$.fragment,e),$l=a(e),u(V.$$.fragment,e),Sl=a(e),Ve=r(e,"P",{}),fs(Ve).forEach(s),this.h()},h(){k(o,"name","hf:doc:metadata"),k(o,"content",Vs),k(J,"align","center"),k(T,"align","center"),k(g,"align","center"),k(U,"align","center"),k(G,"align","center"),k(v,"align","center")},m(e,l){Ts(document.head,o),t(e,W,l),t(e,w,l),t(e,j,l),d(Z,e,l),t(e,y,l),d(b,e,l),t(e,We,l),t(e,_,l),t(e,_e,l),t(e,$,l),t(e,$e,l),t(e,S,l),t(e,Se,l),t(e,x,l),t(e,xe,l),t(e,X,l),t(e,Xe,l),d(I,e,l),t(e,Ie,l),t(e,B,l),t(e,Be,l),d(N,e,l),t(e,Ne,l),t(e,C,l),t(e,Ce,l),d(R,e,l),t(e,Re,l),d(H,e,l),t(e,He,l),t(e,E,l),t(e,Ee,l),d(A,e,l),t(e,Ae,l),t(e,D,l),t(e,De,l),d(F,e,l),t(e,Fe,l),t(e,z,l),t(e,ze,l),d(L,e,l),t(e,Le,l),t(e,Q,l),t(e,Qe,l),d(Y,e,l),t(e,Ye,l),t(e,J,l),t(e,Pe,l),d(P,e,l),t(e,qe,l),t(e,q,l),t(e,Ke,l),d(K,e,l),t(e,Oe,l),t(e,O,l),t(e,el,l),d(ee,e,l),t(e,ll,l),t(e,le,l),t(e,sl,l),t(e,se,l),t(e,tl,l),t(e,te,l),t(e,nl,l),d(ne,e,l),t(e,al,l),t(e,ae,l),t(e,il,l),t(e,ie,l),t(e,rl,l),d(re,e,l),t(e,pl,l),t(e,pe,l),t(e,cl,l),d(ce,e,l),t(e,ul,l),t(e,ue,l),t(e,dl,l),d(de,e,l),t(e,hl,l),t(e,T,l),t(e,Ml,l),t(e,he,l),t(e,ml,l),d(Me,e,l),t(e,ol,l),t(e,me,l),t(e,fl,l),t(e,oe,l),t(e,yl,l),d(fe,e,l),t(e,jl,l),t(e,g,l),t(e,bl,l),t(e,ye,l),t(e,wl,l),d(je,e,l),t(e,Zl,l),t(e,U,l),t(e,Jl,l),t(e,be,l),t(e,Tl,l),d(we,e,l),t(e,gl,l),t(e,G,l),t(e,Ul,l),t(e,Ze,l),t(e,Gl,l),d(Je,e,l),t(e,vl,l),t(e,v,l),t(e,Vl,l),t(e,Te,l),t(e,kl,l),d(ge,e,l),t(e,Wl,l),t(e,Ue,l),t(e,_l,l),d(Ge,e,l),t(e,$l,l),d(V,e,l),t(e,Sl,l),t(e,Ve,l),xl=!0},p(e,[l]){const os={};l&2&&(os.$$scope={dirty:l,ctx:e}),V.$set(os)},i(e){xl||(h(Z.$$.fragment,e),h(b.$$.fragment,e),h(I.$$.fragment,e),h(N.$$.fragment,e),h(R.$$.fragment,e),h(H.$$.fragment,e),h(A.$$.fragment,e),h(F.$$.fragment,e),h(L.$$.fragment,e),h(Y.$$.fragment,e),h(P.$$.fragment,e),h(K.$$.fragment,e),h(ee.$$.fragment,e),h(ne.$$.fragment,e),h(re.$$.fragment,e),h(ce.$$.fragment,e),h(de.$$.fragment,e),h(Me.$$.fragment,e),h(fe.$$.fragment,e),h(je.$$.fragment,e),h(we.$$.fragment,e),h(Je.$$.fragment,e),h(ge.$$.fragment,e),h(Ge.$$.fragment,e),h(V.$$.fragment,e),xl=!0)},o(e){M(Z.$$.fragment,e),M(b.$$.fragment,e),M(I.$$.fragment,e),M(N.$$.fragment,e),M(R.$$.fragment,e),M(H.$$.fragment,e),M(A.$$.fragment,e),M(F.$$.fragment,e),M(L.$$.fragment,e),M(Y.$$.fragment,e),M(P.$$.fragment,e),M(K.$$.fragment,e),M(ee.$$.fragment,e),M(ne.$$.fragment,e),M(re.$$.fragment,e),M(ce.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(fe.$$.fragment,e),M(je.$$.fragment,e),M(we.$$.fragment,e),M(Je.$$.fragment,e),M(ge.$$.fragment,e),M(Ge.$$.fragment,e),M(V.$$.fragment,e),xl=!1},d(e){e&&(s(W),s(w),s(j),s(y),s(We),s(_),s(_e),s($),s($e),s(S),s(Se),s(x),s(xe),s(X),s(Xe),s(Ie),s(B),s(Be),s(Ne),s(C),s(Ce),s(Re),s(He),s(E),s(Ee),s(Ae),s(D),s(De),s(Fe),s(z),s(ze),s(Le),s(Q),s(Qe),s(Ye),s(J),s(Pe),s(qe),s(q),s(Ke),s(Oe),s(O),s(el),s(ll),s(le),s(sl),s(se),s(tl),s(te),s(nl),s(al),s(ae),s(il),s(ie),s(rl),s(pl),s(pe),s(cl),s(ul),s(ue),s(dl),s(hl),s(T),s(Ml),s(he),s(ml),s(ol),s(me),s(fl),s(oe),s(yl),s(jl),s(g),s(bl),s(ye),s(wl),s(Zl),s(U),s(Jl),s(be),s(Tl),s(gl),s(G),s(Ul),s(Ze),s(Gl),s(vl),s(v),s(Vl),s(Te),s(kl),s(Wl),s(Ue),s(_l),s($l),s(Sl),s(Ve)),s(o),m(Z,e),m(b,e),m(I,e),m(N,e),m(R,e),m(H,e),m(A,e),m(F,e),m(L,e),m(Y,e),m(P,e),m(K,e),m(ee,e),m(ne,e),m(re,e),m(ce,e),m(de,e),m(Me,e),m(fe,e),m(je,e),m(we,e),m(Je,e),m(ge,e),m(Ge,e),m(V,e)}}}const Vs='{"title":"Schedulers","local":"schedulers","sections":[{"title":"Load pipeline","local":"load-pipeline","sections":[],"depth":2},{"title":"Access the scheduler","local":"access-the-scheduler","sections":[],"depth":2},{"title":"Changing the scheduler","local":"changing-the-scheduler","sections":[],"depth":2},{"title":"Compare schedulers","local":"compare-schedulers","sections":[],"depth":2},{"title":"Changing the Scheduler in Flax","local":"changing-the-scheduler-in-flax","sections":[],"depth":2}],"depth":1}';function ks(ke){return js(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Is extends ws{constructor(o){super(),Zs(this,o,ks,vs,ys,{})}}export{Is as component};
