import{s as Sl,f as Ol,o as Yl,n as J}from"../chunks/scheduler.25b97de1.js";import{S as Ql,i as Kl,g as l,s as r,r as m,A as ec,h as c,f as o,c as n,j as T,u,x as _,k as w,y as s,a as i,v as h,d as g,t as f,w as v}from"../chunks/index.d9030fc9.js";import{T as je}from"../chunks/Tip.baa67368.js";import{D as $}from"../chunks/Docstring.e257edda.js";import{C as Ce}from"../chunks/CodeBlock.e6cd0d95.js";import{E as xe}from"../chunks/ExampleCodeBlock.20db4b6e.js";import{H as x,E as tc}from"../chunks/EditOnGithub.91d95064.js";function oc(j){let a,y='Perceiver does <strong>not</strong> work with <code>torch.nn.DataParallel</code> due to a bug in PyTorch, see <a href="https://github.com/pytorch/pytorch/issues/36035" rel="nofollow">issue #36035</a>';return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-1mrs8m2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function rc(j){let a,y="Example:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcmNlaXZlck1vZGVsJTJDJTIwUGVyY2VpdmVyQ29uZmlnJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMFBlcmNlaXZlciUyMGRlZXBtaW5kJTJGbGFuZ3VhZ2UtcGVyY2VpdmVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMFBlcmNlaXZlckNvbmZpZygpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGRlZXBtaW5kJTJGbGFuZ3VhZ2UtcGVyY2VpdmVyJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJNb2RlbChjb25maWd1cmF0aW9uKSUwQSUwQSUyMyUyMEFjY2Vzc2luZyUyMHRoZSUyMG1vZGVsJTIwY29uZmlndXJhdGlvbiUwQWNvbmZpZ3VyYXRpb24lMjAlM0QlMjBtb2RlbC5jb25maWc=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-11lpom8"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function nc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function sc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig(image_size=<span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function ac(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function ic(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJjZWl2ZXJGb3JNYXNrZWRMTSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JNYXNrZWRMTS5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBJTBBJTIzJTIwdHJhaW5pbmclMEF0ZXh0JTIwJTNEJTIwJTIyVGhpcyUyMGlzJTIwYW4lMjBpbmNvbXBsZXRlJTIwc2VudGVuY2UlMjB3aGVyZSUyMHNvbWUlMjB3b3JkcyUyMGFyZSUyMG1pc3NpbmcuJTIyJTBBaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHRleHQlMkMlMjBwYWRkaW5nJTNEJTIybWF4X2xlbmd0aCUyMiUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTBBJTIzJTIwbWFzayUyMCUyMiUyMG1pc3NpbmcuJTIyJTBBaW5wdXRzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDUyJTNBNjElNUQlMjAlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUwQWxhYmVscyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5pbnB1dF9pZHMlMEElMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKippbnB1dHMlMkMlMjBsYWJlbHMlM0RsYWJlbHMpJTBBbG9zcyUyMCUzRCUyMG91dHB1dHMubG9zcyUwQXJvdW5kKGxvc3MuaXRlbSgpJTJDJTIwMiklMEElMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKSUwQSUwQSUyMyUyMGluZmVyZW5jZSUwQXRleHQlMjAlM0QlMjAlMjJUaGlzJTIwaXMlMjBhbiUyMGluY29tcGxldGUlMjBzZW50ZW5jZSUyMHdoZXJlJTIwc29tZSUyMHdvcmRzJTIwYXJlJTIwbWlzc2luZy4lMjIlMEFlbmNvZGluZyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSUwQSUwQSUyMyUyMG1hc2slMjBieXRlcyUyMGNvcnJlc3BvbmRpbmclMjB0byUyMCUyMiUyMG1pc3NpbmcuJTIyLiUyME5vdGUlMjB0aGF0JTIwdGhlJTIwbW9kZWwlMjBwZXJmb3JtcyUyMG11Y2glMjBiZXR0ZXIlMjBpZiUyMHRoZSUyMG1hc2tlZCUyMHNwYW4lMjBzdGFydHMlMjB3aXRoJTIwYSUyMHNwYWNlLiUwQWVuY29kaW5nJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTVCMCUyQyUyMDUyJTNBNjElNUQlMjAlM0QlMjB0b2tlbml6ZXIubWFza190b2tlbl9pZCUwQSUwQSUyMyUyMGZvcndhcmQlMjBwYXNzJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmVuY29kaW5nKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBbWFza2VkX3Rva2Vuc19wcmVkaWN0aW9ucyUyMCUzRCUyMGxvZ2l0cyU1QjAlMkMlMjA1MiUzQTYxJTVELmFyZ21heChkaW0lM0QtMSkudG9saXN0KCklMEF0b2tlbml6ZXIuZGVjb2RlKG1hc2tlZF90b2tlbnNfcHJlZGljdGlvbnMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">19.87</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function lc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function cc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBQZXJjZWl2ZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZsYW5ndWFnZS1wZXJjZWl2ZXIlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRmxhbmd1YWdlLXBlcmNlaXZlciUyMiklMEElMEF0ZXh0JTIwJTNEJTIwJTIyaGVsbG8lMjB3b3JsZCUyMiUwQWlucHV0cyUyMCUzRCUyMHRva2VuaXplcih0ZXh0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikuaW5wdXRfaWRzJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyUzRGlucHV0cyklMEFsb2dpdHMlMjAlM0QlMjBvdXRwdXRzLmxvZ2l0cyUwQWxpc3QobG9naXRzLnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function dc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function pc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25MZWFybmVkJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItbGVhcm5lZCUyMiklMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25MZWFybmVkLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItbGVhcm5lZCUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTNEaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function mc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function uc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Gb3VyaWVyJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEF1cmwlMjAlM0QlMjAlMjJodHRwJTNBJTJGJTJGaW1hZ2VzLmNvY29kYXRhc2V0Lm9yZyUyRnZhbDIwMTclMkYwMDAwMDAwMzk3NjkuanBnJTIyJTBBaW1hZ2UlMjAlM0QlMjBJbWFnZS5vcGVuKHJlcXVlc3RzLmdldCh1cmwlMkMlMjBzdHJlYW0lM0RUcnVlKS5yYXcpJTBBJTBBaW1hZ2VfcHJvY2Vzc29yJTIwJTNEJTIwQXV0b0ltYWdlUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItZm91cmllciUyMiklMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Gb3VyaWVyLmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRnZpc2lvbi1wZXJjZWl2ZXItZm91cmllciUyMiklMEElMEFpbnB1dHMlMjAlM0QlMjBpbWFnZV9wcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKS5waXhlbF92YWx1ZXMlMEFvdXRwdXRzJTIwJTNEJTIwbW9kZWwoaW5wdXRzJTNEaW5wdXRzKSUwQWxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBbGlzdChsb2dpdHMuc2hhcGUpJTBBJTBBJTIzJTIwbW9kZWwlMjBwcmVkaWN0cyUyMG9uZSUyMG9mJTIwdGhlJTIwMTAwMCUyMEltYWdlTmV0JTIwY2xhc3NlcyUwQXByZWRpY3RlZF9jbGFzc19pZHglMjAlM0QlMjBsb2dpdHMuYXJnbWF4KC0xKS5pdGVtKCklMEFwcmludCglMjJQcmVkaWN0ZWQlMjBjbGFzcyUzQSUyMiUyQyUyMG1vZGVsLmNvbmZpZy5pZDJsYWJlbCU1QnByZWRpY3RlZF9jbGFzc19pZHglNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function hc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function gc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMFBlcmNlaXZlckZvckltYWdlQ2xhc3NpZmljYXRpb25Db252UHJvY2Vzc2luZyUwQWZyb20lMjBQSUwlMjBpbXBvcnQlMjBJbWFnZSUwQWltcG9ydCUyMHJlcXVlc3RzJTBBJTBBdXJsJTIwJTNEJTIwJTIyaHR0cCUzQSUyRiUyRmltYWdlcy5jb2NvZGF0YXNldC5vcmclMkZ2YWwyMDE3JTJGMDAwMDAwMDM5NzY5LmpwZyUyMiUwQWltYWdlJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQodXJsJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KSUwQSUwQWltYWdlX3Byb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZGVlcG1pbmQlMkZ2aXNpb24tcGVyY2VpdmVyLWNvbnYlMjIpJTBBbW9kZWwlMjAlM0QlMjBQZXJjZWl2ZXJGb3JJbWFnZUNsYXNzaWZpY2F0aW9uQ29udlByb2Nlc3NpbmcuZnJvbV9wcmV0cmFpbmVkKCUyMmRlZXBtaW5kJTJGdmlzaW9uLXBlcmNlaXZlci1jb252JTIyKSUwQSUwQWlucHV0cyUyMCUzRCUyMGltYWdlX3Byb2Nlc3NvcihpbWFnZXMlM0RpbWFnZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpLnBpeGVsX3ZhbHVlcyUwQW91dHB1dHMlMjAlM0QlMjBtb2RlbChpbnB1dHMlM0RpbnB1dHMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSklMEElMEElMjMlMjBtb2RlbCUyMHByZWRpY3RzJTIwb25lJTIwb2YlMjB0aGUlMjAxMDAwJTIwSW1hZ2VOZXQlMjBjbGFzc2VzJTBBcHJlZGljdGVkX2NsYXNzX2lkeCUyMCUzRCUyMGxvZ2l0cy5hcmdtYXgoLTEpLml0ZW0oKSUwQXByaW50KCUyMlByZWRpY3RlZCUyMGNsYXNzJTNBJTIyJTJDJTIwbW9kZWwuY29uZmlnLmlkMmxhYmVsJTVCcHJlZGljdGVkX2NsYXNzX2lkeCU1RCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function fc(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function vc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBlcmNlaXZlckZvck9wdGljYWxGbG93JTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMFBlcmNlaXZlckZvck9wdGljYWxGbG93LmZyb21fcHJldHJhaW5lZCglMjJkZWVwbWluZCUyRm9wdGljYWwtZmxvdy1wZXJjZWl2ZXIlMjIpJTBBJTBBJTIzJTIwaW4lMjB0aGUlMjBQZXJjZWl2ZXIlMjBJTyUyMHBhcGVyJTJDJTIwdGhlJTIwYXV0aG9ycyUyMGV4dHJhY3QlMjBhJTIwMyUyMHglMjAzJTIwcGF0Y2glMjBhcm91bmQlMjBlYWNoJTIwcGl4ZWwlMkMlMEElMjMlMjBsZWFkaW5nJTIwdG8lMjAzJTIweCUyMDMlMjB4JTIwMyUyMCUzRCUyMDI3JTIwdmFsdWVzJTIwZm9yJTIwZWFjaCUyMHBpeGVsJTIwKGFzJTIwZWFjaCUyMHBpeGVsJTIwYWxzbyUyMGhhcyUyMDMlMjBjb2xvciUyMGNoYW5uZWxzKSUwQSUyMyUyMHBhdGNoZXMlMjBoYXZlJTIwc2hhcGUlMjAoYmF0Y2hfc2l6ZSUyQyUyMG51bV9mcmFtZXMlMkMlMjBudW1fY2hhbm5lbHMlMkMlMjBoZWlnaHQlMkMlMjB3aWR0aCklMEElMjMlMjB0aGUlMjBhdXRob3JzJTIwdHJhaW4lMjBvbiUyMHJlc29sdXRpb25zJTIwb2YlMjAzNjglMjB4JTIwNDk2JTBBcGF0Y2hlcyUyMCUzRCUyMHRvcmNoLnJhbmRuKDElMkMlMjAyJTJDJTIwMjclMkMlMjAzNjglMkMlMjA0OTYpJTBBb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0cyUzRHBhdGNoZXMpJTBBbG9naXRzJTIwJTNEJTIwb3V0cHV0cy5sb2dpdHMlMEFsaXN0KGxvZ2l0cy5zaGFwZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>, <span class="hljs-number">2</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function _c(j){let a,y=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){a=l("p"),a.innerHTML=y},l(p){a=c(p,"P",{"data-svelte-h":!0}),_(a)!=="svelte-fincs2"&&(a.innerHTML=y)},m(p,b){i(p,a,b)},p:J,d(p){p&&o(a)}}}function bc(j){let a,y="Examples:",p,b,M;return b=new Ce({props:{code:"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",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;audio&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">240</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;image&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">6272</span>, <span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;label&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">700</span>]`,wrap:!1}}),{c(){a=l("p"),a.textContent=y,p=r(),m(b.$$.fragment)},l(d){a=c(d,"P",{"data-svelte-h":!0}),_(a)!=="svelte-kvfsh7"&&(a.textContent=y),p=n(d),u(b.$$.fragment,d)},m(d,P){i(d,a,P),i(d,p,P),h(b,d,P),M=!0},p:J,i(d){M||(g(b.$$.fragment,d),M=!0)},o(d){f(b.$$.fragment,d),M=!1},d(d){d&&(o(a),o(p)),v(b,d)}}}function yc(j){let a,y,p,b,M,d,P,dn,st,$i=`The Perceiver IO model was proposed in <a href="https://arxiv.org/abs/2107.14795" rel="nofollow">Perceiver IO: A General Architecture for Structured Inputs &amp;
Outputs</a> by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier Hénaff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, João Carreira.`,pn,at,ji=`Perceiver IO is a generalization of <a href="https://arxiv.org/abs/2103.03206" rel="nofollow">Perceiver</a> to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`,mn,it,xi="The abstract from the paper is the following:",un,lt,Ci=`<em>The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original’s appealing properties by learning to flexibly query the model’s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.</em>`,hn,ct,ki="Here’s a TLDR explaining how Perceiver works:",gn,dt,Ji=`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don’t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`,fn,pt,Ui=`Internally, <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> will create the latents, which is a tensor of shape <code>(batch_size, num_latents, d_latents)</code>. One must provide <code>inputs</code> (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the <code>d_latents</code> to <code>num_labels</code>.`,vn,mt,Ii=`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`,_n,ut,Fi=`So let’s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver’s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing <code>inputs</code> of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
<code>outputs</code> as being of shape: <code>(batch_size, 2048, 768)</code>. Next, one performs cross-attention with the final hidden states
of the latents to update the <code>outputs</code> tensor. After cross-attention, one still has a tensor of shape <code>(batch_size, 2048, 768)</code>. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape <code>(batch_size, 2048, 262)</code> (as Perceiver uses a vocabulary
size of 262 byte IDs).`,bn,ke,Zi,yn,ht,zi='Perceiver IO architecture. Taken from the <a href="https://arxiv.org/abs/2105.15203">original paper</a>',Mn,gt,Wi=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>. The original code can be found
<a href="https://github.com/deepmind/deepmind-research/tree/master/perceiver" rel="nofollow">here</a>.`,wn,Je,Tn,ft,Pn,vt,Bi=`<li>The quickest way to get started with the Perceiver is by checking the <a href="https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver" rel="nofollow">tutorial
notebooks</a>.</li> <li>Refer to the <a href="https://huggingface.co/blog/perceiver" rel="nofollow">blog post</a> if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.</li> <li><a href="../tasks/sequence_classification">Text classification task guide</a></li> <li><a href="../tasks/masked_language_modeling">Masked language modeling task guide</a></li> <li><a href="../tasks/image_classification">Image classification task guide</a></li>`,$n,_t,jn,ae,bt,Gs,Lo,Ni="Base class for Perceiver base model’s outputs, with potential hidden states, attentions and cross-attentions.",xn,ie,yt,Vs,Ao,qi="Base class for Perceiver decoder outputs, with potential cross-attentions.",Cn,le,Mt,Hs,So,Gi="Base class for Perceiver’s masked language model outputs.",kn,ce,wt,Xs,Oo,Vi=`Base class for Perceiver’s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`,Jn,Tt,Un,z,Pt,Rs,Yo,Hi=`This is the configuration class to store the configuration of a <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
<a href="https://huggingface.co/deepmind/language-perceiver" rel="nofollow">deepmind/language-perceiver</a> architecture.`,Ds,Qo,Xi=`Configuration objects inherit from <a href="/docs/transformers/v4.41.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/v4.41.3/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,Es,Ue,In,$t,Fn,W,jt,Ls,Ko,Ri="Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding.",As,er,Di=`This tokenizer inherits from <a href="/docs/transformers/v4.41.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizer">PreTrainedTokenizer</a> which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`,Ss,Ie,xt,Os,tr,Ei=`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`,Zn,Ct,zn,de,kt,Ys,Fe,Jt,Qs,or,Li="Preprocess an image or a batch of images.",Wn,Ut,Bn,A,It,Ks,rr,Ai="Constructs a Perceiver image processor.",ea,Ze,Ft,ta,nr,Si="Preprocess an image or batch of images.",Nn,Zt,qn,S,zt,oa,sr,Oi="Text preprocessing for Perceiver Encoder. Can be used to embed <code>inputs</code> and add positional encodings.",ra,ar,Yi="The dimensionality of the embeddings is determined by the <code>d_model</code> attribute of the configuration.",Gn,Wt,Vn,O,Bt,na,ir,Qi="Image preprocessing for Perceiver Encoder.",sa,lr,Ki=`Note: the <em>out_channels</em> argument refers to the output channels of a convolutional layer, if <em>prep_type</em> is set to
“conv1x1” or “conv”. If one adds absolute position embeddings, one must make sure the <em>num_channels</em> of the
position encoding kwargs are set equal to the <em>out_channels</em>.`,Hn,Nt,Xn,pe,qt,aa,cr,el="One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input.",Rn,Gt,Dn,me,Vt,ia,dr,tl="Audio preprocessing for Perceiver Encoder.",En,Ht,Ln,Y,Xt,la,pr,ol="Multimodal preprocessing for Perceiver Encoder.",ca,mr,rl=`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`,An,Rt,Sn,ue,Dt,da,ur,nl="Baseline projection decoder (no cross-attention).",On,Et,Yn,Q,Lt,pa,hr,sl=`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`,ma,gr,al="The shape of the output of this class depends on how one defines the output queries (also called decoder queries).",Qn,At,Kn,he,St,ua,fr,il=`Cross-attention based classification decoder. Light-weight wrapper of <code>PerceiverBasicDecoder</code> for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`,es,Ot,ts,ge,Yt,ha,vr,ll="Cross-attention based optical flow decoder.",os,Qt,rs,fe,Kt,ga,_r,cl=`Cross-attention based video-autoencoding decoder. Light-weight wrapper of [<em>PerceiverBasicDecoder</em>] with video
reshaping logic.`,ns,eo,ss,K,to,fa,br,dl=`Multimodal decoding by composing uni-modal decoders. The <em>modalities</em> argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`,va,yr,pl="Next, there is a shared cross attention operation across all modalities.",as,oo,is,ve,ro,_a,Mr,ml=`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`,ls,no,cs,_e,so,ba,wr,ul="Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features.",ds,ao,ps,be,io,ya,Tr,hl="Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits.",ms,lo,us,ye,co,Ma,Pr,gl=`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`,hs,po,gs,ee,mo,wa,$r,fl=`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ta,B,uo,Pa,jr,vl='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> forward method, overrides the <code>__call__</code> special method.',$a,ze,ja,We,fs,ho,vs,te,go,xa,xr,_l=`Example use of Perceiver for masked language modeling.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Ca,N,fo,ka,Cr,bl='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForMaskedLM">PerceiverForMaskedLM</a> forward method, overrides the <code>__call__</code> special method.',Ja,Be,Ua,Ne,_s,vo,bs,oe,_o,Ia,kr,yl=`Example use of Perceiver for text classification.
This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Fa,q,bo,Za,Jr,Ml='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification">PerceiverForSequenceClassification</a> forward method, overrides the <code>__call__</code> special method.',za,qe,Wa,Ge,ys,yo,Ms,U,Mo,Ba,Ur,wl="Example use of Perceiver for image classification, for tasks such as ImageNet.",Na,Ir,Tl=`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`,qa,Fr,Pl=`<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;conv1x1&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,Ga,Zr,$l=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Va,G,wo,Ha,zr,jl='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> forward method, overrides the <code>__call__</code> special method.',Xa,Ve,Ra,He,ws,To,Ts,I,Po,Da,Wr,xl="Example use of Perceiver for image classification, for tasks such as ImageNet.",Ea,Br,Cl=`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`,La,Nr,kl=`<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;pixels&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,Aa,qr,Jl=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Sa,V,$o,Oa,Gr,Ul='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier">PerceiverForImageClassificationFourier</a> forward method, overrides the <code>__call__</code> special method.',Ya,Xe,Qa,Re,Ps,jo,$s,F,xo,Ka,Vr,Il="Example use of Perceiver for image classification, for tasks such as ImageNet.",ei,Hr,Fl=`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`,ti,Xr,Zl=`<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a> uses <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a>
(with <code>prep_type=&quot;conv&quot;</code>) to preprocess the input images, and
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder">PerceiverClassificationDecoder</a> to decode the latent representation of
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a> into classification logits.`,oi,Rr,zl=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,ri,H,Co,ni,Dr,Wl='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing">PerceiverForImageClassificationConvProcessing</a> forward method, overrides the <code>__call__</code> special method.',si,De,ai,Ee,js,ko,xs,Z,Jo,ii,Er,Bl=`Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a> uses
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor">PerceiverImagePreprocessor</a> (with <em>prep_type=“patches”</em>) to preprocess the
input images, and <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder">PerceiverOpticalFlowDecoder</a> to decode the latent
representation of <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>.`,li,Lr,Nl=`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`,ci,Ar,ql=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,di,X,Uo,pi,Sr,Gl='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow">PerceiverForOpticalFlow</a> forward method, overrides the <code>__call__</code> special method.',mi,Le,ui,Ae,Cs,Io,ks,C,Fo,hi,Or,Vl="Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700.",gi,Yr,Hl=`<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a> uses <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor">PerceiverMultimodalPreprocessor</a> to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`,fi,Qr,Xl=`<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder">PerceiverMultimodalDecoder</a> is used to decode the latent representation of
<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a>.`,vi,Kr,Rl=`<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder">PerceiverMultimodalDecoder</a> also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverModel">PerceiverModel</a>.`,_i,en,Dl=`Finally, <code>~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor</code> is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`,bi,tn,El=`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
“label” modality), this auto-encoding model becomes a Kinetics 700 video classifier.`,yi,on,Ll=`This model is a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`,Mi,R,Zo,wi,rn,Al='The <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding">PerceiverForMultimodalAutoencoding</a> forward method, overrides the <code>__call__</code> special method.',Ti,Se,Pi,Oe,Js,zo,Us,cn,Is;return M=new x({props:{title:"Perceiver",local:"perceiver",headingTag:"h1"}}),P=new x({props:{title:"Overview",local:"overview",headingTag:"h2"}}),Je=new je({props:{warning:!0,$$slots:{default:[oc]},$$scope:{ctx:j}}}),ft=new x({props:{title:"Resources",local:"resources",headingTag:"h2"}}),_t=new x({props:{title:"Perceiver specific outputs",local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",headingTag:"h2"}}),bt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L55"}}),yt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L86"}}),Mt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L104"}}),wt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": Optional = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": Optional = None"},{name:"attentions",val:": Optional = None"},{name:"cross_attentions",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L135"}}),Tt=new x({props:{title:"PerceiverConfig",local:"transformers.PerceiverConfig",headingTag:"h2"}}),Pt=new $({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"output_num_channels",val:" = 512"},{name:"_label_trainable_num_channels",val:" = 1024"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;kv&quot;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[368, 496]</code>) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"},{anchor:"transformers.PerceiverConfig.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 512) &#x2014;
Number of output channels for each modalitiy decoder.`,name:"output_num_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/configuration_perceiver.py#L31"}}),Ue=new xe({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[rc]},$$scope:{ctx:j}}}),$t=new x({props:{title:"PerceiverTokenizer",local:"transformers.PerceiverTokenizer",headingTag:"h2"}}),jt=new $({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/tokenization_perceiver.py#L27"}}),xt=new $({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": Union = None"},{name:"text_pair",val:": Union = None"},{name:"text_target",val:": Union = None"},{name:"text_pair_target",val:": Union = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": Union = False"},{name:"truncation",val:": Union = None"},{name:"max_length",val:": Optional = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": Optional = None"},{name:"return_tensors",val:": Union = None"},{name:"return_token_type_ids",val:": Optional = None"},{name:"return_attention_mask",val:": Optional = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to add special tokens when encoding the sequences. This will use the underlying
<code>PretrainedTokenizerBase.build_inputs_with_special_tokens</code> function, which defines which tokens are
automatically added to the input ids. This is usefull if you want to add <code>bos</code> or <code>eos</code> tokens
automatically.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.41.3/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.41.3/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. Requires <code>padding</code> to be activated.
This is especially useful to enable the use of Tensor Cores on NVIDIA hardware with compute capability
<code>&gt;= 7.5</code> (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.41.3/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/v4.41.3/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/tokenization_utils_base.py#L2809",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> — List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> — List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>“token_type_ids”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> — List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>“attention_mask”</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> — List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> — Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> — List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> — The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),Ct=new x({props:{title:"PerceiverFeatureExtractor",local:"transformers.PerceiverFeatureExtractor",headingTag:"h2"}}),kt=new $({props:{name:"class transformers.PerceiverFeatureExtractor",anchor:"transformers.PerceiverFeatureExtractor",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/feature_extraction_perceiver.py#L26"}}),Jt=new $({props:{name:"__call__",anchor:"transformers.PerceiverFeatureExtractor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/image_processing_utils.py#L549"}}),Ut=new x({props:{title:"PerceiverImageProcessor",local:"transformers.PerceiverImageProcessor",headingTag:"h2"}}),It=new $({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": Dict = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": Dict = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": Union = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/image_processing_perceiver.py#L48"}}),Ft=new $({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessor.preprocess",parameters:[{name:"images",val:": Union"},{name:"do_center_crop",val:": Optional = None"},{name:"crop_size",val:": Optional = None"},{name:"do_resize",val:": Optional = None"},{name:"size",val:": Optional = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": Optional = None"},{name:"rescale_factor",val:": Optional = None"},{name:"do_normalize",val:": Optional = None"},{name:"image_mean",val:": Union = None"},{name:"image_std",val:": Union = None"},{name:"return_tensors",val:": Union = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": Union = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to <code>crop_size</code>.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Desired output size after applying the center crop.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"},{anchor:"transformers.PerceiverImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/image_processing_perceiver.py#L227"}}),Zt=new x({props:{title:"PerceiverTextPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",headingTag:"h2"}}),zt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2841"}}),Wt=new x({props:{title:"PerceiverImagePreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",headingTag:"h2"}}),Bt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2998"}}),Nt=new x({props:{title:"PerceiverOneHotPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",headingTag:"h2"}}),qt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L3227"}}),Gt=new x({props:{title:"PerceiverAudioPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",headingTag:"h2"}}),Vt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L3253"}}),Ht=new x({props:{title:"PerceiverMultimodalPreprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",headingTag:"h2"}}),Xt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": Mapping"},{name:"mask_probs",val:": Optional = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L3350"}}),Rt=new x({props:{title:"PerceiverProjectionDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",headingTag:"h2"}}),Dt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2046"}}),Et=new x({props:{title:"PerceiverBasicDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",headingTag:"h2"}}),Lt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": Optional = 'trainable'"},{name:"output_index_dims",val:": Optional = None"},{name:"num_channels",val:": Optional = 128"},{name:"subsampled_index_dims",val:": Optional = None"},{name:"qk_channels",val:": Optional = None"},{name:"v_channels",val:": Optional = None"},{name:"num_heads",val:": Optional = 1"},{name:"widening_factor",val:": Optional = 1"},{name:"use_query_residual",val:": Optional = False"},{name:"concat_preprocessed_input",val:": Optional = False"},{name:"final_project",val:": Optional = True"},{name:"position_encoding_only",val:": Optional = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2072"}}),At=new x({props:{title:"PerceiverClassificationDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",headingTag:"h2"}}),St=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2258"}}),Ot=new x({props:{title:"PerceiverOpticalFlowDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",headingTag:"h2"}}),Yt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2304"}}),Qt=new x({props:{title:"PerceiverBasicVideoAutoencodingDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",headingTag:"h2"}}),Kt=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": List"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2339"}}),eo=new x({props:{title:"PerceiverMultimodalDecoder",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",headingTag:"h2"}}),to=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": Dict"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": Optional = 2"},{name:"subsampled_index_dims",val:": Optional = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2416"}}),oo=new x({props:{title:"PerceiverProjectionPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",headingTag:"h2"}}),ro=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2977"}}),no=new x({props:{title:"PerceiverAudioPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",headingTag:"h2"}}),so=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2950"}}),ao=new x({props:{title:"PerceiverClassificationPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",headingTag:"h2"}}),io=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2930"}}),lo=new x({props:{title:"PerceiverMultimodalPostprocessor",local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",headingTag:"h2"}}),co=new $({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": Mapping"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Mapping[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L2896"}}),po=new x({props:{title:"PerceiverModel",local:"transformers.PerceiverModel",headingTag:"h2"}}),mo=new $({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": Callable = None"},{name:"output_postprocessor",val:": Callable = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L707"}}),uo=new $({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": Optional = None"},{name:"subsampled_output_points",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L747",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) — Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ze=new je({props:{$$slots:{default:[nc]},$$scope:{ctx:j}}}),We=new xe({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[sc]},$$scope:{ctx:j}}}),ho=new x({props:{title:"PerceiverForMaskedLM",local:"transformers.PerceiverForMaskedLM",headingTag:"h2"}}),go=new $({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L948"}}),fo=new $({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"input_ids",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L981",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Be=new je({props:{$$slots:{default:[ac]},$$scope:{ctx:j}}}),Ne=new xe({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[ic]},$$scope:{ctx:j}}}),vo=new x({props:{title:"PerceiverForSequenceClassification",local:"transformers.PerceiverForSequenceClassification",headingTag:"h2"}}),_o=new $({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1083"}}),bo=new $({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"input_ids",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1105",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),qe=new je({props:{$$slots:{default:[lc]},$$scope:{ctx:j}}}),Ge=new xe({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[cc]},$$scope:{ctx:j}}}),yo=new x({props:{title:"PerceiverForImageClassificationLearned",local:"transformers.PerceiverForImageClassificationLearned",headingTag:"h2"}}),Mo=new $({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1195"}}),wo=new $({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1240",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Ve=new je({props:{$$slots:{default:[dc]},$$scope:{ctx:j}}}),He=new xe({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[pc]},$$scope:{ctx:j}}}),To=new x({props:{title:"PerceiverForImageClassificationFourier",local:"transformers.PerceiverForImageClassificationFourier",headingTag:"h2"}}),Po=new $({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1338"}}),$o=new $({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1384",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Xe=new je({props:{$$slots:{default:[mc]},$$scope:{ctx:j}}}),Re=new xe({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[uc]},$$scope:{ctx:j}}}),jo=new x({props:{title:"PerceiverForImageClassificationConvProcessing",local:"transformers.PerceiverForImageClassificationConvProcessing",headingTag:"h2"}}),xo=new $({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1481"}}),Co=new $({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"},{name:"pixel_values",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1528",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),De=new je({props:{$$slots:{default:[hc]},$$scope:{ctx:j}}}),Ee=new xe({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[gc]},$$scope:{ctx:j}}}),ko=new x({props:{title:"PerceiverForOpticalFlow",local:"transformers.PerceiverForOpticalFlow",headingTag:"h2"}}),Jo=new $({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1625"}}),Uo=new $({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1689",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Le=new je({props:{$$slots:{default:[fc]},$$scope:{ctx:j}}}),Ae=new xe({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[vc]},$$scope:{ctx:j}}}),Io=new x({props:{title:"PerceiverForMultimodalAutoencoding",local:"transformers.PerceiverForMultimodalAutoencoding",headingTag:"h2"}}),Fo=new $({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.41.3/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1754"}}),Zo=new $({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"subsampled_output_points",val:": Optional = None"},{name:"head_mask",val:": Optional = None"},{name:"output_attentions",val:": Optional = None"},{name:"output_hidden_states",val:": Optional = None"},{name:"labels",val:": Optional = None"},{name:"return_dict",val:": Optional = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.41.3/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.41.3/src/transformers/models/perceiver/modeling_perceiver.py#L1900",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) — Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder’s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/transformers/v4.41.3/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Se=new je({props:{$$slots:{default:[_c]},$$scope:{ctx:j}}}),Oe=new xe({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[bc]},$$scope:{ctx:j}}}),zo=new tc({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/perceiver.md"}}),{c(){a=l("meta"),y=r(),p=l("p"),b=r(),m(M.$$.fragment),d=r(),m(P.$$.fragment),dn=r(),st=l("p"),st.innerHTML=$i,pn=r(),at=l("p"),at.innerHTML=ji,mn=r(),it=l("p"),it.textContent=xi,un=r(),lt=l("p"),lt.innerHTML=Ci,hn=r(),ct=l("p"),ct.textContent=ki,gn=r(),dt=l("p"),dt.textContent=Ji,fn=r(),pt=l("p"),pt.innerHTML=Ui,vn=r(),mt=l("p"),mt.textContent=Ii,_n=r(),ut=l("p"),ut.innerHTML=Fi,bn=r(),ke=l("img"),yn=r(),ht=l("small"),ht.innerHTML=zi,Mn=r(),gt=l("p"),gt.innerHTML=Wi,wn=r(),m(Je.$$.fragment),Tn=r(),m(ft.$$.fragment),Pn=r(),vt=l("ul"),vt.innerHTML=Bi,$n=r(),m(_t.$$.fragment),jn=r(),ae=l("div"),m(bt.$$.fragment),Gs=r(),Lo=l("p"),Lo.textContent=Ni,xn=r(),ie=l("div"),m(yt.$$.fragment),Vs=r(),Ao=l("p"),Ao.textContent=qi,Cn=r(),le=l("div"),m(Mt.$$.fragment),Hs=r(),So=l("p"),So.textContent=Gi,kn=r(),ce=l("div"),m(wt.$$.fragment),Xs=r(),Oo=l("p"),Oo.textContent=Vi,Jn=r(),m(Tt.$$.fragment),Un=r(),z=l("div"),m(Pt.$$.fragment),Rs=r(),Yo=l("p"),Yo.innerHTML=Hi,Ds=r(),Qo=l("p"),Qo.innerHTML=Xi,Es=r(),m(Ue.$$.fragment),In=r(),m($t.$$.fragment),Fn=r(),W=l("div"),m(jt.$$.fragment),Ls=r(),Ko=l("p"),Ko.textContent=Ri,As=r(),er=l("p"),er.innerHTML=Di,Ss=r(),Ie=l("div"),m(xt.$$.fragment),Os=r(),tr=l("p"),tr.textContent=Ei,Zn=r(),m(Ct.$$.fragment),zn=r(),de=l("div"),m(kt.$$.fragment),Ys=r(),Fe=l("div"),m(Jt.$$.fragment),Qs=r(),or=l("p"),or.textContent=Li,Wn=r(),m(Ut.$$.fragment),Bn=r(),A=l("div"),m(It.$$.fragment),Ks=r(),rr=l("p"),rr.textContent=Ai,ea=r(),Ze=l("div"),m(Ft.$$.fragment),ta=r(),nr=l("p"),nr.textContent=Si,Nn=r(),m(Zt.$$.fragment),qn=r(),S=l("div"),m(zt.$$.fragment),oa=r(),sr=l("p"),sr.innerHTML=Oi,ra=r(),ar=l("p"),ar.innerHTML=Yi,Gn=r(),m(Wt.$$.fragment),Vn=r(),O=l("div"),m(Bt.$$.fragment),na=r(),ir=l("p"),ir.textContent=Qi,sa=r(),lr=l("p"),lr.innerHTML=Ki,Hn=r(),m(Nt.$$.fragment),Xn=r(),pe=l("div"),m(qt.$$.fragment),aa=r(),cr=l("p"),cr.textContent=el,Rn=r(),m(Gt.$$.fragment),Dn=r(),me=l("div"),m(Vt.$$.fragment),ia=r(),dr=l("p"),dr.textContent=tl,En=r(),m(Ht.$$.fragment),Ln=r(),Y=l("div"),m(Xt.$$.fragment),la=r(),pr=l("p"),pr.textContent=ol,ca=r(),mr=l("p"),mr.textContent=rl,An=r(),m(Rt.$$.fragment),Sn=r(),ue=l("div"),m(Dt.$$.fragment),da=r(),ur=l("p"),ur.textContent=nl,On=r(),m(Et.$$.fragment),Yn=r(),Q=l("div"),m(Lt.$$.fragment),pa=r(),hr=l("p"),hr.textContent=sl,ma=r(),gr=l("p"),gr.textContent=al,Qn=r(),m(At.$$.fragment),Kn=r(),he=l("div"),m(St.$$.fragment),ua=r(),fr=l("p"),fr.innerHTML=il,es=r(),m(Ot.$$.fragment),ts=r(),ge=l("div"),m(Yt.$$.fragment),ha=r(),vr=l("p"),vr.textContent=ll,os=r(),m(Qt.$$.fragment),rs=r(),fe=l("div"),m(Kt.$$.fragment),ga=r(),_r=l("p"),_r.innerHTML=cl,ns=r(),m(eo.$$.fragment),ss=r(),K=l("div"),m(to.$$.fragment),fa=r(),br=l("p"),br.innerHTML=dl,va=r(),yr=l("p"),yr.textContent=pl,as=r(),m(oo.$$.fragment),is=r(),ve=l("div"),m(ro.$$.fragment),_a=r(),Mr=l("p"),Mr.textContent=ml,ls=r(),m(no.$$.fragment),cs=r(),_e=l("div"),m(so.$$.fragment),ba=r(),wr=l("p"),wr.textContent=ul,ds=r(),m(ao.$$.fragment),ps=r(),be=l("div"),m(io.$$.fragment),ya=r(),Tr=l("p"),Tr.textContent=hl,ms=r(),m(lo.$$.fragment),us=r(),ye=l("div"),m(co.$$.fragment),Ma=r(),Pr=l("p"),Pr.textContent=gl,hs=r(),m(po.$$.fragment),gs=r(),ee=l("div"),m(mo.$$.fragment),wa=r(),$r=l("p"),$r.innerHTML=fl,Ta=r(),B=l("div"),m(uo.$$.fragment),Pa=r(),jr=l("p"),jr.innerHTML=vl,$a=r(),m(ze.$$.fragment),ja=r(),m(We.$$.fragment),fs=r(),m(ho.$$.fragment),vs=r(),te=l("div"),m(go.$$.fragment),xa=r(),xr=l("p"),xr.innerHTML=_l,Ca=r(),N=l("div"),m(fo.$$.fragment),ka=r(),Cr=l("p"),Cr.innerHTML=bl,Ja=r(),m(Be.$$.fragment),Ua=r(),m(Ne.$$.fragment),_s=r(),m(vo.$$.fragment),bs=r(),oe=l("div"),m(_o.$$.fragment),Ia=r(),kr=l("p"),kr.innerHTML=yl,Fa=r(),q=l("div"),m(bo.$$.fragment),Za=r(),Jr=l("p"),Jr.innerHTML=Ml,za=r(),m(qe.$$.fragment),Wa=r(),m(Ge.$$.fragment),ys=r(),m(yo.$$.fragment),Ms=r(),U=l("div"),m(Mo.$$.fragment),Ba=r(),Ur=l("p"),Ur.textContent=wl,Na=r(),Ir=l("p"),Ir.textContent=Tl,qa=r(),Fr=l("p"),Fr.innerHTML=Pl,Ga=r(),Zr=l("p"),Zr.innerHTML=$l,Va=r(),G=l("div"),m(wo.$$.fragment),Ha=r(),zr=l("p"),zr.innerHTML=jl,Xa=r(),m(Ve.$$.fragment),Ra=r(),m(He.$$.fragment),ws=r(),m(To.$$.fragment),Ts=r(),I=l("div"),m(Po.$$.fragment),Da=r(),Wr=l("p"),Wr.textContent=xl,Ea=r(),Br=l("p"),Br.textContent=Cl,La=r(),Nr=l("p"),Nr.innerHTML=kl,Aa=r(),qr=l("p"),qr.innerHTML=Jl,Sa=r(),V=l("div"),m($o.$$.fragment),Oa=r(),Gr=l("p"),Gr.innerHTML=Ul,Ya=r(),m(Xe.$$.fragment),Qa=r(),m(Re.$$.fragment),Ps=r(),m(jo.$$.fragment),$s=r(),F=l("div"),m(xo.$$.fragment),Ka=r(),Vr=l("p"),Vr.textContent=Il,ei=r(),Hr=l("p"),Hr.textContent=Fl,ti=r(),Xr=l("p"),Xr.innerHTML=Zl,oi=r(),Rr=l("p"),Rr.innerHTML=zl,ri=r(),H=l("div"),m(Co.$$.fragment),ni=r(),Dr=l("p"),Dr.innerHTML=Wl,si=r(),m(De.$$.fragment),ai=r(),m(Ee.$$.fragment),js=r(),m(ko.$$.fragment),xs=r(),Z=l("div"),m(Jo.$$.fragment),ii=r(),Er=l("p"),Er.innerHTML=Bl,li=r(),Lr=l("p"),Lr.textContent=Nl,ci=r(),Ar=l("p"),Ar.innerHTML=ql,di=r(),X=l("div"),m(Uo.$$.fragment),pi=r(),Sr=l("p"),Sr.innerHTML=Gl,mi=r(),m(Le.$$.fragment),ui=r(),m(Ae.$$.fragment),Cs=r(),m(Io.$$.fragment),ks=r(),C=l("div"),m(Fo.$$.fragment),hi=r(),Or=l("p"),Or.textContent=Vl,gi=r(),Yr=l("p"),Yr.innerHTML=Hl,fi=r(),Qr=l("p"),Qr.innerHTML=Xl,vi=r(),Kr=l("p"),Kr.innerHTML=Rl,_i=r(),en=l("p"),en.innerHTML=Dl,bi=r(),tn=l("p"),tn.textContent=El,yi=r(),on=l("p"),on.innerHTML=Ll,Mi=r(),R=l("div"),m(Zo.$$.fragment),wi=r(),rn=l("p"),rn.innerHTML=Al,Ti=r(),m(Se.$$.fragment),Pi=r(),m(Oe.$$.fragment),Js=r(),m(zo.$$.fragment),Us=r(),cn=l("p"),this.h()},l(e){const t=ec("svelte-u9bgzb",document.head);a=c(t,"META",{name:!0,content:!0}),t.forEach(o),y=n(e),p=c(e,"P",{}),T(p).forEach(o),b=n(e),u(M.$$.fragment,e),d=n(e),u(P.$$.fragment,e),dn=n(e),st=c(e,"P",{"data-svelte-h":!0}),_(st)!=="svelte-1q9pjug"&&(st.innerHTML=$i),pn=n(e),at=c(e,"P",{"data-svelte-h":!0}),_(at)!=="svelte-tt6rit"&&(at.innerHTML=ji),mn=n(e),it=c(e,"P",{"data-svelte-h":!0}),_(it)!=="svelte-vfdo9a"&&(it.textContent=xi),un=n(e),lt=c(e,"P",{"data-svelte-h":!0}),_(lt)!=="svelte-1jljul4"&&(lt.innerHTML=Ci),hn=n(e),ct=c(e,"P",{"data-svelte-h":!0}),_(ct)!=="svelte-l4zudt"&&(ct.textContent=ki),gn=n(e),dt=c(e,"P",{"data-svelte-h":!0}),_(dt)!=="svelte-12eh3gr"&&(dt.textContent=Ji),fn=n(e),pt=c(e,"P",{"data-svelte-h":!0}),_(pt)!=="svelte-r7a35s"&&(pt.innerHTML=Ui),vn=n(e),mt=c(e,"P",{"data-svelte-h":!0}),_(mt)!=="svelte-490sb6"&&(mt.textContent=Ii),_n=n(e),ut=c(e,"P",{"data-svelte-h":!0}),_(ut)!=="svelte-9ljddx"&&(ut.innerHTML=Fi),bn=n(e),ke=c(e,"IMG",{src:!0,alt:!0,width:!0}),yn=n(e),ht=c(e,"SMALL",{"data-svelte-h":!0}),_(ht)!=="svelte-d9mm9q"&&(ht.innerHTML=zi),Mn=n(e),gt=c(e,"P",{"data-svelte-h":!0}),_(gt)!=="svelte-1mhzktt"&&(gt.innerHTML=Wi),wn=n(e),u(Je.$$.fragment,e),Tn=n(e),u(ft.$$.fragment,e),Pn=n(e),vt=c(e,"UL",{"data-svelte-h":!0}),_(vt)!=="svelte-7v41tc"&&(vt.innerHTML=Bi),$n=n(e),u(_t.$$.fragment,e),jn=n(e),ae=c(e,"DIV",{class:!0});var Wo=T(ae);u(bt.$$.fragment,Wo),Gs=n(Wo),Lo=c(Wo,"P",{"data-svelte-h":!0}),_(Lo)!=="svelte-13fgwy5"&&(Lo.textContent=Ni),Wo.forEach(o),xn=n(e),ie=c(e,"DIV",{class:!0});var Bo=T(ie);u(yt.$$.fragment,Bo),Vs=n(Bo),Ao=c(Bo,"P",{"data-svelte-h":!0}),_(Ao)!=="svelte-19jhdk9"&&(Ao.textContent=qi),Bo.forEach(o),Cn=n(e),le=c(e,"DIV",{class:!0});var No=T(le);u(Mt.$$.fragment,No),Hs=n(No),So=c(No,"P",{"data-svelte-h":!0}),_(So)!=="svelte-m841rf"&&(So.textContent=Gi),No.forEach(o),kn=n(e),ce=c(e,"DIV",{class:!0});var qo=T(ce);u(wt.$$.fragment,qo),Xs=n(qo),Oo=c(qo,"P",{"data-svelte-h":!0}),_(Oo)!=="svelte-soa7d4"&&(Oo.textContent=Vi),qo.forEach(o),Jn=n(e),u(Tt.$$.fragment,e),Un=n(e),z=c(e,"DIV",{class:!0});var re=T(z);u(Pt.$$.fragment,re),Rs=n(re),Yo=c(re,"P",{"data-svelte-h":!0}),_(Yo)!=="svelte-1r80lbh"&&(Yo.innerHTML=Hi),Ds=n(re),Qo=c(re,"P",{"data-svelte-h":!0}),_(Qo)!=="svelte-1fgwnf"&&(Qo.innerHTML=Xi),Es=n(re),u(Ue.$$.fragment,re),re.forEach(o),In=n(e),u($t.$$.fragment,e),Fn=n(e),W=c(e,"DIV",{class:!0});var ne=T(W);u(jt.$$.fragment,ne),Ls=n(ne),Ko=c(ne,"P",{"data-svelte-h":!0}),_(Ko)!=="svelte-qvnww0"&&(Ko.textContent=Ri),As=n(ne),er=c(ne,"P",{"data-svelte-h":!0}),_(er)!=="svelte-t68on5"&&(er.innerHTML=Di),Ss=n(ne),Ie=c(ne,"DIV",{class:!0});var Go=T(Ie);u(xt.$$.fragment,Go),Os=n(Go),tr=c(Go,"P",{"data-svelte-h":!0}),_(tr)!=="svelte-kpxj0c"&&(tr.textContent=Ei),Go.forEach(o),ne.forEach(o),Zn=n(e),u(Ct.$$.fragment,e),zn=n(e),de=c(e,"DIV",{class:!0});var Vo=T(de);u(kt.$$.fragment,Vo),Ys=n(Vo),Fe=c(Vo,"DIV",{class:!0});var Ho=T(Fe);u(Jt.$$.fragment,Ho),Qs=n(Ho),or=c(Ho,"P",{"data-svelte-h":!0}),_(or)!=="svelte-khengj"&&(or.textContent=Li),Ho.forEach(o),Vo.forEach(o),Wn=n(e),u(Ut.$$.fragment,e),Bn=n(e),A=c(e,"DIV",{class:!0});var Me=T(A);u(It.$$.fragment,Me),Ks=n(Me),rr=c(Me,"P",{"data-svelte-h":!0}),_(rr)!=="svelte-2cuwar"&&(rr.textContent=Ai),ea=n(Me),Ze=c(Me,"DIV",{class:!0});var Xo=T(Ze);u(Ft.$$.fragment,Xo),ta=n(Xo),nr=c(Xo,"P",{"data-svelte-h":!0}),_(nr)!=="svelte-1x3yxsa"&&(nr.textContent=Si),Xo.forEach(o),Me.forEach(o),Nn=n(e),u(Zt.$$.fragment,e),qn=n(e),S=c(e,"DIV",{class:!0});var we=T(S);u(zt.$$.fragment,we),oa=n(we),sr=c(we,"P",{"data-svelte-h":!0}),_(sr)!=="svelte-14oxh6f"&&(sr.innerHTML=Oi),ra=n(we),ar=c(we,"P",{"data-svelte-h":!0}),_(ar)!=="svelte-10ewy9s"&&(ar.innerHTML=Yi),we.forEach(o),Gn=n(e),u(Wt.$$.fragment,e),Vn=n(e),O=c(e,"DIV",{class:!0});var Te=T(O);u(Bt.$$.fragment,Te),na=n(Te),ir=c(Te,"P",{"data-svelte-h":!0}),_(ir)!=="svelte-qqdw41"&&(ir.textContent=Qi),sa=n(Te),lr=c(Te,"P",{"data-svelte-h":!0}),_(lr)!=="svelte-8bldbv"&&(lr.innerHTML=Ki),Te.forEach(o),Hn=n(e),u(Nt.$$.fragment,e),Xn=n(e),pe=c(e,"DIV",{class:!0});var Ro=T(pe);u(qt.$$.fragment,Ro),aa=n(Ro),cr=c(Ro,"P",{"data-svelte-h":!0}),_(cr)!=="svelte-dy213u"&&(cr.textContent=el),Ro.forEach(o),Rn=n(e),u(Gt.$$.fragment,e),Dn=n(e),me=c(e,"DIV",{class:!0});var Do=T(me);u(Vt.$$.fragment,Do),ia=n(Do),dr=c(Do,"P",{"data-svelte-h":!0}),_(dr)!=="svelte-yuiep6"&&(dr.textContent=tl),Do.forEach(o),En=n(e),u(Ht.$$.fragment,e),Ln=n(e),Y=c(e,"DIV",{class:!0});var Pe=T(Y);u(Xt.$$.fragment,Pe),la=n(Pe),pr=c(Pe,"P",{"data-svelte-h":!0}),_(pr)!=="svelte-1ktcovi"&&(pr.textContent=ol),ca=n(Pe),mr=c(Pe,"P",{"data-svelte-h":!0}),_(mr)!=="svelte-6kslc1"&&(mr.textContent=rl),Pe.forEach(o),An=n(e),u(Rt.$$.fragment,e),Sn=n(e),ue=c(e,"DIV",{class:!0});var Eo=T(ue);u(Dt.$$.fragment,Eo),da=n(Eo),ur=c(Eo,"P",{"data-svelte-h":!0}),_(ur)!=="svelte-y6ydlz"&&(ur.textContent=nl),Eo.forEach(o),On=n(e),u(Et.$$.fragment,e),Yn=n(e),Q=c(e,"DIV",{class:!0});var $e=T(Q);u(Lt.$$.fragment,$e),pa=n($e),hr=c($e,"P",{"data-svelte-h":!0}),_(hr)!=="svelte-1kkn2my"&&(hr.textContent=sl),ma=n($e),gr=c($e,"P",{"data-svelte-h":!0}),_(gr)!=="svelte-1rw0gn5"&&(gr.textContent=al),$e.forEach(o),Qn=n(e),u(At.$$.fragment,e),Kn=n(e),he=c(e,"DIV",{class:!0});var Fs=T(he);u(St.$$.fragment,Fs),ua=n(Fs),fr=c(Fs,"P",{"data-svelte-h":!0}),_(fr)!=="svelte-2naf7r"&&(fr.innerHTML=il),Fs.forEach(o),es=n(e),u(Ot.$$.fragment,e),ts=n(e),ge=c(e,"DIV",{class:!0});var Zs=T(ge);u(Yt.$$.fragment,Zs),ha=n(Zs),vr=c(Zs,"P",{"data-svelte-h":!0}),_(vr)!=="svelte-5i43m6"&&(vr.textContent=ll),Zs.forEach(o),os=n(e),u(Qt.$$.fragment,e),rs=n(e),fe=c(e,"DIV",{class:!0});var zs=T(fe);u(Kt.$$.fragment,zs),ga=n(zs),_r=c(zs,"P",{"data-svelte-h":!0}),_(_r)!=="svelte-ker3kf"&&(_r.innerHTML=cl),zs.forEach(o),ns=n(e),u(eo.$$.fragment,e),ss=n(e),K=c(e,"DIV",{class:!0});var nn=T(K);u(to.$$.fragment,nn),fa=n(nn),br=c(nn,"P",{"data-svelte-h":!0}),_(br)!=="svelte-bcnwvf"&&(br.innerHTML=dl),va=n(nn),yr=c(nn,"P",{"data-svelte-h":!0}),_(yr)!=="svelte-1hdadgl"&&(yr.textContent=pl),nn.forEach(o),as=n(e),u(oo.$$.fragment,e),is=n(e),ve=c(e,"DIV",{class:!0});var Ws=T(ve);u(ro.$$.fragment,Ws),_a=n(Ws),Mr=c(Ws,"P",{"data-svelte-h":!0}),_(Mr)!=="svelte-ko0545"&&(Mr.textContent=ml),Ws.forEach(o),ls=n(e),u(no.$$.fragment,e),cs=n(e),_e=c(e,"DIV",{class:!0});var Bs=T(_e);u(so.$$.fragment,Bs),ba=n(Bs),wr=c(Bs,"P",{"data-svelte-h":!0}),_(wr)!=="svelte-19fogj5"&&(wr.textContent=ul),Bs.forEach(o),ds=n(e),u(ao.$$.fragment,e),ps=n(e),be=c(e,"DIV",{class:!0});var Ns=T(be);u(io.$$.fragment,Ns),ya=n(Ns),Tr=c(Ns,"P",{"data-svelte-h":!0}),_(Tr)!=="svelte-1kv6g6a"&&(Tr.textContent=hl),Ns.forEach(o),ms=n(e),u(lo.$$.fragment,e),us=n(e),ye=c(e,"DIV",{class:!0});var qs=T(ye);u(co.$$.fragment,qs),Ma=n(qs),Pr=c(qs,"P",{"data-svelte-h":!0}),_(Pr)!=="svelte-16bd8vx"&&(Pr.textContent=gl),qs.forEach(o),hs=n(e),u(po.$$.fragment,e),gs=n(e),ee=c(e,"DIV",{class:!0});var sn=T(ee);u(mo.$$.fragment,sn),wa=n(sn),$r=c(sn,"P",{"data-svelte-h":!0}),_($r)!=="svelte-1nfzg5j"&&($r.innerHTML=fl),Ta=n(sn),B=c(sn,"DIV",{class:!0});var Ye=T(B);u(uo.$$.fragment,Ye),Pa=n(Ye),jr=c(Ye,"P",{"data-svelte-h":!0}),_(jr)!=="svelte-1akei3x"&&(jr.innerHTML=vl),$a=n(Ye),u(ze.$$.fragment,Ye),ja=n(Ye),u(We.$$.fragment,Ye),Ye.forEach(o),sn.forEach(o),fs=n(e),u(ho.$$.fragment,e),vs=n(e),te=c(e,"DIV",{class:!0});var an=T(te);u(go.$$.fragment,an),xa=n(an),xr=c(an,"P",{"data-svelte-h":!0}),_(xr)!=="svelte-15ycigb"&&(xr.innerHTML=_l),Ca=n(an),N=c(an,"DIV",{class:!0});var Qe=T(N);u(fo.$$.fragment,Qe),ka=n(Qe),Cr=c(Qe,"P",{"data-svelte-h":!0}),_(Cr)!=="svelte-1rn5a7h"&&(Cr.innerHTML=bl),Ja=n(Qe),u(Be.$$.fragment,Qe),Ua=n(Qe),u(Ne.$$.fragment,Qe),Qe.forEach(o),an.forEach(o),_s=n(e),u(vo.$$.fragment,e),bs=n(e),oe=c(e,"DIV",{class:!0});var ln=T(oe);u(_o.$$.fragment,ln),Ia=n(ln),kr=c(ln,"P",{"data-svelte-h":!0}),_(kr)!=="svelte-a1b1mu"&&(kr.innerHTML=yl),Fa=n(ln),q=c(ln,"DIV",{class:!0});var Ke=T(q);u(bo.$$.fragment,Ke),Za=n(Ke),Jr=c(Ke,"P",{"data-svelte-h":!0}),_(Jr)!=="svelte-p4iesr"&&(Jr.innerHTML=Ml),za=n(Ke),u(qe.$$.fragment,Ke),Wa=n(Ke),u(Ge.$$.fragment,Ke),Ke.forEach(o),ln.forEach(o),ys=n(e),u(yo.$$.fragment,e),Ms=n(e),U=c(e,"DIV",{class:!0});var D=T(U);u(Mo.$$.fragment,D),Ba=n(D),Ur=c(D,"P",{"data-svelte-h":!0}),_(Ur)!=="svelte-14sixf"&&(Ur.textContent=wl),Na=n(D),Ir=c(D,"P",{"data-svelte-h":!0}),_(Ir)!=="svelte-7wi9f7"&&(Ir.textContent=Tl),qa=n(D),Fr=c(D,"P",{"data-svelte-h":!0}),_(Fr)!=="svelte-1ahc388"&&(Fr.innerHTML=Pl),Ga=n(D),Zr=c(D,"P",{"data-svelte-h":!0}),_(Zr)!=="svelte-68lg8f"&&(Zr.innerHTML=$l),Va=n(D),G=c(D,"DIV",{class:!0});var et=T(G);u(wo.$$.fragment,et),Ha=n(et),zr=c(et,"P",{"data-svelte-h":!0}),_(zr)!=="svelte-1x9hl05"&&(zr.innerHTML=jl),Xa=n(et),u(Ve.$$.fragment,et),Ra=n(et),u(He.$$.fragment,et),et.forEach(o),D.forEach(o),ws=n(e),u(To.$$.fragment,e),Ts=n(e),I=c(e,"DIV",{class:!0});var E=T(I);u(Po.$$.fragment,E),Da=n(E),Wr=c(E,"P",{"data-svelte-h":!0}),_(Wr)!=="svelte-14sixf"&&(Wr.textContent=xl),Ea=n(E),Br=c(E,"P",{"data-svelte-h":!0}),_(Br)!=="svelte-8ozzz2"&&(Br.textContent=Cl),La=n(E),Nr=c(E,"P",{"data-svelte-h":!0}),_(Nr)!=="svelte-1bzsxzl"&&(Nr.innerHTML=kl),Aa=n(E),qr=c(E,"P",{"data-svelte-h":!0}),_(qr)!=="svelte-68lg8f"&&(qr.innerHTML=Jl),Sa=n(E),V=c(E,"DIV",{class:!0});var tt=T(V);u($o.$$.fragment,tt),Oa=n(tt),Gr=c(tt,"P",{"data-svelte-h":!0}),_(Gr)!=="svelte-1a1raxn"&&(Gr.innerHTML=Ul),Ya=n(tt),u(Xe.$$.fragment,tt),Qa=n(tt),u(Re.$$.fragment,tt),tt.forEach(o),E.forEach(o),Ps=n(e),u(jo.$$.fragment,e),$s=n(e),F=c(e,"DIV",{class:!0});var L=T(F);u(xo.$$.fragment,L),Ka=n(L),Vr=c(L,"P",{"data-svelte-h":!0}),_(Vr)!=="svelte-14sixf"&&(Vr.textContent=Il),ei=n(L),Hr=c(L,"P",{"data-svelte-h":!0}),_(Hr)!=="svelte-tp3lrm"&&(Hr.textContent=Fl),ti=n(L),Xr=c(L,"P",{"data-svelte-h":!0}),_(Xr)!=="svelte-1b7y6hk"&&(Xr.innerHTML=Zl),oi=n(L),Rr=c(L,"P",{"data-svelte-h":!0}),_(Rr)!=="svelte-68lg8f"&&(Rr.innerHTML=zl),ri=n(L),H=c(L,"DIV",{class:!0});var ot=T(H);u(Co.$$.fragment,ot),ni=n(ot),Dr=c(ot,"P",{"data-svelte-h":!0}),_(Dr)!=="svelte-1pchudh"&&(Dr.innerHTML=Wl),si=n(ot),u(De.$$.fragment,ot),ai=n(ot),u(Ee.$$.fragment,ot),ot.forEach(o),L.forEach(o),js=n(e),u(ko.$$.fragment,e),xs=n(e),Z=c(e,"DIV",{class:!0});var se=T(Z);u(Jo.$$.fragment,se),ii=n(se),Er=c(se,"P",{"data-svelte-h":!0}),_(Er)!=="svelte-167h8x6"&&(Er.innerHTML=Bl),li=n(se),Lr=c(se,"P",{"data-svelte-h":!0}),_(Lr)!=="svelte-15z6y2c"&&(Lr.textContent=Nl),ci=n(se),Ar=c(se,"P",{"data-svelte-h":!0}),_(Ar)!=="svelte-68lg8f"&&(Ar.innerHTML=ql),di=n(se),X=c(se,"DIV",{class:!0});var rt=T(X);u(Uo.$$.fragment,rt),pi=n(rt),Sr=c(rt,"P",{"data-svelte-h":!0}),_(Sr)!=="svelte-itnxth"&&(Sr.innerHTML=Gl),mi=n(rt),u(Le.$$.fragment,rt),ui=n(rt),u(Ae.$$.fragment,rt),rt.forEach(o),se.forEach(o),Cs=n(e),u(Io.$$.fragment,e),ks=n(e),C=c(e,"DIV",{class:!0});var k=T(C);u(Fo.$$.fragment,k),hi=n(k),Or=c(k,"P",{"data-svelte-h":!0}),_(Or)!=="svelte-1oaen3m"&&(Or.textContent=Vl),gi=n(k),Yr=c(k,"P",{"data-svelte-h":!0}),_(Yr)!=="svelte-18lwpj6"&&(Yr.innerHTML=Hl),fi=n(k),Qr=c(k,"P",{"data-svelte-h":!0}),_(Qr)!=="svelte-qlh54q"&&(Qr.innerHTML=Xl),vi=n(k),Kr=c(k,"P",{"data-svelte-h":!0}),_(Kr)!=="svelte-1vsoia9"&&(Kr.innerHTML=Rl),_i=n(k),en=c(k,"P",{"data-svelte-h":!0}),_(en)!=="svelte-1hs9g1p"&&(en.innerHTML=Dl),bi=n(k),tn=c(k,"P",{"data-svelte-h":!0}),_(tn)!=="svelte-1ic9umv"&&(tn.textContent=El),yi=n(k),on=c(k,"P",{"data-svelte-h":!0}),_(on)!=="svelte-68lg8f"&&(on.innerHTML=Ll),Mi=n(k),R=c(k,"DIV",{class:!0});var nt=T(R);u(Zo.$$.fragment,nt),wi=n(nt),rn=c(nt,"P",{"data-svelte-h":!0}),_(rn)!=="svelte-vjwnsx"&&(rn.innerHTML=Al),Ti=n(nt),u(Se.$$.fragment,nt),Pi=n(nt),u(Oe.$$.fragment,nt),nt.forEach(o),k.forEach(o),Js=n(e),u(zo.$$.fragment,e),Us=n(e),cn=c(e,"P",{}),T(cn).forEach(o),this.h()},h(){w(a,"name","hf:doc:metadata"),w(a,"content",Mc),Ol(ke.src,Zi="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||w(ke,"src",Zi),w(ke,"alt","drawing"),w(ke,"width","600"),w(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Ze,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ve,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(be,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(V,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){s(document.head,a),i(e,y,t),i(e,p,t),i(e,b,t),h(M,e,t),i(e,d,t),h(P,e,t),i(e,dn,t),i(e,st,t),i(e,pn,t),i(e,at,t),i(e,mn,t),i(e,it,t),i(e,un,t),i(e,lt,t),i(e,hn,t),i(e,ct,t),i(e,gn,t),i(e,dt,t),i(e,fn,t),i(e,pt,t),i(e,vn,t),i(e,mt,t),i(e,_n,t),i(e,ut,t),i(e,bn,t),i(e,ke,t),i(e,yn,t),i(e,ht,t),i(e,Mn,t),i(e,gt,t),i(e,wn,t),h(Je,e,t),i(e,Tn,t),h(ft,e,t),i(e,Pn,t),i(e,vt,t),i(e,$n,t),h(_t,e,t),i(e,jn,t),i(e,ae,t),h(bt,ae,null),s(ae,Gs),s(ae,Lo),i(e,xn,t),i(e,ie,t),h(yt,ie,null),s(ie,Vs),s(ie,Ao),i(e,Cn,t),i(e,le,t),h(Mt,le,null),s(le,Hs),s(le,So),i(e,kn,t),i(e,ce,t),h(wt,ce,null),s(ce,Xs),s(ce,Oo),i(e,Jn,t),h(Tt,e,t),i(e,Un,t),i(e,z,t),h(Pt,z,null),s(z,Rs),s(z,Yo),s(z,Ds),s(z,Qo),s(z,Es),h(Ue,z,null),i(e,In,t),h($t,e,t),i(e,Fn,t),i(e,W,t),h(jt,W,null),s(W,Ls),s(W,Ko),s(W,As),s(W,er),s(W,Ss),s(W,Ie),h(xt,Ie,null),s(Ie,Os),s(Ie,tr),i(e,Zn,t),h(Ct,e,t),i(e,zn,t),i(e,de,t),h(kt,de,null),s(de,Ys),s(de,Fe),h(Jt,Fe,null),s(Fe,Qs),s(Fe,or),i(e,Wn,t),h(Ut,e,t),i(e,Bn,t),i(e,A,t),h(It,A,null),s(A,Ks),s(A,rr),s(A,ea),s(A,Ze),h(Ft,Ze,null),s(Ze,ta),s(Ze,nr),i(e,Nn,t),h(Zt,e,t),i(e,qn,t),i(e,S,t),h(zt,S,null),s(S,oa),s(S,sr),s(S,ra),s(S,ar),i(e,Gn,t),h(Wt,e,t),i(e,Vn,t),i(e,O,t),h(Bt,O,null),s(O,na),s(O,ir),s(O,sa),s(O,lr),i(e,Hn,t),h(Nt,e,t),i(e,Xn,t),i(e,pe,t),h(qt,pe,null),s(pe,aa),s(pe,cr),i(e,Rn,t),h(Gt,e,t),i(e,Dn,t),i(e,me,t),h(Vt,me,null),s(me,ia),s(me,dr),i(e,En,t),h(Ht,e,t),i(e,Ln,t),i(e,Y,t),h(Xt,Y,null),s(Y,la),s(Y,pr),s(Y,ca),s(Y,mr),i(e,An,t),h(Rt,e,t),i(e,Sn,t),i(e,ue,t),h(Dt,ue,null),s(ue,da),s(ue,ur),i(e,On,t),h(Et,e,t),i(e,Yn,t),i(e,Q,t),h(Lt,Q,null),s(Q,pa),s(Q,hr),s(Q,ma),s(Q,gr),i(e,Qn,t),h(At,e,t),i(e,Kn,t),i(e,he,t),h(St,he,null),s(he,ua),s(he,fr),i(e,es,t),h(Ot,e,t),i(e,ts,t),i(e,ge,t),h(Yt,ge,null),s(ge,ha),s(ge,vr),i(e,os,t),h(Qt,e,t),i(e,rs,t),i(e,fe,t),h(Kt,fe,null),s(fe,ga),s(fe,_r),i(e,ns,t),h(eo,e,t),i(e,ss,t),i(e,K,t),h(to,K,null),s(K,fa),s(K,br),s(K,va),s(K,yr),i(e,as,t),h(oo,e,t),i(e,is,t),i(e,ve,t),h(ro,ve,null),s(ve,_a),s(ve,Mr),i(e,ls,t),h(no,e,t),i(e,cs,t),i(e,_e,t),h(so,_e,null),s(_e,ba),s(_e,wr),i(e,ds,t),h(ao,e,t),i(e,ps,t),i(e,be,t),h(io,be,null),s(be,ya),s(be,Tr),i(e,ms,t),h(lo,e,t),i(e,us,t),i(e,ye,t),h(co,ye,null),s(ye,Ma),s(ye,Pr),i(e,hs,t),h(po,e,t),i(e,gs,t),i(e,ee,t),h(mo,ee,null),s(ee,wa),s(ee,$r),s(ee,Ta),s(ee,B),h(uo,B,null),s(B,Pa),s(B,jr),s(B,$a),h(ze,B,null),s(B,ja),h(We,B,null),i(e,fs,t),h(ho,e,t),i(e,vs,t),i(e,te,t),h(go,te,null),s(te,xa),s(te,xr),s(te,Ca),s(te,N),h(fo,N,null),s(N,ka),s(N,Cr),s(N,Ja),h(Be,N,null),s(N,Ua),h(Ne,N,null),i(e,_s,t),h(vo,e,t),i(e,bs,t),i(e,oe,t),h(_o,oe,null),s(oe,Ia),s(oe,kr),s(oe,Fa),s(oe,q),h(bo,q,null),s(q,Za),s(q,Jr),s(q,za),h(qe,q,null),s(q,Wa),h(Ge,q,null),i(e,ys,t),h(yo,e,t),i(e,Ms,t),i(e,U,t),h(Mo,U,null),s(U,Ba),s(U,Ur),s(U,Na),s(U,Ir),s(U,qa),s(U,Fr),s(U,Ga),s(U,Zr),s(U,Va),s(U,G),h(wo,G,null),s(G,Ha),s(G,zr),s(G,Xa),h(Ve,G,null),s(G,Ra),h(He,G,null),i(e,ws,t),h(To,e,t),i(e,Ts,t),i(e,I,t),h(Po,I,null),s(I,Da),s(I,Wr),s(I,Ea),s(I,Br),s(I,La),s(I,Nr),s(I,Aa),s(I,qr),s(I,Sa),s(I,V),h($o,V,null),s(V,Oa),s(V,Gr),s(V,Ya),h(Xe,V,null),s(V,Qa),h(Re,V,null),i(e,Ps,t),h(jo,e,t),i(e,$s,t),i(e,F,t),h(xo,F,null),s(F,Ka),s(F,Vr),s(F,ei),s(F,Hr),s(F,ti),s(F,Xr),s(F,oi),s(F,Rr),s(F,ri),s(F,H),h(Co,H,null),s(H,ni),s(H,Dr),s(H,si),h(De,H,null),s(H,ai),h(Ee,H,null),i(e,js,t),h(ko,e,t),i(e,xs,t),i(e,Z,t),h(Jo,Z,null),s(Z,ii),s(Z,Er),s(Z,li),s(Z,Lr),s(Z,ci),s(Z,Ar),s(Z,di),s(Z,X),h(Uo,X,null),s(X,pi),s(X,Sr),s(X,mi),h(Le,X,null),s(X,ui),h(Ae,X,null),i(e,Cs,t),h(Io,e,t),i(e,ks,t),i(e,C,t),h(Fo,C,null),s(C,hi),s(C,Or),s(C,gi),s(C,Yr),s(C,fi),s(C,Qr),s(C,vi),s(C,Kr),s(C,_i),s(C,en),s(C,bi),s(C,tn),s(C,yi),s(C,on),s(C,Mi),s(C,R),h(Zo,R,null),s(R,wi),s(R,rn),s(R,Ti),h(Se,R,null),s(R,Pi),h(Oe,R,null),i(e,Js,t),h(zo,e,t),i(e,Us,t),i(e,cn,t),Is=!0},p(e,[t]){const Wo={};t&2&&(Wo.$$scope={dirty:t,ctx:e}),Je.$set(Wo);const Bo={};t&2&&(Bo.$$scope={dirty:t,ctx:e}),Ue.$set(Bo);const No={};t&2&&(No.$$scope={dirty:t,ctx:e}),ze.$set(No);const qo={};t&2&&(qo.$$scope={dirty:t,ctx:e}),We.$set(qo);const re={};t&2&&(re.$$scope={dirty:t,ctx:e}),Be.$set(re);const ne={};t&2&&(ne.$$scope={dirty:t,ctx:e}),Ne.$set(ne);const Go={};t&2&&(Go.$$scope={dirty:t,ctx:e}),qe.$set(Go);const Vo={};t&2&&(Vo.$$scope={dirty:t,ctx:e}),Ge.$set(Vo);const Ho={};t&2&&(Ho.$$scope={dirty:t,ctx:e}),Ve.$set(Ho);const Me={};t&2&&(Me.$$scope={dirty:t,ctx:e}),He.$set(Me);const Xo={};t&2&&(Xo.$$scope={dirty:t,ctx:e}),Xe.$set(Xo);const we={};t&2&&(we.$$scope={dirty:t,ctx:e}),Re.$set(we);const Te={};t&2&&(Te.$$scope={dirty:t,ctx:e}),De.$set(Te);const Ro={};t&2&&(Ro.$$scope={dirty:t,ctx:e}),Ee.$set(Ro);const Do={};t&2&&(Do.$$scope={dirty:t,ctx:e}),Le.$set(Do);const Pe={};t&2&&(Pe.$$scope={dirty:t,ctx:e}),Ae.$set(Pe);const Eo={};t&2&&(Eo.$$scope={dirty:t,ctx:e}),Se.$set(Eo);const $e={};t&2&&($e.$$scope={dirty:t,ctx:e}),Oe.$set($e)},i(e){Is||(g(M.$$.fragment,e),g(P.$$.fragment,e),g(Je.$$.fragment,e),g(ft.$$.fragment,e),g(_t.$$.fragment,e),g(bt.$$.fragment,e),g(yt.$$.fragment,e),g(Mt.$$.fragment,e),g(wt.$$.fragment,e),g(Tt.$$.fragment,e),g(Pt.$$.fragment,e),g(Ue.$$.fragment,e),g($t.$$.fragment,e),g(jt.$$.fragment,e),g(xt.$$.fragment,e),g(Ct.$$.fragment,e),g(kt.$$.fragment,e),g(Jt.$$.fragment,e),g(Ut.$$.fragment,e),g(It.$$.fragment,e),g(Ft.$$.fragment,e),g(Zt.$$.fragment,e),g(zt.$$.fragment,e),g(Wt.$$.fragment,e),g(Bt.$$.fragment,e),g(Nt.$$.fragment,e),g(qt.$$.fragment,e),g(Gt.$$.fragment,e),g(Vt.$$.fragment,e),g(Ht.$$.fragment,e),g(Xt.$$.fragment,e),g(Rt.$$.fragment,e),g(Dt.$$.fragment,e),g(Et.$$.fragment,e),g(Lt.$$.fragment,e),g(At.$$.fragment,e),g(St.$$.fragment,e),g(Ot.$$.fragment,e),g(Yt.$$.fragment,e),g(Qt.$$.fragment,e),g(Kt.$$.fragment,e),g(eo.$$.fragment,e),g(to.$$.fragment,e),g(oo.$$.fragment,e),g(ro.$$.fragment,e),g(no.$$.fragment,e),g(so.$$.fragment,e),g(ao.$$.fragment,e),g(io.$$.fragment,e),g(lo.$$.fragment,e),g(co.$$.fragment,e),g(po.$$.fragment,e),g(mo.$$.fragment,e),g(uo.$$.fragment,e),g(ze.$$.fragment,e),g(We.$$.fragment,e),g(ho.$$.fragment,e),g(go.$$.fragment,e),g(fo.$$.fragment,e),g(Be.$$.fragment,e),g(Ne.$$.fragment,e),g(vo.$$.fragment,e),g(_o.$$.fragment,e),g(bo.$$.fragment,e),g(qe.$$.fragment,e),g(Ge.$$.fragment,e),g(yo.$$.fragment,e),g(Mo.$$.fragment,e),g(wo.$$.fragment,e),g(Ve.$$.fragment,e),g(He.$$.fragment,e),g(To.$$.fragment,e),g(Po.$$.fragment,e),g($o.$$.fragment,e),g(Xe.$$.fragment,e),g(Re.$$.fragment,e),g(jo.$$.fragment,e),g(xo.$$.fragment,e),g(Co.$$.fragment,e),g(De.$$.fragment,e),g(Ee.$$.fragment,e),g(ko.$$.fragment,e),g(Jo.$$.fragment,e),g(Uo.$$.fragment,e),g(Le.$$.fragment,e),g(Ae.$$.fragment,e),g(Io.$$.fragment,e),g(Fo.$$.fragment,e),g(Zo.$$.fragment,e),g(Se.$$.fragment,e),g(Oe.$$.fragment,e),g(zo.$$.fragment,e),Is=!0)},o(e){f(M.$$.fragment,e),f(P.$$.fragment,e),f(Je.$$.fragment,e),f(ft.$$.fragment,e),f(_t.$$.fragment,e),f(bt.$$.fragment,e),f(yt.$$.fragment,e),f(Mt.$$.fragment,e),f(wt.$$.fragment,e),f(Tt.$$.fragment,e),f(Pt.$$.fragment,e),f(Ue.$$.fragment,e),f($t.$$.fragment,e),f(jt.$$.fragment,e),f(xt.$$.fragment,e),f(Ct.$$.fragment,e),f(kt.$$.fragment,e),f(Jt.$$.fragment,e),f(Ut.$$.fragment,e),f(It.$$.fragment,e),f(Ft.$$.fragment,e),f(Zt.$$.fragment,e),f(zt.$$.fragment,e),f(Wt.$$.fragment,e),f(Bt.$$.fragment,e),f(Nt.$$.fragment,e),f(qt.$$.fragment,e),f(Gt.$$.fragment,e),f(Vt.$$.fragment,e),f(Ht.$$.fragment,e),f(Xt.$$.fragment,e),f(Rt.$$.fragment,e),f(Dt.$$.fragment,e),f(Et.$$.fragment,e),f(Lt.$$.fragment,e),f(At.$$.fragment,e),f(St.$$.fragment,e),f(Ot.$$.fragment,e),f(Yt.$$.fragment,e),f(Qt.$$.fragment,e),f(Kt.$$.fragment,e),f(eo.$$.fragment,e),f(to.$$.fragment,e),f(oo.$$.fragment,e),f(ro.$$.fragment,e),f(no.$$.fragment,e),f(so.$$.fragment,e),f(ao.$$.fragment,e),f(io.$$.fragment,e),f(lo.$$.fragment,e),f(co.$$.fragment,e),f(po.$$.fragment,e),f(mo.$$.fragment,e),f(uo.$$.fragment,e),f(ze.$$.fragment,e),f(We.$$.fragment,e),f(ho.$$.fragment,e),f(go.$$.fragment,e),f(fo.$$.fragment,e),f(Be.$$.fragment,e),f(Ne.$$.fragment,e),f(vo.$$.fragment,e),f(_o.$$.fragment,e),f(bo.$$.fragment,e),f(qe.$$.fragment,e),f(Ge.$$.fragment,e),f(yo.$$.fragment,e),f(Mo.$$.fragment,e),f(wo.$$.fragment,e),f(Ve.$$.fragment,e),f(He.$$.fragment,e),f(To.$$.fragment,e),f(Po.$$.fragment,e),f($o.$$.fragment,e),f(Xe.$$.fragment,e),f(Re.$$.fragment,e),f(jo.$$.fragment,e),f(xo.$$.fragment,e),f(Co.$$.fragment,e),f(De.$$.fragment,e),f(Ee.$$.fragment,e),f(ko.$$.fragment,e),f(Jo.$$.fragment,e),f(Uo.$$.fragment,e),f(Le.$$.fragment,e),f(Ae.$$.fragment,e),f(Io.$$.fragment,e),f(Fo.$$.fragment,e),f(Zo.$$.fragment,e),f(Se.$$.fragment,e),f(Oe.$$.fragment,e),f(zo.$$.fragment,e),Is=!1},d(e){e&&(o(y),o(p),o(b),o(d),o(dn),o(st),o(pn),o(at),o(mn),o(it),o(un),o(lt),o(hn),o(ct),o(gn),o(dt),o(fn),o(pt),o(vn),o(mt),o(_n),o(ut),o(bn),o(ke),o(yn),o(ht),o(Mn),o(gt),o(wn),o(Tn),o(Pn),o(vt),o($n),o(jn),o(ae),o(xn),o(ie),o(Cn),o(le),o(kn),o(ce),o(Jn),o(Un),o(z),o(In),o(Fn),o(W),o(Zn),o(zn),o(de),o(Wn),o(Bn),o(A),o(Nn),o(qn),o(S),o(Gn),o(Vn),o(O),o(Hn),o(Xn),o(pe),o(Rn),o(Dn),o(me),o(En),o(Ln),o(Y),o(An),o(Sn),o(ue),o(On),o(Yn),o(Q),o(Qn),o(Kn),o(he),o(es),o(ts),o(ge),o(os),o(rs),o(fe),o(ns),o(ss),o(K),o(as),o(is),o(ve),o(ls),o(cs),o(_e),o(ds),o(ps),o(be),o(ms),o(us),o(ye),o(hs),o(gs),o(ee),o(fs),o(vs),o(te),o(_s),o(bs),o(oe),o(ys),o(Ms),o(U),o(ws),o(Ts),o(I),o(Ps),o($s),o(F),o(js),o(xs),o(Z),o(Cs),o(ks),o(C),o(Js),o(Us),o(cn)),o(a),v(M,e),v(P,e),v(Je,e),v(ft,e),v(_t,e),v(bt),v(yt),v(Mt),v(wt),v(Tt,e),v(Pt),v(Ue),v($t,e),v(jt),v(xt),v(Ct,e),v(kt),v(Jt),v(Ut,e),v(It),v(Ft),v(Zt,e),v(zt),v(Wt,e),v(Bt),v(Nt,e),v(qt),v(Gt,e),v(Vt),v(Ht,e),v(Xt),v(Rt,e),v(Dt),v(Et,e),v(Lt),v(At,e),v(St),v(Ot,e),v(Yt),v(Qt,e),v(Kt),v(eo,e),v(to),v(oo,e),v(ro),v(no,e),v(so),v(ao,e),v(io),v(lo,e),v(co),v(po,e),v(mo),v(uo),v(ze),v(We),v(ho,e),v(go),v(fo),v(Be),v(Ne),v(vo,e),v(_o),v(bo),v(qe),v(Ge),v(yo,e),v(Mo),v(wo),v(Ve),v(He),v(To,e),v(Po),v($o),v(Xe),v(Re),v(jo,e),v(xo),v(Co),v(De),v(Ee),v(ko,e),v(Jo),v(Uo),v(Le),v(Ae),v(Io,e),v(Fo),v(Zo),v(Se),v(Oe),v(zo,e)}}}const Mc='{"title":"Perceiver","local":"perceiver","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Resources","local":"resources","sections":[],"depth":2},{"title":"Perceiver specific outputs","local":"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput","sections":[],"depth":2},{"title":"PerceiverConfig","local":"transformers.PerceiverConfig","sections":[],"depth":2},{"title":"PerceiverTokenizer","local":"transformers.PerceiverTokenizer","sections":[],"depth":2},{"title":"PerceiverFeatureExtractor","local":"transformers.PerceiverFeatureExtractor","sections":[],"depth":2},{"title":"PerceiverImageProcessor","local":"transformers.PerceiverImageProcessor","sections":[],"depth":2},{"title":"PerceiverTextPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor","sections":[],"depth":2},{"title":"PerceiverImagePreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor","sections":[],"depth":2},{"title":"PerceiverOneHotPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor","sections":[],"depth":2},{"title":"PerceiverAudioPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor","sections":[],"depth":2},{"title":"PerceiverMultimodalPreprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor","sections":[],"depth":2},{"title":"PerceiverProjectionDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder","sections":[],"depth":2},{"title":"PerceiverBasicDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder","sections":[],"depth":2},{"title":"PerceiverClassificationDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder","sections":[],"depth":2},{"title":"PerceiverOpticalFlowDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder","sections":[],"depth":2},{"title":"PerceiverBasicVideoAutoencodingDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder","sections":[],"depth":2},{"title":"PerceiverMultimodalDecoder","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder","sections":[],"depth":2},{"title":"PerceiverProjectionPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor","sections":[],"depth":2},{"title":"PerceiverAudioPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor","sections":[],"depth":2},{"title":"PerceiverClassificationPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor","sections":[],"depth":2},{"title":"PerceiverMultimodalPostprocessor","local":"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor","sections":[],"depth":2},{"title":"PerceiverModel","local":"transformers.PerceiverModel","sections":[],"depth":2},{"title":"PerceiverForMaskedLM","local":"transformers.PerceiverForMaskedLM","sections":[],"depth":2},{"title":"PerceiverForSequenceClassification","local":"transformers.PerceiverForSequenceClassification","sections":[],"depth":2},{"title":"PerceiverForImageClassificationLearned","local":"transformers.PerceiverForImageClassificationLearned","sections":[],"depth":2},{"title":"PerceiverForImageClassificationFourier","local":"transformers.PerceiverForImageClassificationFourier","sections":[],"depth":2},{"title":"PerceiverForImageClassificationConvProcessing","local":"transformers.PerceiverForImageClassificationConvProcessing","sections":[],"depth":2},{"title":"PerceiverForOpticalFlow","local":"transformers.PerceiverForOpticalFlow","sections":[],"depth":2},{"title":"PerceiverForMultimodalAutoencoding","local":"transformers.PerceiverForMultimodalAutoencoding","sections":[],"depth":2}],"depth":1}';function wc(j){return Yl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Jc extends Ql{constructor(a){super(),Kl(this,a,wc,yc,Sl,{})}}export{Jc as component};
