import{s as wl,o as Tl,n as yl}from"../chunks/scheduler.25b97de1.js";import{S as Jl,i as ul,g as i,s as n,r,A as Ul,h as M,f as l,c as a,j as pl,u as p,x as o,k as ml,y as dl,a as s,v as m,d as w,t as T,w as y}from"../chunks/index.d9030fc9.js";import{T as cl}from"../chunks/Tip.baa67368.js";import{C as U}from"../chunks/CodeBlock.e6cd0d95.js";import{H as Ct,E as jl}from"../chunks/EditOnGithub.91d95064.js";function hl(It){let J,c=`If you plan to run multiple experiments, in order to properly clear the memory between experiments, restart the Python
kernel between experiments.`;return{c(){J=i("p"),J.textContent=c},l(u){J=M(u,"P",{"data-svelte-h":!0}),o(J)!=="svelte-1v4397i"&&(J.textContent=c)},m(u,jt){s(u,J,jt)},p:yl,d(u){u&&l(J)}}}function Cl(It){let J,c,u,jt,j,ft,h,be=`To understand performance optimization techniques that one can apply to improve efficiency of model training
speed and memory utilization, it’s helpful to get familiar with how GPU is utilized during training, and how compute
intensity varies depending on an operation performed.`,gt,C,Ae=`Let’s start by exploring a motivating example of GPU utilization and the training run of a model. For the demonstration,
we’ll need to install a few libraries:`,bt,I,At,f,Se=`The <code>nvidia-ml-py3</code> library allows us to monitor the memory usage of the models from within Python. You might be familiar
with the <code>nvidia-smi</code> command in the terminal - this library allows to access the same information in Python directly.`,St,g,Le=`Then, we create some dummy data: random token IDs between 100 and 30000 and binary labels for a classifier.
In total, we get 512 sequences each with length 512 and store them in a <code>Dataset</code> with PyTorch format.`,Lt,b,zt,A,ze='To print summary statistics for the GPU utilization and the training run with the <a href="/docs/transformers/v4.41.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> we define two helper functions:',Qt,S,vt,L,Qe="Let’s verify that we start with a free GPU memory:",Rt,z,$t,Q,ve=`That looks good: the GPU memory is not occupied as we would expect before we load any models. If that’s not the case on
your machine make sure to stop all processes that are using GPU memory. However, not all free GPU memory can be used by
the user. When a model is loaded to the GPU the kernels are also loaded, which can take up 1-2GB of memory. To see how
much it is we load a tiny tensor into the GPU which triggers the kernels to be loaded as well.`,xt,v,Gt,R,Re="We see that the kernels alone take up 1.3GB of GPU memory. Now let’s see how much space the model uses.",kt,$,_t,x,$e=`First, we load the <code>google-bert/bert-large-uncased</code> model. We load the model weights directly to the GPU so that we can check
how much space just the weights use.`,Bt,G,Et,k,xe=`We can see that the model weights alone take up 1.3 GB of GPU memory. The exact number depends on the specific
GPU you are using. Note that on newer GPUs a model can sometimes take up more space since the weights are loaded in an
optimized fashion that speeds up the usage of the model. Now we can also quickly check if we get the same result
as with <code>nvidia-smi</code> CLI:`,Wt,_,Vt,B,Zt,E,Ge=`We get the same number as before and you can also see that we are using a V100 GPU with 16GB of memory. So now we can
start training the model and see how the GPU memory consumption changes. First, we set up a few standard training
arguments:`,Pt,W,Ht,d,Nt,V,Ft,Z,ke='Let’s use the <a href="/docs/transformers/v4.41.3/en/main_classes/trainer#transformers.Trainer">Trainer</a> and train the model without using any GPU performance optimization techniques and a batch size of 4:',Xt,P,Dt,H,qt,N,_e=`We see that already a relatively small batch size almost fills up our GPU’s entire memory. However, a larger batch size
can often result in faster model convergence or better end performance. So ideally we want to tune the batch size to our
model’s needs and not to the GPU limitations. What’s interesting is that we use much more memory than the size of the model.
To understand a bit better why this is the case let’s have a look at a model’s operations and memory needs.`,Yt,F,Kt,X,Be="Transformers architecture includes 3 main groups of operations grouped below by compute-intensity.",Ot,D,Ee="<li><p><strong>Tensor Contractions</strong></p> <p>Linear layers and components of Multi-Head Attention all do batched <strong>matrix-matrix multiplications</strong>. These operations are the most compute-intensive part of training a transformer.</p></li> <li><p><strong>Statistical Normalizations</strong></p> <p>Softmax and layer normalization are less compute-intensive than tensor contractions, and involve one or more <strong>reduction operations</strong>, the result of which is then applied via a map.</p></li> <li><p><strong>Element-wise Operators</strong></p> <p>These are the remaining operators: <strong>biases, dropout, activations, and residual connections</strong>. These are the least compute-intensive operations.</p></li>",te,q,We="This knowledge can be helpful to know when analyzing performance bottlenecks.",ee,Y,Ve='This summary is derived from <a href="https://arxiv.org/abs/2007.00072" rel="nofollow">Data Movement Is All You Need: A Case Study on Optimizing Transformers 2020</a>',le,K,se,O,Ze=`We’ve seen that training the model uses much more memory than just putting the model on the GPU. This is because there
are many components during training that use GPU memory. The components on GPU memory are the following:`,ne,tt,Pe="<li>model weights</li> <li>optimizer states</li> <li>gradients</li> <li>forward activations saved for gradient computation</li> <li>temporary buffers</li> <li>functionality-specific memory</li>",ae,et,He=`A typical model trained in mixed precision with AdamW requires 18 bytes per model parameter plus activation memory. For
inference there are no optimizer states and gradients, so we can subtract those. And thus we end up with 6 bytes per
model parameter for mixed precision inference, plus activation memory.`,ie,lt,Ne="Let’s look at the details.",Me,st,Fe="<strong>Model Weights:</strong>",oe,nt,Xe="<li>4 bytes * number of parameters for fp32 training</li> <li>6 bytes * number of parameters for mixed precision training (maintains a model in fp32 and one in fp16 in memory)</li>",re,at,De="<strong>Optimizer States:</strong>",pe,it,qe='<li>8 bytes * number of parameters for normal AdamW (maintains 2 states)</li> <li>2 bytes * number of parameters for 8-bit AdamW optimizers like <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow">bitsandbytes</a></li> <li>4 bytes * number of parameters for optimizers like SGD with momentum (maintains only 1 state)</li>',me,Mt,Ye="<strong>Gradients</strong>",we,ot,Ke="<li>4 bytes * number of parameters for either fp32 or mixed precision training (gradients are always kept in fp32)</li>",Te,rt,Oe="<strong>Forward Activations</strong>",ye,pt,tl="<li>size depends on many factors, the key ones being sequence length, hidden size and batch size.</li>",Je,mt,el=`There are the input and output that are being passed and returned by the forward and the backward functions and the
forward activations saved for gradient computation.`,ue,wt,ll="<strong>Temporary Memory</strong>",Ue,Tt,sl=`Additionally, there are all kinds of temporary variables which get released once the calculation is done, but in the
moment these could require additional memory and could push to OOM. Therefore, when coding it’s crucial to think
strategically about such temporary variables and sometimes to explicitly free those as soon as they are no longer needed.`,de,yt,nl="<strong>Functionality-specific memory</strong>",ce,Jt,al=`Then, your software could have special memory needs. For example, when generating text using beam search, the software
needs to maintain multiple copies of inputs and outputs.`,je,ut,il="<strong><code>forward</code> vs <code>backward</code> Execution Speed</strong>",he,Ut,Ml=`For convolutions and linear layers there are 2x flops in the backward compared to the forward, which generally translates
into ~2x slower (sometimes more, because sizes in the backward tend to be more awkward). Activations are usually
bandwidth-limited, and it’s typical for an activation to have to read more data in the backward than in the forward
(e.g. activation forward reads once, writes once, activation backward reads twice, gradOutput and output of the forward,
and writes once, gradInput).`,Ce,dt,ol=`As you can see, there are potentially a few places where we could save GPU memory or speed up operations.
Now that you understand what affects GPU utilization and computation speed, refer to
the <a href="perf_train_gpu_one">Methods and tools for efficient training on a single GPU</a> documentation page to learn about
performance optimization techniques.`,Ie,ct,fe,ht,ge;return j=new Ct({props:{title:"Model training anatomy",local:"model-training-anatomy",headingTag:"h1"}}),I=new U({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwYWNjZWxlcmF0ZSUyMG52aWRpYS1tbC1weTM=",highlighted:"pip install transformers datasets accelerate nvidia-ml-py3",wrap:!1}}),b=new U({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwRGF0YXNldCUwQSUwQSUwQXNlcV9sZW4lMkMlMjBkYXRhc2V0X3NpemUlMjAlM0QlMjA1MTIlMkMlMjA1MTIlMEFkdW1teV9kYXRhJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyaW5wdXRfaWRzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMTAwJTJDJTIwMzAwMDAlMkMlMjAoZGF0YXNldF9zaXplJTJDJTIwc2VxX2xlbikpJTJDJTBBJTIwJTIwJTIwJTIwJTIybGFiZWxzJTIyJTNBJTIwbnAucmFuZG9tLnJhbmRpbnQoMCUyQyUyMDElMkMlMjAoZGF0YXNldF9zaXplKSklMkMlMEElN0QlMEFkcyUyMCUzRCUyMERhdGFzZXQuZnJvbV9kaWN0KGR1bW15X2RhdGEpJTBBZHMuc2V0X2Zvcm1hdCglMjJwdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> Dataset


<span class="hljs-meta">&gt;&gt;&gt; </span>seq_len, dataset_size = <span class="hljs-number">512</span>, <span class="hljs-number">512</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>dummy_data = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;input_ids&quot;</span>: np.random.randint(<span class="hljs-number">100</span>, <span class="hljs-number">30000</span>, (dataset_size, seq_len)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;labels&quot;</span>: np.random.randint(<span class="hljs-number">0</span>, <span class="hljs-number">1</span>, (dataset_size)),
<span class="hljs-meta">... </span>}
<span class="hljs-meta">&gt;&gt;&gt; </span>ds = Dataset.from_dict(dummy_data)
<span class="hljs-meta">&gt;&gt;&gt; </span>ds.set_format(<span class="hljs-string">&quot;pt&quot;</span>)`,wrap:!1}}),S=new U({props:{code:"ZnJvbSUyMHB5bnZtbCUyMGltcG9ydCUyMColMEElMEElMEFkZWYlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKSUzQSUwQSUyMCUyMCUyMCUyMG52bWxJbml0KCklMEElMjAlMjAlMjAlMjBoYW5kbGUlMjAlM0QlMjBudm1sRGV2aWNlR2V0SGFuZGxlQnlJbmRleCgwKSUwQSUyMCUyMCUyMCUyMGluZm8lMjAlM0QlMjBudm1sRGV2aWNlR2V0TWVtb3J5SW5mbyhoYW5kbGUpJTBBJTIwJTIwJTIwJTIwcHJpbnQoZiUyMkdQVSUyMG1lbW9yeSUyMG9jY3VwaWVkJTNBJTIwJTdCaW5mby51c2VkJTJGJTJGMTAyNCoqMiU3RCUyME1CLiUyMiklMEElMEElMEFkZWYlMjBwcmludF9zdW1tYXJ5KHJlc3VsdCklM0ElMEElMjAlMjAlMjAlMjBwcmludChmJTIyVGltZSUzQSUyMCU3QnJlc3VsdC5tZXRyaWNzJTVCJ3RyYWluX3J1bnRpbWUnJTVEJTNBLjJmJTdEJTIyKSUwQSUyMCUyMCUyMCUyMHByaW50KGYlMjJTYW1wbGVzJTJGc2Vjb25kJTNBJTIwJTdCcmVzdWx0Lm1ldHJpY3MlNUIndHJhaW5fc2FtcGxlc19wZXJfc2Vjb25kJyU1RCUzQS4yZiU3RCUyMiklMEElMjAlMjAlMjAlMjBwcmludF9ncHVfdXRpbGl6YXRpb24oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> pynvml <span class="hljs-keyword">import</span> *


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_gpu_utilization</span>():
<span class="hljs-meta">... </span>    nvmlInit()
<span class="hljs-meta">... </span>    handle = nvmlDeviceGetHandleByIndex(<span class="hljs-number">0</span>)
<span class="hljs-meta">... </span>    info = nvmlDeviceGetMemoryInfo(handle)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;GPU memory occupied: <span class="hljs-subst">{info.used//<span class="hljs-number">1024</span>**<span class="hljs-number">2</span>}</span> MB.&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">print_summary</span>(<span class="hljs-params">result</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Time: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_runtime&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Samples/second: <span class="hljs-subst">{result.metrics[<span class="hljs-string">&#x27;train_samples_per_second&#x27;</span>]:<span class="hljs-number">.2</span>f}</span>&quot;</span>)
<span class="hljs-meta">... </span>    print_gpu_utilization()`,wrap:!1}}),z=new U({props:{code:"cHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">0</span> MB.`,wrap:!1}}),v=new U({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEElMEF0b3JjaC5vbmVzKCgxJTJDJTIwMSkpLnRvKCUyMmN1ZGElMjIpJTBBcHJpbnRfZ3B1X3V0aWxpemF0aW9uKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch


<span class="hljs-meta">&gt;&gt;&gt; </span>torch.ones((<span class="hljs-number">1</span>, <span class="hljs-number">1</span>)).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">1343</span> MB.`,wrap:!1}}),$=new Ct({props:{title:"Load Model",local:"load-model",headingTag:"h2"}}),G=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZS1iZXJ0JTJGYmVydC1sYXJnZS11bmNhc2VkJTIyKS50byglMjJjdWRhJTIyKSUwQXByaW50X2dwdV91dGlsaXphdGlvbigp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification


<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;google-bert/bert-large-uncased&quot;</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>print_gpu_utilization()
GPU memory occupied: <span class="hljs-number">2631</span> MB.`,wrap:!1}}),_=new U({props:{code:"bnZpZGlhLXNtaQ==",highlighted:"nvidia-smi",wrap:!1}}),B=new U({props:{code:"VHVlJTIwSmFuJTIwMTElMjAwOCUzQTU4JTNBMDUlMjAyMDIyJTBBJTJCLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMkIlMEElN0MlMjBOVklESUEtU01JJTIwNDYwLjkxLjAzJTIwJTIwJTIwJTIwRHJpdmVyJTIwVmVyc2lvbiUzQSUyMDQ2MC45MS4wMyUyMCUyMCUyMCUyMENVREElMjBWZXJzaW9uJTNBJTIwMTEuMiUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3Qy0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMkItLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSU3QyUyMEdQVSUyMCUyME5hbWUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBQZXJzaXN0ZW5jZS1NJTdDJTIwQnVzLUlkJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwRGlzcC5BJTIwJTdDJTIwVm9sYXRpbGUlMjBVbmNvcnIuJTIwRUNDJTIwJTdDJTBBJTdDJTIwRmFuJTIwJTIwVGVtcCUyMCUyMFBlcmYlMjAlMjBQd3IlM0FVc2FnZSUyRkNhcCU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyME1lbW9yeS1Vc2FnZSUyMCU3QyUyMEdQVS1VdGlsJTIwJTIwQ29tcHV0ZSUyME0uJTIwJTdDJTBBJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwTUlHJTIwTS4lMjAlN0MlMEElN0MlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMkIlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlMkIlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlM0QlN0MlMEElN0MlMjAlMjAlMjAwJTIwJTIwVGVzbGElMjBWMTAwLVNYTTIuLi4lMjAlMjBPbiUyMCUyMCUyMCU3QyUyMDAwMDAwMDAwJTNBMDAlM0EwNC4wJTIwT2ZmJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwMCUyMCU3QyUwQSU3QyUyME4lMkZBJTIwJTIwJTIwMzdDJTIwJTIwJTIwJTIwUDAlMjAlMjAlMjAlMjAzOVclMjAlMkYlMjAzMDBXJTIwJTdDJTIwJTIwJTIwMjYzMU1pQiUyMCUyRiUyMDE2MTYwTWlCJTIwJTdDJTIwJTIwJTIwJTIwJTIwJTIwMCUyNSUyMCUyMCUyMCUyMCUyMCUyMERlZmF1bHQlMjAlN0MlMEElN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBOJTJGQSUyMCU3QyUwQSUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0lMkItLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCLS0tLS0tLS0tLS0tLS0tLS0tLS0tLSUyQiUwQSUwQSUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJCJTBBJTdDJTIwUHJvY2Vzc2VzJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdDJTBBJTdDJTIwJTIwR1BVJTIwJTIwJTIwR0klMjAlMjAlMjBDSSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMFBJRCUyMCUyMCUyMFR5cGUlMjAlMjAlMjBQcm9jZXNzJTIwbmFtZSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMEdQVSUyME1lbW9yeSUyMCU3QyUwQSU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMElEJTIwJTIwJTIwSUQlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBVc2FnZSUyMCUyMCUyMCUyMCUyMCUyMCU3QyUwQSU3QyUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCUzRCU3QyUwQSU3QyUyMCUyMCUyMCUyMDAlMjAlMjAlMjBOJTJGQSUyMCUyME4lMkZBJTIwJTIwJTIwJTIwJTIwJTIwMzcyMSUyMCUyMCUyMCUyMCUyMCUyMEMlMjAlMjAlMjAuLi5udnMlMkZjb2RlcGFycm90JTJGYmluJTJGcHl0aG9uJTIwJTIwJTIwJTIwJTIwMjYyOU1pQiUyMCU3QyUwQSUyQi0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tLS0tJTJC",highlighted:`Tue Jan 11 08:58:05 2022
+-----------------------------------------------------------------------------+
| NVIDIA-SMI 460.91.03    Driver Version: 460.91.03    CUDA Version: 11.2     |
|-------------------------------+----------------------+----------------------+
| GPU  Name        Persistence-M| Bus-Id        Disp.A | Volatile Uncorr. ECC |
| Fan  Temp  Perf  Pwr:Usage/Cap|         Memory-Usage | GPU-Util  Compute M. |
|                               |                      |               MIG M. |
|===============================+======================+======================|
|   0  Tesla V100-SXM2...  On   | 00000000:00:04.0 Off |                    0 |
| N/A   37C    P0    39W / 300W |   2631MiB / 16160MiB |      0%      Default |
|                               |                      |                  N/A |
+-------------------------------+----------------------+----------------------+

+-----------------------------------------------------------------------------+
| Processes:                                                                  |
|  GPU   GI   CI        PID   Type   Process name                  GPU Memory |
|        ID   ID                                                   Usage      |
|=============================================================================|
|    0   N/A  N/A      3721      C   ...nvs/codeparrot/bin/python     2629MiB |
+-----------------------------------------------------------------------------+`,wrap:!1}}),W=new U({props:{code:"ZGVmYXVsdF9hcmdzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyb3V0cHV0X2RpciUyMiUzQSUyMCUyMnRtcCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMmV2YWxfc3RyYXRlZ3klMjIlM0ElMjAlMjJzdGVwcyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMm51bV90cmFpbl9lcG9jaHMlMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIwJTIwJTIybG9nX2xldmVsJTIyJTNBJTIwJTIyZXJyb3IlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJyZXBvcnRfdG8lMjIlM0ElMjAlMjJub25lJTIyJTJDJTBBJTdE",highlighted:`default_args = {
    <span class="hljs-string">&quot;output_dir&quot;</span>: <span class="hljs-string">&quot;tmp&quot;</span>,
    <span class="hljs-string">&quot;eval_strategy&quot;</span>: <span class="hljs-string">&quot;steps&quot;</span>,
    <span class="hljs-string">&quot;num_train_epochs&quot;</span>: <span class="hljs-number">1</span>,
    <span class="hljs-string">&quot;log_level&quot;</span>: <span class="hljs-string">&quot;error&quot;</span>,
    <span class="hljs-string">&quot;report_to&quot;</span>: <span class="hljs-string">&quot;none&quot;</span>,
}`,wrap:!1}}),d=new cl({props:{$$slots:{default:[hl]},$$scope:{ctx:It}}}),V=new Ct({props:{title:"Memory utilization at vanilla training",local:"memory-utilization-at-vanilla-training",headingTag:"h2"}}),P=new U({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTJDJTIwVHJhaW5lciUyQyUyMGxvZ2dpbmclMEElMEFsb2dnaW5nLnNldF92ZXJib3NpdHlfZXJyb3IoKSUwQSUwQSUwQXRyYWluaW5nX2FyZ3MlMjAlM0QlMjBUcmFpbmluZ0FyZ3VtZW50cyhwZXJfZGV2aWNlX3RyYWluX2JhdGNoX3NpemUlM0Q0JTJDJTIwKipkZWZhdWx0X2FyZ3MpJTBBdHJhaW5lciUyMCUzRCUyMFRyYWluZXIobW9kZWwlM0Rtb2RlbCUyQyUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTIwdHJhaW5fZGF0YXNldCUzRGRzKSUwQXJlc3VsdCUyMCUzRCUyMHRyYWluZXIudHJhaW4oKSUwQXByaW50X3N1bW1hcnkocmVzdWx0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments, Trainer, logging

<span class="hljs-meta">&gt;&gt;&gt; </span>logging.set_verbosity_error()


<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(per_device_train_batch_size=<span class="hljs-number">4</span>, **default_args)
<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(model=model, args=training_args, train_dataset=ds)
<span class="hljs-meta">&gt;&gt;&gt; </span>result = trainer.train()
<span class="hljs-meta">&gt;&gt;&gt; </span>print_summary(result)`,wrap:!1}}),H=new U({props:{code:"VGltZSUzQSUyMDU3LjgyJTBBU2FtcGxlcyUyRnNlY29uZCUzQSUyMDguODYlMEFHUFUlMjBtZW1vcnklMjBvY2N1cGllZCUzQSUyMDE0OTQ5JTIwTUIu",highlighted:`<span class="hljs-keyword">Time:</span> 57.82
Samples/second: 8.86
GPU memory occupied: 14949 MB.`,wrap:!1}}),F=new Ct({props:{title:"Anatomy of Model’s Operations",local:"anatomy-of-models-operations",headingTag:"h2"}}),K=new Ct({props:{title:"Anatomy of Model’s Memory",local:"anatomy-of-models-memory",headingTag:"h2"}}),ct=new jl({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_memory_anatomy.md"}}),{c(){J=i("meta"),c=n(),u=i("p"),jt=n(),r(j.$$.fragment),ft=n(),h=i("p"),h.textContent=be,gt=n(),C=i("p"),C.textContent=Ae,bt=n(),r(I.$$.fragment),At=n(),f=i("p"),f.innerHTML=Se,St=n(),g=i("p"),g.innerHTML=Le,Lt=n(),r(b.$$.fragment),zt=n(),A=i("p"),A.innerHTML=ze,Qt=n(),r(S.$$.fragment),vt=n(),L=i("p"),L.textContent=Qe,Rt=n(),r(z.$$.fragment),$t=n(),Q=i("p"),Q.textContent=ve,xt=n(),r(v.$$.fragment),Gt=n(),R=i("p"),R.textContent=Re,kt=n(),r($.$$.fragment),_t=n(),x=i("p"),x.innerHTML=$e,Bt=n(),r(G.$$.fragment),Et=n(),k=i("p"),k.innerHTML=xe,Wt=n(),r(_.$$.fragment),Vt=n(),r(B.$$.fragment),Zt=n(),E=i("p"),E.textContent=Ge,Pt=n(),r(W.$$.fragment),Ht=n(),r(d.$$.fragment),Nt=n(),r(V.$$.fragment),Ft=n(),Z=i("p"),Z.innerHTML=ke,Xt=n(),r(P.$$.fragment),Dt=n(),r(H.$$.fragment),qt=n(),N=i("p"),N.textContent=_e,Yt=n(),r(F.$$.fragment),Kt=n(),X=i("p"),X.textContent=Be,Ot=n(),D=i("ol"),D.innerHTML=Ee,te=n(),q=i("p"),q.textContent=We,ee=n(),Y=i("p"),Y.innerHTML=Ve,le=n(),r(K.$$.fragment),se=n(),O=i("p"),O.textContent=Ze,ne=n(),tt=i("ol"),tt.innerHTML=Pe,ae=n(),et=i("p"),et.textContent=He,ie=n(),lt=i("p"),lt.textContent=Ne,Me=n(),st=i("p"),st.innerHTML=Fe,oe=n(),nt=i("ul"),nt.innerHTML=Xe,re=n(),at=i("p"),at.innerHTML=De,pe=n(),it=i("ul"),it.innerHTML=qe,me=n(),Mt=i("p"),Mt.innerHTML=Ye,we=n(),ot=i("ul"),ot.innerHTML=Ke,Te=n(),rt=i("p"),rt.innerHTML=Oe,ye=n(),pt=i("ul"),pt.innerHTML=tl,Je=n(),mt=i("p"),mt.textContent=el,ue=n(),wt=i("p"),wt.innerHTML=ll,Ue=n(),Tt=i("p"),Tt.textContent=sl,de=n(),yt=i("p"),yt.innerHTML=nl,ce=n(),Jt=i("p"),Jt.textContent=al,je=n(),ut=i("p"),ut.innerHTML=il,he=n(),Ut=i("p"),Ut.textContent=Ml,Ce=n(),dt=i("p"),dt.innerHTML=ol,Ie=n(),r(ct.$$.fragment),fe=n(),ht=i("p"),this.h()},l(t){const e=Ul("svelte-u9bgzb",document.head);J=M(e,"META",{name:!0,content:!0}),e.forEach(l),c=a(t),u=M(t,"P",{}),pl(u).forEach(l),jt=a(t),p(j.$$.fragment,t),ft=a(t),h=M(t,"P",{"data-svelte-h":!0}),o(h)!=="svelte-hnkrmx"&&(h.textContent=be),gt=a(t),C=M(t,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1senzsq"&&(C.textContent=Ae),bt=a(t),p(I.$$.fragment,t),At=a(t),f=M(t,"P",{"data-svelte-h":!0}),o(f)!=="svelte-12yc6mf"&&(f.innerHTML=Se),St=a(t),g=M(t,"P",{"data-svelte-h":!0}),o(g)!=="svelte-12nv5bp"&&(g.innerHTML=Le),Lt=a(t),p(b.$$.fragment,t),zt=a(t),A=M(t,"P",{"data-svelte-h":!0}),o(A)!=="svelte-u9uwjk"&&(A.innerHTML=ze),Qt=a(t),p(S.$$.fragment,t),vt=a(t),L=M(t,"P",{"data-svelte-h":!0}),o(L)!=="svelte-ync61x"&&(L.textContent=Qe),Rt=a(t),p(z.$$.fragment,t),$t=a(t),Q=M(t,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-5czace"&&(Q.textContent=ve),xt=a(t),p(v.$$.fragment,t),Gt=a(t),R=M(t,"P",{"data-svelte-h":!0}),o(R)!=="svelte-i7swzw"&&(R.textContent=Re),kt=a(t),p($.$$.fragment,t),_t=a(t),x=M(t,"P",{"data-svelte-h":!0}),o(x)!=="svelte-1gubaoi"&&(x.innerHTML=$e),Bt=a(t),p(G.$$.fragment,t),Et=a(t),k=M(t,"P",{"data-svelte-h":!0}),o(k)!=="svelte-11jwi8m"&&(k.innerHTML=xe),Wt=a(t),p(_.$$.fragment,t),Vt=a(t),p(B.$$.fragment,t),Zt=a(t),E=M(t,"P",{"data-svelte-h":!0}),o(E)!=="svelte-3jv7wr"&&(E.textContent=Ge),Pt=a(t),p(W.$$.fragment,t),Ht=a(t),p(d.$$.fragment,t),Nt=a(t),p(V.$$.fragment,t),Ft=a(t),Z=M(t,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-1e8llb1"&&(Z.innerHTML=ke),Xt=a(t),p(P.$$.fragment,t),Dt=a(t),p(H.$$.fragment,t),qt=a(t),N=M(t,"P",{"data-svelte-h":!0}),o(N)!=="svelte-17rqaak"&&(N.textContent=_e),Yt=a(t),p(F.$$.fragment,t),Kt=a(t),X=M(t,"P",{"data-svelte-h":!0}),o(X)!=="svelte-1yxwgxq"&&(X.textContent=Be),Ot=a(t),D=M(t,"OL",{"data-svelte-h":!0}),o(D)!=="svelte-6rh9nr"&&(D.innerHTML=Ee),te=a(t),q=M(t,"P",{"data-svelte-h":!0}),o(q)!=="svelte-133lz8w"&&(q.textContent=We),ee=a(t),Y=M(t,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-kuotmr"&&(Y.innerHTML=Ve),le=a(t),p(K.$$.fragment,t),se=a(t),O=M(t,"P",{"data-svelte-h":!0}),o(O)!=="svelte-1754txj"&&(O.textContent=Ze),ne=a(t),tt=M(t,"OL",{"data-svelte-h":!0}),o(tt)!=="svelte-sugems"&&(tt.innerHTML=Pe),ae=a(t),et=M(t,"P",{"data-svelte-h":!0}),o(et)!=="svelte-fr1nan"&&(et.textContent=He),ie=a(t),lt=M(t,"P",{"data-svelte-h":!0}),o(lt)!=="svelte-gkt5oe"&&(lt.textContent=Ne),Me=a(t),st=M(t,"P",{"data-svelte-h":!0}),o(st)!=="svelte-xrqy2v"&&(st.innerHTML=Fe),oe=a(t),nt=M(t,"UL",{"data-svelte-h":!0}),o(nt)!=="svelte-onmuxe"&&(nt.innerHTML=Xe),re=a(t),at=M(t,"P",{"data-svelte-h":!0}),o(at)!=="svelte-1lt6jd6"&&(at.innerHTML=De),pe=a(t),it=M(t,"UL",{"data-svelte-h":!0}),o(it)!=="svelte-1da4la2"&&(it.innerHTML=qe),me=a(t),Mt=M(t,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1ecbalg"&&(Mt.innerHTML=Ye),we=a(t),ot=M(t,"UL",{"data-svelte-h":!0}),o(ot)!=="svelte-4g0r46"&&(ot.innerHTML=Ke),Te=a(t),rt=M(t,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-2pm1hh"&&(rt.innerHTML=Oe),ye=a(t),pt=M(t,"UL",{"data-svelte-h":!0}),o(pt)!=="svelte-if0ig5"&&(pt.innerHTML=tl),Je=a(t),mt=M(t,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-1nzmdyx"&&(mt.textContent=el),ue=a(t),wt=M(t,"P",{"data-svelte-h":!0}),o(wt)!=="svelte-1wp748v"&&(wt.innerHTML=ll),Ue=a(t),Tt=M(t,"P",{"data-svelte-h":!0}),o(Tt)!=="svelte-1wjdkzj"&&(Tt.textContent=sl),de=a(t),yt=M(t,"P",{"data-svelte-h":!0}),o(yt)!=="svelte-1fhakxc"&&(yt.innerHTML=nl),ce=a(t),Jt=M(t,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-l8a4kr"&&(Jt.textContent=al),je=a(t),ut=M(t,"P",{"data-svelte-h":!0}),o(ut)!=="svelte-1mll0j9"&&(ut.innerHTML=il),he=a(t),Ut=M(t,"P",{"data-svelte-h":!0}),o(Ut)!=="svelte-10o41gl"&&(Ut.textContent=Ml),Ce=a(t),dt=M(t,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-a36np0"&&(dt.innerHTML=ol),Ie=a(t),p(ct.$$.fragment,t),fe=a(t),ht=M(t,"P",{}),pl(ht).forEach(l),this.h()},h(){ml(J,"name","hf:doc:metadata"),ml(J,"content",Il)},m(t,e){dl(document.head,J),s(t,c,e),s(t,u,e),s(t,jt,e),m(j,t,e),s(t,ft,e),s(t,h,e),s(t,gt,e),s(t,C,e),s(t,bt,e),m(I,t,e),s(t,At,e),s(t,f,e),s(t,St,e),s(t,g,e),s(t,Lt,e),m(b,t,e),s(t,zt,e),s(t,A,e),s(t,Qt,e),m(S,t,e),s(t,vt,e),s(t,L,e),s(t,Rt,e),m(z,t,e),s(t,$t,e),s(t,Q,e),s(t,xt,e),m(v,t,e),s(t,Gt,e),s(t,R,e),s(t,kt,e),m($,t,e),s(t,_t,e),s(t,x,e),s(t,Bt,e),m(G,t,e),s(t,Et,e),s(t,k,e),s(t,Wt,e),m(_,t,e),s(t,Vt,e),m(B,t,e),s(t,Zt,e),s(t,E,e),s(t,Pt,e),m(W,t,e),s(t,Ht,e),m(d,t,e),s(t,Nt,e),m(V,t,e),s(t,Ft,e),s(t,Z,e),s(t,Xt,e),m(P,t,e),s(t,Dt,e),m(H,t,e),s(t,qt,e),s(t,N,e),s(t,Yt,e),m(F,t,e),s(t,Kt,e),s(t,X,e),s(t,Ot,e),s(t,D,e),s(t,te,e),s(t,q,e),s(t,ee,e),s(t,Y,e),s(t,le,e),m(K,t,e),s(t,se,e),s(t,O,e),s(t,ne,e),s(t,tt,e),s(t,ae,e),s(t,et,e),s(t,ie,e),s(t,lt,e),s(t,Me,e),s(t,st,e),s(t,oe,e),s(t,nt,e),s(t,re,e),s(t,at,e),s(t,pe,e),s(t,it,e),s(t,me,e),s(t,Mt,e),s(t,we,e),s(t,ot,e),s(t,Te,e),s(t,rt,e),s(t,ye,e),s(t,pt,e),s(t,Je,e),s(t,mt,e),s(t,ue,e),s(t,wt,e),s(t,Ue,e),s(t,Tt,e),s(t,de,e),s(t,yt,e),s(t,ce,e),s(t,Jt,e),s(t,je,e),s(t,ut,e),s(t,he,e),s(t,Ut,e),s(t,Ce,e),s(t,dt,e),s(t,Ie,e),m(ct,t,e),s(t,fe,e),s(t,ht,e),ge=!0},p(t,[e]){const rl={};e&2&&(rl.$$scope={dirty:e,ctx:t}),d.$set(rl)},i(t){ge||(w(j.$$.fragment,t),w(I.$$.fragment,t),w(b.$$.fragment,t),w(S.$$.fragment,t),w(z.$$.fragment,t),w(v.$$.fragment,t),w($.$$.fragment,t),w(G.$$.fragment,t),w(_.$$.fragment,t),w(B.$$.fragment,t),w(W.$$.fragment,t),w(d.$$.fragment,t),w(V.$$.fragment,t),w(P.$$.fragment,t),w(H.$$.fragment,t),w(F.$$.fragment,t),w(K.$$.fragment,t),w(ct.$$.fragment,t),ge=!0)},o(t){T(j.$$.fragment,t),T(I.$$.fragment,t),T(b.$$.fragment,t),T(S.$$.fragment,t),T(z.$$.fragment,t),T(v.$$.fragment,t),T($.$$.fragment,t),T(G.$$.fragment,t),T(_.$$.fragment,t),T(B.$$.fragment,t),T(W.$$.fragment,t),T(d.$$.fragment,t),T(V.$$.fragment,t),T(P.$$.fragment,t),T(H.$$.fragment,t),T(F.$$.fragment,t),T(K.$$.fragment,t),T(ct.$$.fragment,t),ge=!1},d(t){t&&(l(c),l(u),l(jt),l(ft),l(h),l(gt),l(C),l(bt),l(At),l(f),l(St),l(g),l(Lt),l(zt),l(A),l(Qt),l(vt),l(L),l(Rt),l($t),l(Q),l(xt),l(Gt),l(R),l(kt),l(_t),l(x),l(Bt),l(Et),l(k),l(Wt),l(Vt),l(Zt),l(E),l(Pt),l(Ht),l(Nt),l(Ft),l(Z),l(Xt),l(Dt),l(qt),l(N),l(Yt),l(Kt),l(X),l(Ot),l(D),l(te),l(q),l(ee),l(Y),l(le),l(se),l(O),l(ne),l(tt),l(ae),l(et),l(ie),l(lt),l(Me),l(st),l(oe),l(nt),l(re),l(at),l(pe),l(it),l(me),l(Mt),l(we),l(ot),l(Te),l(rt),l(ye),l(pt),l(Je),l(mt),l(ue),l(wt),l(Ue),l(Tt),l(de),l(yt),l(ce),l(Jt),l(je),l(ut),l(he),l(Ut),l(Ce),l(dt),l(Ie),l(fe),l(ht)),l(J),y(j,t),y(I,t),y(b,t),y(S,t),y(z,t),y(v,t),y($,t),y(G,t),y(_,t),y(B,t),y(W,t),y(d,t),y(V,t),y(P,t),y(H,t),y(F,t),y(K,t),y(ct,t)}}}const Il='{"title":"Model training anatomy","local":"model-training-anatomy","sections":[{"title":"Load Model","local":"load-model","sections":[],"depth":2},{"title":"Memory utilization at vanilla training","local":"memory-utilization-at-vanilla-training","sections":[],"depth":2},{"title":"Anatomy of Model’s Operations","local":"anatomy-of-models-operations","sections":[],"depth":2},{"title":"Anatomy of Model’s Memory","local":"anatomy-of-models-memory","sections":[],"depth":2}],"depth":1}';function fl(It){return Tl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class zl extends Jl{constructor(J){super(),ul(this,J,fl,Cl,wl,{})}}export{zl as component};
