import{s as Xe,n as Ye,o as Fe}from"../chunks/scheduler.9bc65507.js";import{S as Le,i as qe,g as i,s as l,r as p,A as Ae,h as o,f as s,c as n,j as Qe,u as m,x as h,k as ze,y as De,a,v as r,d as c,t as u,w as d}from"../chunks/index.707bf1b6.js";import{C as f}from"../chunks/CodeBlock.54a9f38d.js";import{D as Pe}from"../chunks/DocNotebookDropdown.41f65cb5.js";import{H as Ie}from"../chunks/Heading.342b1fa6.js";function Ke(Ze){let g,q,F,A,J,D,w,P,b,We="Image feature extraction is the task of extracting semantically meaningful features given an image. This has many use cases, including image similarity and image retrieval. Moreover, most computer vision models can be used for image feature extraction, where one can remove the task-specific head (image classification, object detection etc) and get the features. These features are very useful on a higher level: edge detection, corner detection and so on. They may also contain information about the real world (e.g. what a cat looks like) depending on how deep the model is. Therefore, these outputs can be used to train new classifiers on a specific dataset.",K,y,ve="In this guide, you will:",O,T,ke="<li>Learn to build a simple image similarity system on top of the <code>image-feature-extraction</code> pipeline.</li> <li>Accomplish the same task with bare model inference.</li>",ee,M,te,j,Ce="We have two images of cats sitting on top of fish nets, one of them is generated.",se,U,ae,$,_e='Let’s see the pipeline in action. First, initialize the pipeline. If you don’t pass any model to it, the pipeline will be automatically initialized with <a href="google/vit-base-patch16-224">google/vit-base-patch16-224</a>. If you’d like to calculate similarity, set <code>pool</code> to True.',le,I,ne,Z,xe="To infer with <code>pipe</code> pass both images to it.",ie,W,oe,v,Ve="The output contains pooled embeddings of those two images.",pe,k,me,C,Be="To get the similarity score, we need to pass them to a similarity function.",re,_,ce,x,Ne="If you want to get the last hidden states before pooling, avoid passing any value for the <code>pool</code> parameter, as it is set to <code>False</code> by default. These hidden states are useful for training new classifiers or models based on the features from the model.",ue,V,de,B,Re="Since the outputs are unpooled, we get the last hidden states where the first dimension is the batch size, and the last two are the embedding shape.",he,N,fe,R,ge,E,Ee="We can also use <code>AutoModel</code> class of transformers to get the features. <code>AutoModel</code> loads any transformers model with no task-specific head, and we can use this to get the features.",Je,G,we,H,Ge="Let’s write a simple function for inference. We will pass the inputs to the <code>processor</code> first and pass its outputs to the <code>model</code>.",be,S,ye,Q,He="We can pass the images directly to this function and get the embeddings.",Te,z,Me,X,Se="We can get the similarity again over the embeddings.",je,Y,Ue,L,$e;return J=new Ie({props:{title:"Image Feature Extraction",local:"image-feature-extraction",headingTag:"h1"}}),w=new Pe({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/image_feature_extraction.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/image_feature_extraction.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/image_feature_extraction.ipynb"}]}}),M=new Ie({props:{title:"Image Similarity using image-feature-extraction Pipeline",local:"image-similarity-using-image-feature-extraction-pipeline",headingTag:"h2"}}),U=new f({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEElMEFpbWdfdXJscyUyMCUzRCUyMCU1QiUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmNhdHMucG5nJTIyJTJDJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGY2F0cy5qcGVnJTIyJTVEJTBBaW1hZ2VfcmVhbCUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KGltZ191cmxzJTVCMCU1RCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdykuY29udmVydCglMjJSR0IlMjIpJTBBaW1hZ2VfZ2VuJTIwJTNEJTIwSW1hZ2Uub3BlbihyZXF1ZXN0cy5nZXQoaW1nX3VybHMlNUIxJTVEJTJDJTIwc3RyZWFtJTNEVHJ1ZSkucmF3KS5jb252ZXJ0KCUyMlJHQiUyMik=",highlighted:`<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

img_urls = [<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.png&quot;</span>, <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/cats.jpeg&quot;</span>]
image_real = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">0</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)
image_gen = Image.<span class="hljs-built_in">open</span>(requests.get(img_urls[<span class="hljs-number">1</span>], stream=<span class="hljs-literal">True</span>).raw).convert(<span class="hljs-string">&quot;RGB&quot;</span>)`,wrap:!1}}),I=new f({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwcGlwZWxpbmUlMEElMEFERVZJQ0UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJ2N1ZGEnJTIwaWYlMjB0b3JjaC5jdWRhLmlzX2F2YWlsYWJsZSgpJTIwZWxzZSUyMCdjcHUnKSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSh0YXNrJTNEJTIyaW1hZ2UtZmVhdHVyZS1leHRyYWN0aW9uJTIyJTJDJTIwbW9kZWxfbmFtZSUzRCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMzg0JTIyJTJDJTIwZGV2aWNlJTNEREVWSUNFJTJDJTIwcG9vbCUzRFRydWUp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

DEVICE = torch.device(<span class="hljs-string">&#x27;cuda&#x27;</span> <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> <span class="hljs-string">&#x27;cpu&#x27;</span>)
pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-384&quot;</span>, device=DEVICE, pool=<span class="hljs-literal">True</span>)`,wrap:!1}}),W=new f({props:{code:"b3V0cHV0cyUyMCUzRCUyMHBpcGUoJTVCaW1hZ2VfcmVhbCUyQyUyMGltYWdlX2dlbiU1RCk=",highlighted:"outputs = pipe([image_real, image_gen])",wrap:!1}}),k=new f({props:{code:"JTIzJTIwZ2V0JTIwdGhlJTIwbGVuZ3RoJTIwb2YlMjBhJTIwc2luZ2xlJTIwb3V0cHV0JTBBcHJpbnQobGVuKG91dHB1dHMlNUIwJTVEJTVCMCU1RCkpJTBBJTIzJTIwc2hvdyUyMG91dHB1dHMlMEFwcmludChvdXRwdXRzKSUwQSUwQSUyMyUyMDc2OCUwQSUyMyUyMCU1QiU1QiU1Qi0wLjAzOTA5MjM2OTM3NzYxMzA3JTJDJTIwMC40MzM4MTY3MDExNzM3ODIzNSUyQyUyMC0wLjA2OTEzMjU1OTAwMTQ0NTc3JTJD",highlighted:`<span class="hljs-comment"># get the length of a single output</span>
<span class="hljs-built_in">print</span>(<span class="hljs-built_in">len</span>(outputs[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))
<span class="hljs-comment"># show outputs</span>
<span class="hljs-built_in">print</span>(outputs)

<span class="hljs-comment"># 768</span>
<span class="hljs-comment"># [[[-0.03909236937761307, 0.43381670117378235, -0.06913255900144577,</span>`,wrap:!1}}),_=new f({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eSh0b3JjaC5UZW5zb3Iob3V0cHV0cyU1QjAlNUQpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdG9yY2guVGVuc29yKG91dHB1dHMlNUIxJTVEKSUyQyUyMGRpbSUzRDEpJTBBJTBBcHJpbnQoc2ltaWxhcml0eV9zY29yZSklMEElMEElMjMlMjB0ZW5zb3IoJTVCMC42MDQzJTVEKQ==",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(torch.Tensor(outputs[<span class="hljs-number">0</span>]),
                                     torch.Tensor(outputs[<span class="hljs-number">1</span>]), dim=<span class="hljs-number">1</span>)

<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6043])</span>`,wrap:!1}}),V=new f({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKHRhc2slM0QlMjJpbWFnZS1mZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMjBtb2RlbF9uYW1lJTNEJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIlMkMlMjBkZXZpY2UlM0RERVZJQ0UpJTBBb3V0cHV0JTIwJTNEJTIwcGlwZShpbWFnZV9yZWFsKQ==",highlighted:`pipe = pipeline(task=<span class="hljs-string">&quot;image-feature-extraction&quot;</span>, model_name=<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>, device=DEVICE)
output = pipe(image_real)`,wrap:!1}}),N=new f({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBcHJpbnQobnAuYXJyYXkob3V0cHV0cykuc2hhcGUpJTBBJTIzJTIwKDElMkMlMjAxOTclMkMlMjA3Njgp",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-built_in">print</span>(np.array(outputs).shape)
<span class="hljs-comment"># (1, 197, 768)</span>`,wrap:!1}}),R=new Ie({props:{title:"Getting Features and Similarities using AutoModel",local:"getting-features-and-similarities-using-automodel",headingTag:"h2"}}),G=new f({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9JbWFnZVByb2Nlc3NvciUyQyUyMEF1dG9Nb2RlbCUwQSUwQXByb2Nlc3NvciUyMCUzRCUyMEF1dG9JbWFnZVByb2Nlc3Nvci5mcm9tX3ByZXRyYWluZWQoJTIyZ29vZ2xlJTJGdml0LWJhc2UtcGF0Y2gxNi0yMjQlMjIpJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMmdvb2dsZSUyRnZpdC1iYXNlLXBhdGNoMTYtMjI0JTIyKS50byhERVZJQ0Up",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoImageProcessor, AutoModel

processor = AutoImageProcessor.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>)
model = AutoModel.from_pretrained(<span class="hljs-string">&quot;google/vit-base-patch16-224&quot;</span>).to(DEVICE)`,wrap:!1}}),S=new f({props:{code:"ZGVmJTIwaW5mZXIoaW1hZ2UpJTNBJTBBJTIwJTIwaW5wdXRzJTIwJTNEJTIwcHJvY2Vzc29yKGltYWdlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMikudG8oREVWSUNFKSUwQSUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmlucHV0cyklMEElMjAlMjByZXR1cm4lMjBvdXRwdXRzLnBvb2xlcl9vdXRwdXQ=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">infer</span>(<span class="hljs-params">image</span>):
  inputs = processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(DEVICE)
  outputs = model(**inputs)
  <span class="hljs-keyword">return</span> outputs.pooler_output`,wrap:!1}}),z=new f({props:{code:"ZW1iZWRfcmVhbCUyMCUzRCUyMGluZmVyKGltYWdlX3JlYWwpJTBBZW1iZWRfZ2VuJTIwJTNEJTIwaW5mZXIoaW1hZ2VfZ2VuKQ==",highlighted:`embed_real = infer(image_real)
embed_gen = infer(image_gen)`,wrap:!1}}),Y=new f({props:{code:"ZnJvbSUyMHRvcmNoLm5uLmZ1bmN0aW9uYWwlMjBpbXBvcnQlMjBjb3NpbmVfc2ltaWxhcml0eSUwQSUwQXNpbWlsYXJpdHlfc2NvcmUlMjAlM0QlMjBjb3NpbmVfc2ltaWxhcml0eShlbWJlZF9yZWFsJTJDJTIwZW1iZWRfZ2VuJTJDJTIwZGltJTNEMSklMEFwcmludChzaW1pbGFyaXR5X3Njb3JlKSUwQSUwQSUyMyUyMHRlbnNvciglNUIwLjYwNjElNUQlMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnJTJDJTIwZ3JhZF9mbiUzRCUzQ1N1bUJhY2t3YXJkMSUzRSk=",highlighted:`<span class="hljs-keyword">from</span> torch.nn.functional <span class="hljs-keyword">import</span> cosine_similarity

similarity_score = cosine_similarity(embed_real, embed_gen, dim=<span class="hljs-number">1</span>)
<span class="hljs-built_in">print</span>(similarity_score)

<span class="hljs-comment"># tensor([0.6061], device=&#x27;cuda:0&#x27;, grad_fn=&lt;SumBackward1&gt;)</span>`,wrap:!1}}),{c(){g=i("meta"),q=l(),F=i("p"),A=l(),p(J.$$.fragment),D=l(),p(w.$$.fragment),P=l(),b=i("p"),b.textContent=We,K=l(),y=i("p"),y.textContent=ve,O=l(),T=i("ul"),T.innerHTML=ke,ee=l(),p(M.$$.fragment),te=l(),j=i("p"),j.textContent=Ce,se=l(),p(U.$$.fragment),ae=l(),$=i("p"),$.innerHTML=_e,le=l(),p(I.$$.fragment),ne=l(),Z=i("p"),Z.innerHTML=xe,ie=l(),p(W.$$.fragment),oe=l(),v=i("p"),v.textContent=Ve,pe=l(),p(k.$$.fragment),me=l(),C=i("p"),C.textContent=Be,re=l(),p(_.$$.fragment),ce=l(),x=i("p"),x.innerHTML=Ne,ue=l(),p(V.$$.fragment),de=l(),B=i("p"),B.textContent=Re,he=l(),p(N.$$.fragment),fe=l(),p(R.$$.fragment),ge=l(),E=i("p"),E.innerHTML=Ee,Je=l(),p(G.$$.fragment),we=l(),H=i("p"),H.innerHTML=Ge,be=l(),p(S.$$.fragment),ye=l(),Q=i("p"),Q.textContent=He,Te=l(),p(z.$$.fragment),Me=l(),X=i("p"),X.textContent=Se,je=l(),p(Y.$$.fragment),Ue=l(),L=i("p"),this.h()},l(e){const t=Ae("svelte-u9bgzb",document.head);g=o(t,"META",{name:!0,content:!0}),t.forEach(s),q=n(e),F=o(e,"P",{}),Qe(F).forEach(s),A=n(e),m(J.$$.fragment,e),D=n(e),m(w.$$.fragment,e),P=n(e),b=o(e,"P",{"data-svelte-h":!0}),h(b)!=="svelte-htpxsg"&&(b.textContent=We),K=n(e),y=o(e,"P",{"data-svelte-h":!0}),h(y)!=="svelte-dkb44i"&&(y.textContent=ve),O=n(e),T=o(e,"UL",{"data-svelte-h":!0}),h(T)!=="svelte-o9mygf"&&(T.innerHTML=ke),ee=n(e),m(M.$$.fragment,e),te=n(e),j=o(e,"P",{"data-svelte-h":!0}),h(j)!=="svelte-1y1lzmz"&&(j.textContent=Ce),se=n(e),m(U.$$.fragment,e),ae=n(e),$=o(e,"P",{"data-svelte-h":!0}),h($)!=="svelte-ufkt7t"&&($.innerHTML=_e),le=n(e),m(I.$$.fragment,e),ne=n(e),Z=o(e,"P",{"data-svelte-h":!0}),h(Z)!=="svelte-1wqrlcg"&&(Z.innerHTML=xe),ie=n(e),m(W.$$.fragment,e),oe=n(e),v=o(e,"P",{"data-svelte-h":!0}),h(v)!=="svelte-ejn9fo"&&(v.textContent=Ve),pe=n(e),m(k.$$.fragment,e),me=n(e),C=o(e,"P",{"data-svelte-h":!0}),h(C)!=="svelte-7ov6zk"&&(C.textContent=Be),re=n(e),m(_.$$.fragment,e),ce=n(e),x=o(e,"P",{"data-svelte-h":!0}),h(x)!=="svelte-1t8cfg9"&&(x.innerHTML=Ne),ue=n(e),m(V.$$.fragment,e),de=n(e),B=o(e,"P",{"data-svelte-h":!0}),h(B)!=="svelte-u3d9d7"&&(B.textContent=Re),he=n(e),m(N.$$.fragment,e),fe=n(e),m(R.$$.fragment,e),ge=n(e),E=o(e,"P",{"data-svelte-h":!0}),h(E)!=="svelte-18d7a3m"&&(E.innerHTML=Ee),Je=n(e),m(G.$$.fragment,e),we=n(e),H=o(e,"P",{"data-svelte-h":!0}),h(H)!=="svelte-1mcm377"&&(H.innerHTML=Ge),be=n(e),m(S.$$.fragment,e),ye=n(e),Q=o(e,"P",{"data-svelte-h":!0}),h(Q)!=="svelte-1ej6c6d"&&(Q.textContent=He),Te=n(e),m(z.$$.fragment,e),Me=n(e),X=o(e,"P",{"data-svelte-h":!0}),h(X)!=="svelte-1t2j36n"&&(X.textContent=Se),je=n(e),m(Y.$$.fragment,e),Ue=n(e),L=o(e,"P",{}),Qe(L).forEach(s),this.h()},h(){ze(g,"name","hf:doc:metadata"),ze(g,"content",Oe)},m(e,t){De(document.head,g),a(e,q,t),a(e,F,t),a(e,A,t),r(J,e,t),a(e,D,t),r(w,e,t),a(e,P,t),a(e,b,t),a(e,K,t),a(e,y,t),a(e,O,t),a(e,T,t),a(e,ee,t),r(M,e,t),a(e,te,t),a(e,j,t),a(e,se,t),r(U,e,t),a(e,ae,t),a(e,$,t),a(e,le,t),r(I,e,t),a(e,ne,t),a(e,Z,t),a(e,ie,t),r(W,e,t),a(e,oe,t),a(e,v,t),a(e,pe,t),r(k,e,t),a(e,me,t),a(e,C,t),a(e,re,t),r(_,e,t),a(e,ce,t),a(e,x,t),a(e,ue,t),r(V,e,t),a(e,de,t),a(e,B,t),a(e,he,t),r(N,e,t),a(e,fe,t),r(R,e,t),a(e,ge,t),a(e,E,t),a(e,Je,t),r(G,e,t),a(e,we,t),a(e,H,t),a(e,be,t),r(S,e,t),a(e,ye,t),a(e,Q,t),a(e,Te,t),r(z,e,t),a(e,Me,t),a(e,X,t),a(e,je,t),r(Y,e,t),a(e,Ue,t),a(e,L,t),$e=!0},p:Ye,i(e){$e||(c(J.$$.fragment,e),c(w.$$.fragment,e),c(M.$$.fragment,e),c(U.$$.fragment,e),c(I.$$.fragment,e),c(W.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(N.$$.fragment,e),c(R.$$.fragment,e),c(G.$$.fragment,e),c(S.$$.fragment,e),c(z.$$.fragment,e),c(Y.$$.fragment,e),$e=!0)},o(e){u(J.$$.fragment,e),u(w.$$.fragment,e),u(M.$$.fragment,e),u(U.$$.fragment,e),u(I.$$.fragment,e),u(W.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u(G.$$.fragment,e),u(S.$$.fragment,e),u(z.$$.fragment,e),u(Y.$$.fragment,e),$e=!1},d(e){e&&(s(q),s(F),s(A),s(D),s(P),s(b),s(K),s(y),s(O),s(T),s(ee),s(te),s(j),s(se),s(ae),s($),s(le),s(ne),s(Z),s(ie),s(oe),s(v),s(pe),s(me),s(C),s(re),s(ce),s(x),s(ue),s(de),s(B),s(he),s(fe),s(ge),s(E),s(Je),s(we),s(H),s(be),s(ye),s(Q),s(Te),s(Me),s(X),s(je),s(Ue),s(L)),s(g),d(J,e),d(w,e),d(M,e),d(U,e),d(I,e),d(W,e),d(k,e),d(_,e),d(V,e),d(N,e),d(R,e),d(G,e),d(S,e),d(z,e),d(Y,e)}}}const Oe='{"title":"Image Feature Extraction","local":"image-feature-extraction","sections":[{"title":"Image Similarity using image-feature-extraction Pipeline","local":"image-similarity-using-image-feature-extraction-pipeline","sections":[],"depth":2},{"title":"Getting Features and Similarities using AutoModel","local":"getting-features-and-similarities-using-automodel","sections":[],"depth":2}],"depth":1}';function et(Ze){return Fe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class it extends Le{constructor(g){super(),qe(this,g,et,Ke,Xe,{})}}export{it as component};
