import{s as Is,n as Bs,o as gs}from"../chunks/scheduler.36a0863c.js";import{S as Cs,i as _s,g as n,s as a,r,A as ks,h as p,f as l,c as i,j as hs,u as c,x as o,k as bs,y as Zs,a as t,v as M,d,t as u,w as m}from"../chunks/index.9c13489a.js";import{C as y}from"../chunks/CodeBlock.05d8ec32.js";import{H as Fe}from"../chunks/Heading.7a254a62.js";function zs(Pe){let J,ie,te,ne,T,pe,j,Le=`In questa guida, scopriremo come creare una pipeline personalizzata e condividerla sull’ <a href="https://hf.co/models" rel="nofollow">Hub</a> o aggiungerla nella libreria
Transformers.`,oe,w,Ke=`Innanzitutto, è necessario decidere gli input grezzi che la pipeline sarà in grado di accettare. Possono essere strings, raw bytes,
dictionaries o qualsiasi cosa sia l’input desiderato più probabile. Cerca di mantenere questi input il più possibile in Python
in quanto facilita la compatibilità (anche con altri linguaggi tramite JSON). Questi saranno gli <code>inputs</code> della
pipeline (<code>preprocess</code>).`,re,U,De=`Poi definire gli <code>outputs</code>. Stessa strategia degli <code>inputs</code>. Più è seplice e meglio è. Questi saranno gli output del metodo
<code>postprocess</code>.`,ce,f,Oe=`Si parte ereditando la classe base <code>Pipeline</code>. con i 4 metodi che bisogna implementare <code>preprocess</code>,
<code>_forward</code>, <code>postprocess</code> e <code>_sanitize_parameters</code>.`,Me,h,de,b,es=`La struttura di questa suddivisione consiste nel supportare in modo relativamente continuo CPU/GPU, supportando allo stesso tempo l’esecuzione di
pre/postelaborazione sulla CPU su thread diversi.`,ue,I,ss=`<code>preprocess</code> prenderà gli input originariamente definiti e li trasformerà in qualcosa di alimentabile dal modello. Potrebbe
contenere più informazioni e di solito è un <code>Dict</code>.`,me,B,ls=`<code>_forward</code> è il dettaglio dell’implementazione e non è destinato a essere chiamato direttamente. <code>forward</code> è il metodo preferito per assicurarsi che tutto funzioni correttamente perchè contiene delle slavaguardie. Se qualcosa è
è collegato a un modello reale, appartiene al metodo <code>_forward</code>, tutto il resto è nel preprocess/postprocess.`,ye,g,ts="<code>postprocess</code> prende l’otput di <code>_forward</code> e lo trasforma nell’output finale che era stato deciso in precedenza.",Je,C,as="<code>_sanitize_parameters</code> esiste per consentire agli utenti di passare i parametri ogni volta che desiderano sia a inizialization time <code>pipeline(...., maybe_arg=4)</code> che al call time <code>pipe = pipeline(...); output = pipe(...., maybe_arg=4)</code>.",Te,_,is=`<code>_sanitize_parameters</code> ritorna 3 dicts di kwargs che vengono passati direttamente a <code>preprocess</code>,
<code>_forward</code> e <code>postprocess</code>. Non riempire nulla se il chiamante non ha chiamato con alcun parametro aggiuntivo. Questo
consente di mantenere gli argomenti predefiniti nella definizione della funzione, che è sempre più “naturale”.`,je,k,ns="Un esempio classico potrebbe essere l’argomento <code>top_k</code> nel post processing dei classification tasks.",we,Z,Ue,z,ps=`In order to achieve that, we’ll update our <code>postprocess</code> method with a default parameter to <code>5</code>. and edit
<code>_sanitize_parameters</code> to allow this new parameter.`,fe,v,he,A,os=`Cercare di mantenere gli input/output molto semplici e idealmente serializzabili in JSON, in quanto ciò rende l’uso della pipeline molto facile
senza richiedere agli utenti di comprendere nuovi tipi di oggetti. È anche relativamente comune supportare molti tipi di argomenti
per facilitarne l’uso (ad esempio file audio, possono essere nomi di file, URL o byte puri).`,be,G,Ie,q,rs="Per registrar il tuo <code>new-task</code> alla lista dei tasks supportati, devi aggiungerlo al <code>PIPELINE_REGISTRY</code>:",Be,H,ge,X,cs="Puoi specificare il modello di default che desideri, in questo caso dovrebbe essere accompagnato da una revisione specifica (che può essere il nome di un branch o l’hash di un commit, in questo caso abbiamo preso <code>&quot;abcdef&quot;</code>) e anche dal type:",Ce,V,_e,N,ke,W,Ms=`Per condividere la tua pipeline personalizzata sull’Hub, devi solo salvare il codice della tua sottoclasse <code>Pipeline</code> in un file
python. Per esempio, supponiamo di voler utilizzare una pipeline personalizzata per la classificazione delle coppie di frasi come la seguente:`,Ze,R,ze,E,ds="L’implementazione è agnostica al framework, e lavorerà sia con modelli PyTorch che con TensorFlow. Se l’abbiamo salvato in un file chiamato <code>pair_classification.py</code>, può essere successivamente importato e registrato in questo modo:",ve,$,Ae,x,us=`Una volta fatto, possiamo usarla con un modello pretrained. L’istanza <code>sgugger/finetuned-bert-mrpc</code> è stata
fine-tuned sul dataset MRPC, che classifica le coppie di frasi come parafrasi o no.`,Ge,Q,qe,Y,ms="Successivamente possiamo condividerlo sull’Hub usando il metodo <code>push_to_hub</code>",He,S,Xe,F,ys=`Questo codice copierà il file dove è stato definitp <code>PairClassificationPipeline</code> all’interno della cartella <code>&quot;test-dynamic-pipeline&quot;</code>,
insieme al salvataggio del modello e del tokenizer della pipeline, prima di pushare il tutto nel repository
<code>{your_username}/test-dynamic-pipeline</code>. Dopodiché chiunque potrà utilizzarlo, purché fornisca l’opzione
<code>trust_remote_code=True</code>:`,Ve,P,Ne,L,We,K,Js=`Se vuoi contribuire con la tua pipeline a Transformers, dovrai aggiungere un modulo nel sottomodulo <code>pipelines</code>
con il codice della tua pipeline, quindi aggiungilo all’elenco dei tasks definiti in <code>pipelines/__init__.py</code>.`,Re,D,Ts="Poi hai bisogno di aggiungere i test. Crea un nuovo file <code>tests/test_pipelines_MY_PIPELINE.py</code> con esempi ed altri test.",Ee,O,js=`La funzione <code>run_pipeline_test</code> sarà molto generica e su piccoli modelli casuali su ogni possibile
architettura, come definito da <code>model_mapping</code> e <code>tf_model_mapping</code>.`,$e,ee,ws=`Questo è molto importante per testare la compatibilità futura, nel senso che se qualcuno aggiunge un nuovo modello di
<code>XXXForQuestionAnswering</code> allora il test della pipeline tenterà di essere eseguito su di esso. Poiché i modelli sono casuali, è
è impossibile controllare i valori effettivi, per questo esiste un aiuto <code>ANY</code> che tenterà solamente di far corrispondere l’output della pipeline TYPE.`,xe,se,Us="Hai anche <em>bisogno</em> di implementare 2 (idealmente 4) test.",Qe,le,fs=`<li><code>test_small_model_pt</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_tf</code>.</li> <li><code>test_small_model_tf</code> : Definire 1 piccolo modello per questa pipeline (non importa se i risultati non hanno senso)
e testare i risultati della pipeline. I risultati dovrebbero essere gli stessi di <code>test_small_model_pt</code>.</li> <li><code>test_large_model_pt</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi che non ci siano  derive nelle versioni future</li> <li><code>test_large_model_tf</code> (<code>optional</code>): Testare la pipeline su una pipeline reale in cui i risultati dovrebbero avere
senso. Questi test sono lenti e dovrebbero essere contrassegnati come tali. In questo caso l’obiettivo è mostrare la pipeline e assicurarsi
che non ci siano derive nelle versioni future</li>`,Ye,ae,Se;return T=new Fe({props:{title:"Come creare una pipeline personalizzata?",local:"come-creare-una-pipeline-personalizzata",headingTag:"h1"}}),h=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFBpcGVsaW5lJTBBJTBBJTBBY2xhc3MlMjBNeVBpcGVsaW5lKFBpcGVsaW5lKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9zYW5pdGl6ZV9wYXJhbWV0ZXJzKHNlbGYlMkMlMjAqKmt3YXJncyklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyUyMCUzRCUyMCU3QiU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGlmJTIwJTIybWF5YmVfYXJnJTIyJTIwaW4lMjBrd2FyZ3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcmVwcm9jZXNzX2t3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUyMCUzRCUyMGt3YXJncyU1QiUyMm1heWJlX2FyZyUyMiU1RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwJTdCJTdEJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcHJlcHJvY2VzcyhzZWxmJTJDJTIwaW5wdXRzJTJDJTIwbWF5YmVfYXJnJTNEMiklM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtb2RlbF9pbnB1dCUyMCUzRCUyMFRlbnNvcihpbnB1dHMlNUIlMjJpbnB1dF9pZHMlMjIlNUQpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmV0dXJuJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUwQSUyMCUyMCUyMCUyMGRlZiUyMF9mb3J3YXJkKHNlbGYlMkMlMjBtb2RlbF9pbnB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwbW9kZWxfaW5wdXRzJTIwJTNEJTNEJTIwJTdCJTIybW9kZWxfaW5wdXQlMjIlM0ElMjBtb2RlbF9pbnB1dCU3RCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBzZWxmLm1vZGVsKCoqbW9kZWxfaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyME1heWJlJTIwJTdCJTIybG9naXRzJTIyJTNBJTIwVGVuc29yKC4uLiklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXRzJTBBJTBBJTIwJTIwJTIwJTIwZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNz",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">class</span> <span class="hljs-title class_">MyPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, inputs, maybe_arg=<span class="hljs-number">2</span></span>):
        model_input = Tensor(inputs[<span class="hljs-string">&quot;input_ids&quot;</span>])
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;model_input&quot;</span>: model_input}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-comment"># model_inputs == {&quot;model_input&quot;: model_input}</span>
        outputs = self.model(**model_inputs)
        <span class="hljs-comment"># Maybe {&quot;logits&quot;: Tensor(...)}</span>
        <span class="hljs-keyword">return</span> outputs

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
        <span class="hljs-keyword">return</span> best_class`,wrap:!1}}),Z=new y({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMm15LW5ldy10YXNrJTIyKSUwQXBpcGUoJTIyVGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIpJTBBJTBBcGlwZSglMjJUaGlzJTIwaXMlMjBhJTIwdGVzdCUyMiUyQyUyMHRvcF9rJTNEMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipeline(<span class="hljs-string">&quot;my-new-task&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;3-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.05</span>}
{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;4-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;5-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.025</span>}]

<span class="hljs-meta">&gt;&gt;&gt; </span>pipe(<span class="hljs-string">&quot;This is a test&quot;</span>, top_k=<span class="hljs-number">2</span>)
[{<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;1-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.8</span>}, {<span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-string">&quot;2-star&quot;</span>, <span class="hljs-string">&quot;score&quot;</span>: <span class="hljs-number">0.1</span>}]`,wrap:!1}}),v=new y({props:{code:"ZGVmJTIwcG9zdHByb2Nlc3Moc2VsZiUyQyUyMG1vZGVsX291dHB1dHMlMkMlMjB0b3BfayUzRDUpJTNBJTBBJTIwJTIwJTIwJTIwYmVzdF9jbGFzcyUyMCUzRCUyMG1vZGVsX291dHB1dHMlNUIlMjJsb2dpdHMlMjIlNUQuc29mdG1heCgtMSklMEElMjAlMjAlMjAlMjAlMjMlMjBBZGQlMjBsb2dpYyUyMHRvJTIwaGFuZGxlJTIwdG9wX2slMEElMjAlMjAlMjAlMjByZXR1cm4lMjBiZXN0X2NsYXNzJTBBJTBBJTBBZGVmJTIwX3Nhbml0aXplX3BhcmFtZXRlcnMoc2VsZiUyQyUyMCoqa3dhcmdzKSUzQSUwQSUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJtYXliZV9hcmclMjIlMjBpbiUyMGt3YXJncyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByZXByb2Nlc3Nfa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTIwJTNEJTIwa3dhcmdzJTVCJTIybWF5YmVfYXJnJTIyJTVEJTBBJTBBJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTIwJTNEJTIwJTdCJTdEJTBBJTIwJTIwJTIwJTIwaWYlMjAlMjJ0b3BfayUyMiUyMGluJTIwa3dhcmdzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcG9zdHByb2Nlc3Nfa3dhcmdzJTVCJTIydG9wX2slMjIlNUQlMjAlM0QlMjBrd2FyZ3MlNUIlMjJ0b3BfayUyMiU1RCUwQSUyMCUyMCUyMCUyMHJldHVybiUyMHByZXByb2Nlc3Nfa3dhcmdzJTJDJTIwJTdCJTdEJTJDJTIwcG9zdHByb2Nlc3Nfa3dhcmdz",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs, top_k=<span class="hljs-number">5</span></span>):
    best_class = model_outputs[<span class="hljs-string">&quot;logits&quot;</span>].softmax(-<span class="hljs-number">1</span>)
    <span class="hljs-comment"># Add logic to handle top_k</span>
    <span class="hljs-keyword">return</span> best_class


<span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
    preprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;maybe_arg&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        preprocess_kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>] = kwargs[<span class="hljs-string">&quot;maybe_arg&quot;</span>]

    postprocess_kwargs = {}
    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;top_k&quot;</span> <span class="hljs-keyword">in</span> kwargs:
        postprocess_kwargs[<span class="hljs-string">&quot;top_k&quot;</span>] = kwargs[<span class="hljs-string">&quot;top_k&quot;</span>]
    <span class="hljs-keyword">return</span> preprocess_kwargs, {}, postprocess_kwargs`,wrap:!1}}),G=new Fe({props:{title:"Aggiungilo alla lista dei tasks supportati",local:"aggiungilo-alla-lista-dei-tasks-supportati",headingTag:"h2"}}),H=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5waXBlbGluZXMlMjBpbXBvcnQlMjBQSVBFTElORV9SRUdJU1RSWSUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMm5ldy10YXNrJTIyJTJDJTBBJTIwJTIwJTIwJTIwcGlwZWxpbmVfY2xhc3MlM0RNeVBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
)`,wrap:!1}}),V=new y({props:{code:"UElQRUxJTkVfUkVHSVNUUlkucmVnaXN0ZXJfcGlwZWxpbmUoJTBBJTIwJTIwJTIwJTIwJTIybmV3LXRhc2slMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRE15UGlwZWxpbmUlMkMlMEElMjAlMjAlMjAlMjBwdF9tb2RlbCUzREF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEElMjAlMjAlMjAlMjBkZWZhdWx0JTNEJTdCJTIycHQlMjIlM0ElMjAoJTIydXNlciUyRmF3ZXNvbWVfbW9kZWwlMjIlMkMlMjAlMjJhYmNkZWYlMjIpJTdEJTJDJTBBJTIwJTIwJTIwJTIwdHlwZSUzRCUyMnRleHQlMjIlMkMlMjAlMjAlMjMlMjBjdXJyZW50JTIwc3VwcG9ydCUyMHR5cGUlM0ElMjB0ZXh0JTJDJTIwYXVkaW8lMkMlMjBpbWFnZSUyQyUyMG11bHRpbW9kYWwlMEEp",highlighted:`PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;new-task&quot;</span>,
    pipeline_class=MyPipeline,
    pt_model=AutoModelForSequenceClassification,
    default={<span class="hljs-string">&quot;pt&quot;</span>: (<span class="hljs-string">&quot;user/awesome_model&quot;</span>, <span class="hljs-string">&quot;abcdef&quot;</span>)},
    <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;text&quot;</span>,  <span class="hljs-comment"># current support type: text, audio, image, multimodal</span>
)`,wrap:!1}}),N=new Fe({props:{title:"Condividi la tua pipeline sull’Hub",local:"condividi-la-tua-pipeline-sullhub",headingTag:"h2"}}),R=new y({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Pipeline


<span class="hljs-keyword">def</span> <span class="hljs-title function_">softmax</span>(<span class="hljs-params">outputs</span>):
    maxes = np.<span class="hljs-built_in">max</span>(outputs, axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)
    shifted_exp = np.exp(outputs - maxes)
    <span class="hljs-keyword">return</span> shifted_exp / shifted_exp.<span class="hljs-built_in">sum</span>(axis=-<span class="hljs-number">1</span>, keepdims=<span class="hljs-literal">True</span>)


<span class="hljs-keyword">class</span> <span class="hljs-title class_">PairClassificationPipeline</span>(<span class="hljs-title class_ inherited__">Pipeline</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_sanitize_parameters</span>(<span class="hljs-params">self, **kwargs</span>):
        preprocess_kwargs = {}
        <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;second_text&quot;</span> <span class="hljs-keyword">in</span> kwargs:
            preprocess_kwargs[<span class="hljs-string">&quot;second_text&quot;</span>] = kwargs[<span class="hljs-string">&quot;second_text&quot;</span>]
        <span class="hljs-keyword">return</span> preprocess_kwargs, {}, {}

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess</span>(<span class="hljs-params">self, text, second_text=<span class="hljs-literal">None</span></span>):
        <span class="hljs-keyword">return</span> self.tokenizer(text, text_pair=second_text, return_tensors=self.framework)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">_forward</span>(<span class="hljs-params">self, model_inputs</span>):
        <span class="hljs-keyword">return</span> self.model(**model_inputs)

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">postprocess</span>(<span class="hljs-params">self, model_outputs</span>):
        logits = model_outputs.logits[<span class="hljs-number">0</span>].numpy()
        probabilities = softmax(logits)

        best_class = np.argmax(probabilities)
        label = self.model.config.id2label[best_class]
        score = probabilities[best_class].item()
        logits = logits.tolist()
        <span class="hljs-keyword">return</span> {<span class="hljs-string">&quot;label&quot;</span>: label, <span class="hljs-string">&quot;score&quot;</span>: score, <span class="hljs-string">&quot;logits&quot;</span>: logits}`,wrap:!1}}),$=new y({props:{code:"ZnJvbSUyMHBhaXJfY2xhc3NpZmljYXRpb24lMjBpbXBvcnQlMjBQYWlyQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQWZyb20lMjB0cmFuc2Zvcm1lcnMucGlwZWxpbmVzJTIwaW1wb3J0JTIwUElQRUxJTkVfUkVHSVNUUlklMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUyQyUyMFRGQXV0b01vZGVsRm9yU2VxdWVuY2VDbGFzc2lmaWNhdGlvbiUwQSUwQVBJUEVMSU5FX1JFR0lTVFJZLnJlZ2lzdGVyX3BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMEElMjAlMjAlMjAlMjBwaXBlbGluZV9jbGFzcyUzRFBhaXJDbGFzc2lmaWNhdGlvblBpcGVsaW5lJTJDJTBBJTIwJTIwJTIwJTIwcHRfbW9kZWwlM0RBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTJDJTBBJTIwJTIwJTIwJTIwdGZfbW9kZWwlM0RURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> pair_classification <span class="hljs-keyword">import</span> PairClassificationPipeline
<span class="hljs-keyword">from</span> transformers.pipelines <span class="hljs-keyword">import</span> PIPELINE_REGISTRY
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification, TFAutoModelForSequenceClassification

PIPELINE_REGISTRY.register_pipeline(
    <span class="hljs-string">&quot;pair-classification&quot;</span>,
    pipeline_class=PairClassificationPipeline,
    pt_model=AutoModelForSequenceClassification,
    tf_model=TFAutoModelForSequenceClassification,
)`,wrap:!1}}),Q=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKCUyMnBhaXItY2xhc3NpZmljYXRpb24lMjIlMkMlMjBtb2RlbCUzRCUyMnNndWdnZXIlMkZmaW5ldHVuZWQtYmVydC1tcnBjJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(<span class="hljs-string">&quot;pair-classification&quot;</span>, model=<span class="hljs-string">&quot;sgugger/finetuned-bert-mrpc&quot;</span>)`,wrap:!1}}),S=new y({props:{code:"Y2xhc3NpZmllci5wdXNoX3RvX2h1YiglMjJ0ZXN0LWR5bmFtaWMtcGlwZWxpbmUlMjIp",highlighted:'classifier.push_to_hub(<span class="hljs-string">&quot;test-dynamic-pipeline&quot;</span>)',wrap:!1}}),P=new y({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMHBpcGVsaW5lJTBBJTBBY2xhc3NpZmllciUyMCUzRCUyMHBpcGVsaW5lKG1vZGVsJTNEJTIyJTdCeW91cl91c2VybmFtZSU3RCUyRnRlc3QtZHluYW1pYy1waXBlbGluZSUyMiUyQyUyMHRydXN0X3JlbW90ZV9jb2RlJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> pipeline

classifier = pipeline(model=<span class="hljs-string">&quot;{your_username}/test-dynamic-pipeline&quot;</span>, trust_remote_code=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new Fe({props:{title:"Aggiungere la pipeline a Transformers",local:"aggiungere-la-pipeline-a-transformers",headingTag:"h2"}}),{c(){J=n("meta"),ie=a(),te=n("p"),ne=a(),r(T.$$.fragment),pe=a(),j=n("p"),j.innerHTML=Le,oe=a(),w=n("p"),w.innerHTML=Ke,re=a(),U=n("p"),U.innerHTML=De,ce=a(),f=n("p"),f.innerHTML=Oe,Me=a(),r(h.$$.fragment),de=a(),b=n("p"),b.textContent=es,ue=a(),I=n("p"),I.innerHTML=ss,me=a(),B=n("p"),B.innerHTML=ls,ye=a(),g=n("p"),g.innerHTML=ts,Je=a(),C=n("p"),C.innerHTML=as,Te=a(),_=n("p"),_.innerHTML=is,je=a(),k=n("p"),k.innerHTML=ns,we=a(),r(Z.$$.fragment),Ue=a(),z=n("p"),z.innerHTML=ps,fe=a(),r(v.$$.fragment),he=a(),A=n("p"),A.textContent=os,be=a(),r(G.$$.fragment),Ie=a(),q=n("p"),q.innerHTML=rs,Be=a(),r(H.$$.fragment),ge=a(),X=n("p"),X.innerHTML=cs,Ce=a(),r(V.$$.fragment),_e=a(),r(N.$$.fragment),ke=a(),W=n("p"),W.innerHTML=Ms,Ze=a(),r(R.$$.fragment),ze=a(),E=n("p"),E.innerHTML=ds,ve=a(),r($.$$.fragment),Ae=a(),x=n("p"),x.innerHTML=us,Ge=a(),r(Q.$$.fragment),qe=a(),Y=n("p"),Y.innerHTML=ms,He=a(),r(S.$$.fragment),Xe=a(),F=n("p"),F.innerHTML=ys,Ve=a(),r(P.$$.fragment),Ne=a(),r(L.$$.fragment),We=a(),K=n("p"),K.innerHTML=Js,Re=a(),D=n("p"),D.innerHTML=Ts,Ee=a(),O=n("p"),O.innerHTML=js,$e=a(),ee=n("p"),ee.innerHTML=ws,xe=a(),se=n("p"),se.innerHTML=Us,Qe=a(),le=n("ul"),le.innerHTML=fs,Ye=a(),ae=n("p"),this.h()},l(e){const s=ks("svelte-u9bgzb",document.head);J=p(s,"META",{name:!0,content:!0}),s.forEach(l),ie=i(e),te=p(e,"P",{}),hs(te).forEach(l),ne=i(e),c(T.$$.fragment,e),pe=i(e),j=p(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-11810ad"&&(j.innerHTML=Le),oe=i(e),w=p(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1iatkga"&&(w.innerHTML=Ke),re=i(e),U=p(e,"P",{"data-svelte-h":!0}),o(U)!=="svelte-i2xp1j"&&(U.innerHTML=De),ce=i(e),f=p(e,"P",{"data-svelte-h":!0}),o(f)!=="svelte-eef5a9"&&(f.innerHTML=Oe),Me=i(e),c(h.$$.fragment,e),de=i(e),b=p(e,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1lfi6tr"&&(b.textContent=es),ue=i(e),I=p(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-m2oyf8"&&(I.innerHTML=ss),me=i(e),B=p(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-xk0co8"&&(B.innerHTML=ls),ye=i(e),g=p(e,"P",{"data-svelte-h":!0}),o(g)!=="svelte-wbceks"&&(g.innerHTML=ts),Je=i(e),C=p(e,"P",{"data-svelte-h":!0}),o(C)!=="svelte-1w8676p"&&(C.innerHTML=as),Te=i(e),_=p(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-wn1l5e"&&(_.innerHTML=is),je=i(e),k=p(e,"P",{"data-svelte-h":!0}),o(k)!=="svelte-hymnzr"&&(k.innerHTML=ns),we=i(e),c(Z.$$.fragment,e),Ue=i(e),z=p(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-nsc0of"&&(z.innerHTML=ps),fe=i(e),c(v.$$.fragment,e),he=i(e),A=p(e,"P",{"data-svelte-h":!0}),o(A)!=="svelte-1fkgamo"&&(A.textContent=os),be=i(e),c(G.$$.fragment,e),Ie=i(e),q=p(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-4zkgvo"&&(q.innerHTML=rs),Be=i(e),c(H.$$.fragment,e),ge=i(e),X=p(e,"P",{"data-svelte-h":!0}),o(X)!=="svelte-u38mjv"&&(X.innerHTML=cs),Ce=i(e),c(V.$$.fragment,e),_e=i(e),c(N.$$.fragment,e),ke=i(e),W=p(e,"P",{"data-svelte-h":!0}),o(W)!=="svelte-16cgcsm"&&(W.innerHTML=Ms),Ze=i(e),c(R.$$.fragment,e),ze=i(e),E=p(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-libyk9"&&(E.innerHTML=ds),ve=i(e),c($.$$.fragment,e),Ae=i(e),x=p(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-vhle5u"&&(x.innerHTML=us),Ge=i(e),c(Q.$$.fragment,e),qe=i(e),Y=p(e,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-g3f5h"&&(Y.innerHTML=ms),He=i(e),c(S.$$.fragment,e),Xe=i(e),F=p(e,"P",{"data-svelte-h":!0}),o(F)!=="svelte-1jl4eog"&&(F.innerHTML=ys),Ve=i(e),c(P.$$.fragment,e),Ne=i(e),c(L.$$.fragment,e),We=i(e),K=p(e,"P",{"data-svelte-h":!0}),o(K)!=="svelte-3oo5s6"&&(K.innerHTML=Js),Re=i(e),D=p(e,"P",{"data-svelte-h":!0}),o(D)!=="svelte-17yxzlw"&&(D.innerHTML=Ts),Ee=i(e),O=p(e,"P",{"data-svelte-h":!0}),o(O)!=="svelte-agzokg"&&(O.innerHTML=js),$e=i(e),ee=p(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-td3vn9"&&(ee.innerHTML=ws),xe=i(e),se=p(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-dschfg"&&(se.innerHTML=Us),Qe=i(e),le=p(e,"UL",{"data-svelte-h":!0}),o(le)!=="svelte-1c56iwk"&&(le.innerHTML=fs),Ye=i(e),ae=p(e,"P",{}),hs(ae).forEach(l),this.h()},h(){bs(J,"name","hf:doc:metadata"),bs(J,"content",vs)},m(e,s){Zs(document.head,J),t(e,ie,s),t(e,te,s),t(e,ne,s),M(T,e,s),t(e,pe,s),t(e,j,s),t(e,oe,s),t(e,w,s),t(e,re,s),t(e,U,s),t(e,ce,s),t(e,f,s),t(e,Me,s),M(h,e,s),t(e,de,s),t(e,b,s),t(e,ue,s),t(e,I,s),t(e,me,s),t(e,B,s),t(e,ye,s),t(e,g,s),t(e,Je,s),t(e,C,s),t(e,Te,s),t(e,_,s),t(e,je,s),t(e,k,s),t(e,we,s),M(Z,e,s),t(e,Ue,s),t(e,z,s),t(e,fe,s),M(v,e,s),t(e,he,s),t(e,A,s),t(e,be,s),M(G,e,s),t(e,Ie,s),t(e,q,s),t(e,Be,s),M(H,e,s),t(e,ge,s),t(e,X,s),t(e,Ce,s),M(V,e,s),t(e,_e,s),M(N,e,s),t(e,ke,s),t(e,W,s),t(e,Ze,s),M(R,e,s),t(e,ze,s),t(e,E,s),t(e,ve,s),M($,e,s),t(e,Ae,s),t(e,x,s),t(e,Ge,s),M(Q,e,s),t(e,qe,s),t(e,Y,s),t(e,He,s),M(S,e,s),t(e,Xe,s),t(e,F,s),t(e,Ve,s),M(P,e,s),t(e,Ne,s),M(L,e,s),t(e,We,s),t(e,K,s),t(e,Re,s),t(e,D,s),t(e,Ee,s),t(e,O,s),t(e,$e,s),t(e,ee,s),t(e,xe,s),t(e,se,s),t(e,Qe,s),t(e,le,s),t(e,Ye,s),t(e,ae,s),Se=!0},p:Bs,i(e){Se||(d(T.$$.fragment,e),d(h.$$.fragment,e),d(Z.$$.fragment,e),d(v.$$.fragment,e),d(G.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(N.$$.fragment,e),d(R.$$.fragment,e),d($.$$.fragment,e),d(Q.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(L.$$.fragment,e),Se=!0)},o(e){u(T.$$.fragment,e),u(h.$$.fragment,e),u(Z.$$.fragment,e),u(v.$$.fragment,e),u(G.$$.fragment,e),u(H.$$.fragment,e),u(V.$$.fragment,e),u(N.$$.fragment,e),u(R.$$.fragment,e),u($.$$.fragment,e),u(Q.$$.fragment,e),u(S.$$.fragment,e),u(P.$$.fragment,e),u(L.$$.fragment,e),Se=!1},d(e){e&&(l(ie),l(te),l(ne),l(pe),l(j),l(oe),l(w),l(re),l(U),l(ce),l(f),l(Me),l(de),l(b),l(ue),l(I),l(me),l(B),l(ye),l(g),l(Je),l(C),l(Te),l(_),l(je),l(k),l(we),l(Ue),l(z),l(fe),l(he),l(A),l(be),l(Ie),l(q),l(Be),l(ge),l(X),l(Ce),l(_e),l(ke),l(W),l(Ze),l(ze),l(E),l(ve),l(Ae),l(x),l(Ge),l(qe),l(Y),l(He),l(Xe),l(F),l(Ve),l(Ne),l(We),l(K),l(Re),l(D),l(Ee),l(O),l($e),l(ee),l(xe),l(se),l(Qe),l(le),l(Ye),l(ae)),l(J),m(T,e),m(h,e),m(Z,e),m(v,e),m(G,e),m(H,e),m(V,e),m(N,e),m(R,e),m($,e),m(Q,e),m(S,e),m(P,e),m(L,e)}}}const vs='{"title":"Come creare una pipeline personalizzata?","local":"come-creare-una-pipeline-personalizzata","sections":[{"title":"Aggiungilo alla lista dei tasks supportati","local":"aggiungilo-alla-lista-dei-tasks-supportati","sections":[],"depth":2},{"title":"Condividi la tua pipeline sull’Hub","local":"condividi-la-tua-pipeline-sullhub","sections":[],"depth":2},{"title":"Aggiungere la pipeline a Transformers","local":"aggiungere-la-pipeline-a-transformers","sections":[],"depth":2}],"depth":1}';function As(Pe){return gs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Vs extends Cs{constructor(J){super(),_s(this,J,As,zs,Is,{})}}export{Vs as component};
