import{s as it,n as rt,o as pt}from"../chunks/scheduler.9bc65507.js";import{S as ot,i as ct,g as i,s as l,r as o,A as dt,h as r,f as a,c as n,j as lt,u as c,x as p,k as nt,y as ft,a as s,v as d,d as f,t as h,w as m}from"../chunks/index.707bf1b6.js";import{C as y}from"../chunks/CodeBlock.54a9f38d.js";import{H as g}from"../chunks/Heading.342b1fa6.js";function ht(We){let u,te,K,ae,w,se,_,De='<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Fully Sharded Data Parallel (FSDP)</a> is a data parallel method that shards a model’s parameters, gradients and optimizer states across the number of available GPUs (also called workers or <em>rank</em>). Unlike <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow">DistributedDataParallel (DDP)</a>, FSDP reduces memory-usage because a model is replicated on each GPU. This improves GPU memory-efficiency and allows you to train much larger models on fewer GPUs. FSDP is integrated with the Accelerate, a library for easily managing training in distributed environments, which means it is available for use from the <a href="/docs/transformers/v4.37.2/en/main_classes/trainer#transformers.Trainer">Trainer</a> class.',le,T,Ie="Before you start, make sure Accelerate is installed and at least PyTorch 2.1.0 or newer.",ne,$,ie,M,re,U,Xe='To start, run the <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-config" rel="nofollow"><code>accelerate config</code></a> command to create a configuration file for your training environment. Accelerate uses this configuration file to automatically setup the correct training environment based on your selected training options in <code>accelerate config</code>.',pe,b,oe,j,Ge='When you run <code>accelerate config</code>, you’ll be prompted with a series of options to configure your training environment. This section covers some of the most important FSDP options. To learn more about the other available FSDP options, take a look at the <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments.fsdp_config" rel="nofollow">fsdp_config</a> parameters.',ce,F,de,Z,ze="FSDP offers a number of sharding strategies to select from:",fe,J,Le="<li><code>FULL_SHARD</code> - shards model parameters, gradients and optimizer states across workers; select <code>1</code> for this option</li> <li><code>SHARD_GRAD_OP</code>- shard gradients and optimizer states across workers; select <code>2</code> for this option</li> <li><code>NO_SHARD</code> - don’t shard anything (this is equivalent to DDP); select <code>3</code> for this option</li> <li><code>HYBRID_SHARD</code> - shard model parameters, gradients and optimizer states within each worker where each worker also has a full copy; select <code>4</code> for this option</li> <li><code>HYBRID_SHARD_ZERO2</code> - shard gradients and optimizer states within each worker where each worker also has a full copy; select <code>5</code> for this option</li>",he,v,Ye="This is enabled by the <code>fsdp_sharding_strategy</code> flag.",me,B,ue,P,Ae="You could also offload parameters and gradients when they are not in use to the CPU to save even more GPU memory and help you fit large models where even FSDP may not be sufficient. This is enabled by setting <code>fsdp_offload_params: true</code> when running <code>accelerate config</code>.",ge,S,ye,H,Ee="FSDP is applied by wrapping each layer in the network. The wrapping is usually applied in a nested way where the full weights are discarded after each forward pass to save memory for use in the next layer. The <em>auto wrapping</em> policy is the simplest way to implement this and you don’t need to change any code. You should select <code>fsdp_auto_wrap_policy: TRANSFORMER_BASED_WRAP</code> to wrap a Transformer layer and <code>fsdp_transformer_layer_cls_to_wrap</code> to specify which layer to wrap (for example <code>BertLayer</code>).",we,C,Ve="Otherwise, you can choose a size-based wrapping policy where FSDP is applied to a layer if it exceeds a certain number of parameters. This is enabled by setting <code>fsdp_wrap_policy: SIZE_BASED_WRAP</code> and <code>min_num_param</code> to the desired size threshold.",_e,k,Te,x,Qe='Intermediate checkpoints should be saved with <code>fsdp_state_dict_type: SHARDED_STATE_DICT</code> because saving the full state dict with CPU offloading on rank 0 takes a lot of time and often results in <code>NCCL Timeout</code> errors due to indefinite hanging during broadcasting. You can resume training with the sharded state dicts with the <a href="https://huggingface.co/docs/accelerate/v0.26.1/en/package_reference/accelerator#accelerate.Accelerator.load_state" rel="nofollow">load_state</a>` method.',$e,N,Me,R,qe="However, when training ends, you want to save the full state dict because sharded state dict is only compatible with FSDP.",Ue,W,be,D,je,I,Oe='<a href="https://pytorch.org/xla/release/2.1/index.html" rel="nofollow">PyTorch XLA</a> supports FSDP training for TPUs and it can be enabled by modifying the FSDP configuration file generated by <code>accelerate config</code>. In addition to the sharding strategies and wrapping options specified above, you can add the parameters shown below to the file.',Fe,X,Ze,G,Ke='The <a href="https://github.com/pytorch/xla/blob/2e6e183e0724818f137c8135b34ef273dea33318/torch_xla/distributed/fsdp/xla_fully_sharded_data_parallel.py#L128" rel="nofollow"><code>xla_fsdp_settings</code></a> allow you to configure additional XLA-specific parameters for FSDP.',Je,z,ve,L,et="An example FSDP configuration file may look like:",Be,Y,Pe,A,tt='To launch training, run the <a href="https://huggingface.co/docs/accelerate/package_reference/cli#accelerate-launch" rel="nofollow"><code>accelerate launch</code></a> command and it’ll automatically use the configuration file you previously created with <code>accelerate config</code>.',Se,E,He,V,Ce,Q,ke,q,at="FSDP can be a powerful tool for training really large models and you have access to more than one GPU or TPU. By sharding the model parameters, optimizer and gradient states, and even offloading them to the CPU when they’re inactive, FSDP can reduce the high cost of large-scale training. If you’re interested in learning more, the following may be helpful:",xe,O,st='<li>Follow along with the more in-depth Accelerate guide for <a href="https://huggingface.co/docs/accelerate/usage_guides/fsdp" rel="nofollow">FSDP</a>.</li> <li>Read the <a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">Introducing PyTorch Fully Sharded Data Parallel (FSDP) API</a> blog post.</li> <li>Read the <a href="https://pytorch.org/blog/scaling-pytorch-models-on-cloud-tpus-with-fsdp/" rel="nofollow">Scaling PyTorch models on Cloud TPUs with FSDP</a> blog post.</li>',Ne,ee,Re;return w=new g({props:{title:"Fully Sharded Data Parallel",local:"fully-sharded-data-parallel",headingTag:"h1"}}),$=new y({props:{code:"cGlwJTIwaW5zdGFsbCUyMGFjY2VsZXJhdGU=",highlighted:"pip install accelerate",wrap:!1}}),M=new g({props:{title:"FSDP configuration",local:"fsdp-configuration",headingTag:"h2"}}),b=new y({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),F=new g({props:{title:"Sharding strategy",local:"sharding-strategy",headingTag:"h3"}}),B=new g({props:{title:"CPU offload",local:"cpu-offload",headingTag:"h3"}}),S=new g({props:{title:"Wrapping policy",local:"wrapping-policy",headingTag:"h3"}}),k=new g({props:{title:"Checkpointing",local:"checkpointing",headingTag:"h3"}}),N=new y({props:{code:"JTIzJTIwZGlyZWN0b3J5JTIwY29udGFpbmluZyUyMGNoZWNrcG9pbnRzJTBBYWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJja3B0JTIyKQ==",highlighted:`<span class="hljs-comment"># directory containing checkpoints</span>
accelerator.load_state(<span class="hljs-string">&quot;ckpt&quot;</span>)`,wrap:!1}}),W=new y({props:{code:"aWYlMjB0cmFpbmVyLmlzX2ZzZHBfZW5hYmxlZCUzQSUwQSUyMCUyMCUyMCUyMHRyYWluZXIuYWNjZWxlcmF0b3Iuc3RhdGUuZnNkcF9wbHVnaW4uc2V0X3N0YXRlX2RpY3RfdHlwZSglMjJGVUxMX1NUQVRFX0RJQ1QlMjIpJTBBJTBBdHJhaW5lci5zYXZlX21vZGVsKHNjcmlwdF9hcmdzLm91dHB1dF9kaXIp",highlighted:`<span class="hljs-keyword">if</span> trainer.is_fsdp_enabled:
    trainer.accelerator.state.fsdp_plugin.set_state_dict_type(<span class="hljs-string">&quot;FULL_STATE_DICT&quot;</span>)

trainer.save_model(script_args.output_dir)`,wrap:!1}}),D=new g({props:{title:"TPU",local:"tpu",headingTag:"h3"}}),X=new y({props:{code:"eGxhJTNBJTIwVHJ1ZSUyMCUyMyUyMG11c3QlMjBiZSUyMHNldCUyMHRvJTIwVHJ1ZSUyMHRvJTIwZW5hYmxlJTIwUHlUb3JjaCUyRlhMQSUwQXhsYV9mc2RwX3NldHRpbmdzJTNBJTIwJTIzJTIwWExBLXNwZWNpZmljJTIwRlNEUCUyMHBhcmFtZXRlcnMlMEF4bGFfZnNkcF9ncmFkX2NrcHQlM0ElMjBUcnVlJTIwJTIzJTIwdXNlJTIwZ3JhZGllbnQlMjBjaGVja3BvaW50aW5n",highlighted:`<span class="hljs-attr">xla:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># must be set to True to enable PyTorch/XLA</span>
<span class="hljs-attr">xla_fsdp_settings:</span> <span class="hljs-comment"># XLA-specific FSDP parameters</span>
<span class="hljs-attr">xla_fsdp_grad_ckpt:</span> <span class="hljs-literal">True</span> <span class="hljs-comment"># use gradient checkpointing</span>`,wrap:!1}}),z=new g({props:{title:"Launch training",local:"launch-training",headingTag:"h2"}}),Y=new y({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWJ1ZyUzQSUyMGZhbHNlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMEZTRFAlMEFkb3duY2FzdF9iZjE2JTNBJTIwJ25vJyUwQWZzZHBfY29uZmlnJTNBJTBBJTIwJTIwZnNkcF9hdXRvX3dyYXBfcG9saWN5JTNBJTIwVFJBTlNGT1JNRVJfQkFTRURfV1JBUCUwQSUyMCUyMGZzZHBfYmFja3dhcmRfcHJlZmV0Y2hfcG9saWN5JTNBJTIwQkFDS1dBUkRfUFJFJTBBJTIwJTIwZnNkcF9jcHVfcmFtX2VmZmljaWVudF9sb2FkaW5nJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfZm9yd2FyZF9wcmVmZXRjaCUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMHRydWUlMEElMjAlMjBmc2RwX3NoYXJkaW5nX3N0cmF0ZWd5JTNBJTIwMSUwQSUyMCUyMGZzZHBfc3RhdGVfZGljdF90eXBlJTNBJTIwU0hBUkRFRF9TVEFURV9ESUNUJTBBJTIwJTIwZnNkcF9zeW5jX21vZHVsZV9zdGF0ZXMlM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF90cmFuc2Zvcm1lcl9sYXllcl9jbHNfdG9fd3JhcCUzQSUyMEJlcnRMYXllciUwQSUyMCUyMGZzZHBfdXNlX29yaWdfcGFyYW1zJTNBJTIwdHJ1ZSUwQW1hY2hpbmVfcmFuayUzQSUyMDAlMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGJmMTYlMEFudW1fbWFjaGluZXMlM0ElMjAxJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDIlMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">debug:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_cpu_ram_efficient_loading:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">SHARDED_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),E=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:"accelerate launch my-trainer-script.py",wrap:!1}}),V=new y({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tZnNkcCUzRCUyMmZ1bGwlMjBzaGFyZCUyMiUyMC0tZnNkcF9jb25maWclM0QlMjJwYXRoJTJGdG8lMkZmc2RwX2NvbmZpZyUyRiUyMG15LXRyYWluZXItc2NyaXB0LnB5",highlighted:'accelerate launch --fsdp=<span class="hljs-string">&quot;full shard&quot;</span> --fsdp_config=<span class="hljs-string">&quot;path/to/fsdp_config/ my-trainer-script.py</span>',wrap:!1}}),Q=new g({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),{c(){u=i("meta"),te=l(),K=i("p"),ae=l(),o(w.$$.fragment),se=l(),_=i("p"),_.innerHTML=De,le=l(),T=i("p"),T.textContent=Ie,ne=l(),o($.$$.fragment),ie=l(),o(M.$$.fragment),re=l(),U=i("p"),U.innerHTML=Xe,pe=l(),o(b.$$.fragment),oe=l(),j=i("p"),j.innerHTML=Ge,ce=l(),o(F.$$.fragment),de=l(),Z=i("p"),Z.textContent=ze,fe=l(),J=i("ul"),J.innerHTML=Le,he=l(),v=i("p"),v.innerHTML=Ye,me=l(),o(B.$$.fragment),ue=l(),P=i("p"),P.innerHTML=Ae,ge=l(),o(S.$$.fragment),ye=l(),H=i("p"),H.innerHTML=Ee,we=l(),C=i("p"),C.innerHTML=Ve,_e=l(),o(k.$$.fragment),Te=l(),x=i("p"),x.innerHTML=Qe,$e=l(),o(N.$$.fragment),Me=l(),R=i("p"),R.textContent=qe,Ue=l(),o(W.$$.fragment),be=l(),o(D.$$.fragment),je=l(),I=i("p"),I.innerHTML=Oe,Fe=l(),o(X.$$.fragment),Ze=l(),G=i("p"),G.innerHTML=Ke,Je=l(),o(z.$$.fragment),ve=l(),L=i("p"),L.textContent=et,Be=l(),o(Y.$$.fragment),Pe=l(),A=i("p"),A.innerHTML=tt,Se=l(),o(E.$$.fragment),He=l(),o(V.$$.fragment),Ce=l(),o(Q.$$.fragment),ke=l(),q=i("p"),q.textContent=at,xe=l(),O=i("ul"),O.innerHTML=st,Ne=l(),ee=i("p"),this.h()},l(e){const t=dt("svelte-u9bgzb",document.head);u=r(t,"META",{name:!0,content:!0}),t.forEach(a),te=n(e),K=r(e,"P",{}),lt(K).forEach(a),ae=n(e),c(w.$$.fragment,e),se=n(e),_=r(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1ypo9d"&&(_.innerHTML=De),le=n(e),T=r(e,"P",{"data-svelte-h":!0}),p(T)!=="svelte-4zh7j7"&&(T.textContent=Ie),ne=n(e),c($.$$.fragment,e),ie=n(e),c(M.$$.fragment,e),re=n(e),U=r(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-il7v8z"&&(U.innerHTML=Xe),pe=n(e),c(b.$$.fragment,e),oe=n(e),j=r(e,"P",{"data-svelte-h":!0}),p(j)!=="svelte-60yrb1"&&(j.innerHTML=Ge),ce=n(e),c(F.$$.fragment,e),de=n(e),Z=r(e,"P",{"data-svelte-h":!0}),p(Z)!=="svelte-18pbstz"&&(Z.textContent=ze),fe=n(e),J=r(e,"UL",{"data-svelte-h":!0}),p(J)!=="svelte-11pbaor"&&(J.innerHTML=Le),he=n(e),v=r(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-1l7i7fk"&&(v.innerHTML=Ye),me=n(e),c(B.$$.fragment,e),ue=n(e),P=r(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-ss15nf"&&(P.innerHTML=Ae),ge=n(e),c(S.$$.fragment,e),ye=n(e),H=r(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-1wisi5e"&&(H.innerHTML=Ee),we=n(e),C=r(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-hh9gtt"&&(C.innerHTML=Ve),_e=n(e),c(k.$$.fragment,e),Te=n(e),x=r(e,"P",{"data-svelte-h":!0}),p(x)!=="svelte-xjec1v"&&(x.innerHTML=Qe),$e=n(e),c(N.$$.fragment,e),Me=n(e),R=r(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-5bvj2l"&&(R.textContent=qe),Ue=n(e),c(W.$$.fragment,e),be=n(e),c(D.$$.fragment,e),je=n(e),I=r(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-1worwgp"&&(I.innerHTML=Oe),Fe=n(e),c(X.$$.fragment,e),Ze=n(e),G=r(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-n0lvzu"&&(G.innerHTML=Ke),Je=n(e),c(z.$$.fragment,e),ve=n(e),L=r(e,"P",{"data-svelte-h":!0}),p(L)!=="svelte-69y5on"&&(L.textContent=et),Be=n(e),c(Y.$$.fragment,e),Pe=n(e),A=r(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-jgueof"&&(A.innerHTML=tt),Se=n(e),c(E.$$.fragment,e),He=n(e),c(V.$$.fragment,e),Ce=n(e),c(Q.$$.fragment,e),ke=n(e),q=r(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-hv24fk"&&(q.textContent=at),xe=n(e),O=r(e,"UL",{"data-svelte-h":!0}),p(O)!=="svelte-gtahwu"&&(O.innerHTML=st),Ne=n(e),ee=r(e,"P",{}),lt(ee).forEach(a),this.h()},h(){nt(u,"name","hf:doc:metadata"),nt(u,"content",mt)},m(e,t){ft(document.head,u),s(e,te,t),s(e,K,t),s(e,ae,t),d(w,e,t),s(e,se,t),s(e,_,t),s(e,le,t),s(e,T,t),s(e,ne,t),d($,e,t),s(e,ie,t),d(M,e,t),s(e,re,t),s(e,U,t),s(e,pe,t),d(b,e,t),s(e,oe,t),s(e,j,t),s(e,ce,t),d(F,e,t),s(e,de,t),s(e,Z,t),s(e,fe,t),s(e,J,t),s(e,he,t),s(e,v,t),s(e,me,t),d(B,e,t),s(e,ue,t),s(e,P,t),s(e,ge,t),d(S,e,t),s(e,ye,t),s(e,H,t),s(e,we,t),s(e,C,t),s(e,_e,t),d(k,e,t),s(e,Te,t),s(e,x,t),s(e,$e,t),d(N,e,t),s(e,Me,t),s(e,R,t),s(e,Ue,t),d(W,e,t),s(e,be,t),d(D,e,t),s(e,je,t),s(e,I,t),s(e,Fe,t),d(X,e,t),s(e,Ze,t),s(e,G,t),s(e,Je,t),d(z,e,t),s(e,ve,t),s(e,L,t),s(e,Be,t),d(Y,e,t),s(e,Pe,t),s(e,A,t),s(e,Se,t),d(E,e,t),s(e,He,t),d(V,e,t),s(e,Ce,t),d(Q,e,t),s(e,ke,t),s(e,q,t),s(e,xe,t),s(e,O,t),s(e,Ne,t),s(e,ee,t),Re=!0},p:rt,i(e){Re||(f(w.$$.fragment,e),f($.$$.fragment,e),f(M.$$.fragment,e),f(b.$$.fragment,e),f(F.$$.fragment,e),f(B.$$.fragment,e),f(S.$$.fragment,e),f(k.$$.fragment,e),f(N.$$.fragment,e),f(W.$$.fragment,e),f(D.$$.fragment,e),f(X.$$.fragment,e),f(z.$$.fragment,e),f(Y.$$.fragment,e),f(E.$$.fragment,e),f(V.$$.fragment,e),f(Q.$$.fragment,e),Re=!0)},o(e){h(w.$$.fragment,e),h($.$$.fragment,e),h(M.$$.fragment,e),h(b.$$.fragment,e),h(F.$$.fragment,e),h(B.$$.fragment,e),h(S.$$.fragment,e),h(k.$$.fragment,e),h(N.$$.fragment,e),h(W.$$.fragment,e),h(D.$$.fragment,e),h(X.$$.fragment,e),h(z.$$.fragment,e),h(Y.$$.fragment,e),h(E.$$.fragment,e),h(V.$$.fragment,e),h(Q.$$.fragment,e),Re=!1},d(e){e&&(a(te),a(K),a(ae),a(se),a(_),a(le),a(T),a(ne),a(ie),a(re),a(U),a(pe),a(oe),a(j),a(ce),a(de),a(Z),a(fe),a(J),a(he),a(v),a(me),a(ue),a(P),a(ge),a(ye),a(H),a(we),a(C),a(_e),a(Te),a(x),a($e),a(Me),a(R),a(Ue),a(be),a(je),a(I),a(Fe),a(Ze),a(G),a(Je),a(ve),a(L),a(Be),a(Pe),a(A),a(Se),a(He),a(Ce),a(ke),a(q),a(xe),a(O),a(Ne),a(ee)),a(u),m(w,e),m($,e),m(M,e),m(b,e),m(F,e),m(B,e),m(S,e),m(k,e),m(N,e),m(W,e),m(D,e),m(X,e),m(z,e),m(Y,e),m(E,e),m(V,e),m(Q,e)}}}const mt='{"title":"Fully Sharded Data Parallel","local":"fully-sharded-data-parallel","sections":[{"title":"FSDP configuration","local":"fsdp-configuration","sections":[{"title":"Sharding strategy","local":"sharding-strategy","sections":[],"depth":3},{"title":"CPU offload","local":"cpu-offload","sections":[],"depth":3},{"title":"Wrapping policy","local":"wrapping-policy","sections":[],"depth":3},{"title":"Checkpointing","local":"checkpointing","sections":[],"depth":3},{"title":"TPU","local":"tpu","sections":[],"depth":3}],"depth":2},{"title":"Launch training","local":"launch-training","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function ut(We){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Tt extends ot{constructor(u){super(),ct(this,u,ut,ht,it,{})}}export{Tt as component};
