import{s as Hs,o as Vs,n as ss}from"../chunks/scheduler.d586627e.js";import{S as Es,i as Ns,g as o,s as l,r as p,A as As,h as r,f as t,c as n,j as T,u as i,x as f,k as oa,y,a as s,v as m,d,t as c,w as u}from"../chunks/index.8589a59c.js";import{T as ts}from"../chunks/Tip.84e2336e.js";import{Y as Pt}from"../chunks/Youtube.49101e7b.js";import{C as g}from"../chunks/CodeBlock.47c46d2c.js";import{D as qs}from"../chunks/DocNotebookDropdown.35d6cac5.js";import{H as b}from"../chunks/Heading.a70e045b.js";function Qs(v){let h,j=`Você verá um alerta sobre alguns pesos pré-treinados que não estão sendo utilizados e que alguns pesos estão
sendo inicializados aleatoriamente. Não se preocupe, essa mensagem é completamente normal.
O header/cabeçário pré-treinado do modelo BERT é descartado e substitui-se por um header de classificação
inicializado aleatoriamente. Assim, pode aplicar o fine-tuning a este novo header do modelo em sua tarefa
de classificação de sequências fazendo um transfer learning do modelo pré-treinado.`;return{c(){h=o("p"),h.textContent=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-ejxvym"&&(h.textContent=j)},m(M,$){s(M,h,$)},p:ss,d(M){M&&t(h)}}}function Ls(v){let h,j=`O <code>Trainer</code> utiliza <code>DataCollatorWithPadding</code> por padrão, então você não precisa especificar explicitamente um
colador de dados (data collator).`;return{c(){h=o("p"),h.innerHTML=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-hfa5bk"&&(h.innerHTML=j)},m(M,$){s(M,h,$)},p:ss,d(M){M&&t(h)}}}function Ss(v){let h,j=`Se necessário, você pode obter o acesso gratuito a uma GPU na núvem por meio de um notebook no
<a href="https://colab.research.google.com/" rel="nofollow">Colaboratory</a> ou <a href="https://studiolab.sagemaker.aws/" rel="nofollow">SageMaker StudioLab</a>
se não tiver esse recurso de forma local.`;return{c(){h=o("p"),h.innerHTML=j},l(M){h=r(M,"P",{"data-svelte-h":!0}),f(h)!=="svelte-ivn2a7"&&(h.innerHTML=j)},m(M,$){s(M,h,$)},p:ss,d(M){M&&t(h)}}}function Ps(v){let h,j,M,$,U,ga,C,Ma,I,ls=`O uso de um modelo pré-treinado tem importantes vantagens. Redução do custo computacional, a pegada de carbono, e te
permite utilizar modelos de última geração sem ter que treinar um novo desde o início.
O 🤗 Transformers proporciona acesso a milhares de modelos pré-treinados numa ampla gama de tarefas.
Quando utilizar um modelo pré-treinado, treine-o com um dataset específico para a sua tarefa.
Isto é chamado de fine-tuning, uma técnica de treinamento incrivelmente poderosa. Neste tutorial faremos o fine-tuning
de um modelo pré-treinado com um framework de Deep Learning da sua escolha:`,ba,R,ns="<li>Fine-tuning de um modelo pré-treinado com o 🤗 Transformers <code>Trainer</code>.</li> <li>Fine-tuning de um modelo pré-treinado no TensorFlow com o Keras.</li> <li>Fine-tuning de um modelo pré-treinado em PyTorch nativo.</li>",ja,ra,ya,G,Ta,W,$a,z,os=`Antes de aplicar o fine-tuning a um modelo pré-treinado, baixe um dataset e prepare-o para o treinamento.
O tutorial anterior ensinará a processar os dados para o treinamento, e então poderá ter a oportunidade de testar
esse novo conhecimento em algo prático.`,wa,X,rs='Comece carregando o dataset <a href="https://huggingface.co/datasets/yelp_review_full" rel="nofollow">Yelp Reviews</a>:',Ja,B,va,F,ps=`Como já sabe, é necessário ter um tokenizador para processar o texto e incluir uma estratégia de padding e truncamento,
para manejar qualquer tamanho varíavel de sequência. Para processar o seu dataset em apenas um passo, utilize o método de
🤗 Datasets <a href="https://huggingface.co/docs/datasets/process#map" rel="nofollow"><code>map</code></a> para aplicar uma função de preprocessamento sobre
todo o dataset.`,Za,x,ka,Y,is="Se desejar, é possível criar um subconjunto menor do dataset completo para aplicar o fine-tuning e assim reduzir o tempo necessário.",_a,H,Ua,pa,Ca,V,Ia,E,Ra,N,ms=`O 🤗 Transformers proporciona uma classe <code>Trainer</code> otimizada para o treinamento de modelos de 🤗 Transformers,
facilitando os primeiros passos do treinamento sem a necessidade de escrever manualmente o seu próprio ciclo.
A API do <code>Trainer</code> suporta um grande conjunto de opções de treinamento e funcionalidades, como o logging,
o gradient accumulation e o mixed precision.`,Ga,A,ds=`Comece carregando seu modelo e especifique o número de labels de previsão.
A partir do <a href="https://huggingface.co/datasets/yelp_review_full#data-fields" rel="nofollow">Card Dataset</a> do Yelp Reveiw, que ja
sabemos ter 5 labels usamos o seguinte código:`,Wa,q,za,Z,Xa,Q,Ba,L,cs=`Em seguida, crie uma classe <code>TrainingArguments</code> que contenha todos os hiperparâmetros que possam ser ajustados, assim
como os indicadores para ativar as diferentes opções de treinamento. Para este tutorial, você pode começar o treinamento
usando os <a href="https://huggingface.co/docs/transformers/main_classes/trainer#transformers.TrainingArguments" rel="nofollow">hiperparámetros</a> padrão,
porém, sinta-se livre para experimentar com eles e encontrar uma configuração ótima.`,Fa,S,us="Especifique onde salvar os checkpoints do treinamento:",xa,P,Ya,D,Ha,K,fs=`O <code>Trainer</code> não avalia automaticamente o rendimento do modelo durante o treinamento. Será necessário passar ao
<code>Trainer</code> uma função para calcular e fazer um diagnóstico sobre as métricas. A biblioteca 🤗 Datasets proporciona
uma função de <a href="https://huggingface.co/metrics/accuracy" rel="nofollow"><code>accuracy</code></a> simples que pode ser carregada com a função
<code>load_metric</code> (ver este <a href="https://huggingface.co/docs/datasets/metrics" rel="nofollow">tutorial</a> para mais informações):`,Va,O,Ea,ee,hs=`Defina a função <code>compute</code> dentro de <code>metric</code> para calcular a precisão das suas predições.
Antes de passar as suas predições ao <code>compute</code>, é necessário converter as predições à logits (lembre-se que
todos os modelos de 🤗 Transformers retornam logits).`,Na,ae,Aa,te,gs=`Se quiser controlar as suas métricas de avaliação durante o fine-tuning, especifique o parâmetro <code>evaluation_strategy</code>
nos seus argumentos de treinamento para que o modelo considere a métrica de avaliação ao final de cada época:`,qa,se,Qa,le,La,ne,Ms="Crie um objeto <code>Trainer</code> com o seu modelo, argumentos de treinamento, conjuntos de dados de treinamento e de teste, e a sua função de avaliação:",Sa,oe,Pa,re,bs="Em seguida, aplique o fine-tuning a seu modelo chamado <code>train()</code>:",Da,pe,Ka,ia,Oa,ie,et,me,at,de,js=`Os modelos de 🤗 Transformers também permitem realizar o treinamento com o TensorFlow com a API do Keras.
Contudo, será necessário fazer algumas mudanças antes de realizar o fine-tuning.`,tt,ce,st,ue,ys=`O <code>DefaultDataCollator</code> junta os tensores em um batch para que o modelo possa ser treinado em cima deles.
Assegure-se de especificar os <code>return_tensors</code> para retornar os tensores do TensorFlow:`,lt,fe,nt,k,ot,he,Ts=`Em seguida, converta os datasets tokenizados em datasets do TensorFlow com o método
<a href="https://huggingface.co/docs/datasets/package_reference/main_classes#datasets.Dataset.to_tf_dataset" rel="nofollow"><code>to_tf_dataset</code></a>.
Especifique suas entradas em <code>columns</code> e seu rótulo em <code>label_cols</code>:`,rt,ge,pt,Me,it,be,$s="Carregue um modelo do TensorFlow com o número esperado de rótulos:",mt,je,dt,ye,ws=`A seguir, compile e ajuste o fine-tuning a seu modelo com <a href="https://keras.io/api/models/model_training_apis/" rel="nofollow"><code>fit</code></a> como
faria com qualquer outro modelo do Keras:`,ct,Te,ut,ma,ft,$e,ht,we,gt,Je,Js=`O <code>Trainer</code> se encarrega do ciclo de treinamento e permite aplicar o fine-tuning a um modelo em uma linha de código apenas.
Para os usuários que preferirem escrever o seu próprio ciclo de treinamento, também é possível aplicar o fine-tuning a um
modelo de 🤗 Transformers em PyTorch nativo.`,Mt,ve,vs=`Neste momento, talvez ocorra a necessidade de reinicar seu notebook ou executar a seguinte linha de código para liberar
memória:`,bt,Ze,jt,ke,Zs="Em sequência, faremos um post-processing manual do <code>tokenized_dataset</code> e assim prepará-lo para o treinamento.",yt,w,_e,da,ks="Apague a coluna de <code>text</code> porque o modelo não aceita texto cru como entrada:",Dt,Ue,Kt,Ce,ca,_s="Troque o nome da coluna <code>label</code> para <code>labels</code>, pois o modelo espera um argumento de mesmo nome:",Ot,Ie,es,Re,ua,Us="Defina o formato do dataset para retornar tensores do PyTorch no lugar de listas:",as,Ge,Tt,We,Cs="Em sequência, crie um subconjunto menor do dataset, como foi mostrado anteriormente, para acelerá-lo o fine-tuning.",$t,ze,wt,Xe,Jt,Be,Is="Crie um <code>DataLoader</code> para os seus datasets de treinamento e de teste para poder iterar sobre batches de dados:",vt,Fe,Zt,xe,Rs="Carregue seu modelo com o número de labels esperados:",kt,Ye,_t,He,Ut,Ve,Gs=`Crie um otimizador e um learning rate para aplicar o fine-tuning ao modelo.
Iremos utilizar o otimizador <a href="https://pytorch.org/docs/stable/generated/torch.optim.AdamW.html" rel="nofollow"><code>AdamW</code></a> do PyTorch:`,Ct,Ee,It,Ne,Ws="Defina o learning rate do <code>Trainer</code>:",Rt,Ae,Gt,qe,zs=`Por último, especifique o <code>device</code> do ambiente para utilizar uma GPU se tiver acesso à alguma. Caso contrário, o treinamento
em uma CPU pode acabar levando várias horas em vez de minutos.`,Wt,Qe,zt,_,Xt,Le,Xs="Perfeito, agora estamos prontos para começar o treinamento! 🥳",Bt,Se,Ft,Pe,Bs=`Para visualizar melhor o processo de treinamento, utilize a biblioteca <a href="https://tqdm.github.io/" rel="nofollow">tqdm</a> para adicionar
uma barra de progresso sobre o número de passos percorridos no treinamento atual:`,xt,De,Yt,Ke,Ht,Oe,Fs=`Da mesma forma que é necessário adicionar uma função de avaliação ao <code>Trainer</code>, é necessário fazer o mesmo quando
escrevendo o próprio ciclo de treinamento. Contudo, em vez de calcular e retornar a métrica final de cada época,
você deverá adicionar todos os batches com <a href="https://huggingface.co/docs/datasets/package_reference/main_classes?highlight=add_batch#datasets.Metric.add_batch" rel="nofollow"><code>add_batch</code></a>
e calcular a métrica apenas no final.`,Vt,ea,Et,fa,Nt,aa,At,ta,xs="Para mais exemplos de fine-tuning acesse:",qt,sa,Ys=`<li><p><a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">🤗 Transformers Examples</a> inclui scripts
para treinas tarefas comuns de NLP em PyTorch e TensorFlow.</p></li> <li><p><a href="notebooks">🤗 Transformers Notebooks</a> contém vários notebooks sobre como aplicar o fine-tuning a um modelo
para tarefas específicas no PyTorch e TensorFlow.</p></li>`,Qt,ha,Lt;return U=new b({props:{title:"Fine-tuning de um modelo pré-treinado",local:"fine-tuning-de-um-modelo-pré-treinado",headingTag:"h1"}}),C=new qs({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/training.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/training.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/training.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/pytorch/training.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/pt/tensorflow/training.ipynb"}]}}),G=new b({props:{title:"Preparando um dataset",local:"preparando-um-dataset",headingTag:"h2"}}),W=new Pt({props:{id:"_BZearw7f0w"}}),B=new g({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBJTBBZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldCglMjJ5ZWxwX3Jldmlld19mdWxsJTIyKSUwQWRhdGFzZXQlNUIxMDAlNUQ=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset

<span class="hljs-meta">&gt;&gt;&gt; </span>dataset = load_dataset(<span class="hljs-string">&quot;yelp_review_full&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>dataset[<span class="hljs-number">100</span>]
{<span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-number">0</span>,
 <span class="hljs-string">&#x27;text&#x27;</span>: <span class="hljs-string">&#x27;My expectations for McDonalds are t rarely high. But for one to still fail so spectacularly...that takes something special!\\\\nThe cashier took my friends\\&#x27;s order, then promptly ignored me. I had to force myself in front of a cashier who opened his register to wait on the person BEHIND me. I waited over five minutes for a gigantic order that included precisely one kid\\&#x27;s meal. After watching two people who ordered after me be handed their food, I asked where mine was. The manager started yelling at the cashiers for \\\\&quot;serving off their orders\\\\&quot; when they didn\\&#x27;t have their food. But neither cashier was anywhere near those controls, and the manager was the one serving food to customers and clearing the boards.\\\\nThe manager was rude when giving me my order. She didn\\&#x27;t make sure that I had everything ON MY RECEIPT, and never even had the decency to apologize that I felt I was getting poor service.\\\\nI\\&#x27;ve eaten at various McDonalds restaurants for over 30 years. I\\&#x27;ve worked at more than one location. I expect bad days, bad moods, and the occasional mistake. But I have yet to have a decent experience at this store. It will remain a place I avoid unless someone in my party needs to avoid illness from low blood sugar. Perhaps I should go back to the racially biased service of Steak n Shake instead!&#x27;</span>}`,wrap:!1}}),x=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiZXJ0LWJhc2UtY2FzZWQlMjIpJTBBJTBBJTBBZGVmJTIwdG9rZW5pemVfZnVuY3Rpb24oZXhhbXBsZXMpJTNBJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwdG9rZW5pemVyKGV4YW1wbGVzJTVCJTIydGV4dCUyMiU1RCUyQyUyMHBhZGRpbmclM0QlMjJtYXhfbGVuZ3RoJTIyJTJDJTIwdHJ1bmNhdGlvbiUzRFRydWUpJTBBJTBBJTBBdG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwZGF0YXNldC5tYXAodG9rZW5pemVfZnVuY3Rpb24lMkMlMjBiYXRjaGVkJTNEVHJ1ZSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize_function</span>(<span class="hljs-params">examples</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> tokenizer(examples[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = dataset.<span class="hljs-built_in">map</span>(tokenize_function, batched=<span class="hljs-literal">True</span>)`,wrap:!1}}),H=new g({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),V=new b({props:{title:"Fine-tuning com o Trainer",local:"fine-tuning-com-o-trainer",headingTag:"h2"}}),E=new Pt({props:{id:"nvBXf7s7vTI"}}),q=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),Z=new ts({props:{$$slots:{default:[Qs]},$$scope:{ctx:v}}}),Q=new b({props:{title:"Hiperparâmetros de treinamento",local:"hiperparâmetros-de-treinamento",headingTag:"h3"}}),P=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>)`,wrap:!1}}),D=new b({props:{title:"Métricas",local:"métricas",headingTag:"h3"}}),O=new g({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9tZXRyaWMlMEElMEFtZXRyaWMlMjAlM0QlMjBsb2FkX21ldHJpYyglMjJhY2N1cmFjeSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_metric

<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)`,wrap:!1}}),ae=new g({props:{code:"ZGVmJTIwY29tcHV0ZV9tZXRyaWNzKGV2YWxfcHJlZCklM0ElMEElMjAlMjAlMjAlMjBsb2dpdHMlMkMlMjBsYWJlbHMlMjAlM0QlMjBldmFsX3ByZWQlMEElMjAlMjAlMjAlMjBwcmVkaWN0aW9ucyUyMCUzRCUyMG5wLmFyZ21heChsb2dpdHMlMkMlMjBheGlzJTNELTEpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwbWV0cmljLmNvbXB1dGUocHJlZGljdGlvbnMlM0RwcmVkaWN0aW9ucyUyQyUyMHJlZmVyZW5jZXMlM0RsYWJlbHMp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_metrics</span>(<span class="hljs-params">eval_pred</span>):
<span class="hljs-meta">... </span>    logits, labels = eval_pred
<span class="hljs-meta">... </span>    predictions = np.argmax(logits, axis=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    <span class="hljs-keyword">return</span> metric.compute(predictions=predictions, references=labels)`,wrap:!1}}),se=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRyYWluaW5nQXJndW1lbnRzJTBBJTBBdHJhaW5pbmdfYXJncyUyMCUzRCUyMFRyYWluaW5nQXJndW1lbnRzKG91dHB1dF9kaXIlM0QlMjJ0ZXN0X3RyYWluZXIlMjIlMkMlMjBldmFsdWF0aW9uX3N0cmF0ZWd5JTNEJTIyZXBvY2glMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TrainingArguments

<span class="hljs-meta">&gt;&gt;&gt; </span>training_args = TrainingArguments(output_dir=<span class="hljs-string">&quot;test_trainer&quot;</span>, evaluation_strategy=<span class="hljs-string">&quot;epoch&quot;</span>)`,wrap:!1}}),le=new b({props:{title:"Trainer",local:"trainer",headingTag:"h3"}}),oe=new g({props:{code:"dHJhaW5lciUyMCUzRCUyMFRyYWluZXIoJTBBJTIwJTIwJTIwJTIwbW9kZWwlM0Rtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHNtYWxsX3RyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBldmFsX2RhdGFzZXQlM0RzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBjb21wdXRlX21ldHJpY3MlM0Rjb21wdXRlX21ldHJpY3MlMkMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>trainer = Trainer(
<span class="hljs-meta">... </span>    model=model,
<span class="hljs-meta">... </span>    args=training_args,
<span class="hljs-meta">... </span>    train_dataset=small_train_dataset,
<span class="hljs-meta">... </span>    eval_dataset=small_eval_dataset,
<span class="hljs-meta">... </span>    compute_metrics=compute_metrics,
<span class="hljs-meta">... </span>)`,wrap:!1}}),pe=new g({props:{code:"dHJhaW5lci50cmFpbigp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>trainer.train()',wrap:!1}}),ie=new b({props:{title:"Fine-tuning com Keras",local:"fine-tuning-com-keras",headingTag:"h2"}}),me=new Pt({props:{id:"rnTGBy2ax1c"}}),ce=new b({props:{title:"Conversão do dataset ao formato do TensorFlow",local:"conversão-do-dataset-ao-formato-do-tensorflow",headingTag:"h3"}}),fe=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMERlZmF1bHREYXRhQ29sbGF0b3IlMEElMEFkYXRhX2NvbGxhdG9yJTIwJTNEJTIwRGVmYXVsdERhdGFDb2xsYXRvcihyZXR1cm5fdGVuc29ycyUzRCUyMnRmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> DefaultDataCollator

<span class="hljs-meta">&gt;&gt;&gt; </span>data_collator = DefaultDataCollator(return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)`,wrap:!1}}),k=new ts({props:{$$slots:{default:[Ls]},$$scope:{ctx:v}}}),ge=new g({props:{code:"dGZfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHNtYWxsX3RyYWluX2RhdGFzZXQudG9fdGZfZGF0YXNldCglMEElMjAlMjAlMjAlMjBjb2x1bW5zJTNEJTVCJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJpbnB1dF9pZHMlMjIlMkMlMjAlMjJ0b2tlbl90eXBlX2lkcyUyMiU1RCUyQyUwQSUyMCUyMCUyMCUyMGxhYmVsX2NvbHMlM0QlMjJsYWJlbHMlMjIlMkMlMEElMjAlMjAlMjAlMjBzaHVmZmxlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMGNvbGxhdGVfZm4lM0RkYXRhX2NvbGxhdG9yJTJDJTBBJTIwJTIwJTIwJTIwYmF0Y2hfc2l6ZSUzRDglMkMlMEEpJTBBJTBBdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTIwJTNEJTIwc21hbGxfZXZhbF9kYXRhc2V0LnRvX3RmX2RhdGFzZXQoJTBBJTIwJTIwJTIwJTIwY29sdW1ucyUzRCU1QiUyMmF0dGVudGlvbl9tYXNrJTIyJTJDJTIwJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIydG9rZW5fdHlwZV9pZHMlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjBsYWJlbF9jb2xzJTNEJTIybGFiZWxzJTIyJTJDJTBBJTIwJTIwJTIwJTIwc2h1ZmZsZSUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwY29sbGF0ZV9mbiUzRGRhdGFfY29sbGF0b3IlMkMlMEElMjAlMjAlMjAlMjBiYXRjaF9zaXplJTNEOCUyQyUwQSk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>tf_train_dataset = small_train_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>tf_validation_dataset = small_eval_dataset.to_tf_dataset(
<span class="hljs-meta">... </span>    columns=[<span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;token_type_ids&quot;</span>],
<span class="hljs-meta">... </span>    label_cols=<span class="hljs-string">&quot;labels&quot;</span>,
<span class="hljs-meta">... </span>    shuffle=<span class="hljs-literal">False</span>,
<span class="hljs-meta">... </span>    collate_fn=data_collator,
<span class="hljs-meta">... </span>    batch_size=<span class="hljs-number">8</span>,
<span class="hljs-meta">... </span>)`,wrap:!1}}),Me=new b({props:{title:"Compilação e ajustes",local:"compilação-e-ajustes",headingTag:"h3"}}),je=new g({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVEZBdXRvTW9kZWxGb3JTZXF1ZW5jZUNsYXNzaWZpY2F0aW9uJTBBJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> TFAutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = TFAutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),Te=new g({props:{code:"bW9kZWwuY29tcGlsZSglMEElMjAlMjAlMjAlMjBvcHRpbWl6ZXIlM0R0Zi5rZXJhcy5vcHRpbWl6ZXJzLkFkYW0obGVhcm5pbmdfcmF0ZSUzRDVlLTUpJTJDJTBBJTIwJTIwJTIwJTIwbG9zcyUzRHRmLmtlcmFzLmxvc3Nlcy5TcGFyc2VDYXRlZ29yaWNhbENyb3NzZW50cm9weShmcm9tX2xvZ2l0cyUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwbWV0cmljcyUzRHRmLm1ldHJpY3MuU3BhcnNlQ2F0ZWdvcmljYWxBY2N1cmFjeSgpJTJDJTBBKSUwQSUwQW1vZGVsLmZpdCh0Zl90cmFpbl9kYXRhc2V0JTJDJTIwdmFsaWRhdGlvbl9kYXRhJTNEdGZfdmFsaWRhdGlvbl9kYXRhc2V0JTJDJTIwZXBvY2hzJTNEMyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">compile</span>(
<span class="hljs-meta">... </span>    optimizer=tf.keras.optimizers.Adam(learning_rate=<span class="hljs-number">5e-5</span>),
<span class="hljs-meta">... </span>    loss=tf.keras.losses.SparseCategoricalCrossentropy(from_logits=<span class="hljs-literal">True</span>),
<span class="hljs-meta">... </span>    metrics=tf.metrics.SparseCategoricalAccuracy(),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model.fit(tf_train_dataset, validation_data=tf_validation_dataset, epochs=<span class="hljs-number">3</span>)`,wrap:!1}}),$e=new b({props:{title:"Fine-tune em PyTorch nativo",local:"fine-tune-em-pytorch-nativo",headingTag:"h2"}}),we=new Pt({props:{id:"Dh9CL8fyG80"}}),Ze=new g({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBweXRvcmNoX21vZGVsJTBBZGVsJTIwdHJhaW5lciUwQXRvcmNoLmN1ZGEuZW1wdHlfY2FjaGUoKQ==",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pytorch_model
<span class="hljs-keyword">del</span> trainer
torch.cuda.empty_cache()`,wrap:!1}}),Ue=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbW92ZV9jb2x1bW5zKCU1QiUyMnRleHQlMjIlNUQp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.remove_columns([<span class="hljs-string">&quot;text&quot;</span>])',wrap:!1}}),Ie=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzJTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzLnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets = tokenized_datasets.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)',wrap:!1}}),Ge=new g({props:{code:"dG9rZW5pemVkX2RhdGFzZXRzLnNldF9mb3JtYXQoJTIydG9yY2glMjIp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>tokenized_datasets.set_format(<span class="hljs-string">&quot;torch&quot;</span>)',wrap:!1}}),ze=new g({props:{code:"c21hbGxfdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRva2VuaXplZF9kYXRhc2V0cyU1QiUyMnRyYWluJTIyJTVELnNodWZmbGUoc2VlZCUzRDQyKS5zZWxlY3QocmFuZ2UoMTAwMCkpJTBBc21hbGxfZXZhbF9kYXRhc2V0JTIwJTNEJTIwdG9rZW5pemVkX2RhdGFzZXRzJTVCJTIydGVzdCUyMiU1RC5zaHVmZmxlKHNlZWQlM0Q0Mikuc2VsZWN0KHJhbmdlKDEwMDApKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>small_train_dataset = tokenized_datasets[<span class="hljs-string">&quot;train&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>small_eval_dataset = tokenized_datasets[<span class="hljs-string">&quot;test&quot;</span>].shuffle(seed=<span class="hljs-number">42</span>).select(<span class="hljs-built_in">range</span>(<span class="hljs-number">1000</span>))`,wrap:!1}}),Xe=new b({props:{title:"DataLoader",local:"dataloader",headingTag:"h3"}}),Fe=new g({props:{code:"ZnJvbSUyMHRvcmNoLnV0aWxzLmRhdGElMjBpbXBvcnQlMjBEYXRhTG9hZGVyJTBBJTBBdHJhaW5fZGF0YWxvYWRlciUyMCUzRCUyMERhdGFMb2FkZXIoc21hbGxfdHJhaW5fZGF0YXNldCUyQyUyMHNodWZmbGUlM0RUcnVlJTJDJTIwYmF0Y2hfc2l6ZSUzRDgpJTBBZXZhbF9kYXRhbG9hZGVyJTIwJTNEJTIwRGF0YUxvYWRlcihzbWFsbF9ldmFsX2RhdGFzZXQlMkMlMjBiYXRjaF9zaXplJTNEOCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.utils.data <span class="hljs-keyword">import</span> DataLoader

<span class="hljs-meta">&gt;&gt;&gt; </span>train_dataloader = DataLoader(small_train_dataset, shuffle=<span class="hljs-literal">True</span>, batch_size=<span class="hljs-number">8</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>eval_dataloader = DataLoader(small_eval_dataset, batch_size=<span class="hljs-number">8</span>)`,wrap:!1}}),Ye=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24lMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvclNlcXVlbmNlQ2xhc3NpZmljYXRpb24uZnJvbV9wcmV0cmFpbmVkKCUyMmJlcnQtYmFzZS1jYXNlZCUyMiUyQyUyMG51bV9sYWJlbHMlM0Q1KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>model = AutoModelForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;bert-base-cased&quot;</span>, num_labels=<span class="hljs-number">5</span>)`,wrap:!1}}),He=new b({props:{title:"Otimização e configuração do Learning Rate",local:"otimização-e-configuração-do-learning-rate",headingTag:"h3"}}),Ee=new g({props:{code:"ZnJvbSUyMHRvcmNoLm9wdGltJTIwaW1wb3J0JTIwQWRhbVclMEElMEFvcHRpbWl6ZXIlMjAlM0QlMjBBZGFtVyhtb2RlbC5wYXJhbWV0ZXJzKCklMkMlMjBsciUzRDVlLTUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> torch.optim <span class="hljs-keyword">import</span> AdamW

<span class="hljs-meta">&gt;&gt;&gt; </span>optimizer = AdamW(model.parameters(), lr=<span class="hljs-number">5e-5</span>)`,wrap:!1}}),Ae=new g({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMGdldF9zY2hlZHVsZXIlMEElMEFudW1fZXBvY2hzJTIwJTNEJTIwMyUwQW51bV90cmFpbmluZ19zdGVwcyUyMCUzRCUyMG51bV9lcG9jaHMlMjAqJTIwbGVuKHRyYWluX2RhdGFsb2FkZXIpJTBBbHJfc2NoZWR1bGVyJTIwJTNEJTIwZ2V0X3NjaGVkdWxlciglMEElMjAlMjAlMjAlMjBuYW1lJTNEJTIybGluZWFyJTIyJTJDJTIwb3B0aW1pemVyJTNEb3B0aW1pemVyJTJDJTIwbnVtX3dhcm11cF9zdGVwcyUzRDAlMkMlMjBudW1fdHJhaW5pbmdfc3RlcHMlM0RudW1fdHJhaW5pbmdfc3RlcHMlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> get_scheduler

<span class="hljs-meta">&gt;&gt;&gt; </span>num_epochs = <span class="hljs-number">3</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>num_training_steps = num_epochs * <span class="hljs-built_in">len</span>(train_dataloader)
<span class="hljs-meta">&gt;&gt;&gt; </span>lr_scheduler = get_scheduler(
<span class="hljs-meta">... </span>    name=<span class="hljs-string">&quot;linear&quot;</span>, optimizer=optimizer, num_warmup_steps=<span class="hljs-number">0</span>, num_training_steps=num_training_steps
<span class="hljs-meta">... </span>)`,wrap:!1}}),Qe=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEElMEFkZXZpY2UlMjAlM0QlMjB0b3JjaC5kZXZpY2UoJTIyY3VkYSUyMiklMjBpZiUyMHRvcmNoLmN1ZGEuaXNfYXZhaWxhYmxlKCklMjBlbHNlJTIwdG9yY2guZGV2aWNlKCUyMmNwdSUyMiklMEFtb2RlbC50byhkZXZpY2Up",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>device = torch.device(<span class="hljs-string">&quot;cuda&quot;</span>) <span class="hljs-keyword">if</span> torch.cuda.is_available() <span class="hljs-keyword">else</span> torch.device(<span class="hljs-string">&quot;cpu&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.to(device)`,wrap:!1}}),_=new ts({props:{$$slots:{default:[Ss]},$$scope:{ctx:v}}}),Se=new b({props:{title:"Ciclo de treinamento",local:"ciclo-de-treinamento",headingTag:"h3"}}),De=new g({props:{code:"ZnJvbSUyMHRxZG0uYXV0byUyMGltcG9ydCUyMHRxZG0lMEElMEFwcm9ncmVzc19iYXIlMjAlM0QlMjB0cWRtKHJhbmdlKG51bV90cmFpbmluZ19zdGVwcykpJTBBJTBBbW9kZWwudHJhaW4oKSUwQWZvciUyMGVwb2NoJTIwaW4lMjByYW5nZShudW1fZXBvY2hzKSUzQSUwQSUyMCUyMCUyMCUyMGZvciUyMGJhdGNoJTIwaW4lMjB0cmFpbl9kYXRhbG9hZGVyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYmF0Y2glMjAlM0QlMjAlN0JrJTNBJTIwdi50byhkZXZpY2UpJTIwZm9yJTIwayUyQyUyMHYlMjBpbiUyMGJhdGNoLml0ZW1zKCklN0QlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbW9kZWwoKipiYXRjaCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwb3V0cHV0cy5sb3NzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbG9zcy5iYWNrd2FyZCgpJTBBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxyX3NjaGVkdWxlci5zdGVwKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwcm9ncmVzc19iYXIudXBkYXRlKDEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm

<span class="hljs-meta">&gt;&gt;&gt; </span>progress_bar = tqdm(<span class="hljs-built_in">range</span>(num_training_steps))

<span class="hljs-meta">&gt;&gt;&gt; </span>model.train()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
<span class="hljs-meta">... </span>        batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>        outputs = model(**batch)
<span class="hljs-meta">... </span>        loss = outputs.loss
<span class="hljs-meta">... </span>        loss.backward()

<span class="hljs-meta">... </span>        optimizer.step()
<span class="hljs-meta">... </span>        lr_scheduler.step()
<span class="hljs-meta">... </span>        optimizer.zero_grad()
<span class="hljs-meta">... </span>        progress_bar.update(<span class="hljs-number">1</span>)`,wrap:!1}}),Ke=new b({props:{title:"Métricas",local:"métricas",headingTag:"h3"}}),ea=new g({props:{code:"bWV0cmljJTIwJTNEJTIwbG9hZF9tZXRyaWMoJTIyYWNjdXJhY3klMjIpJTBBbW9kZWwuZXZhbCgpJTBBZm9yJTIwYmF0Y2glMjBpbiUyMGV2YWxfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMGJhdGNoJTIwJTNEJTIwJTdCayUzQSUyMHYudG8oZGV2aWNlKSUyMGZvciUyMGslMkMlMjB2JTIwaW4lMjBiYXRjaC5pdGVtcygpJTdEJTBBJTIwJTIwJTIwJTIwd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG91dHB1dHMlMjAlM0QlMjBtb2RlbCgqKmJhdGNoKSUwQSUwQSUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMubG9naXRzJTBBJTIwJTIwJTIwJTIwcHJlZGljdGlvbnMlMjAlM0QlMjB0b3JjaC5hcmdtYXgobG9naXRzJTJDJTIwZGltJTNELTEpJTBBJTIwJTIwJTIwJTIwbWV0cmljLmFkZF9iYXRjaChwcmVkaWN0aW9ucyUzRHByZWRpY3Rpb25zJTJDJTIwcmVmZXJlbmNlcyUzRGJhdGNoJTVCJTIybGFiZWxzJTIyJTVEKSUwQSUwQW1ldHJpYy5jb21wdXRlKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>metric = load_metric(<span class="hljs-string">&quot;accuracy&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> eval_dataloader:
<span class="hljs-meta">... </span>    batch = {k: v.to(device) <span class="hljs-keyword">for</span> k, v <span class="hljs-keyword">in</span> batch.items()}
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>        outputs = model(**batch)

<span class="hljs-meta">... </span>    logits = outputs.logits
<span class="hljs-meta">... </span>    predictions = torch.argmax(logits, dim=-<span class="hljs-number">1</span>)
<span class="hljs-meta">... </span>    metric.add_batch(predictions=predictions, references=batch[<span class="hljs-string">&quot;labels&quot;</span>])

<span class="hljs-meta">&gt;&gt;&gt; </span>metric.compute()`,wrap:!1}}),aa=new b({props:{title:"Recursos adicionais",local:"recursos-adicionais",headingTag:"h2"}}),{c(){h=o("meta"),j=l(),M=o("p"),$=l(),p(U.$$.fragment),ga=l(),p(C.$$.fragment),Ma=l(),I=o("p"),I.textContent=ls,ba=l(),R=o("ul"),R.innerHTML=ns,ja=l(),ra=o("a"),ya=l(),p(G.$$.fragment),Ta=l(),p(W.$$.fragment),$a=l(),z=o("p"),z.textContent=os,wa=l(),X=o("p"),X.innerHTML=rs,Ja=l(),p(B.$$.fragment),va=l(),F=o("p"),F.innerHTML=ps,Za=l(),p(x.$$.fragment),ka=l(),Y=o("p"),Y.textContent=is,_a=l(),p(H.$$.fragment),Ua=l(),pa=o("a"),Ca=l(),p(V.$$.fragment),Ia=l(),p(E.$$.fragment),Ra=l(),N=o("p"),N.innerHTML=ms,Ga=l(),A=o("p"),A.innerHTML=ds,Wa=l(),p(q.$$.fragment),za=l(),p(Z.$$.fragment),Xa=l(),p(Q.$$.fragment),Ba=l(),L=o("p"),L.innerHTML=cs,Fa=l(),S=o("p"),S.textContent=us,xa=l(),p(P.$$.fragment),Ya=l(),p(D.$$.fragment),Ha=l(),K=o("p"),K.innerHTML=fs,Va=l(),p(O.$$.fragment),Ea=l(),ee=o("p"),ee.innerHTML=hs,Na=l(),p(ae.$$.fragment),Aa=l(),te=o("p"),te.innerHTML=gs,qa=l(),p(se.$$.fragment),Qa=l(),p(le.$$.fragment),La=l(),ne=o("p"),ne.innerHTML=Ms,Sa=l(),p(oe.$$.fragment),Pa=l(),re=o("p"),re.innerHTML=bs,Da=l(),p(pe.$$.fragment),Ka=l(),ia=o("a"),Oa=l(),p(ie.$$.fragment),et=l(),p(me.$$.fragment),at=l(),de=o("p"),de.textContent=js,tt=l(),p(ce.$$.fragment),st=l(),ue=o("p"),ue.innerHTML=ys,lt=l(),p(fe.$$.fragment),nt=l(),p(k.$$.fragment),ot=l(),he=o("p"),he.innerHTML=Ts,rt=l(),p(ge.$$.fragment),pt=l(),p(Me.$$.fragment),it=l(),be=o("p"),be.textContent=$s,mt=l(),p(je.$$.fragment),dt=l(),ye=o("p"),ye.innerHTML=ws,ct=l(),p(Te.$$.fragment),ut=l(),ma=o("a"),ft=l(),p($e.$$.fragment),ht=l(),p(we.$$.fragment),gt=l(),Je=o("p"),Je.innerHTML=Js,Mt=l(),ve=o("p"),ve.textContent=vs,bt=l(),p(Ze.$$.fragment),jt=l(),ke=o("p"),ke.innerHTML=Zs,yt=l(),w=o("ol"),_e=o("li"),da=o("p"),da.innerHTML=ks,Dt=l(),p(Ue.$$.fragment),Kt=l(),Ce=o("li"),ca=o("p"),ca.innerHTML=_s,Ot=l(),p(Ie.$$.fragment),es=l(),Re=o("li"),ua=o("p"),ua.textContent=Us,as=l(),p(Ge.$$.fragment),Tt=l(),We=o("p"),We.textContent=Cs,$t=l(),p(ze.$$.fragment),wt=l(),p(Xe.$$.fragment),Jt=l(),Be=o("p"),Be.innerHTML=Is,vt=l(),p(Fe.$$.fragment),Zt=l(),xe=o("p"),xe.textContent=Rs,kt=l(),p(Ye.$$.fragment),_t=l(),p(He.$$.fragment),Ut=l(),Ve=o("p"),Ve.innerHTML=Gs,Ct=l(),p(Ee.$$.fragment),It=l(),Ne=o("p"),Ne.innerHTML=Ws,Rt=l(),p(Ae.$$.fragment),Gt=l(),qe=o("p"),qe.innerHTML=zs,Wt=l(),p(Qe.$$.fragment),zt=l(),p(_.$$.fragment),Xt=l(),Le=o("p"),Le.textContent=Xs,Bt=l(),p(Se.$$.fragment),Ft=l(),Pe=o("p"),Pe.innerHTML=Bs,xt=l(),p(De.$$.fragment),Yt=l(),p(Ke.$$.fragment),Ht=l(),Oe=o("p"),Oe.innerHTML=Fs,Vt=l(),p(ea.$$.fragment),Et=l(),fa=o("a"),Nt=l(),p(aa.$$.fragment),At=l(),ta=o("p"),ta.textContent=xs,qt=l(),sa=o("ul"),sa.innerHTML=Ys,Qt=l(),ha=o("p"),this.h()},l(e){const a=As("svelte-u9bgzb",document.head);h=r(a,"META",{name:!0,content:!0}),a.forEach(t),j=n(e),M=r(e,"P",{}),T(M).forEach(t),$=n(e),i(U.$$.fragment,e),ga=n(e),i(C.$$.fragment,e),Ma=n(e),I=r(e,"P",{"data-svelte-h":!0}),f(I)!=="svelte-fhi5po"&&(I.textContent=ls),ba=n(e),R=r(e,"UL",{"data-svelte-h":!0}),f(R)!=="svelte-1uar1qx"&&(R.innerHTML=ns),ja=n(e),ra=r(e,"A",{id:!0}),T(ra).forEach(t),ya=n(e),i(G.$$.fragment,e),Ta=n(e),i(W.$$.fragment,e),$a=n(e),z=r(e,"P",{"data-svelte-h":!0}),f(z)!=="svelte-1opso33"&&(z.textContent=os),wa=n(e),X=r(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-14tknsg"&&(X.innerHTML=rs),Ja=n(e),i(B.$$.fragment,e),va=n(e),F=r(e,"P",{"data-svelte-h":!0}),f(F)!=="svelte-wxbab7"&&(F.innerHTML=ps),Za=n(e),i(x.$$.fragment,e),ka=n(e),Y=r(e,"P",{"data-svelte-h":!0}),f(Y)!=="svelte-1cg4wp0"&&(Y.textContent=is),_a=n(e),i(H.$$.fragment,e),Ua=n(e),pa=r(e,"A",{id:!0}),T(pa).forEach(t),Ca=n(e),i(V.$$.fragment,e),Ia=n(e),i(E.$$.fragment,e),Ra=n(e),N=r(e,"P",{"data-svelte-h":!0}),f(N)!=="svelte-1j0gwk8"&&(N.innerHTML=ms),Ga=n(e),A=r(e,"P",{"data-svelte-h":!0}),f(A)!=="svelte-56udk6"&&(A.innerHTML=ds),Wa=n(e),i(q.$$.fragment,e),za=n(e),i(Z.$$.fragment,e),Xa=n(e),i(Q.$$.fragment,e),Ba=n(e),L=r(e,"P",{"data-svelte-h":!0}),f(L)!=="svelte-1vu82s5"&&(L.innerHTML=cs),Fa=n(e),S=r(e,"P",{"data-svelte-h":!0}),f(S)!=="svelte-fjh0nm"&&(S.textContent=us),xa=n(e),i(P.$$.fragment,e),Ya=n(e),i(D.$$.fragment,e),Ha=n(e),K=r(e,"P",{"data-svelte-h":!0}),f(K)!=="svelte-1o1vpfm"&&(K.innerHTML=fs),Va=n(e),i(O.$$.fragment,e),Ea=n(e),ee=r(e,"P",{"data-svelte-h":!0}),f(ee)!=="svelte-1oopkat"&&(ee.innerHTML=hs),Na=n(e),i(ae.$$.fragment,e),Aa=n(e),te=r(e,"P",{"data-svelte-h":!0}),f(te)!=="svelte-k3gxyo"&&(te.innerHTML=gs),qa=n(e),i(se.$$.fragment,e),Qa=n(e),i(le.$$.fragment,e),La=n(e),ne=r(e,"P",{"data-svelte-h":!0}),f(ne)!=="svelte-1r3j7rx"&&(ne.innerHTML=Ms),Sa=n(e),i(oe.$$.fragment,e),Pa=n(e),re=r(e,"P",{"data-svelte-h":!0}),f(re)!=="svelte-a3f13l"&&(re.innerHTML=bs),Da=n(e),i(pe.$$.fragment,e),Ka=n(e),ia=r(e,"A",{id:!0}),T(ia).forEach(t),Oa=n(e),i(ie.$$.fragment,e),et=n(e),i(me.$$.fragment,e),at=n(e),de=r(e,"P",{"data-svelte-h":!0}),f(de)!=="svelte-j16adj"&&(de.textContent=js),tt=n(e),i(ce.$$.fragment,e),st=n(e),ue=r(e,"P",{"data-svelte-h":!0}),f(ue)!=="svelte-1gyci2m"&&(ue.innerHTML=ys),lt=n(e),i(fe.$$.fragment,e),nt=n(e),i(k.$$.fragment,e),ot=n(e),he=r(e,"P",{"data-svelte-h":!0}),f(he)!=="svelte-1kkaz"&&(he.innerHTML=Ts),rt=n(e),i(ge.$$.fragment,e),pt=n(e),i(Me.$$.fragment,e),it=n(e),be=r(e,"P",{"data-svelte-h":!0}),f(be)!=="svelte-rgss8z"&&(be.textContent=$s),mt=n(e),i(je.$$.fragment,e),dt=n(e),ye=r(e,"P",{"data-svelte-h":!0}),f(ye)!=="svelte-qjchcy"&&(ye.innerHTML=ws),ct=n(e),i(Te.$$.fragment,e),ut=n(e),ma=r(e,"A",{id:!0}),T(ma).forEach(t),ft=n(e),i($e.$$.fragment,e),ht=n(e),i(we.$$.fragment,e),gt=n(e),Je=r(e,"P",{"data-svelte-h":!0}),f(Je)!=="svelte-1q1pzl3"&&(Je.innerHTML=Js),Mt=n(e),ve=r(e,"P",{"data-svelte-h":!0}),f(ve)!=="svelte-1abyi5e"&&(ve.textContent=vs),bt=n(e),i(Ze.$$.fragment,e),jt=n(e),ke=r(e,"P",{"data-svelte-h":!0}),f(ke)!=="svelte-1a8dyp8"&&(ke.innerHTML=Zs),yt=n(e),w=r(e,"OL",{});var J=T(w);_e=r(J,"LI",{});var la=T(_e);da=r(la,"P",{"data-svelte-h":!0}),f(da)!=="svelte-n1mzi4"&&(da.innerHTML=ks),Dt=n(la),i(Ue.$$.fragment,la),la.forEach(t),Kt=n(J),Ce=r(J,"LI",{});var na=T(Ce);ca=r(na,"P",{"data-svelte-h":!0}),f(ca)!=="svelte-dx24cp"&&(ca.innerHTML=_s),Ot=n(na),i(Ie.$$.fragment,na),na.forEach(t),es=n(J),Re=r(J,"LI",{});var St=T(Re);ua=r(St,"P",{"data-svelte-h":!0}),f(ua)!=="svelte-15zkuau"&&(ua.textContent=Us),as=n(St),i(Ge.$$.fragment,St),St.forEach(t),J.forEach(t),Tt=n(e),We=r(e,"P",{"data-svelte-h":!0}),f(We)!=="svelte-x0bqu0"&&(We.textContent=Cs),$t=n(e),i(ze.$$.fragment,e),wt=n(e),i(Xe.$$.fragment,e),Jt=n(e),Be=r(e,"P",{"data-svelte-h":!0}),f(Be)!=="svelte-lg4as"&&(Be.innerHTML=Is),vt=n(e),i(Fe.$$.fragment,e),Zt=n(e),xe=r(e,"P",{"data-svelte-h":!0}),f(xe)!=="svelte-1y9asxq"&&(xe.textContent=Rs),kt=n(e),i(Ye.$$.fragment,e),_t=n(e),i(He.$$.fragment,e),Ut=n(e),Ve=r(e,"P",{"data-svelte-h":!0}),f(Ve)!=="svelte-1355v62"&&(Ve.innerHTML=Gs),Ct=n(e),i(Ee.$$.fragment,e),It=n(e),Ne=r(e,"P",{"data-svelte-h":!0}),f(Ne)!=="svelte-61qbj5"&&(Ne.innerHTML=Ws),Rt=n(e),i(Ae.$$.fragment,e),Gt=n(e),qe=r(e,"P",{"data-svelte-h":!0}),f(qe)!=="svelte-794g8f"&&(qe.innerHTML=zs),Wt=n(e),i(Qe.$$.fragment,e),zt=n(e),i(_.$$.fragment,e),Xt=n(e),Le=r(e,"P",{"data-svelte-h":!0}),f(Le)!=="svelte-10cun9s"&&(Le.textContent=Xs),Bt=n(e),i(Se.$$.fragment,e),Ft=n(e),Pe=r(e,"P",{"data-svelte-h":!0}),f(Pe)!=="svelte-ibqtt9"&&(Pe.innerHTML=Bs),xt=n(e),i(De.$$.fragment,e),Yt=n(e),i(Ke.$$.fragment,e),Ht=n(e),Oe=r(e,"P",{"data-svelte-h":!0}),f(Oe)!=="svelte-i3ujem"&&(Oe.innerHTML=Fs),Vt=n(e),i(ea.$$.fragment,e),Et=n(e),fa=r(e,"A",{id:!0}),T(fa).forEach(t),Nt=n(e),i(aa.$$.fragment,e),At=n(e),ta=r(e,"P",{"data-svelte-h":!0}),f(ta)!=="svelte-vbn27k"&&(ta.textContent=xs),qt=n(e),sa=r(e,"UL",{"data-svelte-h":!0}),f(sa)!=="svelte-1n639bw"&&(sa.innerHTML=Ys),Qt=n(e),ha=r(e,"P",{}),T(ha).forEach(t),this.h()},h(){oa(h,"name","hf:doc:metadata"),oa(h,"content",Ds),oa(ra,"id","data-processing"),oa(pa,"id","trainer"),oa(ia,"id","keras"),oa(ma,"id","pytorch_native"),oa(fa,"id","additional-resources")},m(e,a){y(document.head,h),s(e,j,a),s(e,M,a),s(e,$,a),m(U,e,a),s(e,ga,a),m(C,e,a),s(e,Ma,a),s(e,I,a),s(e,ba,a),s(e,R,a),s(e,ja,a),s(e,ra,a),s(e,ya,a),m(G,e,a),s(e,Ta,a),m(W,e,a),s(e,$a,a),s(e,z,a),s(e,wa,a),s(e,X,a),s(e,Ja,a),m(B,e,a),s(e,va,a),s(e,F,a),s(e,Za,a),m(x,e,a),s(e,ka,a),s(e,Y,a),s(e,_a,a),m(H,e,a),s(e,Ua,a),s(e,pa,a),s(e,Ca,a),m(V,e,a),s(e,Ia,a),m(E,e,a),s(e,Ra,a),s(e,N,a),s(e,Ga,a),s(e,A,a),s(e,Wa,a),m(q,e,a),s(e,za,a),m(Z,e,a),s(e,Xa,a),m(Q,e,a),s(e,Ba,a),s(e,L,a),s(e,Fa,a),s(e,S,a),s(e,xa,a),m(P,e,a),s(e,Ya,a),m(D,e,a),s(e,Ha,a),s(e,K,a),s(e,Va,a),m(O,e,a),s(e,Ea,a),s(e,ee,a),s(e,Na,a),m(ae,e,a),s(e,Aa,a),s(e,te,a),s(e,qa,a),m(se,e,a),s(e,Qa,a),m(le,e,a),s(e,La,a),s(e,ne,a),s(e,Sa,a),m(oe,e,a),s(e,Pa,a),s(e,re,a),s(e,Da,a),m(pe,e,a),s(e,Ka,a),s(e,ia,a),s(e,Oa,a),m(ie,e,a),s(e,et,a),m(me,e,a),s(e,at,a),s(e,de,a),s(e,tt,a),m(ce,e,a),s(e,st,a),s(e,ue,a),s(e,lt,a),m(fe,e,a),s(e,nt,a),m(k,e,a),s(e,ot,a),s(e,he,a),s(e,rt,a),m(ge,e,a),s(e,pt,a),m(Me,e,a),s(e,it,a),s(e,be,a),s(e,mt,a),m(je,e,a),s(e,dt,a),s(e,ye,a),s(e,ct,a),m(Te,e,a),s(e,ut,a),s(e,ma,a),s(e,ft,a),m($e,e,a),s(e,ht,a),m(we,e,a),s(e,gt,a),s(e,Je,a),s(e,Mt,a),s(e,ve,a),s(e,bt,a),m(Ze,e,a),s(e,jt,a),s(e,ke,a),s(e,yt,a),s(e,w,a),y(w,_e),y(_e,da),y(_e,Dt),m(Ue,_e,null),y(w,Kt),y(w,Ce),y(Ce,ca),y(Ce,Ot),m(Ie,Ce,null),y(w,es),y(w,Re),y(Re,ua),y(Re,as),m(Ge,Re,null),s(e,Tt,a),s(e,We,a),s(e,$t,a),m(ze,e,a),s(e,wt,a),m(Xe,e,a),s(e,Jt,a),s(e,Be,a),s(e,vt,a),m(Fe,e,a),s(e,Zt,a),s(e,xe,a),s(e,kt,a),m(Ye,e,a),s(e,_t,a),m(He,e,a),s(e,Ut,a),s(e,Ve,a),s(e,Ct,a),m(Ee,e,a),s(e,It,a),s(e,Ne,a),s(e,Rt,a),m(Ae,e,a),s(e,Gt,a),s(e,qe,a),s(e,Wt,a),m(Qe,e,a),s(e,zt,a),m(_,e,a),s(e,Xt,a),s(e,Le,a),s(e,Bt,a),m(Se,e,a),s(e,Ft,a),s(e,Pe,a),s(e,xt,a),m(De,e,a),s(e,Yt,a),m(Ke,e,a),s(e,Ht,a),s(e,Oe,a),s(e,Vt,a),m(ea,e,a),s(e,Et,a),s(e,fa,a),s(e,Nt,a),m(aa,e,a),s(e,At,a),s(e,ta,a),s(e,qt,a),s(e,sa,a),s(e,Qt,a),s(e,ha,a),Lt=!0},p(e,[a]){const J={};a&2&&(J.$$scope={dirty:a,ctx:e}),Z.$set(J);const la={};a&2&&(la.$$scope={dirty:a,ctx:e}),k.$set(la);const na={};a&2&&(na.$$scope={dirty:a,ctx:e}),_.$set(na)},i(e){Lt||(d(U.$$.fragment,e),d(C.$$.fragment,e),d(G.$$.fragment,e),d(W.$$.fragment,e),d(B.$$.fragment,e),d(x.$$.fragment,e),d(H.$$.fragment,e),d(V.$$.fragment,e),d(E.$$.fragment,e),d(q.$$.fragment,e),d(Z.$$.fragment,e),d(Q.$$.fragment,e),d(P.$$.fragment,e),d(D.$$.fragment,e),d(O.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),d(ie.$$.fragment,e),d(me.$$.fragment,e),d(ce.$$.fragment,e),d(fe.$$.fragment,e),d(k.$$.fragment,e),d(ge.$$.fragment,e),d(Me.$$.fragment,e),d(je.$$.fragment,e),d(Te.$$.fragment,e),d($e.$$.fragment,e),d(we.$$.fragment,e),d(Ze.$$.fragment,e),d(Ue.$$.fragment,e),d(Ie.$$.fragment,e),d(Ge.$$.fragment,e),d(ze.$$.fragment,e),d(Xe.$$.fragment,e),d(Fe.$$.fragment,e),d(Ye.$$.fragment,e),d(He.$$.fragment,e),d(Ee.$$.fragment,e),d(Ae.$$.fragment,e),d(Qe.$$.fragment,e),d(_.$$.fragment,e),d(Se.$$.fragment,e),d(De.$$.fragment,e),d(Ke.$$.fragment,e),d(ea.$$.fragment,e),d(aa.$$.fragment,e),Lt=!0)},o(e){c(U.$$.fragment,e),c(C.$$.fragment,e),c(G.$$.fragment,e),c(W.$$.fragment,e),c(B.$$.fragment,e),c(x.$$.fragment,e),c(H.$$.fragment,e),c(V.$$.fragment,e),c(E.$$.fragment,e),c(q.$$.fragment,e),c(Z.$$.fragment,e),c(Q.$$.fragment,e),c(P.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(ae.$$.fragment,e),c(se.$$.fragment,e),c(le.$$.fragment,e),c(oe.$$.fragment,e),c(pe.$$.fragment,e),c(ie.$$.fragment,e),c(me.$$.fragment,e),c(ce.$$.fragment,e),c(fe.$$.fragment,e),c(k.$$.fragment,e),c(ge.$$.fragment,e),c(Me.$$.fragment,e),c(je.$$.fragment,e),c(Te.$$.fragment,e),c($e.$$.fragment,e),c(we.$$.fragment,e),c(Ze.$$.fragment,e),c(Ue.$$.fragment,e),c(Ie.$$.fragment,e),c(Ge.$$.fragment,e),c(ze.$$.fragment,e),c(Xe.$$.fragment,e),c(Fe.$$.fragment,e),c(Ye.$$.fragment,e),c(He.$$.fragment,e),c(Ee.$$.fragment,e),c(Ae.$$.fragment,e),c(Qe.$$.fragment,e),c(_.$$.fragment,e),c(Se.$$.fragment,e),c(De.$$.fragment,e),c(Ke.$$.fragment,e),c(ea.$$.fragment,e),c(aa.$$.fragment,e),Lt=!1},d(e){e&&(t(j),t(M),t($),t(ga),t(Ma),t(I),t(ba),t(R),t(ja),t(ra),t(ya),t(Ta),t($a),t(z),t(wa),t(X),t(Ja),t(va),t(F),t(Za),t(ka),t(Y),t(_a),t(Ua),t(pa),t(Ca),t(Ia),t(Ra),t(N),t(Ga),t(A),t(Wa),t(za),t(Xa),t(Ba),t(L),t(Fa),t(S),t(xa),t(Ya),t(Ha),t(K),t(Va),t(Ea),t(ee),t(Na),t(Aa),t(te),t(qa),t(Qa),t(La),t(ne),t(Sa),t(Pa),t(re),t(Da),t(Ka),t(ia),t(Oa),t(et),t(at),t(de),t(tt),t(st),t(ue),t(lt),t(nt),t(ot),t(he),t(rt),t(pt),t(it),t(be),t(mt),t(dt),t(ye),t(ct),t(ut),t(ma),t(ft),t(ht),t(gt),t(Je),t(Mt),t(ve),t(bt),t(jt),t(ke),t(yt),t(w),t(Tt),t(We),t($t),t(wt),t(Jt),t(Be),t(vt),t(Zt),t(xe),t(kt),t(_t),t(Ut),t(Ve),t(Ct),t(It),t(Ne),t(Rt),t(Gt),t(qe),t(Wt),t(zt),t(Xt),t(Le),t(Bt),t(Ft),t(Pe),t(xt),t(Yt),t(Ht),t(Oe),t(Vt),t(Et),t(fa),t(Nt),t(At),t(ta),t(qt),t(sa),t(Qt),t(ha)),t(h),u(U,e),u(C,e),u(G,e),u(W,e),u(B,e),u(x,e),u(H,e),u(V,e),u(E,e),u(q,e),u(Z,e),u(Q,e),u(P,e),u(D,e),u(O,e),u(ae,e),u(se,e),u(le,e),u(oe,e),u(pe,e),u(ie,e),u(me,e),u(ce,e),u(fe,e),u(k,e),u(ge,e),u(Me,e),u(je,e),u(Te,e),u($e,e),u(we,e),u(Ze,e),u(Ue),u(Ie),u(Ge),u(ze,e),u(Xe,e),u(Fe,e),u(Ye,e),u(He,e),u(Ee,e),u(Ae,e),u(Qe,e),u(_,e),u(Se,e),u(De,e),u(Ke,e),u(ea,e),u(aa,e)}}}const Ds='{"title":"Fine-tuning de um modelo pré-treinado","local":"fine-tuning-de-um-modelo-pré-treinado","sections":[{"title":"Preparando um dataset","local":"preparando-um-dataset","sections":[],"depth":2},{"title":"Fine-tuning com o Trainer","local":"fine-tuning-com-o-trainer","sections":[{"title":"Hiperparâmetros de treinamento","local":"hiperparâmetros-de-treinamento","sections":[],"depth":3},{"title":"Métricas","local":"métricas","sections":[],"depth":3},{"title":"Trainer","local":"trainer","sections":[],"depth":3}],"depth":2},{"title":"Fine-tuning com Keras","local":"fine-tuning-com-keras","sections":[{"title":"Conversão do dataset ao formato do TensorFlow","local":"conversão-do-dataset-ao-formato-do-tensorflow","sections":[],"depth":3},{"title":"Compilação e ajustes","local":"compilação-e-ajustes","sections":[],"depth":3}],"depth":2},{"title":"Fine-tune em PyTorch nativo","local":"fine-tune-em-pytorch-nativo","sections":[{"title":"DataLoader","local":"dataloader","sections":[],"depth":3},{"title":"Otimização e configuração do Learning Rate","local":"otimização-e-configuração-do-learning-rate","sections":[],"depth":3},{"title":"Ciclo de treinamento","local":"ciclo-de-treinamento","sections":[],"depth":3},{"title":"Métricas","local":"métricas","sections":[],"depth":3}],"depth":2},{"title":"Recursos adicionais","local":"recursos-adicionais","sections":[],"depth":2}],"depth":1}';function Ks(v){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ol extends Es{constructor(h){super(),Ns(this,h,Ks,Ps,Hs,{})}}export{ol as component};
