import{s as pr,o as ir,n as za}from"../chunks/scheduler.9991993c.js";import{S as rr,i as cr,g as p,s as n,r as c,A as dr,h as i,f as l,c as a,j as Pl,u as d,x as r,k as Sl,l as Mr,y as h,a as s,v as M,d as o,t as T,w as f}from"../chunks/index.7fc9a5e7.js";import{T as Da}from"../chunks/Tip.9de92fc6.js";import{C as u}from"../chunks/CodeBlock.e11cba92.js";import{H as _}from"../chunks/Heading.e3de321f.js";function or(v){let m,I='如果你想要使用自回归技术在文本数据集上微调像 Llama-2 或 Mistral 这样的语言模型，考虑使用 <a href="https://github.com/huggingface/trl" rel="nofollow"><code>trl</code></a> 的 <code>SFTTrainer</code>。<code>SFTTrainer</code> 封装了 <code>Trainer</code>，专门针对这个特定任务进行了优化，并支持序列打包、LoRA、量化和 DeepSpeed，以有效扩展到任何模型大小。另一方面，<code>Trainer</code> 是一个更通用的选项，适用于更广泛的任务。';return{c(){m=p("p"),m.innerHTML=I},l(w){m=i(w,"P",{"data-svelte-h":!0}),r(m)!=="svelte-q8eswt"&&(m.innerHTML=I)},m(w,y){s(w,m,y)},p:za,d(w){w&&l(m)}}}function Tr(v){let m,I="<code>Trainer</code> 类被优化用于 🤗 Transformers 模型，并在你在其他模型上使用时可能会有一些令人惊讶的结果。当在你自己的模型上使用时，请确保：",w,y,$='<li>你的模型始终返回元组或 <a href="/docs/transformers/v4.37.2/zh/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> 的子类。</li> <li>如果提供了 <code>labels</code> 参数，你的模型可以计算损失，并且损失作为元组的第一个元素返回（如果你的模型返回元组）。</li> <li>你的模型可以接受多个标签参数（在 <code>TrainingArguments</code> 中使用 <code>label_names</code> 将它们的名称指示给 <code>Trainer</code>），但它们中没有一个应该被命名为 <code>&quot;label&quot;</code>。</li>';return{c(){m=p("p"),m.innerHTML=I,w=n(),y=p("ul"),y.innerHTML=$},l(b){m=i(b,"P",{"data-svelte-h":!0}),r(m)!=="svelte-yyvq3m"&&(m.innerHTML=I),w=a(b),y=i(b,"UL",{"data-svelte-h":!0}),r(y)!=="svelte-5ac8zk"&&(y.innerHTML=$)},m(b,U){s(b,m,U),s(b,w,U),s(b,y,U)},p:za,d(b){b&&(l(m),l(w),l(y))}}}function fr(v){let m,I='我们强烈建议在你的 MacOS 机器上安装 PyTorch &gt;= 1.13（在撰写本文时为最新版本）。对于基于 transformer 的模型， 它提供与模型正确性和性能改进相关的重大修复。有关更多详细信息，请参阅<a href="https://github.com/pytorch/pytorch/issues/82707" rel="nofollow">pytorch/pytorch#82707</a>。';return{c(){m=p("p"),m.innerHTML=I},l(w){m=i(w,"P",{"data-svelte-h":!0}),r(m)!=="svelte-1iyja8u"&&(m.innerHTML=I)},m(w,y){s(w,m,y)},p:za,d(w){w&&l(m)}}}function mr(v){let m,I,w,y,$,b,U,Qa='<code>Trainer</code> 类提供了一个 PyTorch 的 API，用于处理大多数标准用例的全功能训练。它在大多数<a href="https://github.com/huggingface/transformers/tree/main/examples" rel="nofollow">示例脚本</a>中被使用。',El,g,Xl,V,qa="在实例化你的 <code>Trainer</code> 之前，创建一个 <code>TrainingArguments</code>，以便在训练期间访问所有定制点。",Rl,P,Oa='这个 API 支持在多个 GPU/TPU 上进行分布式训练，支持 <a href="https://github.com/NVIDIA/apex" rel="nofollow">NVIDIA Apex</a> 的混合精度和 PyTorch 的原生 AMP。',Nl,S,Ka="<code>Trainer</code> 包含基本的训练循环，支持上述功能。如果需要自定义训练，你可以继承 <code>Trainer</code> 并覆盖以下方法：",kl,E,ep="<li><strong>get_train_dataloader</strong> — 创建训练 DataLoader。</li> <li><strong>get_eval_dataloader</strong> — 创建评估 DataLoader。</li> <li><strong>get_test_dataloader</strong> — 创建测试 DataLoader。</li> <li><strong>log</strong> — 记录观察训练的各种对象的信息。</li> <li><strong>create_optimizer_and_scheduler</strong> — 如果它们没有在初始化时传递，请设置优化器和学习率调度器。请注意，你还可以单独继承或覆盖 <code>create_optimizer</code> 和 <code>create_scheduler</code> 方法。</li> <li><strong>create_optimizer</strong> — 如果在初始化时没有传递，则设置优化器。</li> <li><strong>create_scheduler</strong> — 如果在初始化时没有传递，则设置学习率调度器。</li> <li><strong>compute_loss</strong> - 计算单批训练输入的损失。</li> <li><strong>training_step</strong> — 执行一步训练。</li> <li><strong>prediction_step</strong> — 执行一步评估/测试。</li> <li><strong>evaluate</strong> — 运行评估循环并返回指标。</li> <li><strong>predict</strong> — 返回在测试集上的预测（如果有标签，则包括指标）。</li>",Gl,x,Fl,X,tp="以下是如何自定义 <code>Trainer</code> 以使用加权损失的示例（在训练集不平衡时很有用）：",Wl,R,Yl,N,lp='在 PyTorch <code>Trainer</code> 中自定义训练循环行为的另一种方法是使用 <a href="callback">callbacks</a>，这些回调可以检查训练循环状态（用于进度报告、在 TensorBoard 或其他 ML 平台上记录日志等）并做出决策（比如提前停止）。',Dl,k,zl,G,sp="[[autodoc]] Trainer - all",Ql,F,ql,W,np="[[autodoc]] Seq2SeqTrainer - evaluate - predict",Ol,Y,Kl,D,ap="[[autodoc]] TrainingArguments - all",es,z,ts,Q,pp="[[autodoc]] Seq2SeqTrainingArguments - all",ls,q,ss,O,ip="默认情况下，<code>Trainer</code> 会将所有checkpoints保存在你使用的 <code>TrainingArguments</code> 中设置的 <code>output_dir</code> 中。这些checkpoints将位于名为 <code>checkpoint-xxx</code> 的子文件夹中，xxx 是训练的步骤。",ns,K,rp="从checkpoints恢复训练可以通过调用 <code>Trainer.train()</code> 时使用以下任一方式进行：",as,ee,cp="<li><code>resume_from_checkpoint=True</code>，这将从最新的checkpoint恢复训练。</li> <li><code>resume_from_checkpoint=checkpoint_dir</code>，这将从指定目录中的特定checkpoint恢复训练。</li>",ps,te,dp="此外，当使用 <code>push_to_hub=True</code> 时，你可以轻松将checkpoints保存在 Model Hub 中。默认情况下，保存在训练中间过程的checkpoints中的所有模型都保存在不同的提交中，但不包括优化器状态。你可以根据需要调整 <code>TrainingArguments</code> 的 <code>hub-strategy</code> 值：",is,le,Mp="<li><code>&quot;checkpoint&quot;</code>: 最新的checkpoint也被推送到一个名为 last-checkpoint 的子文件夹中，让你可以通过 <code>trainer.train(resume_from_checkpoint=&quot;output_dir/last-checkpoint&quot;)</code> 轻松恢复训练。</li> <li><code>&quot;all_checkpoints&quot;</code>: 所有checkpoints都像它们出现在输出文件夹中一样被推送（因此你将在最终存储库中的每个文件夹中获得一个checkpoint文件夹）。</li>",rs,se,cs,ne,op="默认情况下，<code>Trainer</code> 将对主进程使用 <code>logging.INFO</code>，对副本（如果有的话）使用 <code>logging.WARNING</code>。",ds,ae,Tp="可以通过 <code>TrainingArguments</code> 的参数覆盖这些默认设置，使用其中的 5 个 <code>logging</code> 级别：",Ms,pe,fp="<li><code>log_level</code> - 用于主进程</li> <li><code>log_level_replica</code> - 用于副本</li>",os,ie,mp="此外，如果 <code>TrainingArguments</code> 的 <code>log_on_each_node</code> 设置为 <code>False</code>，则只有主节点将使用其主进程的日志级别设置，所有其他节点将使用副本的日志级别设置。",Ts,re,up="请注意，<code>Trainer</code> 将在其 <code>Trainer.__init__()</code> 中分别为每个节点设置 <code>transformers</code> 的日志级别。因此，如果在创建 <code>Trainer</code> 对象之前要调用其他 <code>transformers</code> 功能，可能需要更早地设置这一点（请参见下面的示例）。",fs,ce,wp="以下是如何在应用程序中使用的示例：",ms,de,us,Me,Jp="然后，如果你只想在主节点上看到警告，并且所有其他节点不打印任何可能重复的警告，可以这样运行：",ws,oe,Js,Te,jp="在多节点环境中，如果你也不希望每个节点的主进程的日志重复输出，你需要将上面的代码更改为：",js,fe,hs,me,hp="然后，只有第一个节点的主进程将以 “warning” 级别记录日志，主节点上的所有其他进程和其他节点上的所有进程将以 “error” 级别记录日志。",_s,ue,_p="如果你希望应用程序尽可能”安静“，可以执行以下操作：",ys,we,bs,Je,yp="(如果在多节点环境，添加 <code>--log_on_each_node 0</code>)",Is,je,Us,he,bp="当从 <code>Trainer</code> 生成的checkpoint恢复训练时，程序会尽一切努力将 <em>python</em>、<em>numpy</em> 和 <em>pytorch</em> 的 RNG（随机数生成器）状态恢复为保存检查点时的状态，这样可以使“停止和恢复”式训练尽可能接近“非停止式”训练。",$s,_e,Ip='然而，由于各种默认的非确定性 PyTorch 设置，这可能无法完全实现。如果你想要完全确定性，请参阅<a href="https://pytorch.org/docs/stable/notes/randomness" rel="nofollow">控制随机源</a>。正如文档中所解释的那样，使事物变得确定的一些设置（例如 <code>torch.backends.cudnn.deterministic</code>）可能会减慢速度，因此不能默认执行，但如果需要，你可以自行启用这些设置。',Cs,ye,As,be,Up="让我们讨论一下如何告诉你的程序应该使用哪些 GPU 以及使用的顺序。",vs,Ie,$p='当使用 <a href="https://pytorch.org/docs/stable/generated/torch.nn.parallel.DistributedDataParallel.html" rel="nofollow"><code>DistributedDataParallel</code></a> 且仅使用部分 GPU 时，你只需指定要使用的 GPU 数量。例如，如果你有 4 个 GPU，但只想使用前 2 个，可以执行以下操作：',gs,Ue,xs,$e,Cp='如果你安装了 <a href="https://github.com/huggingface/accelerate" rel="nofollow"><code>accelerate</code></a> 或 <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow"><code>deepspeed</code></a>，你还可以通过以下任一方法实现相同的效果：',Ls,Ce,Zs,Ae,Bs,ve,Ap='你不需要使用 Accelerate 或 <a href="Deepspeed">Deepspeed 集成</a> 功能来使用这些启动器。',Hs,ge,vp="到目前为止，你已经能够告诉程序要使用多少个 GPU。现在让我们讨论如何选择特定的 GPU 并控制它们的顺序。",Vs,xe,gp="以下环境变量可帮助你控制使用哪些 GPU 以及它们的顺序。",Ps,Le,xp="<strong><code>CUDA_VISIBLE_DEVICES</code></strong>",Ss,Ze,Lp="如果你有多个 GPU，想要仅使用其中的一个或几个 GPU，请将环境变量 <code>CUDA_VISIBLE_DEVICES</code> 设置为要使用的 GPU 列表。",Es,Be,Zp="例如，假设你有 4 个 GPU：0、1、2 和 3。要仅在物理 GPU 0 和 2 上运行，你可以执行以下操作：",Xs,He,Rs,Ve,Bp="现在，PyTorch 将只看到 2 个 GPU，其中你的物理 GPU 0 和 2 分别映射到 <code>cuda:0</code> 和 <code>cuda:1</code>。",Ns,Pe,Hp="你甚至可以改变它们的顺序：",ks,Se,Gs,Ee,Vp="这里，你的物理 GPU 0 和 2 分别映射到 <code>cuda:1</code> 和 <code>cuda:0</code>。",Fs,Xe,Pp='上面的例子都是针对 <code>DistributedDataParallel</code> 使用模式的，但同样的方法也适用于 <a href="https://pytorch.org/docs/stable/generated/torch.nn.DataParallel.html" rel="nofollow"><code>DataParallel</code></a>：',Ws,Re,Ys,Ne,Sp="为了模拟没有 GPU 的环境，只需将此环境变量设置为空值，如下所示：",Ds,ke,zs,Ge,Ep="与任何环境变量一样，你当然可以将其export到环境变量而不是将其添加到命令行，如下所示：",Qs,Fe,qs,We,Xp="这种方法可能会令人困惑，因为你可能会忘记之前设置了环境变量，进而不明白为什么会使用错误的 GPU。因此，在同一命令行中仅为特定运行设置环境变量是一种常见做法，正如本节大多数示例所示。",Os,Ye,Rp="<strong><code>CUDA_DEVICE_ORDER</code></strong>",Ks,De,Np="还有一个额外的环境变量 <code>CUDA_DEVICE_ORDER</code>，用于控制物理设备的排序方式。有两个选择：",en,ze,kp="<li>按 PCIe 总线 ID 排序（与 nvidia-smi 的顺序相匹配）- 这是默认选项。</li>",tn,Qe,ln,L,Gp="<li>按 GPU 计算能力排序。</li>",sn,qe,nn,Oe,Fp="大多数情况下，你不需要关心这个环境变量，但如果你的设置不均匀，那么这将非常有用，例如，您的旧 GPU 和新 GPU 物理上安装在一起，但让速度较慢的旧卡排在运行的第一位。解决这个问题的一种方法是交换卡的位置。但如果不能交换卡（例如，如果设备的散热受到影响），那么设置 <code>CUDA_DEVICE_ORDER=FASTEST_FIRST</code> 将始终将较新、更快的卡放在第一位。但这可能会有点混乱，因为 <code>nvidia-smi</code> 仍然会按照 PCIe 顺序报告它们。",an,Ke,Wp="交换卡的顺序的另一种方法是使用：",pn,et,rn,tt,Yp="在此示例中，我们只使用了 2 个 GPU，但是当然，对于计算机上有的任何数量的 GPU，都适用相同的方法。",cn,lt,Dp="此外，如果你设置了这个环境变量，最好将其设置在 <code>~/.bashrc</code> 文件或其他启动配置文件中，然后就可以忘记它了。",dn,st,Mn,nt,zp="<code>Trainer</code> 已经被扩展，以支持可能显著提高训练时间并适应更大模型的库。",on,at,Qp='目前，它支持第三方解决方案 <a href="https://github.com/microsoft/DeepSpeed" rel="nofollow">DeepSpeed</a> 和 <a href="https://pytorch.org/docs/stable/fsdp.html" rel="nofollow">PyTorch FSDP</a>，它们实现了论文 <a href="https://arxiv.org/abs/1910.02054" rel="nofollow">ZeRO: Memory Optimizations Toward Training Trillion Parameter Models, by Samyam Rajbhandari, Jeff Rasley, Olatunji Ruwase, Yuxiong He</a> 的部分内容。',Tn,pt,qp='截至撰写本文，此提供的支持是新的且实验性的。尽管我们欢迎围绕 DeepSpeed 和 PyTorch FSDP 的issues，但我们不再支持 FairScale 集成，因为它已经集成到了 PyTorch 主线（参见 <a href="#pytorch-fully-sharded-data-parallel">PyTorch FSDP 集成</a>）。',fn,Al,mn,it,un,rt,Op="撰写时，Deepspeed 需要在使用之前编译 CUDA C++ 代码。",wn,ct,Kp='虽然所有安装问题都应通过 <a href="https://github.com/microsoft/DeepSpeed/issues" rel="nofollow">Deepspeed</a> 的 GitHub Issues处理，但在构建依赖CUDA 扩展的任何 PyTorch 扩展时，可能会遇到一些常见问题。',Jn,dt,ei="因此，如果在执行以下操作时遇到与 CUDA 相关的构建问题：",jn,Mt,hn,ot,ti="请首先阅读以下说明。",_n,Tt,li="在这些说明中，我们提供了在 <code>pytorch</code> 使用 CUDA <code>10.2</code> 构建时应采取的操作示例。如果你的情况有所不同，请记得将版本号调整为您所需的版本。",yn,ft,bn,mt,si="尽管 PyTorch 自带了其自己的 CUDA 工具包，但要构建这两个项目，你必须在整个系统上安装相同版本的 CUDA。",In,ut,ni="例如，如果你在 Python 环境中使用 <code>cudatoolkit==10.2</code> 安装了 <code>pytorch</code>，你还需要在整个系统上安装 CUDA <code>10.2</code>。",Un,wt,ai="确切的位置可能因系统而异，但在许多 Unix 系统上，<code>/usr/local/cuda-10.2</code> 是最常见的位置。当 CUDA 正确设置并添加到 <code>PATH</code> 环境变量时，可以通过执行以下命令找到安装位置：",$n,Jt,Cn,jt,pi='如果你尚未在整个系统上安装 CUDA，请首先安装。你可以使用你喜欢的搜索引擎查找说明。例如，如果你使用的是 Ubuntu，你可能想搜索：<a href="https://www.google.com/search?q=ubuntu+cuda+10.2+install" rel="nofollow">ubuntu cuda 10.2 install</a>。',An,ht,vn,_t,ii="另一个可能的常见问题是你可能在整个系统上安装了多个 CUDA 工具包。例如，你可能有：",gn,yt,xn,bt,ri="在这种情况下，你需要确保 <code>PATH</code> 和 <code>LD_LIBRARY_PATH</code> 环境变量包含所需 CUDA 版本的正确路径。通常，软件包安装程序将设置这些变量以包含最新安装的版本。如果遇到构建失败的问题，且是因为在整个系统安装但软件仍找不到正确的 CUDA 版本，这意味着你需要调整这两个环境变量。",Ln,It,ci="首先，你以查看它们的内容：",Zn,Ut,Bn,$t,di="因此，您可以了解其中的内容。",Hn,Ct,Mi="<code>LD_LIBRARY_PATH</code> 可能是空的。",Vn,At,oi="<code>PATH</code> 列出了可以找到可执行文件的位置，而 <code>LD_LIBRARY_PATH</code> 用于查找共享库。在这两种情况下，较早的条目优先于较后的条目。 <code>:</code> 用于分隔多个条目。",Pn,vt,Ti="现在，为了告诉构建程序在哪里找到特定的 CUDA 工具包，请插入所需的路径，让其首先列出：",Sn,gt,En,xt,fi="请注意，我们没有覆盖现有值，而是在前面添加新的值。",Xn,Lt,mi="当然，根据需要调整版本号和完整路径。检查你分配的目录是否实际存在。<code>lib64</code> 子目录是各种 CUDA <code>.so</code> 对象（如 <code>libcudart.so</code>）的位置，这个名字可能在你的系统中是不同的，如果是，请调整以反映实际情况。",Rn,Zt,Nn,Bt,ui="一些较旧的 CUDA 版本可能会拒绝使用更新的编译器。例如，你可能有 <code>gcc-9</code>，但 CUDA 可能需要 <code>gcc-7</code>。",kn,Ht,wi="有各种方法可以解决这个问题。",Gn,Vt,Ji="如果你可以安装最新的 CUDA 工具包，通常它应该支持更新的编译器。",Fn,Pt,ji="或者，你可以在已经拥有的编译器版本之外安装较低版本，或者你可能已经安装了它但它不是默认的编译器，因此构建系统无法找到它。如果你已经安装了 <code>gcc-7</code> 但构建系统找不到它，以下操作可能会解决问题：",Wn,St,Yn,Et,hi="这里，我们正在从 <code>/usr/local/cuda-10.2/bin/gcc</code> 创建到 <code>gcc-7</code> 的软链接，由于 <code>/usr/local/cuda-10.2/bin/</code> 应该在 <code>PATH</code> 环境变量中（参见前一个问题的解决方案），它应该能够找到 <code>gcc-7</code>（和 <code>g++7</code>），然后构建将成功。",Dn,Xt,_i="与往常一样，请确保编辑示例中的路径以匹配你的情况。",zn,Rt,Qn,Nt,yi='为了加速在更大批次大小上训练庞大模型，我们可以使用完全分片的数据并行模型。这种数据并行范例通过对优化器状态、梯度和参数进行分片，实现了在更多数据和更大模型上的训练。要了解更多信息以及其优势，请查看<a href="https://pytorch.org/blog/introducing-pytorch-fully-sharded-data-parallel-api/" rel="nofollow">完全分片的数据并行博客</a>。我们已经集成了最新的PyTorch完全分片的数据并行（FSDP）训练功能。您只需通过配置启用它。',qn,kt,bi="<strong>FSDP支持所需的PyTorch版本</strong>: PyTorch Nightly（或者如果你在发布后阅读这个，使用1.12.0版本，因为带有激活的FSDP的模型保存仅在最近的修复中可用。",On,Gt,Ii="<strong>用法</strong>:",Kn,Ft,Ui=`<li><p>如果你尚未使用过分布式启动器，确保你已经添加了它 <code>-m torch.distributed.launch --nproc_per_node=NUMBER_OF_GPUS_YOU_HAVE</code>。</p></li> <li><p><strong>分片策略</strong>：</p> <ul><li>FULL_SHARD：在数据并行线程/GPU之间，对优化器状态、梯度和模型参数进行分片。
为此，请在命令行参数中添加 <code>--fsdp full_shard</code>。</li> <li>SHARD_GRAD_OP：在数据并行线程/GPU之间对优化器状态和梯度进行分片。
为此，请在命令行参数中添加 <code>--fsdp shard_grad_op</code>。</li> <li>NO_SHARD：不进行分片。为此，请在命令行参数中添加 <code>--fsdp no_shard</code>。</li></ul></li> <li><p>要将参数和梯度卸载到CPU，添加 <code>--fsdp &quot;full_shard offload&quot;</code> 或 <code>--fsdp &quot;shard_grad_op offload&quot;</code> 到命令行参数中。</p></li> <li><p>要使用 <code>default_auto_wrap_policy</code> 自动递归地用FSDP包装层，请添加 <code>--fsdp &quot;full_shard auto_wrap&quot;</code> 或 <code>--fsdp &quot;shard_grad_op auto_wrap&quot;</code> 到命令行参数中。</p></li> <li><p>要同时启用CPU卸载和自动包装层工具，请添加 <code>--fsdp &quot;full_shard offload auto_wrap&quot;</code> 或 <code>--fsdp &quot;shard_grad_op offload auto_wrap&quot;</code> 到命令行参数中。</p></li> <li><p>其余的FSDP配置通过 <code>--fsdp_config &lt;path_to_fsdp_config.json&gt;</code> 传递。它可以是FSDP json配置文件的位置（例如，<code>fsdp_config.json</code>）或已加载的json文件作为 <code>dict</code>。</p> <ul><li>如果启用了自动包装，您可以使用基于transformer的自动包装策略或基于大小的自动包装策略。<ul><li>对于基于transformer的自动包装策略，建议在配置文件中指定 <code>fsdp_transformer_layer_cls_to_wrap</code>。如果未指定，则默认值为 <code>model._no_split_modules</code>（如果可用）。这将指定要包装的transformer层类名（区分大小写），例如 <code>BertLayer</code>、<code>GPTJBlock</code>、<code>T5Block</code> 等。这很重要，因为共享权重的子模块（例如，embedding层）不应最终出现在不同的FSDP包装单元中。使用此策略，每个包装的块将包含多头注意力和后面的几个MLP层。剩余的层，包括共享的embedding层，都将被方便地包装在同一个最外层的FSDP单元中。因此，对于基于transformer的模型，请使用这个方法。</li> <li>对于基于大小的自动包装策略，请在配置文件中添加 <code>fsdp_min_num_params</code>。它指定了FSDP进行自动包装的最小参数数量。</li></ul></li> <li>可以在配置文件中指定 <code>fsdp_backward_prefetch</code>。它控制何时预取下一组参数。<code>backward_pre</code> 和 <code>backward_pos</code> 是可用的选项。有关更多信息，请参阅 <code>torch.distributed.fsdp.fully_sharded_data_parallel.BackwardPrefetch</code></li> <li>可以在配置文件中指定 <code>fsdp_forward_prefetch</code>。它控制何时预取下一组参数。如果是<code>&quot;True&quot;</code>，在执行前向传递时，FSDP明确地预取下一次即将发生的全局聚集。</li> <li>可以在配置文件中指定 <code>limit_all_gathers</code>。如果是<code>&quot;True&quot;</code>，FSDP明确地同步CPU线程，以防止太多的进行中的全局聚集。</li> <li>可以在配置文件中指定 <code>activation_checkpointing</code>。如果是<code>&quot;True&quot;</code>，FSDP activation checkpoint是一种通过清除某些层的激活值并在反向传递期间重新计算它们来减少内存使用的技术。实际上，这以更多的计算时间为代价减少了内存使用。</li></ul></li>`,ea,Wt,$i="<strong>需要注意几个注意事项</strong>",ta,Yt,Ci='<li>它与 <code>generate</code> 不兼容，因此与所有seq2seq/clm脚本（翻译/摘要/clm等）中的 <code>--predict_with_generate</code> 不兼容。请参阅issue<a href="https://github.com/huggingface/transformers/issues/21667" rel="nofollow">#21667</a>。</li>',la,Dt,sa,zt,Ai='对于所有TPU用户，有个好消息！PyTorch/XLA现在支持FSDP。所有最新的完全分片数据并行（FSDP）训练都受支持。有关更多信息，请参阅<a href="https://pytorch.org/blog/scaling-pytorch-models-on-cloud-tpus-with-fsdp/" rel="nofollow">在云端TPU上使用FSDP扩展PyTorch模型</a>和<a href="https://github.com/pytorch/xla/tree/master/torch_xla/distributed/fsdp" rel="nofollow">PyTorch/XLA FSDP的实现</a>。使用它只需通过配置启用。',na,Qt,vi="<strong>需要的 PyTorch/XLA 版本以支持 FSDP</strong>：&gt;=2.0",aa,qt,gi="<strong>用法</strong>：",pa,Ot,xi="传递 <code>--fsdp &quot;full shard&quot;</code>，同时对 <code>--fsdp_config &lt;path_to_fsdp_config.json&gt;</code> 进行以下更改：",ia,Kt,Li='<li><code>xla</code> 应设置为 <code>True</code> 以启用 PyTorch/XLA FSDP。</li> <li><code>xla_fsdp_settings</code> 的值是一个字典，存储 XLA FSDP 封装参数。完整的选项列表，请参见<a href="https://github.com/pytorch/xla/blob/master/torch_xla/distributed/fsdp/xla_fully_sharded_data_parallel.py" rel="nofollow">此处</a>。</li> <li><code>xla_fsdp_grad_ckpt</code>。当 <code>True</code> 时，在每个嵌套的 XLA FSDP 封装层上使用梯度checkpoint。该设置只能在将 xla 标志设置为 true，并通过 <code>fsdp_min_num_params</code> 或 <code>fsdp_transformer_layer_cls_to_wrap</code> 指定自动包装策略时使用。</li> <li>您可以使用基于transformer的自动包装策略或基于大小的自动包装策略。<ul><li>对于基于transformer的自动包装策略，建议在配置文件中指定 <code>fsdp_transformer_layer_cls_to_wrap</code>。如果未指定，默认值为 <code>model._no_split_modules</code>（如果可用）。这指定了要包装的transformer层类名列表（区分大小写），例如 <code>BertLayer</code>、<code>GPTJBlock</code>、<code>T5Block</code> 等。这很重要，因为共享权重的子模块（例如，embedding层）不应最终出现在不同的FSDP包装单元中。使用此策略，每个包装的块将包含多头注意力和后面的几个MLP层。剩余的层，包括共享的embedding层，都将被方便地包装在同一个最外层的FSDP单元中。因此，对于基于transformer的模型，请使用这个方法。</li> <li>对于基于大小的自动包装策略，请在配置文件中添加 <code>fsdp_min_num_params</code>。它指定了自动包装的 FSDP 的最小参数数量。</li></ul></li>',ra,el,ca,tl,Zi=`随着 PyTorch v1.12 版本的发布，开发人员和研究人员可以利用 Apple Silicon GPU 进行显著更快的模型训练。这使得可以在 Mac 上本地执行原型设计和微调等机器学习工作流程。Apple 的 Metal Performance Shaders（MPS）作为 PyTorch 的后端实现了这一点，并且可以通过新的 <code>&quot;mps&quot;</code> 设备来使用。
这将在 MPS 图形框架上映射计算图和神经图元，并使用 MPS 提供的优化内核。更多信息，请参阅官方文档 <a href="https://pytorch.org/blog/introducing-accelerated-pytorch-training-on-mac/" rel="nofollow">Introducing Accelerated PyTorch Training on Mac</a> 和 <a href="https://pytorch.org/docs/stable/notes/mps.html" rel="nofollow">MPS BACKEND</a>。`,da,Z,Ma,ll,Bi="<strong>使用 Apple Silicon 芯片进行训练和推理的好处</strong>",oa,sl,Hi="<li>使用户能够在本地训练更大的网络或批量数据。</li> <li>由于统一内存架构，减少数据检索延迟，并为 GPU 提供对完整内存存储的直接访问。从而提高端到端性能。</li> <li>降低与基于云的开发或需要额外本地 GPU 的成本。</li>",Ta,nl,Vi='<strong>先决条件</strong>：要安装带有 mps 支持的 torch，请按照这篇精彩的 Medium 文章操作 <a href="https://medium.com/towards-data-science/gpu-acceleration-comes-to-pytorch-on-m1-macs-195c399efcc1" rel="nofollow">GPU-Acceleration Comes to PyTorch on M1 Macs</a>。',fa,al,Pi=`<strong>用法</strong>：
如果可用，<code>mps</code> 设备将默认使用，类似于使用 <code>cuda</code> 设备的方式。因此，用户无需采取任何操作。例如，您可以使用以下命令在 Apple Silicon GPU 上运行官方的 Glue 文本分类任务（从根文件夹运行）：`,ma,pl,ua,il,Si="<strong>需要注意的一些注意事项</strong>",wa,rl,Ei="<li>一些 PyTorch 操作尚未在 mps 中实现，将引发错误。解决此问题的一种方法是设置环境变量 <code>PYTORCH_ENABLE_MPS_FALLBACK=1</code>，它将把这些操作回退到 CPU 进行。然而，它仍然会抛出 UserWarning 信息。</li> <li>分布式设置 <code>gloo</code> 和 <code>nccl</code> 在 <code>mps</code> 设备上不起作用。这意味着当前只能使用 <code>mps</code> 设备类型的单个 GPU。</li>",Ja,cl,Xi='最后，请记住，🤗 <code>Trainer</code> 仅集成了 MPS 后端，因此如果你在使用 MPS 后端时遇到任何问题或有疑问，请在 <a href="https://github.com/pytorch/pytorch/issues" rel="nofollow">PyTorch GitHub</a> 上提交问题。',ja,dl,ha,Ml,Ri="Accelerate 现在支持 Trainer。用户可以期待以下内容：",_a,ol,Ni="<li>他们可以继续使用 Trainer 的迭代，如 FSDP、DeepSpeed 等，而无需做任何更改。</li> <li>现在可以在 Trainer 中使用 Accelerate Launcher（建议使用）。</li>",ya,Tl,ki="通过 Accelerate Launcher 使用 Trainer 的步骤：",ba,C,vl,Gi="<p>确保已安装 🤗 Accelerate，无论如何，如果没有它，你无法使用 <code>Trainer</code>。如果没有，请执行 <code>pip install accelerate</code>。你可能还需要更新 Accelerate 的版本：<code>pip install accelerate --upgrade</code>。</p>",Sa,J,gl,Fi="运行 <code>accelerate config</code> 并填写问题。以下是一些加速配置的示例：",Ea,xl,Wi="a. DDP 多节点多 GPU 配置：",Xa,fl,Ra,Ll,Yi="b. FSDP 配置：",Na,ml,ka,Zl,Di="c. 指向文件的 DeepSpeed 配置：",Ga,ul,Fa,Bl,zi="d. 使用 accelerate 插件的 DeepSpeed 配置：",Wa,wl,Ya,Hl,Qi="<p>使用accelerate配置文件参数或启动器参数以外的参数运行Trainer脚本。以下是一个使用上述FSDP配置从accelerate启动器运行<code>run_glue.py</code>的示例。</p>",Ia,Jl,Ua,B,qi="<li>你也可以直接使用<code>accelerate launch</code>的cmd参数。上面的示例将映射到：</li>",$a,jl,Ca,hl,Oi='有关更多信息，请参阅 🤗 Accelerate CLI 指南：<a href="https://huggingface.co/docs/accelerate/basic_tutorials/launch" rel="nofollow">启动您的 🤗 Accelerate 脚本</a>。',Aa,_l,Ki="已移动的部分：",va,yl,er='[ <a href="./deepspeed#deepspeed-trainer-integration">DeepSpeed</a><a id="deepspeed"></a> | <a href="./deepspeed#deepspeed-installation">Installation</a><a id="installation"></a> | <a href="./deepspeed#deepspeed-multi-gpu">Deployment with multiple GPUs</a><a id="deployment-with-multiple-gpus"></a> | <a href="./deepspeed#deepspeed-one-gpu">Deployment with one GPU</a><a id="deployment-with-one-gpu"></a> | <a href="./deepspeed#deepspeed-notebook">Deployment in Notebooks</a><a id="deployment-in-notebooks"></a> | <a href="./deepspeed#deepspeed-config">Configuration</a><a id="configuration"></a> | <a href="./deepspeed#deepspeed-config-passing">Passing Configuration</a><a id="passing-configuration"></a> | <a href="./deepspeed#deepspeed-config-shared">Shared Configuration</a><a id="shared-configuration"></a> | <a href="./deepspeed#deepspeed-zero">ZeRO</a><a id="zero"></a> | <a href="./deepspeed#deepspeed-zero2-config">ZeRO-2 Config</a><a id="zero-2-config"></a> | <a href="./deepspeed#deepspeed-zero3-config">ZeRO-3 Config</a><a id="zero-3-config"></a> | <a href="./deepspeed#deepspeed-nvme">NVMe Support</a><a id="nvme-support"></a> | <a href="./deepspeed#deepspeed-zero2-zero3-performance">ZeRO-2 vs ZeRO-3 Performance</a><a id="zero-2-vs-zero-3-performance"></a> | <a href="./deepspeed#deepspeed-zero2-example">ZeRO-2 Example</a><a id="zero-2-example"></a> | <a href="./deepspeed#deepspeed-zero3-example">ZeRO-3 Example</a><a id="zero-3-example"></a> | <a href="./deepspeed#deepspeed-optimizer">Optimizer</a><a id="optimizer"></a> | <a href="./deepspeed#deepspeed-scheduler">Scheduler</a><a id="scheduler"></a> | <a href="./deepspeed#deepspeed-fp32">fp32 Precision</a><a id="fp32-precision"></a> | <a href="./deepspeed#deepspeed-amp">Automatic Mixed Precision</a><a id="automatic-mixed-precision"></a> | <a href="./deepspeed#deepspeed-bs">Batch Size</a><a id="batch-size"></a> | <a href="./deepspeed#deepspeed-grad-acc">Gradient Accumulation</a><a id="gradient-accumulation"></a> | <a href="./deepspeed#deepspeed-grad-clip">Gradient Clipping</a><a id="gradient-clipping"></a> | <a href="./deepspeed#deepspeed-weight-extraction">Getting The Model Weights Out</a><a id="getting-the-model-weights-out"></a>]',ga,bl,xa,Il,tr="NEFTune 是一种提升聊天模型性能的技术，由 Jain 等人在论文“NEFTune: Noisy Embeddings Improve Instruction Finetuning” 中引入。该技术在训练过程中向embedding向量添加噪音。根据论文摘要：",La,Ul,lr="<p>使用 Alpaca 对 LLaMA-2-7B 进行标准微调，可以在 AlpacaEval 上达到 29.79%，而使用带有噪音embedding的情况下，性能提高至 64.69%。NEFTune 还在modern instruction数据集上大大优于基线。Evol-Instruct 训练的模型表现提高了 10%，ShareGPT 提高了 8%，OpenPlatypus 提高了 8%。即使像 LLaMA-2-Chat 这样通过 RLHF 进一步细化的强大模型，通过 NEFTune 的额外训练也能受益。</p>",Za,H,sr='<img src="https://huggingface.co/datasets/trl-internal-testing/example-images/resolve/main/images/neft-screenshot.png"/>',Ba,$l,nr="要在 <code>Trainer</code> 中使用它，只需在创建 <code>TrainingArguments</code> 实例时传递 <code>neftune_noise_alpha</code>。请注意，为了避免任何意外行为，NEFTune在训练后被禁止，以此恢复原始的embedding层。",Ha,Cl,Va,Vl,Pa;return $=new _({props:{title:"Trainer",local:"trainer",headingTag:"h1"}}),g=new Da({props:{$$slots:{default:[or]},$$scope:{ctx:v}}}),x=new Da({props:{warning:!0,$$slots:{default:[Tr]},$$scope:{ctx:v}}}),R=new u({props:{code:"ZnJvbSUyMHRvcmNoJTIwaW1wb3J0JTIwbm4lMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwVHJhaW5lciUwQSUwQSUwQWNsYXNzJTIwQ3VzdG9tVHJhaW5lcihUcmFpbmVyKSUzQSUwQSUyMCUyMCUyMCUyMGRlZiUyMGNvbXB1dGVfbG9zcyhzZWxmJTJDJTIwbW9kZWwlMkMlMjBpbnB1dHMlMkMlMjByZXR1cm5fb3V0cHV0cyUzREZhbHNlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxhYmVscyUyMCUzRCUyMGlucHV0cy5wb3AoJTIybGFiZWxzJTIyKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGZvcndhcmQlMjBwYXNzJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKCoqaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvZ2l0cyUyMCUzRCUyMG91dHB1dHMuZ2V0KCUyMmxvZ2l0cyUyMiklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBjb21wdXRlJTIwY3VzdG9tJTIwbG9zcyUyMChzdXBwb3NlJTIwb25lJTIwaGFzJTIwMyUyMGxhYmVscyUyMHdpdGglMjBkaWZmZXJlbnQlMjB3ZWlnaHRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3NfZmN0JTIwJTNEJTIwbm4uQ3Jvc3NFbnRyb3B5TG9zcyh3ZWlnaHQlM0R0b3JjaC50ZW5zb3IoJTVCMS4wJTJDJTIwMi4wJTJDJTIwMy4wJTVEJTJDJTIwZGV2aWNlJTNEbW9kZWwuZGV2aWNlKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsb3NzJTIwJTNEJTIwbG9zc19mY3QobG9naXRzLnZpZXcoLTElMkMlMjBzZWxmLm1vZGVsLmNvbmZpZy5udW1fbGFiZWxzKSUyQyUyMGxhYmVscy52aWV3KC0xKSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjAobG9zcyUyQyUyMG91dHB1dHMpJTIwaWYlMjByZXR1cm5fb3V0cHV0cyUyMGVsc2UlMjBsb3Nz",highlighted:`<span class="hljs-keyword">from</span> torch <span class="hljs-keyword">import</span> nn
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer


<span class="hljs-keyword">class</span> <span class="hljs-title class_">CustomTrainer</span>(<span class="hljs-title class_ inherited__">Trainer</span>):
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">compute_loss</span>(<span class="hljs-params">self, model, inputs, return_outputs=<span class="hljs-literal">False</span></span>):
        labels = inputs.pop(<span class="hljs-string">&quot;labels&quot;</span>)
        <span class="hljs-comment"># forward pass</span>
        outputs = model(**inputs)
        logits = outputs.get(<span class="hljs-string">&quot;logits&quot;</span>)
        <span class="hljs-comment"># compute custom loss (suppose one has 3 labels with different weights)</span>
        loss_fct = nn.CrossEntropyLoss(weight=torch.tensor([<span class="hljs-number">1.0</span>, <span class="hljs-number">2.0</span>, <span class="hljs-number">3.0</span>], device=model.device))
        loss = loss_fct(logits.view(-<span class="hljs-number">1</span>, self.model.config.num_labels), labels.view(-<span class="hljs-number">1</span>))
        <span class="hljs-keyword">return</span> (loss, outputs) <span class="hljs-keyword">if</span> return_outputs <span class="hljs-keyword">else</span> loss`,wrap:!1}}),k=new _({props:{title:"Trainer",local:"trainer",headingTag:"h2"}}),F=new _({props:{title:"Seq2SeqTrainer",local:"seq2seqtrainer",headingTag:"h2"}}),Y=new _({props:{title:"TrainingArguments",local:"trainingarguments",headingTag:"h2"}}),z=new _({props:{title:"Seq2SeqTrainingArguments",local:"seq2seqtrainingarguments",headingTag:"h2"}}),q=new _({props:{title:"Checkpoints",local:"checkpoints",headingTag:"h2"}}),se=new _({props:{title:"Logging",local:"logging",headingTag:"h2"}}),de=new u({props:{code:"JTVCLi4uJTVEJTBBbG9nZ2VyJTIwJTNEJTIwbG9nZ2luZy5nZXRMb2dnZXIoX19uYW1lX18pJTBBJTBBJTIzJTIwU2V0dXAlMjBsb2dnaW5nJTBBbG9nZ2luZy5iYXNpY0NvbmZpZyglMEElMjAlMjAlMjAlMjBmb3JtYXQlM0QlMjIlMjUoYXNjdGltZSlzJTIwLSUyMCUyNShsZXZlbG5hbWUpcyUyMC0lMjAlMjUobmFtZSlzJTIwLSUyMCUyNShtZXNzYWdlKXMlMjIlMkMlMEElMjAlMjAlMjAlMjBkYXRlZm10JTNEJTIyJTI1bSUyRiUyNWQlMkYlMjVZJTIwJTI1SCUzQSUyNU0lM0ElMjVTJTIyJTJDJTBBJTIwJTIwJTIwJTIwaGFuZGxlcnMlM0QlNUJsb2dnaW5nLlN0cmVhbUhhbmRsZXIoc3lzLnN0ZG91dCklNUQlMkMlMEEpJTBBJTBBJTIzJTIwc2V0JTIwdGhlJTIwbWFpbiUyMGNvZGUlMjBhbmQlMjB0aGUlMjBtb2R1bGVzJTIwaXQlMjB1c2VzJTIwdG8lMjB0aGUlMjBzYW1lJTIwbG9nLWxldmVsJTIwYWNjb3JkaW5nJTIwdG8lMjB0aGUlMjBub2RlJTBBbG9nX2xldmVsJTIwJTNEJTIwdHJhaW5pbmdfYXJncy5nZXRfcHJvY2Vzc19sb2dfbGV2ZWwoKSUwQWxvZ2dlci5zZXRMZXZlbChsb2dfbGV2ZWwpJTBBZGF0YXNldHMudXRpbHMubG9nZ2luZy5zZXRfdmVyYm9zaXR5KGxvZ19sZXZlbCklMEF0cmFuc2Zvcm1lcnMudXRpbHMubG9nZ2luZy5zZXRfdmVyYm9zaXR5KGxvZ19sZXZlbCklMEElMEF0cmFpbmVyJTIwJTNEJTIwVHJhaW5lciguLi4p",highlighted:`[...]
logger = logging.getLogger(__name__)

<span class="hljs-comment"># Setup logging</span>
logging.basicConfig(
    <span class="hljs-built_in">format</span>=<span class="hljs-string">&quot;%(asctime)s - %(levelname)s - %(name)s - %(message)s&quot;</span>,
    datefmt=<span class="hljs-string">&quot;%m/%d/%Y %H:%M:%S&quot;</span>,
    handlers=[logging.StreamHandler(sys.stdout)],
)

<span class="hljs-comment"># set the main code and the modules it uses to the same log-level according to the node</span>
log_level = training_args.get_process_log_level()
logger.setLevel(log_level)
datasets.utils.logging.set_verbosity(log_level)
transformers.utils.logging.set_verbosity(log_level)

trainer = Trainer(...)`,wrap:!1}}),oe=new u({props:{code:"bXlfYXBwLnB5JTIwLi4uJTIwLS1sb2dfbGV2ZWwlMjB3YXJuaW5nJTIwLS1sb2dfbGV2ZWxfcmVwbGljYSUyMGVycm9y",highlighted:"my_app.py ... --log_level warning --log_level_replica error",wrap:!1}}),fe=new u({props:{code:"bXlfYXBwLnB5JTIwLi4uJTIwLS1sb2dfbGV2ZWwlMjB3YXJuaW5nJTIwLS1sb2dfbGV2ZWxfcmVwbGljYSUyMGVycm9yJTIwLS1sb2dfb25fZWFjaF9ub2RlJTIwMA==",highlighted:"my_app.py ... --log_level warning --log_level_replica error --log_on_each_node 0",wrap:!1}}),we=new u({props:{code:"bXlfYXBwLnB5JTIwLi4uJTIwLS1sb2dfbGV2ZWwlMjBlcnJvciUyMC0tbG9nX2xldmVsX3JlcGxpY2ElMjBlcnJvciUyMC0tbG9nX29uX2VhY2hfbm9kZSUyMDA=",highlighted:"my_app.py ... --log_level error --log_level_replica error --log_on_each_node 0",wrap:!1}}),je=new _({props:{title:"随机性",local:"随机性",headingTag:"h2"}}),ye=new _({props:{title:"特定GPU选择",local:"特定gpu选择",headingTag:"h2"}}),Ue=new u({props:{code:"cHl0aG9uJTIwLW0lMjB0b3JjaC5kaXN0cmlidXRlZC5sYXVuY2glMjAtLW5wcm9jX3Blcl9ub2RlJTNEMiUyMCUyMHRyYWluZXItcHJvZ3JhbS5weSUyMC4uLg==",highlighted:"python -m torch.distributed.launch --nproc_per_node=2  trainer-program.py ...",wrap:!1}}),Ce=new u({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbnVtX3Byb2Nlc3NlcyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"accelerate launch --num_processes 2 trainer-program.py ...",wrap:!1}}),Ae=new u({props:{code:"ZGVlcHNwZWVkJTIwLS1udW1fZ3B1cyUyMDIlMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"deepspeed --num_gpus 2 trainer-program.py ...",wrap:!1}}),He=new u({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMiUyMHB5dGhvbiUyMC1tJTIwdG9yY2guZGlzdHJpYnV0ZWQubGF1bmNoJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=0,2 python -m torch.distributed.launch trainer-program.py ...",wrap:!1}}),Se=new u({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QyJTJDMCUyMHB5dGhvbiUyMC1tJTIwdG9yY2guZGlzdHJpYnV0ZWQubGF1bmNoJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:"CUDA_VISIBLE_DEVICES=2,0 python -m torch.distributed.launch trainer-program.py ...",wrap:!1}}),Re=new u({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QyJTJDMCUyMHB5dGhvbiUyMHRyYWluZXItcHJvZ3JhbS5weSUyMC4uLg==",highlighted:"CUDA_VISIBLE_DEVICES=2,0 python trainer-program.py ...",wrap:!1}}),ke=new u({props:{code:"Q1VEQV9WSVNJQkxFX0RFVklDRVMlM0QlMjBweXRob24lMjB0cmFpbmVyLXByb2dyYW0ucHklMjAuLi4=",highlighted:"CUDA_VISIBLE_DEVICES= python trainer-program.py ...",wrap:!1}}),Fe=new u({props:{code:"ZXhwb3J0JTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QwJTJDMiUwQXB5dGhvbiUyMC1tJTIwdG9yY2guZGlzdHJpYnV0ZWQubGF1bmNoJTIwdHJhaW5lci1wcm9ncmFtLnB5JTIwLi4u",highlighted:`<span class="hljs-built_in">export</span> CUDA_VISIBLE_DEVICES=0,2
python -m torch.distributed.launch trainer-program.py ...`,wrap:!1}}),Qe=new u({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RQQ0lfQlVTX0lE",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=PCI_BUS_ID',wrap:!1}}),qe=new u({props:{code:"ZXhwb3J0JTIwQ1VEQV9ERVZJQ0VfT1JERVIlM0RGQVNURVNUX0ZJUlNU",highlighted:'<span class="hljs-built_in">export</span> CUDA_DEVICE_ORDER=FASTEST_FIRST',wrap:!1}}),et=new u({props:{code:"ZXhwb3J0JTIwQ1VEQV9WSVNJQkxFX0RFVklDRVMlM0QxJTJDMA==",highlighted:'<span class="hljs-built_in">export</span> CUDA_VISIBLE_DEVICES=1,0',wrap:!1}}),st=new _({props:{title:"Trainer集成",local:"trainer集成",headingTag:"h2"}}),it=new _({props:{title:"CUDA拓展安装注意事项",local:"cuda拓展安装注意事项",headingTag:"h3"}}),Mt=new u({props:{code:"cGlwJTIwaW5zdGFsbCUyMGRlZXBzcGVlZA==",highlighted:"pip install deepspeed",wrap:!1}}),ft=new _({props:{title:"可能的问题 #1",local:"可能的问题-1",headingTag:"h4"}}),Jt=new u({props:{code:"d2hpY2glMjBudmNj",highlighted:'<span class="hljs-built_in">which</span> nvcc',wrap:!1}}),ht=new _({props:{title:"可能的问题 #2",local:"可能的问题-2",headingTag:"h4"}}),yt=new u({props:{code:"JTJGdXNyJTJGbG9jYWwlMkZjdWRhLTEwLjIlMEElMkZ1c3IlMkZsb2NhbCUyRmN1ZGEtMTEuMA==",highlighted:`/usr/local/cuda-10.2
/usr/local/cuda-11.0`,wrap:!1}}),Ut=new u({props:{code:"ZWNobyUyMCUyNFBBVEglMEFlY2hvJTIwJTI0TERfTElCUkFSWV9QQVRI",highlighted:`<span class="hljs-built_in">echo</span> <span class="hljs-variable">$PATH</span>
<span class="hljs-built_in">echo</span> <span class="hljs-variable">$LD_LIBRARY_PATH</span>`,wrap:!1}}),gt=new u({props:{code:"ZXhwb3J0JTIwUEFUSCUzRCUyRnVzciUyRmxvY2FsJTJGY3VkYS0xMC4yJTJGYmluJTNBJTI0UEFUSCUwQWV4cG9ydCUyMExEX0xJQlJBUllfUEFUSCUzRCUyRnVzciUyRmxvY2FsJTJGY3VkYS0xMC4yJTJGbGliNjQlM0ElMjRMRF9MSUJSQVJZX1BBVEg=",highlighted:`<span class="hljs-built_in">export</span> PATH=/usr/local/cuda-10.2/bin:<span class="hljs-variable">$PATH</span>
<span class="hljs-built_in">export</span> LD_LIBRARY_PATH=/usr/local/cuda-10.2/lib64:<span class="hljs-variable">$LD_LIBRARY_PATH</span>`,wrap:!1}}),Zt=new _({props:{title:"可能的问题 #3",local:"可能的问题-3",headingTag:"h4"}}),St=new u({props:{code:"c3VkbyUyMGxuJTIwLXMlMjAlMkZ1c3IlMkZiaW4lMkZnY2MtNyUyMCUyMCUyRnVzciUyRmxvY2FsJTJGY3VkYS0xMC4yJTJGYmluJTJGZ2NjJTBBc3VkbyUyMGxuJTIwLXMlMjAlMkZ1c3IlMkZiaW4lMkZnJTJCJTJCLTclMjAlMjAlMkZ1c3IlMkZsb2NhbCUyRmN1ZGEtMTAuMiUyRmJpbiUyRmclMkIlMkI=",highlighted:`sudo <span class="hljs-built_in">ln</span> -s /usr/bin/gcc-7  /usr/local/cuda-10.2/bin/gcc
sudo <span class="hljs-built_in">ln</span> -s /usr/bin/g++-7  /usr/local/cuda-10.2/bin/g++`,wrap:!1}}),Rt=new _({props:{title:"PyTorch完全分片数据并行（FSDP)",local:"pytorch完全分片数据并行fsdp",headingTag:"h3"}}),Dt=new _({props:{title:"PyTorch/XLA 完全分片数据并行",local:"pytorchxla-完全分片数据并行",headingTag:"h3"}}),el=new _({props:{title:"在 Mac 上使用 Trainer 进行加速的 PyTorch 训练",local:"在-mac-上使用-trainer-进行加速的-pytorch-训练",headingTag:"h3"}}),Z=new Da({props:{warning:!1,$$slots:{default:[fr]},$$scope:{ctx:v}}}),pl=new u({props:{code:"ZXhwb3J0JTIwVEFTS19OQU1FJTNEbXJwYyUwQSUwQXB5dGhvbiUyMGV4YW1wbGVzJTJGcHl0b3JjaCUyRnRleHQtY2xhc3NpZmljYXRpb24lMkZydW5fZ2x1ZS5weSUyMCU1QyUwQSUyMCUyMC0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwYmVydC1iYXNlLWNhc2VkJTIwJTVDJTBBJTIwJTIwLS10YXNrX25hbWUlMjAlMjRUQVNLX05BTUUlMjAlNUMlMEElMjAlMjAtLWRvX3RyYWluJTIwJTVDJTBBJTIwJTIwLS1kb19ldmFsJTIwJTVDJTBBJTIwJTIwLS1tYXhfc2VxX2xlbmd0aCUyMDEyOCUyMCU1QyUwQSUyMCUyMC0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMzIlMjAlNUMlMEElMjAlMjAtLWxlYXJuaW5nX3JhdGUlMjAyZS01JTIwJTVDJTBBJTIwJTIwLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQSUyMCUyMC0tb3V0cHV0X2RpciUyMCUyRnRtcCUyRiUyNFRBU0tfTkFNRSUyRiUyMCU1QyUwQSUyMCUyMC0tb3ZlcndyaXRlX291dHB1dF9kaXI=",highlighted:`<span class="hljs-built_in">export</span> TASK_NAME=mrpc

python examples/pytorch/text-classification/run_glue.py \\
  --model_name_or_path bert-base-cased \\
  --task_name <span class="hljs-variable">$TASK_NAME</span> \\
  --do_train \\
  --do_eval \\
  --max_seq_length 128 \\
  --per_device_train_batch_size 32 \\
  --learning_rate 2e-5 \\
  --num_train_epochs 3 \\
  --output_dir /tmp/<span class="hljs-variable">$TASK_NAME</span>/ \\
  --overwrite_output_dir`,wrap:!1}}),dl=new _({props:{title:"通过 Accelerate Launcher 使用 Trainer",local:"通过-accelerate-launcher-使用-trainer",headingTag:"h2"}}),fl=new u({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEFkaXN0cmlidXRlZF90eXBlJTNBJTIwTVVMVElfR1BVJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBZG93bmNhc3RfYmYxNiUzQSUyMCdubyclMEFncHVfaWRzJTNBJTIwYWxsJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUyMCUyM2NoYW5nZSUyMHJhbmslMjBhcyUyMHBlciUyMHRoZSUyMG5vZGUlMEFtYWluX3Byb2Nlc3NfaXAlM0ElMjAxOTIuMTY4LjIwLjElMEFtYWluX3Byb2Nlc3NfcG9ydCUzQSUyMDk4OTglMEFtYWluX3RyYWluaW5nX2Z1bmN0aW9uJTNBJTIwbWFpbiUwQW1peGVkX3ByZWNpc2lvbiUzQSUyMGZwMTYlMEFudW1fbWFjaGluZXMlM0ElMjAyJTBBbnVtX3Byb2Nlc3NlcyUzQSUyMDglMEFyZHp2X2JhY2tlbmQlM0ElMjBzdGF0aWMlMEFzYW1lX25ldHdvcmslM0ElMjB0cnVlJTBBdHB1X2VudiUzQSUyMCU1QiU1RCUwQXRwdV91c2VfY2x1c3RlciUzQSUyMGZhbHNlJTBBdHB1X3VzZV9zdWRvJTNBJTIwZmFsc2UlMEF1c2VfY3B1JTNBJTIwZmFsc2U=",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>                                                                                             
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">MULTI_GPU</span>                                                                                                    
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">gpu_ids:</span> <span class="hljs-string">all</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span> <span class="hljs-comment">#change rank as per the node</span>
<span class="hljs-attr">main_process_ip:</span> <span class="hljs-number">192.168</span><span class="hljs-number">.20</span><span class="hljs-number">.1</span>
<span class="hljs-attr">main_process_port:</span> <span class="hljs-number">9898</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">fp16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">8</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),ml=new u({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkaXN0cmlidXRlZF90eXBlJTNBJTIwRlNEUCUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBZnNkcF9jb25maWclM0ElMEElMjAlMjBmc2RwX2F1dG9fd3JhcF9wb2xpY3klM0ElMjBUUkFOU0ZPUk1FUl9CQVNFRF9XUkFQJTBBJTIwJTIwZnNkcF9iYWNrd2FyZF9wcmVmZXRjaF9wb2xpY3klM0ElMjBCQUNLV0FSRF9QUkUlMEElMjAlMjBmc2RwX2ZvcndhcmRfcHJlZmV0Y2glM0ElMjB0cnVlJTBBJTIwJTIwZnNkcF9vZmZsb2FkX3BhcmFtcyUzQSUyMGZhbHNlJTBBJTIwJTIwZnNkcF9zaGFyZGluZ19zdHJhdGVneSUzQSUyMDElMEElMjAlMjBmc2RwX3N0YXRlX2RpY3RfdHlwZSUzQSUyMEZVTExfU1RBVEVfRElDVCUwQSUyMCUyMGZzZHBfc3luY19tb2R1bGVfc3RhdGVzJTNBJTIwdHJ1ZSUwQSUyMCUyMGZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0ElMjBCZXJ0TGF5ZXIlMEElMjAlMjBmc2RwX3VzZV9vcmlnX3BhcmFtcyUzQSUyMHRydWUlMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBiZjE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjAyJTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">FSDP</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">fsdp_config:</span>
  <span class="hljs-attr">fsdp_auto_wrap_policy:</span> <span class="hljs-string">TRANSFORMER_BASED_WRAP</span>
  <span class="hljs-attr">fsdp_backward_prefetch_policy:</span> <span class="hljs-string">BACKWARD_PRE</span>
  <span class="hljs-attr">fsdp_forward_prefetch:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_offload_params:</span> <span class="hljs-literal">false</span>
  <span class="hljs-attr">fsdp_sharding_strategy:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">fsdp_state_dict_type:</span> <span class="hljs-string">FULL_STATE_DICT</span>
  <span class="hljs-attr">fsdp_sync_module_states:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">fsdp_transformer_layer_cls_to_wrap:</span> <span class="hljs-string">BertLayer</span>
  <span class="hljs-attr">fsdp_use_orig_params:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),ul=new u({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTBBJTIwJTIwZGVlcHNwZWVkX2NvbmZpZ19maWxlJTNBJTIwJTJGaG9tZSUyRnVzZXIlMkZjb25maWdzJTJGZHNfemVybzNfY29uZmlnLmpzb24lMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBZGlzdHJpYnV0ZWRfdHlwZSUzQSUyMERFRVBTUEVFRCUwQWRvd25jYXN0X2JmMTYlM0ElMjAnbm8nJTBBbWFjaGluZV9yYW5rJTNBJTIwMCUwQW1haW5fdHJhaW5pbmdfZnVuY3Rpb24lM0ElMjBtYWluJTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjA0JTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>
<span class="hljs-attr">deepspeed_config:</span>
  <span class="hljs-attr">deepspeed_config_file:</span> <span class="hljs-string">/home/user/configs/ds_zero3_config.json</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),wl=new u({props:{code:"Y29tcHV0ZV9lbnZpcm9ubWVudCUzQSUyMExPQ0FMX01BQ0hJTkUlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMEFkZWVwc3BlZWRfY29uZmlnJTNBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTBBJTIwJTIwZ3JhZGllbnRfYWNjdW11bGF0aW9uX3N0ZXBzJTNBJTIwMSUwQSUyMCUyMGdyYWRpZW50X2NsaXBwaW5nJTNBJTIwMC43JTBBJTIwJTIwb2ZmbG9hZF9vcHRpbWl6ZXJfZGV2aWNlJTNBJTIwY3B1JTBBJTIwJTIwb2ZmbG9hZF9wYXJhbV9kZXZpY2UlM0ElMjBjcHUlMEElMjAlMjB6ZXJvM19pbml0X2ZsYWclM0ElMjB0cnVlJTBBJTIwJTIwemVyb19zdGFnZSUzQSUyMDIlMEFkaXN0cmlidXRlZF90eXBlJTNBJTIwREVFUFNQRUVEJTBBZG93bmNhc3RfYmYxNiUzQSUyMCdubyclMEFtYWNoaW5lX3JhbmslM0ElMjAwJTBBbWFpbl90cmFpbmluZ19mdW5jdGlvbiUzQSUyMG1haW4lMEFtaXhlZF9wcmVjaXNpb24lM0ElMjBiZjE2JTBBbnVtX21hY2hpbmVzJTNBJTIwMSUwQW51bV9wcm9jZXNzZXMlM0ElMjA0JTBBcmR6dl9iYWNrZW5kJTNBJTIwc3RhdGljJTBBc2FtZV9uZXR3b3JrJTNBJTIwdHJ1ZSUwQXRwdV9lbnYlM0ElMjAlNUIlNUQlMEF0cHVfdXNlX2NsdXN0ZXIlM0ElMjBmYWxzZSUwQXRwdV91c2Vfc3VkbyUzQSUyMGZhbHNlJTBBdXNlX2NwdSUzQSUyMGZhbHNl",highlighted:`<span class="hljs-attr">compute_environment:</span> <span class="hljs-string">LOCAL_MACHINE</span>                                                                                             
<span class="hljs-attr">deepspeed_config:</span>                                                                                                              
  <span class="hljs-attr">gradient_accumulation_steps:</span> <span class="hljs-number">1</span>
  <span class="hljs-attr">gradient_clipping:</span> <span class="hljs-number">0.7</span>
  <span class="hljs-attr">offload_optimizer_device:</span> <span class="hljs-string">cpu</span>
  <span class="hljs-attr">offload_param_device:</span> <span class="hljs-string">cpu</span>
  <span class="hljs-attr">zero3_init_flag:</span> <span class="hljs-literal">true</span>
  <span class="hljs-attr">zero_stage:</span> <span class="hljs-number">2</span>
<span class="hljs-attr">distributed_type:</span> <span class="hljs-string">DEEPSPEED</span>
<span class="hljs-attr">downcast_bf16:</span> <span class="hljs-string">&#x27;no&#x27;</span>
<span class="hljs-attr">machine_rank:</span> <span class="hljs-number">0</span>
<span class="hljs-attr">main_training_function:</span> <span class="hljs-string">main</span>
<span class="hljs-attr">mixed_precision:</span> <span class="hljs-string">bf16</span>
<span class="hljs-attr">num_machines:</span> <span class="hljs-number">1</span>
<span class="hljs-attr">num_processes:</span> <span class="hljs-number">4</span>
<span class="hljs-attr">rdzv_backend:</span> <span class="hljs-string">static</span>
<span class="hljs-attr">same_network:</span> <span class="hljs-literal">true</span>
<span class="hljs-attr">tpu_env:</span> []
<span class="hljs-attr">tpu_use_cluster:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">tpu_use_sudo:</span> <span class="hljs-literal">false</span>
<span class="hljs-attr">use_cpu:</span> <span class="hljs-literal">false</span>`,wrap:!1}}),Jl=new u({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnMlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwJTVDJTBBLiUyRmV4YW1wbGVzJTJGcHl0b3JjaCUyRnRleHQtY2xhc3NpZmljYXRpb24lMkZydW5fZ2x1ZS5weSUyMCU1QyUwQS0tbW9kZWxfbmFtZV9vcl9wYXRoJTIwYmVydC1iYXNlLWNhc2VkJTIwJTVDJTBBLS10YXNrX25hbWUlMjAlMjRUQVNLX05BTUUlMjAlNUMlMEEtLWRvX3RyYWluJTIwJTVDJTBBLS1kb19ldmFsJTIwJTVDJTBBLS1tYXhfc2VxX2xlbmd0aCUyMDEyOCUyMCU1QyUwQS0tcGVyX2RldmljZV90cmFpbl9iYXRjaF9zaXplJTIwMTYlMjAlNUMlMEEtLWxlYXJuaW5nX3JhdGUlMjA1ZS01JTIwJTVDJTBBLS1udW1fdHJhaW5fZXBvY2hzJTIwMyUyMCU1QyUwQS0tb3V0cHV0X2RpciUyMCUyRnRtcCUyRiUyNFRBU0tfTkFNRSUyRiUyMCU1QyUwQS0tb3ZlcndyaXRlX291dHB1dF9kaXI=",highlighted:`<span class="hljs-built_in">cd</span> transformers

accelerate launch \\
./examples/pytorch/text-classification/run_glue.py \\
--model_name_or_path bert-base-cased \\
--task_name <span class="hljs-variable">$TASK_NAME</span> \\
--do_train \\
--do_eval \\
--max_seq_length 128 \\
--per_device_train_batch_size 16 \\
--learning_rate 5e-5 \\
--num_train_epochs 3 \\
--output_dir /tmp/<span class="hljs-variable">$TASK_NAME</span>/ \\
--overwrite_output_dir`,wrap:!1}}),jl=new u({props:{code:"Y2QlMjB0cmFuc2Zvcm1lcnMlMEElMEFhY2NlbGVyYXRlJTIwbGF1bmNoJTIwLS1udW1fcHJvY2Vzc2VzJTNEMiUyMCU1QyUwQS0tdXNlX2ZzZHAlMjAlNUMlMEEtLW1peGVkX3ByZWNpc2lvbiUzRGJmMTYlMjAlNUMlMEEtLWZzZHBfYXV0b193cmFwX3BvbGljeSUzRFRSQU5TRk9STUVSX0JBU0VEX1dSQVAlMjAlMjAlNUMlMEEtLWZzZHBfdHJhbnNmb3JtZXJfbGF5ZXJfY2xzX3RvX3dyYXAlM0QlMjJCZXJ0TGF5ZXIlMjIlMjAlNUMlMEEtLWZzZHBfc2hhcmRpbmdfc3RyYXRlZ3klM0QxJTIwJTVDJTBBLS1mc2RwX3N0YXRlX2RpY3RfdHlwZSUzREZVTExfU1RBVEVfRElDVCUyMCU1QyUwQS4lMkZleGFtcGxlcyUyRnB5dG9yY2glMkZ0ZXh0LWNsYXNzaWZpY2F0aW9uJTJGcnVuX2dsdWUucHklMEEtLW1vZGVsX25hbWVfb3JfcGF0aCUyMGJlcnQtYmFzZS1jYXNlZCUyMCU1QyUwQS0tdGFza19uYW1lJTIwJTI0VEFTS19OQU1FJTIwJTVDJTBBLS1kb190cmFpbiUyMCU1QyUwQS0tZG9fZXZhbCUyMCU1QyUwQS0tbWF4X3NlcV9sZW5ndGglMjAxMjglMjAlNUMlMEEtLXBlcl9kZXZpY2VfdHJhaW5fYmF0Y2hfc2l6ZSUyMDE2JTIwJTVDJTBBLS1sZWFybmluZ19yYXRlJTIwNWUtNSUyMCU1QyUwQS0tbnVtX3RyYWluX2Vwb2NocyUyMDMlMjAlNUMlMEEtLW91dHB1dF9kaXIlMjAlMkZ0bXAlMkYlMjRUQVNLX05BTUUlMkYlMjAlNUMlMEEtLW92ZXJ3cml0ZV9vdXRwdXRfZGly",highlighted:`<span class="hljs-built_in">cd</span> transformers

accelerate launch --num_processes=2 \\
--use_fsdp \\
--mixed_precision=bf16 \\
--fsdp_auto_wrap_policy=TRANSFORMER_BASED_WRAP  \\
--fsdp_transformer_layer_cls_to_wrap=<span class="hljs-string">&quot;BertLayer&quot;</span> \\
--fsdp_sharding_strategy=1 \\
--fsdp_state_dict_type=FULL_STATE_DICT \\
./examples/pytorch/text-classification/run_glue.py
--model_name_or_path bert-base-cased \\
--task_name <span class="hljs-variable">$TASK_NAME</span> \\
--do_train \\
--do_eval \\
--max_seq_length 128 \\
--per_device_train_batch_size 16 \\
--learning_rate 5e-5 \\
--num_train_epochs 3 \\
--output_dir /tmp/<span class="hljs-variable">$TASK_NAME</span>/ \\
--overwrite_output_dir`,wrap:!1}}),bl=new _({props:{title:"通过 NEFTune 提升微调性能",local:"通过-neftune-提升微调性能",headingTag:"h2"}}),Cl=new u({props:{code:"JTBBJTBB",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Trainer, TrainingArguments

args = TrainingArguments(..., neftune_noise_alpha=<span class="hljs-number">0.1</span>)
trainer = Trainer(..., args=args)

...

trainer.train()`,wrap:!1}}),{c(){m=p("meta"),I=n(),w=p("p"),y=n(),c($.$$.fragment),b=n(),U=p("p"),U.innerHTML=Qa,El=n(),c(g.$$.fragment),Xl=n(),V=p("p"),V.innerHTML=qa,Rl=n(),P=p("p"),P.innerHTML=Oa,Nl=n(),S=p("p"),S.innerHTML=Ka,kl=n(),E=p("ul"),E.innerHTML=ep,Gl=n(),c(x.$$.fragment),Fl=n(),X=p("p"),X.innerHTML=tp,Wl=n(),c(R.$$.fragment),Yl=n(),N=p("p"),N.innerHTML=lp,Dl=n(),c(k.$$.fragment),zl=n(),G=p("p"),G.textContent=sp,Ql=n(),c(F.$$.fragment),ql=n(),W=p("p"),W.textContent=np,Ol=n(),c(Y.$$.fragment),Kl=n(),D=p("p"),D.textContent=ap,es=n(),c(z.$$.fragment),ts=n(),Q=p("p"),Q.textContent=pp,ls=n(),c(q.$$.fragment),ss=n(),O=p("p"),O.innerHTML=ip,ns=n(),K=p("p"),K.innerHTML=rp,as=n(),ee=p("ul"),ee.innerHTML=cp,ps=n(),te=p("p"),te.innerHTML=dp,is=n(),le=p("ul"),le.innerHTML=Mp,rs=n(),c(se.$$.fragment),cs=n(),ne=p("p"),ne.innerHTML=op,ds=n(),ae=p("p"),ae.innerHTML=Tp,Ms=n(),pe=p("ul"),pe.innerHTML=fp,os=n(),ie=p("p"),ie.innerHTML=mp,Ts=n(),re=p("p"),re.innerHTML=up,fs=n(),ce=p("p"),ce.textContent=wp,ms=n(),c(de.$$.fragment),us=n(),Me=p("p"),Me.textContent=Jp,ws=n(),c(oe.$$.fragment),Js=n(),Te=p("p"),Te.textContent=jp,js=n(),c(fe.$$.fragment),hs=n(),me=p("p"),me.textContent=hp,_s=n(),ue=p("p"),ue.textContent=_p,ys=n(),c(we.$$.fragment),bs=n(),Je=p("p"),Je.innerHTML=yp,Is=n(),c(je.$$.fragment),Us=n(),he=p("p"),he.innerHTML=bp,$s=n(),_e=p("p"),_e.innerHTML=Ip,Cs=n(),c(ye.$$.fragment),As=n(),be=p("p"),be.textContent=Up,vs=n(),Ie=p("p"),Ie.innerHTML=$p,gs=n(),c(Ue.$$.fragment),xs=n(),$e=p("p"),$e.innerHTML=Cp,Ls=n(),c(Ce.$$.fragment),Zs=n(),c(Ae.$$.fragment),Bs=n(),ve=p("p"),ve.innerHTML=Ap,Hs=n(),ge=p("p"),ge.textContent=vp,Vs=n(),xe=p("p"),xe.textContent=gp,Ps=n(),Le=p("p"),Le.innerHTML=xp,Ss=n(),Ze=p("p"),Ze.innerHTML=Lp,Es=n(),Be=p("p"),Be.textContent=Zp,Xs=n(),c(He.$$.fragment),Rs=n(),Ve=p("p"),Ve.innerHTML=Bp,Ns=n(),Pe=p("p"),Pe.textContent=Hp,ks=n(),c(Se.$$.fragment),Gs=n(),Ee=p("p"),Ee.innerHTML=Vp,Fs=n(),Xe=p("p"),Xe.innerHTML=Pp,Ws=n(),c(Re.$$.fragment),Ys=n(),Ne=p("p"),Ne.textContent=Sp,Ds=n(),c(ke.$$.fragment),zs=n(),Ge=p("p"),Ge.textContent=Ep,Qs=n(),c(Fe.$$.fragment),qs=n(),We=p("p"),We.textContent=Xp,Os=n(),Ye=p("p"),Ye.innerHTML=Rp,Ks=n(),De=p("p"),De.innerHTML=Np,en=n(),ze=p("ol"),ze.innerHTML=kp,tn=n(),c(Qe.$$.fragment),ln=n(),L=p("ol"),L.innerHTML=Gp,sn=n(),c(qe.$$.fragment),nn=n(),Oe=p("p"),Oe.innerHTML=Fp,an=n(),Ke=p("p"),Ke.textContent=Wp,pn=n(),c(et.$$.fragment),rn=n(),tt=p("p"),tt.textContent=Yp,cn=n(),lt=p("p"),lt.innerHTML=Dp,dn=n(),c(st.$$.fragment),Mn=n(),nt=p("p"),nt.innerHTML=zp,on=n(),at=p("p"),at.innerHTML=Qp,Tn=n(),pt=p("p"),pt.innerHTML=qp,fn=n(),Al=p("a"),mn=n(),c(it.$$.fragment),un=n(),rt=p("p"),rt.textContent=Op,wn=n(),ct=p("p"),ct.innerHTML=Kp,Jn=n(),dt=p("p"),dt.textContent=ei,jn=n(),c(Mt.$$.fragment),hn=n(),ot=p("p"),ot.textContent=ti,_n=n(),Tt=p("p"),Tt.innerHTML=li,yn=n(),c(ft.$$.fragment),bn=n(),mt=p("p"),mt.textContent=si,In=n(),ut=p("p"),ut.innerHTML=ni,Un=n(),wt=p("p"),wt.innerHTML=ai,$n=n(),c(Jt.$$.fragment),Cn=n(),jt=p("p"),jt.innerHTML=pi,An=n(),c(ht.$$.fragment),vn=n(),_t=p("p"),_t.textContent=ii,gn=n(),c(yt.$$.fragment),xn=n(),bt=p("p"),bt.innerHTML=ri,Ln=n(),It=p("p"),It.textContent=ci,Zn=n(),c(Ut.$$.fragment),Bn=n(),$t=p("p"),$t.textContent=di,Hn=n(),Ct=p("p"),Ct.innerHTML=Mi,Vn=n(),At=p("p"),At.innerHTML=oi,Pn=n(),vt=p("p"),vt.textContent=Ti,Sn=n(),c(gt.$$.fragment),En=n(),xt=p("p"),xt.textContent=fi,Xn=n(),Lt=p("p"),Lt.innerHTML=mi,Rn=n(),c(Zt.$$.fragment),Nn=n(),Bt=p("p"),Bt.innerHTML=ui,kn=n(),Ht=p("p"),Ht.textContent=wi,Gn=n(),Vt=p("p"),Vt.textContent=Ji,Fn=n(),Pt=p("p"),Pt.innerHTML=ji,Wn=n(),c(St.$$.fragment),Yn=n(),Et=p("p"),Et.innerHTML=hi,Dn=n(),Xt=p("p"),Xt.textContent=_i,zn=n(),c(Rt.$$.fragment),Qn=n(),Nt=p("p"),Nt.innerHTML=yi,qn=n(),kt=p("p"),kt.innerHTML=bi,On=n(),Gt=p("p"),Gt.innerHTML=Ii,Kn=n(),Ft=p("ul"),Ft.innerHTML=Ui,ea=n(),Wt=p("p"),Wt.innerHTML=$i,ta=n(),Yt=p("ul"),Yt.innerHTML=Ci,la=n(),c(Dt.$$.fragment),sa=n(),zt=p("p"),zt.innerHTML=Ai,na=n(),Qt=p("p"),Qt.innerHTML=vi,aa=n(),qt=p("p"),qt.innerHTML=gi,pa=n(),Ot=p("p"),Ot.innerHTML=xi,ia=n(),Kt=p("ul"),Kt.innerHTML=Li,ra=n(),c(el.$$.fragment),ca=n(),tl=p("p"),tl.innerHTML=Zi,da=n(),c(Z.$$.fragment),Ma=n(),ll=p("p"),ll.innerHTML=Bi,oa=n(),sl=p("ol"),sl.innerHTML=Hi,Ta=n(),nl=p("p"),nl.innerHTML=Vi,fa=n(),al=p("p"),al.innerHTML=Pi,ma=n(),c(pl.$$.fragment),ua=n(),il=p("p"),il.innerHTML=Si,wa=n(),rl=p("ol"),rl.innerHTML=Ei,Ja=n(),cl=p("p"),cl.innerHTML=Xi,ja=n(),c(dl.$$.fragment),ha=n(),Ml=p("p"),Ml.textContent=Ri,_a=n(),ol=p("ul"),ol.innerHTML=Ni,ya=n(),Tl=p("p"),Tl.textContent=ki,ba=n(),C=p("ol"),vl=p("li"),vl.innerHTML=Gi,Sa=n(),J=p("li"),gl=p("p"),gl.innerHTML=Fi,Ea=n(),xl=p("p"),xl.textContent=Wi,Xa=n(),c(fl.$$.fragment),Ra=n(),Ll=p("p"),Ll.textContent=Yi,Na=n(),c(ml.$$.fragment),ka=n(),Zl=p("p"),Zl.textContent=Di,Ga=n(),c(ul.$$.fragment),Fa=n(),Bl=p("p"),Bl.textContent=zi,Wa=n(),c(wl.$$.fragment),Ya=n(),Hl=p("li"),Hl.innerHTML=Qi,Ia=n(),c(Jl.$$.fragment),Ua=n(),B=p("ol"),B.innerHTML=qi,$a=n(),c(jl.$$.fragment),Ca=n(),hl=p("p"),hl.innerHTML=Oi,Aa=n(),_l=p("p"),_l.textContent=Ki,va=n(),yl=p("p"),yl.innerHTML=er,ga=n(),c(bl.$$.fragment),xa=n(),Il=p("p"),Il.textContent=tr,La=n(),Ul=p("blockquote"),Ul.innerHTML=lr,Za=n(),H=p("div"),H.innerHTML=sr,Ba=n(),$l=p("p"),$l.innerHTML=nr,Ha=n(),c(Cl.$$.fragment),Va=n(),Vl=p("p"),this.h()},l(e){const t=dr("svelte-u9bgzb",document.head);m=i(t,"META",{name:!0,content:!0}),t.forEach(l),I=a(e),w=i(e,"P",{}),Pl(w).forEach(l),y=a(e),d($.$$.fragment,e),b=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1fqk56f"&&(U.innerHTML=Qa),El=a(e),d(g.$$.fragment,e),Xl=a(e),V=i(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-1l9p1f7"&&(V.innerHTML=qa),Rl=a(e),P=i(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-12lk7wo"&&(P.innerHTML=Oa),Nl=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-khc67z"&&(S.innerHTML=Ka),kl=a(e),E=i(e,"UL",{"data-svelte-h":!0}),r(E)!=="svelte-1uaagqa"&&(E.innerHTML=ep),Gl=a(e),d(x.$$.fragment,e),Fl=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-2j331a"&&(X.innerHTML=tp),Wl=a(e),d(R.$$.fragment,e),Yl=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-ree20n"&&(N.innerHTML=lp),Dl=a(e),d(k.$$.fragment,e),zl=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-9mh9x2"&&(G.textContent=sp),Ql=a(e),d(F.$$.fragment,e),ql=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-y12ple"&&(W.textContent=np),Ol=a(e),d(Y.$$.fragment,e),Kl=a(e),D=i(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-yvfqnp"&&(D.textContent=ap),es=a(e),d(z.$$.fragment,e),ts=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-1ot403n"&&(Q.textContent=pp),ls=a(e),d(q.$$.fragment,e),ss=a(e),O=i(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1dcbvcs"&&(O.innerHTML=ip),ns=a(e),K=i(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-qcrk5m"&&(K.innerHTML=rp),as=a(e),ee=i(e,"UL",{"data-svelte-h":!0}),r(ee)!=="svelte-4byw4s"&&(ee.innerHTML=cp),ps=a(e),te=i(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-bm0al3"&&(te.innerHTML=dp),is=a(e),le=i(e,"UL",{"data-svelte-h":!0}),r(le)!=="svelte-oh4fco"&&(le.innerHTML=Mp),rs=a(e),d(se.$$.fragment,e),cs=a(e),ne=i(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-11nzvje"&&(ne.innerHTML=op),ds=a(e),ae=i(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-bmchrh"&&(ae.innerHTML=Tp),Ms=a(e),pe=i(e,"UL",{"data-svelte-h":!0}),r(pe)!=="svelte-1kpc9v"&&(pe.innerHTML=fp),os=a(e),ie=i(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1j17cf7"&&(ie.innerHTML=mp),Ts=a(e),re=i(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-3s782n"&&(re.innerHTML=up),fs=a(e),ce=i(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-pq2bs5"&&(ce.textContent=wp),ms=a(e),d(de.$$.fragment,e),us=a(e),Me=i(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1jjwf66"&&(Me.textContent=Jp),ws=a(e),d(oe.$$.fragment,e),Js=a(e),Te=i(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1kioman"&&(Te.textContent=jp),js=a(e),d(fe.$$.fragment,e),hs=a(e),me=i(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-ko9cmk"&&(me.textContent=hp),_s=a(e),ue=i(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-c5eui5"&&(ue.textContent=_p),ys=a(e),d(we.$$.fragment,e),bs=a(e),Je=i(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-1jp7g1f"&&(Je.innerHTML=yp),Is=a(e),d(je.$$.fragment,e),Us=a(e),he=i(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-1wvzdab"&&(he.innerHTML=bp),$s=a(e),_e=i(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-5qvus8"&&(_e.innerHTML=Ip),Cs=a(e),d(ye.$$.fragment,e),As=a(e),be=i(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-re54sn"&&(be.textContent=Up),vs=a(e),Ie=i(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-iv7fem"&&(Ie.innerHTML=$p),gs=a(e),d(Ue.$$.fragment,e),xs=a(e),$e=i(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-kxuykq"&&($e.innerHTML=Cp),Ls=a(e),d(Ce.$$.fragment,e),Zs=a(e),d(Ae.$$.fragment,e),Bs=a(e),ve=i(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-bc7sgo"&&(ve.innerHTML=Ap),Hs=a(e),ge=i(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-y06piz"&&(ge.textContent=vp),Vs=a(e),xe=i(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-75oq4n"&&(xe.textContent=gp),Ps=a(e),Le=i(e,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1w89bwu"&&(Le.innerHTML=xp),Ss=a(e),Ze=i(e,"P",{"data-svelte-h":!0}),r(Ze)!=="svelte-5n5bco"&&(Ze.innerHTML=Lp),Es=a(e),Be=i(e,"P",{"data-svelte-h":!0}),r(Be)!=="svelte-175p3lm"&&(Be.textContent=Zp),Xs=a(e),d(He.$$.fragment,e),Rs=a(e),Ve=i(e,"P",{"data-svelte-h":!0}),r(Ve)!=="svelte-1pobon8"&&(Ve.innerHTML=Bp),Ns=a(e),Pe=i(e,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-mbdimu"&&(Pe.textContent=Hp),ks=a(e),d(Se.$$.fragment,e),Gs=a(e),Ee=i(e,"P",{"data-svelte-h":!0}),r(Ee)!=="svelte-ws2fu2"&&(Ee.innerHTML=Vp),Fs=a(e),Xe=i(e,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1svcw38"&&(Xe.innerHTML=Pp),Ws=a(e),d(Re.$$.fragment,e),Ys=a(e),Ne=i(e,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-19wh0eu"&&(Ne.textContent=Sp),Ds=a(e),d(ke.$$.fragment,e),zs=a(e),Ge=i(e,"P",{"data-svelte-h":!0}),r(Ge)!=="svelte-cfiyi7"&&(Ge.textContent=Ep),Qs=a(e),d(Fe.$$.fragment,e),qs=a(e),We=i(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-108fgl4"&&(We.textContent=Xp),Os=a(e),Ye=i(e,"P",{"data-svelte-h":!0}),r(Ye)!=="svelte-sdywfx"&&(Ye.innerHTML=Rp),Ks=a(e),De=i(e,"P",{"data-svelte-h":!0}),r(De)!=="svelte-1v4r80a"&&(De.innerHTML=Np),en=a(e),ze=i(e,"OL",{"data-svelte-h":!0}),r(ze)!=="svelte-734ft1"&&(ze.innerHTML=kp),tn=a(e),d(Qe.$$.fragment,e),ln=a(e),L=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(L)!=="svelte-43atoa"&&(L.innerHTML=Gp),sn=a(e),d(qe.$$.fragment,e),nn=a(e),Oe=i(e,"P",{"data-svelte-h":!0}),r(Oe)!=="svelte-vbam1o"&&(Oe.innerHTML=Fp),an=a(e),Ke=i(e,"P",{"data-svelte-h":!0}),r(Ke)!=="svelte-3rlsf5"&&(Ke.textContent=Wp),pn=a(e),d(et.$$.fragment,e),rn=a(e),tt=i(e,"P",{"data-svelte-h":!0}),r(tt)!=="svelte-1pafl9k"&&(tt.textContent=Yp),cn=a(e),lt=i(e,"P",{"data-svelte-h":!0}),r(lt)!=="svelte-d5ugu7"&&(lt.innerHTML=Dp),dn=a(e),d(st.$$.fragment,e),Mn=a(e),nt=i(e,"P",{"data-svelte-h":!0}),r(nt)!=="svelte-wh4aqa"&&(nt.innerHTML=zp),on=a(e),at=i(e,"P",{"data-svelte-h":!0}),r(at)!=="svelte-paoc96"&&(at.innerHTML=Qp),Tn=a(e),pt=i(e,"P",{"data-svelte-h":!0}),r(pt)!=="svelte-u301tg"&&(pt.innerHTML=qp),fn=a(e),Al=i(e,"A",{id:!0}),Pl(Al).forEach(l),mn=a(e),d(it.$$.fragment,e),un=a(e),rt=i(e,"P",{"data-svelte-h":!0}),r(rt)!=="svelte-yn9um3"&&(rt.textContent=Op),wn=a(e),ct=i(e,"P",{"data-svelte-h":!0}),r(ct)!=="svelte-sahp2c"&&(ct.innerHTML=Kp),Jn=a(e),dt=i(e,"P",{"data-svelte-h":!0}),r(dt)!=="svelte-1kbw1qt"&&(dt.textContent=ei),jn=a(e),d(Mt.$$.fragment,e),hn=a(e),ot=i(e,"P",{"data-svelte-h":!0}),r(ot)!=="svelte-620r2v"&&(ot.textContent=ti),_n=a(e),Tt=i(e,"P",{"data-svelte-h":!0}),r(Tt)!=="svelte-5rw82i"&&(Tt.innerHTML=li),yn=a(e),d(ft.$$.fragment,e),bn=a(e),mt=i(e,"P",{"data-svelte-h":!0}),r(mt)!=="svelte-1v2ka1w"&&(mt.textContent=si),In=a(e),ut=i(e,"P",{"data-svelte-h":!0}),r(ut)!=="svelte-4m7phy"&&(ut.innerHTML=ni),Un=a(e),wt=i(e,"P",{"data-svelte-h":!0}),r(wt)!=="svelte-pfmv7e"&&(wt.innerHTML=ai),$n=a(e),d(Jt.$$.fragment,e),Cn=a(e),jt=i(e,"P",{"data-svelte-h":!0}),r(jt)!=="svelte-1odguee"&&(jt.innerHTML=pi),An=a(e),d(ht.$$.fragment,e),vn=a(e),_t=i(e,"P",{"data-svelte-h":!0}),r(_t)!=="svelte-145ltfk"&&(_t.textContent=ii),gn=a(e),d(yt.$$.fragment,e),xn=a(e),bt=i(e,"P",{"data-svelte-h":!0}),r(bt)!=="svelte-tlg140"&&(bt.innerHTML=ri),Ln=a(e),It=i(e,"P",{"data-svelte-h":!0}),r(It)!=="svelte-wf664i"&&(It.textContent=ci),Zn=a(e),d(Ut.$$.fragment,e),Bn=a(e),$t=i(e,"P",{"data-svelte-h":!0}),r($t)!=="svelte-zk4sv2"&&($t.textContent=di),Hn=a(e),Ct=i(e,"P",{"data-svelte-h":!0}),r(Ct)!=="svelte-4hqpao"&&(Ct.innerHTML=Mi),Vn=a(e),At=i(e,"P",{"data-svelte-h":!0}),r(At)!=="svelte-udq7yk"&&(At.innerHTML=oi),Pn=a(e),vt=i(e,"P",{"data-svelte-h":!0}),r(vt)!=="svelte-1ibrwrt"&&(vt.textContent=Ti),Sn=a(e),d(gt.$$.fragment,e),En=a(e),xt=i(e,"P",{"data-svelte-h":!0}),r(xt)!=="svelte-1en3okt"&&(xt.textContent=fi),Xn=a(e),Lt=i(e,"P",{"data-svelte-h":!0}),r(Lt)!=="svelte-fe44nl"&&(Lt.innerHTML=mi),Rn=a(e),d(Zt.$$.fragment,e),Nn=a(e),Bt=i(e,"P",{"data-svelte-h":!0}),r(Bt)!=="svelte-erxh4b"&&(Bt.innerHTML=ui),kn=a(e),Ht=i(e,"P",{"data-svelte-h":!0}),r(Ht)!=="svelte-18wpg47"&&(Ht.textContent=wi),Gn=a(e),Vt=i(e,"P",{"data-svelte-h":!0}),r(Vt)!=="svelte-1yf72wx"&&(Vt.textContent=Ji),Fn=a(e),Pt=i(e,"P",{"data-svelte-h":!0}),r(Pt)!=="svelte-1mk73kk"&&(Pt.innerHTML=ji),Wn=a(e),d(St.$$.fragment,e),Yn=a(e),Et=i(e,"P",{"data-svelte-h":!0}),r(Et)!=="svelte-178ciny"&&(Et.innerHTML=hi),Dn=a(e),Xt=i(e,"P",{"data-svelte-h":!0}),r(Xt)!=="svelte-1a81go8"&&(Xt.textContent=_i),zn=a(e),d(Rt.$$.fragment,e),Qn=a(e),Nt=i(e,"P",{"data-svelte-h":!0}),r(Nt)!=="svelte-1dhpw61"&&(Nt.innerHTML=yi),qn=a(e),kt=i(e,"P",{"data-svelte-h":!0}),r(kt)!=="svelte-159bs03"&&(kt.innerHTML=bi),On=a(e),Gt=i(e,"P",{"data-svelte-h":!0}),r(Gt)!=="svelte-xzl7zu"&&(Gt.innerHTML=Ii),Kn=a(e),Ft=i(e,"UL",{"data-svelte-h":!0}),r(Ft)!=="svelte-15bm16s"&&(Ft.innerHTML=Ui),ea=a(e),Wt=i(e,"P",{"data-svelte-h":!0}),r(Wt)!=="svelte-eoc2yu"&&(Wt.innerHTML=$i),ta=a(e),Yt=i(e,"UL",{"data-svelte-h":!0}),r(Yt)!=="svelte-1dbiwy5"&&(Yt.innerHTML=Ci),la=a(e),d(Dt.$$.fragment,e),sa=a(e),zt=i(e,"P",{"data-svelte-h":!0}),r(zt)!=="svelte-1tch7gc"&&(zt.innerHTML=Ai),na=a(e),Qt=i(e,"P",{"data-svelte-h":!0}),r(Qt)!=="svelte-q2y7dk"&&(Qt.innerHTML=vi),aa=a(e),qt=i(e,"P",{"data-svelte-h":!0}),r(qt)!=="svelte-qrlftm"&&(qt.innerHTML=gi),pa=a(e),Ot=i(e,"P",{"data-svelte-h":!0}),r(Ot)!=="svelte-dt5rlk"&&(Ot.innerHTML=xi),ia=a(e),Kt=i(e,"UL",{"data-svelte-h":!0}),r(Kt)!=="svelte-nf12q0"&&(Kt.innerHTML=Li),ra=a(e),d(el.$$.fragment,e),ca=a(e),tl=i(e,"P",{"data-svelte-h":!0}),r(tl)!=="svelte-120hv21"&&(tl.innerHTML=Zi),da=a(e),d(Z.$$.fragment,e),Ma=a(e),ll=i(e,"P",{"data-svelte-h":!0}),r(ll)!=="svelte-wtjpop"&&(ll.innerHTML=Bi),oa=a(e),sl=i(e,"OL",{"data-svelte-h":!0}),r(sl)!=="svelte-1ka5quj"&&(sl.innerHTML=Hi),Ta=a(e),nl=i(e,"P",{"data-svelte-h":!0}),r(nl)!=="svelte-1r58xqk"&&(nl.innerHTML=Vi),fa=a(e),al=i(e,"P",{"data-svelte-h":!0}),r(al)!=="svelte-50oyow"&&(al.innerHTML=Pi),ma=a(e),d(pl.$$.fragment,e),ua=a(e),il=i(e,"P",{"data-svelte-h":!0}),r(il)!=="svelte-rqdjb"&&(il.innerHTML=Si),wa=a(e),rl=i(e,"OL",{"data-svelte-h":!0}),r(rl)!=="svelte-17j0ov9"&&(rl.innerHTML=Ei),Ja=a(e),cl=i(e,"P",{"data-svelte-h":!0}),r(cl)!=="svelte-1ya1wrs"&&(cl.innerHTML=Xi),ja=a(e),d(dl.$$.fragment,e),ha=a(e),Ml=i(e,"P",{"data-svelte-h":!0}),r(Ml)!=="svelte-1f883vb"&&(Ml.textContent=Ri),_a=a(e),ol=i(e,"UL",{"data-svelte-h":!0}),r(ol)!=="svelte-7hdm7t"&&(ol.innerHTML=Ni),ya=a(e),Tl=i(e,"P",{"data-svelte-h":!0}),r(Tl)!=="svelte-pseuj1"&&(Tl.textContent=ki),ba=a(e),C=i(e,"OL",{});var A=Pl(C);vl=i(A,"LI",{"data-svelte-h":!0}),r(vl)!=="svelte-1cb1a5s"&&(vl.innerHTML=Gi),Sa=a(A),J=i(A,"LI",{});var j=Pl(J);gl=i(j,"P",{"data-svelte-h":!0}),r(gl)!=="svelte-1m18qdn"&&(gl.innerHTML=Fi),Ea=a(j),xl=i(j,"P",{"data-svelte-h":!0}),r(xl)!=="svelte-x4bacf"&&(xl.textContent=Wi),Xa=a(j),d(fl.$$.fragment,j),Ra=a(j),Ll=i(j,"P",{"data-svelte-h":!0}),r(Ll)!=="svelte-1j4zkhk"&&(Ll.textContent=Yi),Na=a(j),d(ml.$$.fragment,j),ka=a(j),Zl=i(j,"P",{"data-svelte-h":!0}),r(Zl)!=="svelte-q108kw"&&(Zl.textContent=Di),Ga=a(j),d(ul.$$.fragment,j),Fa=a(j),Bl=i(j,"P",{"data-svelte-h":!0}),r(Bl)!=="svelte-jzpdl8"&&(Bl.textContent=zi),Wa=a(j),d(wl.$$.fragment,j),j.forEach(l),Ya=a(A),Hl=i(A,"LI",{"data-svelte-h":!0}),r(Hl)!=="svelte-1175j8m"&&(Hl.innerHTML=Qi),A.forEach(l),Ia=a(e),d(Jl.$$.fragment,e),Ua=a(e),B=i(e,"OL",{start:!0,"data-svelte-h":!0}),r(B)!=="svelte-p5fw3l"&&(B.innerHTML=qi),$a=a(e),d(jl.$$.fragment,e),Ca=a(e),hl=i(e,"P",{"data-svelte-h":!0}),r(hl)!=="svelte-11ttuhu"&&(hl.innerHTML=Oi),Aa=a(e),_l=i(e,"P",{"data-svelte-h":!0}),r(_l)!=="svelte-11jpql9"&&(_l.textContent=Ki),va=a(e),yl=i(e,"P",{"data-svelte-h":!0}),r(yl)!=="svelte-t93zrd"&&(yl.innerHTML=er),ga=a(e),d(bl.$$.fragment,e),xa=a(e),Il=i(e,"P",{"data-svelte-h":!0}),r(Il)!=="svelte-6lb8jf"&&(Il.textContent=tr),La=a(e),Ul=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r(Ul)!=="svelte-bdo78a"&&(Ul.innerHTML=lr),Za=a(e),H=i(e,"DIV",{style:!0,"data-svelte-h":!0}),r(H)!=="svelte-1wkjgyb"&&(H.innerHTML=sr),Ba=a(e),$l=i(e,"P",{"data-svelte-h":!0}),r($l)!=="svelte-13y4x88"&&($l.innerHTML=nr),Ha=a(e),d(Cl.$$.fragment,e),Va=a(e),Vl=i(e,"P",{}),Pl(Vl).forEach(l),this.h()},h(){Sl(m,"name","hf:doc:metadata"),Sl(m,"content",ur),Sl(L,"start","2"),Sl(Al,"id","zero-install-notes"),Sl(B,"start","4"),Mr(H,"text-align","center")},m(e,t){h(document.head,m),s(e,I,t),s(e,w,t),s(e,y,t),M($,e,t),s(e,b,t),s(e,U,t),s(e,El,t),M(g,e,t),s(e,Xl,t),s(e,V,t),s(e,Rl,t),s(e,P,t),s(e,Nl,t),s(e,S,t),s(e,kl,t),s(e,E,t),s(e,Gl,t),M(x,e,t),s(e,Fl,t),s(e,X,t),s(e,Wl,t),M(R,e,t),s(e,Yl,t),s(e,N,t),s(e,Dl,t),M(k,e,t),s(e,zl,t),s(e,G,t),s(e,Ql,t),M(F,e,t),s(e,ql,t),s(e,W,t),s(e,Ol,t),M(Y,e,t),s(e,Kl,t),s(e,D,t),s(e,es,t),M(z,e,t),s(e,ts,t),s(e,Q,t),s(e,ls,t),M(q,e,t),s(e,ss,t),s(e,O,t),s(e,ns,t),s(e,K,t),s(e,as,t),s(e,ee,t),s(e,ps,t),s(e,te,t),s(e,is,t),s(e,le,t),s(e,rs,t),M(se,e,t),s(e,cs,t),s(e,ne,t),s(e,ds,t),s(e,ae,t),s(e,Ms,t),s(e,pe,t),s(e,os,t),s(e,ie,t),s(e,Ts,t),s(e,re,t),s(e,fs,t),s(e,ce,t),s(e,ms,t),M(de,e,t),s(e,us,t),s(e,Me,t),s(e,ws,t),M(oe,e,t),s(e,Js,t),s(e,Te,t),s(e,js,t),M(fe,e,t),s(e,hs,t),s(e,me,t),s(e,_s,t),s(e,ue,t),s(e,ys,t),M(we,e,t),s(e,bs,t),s(e,Je,t),s(e,Is,t),M(je,e,t),s(e,Us,t),s(e,he,t),s(e,$s,t),s(e,_e,t),s(e,Cs,t),M(ye,e,t),s(e,As,t),s(e,be,t),s(e,vs,t),s(e,Ie,t),s(e,gs,t),M(Ue,e,t),s(e,xs,t),s(e,$e,t),s(e,Ls,t),M(Ce,e,t),s(e,Zs,t),M(Ae,e,t),s(e,Bs,t),s(e,ve,t),s(e,Hs,t),s(e,ge,t),s(e,Vs,t),s(e,xe,t),s(e,Ps,t),s(e,Le,t),s(e,Ss,t),s(e,Ze,t),s(e,Es,t),s(e,Be,t),s(e,Xs,t),M(He,e,t),s(e,Rs,t),s(e,Ve,t),s(e,Ns,t),s(e,Pe,t),s(e,ks,t),M(Se,e,t),s(e,Gs,t),s(e,Ee,t),s(e,Fs,t),s(e,Xe,t),s(e,Ws,t),M(Re,e,t),s(e,Ys,t),s(e,Ne,t),s(e,Ds,t),M(ke,e,t),s(e,zs,t),s(e,Ge,t),s(e,Qs,t),M(Fe,e,t),s(e,qs,t),s(e,We,t),s(e,Os,t),s(e,Ye,t),s(e,Ks,t),s(e,De,t),s(e,en,t),s(e,ze,t),s(e,tn,t),M(Qe,e,t),s(e,ln,t),s(e,L,t),s(e,sn,t),M(qe,e,t),s(e,nn,t),s(e,Oe,t),s(e,an,t),s(e,Ke,t),s(e,pn,t),M(et,e,t),s(e,rn,t),s(e,tt,t),s(e,cn,t),s(e,lt,t),s(e,dn,t),M(st,e,t),s(e,Mn,t),s(e,nt,t),s(e,on,t),s(e,at,t),s(e,Tn,t),s(e,pt,t),s(e,fn,t),s(e,Al,t),s(e,mn,t),M(it,e,t),s(e,un,t),s(e,rt,t),s(e,wn,t),s(e,ct,t),s(e,Jn,t),s(e,dt,t),s(e,jn,t),M(Mt,e,t),s(e,hn,t),s(e,ot,t),s(e,_n,t),s(e,Tt,t),s(e,yn,t),M(ft,e,t),s(e,bn,t),s(e,mt,t),s(e,In,t),s(e,ut,t),s(e,Un,t),s(e,wt,t),s(e,$n,t),M(Jt,e,t),s(e,Cn,t),s(e,jt,t),s(e,An,t),M(ht,e,t),s(e,vn,t),s(e,_t,t),s(e,gn,t),M(yt,e,t),s(e,xn,t),s(e,bt,t),s(e,Ln,t),s(e,It,t),s(e,Zn,t),M(Ut,e,t),s(e,Bn,t),s(e,$t,t),s(e,Hn,t),s(e,Ct,t),s(e,Vn,t),s(e,At,t),s(e,Pn,t),s(e,vt,t),s(e,Sn,t),M(gt,e,t),s(e,En,t),s(e,xt,t),s(e,Xn,t),s(e,Lt,t),s(e,Rn,t),M(Zt,e,t),s(e,Nn,t),s(e,Bt,t),s(e,kn,t),s(e,Ht,t),s(e,Gn,t),s(e,Vt,t),s(e,Fn,t),s(e,Pt,t),s(e,Wn,t),M(St,e,t),s(e,Yn,t),s(e,Et,t),s(e,Dn,t),s(e,Xt,t),s(e,zn,t),M(Rt,e,t),s(e,Qn,t),s(e,Nt,t),s(e,qn,t),s(e,kt,t),s(e,On,t),s(e,Gt,t),s(e,Kn,t),s(e,Ft,t),s(e,ea,t),s(e,Wt,t),s(e,ta,t),s(e,Yt,t),s(e,la,t),M(Dt,e,t),s(e,sa,t),s(e,zt,t),s(e,na,t),s(e,Qt,t),s(e,aa,t),s(e,qt,t),s(e,pa,t),s(e,Ot,t),s(e,ia,t),s(e,Kt,t),s(e,ra,t),M(el,e,t),s(e,ca,t),s(e,tl,t),s(e,da,t),M(Z,e,t),s(e,Ma,t),s(e,ll,t),s(e,oa,t),s(e,sl,t),s(e,Ta,t),s(e,nl,t),s(e,fa,t),s(e,al,t),s(e,ma,t),M(pl,e,t),s(e,ua,t),s(e,il,t),s(e,wa,t),s(e,rl,t),s(e,Ja,t),s(e,cl,t),s(e,ja,t),M(dl,e,t),s(e,ha,t),s(e,Ml,t),s(e,_a,t),s(e,ol,t),s(e,ya,t),s(e,Tl,t),s(e,ba,t),s(e,C,t),h(C,vl),h(C,Sa),h(C,J),h(J,gl),h(J,Ea),h(J,xl),h(J,Xa),M(fl,J,null),h(J,Ra),h(J,Ll),h(J,Na),M(ml,J,null),h(J,ka),h(J,Zl),h(J,Ga),M(ul,J,null),h(J,Fa),h(J,Bl),h(J,Wa),M(wl,J,null),h(C,Ya),h(C,Hl),s(e,Ia,t),M(Jl,e,t),s(e,Ua,t),s(e,B,t),s(e,$a,t),M(jl,e,t),s(e,Ca,t),s(e,hl,t),s(e,Aa,t),s(e,_l,t),s(e,va,t),s(e,yl,t),s(e,ga,t),M(bl,e,t),s(e,xa,t),s(e,Il,t),s(e,La,t),s(e,Ul,t),s(e,Za,t),s(e,H,t),s(e,Ba,t),s(e,$l,t),s(e,Ha,t),M(Cl,e,t),s(e,Va,t),s(e,Vl,t),Pa=!0},p(e,[t]){const A={};t&2&&(A.$$scope={dirty:t,ctx:e}),g.$set(A);const j={};t&2&&(j.$$scope={dirty:t,ctx:e}),x.$set(j);const ar={};t&2&&(ar.$$scope={dirty:t,ctx:e}),Z.$set(ar)},i(e){Pa||(o($.$$.fragment,e),o(g.$$.fragment,e),o(x.$$.fragment,e),o(R.$$.fragment,e),o(k.$$.fragment,e),o(F.$$.fragment,e),o(Y.$$.fragment,e),o(z.$$.fragment,e),o(q.$$.fragment,e),o(se.$$.fragment,e),o(de.$$.fragment,e),o(oe.$$.fragment,e),o(fe.$$.fragment,e),o(we.$$.fragment,e),o(je.$$.fragment,e),o(ye.$$.fragment,e),o(Ue.$$.fragment,e),o(Ce.$$.fragment,e),o(Ae.$$.fragment,e),o(He.$$.fragment,e),o(Se.$$.fragment,e),o(Re.$$.fragment,e),o(ke.$$.fragment,e),o(Fe.$$.fragment,e),o(Qe.$$.fragment,e),o(qe.$$.fragment,e),o(et.$$.fragment,e),o(st.$$.fragment,e),o(it.$$.fragment,e),o(Mt.$$.fragment,e),o(ft.$$.fragment,e),o(Jt.$$.fragment,e),o(ht.$$.fragment,e),o(yt.$$.fragment,e),o(Ut.$$.fragment,e),o(gt.$$.fragment,e),o(Zt.$$.fragment,e),o(St.$$.fragment,e),o(Rt.$$.fragment,e),o(Dt.$$.fragment,e),o(el.$$.fragment,e),o(Z.$$.fragment,e),o(pl.$$.fragment,e),o(dl.$$.fragment,e),o(fl.$$.fragment,e),o(ml.$$.fragment,e),o(ul.$$.fragment,e),o(wl.$$.fragment,e),o(Jl.$$.fragment,e),o(jl.$$.fragment,e),o(bl.$$.fragment,e),o(Cl.$$.fragment,e),Pa=!0)},o(e){T($.$$.fragment,e),T(g.$$.fragment,e),T(x.$$.fragment,e),T(R.$$.fragment,e),T(k.$$.fragment,e),T(F.$$.fragment,e),T(Y.$$.fragment,e),T(z.$$.fragment,e),T(q.$$.fragment,e),T(se.$$.fragment,e),T(de.$$.fragment,e),T(oe.$$.fragment,e),T(fe.$$.fragment,e),T(we.$$.fragment,e),T(je.$$.fragment,e),T(ye.$$.fragment,e),T(Ue.$$.fragment,e),T(Ce.$$.fragment,e),T(Ae.$$.fragment,e),T(He.$$.fragment,e),T(Se.$$.fragment,e),T(Re.$$.fragment,e),T(ke.$$.fragment,e),T(Fe.$$.fragment,e),T(Qe.$$.fragment,e),T(qe.$$.fragment,e),T(et.$$.fragment,e),T(st.$$.fragment,e),T(it.$$.fragment,e),T(Mt.$$.fragment,e),T(ft.$$.fragment,e),T(Jt.$$.fragment,e),T(ht.$$.fragment,e),T(yt.$$.fragment,e),T(Ut.$$.fragment,e),T(gt.$$.fragment,e),T(Zt.$$.fragment,e),T(St.$$.fragment,e),T(Rt.$$.fragment,e),T(Dt.$$.fragment,e),T(el.$$.fragment,e),T(Z.$$.fragment,e),T(pl.$$.fragment,e),T(dl.$$.fragment,e),T(fl.$$.fragment,e),T(ml.$$.fragment,e),T(ul.$$.fragment,e),T(wl.$$.fragment,e),T(Jl.$$.fragment,e),T(jl.$$.fragment,e),T(bl.$$.fragment,e),T(Cl.$$.fragment,e),Pa=!1},d(e){e&&(l(I),l(w),l(y),l(b),l(U),l(El),l(Xl),l(V),l(Rl),l(P),l(Nl),l(S),l(kl),l(E),l(Gl),l(Fl),l(X),l(Wl),l(Yl),l(N),l(Dl),l(zl),l(G),l(Ql),l(ql),l(W),l(Ol),l(Kl),l(D),l(es),l(ts),l(Q),l(ls),l(ss),l(O),l(ns),l(K),l(as),l(ee),l(ps),l(te),l(is),l(le),l(rs),l(cs),l(ne),l(ds),l(ae),l(Ms),l(pe),l(os),l(ie),l(Ts),l(re),l(fs),l(ce),l(ms),l(us),l(Me),l(ws),l(Js),l(Te),l(js),l(hs),l(me),l(_s),l(ue),l(ys),l(bs),l(Je),l(Is),l(Us),l(he),l($s),l(_e),l(Cs),l(As),l(be),l(vs),l(Ie),l(gs),l(xs),l($e),l(Ls),l(Zs),l(Bs),l(ve),l(Hs),l(ge),l(Vs),l(xe),l(Ps),l(Le),l(Ss),l(Ze),l(Es),l(Be),l(Xs),l(Rs),l(Ve),l(Ns),l(Pe),l(ks),l(Gs),l(Ee),l(Fs),l(Xe),l(Ws),l(Ys),l(Ne),l(Ds),l(zs),l(Ge),l(Qs),l(qs),l(We),l(Os),l(Ye),l(Ks),l(De),l(en),l(ze),l(tn),l(ln),l(L),l(sn),l(nn),l(Oe),l(an),l(Ke),l(pn),l(rn),l(tt),l(cn),l(lt),l(dn),l(Mn),l(nt),l(on),l(at),l(Tn),l(pt),l(fn),l(Al),l(mn),l(un),l(rt),l(wn),l(ct),l(Jn),l(dt),l(jn),l(hn),l(ot),l(_n),l(Tt),l(yn),l(bn),l(mt),l(In),l(ut),l(Un),l(wt),l($n),l(Cn),l(jt),l(An),l(vn),l(_t),l(gn),l(xn),l(bt),l(Ln),l(It),l(Zn),l(Bn),l($t),l(Hn),l(Ct),l(Vn),l(At),l(Pn),l(vt),l(Sn),l(En),l(xt),l(Xn),l(Lt),l(Rn),l(Nn),l(Bt),l(kn),l(Ht),l(Gn),l(Vt),l(Fn),l(Pt),l(Wn),l(Yn),l(Et),l(Dn),l(Xt),l(zn),l(Qn),l(Nt),l(qn),l(kt),l(On),l(Gt),l(Kn),l(Ft),l(ea),l(Wt),l(ta),l(Yt),l(la),l(sa),l(zt),l(na),l(Qt),l(aa),l(qt),l(pa),l(Ot),l(ia),l(Kt),l(ra),l(ca),l(tl),l(da),l(Ma),l(ll),l(oa),l(sl),l(Ta),l(nl),l(fa),l(al),l(ma),l(ua),l(il),l(wa),l(rl),l(Ja),l(cl),l(ja),l(ha),l(Ml),l(_a),l(ol),l(ya),l(Tl),l(ba),l(C),l(Ia),l(Ua),l(B),l($a),l(Ca),l(hl),l(Aa),l(_l),l(va),l(yl),l(ga),l(xa),l(Il),l(La),l(Ul),l(Za),l(H),l(Ba),l($l),l(Ha),l(Va),l(Vl)),l(m),f($,e),f(g,e),f(x,e),f(R,e),f(k,e),f(F,e),f(Y,e),f(z,e),f(q,e),f(se,e),f(de,e),f(oe,e),f(fe,e),f(we,e),f(je,e),f(ye,e),f(Ue,e),f(Ce,e),f(Ae,e),f(He,e),f(Se,e),f(Re,e),f(ke,e),f(Fe,e),f(Qe,e),f(qe,e),f(et,e),f(st,e),f(it,e),f(Mt,e),f(ft,e),f(Jt,e),f(ht,e),f(yt,e),f(Ut,e),f(gt,e),f(Zt,e),f(St,e),f(Rt,e),f(Dt,e),f(el,e),f(Z,e),f(pl,e),f(dl,e),f(fl),f(ml),f(ul),f(wl),f(Jl,e),f(jl,e),f(bl,e),f(Cl,e)}}}const ur='{"title":"Trainer","local":"trainer","sections":[{"title":"Trainer","local":"trainer","sections":[],"depth":2},{"title":"Seq2SeqTrainer","local":"seq2seqtrainer","sections":[],"depth":2},{"title":"TrainingArguments","local":"trainingarguments","sections":[],"depth":2},{"title":"Seq2SeqTrainingArguments","local":"seq2seqtrainingarguments","sections":[],"depth":2},{"title":"Checkpoints","local":"checkpoints","sections":[],"depth":2},{"title":"Logging","local":"logging","sections":[],"depth":2},{"title":"随机性","local":"随机性","sections":[],"depth":2},{"title":"特定GPU选择","local":"特定gpu选择","sections":[],"depth":2},{"title":"Trainer集成","local":"trainer集成","sections":[{"title":"CUDA拓展安装注意事项","local":"cuda拓展安装注意事项","sections":[{"title":"可能的问题 #1","local":"可能的问题-1","sections":[],"depth":4},{"title":"可能的问题 #2","local":"可能的问题-2","sections":[],"depth":4},{"title":"可能的问题 #3","local":"可能的问题-3","sections":[],"depth":4}],"depth":3},{"title":"PyTorch完全分片数据并行（FSDP)","local":"pytorch完全分片数据并行fsdp","sections":[],"depth":3},{"title":"PyTorch/XLA 完全分片数据并行","local":"pytorchxla-完全分片数据并行","sections":[],"depth":3},{"title":"在 Mac 上使用 Trainer 进行加速的 PyTorch 训练","local":"在-mac-上使用-trainer-进行加速的-pytorch-训练","sections":[],"depth":3}],"depth":2},{"title":"通过 Accelerate Launcher 使用 Trainer","local":"通过-accelerate-launcher-使用-trainer","sections":[],"depth":2},{"title":"通过 NEFTune 提升微调性能","local":"通过-neftune-提升微调性能","sections":[],"depth":2}],"depth":1}';function wr(v){return ir(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class br extends rr{constructor(m){super(),cr(this,m,wr,mr,pr,{})}}export{br as component};
