import{s as Hl,o as Xl,n as Sl}from"../chunks/scheduler.65852ee5.js";import{S as Yl,i as Ll,g as i,s as n,r,A as Fl,h as o,f as l,c as a,j as Ql,u as M,x as p,k as zl,l as Dl,y as Pl,a as s,v as J,d as c,t as d,w as T}from"../chunks/index.aa74147d.js";import{T as Ol}from"../chunks/Tip.bb8ccac8.js";import{D as Kl,C as w}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as j,E as es}from"../chunks/EditOnGithub.4eda6a96.js";function ts(Re){let u,y="In-memory can only be used for quick-prototyping and tests. It is a Python implementation of the Qdrant server methods.";return{c(){u=i("p"),u.textContent=y},l(m){u=o(m,"P",{"data-svelte-h":!0}),p(u)!=="svelte-1xbb3g2"&&(u.textContent=y)},m(m,Ne){s(m,u,Ne)},p:Sl,d(m){m&&l(u)}}}function ls(Re){let u,y,m,Ne,f,Ge,b,qe,U,ll='<em>Authored by: <a href="https://qdrant.tech/" rel="nofollow">Qdrant Team</a></em>',Ve,g,sl="In this notebook, we demonstrate how you can use vector embeddings to navigate a codebase, and find relevant code snippets. We’ll search codebases using natural semantic queries, and search for code based on a similar logic.",Qe,C,nl='You can check out the <a href="https://code-search.qdrant.tech/" rel="nofollow">live deployment</a> of this approach which exposes the Qdrant codebase for search with a web interface.',ze,x,He,A,al="We need two models to accomplish our goal.",Xe,B,il='<li><p>General usage neural encoder for Natural Language Processing (NLP), in our case <a href="https://huggingface.co/sentence-transformers/all-MiniLM-L6-v2" rel="nofollow">sentence-transformers/all-MiniLM-L6-v2</a>. We’ll call this NLP model.</p></li> <li><p>Specialized embeddings for code-to-code similarity search. We’ll use the <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-code" rel="nofollow">jinaai/jina-embeddings-v2-base-code</a> model for the task. It supports English and 30 widely used programming languages with a 8192 sequence length. Let’s call this code model.</p></li>',Se,_,ol="To prepare our code for the NLP model, we need to preprocess the code to a format that closely resembles natural language. The code model supports a variety of standard programming languages, so there is no need to preprocess the snippets. We can use the code as is.",Ye,$,Le,v,pl="Let’s install the packages we’ll work with.",Fe,k,rl='<li><a href="https://pypi.org/project/inflection/" rel="nofollow">inflection</a> - A string transformation library. It singularizes and pluralizes English words, and transforms CamelCase to underscored string.</li> <li><a href="https://pypi.org/project/fastembed/" rel="nofollow">fastembed</a> - A CPU-first, lightweight library for generating vector embeddings. <a href="https://github.com/qdrant/fastembed#%EF%B8%8F-fastembed-on-a-gpu" rel="nofollow">GPU support is available</a>.</li> <li><a href="https://pypi.org/project/qdrant-client/" rel="nofollow">qdrant-client</a> - Official Python library to interface with the Qdrant server.</li>',De,Z,Pe,E,Oe,N,Ml="Chunking the application sources into smaller parts is a non-trivial task. In general, functions, class methods, structs, enums, and all the other language-specific constructs are good candidates for chunks. They are big enough to contain some meaningful information, but small enough to be processed by embedding models with a limited context window. You can also use docstrings, comments, and other metadata can be used to enrich the chunks with additional information.",Ke,h,Jl='<img src="https://huggingface.co/datasets/Anush008/cookbook-images/resolve/main/data-chunking.png"/>',et,W,cl="Text-based search is based on function signatures, but code search may return smaller pieces, such as loops. So, if we receive a particular function signature from the NLP model and part of its implementation from the code model, we merge the results.",tt,R,lt,G,dl=`We’ll use the <a href="https://github.com/qdrant/qdrant" rel="nofollow">Qdrant codebase</a> for this demo.
While this codebase uses Rust, you can use this approach with any other language. You can use an <a href="https://microsoft.github.io/language-server-protocol/" rel="nofollow">Language Server Protocol (LSP)</a> tool to build a graph of the codebase, and then extract chunks. We did our work with the <a href="https://rust-analyzer.github.io/" rel="nofollow">rust-analyzer</a>. We exported the parsed codebase into the <a href="https://microsoft.github.io/language-server-protocol/specifications/lsif/0.4.0/specification/" rel="nofollow">LSIF</a> format, a standard for code intelligence data. Next, we used the LSIF data to navigate the codebase and extract the chunks.`,st,q,Tl='You can use the same approach for other languages. There are <a href="https://microsoft.github.io/language-server-protocol/implementors/servers/" rel="nofollow">plenty of implementations</a> available.',nt,V,ul="We will then export the chunks into JSON documents with not only the code itself, but also context with the location of the code in the project.",at,Q,wl='You can examine the Qdrant structures, parsed in JSON, in the <a href="https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl" rel="nofollow">structures.jsonl file</a> in our Google Cloud Storage bucket. Download it and use it as a source of data for our code search.',it,z,ot,H,ml="Next, load the file and parse the lines into a list of dictionaries:",pt,X,rt,S,jl="Let’s see how one entry looks like.",Mt,Y,Jt,L,ct,F,hl="Each programming language has its own syntax which is not a part of the natural language. Thus, a general-purpose model probably does not understand the code as is. We can, however, normalize the data by removing code specifics and including additional context, such as module, class, function, and file name. We take the following steps:",dt,D,Il="<li>Extract the signature of the function, method, or other code construct.</li> <li>Divide camel case and snake case names into separate words.</li> <li>Take the docstring, comments, and other important metadata.</li> <li>Build a sentence from the extracted data using a predefined template.</li> <li>Remove the special characters and replace them with spaces.</li>",Tt,P,yl="We can now define the <code>textify</code> function that uses the <code>inflection</code> library to carry out our conversions:",ut,O,wt,K,fl="Now we can use <code>textify</code> to convert all chunks into text representations:",mt,ee,jt,te,bl="Let’s see how one of our representations looks like:",ht,le,It,se,yt,ne,ft,ae,bt,ie,Ut,oe,gt,pe,Ul='Qdrant supports multiple modes of deployment. Including in-memory for prototyping, Docker and Qdrant Cloud. You can refer to the <a href="https://qdrant.tech/documentation/guides/installation/" rel="nofollow">installation instructions</a> for more information.',Ct,re,gl="We’ll continue the tutorial using an in-memory instance.",xt,I,At,Me,Cl="Let’s create a collection to store our vectors.",Bt,Je,_t,ce,xl="Our newly created collection is ready to accept the data. Let’s upload the embeddings:",$t,de,vt,Te,Al="The uploaded points are immediately available for search. Next, query the collection to find relevant code snippets.",kt,ue,Zt,we,Bl='We use one of the models to search the collection via Qdrant’s new <a href="https://qdrant.tech/blog/qdrant-1.10.x/" rel="nofollow">Query API</a>. Start with text embeddings. Run the following query “How do I count points in a collection?”. Review the results.',Et,me,Nt,je,_l=`Now, review the results. The following table lists the module, the file name
and score. Each line includes a link to the signature.`,Wt,he,$l='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>operations</td> <td>types.rs</td> <td>0.5493385</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/collection/src/operations/types.rs#L794" rel="nofollow"><code>pub struct CountRequestInternal</code></a></td></tr> <tr><td>map_index</td> <td>types.rs</td> <td>0.49973965</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mod.rs#L89" rel="nofollow"><code>fn get_points_with_value_count</code></a></td></tr> <tr><td>map_index</td> <td>mutable_map_index.rs</td> <td>0.49941066</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/map_index/mutable_map_index.rs#L143" rel="nofollow"><code>pub fn get_points_with_value_count</code></a></td></tr></tbody>',Rt,Ie,vl="It seems we were able to find some relevant code structures. Let’s try the same with the code embeddings:",Gt,ye,qt,fe,kl="Output:",Vt,be,Zl='<thead><tr><th>module</th> <th>file_name</th> <th>score</th> <th>signature</th></tr></thead> <tbody><tr><td>field_index</td> <td>geo_index.rs</td> <td>0.7217579</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/geo_index/mod.rs#L319" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>numeric_index</td> <td>mod.rs</td> <td>0.7113214</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/numeric_index/mod.rs#L317" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr> <tr><td>full_text_index</td> <td>text_index.rs</td> <td>0.6993165</td> <td><a href="https://github.com/qdrant/qdrant/blob/4aac02315bb3ca461a29484094cf6d19025fce99/lib/segment/src/index/field_index/full_text_index/text_index.rs#L179" rel="nofollow"><code>fn count_indexed_points</code></a></td></tr></tbody>',Qt,Ue,El=`While the scores retrieved by different models are not comparable, but we can
see that the results are different. Code and text embeddings can capture
different aspects of the codebase. We can use both models to query the collection
and then combine the results to get the most relevant code snippets.`,zt,ge,Ht,Ce,Xt,xe,Nl='|  operations  |  lib/collection/src/operations/types.rs  |  0.5  | ` # [doc = " Count Request"] # [doc = " Counts the number of points which satisfy the given filter."] # [doc = " If filter is not provided, the count of all points in the collection will be returned."] # [derive (Debug , Deserialize , Serialize , JsonSchema , Validate)] # [serde (rename_all = "snake_case")] pub struct CountRequestInternal &#123; # [doc = " Look only for points which satisfies this conditions"] # [validate] pub filter : Option < Filter > , # [doc = " If true, count exact number of points. If false, count approximate number of points faster."] # [doc = " Approximate count might be unreliable during the indexing process. Default: true"] # [serde (default = "default_exact_count")] pub exact : bool , } ` |\n|  field_index  |  lib/segment/src/index/field_index/geo_index.rs  |  0.5  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.33333334  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  numeric_index  |  lib/segment/src/index/field_index/numeric_index/mod.rs  |  0.33333334  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  lib/segment/src/fixtures/payload_context_fixture.rs  |  0.25  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mutable_map_index.rs  |  0.25  | ` fn get_points_with_value_count < Q > (& self , value : & Q) -> Option < usize > where Q : ? Sized , N : std :: borrow :: Borrow < Q > , Q : Hash + Eq , ` |\n|  id_tracker  |  lib/segment/src/id_tracker/simple_id_tracker.rs  |  0.2  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.2  | ` fn count_indexed_points (& self) -> usize ` |\n|  map_index  |  lib/segment/src/index/field_index/map_index/mod.rs  |  0.16666667  | ` fn count_indexed_points (& self) -> usize ` |\n|  field_index  |  lib/segment/src/index/field_index/stat_tools.rs  |  0.16666667  | ` fn number_of_selected_points (points : usize , values : usize) -> usize ` |\n',St,Ae,Wl=`This is one example of how you can fuse the results from different models.
In a real-world scenario, you might run some reranking and deduplication, as well as additional processing of the results.`,Yt,Be,Lt,_e,Rl=`You can improve the search results, by grouping them by payload properties.
In our case, we can group the results by the module. If we use code embeddings,
we can see multiple results from the <code>map_index</code> module. Let’s group the
results and assume a single result per module:`,Ft,$e,Dt,ve,Pt,ke,Gl="|  field_index  |  geo_index.rs  |  0.7217579  | ` fn count_indexed_points (& self) -> usize ` |\n|  numeric_index  |  mod.rs  |  0.7113214  | ` fn count_indexed_points (& self) -> usize ` |\n|  fixtures  |  payload_context_fixture.rs  |  0.6993165  | ` fn total_point_count (& self) -> usize ` |\n|  map_index  |  mod.rs  |  0.68385994  | ` fn count_indexed_points (& self) -> usize ` |\n|  full_text_index  |  text_index.rs  |  0.6660142  | ` fn count_indexed_points (& self) -> usize ` |\n",Ot,Ze,ql='That concludes our tutorial. Thanks for taking the time to get here. We’ve just begun exploring what’s possible with vector embeddings and how to improve it. Feel free to experiment your way; you could build something very cool! Do share it with us 🙏 We are <a href="https://qdrant.tech/contact-us/" rel="nofollow">here</a>.',Kt,Ee,el,We,tl;return f=new Kl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/code_search.ipynb"}]}}),b=new j({props:{title:"Code Search with Vector Embeddings and Qdrant",local:"code-search-with-vector-embeddings-and-qdrant",headingTag:"h2"}}),x=new j({props:{title:"The approach",local:"the-approach",headingTag:"h3"}}),$=new j({props:{title:"Installing Dependencies",local:"installing-dependencies",headingTag:"h2"}}),Z=new w({props:{code:"JTI1cGlwJTIwaW5zdGFsbCUyMGluZmxlY3Rpb24lMjBxZHJhbnQtY2xpZW50JTIwZmFzdGVtYmVk",highlighted:"%pip install inflection qdrant-client fastembed",wrap:!1}}),E=new j({props:{title:"Data preparation",local:"data-preparation",headingTag:"h3"}}),R=new j({props:{title:"Parsing the Codebaase",local:"parsing-the-codebaase",headingTag:"h3"}}),z=new w({props:{code:"IXdnZXQlMjBodHRwcyUzQSUyRiUyRnN0b3JhZ2UuZ29vZ2xlYXBpcy5jb20lMkZ0dXRvcmlhbC1hdHRhY2htZW50cyUyRmNvZGUtc2VhcmNoJTJGc3RydWN0dXJlcy5qc29ubA==",highlighted:"!wget https://storage.googleapis.com/tutorial-attachments/code-search/structures.jsonl",wrap:!1}}),X=new w({props:{code:"aW1wb3J0JTIwanNvbiUwQSUwQXN0cnVjdHVyZXMlMjAlM0QlMjAlNUIlNUQlMEF3aXRoJTIwb3BlbiglMjJzdHJ1Y3R1cmVzLmpzb25sJTIyJTJDJTIwJTIyciUyMiklMjBhcyUyMGZwJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaSUyQyUyMHJvdyUyMGluJTIwZW51bWVyYXRlKGZwKSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGVudHJ5JTIwJTNEJTIwanNvbi5sb2Fkcyhyb3cpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc3RydWN0dXJlcy5hcHBlbmQoZW50cnkp",highlighted:`<span class="hljs-keyword">import</span> json

structures = []
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;structures.jsonl&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> fp:
    <span class="hljs-keyword">for</span> i, row <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(fp):
        entry = json.loads(row)
        structures.append(entry)`,wrap:!1}}),Y=new w({props:{code:"c3RydWN0dXJlcyU1QjAlNUQ=",highlighted:'structures[<span class="hljs-number">0</span>]',wrap:!1}}),L=new j({props:{title:"Code to natural language conversion",local:"code-to-natural-language-conversion",headingTag:"h3"}}),O=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> inflection
<span class="hljs-keyword">import</span> re

<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Dict</span>, <span class="hljs-type">Any</span>


<span class="hljs-keyword">def</span> <span class="hljs-title function_">textify</span>(<span class="hljs-params">chunk: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Any</span>]</span>) -&gt; <span class="hljs-built_in">str</span>:
    <span class="hljs-comment"># Get rid of all the camel case / snake case</span>
    <span class="hljs-comment"># - inflection.underscore changes the camel case to snake case</span>
    <span class="hljs-comment"># - inflection.humanize converts the snake case to human readable form</span>
    name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;name&quot;</span>]))
    signature = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;signature&quot;</span>]))

    <span class="hljs-comment"># Check if docstring is provided</span>
    docstring = <span class="hljs-string">&quot;&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;docstring&quot;</span>]:
        docstring = <span class="hljs-string">f&quot;that does <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;docstring&#x27;</span>]}</span> &quot;</span>

    <span class="hljs-comment"># Extract the location of that snippet of code</span>
    context = <span class="hljs-string">f&quot;module <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;module&#x27;</span>]}</span> &quot;</span> <span class="hljs-string">f&quot;file <span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;context&#x27;</span>][<span class="hljs-string">&#x27;file_name&#x27;</span>]}</span>&quot;</span>
    <span class="hljs-keyword">if</span> chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]:
        struct_name = inflection.humanize(inflection.underscore(chunk[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;struct_name&quot;</span>]))
        context = <span class="hljs-string">f&quot;defined in struct <span class="hljs-subst">{struct_name}</span> <span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Combine all the bits and pieces together</span>
    text_representation = <span class="hljs-string">f&quot;<span class="hljs-subst">{chunk[<span class="hljs-string">&#x27;code_type&#x27;</span>]}</span> <span class="hljs-subst">{name}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{docstring}</span>&quot;</span> <span class="hljs-string">f&quot;defined as <span class="hljs-subst">{signature}</span> &quot;</span> <span class="hljs-string">f&quot;<span class="hljs-subst">{context}</span>&quot;</span>

    <span class="hljs-comment"># Remove any special characters and concatenate the tokens</span>
    tokens = re.split(<span class="hljs-string">r&quot;\\W&quot;</span>, text_representation)
    tokens = <span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> x: x, tokens)
    <span class="hljs-keyword">return</span> <span class="hljs-string">&quot; &quot;</span>.join(tokens)`,wrap:!1}}),ee=new w({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlMjAlM0QlMjBsaXN0KG1hcCh0ZXh0aWZ5JTJDJTIwc3RydWN0dXJlcykp",highlighted:'text_representations = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">map</span>(textify, structures))',wrap:!1}}),le=new w({props:{code:"dGV4dF9yZXByZXNlbnRhdGlvbnMlNUIxMDAwJTVE",highlighted:'text_representations[<span class="hljs-number">1000</span>]',wrap:!1}}),se=new j({props:{title:"Natural language embeddings",local:"natural-language-embeddings",headingTag:"h3"}}),ne=new w({props:{code:"ZnJvbSUyMGZhc3RlbWJlZCUyMGltcG9ydCUyMFRleHRFbWJlZGRpbmclMEElMEFiYXRjaF9zaXplJTIwJTNEJTIwNSUwQSUwQW5scF9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyc2VudGVuY2UtdHJhbnNmb3JtZXJzJTJGYWxsLU1pbmlMTS1MNi12MiUyMiUyQyUyMHRocmVhZHMlM0QwKSUwQW5scF9lbWJlZGRpbmdzJTIwJTNEJTIwbmxwX21vZGVsLmVtYmVkKHRleHRfcmVwcmVzZW50YXRpb25zJTJDJTIwYmF0Y2hfc2l6ZSUzRGJhdGNoX3NpemUp",highlighted:`<span class="hljs-keyword">from</span> fastembed <span class="hljs-keyword">import</span> TextEmbedding

batch_size = <span class="hljs-number">5</span>

nlp_model = TextEmbedding(<span class="hljs-string">&quot;sentence-transformers/all-MiniLM-L6-v2&quot;</span>, threads=<span class="hljs-number">0</span>)
nlp_embeddings = nlp_model.embed(text_representations, batch_size=batch_size)`,wrap:!1}}),ae=new j({props:{title:"Code Embeddings",local:"code-embeddings",headingTag:"h3"}}),ie=new w({props:{code:"Y29kZV9zbmlwcGV0cyUyMCUzRCUyMCU1QnN0cnVjdHVyZSU1QiUyMmNvbnRleHQlMjIlNUQlNUIlMjJzbmlwcGV0JTIyJTVEJTIwZm9yJTIwc3RydWN0dXJlJTIwaW4lMjBzdHJ1Y3R1cmVzJTVEJTBBJTBBY29kZV9tb2RlbCUyMCUzRCUyMFRleHRFbWJlZGRpbmcoJTIyamluYWFpJTJGamluYS1lbWJlZGRpbmdzLXYyLWJhc2UtY29kZSUyMiklMEElMEFjb2RlX2VtYmVkZGluZ3MlMjAlM0QlMjBjb2RlX21vZGVsLmVtYmVkKGNvZGVfc25pcHBldHMlMkMlMjBiYXRjaF9zaXplJTNEYmF0Y2hfc2l6ZSk=",highlighted:`code_snippets = [structure[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;snippet&quot;</span>] <span class="hljs-keyword">for</span> structure <span class="hljs-keyword">in</span> structures]

code_model = TextEmbedding(<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-code&quot;</span>)

code_embeddings = code_model.embed(code_snippets, batch_size=batch_size)`,wrap:!1}}),oe=new j({props:{title:"Building Qdrant collection",local:"building-qdrant-collection",headingTag:"h3"}}),I=new Ol({props:{warning:!1,$$slots:{default:[ts]},$$scope:{ctx:Re}}}),Je=new w({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBRZHJhbnRDbGllbnQlMkMlMjBtb2RlbHMlMEElMEFDT0xMRUNUSU9OX05BTUUlMjAlM0QlMjAlMjJxZHJhbnQtc291cmNlcyUyMiUwQSUwQWNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjIlM0FtZW1vcnklM0ElMjIpJTIwJTIwJTIzJTIwVXNlJTIwaW4tbWVtb3J5JTIwc3RvcmFnZSUwQSUyMyUyMGNsaWVudCUyMCUzRCUyMFFkcmFudENsaWVudCglMjJodHRwJTNBJTJGJTJGbG9jYWhvc3QlM0E2MzMzJTIyKSUyMCUyMCUyMyUyMEZvciUyMFFkcmFudCUyMHNlcnZlciUwQSUwQWNsaWVudC5jcmVhdGVfY29sbGVjdGlvbiglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjB2ZWN0b3JzX2NvbmZpZyUzRCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRleHQlMjIlM0ElMjBtb2RlbHMuVmVjdG9yUGFyYW1zKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHNpemUlM0QzODQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBkaXN0YW5jZSUzRG1vZGVscy5EaXN0YW5jZS5DT1NJTkUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMG1vZGVscy5WZWN0b3JQYXJhbXMoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2l6ZSUzRDc2OCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRpc3RhbmNlJTNEbW9kZWxzLkRpc3RhbmNlLkNPU0lORSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEEp",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> QdrantClient, models

COLLECTION_NAME = <span class="hljs-string">&quot;qdrant-sources&quot;</span>

client = QdrantClient(<span class="hljs-string">&quot;:memory:&quot;</span>)  <span class="hljs-comment"># Use in-memory storage</span>
<span class="hljs-comment"># client = QdrantClient(&quot;http://locahost:6333&quot;)  # For Qdrant server</span>

client.create_collection(
    COLLECTION_NAME,
    vectors_config={
        <span class="hljs-string">&quot;text&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">384</span>,
            distance=models.Distance.COSINE,
        ),
        <span class="hljs-string">&quot;code&quot;</span>: models.VectorParams(
            size=<span class="hljs-number">768</span>,
            distance=models.Distance.COSINE,
        ),
    },
)`,wrap:!1}}),de=new w({props:{code:"ZnJvbSUyMHRxZG0lMjBpbXBvcnQlMjB0cWRtJTBBJTBBcG9pbnRzJTIwJTNEJTIwJTVCJTVEJTBBdG90YWwlMjAlM0QlMjBsZW4oc3RydWN0dXJlcyklMEFwcmludCglMjJOdW1iZXIlMjBvZiUyMHBvaW50cyUyMHRvJTIwdXBsb2FkJTNBJTIwJTIyJTJDJTIwdG90YWwpJTBBJTBBZm9yJTIwaWQlMkMlMjAodGV4dF9lbWJlZGRpbmclMkMlMjBjb2RlX2VtYmVkZGluZyUyQyUyMHN0cnVjdHVyZSklMjBpbiUyMHRxZG0oJTBBJTIwJTIwJTIwJTIwZW51bWVyYXRlKHppcChubHBfZW1iZWRkaW5ncyUyQyUyMGNvZGVfZW1iZWRkaW5ncyUyQyUyMHN0cnVjdHVyZXMpKSUyQyUyMHRvdGFsJTNEdG90YWwlMEEpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwRmFzdEVtYmVkJTIwcmV0dXJucyUyMGdlbmVyYXRvcnMuJTIwRW1iZWRkaW5ncyUyMGFyZSUyMGNvbXB1dGVkJTIwYXMlMjBjb25zdW1lZC4lMEElMjAlMjAlMjAlMjBwb2ludHMuYXBwZW5kKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5Qb2ludFN0cnVjdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpZCUzRGlkJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwdmVjdG9yJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydGV4dCUyMiUzQSUyMHRleHRfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyY29kZSUyMiUzQSUyMGNvZGVfZW1iZWRkaW5nJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcGF5bG9hZCUzRHN0cnVjdHVyZSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjApJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXBsb2FkJTIwcG9pbnRzJTIwaW4lMjBiYXRjaGVzJTBBJTIwJTIwJTIwJTIwaWYlMjBsZW4ocG9pbnRzKSUyMCUzRSUzRCUyMGJhdGNoX3NpemUlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjbGllbnQudXBsb2FkX3BvaW50cyhDT0xMRUNUSU9OX05BTUUlMkMlMjBwb2ludHMlM0Rwb2ludHMlMkMlMjB3YWl0JTNEVHJ1ZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBwb2ludHMlMjAlM0QlMjAlNUIlNUQlMEElMEElMjMlMjBFbnN1cmUlMjBhbnklMjByZW1haW5pbmclMjBwb2ludHMlMjBhcmUlMjB1cGxvYWRlZCUwQWlmJTIwcG9pbnRzJTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnVwbG9hZF9wb2ludHMoQ09MTEVDVElPTl9OQU1FJTJDJTIwcG9pbnRzJTNEcG9pbnRzKSUwQSUwQXByaW50KGYlMjJUb3RhbCUyMHBvaW50cyUyMGluJTIwY29sbGVjdGlvbiUzQSUyMCU3QmNsaWVudC5jb3VudChDT0xMRUNUSU9OX05BTUUpLmNvdW50JTdEJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> tqdm <span class="hljs-keyword">import</span> tqdm

points = []
total = <span class="hljs-built_in">len</span>(structures)
<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Number of points to upload: &quot;</span>, total)

<span class="hljs-keyword">for</span> <span class="hljs-built_in">id</span>, (text_embedding, code_embedding, structure) <span class="hljs-keyword">in</span> tqdm(
    <span class="hljs-built_in">enumerate</span>(<span class="hljs-built_in">zip</span>(nlp_embeddings, code_embeddings, structures)), total=total
):
    <span class="hljs-comment"># FastEmbed returns generators. Embeddings are computed as consumed.</span>
    points.append(
        models.PointStruct(
            <span class="hljs-built_in">id</span>=<span class="hljs-built_in">id</span>,
            vector={
                <span class="hljs-string">&quot;text&quot;</span>: text_embedding,
                <span class="hljs-string">&quot;code&quot;</span>: code_embedding,
            },
            payload=structure,
        )
    )

    <span class="hljs-comment"># Upload points in batches</span>
    <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(points) &gt;= batch_size:
        client.upload_points(COLLECTION_NAME, points=points, wait=<span class="hljs-literal">True</span>)
        points = []

<span class="hljs-comment"># Ensure any remaining points are uploaded</span>
<span class="hljs-keyword">if</span> points:
    client.upload_points(COLLECTION_NAME, points=points)

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Total points in collection: <span class="hljs-subst">{client.count(COLLECTION_NAME).count}</span>&quot;</span>)`,wrap:!1}}),ue=new j({props:{title:"Querying the codebase",local:"querying-the-codebase",headingTag:"h3"}}),me=new w({props:{code:"cXVlcnklMjAlM0QlMjAlMjJIb3clMjBkbyUyMEklMjBjb3VudCUyMHBvaW50cyUyMGluJTIwYSUyMGNvbGxlY3Rpb24lM0YlMjIlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjBsaW1pdCUzRDMlMkMlMEEpLnBvaW50cw==",highlighted:`query = <span class="hljs-string">&quot;How do I count points in a collection?&quot;</span>

hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;text&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),ye=new w({props:{code:"aGl0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHMoJTBBJTIwJTIwJTIwJTIwQ09MTEVDVElPTl9OQU1FJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0RuZXh0KGNvZGVfbW9kZWwucXVlcnlfZW1iZWQocXVlcnkpKS50b2xpc3QoKSUyQyUwQSUyMCUyMCUyMCUyMHVzaW5nJTNEJTIyY29kZSUyMiUyQyUwQSUyMCUyMCUyMCUyMGxpbWl0JTNEMyUyQyUwQSkucG9pbnRz",highlighted:`hits = client.query_points(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    limit=<span class="hljs-number">3</span>,
).points`,wrap:!1}}),ge=new w({props:{code:"ZnJvbSUyMHFkcmFudF9jbGllbnQlMjBpbXBvcnQlMjBtb2RlbHMlMEElMEFoaXRzJTIwJTNEJTIwY2xpZW50LnF1ZXJ5X3BvaW50cyglMEElMjAlMjAlMjAlMjBjb2xsZWN0aW9uX25hbWUlM0RDT0xMRUNUSU9OX05BTUUlMkMlMEElMjAlMjAlMjAlMjBwcmVmZXRjaCUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVscy5QcmVmZXRjaCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBxdWVyeSUzRG5leHQobmxwX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMnRleHQlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWxzLlByZWZldGNoKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBsaW1pdCUzRDUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjApJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwcXVlcnklM0Rtb2RlbHMuRnVzaW9uUXVlcnkoZnVzaW9uJTNEbW9kZWxzLkZ1c2lvbi5SUkYpJTJDJTBBKS5wb2ludHM=",highlighted:`<span class="hljs-keyword">from</span> qdrant_client <span class="hljs-keyword">import</span> models

hits = client.query_points(
    collection_name=COLLECTION_NAME,
    prefetch=[
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(nlp_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;text&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
        models.Prefetch(
            query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
            using=<span class="hljs-string">&quot;code&quot;</span>,
            limit=<span class="hljs-number">5</span>,
        ),
    ],
    query=models.FusionQuery(fusion=models.Fusion.RRF),
).points`,wrap:!1}}),Ce=new w({props:{code:"Zm9yJTIwaGl0JTIwaW4lMjBoaXRzJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9wYXRoJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> hits:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_path&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>        hit.score,
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>        hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>        <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>    )`,wrap:!1}}),Be=new j({props:{title:"Grouping the results",local:"grouping-the-results",headingTag:"h3"}}),$e=new w({props:{code:"cmVzdWx0cyUyMCUzRCUyMGNsaWVudC5xdWVyeV9wb2ludHNfZ3JvdXBzKCUwQSUyMCUyMCUyMCUyMENPTExFQ1RJT05fTkFNRSUyQyUwQSUyMCUyMCUyMCUyMHF1ZXJ5JTNEbmV4dChjb2RlX21vZGVsLnF1ZXJ5X2VtYmVkKHF1ZXJ5KSkudG9saXN0KCklMkMlMEElMjAlMjAlMjAlMjB1c2luZyUzRCUyMmNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBncm91cF9ieSUzRCUyMmNvbnRleHQubW9kdWxlJTIyJTJDJTBBJTIwJTIwJTIwJTIwbGltaXQlM0Q1JTJDJTBBJTIwJTIwJTIwJTIwZ3JvdXBfc2l6ZSUzRDElMkMlMEEp",highlighted:`results = client.query_points_groups(
    COLLECTION_NAME,
    query=<span class="hljs-built_in">next</span>(code_model.query_embed(query)).tolist(),
    using=<span class="hljs-string">&quot;code&quot;</span>,
    group_by=<span class="hljs-string">&quot;context.module&quot;</span>,
    limit=<span class="hljs-number">5</span>,
    group_size=<span class="hljs-number">1</span>,
)`,wrap:!1}}),ve=new w({props:{code:"Zm9yJTIwZ3JvdXAlMjBpbiUyMHJlc3VsdHMuZ3JvdXBzJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwaGl0JTIwaW4lMjBncm91cC5oaXRzJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJpbnQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIybW9kdWxlJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJjb250ZXh0JTIyJTVEJTVCJTIyZmlsZV9uYW1lJTIyJTVEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnNjb3JlJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyJTIwJTdDJTIwJTYwJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwaGl0LnBheWxvYWQlNUIlMjJzaWduYXR1cmUlMjIlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlNjAlMjAlN0MlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> group <span class="hljs-keyword">in</span> results.groups:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> hit <span class="hljs-keyword">in</span> group.hits:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;| &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;module&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;context&quot;</span>][<span class="hljs-string">&quot;file_name&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | &quot;</span>,
<span class="hljs-meta">... </span>            hit.score,
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot; | \`&quot;</span>,
<span class="hljs-meta">... </span>            hit.payload[<span class="hljs-string">&quot;signature&quot;</span>],
<span class="hljs-meta">... </span>            <span class="hljs-string">&quot;\` |&quot;</span>,
<span class="hljs-meta">... </span>        )`,wrap:!1}}),Ee=new es({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/code_search.md"}}),{c(){u=i("meta"),y=n(),m=i("p"),Ne=n(),r(f.$$.fragment),Ge=n(),r(b.$$.fragment),qe=n(),U=i("p"),U.innerHTML=ll,Ve=n(),g=i("p"),g.textContent=sl,Qe=n(),C=i("p"),C.innerHTML=nl,ze=n(),r(x.$$.fragment),He=n(),A=i("p"),A.textContent=al,Xe=n(),B=i("ul"),B.innerHTML=il,Se=n(),_=i("p"),_.textContent=ol,Ye=n(),r($.$$.fragment),Le=n(),v=i("p"),v.textContent=pl,Fe=n(),k=i("ul"),k.innerHTML=rl,De=n(),r(Z.$$.fragment),Pe=n(),r(E.$$.fragment),Oe=n(),N=i("p"),N.textContent=Ml,Ke=n(),h=i("div"),h.innerHTML=Jl,et=n(),W=i("p"),W.textContent=cl,tt=n(),r(R.$$.fragment),lt=n(),G=i("p"),G.innerHTML=dl,st=n(),q=i("p"),q.innerHTML=Tl,nt=n(),V=i("p"),V.textContent=ul,at=n(),Q=i("p"),Q.innerHTML=wl,it=n(),r(z.$$.fragment),ot=n(),H=i("p"),H.textContent=ml,pt=n(),r(X.$$.fragment),rt=n(),S=i("p"),S.textContent=jl,Mt=n(),r(Y.$$.fragment),Jt=n(),r(L.$$.fragment),ct=n(),F=i("p"),F.textContent=hl,dt=n(),D=i("ol"),D.innerHTML=Il,Tt=n(),P=i("p"),P.innerHTML=yl,ut=n(),r(O.$$.fragment),wt=n(),K=i("p"),K.innerHTML=fl,mt=n(),r(ee.$$.fragment),jt=n(),te=i("p"),te.textContent=bl,ht=n(),r(le.$$.fragment),It=n(),r(se.$$.fragment),yt=n(),r(ne.$$.fragment),ft=n(),r(ae.$$.fragment),bt=n(),r(ie.$$.fragment),Ut=n(),r(oe.$$.fragment),gt=n(),pe=i("p"),pe.innerHTML=Ul,Ct=n(),re=i("p"),re.textContent=gl,xt=n(),r(I.$$.fragment),At=n(),Me=i("p"),Me.textContent=Cl,Bt=n(),r(Je.$$.fragment),_t=n(),ce=i("p"),ce.textContent=xl,$t=n(),r(de.$$.fragment),vt=n(),Te=i("p"),Te.textContent=Al,kt=n(),r(ue.$$.fragment),Zt=n(),we=i("p"),we.innerHTML=Bl,Et=n(),r(me.$$.fragment),Nt=n(),je=i("p"),je.textContent=_l,Wt=n(),he=i("table"),he.innerHTML=$l,Rt=n(),Ie=i("p"),Ie.textContent=vl,Gt=n(),r(ye.$$.fragment),qt=n(),fe=i("p"),fe.textContent=kl,Vt=n(),be=i("table"),be.innerHTML=Zl,Qt=n(),Ue=i("p"),Ue.textContent=El,zt=n(),r(ge.$$.fragment),Ht=n(),r(Ce.$$.fragment),Xt=n(),xe=i("pre"),xe.textContent=Nl,St=n(),Ae=i("p"),Ae.textContent=Wl,Yt=n(),r(Be.$$.fragment),Lt=n(),_e=i("p"),_e.innerHTML=Rl,Ft=n(),r($e.$$.fragment),Dt=n(),r(ve.$$.fragment),Pt=n(),ke=i("pre"),ke.textContent=Gl,Ot=n(),Ze=i("p"),Ze.innerHTML=ql,Kt=n(),r(Ee.$$.fragment),el=n(),We=i("p"),this.h()},l(e){const t=Fl("svelte-u9bgzb",document.head);u=o(t,"META",{name:!0,content:!0}),t.forEach(l),y=a(e),m=o(e,"P",{}),Ql(m).forEach(l),Ne=a(e),M(f.$$.fragment,e),Ge=a(e),M(b.$$.fragment,e),qe=a(e),U=o(e,"P",{"data-svelte-h":!0}),p(U)!=="svelte-17bl742"&&(U.innerHTML=ll),Ve=a(e),g=o(e,"P",{"data-svelte-h":!0}),p(g)!=="svelte-ae7bkg"&&(g.textContent=sl),Qe=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-kszg01"&&(C.innerHTML=nl),ze=a(e),M(x.$$.fragment,e),He=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-1dvof7"&&(A.textContent=al),Xe=a(e),B=o(e,"UL",{"data-svelte-h":!0}),p(B)!=="svelte-19x5x7t"&&(B.innerHTML=il),Se=a(e),_=o(e,"P",{"data-svelte-h":!0}),p(_)!=="svelte-d94nr5"&&(_.textContent=ol),Ye=a(e),M($.$$.fragment,e),Le=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-ut59o"&&(v.textContent=pl),Fe=a(e),k=o(e,"UL",{"data-svelte-h":!0}),p(k)!=="svelte-n6syf2"&&(k.innerHTML=rl),De=a(e),M(Z.$$.fragment,e),Pe=a(e),M(E.$$.fragment,e),Oe=a(e),N=o(e,"P",{"data-svelte-h":!0}),p(N)!=="svelte-1g3hp9b"&&(N.textContent=Ml),Ke=a(e),h=o(e,"DIV",{style:!0,"data-svelte-h":!0}),p(h)!=="svelte-aiydin"&&(h.innerHTML=Jl),et=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-k9nbvr"&&(W.textContent=cl),tt=a(e),M(R.$$.fragment,e),lt=a(e),G=o(e,"P",{"data-svelte-h":!0}),p(G)!=="svelte-i8w8vo"&&(G.innerHTML=dl),st=a(e),q=o(e,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1mfzfdl"&&(q.innerHTML=Tl),nt=a(e),V=o(e,"P",{"data-svelte-h":!0}),p(V)!=="svelte-15jgfrp"&&(V.textContent=ul),at=a(e),Q=o(e,"P",{"data-svelte-h":!0}),p(Q)!=="svelte-14cl4i2"&&(Q.innerHTML=wl),it=a(e),M(z.$$.fragment,e),ot=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-6aidpg"&&(H.textContent=ml),pt=a(e),M(X.$$.fragment,e),rt=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-y6ssjb"&&(S.textContent=jl),Mt=a(e),M(Y.$$.fragment,e),Jt=a(e),M(L.$$.fragment,e),ct=a(e),F=o(e,"P",{"data-svelte-h":!0}),p(F)!=="svelte-1oie9o1"&&(F.textContent=hl),dt=a(e),D=o(e,"OL",{"data-svelte-h":!0}),p(D)!=="svelte-xx6zbg"&&(D.innerHTML=Il),Tt=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-1k8bmra"&&(P.innerHTML=yl),ut=a(e),M(O.$$.fragment,e),wt=a(e),K=o(e,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1fo0w5p"&&(K.innerHTML=fl),mt=a(e),M(ee.$$.fragment,e),jt=a(e),te=o(e,"P",{"data-svelte-h":!0}),p(te)!=="svelte-3wwgsm"&&(te.textContent=bl),ht=a(e),M(le.$$.fragment,e),It=a(e),M(se.$$.fragment,e),yt=a(e),M(ne.$$.fragment,e),ft=a(e),M(ae.$$.fragment,e),bt=a(e),M(ie.$$.fragment,e),Ut=a(e),M(oe.$$.fragment,e),gt=a(e),pe=o(e,"P",{"data-svelte-h":!0}),p(pe)!=="svelte-8h1xvl"&&(pe.innerHTML=Ul),Ct=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-5jc3sw"&&(re.textContent=gl),xt=a(e),M(I.$$.fragment,e),At=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-1fvhhbg"&&(Me.textContent=Cl),Bt=a(e),M(Je.$$.fragment,e),_t=a(e),ce=o(e,"P",{"data-svelte-h":!0}),p(ce)!=="svelte-dpehrl"&&(ce.textContent=xl),$t=a(e),M(de.$$.fragment,e),vt=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-3ws99c"&&(Te.textContent=Al),kt=a(e),M(ue.$$.fragment,e),Zt=a(e),we=o(e,"P",{"data-svelte-h":!0}),p(we)!=="svelte-h95ly4"&&(we.innerHTML=Bl),Et=a(e),M(me.$$.fragment,e),Nt=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1yoto9z"&&(je.textContent=_l),Wt=a(e),he=o(e,"TABLE",{"data-svelte-h":!0}),p(he)!=="svelte-129t8ym"&&(he.innerHTML=$l),Rt=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-19cp8rk"&&(Ie.textContent=vl),Gt=a(e),M(ye.$$.fragment,e),qt=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-1wuxk0l"&&(fe.textContent=kl),Vt=a(e),be=o(e,"TABLE",{"data-svelte-h":!0}),p(be)!=="svelte-1d7gdtl"&&(be.innerHTML=Zl),Qt=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-6u9tc7"&&(Ue.textContent=El),zt=a(e),M(ge.$$.fragment,e),Ht=a(e),M(Ce.$$.fragment,e),Xt=a(e),xe=o(e,"PRE",{"data-svelte-h":!0}),p(xe)!=="svelte-k4pkfe"&&(xe.textContent=Nl),St=a(e),Ae=o(e,"P",{"data-svelte-h":!0}),p(Ae)!=="svelte-rfg7y4"&&(Ae.textContent=Wl),Yt=a(e),M(Be.$$.fragment,e),Lt=a(e),_e=o(e,"P",{"data-svelte-h":!0}),p(_e)!=="svelte-t87f2d"&&(_e.innerHTML=Rl),Ft=a(e),M($e.$$.fragment,e),Dt=a(e),M(ve.$$.fragment,e),Pt=a(e),ke=o(e,"PRE",{"data-svelte-h":!0}),p(ke)!=="svelte-jxqdo"&&(ke.textContent=Gl),Ot=a(e),Ze=o(e,"P",{"data-svelte-h":!0}),p(Ze)!=="svelte-1rvelqz"&&(Ze.innerHTML=ql),Kt=a(e),M(Ee.$$.fragment,e),el=a(e),We=o(e,"P",{}),Ql(We).forEach(l),this.h()},h(){zl(u,"name","hf:doc:metadata"),zl(u,"content",ss),Dl(h,"text-align","center")},m(e,t){Pl(document.head,u),s(e,y,t),s(e,m,t),s(e,Ne,t),J(f,e,t),s(e,Ge,t),J(b,e,t),s(e,qe,t),s(e,U,t),s(e,Ve,t),s(e,g,t),s(e,Qe,t),s(e,C,t),s(e,ze,t),J(x,e,t),s(e,He,t),s(e,A,t),s(e,Xe,t),s(e,B,t),s(e,Se,t),s(e,_,t),s(e,Ye,t),J($,e,t),s(e,Le,t),s(e,v,t),s(e,Fe,t),s(e,k,t),s(e,De,t),J(Z,e,t),s(e,Pe,t),J(E,e,t),s(e,Oe,t),s(e,N,t),s(e,Ke,t),s(e,h,t),s(e,et,t),s(e,W,t),s(e,tt,t),J(R,e,t),s(e,lt,t),s(e,G,t),s(e,st,t),s(e,q,t),s(e,nt,t),s(e,V,t),s(e,at,t),s(e,Q,t),s(e,it,t),J(z,e,t),s(e,ot,t),s(e,H,t),s(e,pt,t),J(X,e,t),s(e,rt,t),s(e,S,t),s(e,Mt,t),J(Y,e,t),s(e,Jt,t),J(L,e,t),s(e,ct,t),s(e,F,t),s(e,dt,t),s(e,D,t),s(e,Tt,t),s(e,P,t),s(e,ut,t),J(O,e,t),s(e,wt,t),s(e,K,t),s(e,mt,t),J(ee,e,t),s(e,jt,t),s(e,te,t),s(e,ht,t),J(le,e,t),s(e,It,t),J(se,e,t),s(e,yt,t),J(ne,e,t),s(e,ft,t),J(ae,e,t),s(e,bt,t),J(ie,e,t),s(e,Ut,t),J(oe,e,t),s(e,gt,t),s(e,pe,t),s(e,Ct,t),s(e,re,t),s(e,xt,t),J(I,e,t),s(e,At,t),s(e,Me,t),s(e,Bt,t),J(Je,e,t),s(e,_t,t),s(e,ce,t),s(e,$t,t),J(de,e,t),s(e,vt,t),s(e,Te,t),s(e,kt,t),J(ue,e,t),s(e,Zt,t),s(e,we,t),s(e,Et,t),J(me,e,t),s(e,Nt,t),s(e,je,t),s(e,Wt,t),s(e,he,t),s(e,Rt,t),s(e,Ie,t),s(e,Gt,t),J(ye,e,t),s(e,qt,t),s(e,fe,t),s(e,Vt,t),s(e,be,t),s(e,Qt,t),s(e,Ue,t),s(e,zt,t),J(ge,e,t),s(e,Ht,t),J(Ce,e,t),s(e,Xt,t),s(e,xe,t),s(e,St,t),s(e,Ae,t),s(e,Yt,t),J(Be,e,t),s(e,Lt,t),s(e,_e,t),s(e,Ft,t),J($e,e,t),s(e,Dt,t),J(ve,e,t),s(e,Pt,t),s(e,ke,t),s(e,Ot,t),s(e,Ze,t),s(e,Kt,t),J(Ee,e,t),s(e,el,t),s(e,We,t),tl=!0},p(e,[t]){const Vl={};t&2&&(Vl.$$scope={dirty:t,ctx:e}),I.$set(Vl)},i(e){tl||(c(f.$$.fragment,e),c(b.$$.fragment,e),c(x.$$.fragment,e),c($.$$.fragment,e),c(Z.$$.fragment,e),c(E.$$.fragment,e),c(R.$$.fragment,e),c(z.$$.fragment,e),c(X.$$.fragment,e),c(Y.$$.fragment,e),c(L.$$.fragment,e),c(O.$$.fragment,e),c(ee.$$.fragment,e),c(le.$$.fragment,e),c(se.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),c(oe.$$.fragment,e),c(I.$$.fragment,e),c(Je.$$.fragment,e),c(de.$$.fragment,e),c(ue.$$.fragment,e),c(me.$$.fragment,e),c(ye.$$.fragment,e),c(ge.$$.fragment,e),c(Ce.$$.fragment,e),c(Be.$$.fragment,e),c($e.$$.fragment,e),c(ve.$$.fragment,e),c(Ee.$$.fragment,e),tl=!0)},o(e){d(f.$$.fragment,e),d(b.$$.fragment,e),d(x.$$.fragment,e),d($.$$.fragment,e),d(Z.$$.fragment,e),d(E.$$.fragment,e),d(R.$$.fragment,e),d(z.$$.fragment,e),d(X.$$.fragment,e),d(Y.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d(ee.$$.fragment,e),d(le.$$.fragment,e),d(se.$$.fragment,e),d(ne.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(I.$$.fragment,e),d(Je.$$.fragment,e),d(de.$$.fragment,e),d(ue.$$.fragment,e),d(me.$$.fragment,e),d(ye.$$.fragment,e),d(ge.$$.fragment,e),d(Ce.$$.fragment,e),d(Be.$$.fragment,e),d($e.$$.fragment,e),d(ve.$$.fragment,e),d(Ee.$$.fragment,e),tl=!1},d(e){e&&(l(y),l(m),l(Ne),l(Ge),l(qe),l(U),l(Ve),l(g),l(Qe),l(C),l(ze),l(He),l(A),l(Xe),l(B),l(Se),l(_),l(Ye),l(Le),l(v),l(Fe),l(k),l(De),l(Pe),l(Oe),l(N),l(Ke),l(h),l(et),l(W),l(tt),l(lt),l(G),l(st),l(q),l(nt),l(V),l(at),l(Q),l(it),l(ot),l(H),l(pt),l(rt),l(S),l(Mt),l(Jt),l(ct),l(F),l(dt),l(D),l(Tt),l(P),l(ut),l(wt),l(K),l(mt),l(jt),l(te),l(ht),l(It),l(yt),l(ft),l(bt),l(Ut),l(gt),l(pe),l(Ct),l(re),l(xt),l(At),l(Me),l(Bt),l(_t),l(ce),l($t),l(vt),l(Te),l(kt),l(Zt),l(we),l(Et),l(Nt),l(je),l(Wt),l(he),l(Rt),l(Ie),l(Gt),l(qt),l(fe),l(Vt),l(be),l(Qt),l(Ue),l(zt),l(Ht),l(Xt),l(xe),l(St),l(Ae),l(Yt),l(Lt),l(_e),l(Ft),l(Dt),l(Pt),l(ke),l(Ot),l(Ze),l(Kt),l(el),l(We)),l(u),T(f,e),T(b,e),T(x,e),T($,e),T(Z,e),T(E,e),T(R,e),T(z,e),T(X,e),T(Y,e),T(L,e),T(O,e),T(ee,e),T(le,e),T(se,e),T(ne,e),T(ae,e),T(ie,e),T(oe,e),T(I,e),T(Je,e),T(de,e),T(ue,e),T(me,e),T(ye,e),T(ge,e),T(Ce,e),T(Be,e),T($e,e),T(ve,e),T(Ee,e)}}}const ss='{"title":"Code Search with Vector Embeddings and Qdrant","local":"code-search-with-vector-embeddings-and-qdrant","sections":[{"title":"The approach","local":"the-approach","sections":[],"depth":3}],"depth":2}';function ns(Re){return Xl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ms extends Yl{constructor(u){super(),Ll(this,u,ns,ls,Hl,{})}}export{Ms as component};
