import{s as dt,n as bt,o as It}from"../chunks/scheduler.65852ee5.js";import{S as gt,i as Ct,g as M,s as n,r as i,A as ft,h as p,f as s,c as a,j as wt,u as y,x as o,k as ht,y as At,a as e,v as c,d as j,t as r,w as u}from"../chunks/index.aa74147d.js";import{D as Bt,C as J}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as Ll,E as qt}from"../chunks/EditOnGithub.4eda6a96.js";function Wt(zl){let U,al,el,Ml,m,pl,T,ol,w,Dl='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',il,h,Kl="In this tutorial, we’ll see how to implement an agent that leverages SQL using <code>transformers.agents</code>.",yl,d,Pl="What’s the advantage over a standard text-to-SQL pipeline?",cl,b,Ol="A standard text-to-sql pipeline is brittle, since the generated SQL query can be incorrect. Even worse, the query could be incorrect, but not raise an error, instead giving some incorrect/useless outputs without raising an alarm.",jl,I,lt="👉 Instead, <strong>an agent system is able to critically inspect outputs and decide if the query needs to be changed or not</strong>, thus giving it a huge performance boost.",rl,g,tt="Let’s build this agent! 💪",ul,C,Jl,f,Ul,A,ml,B,st="Let’s check that our system works with a basic query:",Tl,q,wl,W,et=`(1, 'Alan Payne', 12.06, 1.2)
(2, 'Alex Mason', 23.86, 0.24)
(3, 'Woodrow Wilson', 53.43, 5.43)
(4, 'Margaret James', 21.11, 1.0)
`,hl,Z,dl,Q,nt="Now let’s make our SQL table retrievable by a tool.",bl,E,at="The tool’s <code>description</code> attribute will be embedded in the LLM’s prompt by the agent system: it gives the LLM information about how to use the tool. So that is where we want to describe the SQL table.",Il,R,gl,N,Mt=`Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT
`,Cl,v,pt='Now the tool will need a few mandatory arguments (read <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">the documentation</a> for more detail):',fl,k,ot="<li>The <code>description</code> mentioned above</li> <li>A <code>name</code> by which the agent system can call it.</li> <li>A dictionary of <code>inputs</code>: describe the tool’s input, each with a <code>type</code> and a <code>description</code> key.</li> <li>An <code>output_type</code> for compatibility with gradio demos for instance.</li> <li>A <code>forward</code> method that gets called when the tool is called.</li>",Al,S,Bl,$,it="Now let us create an agent that leverages this tool.",ql,G,yt="We use the <code>ReactCodeAgent</code>, which is <code>transformers.agents</code>’ main agent class: an agent that writes actions in code and can iterate on previous output according to the ReAct framework.",Wl,V,ct='The <code>llm_engine</code> is the LLM that powers the agent system. <code>HfEngine</code> allows you to call LLMs using HF’s Inference API, either via Serverless or Dedicated endpoint, but you could also use any proprietary API: check out <a href="agent_change_llm">this other cookbook</a> to learn how to adapt it.',Zl,_,Ql,x,El,X,Rl,H,Nl,Y,jt="Now let’s make it more challenging! We want our agent to handle joins across multiple tables.",vl,F,rt="So let’s make a second table recording the names of waiters for each <code>receipt_id</code>!",kl,L,Sl,z,ut="We need to update the <code>SQLExecutorTool</code> with this table’s description to let the LLM properly leverage information from this table.",$l,D,Gl,K,Jt=`Allows you to perform SQL queries on the table. Beware that this tool's output is a string representation of the execution output.
It can use the following tables:

Table 'receipts':
Columns:
  - receipt_id: INTEGER
  - customer_name: VARCHAR(16)
  - price: FLOAT
  - tip: FLOAT

Table 'waiters':
Columns:
  - receipt_id: INTEGER
  - waiter_name: VARCHAR(16)
`,Vl,P,_l,O,Ut=`['time', 'queue', 'random', 'unicodedata', 're', 'collections', 'itertools', 'stat', 'math', 'statistics']
`,xl,ll,mt="It directly works! The setup was surprisingly simple, wasn’t it?",Xl,tl,Tt="✅ Now you can go build this text-to-SQL system you’ve always dreamt of! ✨",Hl,sl,Yl,nl,Fl;return m=new Bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.ipynb"}]}}),T=new Ll({props:{title:"Agent for text-to-SQL with automatic error correction",local:"agent-for-text-to-sql-with-automatic-error-correction",headingTag:"h1"}}),C=new Ll({props:{title:"Setup SQL tables",local:"setup-sql-tables",headingTag:"h2"}}),f=new J({props:{code:"ZnJvbSUyMHNxbGFsY2hlbXklMjBpbXBvcnQlMjAoJTBBJTIwJTIwJTIwJTIwY3JlYXRlX2VuZ2luZSUyQyUwQSUyMCUyMCUyMCUyME1ldGFEYXRhJTJDJTBBJTIwJTIwJTIwJTIwVGFibGUlMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4lMkMlMEElMjAlMjAlMjAlMjBTdHJpbmclMkMlMEElMjAlMjAlMjAlMjBJbnRlZ2VyJTJDJTBBJTIwJTIwJTIwJTIwRmxvYXQlMkMlMEElMjAlMjAlMjAlMjBpbnNlcnQlMkMlMEElMjAlMjAlMjAlMjBpbnNwZWN0JTJDJTBBJTIwJTIwJTIwJTIwdGV4dCUyQyUwQSklMEElMEFlbmdpbmUlMjAlM0QlMjBjcmVhdGVfZW5naW5lKCUyMnNxbGl0ZSUzQSUyRiUyRiUyRiUzQW1lbW9yeSUzQSUyMiklMEFtZXRhZGF0YV9vYmolMjAlM0QlMjBNZXRhRGF0YSgpJTBBJTBBJTIzJTIwY3JlYXRlJTIwY2l0eSUyMFNRTCUyMHRhYmxlJTBBdGFibGVfbmFtZSUyMCUzRCUyMCUyMnJlY2VpcHRzJTIyJTBBcmVjZWlwdHMlMjAlM0QlMjBUYWJsZSglMEElMjAlMjAlMjAlMjB0YWJsZV9uYW1lJTJDJTBBJTIwJTIwJTIwJTIwbWV0YWRhdGFfb2JqJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMnJlY2VpcHRfaWQlMjIlMkMlMjBJbnRlZ2VyJTJDJTIwcHJpbWFyeV9rZXklM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMENvbHVtbiglMjJjdXN0b21lcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycHJpY2UlMjIlMkMlMjBGbG9hdCklMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIydGlwJTIyJTJDJTIwRmxvYXQpJTJDJTBBKSUwQW1ldGFkYXRhX29iai5jcmVhdGVfYWxsKGVuZ2luZSk=",highlighted:`<span class="hljs-keyword">from</span> sqlalchemy <span class="hljs-keyword">import</span> (
    create_engine,
    MetaData,
    Table,
    Column,
    String,
    Integer,
    Float,
    insert,
    inspect,
    text,
)

engine = create_engine(<span class="hljs-string">&quot;sqlite:///:memory:&quot;</span>)
metadata_obj = MetaData()

<span class="hljs-comment"># create city SQL table</span>
table_name = <span class="hljs-string">&quot;receipts&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;customer_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;price&quot;</span>, Float),
    Column(<span class="hljs-string">&quot;tip&quot;</span>, Float),
)
metadata_obj.create_all(engine)`,wrap:!1}}),A=new J({props:{code:"cm93cyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAxJTJDJTIwJTIyY3VzdG9tZXJfbmFtZSUyMiUzQSUyMCUyMkFsYW4lMjBQYXluZSUyMiUyQyUyMCUyMnByaWNlJTIyJTNBJTIwMTIuMDYlMkMlMjAlMjJ0aXAlMjIlM0ElMjAxLjIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJjdXN0b21lcl9uYW1lJTIyJTNBJTIwJTIyQWxleCUyME1hc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMy44NiUyQyUyMCUyMnRpcCUyMiUzQSUyMDAuMjQlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMyUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJXb29kcm93JTIwV2lsc29uJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjA1My40MyUyQyUyMCUyMnRpcCUyMiUzQSUyMDUuNDMlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMmN1c3RvbWVyX25hbWUlMjIlM0ElMjAlMjJNYXJnYXJldCUyMEphbWVzJTIyJTJDJTIwJTIycHJpY2UlMjIlM0ElMjAyMS4xMSUyQyUyMCUyMnRpcCUyMiUzQSUyMDEuMDAlN0QlMkMlMEElNUQlMEFmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjBzdG10JTIwJTNEJTIwaW5zZXJ0KHJlY2VpcHRzKS52YWx1ZXMoKipyb3cpJTBBJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5iZWdpbigpJTIwYXMlMjBjb25uZWN0aW9uJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY3Vyc29yJTIwJTNEJTIwY29ubmVjdGlvbi5leGVjdXRlKHN0bXQp",highlighted:`rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alan Payne&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">12.06</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.20</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Alex Mason&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">23.86</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">0.24</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Woodrow Wilson&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">53.43</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">5.43</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;customer_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>, <span class="hljs-string">&quot;price&quot;</span>: <span class="hljs-number">21.11</span>, <span class="hljs-string">&quot;tip&quot;</span>: <span class="hljs-number">1.00</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),q=new J({props:{code:"d2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KCUyMiUyMiUyMlNFTEVDVCUyMColMjBmcm9tJTIwcmVjZWlwdHMlMjIlMjIlMjIpKSUwQSUyMCUyMCUyMCUyMGZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KHJvdyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
<span class="hljs-meta">... </span>    rows = con.execute(text(<span class="hljs-string">&quot;&quot;&quot;SELECT * from receipts&quot;&quot;&quot;</span>))
<span class="hljs-meta">... </span>    <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
<span class="hljs-meta">... </span>        <span class="hljs-built_in">print</span>(row)`,wrap:!1}}),Z=new Ll({props:{title:"Build our agent",local:"build-our-agent",headingTag:"h2"}}),R=new J({props:{code:"aW5zcGVjdG9yJTIwJTNEJTIwaW5zcGVjdChlbmdpbmUpJTBBY29sdW1uc19pbmZvJTIwJTNEJTIwJTVCKGNvbCU1QiUyMm5hbWUlMjIlNUQlMkMlMjBjb2wlNUIlMjJ0eXBlJTIyJTVEKSUyMGZvciUyMGNvbCUyMGluJTIwaW5zcGVjdG9yLmdldF9jb2x1bW5zKCUyMnJlY2VpcHRzJTIyKSU1RCUwQSUwQXRhYmxlX2Rlc2NyaXB0aW9uJTIwJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEFwcmludCh0YWJsZV9kZXNjcmlwdGlvbik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span>columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(<span class="hljs-string">&quot;receipts&quot;</span>)]

<span class="hljs-meta">&gt;&gt;&gt; </span>table_description = <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(table_description)`,wrap:!1}}),S=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBUb29sJTBBJTBBJTBBY2xhc3MlMjBTUUxFeGVjdXRvclRvb2woVG9vbCklM0ElMEElMjAlMjAlMjAlMjBuYW1lJTIwJTNEJTIwJTIyc3FsX2VuZ2luZSUyMiUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTIwJTNEJTIwZiUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMFJldHVybnMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMHJlc3VsdC4lMEFUaGUlMjB0YWJsZSUyMGlzJTIwbmFtZWQlMjAncmVjZWlwdHMnLiUyMEl0cyUyMGRlc2NyaXB0aW9uJTIwaXMlMjBhcyUyMGZvbGxvd3MlM0ElMjAlNUNuJTdCdGFibGVfZGVzY3JpcHRpb24lN0QlMjIlMjIlMjIlMEElMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJxdWVyeSUyMiUzQSUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnR5cGUlMjIlM0ElMjAlMjJ0ZXh0JTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZGVzY3JpcHRpb24lMjIlM0ElMjBmJTIyVGhlJTIwcXVlcnklMjB0byUyMHBlcmZvcm0uJTIwVGhpcyUyMHNob3VsZCUyMGJlJTIwY29ycmVjdCUyMFNRTC4lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjBvdXRwdXRfdHlwZSUyMCUzRCUyMCUyMnRleHQlMjIlMEElMEElMjAlMjAlMjAlMjBkZWYlMjBmb3J3YXJkKHNlbGYlMkMlMjBxdWVyeSUzQSUyMHN0ciklMjAtJTNFJTIwc3RyJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwb3V0cHV0JTIwJTNEJTIwJTIyJTIyJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwd2l0aCUyMGVuZ2luZS5jb25uZWN0KCklMjBhcyUyMGNvbiUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJvd3MlMjAlM0QlMjBjb24uZXhlY3V0ZSh0ZXh0KHF1ZXJ5KSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBmb3IlMjByb3clMjBpbiUyMHJvd3MlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXQlMjAlMkIlM0QlMjAlMjIlNUNuJTIyJTIwJTJCJTIwc3RyKHJvdyklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXR1cm4lMjBvdXRwdXQ=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool


<span class="hljs-keyword">class</span> <span class="hljs-title class_">SQLExecutorTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;sql_engine&quot;</span>
    description = <span class="hljs-string">f&quot;&quot;&quot;Allows you to perform SQL queries on the table. Returns a string representation of the result.
The table is named &#x27;receipts&#x27;. Its description is as follows: \\n<span class="hljs-subst">{table_description}</span>&quot;&quot;&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">f&quot;The query to perform. This should be correct SQL.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        output = <span class="hljs-string">&quot;&quot;</span>
        <span class="hljs-keyword">with</span> engine.connect() <span class="hljs-keyword">as</span> con:
            rows = con.execute(text(query))
            <span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
                output += <span class="hljs-string">&quot;\\n&quot;</span> + <span class="hljs-built_in">str</span>(row)
        <span class="hljs-keyword">return</span> output`,wrap:!1}}),_=new J({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),x=new J({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCglMEElMjAlMjAlMjAlMjB0b29scyUzRCU1QlNRTEV4ZWN1dG9yVG9vbCgpJTVEJTJDJTBBJTIwJTIwJTIwJTIwbGxtX2VuZ2luZSUzREhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> ReactCodeAgent, HfEngine

agent = ReactCodeAgent(
    tools=[SQLExecutorTool()],
    llm_engine=HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>),
)`,wrap:!1}}),X=new J({props:{code:"YWdlbnQucnVuKCUyMkNhbiUyMHlvdSUyMGdpdmUlMjBtZSUyMHRoZSUyMG5hbWUlMjBvZiUyMHRoZSUyMGNsaWVudCUyMHdobyUyMGdvdCUyMHRoZSUyMG1vc3QlMjBleHBlbnNpdmUlMjByZWNlaXB0JTNGJTIyKQ==",highlighted:'agent.run(<span class="hljs-string">&quot;Can you give me the name of the client who got the most expensive receipt?&quot;</span>)',wrap:!1}}),H=new Ll({props:{title:"Increasing difficulty: Table joins",local:"increasing-difficulty-table-joins",headingTag:"h2"}}),L=new J({props:{code:"dGFibGVfbmFtZSUyMCUzRCUyMCUyMndhaXRlcnMlMjIlMEFyZWNlaXB0cyUyMCUzRCUyMFRhYmxlKCUwQSUyMCUyMCUyMCUyMHRhYmxlX25hbWUlMkMlMEElMjAlMjAlMjAlMjBtZXRhZGF0YV9vYmolMkMlMEElMjAlMjAlMjAlMjBDb2x1bW4oJTIycmVjZWlwdF9pZCUyMiUyQyUyMEludGVnZXIlMkMlMjBwcmltYXJ5X2tleSUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwQ29sdW1uKCUyMndhaXRlcl9uYW1lJTIyJTJDJTIwU3RyaW5nKDE2KSUyQyUyMHByaW1hcnlfa2V5JTNEVHJ1ZSklMkMlMEEpJTBBbWV0YWRhdGFfb2JqLmNyZWF0ZV9hbGwoZW5naW5lKSUwQSUwQXJvd3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwMSUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyQ29yZXklMjBKb2huc29uJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTdCJTIycmVjZWlwdF9pZCUyMiUzQSUyMDIlMkMlMjAlMjJ3YWl0ZXJfbmFtZSUyMiUzQSUyMCUyMk1pY2hhZWwlMjBXYXR0cyUyMiU3RCUyQyUwQSUyMCUyMCUyMCUyMCU3QiUyMnJlY2VpcHRfaWQlMjIlM0ElMjAzJTJDJTIwJTIyd2FpdGVyX25hbWUlMjIlM0ElMjAlMjJNaWNoYWVsJTIwV2F0dHMlMjIlN0QlMkMlMEElMjAlMjAlMjAlMjAlN0IlMjJyZWNlaXB0X2lkJTIyJTNBJTIwNCUyQyUyMCUyMndhaXRlcl9uYW1lJTIyJTNBJTIwJTIyTWFyZ2FyZXQlMjBKYW1lcyUyMiU3RCUyQyUwQSU1RCUwQWZvciUyMHJvdyUyMGluJTIwcm93cyUzQSUwQSUyMCUyMCUyMCUyMHN0bXQlMjAlM0QlMjBpbnNlcnQocmVjZWlwdHMpLnZhbHVlcygqKnJvdyklMEElMjAlMjAlMjAlMjB3aXRoJTIwZW5naW5lLmJlZ2luKCklMjBhcyUyMGNvbm5lY3Rpb24lM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBjdXJzb3IlMjAlM0QlMjBjb25uZWN0aW9uLmV4ZWN1dGUoc3RtdCk=",highlighted:`table_name = <span class="hljs-string">&quot;waiters&quot;</span>
receipts = Table(
    table_name,
    metadata_obj,
    Column(<span class="hljs-string">&quot;receipt_id&quot;</span>, Integer, primary_key=<span class="hljs-literal">True</span>),
    Column(<span class="hljs-string">&quot;waiter_name&quot;</span>, String(<span class="hljs-number">16</span>), primary_key=<span class="hljs-literal">True</span>),
)
metadata_obj.create_all(engine)

rows = [
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">1</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Corey Johnson&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">2</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">3</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Michael Watts&quot;</span>},
    {<span class="hljs-string">&quot;receipt_id&quot;</span>: <span class="hljs-number">4</span>, <span class="hljs-string">&quot;waiter_name&quot;</span>: <span class="hljs-string">&quot;Margaret James&quot;</span>},
]
<span class="hljs-keyword">for</span> row <span class="hljs-keyword">in</span> rows:
    stmt = insert(receipts).values(**row)
    <span class="hljs-keyword">with</span> engine.begin() <span class="hljs-keyword">as</span> connection:
        cursor = connection.execute(stmt)`,wrap:!1}}),D=new J({props:{code:"dXBkYXRlZF9kZXNjcmlwdGlvbiUyMCUzRCUyMCUyMiUyMiUyMkFsbG93cyUyMHlvdSUyMHRvJTIwcGVyZm9ybSUyMFNRTCUyMHF1ZXJpZXMlMjBvbiUyMHRoZSUyMHRhYmxlLiUyMEJld2FyZSUyMHRoYXQlMjB0aGlzJTIwdG9vbCdzJTIwb3V0cHV0JTIwaXMlMjBhJTIwc3RyaW5nJTIwcmVwcmVzZW50YXRpb24lMjBvZiUyMHRoZSUyMGV4ZWN1dGlvbiUyMG91dHB1dC4lMEFJdCUyMGNhbiUyMHVzZSUyMHRoZSUyMGZvbGxvd2luZyUyMHRhYmxlcyUzQSUyMiUyMiUyMiUwQSUwQWluc3BlY3RvciUyMCUzRCUyMGluc3BlY3QoZW5naW5lKSUwQWZvciUyMHRhYmxlJTIwaW4lMjAlNUIlMjJyZWNlaXB0cyUyMiUyQyUyMCUyMndhaXRlcnMlMjIlNUQlM0ElMEElMjAlMjAlMjAlMjBjb2x1bW5zX2luZm8lMjAlM0QlMjAlNUIoY29sJTVCJTIybmFtZSUyMiU1RCUyQyUyMGNvbCU1QiUyMnR5cGUlMjIlNUQpJTIwZm9yJTIwY29sJTIwaW4lMjBpbnNwZWN0b3IuZ2V0X2NvbHVtbnModGFibGUpJTVEJTBBJTBBJTIwJTIwJTIwJTIwdGFibGVfZGVzY3JpcHRpb24lMjAlM0QlMjBmJTIyVGFibGUlMjAnJTdCdGFibGUlN0QnJTNBJTVDbiUyMiUwQSUwQSUyMCUyMCUyMCUyMHRhYmxlX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyQ29sdW1ucyUzQSU1Q24lMjIlMjAlMkIlMjAlMjIlNUNuJTIyLmpvaW4oJTVCZiUyMiUyMCUyMC0lMjAlN0JuYW1lJTdEJTNBJTIwJTdCY29sX3R5cGUlN0QlMjIlMjBmb3IlMjBuYW1lJTJDJTIwY29sX3R5cGUlMjBpbiUyMGNvbHVtbnNfaW5mbyU1RCklMEElMjAlMjAlMjAlMjB1cGRhdGVkX2Rlc2NyaXB0aW9uJTIwJTJCJTNEJTIwJTIyJTVDbiU1Q24lMjIlMjAlMkIlMjB0YWJsZV9kZXNjcmlwdGlvbiUwQSUwQXByaW50KHVwZGF0ZWRfZGVzY3JpcHRpb24p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>updated_description = <span class="hljs-string">&quot;&quot;&quot;Allows you to perform SQL queries on the table. Beware that this tool&#x27;s output is a string representation of the execution output.
<span class="hljs-meta">... </span>It can use the following tables:&quot;&quot;&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>inspector = inspect(engine)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> table <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;receipts&quot;</span>, <span class="hljs-string">&quot;waiters&quot;</span>]:
<span class="hljs-meta">... </span>    columns_info = [(col[<span class="hljs-string">&quot;name&quot;</span>], col[<span class="hljs-string">&quot;type&quot;</span>]) <span class="hljs-keyword">for</span> col <span class="hljs-keyword">in</span> inspector.get_columns(table)]

<span class="hljs-meta">... </span>    table_description = <span class="hljs-string">f&quot;Table &#x27;<span class="hljs-subst">{table}</span>&#x27;:\\n&quot;</span>

<span class="hljs-meta">... </span>    table_description += <span class="hljs-string">&quot;Columns:\\n&quot;</span> + <span class="hljs-string">&quot;\\n&quot;</span>.join([<span class="hljs-string">f&quot;  - <span class="hljs-subst">{name}</span>: <span class="hljs-subst">{col_type}</span>&quot;</span> <span class="hljs-keyword">for</span> name, col_type <span class="hljs-keyword">in</span> columns_info])
<span class="hljs-meta">... </span>    updated_description += <span class="hljs-string">&quot;\\n\\n&quot;</span> + table_description

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(updated_description)`,wrap:!1}}),P=new J({props:{code:"c3FsX3Rvb2wlMjAlM0QlMjBTUUxFeGVjdXRvclRvb2woKSUwQXNxbF90b29sLmRlc2NyaXB0aW9uJTIwJTNEJTIwdXBkYXRlZF9kZXNjcmlwdGlvbiUwQSUwQWFnZW50JTIwJTNEJTIwUmVhY3RDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJzcWxfdG9vbCU1RCUyQyUwQSUyMCUyMCUyMCUyMGxsbV9lbmdpbmUlM0RIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMkMlMEEpJTBBJTBBYWdlbnQucnVuKCUyMldoaWNoJTIwd2FpdGVyJTIwZ290JTIwbW9yZSUyMHRvdGFsJTIwbW9uZXklMjBmcm9tJTIwdGlwcyUzRiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>sql_tool = SQLExecutorTool()
<span class="hljs-meta">&gt;&gt;&gt; </span>sql_tool.description = updated_description

<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactCodeAgent(
<span class="hljs-meta">... </span>    tools=[sql_tool],
<span class="hljs-meta">... </span>    llm_engine=HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent.run(<span class="hljs-string">&quot;Which waiter got more total money from tips?&quot;</span>)`,wrap:!1}}),sl=new qt({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agent_text_to_sql.md"}}),{c(){U=M("meta"),al=n(),el=M("p"),Ml=n(),i(m.$$.fragment),pl=n(),i(T.$$.fragment),ol=n(),w=M("p"),w.innerHTML=Dl,il=n(),h=M("p"),h.innerHTML=Kl,yl=n(),d=M("p"),d.textContent=Pl,cl=n(),b=M("p"),b.textContent=Ol,jl=n(),I=M("p"),I.innerHTML=lt,rl=n(),g=M("p"),g.textContent=tt,ul=n(),i(C.$$.fragment),Jl=n(),i(f.$$.fragment),Ul=n(),i(A.$$.fragment),ml=n(),B=M("p"),B.textContent=st,Tl=n(),i(q.$$.fragment),wl=n(),W=M("pre"),W.textContent=et,hl=n(),i(Z.$$.fragment),dl=n(),Q=M("p"),Q.textContent=nt,bl=n(),E=M("p"),E.innerHTML=at,Il=n(),i(R.$$.fragment),gl=n(),N=M("pre"),N.textContent=Mt,Cl=n(),v=M("p"),v.innerHTML=pt,fl=n(),k=M("ul"),k.innerHTML=ot,Al=n(),i(S.$$.fragment),Bl=n(),$=M("p"),$.textContent=it,ql=n(),G=M("p"),G.innerHTML=yt,Wl=n(),V=M("p"),V.innerHTML=ct,Zl=n(),i(_.$$.fragment),Ql=n(),i(x.$$.fragment),El=n(),i(X.$$.fragment),Rl=n(),i(H.$$.fragment),Nl=n(),Y=M("p"),Y.textContent=jt,vl=n(),F=M("p"),F.innerHTML=rt,kl=n(),i(L.$$.fragment),Sl=n(),z=M("p"),z.innerHTML=ut,$l=n(),i(D.$$.fragment),Gl=n(),K=M("pre"),K.textContent=Jt,Vl=n(),i(P.$$.fragment),_l=n(),O=M("pre"),O.textContent=Ut,xl=n(),ll=M("p"),ll.textContent=mt,Xl=n(),tl=M("p"),tl.textContent=Tt,Hl=n(),i(sl.$$.fragment),Yl=n(),nl=M("p"),this.h()},l(l){const t=ft("svelte-u9bgzb",document.head);U=p(t,"META",{name:!0,content:!0}),t.forEach(s),al=a(l),el=p(l,"P",{}),wt(el).forEach(s),Ml=a(l),y(m.$$.fragment,l),pl=a(l),y(T.$$.fragment,l),ol=a(l),w=p(l,"P",{"data-svelte-h":!0}),o(w)!=="svelte-1xlqnsv"&&(w.innerHTML=Dl),il=a(l),h=p(l,"P",{"data-svelte-h":!0}),o(h)!=="svelte-wem15p"&&(h.innerHTML=Kl),yl=a(l),d=p(l,"P",{"data-svelte-h":!0}),o(d)!=="svelte-3ojw25"&&(d.textContent=Pl),cl=a(l),b=p(l,"P",{"data-svelte-h":!0}),o(b)!=="svelte-1hw7g6s"&&(b.textContent=Ol),jl=a(l),I=p(l,"P",{"data-svelte-h":!0}),o(I)!=="svelte-q251yb"&&(I.innerHTML=lt),rl=a(l),g=p(l,"P",{"data-svelte-h":!0}),o(g)!=="svelte-1tzrwc8"&&(g.textContent=tt),ul=a(l),y(C.$$.fragment,l),Jl=a(l),y(f.$$.fragment,l),Ul=a(l),y(A.$$.fragment,l),ml=a(l),B=p(l,"P",{"data-svelte-h":!0}),o(B)!=="svelte-ec23hm"&&(B.textContent=st),Tl=a(l),y(q.$$.fragment,l),wl=a(l),W=p(l,"PRE",{"data-svelte-h":!0}),o(W)!=="svelte-jbb28p"&&(W.textContent=et),hl=a(l),y(Z.$$.fragment,l),dl=a(l),Q=p(l,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-fdu5cw"&&(Q.textContent=nt),bl=a(l),E=p(l,"P",{"data-svelte-h":!0}),o(E)!=="svelte-jme9kq"&&(E.innerHTML=at),Il=a(l),y(R.$$.fragment,l),gl=a(l),N=p(l,"PRE",{"data-svelte-h":!0}),o(N)!=="svelte-1pz02dc"&&(N.textContent=Mt),Cl=a(l),v=p(l,"P",{"data-svelte-h":!0}),o(v)!=="svelte-84s4c8"&&(v.innerHTML=pt),fl=a(l),k=p(l,"UL",{"data-svelte-h":!0}),o(k)!=="svelte-1l8h02j"&&(k.innerHTML=ot),Al=a(l),y(S.$$.fragment,l),Bl=a(l),$=p(l,"P",{"data-svelte-h":!0}),o($)!=="svelte-1t4r7cu"&&($.textContent=it),ql=a(l),G=p(l,"P",{"data-svelte-h":!0}),o(G)!=="svelte-12rc58c"&&(G.innerHTML=yt),Wl=a(l),V=p(l,"P",{"data-svelte-h":!0}),o(V)!=="svelte-1efohjn"&&(V.innerHTML=ct),Zl=a(l),y(_.$$.fragment,l),Ql=a(l),y(x.$$.fragment,l),El=a(l),y(X.$$.fragment,l),Rl=a(l),y(H.$$.fragment,l),Nl=a(l),Y=p(l,"P",{"data-svelte-h":!0}),o(Y)!=="svelte-nr3fl7"&&(Y.textContent=jt),vl=a(l),F=p(l,"P",{"data-svelte-h":!0}),o(F)!=="svelte-6lwjm6"&&(F.innerHTML=rt),kl=a(l),y(L.$$.fragment,l),Sl=a(l),z=p(l,"P",{"data-svelte-h":!0}),o(z)!=="svelte-frhx8p"&&(z.innerHTML=ut),$l=a(l),y(D.$$.fragment,l),Gl=a(l),K=p(l,"PRE",{"data-svelte-h":!0}),o(K)!=="svelte-d75mf2"&&(K.textContent=Jt),Vl=a(l),y(P.$$.fragment,l),_l=a(l),O=p(l,"PRE",{"data-svelte-h":!0}),o(O)!=="svelte-1fqzj2e"&&(O.textContent=Ut),xl=a(l),ll=p(l,"P",{"data-svelte-h":!0}),o(ll)!=="svelte-1umn140"&&(ll.textContent=mt),Xl=a(l),tl=p(l,"P",{"data-svelte-h":!0}),o(tl)!=="svelte-bt1f1w"&&(tl.textContent=Tt),Hl=a(l),y(sl.$$.fragment,l),Yl=a(l),nl=p(l,"P",{}),wt(nl).forEach(s),this.h()},h(){ht(U,"name","hf:doc:metadata"),ht(U,"content",Zt)},m(l,t){At(document.head,U),e(l,al,t),e(l,el,t),e(l,Ml,t),c(m,l,t),e(l,pl,t),c(T,l,t),e(l,ol,t),e(l,w,t),e(l,il,t),e(l,h,t),e(l,yl,t),e(l,d,t),e(l,cl,t),e(l,b,t),e(l,jl,t),e(l,I,t),e(l,rl,t),e(l,g,t),e(l,ul,t),c(C,l,t),e(l,Jl,t),c(f,l,t),e(l,Ul,t),c(A,l,t),e(l,ml,t),e(l,B,t),e(l,Tl,t),c(q,l,t),e(l,wl,t),e(l,W,t),e(l,hl,t),c(Z,l,t),e(l,dl,t),e(l,Q,t),e(l,bl,t),e(l,E,t),e(l,Il,t),c(R,l,t),e(l,gl,t),e(l,N,t),e(l,Cl,t),e(l,v,t),e(l,fl,t),e(l,k,t),e(l,Al,t),c(S,l,t),e(l,Bl,t),e(l,$,t),e(l,ql,t),e(l,G,t),e(l,Wl,t),e(l,V,t),e(l,Zl,t),c(_,l,t),e(l,Ql,t),c(x,l,t),e(l,El,t),c(X,l,t),e(l,Rl,t),c(H,l,t),e(l,Nl,t),e(l,Y,t),e(l,vl,t),e(l,F,t),e(l,kl,t),c(L,l,t),e(l,Sl,t),e(l,z,t),e(l,$l,t),c(D,l,t),e(l,Gl,t),e(l,K,t),e(l,Vl,t),c(P,l,t),e(l,_l,t),e(l,O,t),e(l,xl,t),e(l,ll,t),e(l,Xl,t),e(l,tl,t),e(l,Hl,t),c(sl,l,t),e(l,Yl,t),e(l,nl,t),Fl=!0},p:bt,i(l){Fl||(j(m.$$.fragment,l),j(T.$$.fragment,l),j(C.$$.fragment,l),j(f.$$.fragment,l),j(A.$$.fragment,l),j(q.$$.fragment,l),j(Z.$$.fragment,l),j(R.$$.fragment,l),j(S.$$.fragment,l),j(_.$$.fragment,l),j(x.$$.fragment,l),j(X.$$.fragment,l),j(H.$$.fragment,l),j(L.$$.fragment,l),j(D.$$.fragment,l),j(P.$$.fragment,l),j(sl.$$.fragment,l),Fl=!0)},o(l){r(m.$$.fragment,l),r(T.$$.fragment,l),r(C.$$.fragment,l),r(f.$$.fragment,l),r(A.$$.fragment,l),r(q.$$.fragment,l),r(Z.$$.fragment,l),r(R.$$.fragment,l),r(S.$$.fragment,l),r(_.$$.fragment,l),r(x.$$.fragment,l),r(X.$$.fragment,l),r(H.$$.fragment,l),r(L.$$.fragment,l),r(D.$$.fragment,l),r(P.$$.fragment,l),r(sl.$$.fragment,l),Fl=!1},d(l){l&&(s(al),s(el),s(Ml),s(pl),s(ol),s(w),s(il),s(h),s(yl),s(d),s(cl),s(b),s(jl),s(I),s(rl),s(g),s(ul),s(Jl),s(Ul),s(ml),s(B),s(Tl),s(wl),s(W),s(hl),s(dl),s(Q),s(bl),s(E),s(Il),s(gl),s(N),s(Cl),s(v),s(fl),s(k),s(Al),s(Bl),s($),s(ql),s(G),s(Wl),s(V),s(Zl),s(Ql),s(El),s(Rl),s(Nl),s(Y),s(vl),s(F),s(kl),s(Sl),s(z),s($l),s(Gl),s(K),s(Vl),s(_l),s(O),s(xl),s(ll),s(Xl),s(tl),s(Hl),s(Yl),s(nl)),s(U),u(m,l),u(T,l),u(C,l),u(f,l),u(A,l),u(q,l),u(Z,l),u(R,l),u(S,l),u(_,l),u(x,l),u(X,l),u(H,l),u(L,l),u(D,l),u(P,l),u(sl,l)}}}const Zt='{"title":"Agent for text-to-SQL with automatic error correction","local":"agent-for-text-to-sql-with-automatic-error-correction","sections":[{"title":"Setup SQL tables","local":"setup-sql-tables","sections":[],"depth":2},{"title":"Build our agent","local":"build-our-agent","sections":[],"depth":2},{"title":"Increasing difficulty: Table joins","local":"increasing-difficulty-table-joins","sections":[],"depth":2}],"depth":1}';function Qt(zl){return It(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class kt extends gt{constructor(U){super(),Ct(this,U,Qt,Wt,dt,{})}}export{kt as component};
