import{s as gl,n as fl,o as Il}from"../chunks/scheduler.65852ee5.js";import{S as Cl,i as Zl,g as o,s as n,r,A as Bl,h as i,f as l,c as a,j as dl,u as p,x as M,k as bl,y as vl,a as s,v as y,d as c,t as u,w as m}from"../chunks/index.aa74147d.js";import{D as Gl,C as w}from"../chunks/DocNotebookDropdown.479f4286.js";import{H as J,E as Wl}from"../chunks/EditOnGithub.4eda6a96.js";function Al(Nt){let j,Ze,Ie,Be,T,ve,h,Ge,U,St='<em>Authored by: <a href="https://huggingface.co/m-ric" rel="nofollow">Aymeric Roucher</a></em>',We,d,$t='This notebook demonstrates how you can use <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow"><strong>Transformers Agents</strong></a> to build awesome <strong>agents</strong>!',Ae,b,Qt="What are <strong>agents</strong>? Agents are systems that are powered by an LLM and enable the LLM (with careful prompting and output parsing) to use specific <em>tools</em> to solve problems.",ke,g,Et='These <em>tools</em> are basically functions that the LLM couldn’t perform well by itself: for instance for a text-generation LLM like <a href="https://huggingface.co/meta-llama/Meta-Llama-3-70B-Instruct" rel="nofollow">Llama-3-70B</a>, this could be an image generation tool, a web search tool, a calculator…',_e,f,Xt='What is <strong>Transformers Agents</strong>? it’s an extension of our <code>transformers</code> library that provides building blocks to build your own agents! Learn more about it in the <a href="https://huggingface.co/docs/transformers/en/agents" rel="nofollow">documentation</a>.',Re,I,qt="Let’s see how to use it, and which use cases it can solve.",Ve,C,xt="Run the line below to install required dependencies:",Ne,Z,Se,B,$e,v,Yt="For this use case, we want to show an agent that browses the web and is able to generate image.",Qe,G,zt="To build it, we simply need to have two tools ready: image generation and web search.",Ee,W,Ht="<li>For image generation, we load a tool from the Hub that uses the HF Inference API (Serverless) to generate images using Stable Diffusion.</li> <li>For the web search, we load a LangChain tool.</li>",Xe,A,qe,k,xe,_,Ye,R,Ft='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/agents_db5.png" alt="Image of an Aston Martin DB5"/>',ze,V,He,N,Lt="Quick definition: Retrieval-Augmented-Generation (RAG) is <strong><em>“using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”.</em></strong>",Fe,S,Pt="This method has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",Le,$,Kt="<li><p>Now let’s say we want to perform RAG, but with the additional constraint that some parameters must be dynamically generated. For example, depending on the user query we could want to restrict the search to specific subsets of the knowledge base, or we could want to adjust the number of documents retrieved. The difficulty is: <strong>how to dynamically adjust these parameters based on the user query?</strong></p></li> <li><p>A frequent failure case of RAG is when the retrieval based on the user query does not return any relevant supporting documents. <strong>Is there a way to iterate by re-calling the retriever with a modified query in case the previous results were not relevant?</strong></p></li>",Pe,Q,Dt="🔧 Well, we can solve the points above in a simple way: we will <strong>give our agent control over the retriever’s parameters!</strong>",Ke,E,Ot="➡️ Let’s show how to do this. We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many <code>huggingface</code> packages, stored as markdown.",De,X,Oe,q,el="Now we prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever. We are going to use LangChain, since it features excellent utilities for vector databases:",et,x,tt,Y,tl="Now that we have the database ready, let’s build a RAG system that answers user queries based on it!",lt,z,ll="We want our system to select only from the most relevant sources of information, depending on the query.",st,H,sl="Our documentation pages come from the following sources:",nt,F,at,L,nl=`['evaluate', 'course', 'deep-rl-class', 'peft', 'hf-endpoints-documentation', 'blog', 'gradio', 'datasets', 'datasets-server', 'transformers', 'optimum', 'hub-docs', 'pytorch-image-models', 'diffusers']
`,ot,P,it,K,Mt,D,al="To share your tool to the Hub, first copy-paste the code in the RetrieverTool definition cell to a new file named for instance <code>retriever.py</code>.",rt,O,ol="When the tool is loaded from a separate file, you can then push it to the Hub using the code below (make sure to login with a <code>write</code> access token)",pt,ee,yt,te,ct,le,ut,se,il=`Final output:
https://github.com/huggingface/diffusers/blob/main/examples/text_to_image/train_text_to_image_lora.py
`,mt,ne,Ml="What happened here? First, the agent launched the retriever with specific sources in mind (<code>[&#39;transformers&#39;, &#39;blog&#39;]</code>).",wt,ae,rl=`But this retrieval did not yield enough results ⇒ no problem! The agent could iterate on previous results, so it just re-ran its retrieval with less restrictive search parameters.
Thus the research was successful!`,jt,oe,pl="Note that <strong>using an LLM agent</strong> that calls a retriever as a tool and can dynamically modify the query and other retrieval parameters <strong>is a more general formulation of RAG</strong>, which also covers many RAG improvement techniques like iterative query refinement.",Jt,ie,Tt,Me,yl="Since the ReactCodeAgent has a built-in Python code interpreter, we can use it to debug our faulty Python script!",ht,re,Ut,pe,cl="As you can see, the agent tried the given code, gets an error, analyses the error, corrects the code and returns it after veryfing that it works!",dt,ye,ul="And the final code is the corrected code:",bt,ce,gt,ue,ml=`list=[0, 1, 2]

for i in range(4):
    print(list(i))
`,ft,me,It,we,wl=`It’s really easy to set up your own LLM engine:
it only needs a <code>__call__</code> method with these criteria:`,Ct,je,jl='<li>Takes as input a list of messages in <a href="https://huggingface.co/docs/transformers/main/en/chat_templating#introduction" rel="nofollow">ChatML format</a> and outputs the answer.</li> <li>Accepts a <code>stop_sequences</code> arguments to pass sequences on which generation stops.</li> <li>Depending on which kind of message roles your LLM accepts, you may also need to convert some message roles.</li>',Zt,Je,Bt,Te,vt,he,Jl=`my_list = [0, 1, 2]  # Renamed the list to avoid using the built-in name

for i in range(len(my_list)):  # Changed the range to be within the length of the list
    print(my_list[i])  # Corrected the list access syntax
`,Gt,Ue,Wt,de,Tl="The use cases above should give you a glimpse into the possibilities of our Agents framework!",At,be,hl='For more advanced usage, read the <a href="https://huggingface.co/docs/transformers/en/transformers_agents" rel="nofollow">documentation</a>, and <a href="https://github.com/aymeric-roucher/agent_reasoning_benchmark/blob/main/benchmark_gaia.ipynb" rel="nofollow">this experiment</a> that allowed us to build our own agent based on Llama-3-70B that beats many GPT-4 agents on the very difficult <a href="https://huggingface.co/spaces/gaia-benchmark/leaderboard" rel="nofollow">GAIA Leaderboard</a>!',kt,ge,Ul="All feedback is welcome, it will help us improve the framework! 🚀",_t,fe,Rt,Ce,Vt;return T=new Gl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/agents.ipynb"}]}}),h=new J({props:{title:"Build an agent with tool-calling superpowers 🦸 using Transformers Agents",local:"build-an-agent-with-tool-calling-superpowers--using-transformers-agents",headingTag:"h1"}}),Z=new w({props:{code:"IXBpcCUyMGluc3RhbGwlMjAlMjJ0cmFuc2Zvcm1lcnMlNUJhZ2VudHMlNUQlMjIlMjBkYXRhc2V0cyUyMGxhbmdjaGFpbiUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGZhaXNzLWNwdSUyMHNlcnBhcGklMjBnb29nbGUtc2VhcmNoLXJlc3VsdHMlMjBvcGVuYWklMjBsYW5nY2hhaW4tY29tbXVuaXR5JTIwLXE=",highlighted:'!pip install <span class="hljs-string">&quot;transformers[agents]&quot;</span> datasets langchain sentence-transformers faiss-cpu serpapi google-search-results openai langchain-community -q',wrap:!1}}),B=new J({props:{title:"1. 🏞️ Multimodal + 🌐 Web-browsing assistant",local:"1--multimodal---web-browsing-assistant",headingTag:"h2"}}),A=new w({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyU0VSUEFQSV9BUElfS0VZJTIyJTVEJTIwJTNEJTIwJTIyJTIy",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;SERPAPI_API_KEY&quot;</span>] = <span class="hljs-string">&quot;&quot;</span>`,wrap:!1}}),k=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login

notebook_login()`,wrap:!1}}),_=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFRvb2wlMkMlMjBsb2FkX3Rvb2wlMkMlMjBSZWFjdENvZGVBZ2VudCUyQyUyMEhmRW5naW5lJTBBJTBBJTIzJTIwSW1wb3J0JTIwdG9vbCUyMGZyb20lMjBIdWIlMEFpbWFnZV9nZW5lcmF0aW9uX3Rvb2wlMjAlM0QlMjBsb2FkX3Rvb2woJTIybS1yaWMlMkZ0ZXh0LXRvLWltYWdlJTIyKSUwQSUwQSUyMyUyMEltcG9ydCUyMHRvb2wlMjBmcm9tJTIwTGFuZ0NoYWluJTBBZnJvbSUyMGxhbmdjaGFpbi5hZ2VudHMlMjBpbXBvcnQlMjBsb2FkX3Rvb2xzJTBBJTBBc2VhcmNoX3Rvb2wlMjAlM0QlMjBUb29sLmZyb21fbGFuZ2NoYWluKGxvYWRfdG9vbHMoJTVCJTIyc2VycGFwaSUyMiU1RCklNUIwJTVEKSUwQSUwQSUwQWxsbV9lbmdpbmUlMjAlM0QlMjBIZkVuZ2luZSglMjJtZXRhLWxsYW1hJTJGTWV0YS1MbGFtYS0zLTcwQi1JbnN0cnVjdCUyMiklMEElMjMlMjBJbml0aWFsaXplJTIwdGhlJTIwYWdlbnQlMjB3aXRoJTIwYm90aCUyMHRvb2xzJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QmltYWdlX2dlbmVyYXRpb25fdG9vbCUyQyUyMHNlYXJjaF90b29sJTVEJTJDJTIwbGxtX2VuZ2luZSUzRGxsbV9lbmdpbmUpJTBBJTBBJTIzJTIwUnVuJTIwaXQhJTBBcmVzdWx0JTIwJTNEJTIwYWdlbnQucnVuKCUwQSUyMCUyMCUyMCUyMCUyMkdlbmVyYXRlJTIwbWUlMjBhJTIwcGhvdG8lMjBvZiUyMHRoZSUyMGNhciUyMHRoYXQlMjBKYW1lcyUyMGJvbmQlMjBkcm92ZSUyMGluJTIwdGhlJTIwbGF0ZXN0JTIwbW92aWUuJTIyJTJDJTBBKSUwQXJlc3VsdA==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> Tool, load_tool, ReactCodeAgent, HfEngine

<span class="hljs-comment"># Import tool from Hub</span>
image_generation_tool = load_tool(<span class="hljs-string">&quot;m-ric/text-to-image&quot;</span>)

<span class="hljs-comment"># Import tool from LangChain</span>
<span class="hljs-keyword">from</span> langchain.agents <span class="hljs-keyword">import</span> load_tools

search_tool = Tool.from_langchain(load_tools([<span class="hljs-string">&quot;serpapi&quot;</span>])[<span class="hljs-number">0</span>])


llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)
<span class="hljs-comment"># Initialize the agent with both tools</span>
agent = ReactCodeAgent(tools=[image_generation_tool, search_tool], llm_engine=llm_engine)

<span class="hljs-comment"># Run it!</span>
result = agent.run(
    <span class="hljs-string">&quot;Generate me a photo of the car that James bond drove in the latest movie.&quot;</span>,
)
result`,wrap:!1}}),V=new J({props:{title:"2. 📚💬 RAG with Iterative query refinement & Source selection",local:"2--rag-with-iterative-query-refinement--source-selection",headingTag:"h2"}}),X=new w({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEElMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGRhdGFzZXRzLmxvYWRfZGF0YXNldCglMjJtLXJpYyUyRmh1Z2dpbmdmYWNlX2RvYyUyMiUyQyUyMHNwbGl0JTNEJTIydHJhaW4lMjIp",highlighted:`<span class="hljs-keyword">import</span> datasets

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)`,wrap:!1}}),x=new w({props:{code:"ZnJvbSUyMGxhbmdjaGFpbi5kb2NzdG9yZS5kb2N1bWVudCUyMGltcG9ydCUyMERvY3VtZW50JTBBZnJvbSUyMGxhbmdjaGFpbi50ZXh0X3NwbGl0dGVyJTIwaW1wb3J0JTIwUmVjdXJzaXZlQ2hhcmFjdGVyVGV4dFNwbGl0dGVyJTBBZnJvbSUyMGxhbmdjaGFpbi52ZWN0b3JzdG9yZXMlMjBpbXBvcnQlMjBGQUlTUyUwQWZyb20lMjBsYW5nY2hhaW5fY29tbXVuaXR5LmVtYmVkZGluZ3MlMjBpbXBvcnQlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MlMEElMEFzb3VyY2VfZG9jcyUyMCUzRCUyMCU1QiUwQSUyMCUyMCUyMCUyMERvY3VtZW50KHBhZ2VfY29udGVudCUzRGRvYyU1QiUyMnRleHQlMjIlNUQlMkMlMjBtZXRhZGF0YSUzRCU3QiUyMnNvdXJjZSUyMiUzQSUyMGRvYyU1QiUyMnNvdXJjZSUyMiU1RC5zcGxpdCglMjIlMkYlMjIpJTVCMSU1RCU3RCklMjBmb3IlMjBkb2MlMjBpbiUyMGtub3dsZWRnZV9iYXNlJTBBJTVEJTBBJTBBZG9jc19wcm9jZXNzZWQlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoY2h1bmtfc2l6ZSUzRDUwMCkuc3BsaXRfZG9jdW1lbnRzKHNvdXJjZV9kb2NzKSU1QiUzQTEwMDAlNUQlMEElMEFlbWJlZGRpbmdfbW9kZWwlMjAlM0QlMjBIdWdnaW5nRmFjZUVtYmVkZGluZ3MobW9kZWxfbmFtZSUzRCUyMnRoZW5scGVyJTJGZ3RlLXNtYWxsJTIyKSUwQXZlY3RvcmRiJTIwJTNEJTIwRkFJU1MuZnJvbV9kb2N1bWVudHMoZG9jdW1lbnRzJTNEZG9jc19wcm9jZXNzZWQlMkMlMjBlbWJlZGRpbmclM0RlbWJlZGRpbmdfbW9kZWwp",highlighted:`<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain.vectorstores <span class="hljs-keyword">import</span> FAISS
<span class="hljs-keyword">from</span> langchain_community.embeddings <span class="hljs-keyword">import</span> HuggingFaceEmbeddings

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]}) <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

docs_processed = RecursiveCharacterTextSplitter(chunk_size=<span class="hljs-number">500</span>).split_documents(source_docs)[:<span class="hljs-number">1000</span>]

embedding_model = HuggingFaceEmbeddings(model_name=<span class="hljs-string">&quot;thenlper/gte-small&quot;</span>)
vectordb = FAISS.from_documents(documents=docs_processed, embedding=embedding_model)`,wrap:!1}}),F=new w({props:{code:"YWxsX3NvdXJjZXMlMjAlM0QlMjBsaXN0KHNldCglNUJkb2MubWV0YWRhdGElNUIlMjJzb3VyY2UlMjIlNUQlMjBmb3IlMjBkb2MlMjBpbiUyMGRvY3NfcHJvY2Vzc2VkJTVEKSklMEFwcmludChhbGxfc291cmNlcyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>all_sources = <span class="hljs-built_in">list</span>(<span class="hljs-built_in">set</span>([doc.metadata[<span class="hljs-string">&quot;source&quot;</span>] <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs_processed]))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(all_sources)`,wrap:!1}}),P=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> Tool
<span class="hljs-keyword">from</span> langchain_core.vectorstores <span class="hljs-keyword">import</span> VectorStore


<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = (
        <span class="hljs-string">&quot;Retrieves some documents from the knowledge base that have the closest embeddings to the input query.&quot;</span>
    )
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        },
        <span class="hljs-string">&quot;source&quot;</span>: {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;&quot;</span>},
        <span class="hljs-string">&quot;number_of_documents&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;the number of documents to retrieve. Stay under 10 to avoid drowning in docs&quot;</span>,
        },
    }
    output_type = <span class="hljs-string">&quot;text&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, vectordb: VectorStore, all_sources: <span class="hljs-built_in">str</span>, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.vectordb = vectordb
        self.inputs[<span class="hljs-string">&quot;source&quot;</span>][
            <span class="hljs-string">&quot;description&quot;</span>
        ] = <span class="hljs-string">f&quot;The source of the documents to search, as a str representation of a list. Possible values in the list are: <span class="hljs-subst">{all_sources}</span>. If this argument is not provided, all sources will be searched.&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span>, source: <span class="hljs-built_in">str</span> = <span class="hljs-literal">None</span>, number_of_documents=<span class="hljs-number">7</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>
        number_of_documents = <span class="hljs-built_in">int</span>(number_of_documents)

        <span class="hljs-keyword">if</span> source:
            <span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(source, <span class="hljs-built_in">str</span>) <span class="hljs-keyword">and</span> <span class="hljs-string">&quot;[&quot;</span> <span class="hljs-keyword">not</span> <span class="hljs-keyword">in</span> <span class="hljs-built_in">str</span>(source):  <span class="hljs-comment"># if the source is not representing a list</span>
                source = [source]
            source = json.loads(<span class="hljs-built_in">str</span>(source).replace(<span class="hljs-string">&quot;&#x27;&quot;</span>, <span class="hljs-string">&#x27;&quot;&#x27;</span>))

        docs = self.vectordb.similarity_search(
            query,
            <span class="hljs-built_in">filter</span>=({<span class="hljs-string">&quot;source&quot;</span>: source} <span class="hljs-keyword">if</span> source <span class="hljs-keyword">else</span> <span class="hljs-literal">None</span>),
            k=number_of_documents,
        )

        <span class="hljs-keyword">if</span> <span class="hljs-built_in">len</span>(docs) == <span class="hljs-number">0</span>:
            <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;No documents found with this filtering. Try removing the source filter.&quot;</span>
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;Retrieved documents:\\n\\n&quot;</span> + <span class="hljs-string">&quot;\\n===Document===\\n&quot;</span>.join([doc.page_content <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> docs])`,wrap:!1}}),K=new J({props:{title:"Optional: Share your Retriever tool to Hub",local:"optional-share-your-retriever-tool-to-hub",headingTag:"h3"}}),ee=new w({props:{code:"c2hhcmVfdG9faHViJTIwJTNEJTIwRmFsc2UlMEElMEFpZiUyMHNoYXJlX3RvX2h1YiUzQSUwQSUyMCUyMCUyMCUyMGZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBsb2dpbiUwQSUyMCUyMCUyMCUyMGZyb20lMjByZXRyaWV2ZXIlMjBpbXBvcnQlMjBSZXRyaWV2ZXJUb29sJTBBJTBBJTIwJTIwJTIwJTIwbG9naW4oJTIyeW91cl90b2tlbiUyMiklMEElMEElMjAlMjAlMjAlMjB0b29sJTIwJTNEJTIwUmV0cmlldmVyVG9vbCh2ZWN0b3JkYiUyQyUyMGFsbF9zb3VyY2VzKSUwQSUwQSUyMCUyMCUyMCUyMHRvb2wucHVzaF90b19odWIocmVwb19pZCUzRCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIp",highlighted:`share_to_hub = <span class="hljs-literal">False</span>

<span class="hljs-keyword">if</span> share_to_hub:
    <span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> login
    <span class="hljs-keyword">from</span> retriever <span class="hljs-keyword">import</span> RetrieverTool

    login(<span class="hljs-string">&quot;your_token&quot;</span>)

    tool = RetrieverTool(vectordb, all_sources)

    tool.push_to_hub(repo_id=<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>)`,wrap:!1}}),te=new J({props:{title:"Run the agent!",local:"run-the-agent",headingTag:"h3"}}),le=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycy5hZ2VudHMlMjBpbXBvcnQlMjBIZkVuZ2luZSUyQyUyMFJlYWN0SnNvbkFnZW50JTJDJTIwbG9hZF90b29sJTBBJTBBbGxtX2VuZ2luZSUyMCUzRCUyMEhmRW5naW5lKCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtNzBCLUluc3RydWN0JTIyKSUwQSUwQXJldHJpZXZlcl90b29sJTIwJTNEJTIwbG9hZF90b29sKCUyMm0tcmljJTJGcmV0cmlldmVyLXRvb2wlMjIlMkMlMjB2ZWN0b3JkYiUzRHZlY3RvcmRiJTJDJTIwYWxsX3NvdXJjZXMlM0RhbGxfc291cmNlcyklMEFhZ2VudCUyMCUzRCUyMFJlYWN0SnNvbkFnZW50KHRvb2xzJTNEJTVCcmV0cmlldmVyX3Rvb2wlNUQlMkMlMjBsbG1fZW5naW5lJTNEbGxtX2VuZ2luZSUyQyUyMHZlcmJvc2UlM0QwKSUwQSUwQWFnZW50X291dHB1dCUyMCUzRCUyMGFnZW50LnJ1biglMjJQbGVhc2UlMjBzaG93JTIwbWUlMjBhJTIwTE9SQSUyMGZpbmV0dW5pbmclMjBzY3JpcHQlMjIpJTBBJTBBcHJpbnQoJTIyRmluYWwlMjBvdXRwdXQlM0ElMjIpJTBBcHJpbnQoYWdlbnRfb3V0cHV0KQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.agents <span class="hljs-keyword">import</span> HfEngine, ReactJsonAgent, load_tool

<span class="hljs-meta">&gt;&gt;&gt; </span>llm_engine = HfEngine(<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-70B-Instruct&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>retriever_tool = load_tool(<span class="hljs-string">&quot;m-ric/retriever-tool&quot;</span>, vectordb=vectordb, all_sources=all_sources)
<span class="hljs-meta">&gt;&gt;&gt; </span>agent = ReactJsonAgent(tools=[retriever_tool], llm_engine=llm_engine, verbose=<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>agent_output = agent.run(<span class="hljs-string">&quot;Please show me a LORA finetuning script&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),ie=new J({props:{title:"3. 💻 Debug Python code",local:"3--debug-python-code",headingTag:"h2"}}),re=new w({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMFJlYWN0Q29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBSZWFjdENvZGVBZ2VudCh0b29scyUzRCU1QiU1RCklMEElMEFjb2RlJTIwJTNEJTIwJTIyJTIyJTIyJTBBbGlzdCUzRCU1QjAlMkMlMjAxJTJDJTIwMiU1RCUwQSUwQWZvciUyMGklMjBpbiUyMHJhbmdlKDQpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQobGlzdChpKSklMEElMjIlMjIlMjIlMEElMEFmaW5hbF9hbnN3ZXIlMjAlM0QlMjBhZ2VudC5ydW4oJTBBJTIwJTIwJTIwJTIwJTIySSUyMGhhdmUlMjBzb21lJTIwY29kZSUyMHRoYXQlMjBjcmVhdGVzJTIwYSUyMGJ1ZyUzQSUyMHBsZWFzZSUyMGRlYnVnJTIwaXQlMjBhbmQlMjByZXR1cm4lMjB0aGUlMjBmaW5hbCUyMGNvZGUlMjIlMkMlMEElMjAlMjAlMjAlMjBjb2RlJTNEY29kZSUyQyUwQSk=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> ReactCodeAgent

agent = ReactCodeAgent(tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),ce=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),me=new J({props:{title:"4. Create your own LLM engine (OpenAI)",local:"4-create-your-own-llm-engine-openai",headingTag:"h2"}}),Je=new w({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> os
<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI
<span class="hljs-keyword">from</span> transformers.agents.llm_engine <span class="hljs-keyword">import</span> MessageRole, get_clean_message_list

openai_role_conversions = {
    MessageRole.TOOL_RESPONSE: <span class="hljs-string">&quot;user&quot;</span>,
}


<span class="hljs-keyword">class</span> <span class="hljs-title class_">OpenAIEngine</span>:
    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, model_name=<span class="hljs-string">&quot;gpt-4o-2024-05-13&quot;</span></span>):
        self.model_name = model_name
        self.client = OpenAI(
            api_key=os.getenv(<span class="hljs-string">&quot;OPENAI_API_KEY&quot;</span>),
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__call__</span>(<span class="hljs-params">self, messages, stop_sequences=[]</span>):
        <span class="hljs-comment"># Get clean message list</span>
        messages = get_clean_message_list(messages, role_conversions=openai_role_conversions)

        <span class="hljs-comment"># Get LLM output</span>
        response = self.client.chat.completions.create(
            model=self.model_name,
            messages=messages,
            stop=stop_sequences,
        )
        <span class="hljs-keyword">return</span> response.choices[<span class="hljs-number">0</span>].message.content


openai_engine = OpenAIEngine()
agent = ReactCodeAgent(llm_engine=openai_engine, tools=[])

code = <span class="hljs-string">&quot;&quot;&quot;
list=[0, 1, 2]

for i in range(4):
    print(list(i))
&quot;&quot;&quot;</span>

final_answer = agent.run(
    <span class="hljs-string">&quot;I have some code that creates a bug: please debug it and return the final code&quot;</span>,
    code=code,
)`,wrap:!1}}),Te=new w({props:{code:"cHJpbnQoZmluYWxfYW5zd2VyKQ==",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(final_answer)',wrap:!1}}),Ue=new J({props:{title:"➡️ Conclusion",local:"-conclusion",headingTag:"h2"}}),fe=new Wl({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/agents.md"}}),{c(){j=o("meta"),Ze=n(),Ie=o("p"),Be=n(),r(T.$$.fragment),ve=n(),r(h.$$.fragment),Ge=n(),U=o("p"),U.innerHTML=St,We=n(),d=o("p"),d.innerHTML=$t,Ae=n(),b=o("p"),b.innerHTML=Qt,ke=n(),g=o("p"),g.innerHTML=Et,_e=n(),f=o("p"),f.innerHTML=Xt,Re=n(),I=o("p"),I.textContent=qt,Ve=n(),C=o("p"),C.textContent=xt,Ne=n(),r(Z.$$.fragment),Se=n(),r(B.$$.fragment),$e=n(),v=o("p"),v.textContent=Yt,Qe=n(),G=o("p"),G.textContent=zt,Ee=n(),W=o("ul"),W.innerHTML=Ht,Xe=n(),r(A.$$.fragment),qe=n(),r(k.$$.fragment),xe=n(),r(_.$$.fragment),Ye=n(),R=o("p"),R.innerHTML=Ft,ze=n(),r(V.$$.fragment),He=n(),N=o("p"),N.innerHTML=Lt,Fe=n(),S=o("p"),S.textContent=Pt,Le=n(),$=o("ul"),$.innerHTML=Kt,Pe=n(),Q=o("p"),Q.innerHTML=Dt,Ke=n(),E=o("p"),E.innerHTML=Ot,De=n(),r(X.$$.fragment),Oe=n(),q=o("p"),q.textContent=el,et=n(),r(x.$$.fragment),tt=n(),Y=o("p"),Y.textContent=tl,lt=n(),z=o("p"),z.textContent=ll,st=n(),H=o("p"),H.textContent=sl,nt=n(),r(F.$$.fragment),at=n(),L=o("pre"),L.textContent=nl,ot=n(),r(P.$$.fragment),it=n(),r(K.$$.fragment),Mt=n(),D=o("p"),D.innerHTML=al,rt=n(),O=o("p"),O.innerHTML=ol,pt=n(),r(ee.$$.fragment),yt=n(),r(te.$$.fragment),ct=n(),r(le.$$.fragment),ut=n(),se=o("pre"),se.textContent=il,mt=n(),ne=o("p"),ne.innerHTML=Ml,wt=n(),ae=o("p"),ae.textContent=rl,jt=n(),oe=o("p"),oe.innerHTML=pl,Jt=n(),r(ie.$$.fragment),Tt=n(),Me=o("p"),Me.textContent=yl,ht=n(),r(re.$$.fragment),Ut=n(),pe=o("p"),pe.textContent=cl,dt=n(),ye=o("p"),ye.textContent=ul,bt=n(),r(ce.$$.fragment),gt=n(),ue=o("pre"),ue.textContent=ml,ft=n(),r(me.$$.fragment),It=n(),we=o("p"),we.innerHTML=wl,Ct=n(),je=o("ol"),je.innerHTML=jl,Zt=n(),r(Je.$$.fragment),Bt=n(),r(Te.$$.fragment),vt=n(),he=o("pre"),he.textContent=Jl,Gt=n(),r(Ue.$$.fragment),Wt=n(),de=o("p"),de.textContent=Tl,At=n(),be=o("p"),be.innerHTML=hl,kt=n(),ge=o("p"),ge.textContent=Ul,_t=n(),r(fe.$$.fragment),Rt=n(),Ce=o("p"),this.h()},l(e){const t=Bl("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(l),Ze=a(e),Ie=i(e,"P",{}),dl(Ie).forEach(l),Be=a(e),p(T.$$.fragment,e),ve=a(e),p(h.$$.fragment,e),Ge=a(e),U=i(e,"P",{"data-svelte-h":!0}),M(U)!=="svelte-1xlqnsv"&&(U.innerHTML=St),We=a(e),d=i(e,"P",{"data-svelte-h":!0}),M(d)!=="svelte-qt5igr"&&(d.innerHTML=$t),Ae=a(e),b=i(e,"P",{"data-svelte-h":!0}),M(b)!=="svelte-1mh34dv"&&(b.innerHTML=Qt),ke=a(e),g=i(e,"P",{"data-svelte-h":!0}),M(g)!=="svelte-mmy9qo"&&(g.innerHTML=Et),_e=a(e),f=i(e,"P",{"data-svelte-h":!0}),M(f)!=="svelte-176yg59"&&(f.innerHTML=Xt),Re=a(e),I=i(e,"P",{"data-svelte-h":!0}),M(I)!=="svelte-fc6q9b"&&(I.textContent=qt),Ve=a(e),C=i(e,"P",{"data-svelte-h":!0}),M(C)!=="svelte-16cuoal"&&(C.textContent=xt),Ne=a(e),p(Z.$$.fragment,e),Se=a(e),p(B.$$.fragment,e),$e=a(e),v=i(e,"P",{"data-svelte-h":!0}),M(v)!=="svelte-1354tpb"&&(v.textContent=Yt),Qe=a(e),G=i(e,"P",{"data-svelte-h":!0}),M(G)!=="svelte-1yb5yrl"&&(G.textContent=zt),Ee=a(e),W=i(e,"UL",{"data-svelte-h":!0}),M(W)!=="svelte-1dqrk95"&&(W.innerHTML=Ht),Xe=a(e),p(A.$$.fragment,e),qe=a(e),p(k.$$.fragment,e),xe=a(e),p(_.$$.fragment,e),Ye=a(e),R=i(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1hg95q8"&&(R.innerHTML=Ft),ze=a(e),p(V.$$.fragment,e),He=a(e),N=i(e,"P",{"data-svelte-h":!0}),M(N)!=="svelte-1wknlb6"&&(N.innerHTML=Lt),Fe=a(e),S=i(e,"P",{"data-svelte-h":!0}),M(S)!=="svelte-19h5931"&&(S.textContent=Pt),Le=a(e),$=i(e,"UL",{"data-svelte-h":!0}),M($)!=="svelte-5uub6"&&($.innerHTML=Kt),Pe=a(e),Q=i(e,"P",{"data-svelte-h":!0}),M(Q)!=="svelte-1kfx2et"&&(Q.innerHTML=Dt),Ke=a(e),E=i(e,"P",{"data-svelte-h":!0}),M(E)!=="svelte-1qw64fs"&&(E.innerHTML=Ot),De=a(e),p(X.$$.fragment,e),Oe=a(e),q=i(e,"P",{"data-svelte-h":!0}),M(q)!=="svelte-jy4i2f"&&(q.textContent=el),et=a(e),p(x.$$.fragment,e),tt=a(e),Y=i(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-5pp8py"&&(Y.textContent=tl),lt=a(e),z=i(e,"P",{"data-svelte-h":!0}),M(z)!=="svelte-1cx88lu"&&(z.textContent=ll),st=a(e),H=i(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-1vgfwws"&&(H.textContent=sl),nt=a(e),p(F.$$.fragment,e),at=a(e),L=i(e,"PRE",{"data-svelte-h":!0}),M(L)!=="svelte-87x3d8"&&(L.textContent=nl),ot=a(e),p(P.$$.fragment,e),it=a(e),p(K.$$.fragment,e),Mt=a(e),D=i(e,"P",{"data-svelte-h":!0}),M(D)!=="svelte-19hckuz"&&(D.innerHTML=al),rt=a(e),O=i(e,"P",{"data-svelte-h":!0}),M(O)!=="svelte-1wpkyax"&&(O.innerHTML=ol),pt=a(e),p(ee.$$.fragment,e),yt=a(e),p(te.$$.fragment,e),ct=a(e),p(le.$$.fragment,e),ut=a(e),se=i(e,"PRE",{"data-svelte-h":!0}),M(se)!=="svelte-l44zt6"&&(se.textContent=il),mt=a(e),ne=i(e,"P",{"data-svelte-h":!0}),M(ne)!=="svelte-6d9ubm"&&(ne.innerHTML=Ml),wt=a(e),ae=i(e,"P",{"data-svelte-h":!0}),M(ae)!=="svelte-ud3g55"&&(ae.textContent=rl),jt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),M(oe)!=="svelte-3qqlok"&&(oe.innerHTML=pl),Jt=a(e),p(ie.$$.fragment,e),Tt=a(e),Me=i(e,"P",{"data-svelte-h":!0}),M(Me)!=="svelte-5kn15r"&&(Me.textContent=yl),ht=a(e),p(re.$$.fragment,e),Ut=a(e),pe=i(e,"P",{"data-svelte-h":!0}),M(pe)!=="svelte-168ebuv"&&(pe.textContent=cl),dt=a(e),ye=i(e,"P",{"data-svelte-h":!0}),M(ye)!=="svelte-vscncs"&&(ye.textContent=ul),bt=a(e),p(ce.$$.fragment,e),gt=a(e),ue=i(e,"PRE",{"data-svelte-h":!0}),M(ue)!=="svelte-1t45l4d"&&(ue.textContent=ml),ft=a(e),p(me.$$.fragment,e),It=a(e),we=i(e,"P",{"data-svelte-h":!0}),M(we)!=="svelte-6gn5q5"&&(we.innerHTML=wl),Ct=a(e),je=i(e,"OL",{"data-svelte-h":!0}),M(je)!=="svelte-1o7lqh"&&(je.innerHTML=jl),Zt=a(e),p(Je.$$.fragment,e),Bt=a(e),p(Te.$$.fragment,e),vt=a(e),he=i(e,"PRE",{"data-svelte-h":!0}),M(he)!=="svelte-tgqz6q"&&(he.textContent=Jl),Gt=a(e),p(Ue.$$.fragment,e),Wt=a(e),de=i(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-hpfue3"&&(de.textContent=Tl),At=a(e),be=i(e,"P",{"data-svelte-h":!0}),M(be)!=="svelte-1nxb7v"&&(be.innerHTML=hl),kt=a(e),ge=i(e,"P",{"data-svelte-h":!0}),M(ge)!=="svelte-1ctcozl"&&(ge.textContent=Ul),_t=a(e),p(fe.$$.fragment,e),Rt=a(e),Ce=i(e,"P",{}),dl(Ce).forEach(l),this.h()},h(){bl(j,"name","hf:doc:metadata"),bl(j,"content",kl)},m(e,t){vl(document.head,j),s(e,Ze,t),s(e,Ie,t),s(e,Be,t),y(T,e,t),s(e,ve,t),y(h,e,t),s(e,Ge,t),s(e,U,t),s(e,We,t),s(e,d,t),s(e,Ae,t),s(e,b,t),s(e,ke,t),s(e,g,t),s(e,_e,t),s(e,f,t),s(e,Re,t),s(e,I,t),s(e,Ve,t),s(e,C,t),s(e,Ne,t),y(Z,e,t),s(e,Se,t),y(B,e,t),s(e,$e,t),s(e,v,t),s(e,Qe,t),s(e,G,t),s(e,Ee,t),s(e,W,t),s(e,Xe,t),y(A,e,t),s(e,qe,t),y(k,e,t),s(e,xe,t),y(_,e,t),s(e,Ye,t),s(e,R,t),s(e,ze,t),y(V,e,t),s(e,He,t),s(e,N,t),s(e,Fe,t),s(e,S,t),s(e,Le,t),s(e,$,t),s(e,Pe,t),s(e,Q,t),s(e,Ke,t),s(e,E,t),s(e,De,t),y(X,e,t),s(e,Oe,t),s(e,q,t),s(e,et,t),y(x,e,t),s(e,tt,t),s(e,Y,t),s(e,lt,t),s(e,z,t),s(e,st,t),s(e,H,t),s(e,nt,t),y(F,e,t),s(e,at,t),s(e,L,t),s(e,ot,t),y(P,e,t),s(e,it,t),y(K,e,t),s(e,Mt,t),s(e,D,t),s(e,rt,t),s(e,O,t),s(e,pt,t),y(ee,e,t),s(e,yt,t),y(te,e,t),s(e,ct,t),y(le,e,t),s(e,ut,t),s(e,se,t),s(e,mt,t),s(e,ne,t),s(e,wt,t),s(e,ae,t),s(e,jt,t),s(e,oe,t),s(e,Jt,t),y(ie,e,t),s(e,Tt,t),s(e,Me,t),s(e,ht,t),y(re,e,t),s(e,Ut,t),s(e,pe,t),s(e,dt,t),s(e,ye,t),s(e,bt,t),y(ce,e,t),s(e,gt,t),s(e,ue,t),s(e,ft,t),y(me,e,t),s(e,It,t),s(e,we,t),s(e,Ct,t),s(e,je,t),s(e,Zt,t),y(Je,e,t),s(e,Bt,t),y(Te,e,t),s(e,vt,t),s(e,he,t),s(e,Gt,t),y(Ue,e,t),s(e,Wt,t),s(e,de,t),s(e,At,t),s(e,be,t),s(e,kt,t),s(e,ge,t),s(e,_t,t),y(fe,e,t),s(e,Rt,t),s(e,Ce,t),Vt=!0},p:fl,i(e){Vt||(c(T.$$.fragment,e),c(h.$$.fragment,e),c(Z.$$.fragment,e),c(B.$$.fragment,e),c(A.$$.fragment,e),c(k.$$.fragment,e),c(_.$$.fragment,e),c(V.$$.fragment,e),c(X.$$.fragment,e),c(x.$$.fragment,e),c(F.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(ee.$$.fragment,e),c(te.$$.fragment,e),c(le.$$.fragment,e),c(ie.$$.fragment,e),c(re.$$.fragment,e),c(ce.$$.fragment,e),c(me.$$.fragment,e),c(Je.$$.fragment,e),c(Te.$$.fragment,e),c(Ue.$$.fragment,e),c(fe.$$.fragment,e),Vt=!0)},o(e){u(T.$$.fragment,e),u(h.$$.fragment,e),u(Z.$$.fragment,e),u(B.$$.fragment,e),u(A.$$.fragment,e),u(k.$$.fragment,e),u(_.$$.fragment,e),u(V.$$.fragment,e),u(X.$$.fragment,e),u(x.$$.fragment,e),u(F.$$.fragment,e),u(P.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(te.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(re.$$.fragment,e),u(ce.$$.fragment,e),u(me.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(Ue.$$.fragment,e),u(fe.$$.fragment,e),Vt=!1},d(e){e&&(l(Ze),l(Ie),l(Be),l(ve),l(Ge),l(U),l(We),l(d),l(Ae),l(b),l(ke),l(g),l(_e),l(f),l(Re),l(I),l(Ve),l(C),l(Ne),l(Se),l($e),l(v),l(Qe),l(G),l(Ee),l(W),l(Xe),l(qe),l(xe),l(Ye),l(R),l(ze),l(He),l(N),l(Fe),l(S),l(Le),l($),l(Pe),l(Q),l(Ke),l(E),l(De),l(Oe),l(q),l(et),l(tt),l(Y),l(lt),l(z),l(st),l(H),l(nt),l(at),l(L),l(ot),l(it),l(Mt),l(D),l(rt),l(O),l(pt),l(yt),l(ct),l(ut),l(se),l(mt),l(ne),l(wt),l(ae),l(jt),l(oe),l(Jt),l(Tt),l(Me),l(ht),l(Ut),l(pe),l(dt),l(ye),l(bt),l(gt),l(ue),l(ft),l(It),l(we),l(Ct),l(je),l(Zt),l(Bt),l(vt),l(he),l(Gt),l(Wt),l(de),l(At),l(be),l(kt),l(ge),l(_t),l(Rt),l(Ce)),l(j),m(T,e),m(h,e),m(Z,e),m(B,e),m(A,e),m(k,e),m(_,e),m(V,e),m(X,e),m(x,e),m(F,e),m(P,e),m(K,e),m(ee,e),m(te,e),m(le,e),m(ie,e),m(re,e),m(ce,e),m(me,e),m(Je,e),m(Te,e),m(Ue,e),m(fe,e)}}}const kl='{"title":"Build an agent with tool-calling superpowers 🦸 using Transformers Agents","local":"build-an-agent-with-tool-calling-superpowers--using-transformers-agents","sections":[{"title":"1. 🏞️ Multimodal + 🌐 Web-browsing assistant","local":"1--multimodal---web-browsing-assistant","sections":[],"depth":2},{"title":"2. 📚💬 RAG with Iterative query refinement & Source selection","local":"2--rag-with-iterative-query-refinement--source-selection","sections":[{"title":"Optional: Share your Retriever tool to Hub","local":"optional-share-your-retriever-tool-to-hub","sections":[],"depth":3},{"title":"Run the agent!","local":"run-the-agent","sections":[],"depth":3}],"depth":2},{"title":"3. 💻 Debug Python code","local":"3--debug-python-code","sections":[],"depth":2},{"title":"4. Create your own LLM engine (OpenAI)","local":"4-create-your-own-llm-engine-openai","sections":[],"depth":2},{"title":"➡️ Conclusion","local":"-conclusion","sections":[],"depth":2}],"depth":1}';function _l(Nt){return Il(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class $l extends Cl{constructor(j){super(),Zl(this,j,_l,Al,gl,{})}}export{$l as component};
