import{s as sl,n as nl,o as al}from"../chunks/scheduler.889ebb13.js";import{S as ol,i as rl,g as n,s as o,u as m,A as il,h as a,f as t,c as r,j as u,v as J,y as i,k as p,o as c,a as s,w as T,d,t as f,x as h}from"../chunks/index.8980e686.js";import{I as je}from"../chunks/IconCopyLink.357761cd.js";import{C as j}from"../chunks/CodeBlock.25fc3430.js";import{D as pl}from"../chunks/DocNotebookDropdown.f8a50280.js";function cl(wt){let M,ke,he,_e,U,k,Me,Z,dt,me,yt="TensorFlow 모델을 위한 XLA 통합",ve,V,Re,I,bt='XLA(Accelerated Linear Algebra)는 TensorFlow 모델의 실행 시간을 가속화하기 위한 컴파일러입니다. <a href="https://www.tensorflow.org/xla" rel="nofollow">공식 문서</a>에 따르면 다음과 같습니다:',Ce,x,gt="XLA(Accelerated Linear Algebra)는 선형 대수를 위한 도메인 특화 컴파일러로, TensorFlow 모델을 소스 코드 변경 없이 가속화할 수 있습니다.",Ze,X,jt='TensorFlow에서 XLA를 사용하는 것은 간단합니다. XLA는 <code>tensorflow</code> 라이브러리 내에 패키지로 제공되며, <a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow"><code>tf.function</code></a>과 같은 그래프 생성 함수에서 <code>jit_compile</code> 인수를 사용하여 활성화할 수 있습니다. <code>fit()</code> 및 <code>predict()</code>와 같은 Keras 메소드를 사용하는 경우, <code>jit_compile</code> 인수를 <code>model.compile()</code>에 전달하여 XLA를 간단하게 활성화할 수 있습니다. 그러나 XLA는 이러한 메소드에 국한되지 않고 임의의 <code>tf.function</code>을 가속화하는 데에도 사용할 수 있습니다.',Ve,Q,kt='🤗 Transformers에서는 <a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>, <a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>, <a href="https://huggingface.co/docs/transformers/model_doc/opt" rel="nofollow">OPT</a>와 같은 모델의 텍스트 생성, 그리고 <a href="https://huggingface.co/docs/transformers/model_doc/whisper" rel="nofollow">Whisper</a>와 같은 모델의 음성 처리를 포함하여 여러 TensorFlow 메소드가 XLA와 호환되도록 다시 작성되었습니다.',Ie,E,_t="정확한 속도 향상은 모델에 따라 다르지만, 🤗 Transformers 내의 TensorFlow 텍스트 생성 모델의 경우 최대 100배의 속도 향상을 확인했습니다. 이 문서에서는 이러한 모델에 대해 XLA를 사용하여 최대 성능을 얻는 방법을 설명합니다. 또한 XLA 통합의 벤치마크 및 디자인 철학에 대한 추가 자료 링크도 제공할 것입니다.",xe,w,_,Ue,G,ft,Je,vt="XLA를 사용하여 TF 함수 실행하기",Xe,$,Rt="TensorFlow에서 다음과 같은 모델을 고려해 봅시다:",Qe,B,Ee,W,Ct="위 모델은 차원이 <code>(10, )</code>인 입력을 받습니다. 다음과 같이 모델을 사용하여 순전파를 실행할 수 있습니다:",Ge,A,$e,F,Zt="XLA로 컴파일된 함수로 순전파를 실행하려면 다음과 같이 해야 합니다:",Be,z,We,L,Vt="<code>model</code>의 기본 <code>call()</code> 함수는 XLA 그래프를 컴파일하는 데 사용됩니다. 그러나 다른 모델 함수를 XLA로 컴파일하려면 다음과 같이 할 수도 있습니다:",Ae,N,Fe,y,v,we,H,ht,Te,It="🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기",ze,D,xt="🤗 Transformers에서 XLA로 가속화된 생성을 활성화하려면 최신 버전의 <code>transformers</code>가 설치되어 있어야 합니다. 다음과 같이 설치할 수 있습니다:",Le,Y,Ne,q,Xt="그리고 다음 코드를 실행할 수 있습니다:",He,S,De,O,Qt="알 수 있듯이, <code>generate()</code>에서 XLA를 활성화하는 것은 단 한 줄의 코드입니다. 코드의 나머지 부분은 변경되지 않습니다. 그러나 위 코드 스니펫에서는 XLA에 특정한 몇 가지 주의할 점이 있습니다. XLA가 가져다줄 속도 향상을 실현하기 위해서는 이를 알고 있어야 합니다. 다음 섹션에서 이에 대해 논의합니다.",Ye,b,R,ye,P,Mt,de,Et="주의할 점",qe,K,Gt='XLA 활성화 함수(<code>xla_generate()</code>와 같은)를 처음 실행할 때 내부적으로 계산 그래프를 추론하려고 하며, 이는 시간이 소요됩니다. 이 과정은 <a href="https://www.tensorflow.org/guide/intro_to_graphs#when_is_a_function_tracing" rel="nofollow">“추적(tracing)”</a>이라고 알려져 있습니다.',Se,ee,$t="생성 시간이 빠르지 않다는 것을 알 수 있을 것입니다. <code>xla_generate()</code>(또는 다른 XLA 활성화 함수)의 연속 호출은 함수에 전달된 입력이 초기에 구축된 계산 그래프와 동일한 형태를 따른다면, 계산 그래프를 추론할 필요가 없습니다. 이는 입력 형태가 고정된 모달리티(예: 이미지)에는 문제가 되지 않지만, 가변 입력 형태 모달리티(예: 텍스트)를 사용할 때 주의해야 합니다.",Oe,te,Bt="<code>xla_generate()</code>가 항상 동일한 입력 형태로 동작하도록 하려면, 토크나이저를 호출할 때 <code>padding</code> 인수를 지정할 수 있습니다.",Pe,le,Ke,se,Wt="이렇게 하면 <code>xla_generate()</code>에 대한 입력이 항상 추적된 형태로 전달되어 생성 시간이 가속화됩니다. 다음 코드로 이를 확인할 수 있습니다:",et,ne,tt,ae,At="Tesla T4 GPU에서는 다음과 같은 출력을 예상할 수 있습니다:",lt,oe,st,re,Ft="<code>xla_generate()</code>의 첫 번째 호출은 추적 때문에 시간이 오래 걸리지만, 연속 호출은 몇 배나 빠릅니다. 생성 옵션에 대한 어떤 변경이든 다시 추적을 유발하므로 생성 시간이 느려질 수 있음을 명심하세요.",nt,ie,zt="이 문서에서는 🤗 Transformers에서 제공하는 모든 텍스트 생성 옵션을 다루지 않았습니다. 고급 사용 사례에 대해 문서를 참조하시기 바랍니다.",at,g,C,be,pe,Ut,fe,Lt="추가 자료",ot,ce,Nt="여기에 🤗 Transformers와 XLA에 대해 더 자세히 알고 싶은 경우 도움이 될 수 있는 몇 가지 추가 자료를 제공합니다.",rt,ue,Ht='<li><a href="https://colab.research.google.com/github/huggingface/blog/blob/main/notebooks/91_tf_xla_generate.ipynb" rel="nofollow">이 Colab 노트북</a>은 XLA와 호환되는 인코더-디코더(<a href="https://huggingface.co/docs/transformers/model_doc/t5" rel="nofollow">T5</a>와 같은) 및 디코더 전용(<a href="https://huggingface.co/docs/transformers/model_doc/gpt2" rel="nofollow">GPT2</a>와 같은) 텍스트 생성 모델을 실험해 볼 수 있는 대화형 데모를 제공합니다.</li> <li><a href="https://huggingface.co/blog/tf-xla-generate" rel="nofollow">이 블로그 글</a>은 TensorFlow에서 XLA에 대한 친절한 소개와 함께 XLA와 호환되는 모델의 비교 벤치마크에 대한 개요를 제공합니다.</li> <li><a href="https://blog.tensorflow.org/2022/11/how-hugging-face-improved-text-generation-performance-with-xla.html" rel="nofollow">이 블로그 글</a>은 🤗 Transformers의 TensorFlow 모델에 XLA 지원을 추가하는 것에 대한 디자인 철학을 논의합니다.</li> <li>XLA와 TensorFlow 그래프에 대해 더 자세히 알고 싶은 경우 추천하는 글:<ul><li><a href="https://www.tensorflow.org/xla" rel="nofollow">XLA: 기계 학습을 위한 최적화 컴파일러</a></li> <li><a href="https://www.tensorflow.org/guide/intro_to_graphs" rel="nofollow">그래프 및 tf.function 소개</a></li> <li><a href="https://www.tensorflow.org/guide/function" rel="nofollow">tf.function으로 성능 향상하기</a></li></ul></li>',it,ge,pt;return Z=new je({}),V=new pl({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tf_xla.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/pytorch/tf_xla.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/ko/tensorflow/tf_xla.ipynb"}]}}),G=new je({}),B=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEElMEFtb2RlbCUyMCUzRCUyMHRmLmtlcmFzLlNlcXVlbnRpYWwoJTBBJTIwJTIwJTIwJTIwJTVCdGYua2VyYXMubGF5ZXJzLkRlbnNlKDEwJTJDJTIwaW5wdXRfc2hhcGUlM0QoMTAlMkMpJTJDJTIwYWN0aXZhdGlvbiUzRCUyMnJlbHUlMjIpJTJDJTIwdGYua2VyYXMubGF5ZXJzLkRlbnNlKDUlMkMlMjBhY3RpdmF0aW9uJTNEJTIyc29mdG1heCUyMiklNUQlMEEp",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf

model = tf.keras.Sequential(
    [tf.keras.layers.Dense(<span class="hljs-number">10</span>, input_shape=(<span class="hljs-number">10</span>,), activation=<span class="hljs-string">&quot;relu&quot;</span>), tf.keras.layers.Dense(<span class="hljs-number">5</span>, activation=<span class="hljs-string">&quot;softmax&quot;</span>)]
)`}}),A=new j({props:{code:"JTIzJTIwJUVCJUFBJUE4JUVCJThEJUI4JUVDJTk3JTkwJTIwJUVCJThDJTgwJUVEJTk1JTlDJTIwJUVDJTlFJTg0JUVDJTlEJTk4JUVDJTlEJTk4JTIwJUVDJTlFJTg1JUVCJUEwJUE1JUVDJTlEJTg0JTIwJUVDJTgzJTlEJUVDJTg0JUIxJUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQWJhdGNoX3NpemUlMjAlM0QlMjAxNiUwQWlucHV0X3ZlY3Rvcl9kaW0lMjAlM0QlMjAxMCUwQXJhbmRvbV9pbnB1dHMlMjAlM0QlMjB0Zi5yYW5kb20ubm9ybWFsKChiYXRjaF9zaXplJTJDJTIwaW5wdXRfdmVjdG9yX2RpbSkpJTBBJTBBJTIzJTIwJUVDJTg4JTlDJUVDJUEwJTg0JUVEJThDJThDJUVCJUE1JUJDJTIwJUVDJThCJUE0JUVEJTk2JTg5JUVEJTk1JUE5JUVCJThCJTg4JUVCJThCJUE0LiUwQV8lMjAlM0QlMjBtb2RlbChyYW5kb21faW5wdXRzKQ==",highlighted:`<span class="hljs-comment"># 모델에 대한 임의의 입력을 생성합니다.</span>
batch_size = <span class="hljs-number">16</span>
input_vector_dim = <span class="hljs-number">10</span>
random_inputs = tf.random.normal((batch_size, input_vector_dim))

<span class="hljs-comment"># 순전파를 실행합니다.</span>
_ = model(random_inputs)`}}),z=new j({props:{code:"eGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBXyUyMCUzRCUyMHhsYV9mbihyYW5kb21faW5wdXRzKQ==",highlighted:`xla_fn = tf.function(model, jit_compile=<span class="hljs-literal">True</span>)
_ = xla_fn(random_inputs)`}}),N=new j({props:{code:"bXlfeGxhX2ZuJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwubXlfeGxhX2ZuJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKQ==",highlighted:'my_xla_fn = tf.function(model.my_xla_fn, jit_compile=<span class="hljs-literal">True</span>)'}}),H=new je({}),Y=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMHRyYW5zZm9ybWVycyUyMC0tdXBncmFkZQ==",highlighted:"pip install transformers --upgrade"}}),S=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEElMjMlMjAlRUMlQjUlOUMlRUMlODYlOEMlMjAlRUIlQjIlODQlRUMlQTAlODQlRUMlOUQlOTglMjBUcmFuc2Zvcm1lcnMlRUElQjAlODAlMjAlRUMlODQlQTQlRUMlQjklOTglRUIlOTAlOTglRUMlOTYlQjQlMjAlRUMlOUUlODglRUMlQTclODAlMjAlRUMlOTUlOEElRUIlOEIlQTQlRUIlQTklQjQlMjAlRUMlOTglQTQlRUIlQTUlOTglRUElQjAlODAlMjAlRUIlQjAlOUMlRUMlODMlOUQlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBZnJvbSUyMHRyYW5zZm9ybWVycy51dGlscyUyMGltcG9ydCUyMGNoZWNrX21pbl92ZXJzaW9uJTBBJTBBY2hlY2tfbWluX3ZlcnNpb24oJTIyNC4yMS4wJTIyKSUwQSUwQSUwQXRva2VuaXplciUyMCUzRCUyMEF1dG9Ub2tlbml6ZXIuZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIlMkMlMjBwYWRkaW5nX3NpZGUlM0QlMjJsZWZ0JTIyJTJDJTIwcGFkX3Rva2VuJTNEJTIyJTNDJTJGcyUzRSUyMiklMEFtb2RlbCUyMCUzRCUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0uZnJvbV9wcmV0cmFpbmVkKCUyMmdwdDIlMjIpJTBBaW5wdXRfc3RyaW5nJTIwJTNEJTIwJTVCJTIyVGVuc29yRmxvdyUyMGlzJTIyJTVEJTBBJTBBJTIzJTIwWExBJTIwJUVDJTgzJTlEJUVDJTg0JUIxJTIwJUVEJTk1JUE4JUVDJTg4JTk4JUVCJUE1JUJDJTIwJUVCJUE3JThDJUVCJTkzJUE0JUVBJUI4JUIwJTIwJUVDJTlDJTg0JUVEJTk1JTlDJTIwJUVEJTk1JTlDJTIwJUVDJUE0JTg0JTBBeGxhX2dlbmVyYXRlJTIwJTNEJTIwdGYuZnVuY3Rpb24obW9kZWwuZ2VuZXJhdGUlMkMlMjBqaXRfY29tcGlsZSUzRFRydWUpJTBBJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMiklMEElMjMlMjBHZW5lcmF0ZWQlMjAtLSUyMFRlbnNvckZsb3clMjBpcyUyMGFuJTIwb3Blbi1zb3VyY2UlMkMlMjBvcGVuLXNvdXJjZSUyQyUyMGRpc3RyaWJ1dGVkLXNvdXJjZSUyMGFwcGxpY2F0aW9uJTIwJTIzJTIwZnJhbWV3b3JrJTIwZm9yJTIwdGhl",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

<span class="hljs-comment"># 최소 버전의 Transformers가 설치되어 있지 않다면 오류가 발생합니다.</span>
<span class="hljs-keyword">from</span> transformers.utils <span class="hljs-keyword">import</span> check_min_version

check_min_version(<span class="hljs-string">&quot;4.21.0&quot;</span>)


tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

<span class="hljs-comment"># XLA 생성 함수를 만들기 위한 한 줄</span>
xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

tokenized_input = tokenizer(input_string, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)

decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)
<span class="hljs-comment"># Generated -- TensorFlow is an open-source, open-source, distributed-source application # framework for the</span>`}}),P=new je({}),le=new j({props:{code:"aW1wb3J0JTIwdGVuc29yZmxvdyUyMGFzJTIwdGYlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Rva2VuaXplciUyQyUyMFRGQXV0b01vZGVsRm9yQ2F1c2FsTE0lMEElMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyJTJDJTIwcGFkZGluZ19zaWRlJTNEJTIybGVmdCUyMiUyQyUyMHBhZF90b2tlbiUzRCUyMiUzQyUyRnMlM0UlMjIpJTBBbW9kZWwlMjAlM0QlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJncHQyJTIyKSUwQWlucHV0X3N0cmluZyUyMCUzRCUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiU1RCUwQSUwQXhsYV9nZW5lcmF0ZSUyMCUzRCUyMHRmLmZ1bmN0aW9uKG1vZGVsLmdlbmVyYXRlJTJDJTIwaml0X2NvbXBpbGUlM0RUcnVlKSUwQSUwQSUyMyUyMCVFQyU5NyVBQyVFQSVCOCVCMCVFQyU4NCU5QyUyQyUyMHBhZGRpbmclMjAlRUMlOTglQjUlRUMlODUlOTglRUMlOUQlQjQlMjAlRUMlOUUlODglRUIlOEElOTQlMjAlRUQlODYlQTAlRUQlODElQUMlRUIlODIlOTglRUMlOUQlQjQlRUMlQTAlODAlRUIlQTUlQkMlMjAlRUQlOTglQjglRUMlQjYlOUMlRUQlOTUlQTklRUIlOEIlODglRUIlOEIlQTQuJTBBdG9rZW5pemVkX2lucHV0JTIwJTNEJTIwdG9rZW5pemVyKGlucHV0X3N0cmluZyUyQyUyMHBhZF90b19tdWx0aXBsZV9vZiUzRDglMkMlMjBwYWRkaW5nJTNEVHJ1ZSUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIydGYlMjIpJTBBJTBBZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBZGVjb2RlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmRlY29kZShnZW5lcmF0ZWRfdG9rZW5zJTVCMCU1RCUyQyUyMHNraXBfc3BlY2lhbF90b2tlbnMlM0RUcnVlKSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjAtLSUyMCU3QmRlY29kZWRfdGV4dCU3RCUyMik=",highlighted:`<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)
input_string = [<span class="hljs-string">&quot;TensorFlow is&quot;</span>]

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 여기서, padding 옵션이 있는 토크나이저를 호출합니다.</span>
tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)

generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
decoded_text = tokenizer.decode(generated_tokens[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated -- <span class="hljs-subst">{decoded_text}</span>&quot;</span>)`}}),ne=new j({props:{code:"aW1wb3J0JTIwdGltZSUwQWltcG9ydCUyMHRlbnNvcmZsb3clMjBhcyUyMHRmJTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMkMlMjBURkF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBdG9rZW5pemVyJTIwJTNEJTIwQXV0b1Rva2VuaXplci5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiUyQyUyMHBhZGRpbmdfc2lkZSUzRCUyMmxlZnQlMjIlMkMlMjBwYWRfdG9rZW4lM0QlMjIlM0MlMkZzJTNFJTIyKSUwQW1vZGVsJTIwJTNEJTIwVEZBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyZ3B0MiUyMiklMEElMEF4bGFfZ2VuZXJhdGUlMjAlM0QlMjB0Zi5mdW5jdGlvbihtb2RlbC5nZW5lcmF0ZSUyQyUyMGppdF9jb21waWxlJTNEVHJ1ZSklMEElMEFmb3IlMjBpbnB1dF9zdHJpbmclMjBpbiUyMCU1QiUyMlRlbnNvckZsb3clMjBpcyUyMiUyQyUyMCUyMlRlbnNvckZsb3clMjBpcyUyMGElMjIlMkMlMjAlMjJURkxpdGUlMjBpcyUyMGElMjIlNUQlM0ElMEElMjAlMjAlMjAlMjB0b2tlbml6ZWRfaW5wdXQlMjAlM0QlMjB0b2tlbml6ZXIoaW5wdXRfc3RyaW5nJTJDJTIwcGFkX3RvX211bHRpcGxlX29mJTNEOCUyQyUyMHBhZGRpbmclM0RUcnVlJTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJ0ZiUyMiklMEElMjAlMjAlMjAlMjBzdGFydCUyMCUzRCUyMHRpbWUudGltZV9ucygpJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdGVkX3Rva2VucyUyMCUzRCUyMHhsYV9nZW5lcmF0ZSgqKnRva2VuaXplZF9pbnB1dCUyQyUyMG51bV9iZWFtcyUzRDIpJTBBJTIwJTIwJTIwJTIwZW5kJTIwJTNEJTIwdGltZS50aW1lX25zKCklMEElMjAlMjAlMjAlMjBwcmludChmJTIyRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwJTdCKGVuZCUyMC0lMjBzdGFydCklMjAlMkYlMjAxZTYlM0EuMWYlN0QlMjBtcyU1Q24lMjIp",highlighted:`<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">import</span> tensorflow <span class="hljs-keyword">as</span> tf
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer, TFAutoModelForCausalLM

tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>, padding_side=<span class="hljs-string">&quot;left&quot;</span>, pad_token=<span class="hljs-string">&quot;&lt;/s&gt;&quot;</span>)
model = TFAutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;gpt2&quot;</span>)

xla_generate = tf.function(model.generate, jit_compile=<span class="hljs-literal">True</span>)

<span class="hljs-keyword">for</span> input_string <span class="hljs-keyword">in</span> [<span class="hljs-string">&quot;TensorFlow is&quot;</span>, <span class="hljs-string">&quot;TensorFlow is a&quot;</span>, <span class="hljs-string">&quot;TFLite is a&quot;</span>]:
    tokenized_input = tokenizer(input_string, pad_to_multiple_of=<span class="hljs-number">8</span>, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;tf&quot;</span>)
    start = time.time_ns()
    generated_tokens = xla_generate(**tokenized_input, num_beams=<span class="hljs-number">2</span>)
    end = time.time_ns()
    <span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Execution time -- <span class="hljs-subst">{(end - start) / <span class="hljs-number">1e6</span>:<span class="hljs-number">.1</span>f}</span> ms\\n&quot;</span>)`}}),oe=new j({props:{code:"RXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwMzA4MTkuNiUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzkuMCUyMG1zJTBBJTBBRXhlY3V0aW9uJTIwdGltZSUyMC0tJTIwNzguOSUyMG1z",highlighted:`Execution time -- 30819.6 ms

Execution time -- 79.0 ms

Execution time -- 78.9 ms`}}),pe=new je({}),{c(){M=n("meta"),ke=o(),he=n("p"),_e=o(),U=n("h1"),k=n("a"),Me=n("span"),m(Z.$$.fragment),dt=o(),me=n("span"),me.textContent=yt,ve=o(),m(V.$$.fragment),Re=o(),I=n("p"),I.innerHTML=bt,Ce=o(),x=n("p"),x.textContent=gt,Ze=o(),X=n("p"),X.innerHTML=jt,Ve=o(),Q=n("p"),Q.innerHTML=kt,Ie=o(),E=n("p"),E.textContent=_t,xe=o(),w=n("h2"),_=n("a"),Ue=n("span"),m(G.$$.fragment),ft=o(),Je=n("span"),Je.textContent=vt,Xe=o(),$=n("p"),$.textContent=Rt,Qe=o(),m(B.$$.fragment),Ee=o(),W=n("p"),W.innerHTML=Ct,Ge=o(),m(A.$$.fragment),$e=o(),F=n("p"),F.textContent=Zt,Be=o(),m(z.$$.fragment),We=o(),L=n("p"),L.innerHTML=Vt,Ae=o(),m(N.$$.fragment),Fe=o(),y=n("h2"),v=n("a"),we=n("span"),m(H.$$.fragment),ht=o(),Te=n("span"),Te.textContent=It,ze=o(),D=n("p"),D.innerHTML=xt,Le=o(),m(Y.$$.fragment),Ne=o(),q=n("p"),q.textContent=Xt,He=o(),m(S.$$.fragment),De=o(),O=n("p"),O.innerHTML=Qt,Ye=o(),b=n("h2"),R=n("a"),ye=n("span"),m(P.$$.fragment),Mt=o(),de=n("span"),de.textContent=Et,qe=o(),K=n("p"),K.innerHTML=Gt,Se=o(),ee=n("p"),ee.innerHTML=$t,Oe=o(),te=n("p"),te.innerHTML=Bt,Pe=o(),m(le.$$.fragment),Ke=o(),se=n("p"),se.innerHTML=Wt,et=o(),m(ne.$$.fragment),tt=o(),ae=n("p"),ae.textContent=At,lt=o(),m(oe.$$.fragment),st=o(),re=n("p"),re.innerHTML=Ft,nt=o(),ie=n("p"),ie.textContent=zt,at=o(),g=n("h2"),C=n("a"),be=n("span"),m(pe.$$.fragment),Ut=o(),fe=n("span"),fe.textContent=Lt,ot=o(),ce=n("p"),ce.textContent=Nt,rt=o(),ue=n("ul"),ue.innerHTML=Ht,it=o(),ge=n("p"),this.h()},l(e){const l=il("svelte-1phssyn",document.head);M=a(l,"META",{name:!0,content:!0}),l.forEach(t),ke=r(e),he=a(e,"P",{}),u(he).forEach(t),_e=r(e),U=a(e,"H1",{class:!0});var ct=u(U);k=a(ct,"A",{id:!0,class:!0,href:!0});var Dt=u(k);Me=a(Dt,"SPAN",{});var Yt=u(Me);J(Z.$$.fragment,Yt),Yt.forEach(t),Dt.forEach(t),dt=r(ct),me=a(ct,"SPAN",{"data-svelte-h":!0}),i(me)!=="svelte-dpi4hl"&&(me.textContent=yt),ct.forEach(t),ve=r(e),J(V.$$.fragment,e),Re=r(e),I=a(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-vhpug6"&&(I.innerHTML=bt),Ce=r(e),x=a(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-mb1ukg"&&(x.textContent=gt),Ze=r(e),X=a(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1f4n09x"&&(X.innerHTML=jt),Ve=r(e),Q=a(e,"P",{"data-svelte-h":!0}),i(Q)!=="svelte-1v6brk3"&&(Q.innerHTML=kt),Ie=r(e),E=a(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-148xdun"&&(E.textContent=_t),xe=r(e),w=a(e,"H2",{class:!0});var ut=u(w);_=a(ut,"A",{id:!0,class:!0,href:!0});var qt=u(_);Ue=a(qt,"SPAN",{});var St=u(Ue);J(G.$$.fragment,St),St.forEach(t),qt.forEach(t),ft=r(ut),Je=a(ut,"SPAN",{"data-svelte-h":!0}),i(Je)!=="svelte-1j0t2ik"&&(Je.textContent=vt),ut.forEach(t),Xe=r(e),$=a(e,"P",{"data-svelte-h":!0}),i($)!=="svelte-1njozb7"&&($.textContent=Rt),Qe=r(e),J(B.$$.fragment,e),Ee=r(e),W=a(e,"P",{"data-svelte-h":!0}),i(W)!=="svelte-7f6oar"&&(W.innerHTML=Ct),Ge=r(e),J(A.$$.fragment,e),$e=r(e),F=a(e,"P",{"data-svelte-h":!0}),i(F)!=="svelte-1pc9n8q"&&(F.textContent=Zt),Be=r(e),J(z.$$.fragment,e),We=r(e),L=a(e,"P",{"data-svelte-h":!0}),i(L)!=="svelte-epruek"&&(L.innerHTML=Vt),Ae=r(e),J(N.$$.fragment,e),Fe=r(e),y=a(e,"H2",{class:!0});var mt=u(y);v=a(mt,"A",{id:!0,class:!0,href:!0});var Ot=u(v);we=a(Ot,"SPAN",{});var Pt=u(we);J(H.$$.fragment,Pt),Pt.forEach(t),Ot.forEach(t),ht=r(mt),Te=a(mt,"SPAN",{"data-svelte-h":!0}),i(Te)!=="svelte-nw7fd2"&&(Te.textContent=It),mt.forEach(t),ze=r(e),D=a(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-1dwvoc4"&&(D.innerHTML=xt),Le=r(e),J(Y.$$.fragment,e),Ne=r(e),q=a(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-183puqa"&&(q.textContent=Xt),He=r(e),J(S.$$.fragment,e),De=r(e),O=a(e,"P",{"data-svelte-h":!0}),i(O)!=="svelte-ssbrjd"&&(O.innerHTML=Qt),Ye=r(e),b=a(e,"H2",{class:!0});var Jt=u(b);R=a(Jt,"A",{id:!0,class:!0,href:!0});var Kt=u(R);ye=a(Kt,"SPAN",{});var el=u(ye);J(P.$$.fragment,el),el.forEach(t),Kt.forEach(t),Mt=r(Jt),de=a(Jt,"SPAN",{"data-svelte-h":!0}),i(de)!=="svelte-1b9slst"&&(de.textContent=Et),Jt.forEach(t),qe=r(e),K=a(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1n4in8p"&&(K.innerHTML=Gt),Se=r(e),ee=a(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-h9m36e"&&(ee.innerHTML=$t),Oe=r(e),te=a(e,"P",{"data-svelte-h":!0}),i(te)!=="svelte-1s012xi"&&(te.innerHTML=Bt),Pe=r(e),J(le.$$.fragment,e),Ke=r(e),se=a(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-f28hgm"&&(se.innerHTML=Wt),et=r(e),J(ne.$$.fragment,e),tt=r(e),ae=a(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1slt67r"&&(ae.textContent=At),lt=r(e),J(oe.$$.fragment,e),st=r(e),re=a(e,"P",{"data-svelte-h":!0}),i(re)!=="svelte-15kvfy2"&&(re.innerHTML=Ft),nt=r(e),ie=a(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-18p6eo2"&&(ie.textContent=zt),at=r(e),g=a(e,"H2",{class:!0});var Tt=u(g);C=a(Tt,"A",{id:!0,class:!0,href:!0});var tl=u(C);be=a(tl,"SPAN",{});var ll=u(be);J(pe.$$.fragment,ll),ll.forEach(t),tl.forEach(t),Ut=r(Tt),fe=a(Tt,"SPAN",{"data-svelte-h":!0}),i(fe)!=="svelte-1d5s2qp"&&(fe.textContent=Lt),Tt.forEach(t),ot=r(e),ce=a(e,"P",{"data-svelte-h":!0}),i(ce)!=="svelte-36wvdw"&&(ce.textContent=Nt),rt=r(e),ue=a(e,"UL",{"data-svelte-h":!0}),i(ue)!=="svelte-wv6sfd"&&(ue.innerHTML=Ht),it=r(e),ge=a(e,"P",{}),u(ge).forEach(t),this.h()},h(){p(M,"name","hf:doc:metadata"),p(M,"content",JSON.stringify(ul)),p(k,"id","xla-integration-for-tensorflow-models"),p(k,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(k,"href","#xla-integration-for-tensorflow-models"),p(U,"class","relative group"),p(_,"id","running-tf-functions-with-xla"),p(_,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(_,"href","#running-tf-functions-with-xla"),p(w,"class","relative group"),p(v,"id","running-a-tf-text-generation-model-with-xla-from-transformers"),p(v,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(v,"href","#running-a-tf-text-generation-model-with-xla-from-transformers"),p(y,"class","relative group"),p(R,"id","gotchas-to-be-aware-of"),p(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(R,"href","#gotchas-to-be-aware-of"),p(b,"class","relative group"),p(C,"id","additional-resources"),p(C,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),p(C,"href","#additional-resources"),p(g,"class","relative group")},m(e,l){c(document.head,M),s(e,ke,l),s(e,he,l),s(e,_e,l),s(e,U,l),c(U,k),c(k,Me),T(Z,Me,null),c(U,dt),c(U,me),s(e,ve,l),T(V,e,l),s(e,Re,l),s(e,I,l),s(e,Ce,l),s(e,x,l),s(e,Ze,l),s(e,X,l),s(e,Ve,l),s(e,Q,l),s(e,Ie,l),s(e,E,l),s(e,xe,l),s(e,w,l),c(w,_),c(_,Ue),T(G,Ue,null),c(w,ft),c(w,Je),s(e,Xe,l),s(e,$,l),s(e,Qe,l),T(B,e,l),s(e,Ee,l),s(e,W,l),s(e,Ge,l),T(A,e,l),s(e,$e,l),s(e,F,l),s(e,Be,l),T(z,e,l),s(e,We,l),s(e,L,l),s(e,Ae,l),T(N,e,l),s(e,Fe,l),s(e,y,l),c(y,v),c(v,we),T(H,we,null),c(y,ht),c(y,Te),s(e,ze,l),s(e,D,l),s(e,Le,l),T(Y,e,l),s(e,Ne,l),s(e,q,l),s(e,He,l),T(S,e,l),s(e,De,l),s(e,O,l),s(e,Ye,l),s(e,b,l),c(b,R),c(R,ye),T(P,ye,null),c(b,Mt),c(b,de),s(e,qe,l),s(e,K,l),s(e,Se,l),s(e,ee,l),s(e,Oe,l),s(e,te,l),s(e,Pe,l),T(le,e,l),s(e,Ke,l),s(e,se,l),s(e,et,l),T(ne,e,l),s(e,tt,l),s(e,ae,l),s(e,lt,l),T(oe,e,l),s(e,st,l),s(e,re,l),s(e,nt,l),s(e,ie,l),s(e,at,l),s(e,g,l),c(g,C),c(C,be),T(pe,be,null),c(g,Ut),c(g,fe),s(e,ot,l),s(e,ce,l),s(e,rt,l),s(e,ue,l),s(e,it,l),s(e,ge,l),pt=!0},p:nl,i(e){pt||(d(Z.$$.fragment,e),d(V.$$.fragment,e),d(G.$$.fragment,e),d(B.$$.fragment,e),d(A.$$.fragment,e),d(z.$$.fragment,e),d(N.$$.fragment,e),d(H.$$.fragment,e),d(Y.$$.fragment,e),d(S.$$.fragment,e),d(P.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(oe.$$.fragment,e),d(pe.$$.fragment,e),pt=!0)},o(e){f(Z.$$.fragment,e),f(V.$$.fragment,e),f(G.$$.fragment,e),f(B.$$.fragment,e),f(A.$$.fragment,e),f(z.$$.fragment,e),f(N.$$.fragment,e),f(H.$$.fragment,e),f(Y.$$.fragment,e),f(S.$$.fragment,e),f(P.$$.fragment,e),f(le.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(pe.$$.fragment,e),pt=!1},d(e){e&&(t(ke),t(he),t(_e),t(U),t(ve),t(Re),t(I),t(Ce),t(x),t(Ze),t(X),t(Ve),t(Q),t(Ie),t(E),t(xe),t(w),t(Xe),t($),t(Qe),t(Ee),t(W),t(Ge),t($e),t(F),t(Be),t(We),t(L),t(Ae),t(Fe),t(y),t(ze),t(D),t(Le),t(Ne),t(q),t(He),t(De),t(O),t(Ye),t(b),t(qe),t(K),t(Se),t(ee),t(Oe),t(te),t(Pe),t(Ke),t(se),t(et),t(tt),t(ae),t(lt),t(st),t(re),t(nt),t(ie),t(at),t(g),t(ot),t(ce),t(rt),t(ue),t(it),t(ge)),t(M),h(Z),h(V,e),h(G),h(B,e),h(A,e),h(z,e),h(N,e),h(H),h(Y,e),h(S,e),h(P),h(le,e),h(ne,e),h(oe,e),h(pe)}}}const ul={local:"xla-integration-for-tensorflow-models",sections:[{local:"running-tf-functions-with-xla",title:"XLA를 사용하여 TF 함수 실행하기 "},{local:"running-a-tf-text-generation-model-with-xla-from-transformers",title:"🤗 Transformers에서 XLA를 사용하여 TF 텍스트 생성 모델 실행하기 "},{local:"gotchas-to-be-aware-of",title:"주의할 점 "},{local:"additional-resources",title:"추가 자료 "}],title:"TensorFlow 모델을 위한 XLA 통합 "};function ml(wt){return al(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ml extends ol{constructor(M){super(),rl(this,M,ml,cl,sl,{})}}export{Ml as component};
