import{s as vt,o as Zt,n as Wt}from"../chunks/scheduler.56730f09.js";import{S as Nt,i as Ft,g as r,s,r as p,A as xt,h as i,f as l,c as a,j as Bt,u as U,x as o,k as St,y as At,a as n,v as J,d as m,t as c,w as T}from"../chunks/index.1f144517.js";import{T as Ht}from"../chunks/Tip.41e845e5.js";import{C as Je}from"../chunks/CodeBlock.738eeccb.js";import{H as h}from"../chunks/Heading.57d46534.js";function zt(ce){let M,C=`TorchScript를 활용한 실험은 아직 초기 단계로, 가변적인 입력 크기 모델들을 통해 그 기능성을 계속 탐구하고 있습니다.
이 기능은 저희가 관심을 두고 있는 분야 중 하나이며,
앞으로 출시될 버전에서 더 많은 코드 예제, 더 유연한 구현, 그리고 Python 기반 코드와 컴파일된 TorchScript를 비교하는 벤치마크를 등을 통해 분석을 심화할 예정입니다.`;return{c(){M=r("p"),M.textContent=C},l(d){M=i(d,"P",{"data-svelte-h":!0}),o(M)!=="svelte-1mebeqz"&&(M.textContent=C)},m(d,Ue){n(d,M,Ue)},p:Wt,d(d){d&&l(M)}}}function Dt(ce){let M,C,d,Ue,y,Te,f,Me,u,rt='<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">TorchScript 문서</a>에서는 이렇게 말합니다.',de,V,it="<p>TorchScript는 PyTorch 코드에서 직렬화 및 최적화 가능한 모델을 생성하는 방법입니다.</p>",he,w,ot='<a href="https://pytorch.org/docs/stable/jit.html" rel="nofollow">JIT과 TRACE</a>는 개발자가 모델을 내보내서 효율 지향적인 C++ 프로그램과 같은 다른 프로그램에서 재사용할 수 있도록 하는 PyTorch 모듈입니다.',fe,Q,pt=`PyTorch 기반 Python 프로그램과 다른 환경에서 모델을 재사용할 수 있도록, 🤗 Transformers 모델을 TorchScript로 내보낼 수 있는 인터페이스를 제공합니다.
이 문서에서는 TorchScript를 사용하여 모델을 내보내고 사용하는 방법을 설명합니다.`,Ce,$,Ut="모델을 내보내려면 두 가지가 필요합니다:",ye,b,Jt="<li><code>torchscript</code> 플래그로 모델 인스턴스화</li> <li>더미 입력을 사용한 순전파(forward pass)</li>",ue,j,mt="이 필수 조건들은 아래에 자세히 설명된 것처럼 개발자들이 주의해야 할 여러 사항들을 의미합니다.",Ve,g,we,E,ct=`<code>torchscript</code> 플래그가 필요한 이유는 대부분의 🤗 Transformers 언어 모델에서 <code>Embedding</code> 레이어와 <code>Decoding</code> 레이어 간의 묶인 가중치(tied weights)가 존재하기 때문입니다.
TorchScript는 묶인 가중치를 가진 모델을 내보낼 수 없으므로, 미리 가중치를 풀고 복제해야 합니다.`,Qe,I,Tt=`<code>torchscript</code> 플래그로 인스턴스화된 모델은 <code>Embedding</code> 레이어와 <code>Decoding</code> 레이어가 분리되어 있으므로 이후에 훈련해서는 안 됩니다.
훈련을 하게 되면 두 레이어 간 동기화가 해제되어 예상치 못한 결과가 발생할 수 있습니다.`,$e,R,Mt=`언어 모델 헤드를 갖지 않은 모델은 가중치가 묶여 있지 않아서 이 문제가 발생하지 않습니다.
이러한 모델들은 <code>torchscript</code> 플래그 없이 안전하게 내보낼 수 있습니다.`,be,k,je,_,dt=`더미 입력(dummy inputs)은 모델의 순전파(forward pass)에 사용됩니다.
입력 값이 레이어를 통해 전파되는 동안, PyTorch는 각 텐서에서 실행된 다른 연산을 추적합니다.
이러한 기록된 연산은 모델의 <em>추적(trace)</em>을 생성하는 데 사용됩니다.`,ge,B,ht=`추적은 입력의 차원을 기준으로 생성됩니다.
따라서 더미 입력의 차원에 제한되어, 다른 시퀀스 길이나 배치 크기에서는 작동하지 않습니다.
다른 크기로 시도할 경우 다음과 같은 오류가 발생합니다:`,Ee,S,Ie,v,ft=`추론 중 모델에 공급될 가장 큰 입력만큼 큰 더미 입력 크기로 모델을 추적하는 것이 좋습니다.
패딩은 누락된 값을 채우는 데 도움이 될 수 있습니다.
그러나 모델이 더 큰 입력 크기로 추적되기 때문에, 행렬의 차원이 커지고 계산량이 많아집니다.`,Re,Z,Ct="다양한 시퀀스 길이 모델을 내보낼 때는 각 입력에 대해 수행되는 총 연산 횟수에 주의하고 성능을 주의 깊게 확인하세요.",ke,W,_e,N,yt="이 섹션에서는 모델을 저장하고 가져오는 방법, 추적을 사용하여 추론하는 방법을 보여줍니다.",Be,F,Se,x,ut="<code>BertModel</code>을 TorchScript로 내보내려면 <code>BertConfig</code> 클래스에서 <code>BertModel</code>을 인스턴스화한 다음, <code>traced_bert.pt</code>라는 파일명으로 디스크에 저장하면 됩니다.",ve,A,Ze,H,We,z,Vt="이제 이전에 저장한 <code>BertModel</code>, 즉 <code>traced_bert.pt</code>를 디스크에서 가져오고, 이전에 초기화한 <code>dummy_input</code>에서 사용할 수 있습니다.",Ne,D,Fe,O,xe,L,wt="<code>__call__</code> 이중 언더스코어(dunder) 메소드를 사용하여 추론에 추적된 모델을 사용하세요:",Ae,X,He,P,ze,G,Qt=`AWS가 클라우드에서 저비용, 고성능 머신 러닝 추론을 위한 <a href="https://aws.amazon.com/ec2/instance-types/inf1/" rel="nofollow">Amazon EC2 Inf1</a> 인스턴스 제품군을 출시했습니다.
Inf1 인스턴스는 딥러닝 추론 워크로드에 특화된 맞춤 하드웨어 가속기인 AWS Inferentia 칩으로 구동됩니다.
<a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/#" rel="nofollow">AWS Neuron</a>은 Inferentia를 위한 SDK로, Inf1에 배포하기 위한 transformers 모델 추적 및 최적화를 지원합니다.
Neuron SDK는 다음과 같은 기능을 제공합니다:`,De,Y,$t='<li>코드 한 줄만 변경하면 클라우드 추론를 위해 TorchScript 모델을 추적하고 최적화할 수 있는 쉬운 API</li> <li>즉시 사용 가능한 성능 최적화로 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/benchmark/%3E" rel="nofollow">비용 효율 향상</a></li> <li><a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/bert_tutorial/tutorial_pretrained_bert.html" rel="nofollow">PyTorch</a> 또는 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/tensorflow/huggingface_bert/huggingface_bert.html" rel="nofollow">TensorFlow</a>로 구축된 Hugging Face transformers 모델 지원</li>',Oe,K,Le,q,bt=`<a href="https://huggingface.co/docs/transformers/main/model_doc/bert" rel="nofollow">BERT (Bidirectional Encoder Representations from Transformers)</a> 아키텍처 또는 그 변형인 <a href="https://huggingface.co/docs/transformers/main/model_doc/distilbert" rel="nofollow">distilBERT</a> 및 <a href="https://huggingface.co/docs/transformers/main/model_doc/roberta" rel="nofollow">roBERTa</a>를 기반으로 한 Transformers 모델은 추출 기반 질의응답, 시퀀스 분류 및 토큰 분류와 같은 비생성 작업 시 Inf1에서 최상의 성능을 보입니다.
그러나 텍스트 생성 작업도 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/src/examples/pytorch/transformers-marianmt.html" rel="nofollow">AWS Neuron MarianMT 튜토리얼</a>을 따라 Inf1에서 실행되도록 조정할 수 있습니다.`,Xe,ee,jt='Inferentia에서 바로 변환할 수 있는 모델에 대한 자세한 정보는 Neuron 문서의 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/models/models-inferentia.html#models-inferentia" rel="nofollow">Model Architecture Fit</a> 섹션에서 확인할 수 있습니다.',Pe,te,Ge,le,gt=`AWS Neuron을 사용하여 모델을 변환하려면 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/neuron-guide/neuron-frameworks/pytorch-neuron/index.html#installation-guide" rel="nofollow">Neuron SDK 환경</a>이 필요합니다.
이는 <a href="https://docs.aws.amazon.com/dlami/latest/devguide/tutorial-inferentia-launching.html" rel="nofollow">AWS Deep Learning AMI</a>에 미리 구성되어 있습니다.`,Ye,ne,Ke,se,Et=`<code>BertModel</code>을 추적하려면, <a href="torchscript#using-torchscript-in-python">Python에서 TorchScript 사용하기</a>에서와 동일한 코드를 사용해서 AWS NEURON용 모델을 변환합니다.
<code>torch.neuron</code> 프레임워크 익스텐션을 가져와 Python API를 통해 Neuron SDK의 구성 요소에 접근합니다:`,qe,ae,et,re,It="다음 줄만 수정하면 됩니다:",tt,ie,lt,oe,Rt="이로써 Neuron SDK가 모델을 추적하고 Inf1 인스턴스에 최적화할 수 있게 됩니다.",nt,pe,kt='AWS Neuron SDK의 기능, 도구, 예제 튜토리얼 및 최신 업데이트에 대해 자세히 알아보려면 <a href="https://awsdocs-neuron.readthedocs-hosted.com/en/latest/index.html" rel="nofollow">AWS NeuronSDK 문서</a>를 참조하세요.',st,me,at;return y=new h({props:{title:"TorchScript로 내보내기",local:"export-to-torchscript",headingTag:"h1"}}),f=new Ht({props:{$$slots:{default:[zt]},$$scope:{ctx:ce}}}),g=new h({props:{title:"TorchScript 플래그와 묶인 가중치(tied weights)",local:"torchscript-flag-and-tied-weights",headingTag:"h2"}}),k=new h({props:{title:"더미 입력과 표준 길이",local:"dummy-inputs-and-standard-lengths",headingTag:"h2"}}),S=new Je({props:{code:"JTYwVGhlJTIwZXhwYW5kZWQlMjBzaXplJTIwb2YlMjB0aGUlMjB0ZW5zb3IlMjAoMyklMjBtdXN0JTIwbWF0Y2glMjB0aGUlMjBleGlzdGluZyUyMHNpemUlMjAoNyklMjBhdCUyMG5vbi1zaW5nbGV0b24lMjBkaW1lbnNpb24lMjAyJTYw",highlighted:'`The expanded <span class="hljs-built_in">size</span> of the tensor (<span class="hljs-number">3</span>) must match the existing <span class="hljs-built_in">size</span> (<span class="hljs-number">7</span>) at non-singleton <span class="hljs-keyword">dimension</span> <span class="hljs-number">2</span>`',wrap:!1}}),W=new h({props:{title:"Python에서 TorchScript 사용하기",local:"using-torchscript-in-python",headingTag:"h2"}}),F=new h({props:{title:"모델 저장하기",local:"saving-a-model",headingTag:"h3"}}),A=new Je({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch

enc = BertTokenizer.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>)

<span class="hljs-comment"># 입력 텍스트 토큰화하기</span>
text = <span class="hljs-string">&quot;[CLS] Who was Jim Henson ? [SEP] Jim Henson was a puppeteer [SEP]&quot;</span>
tokenized_text = enc.tokenize(text)

<span class="hljs-comment"># 입력 토큰 중 하나를 마스킹하기</span>
masked_index = <span class="hljs-number">8</span>
tokenized_text[masked_index] = <span class="hljs-string">&quot;[MASK]&quot;</span>
indexed_tokens = enc.convert_tokens_to_ids(tokenized_text)
segments_ids = [<span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">0</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>]

<span class="hljs-comment"># 더미 입력 만들기</span>
tokens_tensor = torch.tensor([indexed_tokens])
segments_tensors = torch.tensor([segments_ids])
dummy_input = [tokens_tensor, segments_tensors]

<span class="hljs-comment"># torchscript 플래그로 모델 초기화하기</span>
<span class="hljs-comment"># 이 모델은 LM 헤드가 없으므로 필요하지 않지만, 플래그를 True로 설정합니다.</span>
config = BertConfig(
    vocab_size_or_config_json_file=<span class="hljs-number">32000</span>,
    hidden_size=<span class="hljs-number">768</span>,
    num_hidden_layers=<span class="hljs-number">12</span>,
    num_attention_heads=<span class="hljs-number">12</span>,
    intermediate_size=<span class="hljs-number">3072</span>,
    torchscript=<span class="hljs-literal">True</span>,
)

<span class="hljs-comment"># 모델을 인스턴트화하기</span>
model = BertModel(config)

<span class="hljs-comment"># 모델을 평가 모드로 두어야 합니다.</span>
model.<span class="hljs-built_in">eval</span>()

<span class="hljs-comment"># 만약 *from_pretrained*를 사용하여 모델을 인스턴스화하는 경우, TorchScript 플래그를 쉽게 설정할 수 있습니다</span>
model = BertModel.from_pretrained(<span class="hljs-string">&quot;bert-base-uncased&quot;</span>, torchscript=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># 추적 생성하기</span>
traced_model = torch.jit.trace(model, [tokens_tensor, segments_tensors])
torch.jit.save(traced_model, <span class="hljs-string">&quot;traced_bert.pt&quot;</span>)`,wrap:!1}}),H=new h({props:{title:"모델 가져오기",local:"loading-a-model",headingTag:"h3"}}),D=new Je({props:{code:"bG9hZGVkX21vZGVsJTIwJTNEJTIwdG9yY2guaml0LmxvYWQoJTIydHJhY2VkX2JlcnQucHQlMjIpJTBBbG9hZGVkX21vZGVsLmV2YWwoKSUwQSUwQWFsbF9lbmNvZGVyX2xheWVycyUyQyUyMHBvb2xlZF9vdXRwdXQlMjAlM0QlMjBsb2FkZWRfbW9kZWwoKmR1bW15X2lucHV0KQ==",highlighted:`loaded_model = torch.jit.load(<span class="hljs-string">&quot;traced_bert.pt&quot;</span>)
loaded_model.<span class="hljs-built_in">eval</span>()

all_encoder_layers, pooled_output = loaded_model(*dummy_input)`,wrap:!1}}),O=new h({props:{title:"추적된 모델을 사용하여 추론하기",local:"using-a-traced-model-for-inference",headingTag:"h3"}}),X=new Je({props:{code:"dHJhY2VkX21vZGVsKHRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzKQ==",highlighted:"traced_model(tokens_tensor, segments_tensors)",wrap:!1}}),P=new h({props:{title:"Neuron SDK로 Hugging Face TorchScript 모델을 AWS에 배포하기",local:"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk",headingTag:"h2"}}),K=new h({props:{title:"시사점",local:"implications",headingTag:"h3"}}),te=new h({props:{title:"종속성",local:"dependencies",headingTag:"h3"}}),ne=new h({props:{title:"AWS Neuron으로 모델 변환하기",local:"converting-a-model-for-aws-neuron",headingTag:"h3"}}),ae=new Je({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEJlcnRNb2RlbCUyQyUyMEJlcnRUb2tlbml6ZXIlMkMlMjBCZXJ0Q29uZmlnJTBBaW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0b3JjaC5uZXVyb24=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> BertModel, BertTokenizer, BertConfig
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">import</span> torch.neuron`,wrap:!1}}),ie=new Je({props:{code:"LSUyMHRvcmNoLmppdC50cmFjZShtb2RlbCUyQyUyMCU1QnRva2Vuc190ZW5zb3IlMkMlMjBzZWdtZW50c190ZW5zb3JzJTVEKSUwQSUyQiUyMHRvcmNoLm5ldXJvbi50cmFjZShtb2RlbCUyQyUyMCU1QnRva2VuX3RlbnNvciUyQyUyMHNlZ21lbnRzX3RlbnNvcnMlNUQp",highlighted:`<span class="hljs-deletion">- torch.jit.trace(model, [tokens_tensor, segments_tensors])</span>
<span class="hljs-addition">+ torch.neuron.trace(model, [token_tensor, segments_tensors])</span>`,wrap:!1}}),{c(){M=r("meta"),C=s(),d=r("p"),Ue=s(),p(y.$$.fragment),Te=s(),p(f.$$.fragment),Me=s(),u=r("p"),u.innerHTML=rt,de=s(),V=r("blockquote"),V.innerHTML=it,he=s(),w=r("p"),w.innerHTML=ot,fe=s(),Q=r("p"),Q.textContent=pt,Ce=s(),$=r("p"),$.textContent=Ut,ye=s(),b=r("ul"),b.innerHTML=Jt,ue=s(),j=r("p"),j.textContent=mt,Ve=s(),p(g.$$.fragment),we=s(),E=r("p"),E.innerHTML=ct,Qe=s(),I=r("p"),I.innerHTML=Tt,$e=s(),R=r("p"),R.innerHTML=Mt,be=s(),p(k.$$.fragment),je=s(),_=r("p"),_.innerHTML=dt,ge=s(),B=r("p"),B.textContent=ht,Ee=s(),p(S.$$.fragment),Ie=s(),v=r("p"),v.textContent=ft,Re=s(),Z=r("p"),Z.textContent=Ct,ke=s(),p(W.$$.fragment),_e=s(),N=r("p"),N.textContent=yt,Be=s(),p(F.$$.fragment),Se=s(),x=r("p"),x.innerHTML=ut,ve=s(),p(A.$$.fragment),Ze=s(),p(H.$$.fragment),We=s(),z=r("p"),z.innerHTML=Vt,Ne=s(),p(D.$$.fragment),Fe=s(),p(O.$$.fragment),xe=s(),L=r("p"),L.innerHTML=wt,Ae=s(),p(X.$$.fragment),He=s(),p(P.$$.fragment),ze=s(),G=r("p"),G.innerHTML=Qt,De=s(),Y=r("ol"),Y.innerHTML=$t,Oe=s(),p(K.$$.fragment),Le=s(),q=r("p"),q.innerHTML=bt,Xe=s(),ee=r("p"),ee.innerHTML=jt,Pe=s(),p(te.$$.fragment),Ge=s(),le=r("p"),le.innerHTML=gt,Ye=s(),p(ne.$$.fragment),Ke=s(),se=r("p"),se.innerHTML=Et,qe=s(),p(ae.$$.fragment),et=s(),re=r("p"),re.textContent=It,tt=s(),p(ie.$$.fragment),lt=s(),oe=r("p"),oe.textContent=Rt,nt=s(),pe=r("p"),pe.innerHTML=kt,st=s(),me=r("p"),this.h()},l(e){const t=xt("svelte-u9bgzb",document.head);M=i(t,"META",{name:!0,content:!0}),t.forEach(l),C=a(e),d=i(e,"P",{}),Bt(d).forEach(l),Ue=a(e),U(y.$$.fragment,e),Te=a(e),U(f.$$.fragment,e),Me=a(e),u=i(e,"P",{"data-svelte-h":!0}),o(u)!=="svelte-isybml"&&(u.innerHTML=rt),de=a(e),V=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),o(V)!=="svelte-1nfg3b0"&&(V.innerHTML=it),he=a(e),w=i(e,"P",{"data-svelte-h":!0}),o(w)!=="svelte-sp9oye"&&(w.innerHTML=ot),fe=a(e),Q=i(e,"P",{"data-svelte-h":!0}),o(Q)!=="svelte-do9l6t"&&(Q.textContent=pt),Ce=a(e),$=i(e,"P",{"data-svelte-h":!0}),o($)!=="svelte-1w91skt"&&($.textContent=Ut),ye=a(e),b=i(e,"UL",{"data-svelte-h":!0}),o(b)!=="svelte-k6rkk6"&&(b.innerHTML=Jt),ue=a(e),j=i(e,"P",{"data-svelte-h":!0}),o(j)!=="svelte-14fy25m"&&(j.textContent=mt),Ve=a(e),U(g.$$.fragment,e),we=a(e),E=i(e,"P",{"data-svelte-h":!0}),o(E)!=="svelte-12irp1s"&&(E.innerHTML=ct),Qe=a(e),I=i(e,"P",{"data-svelte-h":!0}),o(I)!=="svelte-50p7lq"&&(I.innerHTML=Tt),$e=a(e),R=i(e,"P",{"data-svelte-h":!0}),o(R)!=="svelte-1xgnj70"&&(R.innerHTML=Mt),be=a(e),U(k.$$.fragment,e),je=a(e),_=i(e,"P",{"data-svelte-h":!0}),o(_)!=="svelte-1q7p5d"&&(_.innerHTML=dt),ge=a(e),B=i(e,"P",{"data-svelte-h":!0}),o(B)!=="svelte-9y2g95"&&(B.textContent=ht),Ee=a(e),U(S.$$.fragment,e),Ie=a(e),v=i(e,"P",{"data-svelte-h":!0}),o(v)!=="svelte-1ujz4pz"&&(v.textContent=ft),Re=a(e),Z=i(e,"P",{"data-svelte-h":!0}),o(Z)!=="svelte-2wkzde"&&(Z.textContent=Ct),ke=a(e),U(W.$$.fragment,e),_e=a(e),N=i(e,"P",{"data-svelte-h":!0}),o(N)!=="svelte-kletgn"&&(N.textContent=yt),Be=a(e),U(F.$$.fragment,e),Se=a(e),x=i(e,"P",{"data-svelte-h":!0}),o(x)!=="svelte-sf77rs"&&(x.innerHTML=ut),ve=a(e),U(A.$$.fragment,e),Ze=a(e),U(H.$$.fragment,e),We=a(e),z=i(e,"P",{"data-svelte-h":!0}),o(z)!=="svelte-1r4og2d"&&(z.innerHTML=Vt),Ne=a(e),U(D.$$.fragment,e),Fe=a(e),U(O.$$.fragment,e),xe=a(e),L=i(e,"P",{"data-svelte-h":!0}),o(L)!=="svelte-1fmm5c"&&(L.innerHTML=wt),Ae=a(e),U(X.$$.fragment,e),He=a(e),U(P.$$.fragment,e),ze=a(e),G=i(e,"P",{"data-svelte-h":!0}),o(G)!=="svelte-grcwrb"&&(G.innerHTML=Qt),De=a(e),Y=i(e,"OL",{"data-svelte-h":!0}),o(Y)!=="svelte-ro97hi"&&(Y.innerHTML=$t),Oe=a(e),U(K.$$.fragment,e),Le=a(e),q=i(e,"P",{"data-svelte-h":!0}),o(q)!=="svelte-1dwgzck"&&(q.innerHTML=bt),Xe=a(e),ee=i(e,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-it8cst"&&(ee.innerHTML=jt),Pe=a(e),U(te.$$.fragment,e),Ge=a(e),le=i(e,"P",{"data-svelte-h":!0}),o(le)!=="svelte-3tyyhn"&&(le.innerHTML=gt),Ye=a(e),U(ne.$$.fragment,e),Ke=a(e),se=i(e,"P",{"data-svelte-h":!0}),o(se)!=="svelte-13235e8"&&(se.innerHTML=Et),qe=a(e),U(ae.$$.fragment,e),et=a(e),re=i(e,"P",{"data-svelte-h":!0}),o(re)!=="svelte-r93qfm"&&(re.textContent=It),tt=a(e),U(ie.$$.fragment,e),lt=a(e),oe=i(e,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-12g7lo2"&&(oe.textContent=Rt),nt=a(e),pe=i(e,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-1akz01w"&&(pe.innerHTML=kt),st=a(e),me=i(e,"P",{}),Bt(me).forEach(l),this.h()},h(){St(M,"name","hf:doc:metadata"),St(M,"content",Ot)},m(e,t){At(document.head,M),n(e,C,t),n(e,d,t),n(e,Ue,t),J(y,e,t),n(e,Te,t),J(f,e,t),n(e,Me,t),n(e,u,t),n(e,de,t),n(e,V,t),n(e,he,t),n(e,w,t),n(e,fe,t),n(e,Q,t),n(e,Ce,t),n(e,$,t),n(e,ye,t),n(e,b,t),n(e,ue,t),n(e,j,t),n(e,Ve,t),J(g,e,t),n(e,we,t),n(e,E,t),n(e,Qe,t),n(e,I,t),n(e,$e,t),n(e,R,t),n(e,be,t),J(k,e,t),n(e,je,t),n(e,_,t),n(e,ge,t),n(e,B,t),n(e,Ee,t),J(S,e,t),n(e,Ie,t),n(e,v,t),n(e,Re,t),n(e,Z,t),n(e,ke,t),J(W,e,t),n(e,_e,t),n(e,N,t),n(e,Be,t),J(F,e,t),n(e,Se,t),n(e,x,t),n(e,ve,t),J(A,e,t),n(e,Ze,t),J(H,e,t),n(e,We,t),n(e,z,t),n(e,Ne,t),J(D,e,t),n(e,Fe,t),J(O,e,t),n(e,xe,t),n(e,L,t),n(e,Ae,t),J(X,e,t),n(e,He,t),J(P,e,t),n(e,ze,t),n(e,G,t),n(e,De,t),n(e,Y,t),n(e,Oe,t),J(K,e,t),n(e,Le,t),n(e,q,t),n(e,Xe,t),n(e,ee,t),n(e,Pe,t),J(te,e,t),n(e,Ge,t),n(e,le,t),n(e,Ye,t),J(ne,e,t),n(e,Ke,t),n(e,se,t),n(e,qe,t),J(ae,e,t),n(e,et,t),n(e,re,t),n(e,tt,t),J(ie,e,t),n(e,lt,t),n(e,oe,t),n(e,nt,t),n(e,pe,t),n(e,st,t),n(e,me,t),at=!0},p(e,[t]){const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),f.$set(_t)},i(e){at||(m(y.$$.fragment,e),m(f.$$.fragment,e),m(g.$$.fragment,e),m(k.$$.fragment,e),m(S.$$.fragment,e),m(W.$$.fragment,e),m(F.$$.fragment,e),m(A.$$.fragment,e),m(H.$$.fragment,e),m(D.$$.fragment,e),m(O.$$.fragment,e),m(X.$$.fragment,e),m(P.$$.fragment,e),m(K.$$.fragment,e),m(te.$$.fragment,e),m(ne.$$.fragment,e),m(ae.$$.fragment,e),m(ie.$$.fragment,e),at=!0)},o(e){c(y.$$.fragment,e),c(f.$$.fragment,e),c(g.$$.fragment,e),c(k.$$.fragment,e),c(S.$$.fragment,e),c(W.$$.fragment,e),c(F.$$.fragment,e),c(A.$$.fragment,e),c(H.$$.fragment,e),c(D.$$.fragment,e),c(O.$$.fragment,e),c(X.$$.fragment,e),c(P.$$.fragment,e),c(K.$$.fragment,e),c(te.$$.fragment,e),c(ne.$$.fragment,e),c(ae.$$.fragment,e),c(ie.$$.fragment,e),at=!1},d(e){e&&(l(C),l(d),l(Ue),l(Te),l(Me),l(u),l(de),l(V),l(he),l(w),l(fe),l(Q),l(Ce),l($),l(ye),l(b),l(ue),l(j),l(Ve),l(we),l(E),l(Qe),l(I),l($e),l(R),l(be),l(je),l(_),l(ge),l(B),l(Ee),l(Ie),l(v),l(Re),l(Z),l(ke),l(_e),l(N),l(Be),l(Se),l(x),l(ve),l(Ze),l(We),l(z),l(Ne),l(Fe),l(xe),l(L),l(Ae),l(He),l(ze),l(G),l(De),l(Y),l(Oe),l(Le),l(q),l(Xe),l(ee),l(Pe),l(Ge),l(le),l(Ye),l(Ke),l(se),l(qe),l(et),l(re),l(tt),l(lt),l(oe),l(nt),l(pe),l(st),l(me)),l(M),T(y,e),T(f,e),T(g,e),T(k,e),T(S,e),T(W,e),T(F,e),T(A,e),T(H,e),T(D,e),T(O,e),T(X,e),T(P,e),T(K,e),T(te,e),T(ne,e),T(ae,e),T(ie,e)}}}const Ot='{"title":"TorchScript로 내보내기","local":"export-to-torchscript","sections":[{"title":"TorchScript 플래그와 묶인 가중치(tied weights)","local":"torchscript-flag-and-tied-weights","sections":[],"depth":2},{"title":"더미 입력과 표준 길이","local":"dummy-inputs-and-standard-lengths","sections":[],"depth":2},{"title":"Python에서 TorchScript 사용하기","local":"using-torchscript-in-python","sections":[{"title":"모델 저장하기","local":"saving-a-model","sections":[],"depth":3},{"title":"모델 가져오기","local":"loading-a-model","sections":[],"depth":3},{"title":"추적된 모델을 사용하여 추론하기","local":"using-a-traced-model-for-inference","sections":[],"depth":3}],"depth":2},{"title":"Neuron SDK로 Hugging Face TorchScript 모델을 AWS에 배포하기","local":"deploy-hugging-face-torchscript-models-to-aws-with-the-neuron-sdk","sections":[{"title":"시사점","local":"implications","sections":[],"depth":3},{"title":"종속성","local":"dependencies","sections":[],"depth":3},{"title":"AWS Neuron으로 모델 변환하기","local":"converting-a-model-for-aws-neuron","sections":[],"depth":3}],"depth":2}],"depth":1}';function Lt(ce){return Zt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class qt extends Nt{constructor(M){super(),Ft(this,M,Lt,Dt,vt,{})}}export{qt as component};
