import{s as ha,n as fa,o as da}from"../chunks/scheduler.d6170356.js";import{S as ua,i as ma,g as s,s as n,r as y,A as Ma,h as o,f as l,c as i,j as c,u as h,x as r,k as al,y as p,a,v as f,d,t as u,w as m}from"../chunks/index.fcd4cc08.js";import{C as M}from"../chunks/CodeBlock.7b16bdef.js";import{H as w}from"../chunks/Heading.8660bd0e.js";function ca(Tl){let b,ze,Re,Oe,$,Ke,v,Ul='The Hugging Face Hub aims to facilitate sharing machine learning models, checkpoints, and artifacts. This endeavor includes integrating the Hub into many of the amazing third-party libraries in the community. Some of the ones already integrated include <a href="https://spacy.io/usage/projects#huggingface_hub" rel="nofollow">spaCy</a>, <a href="https://allennlp.org/" rel="nofollow">AllenNLP</a>, and <a href="https://rwightman.github.io/pytorch-image-models/" rel="nofollow">timm</a>, among many others. Integration means users can download and upload files to the Hub directly from your library. We hope you will integrate your library and join us in democratizing artificial intelligence for everyone.',et,k,bl="Integrating the Hub with your library provides many benefits, including:",tt,x,_l='<li>Free model hosting for you and your users.</li> <li>Built-in file versioning - even for huge files - made possible by <a href="https://git-lfs.github.com/" rel="nofollow">Git-LFS</a>.</li> <li>All public models are powered by the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>.</li> <li>In-browser widgets allow users to interact with your hosted models directly.</li>',lt,H,Jl="This tutorial will help you integrate the Hub into your library so your users can benefit from all the features offered by the Hub.",at,A,Cl='Before you begin, we recommend you create a <a href="https://huggingface.co/join" rel="nofollow">Hugging Face account</a> from which you can manage your repositories and files.',nt,N,jl='If you need help with the integration, feel free to open an <a href="https://github.com/huggingface/huggingface_hub/issues/new/choose" rel="nofollow">issue</a>, and we would be more than happy to help you.',it,L,st,T,Q,Ne,Il="Install the <code>huggingface_hub</code> library with pip in your environment:",nl,X,il,_,Le,$l="Once you have successfully installed the <code>huggingface_hub</code> library, log in to your Hugging Face account:",sl,Z,ol,D,rl,J,Qe,vl="Alternatively, if you prefer working from a Jupyter or Colaboratory notebook, login with <code>notebook_login</code>:",pl,G,yl,Xe,kl="<code>notebook_login</code> will launch a widget in your notebook from which you can enter your Hugging Face credentials.",ot,F,rt,B,xl="Integration allows users to download your hosted files directly from the Hub using your library.",pt,P,Hl="Use the <code>hf_hub_download</code> function to retrieve a URL and download files from your repository. Downloaded files are stored in your cache: <code>~/.cache/huggingface/hub</code>. You don’t have to re-download the file the next time you use it, and for larger files, this can save a lot of time. Furthermore, if the repository is updated with a new version of the file, <code>huggingface_hub</code> will automatically download the latest version and store it in the cache for you. Users don’t have to worry about updating their files.",yt,W,Al='For example, download the <code>config.json</code> file from the <a href="https://huggingface.co/lysandre/arxiv-nlp" rel="nofollow">lysandre/arxiv-nlp</a> repository:',ht,E,ft,q,Nl="Download a specific version of the file by specifying the <code>revision</code> parameter. The <code>revision</code> parameter can be a branch name, tag, or commit hash.",dt,Y,Ll="The commit hash must be a full-length hash instead of the shorter 7-character commit hash:",ut,S,mt,R,Ql="Use the <code>cache_dir</code> parameter to change where a file is stored:",Mt,V,ct,z,gt,O,Xl="We recommend adding a code snippet to explain how to use a model in your downstream library.",wt,C,Zl='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/code_snippet-dark.png"/>',Tt,K,Dl='First, register your library by editing <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/model-libraries.ts" rel="nofollow">model-libaries.ts</a>.',Ut,ee,Gl='Then, add a code snippet by updating the <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/library-ui-elements.ts" rel="nofollow">library-ui-elements</a> file with instructions for your model. For example, the <a href="https://huggingface.co/asteroid-team" rel="nofollow">Asteroid</a> integration includes a brief code snippet for how to load and use an Asteroid model:',bt,te,_t,le,Fl="Doing so will also add a tag to your model so users can quickly identify models from your library.",Jt,j,Bl='<img class="block dark:hidden" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-tags.png"/> <img class="hidden dark:block" src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/libraries-tags-dark.png"/>',Ct,ae,jt,ne,Pl="You might also want to provide a method for creating model repositories and uploading files to the Hub directly from your library. The <code>huggingface_hub</code> library offers two ways to assist you with creating repositories and uploading files:",It,ie,Wl="<li><code>create_repo</code> creates a repository on the Hub.</li> <li><code>upload_file</code> directly uploads files to a repository on the Hub.</li>",$t,se,vt,oe,El="The <code>create_repo</code> method creates a repository on the Hub. Use the <code>name</code> parameter to provide a name for your repository:",kt,re,xt,pe,ql="When you check your Hugging Face account, you should now see a <code>test-model</code> repository under your namespace.",Ht,ye,At,he,Yl="The <code>upload_file</code> method uploads files to the Hub. This method requires the following:",Nt,fe,Sl="<li>A path to the file to upload.</li> <li>The final path in the repository.</li> <li>The repository you wish to push the files to.</li>",Lt,de,Rl="For example:",Qt,ue,Xt,me,Vl='If you need to upload more than one file, look at the <a href="https://huggingface.co/docs/huggingface_hub/package_reference/repository" rel="nofollow">utilities offered by the <code>Repository</code> class</a>.',Zt,Me,zl="Once again, if you check your Hugging Face account, you should see the file inside your repository.",Dt,ce,Ol='Lastly, it is important to add a model card so users understand how to use your model. See <a href="./model-cards">here</a> for more details about how to create a model card.',Gt,ge,Ft,we,Kl="Our Inference API powers models uploaded to the Hub through your library.",Bt,Te,Pt,Ue,ea='All third-party libraries are Dockerized, so you can install the dependencies you’ll need for your library to work correctly. Add your library to the existing Docker images by navigating to the <a href="https://github.com/huggingface/api-inference-community/tree/main/docker_images" rel="nofollow">Docker images folder</a>.',Wt,U,Ze,ta="<p>Copy the <code>common</code> folder and rename it with the name of your library (e.g. <code>docker/common</code> to <code>docker/your-awesome-library</code>).</p>",hl,be,De,la="There are four files you need to edit:",fl,g,Ge,aa="<p>List the packages required for your library to work in <code>requirements.txt</code>.</p>",dl,_e,Fe,na='Update <code>app/main.py</code> with the tasks supported by your model (see <a href="https://github.com/huggingface/api-inference-community" rel="nofollow">here</a> for a complete list of available tasks). Look out for the <code>IMPLEMENT_THIS</code> flag to add your supported task.',ul,Je,ml,Be,ia='<p>For each task your library supports, modify the <code>app/pipelines/task_name.py</code> files accordingly. We have also added an <code>IMPLEMENT_THIS</code> flag in the pipeline files to guide you. If there isn’t a pipeline that supports your task, feel free to add one. Open an <a href="https://github.com/huggingface/huggingface.js/issues/new" rel="nofollow">issue</a> here, and we will be happy to help you.</p>',Ml,Ce,Pe,sa="Add your model and task to the <code>tests/test_api.py</code> file. For example, if you have a text generation model:",cl,je,gl,Ie,We,oa="Finally, run the following test to ensure everything works as expected:",wl,$e,Et,ve,qt,ke,ra='To register the tasks supported by your library on the hub you’ll need to add a mapping from your library name to its supported tasks in <a href="https://github.com/huggingface/huggingface.js/blob/main/packages/tasks/src/library-to-tasks.ts" rel="nofollow">library-to-tasks.ts file</a>. This will ensure the inference API is registered for tasks supported by your model. This file is automatically generated as part of a <a href="https://github.com/huggingface/api-inference-community/actions/workflows/python-api-export-tasks.yaml" rel="nofollow">GitHub Action</a> in the <a href="https://github.com/huggingface/api-inference-community" rel="nofollow">api-inference-community repository</a> repository. You can see an example of this <a href="https://github.com/huggingface/api-inference-community/actions/runs/5126874210/jobs/9221890853#step:5:8" rel="nofollow">here</a>.',Yt,xe,pa="With these simple but powerful methods, you brought the full functionality of the Hub into your library. Users can download files stored on the Hub from your library with <code>hf_hub_download</code>, create repositories with <code>create_repo</code>, and upload files with <code>upload_file</code>. You also set up Inference API with your library, allowing users to interact with your models on the Hub from inside a browser.",St,He,Rt,Ae,ya='Finally, you can add your library to the Hub’s documentation. Check for example the <a href="https://github.com/huggingface/hub-docs/pull/1150" rel="nofollow">Setfit PR</a> that added <a href="./setfit">SetFit</a> to the documentation.',Vt,Ve,zt;return $=new w({props:{title:"Integrate your library with the Hub",local:"integrate-your-library-with-the-hub",headingTag:"h1"}}),L=new w({props:{title:"Installation",local:"installation",headingTag:"h2"}}),X=new M({props:{code:"cHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfaHVi",highlighted:"python -m pip install huggingface_hub",wrap:!1}}),Z=new M({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwbG9naW4=",highlighted:"huggingface-cli login",wrap:!1}}),D=new M({props:{code:"JTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMEElMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0NfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwXyU3Q18lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMF8lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDXyU3Q18lN0MlMEElMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0MlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTBBJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDXyU3QyUyMCUyMCUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMCUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0NfJTdDXyU3QyUyMCUyMF8lN0MlMjAlMjAlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwJTIwJTIwJTIwJTIwXyU3QyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMF8lN0MlMjAlMjAlMjAlMjBfJTdDJTIwJTIwJTIwJTIwXyU3Q18lN0NfJTdDJTIwJTIwXyU3Q18lN0NfJTdDXyU3QyUwQSUwQSUyMCUyMCUyMCUyMCUyMCUwQVVzZXJuYW1lJTNBJTIwJTBBUGFzc3dvcmQlM0E=",highlighted:`     _|    _|  _|    _|    _|_|_|    _|_|_|  _|_|_|  _|      _|    _|_|_|      _|_|_|_|    _|_|      _|_|_|  _|_|_|_|
     _|    _|  _|    _|  _|        _|          _|    _|_|    _|  _|            _|        _|    _|  _|        _|
     _|_|_|_|  _|    _|  _|  _|_|  _|  _|_|    _|    _|  _|  _|  _|  _|_|      _|_|_|    _|_|_|_|  _|        _|_|_|
     _|    _|  _|    _|  _|    _|  _|    _|    _|    _|    _|_|  _|    _|      _|        _|    _|  _|        _|
     _|    _|    _|_|      _|_|_|    _|_|_|  _|_|_|  _|      _|    _|_|_|      _|        _|    _|    _|_|_|  _|_|_|_|

     
Username: 
Password:`,wrap:!1}}),G=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMG5vdGVib29rX2xvZ2luJTBBbm90ZWJvb2tfbG9naW4oKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login
<span class="hljs-meta">&gt;&gt;&gt; </span>notebook_login()`,wrap:!1}}),F=new w({props:{title:"Download files from the Hub",local:"download-files-from-the-hub",headingTag:"h2"}}),E=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>)`,wrap:!1}}),S=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwcmV2aXNpb24lM0QlMjI4NzdiODRhOGY5M2YyZDYxOWZhYTJhNmU1MTRhMzJiZWVmODhhYjBhJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, revision=<span class="hljs-string">&quot;877b84a8f93f2d619faa2a6e514a32beef88ab0a&quot;</span>)`,wrap:!1}}),V=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGhmX2h1Yl9kb3dubG9hZCUwQWhmX2h1Yl9kb3dubG9hZChyZXBvX2lkJTNEJTIybHlzYW5kcmUlMkZhcnhpdi1ubHAlMjIlMkMlMjBmaWxlbmFtZSUzRCUyMmNvbmZpZy5qc29uJTIyJTJDJTIwY2FjaGVfZGlyJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGdGVzdCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> hf_hub_download
<span class="hljs-meta">&gt;&gt;&gt; </span>hf_hub_download(repo_id=<span class="hljs-string">&quot;lysandre/arxiv-nlp&quot;</span>, filename=<span class="hljs-string">&quot;config.json&quot;</span>, cache_dir=<span class="hljs-string">&quot;/home/lysandre/test&quot;</span>)`,wrap:!1}}),z=new w({props:{title:"Code sample",local:"code-sample",headingTag:"h3"}}),te=new M({props:{code:"Y29uc3QlMjBhc3Rlcm9pZCUyMCUzRCUyMChtb2RlbCUzQSUyME1vZGVsRGF0YSklMjAlM0QlM0UlMEElNjBmcm9tJTIwYXN0ZXJvaWQubW9kZWxzJTIwaW1wb3J0JTIwQmFzZU1vZGVsJTBBJTIwJTIwJTBBbW9kZWwlMjAlM0QlMjBCYXNlTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMiUyNCU3Qm1vZGVsLmlkJTdEJTIyKSU2MCUzQg==",highlighted:'<span class="hljs-keyword">const</span> <span class="hljs-title function_">asteroid</span> = (<span class="hljs-params">model: ModelData</span>) =&gt;\n<span class="hljs-string">`from asteroid.models import BaseModel\n  \nmodel = BaseModel.from_pretrained(&quot;<span class="hljs-subst">${model.id}</span>&quot;)`</span>;',wrap:!1}}),ae=new w({props:{title:"Upload files to the Hub",local:"upload-files-to-the-hub",headingTag:"h2"}}),se=new w({props:{title:"create_repo",local:"createrepo",headingTag:"h3"}}),re=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNyZWF0ZV9yZXBvJTBBY3JlYXRlX3JlcG8ocmVwb19pZCUzRCUyMnRlc3QtbW9kZWwlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> create_repo
<span class="hljs-meta">&gt;&gt;&gt; </span>create_repo(repo_id=<span class="hljs-string">&quot;test-model&quot;</span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model&#x27;</span>`,wrap:!1}}),ye=new w({props:{title:"upload_file",local:"uploadfile",headingTag:"h3"}}),ue=new M({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHVwbG9hZF9maWxlJTBBdXBsb2FkX2ZpbGUoJTBBJTIwJTIwJTIwcGF0aF9vcl9maWxlb2JqJTNEJTIyJTJGaG9tZSUyRmx5c2FuZHJlJTJGZHVtbXktdGVzdCUyRlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHBhdGhfaW5fcmVwbyUzRCUyMlJFQURNRS5tZCUyMiUyQyUyMCUwQSUyMCUyMCUyMHJlcG9faWQlM0QlMjJseXNhbmRyZSUyRnRlc3QtbW9kZWwlMjIlMEEp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> upload_file
<span class="hljs-meta">&gt;&gt;&gt; </span>upload_file(
<span class="hljs-meta">... </span>   path_or_fileobj=<span class="hljs-string">&quot;/home/lysandre/dummy-test/README.md&quot;</span>, 
<span class="hljs-meta">... </span>   path_in_repo=<span class="hljs-string">&quot;README.md&quot;</span>, 
<span class="hljs-meta">... </span>   repo_id=<span class="hljs-string">&quot;lysandre/test-model&quot;</span>
<span class="hljs-meta">... </span>)
<span class="hljs-string">&#x27;https://huggingface.co/lysandre/test-model/blob/main/README.md&#x27;</span>`,wrap:!1}}),ge=new w({props:{title:"Set up the Inference API",local:"set-up-the-inference-api",headingTag:"h2"}}),Te=new w({props:{title:"Create an Inference API Docker image",local:"create-an-inference-api-docker-image",headingTag:"h3"}}),Je=new M({props:{code:"QUxMT1dFRF9UQVNLUyUzQSUyMERpY3QlNUJzdHIlMkMlMjBUeXBlJTVCUGlwZWxpbmUlNUQlNUQlMjAlM0QlMjAlN0IlMEElMjAlMjAlMjAlMjAlMjJ0b2tlbi1jbGFzc2lmaWNhdGlvbiUyMiUzQSUyMFRva2VuQ2xhc3NpZmljYXRpb25QaXBlbGluZSUwQSU3RA==",highlighted:`ALLOWED_TASKS: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>, <span class="hljs-type">Type</span>[Pipeline]] = {
    <span class="hljs-string">&quot;token-classification&quot;</span>: TokenClassificationPipeline
}`,wrap:!1}}),je=new M({props:{code:"VEVTVEFCTEVfTU9ERUxTJTNBJTIwRGljdCU1QnN0ciUyQ3N0ciU1RCUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUzQSUyMCUyMm15LWdwdDItbW9kZWwlMjIlMEElN0Q=",highlighted:`TESTABLE_MODELS: <span class="hljs-type">Dict</span>[<span class="hljs-built_in">str</span>,<span class="hljs-built_in">str</span>] = {
    <span class="hljs-string">&quot;text-generation&quot;</span>: <span class="hljs-string">&quot;my-gpt2-model&quot;</span>
}`,wrap:!1}}),$e=new M({props:{code:"cHl0ZXN0JTIwLXN2JTIwLS1yb290ZGlyJTIwZG9ja2VyX2ltYWdlcyUyRnlvdXItYXdlc29tZS1saWJyYXJ5JTJGZG9ja2VyX2ltYWdlcyUyRnlvdXItYXdlc29tZS1saWJyYXJ5JTJG",highlighted:"pytest -sv --rootdir docker_images/your-awesome-library/docker_images/your-awesome-library/",wrap:!1}}),ve=new w({props:{title:"Register your libraries supported tasks on the hub",local:"register-your-libraries-supported-tasks-on-the-hub",headingTag:"h3"}}),He=new w({props:{title:"Document your library",local:"document-your-library",headingTag:"h2"}}),{c(){b=s("meta"),ze=n(),Re=s("p"),Oe=n(),y($.$$.fragment),Ke=n(),v=s("p"),v.innerHTML=Ul,et=n(),k=s("p"),k.textContent=bl,tt=n(),x=s("ul"),x.innerHTML=_l,lt=n(),H=s("p"),H.textContent=Jl,at=n(),A=s("p"),A.innerHTML=Cl,nt=n(),N=s("p"),N.innerHTML=jl,it=n(),y(L.$$.fragment),st=n(),T=s("ol"),Q=s("li"),Ne=s("p"),Ne.innerHTML=Il,nl=n(),y(X.$$.fragment),il=n(),_=s("li"),Le=s("p"),Le.innerHTML=$l,sl=n(),y(Z.$$.fragment),ol=n(),y(D.$$.fragment),rl=n(),J=s("li"),Qe=s("p"),Qe.innerHTML=vl,pl=n(),y(G.$$.fragment),yl=n(),Xe=s("p"),Xe.innerHTML=kl,ot=n(),y(F.$$.fragment),rt=n(),B=s("p"),B.textContent=xl,pt=n(),P=s("p"),P.innerHTML=Hl,yt=n(),W=s("p"),W.innerHTML=Al,ht=n(),y(E.$$.fragment),ft=n(),q=s("p"),q.innerHTML=Nl,dt=n(),Y=s("p"),Y.textContent=Ll,ut=n(),y(S.$$.fragment),mt=n(),R=s("p"),R.innerHTML=Ql,Mt=n(),y(V.$$.fragment),ct=n(),y(z.$$.fragment),gt=n(),O=s("p"),O.textContent=Xl,wt=n(),C=s("div"),C.innerHTML=Zl,Tt=n(),K=s("p"),K.innerHTML=Dl,Ut=n(),ee=s("p"),ee.innerHTML=Gl,bt=n(),y(te.$$.fragment),_t=n(),le=s("p"),le.textContent=Fl,Jt=n(),j=s("div"),j.innerHTML=Bl,Ct=n(),y(ae.$$.fragment),jt=n(),ne=s("p"),ne.innerHTML=Pl,It=n(),ie=s("ul"),ie.innerHTML=Wl,$t=n(),y(se.$$.fragment),vt=n(),oe=s("p"),oe.innerHTML=El,kt=n(),y(re.$$.fragment),xt=n(),pe=s("p"),pe.innerHTML=ql,Ht=n(),y(ye.$$.fragment),At=n(),he=s("p"),he.innerHTML=Yl,Nt=n(),fe=s("ul"),fe.innerHTML=Sl,Lt=n(),de=s("p"),de.textContent=Rl,Qt=n(),y(ue.$$.fragment),Xt=n(),me=s("p"),me.innerHTML=Vl,Zt=n(),Me=s("p"),Me.textContent=zl,Dt=n(),ce=s("p"),ce.innerHTML=Ol,Gt=n(),y(ge.$$.fragment),Ft=n(),we=s("p"),we.textContent=Kl,Bt=n(),y(Te.$$.fragment),Pt=n(),Ue=s("p"),Ue.innerHTML=ea,Wt=n(),U=s("ol"),Ze=s("li"),Ze.innerHTML=ta,hl=n(),be=s("li"),De=s("p"),De.textContent=la,fl=n(),g=s("ul"),Ge=s("li"),Ge.innerHTML=aa,dl=n(),_e=s("li"),Fe=s("p"),Fe.innerHTML=na,ul=n(),y(Je.$$.fragment),ml=n(),Be=s("li"),Be.innerHTML=ia,Ml=n(),Ce=s("li"),Pe=s("p"),Pe.innerHTML=sa,cl=n(),y(je.$$.fragment),gl=n(),Ie=s("li"),We=s("p"),We.textContent=oa,wl=n(),y($e.$$.fragment),Et=n(),y(ve.$$.fragment),qt=n(),ke=s("p"),ke.innerHTML=ra,Yt=n(),xe=s("p"),xe.innerHTML=pa,St=n(),y(He.$$.fragment),Rt=n(),Ae=s("p"),Ae.innerHTML=ya,Vt=n(),Ve=s("p"),this.h()},l(e){const t=Ma("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),ze=i(e),Re=o(e,"P",{}),c(Re).forEach(l),Oe=i(e),h($.$$.fragment,e),Ke=i(e),v=o(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-wqzoze"&&(v.innerHTML=Ul),et=i(e),k=o(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-1h76lqo"&&(k.textContent=bl),tt=i(e),x=o(e,"UL",{"data-svelte-h":!0}),r(x)!=="svelte-1f2b9dq"&&(x.innerHTML=_l),lt=i(e),H=o(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-tideui"&&(H.textContent=Jl),at=i(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-bv6wqp"&&(A.innerHTML=Cl),nt=i(e),N=o(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-5v9xsl"&&(N.innerHTML=jl),it=i(e),h(L.$$.fragment,e),st=i(e),T=o(e,"OL",{});var Ee=c(T);Q=o(Ee,"LI",{});var Ot=c(Q);Ne=o(Ot,"P",{"data-svelte-h":!0}),r(Ne)!=="svelte-1un3zii"&&(Ne.innerHTML=Il),nl=i(Ot),h(X.$$.fragment,Ot),Ot.forEach(l),il=i(Ee),_=o(Ee,"LI",{});var qe=c(_);Le=o(qe,"P",{"data-svelte-h":!0}),r(Le)!=="svelte-1n5fxns"&&(Le.innerHTML=$l),sl=i(qe),h(Z.$$.fragment,qe),ol=i(qe),h(D.$$.fragment,qe),qe.forEach(l),rl=i(Ee),J=o(Ee,"LI",{});var Ye=c(J);Qe=o(Ye,"P",{"data-svelte-h":!0}),r(Qe)!=="svelte-lceb1h"&&(Qe.innerHTML=vl),pl=i(Ye),h(G.$$.fragment,Ye),yl=i(Ye),Xe=o(Ye,"P",{"data-svelte-h":!0}),r(Xe)!=="svelte-1utjkvu"&&(Xe.innerHTML=kl),Ye.forEach(l),Ee.forEach(l),ot=i(e),h(F.$$.fragment,e),rt=i(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-1xrlxrq"&&(B.textContent=xl),pt=i(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-mlcwe8"&&(P.innerHTML=Hl),yt=i(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-22k4ir"&&(W.innerHTML=Al),ht=i(e),h(E.$$.fragment,e),ft=i(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-nqohuu"&&(q.innerHTML=Nl),dt=i(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-jz20t2"&&(Y.textContent=Ll),ut=i(e),h(S.$$.fragment,e),mt=i(e),R=o(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1g7ex70"&&(R.innerHTML=Ql),Mt=i(e),h(V.$$.fragment,e),ct=i(e),h(z.$$.fragment,e),gt=i(e),O=o(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-kjqwtb"&&(O.textContent=Xl),wt=i(e),C=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(C)!=="svelte-k2vnd3"&&(C.innerHTML=Zl),Tt=i(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-w1r9fm"&&(K.innerHTML=Dl),Ut=i(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-12afan4"&&(ee.innerHTML=Gl),bt=i(e),h(te.$$.fragment,e),_t=i(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1s18u9b"&&(le.textContent=Fl),Jt=i(e),j=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(j)!=="svelte-1n378h3"&&(j.innerHTML=Bl),Ct=i(e),h(ae.$$.fragment,e),jt=i(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1kwmyjl"&&(ne.innerHTML=Pl),It=i(e),ie=o(e,"UL",{"data-svelte-h":!0}),r(ie)!=="svelte-1kcwgoq"&&(ie.innerHTML=Wl),$t=i(e),h(se.$$.fragment,e),vt=i(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-rngk60"&&(oe.innerHTML=El),kt=i(e),h(re.$$.fragment,e),xt=i(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-aiu9oy"&&(pe.innerHTML=ql),Ht=i(e),h(ye.$$.fragment,e),At=i(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-co0lqw"&&(he.innerHTML=Yl),Nt=i(e),fe=o(e,"UL",{"data-svelte-h":!0}),r(fe)!=="svelte-9phsay"&&(fe.innerHTML=Sl),Lt=i(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1gkqha7"&&(de.textContent=Rl),Qt=i(e),h(ue.$$.fragment,e),Xt=i(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-m2kxf2"&&(me.innerHTML=Vl),Zt=i(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-269fdk"&&(Me.textContent=zl),Dt=i(e),ce=o(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-dxh4k0"&&(ce.innerHTML=Ol),Gt=i(e),h(ge.$$.fragment,e),Ft=i(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-lhddhv"&&(we.textContent=Kl),Bt=i(e),h(Te.$$.fragment,e),Pt=i(e),Ue=o(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-9nvj4e"&&(Ue.innerHTML=ea),Wt=i(e),U=o(e,"OL",{});var Se=c(U);Ze=o(Se,"LI",{"data-svelte-h":!0}),r(Ze)!=="svelte-l76mxy"&&(Ze.innerHTML=ta),hl=i(Se),be=o(Se,"LI",{});var Kt=c(be);De=o(Kt,"P",{"data-svelte-h":!0}),r(De)!=="svelte-ey431t"&&(De.textContent=la),fl=i(Kt),g=o(Kt,"UL",{});var I=c(g);Ge=o(I,"LI",{"data-svelte-h":!0}),r(Ge)!=="svelte-1nu45ed"&&(Ge.innerHTML=aa),dl=i(I),_e=o(I,"LI",{});var el=c(_e);Fe=o(el,"P",{"data-svelte-h":!0}),r(Fe)!=="svelte-db8jal"&&(Fe.innerHTML=na),ul=i(el),h(Je.$$.fragment,el),el.forEach(l),ml=i(I),Be=o(I,"LI",{"data-svelte-h":!0}),r(Be)!=="svelte-1lyepfm"&&(Be.innerHTML=ia),Ml=i(I),Ce=o(I,"LI",{});var tl=c(Ce);Pe=o(tl,"P",{"data-svelte-h":!0}),r(Pe)!=="svelte-1anbe36"&&(Pe.innerHTML=sa),cl=i(tl),h(je.$$.fragment,tl),tl.forEach(l),I.forEach(l),Kt.forEach(l),gl=i(Se),Ie=o(Se,"LI",{});var ll=c(Ie);We=o(ll,"P",{"data-svelte-h":!0}),r(We)!=="svelte-1aut65a"&&(We.textContent=oa),wl=i(ll),h($e.$$.fragment,ll),ll.forEach(l),Se.forEach(l),Et=i(e),h(ve.$$.fragment,e),qt=i(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-c66868"&&(ke.innerHTML=ra),Yt=i(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-udfx7c"&&(xe.innerHTML=pa),St=i(e),h(He.$$.fragment,e),Rt=i(e),Ae=o(e,"P",{"data-svelte-h":!0}),r(Ae)!=="svelte-1bxz36b"&&(Ae.innerHTML=ya),Vt=i(e),Ve=o(e,"P",{}),c(Ve).forEach(l),this.h()},h(){al(b,"name","hf:doc:metadata"),al(b,"content",ga),al(C,"class","flex justify-center"),al(j,"class","flex justify-center")},m(e,t){p(document.head,b),a(e,ze,t),a(e,Re,t),a(e,Oe,t),f($,e,t),a(e,Ke,t),a(e,v,t),a(e,et,t),a(e,k,t),a(e,tt,t),a(e,x,t),a(e,lt,t),a(e,H,t),a(e,at,t),a(e,A,t),a(e,nt,t),a(e,N,t),a(e,it,t),f(L,e,t),a(e,st,t),a(e,T,t),p(T,Q),p(Q,Ne),p(Q,nl),f(X,Q,null),p(T,il),p(T,_),p(_,Le),p(_,sl),f(Z,_,null),p(_,ol),f(D,_,null),p(T,rl),p(T,J),p(J,Qe),p(J,pl),f(G,J,null),p(J,yl),p(J,Xe),a(e,ot,t),f(F,e,t),a(e,rt,t),a(e,B,t),a(e,pt,t),a(e,P,t),a(e,yt,t),a(e,W,t),a(e,ht,t),f(E,e,t),a(e,ft,t),a(e,q,t),a(e,dt,t),a(e,Y,t),a(e,ut,t),f(S,e,t),a(e,mt,t),a(e,R,t),a(e,Mt,t),f(V,e,t),a(e,ct,t),f(z,e,t),a(e,gt,t),a(e,O,t),a(e,wt,t),a(e,C,t),a(e,Tt,t),a(e,K,t),a(e,Ut,t),a(e,ee,t),a(e,bt,t),f(te,e,t),a(e,_t,t),a(e,le,t),a(e,Jt,t),a(e,j,t),a(e,Ct,t),f(ae,e,t),a(e,jt,t),a(e,ne,t),a(e,It,t),a(e,ie,t),a(e,$t,t),f(se,e,t),a(e,vt,t),a(e,oe,t),a(e,kt,t),f(re,e,t),a(e,xt,t),a(e,pe,t),a(e,Ht,t),f(ye,e,t),a(e,At,t),a(e,he,t),a(e,Nt,t),a(e,fe,t),a(e,Lt,t),a(e,de,t),a(e,Qt,t),f(ue,e,t),a(e,Xt,t),a(e,me,t),a(e,Zt,t),a(e,Me,t),a(e,Dt,t),a(e,ce,t),a(e,Gt,t),f(ge,e,t),a(e,Ft,t),a(e,we,t),a(e,Bt,t),f(Te,e,t),a(e,Pt,t),a(e,Ue,t),a(e,Wt,t),a(e,U,t),p(U,Ze),p(U,hl),p(U,be),p(be,De),p(be,fl),p(be,g),p(g,Ge),p(g,dl),p(g,_e),p(_e,Fe),p(_e,ul),f(Je,_e,null),p(g,ml),p(g,Be),p(g,Ml),p(g,Ce),p(Ce,Pe),p(Ce,cl),f(je,Ce,null),p(U,gl),p(U,Ie),p(Ie,We),p(Ie,wl),f($e,Ie,null),a(e,Et,t),f(ve,e,t),a(e,qt,t),a(e,ke,t),a(e,Yt,t),a(e,xe,t),a(e,St,t),f(He,e,t),a(e,Rt,t),a(e,Ae,t),a(e,Vt,t),a(e,Ve,t),zt=!0},p:fa,i(e){zt||(d($.$$.fragment,e),d(L.$$.fragment,e),d(X.$$.fragment,e),d(Z.$$.fragment,e),d(D.$$.fragment,e),d(G.$$.fragment,e),d(F.$$.fragment,e),d(E.$$.fragment,e),d(S.$$.fragment,e),d(V.$$.fragment,e),d(z.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(se.$$.fragment,e),d(re.$$.fragment,e),d(ye.$$.fragment,e),d(ue.$$.fragment,e),d(ge.$$.fragment,e),d(Te.$$.fragment,e),d(Je.$$.fragment,e),d(je.$$.fragment,e),d($e.$$.fragment,e),d(ve.$$.fragment,e),d(He.$$.fragment,e),zt=!0)},o(e){u($.$$.fragment,e),u(L.$$.fragment,e),u(X.$$.fragment,e),u(Z.$$.fragment,e),u(D.$$.fragment,e),u(G.$$.fragment,e),u(F.$$.fragment,e),u(E.$$.fragment,e),u(S.$$.fragment,e),u(V.$$.fragment,e),u(z.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(se.$$.fragment,e),u(re.$$.fragment,e),u(ye.$$.fragment,e),u(ue.$$.fragment,e),u(ge.$$.fragment,e),u(Te.$$.fragment,e),u(Je.$$.fragment,e),u(je.$$.fragment,e),u($e.$$.fragment,e),u(ve.$$.fragment,e),u(He.$$.fragment,e),zt=!1},d(e){e&&(l(ze),l(Re),l(Oe),l(Ke),l(v),l(et),l(k),l(tt),l(x),l(lt),l(H),l(at),l(A),l(nt),l(N),l(it),l(st),l(T),l(ot),l(rt),l(B),l(pt),l(P),l(yt),l(W),l(ht),l(ft),l(q),l(dt),l(Y),l(ut),l(mt),l(R),l(Mt),l(ct),l(gt),l(O),l(wt),l(C),l(Tt),l(K),l(Ut),l(ee),l(bt),l(_t),l(le),l(Jt),l(j),l(Ct),l(jt),l(ne),l(It),l(ie),l($t),l(vt),l(oe),l(kt),l(xt),l(pe),l(Ht),l(At),l(he),l(Nt),l(fe),l(Lt),l(de),l(Qt),l(Xt),l(me),l(Zt),l(Me),l(Dt),l(ce),l(Gt),l(Ft),l(we),l(Bt),l(Pt),l(Ue),l(Wt),l(U),l(Et),l(qt),l(ke),l(Yt),l(xe),l(St),l(Rt),l(Ae),l(Vt),l(Ve)),l(b),m($,e),m(L,e),m(X),m(Z),m(D),m(G),m(F,e),m(E,e),m(S,e),m(V,e),m(z,e),m(te,e),m(ae,e),m(se,e),m(re,e),m(ye,e),m(ue,e),m(ge,e),m(Te,e),m(Je),m(je),m($e),m(ve,e),m(He,e)}}}const ga='{"title":"Integrate your library with the Hub","local":"integrate-your-library-with-the-hub","sections":[{"title":"Installation","local":"installation","sections":[],"depth":2},{"title":"Download files from the Hub","local":"download-files-from-the-hub","sections":[{"title":"Code sample","local":"code-sample","sections":[],"depth":3}],"depth":2},{"title":"Upload files to the Hub","local":"upload-files-to-the-hub","sections":[{"title":"create_repo","local":"createrepo","sections":[],"depth":3},{"title":"upload_file","local":"uploadfile","sections":[],"depth":3}],"depth":2},{"title":"Set up the Inference API","local":"set-up-the-inference-api","sections":[{"title":"Create an Inference API Docker image","local":"create-an-inference-api-docker-image","sections":[],"depth":3},{"title":"Register your libraries supported tasks on the hub","local":"register-your-libraries-supported-tasks-on-the-hub","sections":[],"depth":3}],"depth":2},{"title":"Document your library","local":"document-your-library","sections":[],"depth":2}],"depth":1}';function wa(Tl){return da(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ja extends ua{constructor(b){super(),ma(this,b,wa,ca,ha,{})}}export{Ja as component};
