import{s as Gs,n as Es,o as Ns}from"../chunks/scheduler.0219f8bd.js";import{S as Hs,i as Ws,g as y,s as n,r as p,A as vs,h as w,f as a,c as e,j as ks,u as M,x as T,k as Qs,y as Ys,a as t,v as o,d as i,t as j,w as c}from"../chunks/index.f61edf3b.js";import{C as q}from"../chunks/CodeBlock.38e566ae.js";import{H as h}from"../chunks/Heading.d33122ca.js";function _s(gs){let J,X,L,F,r,x,u,ds="A way to call Hugging Face models and inference APIs from natural language, using an LLM.",z,m,P,U,D,g,K,d,O,I,ss,f,Is='Agents.js leverages LLMs hosted as Inference APIs on HF, so you need to create an account and generate an <a href="https://huggingface.co/settings/tokens" rel="nofollow">access token</a>.',ls,C,as,B,ts,A,fs="You can also use your own LLM, by calling one of the <code>LLMFrom*</code> functions.",ns,$,es,b,Cs="You can specify any valid model on the hub as long as they have an API.",ps,Z,Ms,k,os,Q,Bs='You can also specify your own endpoint, as long as it implements the same API, for exemple using <a href="https://github.com/huggingface/text-generation-inference" rel="nofollow">text generation inference</a> and <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoints</a>.',is,G,js,E,cs,N,As="A LLM in this context is defined as any async function that takes a string input and returns a string. For example if you wanted to use the OpenAI API you could do so like this:",ys,H,ws,W,hs,v,$s="By default, agents ship with 4 tools. (textToImage, textToSpeech, imageToText, speechToText)",Js,Y,bs="But you can expand the list of tools easily by creating new tools and passing them at initialization.",Ts,_,rs,R,us,S,Zs="<li><code>@huggingface/inference</code> : Required to call the inference endpoints themselves.</li>",ms,V,Us;return r=new h({props:{title:"🤗 Hugging Face Agents.js",local:"-hugging-face-agentsjs",headingTag:"h1"}}),m=new h({props:{title:"Install",local:"install",headingTag:"h2"}}),U=new q({props:{code:"cG5wbSUyMGFkZCUyMCU0MGh1Z2dpbmdmYWNlJTJGYWdlbnRzJTBBJTBBbnBtJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHMlMEElMEF5YXJuJTIwYWRkJTIwJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHM=",highlighted:`pnpm add @huggingface/agents

npm add @huggingface/agents

yarn add @huggingface/agents`,wrap:!1}}),g=new h({props:{title:"Deno",local:"deno",headingTag:"h3"}}),d=new q({props:{code:"JTJGJTJGJTIwZXNtLnNoJTBBaW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjJodHRwcyUzQSUyRiUyRmVzbS5zaCUyRiU0MGh1Z2dpbmdmYWNlJTJGYWdlbnQlMjIlMEElMkYlMkYlMjBvciUyMG5wbSUzQSUwQWltcG9ydCUyMCU3QiUyMEhmQWdlbnQlMjAlN0QlMjBmcm9tJTIwJTIybnBtJTNBJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudCUyMg==",highlighted:`<span class="hljs-comment">// esm.sh</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;https://esm.sh/@huggingface/agent&quot;</span>
<span class="hljs-comment">// or npm:</span>
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;npm:@huggingface/agent&quot;</span>`,wrap:!1}}),I=new h({props:{title:"Usage",local:"usage",headingTag:"h2"}}),C=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWNvbnN0JTIwYWdlbnQlMjAlM0QlMjBuZXclMjBIZkFnZW50KCUyMmhmXy4uLiUyMiklM0IlMEElMEFjb25zdCUyMGNvZGUlMjAlM0QlMjBhd2FpdCUyMGFnZW50LmdlbmVyYXRlQ29kZSglMjJEcmF3JTIwYSUyMHBpY3R1cmUlMjBvZiUyMGElMjBjYXQlMkMlMjB3ZWFyaW5nJTIwYSUyMHRvcCUyMGhhdC4lMjIpJTBBY29uc29sZS5sb2coY29kZSklMjAlMkYlMkYlMjBhbHdheXMlMjBnb29kJTIwdG8lMjBjaGVjayUyMHRoZSUyMGdlbmVyYXRlZCUyMGNvZGUlMjBiZWZvcmUlMjBydW5uaW5nJTIwaXQlMEFjb25zdCUyMG91dHB1dHMlMjAlM0QlMjBhd2FpdCUyMGFnZW50LmV2YWx1YXRlQ29kZShjb2RlKSUzQiUwQWNvbnNvbGUubG9nKG91dHB1dHMpJTIw",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(<span class="hljs-string">&quot;hf_...&quot;</span>);

<span class="hljs-keyword">const</span> code = <span class="hljs-keyword">await</span> agent.<span class="hljs-title function_">generateCode</span>(<span class="hljs-string">&quot;Draw a picture of a cat, wearing a top hat.&quot;</span>)
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(code) <span class="hljs-comment">// always good to check the generated code before running it</span>
<span class="hljs-keyword">const</span> outputs = <span class="hljs-keyword">await</span> agent.evaluateCode(code);
<span class="hljs-variable language_">console</span>.<span class="hljs-title function_">log</span>(outputs) `,wrap:!1}}),B=new h({props:{title:"Choose your LLM",local:"choose-your-llm",headingTag:"h3"}}),$=new h({props:{title:"From the hub",local:"from-the-hub",headingTag:"h4"}}),Z=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyQyUyMExMTUZyb21IdWIlMjAlN0QlMjBmcm9tJTIwJTIyJTQwaHVnZ2luZ2ZhY2UlMkZhZ2VudHMlMjIlM0IlMEElMEFjb25zdCUyMGFnZW50JTIwJTNEJTIwbmV3JTIwSGZBZ2VudCglMEElMjAlMjAlMjJoZl8uLi4lMjIlMkMlMEElMjAlMjBMTE1Gcm9tSHViKCUyMmhmXy4uLiUyMiUyQyUyMCUyMk9wZW5Bc3Npc3RhbnQlMkZvYXNzdC1zZnQtNC1weXRoaWEtMTJiLWVwb2NoLTMuNSUyMiklMEEpJTNC",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromHub</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-string">&quot;OpenAssistant/oasst-sft-4-pythia-12b-epoch-3.5&quot;</span>)
);`,wrap:!1}}),k=new h({props:{title:"From your own endpoints",local:"from-your-own-endpoints",headingTag:"h4"}}),G=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyQyUyMExMTUZyb21FbmRwb2ludCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQSUwQWNvbnN0JTIwYWdlbnQlMjAlM0QlMjBuZXclMjBIZkFnZW50KCUwQSUyMCUyMCUyMmhmXy4uLiUyMiUyQyUwQSUyMCUyMExMTUZyb21FbmRwb2ludCglMjJoZl8uLi4lMjIlMkMlMjAlMjJodHRwJTNBJTJGJTJGLi4uJTIyKSUwQSklM0I=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, <span class="hljs-title class_">LLMFromEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-string">&quot;hf_...&quot;</span>,
  <span class="hljs-title class_">LLMFromEndpoint</span>(<span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-string">&quot;http://...&quot;</span>)
);`,wrap:!1}}),E=new h({props:{title:"Custom LLM",local:"custom-llm",headingTag:"h4"}}),H=new q({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZBZ2VudCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmFnZW50cyUyMiUzQiUwQWltcG9ydCUyMCU3QiUyMENvbmZpZ3VyYXRpb24lMkMlMjBPcGVuQUlBcGklMjAlN0QlMjBmcm9tJTIwJTIyb3BlbmFpJTIyJTNCJTBBJTBBY29uc3QlMjBhcGklMjAlM0QlMjBuZXclMjBPcGVuQUlBcGkobmV3JTIwQ29uZmlndXJhdGlvbiglN0IlMjBhcGlLZXklM0ElMjAlMjJzay0uLi4lMjIlMjAlN0QpKSUzQiUwQSUwQWNvbnN0JTIwbGxtT3BlbkFJJTIwJTNEJTIwYXN5bmMlMjAocHJvbXB0JTNBJTIwc3RyaW5nKSUzQSUyMFByb21pc2UlM0NzdHJpbmclM0UlMjAlM0QlM0UlMjAlN0IlMEElMjAlMjByZXR1cm4lMjAoJTBBJTIwJTIwJTIwJTIwKCUwQSUyMCUyMCUyMCUyMCUyMCUyMGF3YWl0JTIwYXBpLmNyZWF0ZUNvbXBsZXRpb24oJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlM0ElMjAlMjJ0ZXh0LWRhdmluY2ktMDAzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJvbXB0JTNBJTIwcHJvbXB0JTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X3Rva2VucyUzQSUyMDEwMDAlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlN0QpJTBBJTIwJTIwJTIwJTIwKS5kYXRhLmNob2ljZXMlNUIwJTVELnRleHQlMjAlM0YlM0YlMjAlMjIlMjIlMEElMjAlMjApJTNCJTBBJTdEJTNCJTBBJTBBY29uc3QlMjBhZ2VudCUyMCUzRCUyMG5ldyUyMEhmQWdlbnQoJTBBJTIwJTIwJTIyaGZfLi4uJTIyJTJDJTBBJTIwJTIwbGxtT3BlbkFJJTBBKSUzQiUwQSUwQSUyRiUyRiUyMGRvJTIwYW55dGhpbmclMjB5b3UlMjB3YW50JTIwd2l0aCUyMHRoZSUyMGFnZW50JTIwaGVyZSUwQQ==",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> { <span class="hljs-title class_">Configuration</span>, <span class="hljs-title class_">OpenAIApi</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;openai&quot;</span>;

<span class="hljs-keyword">const</span> api = <span class="hljs-keyword">new</span> <span class="hljs-title class_">OpenAIApi</span>(<span class="hljs-keyword">new</span> <span class="hljs-title class_">Configuration</span>({ <span class="hljs-attr">apiKey</span>: <span class="hljs-string">&quot;sk-...&quot;</span> }));

<span class="hljs-keyword">const</span> llmOpenAI = <span class="hljs-keyword">async</span> (<span class="hljs-attr">prompt</span>: <span class="hljs-built_in">string</span>): <span class="hljs-title class_">Promise</span>&lt;<span class="hljs-built_in">string</span>&gt; =&gt; {
  <span class="hljs-keyword">return</span> (
    (
      <span class="hljs-keyword">await</span> api.<span class="hljs-title function_">createCompletion</span>({
        <span class="hljs-attr">model</span>: <span class="hljs-string">&quot;text-davinci-003&quot;</span>,
        <span class="hljs-attr">prompt</span>: prompt,
        <span class="hljs-attr">max_tokens</span>: <span class="hljs-number">1000</span>,
      })
    ).<span class="hljs-property">data</span>.<span class="hljs-property">choices</span>[<span class="hljs-number">0</span>].<span class="hljs-property">text</span> ?? <span class="hljs-string">&quot;&quot;</span>
  );
};

<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(
  <span class="hljs-string">&quot;hf_...&quot;</span>,
  llmOpenAI
);

<span class="hljs-comment">// do anything you want with the agent here</span>
`,wrap:!1}}),W=new h({props:{title:"Tools",local:"tools",headingTag:"h3"}}),_=new q({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfAgent</span>, defaultTools, <span class="hljs-title class_">LLMFromHub</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents&quot;</span>;
<span class="hljs-keyword">import</span> <span class="hljs-keyword">type</span> { <span class="hljs-title class_">Tool</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/agents/src/types&quot;</span>;

<span class="hljs-comment">// define the tool</span>
<span class="hljs-keyword">const</span> <span class="hljs-attr">uppercaseTool</span>: <span class="hljs-title class_">Tool</span> = {
    <span class="hljs-attr">name</span>: <span class="hljs-string">&quot;uppercase&quot;</span>,
    <span class="hljs-attr">description</span>: <span class="hljs-string">&quot;uppercase the input string and returns it &quot;</span>,
    <span class="hljs-attr">examples</span>: [
        {
            <span class="hljs-attr">prompt</span>: <span class="hljs-string">&quot;uppercase the string: hello world&quot;</span>,
            <span class="hljs-attr">code</span>: <span class="hljs-string">\`const output = uppercase(&quot;hello world&quot;)\`</span>,
            <span class="hljs-attr">tools</span>: [<span class="hljs-string">&quot;uppercase&quot;</span>],
        },
    ],
    <span class="hljs-attr">call</span>: <span class="hljs-keyword">async</span> (input) =&gt; {
        <span class="hljs-keyword">const</span> data = <span class="hljs-keyword">await</span> input;
        <span class="hljs-keyword">if</span> (<span class="hljs-keyword">typeof</span> data !== <span class="hljs-string">&quot;string&quot;</span>) {
            <span class="hljs-keyword">throw</span> <span class="hljs-keyword">new</span> <span class="hljs-title class_">Error</span>(<span class="hljs-string">&quot;Input must be a string&quot;</span>);
        }
        <span class="hljs-keyword">return</span> data.<span class="hljs-title function_">toUpperCase</span>();
    },
};

<span class="hljs-comment">// pass it in the agent</span>
<span class="hljs-keyword">const</span> agent = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfAgent</span>(process.<span class="hljs-property">env</span>.<span class="hljs-property">HF_TOKEN</span>,
                <span class="hljs-title class_">LLMFromHub</span>(<span class="hljs-string">&quot;hf_...&quot;</span>, <span class="hljs-string">&quot;OpenAssistant/oasst-sft-4-pythia-12b-epoch-3.5&quot;</span>),
                [uppercaseTool, ...defaultTools]);`,wrap:!1}}),R=new h({props:{title:"Dependencies",local:"dependencies",headingTag:"h2"}}),{c(){J=y("meta"),X=n(),L=y("p"),F=n(),p(r.$$.fragment),x=n(),u=y("p"),u.textContent=ds,z=n(),p(m.$$.fragment),P=n(),p(U.$$.fragment),D=n(),p(g.$$.fragment),K=n(),p(d.$$.fragment),O=n(),p(I.$$.fragment),ss=n(),f=y("p"),f.innerHTML=Is,ls=n(),p(C.$$.fragment),as=n(),p(B.$$.fragment),ts=n(),A=y("p"),A.innerHTML=fs,ns=n(),p($.$$.fragment),es=n(),b=y("p"),b.textContent=Cs,ps=n(),p(Z.$$.fragment),Ms=n(),p(k.$$.fragment),os=n(),Q=y("p"),Q.innerHTML=Bs,is=n(),p(G.$$.fragment),js=n(),p(E.$$.fragment),cs=n(),N=y("p"),N.textContent=As,ys=n(),p(H.$$.fragment),ws=n(),p(W.$$.fragment),hs=n(),v=y("p"),v.textContent=$s,Js=n(),Y=y("p"),Y.textContent=bs,Ts=n(),p(_.$$.fragment),rs=n(),p(R.$$.fragment),us=n(),S=y("ul"),S.innerHTML=Zs,ms=n(),V=y("p"),this.h()},l(s){const l=vs("svelte-u9bgzb",document.head);J=w(l,"META",{name:!0,content:!0}),l.forEach(a),X=e(s),L=w(s,"P",{}),ks(L).forEach(a),F=e(s),M(r.$$.fragment,s),x=e(s),u=w(s,"P",{"data-svelte-h":!0}),T(u)!=="svelte-155kf59"&&(u.textContent=ds),z=e(s),M(m.$$.fragment,s),P=e(s),M(U.$$.fragment,s),D=e(s),M(g.$$.fragment,s),K=e(s),M(d.$$.fragment,s),O=e(s),M(I.$$.fragment,s),ss=e(s),f=w(s,"P",{"data-svelte-h":!0}),T(f)!=="svelte-34y4xq"&&(f.innerHTML=Is),ls=e(s),M(C.$$.fragment,s),as=e(s),M(B.$$.fragment,s),ts=e(s),A=w(s,"P",{"data-svelte-h":!0}),T(A)!=="svelte-1qeoss3"&&(A.innerHTML=fs),ns=e(s),M($.$$.fragment,s),es=e(s),b=w(s,"P",{"data-svelte-h":!0}),T(b)!=="svelte-53uh5h"&&(b.textContent=Cs),ps=e(s),M(Z.$$.fragment,s),Ms=e(s),M(k.$$.fragment,s),os=e(s),Q=w(s,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-1hj19ct"&&(Q.innerHTML=Bs),is=e(s),M(G.$$.fragment,s),js=e(s),M(E.$$.fragment,s),cs=e(s),N=w(s,"P",{"data-svelte-h":!0}),T(N)!=="svelte-ixq9gr"&&(N.textContent=As),ys=e(s),M(H.$$.fragment,s),ws=e(s),M(W.$$.fragment,s),hs=e(s),v=w(s,"P",{"data-svelte-h":!0}),T(v)!=="svelte-1v88ysk"&&(v.textContent=$s),Js=e(s),Y=w(s,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-1sb6vmy"&&(Y.textContent=bs),Ts=e(s),M(_.$$.fragment,s),rs=e(s),M(R.$$.fragment,s),us=e(s),S=w(s,"UL",{"data-svelte-h":!0}),T(S)!=="svelte-14gp5c0"&&(S.innerHTML=Zs),ms=e(s),V=w(s,"P",{}),ks(V).forEach(a),this.h()},h(){Qs(J,"name","hf:doc:metadata"),Qs(J,"content",Rs)},m(s,l){Ys(document.head,J),t(s,X,l),t(s,L,l),t(s,F,l),o(r,s,l),t(s,x,l),t(s,u,l),t(s,z,l),o(m,s,l),t(s,P,l),o(U,s,l),t(s,D,l),o(g,s,l),t(s,K,l),o(d,s,l),t(s,O,l),o(I,s,l),t(s,ss,l),t(s,f,l),t(s,ls,l),o(C,s,l),t(s,as,l),o(B,s,l),t(s,ts,l),t(s,A,l),t(s,ns,l),o($,s,l),t(s,es,l),t(s,b,l),t(s,ps,l),o(Z,s,l),t(s,Ms,l),o(k,s,l),t(s,os,l),t(s,Q,l),t(s,is,l),o(G,s,l),t(s,js,l),o(E,s,l),t(s,cs,l),t(s,N,l),t(s,ys,l),o(H,s,l),t(s,ws,l),o(W,s,l),t(s,hs,l),t(s,v,l),t(s,Js,l),t(s,Y,l),t(s,Ts,l),o(_,s,l),t(s,rs,l),o(R,s,l),t(s,us,l),t(s,S,l),t(s,ms,l),t(s,V,l),Us=!0},p:Es,i(s){Us||(i(r.$$.fragment,s),i(m.$$.fragment,s),i(U.$$.fragment,s),i(g.$$.fragment,s),i(d.$$.fragment,s),i(I.$$.fragment,s),i(C.$$.fragment,s),i(B.$$.fragment,s),i($.$$.fragment,s),i(Z.$$.fragment,s),i(k.$$.fragment,s),i(G.$$.fragment,s),i(E.$$.fragment,s),i(H.$$.fragment,s),i(W.$$.fragment,s),i(_.$$.fragment,s),i(R.$$.fragment,s),Us=!0)},o(s){j(r.$$.fragment,s),j(m.$$.fragment,s),j(U.$$.fragment,s),j(g.$$.fragment,s),j(d.$$.fragment,s),j(I.$$.fragment,s),j(C.$$.fragment,s),j(B.$$.fragment,s),j($.$$.fragment,s),j(Z.$$.fragment,s),j(k.$$.fragment,s),j(G.$$.fragment,s),j(E.$$.fragment,s),j(H.$$.fragment,s),j(W.$$.fragment,s),j(_.$$.fragment,s),j(R.$$.fragment,s),Us=!1},d(s){s&&(a(X),a(L),a(F),a(x),a(u),a(z),a(P),a(D),a(K),a(O),a(ss),a(f),a(ls),a(as),a(ts),a(A),a(ns),a(es),a(b),a(ps),a(Ms),a(os),a(Q),a(is),a(js),a(cs),a(N),a(ys),a(ws),a(hs),a(v),a(Js),a(Y),a(Ts),a(rs),a(us),a(S),a(ms),a(V)),a(J),c(r,s),c(m,s),c(U,s),c(g,s),c(d,s),c(I,s),c(C,s),c(B,s),c($,s),c(Z,s),c(k,s),c(G,s),c(E,s),c(H,s),c(W,s),c(_,s),c(R,s)}}}const Rs='{"title":"🤗 Hugging Face Agents.js","local":"-hugging-face-agentsjs","sections":[{"title":"Install","local":"install","sections":[{"title":"Deno","local":"deno","sections":[],"depth":3}],"depth":2},{"title":"Usage","local":"usage","sections":[{"title":"Choose your LLM","local":"choose-your-llm","sections":[{"title":"From the hub","local":"from-the-hub","sections":[],"depth":4},{"title":"From your own endpoints","local":"from-your-own-endpoints","sections":[],"depth":4},{"title":"Custom LLM","local":"custom-llm","sections":[],"depth":4}],"depth":3},{"title":"Tools","local":"tools","sections":[],"depth":3}],"depth":2},{"title":"Dependencies","local":"dependencies","sections":[],"depth":2}],"depth":1}';function Ss(gs){return Ns(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Fs extends Hs{constructor(J){super(),Ws(this,J,Ss,_s,Gs,{})}}export{Fs as component};
