import{s as Fw,o as Pw,n as Kw}from"../chunks/scheduler.25b97de1.js";import{S as Dw,i as Ow,g as i,s as n,r as d,m as r,H as c,A as sb,h as p,f as a,c as l,j as M,u as g,x as o,n as h,B as u,k as L,y as m,a as e,v as y,d as f,t as w,w as b}from"../chunks/index.d9030fc9.js";import{T as tb}from"../chunks/Tip.baa67368.js";import{C as v}from"../chunks/CodeBlock.e6cd0d95.js";import{D as ab}from"../chunks/DocNotebookDropdown.5ea6cb78.js";import{H as Cc,E as eb}from"../chunks/EditOnGithub.91d95064.js";function nb(hl){let G,Us='Note that, despite our advice to use key-value caches, your LLM output may be slightly different when you use them. This is a property of the matrix multiplication kernels themselves — you can read more about it <a href="https://github.com/huggingface/transformers/issues/25420#issuecomment-1775317535" rel="nofollow">here</a>.';return{c(){G=i("p"),G.innerHTML=Us},l(P){G=p(P,"P",{"data-svelte-h":!0}),o(G)!=="svelte-175aom5"&&(G.innerHTML=Us)},m(P,yn){e(P,G,yn)},p:Kw,d(P){P&&a(G)}}}function lb(hl){let G,Us,P,yn,Cs,cl,zs,ul,Ls,Fu=`Large Language Models (LLMs) such as GPT3/4, <a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow">Falcon</a>, and <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama</a> are rapidly advancing in their ability to tackle human-centric tasks, establishing themselves as essential tools in modern knowledge-based industries.
Deploying these models in real-world tasks remains challenging, however:`,dl,Gs,Pu='<li>To exhibit near-human text understanding and generation capabilities, LLMs currently require to be composed of billions of parameters (see <a href="https://arxiv.org/abs/2001.08361" rel="nofollow">Kaplan et al</a>, <a href="https://arxiv.org/abs/2206.07682" rel="nofollow">Wei et. al</a>). This consequently amplifies the memory demands for inference.</li> <li>In many real-world tasks, LLMs need to be given extensive contextual information. This necessitates the model’s capability to manage very long input sequences during inference.</li>',gl,Bs,Ku="The crux of these challenges lies in augmenting the computational and memory capabilities of LLMs, especially when handling expansive input sequences.",yl,Zs,Du="In this guide, we will go over the effective techniques for efficient LLM deployment:",fl,Is,Ou='<li><p><strong>Lower Precision:</strong> Research has shown that operating at reduced numerical precision, namely <a href="./main_classes/quantization.md">8-bit and 4-bit</a> can achieve computational advantages without a considerable decline in model performance.</p></li> <li><p><strong>Flash Attention:</strong> Flash Attention is a variation of the attention algorithm that not only provides a more memory-efficient approach but also realizes increased efficiency due to optimized GPU memory utilization.</p></li> <li><p><strong>Architectural Innovations:</strong> Considering that LLMs are always deployed in the same way during inference, namely autoregressive text generation with a long input context, specialized model architectures have been proposed that allow for more efficient inference. The most important advancement in model architectures hereby are <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">Alibi</a>, <a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary embeddings</a>, <a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query Attention (MQA)</a> and <a href="(https://arxiv.org/abs/2305.13245)">Grouped-Query-Attention (GQA)</a>.</p></li>',wl,$s,sd="Throughout this guide, we will offer an analysis of auto-regressive generation from a tensor’s perspective. We delve into the pros and cons of adopting lower precision, provide a comprehensive exploration of the latest attention algorithms, and discuss improved LLM architectures. While doing so, we run practical examples showcasing each of the feature improvements.",bl,Ws,vl,Hs,td="Memory requirements of LLMs can be best understood by seeing the LLM as a set of weight matrices and vectors and the text inputs as a sequence of vectors. In the following, the definition <em>weights</em> will be used to signify all model weight matrices and vectors.",Ml,Qs,ad='At the time of writing this guide, LLMs consist of at least a couple billion parameters. Each parameter thereby is made of a decimal number, e.g. <code>4.5689</code> which is usually stored in either <a href="https://en.wikipedia.org/wiki/Single-precision_floating-point_format" rel="nofollow">float32</a>, <a href="https://en.wikipedia.org/wiki/Bfloat16_floating-point_format" rel="nofollow">bfloat16</a>, or <a href="https://en.wikipedia.org/wiki/Half-precision_floating-point_format" rel="nofollow">float16</a> format. This allows us to easily compute the memory requirement to load the LLM into memory:',xl,Xs,ed="<p><em>Loading the weights of a model having X billion parameters requires roughly 4</em> X GB of VRAM in float32 precision*</p>",kl,Ns,nd="Nowadays, models are however rarely trained in full float32 precision, but usually in bfloat16 precision or less frequently in float16 precision. Therefore the rule of thumb becomes:",Tl,Rs,ld="<p><em>Loading the weights of a model having X billion parameters requires roughly 2</em> X GB of VRAM in bfloat16/float16 precision*</p>",jl,Vs,id="For shorter text inputs (less than 1024 tokens), the memory requirement for inference is very much dominated by the memory requirement to load the weights. Therefore, for now, let’s assume that the memory requirement for inference is equal to the memory requirement to load the model into the GPU VRAM.",_l,qs,pd="To give some examples of how much VRAM it roughly takes to load a model in bfloat16:",Jl,As,md='<li><strong>GPT3</strong> requires 2 * 175 GB = <strong>350 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>Bloom</strong></a> requires 2 * 176 GB = <strong>352 GB</strong> VRAM</li> <li><a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow"><strong>Llama-2-70b</strong></a> requires 2 * 70 GB = <strong>140 GB</strong> VRAM</li> <li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon-40b</strong></a> requires 2 * 40 GB = <strong>80 GB</strong> VRAM</li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT-30b</strong></a> requires 2 * 30 GB = <strong>60 GB</strong> VRAM</li> <li><a href="https://huggingface.co/bigcode/starcoder" rel="nofollow"><strong>bigcode/starcoder</strong></a> requires 2 * 15.5 = <strong>31 GB</strong> VRAM</li>',Ul,Es,od='As of writing this document, the largest GPU chip on the market is the A100 &amp; H100 offering 80GB of VRAM. Most of the models listed before require more than 80GB just to be loaded and therefore necessarily require <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#tensor-parallelism" rel="nofollow">tensor parallelism</a> and/or <a href="https://huggingface.co/docs/transformers/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">pipeline parallelism</a>.',Cl,Ys,rd='🤗 Transformers does not support tensor parallelism out of the box as it requires the model architecture to be written in a specific way. If you’re interested in writing models in a tensor-parallelism-friendly way, feel free to have a look at <a href="https://github.com/huggingface/text-generation-inference/tree/main/server/text_generation_server/models/custom_modeling" rel="nofollow">the text-generation-inference library</a>.',zl,Ss,hd=`Naive pipeline parallelism is supported out of the box. For this, simply load the model with <code>device=&quot;auto&quot;</code> which will automatically place the different layers on the available GPUs as explained <a href="https://huggingface.co/docs/accelerate/v0.22.0/en/concept_guides/big_model_inference" rel="nofollow">here</a>.
Note, however that while very effective, this naive pipeline parallelism does not tackle the issues of GPU idling. For this more advanced pipeline parallelism is required as explained <a href="https://huggingface.co/docs/transformers/en/perf_train_gpu_many#naive-model-parallelism-vertical-and-pipeline-parallelism" rel="nofollow">here</a>.`,Ll,Fs,cd="If you have access to an 8 x 80GB A100 node, you could load BLOOM as follows",Gl,Ps,Bl,Ks,Zl,Ds,ud="By using <code>device_map=&quot;auto&quot;</code> the attention layers would be equally distributed over all available GPUs.",Il,Os,dd='In this guide, we will use <a href="https://huggingface.co/bigcode/octocoder" rel="nofollow">bigcode/octocoder</a> as it can be run on a single 40 GB A100 GPU device chip. Note that all memory and speed optimizations that we will apply going forward, are equally applicable to models that require model or tensor parallelism.',$l,st,gd="Since the model is loaded in bfloat16 precision, using our rule of thumb above, we would expect the memory requirement to run inference with <code>bigcode/octocoder</code> to be around 31 GB VRAM. Let’s give it a try.",Wl,tt,yd='We first load the model and tokenizer and then pass both to Transformers’ <a href="https://huggingface.co/docs/transformers/main_classes/pipelines" rel="nofollow">pipeline</a> object.',Hl,at,Ql,et,Xl,nt,fd="<strong>Output</strong>:",Nl,lt,Rl,it,wd="Nice, we can now directly use the result to convert bytes into Gigabytes.",Vl,pt,ql,mt,bd='Let’s call <a href="https://pytorch.org/docs/stable/generated/torch.cuda.max_memory_allocated.html" rel="nofollow"><code>torch.cuda.max_memory_allocated</code></a> to measure the peak GPU memory allocation.',Al,ot,El,rt,vd="<strong>Output</strong>:",Yl,ht,Sl,ct,Md=`Close enough to our back-of-the-envelope computation! We can see the number is not exactly correct as going from bytes to kilobytes requires a multiplication of 1024 instead of 1000. Therefore the back-of-the-envelope formula can also be understood as an “at most X GB” computation.
Note that if we had tried to run the model in full float32 precision, a whopping 64 GB of VRAM would have been required.`,Fl,ut,xd='<p>Almost all models are trained in bfloat16 nowadays, there is no reason to run the model in full float32 precision if <a href="https://discuss.pytorch.org/t/bfloat16-native-support/117155/5" rel="nofollow">your GPU supports bfloat16</a>. Float32 won’t give better inference results than the precision that was used to train the model.</p>',Pl,dt,kd='If you are unsure in which format the model weights are stored on the Hub, you can always look into the checkpoint’s config under <code>&quot;torch_dtype&quot;</code>, <em>e.g.</em> <a href="https://huggingface.co/meta-llama/Llama-2-7b-hf/blob/6fdf2e60f86ff2481f2241aaee459f85b5b0bbb9/config.json#L21" rel="nofollow">here</a>. It is recommended to set the model to the same precision type as written in the config when loading with <code>from_pretrained(..., torch_dtype=...)</code> except when the original type is float32 in which case one can use both <code>float16</code> or <code>bfloat16</code> for inference.',Kl,gt,Td="Let’s define a <code>flush(...)</code> function to free all allocated memory so that we can accurately measure the peak allocated GPU memory.",Dl,yt,Ol,ft,jd="Let’s call it now for the next experiment.",si,wt,ti,bt,_d="In the recent version of the accelerate library, you can also use an utility method called <code>release_memory()</code>",ai,vt,ei,Mt,Jd=`Now what if your GPU does not have 32 GB of VRAM? It has been found that model weights can be quantized to 8-bit or 4-bits without a significant loss in performance (see <a href="https://arxiv.org/abs/2208.07339" rel="nofollow">Dettmers et al.</a>).
Model can be quantized to even 3 or 2 bits with an acceptable loss in performance as shown in the recent <a href="https://arxiv.org/abs/2210.17323" rel="nofollow">GPTQ paper</a> 🤯.`,ni,xt,Ud=`Without going into too many details, quantization schemes aim at reducing the precision of weights while trying to keep the model’s inference results as accurate as possible (<em>a.k.a</em> as close as possible to bfloat16).
Note that quantization works especially well for text generation since all we care about is choosing the <em>set of most likely next tokens</em> and don’t really care about the exact values of the next token <em>logit</em> distribution.
All that matters is that the next token <em>logit</em> distribution stays roughly the same so that an <code>argmax</code> or <code>topk</code> operation gives the same results.`,li,kt,Cd="There are various quantization techniques, which we won’t discuss in detail here, but in general, all quantization techniques work as follows:",ii,Tt,zd='<li><ol><li>Quantize all weights to the target precision</li></ol></li> <li><ol start="2"><li>Load the quantized weights, and pass the input sequence of vectors in bfloat16 precision</li></ol></li> <li><ol start="3"><li>Dynamically dequantize weights to bfloat16 to perform the computation with their input vectors in bfloat16 precision</li></ol></li>',pi,B,zc,fn,Ld="inputs-weight matrix",Lc,mi,kf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>X</mi></mrow><annotation encoding="application/x-tex"> X </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span></span></span></span>',oi,wn,Gd="inputs",Gc,ri,Tf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>W</mi></mrow><annotation encoding="application/x-tex"> W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span>',hi,ci,jf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Y</mi></mrow><annotation encoding="application/x-tex"> Y </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span></span></span></span>',ui,di,_f='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mi>W</mi></mrow><annotation encoding="application/x-tex"> Y = X * W </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span></span></span></span></span>',gi,jt,Bc,yi,Jf='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mi>Y</mi><mo>=</mo><mi>X</mi><mo>∗</mo><mtext>dequantize</mtext><mo stretchy="false">(</mo><mi>W</mi><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> Y = X * \\text{dequantize}(W) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.22222em;">Y</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.07847em;">X</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">dequantize</span></span><span class="mopen">(</span><span class="mord mathnormal" style="margin-right:0.13889em;">W</span><span class="mclose">)</span></span></span></span></span>',fi,_t,Bd="for every matrix multiplication. Dequantization and re-quantization is performed sequentially for all weight matrices as the inputs run through the network graph.",wi,Jt,Zd=`Therefore, inference time is often <strong>not</strong> reduced when using quantized weights, but rather increases.
Enough theory, let’s give it a try! To quantize the weights with Transformers, you need to make sure that
the <a href="https://github.com/TimDettmers/bitsandbytes" rel="nofollow"><code>bitsandbytes</code></a> library is installed.`,bi,Ut,vi,Ct,Id="We can then load models in 8-bit quantization by simply adding a <code>load_in_8bit=True</code> flag to <code>from_pretrained</code>.",Mi,zt,xi,Lt,$d="Now, let’s run our example again and measure the memory usage.",ki,Gt,Ti,Bt,Wd="<strong>Output</strong>:",ji,Zt,_i,It,Hd="Nice, we’re getting the same result as before, so no loss in accuracy! Let’s look at how much memory was used this time.",Ji,$t,Ui,Wt,Qd="<strong>Output</strong>:",Ci,Ht,zi,Qt,Xd=`Significantly less! We’re down to just a bit over 15 GBs and could therefore run this model on consumer GPUs like the 4090.
We’re seeing a very nice gain in memory efficiency and more or less no degradation to the model’s output. However, we can also notice a slight slow-down during inference.`,Li,Xt,Nd="We delete the models and flush the memory again.",Gi,Nt,Bi,Rt,Zi,Vt,Rd="Let’s see what peak GPU memory consumption 4-bit quantization gives. Quantizing the model to 4-bit can be done with the same API as before - this time by passing <code>load_in_4bit=True</code> instead of <code>load_in_8bit=True</code>.",Ii,qt,$i,At,Vd="<strong>Output</strong>:",Wi,Et,Hi,Yt,qd="We’re almost seeing the same output text as before - just the <code>python</code> is missing just before the code snippet. Let’s see how much memory was required.",Qi,St,Xi,Ft,Ad="<strong>Output</strong>:",Ni,Pt,Ri,Kt,Ed="Just 9.5GB! That’s really not a lot for a >15 billion parameter model.",Vi,Dt,Yd="While we see very little degradation in accuracy for our model here, 4-bit quantization can in practice often lead to different results compared to 8-bit quantization or full <code>bfloat16</code> inference. It is up to the user to try it out.",qi,K,Zc,Ai,Uf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>quantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{quantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8623em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">quantize</span></span></span></span></span>',Ei,Yi,Cf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>dequantize</mtext></mrow><annotation encoding="application/x-tex"> \\text{dequantize} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord text"><span class="mord">dequantize</span></span></span></span></span>',Si,Fi,Ot,Pi,sa,Ki,ta,Sd="Overall, we saw that running OctoCoder in 8-bit precision reduced the required GPU VRAM from 32G GPU VRAM to only 15GB and running the model in 4-bit precision further reduces the required GPU VRAM to just a bit over 9GB.",Di,aa,Fd="4-bit quantization allows the model to be run on GPUs such as RTX3090, V100, and T4 which are quite accessible for most people.",Oi,ea,Pd='For more information on quantization and to see how one can quantize models to require even less GPU VRAM memory than 4-bit, we recommend looking into the <a href="https://huggingface.co/docs/transformers/main/en/main_classes/quantization#autogptq-integration%60" rel="nofollow"><code>AutoGPTQ</code></a> implementation.',sp,na,Kd="<p>As a conclusion, it is important to remember that model quantization trades improved memory efficiency against accuracy and in some cases inference time.</p>",tp,la,Dd="If GPU memory is not a constraint for your use case, there is often no need to look into quantization. However many GPUs simply can’t run LLMs without quantization methods and in this case, 4-bit and 8-bit quantization schemes are extremely useful tools.",ap,ia,Od=`For more in-detail usage information, we strongly recommend taking a look at the <a href="https://huggingface.co/docs/transformers/main_classes/quantization#general-usage" rel="nofollow">Transformers Quantization Docs</a>.
Next, let’s look into how we can improve computational and memory efficiency by using better algorithms and an improved model architecture.`,ep,pa,np,ma,sg="Today’s top-performing LLMs share more or less the same fundamental architecture that consists of feed-forward layers, activation layers, layer normalization layers, and most crucially, self-attention layers.",lp,q,Ic,bn,tg="quadratically",$c,vn,ag="sequence length",Wc,ip,zf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',pp,mp,T,Hc,op,Lf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',rp,hp,Gf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span></span></span></span>',cp,up,Bf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',dp,gp,Zf='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><mtext mathvariant="bold">O</mtext><mo>=</mo><mtext>Attn</mtext><mo stretchy="false">(</mo><mi mathvariant="bold">X</mi><mo stretchy="false">)</mo><mo>=</mo><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo><mtext> with </mtext><mi mathvariant="bold">Q</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>q</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">V</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>v</mi></msub><mi mathvariant="bold">X</mi><mo separator="true">,</mo><mi mathvariant="bold">K</mi><mo>=</mo><msub><mi mathvariant="bold">W</mi><mi>k</mi></msub><mi mathvariant="bold">X</mi></mrow><annotation encoding="application/x-tex"> \\textbf{O} = \\text{Attn}(\\mathbf{X}) = \\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T) \\text{ with } \\mathbf{Q} = \\mathbf{W}_q \\mathbf{X}, \\mathbf{V} = \\mathbf{W}_v \\mathbf{X}, \\mathbf{K} = \\mathbf{W}_k \\mathbf{X} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord text"><span class="mord textbf">O</span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Attn</span></span><span class="mopen">(</span><span class="mord mathbf">X</span><span class="mclose">)</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> with </span></span><span class="mord mathbf">Q</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">q</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03588em;">v</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathbf">K</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">W</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.03148em;">k</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord mathbf">X</span></span></span></span></span>',yp,fp,If='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">X</mi><mo>=</mo><mo stretchy="false">(</mo><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo separator="true">,</mo><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><mi mathvariant="normal">.</mi><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex">  \\mathbf{X} = (\\mathbf{x}_1, ... \\mathbf{x}_{N}) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">X</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">(</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">...</span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',wp,bp,$f='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{Q} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8805em;vertical-align:-0.1944em;"></span><span class="mord mathbf">Q</span></span></span></span>',vp,Mp,Wf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">K</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{K} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">K</span></span></span></span>',xp,kp,Hf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Tp,jp,Qf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',_p,Jp,Xf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Up,Cp,U,Qc,zp,Nf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">Q</mi><msup><mi mathvariant="bold">K</mi><mi mathvariant="bold">T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK^T} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0377em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">Q</span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8433em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathbf mtight">T</span></span></span></span></span></span></span></span></span></span></span></span>',Lp,Gp,Rf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>40</mn><mo>∗</mo><mn>2</mn><mo>∗</mo><msup><mi>N</mi><mn>2</mn></msup></mrow><annotation encoding="application/x-tex"> 40 * 2 * N^2 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">40</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8141em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8141em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span></span></span></span></span></span></span></span>',Bp,Zp,Vf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>1000</mn></mrow><annotation encoding="application/x-tex"> N=1000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">1000</span></span></span></span>',Ip,$p,qf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>16000</mn></mrow><annotation encoding="application/x-tex"> N=16000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">16000</span></span></span></span>',Wp,Hp,Af='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi><mo>=</mo><mn>100</mn><mo separator="true">,</mo><mn>000</mn></mrow><annotation encoding="application/x-tex"> N=100,000 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8389em;vertical-align:-0.1944em;"></span><span class="mord">100</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord">000</span></span></span></span>',Qp,Xp,Ef='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Np,Rp,oa,eg="Long story short, the default self-attention algorithm quickly becomes prohibitively memory-expensive for large input contexts.",Vp,ra,ng="As LLMs improve in text comprehension and generation, they are applied to increasingly complex tasks. While models once handled the translation or summarization of a few sentences, they now manage entire pages, demanding the capability to process extensive input lengths.",qp,A,Xc,Ap,Yf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Ep,rs,lg="Tri Dao et al.",Nc,Mn,ig="Flash Attention",Rc,Yp,is,Vc,Sp,Sf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">V</mi><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex">\\mathbf{V} \\times \\text{Softmax}(\\mathbf{QK}^T</annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7694em;vertical-align:-0.0833em;"></span><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Fp,Pp,Ff='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>←</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup><mo>∗</mo><msub><mtext mathvariant="bold">O</mtext><mi>i</mi></msub><mo>+</mo><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup><mo>∗</mo><msub><mi mathvariant="bold">V</mi><mi>j</mi></msub><mo>×</mo><mtext>Softmax</mtext><mo stretchy="false">(</mo><msubsup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><mi>T</mi></msubsup><mo stretchy="false">)</mo><mtext> for multiple </mtext><mi>i</mi><mo separator="true">,</mo><mi>j</mi><mtext> iterations</mtext></mrow><annotation encoding="application/x-tex"> \\textbf{O}_i \\leftarrow s^a_{ij} * \\textbf{O}_i + s^b_{ij} * \\mathbf{V}_{j} \\times \\text{Softmax}(\\mathbf{QK}^T_{i,j}) \\text{ for multiple } i, j \\text{ iterations} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">←</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.0975em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7144em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.8361em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord text"><span class="mord textbf">O</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.2822em;vertical-align:-0.3831em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8991em;"><span style="top:-2.453em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">V</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">×</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1.3004em;vertical-align:-0.3831em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">i</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3831em;"><span></span></span></span></span></span></span><span class="mclose">)</span><span class="mord text"><span class="mord"> for multiple </span></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mord text"><span class="mord"> iterations</span></span></span></span></span></span>',Kp,W,qc,Dp,Pf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>a</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^a_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0592em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.6644em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">a</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',Op,sm,Kf='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msubsup><mi>s</mi><mrow><mi>i</mi><mi>j</mi></mrow><mi>b</mi></msubsup></mrow><annotation encoding="application/x-tex"> s^b_{ij} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2439em;vertical-align:-0.3948em;"></span><span class="mord"><span class="mord mathnormal">s</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8491em;"><span style="top:-2.4413em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">ij</span></span></span></span><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">b</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.3948em;"><span></span></span></span></span></span></span></span></span></span>',tm,am,Df='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',em,nm,Of='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',lm,im,ha,pg='Please note that the whole Flash Attention is a bit more complex and is greatly simplified here as going in too much depth is out of scope for this guide. The reader is invited to take a look at the well-written <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">Flash Attention paper</a> for more details.',pm,ca,mg="The main takeaway here is:",mm,xn,ps,Ac,kn,og="numerical identical",Ec,om,sw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',rm,hm,ua,rg='Looking at the formula, one would intuitively say that Flash Attention must be much slower compared to the default self-attention formula as more computation needs to be done. Indeed Flash Attention requires more FLOPs compared to normal attention as the softmax normalization statistics have to constantly be recomputed (see <a href="https://arxiv.org/abs/2205.14135" rel="nofollow">paper</a> for more details if interested)',cm,da,hg="<p>However, Flash Attention is much faster in inference compared to default attention which comes from its ability to significantly reduce the demands on the slower, high-bandwidth memory of the GPU (VRAM), focusing instead on the faster on-chip memory (SRAM).</p>",um,D,Yc,Tn,cg="on-chip",Sc,dm,tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">O</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{O} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">O</span></span></span></span>',gm,ym,ga,ug="In practice, there is currently absolutely no reason to <strong>not</strong> use Flash Attention if available. The algorithm gives mathematically the same outputs, and is both faster and more memory-efficient.",fm,ya,dg="Let’s look at a practical example.",wm,fa,gg=`Our OctoCoder model now gets a significantly longer input prompt which includes a so-called <em>system prompt</em>. System prompts are used to steer the LLM into a better assistant that is tailored to the users’ task.
In the following, we use a system prompt that will make OctoCoder a better coding assistant.`,bm,wa,vm,ba,yg=`For demonstration purposes, we duplicate the system prompt by ten so that the input length is long enough to observe Flash Attention’s memory savings.
We append the original text prompt <code>&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer: Here&quot;</code>`,Mm,va,xm,Ma,fg="We instantiate our model again in bfloat16 precision.",km,xa,Tm,ka,wg="Let’s now run the model just like before <em>without Flash Attention</em> and measure the peak GPU memory requirement and inference time.",jm,Ta,_m,ja,bg="<strong>Output</strong>:",Jm,_a,Um,Ja,vg="We’re getting the same output as before, however this time, the model repeats the answer multiple times until it’s 60 tokens cut-off. This is not surprising as we’ve repeated the system prompt ten times for demonstration purposes and thus cued the model to repeat itself.",Cm,Ua,Mg="<strong>Note</strong> that the system prompt should not be repeated ten times in real-world applications - one time is enough!",zm,Ca,xg="Let’s measure the peak GPU memory requirement.",Lm,za,Gm,La,kg="<strong>Output</strong>:",Bm,Ga,Zm,Ba,Tg="As we can see the peak GPU memory requirement is now significantly higher than in the beginning, which is largely due to the longer input sequence. Also the generation takes a little over a minute now.",Im,Za,jg="We call <code>flush()</code> to free GPU memory for our next experiment.",$m,Ia,Wm,$a,_g=`For comparison, let’s run the same function, but enable Flash Attention instead.
To do so, we convert the model to <a href="https://huggingface.co/docs/optimum/bettertransformer/overview" rel="nofollow">BetterTransformer</a> and by doing so enabling PyTorch’s <a href="https://pytorch.org/docs/master/generated/torch.nn.functional.scaled_dot_product_attention" rel="nofollow">SDPA self-attention</a> which in turn is able to use Flash Attention.`,Hm,Wa,Qm,Ha,Jg="Now we run the exact same code snippet as before and under the hood Transformers will make use of Flash Attention.",Xm,Qa,Nm,Xa,Ug="<strong>Output</strong>:",Rm,Na,Vm,Ra,Cg="We’re getting the exact same result as before, but can observe a very significant speed-up thanks to Flash Attention.",qm,Va,zg="Let’s measure the memory consumption one last time.",Am,qa,Em,Aa,Lg="<strong>Output</strong>:",Ym,Ea,Sm,Ya,Gg="And we’re almost back to our original 29GB peak GPU memory from the beginning.",Fm,Sa,Bg="We can observe that we only use roughly 100MB more GPU memory when passing a very long input sequence with Flash Attention compared to passing a short input sequence as done in the beginning.",Pm,Fa,Km,Pa,Zg='For more information on how to use Flash Attention, please have a look at <a href="https://huggingface.co/docs/transformers/en/perf_infer_gpu_one#flashattention-2" rel="nofollow">this doc page</a>.',Dm,Ka,Ig="## 3. Architectural Innovations",Om,Da,$g="So far we have looked into improving computational and memory efficiency by:",so,Oa,Wg="<li>Casting the weights to a lower precision format</li> <li>Replacing the self-attention algorithm with a more memory- and compute efficient version</li>",to,se,Hg="Let’s now look into how we can change the architecture of an LLM so that it is most effective and efficient for task that require long text inputs, <em>e.g.</em>:",ao,te,Qg="<li>Retrieval augmented Questions Answering,</li> <li>Summarization,</li> <li>Chat</li>",eo,ae,Xg="Note that <em>chat</em> not only requires the LLM to handle long text inputs, but it also necessitates that the LLM is able to efficiently handle the back-and-forth dialogue between user and assistant (such as ChatGPT).",no,ee,Ng=`Once trained, the fundamental LLM architecture is difficult to change, so it is important to make considerations about the LLM’s tasks beforehand and accordingly optimize the model’s architecture.
There are two important components of the model architecture that quickly become memory and/or performance bottlenecks for large input sequences.`,lo,ne,Rg="<li>The positional embeddings</li> <li>The key-value cache</li>",io,le,Vg="Let’s go over each component in more detail",po,ie,qg="### 3.1 Improving positional embeddings of LLMs",mo,O,Fc,oo,aw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mtext>Softmax</mtext><mo stretchy="false">(</mo><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> \\text{Softmax}(\\mathbf{QK}^T) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1673em;vertical-align:-0.25em;"></span><span class="mord text"><span class="mord">Softmax</span></span><span class="mopen">(</span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span><span class="mclose">)</span></span></span></span>',ro,jn,Ag="“Hello”, “I”, “love”, “you”",Pc,ho,pe,Eg='<img src="/blog/assets/163_optimize_llm/self_attn_tokens.png"/>',co,me,Yg="Each word token is given a probability mass at which it attends all other word tokens and, therefore is put into relation with all other word tokens. E.g. the word <em>“love”</em> attends to the word <em>“Hello”</em> with 5%, to <em>“I”</em> with 30%, and to itself with 65%.",uo,I,Kc,go,ew='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',yo,fo,nw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>O</mi><mo stretchy="false">(</mo><mn>1</mn><mo stretchy="false">)</mo></mrow><annotation encoding="application/x-tex"> O(1) </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">O</span><span class="mopen">(</span><span class="mord">1</span><span class="mclose">)</span></span></span></span>',wo,_n,Sg="e.g.",Dc,Jn,Fg="“Hello I love you”",Oc,Un,Pg="“You love I hello”",su,bo,oe,Kg=`For the LLM to understand sentence order, an additional <em>cue</em> is needed and is usually applied in the form of <em>positional encodings</em> (or also called <em>positional embeddings</em>).
Positional encodings, encode the position of each token into a numerical presentation that the LLM can leverage to better understand sentence order.`,vo,C,tu,hs,Dg="<em>Attention Is All You Need</em>",au,Mo,lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi><mo>=</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{P} = \\mathbf{p}_1, \\ldots, \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',xo,ko,iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">p</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{p}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',To,jo,pw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',_o,Jo,mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mover accent="true"><mi mathvariant="bold">X</mi><mo>^</mo></mover><mo>=</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{X}} = \\mathbf{\\hat{x}}_1, \\ldots, \\mathbf{\\hat{x}}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9495em;"></span><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9495em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">X</span></span><span style="top:-3.2551em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.9023em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Uo,Co,ow='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mn>1</mn></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mn>1</mn></msub><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><msub><mi mathvariant="bold">x</mi><mi>N</mi></msub><mo>+</mo><msub><mi mathvariant="bold">p</mi><mi>N</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_1 + \\mathbf{p}_1, \\ldots, \\mathbf{x}_N + \\mathbf{p}_N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.7778em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">+</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">p</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3283em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.10903em;">N</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',zo,Lo,ss,eu,cs,Og="Devlin et al.",nu,Go,rw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi mathvariant="bold">P</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{P} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6861em;"></span><span class="mord mathbf">P</span></span></span></span>',Bo,Zo,re,sy="Sinusoidal and learned position embeddings used to be the predominant methods to encode sentence order into LLMs, but a couple of problems related to these positional encodings were found:",Io,us,R,lu,Cn,ty="i.e.",iu,$o,hw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>N</mi></mrow><annotation encoding="application/x-tex"> 0, \\ldots, N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8778em;vertical-align:-0.1944em;"></span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Wo,ds,ay="Huang et al.",pu,gs,ey="Su et al.",mu,ou,he,ru,Ho,cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>N</mi></mrow><annotation encoding="application/x-tex"> N </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6833em;"></span><span class="mord mathnormal" style="margin-right:0.10903em;">N</span></span></span></span>',Qo,Xo,ce,ny="Recently, relative positional embeddings that can tackle the above mentioned problems have become more popular, most notably:",No,ue,ly='<li><a href="https://arxiv.org/abs/2104.09864" rel="nofollow">Rotary Position Embedding (RoPE)</a></li> <li><a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a></li>',Ro,E,hu,zn,iy="RoPE",cu,Ln,py="ALiBi",uu,Vo,uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',qo,Ao,k,du,Gn,my="RoPE",gu,Bn,oy="e.g.",Eo,dw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Yo,So,gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',Fo,Po,yw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> \\theta * i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',Ko,Do,fw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi><mo>∗</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> \\theta * j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">∗</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',Oo,sr,ww='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo separator="true">,</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i, j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',tr,ar,bw='<span class="katex-display"><span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML" display="block"><semantics><mrow><msubsup><mover accent="true"><mi mathvariant="bold">q</mi><mo>^</mo></mover><mi>i</mi><mi>T</mi></msubsup><msub><mover accent="true"><mi mathvariant="bold">x</mi><mo>^</mo></mover><mi>j</mi></msub><mo>=</mo><msubsup><mi mathvariant="bold">q</mi><mi>i</mi><mi>T</mi></msubsup><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub><msub><mi mathvariant="bold">x</mi><mi>j</mi></msub><mi mathvariant="normal">.</mi></mrow><annotation encoding="application/x-tex"> \\mathbf{\\hat{q}}_i^T \\mathbf{\\hat{x}}_j = \\mathbf{{q}}_i^T \\mathbf{R}_{\\theta, i -j} \\mathbf{{x}}_j. </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.2252em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord accent"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">q</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1944em;"><span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.9391em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.1608em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord accent"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.7079em;"><span style="top:-3em;"><span class="pstrut" style="height:3em;"></span><span class="mord mathbf">x</span></span><span style="top:-3.0134em;"><span class="pstrut" style="height:3em;"></span><span class="accent-body" style="left:-0.2875em;"><span class="mord mathbf">^</span></span></span></span></span></span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1.1774em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">q</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.8913em;"><span style="top:-2.453em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span><span style="top:-3.113em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.247em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord"><span class="mord mathbf">x</span></span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mord">.</span></span></span></span></span>',er,nr,vw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">R</mi><mrow><mi>θ</mi><mo separator="true">,</mo><mi>i</mi><mo>−</mo><mi>j</mi></mrow></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{R}_{\\theta, i - j} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9722em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">R</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3361em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight" style="margin-right:0.02778em;">θ</span><span class="mpunct mtight">,</span><span class="mord mathnormal mtight">i</span><span class="mbin mtight">−</span><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',lr,ir,Mw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',pr,Zn,ry="not",yu,mr,In,Z,fu,or,xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',rr,hr,kw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7305em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',cr,ur,Tw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo mathvariant="normal">≠</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i \\ne j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel"><span class="mrel"><span class="mord vbox"><span class="thinbox"><span class="rlap"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="inner"><span class="mord"><span class="mrel"></span></span></span><span class="fix"></span></span></span></span></span><span class="mrel">=</span></span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',dr,gr,jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi><mo>−</mo><mi>j</mi></mrow><annotation encoding="application/x-tex"> i - j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.7429em;vertical-align:-0.0833em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',yr,fr,_w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>i</mi></mrow><annotation encoding="application/x-tex"> i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',wr,br,Jw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi></mrow><annotation encoding="application/x-tex"> j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span></span></span></span>',vr,Mr,de,hy="<em>RoPE</em> is used in multiple of today’s most important LLMs, such as:",xr,ge,cy='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2302.13971" rel="nofollow"><strong>Llama</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li>',kr,Y,wu,$n,uy="ALiBi",bu,Wn,dy="m",vu,Tr,Uw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',jr,_r,ye,gy='<img src="/blog/assets/163_optimize_llm/alibi.png"/>',Jr,fe,yy='As shown in the <a href="https://arxiv.org/abs/2108.12409" rel="nofollow">ALiBi</a> paper, this simple relative positional encoding allows the model to retain a high performance even at very long text input sequences.',Ur,we,fy="<em>ALiBi</em> is used in multiple of today’s most important LLMs, such as:",Cr,be,wy='<li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',zr,x,Mu,Hn,by="RoPE",xu,Qn,vy="ALiBi",ku,Xn,My="ALiBi",Tu,Nn,xy="RoPE",ju,Rn,ky="RoPE",_u,Lr,Cw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',Gr,Vn,Ty="c.f",Ju,ys,jy="Press et al.",Uu,Br,zw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>θ</mi></mrow><annotation encoding="application/x-tex"> \\theta </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6944em;"></span><span class="mord mathnormal" style="margin-right:0.02778em;">θ</span></span></span></span>',Zr,qn,_y="RoPE",Cu,fs,Jy="here",zu,Ir,ws,An,Uy="Both RoPE and ALiBi are relative positional embeddings that are <em>not</em> learned during training, but instead are based on the following intuitions:",Lu,ms,ve,Gu,$r,Lw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>Q</mi><msup><mi>K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> QK^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord mathnormal">Q</span><span class="mord"><span class="mord mathnormal" style="margin-right:0.07153em;">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Wr,Bu,En,Cy="The LLM should be incentivized to learn a constant <em>relative</em> distance positional encodings have to each other",Zu,Yn,zy="The further text input tokens are from each other, the lower the probability of their query-value probability. Both RoPE and ALiBi lower the query-key probability of tokens far away from each other. RoPE by decreasing their vector product by increasing the angle between the query-key vectors. ALiBi by adding large negative numbers to the vector product",Hr,S,Iu,Qr,Gw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub><mo>=</mo><mn>2048</mn></mrow><annotation encoding="application/x-tex"> N_1 = 2048 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6444em;"></span><span class="mord">2048</span></span></span></span>',Xr,Nr,Bw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',Rr,Vr,Zw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi>N</mi><mn>2</mn></msub><mo>=</mo><mn>8192</mn><mo>&gt;</mo><msub><mi>N</mi><mn>1</mn></msub></mrow><annotation encoding="application/x-tex"> N_2 = 8192 &gt; N_1 </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">2</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">=</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6835em;vertical-align:-0.0391em;"></span><span class="mord">8192</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.8333em;vertical-align:-0.15em;"></span><span class="mord"><span class="mord mathnormal" style="margin-right:0.10903em;">N</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3011em;"><span style="top:-2.55em;margin-left:-0.109em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight">1</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',qr,Ar,Me,Ly="### 3.2 The key-value cache",Er,xe,Gy="Auto-regressive text generation with LLMs works by iteratively putting in an input sequence, sampling the next token, appending the next token to the input sequence, and continuing to do so until the LLM produces a token that signifies that the generation has finished.",Yr,ke,By='Please have a look at <a href="https://huggingface.co/docs/transformers/llm_tutorial#generate-text" rel="nofollow">Transformer’s Generate Text Tutorial</a> to get a more visual explanation of how auto-regressive generation works.',Sr,Te,Zy="Let’s run a quick code snippet to show how auto-regressive works in practice. We will simply take the most likely next token via <code>torch.argmax</code>.",Fr,je,Pr,_e,Iy="<strong>Output</strong>:",Kr,Je,Dr,Ue,$y="As we can see every time we increase the text input tokens by the just sampled token.",Or,Ce,Wy='With very few exceptions, LLMs are trained using the <a href="https://huggingface.co/docs/transformers/tasks/language_modeling#causal-language-modeling" rel="nofollow">causal language modeling objective</a> and therefore mask the upper triangle matrix of the attention score - this is why in the two diagrams above the attention scores are left blank (<em>a.k.a</em> have 0 probability). For a quick recap on causal language modeling you can refer to the <a href="https://jalammar.github.io/illustrated-gpt2/#part-2-illustrated-self-attention" rel="nofollow"><em>Illustrated Self Attention blog</em></a>.',sh,z,$u,Sn,Hy="never",Wu,th,Iw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',ah,eh,$w='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>j</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>j</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_j, \\mathbf{v}_j </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.9805em;vertical-align:-0.2861em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.05724em;">j</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.2861em;"><span></span></span></span></span></span></span></span></span></span>',nh,lh,Ww='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><mi>j</mi><mo>&gt;</mo><mi>i</mi></mrow><annotation encoding="application/x-tex"> j &gt; i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.854em;vertical-align:-0.1944em;"></span><span class="mord mathnormal" style="margin-right:0.05724em;">j</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">&gt;</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:0.6595em;"></span><span class="mord mathnormal">i</span></span></span></span>',ih,ph,Hw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',mh,oh,Qw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mrow><mi>m</mi><mo>&lt;</mo><mi>i</mi></mrow></msub><mtext> , for </mtext><mi>m</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>0</mn><mo separator="true">,</mo><mo>…</mo><mi>i</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_{m &lt; i}, \\mathbf{v}_{m &lt; i} \\text{ , for } m \\in \\{0, \\ldots i - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mtight"><span class="mord mathnormal mtight">m</span><span class="mrel mtight">&lt;</span><span class="mord mathnormal mtight">i</span></span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.1774em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord"> , for </span></span><span class="mord mathnormal">m</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">0</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',rh,hh,ze,Qy=`In the following, we will tell the LLM to make use of the key-value cache by retrieving and forwarding it for each forward pass.
In Transformers, we can retrieve the key-value cache by passing the <code>use_cache</code> flag to the <code>forward</code> call and can then pass it with the current token.`,ch,Le,uh,Ge,Xy="<strong>Output</strong>:",dh,Be,gh,Ze,Ny="As one can see, when using the key-value cache the text input tokens are <em>not</em> increased in length, but remain a single input vector. The length of the key-value cache on the other hand is increased by one at every decoding step.",yh,Fn,V,Hu,fh,Xw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',wh,bh,Nw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',vh,Mh,Rw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.6389em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',xh,Pn,Ry="always",Qu,kh,Ie,Vy="Using the key-value cache has two advantages:",Th,bs,$e,Xu,jh,Vw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',_h,Nu,Kn,qy="The maximum required memory is not increased quadratically with the number of generated tokens, but only increases linearly.",Jh,We,Ay='<p>One should <em>always</em> make use of the key-value cache as it leads to identical results and a significant speed-up for longer input sequences. Transformers has the key-value cache enabled by default when making use of the text pipeline or the <a href="https://huggingface.co/docs/transformers/main_classes/text_generation" rel="nofollow"><code>generate</code> method</a>.</p>',Uh,vs,Ch,He,Ey="#### 3.2.1 Multi-round conversation",zh,Qe,Yy="The key-value cache is especially useful for applications such as chat where multiple passes of auto-regressive decoding are required. Let’s look at an example.",Lh,Xe,Gh,Ne,Sy="In this chat, the LLM runs auto-regressive decoding twice:",Bh,Re,Fy="<li>The first time, the key-value cache is empty and the input prompt is <code>&quot;User: How many people live in France?&quot;</code> and the model auto-regressively generates the text <code>&quot;Roughly 75 million people live in France&quot;</code> while increasing the key-value cache at every decoding step.</li> <li>The second time the input prompt is <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many in Germany?&quot;</code>. Thanks to the cache, all key-value vectors for the first two sentences are already computed. Therefore the input prompt only consists of <code>&quot;User: And how many in Germany?&quot;</code>. While processing the shortened input prompt, it’s computed key-value vectors are concatenated to the key-value cache of the first decoding. The second Assistant’s answer <code>&quot;Germany has ca. 81 million inhabitants&quot;</code> is then auto-regressively generated with the key-value cache consisting of encoded key-value vectors of <code>&quot;User: How many people live in France? \\n Assistant: Roughly 75 million people live in France \\n User: And how many are in Germany?&quot;</code>.</li>",Zh,Ve,Py="Two things should be noted here:",Ih,qe,Ky="<li>Keeping all the context is crucial for LLMs deployed in chat so that the LLM understands all the previous context of the conversation. E.g. for the example above the LLM needs to understand that the user refers to the population when asking <code>&quot;And how many are in Germany&quot;</code>.</li> <li>The key-value cache is extremely useful for chat as it allows us to continuously grow the encoded chat history instead of having to re-encode the chat history again from scratch (as e.g. would be the case when using an encoder-decoder architecture).</li>",$h,Ae,Dy="In <code>transformers</code>, a <code>generate</code> call will return <code>past_key_values</code> when <code>return_dict_in_generate=True</code> is passed, in addition to the default <code>use_cache=True</code>. Note that it is not yet available through the <code>pipeline</code> interface.",Wh,Ee,Hh,Ye,Oy="<strong>Output</strong>:",Qh,Se,Xh,ts,Ru,Nh,qw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',Rh,Vh,Aw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">x</mi><mi>i</mi></msub><mtext>, for </mtext><mi>i</mi><mo>∈</mo><mo stretchy="false">{</mo><mn>1</mn><mo separator="true">,</mo><mo>…</mo><mo separator="true">,</mo><mi>c</mi><mo>−</mo><mn>1</mn><mo stretchy="false">}</mo></mrow><annotation encoding="application/x-tex"> \\mathbf{x}_i \\text{, for } i \\in \\{1, \\ldots, c - 1\\} </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">x</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord text"><span class="mord">, for </span></span><span class="mord mathnormal">i</span><span class="mspace" style="margin-right:0.2778em;"></span><span class="mrel">∈</span><span class="mspace" style="margin-right:0.2778em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mopen">{</span><span class="mord">1</span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="minner">…</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord mathnormal">c</span><span class="mspace" style="margin-right:0.2222em;"></span><span class="mbin">−</span><span class="mspace" style="margin-right:0.2222em;"></span></span><span class="base"><span class="strut" style="height:1em;vertical-align:-0.25em;"></span><span class="mord">1</span><span class="mclose">}</span></span></span></span>',qh,Ah,Fe,sf=`Let’s compute the number of float values that need to be stored in the key-value cache for the LLM <code>bigcode/octocoder</code> that we used before.
The number of float values amounts to two times the sequence length times the number of attention heads times the attention head dimension and times the number of layers.
Computing this for our LLM at a hypothetical input sequence length of 16000 gives:`,Eh,Pe,Yh,Ke,tf="<strong>Output</strong>:",Sh,De,Fh,Oe,af=`Roughly 8 billion float values! Storing 8 billion float values in <code>float16</code> precision requires around 15 GB of RAM which is circa half as much as the model weights themselves!
Researchers have proposed two methods that allow to significantly reduce the memory cost of storing the key-value cache, which are explored in the next subsections.`,Ph,sn,ef="#### 3.2.2 Multi-Query-Attention (MQA)",Kh,tn,nf='<a href="https://arxiv.org/abs/1911.02150" rel="nofollow">Multi-Query-Attention</a> was proposed in Noam Shazeer’s <em>Fast Transformer Decoding: One Write-Head is All You Need</em> paper. As the title says, Noam found out that instead of using <code>n_head</code> key-value projections weights, one can use a single head-value projection weight pair that is shared across all attention heads without that the model’s performance significantly degrades.',Dh,Dn,os,Vu,Oh,Ew='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">k</mi><mi>i</mi></msub><mo separator="true">,</mo><msub><mi mathvariant="bold">v</mi><mi>i</mi></msub></mrow><annotation encoding="application/x-tex"> \\mathbf{k}_i, \\mathbf{v}_i </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:0.8889em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">k</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mpunct">,</span><span class="mspace" style="margin-right:0.1667em;"></span><span class="mord"><span class="mord mathbf" style="margin-right:0.01597em;">v</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.3117em;"><span style="top:-2.55em;margin-left:-0.016em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">i</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span></span></span></span>',sc,On,lf="n_head",qu,tc,an,pf="As most LLMs use between 20 and 100 attention heads, MQA significantly reduces the memory consumption of the key-value cache. For the LLM used in this notebook we could therefore reduce the required memory consumption from 15 GB to less than 400 MB at an input sequence length of 16000.",ac,as,Au,ec,Yw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msub><mi mathvariant="bold">q</mi><mi>c</mi></msub><msup><mi mathvariant="bold">K</mi><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{q}_c\\mathbf{K}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.0358em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord mathbf">q</span><span class="msupsub"><span class="vlist-t vlist-t2"><span class="vlist-r"><span class="vlist" style="height:0.1514em;"><span style="top:-2.55em;margin-left:0em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight">c</span></span></span></span><span class="vlist-s">​</span></span><span class="vlist-r"><span class="vlist" style="height:0.15em;"><span></span></span></span></span></span></span><span class="mord"><span class="mord mathbf">K</span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.8413em;"><span style="top:-3.063em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',nc,Ms,mf="Noam’s paper",Eu,lc,xs,Yu,ic,Sw='<span class="katex"><span class="katex-mathml"><math xmlns="http://www.w3.org/1998/Math/MathML"><semantics><mrow><msup><mrow><mi mathvariant="bold">Q</mi><mi mathvariant="bold">K</mi></mrow><mi>T</mi></msup></mrow><annotation encoding="application/x-tex"> \\mathbf{QK}^T </annotation></semantics></math></span><span class="katex-html" aria-hidden="true"><span class="base"><span class="strut" style="height:1.1118em;vertical-align:-0.1944em;"></span><span class="mord"><span class="mord"><span class="mord mathbf">QK</span></span><span class="msupsub"><span class="vlist-t"><span class="vlist-r"><span class="vlist" style="height:0.9173em;"><span style="top:-3.139em;margin-right:0.05em;"><span class="pstrut" style="height:2.7em;"></span><span class="sizing reset-size6 size3 mtight"><span class="mord mathnormal mtight" style="margin-right:0.13889em;">T</span></span></span></span></span></span></span></span></span></span></span>',pc,mc,en,of="MQA has seen wide adoption by the community and is now used by many of the most popular LLMs:",oc,nn,rf='<li><a href="https://huggingface.co/tiiuae/falcon-40b" rel="nofollow"><strong>Falcon</strong></a></li> <li><a href="https://arxiv.org/abs/2204.02311" rel="nofollow"><strong>PaLM</strong></a></li> <li><a href="https://huggingface.co/mosaicml/mpt-30b" rel="nofollow"><strong>MPT</strong></a></li> <li><a href="https://huggingface.co/bigscience/bloom" rel="nofollow"><strong>BLOOM</strong></a></li>',rc,ln,hf="Also, the checkpoint used in this notebook - <code>bigcode/octocoder</code> - makes use of MQA.",hc,pn,cf="#### 3.2.3 Grouped-Query-Attention (GQA)",cc,mn,uf='<a href="https://arxiv.org/abs/2305.13245" rel="nofollow">Grouped-Query-Attention</a>, as proposed by Ainslie et al. from Google, found that using MQA can often lead to quality degradation compared to using vanilla multi-key-value head projections. The paper argues that more model performance can be kept by less drastically reducing the number of query head projection weights. Instead of using just a single key-value projection weight, <code>n &lt; n_head</code> key-value projection weights should be used. By choosing <code>n</code> to a significantly smaller value than <code>n_head</code>, such as 2,4 or 8 almost all of the memory and speed gains from MQA can be kept while sacrificing less model capacity and thus arguably less performance.',uc,on,df="Moreover, the authors of GQA found out that existing model checkpoints can be <em>uptrained</em> to have a GQA architecture with as little as 5% of the original pre-training compute. While 5% of the original pre-training compute can still be a massive amount, GQA <em>uptraining</em> allows existing checkpoints to be useful for longer input sequences.",dc,rn,gf=`GQA was only recently proposed which is why there is less adoption at the time of writing this notebook.
The most notable application of GQA is <a href="https://huggingface.co/meta-llama/Llama-2-70b-hf" rel="nofollow">Llama-v2</a>.`,gc,hn,yf="<p>As a conclusion, it is strongly recommended to make use of either GQA or MQA if the LLM is deployed with auto-regressive decoding and is required to handle large input sequences as is the case for example for chat.</p>",yc,cn,fc,un,ff='The research community is constantly coming up with new, nifty ways to speed up inference time for ever-larger LLMs. As an example, one such promising research direction is <a href="https://arxiv.org/abs/2211.17192" rel="nofollow">speculative decoding</a> where “easy tokens” are generated by smaller, faster language models and only “hard tokens” are generated by the LLM itself. Going into more detail is out of the scope of this notebook, but can be read upon in this <a href="https://huggingface.co/blog/assisted-generation" rel="nofollow">nice blog post</a>.',wc,dn,wf=`The reason massive LLMs such as GPT3/4, Llama-2-70b, Claude, PaLM can run so quickly in chat-interfaces such as <a href="https://huggingface.co/chat/" rel="nofollow">Hugging Face Chat</a> or ChatGPT is to a big part thanks to the above-mentioned improvements in precision, algorithms, and architecture.
Going forward, accelerators such as GPUs, TPUs, etc… will only get faster and allow for more memory, but one should nevertheless always make sure to use the best available algorithms and architectures to get the most bang for your buck 🤗`,bc,gn,vc,ol,Mc;return Cs=new Cc({props:{title:"Optimizing LLMs for Speed and Memory",local:"optimizing-llms-for-speed-and-memory",headingTag:"h1"}}),zs=new ab({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/llm_tutorial_optimization.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/pytorch/llm_tutorial_optimization.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/transformers_doc/en/tensorflow/llm_tutorial_optimization.ipynb"}]}}),Ws=new Cc({props:{title:"1. Lower Precision",local:"1-lower-precision",headingTag:"h2"}}),Ps=new v({props:{code:"IXBpcCUyMGluc3RhbGwlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRlJTIwYml0c2FuZGJ5dGVzJTIwb3B0aW11bQ==",highlighted:"!pip install transformers accelerate bitsandbytes optimum",wrap:!1}}),Ks=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnc2NpZW5jZSUyRmJsb29tJTIyJTJDJTIwZGV2aWNlX21hcCUzRCUyMmF1dG8lMjIlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigscience/bloom&quot;</span>, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)`,wrap:!1}}),at=new v({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNJTJDJTIwQXV0b1Rva2VuaXplciUyQyUyMHBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEFtb2RlbCUyMCUzRCUyMEF1dG9Nb2RlbEZvckNhdXNhbExNLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5iZmxvYXQxNiUyQyUyMGRldmljZV9tYXAlM0QlMjJhdXRvJTIyJTJDJTIwcGFkX3Rva2VuX2lkJTNEMCklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForCausalLM, AutoTokenizer, pipeline
<span class="hljs-keyword">import</span> torch

model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>, pad_token_id=<span class="hljs-number">0</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),et=new v({props:{code:"cHJvbXB0JTIwJTNEJTIwJTIyUXVlc3Rpb24lM0ElMjBQbGVhc2UlMjB3cml0ZSUyMGElMjBmdW5jdGlvbiUyMGluJTIwUHl0aG9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzLiU1Q24lNUNuQW5zd2VyJTNBJTIyJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`prompt = <span class="hljs-string">&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer:&quot;</span>

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),lt=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),pt=new v({props:{code:"ZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElMEElMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNA==",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">bytes_to_giga_bytes</span>(<span class="hljs-params"><span class="hljs-built_in">bytes</span></span>):
  <span class="hljs-keyword">return</span> <span class="hljs-built_in">bytes</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>`,wrap:!1}}),ot=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),ht=new v({props:{code:"MjkuMDI2MDY0ODcyNzQxNw==",highlighted:"29.0260648727417",wrap:!1}}),yt=new v({props:{code:"ZGVsJTIwcGlwZSUwQWRlbCUyMG1vZGVsJTBBJTBBaW1wb3J0JTIwZ2MlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQWRlZiUyMGZsdXNoKCklM0ElMEElMjAlMjBnYy5jb2xsZWN0KCklMEElMjAlMjB0b3JjaC5jdWRhLmVtcHR5X2NhY2hlKCklMEElMjAlMjB0b3JjaC5jdWRhLnJlc2V0X3BlYWtfbWVtb3J5X3N0YXRzKCk=",highlighted:`<span class="hljs-keyword">del</span> pipe
<span class="hljs-keyword">del</span> model

<span class="hljs-keyword">import</span> gc
<span class="hljs-keyword">import</span> torch

<span class="hljs-keyword">def</span> <span class="hljs-title function_">flush</span>():
  gc.collect()
  torch.cuda.empty_cache()
  torch.cuda.reset_peak_memory_stats()`,wrap:!1}}),wt=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),vt=new v({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjByZWxlYXNlX21lbW9yeSUwQSUyMyUyMC4uLiUwQSUwQXJlbGVhc2VfbWVtb3J5KG1vZGVsKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> release_memory
<span class="hljs-comment"># ...</span>

release_memory(model)`,wrap:!1}}),Ut=new v({props:{code:"IXBpcCUyMGluc3RhbGwlMjBiaXRzYW5kYnl0ZXM=",highlighted:"!pip install bitsandbytes",wrap:!1}}),zt=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fOGJpdCUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKQ==",highlighted:'model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_8bit=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)',wrap:!1}}),Gt=new v({props:{code:"cGlwZSUyMCUzRCUyMHBpcGVsaW5lKCUyMnRleHQtZ2VuZXJhdGlvbiUyMiUyQyUyMG1vZGVsJTNEbW9kZWwlMkMlMjB0b2tlbml6ZXIlM0R0b2tlbml6ZXIpJTBBJTBBcmVzdWx0JTIwJTNEJTIwcGlwZShwcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihwcm9tcHQpJTNBJTVEJTBBcmVzdWx0",highlighted:`pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Zt=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjBweXRob24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYV9ieXRlcyhieXRlcyklM0ElNUNuJTIwJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTYwJTYwJTYwJTVDbiU1Q25UaGlzJTIwZnVuY3Rpb24lMjB0YWtlcyUyMGElMjBzaW5nbGU=",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```python\\ndef</span> bytes_to_giga_bytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single',wrap:!1}}),$t=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ht=new v({props:{code:"MTUuMjE5MjM0NDY2NTUyNzM0",highlighted:'<span class="hljs-attribute">15</span>.<span class="hljs-number">219234466552734</span>',wrap:!1}}),Nt=new v({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),Rt=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),qt=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMjBsb3dfY3B1X21lbV91c2FnZSUzRFRydWUlMkMlMjBwYWRfdG9rZW5faWQlM0QwKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKSUwQSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0Q2MCklNUIwJTVEJTVCJTIyZ2VuZXJhdGVkX3RleHQlMjIlNUQlNUJsZW4ocHJvbXB0KSUzQSU1RCUwQXJlc3VsdA==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, load_in_4bit=<span class="hljs-literal">True</span>, low_cpu_mem_usage=<span class="hljs-literal">True</span>, pad_token_id=<span class="hljs-number">0</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)

result = pipe(prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(prompt):]
result`,wrap:!1}}),Et=new v({props:{code:"SGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzJTNBJTVDbiU1Q24lNjAlNjAlNjAlNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYWJ5dGVzKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNjAlNjAlNjAlNUNuJTVDblRoaXMlMjBmdW5jdGlvbiUyMHRha2VzJTIwYSUyMHNpbmdsZSUyMGFyZ3VtZW50",highlighted:'Here <span class="hljs-keyword">is</span> a Python <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> transforms bytes <span class="hljs-keyword">to</span> Giga bytes:<span class="hljs-string">\\n\\n```\\ndef</span> bytes_to_gigabytes(bytes):<span class="hljs-string">\\n</span>    <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n```\\n\\nThis</span> <span class="hljs-keyword">function</span> takes a single argument',wrap:!1}}),St=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Pt=new v({props:{code:"OS41NDM1NzQzMzMxOTA5MTg=",highlighted:'<span class="hljs-attribute">9</span>.<span class="hljs-number">543574333190918</span>',wrap:!1}}),Ot=new v({props:{code:"ZGVsJTIwbW9kZWwlMEFkZWwlMjBwaXBl",highlighted:`<span class="hljs-keyword">del</span> model
<span class="hljs-keyword">del</span> pipe`,wrap:!1}}),sa=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),pa=new Cc({props:{title:"2. Flash Attention",local:"2-flash-attention",headingTag:"h2"}}),wa=new v({props:{code:"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",highlighted:`system_prompt = <span class="hljs-string">&quot;&quot;&quot;Below are a series of dialogues between various people and an AI technical assistant.
The assistant tries to be helpful, polite, honest, sophisticated, emotionally aware, and humble but knowledgeable.
The assistant is happy to help with code questions and will do their best to understand exactly what is needed.
It also tries to avoid giving false or misleading information, and it caveats when it isn&#x27;t entirely sure about the right answer.
That said, the assistant is practical really does its best, and doesn&#x27;t let caution get too much in the way of being useful.

The Starcoder models are a series of 15.5B parameter models trained on 80+ programming languages from The Stack (v1.2) (excluding opt-out requests).
The model uses Multi Query Attention, was trained using the Fill-in-the-Middle objective, and with 8,192 tokens context window for a trillion tokens of heavily deduplicated data.

-----

Question: Write a function that takes two lists and returns a list that has alternating elements from each input list.

Answer: Sure. Here is a function that does that.

def alternating(list1, list2):
   results = []
   for i in range(len(list1)):
       results.append(list1[i])
       results.append(list2[i])
   return results

Question: Can you write some test cases for this function?

Answer: Sure, here are some tests.

assert alternating([10, 20, 30], [1, 2, 3]) == [10, 1, 20, 2, 30, 3]
assert alternating([True, False], [4, 5]) == [True, 4, False, 5]
assert alternating([], []) == []

Question: Modify the function so that it returns all input elements when the lists have uneven length. The elements from the longer list should be at the end.

Answer: Here is the modified function.

def alternating(list1, list2):
   results = []
   for i in range(min(len(list1), len(list2))):
       results.append(list1[i])
       results.append(list2[i])
   if len(list1) &gt; len(list2):
       results.extend(list1[i+1:])
   else:
       results.extend(list2[i+1:])
   return results

-----
&quot;&quot;&quot;</span>`,wrap:!1}}),va=new v({props:{code:"bG9uZ19wcm9tcHQlMjAlM0QlMjAxMCUyMColMjBzeXN0ZW1fcHJvbXB0JTIwJTJCJTIwcHJvbXB0",highlighted:'long_prompt = <span class="hljs-number">10</span> * system_prompt + prompt',wrap:!1}}),xa=new v({props:{code:"bW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoJTIyYmlnY29kZSUyRm9jdG9jb2RlciUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guYmZsb2F0MTYlMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMiklMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJiaWdjb2RlJTJGb2N0b2NvZGVyJTIyKSUwQSUwQXBpcGUlMjAlM0QlMjBwaXBlbGluZSglMjJ0ZXh0LWdlbmVyYXRpb24lMjIlMkMlMjBtb2RlbCUzRG1vZGVsJTJDJTIwdG9rZW5pemVyJTNEdG9rZW5pemVyKQ==",highlighted:`model = AutoModelForCausalLM.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>, torch_dtype=torch.bfloat16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;bigcode/octocoder&quot;</span>)

pipe = pipeline(<span class="hljs-string">&quot;text-generation&quot;</span>, model=model, tokenizer=tokenizer)`,wrap:!1}}),Ta=new v({props:{code:"aW1wb3J0JTIwdGltZSUwQSUwQXN0YXJ0X3RpbWUlMjAlM0QlMjB0aW1lLnRpbWUoKSUwQXJlc3VsdCUyMCUzRCUyMHBpcGUobG9uZ19wcm9tcHQlMkMlMjBtYXhfbmV3X3Rva2VucyUzRDYwKSU1QjAlNUQlNUIlMjJnZW5lcmF0ZWRfdGV4dCUyMiU1RCU1Qmxlbihsb25nX3Byb21wdCklM0ElNUQlMEElMEFwcmludChmJTIyR2VuZXJhdGVkJTIwaW4lMjAlN0J0aW1lLnRpbWUoKSUyMC0lMjBzdGFydF90aW1lJTdEJTIwc2Vjb25kcy4lMjIpJTBBcmVzdWx0",highlighted:`<span class="hljs-keyword">import</span> time

start_time = time.time()
result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),_a=new v({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAxMC45Njg1NDAxOTE2NTAzOSUyMHNlY29uZHMuJTBBU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWYlMjBieXRlc190b19naWdhKGJ5dGVzKSUzQSU1Q24lMjAlMjAlMjByZXR1cm4lMjBieXRlcyUyMCUyRiUyMDEwMjQlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCU1Q24lNUNuQW5zd2VyJTNBJTIwU3VyZS4lMjBIZXJlJTIwaXMlMjBhJTIwZnVuY3Rpb24lMjB0aGF0JTIwZG9lcyUyMHRoYXQuJTVDbiU1Q25kZWY=",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">10.96854019165039</span> seconds.
Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),za=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ga=new v({props:{code:"MzcuNjY4MTkzMzQwMzAxNTE0",highlighted:"37.668193340301514",wrap:!1}}),Ia=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),Wa=new v({props:{code:"bW9kZWwudG9fYmV0dGVydHJhbnNmb3JtZXIoKQ==",highlighted:"model.to_bettertransformer()",wrap:!1}}),Qa=new v({props:{code:"c3RhcnRfdGltZSUyMCUzRCUyMHRpbWUudGltZSgpJTBBd2l0aCUyMHRvcmNoLmJhY2tlbmRzLmN1ZGEuc2RwX2tlcm5lbChlbmFibGVfZmxhc2glM0RUcnVlJTJDJTIwZW5hYmxlX21hdGglM0RGYWxzZSUyQyUyMGVuYWJsZV9tZW1fZWZmaWNpZW50JTNERmFsc2UpJTNBJTBBJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwcGlwZShsb25nX3Byb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjApJTVCMCU1RCU1QiUyMmdlbmVyYXRlZF90ZXh0JTIyJTVEJTVCbGVuKGxvbmdfcHJvbXB0KSUzQSU1RCUwQSUwQXByaW50KGYlMjJHZW5lcmF0ZWQlMjBpbiUyMCU3QnRpbWUudGltZSgpJTIwLSUyMHN0YXJ0X3RpbWUlN0QlMjBzZWNvbmRzLiUyMiklMEFyZXN1bHQ=",highlighted:`start_time = time.time()
<span class="hljs-keyword">with</span> torch.backends.cuda.sdp_kernel(enable_flash=<span class="hljs-literal">True</span>, enable_math=<span class="hljs-literal">False</span>, enable_mem_efficient=<span class="hljs-literal">False</span>):
    result = pipe(long_prompt, max_new_tokens=<span class="hljs-number">60</span>)[<span class="hljs-number">0</span>][<span class="hljs-string">&quot;generated_text&quot;</span>][<span class="hljs-built_in">len</span>(long_prompt):]

<span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Generated in <span class="hljs-subst">{time.time() - start_time}</span> seconds.&quot;</span>)
result`,wrap:!1}}),Na=new v({props:{code:"R2VuZXJhdGVkJTIwaW4lMjAzLjAyMTE2MTc5NDY2MjQ3NTYlMjBzZWNvbmRzLiUwQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVmJTIwYnl0ZXNfdG9fZ2lnYShieXRlcyklM0ElNUNuJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUyMCUyRiUyMDEwMjQlNUNuJTVDbkFuc3dlciUzQSUyMFN1cmUuJTIwSGVyZSUyMGlzJTIwYSUyMGZ1bmN0aW9uJTIwdGhhdCUyMGRvZXMlMjB0aGF0LiU1Q24lNUNuZGVm",highlighted:`Generated <span class="hljs-keyword">in</span> <span class="hljs-number">3.0211617946624756</span> seconds.
 Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span> bytes_to_giga(bytes):<span class="hljs-string">\\n</span>   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span><span class="hljs-string">\\n\\nAnswer:</span> Sure. Here <span class="hljs-keyword">is</span> a <span class="hljs-keyword">function</span> <span class="hljs-literal">that</span> does <span class="hljs-literal">that</span>.<span class="hljs-string">\\n\\ndef</span>`,wrap:!1}}),qa=new v({props:{code:"Ynl0ZXNfdG9fZ2lnYV9ieXRlcyh0b3JjaC5jdWRhLm1heF9tZW1vcnlfYWxsb2NhdGVkKCkp",highlighted:"bytes_to_giga_bytes(torch.cuda.max_memory_allocated())",wrap:!1}}),Ea=new v({props:{code:"MzIuNjE3MzMxOTgxNjU4OTM2",highlighted:'<span class="hljs-attribute">32</span>.<span class="hljs-number">617331981658936</span>',wrap:!1}}),Fa=new v({props:{code:"Zmx1c2goKQ==",highlighted:"flush()",wrap:!1}}),je=new v({props:{code:"aW5wdXRfaWRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJTIycHQlMjIpJTVCJTIyaW5wdXRfaWRzJTIyJTVELnRvKCUyMmN1ZGElMjIpJTBBJTBBZm9yJTIwXyUyMGluJTIwcmFuZ2UoNSklM0ElMEElMjAlMjBuZXh0X2xvZ2l0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyklNUIlMjJsb2dpdHMlMjIlNUQlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkNkaW0lM0QtMSklMEElMEElMjAlMjBpbnB1dF9pZHMlMjAlM0QlMjB0b3JjaC5jYXQoJTVCaW5wdXRfaWRzJTJDJTIwbmV4dF90b2tlbl9pZCU1RCUyQyUyMGRpbSUzRC0xKSUwQSUyMCUyMHByaW50KCUyMnNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjIlMkMlMjBpbnB1dF9pZHMuc2hhcGUpJTBBJTBBZ2VuZXJhdGVkX3RleHQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGlucHV0X2lkcyU1QiUzQSUyQyUyMC01JTNBJTVEKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`input_ids = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits = model(input_ids)[<span class="hljs-string">&quot;logits&quot;</span>][:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits,dim=-<span class="hljs-number">1</span>)

  input_ids = torch.cat([input_ids, next_token_id], dim=-<span class="hljs-number">1</span>)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, input_ids.shape)

generated_text = tokenizer.batch_decode(input_ids[:, -<span class="hljs-number">5</span>:])
generated_text`,wrap:!1}}),Je=new v({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDIxJTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyMiU1RCklMEFzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIwdG9yY2guU2l6ZSglNUIxJTJDJTIwMjMlNUQpJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDI0JTVEKSUwQXNoYXBlJTIwb2YlMjBpbnB1dF9pZHMlMjB0b3JjaC5TaXplKCU1QjElMkMlMjAyNSU1RCklMEElNUInJTIwSGVyZSUyMGlzJTIwYSUyMFB5dGhvbiUyMGZ1bmN0aW9uJyU1RA==",highlighted:`shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 21]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 22]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 23]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 24]</span>)
shape of input_ids torch<span class="hljs-selector-class">.Size</span>(<span class="hljs-selector-attr">[1, 25]</span>)
<span class="hljs-selector-attr">[<span class="hljs-string">&#x27; Here is a Python function&#x27;</span>]</span>`,wrap:!1}}),Le=new v({props:{code:"cGFzdF9rZXlfdmFsdWVzJTIwJTNEJTIwTm9uZSUyMCUyMyUyMHBhc3Rfa2V5X3ZhbHVlcyUyMGlzJTIwdGhlJTIwa2V5LXZhbHVlJTIwY2FjaGUlMEFnZW5lcmF0ZWRfdG9rZW5zJTIwJTNEJTIwJTVCJTVEJTBBbmV4dF90b2tlbl9pZCUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCUyMnB0JTIyKSU1QiUyMmlucHV0X2lkcyUyMiU1RC50byglMjJjdWRhJTIyKSUwQSUwQWZvciUyMF8lMjBpbiUyMHJhbmdlKDUpJTNBJTBBJTIwJTIwbmV4dF9sb2dpdHMlMkMlMjBwYXN0X2tleV92YWx1ZXMlMjAlM0QlMjBtb2RlbChuZXh0X3Rva2VuX2lkJTJDJTIwcGFzdF9rZXlfdmFsdWVzJTNEcGFzdF9rZXlfdmFsdWVzJTJDJTIwdXNlX2NhY2hlJTNEVHJ1ZSkudG9fdHVwbGUoKSUwQSUyMCUyMG5leHRfbG9naXRzJTIwJTNEJTIwbmV4dF9sb2dpdHMlNUIlM0ElMkMlMjAtMSUzQSU1RCUwQSUyMCUyMG5leHRfdG9rZW5faWQlMjAlM0QlMjB0b3JjaC5hcmdtYXgobmV4dF9sb2dpdHMlMkMlMjBkaW0lM0QtMSklMEElMEElMjAlMjBwcmludCglMjJzaGFwZSUyMG9mJTIwaW5wdXRfaWRzJTIyJTJDJTIwbmV4dF90b2tlbl9pZC5zaGFwZSklMEElMjAlMjBwcmludCglMjJsZW5ndGglMjBvZiUyMGtleS12YWx1ZSUyMGNhY2hlJTIyJTJDJTIwbGVuKHBhc3Rfa2V5X3ZhbHVlcyU1QjAlNUQlNUIwJTVEKSklMjAlMjAlMjMlMjBwYXN0X2tleV92YWx1ZXMlMjBhcmUlMjBvZiUyMHNoYXBlJTIwJTVCbnVtX2xheWVycyUyQyUyMDAlMjBmb3IlMjBrJTJDJTIwMSUyMGZvciUyMHYlMkMlMjBiYXRjaF9zaXplJTJDJTIwbGVuZ3RoJTJDJTIwaGlkZGVuX2RpbSU1RCUwQSUyMCUyMGdlbmVyYXRlZF90b2tlbnMuYXBwZW5kKG5leHRfdG9rZW5faWQuaXRlbSgpKSUwQSUwQWdlbmVyYXRlZF90ZXh0JTIwJTNEJTIwdG9rZW5pemVyLmJhdGNoX2RlY29kZShnZW5lcmF0ZWRfdG9rZW5zKSUwQWdlbmVyYXRlZF90ZXh0",highlighted:`past_key_values = <span class="hljs-literal">None</span> <span class="hljs-comment"># past_key_values is the key-value cache</span>
generated_tokens = []
next_token_id = tokenizer(prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)[<span class="hljs-string">&quot;input_ids&quot;</span>].to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-keyword">for</span> _ <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(<span class="hljs-number">5</span>):
  next_logits, past_key_values = model(next_token_id, past_key_values=past_key_values, use_cache=<span class="hljs-literal">True</span>).to_tuple()
  next_logits = next_logits[:, -<span class="hljs-number">1</span>:]
  next_token_id = torch.argmax(next_logits, dim=-<span class="hljs-number">1</span>)

  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;shape of input_ids&quot;</span>, next_token_id.shape)
  <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;length of key-value cache&quot;</span>, <span class="hljs-built_in">len</span>(past_key_values[<span class="hljs-number">0</span>][<span class="hljs-number">0</span>]))  <span class="hljs-comment"># past_key_values are of shape [num_layers, 0 for k, 1 for v, batch_size, length, hidden_dim]</span>
  generated_tokens.append(next_token_id.item())

generated_text = tokenizer.batch_decode(generated_tokens)
generated_text`,wrap:!1}}),Be=new v({props:{code:"c2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIwJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIxJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIyJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDIzJTBBc2hhcGUlMjBvZiUyMGlucHV0X2lkcyUyMHRvcmNoLlNpemUoJTVCMSUyQyUyMDElNUQpJTBBbGVuZ3RoJTIwb2YlMjBrZXktdmFsdWUlMjBjYWNoZSUyMDI0JTBBJTVCJyUyMEhlcmUnJTJDJTIwJyUyMGlzJyUyQyUyMCclMjBhJyUyQyUyMCclMjBQeXRob24nJTJDJTIwJyUyMGZ1bmN0aW9uJyU1RA==",highlighted:`<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">20</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">21</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">22</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">23</span>
<span class="hljs-attribute">shape</span> of input_ids torch.Size([<span class="hljs-number">1</span>, <span class="hljs-number">1</span>])
<span class="hljs-attribute">length</span> of key-value cache <span class="hljs-number">24</span><span class="hljs-meta">
[&#x27; Here&#x27;, &#x27; is&#x27;, &#x27; a&#x27;, &#x27; Python&#x27;, &#x27; function&#x27;]</span>`,wrap:!1}}),vs=new tb({props:{warning:!0,$$slots:{default:[nb]},$$scope:{ctx:hl}}}),Xe=new v({props:{code:"VXNlciUzQSUyMEhvdyUyMG1hbnklMjBwZW9wbGUlMjBsaXZlJTIwaW4lMjBGcmFuY2UlM0YlMEFBc3Npc3RhbnQlM0ElMjBSb3VnaGx5JTIwNzUlMjBtaWxsaW9uJTIwcGVvcGxlJTIwbGl2ZSUyMGluJTIwRnJhbmNlJTBBVXNlciUzQSUyMEFuZCUyMGhvdyUyMG1hbnklMjBhcmUlMjBpbiUyMEdlcm1hbnklM0YlMEFBc3Npc3RhbnQlM0ElMjBHZXJtYW55JTIwaGFzJTIwY2EuJTIwODElMjBtaWxsaW9uJTIwaW5oYWJpdGFudHM=",highlighted:`<span class="hljs-symbol">User:</span> How many people live <span class="hljs-keyword">in</span> France?
<span class="hljs-symbol">Assistant:</span> Roughly <span class="hljs-number">75</span> million people live <span class="hljs-keyword">in</span> France
<span class="hljs-symbol">User:</span> <span class="hljs-keyword">And</span> how many are <span class="hljs-keyword">in</span> Germany?
<span class="hljs-symbol">Assistant:</span> Germany has ca. <span class="hljs-number">81</span> million inhabitants`,wrap:!1}}),Ee=new v({props:{code:"JTIzJTIwR2VuZXJhdGlvbiUyMGFzJTIwdXN1YWwlMEFwcm9tcHQlMjAlM0QlMjBzeXN0ZW1fcHJvbXB0JTIwJTJCJTIwJTIyUXVlc3Rpb24lM0ElMjBQbGVhc2UlMjB3cml0ZSUyMGElMjBmdW5jdGlvbiUyMGluJTIwUHl0aG9uJTIwdGhhdCUyMHRyYW5zZm9ybXMlMjBieXRlcyUyMHRvJTIwR2lnYSUyMGJ5dGVzLiU1Q24lNUNuQW5zd2VyJTNBJTIwSGVyZSUyMiUwQW1vZGVsX2lucHV0cyUyMCUzRCUyMHRva2VuaXplcihwcm9tcHQlMkMlMjByZXR1cm5fdGVuc29ycyUzRCdwdCcpJTBBZ2VuZXJhdGlvbl9vdXRwdXQlMjAlM0QlMjBtb2RlbC5nZW5lcmF0ZSgqKm1vZGVsX2lucHV0cyUyQyUyMG1heF9uZXdfdG9rZW5zJTNENjAlMkMlMjByZXR1cm5fZGljdF9pbl9nZW5lcmF0ZSUzRFRydWUpJTBBZGVjb2RlZF9vdXRwdXQlMjAlM0QlMjB0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRpb25fb3V0cHV0LnNlcXVlbmNlcyklNUIwJTVEJTBBJTBBJTIzJTIwUGlwaW5nJTIwdGhlJTIwcmV0dXJuZWQlMjAlNjBwYXN0X2tleV92YWx1ZXMlNjAlMjB0byUyMHNwZWVkJTIwdXAlMjB0aGUlMjBuZXh0JTIwY29udmVyc2F0aW9uJTIwcm91bmQlMEFwcm9tcHQlMjAlM0QlMjBkZWNvZGVkX291dHB1dCUyMCUyQiUyMCUyMiU1Q25RdWVzdGlvbiUzQSUyMEhvdyUyMGNhbiUyMEklMjBtb2RpZnklMjB0aGUlMjBmdW5jdGlvbiUyMGFib3ZlJTIwdG8lMjByZXR1cm4lMjBNZWdhJTIwYnl0ZXMlMjBpbnN0ZWFkJTNGJTVDbiU1Q25BbnN3ZXIlM0ElMjBIZXJlJTIyJTBBbW9kZWxfaW5wdXRzJTIwJTNEJTIwdG9rZW5pemVyKHByb21wdCUyQyUyMHJldHVybl90ZW5zb3JzJTNEJ3B0JyklMEFnZW5lcmF0aW9uX291dHB1dCUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCUwQSUyMCUyMCoqbW9kZWxfaW5wdXRzJTJDJTBBJTIwJTIwcGFzdF9rZXlfdmFsdWVzJTNEZ2VuZXJhdGlvbl9vdXRwdXQucGFzdF9rZXlfdmFsdWVzJTJDJTBBJTIwJTIwbWF4X25ld190b2tlbnMlM0Q2MCUyQyUwQSUyMCUyMHJldHVybl9kaWN0X2luX2dlbmVyYXRlJTNEVHJ1ZSUwQSklMEF0b2tlbml6ZXIuYmF0Y2hfZGVjb2RlKGdlbmVyYXRpb25fb3V0cHV0LnNlcXVlbmNlcyklNUIwJTVEJTVCbGVuKHByb21wdCklM0ElNUQ=",highlighted:`<span class="hljs-comment"># Generation as usual</span>
prompt = system_prompt + <span class="hljs-string">&quot;Question: Please write a function in Python that transforms bytes to Giga bytes.\\n\\nAnswer: Here&quot;</span>
model_inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
generation_output = model.generate(**model_inputs, max_new_tokens=<span class="hljs-number">60</span>, return_dict_in_generate=<span class="hljs-literal">True</span>)
decoded_output = tokenizer.batch_decode(generation_output.sequences)[<span class="hljs-number">0</span>]

<span class="hljs-comment"># Piping the returned \`past_key_values\` to speed up the next conversation round</span>
prompt = decoded_output + <span class="hljs-string">&quot;\\nQuestion: How can I modify the function above to return Mega bytes instead?\\n\\nAnswer: Here&quot;</span>
model_inputs = tokenizer(prompt, return_tensors=<span class="hljs-string">&#x27;pt&#x27;</span>)
generation_output = model.generate(
  **model_inputs,
  past_key_values=generation_output.past_key_values,
  max_new_tokens=<span class="hljs-number">60</span>,
  return_dict_in_generate=<span class="hljs-literal">True</span>
)
tokenizer.batch_decode(generation_output.sequences)[<span class="hljs-number">0</span>][<span class="hljs-built_in">len</span>(prompt):]`,wrap:!1}}),Se=new v({props:{code:"JTIwaXMlMjBhJTIwbW9kaWZpZWQlMjB2ZXJzaW9uJTIwb2YlMjB0aGUlMjBmdW5jdGlvbiUyMHRoYXQlMjByZXR1cm5zJTIwTWVnYSUyMGJ5dGVzJTIwaW5zdGVhZC4lMEElMEFkZWYlMjBieXRlc190b19tZWdhYnl0ZXMoYnl0ZXMpJTNBJTBBJTIwJTIwJTIwcmV0dXJuJTIwYnl0ZXMlMjAlMkYlMjAxMDI0JTIwJTJGJTIwMTAyNCUwQSUwQUFuc3dlciUzQSUyMFRoZSUyMGZ1bmN0aW9uJTIwdGFrZXMlMjBhJTIwbnVtYmVyJTIwb2YlMjBieXRlcyUyMGFzJTIwaW5wdXQlMjBhbmQlMjByZXR1cm5zJTIwdGhlJTIwbnVtYmVyJTIwb2Y=",highlighted:` <span class="hljs-keyword">is</span> a modified <span class="hljs-keyword">version</span> <span class="hljs-keyword">of</span> the <span class="hljs-keyword">function</span> that <span class="hljs-keyword">returns</span> Mega bytes <span class="hljs-keyword">instead</span>.

def bytes_to_megabytes(bytes):
   <span class="hljs-keyword">return</span> bytes / <span class="hljs-number">1024</span> / <span class="hljs-number">1024</span>

Answer: The <span class="hljs-keyword">function</span> takes a number <span class="hljs-keyword">of</span> bytes <span class="hljs-keyword">as</span> <span class="hljs-keyword">input</span> <span class="hljs-keyword">and</span> <span class="hljs-keyword">returns</span> the number <span class="hljs-keyword">of</span>`,wrap:!1}}),Pe=new v({props:{code:"Y29uZmlnJTIwJTNEJTIwbW9kZWwuY29uZmlnJTBBMiUyMColMjAxNl8wMDAlMjAqJTIwY29uZmlnLm5fbGF5ZXIlMjAqJTIwY29uZmlnLm5faGVhZCUyMColMjBjb25maWcubl9lbWJkJTIwJTJGJTJGJTIwY29uZmlnLm5faGVhZA==",highlighted:`config = model.config
<span class="hljs-number">2</span> * <span class="hljs-number">16_000</span> * config.n_layer * config.n_head * config.n_embd // config.n_head`,wrap:!1}}),De=new v({props:{code:"Nzg2NDMyMDAwMA==",highlighted:'<span class="hljs-number">7864320000</span>',wrap:!1}}),cn=new Cc({props:{title:"Conclusion",local:"conclusion",headingTag:"h2"}}),gn=new eb({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/llm_tutorial_optimization.md"}}),{c(){G=i("meta"),Us=n(),P=i("p"),yn=n(),d(Cs.$$.fragment),cl=n(),d(zs.$$.fragment),ul=n(),Ls=i("p"),Ls.innerHTML=Fu,dl=n(),Gs=i("ul"),Gs.innerHTML=Pu,gl=n(),Bs=i("p"),Bs.textContent=Ku,yl=n(),Zs=i("p"),Zs.textContent=Du,fl=n(),Is=i("ol"),Is.innerHTML=Ou,wl=n(),$s=i("p"),$s.textContent=sd,bl=n(),d(Ws.$$.fragment),vl=n(),Hs=i("p"),Hs.innerHTML=td,Ml=n(),Qs=i("p"),Qs.innerHTML=ad,xl=n(),Xs=i("blockquote"),Xs.innerHTML=ed,kl=n(),Ns=i("p"),Ns.textContent=nd,Tl=n(),Rs=i("blockquote"),Rs.innerHTML=ld,jl=n(),Vs=i("p"),Vs.textContent=id,_l=n(),qs=i("p"),qs.textContent=pd,Jl=n(),As=i("ul"),As.innerHTML=md,Ul=n(),Es=i("p"),Es.innerHTML=od,Cl=n(),Ys=i("p"),Ys.innerHTML=rd,zl=n(),Ss=i("p"),Ss.innerHTML=hd,Ll=n(),Fs=i("p"),Fs.textContent=cd,Gl=n(),d(Ps.$$.fragment),Bl=n(),d(Ks.$$.fragment),Zl=n(),Ds=i("p"),Ds.innerHTML=ud,Il=n(),Os=i("p"),Os.innerHTML=dd,$l=n(),st=i("p"),st.innerHTML=gd,Wl=n(),tt=i("p"),tt.innerHTML=yd,Hl=n(),d(at.$$.fragment),Ql=n(),d(et.$$.fragment),Xl=n(),nt=i("p"),nt.innerHTML=fd,Nl=n(),d(lt.$$.fragment),Rl=n(),it=i("p"),it.textContent=wd,Vl=n(),d(pt.$$.fragment),ql=n(),mt=i("p"),mt.innerHTML=bd,Al=n(),d(ot.$$.fragment),El=n(),rt=i("p"),rt.innerHTML=vd,Yl=n(),d(ht.$$.fragment),Sl=n(),ct=i("p"),ct.textContent=Md,Fl=n(),ut=i("blockquote"),ut.innerHTML=xd,Pl=n(),dt=i("p"),dt.innerHTML=kd,Kl=n(),gt=i("p"),gt.innerHTML=Td,Dl=n(),d(yt.$$.fragment),Ol=n(),ft=i("p"),ft.textContent=jd,si=n(),d(wt.$$.fragment),ti=n(),bt=i("p"),bt.innerHTML=_d,ai=n(),d(vt.$$.fragment),ei=n(),Mt=i("p"),Mt.innerHTML=Jd,ni=n(),xt=i("p"),xt.innerHTML=Ud,li=n(),kt=i("p"),kt.textContent=Cd,ii=n(),Tt=i("ul"),Tt.innerHTML=zd,pi=n(),B=i("p"),zc=r("In a nutshell, this means that "),fn=i("em"),fn.textContent=Ld,Lc=r(" multiplications, with"),mi=new c(!1),oi=r(" being the "),wn=i("em"),wn.textContent=Gd,Gc=r(","),ri=new c(!1),hi=r(" being a weight matrix and"),ci=new c(!1),ui=r(` being the output:
`),di=new c(!1),gi=n(),jt=i("p"),Bc=r(`are changed to
`),yi=new c(!1),fi=n(),_t=i("p"),_t.textContent=Bd,wi=n(),Jt=i("p"),Jt.innerHTML=Zd,bi=n(),d(Ut.$$.fragment),vi=n(),Ct=i("p"),Ct.innerHTML=Id,Mi=n(),d(zt.$$.fragment),xi=n(),Lt=i("p"),Lt.textContent=$d,ki=n(),d(Gt.$$.fragment),Ti=n(),Bt=i("p"),Bt.innerHTML=Wd,ji=n(),d(Zt.$$.fragment),_i=n(),It=i("p"),It.textContent=Hd,Ji=n(),d($t.$$.fragment),Ui=n(),Wt=i("p"),Wt.innerHTML=Qd,Ci=n(),d(Ht.$$.fragment),zi=n(),Qt=i("p"),Qt.textContent=Xd,Li=n(),Xt=i("p"),Xt.textContent=Nd,Gi=n(),d(Nt.$$.fragment),Bi=n(),d(Rt.$$.fragment),Zi=n(),Vt=i("p"),Vt.innerHTML=Rd,Ii=n(),d(qt.$$.fragment),$i=n(),At=i("p"),At.innerHTML=Vd,Wi=n(),d(Et.$$.fragment),Hi=n(),Yt=i("p"),Yt.innerHTML=qd,Qi=n(),d(St.$$.fragment),Xi=n(),Ft=i("p"),Ft.innerHTML=Ad,Ni=n(),d(Pt.$$.fragment),Ri=n(),Kt=i("p"),Kt.textContent=Ed,Vi=n(),Dt=i("p"),Dt.innerHTML=Yd,qi=n(),K=i("p"),Zc=r("Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to"),Ai=new c(!1),Ei=r(" and"),Yi=new c(!1),Si=r(" taking longer during inference."),Fi=n(),d(Ot.$$.fragment),Pi=n(),d(sa.$$.fragment),Ki=n(),ta=i("p"),ta.textContent=Sd,Di=n(),aa=i("p"),aa.textContent=Fd,Oi=n(),ea=i("p"),ea.innerHTML=Pd,sp=n(),na=i("blockquote"),na.innerHTML=Kd,tp=n(),la=i("p"),la.textContent=Dd,ap=n(),ia=i("p"),ia.innerHTML=Od,ep=n(),d(pa.$$.fragment),np=n(),ma=i("p"),ma.textContent=sg,lp=n(),q=i("p"),Ic=r(`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),bn=i("em"),bn.textContent=tg,$c=r(" both in compute and memory complexity with number of input tokens (also called "),vn=i("em"),vn.textContent=ag,Wc=r(") that we denote in the following by"),ip=new c(!1),pp=r(` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),mp=n(),T=i("p"),Hc=r("Let’s take a closer look. The formula to compute the output"),op=new c(!1),rp=r(" of a self-attention layer for an input"),hp=new c(!1),cp=r(" of length"),up=new c(!1),dp=r(` is:
`),gp=new c(!1),yp=n(),fp=new c(!1),wp=r(" is thereby the input sequence to the attention layer. The projections"),bp=new c(!1),vp=r(" and"),Mp=new c(!1),xp=r(" will each consist of"),kp=new c(!1),Tp=r(" vectors resulting in the"),jp=new c(!1),_p=r(" being of size"),Jp=new c(!1),Up=r(" ."),Cp=n(),U=i("p"),Qc=r(`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the`),zp=new c(!1),Lp=r(" matrices to be"),Gp=new c(!1),Bp=r(" bytes. For"),Zp=new c(!1),Ip=r(" only around 50 MB of VRAM are needed, however, for"),$p=new c(!1),Wp=r(" we would need 19 GB of VRAM, and for"),Hp=new c(!1),Qp=r(" we would need almost 1TB just to store the"),Xp=new c(!1),Np=r(" matrices."),Rp=n(),oa=i("p"),oa.textContent=eg,Vp=n(),ra=i("p"),ra.textContent=ng,qp=n(),A=i("p"),Xc=r("How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the"),Ap=new c(!1),Ep=r(" matrix. "),rs=i("a"),rs.textContent=lg,Nc=r(" developed exactly such a new algorithm and called it "),Mn=i("strong"),Mn.textContent=ig,Rc=r("."),Yp=n(),is=i("p"),Vc=r("In a nutshell, Flash Attention breaks the "),Sp=new c(!1),Fp=r(`) computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:
`),Pp=new c(!1),Kp=n(),W=i("p"),qc=r("with"),Dp=new c(!1),Op=r(" and"),sm=new c(!1),tm=r(" being some softmax normalization statistics that need to be recomputed for every"),am=new c(!1),em=r(" and"),nm=new c(!1),lm=r(" ."),im=n(),ha=i("p"),ha.innerHTML=pg,pm=n(),ca=i("p"),ca.textContent=mg,mm=n(),xn=i("blockquote"),ps=i("p"),Ac=r("By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),kn=i("strong"),kn.textContent=og,Ec=r(" outputs compared to the default self-attention layer at a memory cost that only increases linearly with"),om=new c(!1),rm=r(" ."),hm=n(),ua=i("p"),ua.innerHTML=rg,cm=n(),da=i("blockquote"),da.innerHTML=hg,um=n(),D=i("p"),Yc=r("Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),Tn=i("em"),Tn.textContent=cg,Sc=r(" SRAM memory instead of having to access the slower VRAM memory to compute the output vector"),dm=new c(!1),gm=r(" ."),ym=n(),ga=i("p"),ga.innerHTML=ug,fm=n(),ya=i("p"),ya.textContent=dg,wm=n(),fa=i("p"),fa.innerHTML=gg,bm=n(),d(wa.$$.fragment),vm=n(),ba=i("p"),ba.innerHTML=yg,Mm=n(),d(va.$$.fragment),xm=n(),Ma=i("p"),Ma.textContent=fg,km=n(),d(xa.$$.fragment),Tm=n(),ka=i("p"),ka.innerHTML=wg,jm=n(),d(Ta.$$.fragment),_m=n(),ja=i("p"),ja.innerHTML=bg,Jm=n(),d(_a.$$.fragment),Um=n(),Ja=i("p"),Ja.textContent=vg,Cm=n(),Ua=i("p"),Ua.innerHTML=Mg,zm=n(),Ca=i("p"),Ca.textContent=xg,Lm=n(),d(za.$$.fragment),Gm=n(),La=i("p"),La.innerHTML=kg,Bm=n(),d(Ga.$$.fragment),Zm=n(),Ba=i("p"),Ba.textContent=Tg,Im=n(),Za=i("p"),Za.innerHTML=jg,$m=n(),d(Ia.$$.fragment),Wm=n(),$a=i("p"),$a.innerHTML=_g,Hm=n(),d(Wa.$$.fragment),Qm=n(),Ha=i("p"),Ha.textContent=Jg,Xm=n(),d(Qa.$$.fragment),Nm=n(),Xa=i("p"),Xa.innerHTML=Ug,Rm=n(),d(Na.$$.fragment),Vm=n(),Ra=i("p"),Ra.textContent=Cg,qm=n(),Va=i("p"),Va.textContent=zg,Am=n(),d(qa.$$.fragment),Em=n(),Aa=i("p"),Aa.innerHTML=Lg,Ym=n(),d(Ea.$$.fragment),Sm=n(),Ya=i("p"),Ya.textContent=Gg,Fm=n(),Sa=i("p"),Sa.textContent=Bg,Pm=n(),d(Fa.$$.fragment),Km=n(),Pa=i("p"),Pa.innerHTML=Zg,Dm=n(),Ka=i("p"),Ka.textContent=Ig,Om=n(),Da=i("p"),Da.textContent=$g,so=n(),Oa=i("ul"),Oa.innerHTML=Wg,to=n(),se=i("p"),se.innerHTML=Hg,ao=n(),te=i("ul"),te.innerHTML=Qg,eo=n(),ae=i("p"),ae.innerHTML=Xg,no=n(),ee=i("p"),ee.textContent=Ng,lo=n(),ne=i("ul"),ne.innerHTML=Rg,io=n(),le=i("p"),le.textContent=Vg,po=n(),ie=i("p"),ie.textContent=qg,mo=n(),O=i("p"),Fc=r(`Self-attention puts each token in relation to each other’s tokens.
As an example, the`),oo=new c(!1),ro=r(" matrix of the text input sequence "),jn=i("em"),jn.textContent=Ag,Pc=r(" could look as follows:"),ho=n(),pe=i("p"),pe.innerHTML=Eg,co=n(),me=i("p"),me.innerHTML=Yg,uo=n(),I=i("p"),Kc=r(`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by`),go=new c(!1),yo=r(" relates each word token to each other word token in"),fo=new c(!1),wo=r(` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),_n=i("em"),_n.textContent=Sg,Dc=r(" differentiating between "),Jn=i("em"),Jn.textContent=Fg,Oc=r(" and "),Un=i("em"),Un.textContent=Pg,su=r(" would be very challenging."),bo=n(),oe=i("p"),oe.innerHTML=Kg,vo=n(),C=i("p"),tu=r("The authors of the "),hs=i("a"),hs.innerHTML=Dg,au=r(" paper introduced sinusoidal positional embeddings"),Mo=new c(!1),xo=r(` .
where each vector`),ko=new c(!1),To=r(" is computed as a sinusoidal function of its position"),jo=new c(!1),_o=r(` .
The positional encodings are then simply added to the input sequence vectors`),Jo=new c(!1),Uo=r(" ="),Co=new c(!1),zo=r(" thereby cueing the model to better learn sentence order."),Lo=n(),ss=i("p"),eu=r("Instead of using fixed position embeddings, others (such as "),cs=i("a"),cs.textContent=Og,nu=r(") used learned positional encodings for which the positional embeddings"),Go=new c(!1),Bo=r(" are learned during training."),Zo=n(),re=i("p"),re.textContent=sy,Io=n(),us=i("ol"),R=i("li"),lu=r("Sinusoidal and learned position embeddings are both absolute positional embeddings, "),Cn=i("em"),Cn.textContent=ty,iu=r(" encoding a unique embedding for each position id:"),$o=new c(!1),Wo=r(" . As shown by "),ds=i("a"),ds.textContent=ay,pu=r(" and "),gs=i("a"),gs.textContent=ey,mu=r(", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),ou=n(),he=i("li"),ru=r("When using learned position embeddings, the LLM has to be trained on a fixed input length"),Ho=new c(!1),Qo=r(", which makes it difficult to extrapolate to an input length longer than what it was trained on."),Xo=n(),ce=i("p"),ce.textContent=ny,No=n(),ue=i("ul"),ue.innerHTML=ly,Ro=n(),E=i("p"),hu=r("Both "),zn=i("em"),zn.textContent=iy,cu=r(" and "),Ln=i("em"),Ln.textContent=py,uu=r(" argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the"),Vo=new c(!1),qo=r(" computation."),Ao=n(),k=i("p"),du=r("Without going into too many details, "),Gn=i("em"),Gn.textContent=my,gu=r(" notes that positional information can be encoded into query-key pairs, "),Bn=i("em"),Bn.textContent=oy,Eo=new c(!1),Yo=r(" and"),So=new c(!1),Fo=r(" by rotating each vector by an angle"),Po=new c(!1),Ko=r(" and"),Do=new c(!1),Oo=r(" respectively with"),sr=new c(!1),tr=r(` describing each vectors sentence position:
`),ar=new c(!1),er=n(),nr=new c(!1),lr=r(" thereby represents a rotational matrix."),ir=new c(!1),pr=r(" is "),Zn=i("em"),Zn.textContent=ry,yu=r(" learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),mr=n(),In=i("blockquote"),Z=i("p"),fu=r("By doing so, the propability score between"),or=new c(!1),rr=r(" and"),hr=new c(!1),cr=r(" is only affected if"),ur=new c(!1),dr=r(" and solely depends on the relative distance"),gr=new c(!1),yr=r(" regardless of each vector’s specific positions"),fr=new c(!1),wr=r(" and"),br=new c(!1),vr=r(" ."),Mr=n(),de=i("p"),de.innerHTML=hy,xr=n(),ge=i("ul"),ge.innerHTML=cy,kr=n(),Y=i("p"),wu=r("As an alternative, "),$n=i("em"),$n.textContent=uy,bu=r(" proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Wn=i("code"),Wn.textContent=dy,vu=r(" to each query-key entry of the"),Tr=new c(!1),jr=r(" matrix right before the softmax computation."),_r=n(),ye=i("p"),ye.innerHTML=gy,Jr=n(),fe=i("p"),fe.innerHTML=yy,Ur=n(),we=i("p"),we.innerHTML=fy,Cr=n(),be=i("ul"),be.innerHTML=wy,zr=n(),x=i("p"),Mu=r("Both "),Hn=i("em"),Hn.textContent=by,xu=r(" and "),Qn=i("em"),Qn.textContent=vy,ku=r(" position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),Xn=i("em"),Xn.textContent=My,Tu=r(" as compared to "),Nn=i("em"),Nn.textContent=xy,ju=r(`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),Rn=i("em"),Rn.textContent=ky,_u=r(", keeping the same"),Lr=new c(!1),Gr=r(" that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),Vn=i("em"),Vn.textContent=Ty,Ju=n(),ys=i("a"),ys.textContent=jy,Uu=r(". However, the community has found a couple of effective tricks that adapt"),Br=new c(!1),Zr=r(", thereby allowing "),qn=i("em"),qn.textContent=_y,Cu=r(" position embeddings to work well for extrapolated text input sequences (see "),fs=i("a"),fs.textContent=Jy,zu=r(")."),Ir=n(),ws=i("blockquote"),An=i("p"),An.innerHTML=Uy,Lu=n(),ms=i("ul"),ve=i("li"),Gu=r("Positional cues about the text inputs should be given directly to the"),$r=new c(!1),Wr=r(" matrix of the self-attention layer"),Bu=n(),En=i("li"),En.innerHTML=Cy,Zu=n(),Yn=i("li"),Yn.textContent=zy,Hr=n(),S=i("p"),Iu=r("In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say"),Qr=new c(!1),Xr=r(" it can still be used in practice with text inputs much larger than"),Nr=new c(!1),Rr=r(", like"),Vr=new c(!1),qr=r(" by extrapolating the positional embeddings."),Ar=n(),Me=i("p"),Me.textContent=Ly,Er=n(),xe=i("p"),xe.textContent=Gy,Yr=n(),ke=i("p"),ke.innerHTML=By,Sr=n(),Te=i("p"),Te.innerHTML=Zy,Fr=n(),d(je.$$.fragment),Pr=n(),_e=i("p"),_e.innerHTML=Iy,Kr=n(),d(Je.$$.fragment),Dr=n(),Ue=i("p"),Ue.textContent=$y,Or=n(),Ce=i("p"),Ce.innerHTML=Wy,sh=n(),z=i("p"),$u=r("As a consequence, tokens "),Sn=i("em"),Sn.textContent=Hy,Wu=r(" depend on previous tokens, more specifically the"),th=new c(!1),ah=r(" vector is never put in relation with any key, values vectors"),eh=new c(!1),nh=r(" if"),lh=new c(!1),ih=r(" . Instead"),ph=new c(!1),mh=r(" only attends to previous key-value vectors"),oh=new c(!1),rh=r(". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),hh=n(),ze=i("p"),ze.innerHTML=Qy,ch=n(),d(Le.$$.fragment),uh=n(),Ge=i("p"),Ge.innerHTML=Xy,dh=n(),d(Be.$$.fragment),gh=n(),Ze=i("p"),Ze.innerHTML=Ny,yh=n(),Fn=i("blockquote"),V=i("p"),Hu=r("Making use of the key-value cache means that the"),fh=new c(!1),wh=r(" is essentially reduced to"),bh=new c(!1),vh=r(" with"),Mh=new c(!1),xh=r(" being the query projection of the currently passed input token which is "),Pn=i("em"),Pn.textContent=Ry,Qu=r(" just a single vector."),kh=n(),Ie=i("p"),Ie.textContent=Vy,Th=n(),bs=i("ul"),$e=i("li"),Xu=r("Significant increase in computational efficiency as less computations are performed compared to computing the full"),jh=new c(!1),_h=r(" matrix. This leads to an increase in inference speed"),Nu=n(),Kn=i("li"),Kn.textContent=qy,Jh=n(),We=i("blockquote"),We.innerHTML=Ay,Uh=n(),d(vs.$$.fragment),Ch=n(),He=i("p"),He.textContent=Ey,zh=n(),Qe=i("p"),Qe.textContent=Yy,Lh=n(),d(Xe.$$.fragment),Gh=n(),Ne=i("p"),Ne.textContent=Sy,Bh=n(),Re=i("ol"),Re.innerHTML=Fy,Zh=n(),Ve=i("p"),Ve.textContent=Py,Ih=n(),qe=i("ol"),qe.innerHTML=Ky,$h=n(),Ae=i("p"),Ae.innerHTML=Dy,Wh=n(),d(Ee.$$.fragment),Hh=n(),Ye=i("p"),Ye.innerHTML=Oy,Qh=n(),d(Se.$$.fragment),Xh=n(),ts=i("p"),Ru=r("Great, no additional time is spent recomputing the same key and values for the attention layer! There is however one catch. While the required peak memory for the"),Nh=new c(!1),Rh=r(" matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors"),Vh=new c(!1),qh=r(" for all self-attention layers and for all attention heads."),Ah=n(),Fe=i("p"),Fe.innerHTML=sf,Eh=n(),d(Pe.$$.fragment),Yh=n(),Ke=i("p"),Ke.innerHTML=tf,Sh=n(),d(De.$$.fragment),Fh=n(),Oe=i("p"),Oe.innerHTML=af,Ph=n(),sn=i("p"),sn.textContent=ef,Kh=n(),tn=i("p"),tn.innerHTML=nf,Dh=n(),Dn=i("blockquote"),os=i("p"),Vu=r("By using a single head-value projection weight pair, the key value vectors"),Oh=new c(!1),sc=r(" have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),On=i("code"),On.textContent=lf,qu=r(" ones."),tc=n(),an=i("p"),an.textContent=pf,ac=n(),as=i("p"),Au=r(`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the`),ec=new c(!1),nc=r(" computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),Ms=i("a"),Ms.textContent=mf,Eu=r("."),lc=n(),xs=i("p"),Yu=r("The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different"),ic=new c(!1),pc=r(" matrix."),mc=n(),en=i("p"),en.textContent=of,oc=n(),nn=i("ul"),nn.innerHTML=rf,rc=n(),ln=i("p"),ln.innerHTML=hf,hc=n(),pn=i("p"),pn.textContent=cf,cc=n(),mn=i("p"),mn.innerHTML=uf,uc=n(),on=i("p"),on.innerHTML=df,dc=n(),rn=i("p"),rn.innerHTML=gf,gc=n(),hn=i("blockquote"),hn.innerHTML=yf,yc=n(),d(cn.$$.fragment),fc=n(),un=i("p"),un.innerHTML=ff,wc=n(),dn=i("p"),dn.innerHTML=wf,bc=n(),d(gn.$$.fragment),vc=n(),ol=i("p"),this.h()},l(s){const t=sb("svelte-u9bgzb",document.head);G=p(t,"META",{name:!0,content:!0}),t.forEach(a),Us=l(s),P=p(s,"P",{}),M(P).forEach(a),yn=l(s),g(Cs.$$.fragment,s),cl=l(s),g(zs.$$.fragment,s),ul=l(s),Ls=p(s,"P",{"data-svelte-h":!0}),o(Ls)!=="svelte-1b2qao5"&&(Ls.innerHTML=Fu),dl=l(s),Gs=p(s,"UL",{"data-svelte-h":!0}),o(Gs)!=="svelte-xknchk"&&(Gs.innerHTML=Pu),gl=l(s),Bs=p(s,"P",{"data-svelte-h":!0}),o(Bs)!=="svelte-1cl588t"&&(Bs.textContent=Ku),yl=l(s),Zs=p(s,"P",{"data-svelte-h":!0}),o(Zs)!=="svelte-f1zoss"&&(Zs.textContent=Du),fl=l(s),Is=p(s,"OL",{"data-svelte-h":!0}),o(Is)!=="svelte-yc0h5e"&&(Is.innerHTML=Ou),wl=l(s),$s=p(s,"P",{"data-svelte-h":!0}),o($s)!=="svelte-ihy2a8"&&($s.textContent=sd),bl=l(s),g(Ws.$$.fragment,s),vl=l(s),Hs=p(s,"P",{"data-svelte-h":!0}),o(Hs)!=="svelte-qqgdso"&&(Hs.innerHTML=td),Ml=l(s),Qs=p(s,"P",{"data-svelte-h":!0}),o(Qs)!=="svelte-ljb3iz"&&(Qs.innerHTML=ad),xl=l(s),Xs=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Xs)!=="svelte-4jkxwr"&&(Xs.innerHTML=ed),kl=l(s),Ns=p(s,"P",{"data-svelte-h":!0}),o(Ns)!=="svelte-i58rjm"&&(Ns.textContent=nd),Tl=l(s),Rs=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(Rs)!=="svelte-z4szg9"&&(Rs.innerHTML=ld),jl=l(s),Vs=p(s,"P",{"data-svelte-h":!0}),o(Vs)!=="svelte-28orre"&&(Vs.textContent=id),_l=l(s),qs=p(s,"P",{"data-svelte-h":!0}),o(qs)!=="svelte-1jmd8j1"&&(qs.textContent=pd),Jl=l(s),As=p(s,"UL",{"data-svelte-h":!0}),o(As)!=="svelte-1th1pdf"&&(As.innerHTML=md),Ul=l(s),Es=p(s,"P",{"data-svelte-h":!0}),o(Es)!=="svelte-28fp1w"&&(Es.innerHTML=od),Cl=l(s),Ys=p(s,"P",{"data-svelte-h":!0}),o(Ys)!=="svelte-189eose"&&(Ys.innerHTML=rd),zl=l(s),Ss=p(s,"P",{"data-svelte-h":!0}),o(Ss)!=="svelte-6j2ucx"&&(Ss.innerHTML=hd),Ll=l(s),Fs=p(s,"P",{"data-svelte-h":!0}),o(Fs)!=="svelte-g7zrz4"&&(Fs.textContent=cd),Gl=l(s),g(Ps.$$.fragment,s),Bl=l(s),g(Ks.$$.fragment,s),Zl=l(s),Ds=p(s,"P",{"data-svelte-h":!0}),o(Ds)!=="svelte-z9gs9x"&&(Ds.innerHTML=ud),Il=l(s),Os=p(s,"P",{"data-svelte-h":!0}),o(Os)!=="svelte-19462o4"&&(Os.innerHTML=dd),$l=l(s),st=p(s,"P",{"data-svelte-h":!0}),o(st)!=="svelte-ppeb89"&&(st.innerHTML=gd),Wl=l(s),tt=p(s,"P",{"data-svelte-h":!0}),o(tt)!=="svelte-81gnnp"&&(tt.innerHTML=yd),Hl=l(s),g(at.$$.fragment,s),Ql=l(s),g(et.$$.fragment,s),Xl=l(s),nt=p(s,"P",{"data-svelte-h":!0}),o(nt)!=="svelte-jl1fz0"&&(nt.innerHTML=fd),Nl=l(s),g(lt.$$.fragment,s),Rl=l(s),it=p(s,"P",{"data-svelte-h":!0}),o(it)!=="svelte-174suzs"&&(it.textContent=wd),Vl=l(s),g(pt.$$.fragment,s),ql=l(s),mt=p(s,"P",{"data-svelte-h":!0}),o(mt)!=="svelte-138fn6l"&&(mt.innerHTML=bd),Al=l(s),g(ot.$$.fragment,s),El=l(s),rt=p(s,"P",{"data-svelte-h":!0}),o(rt)!=="svelte-jl1fz0"&&(rt.innerHTML=vd),Yl=l(s),g(ht.$$.fragment,s),Sl=l(s),ct=p(s,"P",{"data-svelte-h":!0}),o(ct)!=="svelte-14j7eyl"&&(ct.textContent=Md),Fl=l(s),ut=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(ut)!=="svelte-1gvcuxd"&&(ut.innerHTML=xd),Pl=l(s),dt=p(s,"P",{"data-svelte-h":!0}),o(dt)!=="svelte-1urmxur"&&(dt.innerHTML=kd),Kl=l(s),gt=p(s,"P",{"data-svelte-h":!0}),o(gt)!=="svelte-1uylvrd"&&(gt.innerHTML=Td),Dl=l(s),g(yt.$$.fragment,s),Ol=l(s),ft=p(s,"P",{"data-svelte-h":!0}),o(ft)!=="svelte-zicod6"&&(ft.textContent=jd),si=l(s),g(wt.$$.fragment,s),ti=l(s),bt=p(s,"P",{"data-svelte-h":!0}),o(bt)!=="svelte-1prc48e"&&(bt.innerHTML=_d),ai=l(s),g(vt.$$.fragment,s),ei=l(s),Mt=p(s,"P",{"data-svelte-h":!0}),o(Mt)!=="svelte-1xisv4k"&&(Mt.innerHTML=Jd),ni=l(s),xt=p(s,"P",{"data-svelte-h":!0}),o(xt)!=="svelte-xkk23p"&&(xt.innerHTML=Ud),li=l(s),kt=p(s,"P",{"data-svelte-h":!0}),o(kt)!=="svelte-171gpq5"&&(kt.textContent=Cd),ii=l(s),Tt=p(s,"UL",{"data-svelte-h":!0}),o(Tt)!=="svelte-11ifrvi"&&(Tt.innerHTML=zd),pi=l(s),B=p(s,"P",{});var $=M(B);zc=h($,"In a nutshell, this means that "),fn=p($,"EM",{"data-svelte-h":!0}),o(fn)!=="svelte-1hxrv2n"&&(fn.textContent=Ld),Lc=h($," multiplications, with"),mi=u($,!1),oi=h($," being the "),wn=p($,"EM",{"data-svelte-h":!0}),o(wn)!=="svelte-9j42in"&&(wn.textContent=Gd),Gc=h($,","),ri=u($,!1),hi=h($," being a weight matrix and"),ci=u($,!1),ui=h($,` being the output:
`),di=u($,!1),$.forEach(a),gi=l(s),jt=p(s,"P",{});var Su=M(jt);Bc=h(Su,`are changed to
`),yi=u(Su,!1),Su.forEach(a),fi=l(s),_t=p(s,"P",{"data-svelte-h":!0}),o(_t)!=="svelte-12wl41q"&&(_t.textContent=Bd),wi=l(s),Jt=p(s,"P",{"data-svelte-h":!0}),o(Jt)!=="svelte-8mpqh2"&&(Jt.innerHTML=Zd),bi=l(s),g(Ut.$$.fragment,s),vi=l(s),Ct=p(s,"P",{"data-svelte-h":!0}),o(Ct)!=="svelte-6n5flp"&&(Ct.innerHTML=Id),Mi=l(s),g(zt.$$.fragment,s),xi=l(s),Lt=p(s,"P",{"data-svelte-h":!0}),o(Lt)!=="svelte-1yy92n4"&&(Lt.textContent=$d),ki=l(s),g(Gt.$$.fragment,s),Ti=l(s),Bt=p(s,"P",{"data-svelte-h":!0}),o(Bt)!=="svelte-jl1fz0"&&(Bt.innerHTML=Wd),ji=l(s),g(Zt.$$.fragment,s),_i=l(s),It=p(s,"P",{"data-svelte-h":!0}),o(It)!=="svelte-12urs7j"&&(It.textContent=Hd),Ji=l(s),g($t.$$.fragment,s),Ui=l(s),Wt=p(s,"P",{"data-svelte-h":!0}),o(Wt)!=="svelte-jl1fz0"&&(Wt.innerHTML=Qd),Ci=l(s),g(Ht.$$.fragment,s),zi=l(s),Qt=p(s,"P",{"data-svelte-h":!0}),o(Qt)!=="svelte-x8wynt"&&(Qt.textContent=Xd),Li=l(s),Xt=p(s,"P",{"data-svelte-h":!0}),o(Xt)!=="svelte-3uld8v"&&(Xt.textContent=Nd),Gi=l(s),g(Nt.$$.fragment,s),Bi=l(s),g(Rt.$$.fragment,s),Zi=l(s),Vt=p(s,"P",{"data-svelte-h":!0}),o(Vt)!=="svelte-1sadlnz"&&(Vt.innerHTML=Rd),Ii=l(s),g(qt.$$.fragment,s),$i=l(s),At=p(s,"P",{"data-svelte-h":!0}),o(At)!=="svelte-jl1fz0"&&(At.innerHTML=Vd),Wi=l(s),g(Et.$$.fragment,s),Hi=l(s),Yt=p(s,"P",{"data-svelte-h":!0}),o(Yt)!=="svelte-1scve2"&&(Yt.innerHTML=qd),Qi=l(s),g(St.$$.fragment,s),Xi=l(s),Ft=p(s,"P",{"data-svelte-h":!0}),o(Ft)!=="svelte-jl1fz0"&&(Ft.innerHTML=Ad),Ni=l(s),g(Pt.$$.fragment,s),Ri=l(s),Kt=p(s,"P",{"data-svelte-h":!0}),o(Kt)!=="svelte-1mhmf5k"&&(Kt.textContent=Ed),Vi=l(s),Dt=p(s,"P",{"data-svelte-h":!0}),o(Dt)!=="svelte-sad4qj"&&(Dt.innerHTML=Yd),qi=l(s),K=p(s,"P",{});var sl=M(K);Zc=h(sl,"Also note that inference here was again a bit slower compared to 8-bit quantization which is due to the more aggressive quantization method used for 4-bit quantization leading to"),Ai=u(sl,!1),Ei=h(sl," and"),Yi=u(sl,!1),Si=h(sl," taking longer during inference."),sl.forEach(a),Fi=l(s),g(Ot.$$.fragment,s),Pi=l(s),g(sa.$$.fragment,s),Ki=l(s),ta=p(s,"P",{"data-svelte-h":!0}),o(ta)!=="svelte-9e7sx8"&&(ta.textContent=Sd),Di=l(s),aa=p(s,"P",{"data-svelte-h":!0}),o(aa)!=="svelte-pphiln"&&(aa.textContent=Fd),Oi=l(s),ea=p(s,"P",{"data-svelte-h":!0}),o(ea)!=="svelte-6h5u0r"&&(ea.innerHTML=Pd),sp=l(s),na=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(na)!=="svelte-i1sgud"&&(na.innerHTML=Kd),tp=l(s),la=p(s,"P",{"data-svelte-h":!0}),o(la)!=="svelte-68w1lt"&&(la.textContent=Dd),ap=l(s),ia=p(s,"P",{"data-svelte-h":!0}),o(ia)!=="svelte-ei9u00"&&(ia.innerHTML=Od),ep=l(s),g(pa.$$.fragment,s),np=l(s),ma=p(s,"P",{"data-svelte-h":!0}),o(ma)!=="svelte-649tnu"&&(ma.textContent=sg),lp=l(s),q=p(s,"P",{});var ks=M(q);Ic=h(ks,`Self-attention layers are central to Large Language Models (LLMs) in that they enable the model to understand the contextual relationships between input tokens.
However, the peak GPU memory consumption for self-attention layers grows `),bn=p(ks,"EM",{"data-svelte-h":!0}),o(bn)!=="svelte-1jeo576"&&(bn.textContent=tg),$c=h(ks," both in compute and memory complexity with number of input tokens (also called "),vn=p(ks,"EM",{"data-svelte-h":!0}),o(vn)!=="svelte-1xe7eav"&&(vn.textContent=ag),Wc=h(ks,") that we denote in the following by"),ip=u(ks,!1),pp=h(ks,` .
While this is not really noticeable for shorter input sequences (of up to 1000 input tokens), it becomes a serious problem for longer input sequences (at around 16000 input tokens).`),ks.forEach(a),mp=l(s),T=p(s,"P",{});var J=M(T);Hc=h(J,"Let’s take a closer look. The formula to compute the output"),op=u(J,!1),rp=h(J," of a self-attention layer for an input"),hp=u(J,!1),cp=h(J," of length"),up=u(J,!1),dp=h(J,` is:
`),gp=u(J,!1),yp=l(J),fp=u(J,!1),wp=h(J," is thereby the input sequence to the attention layer. The projections"),bp=u(J,!1),vp=h(J," and"),Mp=u(J,!1),xp=h(J," will each consist of"),kp=u(J,!1),Tp=h(J," vectors resulting in the"),jp=u(J,!1),_p=h(J," being of size"),Jp=u(J,!1),Up=h(J," ."),J.forEach(a),Cp=l(s),U=p(s,"P",{});var H=M(U);Qc=h(H,`LLMs usually have multiple attention heads, thus doing multiple self-attention computations in parallel.
Assuming, the LLM has 40 attention heads and runs in bfloat16 precision, we can calculate the memory requirement to store the`),zp=u(H,!1),Lp=h(H," matrices to be"),Gp=u(H,!1),Bp=h(H," bytes. For"),Zp=u(H,!1),Ip=h(H," only around 50 MB of VRAM are needed, however, for"),$p=u(H,!1),Wp=h(H," we would need 19 GB of VRAM, and for"),Hp=u(H,!1),Qp=h(H," we would need almost 1TB just to store the"),Xp=u(H,!1),Np=h(H," matrices."),H.forEach(a),Rp=l(s),oa=p(s,"P",{"data-svelte-h":!0}),o(oa)!=="svelte-bptbn2"&&(oa.textContent=eg),Vp=l(s),ra=p(s,"P",{"data-svelte-h":!0}),o(ra)!=="svelte-opmd8n"&&(ra.textContent=ng),qp=l(s),A=p(s,"P",{});var Ts=M(A);Xc=h(Ts,"How can we get rid of the exorbitant memory requirements for large input lengths? We need a new way to compute the self-attention mechanism that gets rid of the"),Ap=u(Ts,!1),Ep=h(Ts," matrix. "),rs=p(Ts,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(rs)!=="svelte-1h13bsr"&&(rs.textContent=lg),Nc=h(Ts," developed exactly such a new algorithm and called it "),Mn=p(Ts,"STRONG",{"data-svelte-h":!0}),o(Mn)!=="svelte-eh0j4m"&&(Mn.textContent=ig),Rc=h(Ts,"."),Ts.forEach(a),Yp=l(s),is=p(s,"P",{});var rl=M(is);Vc=h(rl,"In a nutshell, Flash Attention breaks the "),Sp=u(rl,!1),Fp=h(rl,`) computation apart and instead computes smaller chunks of the output by iterating over multiple softmax computation steps:
`),Pp=u(rl,!1),rl.forEach(a),Kp=l(s),W=p(s,"P",{});var es=M(W);qc=h(es,"with"),Dp=u(es,!1),Op=h(es," and"),sm=u(es,!1),tm=h(es," being some softmax normalization statistics that need to be recomputed for every"),am=u(es,!1),em=h(es," and"),nm=u(es,!1),lm=h(es," ."),es.forEach(a),im=l(s),ha=p(s,"P",{"data-svelte-h":!0}),o(ha)!=="svelte-1q8406g"&&(ha.innerHTML=pg),pm=l(s),ca=p(s,"P",{"data-svelte-h":!0}),o(ca)!=="svelte-1ufr4xd"&&(ca.textContent=mg),mm=l(s),xn=p(s,"BLOCKQUOTE",{});var bf=M(xn);ps=p(bf,"P",{});var tl=M(ps);Ac=h(tl,"By keeping track of softmax normalization statistics and by using some smart mathematics, Flash Attention gives "),kn=p(tl,"STRONG",{"data-svelte-h":!0}),o(kn)!=="svelte-1fh6qbl"&&(kn.textContent=og),Ec=h(tl," outputs compared to the default self-attention layer at a memory cost that only increases linearly with"),om=u(tl,!1),rm=h(tl," ."),tl.forEach(a),bf.forEach(a),hm=l(s),ua=p(s,"P",{"data-svelte-h":!0}),o(ua)!=="svelte-1re0bhf"&&(ua.innerHTML=rg),cm=l(s),da=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(da)!=="svelte-m261q0"&&(da.innerHTML=hg),um=l(s),D=p(s,"P",{});var al=M(D);Yc=h(al,"Essentially, Flash Attention makes sure that all intermediate write and read operations can be done using the fast "),Tn=p(al,"EM",{"data-svelte-h":!0}),o(Tn)!=="svelte-1g1d7vc"&&(Tn.textContent=cg),Sc=h(al," SRAM memory instead of having to access the slower VRAM memory to compute the output vector"),dm=u(al,!1),gm=h(al," ."),al.forEach(a),ym=l(s),ga=p(s,"P",{"data-svelte-h":!0}),o(ga)!=="svelte-1ew53wd"&&(ga.innerHTML=ug),fm=l(s),ya=p(s,"P",{"data-svelte-h":!0}),o(ya)!=="svelte-1uhed9l"&&(ya.textContent=dg),wm=l(s),fa=p(s,"P",{"data-svelte-h":!0}),o(fa)!=="svelte-66kx9u"&&(fa.innerHTML=gg),bm=l(s),g(wa.$$.fragment,s),vm=l(s),ba=p(s,"P",{"data-svelte-h":!0}),o(ba)!=="svelte-1qzrmrh"&&(ba.innerHTML=yg),Mm=l(s),g(va.$$.fragment,s),xm=l(s),Ma=p(s,"P",{"data-svelte-h":!0}),o(Ma)!=="svelte-1lfqnh1"&&(Ma.textContent=fg),km=l(s),g(xa.$$.fragment,s),Tm=l(s),ka=p(s,"P",{"data-svelte-h":!0}),o(ka)!=="svelte-tc5wkn"&&(ka.innerHTML=wg),jm=l(s),g(Ta.$$.fragment,s),_m=l(s),ja=p(s,"P",{"data-svelte-h":!0}),o(ja)!=="svelte-jl1fz0"&&(ja.innerHTML=bg),Jm=l(s),g(_a.$$.fragment,s),Um=l(s),Ja=p(s,"P",{"data-svelte-h":!0}),o(Ja)!=="svelte-sz1cee"&&(Ja.textContent=vg),Cm=l(s),Ua=p(s,"P",{"data-svelte-h":!0}),o(Ua)!=="svelte-d2g4iy"&&(Ua.innerHTML=Mg),zm=l(s),Ca=p(s,"P",{"data-svelte-h":!0}),o(Ca)!=="svelte-2il51v"&&(Ca.textContent=xg),Lm=l(s),g(za.$$.fragment,s),Gm=l(s),La=p(s,"P",{"data-svelte-h":!0}),o(La)!=="svelte-jl1fz0"&&(La.innerHTML=kg),Bm=l(s),g(Ga.$$.fragment,s),Zm=l(s),Ba=p(s,"P",{"data-svelte-h":!0}),o(Ba)!=="svelte-1uumitt"&&(Ba.textContent=Tg),Im=l(s),Za=p(s,"P",{"data-svelte-h":!0}),o(Za)!=="svelte-bk1lpp"&&(Za.innerHTML=jg),$m=l(s),g(Ia.$$.fragment,s),Wm=l(s),$a=p(s,"P",{"data-svelte-h":!0}),o($a)!=="svelte-wh831x"&&($a.innerHTML=_g),Hm=l(s),g(Wa.$$.fragment,s),Qm=l(s),Ha=p(s,"P",{"data-svelte-h":!0}),o(Ha)!=="svelte-ncw8pe"&&(Ha.textContent=Jg),Xm=l(s),g(Qa.$$.fragment,s),Nm=l(s),Xa=p(s,"P",{"data-svelte-h":!0}),o(Xa)!=="svelte-jl1fz0"&&(Xa.innerHTML=Ug),Rm=l(s),g(Na.$$.fragment,s),Vm=l(s),Ra=p(s,"P",{"data-svelte-h":!0}),o(Ra)!=="svelte-1onj0qe"&&(Ra.textContent=Cg),qm=l(s),Va=p(s,"P",{"data-svelte-h":!0}),o(Va)!=="svelte-1b8rrkf"&&(Va.textContent=zg),Am=l(s),g(qa.$$.fragment,s),Em=l(s),Aa=p(s,"P",{"data-svelte-h":!0}),o(Aa)!=="svelte-jl1fz0"&&(Aa.innerHTML=Lg),Ym=l(s),g(Ea.$$.fragment,s),Sm=l(s),Ya=p(s,"P",{"data-svelte-h":!0}),o(Ya)!=="svelte-gk4woy"&&(Ya.textContent=Gg),Fm=l(s),Sa=p(s,"P",{"data-svelte-h":!0}),o(Sa)!=="svelte-1lt2th7"&&(Sa.textContent=Bg),Pm=l(s),g(Fa.$$.fragment,s),Km=l(s),Pa=p(s,"P",{"data-svelte-h":!0}),o(Pa)!=="svelte-1a3n0qf"&&(Pa.innerHTML=Zg),Dm=l(s),Ka=p(s,"P",{"data-svelte-h":!0}),o(Ka)!=="svelte-13zp14a"&&(Ka.textContent=Ig),Om=l(s),Da=p(s,"P",{"data-svelte-h":!0}),o(Da)!=="svelte-1i10a94"&&(Da.textContent=$g),so=l(s),Oa=p(s,"UL",{"data-svelte-h":!0}),o(Oa)!=="svelte-1ti1vbk"&&(Oa.innerHTML=Wg),to=l(s),se=p(s,"P",{"data-svelte-h":!0}),o(se)!=="svelte-jqprou"&&(se.innerHTML=Hg),ao=l(s),te=p(s,"UL",{"data-svelte-h":!0}),o(te)!=="svelte-ig4ec7"&&(te.innerHTML=Qg),eo=l(s),ae=p(s,"P",{"data-svelte-h":!0}),o(ae)!=="svelte-awpy0j"&&(ae.innerHTML=Xg),no=l(s),ee=p(s,"P",{"data-svelte-h":!0}),o(ee)!=="svelte-152e8kl"&&(ee.textContent=Ng),lo=l(s),ne=p(s,"UL",{"data-svelte-h":!0}),o(ne)!=="svelte-k4f0dn"&&(ne.innerHTML=Rg),io=l(s),le=p(s,"P",{"data-svelte-h":!0}),o(le)!=="svelte-wxdkvm"&&(le.textContent=Vg),po=l(s),ie=p(s,"P",{"data-svelte-h":!0}),o(ie)!=="svelte-18w95it"&&(ie.textContent=qg),mo=l(s),O=p(s,"P",{});var el=M(O);Fc=h(el,`Self-attention puts each token in relation to each other’s tokens.
As an example, the`),oo=u(el,!1),ro=h(el," matrix of the text input sequence "),jn=p(el,"EM",{"data-svelte-h":!0}),o(jn)!=="svelte-13ogmf8"&&(jn.textContent=Ag),Pc=h(el," could look as follows:"),el.forEach(a),ho=l(s),pe=p(s,"P",{"data-svelte-h":!0}),o(pe)!=="svelte-7ssrcl"&&(pe.innerHTML=Eg),co=l(s),me=p(s,"P",{"data-svelte-h":!0}),o(me)!=="svelte-1xg4o0y"&&(me.innerHTML=Yg),uo=l(s),I=p(s,"P",{});var F=M(I);Kc=h(F,`A LLM based on self-attention, but without position embeddings would have great difficulties in understanding the positions of the text inputs to each other.
This is because the probability score computed by`),go=u(F,!1),yo=h(F," relates each word token to each other word token in"),fo=u(F,!1),wo=h(F,` computations regardless of their relative positional distance to each other.
Therefore, for the LLM without position embeddings each token appears to have the same distance to all other tokens, `),_n=p(F,"EM",{"data-svelte-h":!0}),o(_n)!=="svelte-2dbwd4"&&(_n.textContent=Sg),Dc=h(F," differentiating between "),Jn=p(F,"EM",{"data-svelte-h":!0}),o(Jn)!=="svelte-1u1601v"&&(Jn.textContent=Fg),Oc=h(F," and "),Un=p(F,"EM",{"data-svelte-h":!0}),o(Un)!=="svelte-16pe0y3"&&(Un.textContent=Pg),su=h(F," would be very challenging."),F.forEach(a),bo=l(s),oe=p(s,"P",{"data-svelte-h":!0}),o(oe)!=="svelte-10v2cm"&&(oe.innerHTML=Kg),vo=l(s),C=p(s,"P",{});var Q=M(C);tu=h(Q,"The authors of the "),hs=p(Q,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(hs)!=="svelte-507xi2"&&(hs.innerHTML=Dg),au=h(Q," paper introduced sinusoidal positional embeddings"),Mo=u(Q,!1),xo=h(Q,` .
where each vector`),ko=u(Q,!1),To=h(Q," is computed as a sinusoidal function of its position"),jo=u(Q,!1),_o=h(Q,` .
The positional encodings are then simply added to the input sequence vectors`),Jo=u(Q,!1),Uo=h(Q," ="),Co=u(Q,!1),zo=h(Q," thereby cueing the model to better learn sentence order."),Q.forEach(a),Lo=l(s),ss=p(s,"P",{});var nl=M(ss);eu=h(nl,"Instead of using fixed position embeddings, others (such as "),cs=p(nl,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(cs)!=="svelte-1j8obl2"&&(cs.textContent=Og),nu=h(nl,") used learned positional encodings for which the positional embeddings"),Go=u(nl,!1),Bo=h(nl," are learned during training."),nl.forEach(a),Zo=l(s),re=p(s,"P",{"data-svelte-h":!0}),o(re)!=="svelte-gfh3nk"&&(re.textContent=sy),Io=l(s),us=p(s,"OL",{});var xc=M(us);R=p(xc,"LI",{});var ns=M(R);lu=h(ns,"Sinusoidal and learned position embeddings are both absolute positional embeddings, "),Cn=p(ns,"EM",{"data-svelte-h":!0}),o(Cn)!=="svelte-1636wt6"&&(Cn.textContent=ty),iu=h(ns," encoding a unique embedding for each position id:"),$o=u(ns,!1),Wo=h(ns," . As shown by "),ds=p(ns,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ds)!=="svelte-1elqrnk"&&(ds.textContent=ay),pu=h(ns," and "),gs=p(ns,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(gs)!=="svelte-sksjon"&&(gs.textContent=ey),mu=h(ns,", absolute positional embeddings lead to poor LLM performance for long text inputs. For long text inputs, it is advantageous if the model learns the relative positional distance input tokens have to each other instead of their absolute position."),ns.forEach(a),ou=l(xc),he=p(xc,"LI",{});var kc=M(he);ru=h(kc,"When using learned position embeddings, the LLM has to be trained on a fixed input length"),Ho=u(kc,!1),Qo=h(kc,", which makes it difficult to extrapolate to an input length longer than what it was trained on."),kc.forEach(a),xc.forEach(a),Xo=l(s),ce=p(s,"P",{"data-svelte-h":!0}),o(ce)!=="svelte-pzlnat"&&(ce.textContent=ny),No=l(s),ue=p(s,"UL",{"data-svelte-h":!0}),o(ue)!=="svelte-1q2i0ic"&&(ue.innerHTML=ly),Ro=l(s),E=p(s,"P",{});var js=M(E);hu=h(js,"Both "),zn=p(js,"EM",{"data-svelte-h":!0}),o(zn)!=="svelte-1koqbni"&&(zn.textContent=iy),cu=h(js," and "),Ln=p(js,"EM",{"data-svelte-h":!0}),o(Ln)!=="svelte-4g6i8t"&&(Ln.textContent=py),uu=h(js," argue that it’s best to cue the LLM about sentence order directly in the self-attention algorithm as it’s there that word tokens are put into relation with each other. More specifically, sentence order should be cued by modifying the"),Vo=u(js,!1),qo=h(js," computation."),js.forEach(a),Ao=l(s),k=p(s,"P",{});var _=M(k);du=h(_,"Without going into too many details, "),Gn=p(_,"EM",{"data-svelte-h":!0}),o(Gn)!=="svelte-1koqbni"&&(Gn.textContent=my),gu=h(_," notes that positional information can be encoded into query-key pairs, "),Bn=p(_,"EM",{"data-svelte-h":!0}),o(Bn)!=="svelte-2dbwd4"&&(Bn.textContent=oy),Eo=u(_,!1),Yo=h(_," and"),So=u(_,!1),Fo=h(_," by rotating each vector by an angle"),Po=u(_,!1),Ko=h(_," and"),Do=u(_,!1),Oo=h(_," respectively with"),sr=u(_,!1),tr=h(_,` describing each vectors sentence position:
`),ar=u(_,!1),er=l(_),nr=u(_,!1),lr=h(_," thereby represents a rotational matrix."),ir=u(_,!1),pr=h(_," is "),Zn=p(_,"EM",{"data-svelte-h":!0}),o(Zn)!=="svelte-r5iszh"&&(Zn.textContent=ry),yu=h(_," learned during training, but instead set to a pre-defined value that depends on the maximum input sequence length during training."),_.forEach(a),mr=l(s),In=p(s,"BLOCKQUOTE",{});var vf=M(In);Z=p(vf,"P",{});var X=M(Z);fu=h(X,"By doing so, the propability score between"),or=u(X,!1),rr=h(X," and"),hr=u(X,!1),cr=h(X," is only affected if"),ur=u(X,!1),dr=h(X," and solely depends on the relative distance"),gr=u(X,!1),yr=h(X," regardless of each vector’s specific positions"),fr=u(X,!1),wr=h(X," and"),br=u(X,!1),vr=h(X," ."),X.forEach(a),vf.forEach(a),Mr=l(s),de=p(s,"P",{"data-svelte-h":!0}),o(de)!=="svelte-1ct7c61"&&(de.innerHTML=hy),xr=l(s),ge=p(s,"UL",{"data-svelte-h":!0}),o(ge)!=="svelte-1ggqrue"&&(ge.innerHTML=cy),kr=l(s),Y=p(s,"P",{});var _s=M(Y);wu=h(_s,"As an alternative, "),$n=p(_s,"EM",{"data-svelte-h":!0}),o($n)!=="svelte-4g6i8t"&&($n.textContent=uy),bu=h(_s," proposes a much simpler relative position encoding scheme. The relative distance that input tokens have to each other is added as a negative integer scaled by a pre-defined value "),Wn=p(_s,"CODE",{"data-svelte-h":!0}),o(Wn)!=="svelte-1gskrin"&&(Wn.textContent=dy),vu=h(_s," to each query-key entry of the"),Tr=u(_s,!1),jr=h(_s," matrix right before the softmax computation."),_s.forEach(a),_r=l(s),ye=p(s,"P",{"data-svelte-h":!0}),o(ye)!=="svelte-1sb0gvf"&&(ye.innerHTML=gy),Jr=l(s),fe=p(s,"P",{"data-svelte-h":!0}),o(fe)!=="svelte-1stpbxv"&&(fe.innerHTML=yy),Ur=l(s),we=p(s,"P",{"data-svelte-h":!0}),o(we)!=="svelte-3uyjm"&&(we.innerHTML=fy),Cr=l(s),be=p(s,"UL",{"data-svelte-h":!0}),o(be)!=="svelte-l3k8fx"&&(be.innerHTML=wy),zr=l(s),x=p(s,"P",{});var j=M(x);Mu=h(j,"Both "),Hn=p(j,"EM",{"data-svelte-h":!0}),o(Hn)!=="svelte-1koqbni"&&(Hn.textContent=by),xu=h(j," and "),Qn=p(j,"EM",{"data-svelte-h":!0}),o(Qn)!=="svelte-4g6i8t"&&(Qn.textContent=vy),ku=h(j," position encodings can extrapolate to input lengths not seen during training whereas it has been shown that extrapolation works much better out-of-the-box for "),Xn=p(j,"EM",{"data-svelte-h":!0}),o(Xn)!=="svelte-4g6i8t"&&(Xn.textContent=My),Tu=h(j," as compared to "),Nn=p(j,"EM",{"data-svelte-h":!0}),o(Nn)!=="svelte-1koqbni"&&(Nn.textContent=xy),ju=h(j,`.
For ALiBi, one simply increases the values of the lower triangular position matrix to match the length of the input sequence.
For `),Rn=p(j,"EM",{"data-svelte-h":!0}),o(Rn)!=="svelte-1koqbni"&&(Rn.textContent=ky),_u=h(j,", keeping the same"),Lr=u(j,!1),Gr=h(j," that was used during training leads to poor results when passing text inputs much longer than those seen during training, "),Vn=p(j,"EM",{"data-svelte-h":!0}),o(Vn)!=="svelte-6ye6px"&&(Vn.textContent=Ty),Ju=l(j),ys=p(j,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(ys)!=="svelte-1wv3alf"&&(ys.textContent=jy),Uu=h(j,". However, the community has found a couple of effective tricks that adapt"),Br=u(j,!1),Zr=h(j,", thereby allowing "),qn=p(j,"EM",{"data-svelte-h":!0}),o(qn)!=="svelte-1koqbni"&&(qn.textContent=_y),Cu=h(j," position embeddings to work well for extrapolated text input sequences (see "),fs=p(j,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(fs)!=="svelte-ax8fr8"&&(fs.textContent=Jy),zu=h(j,")."),j.forEach(a),Ir=l(s),ws=p(s,"BLOCKQUOTE",{});var Tc=M(ws);An=p(Tc,"P",{"data-svelte-h":!0}),o(An)!=="svelte-1bw79ap"&&(An.innerHTML=Uy),Lu=l(Tc),ms=p(Tc,"UL",{});var ll=M(ms);ve=p(ll,"LI",{});var jc=M(ve);Gu=h(jc,"Positional cues about the text inputs should be given directly to the"),$r=u(jc,!1),Wr=h(jc," matrix of the self-attention layer"),jc.forEach(a),Bu=l(ll),En=p(ll,"LI",{"data-svelte-h":!0}),o(En)!=="svelte-lwsxvy"&&(En.innerHTML=Cy),Zu=l(ll),Yn=p(ll,"LI",{"data-svelte-h":!0}),o(Yn)!=="svelte-as1kp0"&&(Yn.textContent=zy),ll.forEach(a),Tc.forEach(a),Hr=l(s),S=p(s,"P",{});var Js=M(S);Iu=h(Js,"In conclusion, LLMs that are intended to be deployed in tasks that require handling large text inputs are better trained with relative positional embeddings, such as RoPE and ALiBi. Also note that even if an LLM with RoPE and ALiBi has been trained only on a fixed length of say"),Qr=u(Js,!1),Xr=h(Js," it can still be used in practice with text inputs much larger than"),Nr=u(Js,!1),Rr=h(Js,", like"),Vr=u(Js,!1),qr=h(Js," by extrapolating the positional embeddings."),Js.forEach(a),Ar=l(s),Me=p(s,"P",{"data-svelte-h":!0}),o(Me)!=="svelte-1an2cry"&&(Me.textContent=Ly),Er=l(s),xe=p(s,"P",{"data-svelte-h":!0}),o(xe)!=="svelte-ph4j6j"&&(xe.textContent=Gy),Yr=l(s),ke=p(s,"P",{"data-svelte-h":!0}),o(ke)!=="svelte-1e96w3w"&&(ke.innerHTML=By),Sr=l(s),Te=p(s,"P",{"data-svelte-h":!0}),o(Te)!=="svelte-809dal"&&(Te.innerHTML=Zy),Fr=l(s),g(je.$$.fragment,s),Pr=l(s),_e=p(s,"P",{"data-svelte-h":!0}),o(_e)!=="svelte-jl1fz0"&&(_e.innerHTML=Iy),Kr=l(s),g(Je.$$.fragment,s),Dr=l(s),Ue=p(s,"P",{"data-svelte-h":!0}),o(Ue)!=="svelte-1hvw6ou"&&(Ue.textContent=$y),Or=l(s),Ce=p(s,"P",{"data-svelte-h":!0}),o(Ce)!=="svelte-td5od5"&&(Ce.innerHTML=Wy),sh=l(s),z=p(s,"P",{});var N=M(z);$u=h(N,"As a consequence, tokens "),Sn=p(N,"EM",{"data-svelte-h":!0}),o(Sn)!=="svelte-1pjm1n8"&&(Sn.textContent=Hy),Wu=h(N," depend on previous tokens, more specifically the"),th=u(N,!1),ah=h(N," vector is never put in relation with any key, values vectors"),eh=u(N,!1),nh=h(N," if"),lh=u(N,!1),ih=h(N," . Instead"),ph=u(N,!1),mh=h(N," only attends to previous key-value vectors"),oh=u(N,!1),rh=h(N,". In order to reduce unnecessary computation, one can therefore cache each layer’s key-value vectors for all previous timesteps."),N.forEach(a),hh=l(s),ze=p(s,"P",{"data-svelte-h":!0}),o(ze)!=="svelte-1f21m0a"&&(ze.innerHTML=Qy),ch=l(s),g(Le.$$.fragment,s),uh=l(s),Ge=p(s,"P",{"data-svelte-h":!0}),o(Ge)!=="svelte-jl1fz0"&&(Ge.innerHTML=Xy),dh=l(s),g(Be.$$.fragment,s),gh=l(s),Ze=p(s,"P",{"data-svelte-h":!0}),o(Ze)!=="svelte-sjvt58"&&(Ze.innerHTML=Ny),yh=l(s),Fn=p(s,"BLOCKQUOTE",{});var Mf=M(Fn);V=p(Mf,"P",{});var ls=M(V);Hu=h(ls,"Making use of the key-value cache means that the"),fh=u(ls,!1),wh=h(ls," is essentially reduced to"),bh=u(ls,!1),vh=h(ls," with"),Mh=u(ls,!1),xh=h(ls," being the query projection of the currently passed input token which is "),Pn=p(ls,"EM",{"data-svelte-h":!0}),o(Pn)!=="svelte-x3mkar"&&(Pn.textContent=Ry),Qu=h(ls," just a single vector."),ls.forEach(a),Mf.forEach(a),kh=l(s),Ie=p(s,"P",{"data-svelte-h":!0}),o(Ie)!=="svelte-1xsdpw0"&&(Ie.textContent=Vy),Th=l(s),bs=p(s,"UL",{});var _c=M(bs);$e=p(_c,"LI",{});var Jc=M($e);Xu=h(Jc,"Significant increase in computational efficiency as less computations are performed compared to computing the full"),jh=u(Jc,!1),_h=h(Jc," matrix. This leads to an increase in inference speed"),Jc.forEach(a),Nu=l(_c),Kn=p(_c,"LI",{"data-svelte-h":!0}),o(Kn)!=="svelte-1uy8i0e"&&(Kn.textContent=qy),_c.forEach(a),Jh=l(s),We=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(We)!=="svelte-ecu5gq"&&(We.innerHTML=Ay),Uh=l(s),g(vs.$$.fragment,s),Ch=l(s),He=p(s,"P",{"data-svelte-h":!0}),o(He)!=="svelte-6wgkwb"&&(He.textContent=Ey),zh=l(s),Qe=p(s,"P",{"data-svelte-h":!0}),o(Qe)!=="svelte-15et702"&&(Qe.textContent=Yy),Lh=l(s),g(Xe.$$.fragment,s),Gh=l(s),Ne=p(s,"P",{"data-svelte-h":!0}),o(Ne)!=="svelte-1nmendz"&&(Ne.textContent=Sy),Bh=l(s),Re=p(s,"OL",{"data-svelte-h":!0}),o(Re)!=="svelte-shg0uc"&&(Re.innerHTML=Fy),Zh=l(s),Ve=p(s,"P",{"data-svelte-h":!0}),o(Ve)!=="svelte-cqzbwt"&&(Ve.textContent=Py),Ih=l(s),qe=p(s,"OL",{"data-svelte-h":!0}),o(qe)!=="svelte-1bgwi27"&&(qe.innerHTML=Ky),$h=l(s),Ae=p(s,"P",{"data-svelte-h":!0}),o(Ae)!=="svelte-naw54a"&&(Ae.innerHTML=Dy),Wh=l(s),g(Ee.$$.fragment,s),Hh=l(s),Ye=p(s,"P",{"data-svelte-h":!0}),o(Ye)!=="svelte-jl1fz0"&&(Ye.innerHTML=Oy),Qh=l(s),g(Se.$$.fragment,s),Xh=l(s),ts=p(s,"P",{});var il=M(ts);Ru=h(il,"Great, no additional time is spent recomputing the same key and values for the attention layer! There is however one catch. While the required peak memory for the"),Nh=u(il,!1),Rh=h(il," matrix is significantly reduced, holding the key-value cache in memory can become very memory expensive for long input sequences or multi-turn chat. Remember that the key-value cache needs to store the key-value vectors for all previous input vectors"),Vh=u(il,!1),qh=h(il," for all self-attention layers and for all attention heads."),il.forEach(a),Ah=l(s),Fe=p(s,"P",{"data-svelte-h":!0}),o(Fe)!=="svelte-hoekyy"&&(Fe.innerHTML=sf),Eh=l(s),g(Pe.$$.fragment,s),Yh=l(s),Ke=p(s,"P",{"data-svelte-h":!0}),o(Ke)!=="svelte-jl1fz0"&&(Ke.innerHTML=tf),Sh=l(s),g(De.$$.fragment,s),Fh=l(s),Oe=p(s,"P",{"data-svelte-h":!0}),o(Oe)!=="svelte-yntyqd"&&(Oe.innerHTML=af),Ph=l(s),sn=p(s,"P",{"data-svelte-h":!0}),o(sn)!=="svelte-lzcw9a"&&(sn.textContent=ef),Kh=l(s),tn=p(s,"P",{"data-svelte-h":!0}),o(tn)!=="svelte-15s0o0t"&&(tn.innerHTML=nf),Dh=l(s),Dn=p(s,"BLOCKQUOTE",{});var xf=M(Dn);os=p(xf,"P",{});var pl=M(os);Vu=h(pl,"By using a single head-value projection weight pair, the key value vectors"),Oh=u(pl,!1),sc=h(pl," have to be identical across all attention heads which in turn means that we only need to store 1 key-value projection pair in the cache instead of "),On=p(pl,"CODE",{"data-svelte-h":!0}),o(On)!=="svelte-6j0g1x"&&(On.textContent=lf),qu=h(pl," ones."),pl.forEach(a),xf.forEach(a),tc=l(s),an=p(s,"P",{"data-svelte-h":!0}),o(an)!=="svelte-16lijvq"&&(an.textContent=pf),ac=l(s),as=p(s,"P",{});var ml=M(as);Au=h(ml,`In addition to memory savings, MQA also leads to improved computational efficiency as explained in the following.
In auto-regressive decoding, large key-value vectors need to be reloaded, concatenated with the current key-value vector pair to be then fed into the`),ec=u(ml,!1),nc=h(ml," computation at every step. For auto-regressive decoding, the required memory bandwidth for the constant reloading can become a serious time bottleneck. By reducing the size of the key-value vectors less memory needs to be accessed, thus reducing the memory bandwidth bottleneck. For more detail, please have a look at "),Ms=p(ml,"A",{href:!0,rel:!0,"data-svelte-h":!0}),o(Ms)!=="svelte-cg4wmi"&&(Ms.textContent=mf),Eu=h(ml,"."),ml.forEach(a),lc=l(s),xs=p(s,"P",{});var Uc=M(xs);Yu=h(Uc,"The important part to understand here is that reducing the number of key-value attention heads to 1 only makes sense if a key-value cache is used. The peak memory consumption of the model for a single forward pass without key-value cache stays unchanged as every attention head still has a unique query vector so that each attention head still has a different"),ic=u(Uc,!1),pc=h(Uc," matrix."),Uc.forEach(a),mc=l(s),en=p(s,"P",{"data-svelte-h":!0}),o(en)!=="svelte-1q4ym7y"&&(en.textContent=of),oc=l(s),nn=p(s,"UL",{"data-svelte-h":!0}),o(nn)!=="svelte-c4p3y"&&(nn.innerHTML=rf),rc=l(s),ln=p(s,"P",{"data-svelte-h":!0}),o(ln)!=="svelte-fzvfyw"&&(ln.innerHTML=hf),hc=l(s),pn=p(s,"P",{"data-svelte-h":!0}),o(pn)!=="svelte-1w511t4"&&(pn.textContent=cf),cc=l(s),mn=p(s,"P",{"data-svelte-h":!0}),o(mn)!=="svelte-1vaiukl"&&(mn.innerHTML=uf),uc=l(s),on=p(s,"P",{"data-svelte-h":!0}),o(on)!=="svelte-1rn3bde"&&(on.innerHTML=df),dc=l(s),rn=p(s,"P",{"data-svelte-h":!0}),o(rn)!=="svelte-c4mo8y"&&(rn.innerHTML=gf),gc=l(s),hn=p(s,"BLOCKQUOTE",{"data-svelte-h":!0}),o(hn)!=="svelte-xhly52"&&(hn.innerHTML=yf),yc=l(s),g(cn.$$.fragment,s),fc=l(s),un=p(s,"P",{"data-svelte-h":!0}),o(un)!=="svelte-1r7m8vw"&&(un.innerHTML=ff),wc=l(s),dn=p(s,"P",{"data-svelte-h":!0}),o(dn)!=="svelte-2w30uj"&&(dn.innerHTML=wf),bc=l(s),g(gn.$$.fragment,s),vc=l(s),ol=p(s,"P",{}),M(ol).forEach(a),this.h()},h(){L(G,"name","hf:doc:metadata"),L(G,"content",ib),mi.a=oi,ri.a=hi,ci.a=ui,di.a=null,yi.a=null,Ai.a=Ei,Yi.a=Si,ip.a=pp,op.a=rp,hp.a=cp,up.a=dp,gp.a=yp,fp.a=wp,bp.a=vp,Mp.a=xp,kp.a=Tp,jp.a=_p,Jp.a=Up,zp.a=Lp,Gp.a=Bp,Zp.a=Ip,$p.a=Wp,Hp.a=Qp,Xp.a=Np,Ap.a=Ep,L(rs,"href","https://arxiv.org/abs/2205.14135"),L(rs,"rel","nofollow"),Sp.a=Fp,Pp.a=null,Dp.a=Op,sm.a=tm,am.a=em,nm.a=lm,om.a=rm,dm.a=gm,oo.a=ro,go.a=yo,fo.a=wo,L(hs,"href","https://arxiv.org/abs/1706.03762"),L(hs,"rel","nofollow"),Mo.a=xo,ko.a=To,jo.a=_o,Jo.a=Uo,Co.a=zo,L(cs,"href","https://arxiv.org/abs/1810.04805"),L(cs,"rel","nofollow"),Go.a=Bo,$o.a=Wo,L(ds,"href","https://arxiv.org/abs/2009.13658"),L(ds,"rel","nofollow"),L(gs,"href","https://arxiv.org/abs/2104.09864"),L(gs,"rel","nofollow"),Ho.a=Qo,Vo.a=qo,Eo.a=Yo,So.a=Fo,Po.a=Ko,Do.a=Oo,sr.a=tr,ar.a=er,nr.a=lr,ir.a=pr,or.a=rr,hr.a=cr,ur.a=dr,gr.a=yr,fr.a=wr,br.a=vr,Tr.a=jr,Lr.a=Gr,L(ys,"href","https://arxiv.org/abs/2108.12409"),L(ys,"rel","nofollow"),Br.a=Zr,L(fs,"href","https://github.com/huggingface/transformers/pull/24653"),L(fs,"rel","nofollow"),$r.a=Wr,Qr.a=Xr,Nr.a=Rr,Vr.a=qr,th.a=ah,eh.a=nh,lh.a=ih,ph.a=mh,oh.a=rh,fh.a=wh,bh.a=vh,Mh.a=xh,jh.a=_h,Nh.a=Rh,Vh.a=qh,Oh.a=sc,ec.a=nc,L(Ms,"href","https://arxiv.org/abs/1911.02150"),L(Ms,"rel","nofollow"),ic.a=pc},m(s,t){m(document.head,G),e(s,Us,t),e(s,P,t),e(s,yn,t),y(Cs,s,t),e(s,cl,t),y(zs,s,t),e(s,ul,t),e(s,Ls,t),e(s,dl,t),e(s,Gs,t),e(s,gl,t),e(s,Bs,t),e(s,yl,t),e(s,Zs,t),e(s,fl,t),e(s,Is,t),e(s,wl,t),e(s,$s,t),e(s,bl,t),y(Ws,s,t),e(s,vl,t),e(s,Hs,t),e(s,Ml,t),e(s,Qs,t),e(s,xl,t),e(s,Xs,t),e(s,kl,t),e(s,Ns,t),e(s,Tl,t),e(s,Rs,t),e(s,jl,t),e(s,Vs,t),e(s,_l,t),e(s,qs,t),e(s,Jl,t),e(s,As,t),e(s,Ul,t),e(s,Es,t),e(s,Cl,t),e(s,Ys,t),e(s,zl,t),e(s,Ss,t),e(s,Ll,t),e(s,Fs,t),e(s,Gl,t),y(Ps,s,t),e(s,Bl,t),y(Ks,s,t),e(s,Zl,t),e(s,Ds,t),e(s,Il,t),e(s,Os,t),e(s,$l,t),e(s,st,t),e(s,Wl,t),e(s,tt,t),e(s,Hl,t),y(at,s,t),e(s,Ql,t),y(et,s,t),e(s,Xl,t),e(s,nt,t),e(s,Nl,t),y(lt,s,t),e(s,Rl,t),e(s,it,t),e(s,Vl,t),y(pt,s,t),e(s,ql,t),e(s,mt,t),e(s,Al,t),y(ot,s,t),e(s,El,t),e(s,rt,t),e(s,Yl,t),y(ht,s,t),e(s,Sl,t),e(s,ct,t),e(s,Fl,t),e(s,ut,t),e(s,Pl,t),e(s,dt,t),e(s,Kl,t),e(s,gt,t),e(s,Dl,t),y(yt,s,t),e(s,Ol,t),e(s,ft,t),e(s,si,t),y(wt,s,t),e(s,ti,t),e(s,bt,t),e(s,ai,t),y(vt,s,t),e(s,ei,t),e(s,Mt,t),e(s,ni,t),e(s,xt,t),e(s,li,t),e(s,kt,t),e(s,ii,t),e(s,Tt,t),e(s,pi,t),e(s,B,t),m(B,zc),m(B,fn),m(B,Lc),mi.m(kf,B),m(B,oi),m(B,wn),m(B,Gc),ri.m(Tf,B),m(B,hi),ci.m(jf,B),m(B,ui),di.m(_f,B),e(s,gi,t),e(s,jt,t),m(jt,Bc),yi.m(Jf,jt),e(s,fi,t),e(s,_t,t),e(s,wi,t),e(s,Jt,t),e(s,bi,t),y(Ut,s,t),e(s,vi,t),e(s,Ct,t),e(s,Mi,t),y(zt,s,t),e(s,xi,t),e(s,Lt,t),e(s,ki,t),y(Gt,s,t),e(s,Ti,t),e(s,Bt,t),e(s,ji,t),y(Zt,s,t),e(s,_i,t),e(s,It,t),e(s,Ji,t),y($t,s,t),e(s,Ui,t),e(s,Wt,t),e(s,Ci,t),y(Ht,s,t),e(s,zi,t),e(s,Qt,t),e(s,Li,t),e(s,Xt,t),e(s,Gi,t),y(Nt,s,t),e(s,Bi,t),y(Rt,s,t),e(s,Zi,t),e(s,Vt,t),e(s,Ii,t),y(qt,s,t),e(s,$i,t),e(s,At,t),e(s,Wi,t),y(Et,s,t),e(s,Hi,t),e(s,Yt,t),e(s,Qi,t),y(St,s,t),e(s,Xi,t),e(s,Ft,t),e(s,Ni,t),y(Pt,s,t),e(s,Ri,t),e(s,Kt,t),e(s,Vi,t),e(s,Dt,t),e(s,qi,t),e(s,K,t),m(K,Zc),Ai.m(Uf,K),m(K,Ei),Yi.m(Cf,K),m(K,Si),e(s,Fi,t),y(Ot,s,t),e(s,Pi,t),y(sa,s,t),e(s,Ki,t),e(s,ta,t),e(s,Di,t),e(s,aa,t),e(s,Oi,t),e(s,ea,t),e(s,sp,t),e(s,na,t),e(s,tp,t),e(s,la,t),e(s,ap,t),e(s,ia,t),e(s,ep,t),y(pa,s,t),e(s,np,t),e(s,ma,t),e(s,lp,t),e(s,q,t),m(q,Ic),m(q,bn),m(q,$c),m(q,vn),m(q,Wc),ip.m(zf,q),m(q,pp),e(s,mp,t),e(s,T,t),m(T,Hc),op.m(Lf,T),m(T,rp),hp.m(Gf,T),m(T,cp),up.m(Bf,T),m(T,dp),gp.m(Zf,T),m(T,yp),fp.m(If,T),m(T,wp),bp.m($f,T),m(T,vp),Mp.m(Wf,T),m(T,xp),kp.m(Hf,T),m(T,Tp),jp.m(Qf,T),m(T,_p),Jp.m(Xf,T),m(T,Up),e(s,Cp,t),e(s,U,t),m(U,Qc),zp.m(Nf,U),m(U,Lp),Gp.m(Rf,U),m(U,Bp),Zp.m(Vf,U),m(U,Ip),$p.m(qf,U),m(U,Wp),Hp.m(Af,U),m(U,Qp),Xp.m(Ef,U),m(U,Np),e(s,Rp,t),e(s,oa,t),e(s,Vp,t),e(s,ra,t),e(s,qp,t),e(s,A,t),m(A,Xc),Ap.m(Yf,A),m(A,Ep),m(A,rs),m(A,Nc),m(A,Mn),m(A,Rc),e(s,Yp,t),e(s,is,t),m(is,Vc),Sp.m(Sf,is),m(is,Fp),Pp.m(Ff,is),e(s,Kp,t),e(s,W,t),m(W,qc),Dp.m(Pf,W),m(W,Op),sm.m(Kf,W),m(W,tm),am.m(Df,W),m(W,em),nm.m(Of,W),m(W,lm),e(s,im,t),e(s,ha,t),e(s,pm,t),e(s,ca,t),e(s,mm,t),e(s,xn,t),m(xn,ps),m(ps,Ac),m(ps,kn),m(ps,Ec),om.m(sw,ps),m(ps,rm),e(s,hm,t),e(s,ua,t),e(s,cm,t),e(s,da,t),e(s,um,t),e(s,D,t),m(D,Yc),m(D,Tn),m(D,Sc),dm.m(tw,D),m(D,gm),e(s,ym,t),e(s,ga,t),e(s,fm,t),e(s,ya,t),e(s,wm,t),e(s,fa,t),e(s,bm,t),y(wa,s,t),e(s,vm,t),e(s,ba,t),e(s,Mm,t),y(va,s,t),e(s,xm,t),e(s,Ma,t),e(s,km,t),y(xa,s,t),e(s,Tm,t),e(s,ka,t),e(s,jm,t),y(Ta,s,t),e(s,_m,t),e(s,ja,t),e(s,Jm,t),y(_a,s,t),e(s,Um,t),e(s,Ja,t),e(s,Cm,t),e(s,Ua,t),e(s,zm,t),e(s,Ca,t),e(s,Lm,t),y(za,s,t),e(s,Gm,t),e(s,La,t),e(s,Bm,t),y(Ga,s,t),e(s,Zm,t),e(s,Ba,t),e(s,Im,t),e(s,Za,t),e(s,$m,t),y(Ia,s,t),e(s,Wm,t),e(s,$a,t),e(s,Hm,t),y(Wa,s,t),e(s,Qm,t),e(s,Ha,t),e(s,Xm,t),y(Qa,s,t),e(s,Nm,t),e(s,Xa,t),e(s,Rm,t),y(Na,s,t),e(s,Vm,t),e(s,Ra,t),e(s,qm,t),e(s,Va,t),e(s,Am,t),y(qa,s,t),e(s,Em,t),e(s,Aa,t),e(s,Ym,t),y(Ea,s,t),e(s,Sm,t),e(s,Ya,t),e(s,Fm,t),e(s,Sa,t),e(s,Pm,t),y(Fa,s,t),e(s,Km,t),e(s,Pa,t),e(s,Dm,t),e(s,Ka,t),e(s,Om,t),e(s,Da,t),e(s,so,t),e(s,Oa,t),e(s,to,t),e(s,se,t),e(s,ao,t),e(s,te,t),e(s,eo,t),e(s,ae,t),e(s,no,t),e(s,ee,t),e(s,lo,t),e(s,ne,t),e(s,io,t),e(s,le,t),e(s,po,t),e(s,ie,t),e(s,mo,t),e(s,O,t),m(O,Fc),oo.m(aw,O),m(O,ro),m(O,jn),m(O,Pc),e(s,ho,t),e(s,pe,t),e(s,co,t),e(s,me,t),e(s,uo,t),e(s,I,t),m(I,Kc),go.m(ew,I),m(I,yo),fo.m(nw,I),m(I,wo),m(I,_n),m(I,Dc),m(I,Jn),m(I,Oc),m(I,Un),m(I,su),e(s,bo,t),e(s,oe,t),e(s,vo,t),e(s,C,t),m(C,tu),m(C,hs),m(C,au),Mo.m(lw,C),m(C,xo),ko.m(iw,C),m(C,To),jo.m(pw,C),m(C,_o),Jo.m(mw,C),m(C,Uo),Co.m(ow,C),m(C,zo),e(s,Lo,t),e(s,ss,t),m(ss,eu),m(ss,cs),m(ss,nu),Go.m(rw,ss),m(ss,Bo),e(s,Zo,t),e(s,re,t),e(s,Io,t),e(s,us,t),m(us,R),m(R,lu),m(R,Cn),m(R,iu),$o.m(hw,R),m(R,Wo),m(R,ds),m(R,pu),m(R,gs),m(R,mu),m(us,ou),m(us,he),m(he,ru),Ho.m(cw,he),m(he,Qo),e(s,Xo,t),e(s,ce,t),e(s,No,t),e(s,ue,t),e(s,Ro,t),e(s,E,t),m(E,hu),m(E,zn),m(E,cu),m(E,Ln),m(E,uu),Vo.m(uw,E),m(E,qo),e(s,Ao,t),e(s,k,t),m(k,du),m(k,Gn),m(k,gu),m(k,Bn),Eo.m(dw,k),m(k,Yo),So.m(gw,k),m(k,Fo),Po.m(yw,k),m(k,Ko),Do.m(fw,k),m(k,Oo),sr.m(ww,k),m(k,tr),ar.m(bw,k),m(k,er),nr.m(vw,k),m(k,lr),ir.m(Mw,k),m(k,pr),m(k,Zn),m(k,yu),e(s,mr,t),e(s,In,t),m(In,Z),m(Z,fu),or.m(xw,Z),m(Z,rr),hr.m(kw,Z),m(Z,cr),ur.m(Tw,Z),m(Z,dr),gr.m(jw,Z),m(Z,yr),fr.m(_w,Z),m(Z,wr),br.m(Jw,Z),m(Z,vr),e(s,Mr,t),e(s,de,t),e(s,xr,t),e(s,ge,t),e(s,kr,t),e(s,Y,t),m(Y,wu),m(Y,$n),m(Y,bu),m(Y,Wn),m(Y,vu),Tr.m(Uw,Y),m(Y,jr),e(s,_r,t),e(s,ye,t),e(s,Jr,t),e(s,fe,t),e(s,Ur,t),e(s,we,t),e(s,Cr,t),e(s,be,t),e(s,zr,t),e(s,x,t),m(x,Mu),m(x,Hn),m(x,xu),m(x,Qn),m(x,ku),m(x,Xn),m(x,Tu),m(x,Nn),m(x,ju),m(x,Rn),m(x,_u),Lr.m(Cw,x),m(x,Gr),m(x,Vn),m(x,Ju),m(x,ys),m(x,Uu),Br.m(zw,x),m(x,Zr),m(x,qn),m(x,Cu),m(x,fs),m(x,zu),e(s,Ir,t),e(s,ws,t),m(ws,An),m(ws,Lu),m(ws,ms),m(ms,ve),m(ve,Gu),$r.m(Lw,ve),m(ve,Wr),m(ms,Bu),m(ms,En),m(ms,Zu),m(ms,Yn),e(s,Hr,t),e(s,S,t),m(S,Iu),Qr.m(Gw,S),m(S,Xr),Nr.m(Bw,S),m(S,Rr),Vr.m(Zw,S),m(S,qr),e(s,Ar,t),e(s,Me,t),e(s,Er,t),e(s,xe,t),e(s,Yr,t),e(s,ke,t),e(s,Sr,t),e(s,Te,t),e(s,Fr,t),y(je,s,t),e(s,Pr,t),e(s,_e,t),e(s,Kr,t),y(Je,s,t),e(s,Dr,t),e(s,Ue,t),e(s,Or,t),e(s,Ce,t),e(s,sh,t),e(s,z,t),m(z,$u),m(z,Sn),m(z,Wu),th.m(Iw,z),m(z,ah),eh.m($w,z),m(z,nh),lh.m(Ww,z),m(z,ih),ph.m(Hw,z),m(z,mh),oh.m(Qw,z),m(z,rh),e(s,hh,t),e(s,ze,t),e(s,ch,t),y(Le,s,t),e(s,uh,t),e(s,Ge,t),e(s,dh,t),y(Be,s,t),e(s,gh,t),e(s,Ze,t),e(s,yh,t),e(s,Fn,t),m(Fn,V),m(V,Hu),fh.m(Xw,V),m(V,wh),bh.m(Nw,V),m(V,vh),Mh.m(Rw,V),m(V,xh),m(V,Pn),m(V,Qu),e(s,kh,t),e(s,Ie,t),e(s,Th,t),e(s,bs,t),m(bs,$e),m($e,Xu),jh.m(Vw,$e),m($e,_h),m(bs,Nu),m(bs,Kn),e(s,Jh,t),e(s,We,t),e(s,Uh,t),y(vs,s,t),e(s,Ch,t),e(s,He,t),e(s,zh,t),e(s,Qe,t),e(s,Lh,t),y(Xe,s,t),e(s,Gh,t),e(s,Ne,t),e(s,Bh,t),e(s,Re,t),e(s,Zh,t),e(s,Ve,t),e(s,Ih,t),e(s,qe,t),e(s,$h,t),e(s,Ae,t),e(s,Wh,t),y(Ee,s,t),e(s,Hh,t),e(s,Ye,t),e(s,Qh,t),y(Se,s,t),e(s,Xh,t),e(s,ts,t),m(ts,Ru),Nh.m(qw,ts),m(ts,Rh),Vh.m(Aw,ts),m(ts,qh),e(s,Ah,t),e(s,Fe,t),e(s,Eh,t),y(Pe,s,t),e(s,Yh,t),e(s,Ke,t),e(s,Sh,t),y(De,s,t),e(s,Fh,t),e(s,Oe,t),e(s,Ph,t),e(s,sn,t),e(s,Kh,t),e(s,tn,t),e(s,Dh,t),e(s,Dn,t),m(Dn,os),m(os,Vu),Oh.m(Ew,os),m(os,sc),m(os,On),m(os,qu),e(s,tc,t),e(s,an,t),e(s,ac,t),e(s,as,t),m(as,Au),ec.m(Yw,as),m(as,nc),m(as,Ms),m(as,Eu),e(s,lc,t),e(s,xs,t),m(xs,Yu),ic.m(Sw,xs),m(xs,pc),e(s,mc,t),e(s,en,t),e(s,oc,t),e(s,nn,t),e(s,rc,t),e(s,ln,t),e(s,hc,t),e(s,pn,t),e(s,cc,t),e(s,mn,t),e(s,uc,t),e(s,on,t),e(s,dc,t),e(s,rn,t),e(s,gc,t),e(s,hn,t),e(s,yc,t),y(cn,s,t),e(s,fc,t),e(s,un,t),e(s,wc,t),e(s,dn,t),e(s,bc,t),y(gn,s,t),e(s,vc,t),e(s,ol,t),Mc=!0},p(s,[t]){const $={};t&2&&($.$$scope={dirty:t,ctx:s}),vs.$set($)},i(s){Mc||(f(Cs.$$.fragment,s),f(zs.$$.fragment,s),f(Ws.$$.fragment,s),f(Ps.$$.fragment,s),f(Ks.$$.fragment,s),f(at.$$.fragment,s),f(et.$$.fragment,s),f(lt.$$.fragment,s),f(pt.$$.fragment,s),f(ot.$$.fragment,s),f(ht.$$.fragment,s),f(yt.$$.fragment,s),f(wt.$$.fragment,s),f(vt.$$.fragment,s),f(Ut.$$.fragment,s),f(zt.$$.fragment,s),f(Gt.$$.fragment,s),f(Zt.$$.fragment,s),f($t.$$.fragment,s),f(Ht.$$.fragment,s),f(Nt.$$.fragment,s),f(Rt.$$.fragment,s),f(qt.$$.fragment,s),f(Et.$$.fragment,s),f(St.$$.fragment,s),f(Pt.$$.fragment,s),f(Ot.$$.fragment,s),f(sa.$$.fragment,s),f(pa.$$.fragment,s),f(wa.$$.fragment,s),f(va.$$.fragment,s),f(xa.$$.fragment,s),f(Ta.$$.fragment,s),f(_a.$$.fragment,s),f(za.$$.fragment,s),f(Ga.$$.fragment,s),f(Ia.$$.fragment,s),f(Wa.$$.fragment,s),f(Qa.$$.fragment,s),f(Na.$$.fragment,s),f(qa.$$.fragment,s),f(Ea.$$.fragment,s),f(Fa.$$.fragment,s),f(je.$$.fragment,s),f(Je.$$.fragment,s),f(Le.$$.fragment,s),f(Be.$$.fragment,s),f(vs.$$.fragment,s),f(Xe.$$.fragment,s),f(Ee.$$.fragment,s),f(Se.$$.fragment,s),f(Pe.$$.fragment,s),f(De.$$.fragment,s),f(cn.$$.fragment,s),f(gn.$$.fragment,s),Mc=!0)},o(s){w(Cs.$$.fragment,s),w(zs.$$.fragment,s),w(Ws.$$.fragment,s),w(Ps.$$.fragment,s),w(Ks.$$.fragment,s),w(at.$$.fragment,s),w(et.$$.fragment,s),w(lt.$$.fragment,s),w(pt.$$.fragment,s),w(ot.$$.fragment,s),w(ht.$$.fragment,s),w(yt.$$.fragment,s),w(wt.$$.fragment,s),w(vt.$$.fragment,s),w(Ut.$$.fragment,s),w(zt.$$.fragment,s),w(Gt.$$.fragment,s),w(Zt.$$.fragment,s),w($t.$$.fragment,s),w(Ht.$$.fragment,s),w(Nt.$$.fragment,s),w(Rt.$$.fragment,s),w(qt.$$.fragment,s),w(Et.$$.fragment,s),w(St.$$.fragment,s),w(Pt.$$.fragment,s),w(Ot.$$.fragment,s),w(sa.$$.fragment,s),w(pa.$$.fragment,s),w(wa.$$.fragment,s),w(va.$$.fragment,s),w(xa.$$.fragment,s),w(Ta.$$.fragment,s),w(_a.$$.fragment,s),w(za.$$.fragment,s),w(Ga.$$.fragment,s),w(Ia.$$.fragment,s),w(Wa.$$.fragment,s),w(Qa.$$.fragment,s),w(Na.$$.fragment,s),w(qa.$$.fragment,s),w(Ea.$$.fragment,s),w(Fa.$$.fragment,s),w(je.$$.fragment,s),w(Je.$$.fragment,s),w(Le.$$.fragment,s),w(Be.$$.fragment,s),w(vs.$$.fragment,s),w(Xe.$$.fragment,s),w(Ee.$$.fragment,s),w(Se.$$.fragment,s),w(Pe.$$.fragment,s),w(De.$$.fragment,s),w(cn.$$.fragment,s),w(gn.$$.fragment,s),Mc=!1},d(s){s&&(a(Us),a(P),a(yn),a(cl),a(ul),a(Ls),a(dl),a(Gs),a(gl),a(Bs),a(yl),a(Zs),a(fl),a(Is),a(wl),a($s),a(bl),a(vl),a(Hs),a(Ml),a(Qs),a(xl),a(Xs),a(kl),a(Ns),a(Tl),a(Rs),a(jl),a(Vs),a(_l),a(qs),a(Jl),a(As),a(Ul),a(Es),a(Cl),a(Ys),a(zl),a(Ss),a(Ll),a(Fs),a(Gl),a(Bl),a(Zl),a(Ds),a(Il),a(Os),a($l),a(st),a(Wl),a(tt),a(Hl),a(Ql),a(Xl),a(nt),a(Nl),a(Rl),a(it),a(Vl),a(ql),a(mt),a(Al),a(El),a(rt),a(Yl),a(Sl),a(ct),a(Fl),a(ut),a(Pl),a(dt),a(Kl),a(gt),a(Dl),a(Ol),a(ft),a(si),a(ti),a(bt),a(ai),a(ei),a(Mt),a(ni),a(xt),a(li),a(kt),a(ii),a(Tt),a(pi),a(B),a(gi),a(jt),a(fi),a(_t),a(wi),a(Jt),a(bi),a(vi),a(Ct),a(Mi),a(xi),a(Lt),a(ki),a(Ti),a(Bt),a(ji),a(_i),a(It),a(Ji),a(Ui),a(Wt),a(Ci),a(zi),a(Qt),a(Li),a(Xt),a(Gi),a(Bi),a(Zi),a(Vt),a(Ii),a($i),a(At),a(Wi),a(Hi),a(Yt),a(Qi),a(Xi),a(Ft),a(Ni),a(Ri),a(Kt),a(Vi),a(Dt),a(qi),a(K),a(Fi),a(Pi),a(Ki),a(ta),a(Di),a(aa),a(Oi),a(ea),a(sp),a(na),a(tp),a(la),a(ap),a(ia),a(ep),a(np),a(ma),a(lp),a(q),a(mp),a(T),a(Cp),a(U),a(Rp),a(oa),a(Vp),a(ra),a(qp),a(A),a(Yp),a(is),a(Kp),a(W),a(im),a(ha),a(pm),a(ca),a(mm),a(xn),a(hm),a(ua),a(cm),a(da),a(um),a(D),a(ym),a(ga),a(fm),a(ya),a(wm),a(fa),a(bm),a(vm),a(ba),a(Mm),a(xm),a(Ma),a(km),a(Tm),a(ka),a(jm),a(_m),a(ja),a(Jm),a(Um),a(Ja),a(Cm),a(Ua),a(zm),a(Ca),a(Lm),a(Gm),a(La),a(Bm),a(Zm),a(Ba),a(Im),a(Za),a($m),a(Wm),a($a),a(Hm),a(Qm),a(Ha),a(Xm),a(Nm),a(Xa),a(Rm),a(Vm),a(Ra),a(qm),a(Va),a(Am),a(Em),a(Aa),a(Ym),a(Sm),a(Ya),a(Fm),a(Sa),a(Pm),a(Km),a(Pa),a(Dm),a(Ka),a(Om),a(Da),a(so),a(Oa),a(to),a(se),a(ao),a(te),a(eo),a(ae),a(no),a(ee),a(lo),a(ne),a(io),a(le),a(po),a(ie),a(mo),a(O),a(ho),a(pe),a(co),a(me),a(uo),a(I),a(bo),a(oe),a(vo),a(C),a(Lo),a(ss),a(Zo),a(re),a(Io),a(us),a(Xo),a(ce),a(No),a(ue),a(Ro),a(E),a(Ao),a(k),a(mr),a(In),a(Mr),a(de),a(xr),a(ge),a(kr),a(Y),a(_r),a(ye),a(Jr),a(fe),a(Ur),a(we),a(Cr),a(be),a(zr),a(x),a(Ir),a(ws),a(Hr),a(S),a(Ar),a(Me),a(Er),a(xe),a(Yr),a(ke),a(Sr),a(Te),a(Fr),a(Pr),a(_e),a(Kr),a(Dr),a(Ue),a(Or),a(Ce),a(sh),a(z),a(hh),a(ze),a(ch),a(uh),a(Ge),a(dh),a(gh),a(Ze),a(yh),a(Fn),a(kh),a(Ie),a(Th),a(bs),a(Jh),a(We),a(Uh),a(Ch),a(He),a(zh),a(Qe),a(Lh),a(Gh),a(Ne),a(Bh),a(Re),a(Zh),a(Ve),a(Ih),a(qe),a($h),a(Ae),a(Wh),a(Hh),a(Ye),a(Qh),a(Xh),a(ts),a(Ah),a(Fe),a(Eh),a(Yh),a(Ke),a(Sh),a(Fh),a(Oe),a(Ph),a(sn),a(Kh),a(tn),a(Dh),a(Dn),a(tc),a(an),a(ac),a(as),a(lc),a(xs),a(mc),a(en),a(oc),a(nn),a(rc),a(ln),a(hc),a(pn),a(cc),a(mn),a(uc),a(on),a(dc),a(rn),a(gc),a(hn),a(yc),a(fc),a(un),a(wc),a(dn),a(bc),a(vc),a(ol)),a(G),b(Cs,s),b(zs,s),b(Ws,s),b(Ps,s),b(Ks,s),b(at,s),b(et,s),b(lt,s),b(pt,s),b(ot,s),b(ht,s),b(yt,s),b(wt,s),b(vt,s),b(Ut,s),b(zt,s),b(Gt,s),b(Zt,s),b($t,s),b(Ht,s),b(Nt,s),b(Rt,s),b(qt,s),b(Et,s),b(St,s),b(Pt,s),b(Ot,s),b(sa,s),b(pa,s),b(wa,s),b(va,s),b(xa,s),b(Ta,s),b(_a,s),b(za,s),b(Ga,s),b(Ia,s),b(Wa,s),b(Qa,s),b(Na,s),b(qa,s),b(Ea,s),b(Fa,s),b(je,s),b(Je,s),b(Le,s),b(Be,s),b(vs,s),b(Xe,s),b(Ee,s),b(Se,s),b(Pe,s),b(De,s),b(cn,s),b(gn,s)}}}const ib='{"title":"Optimizing LLMs for Speed and Memory","local":"optimizing-llms-for-speed-and-memory","sections":[{"title":"1. Lower Precision","local":"1-lower-precision","sections":[],"depth":2},{"title":"2. Flash Attention","local":"2-flash-attention","sections":[],"depth":2},{"title":"Conclusion","local":"conclusion","sections":[],"depth":2}],"depth":1}';function pb(hl){return Pw(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class db extends Dw{constructor(G){super(),Ow(this,G,pb,lb,Fw,{})}}export{db as component};
