import{s as Ja,n as Ua,o as Fa}from"../chunks/scheduler.d627b047.js";import{S as La,i as Za,g as l,s as n,r as p,A as Ia,h as i,f as t,c as o,j as b,u as g,x as m,k as v,y as r,a as s,v as _,d as u,t as f,w as h}from"../chunks/index.73c51727.js";import{D as y}from"../chunks/Docstring.488b7ad2.js";import{C as Ot}from"../chunks/CodeBlock.b1cdc5f6.js";import{H as L,E as za}from"../chunks/EditOnGithub.859b9ebc.js";function Ha(ta){let x,Ve,Pe,We,Z,De,I,aa='<a href="https://huggingface.co/models?other=bco,trl" rel="nofollow"><img src="https://img.shields.io/badge/All_models-BCO-blue"/></a>',Ge,z,na=`TRL supports the Binary Classifier Optimization (BCO).
The <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> authors train a binary classifier whose logit serves as a reward so that the classifier maps {prompt, chosen completion} pairs to 1 and {prompt, rejected completion} pairs to 0.
For a full example have a look at  <code>examples/scripts/bco.py</code>.`,Xe,H,Re,j,oa=`The <a href="/docs/trl/v0.15.1/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> requires an <a href="dataset_formats#unpaired-preference">unpaired preference dataset</a>.
The <a href="/docs/trl/v0.15.1/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a> supports both <a href="dataset_formats#conversational">conversational</a> and <a href="dataset_formats#standard">standard</a> dataset format. When provided with a conversational dataset, the trainer will automatically apply the chat template to the dataset.`,Ae,P,Se,E,ra="The BCO trainer expects a model of <code>AutoModelForCausalLM</code>, compared to PPO that expects <code>AutoModelForCausalLMWithValueHead</code> for the value function.",Qe,V,qe,W,la="For a detailed example have a look at the <code>examples/scripts/bco.py</code> script. At a high level we need to initialize the <code>BCOTrainer</code> with a <code>model</code> we wish to train and a reference <code>ref_model</code> which we will use to calculate the implicit rewards of the preferred and rejected response.",Ye,D,ia="The <code>beta</code> refers to the hyperparameter of the implicit reward, and the dataset contains the 3 entries listed above. Note that the <code>model</code> and <code>ref_model</code> need to have the same architecture (ie decoder only or encoder-decoder).",Ke,G,et,X,sa="After this one can then call:",tt,R,at,A,nt,S,da=`In practical scenarios, the thumbs-up and thumbs-down datasets are likely to have divergent underlying distributions of prompts.
Consider an LLM deployed for user feedback: if the model excels in writing tasks but underperforms in coding, the thumbs-up dataset will be dominated by writing-related prompts, while the thumbs-down dataset will contain mostly coding-related prompts.<br/>
If the prompts in your desired and undesired datasets differ a lot, it is useful to enable UDM.`,ot,Q,ma="Choose an embedding model and tokenizer:",rt,q,lt,Y,ca="Set <code>prompt_sample_size</code> to define how many prompts are selected to train the UDM classifier and start the training with the provided embedding function:",it,K,st,ee,dt,te,pa=`MOEs are the most efficient if the load is about equally distributed between experts.<br/>
To ensure that we train MOEs similarly during preference-tuning, it is beneficial to add the auxiliary loss from the load balancer to the final loss.`,mt,ae,ga=`This option is enabled by setting <code>output_router_logits=True</code> in the model config (e.g. MixtralConfig).<br/>
To scale how much the auxiliary loss contributes to the total loss, use the hyperparameter <code>router_aux_loss_coef=...</code> (default: 0.001).`,ct,ne,pt,d,oe,Mt,ve,_a='Initialize BCOTrainer from <a href="https://huggingface.co/papers/2404.04656" rel="nofollow">BCO</a> paper.',Nt,O,re,Bt,ye,ua="Compute the BCO loss for a batch of policy and reference model log probabilities.",kt,M,le,Jt,Te,fa="Computes log probabilities of the reference model for a single padded batch of a BCO specific dataset.",Ut,N,ie,Ft,Ce,ha="Creates a draft of a model card using the information available to the <code>Trainer</code>.",Lt,C,se,Zt,$e,ba=`Overriding built-in evaluation loop to store metrics for each batch.
Prediction/evaluation loop, shared by <code>Trainer.evaluate()</code> and <code>Trainer.predict()</code>.`,It,we,va="Works both with or without labels.",zt,B,de,Ht,xe,ya="Generate samples from the model and reference model for the given batch of inputs.",jt,k,me,Pt,Oe,Ta="Compute the log probabilities of the given labels under the given logits.",Et,J,ce,Vt,Me,Ca="Compute the BCO loss and other metrics for the given batch of inputs for train or test.",Wt,$,pe,Dt,Ne,$a="Returns the evaluation <code>~torch.utils.data.DataLoader</code>.",Gt,Be,wa="Subclass of transformers.src.transformers.trainer.get_eval_dataloader to precompute <code>ref_log_probs</code>.",Xt,w,ge,Rt,ke,xa="Returns the training <code>~torch.utils.data.DataLoader</code>.",At,Je,Oa="Subclass of transformers.src.transformers.trainer.get_train_dataloader to precompute <code>ref_log_probs</code>.",St,U,_e,Qt,Ue,Ma="Log <code>logs</code> on the various objects watching training, including stored metrics.",qt,F,ue,Yt,Fe,Na="Context manager for handling null reference model (that is, peft adapter manipulation).",gt,fe,_t,T,he,Kt,Le,Ba='Configuration class for the <a href="/docs/trl/v0.15.1/en/bco_trainer#trl.BCOTrainer">BCOTrainer</a>.',ea,Ze,ka=`Using <a href="https://huggingface.co/docs/transformers/v4.49.0/en/internal/trainer_utils#transformers.HfArgumentParser" rel="nofollow">HfArgumentParser</a> we can turn this class into
<a href="https://docs.python.org/3/library/argparse#module-argparse" rel="nofollow">argparse</a> arguments that can be specified on the
command line.`,ut,be,ft,Ee,ht;return Z=new L({props:{title:"BCO Trainer",local:"bco-trainer",headingTag:"h1"}}),H=new L({props:{title:"Expected dataset type",local:"expected-dataset-type",headingTag:"h2"}}),P=new L({props:{title:"Expected model format",local:"expected-model-format",headingTag:"h2"}}),V=new L({props:{title:"Using the BCOTrainer",local:"using-the-bcotrainer",headingTag:"h2"}}),G=new Ot({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBKQ==",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    processing_class=tokenizer,
)`,wrap:!1}}),R=new Ot({props:{code:"YmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:"bco_trainer.train()",wrap:!1}}),A=new L({props:{title:"Underlying Distribution matching (UDM)",local:"underlying-distribution-matching-udm",headingTag:"h2"}}),q=new Ot({props:{code:"ZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQXV0b01vZGVsLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQWVtYmVkZGluZ190b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCh5b3VyX21vZGVsX2lkKSUwQSUwQSUyMyUyMGN1c3RvbWl6ZSUyMHRoaXMlMjBmdW5jdGlvbiUyMGRlcGVuZGluZyUyMG9uJTIweW91ciUyMGVtYmVkZGluZyUyMG1vZGVsJTBBZGVmJTIwZW1iZWRfcHJvbXB0KGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwbW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUyMCUzRCUyMG1vZGVsKGlucHV0X2lkcyUzRGlucHV0X2lkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTNEYXR0ZW50aW9uX21hc2spJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwb3V0cHV0cy5sYXN0X2hpZGRlbl9zdGF0ZS5tZWFuKGRpbSUzRDEpJTBBJTBBZW1iZWRkaW5nX21vZGVsJTIwJTNEJTIwQWNjZWxlcmF0b3IoKS5wcmVwYXJlX21vZGVsKHNlbGYuZW1iZWRkaW5nX21vZGVsKSUwQWVtYmVkZGluZ19mdW5jJTIwJTNEJTIwcGFydGlhbChlbWJlZF9wcm9tcHQlMkMlMjBtb2RlbCUzRGVtYmVkZGluZ19tb2RlbCk=",highlighted:`embedding_model = AutoModel.from_pretrained(your_model_id)
embedding_tokenizer = AutoTokenizer.from_pretrained(your_model_id)

<span class="hljs-comment"># customize this function depending on your embedding model</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">embed_prompt</span>(<span class="hljs-params">input_ids, attention_mask, model</span>):
    outputs = model(input_ids=input_ids, attention_mask=attention_mask)
    <span class="hljs-keyword">return</span> outputs.last_hidden_state.mean(dim=<span class="hljs-number">1</span>)

embedding_model = Accelerator().prepare_model(self.embedding_model)
embedding_func = partial(embed_prompt, model=embedding_model)`,wrap:!1}}),K=new Ot({props:{code:"dHJhaW5pbmdfYXJncyUyMCUzRCUyMEJDT0NvbmZpZyglMEElMjAlMjAlMjAlMjBiZXRhJTNEMC4xJTJDJTBBJTIwJTIwJTIwJTIwcHJvbXB0X3NhbXBsZV9zaXplJTNENTEyJTJDJTBBKSUwQSUwQWJjb190cmFpbmVyJTIwJTNEJTIwQkNPVHJhaW5lciglMEElMjAlMjAlMjAlMjBtb2RlbCUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsX3JlZiUyQyUwQSUyMCUyMCUyMCUyMGFyZ3MlM0R0cmFpbmluZ19hcmdzJTJDJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YXNldCUzRHRyYWluX2RhdGFzZXQlMkMlMEElMjAlMjAlMjAlMjBwcm9jZXNzaW5nX2NsYXNzJTNEdG9rZW5pemVyJTJDJTBBJTIwJTIwJTIwJTIwZW1iZWRkaW5nX2Z1bmMlM0RlbWJlZGRpbmdfZnVuYyUyQyUwQSUyMCUyMCUyMCUyMGVtYmVkZGluZ190b2tlbml6ZXIlM0RzZWxmLmVtYmVkZGluZ190b2tlbml6ZXIlMkMlMEEpJTBBJTBBYmNvX3RyYWluZXIudHJhaW4oKQ==",highlighted:`training_args = BCOConfig(
    beta=<span class="hljs-number">0.1</span>,
    prompt_sample_size=<span class="hljs-number">512</span>,
)

bco_trainer = BCOTrainer(
    model,
    model_ref,
    args=training_args,
    train_dataset=train_dataset,
    processing_class=tokenizer,
    embedding_func=embedding_func,
    embedding_tokenizer=self.embedding_tokenizer,
)

bco_trainer.train()`,wrap:!1}}),ee=new L({props:{title:"For Mixture of Experts Models: Enabling the auxiliary loss",local:"for-mixture-of-experts-models-enabling-the-auxiliary-loss",headingTag:"h3"}}),ne=new L({props:{title:"BCOTrainer",local:"trl.BCOTrainer",headingTag:"h2"}}),oe=new y({props:{name:"class trl.BCOTrainer",anchor:"trl.BCOTrainer",parameters:[{name:"model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str] = None"},{name:"ref_model",val:": typing.Union[transformers.modeling_utils.PreTrainedModel, torch.nn.modules.module.Module, str, NoneType] = None"},{name:"args",val:": BCOConfig = None"},{name:"train_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"},{name:"eval_dataset",val:": typing.Union[datasets.arrow_dataset.Dataset, dict[str, datasets.arrow_dataset.Dataset], NoneType] = None"},{name:"processing_class",val:": typing.Union[transformers.tokenization_utils_base.PreTrainedTokenizerBase, transformers.image_processing_utils.BaseImageProcessor, transformers.feature_extraction_utils.FeatureExtractionMixin, transformers.processing_utils.ProcessorMixin, NoneType] = None"},{name:"data_collator",val:": typing.Optional[transformers.data.data_collator.DataCollator] = None"},{name:"model_init",val:": typing.Optional[typing.Callable[[], transformers.modeling_utils.PreTrainedModel]] = None"},{name:"callbacks",val:": typing.Optional[list[transformers.trainer_callback.TrainerCallback]] = None"},{name:"optimizers",val:": tuple = (None, None)"},{name:"preprocess_logits_for_metrics",val:": typing.Optional[typing.Callable[[torch.Tensor, torch.Tensor], torch.Tensor]] = None"},{name:"peft_config",val:": typing.Optional[dict] = None"},{name:"compute_metrics",val:": typing.Optional[typing.Callable[[transformers.trainer_utils.EvalLoopOutput], dict]] = None"},{name:"model_adapter_name",val:": typing.Optional[str] = None"},{name:"ref_adapter_name",val:": typing.Optional[str] = None"},{name:"embedding_func",val:": typing.Optional[typing.Callable] = None"},{name:"embedding_tokenizer",val:": typing.Optional[transformers.tokenization_utils_base.PreTrainedTokenizerBase] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.model",description:`<strong>model</strong> (<code>transformers.PreTrainedModel</code>) &#x2014;
The model to train, preferably an <code>AutoModelForSequenceClassification</code>.`,name:"model"},{anchor:"trl.BCOTrainer.ref_model",description:`<strong>ref_model</strong> (<code>PreTrainedModelWrapper</code>) &#x2014;
Hugging Face transformer model with a casual language modelling head. Used for implicit reward computation and loss. If no
reference model is provided, the trainer will create a reference model with the same architecture as the model to be optimized.`,name:"ref_model"},{anchor:"trl.BCOTrainer.args",description:`<strong>args</strong> (<code>BCOConfig</code>) &#x2014;
The arguments to use for training.`,name:"args"},{anchor:"trl.BCOTrainer.train_dataset",description:`<strong>train_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for training.`,name:"train_dataset"},{anchor:"trl.BCOTrainer.eval_dataset",description:`<strong>eval_dataset</strong> (<code>datasets.Dataset</code>) &#x2014;
The dataset to use for evaluation.`,name:"eval_dataset"},{anchor:"trl.BCOTrainer.processing_class",description:`<strong>processing_class</strong> (<code>PreTrainedTokenizerBase</code> or <code>BaseImageProcessor</code> or <code>FeatureExtractionMixin</code> or <code>ProcessorMixin</code>, <em>optional</em>) &#x2014;
Processing class used to process the data. If provided, will be used to automatically process the inputs
for the model, and it will be saved along the model to make it easier to rerun an interrupted training or
reuse the fine-tuned model.`,name:"processing_class"},{anchor:"trl.BCOTrainer.data_collator",description:`<strong>data_collator</strong> (<code>transformers.DataCollator</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The data collator to use for training. If None is specified, the default data collator (<code>DPODataCollatorWithPadding</code>) will be used
which will pad the sequences to the maximum length of the sequences in the batch, given a dataset of paired sequences.`,name:"data_collator"},{anchor:"trl.BCOTrainer.model_init",description:`<strong>model_init</strong> (<code>Callable[[], transformers.PreTrainedModel]</code>) &#x2014;
The model initializer to use for training. If None is specified, the default model initializer will be used.`,name:"model_init"},{anchor:"trl.BCOTrainer.callbacks",description:`<strong>callbacks</strong> (<code>list[transformers.TrainerCallback]</code>) &#x2014;
The callbacks to use for training.`,name:"callbacks"},{anchor:"trl.BCOTrainer.optimizers",description:`<strong>optimizers</strong> (<code>tuple[torch.optim.Optimizer, torch.optim.lr_scheduler.LambdaLR]</code>) &#x2014;
The optimizer and scheduler to use for training.`,name:"optimizers"},{anchor:"trl.BCOTrainer.preprocess_logits_for_metrics",description:`<strong>preprocess_logits_for_metrics</strong> (<code>Callable[[torch.Tensor, torch.Tensor], torch.Tensor]</code>) &#x2014;
The function to use to preprocess the logits before computing the metrics.`,name:"preprocess_logits_for_metrics"},{anchor:"trl.BCOTrainer.peft_config",description:`<strong>peft_config</strong> (<code>dict</code>, defaults to <code>None</code>) &#x2014;
The PEFT configuration to use for training. If you pass a PEFT configuration, the model will be wrapped in a PEFT model.`,name:"peft_config"},{anchor:"trl.BCOTrainer.compute_metrics",description:`<strong>compute_metrics</strong> (<code>Callable[[EvalPrediction], dict]</code>, <em>optional</em>) &#x2014;
The function to use to compute the metrics. Must take a <code>EvalPrediction</code> and return
a dictionary string to metric values.`,name:"compute_metrics"},{anchor:"trl.BCOTrainer.model_adapter_name",description:`<strong>model_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the train target PEFT adapter, when using LoRA with multiple adapters.`,name:"model_adapter_name"},{anchor:"trl.BCOTrainer.ref_adapter_name",description:`<strong>ref_adapter_name</strong> (<code>str</code>, defaults to <code>None</code>) &#x2014;
Name of the reference PEFT adapter, when using LoRA with multiple adapters.`,name:"ref_adapter_name"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L283"}}),re=new y({props:{name:"bco_loss",anchor:"trl.BCOTrainer.bco_loss",parameters:[{name:"policy_chosen_logps",val:": FloatTensor"},{name:"policy_rejected_logps",val:": FloatTensor"},{name:"reference_chosen_logps",val:": FloatTensor"},{name:"reference_rejected_logps",val:": FloatTensor"},{name:"chosen_embeddings",val:": typing.Optional[torch.FloatTensor]"},{name:"rejected_embeddings",val:": typing.Optional[torch.FloatTensor]"}],parametersDescription:[{anchor:"trl.BCOTrainer.bco_loss.policy_chosen_logps",description:"<strong>policy_chosen_logps</strong> &#x2014; Log probabilities of the policy model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"policy_chosen_logps"},{anchor:"trl.BCOTrainer.bco_loss.policy_rejected_logps",description:"<strong>policy_rejected_logps</strong> &#x2014; Log probabilities of the policy model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"policy_rejected_logps"},{anchor:"trl.BCOTrainer.bco_loss.reference_chosen_logps",description:"<strong>reference_chosen_logps</strong> &#x2014; Log probabilities of the reference model for the chosen responses. Shape: (num(chosen) in batch_size,)",name:"reference_chosen_logps"},{anchor:"trl.BCOTrainer.bco_loss.reference_rejected_logps",description:"<strong>reference_rejected_logps</strong> &#x2014; Log probabilities of the reference model for the rejected responses. Shape: (num(rejected) in batch_size,)",name:"reference_rejected_logps"},{anchor:"trl.BCOTrainer.bco_loss.chosen_embeddings",description:"<strong>chosen_embeddings</strong> &#x2014; embeddings of desirable prompts",name:"chosen_embeddings"},{anchor:"trl.BCOTrainer.bco_loss.rejected_embeddings",description:"<strong>rejected_embeddings</strong> &#x2014; embeddings of undesirable prompts",name:"rejected_embeddings"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1133",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>(losses, chosen_rewards, rejected_rewards, delta).
The losses tensor contains the BCO loss for each example in the batch.
The chosen_rewards and rejected_rewards tensors contain the rewards for the chosen and rejected responses, respectively.
The delta value contains the moving average of all implicit rewards.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tuple of four tensors</p>
`}}),le=new y({props:{name:"compute_reference_log_probs",anchor:"trl.BCOTrainer.compute_reference_log_probs",parameters:[{name:"padded_batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L992"}}),ie=new y({props:{name:"create_model_card",anchor:"trl.BCOTrainer.create_model_card",parameters:[{name:"model_name",val:": typing.Optional[str] = None"},{name:"dataset_name",val:": typing.Optional[str] = None"},{name:"tags",val:": typing.Union[str, list[str], NoneType] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.create_model_card.model_name",description:`<strong>model_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the model.`,name:"model_name"},{anchor:"trl.BCOTrainer.create_model_card.dataset_name",description:`<strong>dataset_name</strong> (<code>str</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Name of the dataset used for training.`,name:"dataset_name"},{anchor:"trl.BCOTrainer.create_model_card.tags",description:`<strong>tags</strong> (<code>str</code>, <code>list[str]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Tags to be associated with the model card.`,name:"tags"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1494"}}),se=new y({props:{name:"evaluation_loop",anchor:"trl.BCOTrainer.evaluation_loop",parameters:[{name:"dataloader",val:": DataLoader"},{name:"description",val:": str"},{name:"prediction_loss_only",val:": typing.Optional[bool] = None"},{name:"ignore_keys",val:": typing.Optional[list[str]] = None"},{name:"metric_key_prefix",val:": str = 'eval'"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1398"}}),de=new y({props:{name:"generate_from_model_and_ref",anchor:"trl.BCOTrainer.generate_from_model_and_ref",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1318"}}),me=new y({props:{name:"get_batch_logps",anchor:"trl.BCOTrainer.get_batch_logps",parameters:[{name:"logits",val:": FloatTensor"},{name:"labels",val:": LongTensor"},{name:"average_log_prob",val:": bool = False"},{name:"label_pad_token_id",val:": int = -100"},{name:"is_encoder_decoder",val:": bool = False"}],parametersDescription:[{anchor:"trl.BCOTrainer.get_batch_logps.logits",description:"<strong>logits</strong> &#x2014; Logits of the model (unnormalized). Shape: (batch_size, sequence_length, vocab_size)",name:"logits"},{anchor:"trl.BCOTrainer.get_batch_logps.labels",description:"<strong>labels</strong> &#x2014; Labels for which to compute the log probabilities. Label tokens with a value of label_pad_token_id are ignored. Shape: (batch_size, sequence_length)",name:"labels"},{anchor:"trl.BCOTrainer.get_batch_logps.average_log_prob",description:"<strong>average_log_prob</strong> &#x2014; If True, return the average log probability per (non-masked) token. Otherwise, return the sum of the log probabilities of the (non-masked) tokens.",name:"average_log_prob"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1035",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A tensor of shape (batch_size,) containing the average/sum log probabilities of the given labels under the given logits.</p>
`}}),ce=new y({props:{name:"get_batch_loss_metrics",anchor:"trl.BCOTrainer.get_batch_loss_metrics",parameters:[{name:"model",val:""},{name:"batch",val:": dict"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1195"}}),pe=new y({props:{name:"get_eval_dataloader",anchor:"trl.BCOTrainer.get_eval_dataloader",parameters:[{name:"eval_dataset",val:": typing.Optional[datasets.arrow_dataset.Dataset] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.get_eval_dataloader.eval_dataset",description:`<strong>eval_dataset</strong> (<code>torch.utils.data.Dataset</code>, <em>optional</em>) &#x2014;
If provided, will override <code>self.eval_dataset</code>. If it is a <a href="https://huggingface.co/docs/datasets/v3.3.1/en/package_reference/main_classes#datasets.Dataset" rel="nofollow">Dataset</a>, columns not accepted
by the <code>model.forward()</code> method are automatically removed. It must implement <code>__len__</code>.`,name:"eval_dataset"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L946"}}),ge=new y({props:{name:"get_train_dataloader",anchor:"trl.BCOTrainer.get_train_dataloader",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L912"}}),_e=new y({props:{name:"log",anchor:"trl.BCOTrainer.log",parameters:[{name:"logs",val:": dict"},{name:"start_time",val:": typing.Optional[float] = None"}],parametersDescription:[{anchor:"trl.BCOTrainer.log.logs",description:`<strong>logs</strong> (<code>dict[str, float]</code>) &#x2014;
The values to log.`,name:"logs"},{anchor:"trl.BCOTrainer.log.start_time",description:`<strong>start_time</strong> (<code>float</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Start time of the training.`,name:"start_time"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L1455"}}),ue=new y({props:{name:"null_ref_context",anchor:"trl.BCOTrainer.null_ref_context",parameters:[],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_trainer.py#L898"}}),fe=new L({props:{title:"BCOConfig",local:"trl.BCOConfig",headingTag:"h2"}}),he=new y({props:{name:"class trl.BCOConfig",anchor:"trl.BCOConfig",parameters:[{name:"output_dir",val:": str"},{name:"overwrite_output_dir",val:": bool = False"},{name:"do_train",val:": bool = False"},{name:"do_eval",val:": bool = False"},{name:"do_predict",val:": bool = False"},{name:"eval_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'no'"},{name:"prediction_loss_only",val:": bool = False"},{name:"per_device_train_batch_size",val:": int = 8"},{name:"per_device_eval_batch_size",val:": int = 8"},{name:"per_gpu_train_batch_size",val:": typing.Optional[int] = None"},{name:"per_gpu_eval_batch_size",val:": typing.Optional[int] = None"},{name:"gradient_accumulation_steps",val:": int = 1"},{name:"eval_accumulation_steps",val:": typing.Optional[int] = None"},{name:"eval_delay",val:": typing.Optional[float] = 0"},{name:"torch_empty_cache_steps",val:": typing.Optional[int] = None"},{name:"learning_rate",val:": float = 5e-05"},{name:"weight_decay",val:": float = 0.0"},{name:"adam_beta1",val:": float = 0.9"},{name:"adam_beta2",val:": float = 0.999"},{name:"adam_epsilon",val:": float = 1e-08"},{name:"max_grad_norm",val:": float = 1.0"},{name:"num_train_epochs",val:": float = 3.0"},{name:"max_steps",val:": int = -1"},{name:"lr_scheduler_type",val:": typing.Union[transformers.trainer_utils.SchedulerType, str] = 'linear'"},{name:"lr_scheduler_kwargs",val:": typing.Union[dict, str, NoneType] = <factory>"},{name:"warmup_ratio",val:": float = 0.0"},{name:"warmup_steps",val:": int = 0"},{name:"log_level",val:": typing.Optional[str] = 'passive'"},{name:"log_level_replica",val:": typing.Optional[str] = 'warning'"},{name:"log_on_each_node",val:": bool = True"},{name:"logging_dir",val:": typing.Optional[str] = None"},{name:"logging_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = 'steps'"},{name:"logging_first_step",val:": bool = False"},{name:"logging_steps",val:": float = 500"},{name:"logging_nan_inf_filter",val:": bool = True"},{name:"save_strategy",val:": typing.Union[transformers.trainer_utils.SaveStrategy, str] = 'steps'"},{name:"save_steps",val:": float = 500"},{name:"save_total_limit",val:": typing.Optional[int] = None"},{name:"save_safetensors",val:": typing.Optional[bool] = True"},{name:"save_on_each_node",val:": bool = False"},{name:"save_only_model",val:": bool = False"},{name:"restore_callback_states_from_checkpoint",val:": bool = False"},{name:"no_cuda",val:": bool = False"},{name:"use_cpu",val:": bool = False"},{name:"use_mps_device",val:": bool = False"},{name:"seed",val:": int = 42"},{name:"data_seed",val:": typing.Optional[int] = None"},{name:"jit_mode_eval",val:": bool = False"},{name:"use_ipex",val:": bool = False"},{name:"bf16",val:": bool = False"},{name:"fp16",val:": bool = False"},{name:"fp16_opt_level",val:": str = 'O1'"},{name:"half_precision_backend",val:": str = 'auto'"},{name:"bf16_full_eval",val:": bool = False"},{name:"fp16_full_eval",val:": bool = False"},{name:"tf32",val:": typing.Optional[bool] = None"},{name:"local_rank",val:": int = -1"},{name:"ddp_backend",val:": typing.Optional[str] = None"},{name:"tpu_num_cores",val:": typing.Optional[int] = None"},{name:"tpu_metrics_debug",val:": bool = False"},{name:"debug",val:": typing.Union[str, typing.List[transformers.debug_utils.DebugOption]] = ''"},{name:"dataloader_drop_last",val:": bool = False"},{name:"eval_steps",val:": typing.Optional[float] = None"},{name:"dataloader_num_workers",val:": int = 0"},{name:"dataloader_prefetch_factor",val:": typing.Optional[int] = None"},{name:"past_index",val:": int = -1"},{name:"run_name",val:": typing.Optional[str] = None"},{name:"disable_tqdm",val:": typing.Optional[bool] = None"},{name:"remove_unused_columns",val:": typing.Optional[bool] = True"},{name:"label_names",val:": typing.Optional[typing.List[str]] = None"},{name:"load_best_model_at_end",val:": typing.Optional[bool] = False"},{name:"metric_for_best_model",val:": typing.Optional[str] = None"},{name:"greater_is_better",val:": typing.Optional[bool] = None"},{name:"ignore_data_skip",val:": bool = False"},{name:"fsdp",val:": typing.Union[typing.List[transformers.trainer_utils.FSDPOption], str, NoneType] = ''"},{name:"fsdp_min_num_params",val:": int = 0"},{name:"fsdp_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"fsdp_transformer_layer_cls_to_wrap",val:": typing.Optional[str] = None"},{name:"accelerator_config",val:": typing.Union[dict, str, NoneType] = None"},{name:"deepspeed",val:": typing.Union[dict, str, NoneType] = None"},{name:"label_smoothing_factor",val:": float = 0.0"},{name:"optim",val:": typing.Union[transformers.training_args.OptimizerNames, str] = 'adamw_torch'"},{name:"optim_args",val:": typing.Optional[str] = None"},{name:"adafactor",val:": bool = False"},{name:"group_by_length",val:": bool = False"},{name:"length_column_name",val:": typing.Optional[str] = 'length'"},{name:"report_to",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"ddp_find_unused_parameters",val:": typing.Optional[bool] = None"},{name:"ddp_bucket_cap_mb",val:": typing.Optional[int] = None"},{name:"ddp_broadcast_buffers",val:": typing.Optional[bool] = None"},{name:"dataloader_pin_memory",val:": bool = True"},{name:"dataloader_persistent_workers",val:": bool = False"},{name:"skip_memory_metrics",val:": bool = True"},{name:"use_legacy_prediction_loop",val:": bool = False"},{name:"push_to_hub",val:": bool = False"},{name:"resume_from_checkpoint",val:": typing.Optional[str] = None"},{name:"hub_model_id",val:": typing.Optional[str] = None"},{name:"hub_strategy",val:": typing.Union[transformers.trainer_utils.HubStrategy, str] = 'every_save'"},{name:"hub_token",val:": typing.Optional[str] = None"},{name:"hub_private_repo",val:": typing.Optional[bool] = None"},{name:"hub_always_push",val:": bool = False"},{name:"gradient_checkpointing",val:": bool = False"},{name:"gradient_checkpointing_kwargs",val:": typing.Union[dict, str, NoneType] = None"},{name:"include_inputs_for_metrics",val:": bool = False"},{name:"include_for_metrics",val:": typing.List[str] = <factory>"},{name:"eval_do_concat_batches",val:": bool = True"},{name:"fp16_backend",val:": str = 'auto'"},{name:"evaluation_strategy",val:": typing.Union[transformers.trainer_utils.IntervalStrategy, str] = None"},{name:"push_to_hub_model_id",val:": typing.Optional[str] = None"},{name:"push_to_hub_organization",val:": typing.Optional[str] = None"},{name:"push_to_hub_token",val:": typing.Optional[str] = None"},{name:"mp_parameters",val:": str = ''"},{name:"auto_find_batch_size",val:": bool = False"},{name:"full_determinism",val:": bool = False"},{name:"torchdynamo",val:": typing.Optional[str] = None"},{name:"ray_scope",val:": typing.Optional[str] = 'last'"},{name:"ddp_timeout",val:": typing.Optional[int] = 1800"},{name:"torch_compile",val:": bool = False"},{name:"torch_compile_backend",val:": typing.Optional[str] = None"},{name:"torch_compile_mode",val:": typing.Optional[str] = None"},{name:"dispatch_batches",val:": typing.Optional[bool] = None"},{name:"split_batches",val:": typing.Optional[bool] = None"},{name:"include_tokens_per_second",val:": typing.Optional[bool] = False"},{name:"include_num_input_tokens_seen",val:": typing.Optional[bool] = False"},{name:"neftune_noise_alpha",val:": typing.Optional[float] = None"},{name:"optim_target_modules",val:": typing.Union[NoneType, str, typing.List[str]] = None"},{name:"batch_eval_metrics",val:": bool = False"},{name:"eval_on_start",val:": bool = False"},{name:"use_liger_kernel",val:": typing.Optional[bool] = False"},{name:"eval_use_gather_object",val:": typing.Optional[bool] = False"},{name:"average_tokens_across_devices",val:": typing.Optional[bool] = False"},{name:"max_length",val:": typing.Optional[int] = 1024"},{name:"max_prompt_length",val:": typing.Optional[int] = 512"},{name:"max_completion_length",val:": typing.Optional[int] = None"},{name:"beta",val:": float = 0.1"},{name:"label_pad_token_id",val:": int = -100"},{name:"padding_value",val:": typing.Optional[int] = None"},{name:"truncation_mode",val:": str = 'keep_end'"},{name:"disable_dropout",val:": bool = True"},{name:"generate_during_eval",val:": bool = False"},{name:"is_encoder_decoder",val:": typing.Optional[bool] = None"},{name:"precompute_ref_log_probs",val:": bool = False"},{name:"model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"ref_model_init_kwargs",val:": typing.Optional[dict[str, typing.Any]] = None"},{name:"dataset_num_proc",val:": typing.Optional[int] = None"},{name:"prompt_sample_size",val:": int = 1024"},{name:"min_density_ratio",val:": float = 0.5"},{name:"max_density_ratio",val:": float = 10.0"}],parametersDescription:[{anchor:"trl.BCOConfig.max_length",description:`<strong>max_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Maximum length of the sequences (prompt + completion) in the batch. This argument is required if you want
to use the default data collator.`,name:"max_length"},{anchor:"trl.BCOConfig.max_prompt_length",description:`<strong>max_prompt_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>512</code>) &#x2014;
Maximum length of the prompt. This argument is required if you want to use the default data collator.`,name:"max_prompt_length"},{anchor:"trl.BCOConfig.max_completion_length",description:`<strong>max_completion_length</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Maximum length of the completion. This argument is required if you want to use the default data collator
and your model is an encoder-decoder.`,name:"max_completion_length"},{anchor:"trl.BCOConfig.beta",description:`<strong>beta</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.1</code>) &#x2014;
Parameter controlling the deviation from the reference model. Higher &#x3B2; means less deviation from the
reference model.`,name:"beta"},{anchor:"trl.BCOConfig.label_pad_token_id",description:`<strong>label_pad_token_id</strong> (<code>int</code>,  <em>optional</em>, defaults to <code>-100</code>) &#x2014;
Label pad token id. This argument is required if you want to use the default data collator.`,name:"label_pad_token_id"},{anchor:"trl.BCOConfig.padding_value",description:`<strong>padding_value</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Padding value to use. If <code>None</code>, the padding value of the tokenizer is used.`,name:"padding_value"},{anchor:"trl.BCOConfig.truncation_mode",description:`<strong>truncation_mode</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;keep_end&quot;</code>) &#x2014;
Truncation mode to use when the prompt is too long. Possible values are <code>&quot;keep_end&quot;</code> or <code>&quot;keep_start&quot;</code>.
This argument is required if you want to use the default data collator.`,name:"truncation_mode"},{anchor:"trl.BCOConfig.disable_dropout",description:`<strong>disable_dropout</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to disable dropout in the model and reference model.`,name:"disable_dropout"},{anchor:"trl.BCOConfig.generate_during_eval",description:`<strong>generate_during_eval</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If <code>True</code>, generates and logs completions from both the model and the reference model to W&amp;B or Comet during
evaluation.`,name:"generate_during_eval"},{anchor:"trl.BCOConfig.is_encoder_decoder",description:`<strong>is_encoder_decoder</strong> (<code>bool</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
When using the <code>model_init</code> argument (callable) to instantiate the model instead of the <code>model</code> argument,
you need to specify if the model returned by the callable is an encoder-decoder model.`,name:"is_encoder_decoder"},{anchor:"trl.BCOConfig.precompute_ref_log_probs",description:`<strong>precompute_ref_log_probs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to precompute reference model log probabilities for training and evaluation datasets. This is
useful when training without the reference model to reduce the total GPU memory needed.`,name:"precompute_ref_log_probs"},{anchor:"trl.BCOConfig.model_init_kwargs",description:`<strong>model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the model from a
string.`,name:"model_init_kwargs"},{anchor:"trl.BCOConfig.ref_model_init_kwargs",description:`<strong>ref_model_init_kwargs</strong> (<code>dict[str, Any]</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Keyword arguments to pass to <code>AutoModelForCausalLM.from_pretrained</code> when instantiating the reference model
from a string.`,name:"ref_model_init_kwargs"},{anchor:"trl.BCOConfig.dataset_num_proc",description:`<strong>dataset_num_proc</strong> (<code>int</code> or <code>None</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Number of processes to use for processing the dataset.`,name:"dataset_num_proc"},{anchor:"trl.BCOConfig.prompt_sample_size",description:`<strong>prompt_sample_size</strong> (<code>int</code>, <em>optional</em>, defaults to <code>1024</code>) &#x2014;
Number of prompts that are fed to density ratio classifier.`,name:"prompt_sample_size"},{anchor:"trl.BCOConfig.min_density_ratio",description:`<strong>min_density_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>0.5</code>) &#x2014;
Minimum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"min_density_ratio"},{anchor:"trl.BCOConfig.max_density_ratio",description:`<strong>max_density_ratio</strong> (<code>float</code>, <em>optional</em>, defaults to <code>10.0</code>) &#x2014;
Maximum value of the density ratio. The estimated density ratio is clamped to this value.`,name:"max_density_ratio"}],source:"https://github.com/huggingface/trl/blob/v0.15.1/trl/trainer/bco_config.py#L21"}}),be=new za({props:{source:"https://github.com/huggingface/trl/blob/main/docs/source/bco_trainer.md"}}),{c(){x=l("meta"),Ve=n(),Pe=l("p"),We=n(),p(Z.$$.fragment),De=n(),I=l("p"),I.innerHTML=aa,Ge=n(),z=l("p"),z.innerHTML=na,Xe=n(),p(H.$$.fragment),Re=n(),j=l("p"),j.innerHTML=oa,Ae=n(),p(P.$$.fragment),Se=n(),E=l("p"),E.innerHTML=ra,Qe=n(),p(V.$$.fragment),qe=n(),W=l("p"),W.innerHTML=la,Ye=n(),D=l("p"),D.innerHTML=ia,Ke=n(),p(G.$$.fragment),et=n(),X=l("p"),X.textContent=sa,tt=n(),p(R.$$.fragment),at=n(),p(A.$$.fragment),nt=n(),S=l("p"),S.innerHTML=da,ot=n(),Q=l("p"),Q.textContent=ma,rt=n(),p(q.$$.fragment),lt=n(),Y=l("p"),Y.innerHTML=ca,it=n(),p(K.$$.fragment),st=n(),p(ee.$$.fragment),dt=n(),te=l("p"),te.innerHTML=pa,mt=n(),ae=l("p"),ae.innerHTML=ga,ct=n(),p(ne.$$.fragment),pt=n(),d=l("div"),p(oe.$$.fragment),Mt=n(),ve=l("p"),ve.innerHTML=_a,Nt=n(),O=l("div"),p(re.$$.fragment),Bt=n(),ye=l("p"),ye.textContent=ua,kt=n(),M=l("div"),p(le.$$.fragment),Jt=n(),Te=l("p"),Te.textContent=fa,Ut=n(),N=l("div"),p(ie.$$.fragment),Ft=n(),Ce=l("p"),Ce.innerHTML=ha,Lt=n(),C=l("div"),p(se.$$.fragment),Zt=n(),$e=l("p"),$e.innerHTML=ba,It=n(),we=l("p"),we.textContent=va,zt=n(),B=l("div"),p(de.$$.fragment),Ht=n(),xe=l("p"),xe.textContent=ya,jt=n(),k=l("div"),p(me.$$.fragment),Pt=n(),Oe=l("p"),Oe.textContent=Ta,Et=n(),J=l("div"),p(ce.$$.fragment),Vt=n(),Me=l("p"),Me.textContent=Ca,Wt=n(),$=l("div"),p(pe.$$.fragment),Dt=n(),Ne=l("p"),Ne.innerHTML=$a,Gt=n(),Be=l("p"),Be.innerHTML=wa,Xt=n(),w=l("div"),p(ge.$$.fragment),Rt=n(),ke=l("p"),ke.innerHTML=xa,At=n(),Je=l("p"),Je.innerHTML=Oa,St=n(),U=l("div"),p(_e.$$.fragment),Qt=n(),Ue=l("p"),Ue.innerHTML=Ma,qt=n(),F=l("div"),p(ue.$$.fragment),Yt=n(),Fe=l("p"),Fe.textContent=Na,gt=n(),p(fe.$$.fragment),_t=n(),T=l("div"),p(he.$$.fragment),Kt=n(),Le=l("p"),Le.innerHTML=Ba,ea=n(),Ze=l("p"),Ze.innerHTML=ka,ut=n(),p(be.$$.fragment),ft=n(),Ee=l("p"),this.h()},l(e){const a=Ia("svelte-u9bgzb",document.head);x=i(a,"META",{name:!0,content:!0}),a.forEach(t),Ve=o(e),Pe=i(e,"P",{}),b(Pe).forEach(t),We=o(e),g(Z.$$.fragment,e),De=o(e),I=i(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-n86tfs"&&(I.innerHTML=aa),Ge=o(e),z=i(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-r130jr"&&(z.innerHTML=na),Xe=o(e),g(H.$$.fragment,e),Re=o(e),j=i(e,"P",{"data-svelte-h":!0}),m(j)!=="svelte-kkdb76"&&(j.innerHTML=oa),Ae=o(e),g(P.$$.fragment,e),Se=o(e),E=i(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-a13xh1"&&(E.innerHTML=ra),Qe=o(e),g(V.$$.fragment,e),qe=o(e),W=i(e,"P",{"data-svelte-h":!0}),m(W)!=="svelte-1xv0q10"&&(W.innerHTML=la),Ye=o(e),D=i(e,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1eil2tw"&&(D.innerHTML=ia),Ke=o(e),g(G.$$.fragment,e),et=o(e),X=i(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-1lg6q1l"&&(X.textContent=sa),tt=o(e),g(R.$$.fragment,e),at=o(e),g(A.$$.fragment,e),nt=o(e),S=i(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-16kpfu0"&&(S.innerHTML=da),ot=o(e),Q=i(e,"P",{"data-svelte-h":!0}),m(Q)!=="svelte-1hlwkqm"&&(Q.textContent=ma),rt=o(e),g(q.$$.fragment,e),lt=o(e),Y=i(e,"P",{"data-svelte-h":!0}),m(Y)!=="svelte-zt3y0f"&&(Y.innerHTML=ca),it=o(e),g(K.$$.fragment,e),st=o(e),g(ee.$$.fragment,e),dt=o(e),te=i(e,"P",{"data-svelte-h":!0}),m(te)!=="svelte-3kfva2"&&(te.innerHTML=pa),mt=o(e),ae=i(e,"P",{"data-svelte-h":!0}),m(ae)!=="svelte-1c01yo3"&&(ae.innerHTML=ga),ct=o(e),g(ne.$$.fragment,e),pt=o(e),d=i(e,"DIV",{class:!0});var c=b(d);g(oe.$$.fragment,c),Mt=o(c),ve=i(c,"P",{"data-svelte-h":!0}),m(ve)!=="svelte-13v1u5r"&&(ve.innerHTML=_a),Nt=o(c),O=i(c,"DIV",{class:!0});var bt=b(O);g(re.$$.fragment,bt),Bt=o(bt),ye=i(bt,"P",{"data-svelte-h":!0}),m(ye)!=="svelte-2814fy"&&(ye.textContent=ua),bt.forEach(t),kt=o(c),M=i(c,"DIV",{class:!0});var vt=b(M);g(le.$$.fragment,vt),Jt=o(vt),Te=i(vt,"P",{"data-svelte-h":!0}),m(Te)!=="svelte-2l3xud"&&(Te.textContent=fa),vt.forEach(t),Ut=o(c),N=i(c,"DIV",{class:!0});var yt=b(N);g(ie.$$.fragment,yt),Ft=o(yt),Ce=i(yt,"P",{"data-svelte-h":!0}),m(Ce)!=="svelte-1mh859w"&&(Ce.innerHTML=ha),yt.forEach(t),Lt=o(c),C=i(c,"DIV",{class:!0});var Ie=b(C);g(se.$$.fragment,Ie),Zt=o(Ie),$e=i(Ie,"P",{"data-svelte-h":!0}),m($e)!=="svelte-8qlty5"&&($e.innerHTML=ba),It=o(Ie),we=i(Ie,"P",{"data-svelte-h":!0}),m(we)!=="svelte-1tyo99t"&&(we.textContent=va),Ie.forEach(t),zt=o(c),B=i(c,"DIV",{class:!0});var Tt=b(B);g(de.$$.fragment,Tt),Ht=o(Tt),xe=i(Tt,"P",{"data-svelte-h":!0}),m(xe)!=="svelte-18uwvbi"&&(xe.textContent=ya),Tt.forEach(t),jt=o(c),k=i(c,"DIV",{class:!0});var Ct=b(k);g(me.$$.fragment,Ct),Pt=o(Ct),Oe=i(Ct,"P",{"data-svelte-h":!0}),m(Oe)!=="svelte-4nmimv"&&(Oe.textContent=Ta),Ct.forEach(t),Et=o(c),J=i(c,"DIV",{class:!0});var $t=b(J);g(ce.$$.fragment,$t),Vt=o($t),Me=i($t,"P",{"data-svelte-h":!0}),m(Me)!=="svelte-1syv8mg"&&(Me.textContent=Ca),$t.forEach(t),Wt=o(c),$=i(c,"DIV",{class:!0});var ze=b($);g(pe.$$.fragment,ze),Dt=o(ze),Ne=i(ze,"P",{"data-svelte-h":!0}),m(Ne)!=="svelte-xesobz"&&(Ne.innerHTML=$a),Gt=o(ze),Be=i(ze,"P",{"data-svelte-h":!0}),m(Be)!=="svelte-qg43tm"&&(Be.innerHTML=wa),ze.forEach(t),Xt=o(c),w=i(c,"DIV",{class:!0});var He=b(w);g(ge.$$.fragment,He),Rt=o(He),ke=i(He,"P",{"data-svelte-h":!0}),m(ke)!=="svelte-dkae9b"&&(ke.innerHTML=xa),At=o(He),Je=i(He,"P",{"data-svelte-h":!0}),m(Je)!=="svelte-hmd5cw"&&(Je.innerHTML=Oa),He.forEach(t),St=o(c),U=i(c,"DIV",{class:!0});var wt=b(U);g(_e.$$.fragment,wt),Qt=o(wt),Ue=i(wt,"P",{"data-svelte-h":!0}),m(Ue)!=="svelte-nqksfz"&&(Ue.innerHTML=Ma),wt.forEach(t),qt=o(c),F=i(c,"DIV",{class:!0});var xt=b(F);g(ue.$$.fragment,xt),Yt=o(xt),Fe=i(xt,"P",{"data-svelte-h":!0}),m(Fe)!=="svelte-17kjsy4"&&(Fe.textContent=Na),xt.forEach(t),c.forEach(t),gt=o(e),g(fe.$$.fragment,e),_t=o(e),T=i(e,"DIV",{class:!0});var je=b(T);g(he.$$.fragment,je),Kt=o(je),Le=i(je,"P",{"data-svelte-h":!0}),m(Le)!=="svelte-1p4knza"&&(Le.innerHTML=Ba),ea=o(je),Ze=i(je,"P",{"data-svelte-h":!0}),m(Ze)!=="svelte-2adg1n"&&(Ze.innerHTML=ka),je.forEach(t),ut=o(e),g(be.$$.fragment,e),ft=o(e),Ee=i(e,"P",{}),b(Ee).forEach(t),this.h()},h(){v(x,"name","hf:doc:metadata"),v(x,"content",ja),v(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(M,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(w,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(d,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),v(T,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,a){r(document.head,x),s(e,Ve,a),s(e,Pe,a),s(e,We,a),_(Z,e,a),s(e,De,a),s(e,I,a),s(e,Ge,a),s(e,z,a),s(e,Xe,a),_(H,e,a),s(e,Re,a),s(e,j,a),s(e,Ae,a),_(P,e,a),s(e,Se,a),s(e,E,a),s(e,Qe,a),_(V,e,a),s(e,qe,a),s(e,W,a),s(e,Ye,a),s(e,D,a),s(e,Ke,a),_(G,e,a),s(e,et,a),s(e,X,a),s(e,tt,a),_(R,e,a),s(e,at,a),_(A,e,a),s(e,nt,a),s(e,S,a),s(e,ot,a),s(e,Q,a),s(e,rt,a),_(q,e,a),s(e,lt,a),s(e,Y,a),s(e,it,a),_(K,e,a),s(e,st,a),_(ee,e,a),s(e,dt,a),s(e,te,a),s(e,mt,a),s(e,ae,a),s(e,ct,a),_(ne,e,a),s(e,pt,a),s(e,d,a),_(oe,d,null),r(d,Mt),r(d,ve),r(d,Nt),r(d,O),_(re,O,null),r(O,Bt),r(O,ye),r(d,kt),r(d,M),_(le,M,null),r(M,Jt),r(M,Te),r(d,Ut),r(d,N),_(ie,N,null),r(N,Ft),r(N,Ce),r(d,Lt),r(d,C),_(se,C,null),r(C,Zt),r(C,$e),r(C,It),r(C,we),r(d,zt),r(d,B),_(de,B,null),r(B,Ht),r(B,xe),r(d,jt),r(d,k),_(me,k,null),r(k,Pt),r(k,Oe),r(d,Et),r(d,J),_(ce,J,null),r(J,Vt),r(J,Me),r(d,Wt),r(d,$),_(pe,$,null),r($,Dt),r($,Ne),r($,Gt),r($,Be),r(d,Xt),r(d,w),_(ge,w,null),r(w,Rt),r(w,ke),r(w,At),r(w,Je),r(d,St),r(d,U),_(_e,U,null),r(U,Qt),r(U,Ue),r(d,qt),r(d,F),_(ue,F,null),r(F,Yt),r(F,Fe),s(e,gt,a),_(fe,e,a),s(e,_t,a),s(e,T,a),_(he,T,null),r(T,Kt),r(T,Le),r(T,ea),r(T,Ze),s(e,ut,a),_(be,e,a),s(e,ft,a),s(e,Ee,a),ht=!0},p:Ua,i(e){ht||(u(Z.$$.fragment,e),u(H.$$.fragment,e),u(P.$$.fragment,e),u(V.$$.fragment,e),u(G.$$.fragment,e),u(R.$$.fragment,e),u(A.$$.fragment,e),u(q.$$.fragment,e),u(K.$$.fragment,e),u(ee.$$.fragment,e),u(ne.$$.fragment,e),u(oe.$$.fragment,e),u(re.$$.fragment,e),u(le.$$.fragment,e),u(ie.$$.fragment,e),u(se.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(pe.$$.fragment,e),u(ge.$$.fragment,e),u(_e.$$.fragment,e),u(ue.$$.fragment,e),u(fe.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),ht=!0)},o(e){f(Z.$$.fragment,e),f(H.$$.fragment,e),f(P.$$.fragment,e),f(V.$$.fragment,e),f(G.$$.fragment,e),f(R.$$.fragment,e),f(A.$$.fragment,e),f(q.$$.fragment,e),f(K.$$.fragment,e),f(ee.$$.fragment,e),f(ne.$$.fragment,e),f(oe.$$.fragment,e),f(re.$$.fragment,e),f(le.$$.fragment,e),f(ie.$$.fragment,e),f(se.$$.fragment,e),f(de.$$.fragment,e),f(me.$$.fragment,e),f(ce.$$.fragment,e),f(pe.$$.fragment,e),f(ge.$$.fragment,e),f(_e.$$.fragment,e),f(ue.$$.fragment,e),f(fe.$$.fragment,e),f(he.$$.fragment,e),f(be.$$.fragment,e),ht=!1},d(e){e&&(t(Ve),t(Pe),t(We),t(De),t(I),t(Ge),t(z),t(Xe),t(Re),t(j),t(Ae),t(Se),t(E),t(Qe),t(qe),t(W),t(Ye),t(D),t(Ke),t(et),t(X),t(tt),t(at),t(nt),t(S),t(ot),t(Q),t(rt),t(lt),t(Y),t(it),t(st),t(dt),t(te),t(mt),t(ae),t(ct),t(pt),t(d),t(gt),t(_t),t(T),t(ut),t(ft),t(Ee)),t(x),h(Z,e),h(H,e),h(P,e),h(V,e),h(G,e),h(R,e),h(A,e),h(q,e),h(K,e),h(ee,e),h(ne,e),h(oe),h(re),h(le),h(ie),h(se),h(de),h(me),h(ce),h(pe),h(ge),h(_e),h(ue),h(fe,e),h(he),h(be,e)}}}const ja='{"title":"BCO Trainer","local":"bco-trainer","sections":[{"title":"Expected dataset type","local":"expected-dataset-type","sections":[],"depth":2},{"title":"Expected model format","local":"expected-model-format","sections":[],"depth":2},{"title":"Using the BCOTrainer","local":"using-the-bcotrainer","sections":[],"depth":2},{"title":"Underlying Distribution matching (UDM)","local":"underlying-distribution-matching-udm","sections":[{"title":"For Mixture of Experts Models: Enabling the auxiliary loss","local":"for-mixture-of-experts-models-enabling-the-auxiliary-loss","sections":[],"depth":3}],"depth":2},{"title":"BCOTrainer","local":"trl.BCOTrainer","sections":[],"depth":2},{"title":"BCOConfig","local":"trl.BCOConfig","sections":[],"depth":2}],"depth":1}';function Pa(ta){return Fa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Xa extends La{constructor(x){super(),Za(this,x,Pa,Ha,Ja,{})}}export{Xa as component};
