import{s as ut,o as dt,n as ft}from"../chunks/scheduler.182ea377.js";import{S as Mt,i as mt,g as i,s as n,r,A as yt,h as o,f as s,c as a,j as pt,u as c,x as p,k as rt,y as ht,a as t,v as f,d as u,t as d,w as M}from"../chunks/index.abf12888.js";import{T as ct}from"../chunks/Tip.230e2334.js";import{C as y}from"../chunks/CodeBlock.57fe6e13.js";import{D as Jt}from"../chunks/DocNotebookDropdown.5fa27ace.js";import{H as U}from"../chunks/Heading.16916d63.js";function Ut(He){let m,J='💡 Skip to the <a href="#diffusionpipeline-explained">DiffusionPipeline explained</a> section if you are interested in learning in more detail about how the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class works.';return{c(){m=i("p"),m.innerHTML=J},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-75jv9d"&&(m.innerHTML=J)},m(h,T){t(h,m,T)},p:ft,d(h){h&&s(m)}}}function Tt(He){let m,J="💡 When the checkpoints have identical model structures, but they were trained on different datasets and with a different training setup, they should be stored in separate repositories instead of variations (for example, <code>stable-diffusion-v1-4</code> and <code>stable-diffusion-v1-5</code>).";return{c(){m=i("p"),m.innerHTML=J},l(h){m=o(h,"P",{"data-svelte-h":!0}),p(m)!=="svelte-1bx6mv6"&&(m.innerHTML=J)},m(h,T){t(h,m,T)},p:ft,d(h){h&&s(m)}}}function wt(He){let m,J,h,T,Z,Ye,j,Ae,v,Js='Having an easy way to use a diffusion system for inference is essential to 🧨 Diffusers. Diffusion systems often consist of multiple components like parameterized models, tokenizers, and schedulers that interact in complex ways. That is why we designed the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> to wrap the complexity of the entire diffusion system into an easy-to-use API, while remaining flexible enough to be adapted for other use cases, such as loading each component individually as building blocks to assemble your own diffusion system.',Fe,C,Us="Everything you need for inference or training is accessible with the <code>from_pretrained()</code> method.",Le,I,Ts="This guide will show you how to load:",Pe,g,ws="<li>pipelines from the Hub and locally</li> <li>different components into a pipeline</li> <li>checkpoint variants such as different floating point types or non-exponential mean averaged (EMA) weights</li> <li>models and schedulers</li>",Oe,V,Ke,w,el,W,bs='The <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a> class is the simplest and most generic way to load the latest trending diffusion model from the <a href="https://huggingface.co/models?library=diffusers&amp;sort=trending" rel="nofollow">Hub</a>. The <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> method automatically detects the correct pipeline class from the checkpoint, downloads, and caches all the required configuration and weight files, and returns a pipeline instance ready for inference.',ll,k,sl,R,Zs='You can also load a checkpoint with its specific pipeline class. The example above loaded a Stable Diffusion model; to get the same result, use the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> class:',tl,N,nl,B,js='A checkpoint (such as <a href="https://huggingface.co/CompVis/stable-diffusion-v1-4" rel="nofollow"><code>CompVis/stable-diffusion-v1-4</code></a> or <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) may also be used for more than one task, like text-to-image or image-to-image. To differentiate what task you want to use the checkpoint for, you have to load it directly with its corresponding task-specific pipeline class:',al,G,il,_,ol,$,vs='To load a diffusion pipeline locally, use <a href="https://git-lfs.github.com/" rel="nofollow"><code>git-lfs</code></a> to manually download the checkpoint (in this case, <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>) to your local disk. This creates a local folder, <code>./stable-diffusion-v1-5</code>, on your disk:',pl,Q,rl,X,Cs='Then pass the local path to <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a>:',cl,E,fl,z,Is='The <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method won’t download any files from the Hub when it detects a local path, but this also means it won’t download and cache the latest changes to a checkpoint.',ul,D,dl,S,gs="You can customize the default components of any pipeline with another compatible component. Customization is important because:",Ml,x,Vs="<li>Changing the scheduler is important for exploring the trade-off between generation speed and quality.</li> <li>Different components of a model are typically trained independently and you can swap out a component with a better-performing one.</li> <li>During finetuning, usually only some components - like the UNet or text encoder - are trained.</li>",ml,H,Ws="To find out which schedulers are compatible for customization, you can use the <code>compatibles</code> method:",yl,q,hl,Y,ks='Let’s use the <a href="/docs/diffusers/v0.27.1/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method to replace the default <a href="/docs/diffusers/v0.27.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a> with a more performant scheduler, <a href="/docs/diffusers/v0.27.1/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a>. The <code>subfolder=&quot;scheduler&quot;</code> argument is required to load the scheduler configuration from the correct <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/scheduler" rel="nofollow">subfolder</a> of the pipeline repository.',Jl,A,Rs='Then you can pass the new <a href="/docs/diffusers/v0.27.1/en/api/schedulers/euler#diffusers.EulerDiscreteScheduler">EulerDiscreteScheduler</a> instance to the <code>scheduler</code> argument in <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Ul,F,Tl,L,wl,P,Ns='Diffusion models like Stable Diffusion can generate harmful content, which is why 🧨 Diffusers has a <a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/pipelines/stable_diffusion/safety_checker.py" rel="nofollow">safety checker</a> to check generated outputs against known hardcoded NSFW content. If you’d like to disable the safety checker for whatever reason, pass <code>None</code> to the <code>safety_checker</code> argument:',bl,O,Zl,K,jl,ee,Bs='You can also reuse the same components in multiple pipelines to avoid loading the weights into RAM twice. Use the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.components">components</a> method to save the components:',vl,le,Cl,se,Gs="Then you can pass the <code>components</code> to another pipeline without reloading the weights into RAM:",Il,te,gl,ne,_s="You can also pass the components individually to the pipeline if you want more flexibility over which components to reuse or disable. For example, to reuse the same components in the text-to-image pipeline, except for the safety checker and feature extractor, in the image-to-image pipeline:",Vl,ae,Wl,ie,kl,oe,$s="A checkpoint variant is usually a checkpoint whose weights are:",Rl,pe,Qs='<li>Stored in a different floating point type for lower precision and lower storage, such as <a href="https://pytorch.org/docs/stable/tensors.html#data-types" rel="nofollow"><code>torch.float16</code></a>, because it only requires half the bandwidth and storage to download. You can’t use this variant if you’re continuing training or using a CPU.</li> <li>Non-exponential mean averaged (EMA) weights, which shouldn’t be used for inference. You should use these to continue fine-tuning a model.</li>',Nl,b,Bl,re,Xs='Otherwise, a variant is <strong>identical</strong> to the original checkpoint. They have exactly the same serialization format (like <a href="./using_safetensors">Safetensors</a>), model structure, and weights that have identical tensor shapes.',Gl,ce,Es="<thead><tr><th><strong>checkpoint type</strong></th> <th><strong>weight name</strong></th> <th><strong>argument for loading weights</strong></th></tr></thead> <tbody><tr><td>original</td> <td>diffusion_pytorch_model.bin</td> <td></td></tr> <tr><td>floating point</td> <td>diffusion_pytorch_model.fp16.bin</td> <td><code>variant</code>, <code>torch_dtype</code></td></tr> <tr><td>non-EMA</td> <td>diffusion_pytorch_model.non_ema.bin</td> <td><code>variant</code></td></tr></tbody>",_l,fe,zs="There are two important arguments to know for loading variants:",$l,ue,Ds='<li><p><code>torch_dtype</code> defines the floating point precision of the loaded checkpoints. For example, if you want to save bandwidth by loading a <code>fp16</code> variant, you should specify <code>torch_dtype=torch.float16</code> to <em>convert the weights</em> to <code>fp16</code>. Otherwise, the <code>fp16</code> weights are converted to the default <code>fp32</code> precision. You can also load the original checkpoint without defining the <code>variant</code> argument, and convert it to <code>fp16</code> with <code>torch_dtype=torch.float16</code>. In this case, the default <code>fp32</code> weights are downloaded first, and then they’re converted to <code>fp16</code> after loading.</p></li> <li><p><code>variant</code> defines which files should be loaded from the repository. For example, if you want to load a <code>non_ema</code> variant from the <a href="https://huggingface.co/diffusers/stable-diffusion-variants/tree/main/unet" rel="nofollow"><code>diffusers/stable-diffusion-variants</code></a> repository, you should specify <code>variant=&quot;non_ema&quot;</code> to download the <code>non_ema</code> files.</p></li>',Ql,de,Xl,Me,Ss='To save a checkpoint stored in a different floating-point type or as a non-EMA variant, use the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.save_pretrained">DiffusionPipeline.save_pretrained()</a> method and specify the <code>variant</code> argument. You should try and save a variant to the same folder as the original checkpoint, so you can load both from the same folder:',El,me,zl,ye,xs="If you don’t save the variant to an existing folder, you must specify the <code>variant</code> argument otherwise it’ll throw an <code>Exception</code> because it can’t find the original checkpoint:",Dl,he,Sl,Je,xl,Ue,Hs='Models are loaded from the <a href="/docs/diffusers/v0.27.1/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> method, which downloads and caches the latest version of the model weights and configurations. If the latest files are available in the local cache, <a href="/docs/diffusers/v0.27.1/en/api/models/overview#diffusers.ModelMixin.from_pretrained">from_pretrained()</a> reuses files in the cache instead of re-downloading them.',Hl,Te,qs='Models can be loaded from a subfolder with the <code>subfolder</code> argument. For example, the model weights for <code>runwayml/stable-diffusion-v1-5</code> are stored in the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main/unet" rel="nofollow"><code>unet</code></a> subfolder:',ql,we,Yl,be,Ys='Or directly from a repository’s <a href="https://huggingface.co/google/ddpm-cifar10-32/tree/main" rel="nofollow">directory</a>:',Al,Ze,Fl,je,As='You can also load and save model variants by specifying the <code>variant</code> argument in <a href="/docs/diffusers/v0.27.1/en/api/models/overview#diffusers.ModelMixin.from_pretrained">ModelMixin.from_pretrained()</a> and <a href="/docs/diffusers/v0.27.1/en/api/models/overview#diffusers.ModelMixin.save_pretrained">ModelMixin.save_pretrained()</a>:',Ll,ve,Pl,Ce,Ol,Ie,Fs='Schedulers are loaded from the <a href="/docs/diffusers/v0.27.1/en/api/schedulers/overview#diffusers.SchedulerMixin.from_pretrained">SchedulerMixin.from_pretrained()</a> method, and unlike models, schedulers are <strong>not parameterized</strong> or <strong>trained</strong>; they are defined by a configuration file.',Kl,ge,Ls=`Loading schedulers does not consume any significant amount of memory and the same configuration file can be used for a variety of different schedulers.
For example, the following schedulers are compatible with <a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which means you can load the same scheduler configuration file in any of these classes:`,es,Ve,ls,We,ss,ke,Ps='As a class method, <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> is responsible for two things:',ts,Re,Os='<li>Download the latest version of the folder structure required for inference and cache it. If the latest folder structure is available in the local cache, <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">DiffusionPipeline.from_pretrained()</a> reuses the cache and won’t redownload the files.</li> <li>Load the cached weights into the correct pipeline <a href="../api/pipelines/overview#diffusers-summary">class</a> - retrieved from the <code>model_index.json</code> file - and return an instance of it.</li>',ns,Ne,Ks='The pipelines’ underlying folder structure corresponds directly with their class instances. For example, the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a> corresponds to the folder structure in <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a>.',as,Be,is,Ge,et='You’ll see pipeline is an instance of <a href="/docs/diffusers/v0.27.1/en/api/pipelines/stable_diffusion/text2img#diffusers.StableDiffusionPipeline">StableDiffusionPipeline</a>, which consists of seven components:',os,_e,lt='<li><code>&quot;feature_extractor&quot;</code>: a <a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPImageProcessor" rel="nofollow">CLIPImageProcessor</a> from 🤗 Transformers.</li> <li><code>&quot;safety_checker&quot;</code>: a <a href="https://github.com/huggingface/diffusers/blob/e55687e1e15407f60f32242027b7bb8170e58266/src/diffusers/pipelines/stable_diffusion/safety_checker.py#L32" rel="nofollow">component</a> for screening against harmful content.</li> <li><code>&quot;scheduler&quot;</code>: an instance of <a href="/docs/diffusers/v0.27.1/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.</li> <li><code>&quot;text_encoder&quot;</code>: a <a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTextModel" rel="nofollow">CLIPTextModel</a> from 🤗 Transformers.</li> <li><code>&quot;tokenizer&quot;</code>: a <a href="https://huggingface.co/docs/transformers/v4.38.2/en/model_doc/clip#transformers.CLIPTokenizer" rel="nofollow">CLIPTokenizer</a> from 🤗 Transformers.</li> <li><code>&quot;unet&quot;</code>: an instance of <a href="/docs/diffusers/v0.27.1/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>.</li> <li><code>&quot;vae&quot;</code>: an instance of <a href="/docs/diffusers/v0.27.1/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>.</li>',ps,$e,rs,Qe,st='Compare the components of the pipeline instance to the <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/tree/main" rel="nofollow"><code>runwayml/stable-diffusion-v1-5</code></a> folder structure, and you’ll see there is a separate folder for each of the components in the repository:',cs,Xe,fs,Ee,tt="You can access each of the components of the pipeline as an attribute to view its configuration:",us,ze,ds,De,nt='Every pipeline expects a <a href="https://huggingface.co/runwayml/stable-diffusion-v1-5/blob/main/model_index.json" rel="nofollow"><code>model_index.json</code></a> file that tells the <a href="/docs/diffusers/v0.27.1/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>:',Ms,Se,at="<li>which pipeline class to load from <code>_class_name</code></li> <li>which version of 🧨 Diffusers was used to create the model in <code>_diffusers_version</code></li> <li>what components from which library are stored in the subfolders (<code>name</code> corresponds to the component and subfolder name, <code>library</code> corresponds to the name of the library to load the class from, and <code>class</code> corresponds to the class name)</li>",ms,xe,ys,qe,hs;return Z=new U({props:{title:"Load pipelines, models, and schedulers",local:"load-pipelines-models-and-schedulers",headingTag:"h1"}}),j=new Jt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/loading.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/loading.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/loading.ipynb"}]}}),V=new U({props:{title:"Diffusion Pipeline",local:"diffusion-pipeline",headingTag:"h2"}}),w=new ct({props:{$$slots:{default:[Ut]},$$scope:{ctx:He}}}),k=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),N=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),G=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvbkltZzJJbWdQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbWcySW1nUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionImg2ImgPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionImg2ImgPipeline.from_pretrained(repo_id)`,wrap:!1}}),_=new U({props:{title:"Local pipeline",local:"local-pipeline",headingTag:"h3"}}),Q=new y({props:{code:"Z2l0LWxmcyUyMGluc3RhbGwlMEFnaXQlMjBjbG9uZSUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNQ==",highlighted:`git-lfs install
git <span class="hljs-built_in">clone</span> https://huggingface.co/runwayml/stable-diffusion-v1-5`,wrap:!1}}),E=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMi4lMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),D=new U({props:{title:"Swap components in a pipeline",local:"swap-components-in-a-pipeline",headingTag:"h3"}}),q=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEFzdGFibGVfZGlmZnVzaW9uLnNjaGVkdWxlci5jb21wYXRpYmxlcw==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion.scheduler.compatibles`,wrap:!1}}),F=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTJDJTIwRXVsZXJEaXNjcmV0ZVNjaGVkdWxlciUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXNjaGVkdWxlciUyMCUzRCUyMEV1bGVyRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEc2NoZWR1bGVyJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline, EulerDiscreteScheduler

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
scheduler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, scheduler=scheduler, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),L=new U({props:{title:"Safety checker",local:"safety-checker",headingTag:"h3"}}),O=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSklMEElMjIlMjIlMjIlMEFZb3UlMjBoYXZlJTIwZGlzYWJsZWQlMjB0aGUlMjBzYWZldHklMjBjaGVja2VyJTIwZm9yJTIwJTNDY2xhc3MlMjAnZGlmZnVzZXJzLnBpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uLnBpcGVsaW5lX3N0YWJsZV9kaWZmdXNpb24uU3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUnJTNFJTIwYnklMjBwYXNzaW5nJTIwJTYwc2FmZXR5X2NoZWNrZXIlM0ROb25lJTYwLiUyMEVuc3VyZSUyMHRoYXQlMjB5b3UlMjBhYmlkZSUyMGJ5JTIwdGhlJTIwY29uZGl0aW9ucyUyMG9mJTIwdGhlJTIwU3RhYmxlJTIwRGlmZnVzaW9uJTIwbGljZW5zZSUyMGFuZCUyMGRvJTIwbm90JTIwZXhwb3NlJTIwdW5maWx0ZXJlZCUyMHJlc3VsdHMlMjBpbiUyMHNlcnZpY2VzJTIwb3IlMjBhcHBsaWNhdGlvbnMlMjBvcGVuJTIwdG8lMjB0aGUlMjBwdWJsaWMuJTIwQm90aCUyMHRoZSUyMGRpZmZ1c2VycyUyMHRlYW0lMjBhbmQlMjBIdWdnaW5nJTIwRmFjZSUyMHN0cm9uZ2x5JTIwcmVjb21tZW5kJTIwa2VlcGluZyUyMHRoZSUyMHNhZmV0eSUyMGZpbHRlciUyMGVuYWJsZWQlMjBpbiUyMGFsbCUyMHB1YmxpYy1mYWNpbmclMjBjaXJjdW1zdGFuY2VzJTJDJTIwZGlzYWJsaW5nJTIwaXQlMjBvbmx5JTIwZm9yJTIwdXNlJTIwY2FzZXMlMjB0aGF0JTIwaW52b2x2ZSUyMGFuYWx5emluZyUyMG5ldHdvcmslMjBiZWhhdmlvciUyMG9yJTIwYXVkaXRpbmclMjBpdHMlMjByZXN1bHRzLiUyMEZvciUyMG1vcmUlMjBpbmZvcm1hdGlvbiUyQyUyMHBsZWFzZSUyMGhhdmUlMjBhJTIwbG9vayUyMGF0JTIwaHR0cHMlM0ElMkYlMkZnaXRodWIuY29tJTJGaHVnZ2luZ2ZhY2UlMkZkaWZmdXNlcnMlMkZwdWxsJTJGMjU0JTIwLiUwQSUyMiUyMiUyMg==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion = DiffusionPipeline.from_pretrained(repo_id, safety_checker=<span class="hljs-literal">None</span>, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-string">&quot;&quot;&quot;
You have disabled the safety checker for &lt;class &#x27;diffusers.pipelines.stable_diffusion.pipeline_stable_diffusion.StableDiffusionPipeline&#x27;&gt; by passing \`safety_checker=None\`. Ensure that you abide by the conditions of the Stable Diffusion license and do not expose unfiltered results in services or applications open to the public. Both the diffusers team and Hugging Face strongly recommend keeping the safety filter enabled in all public-facing circumstances, disabling it only for use cases that involve analyzing network behavior or auditing its results. For more information, please have a look at https://github.com/huggingface/diffusers/pull/254 .
&quot;&quot;&quot;</span>`,wrap:!1}}),K=new U({props:{title:"Reuse components across pipelines",local:"reuse-components-across-pipelines",headingTag:"h3"}}),le=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBY29tcG9uZW50cyUyMCUzRCUyMHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5jb21wb25lbnRz",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

components = stable_diffusion_txt2img.components`,wrap:!1}}),te=new y({props:{code:"c3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCoqY29tcG9uZW50cyk=",highlighted:"stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(**components)",wrap:!1}}),ae=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTJDJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXN0YWJsZV9kaWZmdXNpb25fdHh0MmltZyUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBc3RhYmxlX2RpZmZ1c2lvbl9pbWcyaW1nJTIwJTNEJTIwU3RhYmxlRGlmZnVzaW9uSW1nMkltZ1BpcGVsaW5lKCUwQSUyMCUyMCUyMCUyMHZhZSUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy52YWUlMkMlMEElMjAlMjAlMjAlMjB0ZXh0X2VuY29kZXIlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudGV4dF9lbmNvZGVyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW5pemVyJTNEc3RhYmxlX2RpZmZ1c2lvbl90eHQyaW1nLnRva2VuaXplciUyQyUwQSUyMCUyMCUyMCUyMHVuZXQlM0RzdGFibGVfZGlmZnVzaW9uX3R4dDJpbWcudW5ldCUyQyUwQSUyMCUyMCUyMCUyMHNjaGVkdWxlciUzRHN0YWJsZV9kaWZmdXNpb25fdHh0MmltZy5zY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBzYWZldHlfY2hlY2tlciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjBmZWF0dXJlX2V4dHJhY3RvciUzRE5vbmUlMkMlMEElMjAlMjAlMjAlMjByZXF1aXJlc19zYWZldHlfY2hlY2tlciUzREZhbHNlJTJDJTBBKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline, StableDiffusionImg2ImgPipeline

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
stable_diffusion_txt2img = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
stable_diffusion_img2img = StableDiffusionImg2ImgPipeline(
    vae=stable_diffusion_txt2img.vae,
    text_encoder=stable_diffusion_txt2img.text_encoder,
    tokenizer=stable_diffusion_txt2img.tokenizer,
    unet=stable_diffusion_txt2img.unet,
    scheduler=stable_diffusion_txt2img.scheduler,
    safety_checker=<span class="hljs-literal">None</span>,
    feature_extractor=<span class="hljs-literal">None</span>,
    requires_safety_checker=<span class="hljs-literal">False</span>,
)`,wrap:!1}}),ie=new U({props:{title:"Checkpoint variants",local:"checkpoint-variants",headingTag:"h2"}}),b=new ct({props:{$$slots:{default:[Tt]},$$scope:{ctx:He}}}),de=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwdG9yY2glMEElMEElMjMlMjBsb2FkJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uJTIwJTNEJTIwRGlmZnVzaW9uUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUwQSUyMCUyMCUyMCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQSUyMyUyMGxvYWQlMjBub25fZW1hJTIwdmFyaWFudCUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline
<span class="hljs-keyword">import</span> torch

<span class="hljs-comment"># load fp16 variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># load non_ema variant</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),me=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBJTIzJTIwc2F2ZSUyMGFzJTIwZnAxNiUyMHZhcmlhbnQlMEFzdGFibGVfZGlmZnVzaW9uLnNhdmVfcHJldHJhaW5lZCglMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQSUyMyUyMHNhdmUlMjBhcyUyMG5vbi1lbWElMjB2YXJpYW50JTBBc3RhYmxlX2RpZmZ1c2lvbi5zYXZlX3ByZXRyYWluZWQoJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjB2YXJpYW50JTNEJTIybm9uX2VtYSUyMik=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

<span class="hljs-comment"># save as fp16 variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
<span class="hljs-comment"># save as non-ema variant</span>
stable_diffusion.save_pretrained(<span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),he=new y({props:{code:"JTIzJTIwJUYwJTlGJTkxJThFJTIwdGhpcyUyMHdvbid0JTIwd29yayUwQXN0YWJsZV9kaWZmdXNpb24lMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyLiUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUlMEEpJTBBJTIzJTIwJUYwJTlGJTkxJThEJTIwdGhpcyUyMHdvcmtzJTBBc3RhYmxlX2RpZmZ1c2lvbiUyMCUzRCUyMERpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjAlMjIuJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKQ==",highlighted:`<span class="hljs-comment"># 👎 this won&#x27;t work</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)
<span class="hljs-comment"># 👍 this works</span>
stable_diffusion = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;./stable-diffusion-v1-5&quot;</span>, variant=<span class="hljs-string">&quot;fp16&quot;</span>, torch_dtype=torch.float16, use_safetensors=<span class="hljs-literal">True</span>
)`,wrap:!1}}),Je=new U({props:{title:"Models",local:"models",headingTag:"h2"}}),we=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
model = UNet2DConditionModel.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),Ze=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRE1vZGVsJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMmdvb2dsZSUyRmRkcG0tY2lmYXIxMC0zMiUyMiUwQW1vZGVsJTIwJTNEJTIwVU5ldDJETW9kZWwuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DModel

repo_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>
model = UNet2DModel.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),ve=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFVOZXQyRENvbmRpdGlvbk1vZGVsJTBBJTBBbW9kZWwlMjAlM0QlMjBVTmV0MkRDb25kaXRpb25Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIycnVud2F5bWwlMkZzdGFibGUtZGlmZnVzaW9uLXYxLTUlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdmFyaWFudCUzRCUyMm5vbl9lbWElMjIlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlJTBBKSUwQW1vZGVsLnNhdmVfcHJldHJhaW5lZCglMjIuJTJGbG9jYWwtdW5ldCUyMiUyQyUyMHZhcmlhbnQlM0QlMjJub25fZW1hJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> UNet2DConditionModel

model = UNet2DConditionModel.from_pretrained(
    <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>, use_safetensors=<span class="hljs-literal">True</span>
)
model.save_pretrained(<span class="hljs-string">&quot;./local-unet&quot;</span>, variant=<span class="hljs-string">&quot;non_ema&quot;</span>)`,wrap:!1}}),Ce=new U({props:{title:"Schedulers",local:"schedulers",headingTag:"h2"}}),Ve=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMCglMEElMjAlMjAlMjAlMjBERFBNU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRERJTVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMFBORE1TY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBMTVNEaXNjcmV0ZVNjaGVkdWxlciUyQyUwQSUyMCUyMCUyMCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIlMkMlMEElMjAlMjAlMjAlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyJTJDJTBBJTIwJTIwJTIwJTIwRFBNU29sdmVyTXVsdGlzdGVwU2NoZWR1bGVyJTJDJTBBKSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQSUwQWRkcG0lMjAlM0QlMjBERFBNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRkaW0lMjAlM0QlMjBERElNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQXBuZG0lMjAlM0QlMjBQTkRNU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWxtcyUyMCUzRCUyMExNU0Rpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWV1bGVyX2FuYyUyMCUzRCUyMEV1bGVyQW5jZXN0cmFsRGlzY3JldGVTY2hlZHVsZXIuZnJvbV9wcmV0cmFpbmVkKHJlcG9faWQlMkMlMjBzdWJmb2xkZXIlM0QlMjJzY2hlZHVsZXIlMjIpJTBBZXVsZXIlMjAlM0QlMjBFdWxlckRpc2NyZXRlU2NoZWR1bGVyLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc3ViZm9sZGVyJTNEJTIyc2NoZWR1bGVyJTIyKSUwQWRwbSUyMCUzRCUyMERQTVNvbHZlck11bHRpc3RlcFNjaGVkdWxlci5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHN1YmZvbGRlciUzRCUyMnNjaGVkdWxlciUyMiklMEElMEElMjMlMjByZXBsYWNlJTIwJTYwZHBtJTYwJTIwd2l0aCUyMGFueSUyMG9mJTIwJTYwZGRwbSU2MCUyQyUyMCU2MGRkaW0lNjAlMkMlMjAlNjBwbmRtJTYwJTJDJTIwJTYwbG1zJTYwJTJDJTIwJTYwZXVsZXJfYW5jJTYwJTJDJTIwJTYwZXVsZXIlNjAlMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChyZXBvX2lkJTJDJTIwc2NoZWR1bGVyJTNEZHBtJTJDJTIwdXNlX3NhZmV0ZW5zb3JzJTNEVHJ1ZSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionPipeline
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> (
    DDPMScheduler,
    DDIMScheduler,
    PNDMScheduler,
    LMSDiscreteScheduler,
    EulerAncestralDiscreteScheduler,
    EulerDiscreteScheduler,
    DPMSolverMultistepScheduler,
)

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>

ddpm = DDPMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
ddim = DDIMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
pndm = PNDMScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
lms = LMSDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler_anc = EulerAncestralDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
euler = EulerDiscreteScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)
dpm = DPMSolverMultistepScheduler.from_pretrained(repo_id, subfolder=<span class="hljs-string">&quot;scheduler&quot;</span>)

<span class="hljs-comment"># replace \`dpm\` with any of \`ddpm\`, \`ddim\`, \`pndm\`, \`lms\`, \`euler_anc\`, \`euler\`</span>
pipeline = StableDiffusionPipeline.from_pretrained(repo_id, scheduler=dpm, use_safetensors=<span class="hljs-literal">True</span>)`,wrap:!1}}),We=new U({props:{title:"DiffusionPipeline explained",local:"diffusionpipeline-explained",headingTag:"h2"}}),Be=new y({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5lJTBBJTBBcmVwb19pZCUyMCUzRCUyMCUyMnJ1bndheW1sJTJGc3RhYmxlLWRpZmZ1c2lvbi12MS01JTIyJTBBcGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBcHJpbnQocGlwZWxpbmUp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

repo_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipeline = DiffusionPipeline.from_pretrained(repo_id, use_safetensors=<span class="hljs-literal">True</span>)
<span class="hljs-built_in">print</span>(pipeline)`,wrap:!1}}),$e=new y({props:{code:"U3RhYmxlRGlmZnVzaW9uUGlwZWxpbmUlMjAlN0IlMEElMjAlMjAlMjJmZWF0dXJlX2V4dHJhY3RvciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBJbWFnZVByb2Nlc3NvciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnNhZmV0eV9jaGVja2VyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyc3RhYmxlX2RpZmZ1c2lvbiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlN0YWJsZURpZmZ1c2lvblNhZmV0eUNoZWNrZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzY2hlZHVsZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJQTkRNU2NoZWR1bGVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydGV4dF9lbmNvZGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIydHJhbnNmb3JtZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQ0xJUFRleHRNb2RlbCUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRva2VuaXplciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUb2tlbml6ZXIlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ1bmV0JTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyVU5ldDJEQ29uZGl0aW9uTW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ2YWUlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJkaWZmdXNlcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJBdXRvZW5jb2RlcktMJTIyJTBBJTIwJTIwJTVEJTBBJTdE",highlighted:`StableDiffusionPipeline <span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),Xe=new y({props:{code:"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",highlighted:`.
├── feature_extractor
│   └── preprocessor_config.json
├── model_index.json
├── safety_checker
│   ├── config.json
|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   ├── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── scheduler
│   └── scheduler_config.json
├── text_encoder
│   ├── config.json
</span>|<span class="hljs-string">   ├── model.fp16.safetensors
│   ├── model.safetensors
│   </span>|<span class="hljs-string">── pytorch_model.bin
</span>|<span class="hljs-string">   └── pytorch_model.fp16.bin
├── tokenizer
│   ├── merges.txt
│   ├── special_tokens_map.json
│   ├── tokenizer_config.json
│   └── vocab.json
├── unet
│   ├── config.json
│   ├── diffusion_pytorch_model.bin
</span>|<span class="hljs-string">   </span>|<span class="hljs-string">── diffusion_pytorch_model.fp16.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.f16.safetensors
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.bin
│   </span>|<span class="hljs-string">── diffusion_pytorch_model.non_ema.safetensors
│   └── diffusion_pytorch_model.safetensors
</span>|<span class="hljs-string">── vae
.   ├── config.json
.   ├── diffusion_pytorch_model.bin
    ├── diffusion_pytorch_model.fp16.bin
    ├── diffusion_pytorch_model.fp16.safetensors
    └── diffusion_pytorch_model.safetensors</span>`,wrap:!1}}),ze=new y({props:{code:"cGlwZWxpbmUudG9rZW5pemVyJTBBQ0xJUFRva2VuaXplciglMEElMjAlMjAlMjAlMjBuYW1lX29yX3BhdGglM0QlMjIlMkZyb290JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXJ1bndheW1sLS1zdGFibGUtZGlmZnVzaW9uLXYxLTUlMkZzbmFwc2hvdHMlMkYzOTU5M2Q1NjUwMTEyYjRjYzU4MDQzM2Y2YjA0MzUzODU4ODJkODE5JTJGdG9rZW5pemVyJTIyJTJDJTBBJTIwJTIwJTIwJTIwdm9jYWJfc2l6ZSUzRDQ5NDA4JTJDJTBBJTIwJTIwJTIwJTIwbW9kZWxfbWF4X2xlbmd0aCUzRDc3JTJDJTBBJTIwJTIwJTIwJTIwaXNfZmFzdCUzREZhbHNlJTJDJTBBJTIwJTIwJTIwJTIwcGFkZGluZ19zaWRlJTNEJTIycmlnaHQlMjIlMkMlMEElMjAlMjAlMjAlMjB0cnVuY2F0aW9uX3NpZGUlM0QlMjJyaWdodCUyMiUyQyUwQSUyMCUyMCUyMCUyMHNwZWNpYWxfdG9rZW5zJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyYm9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NzdGFydG9mdGV4dCU3QyUzRSUyMiUyQyUyMHJzdHJpcCUzREZhbHNlJTJDJTIwbHN0cmlwJTNERmFsc2UlMkMlMjBzaW5nbGVfd29yZCUzREZhbHNlJTJDJTIwbm9ybWFsaXplZCUzRFRydWUpJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyZW9zX3Rva2VuJTIyJTNBJTIwQWRkZWRUb2tlbiglMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMjByc3RyaXAlM0RGYWxzZSUyQyUyMGxzdHJpcCUzREZhbHNlJTJDJTIwc2luZ2xlX3dvcmQlM0RGYWxzZSUyQyUyMG5vcm1hbGl6ZWQlM0RUcnVlKSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnVua190b2tlbiUyMiUzQSUyMEFkZGVkVG9rZW4oJTIyJTNDJTdDZW5kb2Z0ZXh0JTdDJTNFJTIyJTJDJTIwcnN0cmlwJTNERmFsc2UlMkMlMjBsc3RyaXAlM0RGYWxzZSUyQyUyMHNpbmdsZV93b3JkJTNERmFsc2UlMkMlMjBub3JtYWxpemVkJTNEVHJ1ZSklMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJwYWRfdG9rZW4lMjIlM0ElMjAlMjIlM0MlN0NlbmRvZnRleHQlN0MlM0UlMjIlMkMlMEElMjAlMjAlMjAlMjAlN0QlMkMlMEElMjAlMjAlMjAlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNEVHJ1ZSUwQSk=",highlighted:`pipeline.tokenizer
CLIPTokenizer(
    name_or_path=<span class="hljs-string">&quot;/root/.cache/huggingface/hub/models--runwayml--stable-diffusion-v1-5/snapshots/39593d5650112b4cc580433f6b0435385882d819/tokenizer&quot;</span>,
    vocab_size=<span class="hljs-number">49408</span>,
    model_max_length=<span class="hljs-number">77</span>,
    is_fast=<span class="hljs-literal">False</span>,
    padding_side=<span class="hljs-string">&quot;right&quot;</span>,
    truncation_side=<span class="hljs-string">&quot;right&quot;</span>,
    special_tokens={
        <span class="hljs-string">&quot;bos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|startoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;eos_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;unk_token&quot;</span>: AddedToken(<span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>, rstrip=<span class="hljs-literal">False</span>, lstrip=<span class="hljs-literal">False</span>, single_word=<span class="hljs-literal">False</span>, normalized=<span class="hljs-literal">True</span>),
        <span class="hljs-string">&quot;pad_token&quot;</span>: <span class="hljs-string">&quot;&lt;|endoftext|&gt;&quot;</span>,
    },
    clean_up_tokenization_spaces=<span class="hljs-literal">True</span>
)`,wrap:!1}}),xe=new y({props:{code:"JTdCJTBBJTIwJTIwJTIyX2NsYXNzX25hbWUlMjIlM0ElMjAlMjJTdGFibGVEaWZmdXNpb25QaXBlbGluZSUyMiUyQyUwQSUyMCUyMCUyMl9kaWZmdXNlcnNfdmVyc2lvbiUyMiUzQSUyMCUyMjAuNi4wJTIyJTJDJTBBJTIwJTIwJTIyZmVhdHVyZV9leHRyYWN0b3IlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQSW1hZ2VQcm9jZXNzb3IlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJzYWZldHlfY2hlY2tlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnN0YWJsZV9kaWZmdXNpb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJTdGFibGVEaWZmdXNpb25TYWZldHlDaGVja2VyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIyc2NoZWR1bGVyJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyUE5ETVNjaGVkdWxlciUyMiUwQSUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMnRleHRfZW5jb2RlciUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMnRyYW5zZm9ybWVycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMkNMSVBUZXh0TW9kZWwlMjIlMEElMjAlMjAlNUQlMkMlMEElMjAlMjAlMjJ0b2tlbml6ZXIlMjIlM0ElMjAlNUIlMEElMjAlMjAlMjAlMjAlMjJ0cmFuc2Zvcm1lcnMlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjJDTElQVG9rZW5pemVyJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydW5ldCUyMiUzQSUyMCU1QiUwQSUyMCUyMCUyMCUyMCUyMmRpZmZ1c2VycyUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMlVOZXQyRENvbmRpdGlvbk1vZGVsJTIyJTBBJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIydmFlJTIyJTNBJTIwJTVCJTBBJTIwJTIwJTIwJTIwJTIyZGlmZnVzZXJzJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyQXV0b2VuY29kZXJLTCUyMiUwQSUyMCUyMCU1RCUwQSU3RA==",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;_class_name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;StableDiffusionPipeline&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;_diffusers_version&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;0.6.0&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;feature_extractor&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPImageProcessor&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;safety_checker&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;stable_diffusion&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;StableDiffusionSafetyChecker&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;scheduler&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;PNDMScheduler&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;text_encoder&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTextModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;tokenizer&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;transformers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;CLIPTokenizer&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;unet&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;UNet2DConditionModel&quot;</span>
  <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;vae&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
    <span class="hljs-string">&quot;diffusers&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-string">&quot;AutoencoderKL&quot;</span>
  <span class="hljs-punctuation">]</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),{c(){m=i("meta"),J=n(),h=i("p"),T=n(),r(Z.$$.fragment),Ye=n(),r(j.$$.fragment),Ae=n(),v=i("p"),v.innerHTML=Js,Fe=n(),C=i("p"),C.innerHTML=Us,Le=n(),I=i("p"),I.textContent=Ts,Pe=n(),g=i("ul"),g.innerHTML=ws,Oe=n(),r(V.$$.fragment),Ke=n(),r(w.$$.fragment),el=n(),W=i("p"),W.innerHTML=bs,ll=n(),r(k.$$.fragment),sl=n(),R=i("p"),R.innerHTML=Zs,tl=n(),r(N.$$.fragment),nl=n(),B=i("p"),B.innerHTML=js,al=n(),r(G.$$.fragment),il=n(),r(_.$$.fragment),ol=n(),$=i("p"),$.innerHTML=vs,pl=n(),r(Q.$$.fragment),rl=n(),X=i("p"),X.innerHTML=Cs,cl=n(),r(E.$$.fragment),fl=n(),z=i("p"),z.innerHTML=Is,ul=n(),r(D.$$.fragment),dl=n(),S=i("p"),S.textContent=gs,Ml=n(),x=i("ul"),x.innerHTML=Vs,ml=n(),H=i("p"),H.innerHTML=Ws,yl=n(),r(q.$$.fragment),hl=n(),Y=i("p"),Y.innerHTML=ks,Jl=n(),A=i("p"),A.innerHTML=Rs,Ul=n(),r(F.$$.fragment),Tl=n(),r(L.$$.fragment),wl=n(),P=i("p"),P.innerHTML=Ns,bl=n(),r(O.$$.fragment),Zl=n(),r(K.$$.fragment),jl=n(),ee=i("p"),ee.innerHTML=Bs,vl=n(),r(le.$$.fragment),Cl=n(),se=i("p"),se.innerHTML=Gs,Il=n(),r(te.$$.fragment),gl=n(),ne=i("p"),ne.textContent=_s,Vl=n(),r(ae.$$.fragment),Wl=n(),r(ie.$$.fragment),kl=n(),oe=i("p"),oe.textContent=$s,Rl=n(),pe=i("ul"),pe.innerHTML=Qs,Nl=n(),r(b.$$.fragment),Bl=n(),re=i("p"),re.innerHTML=Xs,Gl=n(),ce=i("table"),ce.innerHTML=Es,_l=n(),fe=i("p"),fe.textContent=zs,$l=n(),ue=i("ul"),ue.innerHTML=Ds,Ql=n(),r(de.$$.fragment),Xl=n(),Me=i("p"),Me.innerHTML=Ss,El=n(),r(me.$$.fragment),zl=n(),ye=i("p"),ye.innerHTML=xs,Dl=n(),r(he.$$.fragment),Sl=n(),r(Je.$$.fragment),xl=n(),Ue=i("p"),Ue.innerHTML=Hs,Hl=n(),Te=i("p"),Te.innerHTML=qs,ql=n(),r(we.$$.fragment),Yl=n(),be=i("p"),be.innerHTML=Ys,Al=n(),r(Ze.$$.fragment),Fl=n(),je=i("p"),je.innerHTML=As,Ll=n(),r(ve.$$.fragment),Pl=n(),r(Ce.$$.fragment),Ol=n(),Ie=i("p"),Ie.innerHTML=Fs,Kl=n(),ge=i("p"),ge.innerHTML=Ls,es=n(),r(Ve.$$.fragment),ls=n(),r(We.$$.fragment),ss=n(),ke=i("p"),ke.innerHTML=Ps,ts=n(),Re=i("ul"),Re.innerHTML=Os,ns=n(),Ne=i("p"),Ne.innerHTML=Ks,as=n(),r(Be.$$.fragment),is=n(),Ge=i("p"),Ge.innerHTML=et,os=n(),_e=i("ul"),_e.innerHTML=lt,ps=n(),r($e.$$.fragment),rs=n(),Qe=i("p"),Qe.innerHTML=st,cs=n(),r(Xe.$$.fragment),fs=n(),Ee=i("p"),Ee.textContent=tt,us=n(),r(ze.$$.fragment),ds=n(),De=i("p"),De.innerHTML=nt,Ms=n(),Se=i("ul"),Se.innerHTML=at,ms=n(),r(xe.$$.fragment),ys=n(),qe=i("p"),this.h()},l(e){const l=yt("svelte-u9bgzb",document.head);m=o(l,"META",{name:!0,content:!0}),l.forEach(s),J=a(e),h=o(e,"P",{}),pt(h).forEach(s),T=a(e),c(Z.$$.fragment,e),Ye=a(e),c(j.$$.fragment,e),Ae=a(e),v=o(e,"P",{"data-svelte-h":!0}),p(v)!=="svelte-53uqsl"&&(v.innerHTML=Js),Fe=a(e),C=o(e,"P",{"data-svelte-h":!0}),p(C)!=="svelte-1let6ok"&&(C.innerHTML=Us),Le=a(e),I=o(e,"P",{"data-svelte-h":!0}),p(I)!=="svelte-b6mpdv"&&(I.textContent=Ts),Pe=a(e),g=o(e,"UL",{"data-svelte-h":!0}),p(g)!=="svelte-19eqgr5"&&(g.innerHTML=ws),Oe=a(e),c(V.$$.fragment,e),Ke=a(e),c(w.$$.fragment,e),el=a(e),W=o(e,"P",{"data-svelte-h":!0}),p(W)!=="svelte-qwj9aj"&&(W.innerHTML=bs),ll=a(e),c(k.$$.fragment,e),sl=a(e),R=o(e,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1gixk8"&&(R.innerHTML=Zs),tl=a(e),c(N.$$.fragment,e),nl=a(e),B=o(e,"P",{"data-svelte-h":!0}),p(B)!=="svelte-1dc1tjj"&&(B.innerHTML=js),al=a(e),c(G.$$.fragment,e),il=a(e),c(_.$$.fragment,e),ol=a(e),$=o(e,"P",{"data-svelte-h":!0}),p($)!=="svelte-zzamd0"&&($.innerHTML=vs),pl=a(e),c(Q.$$.fragment,e),rl=a(e),X=o(e,"P",{"data-svelte-h":!0}),p(X)!=="svelte-ooqzwz"&&(X.innerHTML=Cs),cl=a(e),c(E.$$.fragment,e),fl=a(e),z=o(e,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1rrtpof"&&(z.innerHTML=Is),ul=a(e),c(D.$$.fragment,e),dl=a(e),S=o(e,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1b4jg3u"&&(S.textContent=gs),Ml=a(e),x=o(e,"UL",{"data-svelte-h":!0}),p(x)!=="svelte-vp14rw"&&(x.innerHTML=Vs),ml=a(e),H=o(e,"P",{"data-svelte-h":!0}),p(H)!=="svelte-s7xu2t"&&(H.innerHTML=Ws),yl=a(e),c(q.$$.fragment,e),hl=a(e),Y=o(e,"P",{"data-svelte-h":!0}),p(Y)!=="svelte-oiur8s"&&(Y.innerHTML=ks),Jl=a(e),A=o(e,"P",{"data-svelte-h":!0}),p(A)!=="svelte-vmyofc"&&(A.innerHTML=Rs),Ul=a(e),c(F.$$.fragment,e),Tl=a(e),c(L.$$.fragment,e),wl=a(e),P=o(e,"P",{"data-svelte-h":!0}),p(P)!=="svelte-181junk"&&(P.innerHTML=Ns),bl=a(e),c(O.$$.fragment,e),Zl=a(e),c(K.$$.fragment,e),jl=a(e),ee=o(e,"P",{"data-svelte-h":!0}),p(ee)!=="svelte-bcrzpp"&&(ee.innerHTML=Bs),vl=a(e),c(le.$$.fragment,e),Cl=a(e),se=o(e,"P",{"data-svelte-h":!0}),p(se)!=="svelte-jytaak"&&(se.innerHTML=Gs),Il=a(e),c(te.$$.fragment,e),gl=a(e),ne=o(e,"P",{"data-svelte-h":!0}),p(ne)!=="svelte-1o7di1p"&&(ne.textContent=_s),Vl=a(e),c(ae.$$.fragment,e),Wl=a(e),c(ie.$$.fragment,e),kl=a(e),oe=o(e,"P",{"data-svelte-h":!0}),p(oe)!=="svelte-144ljdh"&&(oe.textContent=$s),Rl=a(e),pe=o(e,"UL",{"data-svelte-h":!0}),p(pe)!=="svelte-1j7sdrg"&&(pe.innerHTML=Qs),Nl=a(e),c(b.$$.fragment,e),Bl=a(e),re=o(e,"P",{"data-svelte-h":!0}),p(re)!=="svelte-q0e9bt"&&(re.innerHTML=Xs),Gl=a(e),ce=o(e,"TABLE",{"data-svelte-h":!0}),p(ce)!=="svelte-1e3wdtx"&&(ce.innerHTML=Es),_l=a(e),fe=o(e,"P",{"data-svelte-h":!0}),p(fe)!=="svelte-16brnlv"&&(fe.textContent=zs),$l=a(e),ue=o(e,"UL",{"data-svelte-h":!0}),p(ue)!=="svelte-11239e9"&&(ue.innerHTML=Ds),Ql=a(e),c(de.$$.fragment,e),Xl=a(e),Me=o(e,"P",{"data-svelte-h":!0}),p(Me)!=="svelte-5xjhnd"&&(Me.innerHTML=Ss),El=a(e),c(me.$$.fragment,e),zl=a(e),ye=o(e,"P",{"data-svelte-h":!0}),p(ye)!=="svelte-ydb193"&&(ye.innerHTML=xs),Dl=a(e),c(he.$$.fragment,e),Sl=a(e),c(Je.$$.fragment,e),xl=a(e),Ue=o(e,"P",{"data-svelte-h":!0}),p(Ue)!=="svelte-1iaekvo"&&(Ue.innerHTML=Hs),Hl=a(e),Te=o(e,"P",{"data-svelte-h":!0}),p(Te)!=="svelte-1y53na1"&&(Te.innerHTML=qs),ql=a(e),c(we.$$.fragment,e),Yl=a(e),be=o(e,"P",{"data-svelte-h":!0}),p(be)!=="svelte-7x7c45"&&(be.innerHTML=Ys),Al=a(e),c(Ze.$$.fragment,e),Fl=a(e),je=o(e,"P",{"data-svelte-h":!0}),p(je)!=="svelte-1khqwun"&&(je.innerHTML=As),Ll=a(e),c(ve.$$.fragment,e),Pl=a(e),c(Ce.$$.fragment,e),Ol=a(e),Ie=o(e,"P",{"data-svelte-h":!0}),p(Ie)!=="svelte-ni3i5z"&&(Ie.innerHTML=Fs),Kl=a(e),ge=o(e,"P",{"data-svelte-h":!0}),p(ge)!=="svelte-1hvfs4d"&&(ge.innerHTML=Ls),es=a(e),c(Ve.$$.fragment,e),ls=a(e),c(We.$$.fragment,e),ss=a(e),ke=o(e,"P",{"data-svelte-h":!0}),p(ke)!=="svelte-1n0mopo"&&(ke.innerHTML=Ps),ts=a(e),Re=o(e,"UL",{"data-svelte-h":!0}),p(Re)!=="svelte-pp3d4u"&&(Re.innerHTML=Os),ns=a(e),Ne=o(e,"P",{"data-svelte-h":!0}),p(Ne)!=="svelte-pckiaf"&&(Ne.innerHTML=Ks),as=a(e),c(Be.$$.fragment,e),is=a(e),Ge=o(e,"P",{"data-svelte-h":!0}),p(Ge)!=="svelte-ivy5n9"&&(Ge.innerHTML=et),os=a(e),_e=o(e,"UL",{"data-svelte-h":!0}),p(_e)!=="svelte-113lnuf"&&(_e.innerHTML=lt),ps=a(e),c($e.$$.fragment,e),rs=a(e),Qe=o(e,"P",{"data-svelte-h":!0}),p(Qe)!=="svelte-173hqz7"&&(Qe.innerHTML=st),cs=a(e),c(Xe.$$.fragment,e),fs=a(e),Ee=o(e,"P",{"data-svelte-h":!0}),p(Ee)!=="svelte-5jik9b"&&(Ee.textContent=tt),us=a(e),c(ze.$$.fragment,e),ds=a(e),De=o(e,"P",{"data-svelte-h":!0}),p(De)!=="svelte-1rizwab"&&(De.innerHTML=nt),Ms=a(e),Se=o(e,"UL",{"data-svelte-h":!0}),p(Se)!=="svelte-hr84vt"&&(Se.innerHTML=at),ms=a(e),c(xe.$$.fragment,e),ys=a(e),qe=o(e,"P",{}),pt(qe).forEach(s),this.h()},h(){rt(m,"name","hf:doc:metadata"),rt(m,"content",bt)},m(e,l){ht(document.head,m),t(e,J,l),t(e,h,l),t(e,T,l),f(Z,e,l),t(e,Ye,l),f(j,e,l),t(e,Ae,l),t(e,v,l),t(e,Fe,l),t(e,C,l),t(e,Le,l),t(e,I,l),t(e,Pe,l),t(e,g,l),t(e,Oe,l),f(V,e,l),t(e,Ke,l),f(w,e,l),t(e,el,l),t(e,W,l),t(e,ll,l),f(k,e,l),t(e,sl,l),t(e,R,l),t(e,tl,l),f(N,e,l),t(e,nl,l),t(e,B,l),t(e,al,l),f(G,e,l),t(e,il,l),f(_,e,l),t(e,ol,l),t(e,$,l),t(e,pl,l),f(Q,e,l),t(e,rl,l),t(e,X,l),t(e,cl,l),f(E,e,l),t(e,fl,l),t(e,z,l),t(e,ul,l),f(D,e,l),t(e,dl,l),t(e,S,l),t(e,Ml,l),t(e,x,l),t(e,ml,l),t(e,H,l),t(e,yl,l),f(q,e,l),t(e,hl,l),t(e,Y,l),t(e,Jl,l),t(e,A,l),t(e,Ul,l),f(F,e,l),t(e,Tl,l),f(L,e,l),t(e,wl,l),t(e,P,l),t(e,bl,l),f(O,e,l),t(e,Zl,l),f(K,e,l),t(e,jl,l),t(e,ee,l),t(e,vl,l),f(le,e,l),t(e,Cl,l),t(e,se,l),t(e,Il,l),f(te,e,l),t(e,gl,l),t(e,ne,l),t(e,Vl,l),f(ae,e,l),t(e,Wl,l),f(ie,e,l),t(e,kl,l),t(e,oe,l),t(e,Rl,l),t(e,pe,l),t(e,Nl,l),f(b,e,l),t(e,Bl,l),t(e,re,l),t(e,Gl,l),t(e,ce,l),t(e,_l,l),t(e,fe,l),t(e,$l,l),t(e,ue,l),t(e,Ql,l),f(de,e,l),t(e,Xl,l),t(e,Me,l),t(e,El,l),f(me,e,l),t(e,zl,l),t(e,ye,l),t(e,Dl,l),f(he,e,l),t(e,Sl,l),f(Je,e,l),t(e,xl,l),t(e,Ue,l),t(e,Hl,l),t(e,Te,l),t(e,ql,l),f(we,e,l),t(e,Yl,l),t(e,be,l),t(e,Al,l),f(Ze,e,l),t(e,Fl,l),t(e,je,l),t(e,Ll,l),f(ve,e,l),t(e,Pl,l),f(Ce,e,l),t(e,Ol,l),t(e,Ie,l),t(e,Kl,l),t(e,ge,l),t(e,es,l),f(Ve,e,l),t(e,ls,l),f(We,e,l),t(e,ss,l),t(e,ke,l),t(e,ts,l),t(e,Re,l),t(e,ns,l),t(e,Ne,l),t(e,as,l),f(Be,e,l),t(e,is,l),t(e,Ge,l),t(e,os,l),t(e,_e,l),t(e,ps,l),f($e,e,l),t(e,rs,l),t(e,Qe,l),t(e,cs,l),f(Xe,e,l),t(e,fs,l),t(e,Ee,l),t(e,us,l),f(ze,e,l),t(e,ds,l),t(e,De,l),t(e,Ms,l),t(e,Se,l),t(e,ms,l),f(xe,e,l),t(e,ys,l),t(e,qe,l),hs=!0},p(e,[l]){const it={};l&2&&(it.$$scope={dirty:l,ctx:e}),w.$set(it);const ot={};l&2&&(ot.$$scope={dirty:l,ctx:e}),b.$set(ot)},i(e){hs||(u(Z.$$.fragment,e),u(j.$$.fragment,e),u(V.$$.fragment,e),u(w.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(G.$$.fragment,e),u(_.$$.fragment,e),u(Q.$$.fragment,e),u(E.$$.fragment,e),u(D.$$.fragment,e),u(q.$$.fragment,e),u(F.$$.fragment,e),u(L.$$.fragment,e),u(O.$$.fragment,e),u(K.$$.fragment,e),u(le.$$.fragment,e),u(te.$$.fragment,e),u(ae.$$.fragment,e),u(ie.$$.fragment,e),u(b.$$.fragment,e),u(de.$$.fragment,e),u(me.$$.fragment,e),u(he.$$.fragment,e),u(Je.$$.fragment,e),u(we.$$.fragment,e),u(Ze.$$.fragment,e),u(ve.$$.fragment,e),u(Ce.$$.fragment,e),u(Ve.$$.fragment,e),u(We.$$.fragment,e),u(Be.$$.fragment,e),u($e.$$.fragment,e),u(Xe.$$.fragment,e),u(ze.$$.fragment,e),u(xe.$$.fragment,e),hs=!0)},o(e){d(Z.$$.fragment,e),d(j.$$.fragment,e),d(V.$$.fragment,e),d(w.$$.fragment,e),d(k.$$.fragment,e),d(N.$$.fragment,e),d(G.$$.fragment,e),d(_.$$.fragment,e),d(Q.$$.fragment,e),d(E.$$.fragment,e),d(D.$$.fragment,e),d(q.$$.fragment,e),d(F.$$.fragment,e),d(L.$$.fragment,e),d(O.$$.fragment,e),d(K.$$.fragment,e),d(le.$$.fragment,e),d(te.$$.fragment,e),d(ae.$$.fragment,e),d(ie.$$.fragment,e),d(b.$$.fragment,e),d(de.$$.fragment,e),d(me.$$.fragment,e),d(he.$$.fragment,e),d(Je.$$.fragment,e),d(we.$$.fragment,e),d(Ze.$$.fragment,e),d(ve.$$.fragment,e),d(Ce.$$.fragment,e),d(Ve.$$.fragment,e),d(We.$$.fragment,e),d(Be.$$.fragment,e),d($e.$$.fragment,e),d(Xe.$$.fragment,e),d(ze.$$.fragment,e),d(xe.$$.fragment,e),hs=!1},d(e){e&&(s(J),s(h),s(T),s(Ye),s(Ae),s(v),s(Fe),s(C),s(Le),s(I),s(Pe),s(g),s(Oe),s(Ke),s(el),s(W),s(ll),s(sl),s(R),s(tl),s(nl),s(B),s(al),s(il),s(ol),s($),s(pl),s(rl),s(X),s(cl),s(fl),s(z),s(ul),s(dl),s(S),s(Ml),s(x),s(ml),s(H),s(yl),s(hl),s(Y),s(Jl),s(A),s(Ul),s(Tl),s(wl),s(P),s(bl),s(Zl),s(jl),s(ee),s(vl),s(Cl),s(se),s(Il),s(gl),s(ne),s(Vl),s(Wl),s(kl),s(oe),s(Rl),s(pe),s(Nl),s(Bl),s(re),s(Gl),s(ce),s(_l),s(fe),s($l),s(ue),s(Ql),s(Xl),s(Me),s(El),s(zl),s(ye),s(Dl),s(Sl),s(xl),s(Ue),s(Hl),s(Te),s(ql),s(Yl),s(be),s(Al),s(Fl),s(je),s(Ll),s(Pl),s(Ol),s(Ie),s(Kl),s(ge),s(es),s(ls),s(ss),s(ke),s(ts),s(Re),s(ns),s(Ne),s(as),s(is),s(Ge),s(os),s(_e),s(ps),s(rs),s(Qe),s(cs),s(fs),s(Ee),s(us),s(ds),s(De),s(Ms),s(Se),s(ms),s(ys),s(qe)),s(m),M(Z,e),M(j,e),M(V,e),M(w,e),M(k,e),M(N,e),M(G,e),M(_,e),M(Q,e),M(E,e),M(D,e),M(q,e),M(F,e),M(L,e),M(O,e),M(K,e),M(le,e),M(te,e),M(ae,e),M(ie,e),M(b,e),M(de,e),M(me,e),M(he,e),M(Je,e),M(we,e),M(Ze,e),M(ve,e),M(Ce,e),M(Ve,e),M(We,e),M(Be,e),M($e,e),M(Xe,e),M(ze,e),M(xe,e)}}}const bt='{"title":"Load pipelines, models, and schedulers","local":"load-pipelines-models-and-schedulers","sections":[{"title":"Diffusion Pipeline","local":"diffusion-pipeline","sections":[{"title":"Local pipeline","local":"local-pipeline","sections":[],"depth":3},{"title":"Swap components in a pipeline","local":"swap-components-in-a-pipeline","sections":[],"depth":3},{"title":"Safety checker","local":"safety-checker","sections":[],"depth":3},{"title":"Reuse components across pipelines","local":"reuse-components-across-pipelines","sections":[],"depth":3}],"depth":2},{"title":"Checkpoint variants","local":"checkpoint-variants","sections":[],"depth":2},{"title":"Models","local":"models","sections":[],"depth":2},{"title":"Schedulers","local":"schedulers","sections":[],"depth":2},{"title":"DiffusionPipeline explained","local":"diffusionpipeline-explained","sections":[],"depth":2}],"depth":1}';function Zt(He){return dt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Wt extends Mt{constructor(m){super(),mt(this,m,Zt,wt,ut,{})}}export{Wt as component};
