import{s as ct,o as ut,n as He}from"../chunks/scheduler.182ea377.js";import{S as mt,i as dt,g as o,s as n,r as m,A as ht,h as p,f as s,c as a,j as pt,u as d,x as r,k as rt,y as yt,a as l,v as h,d as y,t as b,w as M}from"../chunks/index.abf12888.js";import{T as Xe}from"../chunks/Tip.230e2334.js";import{C as te}from"../chunks/CodeBlock.57fe6e13.js";import{D as bt}from"../chunks/DocNotebookDropdown.d9060979.js";import{H as le}from"../chunks/Heading.16916d63.js";function Mt(J){let i,w='💡 We strongly recommend reading PyTorch’s <a href="https://pytorch.org/docs/stable/notes/randomness.html" rel="nofollow">statement about reproducibility</a>:',c,u,T="<p>Completely reproducible results are not guaranteed across PyTorch releases, individual commits, or different platforms. Furthermore, results may not be reproducible between CPU and GPU executions, even when using identical seeds.</p>";return{c(){i=o("p"),i.innerHTML=w,c=n(),u=o("blockquote"),u.innerHTML=T},l(f){i=p(f,"P",{"data-svelte-h":!0}),r(i)!=="svelte-mk56g"&&(i.innerHTML=w),c=a(f),u=p(f,"BLOCKQUOTE",{"data-svelte-h":!0}),r(u)!=="svelte-16ppwuq"&&(u.innerHTML=T)},m(f,j){l(f,i,j),l(f,c,j),l(f,u,j)},p:He,d(f){f&&(s(i),s(c),s(u))}}}function ft(J){let i,w=`💡 It might be a bit unintuitive at first to pass <code>Generator</code> objects to the pipeline instead of
just integer values representing the seed, but this is the recommended design when dealing with
probabilistic models in PyTorch as <code>Generator</code>’s are <em>random states</em> that can be
passed to multiple pipelines in a sequence.`;return{c(){i=o("p"),i.innerHTML=w},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-1dliima"&&(i.innerHTML=w)},m(c,u){l(c,i,u)},p:He,d(c){c&&s(i)}}}function wt(J){let i,w=`💡 If reproducibility is important, we recommend always passing a CPU generator.
The performance loss is often neglectable, and you’ll generate much more similar
values than if the pipeline had been run on a GPU.`;return{c(){i=o("p"),i.textContent=w},l(c){i=p(c,"P",{"data-svelte-h":!0}),r(i)!=="svelte-6qqsvj"&&(i.textContent=w)},m(c,u){l(c,i,u)},p:He,d(c){c&&s(i)}}}function jt(J){let i,w,c,u,T,f,j,ne,W,xe='Reproducibility is important for testing, replicating results, and can even be used to <a href="reusing_seeds">improve image quality</a>. However, the randomness in diffusion models is a desired property because it allows the pipeline to generate different images every time it is run. While you can’t expect to get the exact same results across platforms, you can expect results to be reproducible across releases and platforms within a certain tolerance range. Even then, tolerance varies depending on the diffusion pipeline and checkpoint.',ae,B,Pe="This is why it’s important to understand how to control sources of randomness in diffusion models or use deterministic algorithms.",ie,g,oe,$,pe,I,Fe=`During inference, pipelines rely heavily on random sampling operations which include creating the
Gaussian noise tensors to denoise and adding noise to the scheduling step.`,re,v,ze='Take a look at the tensor values in the <a href="/docs/diffusers/v0.23.0/en/api/pipelines/ddim#diffusers.DDIMPipeline">DDIMPipeline</a> after two inference steps:',ce,G,ue,k,Qe="Running the code above prints one value, but if you run it again you get a different value. What is going on here?",me,_,Se='Every time the pipeline is run, <a href="https://pytorch.org/docs/stable/generated/torch.randn.html" rel="nofollow"><code>torch.randn</code></a> uses a different random seed to create Gaussian noise which is denoised stepwise. This leads to a different result each time it is run, which is great for diffusion pipelines since it generates a different random image each time.',de,C,Ne="But if you need to reliably generate the same image, that’ll depend on whether you’re running the pipeline on a CPU or GPU.",he,V,ye,R,qe='To generate reproducible results on a CPU, you’ll need to use a PyTorch <a href="https://pytorch.org/docs/stable/generated/torch.randn.html" rel="nofollow"><code>Generator</code></a> and set a seed:',be,E,Me,X,Ye="Now when you run the code above, it always prints a value of <code>1491.1711</code> no matter what because the <code>Generator</code> object with the seed is passed to all the random functions of the pipeline.",fe,H,Le="If you run this code example on your specific hardware and PyTorch version, you should get a similar, if not the same, result.",we,U,je,x,Te,P,De="Writing a reproducible pipeline on a GPU is a bit trickier, and full reproducibility across different hardware is not guaranteed because matrix multiplication - which diffusion pipelines require a lot of - is less deterministic on a GPU than a CPU. For example, if you run the same code example above on a GPU:",Je,F,ge,z,Ae="The result is not the same even though you’re using an identical seed because the GPU uses a different random number generator than the CPU.",Ue,Q,Ke="To circumvent this problem, 🧨 Diffusers has a <code>randn_tensor()</code> function for creating random noise on the CPU, and then moving the tensor to a GPU if necessary. The <code>randn_tensor</code> function is used everywhere inside the pipeline, allowing the user to <strong>always</strong> pass a CPU <code>Generator</code> even if the pipeline is run on a GPU.",Ze,S,Oe="You’ll see the results are much closer now!",We,N,Be,Z,$e,q,et=`Finally, for more complex pipelines such as <a href="/docs/diffusers/v0.23.0/en/api/pipelines/unclip#diffusers.UnCLIPPipeline">UnCLIPPipeline</a>, these are often extremely
susceptible to precision error propagation. Don’t expect similar results across
different GPU hardware or PyTorch versions. In this case, you’ll need to run
exactly the same hardware and PyTorch version for full reproducibility.`,Ie,Y,ve,L,tt="You can also configure PyTorch to use deterministic algorithms to create a reproducible pipeline. However, you should be aware that deterministic algorithms may be slower than nondeterministic ones and you may observe a decrease in performance. But if reproducibility is important to you, then this is the way to go!",Ge,D,st='Nondeterministic behavior occurs when operations are launched in more than one CUDA stream. To avoid this, set the environment variable <a href="https://docs.nvidia.com/cuda/cublas/index.html#results-reproducibility" rel="nofollow"><code>CUBLAS_WORKSPACE_CONFIG</code></a> to <code>:16:8</code> to only use one buffer size during runtime.',ke,A,lt='PyTorch typically benchmarks multiple algorithms to select the fastest one, but if you want reproducibility, you should disable this feature because the benchmark may select different algorithms each time. Lastly, pass <code>True</code> to <a href="https://pytorch.org/docs/stable/generated/torch.use_deterministic_algorithms.html" rel="nofollow"><code>torch.use_deterministic_algorithms</code></a> to enable deterministic algorithms.',_e,K,Ce,O,nt="Now when you run the same pipeline twice, you’ll get identical results.",Ve,ee,Re,se,Ee;return T=new le({props:{title:"Create reproducible pipelines",local:"create-reproducible-pipelines",headingTag:"h1"}}),j=new bt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/reproducibility.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/reproducibility.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/reproducibility.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/reproducibility.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/reproducibility.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/reproducibility.ipynb"}]}}),g=new Xe({props:{$$slots:{default:[Mt]},$$scope:{ctx:J}}}),$=new le({props:{title:"Control randomness",local:"control-randomness",headingTag:"h2"}}),G=new te({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERESU1QaXBlbGluZSUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQSUwQW1vZGVsX2lkJTIwJTNEJTIwJTIyZ29vZ2xlJTJGZGRwbS1jaWZhcjEwLTMyJTIyJTBBJTBBJTIzJTIwbG9hZCUyMG1vZGVsJTIwYW5kJTIwc2NoZWR1bGVyJTBBZGRpbSUyMCUzRCUyMERESU1QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKSUwQSUwQSUyMyUyMHJ1biUyMHBpcGVsaW5lJTIwZm9yJTIwanVzdCUyMHR3byUyMHN0ZXBzJTIwYW5kJTIwcmV0dXJuJTIwbnVtcHklMjB0ZW5zb3IlMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),V=new le({props:{title:"CPU",local:"cpu",headingTag:"h3"}}),E=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBJTBBJTIzJTIwY3JlYXRlJTIwYSUyMGdlbmVyYXRvciUyMGZvciUyMHJlcHJvZHVjaWJpbGl0eSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjcHUlMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBJTIzJTIwcnVuJTIwcGlwZWxpbmUlMjBmb3IlMjBqdXN0JTIwdHdvJTIwc3RlcHMlMjBhbmQlMjByZXR1cm4lMjBudW1weSUyMHRlbnNvciUwQWltYWdlJTIwJTNEJTIwZGRpbShudW1faW5mZXJlbmNlX3N0ZXBzJTNEMiUyQyUyMG91dHB1dF90eXBlJTNEJTIybnAlMjIlMkMlMjBnZW5lcmF0b3IlM0RnZW5lcmF0b3IpLmltYWdlcyUwQXByaW50KG5wLmFicyhpbWFnZSkuc3VtKCkp",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># create a generator for reproducibility</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cpu&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),U=new Xe({props:{$$slots:{default:[ft]},$$scope:{ctx:J}}}),x=new le({props:{title:"GPU",local:"gpu",headingTag:"h3"}}),F=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBZGRpbS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMGElMjBnZW5lcmF0b3IlMjBmb3IlMjByZXByb2R1Y2liaWxpdHklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjBwaXBlbGluZSUyMGZvciUyMGp1c3QlMjB0d28lMjBzdGVwcyUyMGFuZCUyMHJldHVybiUyMG51bXB5JTIwdGVuc29yJTBBaW1hZ2UlMjAlM0QlMjBkZGltKG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyJTJDJTIwb3V0cHV0X3R5cGUlM0QlMjJucCUyMiUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvcikuaW1hZ2VzJTBBcHJpbnQobnAuYWJzKGltYWdlKS5zdW0oKSk=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># create a generator for reproducibility</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),N=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJnb29nbGUlMkZkZHBtLWNpZmFyMTAtMzIlMjIlMEElMEElMjMlMjBsb2FkJTIwbW9kZWwlMjBhbmQlMjBzY2hlZHVsZXIlMEFkZGltJTIwJTNEJTIwRERJTVBpcGVsaW5lLmZyb21fcHJldHJhaW5lZChtb2RlbF9pZCUyQyUyMHVzZV9zYWZldGVuc29ycyUzRFRydWUpJTBBZGRpbS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGNyZWF0ZSUyMGElMjBnZW5lcmF0b3IlMjBmb3IlMjByZXByb2R1Y2liaWxpdHklM0IlMjBub3RpY2UlMjB5b3UlMjBkb24ndCUyMHBsYWNlJTIwaXQlMjBvbiUyMHRoZSUyMEdQVSElMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5tYW51YWxfc2VlZCgwKSUwQSUwQSUyMyUyMHJ1biUyMHBpcGVsaW5lJTIwZm9yJTIwanVzdCUyMHR3byUyMHN0ZXBzJTIwYW5kJTIwcmV0dXJuJTIwbnVtcHklMjB0ZW5zb3IlMEFpbWFnZSUyMCUzRCUyMGRkaW0obnVtX2luZmVyZW5jZV9zdGVwcyUzRDIlMkMlMjBvdXRwdXRfdHlwZSUzRCUyMm5wJTIyJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKS5pbWFnZXMlMEFwcmludChucC5hYnMoaW1hZ2UpLnN1bSgpKQ==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;google/ddpm-cifar10-32&quot;</span>

<span class="hljs-comment"># load model and scheduler</span>
ddim = DDIMPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>)
ddim.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># create a generator for reproducibility; notice you don&#x27;t place it on the GPU!</span>
generator = torch.manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-comment"># run pipeline for just two steps and return numpy tensor</span>
image = ddim(num_inference_steps=<span class="hljs-number">2</span>, output_type=<span class="hljs-string">&quot;np&quot;</span>, generator=generator).images
<span class="hljs-built_in">print</span>(np.<span class="hljs-built_in">abs</span>(image).<span class="hljs-built_in">sum</span>())`,wrap:!1}}),Z=new Xe({props:{$$slots:{default:[wt]},$$scope:{ctx:J}}}),Y=new le({props:{title:"Deterministic algorithms",local:"deterministic-algorithms",headingTag:"h2"}}),K=new te({props:{code:"aW1wb3J0JTIwb3MlMEElMEFvcy5lbnZpcm9uJTVCJTIyQ1VCTEFTX1dPUktTUEFDRV9DT05GSUclMjIlNUQlMjAlM0QlMjAlMjIlM0ExNiUzQTglMjIlMEElMEF0b3JjaC5iYWNrZW5kcy5jdWRubi5iZW5jaG1hcmslMjAlM0QlMjBGYWxzZSUwQXRvcmNoLnVzZV9kZXRlcm1pbmlzdGljX2FsZ29yaXRobXMoVHJ1ZSk=",highlighted:`<span class="hljs-keyword">import</span> os

os.environ[<span class="hljs-string">&quot;CUBLAS_WORKSPACE_CONFIG&quot;</span>] = <span class="hljs-string">&quot;:16:8&quot;</span>

torch.backends.cudnn.benchmark = <span class="hljs-literal">False</span>
torch.use_deterministic_algorithms(<span class="hljs-literal">True</span>)`,wrap:!1}}),ee=new te({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzJTIwaW1wb3J0JTIwRERJTVNjaGVkdWxlciUyQyUyMFN0YWJsZURpZmZ1c2lvblBpcGVsaW5lJTBBaW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBbW9kZWxfaWQlMjAlM0QlMjAlMjJydW53YXltbCUyRnN0YWJsZS1kaWZmdXNpb24tdjEtNSUyMiUwQXBpcGUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQobW9kZWxfaWQlMkMlMjB1c2Vfc2FmZXRlbnNvcnMlM0RUcnVlKS50byglMjJjdWRhJTIyKSUwQXBpcGUuc2NoZWR1bGVyJTIwJTNEJTIwRERJTVNjaGVkdWxlci5mcm9tX2NvbmZpZyhwaXBlLnNjaGVkdWxlci5jb25maWcpJTBBZyUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvcihkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBiZWFyJTIwaXMlMjBwbGF5aW5nJTIwYSUyMGd1aXRhciUyMG9uJTIwVGltZXMlMjBTcXVhcmUlMjIlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MSUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFnLm1hbnVhbF9zZWVkKDApJTBBcmVzdWx0MiUyMCUzRCUyMHBpcGUocHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDUwJTJDJTIwZ2VuZXJhdG9yJTNEZyUyQyUyMG91dHB1dF90eXBlJTNEJTIybGF0ZW50JTIyKS5pbWFnZXMlMEElMEFwcmludCglMjJMX2luZiUyMGRpc3QlMjAlM0QlMjAlMjIlMkMlMjBhYnMocmVzdWx0MSUyMC0lMjByZXN1bHQyKS5tYXgoKSklMEElMjJMX2luZiUyMGRpc3QlMjAlM0QlMjAlMjB0ZW5zb3IoMC4lMkMlMjBkZXZpY2UlM0QnY3VkYSUzQTAnKSUyMg==",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DDIMScheduler, StableDiffusionPipeline
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

model_id = <span class="hljs-string">&quot;runwayml/stable-diffusion-v1-5&quot;</span>
pipe = StableDiffusionPipeline.from_pretrained(model_id, use_safetensors=<span class="hljs-literal">True</span>).to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipe.scheduler = DDIMScheduler.from_config(pipe.scheduler.config)
g = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A bear is playing a guitar on Times Square&quot;</span>

g.manual_seed(<span class="hljs-number">0</span>)
result1 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

g.manual_seed(<span class="hljs-number">0</span>)
result2 = pipe(prompt=prompt, num_inference_steps=<span class="hljs-number">50</span>, generator=g, output_type=<span class="hljs-string">&quot;latent&quot;</span>).images

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;L_inf dist = &quot;</span>, <span class="hljs-built_in">abs</span>(result1 - result2).<span class="hljs-built_in">max</span>())
<span class="hljs-string">&quot;L_inf dist =  tensor(0., device=&#x27;cuda:0&#x27;)&quot;</span>`,wrap:!1}}),{c(){i=o("meta"),w=n(),c=o("p"),u=n(),m(T.$$.fragment),f=n(),m(j.$$.fragment),ne=n(),W=o("p"),W.innerHTML=xe,ae=n(),B=o("p"),B.textContent=Pe,ie=n(),m(g.$$.fragment),oe=n(),m($.$$.fragment),pe=n(),I=o("p"),I.textContent=Fe,re=n(),v=o("p"),v.innerHTML=ze,ce=n(),m(G.$$.fragment),ue=n(),k=o("p"),k.textContent=Qe,me=n(),_=o("p"),_.innerHTML=Se,de=n(),C=o("p"),C.textContent=Ne,he=n(),m(V.$$.fragment),ye=n(),R=o("p"),R.innerHTML=qe,be=n(),m(E.$$.fragment),Me=n(),X=o("p"),X.innerHTML=Ye,fe=n(),H=o("p"),H.textContent=Le,we=n(),m(U.$$.fragment),je=n(),m(x.$$.fragment),Te=n(),P=o("p"),P.textContent=De,Je=n(),m(F.$$.fragment),ge=n(),z=o("p"),z.textContent=Ae,Ue=n(),Q=o("p"),Q.innerHTML=Ke,Ze=n(),S=o("p"),S.textContent=Oe,We=n(),m(N.$$.fragment),Be=n(),m(Z.$$.fragment),$e=n(),q=o("p"),q.innerHTML=et,Ie=n(),m(Y.$$.fragment),ve=n(),L=o("p"),L.textContent=tt,Ge=n(),D=o("p"),D.innerHTML=st,ke=n(),A=o("p"),A.innerHTML=lt,_e=n(),m(K.$$.fragment),Ce=n(),O=o("p"),O.textContent=nt,Ve=n(),m(ee.$$.fragment),Re=n(),se=o("p"),this.h()},l(e){const t=ht("svelte-u9bgzb",document.head);i=p(t,"META",{name:!0,content:!0}),t.forEach(s),w=a(e),c=p(e,"P",{}),pt(c).forEach(s),u=a(e),d(T.$$.fragment,e),f=a(e),d(j.$$.fragment,e),ne=a(e),W=p(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1sdj1n4"&&(W.innerHTML=xe),ae=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-spyond"&&(B.textContent=Pe),ie=a(e),d(g.$$.fragment,e),oe=a(e),d($.$$.fragment,e),pe=a(e),I=p(e,"P",{"data-svelte-h":!0}),r(I)!=="svelte-1tn5oba"&&(I.textContent=Fe),re=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-1ekag1v"&&(v.innerHTML=ze),ce=a(e),d(G.$$.fragment,e),ue=a(e),k=p(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-6e7pfa"&&(k.textContent=Qe),me=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-mhfmil"&&(_.innerHTML=Se),de=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-opovkl"&&(C.textContent=Ne),he=a(e),d(V.$$.fragment,e),ye=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-z8s4z5"&&(R.innerHTML=qe),be=a(e),d(E.$$.fragment,e),Me=a(e),X=p(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-jf8pj"&&(X.innerHTML=Ye),fe=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1mz2u42"&&(H.textContent=Le),we=a(e),d(U.$$.fragment,e),je=a(e),d(x.$$.fragment,e),Te=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-vhxkpf"&&(P.textContent=De),Je=a(e),d(F.$$.fragment,e),ge=a(e),z=p(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1tpavxr"&&(z.textContent=Ae),Ue=a(e),Q=p(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-oj1ygm"&&(Q.innerHTML=Ke),Ze=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-v5oouu"&&(S.textContent=Oe),We=a(e),d(N.$$.fragment,e),Be=a(e),d(Z.$$.fragment,e),$e=a(e),q=p(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ddow2w"&&(q.innerHTML=et),Ie=a(e),d(Y.$$.fragment,e),ve=a(e),L=p(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-j2780s"&&(L.textContent=tt),Ge=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-10j1qq1"&&(D.innerHTML=st),ke=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ncc9dd"&&(A.innerHTML=lt),_e=a(e),d(K.$$.fragment,e),Ce=a(e),O=p(e,"P",{"data-svelte-h":!0}),r(O)!=="svelte-b9yuf0"&&(O.textContent=nt),Ve=a(e),d(ee.$$.fragment,e),Re=a(e),se=p(e,"P",{}),pt(se).forEach(s),this.h()},h(){rt(i,"name","hf:doc:metadata"),rt(i,"content",Tt)},m(e,t){yt(document.head,i),l(e,w,t),l(e,c,t),l(e,u,t),h(T,e,t),l(e,f,t),h(j,e,t),l(e,ne,t),l(e,W,t),l(e,ae,t),l(e,B,t),l(e,ie,t),h(g,e,t),l(e,oe,t),h($,e,t),l(e,pe,t),l(e,I,t),l(e,re,t),l(e,v,t),l(e,ce,t),h(G,e,t),l(e,ue,t),l(e,k,t),l(e,me,t),l(e,_,t),l(e,de,t),l(e,C,t),l(e,he,t),h(V,e,t),l(e,ye,t),l(e,R,t),l(e,be,t),h(E,e,t),l(e,Me,t),l(e,X,t),l(e,fe,t),l(e,H,t),l(e,we,t),h(U,e,t),l(e,je,t),h(x,e,t),l(e,Te,t),l(e,P,t),l(e,Je,t),h(F,e,t),l(e,ge,t),l(e,z,t),l(e,Ue,t),l(e,Q,t),l(e,Ze,t),l(e,S,t),l(e,We,t),h(N,e,t),l(e,Be,t),h(Z,e,t),l(e,$e,t),l(e,q,t),l(e,Ie,t),h(Y,e,t),l(e,ve,t),l(e,L,t),l(e,Ge,t),l(e,D,t),l(e,ke,t),l(e,A,t),l(e,_e,t),h(K,e,t),l(e,Ce,t),l(e,O,t),l(e,Ve,t),h(ee,e,t),l(e,Re,t),l(e,se,t),Ee=!0},p(e,[t]){const at={};t&2&&(at.$$scope={dirty:t,ctx:e}),g.$set(at);const it={};t&2&&(it.$$scope={dirty:t,ctx:e}),U.$set(it);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),Z.$set(ot)},i(e){Ee||(y(T.$$.fragment,e),y(j.$$.fragment,e),y(g.$$.fragment,e),y($.$$.fragment,e),y(G.$$.fragment,e),y(V.$$.fragment,e),y(E.$$.fragment,e),y(U.$$.fragment,e),y(x.$$.fragment,e),y(F.$$.fragment,e),y(N.$$.fragment,e),y(Z.$$.fragment,e),y(Y.$$.fragment,e),y(K.$$.fragment,e),y(ee.$$.fragment,e),Ee=!0)},o(e){b(T.$$.fragment,e),b(j.$$.fragment,e),b(g.$$.fragment,e),b($.$$.fragment,e),b(G.$$.fragment,e),b(V.$$.fragment,e),b(E.$$.fragment,e),b(U.$$.fragment,e),b(x.$$.fragment,e),b(F.$$.fragment,e),b(N.$$.fragment,e),b(Z.$$.fragment,e),b(Y.$$.fragment,e),b(K.$$.fragment,e),b(ee.$$.fragment,e),Ee=!1},d(e){e&&(s(w),s(c),s(u),s(f),s(ne),s(W),s(ae),s(B),s(ie),s(oe),s(pe),s(I),s(re),s(v),s(ce),s(ue),s(k),s(me),s(_),s(de),s(C),s(he),s(ye),s(R),s(be),s(Me),s(X),s(fe),s(H),s(we),s(je),s(Te),s(P),s(Je),s(ge),s(z),s(Ue),s(Q),s(Ze),s(S),s(We),s(Be),s($e),s(q),s(Ie),s(ve),s(L),s(Ge),s(D),s(ke),s(A),s(_e),s(Ce),s(O),s(Ve),s(Re),s(se)),s(i),M(T,e),M(j,e),M(g,e),M($,e),M(G,e),M(V,e),M(E,e),M(U,e),M(x,e),M(F,e),M(N,e),M(Z,e),M(Y,e),M(K,e),M(ee,e)}}}const Tt='{"title":"Create reproducible pipelines","local":"create-reproducible-pipelines","sections":[{"title":"Control randomness","local":"control-randomness","sections":[{"title":"CPU","local":"cpu","sections":[],"depth":3},{"title":"GPU","local":"gpu","sections":[],"depth":3}],"depth":2},{"title":"Deterministic algorithms","local":"deterministic-algorithms","sections":[],"depth":2}],"depth":1}';function Jt(J){return ut(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class It extends mt{constructor(i){super(),dt(this,i,Jt,jt,ct,{})}}export{It as component};
