import{s as zs,n as ks,o as Vs}from"../chunks/scheduler.9680c161.js";import{S as Rs,i as Xs,g as J,s as a,r as j,A as Ys,h as T,f as M,c as n,j as es,u as I,x as p,k as vs,y as ws,a as t,v as y,d as e,t as w,w as o}from"../chunks/index.38d74ee1.js";import{C as c}from"../chunks/CodeBlock.1371964c.js";import{H as U,E as xs}from"../chunks/EditOnGithub.1c840068.js";function $s(os){let i,pl,wl,Ul,A,il,r,ps='Text Generation Inference (TGI) now supports <a href="#grammar-and-constraints">JSON and regex grammars</a> and <a href="#tools-and-functions">tools and functions</a> to help developers guide LLM responses to fit their needs.',ul,C,Us='These feature are available starting from version <code>1.4.3</code>. They are accessible via the <a href="https://pypi.org/project/text-generation/" rel="nofollow">text_generation</a> library.  The tool support is compatible with OpenAI’s client libraries. The following guide will walk you through the new features and how to use them!',cl,h,is="<p>The Grammar guidance support is currently only available in the TGI API due to lack of support in Open AI API.</p>",Al,m,rl,q,us="Before we jump into the deep end, ensure your system is using TGI version <code>1.4.3</code> or later to access all the features we’re about to explore in this guide.",Cl,d,cs="If you’re not up to date, grab the latest version and let’s get started!",hl,b,ml,B,As='TGI leverages the <a href="https://github.com/outlines-dev/outlines" rel="nofollow">outlines</a> library to efficiently parse and compile the grammatical structures and tools specified by users. This integration transforms the defined grammars into an intermediate representation that acts as a framework to guide and constrain content generation, ensuring that outputs adhere to the specified grammatical rules.',ql,E,dl,g,bl,Q,rs='<li><a href="#the-grammar-parameter">The Grammar Parameter</a>: Shape your AI’s responses with precision.</li> <li><a href="#constrain-with-pydantic">Constrain with Pydantic</a>: Define a grammar using Pydantic models.</li> <li><a href="#json-schema-integration">JSON Schema Integration</a>: Fine-grained control over your requests via JSON schema.</li> <li><a href="#using-the-client">Using the client</a>: Use TGI’s client libraries to shape the AI’s responses.</li>',Bl,f,El,N,Cs='<li><a href="#the-tools-parameter">The Tools Parameter</a>: Enhance the AI’s capabilities with predefined functions.</li> <li><a href="#text-generation-inference-client">Via the client</a>: Use TGI’s client libraries to interact with the Messages API and Tool functions.</li> <li><a href="#openai-integration">OpenAI integration</a>: Use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.</li>',gl,G,Ql,Z,fl,W,hs="In TGI <code>1.4.3</code>, we’ve introduced the grammar parameter, which allows you to specify the format of the response you want from the AI. This is a game-changer for those who need precise control over the AI’s output.",Nl,S,ms='Using curl, you can make a request to TGI’s Messages API with the grammar parameter. This is the most primitive way to interact with the API and using <a href="#constrain-with-pydantic">Pydantic</a> is recommended for ease of use and readability.',Gl,v,Zl,z,qs="A grammar can be defined using Pydantic models, JSON schemas, or regular expressions. The AI will then generate a response that conforms to the specified grammar.",Wl,k,ds="<p>Note: A grammar must compile to an intermediate representation to constrain the output. Grammar compilation is a computationally expensive and may take a few seconds to complete on the first request. Subsequent requests will use the cached grammar and will be much faster.</p>",Sl,V,vl,R,bs="Pydantic is a powerful library for data validation and settings management. It’s the perfect tool for crafting the a specific response format.",zl,X,Bs="Using Pydantic models we can define a similar grammar as the previous example in a shorter and more readable way.",kl,Y,Vl,x,Rl,$,Es="If Pydantic’s not your style, go raw with direct JSON Schema integration. It’s like having a conversation with the AI in its own language. This is simliar to the first example but with programmatic control.",Xl,H,Yl,F,xl,_,gs="TGI provides a client library to that make it easy to send requests with all of the parameters we’ve discussed above. Here’s an example of how to use the client to send a request with a grammar parameter.",$l,D,Hl,P,Fl,L,_l,O,Qs="In addition to the grammar parameter, we’ve also introduced a set of tools and functions to help you get the most out of the Messages API.",Dl,K,fs="Tools are a set of user defined functions that can be used in tandem with the chat functionality to enhance the AI’s capabilities. You can use these tools to perform a variety of tasks, such as data manipulation, formatting, and more.",Pl,ll,Ns="Functions, similar to grammar are defined as JSON schema and can be passed as part of the parameters to the Messages API.",Ll,sl,Ol,u,el,Gs="Tools used in example below",ys,Ml,Kl,tl,ls,al,Zs="TGI provides a client library to interact with the Messages API and Tool functions. The client library is available in both synchronous and asynchronous versions.",ss,nl,Ms,Jl,ts,Tl,Ws="TGI exposes an OpenAI-compatible API, which means you can use OpenAI’s client libraries to interact with TGI’s Messages API and Tool functions.",as,jl,Ss="However there are some minor differences in the API, for example <code>tool_choice=&quot;auto&quot;</code> will ALWAYS choose the tool for you. This is different from OpenAI’s API where <code>tool_choice=&quot;auto&quot;</code> will choose a tool if the model thinks it’s necessary.",ns,Il,Js,yl,Ts,ol,js;return A=new U({props:{title:"Guidance",local:"guidance",headingTag:"h1"}}),m=new U({props:{title:"Quick Start",local:"quick-start",headingTag:"h2"}}),b=new U({props:{title:"How it works",local:"how-it-works",headingTag:"h2"}}),E=new U({props:{title:"Table of Contents 📚",local:"table-of-contents-",headingTag:"h2"}}),g=new U({props:{title:"Grammar and Constraints",local:"grammar-and-constraints",headingTag:"h3"}}),f=new U({props:{title:"Tools and Functions",local:"tools-and-functions",headingTag:"h3"}}),G=new U({props:{title:"Grammar and Constraints 🛣️",local:"grammar-and-constraints-",headingTag:"h2"}}),Z=new U({props:{title:"The Grammar Parameter",local:"the-grammar-parameter",headingTag:"h3"}}),v=new c({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/generate \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;inputs&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
        <span class="hljs-attr">&quot;repetition_penalty&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1.3</span><span class="hljs-punctuation">,</span>
        <span class="hljs-attr">&quot;grammar&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;json&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;value&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;integer&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;minimum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;maximum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">5</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;array&quot;</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;items&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span>
                <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;activity&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals_seen&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;animals&quot;</span><span class="hljs-punctuation">]</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">}</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;generated_text&quot;:&quot;{ \\n\\n\\&quot;activity\\&quot;: \\&quot;biking\\&quot;,\\n\\&quot;animals\\&quot;: [\\&quot;puppy\\&quot;,\\&quot;cat\\&quot;,\\&quot;raccoon\\&quot;],\\n\\&quot;animals_seen\\&quot;: 3,\\n\\&quot;location\\&quot;: \\&quot;park\\&quot;\\n}&quot;}</span>
`,wrap:!1}}),V=new U({props:{title:"Constrain with Pydantic",local:"constrain-with-pydantic",headingTag:"h3"}}),Y=new c({props:{code:"aW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwcHlkYW50aWMlMjBpbXBvcnQlMjBCYXNlTW9kZWwlMkMlMjBjb25pbnQlMEFmcm9tJTIwdHlwaW5nJTIwaW1wb3J0JTIwTGlzdCUwQSUwQWNsYXNzJTIwQW5pbWFscyhCYXNlTW9kZWwpJTNBJTBBJTIwJTIwJTIwJTIwbG9jYXRpb24lM0ElMjBzdHIlMEElMjAlMjAlMjAlMjBhY3Rpdml0eSUzQSUyMHN0ciUwQSUyMCUyMCUyMCUyMGFuaW1hbHNfc2VlbiUzQSUyMGNvbmludChnZSUzRDElMkMlMjBsZSUzRDUpJTIwJTIwJTIzJTIwQ29uc3RyYWluZWQlMjBpbnRlZ2VyJTIwdHlwZSUwQSUyMCUyMCUyMCUyMGFuaW1hbHMlM0ElMjBMaXN0JTVCc3RyJTVEJTBBJTBBcHJvbXB0JTIwJTNEJTIwJTIyY29udmVydCUyMHRvJTIwSlNPTiUzQSUyMEklMjBzYXclMjBhJTIwcHVwcHklMjBhJTIwY2F0JTIwYW5kJTIwYSUyMHJhY2Nvb24lMjBkdXJpbmclMjBteSUyMGJpa2UlMjByaWRlJTIwaW4lMjB0aGUlMjBwYXJrJTIyJTBBJTBBZGF0YSUyMCUzRCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMmlucHV0cyUyMiUzQSUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMCUyMnBhcmFtZXRlcnMlMjIlM0ElMjAlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJyZXBldGl0aW9uX3BlbmFsdHklMjIlM0ElMjAxLjMlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJncmFtbWFyJTIyJTNBJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmpzb24lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMEFuaW1hbHMuc2NoZW1hKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlN0QlMEElMjAlMjAlMjAlMjAlN0QlMEElN0QlMEElMEFoZWFkZXJzJTIwJTNEJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIyQ29udGVudC1UeXBlJTIyJTNBJTIwJTIyYXBwbGljYXRpb24lMkZqc29uJTIyJTJDJTBBJTdEJTBBJTBBcmVzcG9uc2UlMjAlM0QlMjByZXF1ZXN0cy5wb3N0KCUwQSUyMCUyMCUyMCUyMCdodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBMzAwMCUyRmdlbmVyYXRlJyUyQyUwQSUyMCUyMCUyMCUyMGhlYWRlcnMlM0RoZWFkZXJzJTJDJTBBJTIwJTIwJTIwJTIwanNvbiUzRGRhdGElMEEpJTBBcHJpbnQocmVzcG9uc2UuanNvbigpKSUwQSUyMyUyMCU3QidnZW5lcmF0ZWRfdGV4dCclM0ElMjAnJTdCJTIwJTIyYWN0aXZpdHklMjIlM0ElMjAlMjJiaWtlJTIwcmlkaW5nJTIyJTJDJTIwJTIyYW5pbWFscyUyMiUzQSUyMCU1QiUyMnB1cHB5JTIyJTJDJTIyY2F0JTIyJTJDJTIycmFjY29vbiUyMiU1RCUyQyUyMmFuaW1hbHNfc2VlbiUyMiUzQSUyMDMlMkMlMjAlMjJsb2NhdGlvbiUyMiUzQSUyMnBhcmslMjIlMjAlN0QnJTdEJTBB",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> pydantic <span class="hljs-keyword">import</span> BaseModel, conint
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">List</span>

<span class="hljs-keyword">class</span> <span class="hljs-title class_">Animals</span>(<span class="hljs-title class_ inherited__">BaseModel</span>):
    location: <span class="hljs-built_in">str</span>
    activity: <span class="hljs-built_in">str</span>
    animals_seen: conint(ge=<span class="hljs-number">1</span>, le=<span class="hljs-number">5</span>)  <span class="hljs-comment"># Constrained integer type</span>
    animals: <span class="hljs-type">List</span>[<span class="hljs-built_in">str</span>]

prompt = <span class="hljs-string">&quot;convert to JSON: I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>

data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: prompt,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.3</span>,
        <span class="hljs-string">&quot;grammar&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
            <span class="hljs-string">&quot;value&quot;</span>: Animals.schema()
        }
    }
}

headers = {
    <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
}

response = requests.post(
    <span class="hljs-string">&#x27;http://127.0.0.1:3000/generate&#x27;</span>,
    headers=headers,
    json=data
)
<span class="hljs-built_in">print</span>(response.json())
<span class="hljs-comment"># {&#x27;generated_text&#x27;: &#x27;{ &quot;activity&quot;: &quot;bike riding&quot;, &quot;animals&quot;: [&quot;puppy&quot;,&quot;cat&quot;,&quot;raccoon&quot;],&quot;animals_seen&quot;: 3, &quot;location&quot;:&quot;park&quot; }&#x27;}</span>
`,wrap:!1}}),x=new U({props:{title:"JSON Schema Integration",local:"json-schema-integration",headingTag:"h3"}}),H=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests

json_schema = {
    <span class="hljs-string">&quot;properties&quot;</span>: {
        <span class="hljs-string">&quot;location&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>
        },
        <span class="hljs-string">&quot;activity&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>
        },
        <span class="hljs-string">&quot;animals_seen&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
            <span class="hljs-string">&quot;minimum&quot;</span>: <span class="hljs-number">1</span>,
            <span class="hljs-string">&quot;maximum&quot;</span>: <span class="hljs-number">5</span>
        },
        <span class="hljs-string">&quot;animals&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;array&quot;</span>,
            <span class="hljs-string">&quot;items&quot;</span>: {
                <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>
            }
        }
    },
    <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;activity&quot;</span>, <span class="hljs-string">&quot;animals_seen&quot;</span>, <span class="hljs-string">&quot;animals&quot;</span>]
}

data = {
    <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;convert to JSON: I saw a puppy a cat and a raccoon during my bike ride in the park&quot;</span>,
    <span class="hljs-string">&quot;parameters&quot;</span>: {
        <span class="hljs-string">&quot;max_new_tokens&quot;</span>: <span class="hljs-number">200</span>,
        <span class="hljs-string">&quot;repetition_penalty&quot;</span>: <span class="hljs-number">1.3</span>,
        <span class="hljs-string">&quot;grammar&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;json&quot;</span>,
            <span class="hljs-string">&quot;value&quot;</span>: json_schema
        }
    }
}

headers = {
    <span class="hljs-string">&quot;Content-Type&quot;</span>: <span class="hljs-string">&quot;application/json&quot;</span>,
}

response = requests.post(
    <span class="hljs-string">&#x27;http://127.0.0.1:3000/generate&#x27;</span>,
    headers=headers,
    json=data
)
<span class="hljs-built_in">print</span>(response.json())
<span class="hljs-comment"># {&#x27;generated_text&#x27;: &#x27;{\\n&quot;activity&quot;: &quot;biking&quot;,\\n&quot;animals&quot;: [&quot;puppy&quot;,&quot;cat&quot;,&quot;raccoon&quot;]\\n  , &quot;animals_seen&quot;: 3,\\n   &quot;location&quot;:&quot;park&quot;}&#x27;}</span>
`,wrap:!1}}),F=new U({props:{title:"Using the client",local:"using-the-client",headingTag:"h3"}}),D=new c({props:{code:"ZnJvbSUyMHRleHRfZ2VuZXJhdGlvbiUyMGltcG9ydCUyMEFzeW5jQ2xpZW50JTBBZnJvbSUyMHRleHRfZ2VuZXJhdGlvbi50eXBlcyUyMGltcG9ydCUyMEdyYW1tYXJUeXBlJTBBJTBBJTIzJTIwTk9URSUzQSUyMHRvb2xzJTIwZGVmaW5lZCUyMGFib3ZlJTIwYW5kJTIwcmVtb3ZlZCUyMGZvciUyMGJyZXZpdHklMEElMEElMjMlMjBEZWZpbmUlMjBhbiUyMGFzeW5jJTIwZnVuY3Rpb24lMjB0byUyMGVuY2Fwc3VsYXRlJTIwdGhlJTIwYXN5bmMlMjBvcGVyYXRpb24lMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMGNsaWVudCUyMCUzRCUyMEFzeW5jQ2xpZW50KGJhc2VfdXJsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTMwMDAlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwJ2F3YWl0JyUyMHRvJTIwd2FpdCUyMGZvciUyMHRoZSUyMGFzeW5jJTIwbWV0aG9kJTIwJ2NoYXQnJTIwdG8lMjBjb21wbGV0ZSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuZ2VuZXJhdGUoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyV2hhdHMlMjBHb29nbGVzJTIwRE5TJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0QxMCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGRlY29kZXJfaW5wdXRfZGV0YWlscyUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzZWVkJTNEMSUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGdyYW1tYXIlM0QlN0IlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ0eXBlJTIyJTNBJTIwR3JhbW1hclR5cGUuUmVnZXglMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJ2YWx1ZSUyMiUzQSUyMCUyMigoMjUlNUIwLTUlNUQlN0MyJTVCMC00JTVEJTVDJTVDZCU3QyU1QjAxJTVEJTNGJTVDJTVDZCU1QyU1Q2QlM0YpJTVDJTVDLiklN0IzJTdEKDI1JTVCMC01JTVEJTdDMiU1QjAtNCU1RCU1QyU1Q2QlN0MlNUIwMSU1RCUzRiU1QyU1Q2QlNUMlNUNkJTNGKSUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBPbmNlJTIwdGhlJTIwcmVzcG9uc2UlMjBpcyUyMHJlY2VpdmVkJTJDJTIweW91JTIwY2FuJTIwcHJvY2VzcyUyMGl0JTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzcG9uc2UuZ2VuZXJhdGVkX3RleHQpJTBBJTBBJTIzJTIwRW5zdXJlJTIwdGhlJTIwbWFpbiUyMGFzeW5jJTIwZnVuY3Rpb24lMjBpcyUyMHJ1biUyMGluJTIwdGhlJTIwZXZlbnQlMjBsb29wJTBBaWYlMjBfX25hbWVfXyUyMCUzRCUzRCUyMCUyMl9fbWFpbl9fJTIyJTNBJTBBJTIwJTIwJTIwJTIwaW1wb3J0JTIwYXN5bmNpbyUwQSUyMCUyMCUyMCUyMGFzeW5jaW8ucnVuKG1haW4oKSklMEElMEElMjMlMjAxMTguOC4wLjg0JTBB",highlighted:`<span class="hljs-keyword">from</span> text_generation <span class="hljs-keyword">import</span> AsyncClient
<span class="hljs-keyword">from</span> text_generation.types <span class="hljs-keyword">import</span> GrammarType

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

<span class="hljs-comment"># Define an async function to encapsulate the async operation</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    client = AsyncClient(base_url=<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

    <span class="hljs-comment"># Use &#x27;await&#x27; to wait for the async method &#x27;chat&#x27; to complete</span>
    response = <span class="hljs-keyword">await</span> client.generate(
        <span class="hljs-string">&quot;Whats Googles DNS&quot;</span>,
        max_new_tokens=<span class="hljs-number">10</span>,
        decoder_input_details=<span class="hljs-literal">True</span>,
        seed=<span class="hljs-number">1</span>,
        grammar={
            <span class="hljs-string">&quot;type&quot;</span>: GrammarType.Regex,
            <span class="hljs-string">&quot;value&quot;</span>: <span class="hljs-string">&quot;((25[0-5]|2[0-4]\\\\d|[01]?\\\\d\\\\d?)\\\\.){3}(25[0-5]|2[0-4]\\\\d|[01]?\\\\d\\\\d?)&quot;</span>,
        },
    )

    <span class="hljs-comment"># Once the response is received, you can process it</span>
    <span class="hljs-built_in">print</span>(response.generated_text)

<span class="hljs-comment"># Ensure the main async function is run in the event loop</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-keyword">import</span> asyncio
    asyncio.run(main())

<span class="hljs-comment"># 118.8.0.84</span>
`,wrap:!1}}),P=new U({props:{title:"Tools and Functions 🛠️",local:"tools-and-functions-",headingTag:"h2"}}),L=new U({props:{title:"The Tools Parameter",local:"the-tools-parameter",headingTag:"h3"}}),sl=new c({props:{code:"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",highlighted:`curl localhost<span class="hljs-punctuation">:</span><span class="hljs-number">3000</span>/v1/chat/completions \\
    -X POST \\
    -H &#x27;Content-Type<span class="hljs-punctuation">:</span> application/json&#x27; \\
    -d &#x27;<span class="hljs-punctuation">{</span>
    <span class="hljs-attr">&quot;model&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;tgi&quot;</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;messages&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;role&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;user&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;content&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;What is the weather like in New York?&quot;</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tools&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span>
        <span class="hljs-punctuation">{</span>
            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;function&quot;</span><span class="hljs-punctuation">,</span>
            <span class="hljs-attr">&quot;function&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                <span class="hljs-attr">&quot;name&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Get the current weather&quot;</span><span class="hljs-punctuation">,</span>
                <span class="hljs-attr">&quot;parameters&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                    <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;object&quot;</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;properties&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                        <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>
                        <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                        <span class="hljs-attr">&quot;format&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">{</span>
                            <span class="hljs-attr">&quot;type&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;string&quot;</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;enum&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;celsius&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;fahrenheit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
                            <span class="hljs-attr">&quot;description&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>
                        <span class="hljs-punctuation">}</span>
                    <span class="hljs-punctuation">}</span><span class="hljs-punctuation">,</span>
                    <span class="hljs-attr">&quot;required&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;location&quot;</span><span class="hljs-punctuation">,</span> <span class="hljs-string">&quot;format&quot;</span><span class="hljs-punctuation">]</span>
                <span class="hljs-punctuation">}</span>
            <span class="hljs-punctuation">}</span>
        <span class="hljs-punctuation">}</span>
    <span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
    <span class="hljs-attr">&quot;tool_choice&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;get_current_weather&quot;</span>
<span class="hljs-punctuation">}</span>&#x27;
<span class="hljs-comment">// {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051640,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:19,&quot;total_tokens&quot;:176}}</span>`,wrap:!1}}),Ml=new c({props:{code:"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",highlighted:`  tools = [
      {
          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
          <span class="hljs-string">&quot;function&quot;</span>: {
              <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_current_weather&quot;</span>,
              <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get the current weather&quot;</span>,
              <span class="hljs-string">&quot;parameters&quot;</span>: {
                  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                  <span class="hljs-string">&quot;properties&quot;</span>: {
                      <span class="hljs-string">&quot;location&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                      },
                      <span class="hljs-string">&quot;format&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                      },
                  },
                  <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>],
              },
          },
      },
      {
          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;function&quot;</span>,
          <span class="hljs-string">&quot;function&quot;</span>: {
              <span class="hljs-string">&quot;name&quot;</span>: <span class="hljs-string">&quot;get_n_day_weather_forecast&quot;</span>,
              <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;Get an N-day weather forecast&quot;</span>,
              <span class="hljs-string">&quot;parameters&quot;</span>: {
                  <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;object&quot;</span>,
                  <span class="hljs-string">&quot;properties&quot;</span>: {
                      <span class="hljs-string">&quot;location&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The city and state, e.g. San Francisco, CA&quot;</span>,
                      },
                      <span class="hljs-string">&quot;format&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
                          <span class="hljs-string">&quot;enum&quot;</span>: [<span class="hljs-string">&quot;celsius&quot;</span>, <span class="hljs-string">&quot;fahrenheit&quot;</span>],
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The temperature unit to use. Infer this from the users location.&quot;</span>,
                      },
                      <span class="hljs-string">&quot;num_days&quot;</span>: {
                          <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;integer&quot;</span>,
                          <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The number of days to forecast&quot;</span>,
                      },
                  },
                  <span class="hljs-string">&quot;required&quot;</span>: [<span class="hljs-string">&quot;location&quot;</span>, <span class="hljs-string">&quot;format&quot;</span>, <span class="hljs-string">&quot;num_days&quot;</span>],
              },
          },
      }
  ]`,wrap:!1}}),tl=new U({props:{title:"Text Generation Inference Client",local:"text-generation-inference-client",headingTag:"h3"}}),nl=new c({props:{code:"ZnJvbSUyMHRleHRfZ2VuZXJhdGlvbiUyMGltcG9ydCUyMEFzeW5jQ2xpZW50JTBBJTBBJTIzJTIwTk9URSUzQSUyMHRvb2xzJTIwZGVmaW5lZCUyMGFib3ZlJTIwYW5kJTIwcmVtb3ZlZCUyMGZvciUyMGJyZXZpdHklMEElMEElMjMlMjBEZWZpbmUlMjBhbiUyMGFzeW5jJTIwZnVuY3Rpb24lMjB0byUyMGVuY2Fwc3VsYXRlJTIwdGhlJTIwYXN5bmMlMjBvcGVyYXRpb24lMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMGNsaWVudCUyMCUzRCUyMEFzeW5jQ2xpZW50KGJhc2VfdXJsJTNEJTIyaHR0cCUzQSUyRiUyRmxvY2FsaG9zdCUzQTMwMDAlMjIpJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNlJTIwJ2F3YWl0JyUyMHRvJTIwd2FpdCUyMGZvciUyMHRoZSUyMGFzeW5jJTIwbWV0aG9kJTIwJ2NoYXQnJTIwdG8lMjBjb21wbGV0ZSUwQSUyMCUyMCUyMCUyMHJlc3BvbnNlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQuY2hhdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtYXhfdG9rZW5zJTNEMTAwJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwc2VlZCUzRDElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjB0b29scyUzRHRvb2xzJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcHJlc2VuY2VfcGVuYWx0eSUzRC0xLjElMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91J3JlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQhJTIwQW5zd2VyJTIwdGhlJTIwdXNlcnMlMjBxdWVzdGlvbiUyMGJlc3QlMjB5b3UlMjBjYW4uJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyV2hhdCUyMGlzJTIwdGhlJTIwd2VhdGhlciUyMGxpa2UlMjBpbiUyMEJyb29rbHluJTJDJTIwTmV3JTIwWW9yayUzRiUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU1RCUyQyUwQSUyMCUyMCUyMCUyMCklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBPbmNlJTIwdGhlJTIwcmVzcG9uc2UlMjBpcyUyMHJlY2VpdmVkJTJDJTIweW91JTIwY2FuJTIwcHJvY2VzcyUyMGl0JTBBJTIwJTIwJTIwJTIwcHJpbnQocmVzcG9uc2UuY2hvaWNlcyU1QjAlNUQubWVzc2FnZS50b29sX2NhbGxzKSUwQSUwQSUyMyUyMEVuc3VyZSUyMHRoZSUyMG1haW4lMjBhc3luYyUyMGZ1bmN0aW9uJTIwaXMlMjBydW4lMjBpbiUyMHRoZSUyMGV2ZW50JTIwbG9vcCUwQWlmJTIwX19uYW1lX18lMjAlM0QlM0QlMjAlMjJfX21haW5fXyUyMiUzQSUwQSUyMCUyMCUyMCUyMGltcG9ydCUyMGFzeW5jaW8lMEElMjAlMjAlMjAlMjBhc3luY2lvLnJ1bihtYWluKCkpJTBBJTBBJTIzJTIwJTdCJTIyaWQlMjIlM0ElMjIlMjIlMkMlMjJvYmplY3QlMjIlM0ElMjJ0ZXh0X2NvbXBsZXRpb24lMjIlMkMlMjJjcmVhdGVkJTIyJTNBMTcwOTA1MTk0MiUyQyUyMm1vZGVsJTIyJTNBJTIySHVnZ2luZ0ZhY2VINCUyRnplcGh5ci03Yi1iZXRhJTIyJTJDJTIyc3lzdGVtX2ZpbmdlcnByaW50JTIyJTNBJTIyMS40LjMtbmF0aXZlJTIyJTJDJTIyY2hvaWNlcyUyMiUzQSU1QiU3QiUyMmluZGV4JTIyJTNBMCUyQyUyMm1lc3NhZ2UlMjIlM0ElN0IlMjJyb2xlJTIyJTNBJTIyYXNzaXN0YW50JTIyJTJDJTIydG9vbF9jYWxscyUyMiUzQSU3QiUyMmlkJTIyJTNBMCUyQyUyMnR5cGUlMjIlM0ElMjJmdW5jdGlvbiUyMiUyQyUyMmZ1bmN0aW9uJTIyJTNBJTdCJTIyZGVzY3JpcHRpb24lMjIlM0FudWxsJTJDJTIybmFtZSUyMiUzQSUyMnRvb2xzJTIyJTJDJTIycGFyYW1ldGVycyUyMiUzQSU3QiUyMmZvcm1hdCUyMiUzQSUyMmNlbHNpdXMlMjIlMkMlMjJsb2NhdGlvbiUyMiUzQSUyMk5ldyUyMFlvcmslMjIlN0QlN0QlN0QlN0QlMkMlMjJsb2dwcm9icyUyMiUzQW51bGwlMkMlMjJmaW5pc2hfcmVhc29uJTIyJTNBJTIyZW9zX3Rva2VuJTIyJTdEJTVEJTJDJTIydXNhZ2UlMjIlM0ElN0IlMjJwcm9tcHRfdG9rZW5zJTIyJTNBMTU3JTJDJTIyY29tcGxldGlvbl90b2tlbnMlMjIlM0EyMCUyQyUyMnRvdGFsX3Rva2VucyUyMiUzQTE3NyU3RCU3RCUwQQ==",highlighted:`<span class="hljs-keyword">from</span> text_generation <span class="hljs-keyword">import</span> AsyncClient

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

<span class="hljs-comment"># Define an async function to encapsulate the async operation</span>
<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>():
    client = AsyncClient(base_url=<span class="hljs-string">&quot;http://localhost:3000&quot;</span>)

    <span class="hljs-comment"># Use &#x27;await&#x27; to wait for the async method &#x27;chat&#x27; to complete</span>
    response = <span class="hljs-keyword">await</span> client.chat(
        max_tokens=<span class="hljs-number">100</span>,
        seed=<span class="hljs-number">1</span>,
        tools=tools,
        presence_penalty=-<span class="hljs-number">1.1</span>,
        messages=[
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;You&#x27;re a helpful assistant! Answer the users question best you can.&quot;</span>,
            },
            {
                <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
                <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the weather like in Brooklyn, New York?&quot;</span>,
            },
        ],
    )

    <span class="hljs-comment"># Once the response is received, you can process it</span>
    <span class="hljs-built_in">print</span>(response.choices[<span class="hljs-number">0</span>].message.tool_calls)

<span class="hljs-comment"># Ensure the main async function is run in the event loop</span>
<span class="hljs-keyword">if</span> __name__ == <span class="hljs-string">&quot;__main__&quot;</span>:
    <span class="hljs-keyword">import</span> asyncio
    asyncio.run(main())

<span class="hljs-comment"># {&quot;id&quot;:&quot;&quot;,&quot;object&quot;:&quot;text_completion&quot;,&quot;created&quot;:1709051942,&quot;model&quot;:&quot;HuggingFaceH4/zephyr-7b-beta&quot;,&quot;system_fingerprint&quot;:&quot;1.4.3-native&quot;,&quot;choices&quot;:[{&quot;index&quot;:0,&quot;message&quot;:{&quot;role&quot;:&quot;assistant&quot;,&quot;tool_calls&quot;:{&quot;id&quot;:0,&quot;type&quot;:&quot;function&quot;,&quot;function&quot;:{&quot;description&quot;:null,&quot;name&quot;:&quot;tools&quot;,&quot;parameters&quot;:{&quot;format&quot;:&quot;celsius&quot;,&quot;location&quot;:&quot;New York&quot;}}}},&quot;logprobs&quot;:null,&quot;finish_reason&quot;:&quot;eos_token&quot;}],&quot;usage&quot;:{&quot;prompt_tokens&quot;:157,&quot;completion_tokens&quot;:20,&quot;total_tokens&quot;:177}}</span>
`,wrap:!1}}),Jl=new U({props:{title:"OpenAI integration",local:"openai-integration",headingTag:"h3"}}),Il=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> openai <span class="hljs-keyword">import</span> OpenAI

<span class="hljs-comment"># Initialize the client, pointing it to one of the available models</span>
client = OpenAI(
    base_url=<span class="hljs-string">&quot;http://localhost:3000/v1&quot;</span>,
    api_key=<span class="hljs-string">&quot;_&quot;</span>,
)

<span class="hljs-comment"># <span class="hljs-doctag">NOTE:</span> tools defined above and removed for brevity</span>

chat_completion = client.chat.completions.create(
    model=<span class="hljs-string">&quot;tgi&quot;</span>,
    messages=[
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;system&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;Don&#x27;t make assumptions about what values to plug into functions. Ask for clarification if a user request is ambiguous.&quot;</span>,
        },
        {
            <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
            <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What&#x27;s the weather like the next 3 days in San Francisco, CA?&quot;</span>,
        },
    ],
    tools=tools,
    tool_choice=<span class="hljs-string">&quot;auto&quot;</span>,  <span class="hljs-comment"># tool selected by model</span>
    max_tokens=<span class="hljs-number">500</span>,
)


called = chat_completion.choices[<span class="hljs-number">0</span>].message.tool_calls
<span class="hljs-built_in">print</span>(called)
<span class="hljs-comment"># {</span>
<span class="hljs-comment">#     &quot;id&quot;: 0,</span>
<span class="hljs-comment">#     &quot;type&quot;: &quot;function&quot;,</span>
<span class="hljs-comment">#     &quot;function&quot;: {</span>
<span class="hljs-comment">#         &quot;description&quot;: None,</span>
<span class="hljs-comment">#         &quot;name&quot;: &quot;tools&quot;,</span>
<span class="hljs-comment">#         &quot;parameters&quot;: {</span>
<span class="hljs-comment">#             &quot;format&quot;: &quot;celsius&quot;,</span>
<span class="hljs-comment">#             &quot;location&quot;: &quot;San Francisco, CA&quot;,</span>
<span class="hljs-comment">#             &quot;num_days&quot;: 3,</span>
<span class="hljs-comment">#         },</span>
<span class="hljs-comment">#     },</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),yl=new xs({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/conceptual/guidance.md"}}),{c(){i=J("meta"),pl=a(),wl=J("p"),Ul=a(),j(A.$$.fragment),il=a(),r=J("p"),r.innerHTML=ps,ul=a(),C=J("p"),C.innerHTML=Us,cl=a(),h=J("blockquote"),h.innerHTML=is,Al=a(),j(m.$$.fragment),rl=a(),q=J("p"),q.innerHTML=us,Cl=a(),d=J("p"),d.textContent=cs,hl=a(),j(b.$$.fragment),ml=a(),B=J("p"),B.innerHTML=As,ql=a(),j(E.$$.fragment),dl=a(),j(g.$$.fragment),bl=a(),Q=J("ul"),Q.innerHTML=rs,Bl=a(),j(f.$$.fragment),El=a(),N=J("ul"),N.innerHTML=Cs,gl=a(),j(G.$$.fragment),Ql=a(),j(Z.$$.fragment),fl=a(),W=J("p"),W.innerHTML=hs,Nl=a(),S=J("p"),S.innerHTML=ms,Gl=a(),j(v.$$.fragment),Zl=a(),z=J("p"),z.textContent=qs,Wl=a(),k=J("blockquote"),k.innerHTML=ds,Sl=a(),j(V.$$.fragment),vl=a(),R=J("p"),R.textContent=bs,zl=a(),X=J("p"),X.textContent=Bs,kl=a(),j(Y.$$.fragment),Vl=a(),j(x.$$.fragment),Rl=a(),$=J("p"),$.textContent=Es,Xl=a(),j(H.$$.fragment),Yl=a(),j(F.$$.fragment),xl=a(),_=J("p"),_.textContent=gs,$l=a(),j(D.$$.fragment),Hl=a(),j(P.$$.fragment),Fl=a(),j(L.$$.fragment),_l=a(),O=J("p"),O.textContent=Qs,Dl=a(),K=J("p"),K.textContent=fs,Pl=a(),ll=J("p"),ll.textContent=Ns,Ll=a(),j(sl.$$.fragment),Ol=a(),u=J("details"),el=J("summary"),el.textContent=Gs,ys=a(),j(Ml.$$.fragment),Kl=a(),j(tl.$$.fragment),ls=a(),al=J("p"),al.textContent=Zs,ss=a(),j(nl.$$.fragment),Ms=a(),j(Jl.$$.fragment),ts=a(),Tl=J("p"),Tl.textContent=Ws,as=a(),jl=J("p"),jl.innerHTML=Ss,ns=a(),j(Il.$$.fragment),Js=a(),j(yl.$$.fragment),Ts=a(),ol=J("p"),this.h()},l(l){const s=Ys("svelte-u9bgzb",document.head);i=T(s,"META",{name:!0,content:!0}),s.forEach(M),pl=n(l),wl=T(l,"P",{}),es(wl).forEach(M),Ul=n(l),I(A.$$.fragment,l),il=n(l),r=T(l,"P",{"data-svelte-h":!0}),p(r)!=="svelte-kbjeep"&&(r.innerHTML=ps),ul=n(l),C=T(l,"P",{"data-svelte-h":!0}),p(C)!=="svelte-7p3180"&&(C.innerHTML=Us),cl=n(l),h=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(h)!=="svelte-1tp3yxk"&&(h.innerHTML=is),Al=n(l),I(m.$$.fragment,l),rl=n(l),q=T(l,"P",{"data-svelte-h":!0}),p(q)!=="svelte-1yk2trj"&&(q.innerHTML=us),Cl=n(l),d=T(l,"P",{"data-svelte-h":!0}),p(d)!=="svelte-dzufb1"&&(d.textContent=cs),hl=n(l),I(b.$$.fragment,l),ml=n(l),B=T(l,"P",{"data-svelte-h":!0}),p(B)!=="svelte-wsp0l4"&&(B.innerHTML=As),ql=n(l),I(E.$$.fragment,l),dl=n(l),I(g.$$.fragment,l),bl=n(l),Q=T(l,"UL",{"data-svelte-h":!0}),p(Q)!=="svelte-12576sd"&&(Q.innerHTML=rs),Bl=n(l),I(f.$$.fragment,l),El=n(l),N=T(l,"UL",{"data-svelte-h":!0}),p(N)!=="svelte-18ofpvb"&&(N.innerHTML=Cs),gl=n(l),I(G.$$.fragment,l),Ql=n(l),I(Z.$$.fragment,l),fl=n(l),W=T(l,"P",{"data-svelte-h":!0}),p(W)!=="svelte-1dpevtv"&&(W.innerHTML=hs),Nl=n(l),S=T(l,"P",{"data-svelte-h":!0}),p(S)!=="svelte-1vsv0tm"&&(S.innerHTML=ms),Gl=n(l),I(v.$$.fragment,l),Zl=n(l),z=T(l,"P",{"data-svelte-h":!0}),p(z)!=="svelte-1xvi374"&&(z.textContent=qs),Wl=n(l),k=T(l,"BLOCKQUOTE",{"data-svelte-h":!0}),p(k)!=="svelte-cm9i0i"&&(k.innerHTML=ds),Sl=n(l),I(V.$$.fragment,l),vl=n(l),R=T(l,"P",{"data-svelte-h":!0}),p(R)!=="svelte-1gr119f"&&(R.textContent=bs),zl=n(l),X=T(l,"P",{"data-svelte-h":!0}),p(X)!=="svelte-3pxjtu"&&(X.textContent=Bs),kl=n(l),I(Y.$$.fragment,l),Vl=n(l),I(x.$$.fragment,l),Rl=n(l),$=T(l,"P",{"data-svelte-h":!0}),p($)!=="svelte-ng8aow"&&($.textContent=Es),Xl=n(l),I(H.$$.fragment,l),Yl=n(l),I(F.$$.fragment,l),xl=n(l),_=T(l,"P",{"data-svelte-h":!0}),p(_)!=="svelte-1u2gawg"&&(_.textContent=gs),$l=n(l),I(D.$$.fragment,l),Hl=n(l),I(P.$$.fragment,l),Fl=n(l),I(L.$$.fragment,l),_l=n(l),O=T(l,"P",{"data-svelte-h":!0}),p(O)!=="svelte-lut42n"&&(O.textContent=Qs),Dl=n(l),K=T(l,"P",{"data-svelte-h":!0}),p(K)!=="svelte-1qej1bm"&&(K.textContent=fs),Pl=n(l),ll=T(l,"P",{"data-svelte-h":!0}),p(ll)!=="svelte-1yk642r"&&(ll.textContent=Ns),Ll=n(l),I(sl.$$.fragment,l),Ol=n(l),u=T(l,"DETAILS",{});var Is=es(u);el=T(Is,"SUMMARY",{"data-svelte-h":!0}),p(el)!=="svelte-1bsygvs"&&(el.textContent=Gs),ys=n(Is),I(Ml.$$.fragment,Is),Is.forEach(M),Kl=n(l),I(tl.$$.fragment,l),ls=n(l),al=T(l,"P",{"data-svelte-h":!0}),p(al)!=="svelte-s8b45c"&&(al.textContent=Zs),ss=n(l),I(nl.$$.fragment,l),Ms=n(l),I(Jl.$$.fragment,l),ts=n(l),Tl=T(l,"P",{"data-svelte-h":!0}),p(Tl)!=="svelte-qj1me9"&&(Tl.textContent=Ws),as=n(l),jl=T(l,"P",{"data-svelte-h":!0}),p(jl)!=="svelte-7v54cr"&&(jl.innerHTML=Ss),ns=n(l),I(Il.$$.fragment,l),Js=n(l),I(yl.$$.fragment,l),Ts=n(l),ol=T(l,"P",{}),es(ol).forEach(M),this.h()},h(){vs(i,"name","hf:doc:metadata"),vs(i,"content",Hs)},m(l,s){ws(document.head,i),t(l,pl,s),t(l,wl,s),t(l,Ul,s),y(A,l,s),t(l,il,s),t(l,r,s),t(l,ul,s),t(l,C,s),t(l,cl,s),t(l,h,s),t(l,Al,s),y(m,l,s),t(l,rl,s),t(l,q,s),t(l,Cl,s),t(l,d,s),t(l,hl,s),y(b,l,s),t(l,ml,s),t(l,B,s),t(l,ql,s),y(E,l,s),t(l,dl,s),y(g,l,s),t(l,bl,s),t(l,Q,s),t(l,Bl,s),y(f,l,s),t(l,El,s),t(l,N,s),t(l,gl,s),y(G,l,s),t(l,Ql,s),y(Z,l,s),t(l,fl,s),t(l,W,s),t(l,Nl,s),t(l,S,s),t(l,Gl,s),y(v,l,s),t(l,Zl,s),t(l,z,s),t(l,Wl,s),t(l,k,s),t(l,Sl,s),y(V,l,s),t(l,vl,s),t(l,R,s),t(l,zl,s),t(l,X,s),t(l,kl,s),y(Y,l,s),t(l,Vl,s),y(x,l,s),t(l,Rl,s),t(l,$,s),t(l,Xl,s),y(H,l,s),t(l,Yl,s),y(F,l,s),t(l,xl,s),t(l,_,s),t(l,$l,s),y(D,l,s),t(l,Hl,s),y(P,l,s),t(l,Fl,s),y(L,l,s),t(l,_l,s),t(l,O,s),t(l,Dl,s),t(l,K,s),t(l,Pl,s),t(l,ll,s),t(l,Ll,s),y(sl,l,s),t(l,Ol,s),t(l,u,s),ws(u,el),ws(u,ys),y(Ml,u,null),t(l,Kl,s),y(tl,l,s),t(l,ls,s),t(l,al,s),t(l,ss,s),y(nl,l,s),t(l,Ms,s),y(Jl,l,s),t(l,ts,s),t(l,Tl,s),t(l,as,s),t(l,jl,s),t(l,ns,s),y(Il,l,s),t(l,Js,s),y(yl,l,s),t(l,Ts,s),t(l,ol,s),js=!0},p:ks,i(l){js||(e(A.$$.fragment,l),e(m.$$.fragment,l),e(b.$$.fragment,l),e(E.$$.fragment,l),e(g.$$.fragment,l),e(f.$$.fragment,l),e(G.$$.fragment,l),e(Z.$$.fragment,l),e(v.$$.fragment,l),e(V.$$.fragment,l),e(Y.$$.fragment,l),e(x.$$.fragment,l),e(H.$$.fragment,l),e(F.$$.fragment,l),e(D.$$.fragment,l),e(P.$$.fragment,l),e(L.$$.fragment,l),e(sl.$$.fragment,l),e(Ml.$$.fragment,l),e(tl.$$.fragment,l),e(nl.$$.fragment,l),e(Jl.$$.fragment,l),e(Il.$$.fragment,l),e(yl.$$.fragment,l),js=!0)},o(l){w(A.$$.fragment,l),w(m.$$.fragment,l),w(b.$$.fragment,l),w(E.$$.fragment,l),w(g.$$.fragment,l),w(f.$$.fragment,l),w(G.$$.fragment,l),w(Z.$$.fragment,l),w(v.$$.fragment,l),w(V.$$.fragment,l),w(Y.$$.fragment,l),w(x.$$.fragment,l),w(H.$$.fragment,l),w(F.$$.fragment,l),w(D.$$.fragment,l),w(P.$$.fragment,l),w(L.$$.fragment,l),w(sl.$$.fragment,l),w(Ml.$$.fragment,l),w(tl.$$.fragment,l),w(nl.$$.fragment,l),w(Jl.$$.fragment,l),w(Il.$$.fragment,l),w(yl.$$.fragment,l),js=!1},d(l){l&&(M(pl),M(wl),M(Ul),M(il),M(r),M(ul),M(C),M(cl),M(h),M(Al),M(rl),M(q),M(Cl),M(d),M(hl),M(ml),M(B),M(ql),M(dl),M(bl),M(Q),M(Bl),M(El),M(N),M(gl),M(Ql),M(fl),M(W),M(Nl),M(S),M(Gl),M(Zl),M(z),M(Wl),M(k),M(Sl),M(vl),M(R),M(zl),M(X),M(kl),M(Vl),M(Rl),M($),M(Xl),M(Yl),M(xl),M(_),M($l),M(Hl),M(Fl),M(_l),M(O),M(Dl),M(K),M(Pl),M(ll),M(Ll),M(Ol),M(u),M(Kl),M(ls),M(al),M(ss),M(Ms),M(ts),M(Tl),M(as),M(jl),M(ns),M(Js),M(Ts),M(ol)),M(i),o(A,l),o(m,l),o(b,l),o(E,l),o(g,l),o(f,l),o(G,l),o(Z,l),o(v,l),o(V,l),o(Y,l),o(x,l),o(H,l),o(F,l),o(D,l),o(P,l),o(L,l),o(sl,l),o(Ml),o(tl,l),o(nl,l),o(Jl,l),o(Il,l),o(yl,l)}}}const Hs='{"title":"Guidance","local":"guidance","sections":[{"title":"Quick Start","local":"quick-start","sections":[],"depth":2},{"title":"How it works","local":"how-it-works","sections":[],"depth":2},{"title":"Table of Contents 📚","local":"table-of-contents-","sections":[{"title":"Grammar and Constraints","local":"grammar-and-constraints","sections":[],"depth":3},{"title":"Tools and Functions","local":"tools-and-functions","sections":[],"depth":3}],"depth":2},{"title":"Grammar and Constraints 🛣️","local":"grammar-and-constraints-","sections":[{"title":"The Grammar Parameter","local":"the-grammar-parameter","sections":[],"depth":3},{"title":"Constrain with Pydantic","local":"constrain-with-pydantic","sections":[],"depth":3},{"title":"JSON Schema Integration","local":"json-schema-integration","sections":[],"depth":3},{"title":"Using the client","local":"using-the-client","sections":[],"depth":3}],"depth":2},{"title":"Tools and Functions 🛠️","local":"tools-and-functions-","sections":[{"title":"The Tools Parameter","local":"the-tools-parameter","sections":[],"depth":3},{"title":"Text Generation Inference Client","local":"text-generation-inference-client","sections":[],"depth":3},{"title":"OpenAI integration","local":"openai-integration","sections":[],"depth":3}],"depth":2}],"depth":1}';function Fs(os){return Vs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Os extends Rs{constructor(i){super(),Xs(this,i,Fs,$s,zs,{})}}export{Os as component};
