import{s as _l,n as Ll,o as Dl}from"../chunks/scheduler.9680c161.js";import{S as Pl,i as Kl,g as s,s as a,r as o,A as Ol,h as i,f as e,c as M,j as Fl,u as U,x as y,k as Zl,y as lt,a as n,v as J,d as u,t as p,w as T}from"../chunks/index.38d74ee1.js";import{C as z}from"../chunks/CodeBlock.1371964c.js";import{H as F,E as tt}from"../chunks/EditOnGithub.1c840068.js";function et(Wl){let j,D,_,P,r,K,w,Bl="Visual Language Model (VLM) are models that consume both image and text inputs to generate text.",O,m,Gl="VLM’s are trained on a combination of image and text data and can handle a wide range of tasks, such as image captioning, visual question answering, and visual dialog.",ll,C,Nl="<p>What distinguishes VLMs from other text and image models is their ability to handle long context and generate text that is coherent and relevant to the image even after multiple turns or in some cases, multiple images.</p>",tl,h,Ql="Below are couple of common use cases for vision language models:",el,I,Yl="<li><strong>Image Captioning</strong>: Given an image, generate a caption that describes the image.</li> <li><strong>Visual Question Answering (VQA)</strong>: Given an image and a question about the image, generate an answer to the question.</li> <li><strong>Mulimodal Dialog</strong>: Generate response to multiple turns of images and conversations.</li> <li><strong>Image Information Retrieval</strong>: Given an image, retrieve information from the image.</li>",nl,d,al,g,Ml,f,vl='To infer with vision language models through Python, you can use the <a href="https://pypi.org/project/huggingface-hub/" rel="nofollow"><code>huggingface_hub</code></a> library. The <code>InferenceClient</code> class provides a simple way to interact with the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>. Images can be passed as URLs or base64-encoded strings. The <code>InferenceClient</code> will automatically detect the image format.',sl,b,il,A,yl,q,El="If you want additional details, you can add <code>details=True</code>. In this case, you get a <code>TextGenerationStreamResponse</code> which contains additional information such as the probabilities and the tokens. For the final response in the stream, it also returns the full generated text.",ol,Z,Ul,W,$l="To use the <code>generate_stream</code> endpoint with curl, you can add the <code>-N</code> flag. This flag disables curl default buffering and shows data as it arrives from the server.",Jl,B,ul,G,pl,N,Sl="First, we need to install the <code>@huggingface/inference</code> library.",Tl,Q,jl,Y,kl='If you’re using the free Inference API, you can use <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">Huggingface.js</a>’s <code>HfInference</code>. If you’re using inference endpoints, you can use <code>HfInferenceEndpoint</code> class to easily interact with the Inference API.',cl,v,Hl='We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and We can create a <code>HfInferenceEndpoint</code> providing our endpoint URL and <a href="https://huggingface.co/settings/tokens" rel="nofollow">Hugging Face access token</a>.',rl,E,wl,$,ml,S,Vl='VLMs in TGI have several advantages, for example these models can be used in tandem with other features for more complex tasks. For example, you can use VLMs with <a href="/docs/conceptual/guided-generation">Guided Generation</a> to generate specific JSON data from an image.',Cl,c,Rl='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png" width="400"/>',hl,k,xl="For example we can extract information from the rabbit image and generate a JSON object with the location, activity, number of animals seen, and the animals seen. That would look like this:",Il,H,dl,V,Xl="All we need to do is provide a JSON schema to the VLM model and it will generate the JSON object for us.",gl,R,fl,x,zl='Want to learn more about how Vision Language Models work? Check out the <a href="https://huggingface.co/blog/vlms" rel="nofollow">awesome blog post on the topic</a>.',bl,X,Al,L,ql;return r=new F({props:{title:"Vision Language Model Inference in TGI",local:"vision-language-model-inference-in-tgi",headingTag:"h1"}}),d=new F({props:{title:"How to Use a Vision Language Model?",local:"how-to-use-a-vision-language-model",headingTag:"h2"}}),g=new F({props:{title:"Hugging Face Hub Python Library",local:"hugging-face-hub-python-library",headingTag:"h3"}}),b=new z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCglMjJodHRwJTNBJTJGJTJGMTI3LjAuMC4xJTNBMzAwMCUyMiklMEFpbWFnZSUyMCUzRCUyMCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJhYmJpdC5wbmclMjIlMEFwcm9tcHQlMjAlM0QlMjBmJTIyISU1QiU1RCglN0JpbWFnZSU3RClXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTBBZm9yJTIwdG9rZW4lMjBpbiUyMGNsaWVudC50ZXh0X2dlbmVyYXRpb24ocHJvbXB0JTJDJTIwbWF4X25ld190b2tlbnMlM0QxNiUyQyUyMHN0cmVhbSUzRFRydWUpJTNBJTBBJTIwJTIwJTIwJTIwcHJpbnQodG9rZW4pJTBBJTBBJTIzJTIwVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0Lg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)
image = <span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png&quot;</span>
prompt = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image}</span>)What is this a picture of?\\n\\n&quot;</span>
<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(prompt, max_new_tokens=<span class="hljs-number">16</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),A=new z({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWltcG9ydCUyMGJhc2U2NCUwQWltcG9ydCUyMHJlcXVlc3RzJTBBaW1wb3J0JTIwaW8lMEElMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTIyaHR0cCUzQSUyRiUyRjEyNy4wLjAuMSUzQTMwMDAlMjIpJTBBJTBBJTIzJTIwcmVhZCUyMGltYWdlJTIwZnJvbSUyMGxvY2FsJTIwZmlsZSUwQWltYWdlX3BhdGglMjAlM0QlMjAlMjJyYWJiaXQucG5nJTIyJTBBd2l0aCUyMG9wZW4oaW1hZ2VfcGF0aCUyQyUyMCUyMnJiJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGltYWdlJTIwJTNEJTIwYmFzZTY0LmI2NGVuY29kZShmLnJlYWQoKSkuZGVjb2RlKCUyMnV0Zi04JTIyKSUwQSUwQWltYWdlJTIwJTNEJTIwZiUyMmRhdGElM0FpbWFnZSUyRnBuZyUzQmJhc2U2NCUyQyU3QmltYWdlJTdEJTIyJTBBcHJvbXB0JTIwJTNEJTIwZiUyMiElNUIlNUQoJTdCaW1hZ2UlN0QpV2hhdCUyMGlzJTIwdGhpcyUyMGElMjBwaWN0dXJlJTIwb2YlM0YlNUNuJTVDbiUyMiUwQSUwQWZvciUyMHRva2VuJTIwaW4lMjBjbGllbnQudGV4dF9nZW5lcmF0aW9uKHByb21wdCUyQyUyMG1heF9uZXdfdG9rZW5zJTNEMTAlMkMlMjBzdHJlYW0lM0RUcnVlKSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHRva2VuKSUwQSUwQSUyMyUyMFRoaXMlMjBpcyUyMGElMjBwaWN0dXJlJTIwb2YlMjBhbiUyMGFudGhyb3BvbW9ycGhpYyUyMHJhYmJpdCUyMGluJTIwYSUyMHNwYWNlJTIwc3VpdC4=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-keyword">import</span> base64
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> io

client = InferenceClient(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>)

<span class="hljs-comment"># read image from local file</span>
image_path = <span class="hljs-string">&quot;rabbit.png&quot;</span>
<span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(image_path, <span class="hljs-string">&quot;rb&quot;</span>) <span class="hljs-keyword">as</span> f:
    image = base64.b64encode(f.read()).decode(<span class="hljs-string">&quot;utf-8&quot;</span>)

image = <span class="hljs-string">f&quot;data:image/png;base64,<span class="hljs-subst">{image}</span>&quot;</span>
prompt = <span class="hljs-string">f&quot;![](<span class="hljs-subst">{image}</span>)What is this a picture of?\\n\\n&quot;</span>

<span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> client.text_generation(prompt, max_new_tokens=<span class="hljs-number">10</span>, stream=<span class="hljs-literal">True</span>):
    <span class="hljs-built_in">print</span>(token)

<span class="hljs-comment"># This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),Z=new F({props:{title:"Inference Through Sending cURL Requests",local:"inference-through-sending-curl-requests",headingTag:"h3"}}),B=new z({props:{code:"Y3VybCUyMC1OJTIwMTI3LjAuMC4xJTNBMzAwMCUyRmdlbmVyYXRlX3N0cmVhbSUyMCU1QyUwQSUyMCUyMCUyMCUyMC1YJTIwUE9TVCUyMCU1QyUwQSUyMCUyMCUyMCUyMC1kJTIwJyU3QiUyMmlucHV0cyUyMiUzQSUyMiElNUIlNUQoaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGaHVnZ2luZ2ZhY2UlMkZkb2N1bWVudGF0aW9uLWltYWdlcyUyRnJlc29sdmUlMkZtYWluJTJGdHJhbnNmb3JtZXJzJTJGcmFiYml0LnBuZylXaGF0JTIwaXMlMjB0aGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUzRiU1Q24lNUNuJTIyJTJDJTIycGFyYW1ldGVycyUyMiUzQSU3QiUyMm1heF9uZXdfdG9rZW5zJTIyJTNBMTYlMkMlMjAlMjJzZWVkJTIyJTNBJTIwNDIlN0QlN0QnJTIwJTVDJTBBJTIwJTIwJTIwJTIwLUglMjAnQ29udGVudC1UeXBlJTNBJTIwYXBwbGljYXRpb24lMkZqc29uJyUwQSUwQSUyMyUyMC4uLiUwQSUyMyUyMGRhdGElM0ElN0IlMjJpbmRleCUyMiUzQTE2JTJDJTIydG9rZW4lMjIlM0ElN0IlMjJpZCUyMiUzQTI4NzIzJTJDJTIydGV4dCUyMiUzQSUyMi4lMjIlMkMlMjJsb2dwcm9iJTIyJTNBLTAuNjE5NjI4OSUyQyUyMnNwZWNpYWwlMjIlM0FmYWxzZSU3RCUyQyUyMmdlbmVyYXRlZF90ZXh0JTIyJTNBJTIyVGhpcyUyMGlzJTIwYSUyMHBpY3R1cmUlMjBvZiUyMGFuJTIwYW50aHJvcG9tb3JwaGljJTIwcmFiYml0JTIwaW4lMjBhJTIwc3BhY2UlMjBzdWl0LiUyMiUyQyUyMmRldGFpbHMlMjIlM0FudWxsJTdE",highlighted:`curl -N 127.0.0.1:3000/generate_stream \\
    -X POST \\
    -d <span class="hljs-string">&#x27;{&quot;inputs&quot;:&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;,&quot;parameters&quot;:{&quot;max_new_tokens&quot;:16, &quot;seed&quot;: 42}}&#x27;</span> \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span>

<span class="hljs-comment"># ...</span>
<span class="hljs-comment"># data:{&quot;index&quot;:16,&quot;token&quot;:{&quot;id&quot;:28723,&quot;text&quot;:&quot;.&quot;,&quot;logprob&quot;:-0.6196289,&quot;special&quot;:false},&quot;generated_text&quot;:&quot;This is a picture of an anthropomorphic rabbit in a space suit.&quot;,&quot;details&quot;:null}</span>`,wrap:!1}}),G=new F({props:{title:"Inference Through JavaScript",local:"inference-through-javascript",headingTag:"h3"}}),Q=new z({props:{code:"bnBtJTIwaW5zdGFsbCUyMCU0MGh1Z2dpbmdmYWNlJTJGaW5mZXJlbmNl",highlighted:"npm install @huggingface/inference",wrap:!1}}),E=new z({props:{code:"aW1wb3J0JTIwJTdCJTIwSGZJbmZlcmVuY2VFbmRwb2ludCUyMCU3RCUyMGZyb20lMjAlMjIlNDBodWdnaW5nZmFjZSUyRmluZmVyZW5jZSUyMiUzQiUwQSUwQWNvbnN0JTIwaGYlMjAlM0QlMjBuZXclMjBIZkluZmVyZW5jZUVuZHBvaW50KCUyMmh0dHAlM0ElMkYlMkYxMjcuMC4wLjElM0EzMDAwJTIyJTJDJTIwJTIySEZfVE9LRU4lMjIpJTNCJTBBJTBBY29uc3QlMjBwcm9tcHQlMjAlM0QlMEElMjAlMjAlMjIhJTVCJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRnRyYW5zZm9ybWVycyUyRnJhYmJpdC5wbmcpV2hhdCUyMGlzJTIwdGhpcyUyMGElMjBwaWN0dXJlJTIwb2YlM0YlNUNuJTVDbiUyMiUzQiUwQSUwQWNvbnN0JTIwc3RyZWFtJTIwJTNEJTIwaGYudGV4dEdlbmVyYXRpb25TdHJlYW0oJTdCJTBBJTIwJTIwaW5wdXRzJTNBJTIwcHJvbXB0JTJDJTBBJTIwJTIwcGFyYW1ldGVycyUzQSUyMCU3QiUyMG1heF9uZXdfdG9rZW5zJTNBJTIwMTYlMkMlMjBzZWVkJTNBJTIwNDIlMjAlN0QlMkMlMEElN0QpJTNCJTBBZm9yJTIwYXdhaXQlMjAoY29uc3QlMjByJTIwb2YlMjBzdHJlYW0pJTIwJTdCJTBBJTIwJTIwJTJGJTJGJTIweWllbGQlMjB0aGUlMjBnZW5lcmF0ZWQlMjB0b2tlbiUwQSUyMCUyMHByb2Nlc3Muc3Rkb3V0LndyaXRlKHIudG9rZW4udGV4dCklM0IlMEElN0QlMEElMEElMkYlMkYlMjBUaGlzJTIwaXMlMjBhJTIwcGljdHVyZSUyMG9mJTIwYW4lMjBhbnRocm9wb21vcnBoaWMlMjByYWJiaXQlMjBpbiUyMGElMjBzcGFjZSUyMHN1aXQu",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">HfInferenceEndpoint</span> } <span class="hljs-keyword">from</span> <span class="hljs-string">&quot;@huggingface/inference&quot;</span>;

<span class="hljs-keyword">const</span> hf = <span class="hljs-keyword">new</span> <span class="hljs-title class_">HfInferenceEndpoint</span>(<span class="hljs-string">&quot;http://127.0.0.1:3000&quot;</span>, <span class="hljs-string">&quot;HF_TOKEN&quot;</span>);

<span class="hljs-keyword">const</span> prompt =
  <span class="hljs-string">&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;</span>;

<span class="hljs-keyword">const</span> stream = hf.<span class="hljs-title function_">textGenerationStream</span>({
  <span class="hljs-attr">inputs</span>: prompt,
  <span class="hljs-attr">parameters</span>: { <span class="hljs-attr">max_new_tokens</span>: <span class="hljs-number">16</span>, <span class="hljs-attr">seed</span>: <span class="hljs-number">42</span> },
});
<span class="hljs-keyword">for</span> <span class="hljs-keyword">await</span> (<span class="hljs-keyword">const</span> r <span class="hljs-keyword">of</span> stream) {
  <span class="hljs-comment">// yield the generated token</span>
  process.<span class="hljs-property">stdout</span>.<span class="hljs-title function_">write</span>(r.<span class="hljs-property">token</span>.<span class="hljs-property">text</span>);
}

<span class="hljs-comment">// This is a picture of an anthropomorphic rabbit in a space suit.</span>`,wrap:!1}}),$=new F({props:{title:"Combining Vision Language Models with Other Features",local:"combining-vision-language-models-with-other-features",headingTag:"h2"}}),H=new z({props:{code:"JTdCJTBBJTIwJTIwJTIyYWN0aXZpdHklMjIlM0ElMjAlMjJTdGFuZGluZyUyMiUyQyUwQSUyMCUyMCUyMmFuaW1hbHMlMjIlM0ElMjAlNUIlMjJSYWJiaXQlMjIlNUQlMkMlMEElMjAlMjAlMjJhbmltYWxzX3NlZW4lMjIlM0ElMjAxJTJDJTBBJTIwJTIwJTIybG9jYXRpb24lMjIlM0ElMjAlMjJSb2NreSUyMHN1cmZhY2UlMjB3aXRoJTIwbW91bnRhaW5zJTIwaW4lMjB0aGUlMjBiYWNrZ3JvdW5kJTIwYW5kJTIwYSUyMHJlZCUyMGxpZ2h0JTIwb24lMjB0aGUlMjByYWJiaXQncyUyMGNoZXN0JTIyJTBBJTdE",highlighted:`<span class="hljs-punctuation">{</span>
  <span class="hljs-attr">&quot;activity&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Standing&quot;</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;animals&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-punctuation">[</span><span class="hljs-string">&quot;Rabbit&quot;</span><span class="hljs-punctuation">]</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;animals_seen&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-number">1</span><span class="hljs-punctuation">,</span>
  <span class="hljs-attr">&quot;location&quot;</span><span class="hljs-punctuation">:</span> <span class="hljs-string">&quot;Rocky surface with mountains in the background and a red light on the rabbit&#x27;s chest&quot;</span>
<span class="hljs-punctuation">}</span>`,wrap:!1}}),R=new z({props:{code:"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",highlighted:`curl localhost:3000/generate \\
    -X POST \\
    -H <span class="hljs-string">&#x27;Content-Type: application/json&#x27;</span> \\
    -d <span class="hljs-string">&#x27;{
    &quot;inputs&quot;:&quot;![](https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/rabbit.png)What is this a picture of?\\n\\n&quot;,
    &quot;parameters&quot;: {
        &quot;max_new_tokens&quot;: 100,
        &quot;seed&quot;: 42,
        &quot;grammar&quot;: {
            &quot;type&quot;: &quot;json&quot;,
            &quot;value&quot;: {
                &quot;properties&quot;: {
                    &quot;location&quot;: {
                        &quot;type&quot;: &quot;string&quot;
                    },
                    &quot;activity&quot;: {
                        &quot;type&quot;: &quot;string&quot;
                    },
                    &quot;animals_seen&quot;: {
                        &quot;type&quot;: &quot;integer&quot;,
                        &quot;minimum&quot;: 1,
                        &quot;maximum&quot;: 5
                    },
                    &quot;animals&quot;: {
                        &quot;type&quot;: &quot;array&quot;,
                        &quot;items&quot;: {
                            &quot;type&quot;: &quot;string&quot;
                        }
                    }
                },
                &quot;required&quot;: [&quot;location&quot;, &quot;activity&quot;, &quot;animals_seen&quot;, &quot;animals&quot;]
            }
        }
    }
}&#x27;</span>

<span class="hljs-comment"># {</span>
<span class="hljs-comment">#   &quot;generated_text&quot;: &quot;{ \\&quot;activity\\&quot;: \\&quot;Standing\\&quot;, \\&quot;animals\\&quot;: [ \\&quot;Rabbit\\&quot; ], \\&quot;animals_seen\\&quot;: 1, \\&quot;location\\&quot;: \\&quot;Rocky surface with mountains in the background and a red light on the rabbit&#x27;s chest\\&quot; }&quot;</span>
<span class="hljs-comment"># }</span>`,wrap:!1}}),X=new tt({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/basic_tutorials/visual_language_models.md"}}),{c(){j=s("meta"),D=a(),_=s("p"),P=a(),o(r.$$.fragment),K=a(),w=s("p"),w.textContent=Bl,O=a(),m=s("p"),m.textContent=Gl,ll=a(),C=s("blockquote"),C.innerHTML=Nl,tl=a(),h=s("p"),h.textContent=Ql,el=a(),I=s("ul"),I.innerHTML=Yl,nl=a(),o(d.$$.fragment),al=a(),o(g.$$.fragment),Ml=a(),f=s("p"),f.innerHTML=vl,sl=a(),o(b.$$.fragment),il=a(),o(A.$$.fragment),yl=a(),q=s("p"),q.innerHTML=El,ol=a(),o(Z.$$.fragment),Ul=a(),W=s("p"),W.innerHTML=$l,Jl=a(),o(B.$$.fragment),ul=a(),o(G.$$.fragment),pl=a(),N=s("p"),N.innerHTML=Sl,Tl=a(),o(Q.$$.fragment),jl=a(),Y=s("p"),Y.innerHTML=kl,cl=a(),v=s("p"),v.innerHTML=Hl,rl=a(),o(E.$$.fragment),wl=a(),o($.$$.fragment),ml=a(),S=s("p"),S.innerHTML=Vl,Cl=a(),c=s("div"),c.innerHTML=Rl,hl=a(),k=s("p"),k.textContent=xl,Il=a(),o(H.$$.fragment),dl=a(),V=s("p"),V.textContent=Xl,gl=a(),o(R.$$.fragment),fl=a(),x=s("p"),x.innerHTML=zl,bl=a(),o(X.$$.fragment),Al=a(),L=s("p"),this.h()},l(l){const t=Ol("svelte-u9bgzb",document.head);j=i(t,"META",{name:!0,content:!0}),t.forEach(e),D=M(l),_=i(l,"P",{}),Fl(_).forEach(e),P=M(l),U(r.$$.fragment,l),K=M(l),w=i(l,"P",{"data-svelte-h":!0}),y(w)!=="svelte-c5mqsg"&&(w.textContent=Bl),O=M(l),m=i(l,"P",{"data-svelte-h":!0}),y(m)!=="svelte-bme3bd"&&(m.textContent=Gl),ll=M(l),C=i(l,"BLOCKQUOTE",{"data-svelte-h":!0}),y(C)!=="svelte-oo54gt"&&(C.innerHTML=Nl),tl=M(l),h=i(l,"P",{"data-svelte-h":!0}),y(h)!=="svelte-1u3863s"&&(h.textContent=Ql),el=M(l),I=i(l,"UL",{"data-svelte-h":!0}),y(I)!=="svelte-9wqdub"&&(I.innerHTML=Yl),nl=M(l),U(d.$$.fragment,l),al=M(l),U(g.$$.fragment,l),Ml=M(l),f=i(l,"P",{"data-svelte-h":!0}),y(f)!=="svelte-fwtu6p"&&(f.innerHTML=vl),sl=M(l),U(b.$$.fragment,l),il=M(l),U(A.$$.fragment,l),yl=M(l),q=i(l,"P",{"data-svelte-h":!0}),y(q)!=="svelte-wt9qrx"&&(q.innerHTML=El),ol=M(l),U(Z.$$.fragment,l),Ul=M(l),W=i(l,"P",{"data-svelte-h":!0}),y(W)!=="svelte-omocvk"&&(W.innerHTML=$l),Jl=M(l),U(B.$$.fragment,l),ul=M(l),U(G.$$.fragment,l),pl=M(l),N=i(l,"P",{"data-svelte-h":!0}),y(N)!=="svelte-1qcvblx"&&(N.innerHTML=Sl),Tl=M(l),U(Q.$$.fragment,l),jl=M(l),Y=i(l,"P",{"data-svelte-h":!0}),y(Y)!=="svelte-yp1xs4"&&(Y.innerHTML=kl),cl=M(l),v=i(l,"P",{"data-svelte-h":!0}),y(v)!=="svelte-nw2yki"&&(v.innerHTML=Hl),rl=M(l),U(E.$$.fragment,l),wl=M(l),U($.$$.fragment,l),ml=M(l),S=i(l,"P",{"data-svelte-h":!0}),y(S)!=="svelte-kstfyt"&&(S.innerHTML=Vl),Cl=M(l),c=i(l,"DIV",{class:!0,"data-svelte-h":!0}),y(c)!=="svelte-vm0v0f"&&(c.innerHTML=Rl),hl=M(l),k=i(l,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1fqoo0l"&&(k.textContent=xl),Il=M(l),U(H.$$.fragment,l),dl=M(l),V=i(l,"P",{"data-svelte-h":!0}),y(V)!=="svelte-4bcx48"&&(V.textContent=Xl),gl=M(l),U(R.$$.fragment,l),fl=M(l),x=i(l,"P",{"data-svelte-h":!0}),y(x)!=="svelte-am908w"&&(x.innerHTML=zl),bl=M(l),U(X.$$.fragment,l),Al=M(l),L=i(l,"P",{}),Fl(L).forEach(e),this.h()},h(){Zl(j,"name","hf:doc:metadata"),Zl(j,"content",nt),Zl(c,"class","flex justify-center")},m(l,t){lt(document.head,j),n(l,D,t),n(l,_,t),n(l,P,t),J(r,l,t),n(l,K,t),n(l,w,t),n(l,O,t),n(l,m,t),n(l,ll,t),n(l,C,t),n(l,tl,t),n(l,h,t),n(l,el,t),n(l,I,t),n(l,nl,t),J(d,l,t),n(l,al,t),J(g,l,t),n(l,Ml,t),n(l,f,t),n(l,sl,t),J(b,l,t),n(l,il,t),J(A,l,t),n(l,yl,t),n(l,q,t),n(l,ol,t),J(Z,l,t),n(l,Ul,t),n(l,W,t),n(l,Jl,t),J(B,l,t),n(l,ul,t),J(G,l,t),n(l,pl,t),n(l,N,t),n(l,Tl,t),J(Q,l,t),n(l,jl,t),n(l,Y,t),n(l,cl,t),n(l,v,t),n(l,rl,t),J(E,l,t),n(l,wl,t),J($,l,t),n(l,ml,t),n(l,S,t),n(l,Cl,t),n(l,c,t),n(l,hl,t),n(l,k,t),n(l,Il,t),J(H,l,t),n(l,dl,t),n(l,V,t),n(l,gl,t),J(R,l,t),n(l,fl,t),n(l,x,t),n(l,bl,t),J(X,l,t),n(l,Al,t),n(l,L,t),ql=!0},p:Ll,i(l){ql||(u(r.$$.fragment,l),u(d.$$.fragment,l),u(g.$$.fragment,l),u(b.$$.fragment,l),u(A.$$.fragment,l),u(Z.$$.fragment,l),u(B.$$.fragment,l),u(G.$$.fragment,l),u(Q.$$.fragment,l),u(E.$$.fragment,l),u($.$$.fragment,l),u(H.$$.fragment,l),u(R.$$.fragment,l),u(X.$$.fragment,l),ql=!0)},o(l){p(r.$$.fragment,l),p(d.$$.fragment,l),p(g.$$.fragment,l),p(b.$$.fragment,l),p(A.$$.fragment,l),p(Z.$$.fragment,l),p(B.$$.fragment,l),p(G.$$.fragment,l),p(Q.$$.fragment,l),p(E.$$.fragment,l),p($.$$.fragment,l),p(H.$$.fragment,l),p(R.$$.fragment,l),p(X.$$.fragment,l),ql=!1},d(l){l&&(e(D),e(_),e(P),e(K),e(w),e(O),e(m),e(ll),e(C),e(tl),e(h),e(el),e(I),e(nl),e(al),e(Ml),e(f),e(sl),e(il),e(yl),e(q),e(ol),e(Ul),e(W),e(Jl),e(ul),e(pl),e(N),e(Tl),e(jl),e(Y),e(cl),e(v),e(rl),e(wl),e(ml),e(S),e(Cl),e(c),e(hl),e(k),e(Il),e(dl),e(V),e(gl),e(fl),e(x),e(bl),e(Al),e(L)),e(j),T(r,l),T(d,l),T(g,l),T(b,l),T(A,l),T(Z,l),T(B,l),T(G,l),T(Q,l),T(E,l),T($,l),T(H,l),T(R,l),T(X,l)}}}const nt='{"title":"Vision Language Model Inference in TGI","local":"vision-language-model-inference-in-tgi","sections":[{"title":"How to Use a Vision Language Model?","local":"how-to-use-a-vision-language-model","sections":[{"title":"Hugging Face Hub Python Library","local":"hugging-face-hub-python-library","sections":[],"depth":3},{"title":"Inference Through Sending cURL Requests","local":"inference-through-sending-curl-requests","sections":[],"depth":3},{"title":"Inference Through JavaScript","local":"inference-through-javascript","sections":[],"depth":3}],"depth":2},{"title":"Combining Vision Language Models with Other Features","local":"combining-vision-language-models-with-other-features","sections":[],"depth":2}],"depth":1}';function at(Wl){return Dl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ot extends Pl{constructor(j){super(),Kl(this,j,at,et,_l,{})}}export{ot as component};
