import{s as me,n as Te,o as oe}from"../chunks/scheduler.362310b7.js";import{S as re,i as ce,g as M,s as a,r as m,A as Ue,h as i,f as l,c as s,j as Me,u as T,x as R,k as ie,y as Je,a as n,v as o,d as r,t as c,w as U}from"../chunks/index.57dfc70d.js";import{C as pe}from"../chunks/CodeBlock.d3c47f83.js";import{H as N,E as de}from"../chunks/EditOnGithub.9633c464.js";function he(q){let p,k,Z,B,J,W,d,K=`The NVIDIA TensorRT-LLM (TRTLLM) backend is a high-performance backend for LLMs
that uses NVIDIA’s TensorRT library for inference acceleration.
It makes use of specific optimizations for NVIDIA GPUs, such as custom kernels.`,G,h,ee=`To use the TRTLLM backend you need to compile <code>engines</code> for the models you want to use.
Each <code>engine</code> must be compiled on the same GPU architecture that you will use for inference.`,v,w,x,u,te=`Check the <a href="https://nvidia.github.io/TensorRT-LLM/reference/support-matrix.html" rel="nofollow">support matrix</a> to see which models are
supported.`,_,E,V,j,le=`You can use <a href="https://github.com/huggingface/optimum-nvidia" rel="nofollow">Optimum-NVIDIA</a> to compile engines for the models you
want to use.`,S,b,D,f,ne="Your compiled engine will be saved in the <code>/tmp/engines/$MODEL_NAME</code> directory.",H,y,F,g,ae="Run TGI-TRTLLM Docker image with the compiled engine:",X,I,Q,$,Y,L,se=`To develop TRTLLM backend, you can use <a href="https://containers.dev/" rel="nofollow">dev containers</a> located in
<code>.devcontainer</code> directory.`,O,A,z,C,P;return J=new N({props:{title:"TensorRT-LLM backend",local:"tensorrt-llm-backend",headingTag:"h1"}}),w=new N({props:{title:"Supported models",local:"supported-models",headingTag:"h2"}}),E=new N({props:{title:"Compiling engines",local:"compiling-engines",headingTag:"h2"}}),b=new pe({props:{code:"TU9ERUxfTkFNRSUzRCUyMm1ldGEtbGxhbWElMkZMbGFtYS0zLjEtOEItSW5zdHJ1Y3QlMjIlMEElMEElMjMlMjBJbnN0YWxsJTIwaHVnZ2luZ2ZhY2VfY2xpJTBBcHl0aG9uJTIwLW0lMjBwaXAlMjBpbnN0YWxsJTIwaHVnZ2luZ2ZhY2UtY2xpJTVCaGZfdHJhbnNmZXIlNUQlMEElMEElMjMlMjBMb2dpbiUyMHRvJTIwdGhlJTIwSHVnZ2luZyUyMEZhY2UlMjBIdWIlMEFodWdnaW5nZmFjZS1jbGklMjBsb2dpbiUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBkaXJlY3RvcnklMjB0byUyMHN0b3JlJTIwdGhlJTIwbW9kZWwlMEFta2RpciUyMC1wJTIwJTJGdG1wJTJGbW9kZWxzJTJGJTI0TU9ERUxfTkFNRSUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBkaXJlY3RvcnklMjB0byUyMHN0b3JlJTIwdGhlJTIwY29tcGlsZWQlMjBlbmdpbmUlMEFta2RpciUyMC1wJTIwJTJGdG1wJTJGZW5naW5lcyUyRiUyNE1PREVMX05BTUUlMEElMEElMjMlMjBEb3dubG9hZCUyMHRoZSUyMG1vZGVsJTBBSEZfSFVCX0VOQUJMRV9IRl9UUkFOU0ZFUiUzRDElMjBodWdnaW5nZmFjZS1jbGklMjBkb3dubG9hZCUyMC0tbG9jYWwtZGlyJTIwJTJGdG1wJTJGbW9kZWxzJTJGJTI0TU9ERUxfTkFNRSUyMCUyNE1PREVMX05BTUUlMEElMEElMjMlMjBDb21waWxlJTIwdGhlJTIwZW5naW5lJTIwdXNpbmclMjBPcHRpbXVtLU5WSURJQSUwQWRvY2tlciUyMHJ1biUyMCU1QyUwQSUyMCUyMC0tcm0lMjAlNUMlMEElMjAlMjAtaXQlMjAlNUMlMEElMjAlMjAtLWdwdXMlM0QxJTIwJTVDJTBBJTIwJTIwLXYlMjAlMkZ0bXAlMkZtb2RlbHMlMkYlMjRNT0RFTF9OQU1FJTNBJTJGbW9kZWwlMjAlNUMlMEElMjAlMjAtdiUyMCUyRnRtcCUyRmVuZ2luZXMlMkYlMjRNT0RFTF9OQU1FJTNBJTJGZW5naW5lJTIwJTVDJTBBJTIwJTIwaHVnZ2luZ2ZhY2UlMkZvcHRpbXVtLW52aWRpYSUyMCU1QyUwQSUyMCUyMCUyMCUyMG9wdGltdW0tY2xpJTIwZXhwb3J0JTIwdHJ0bGxtJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS10cCUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLXBwJTNEMSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWF4LWJhdGNoLXNpemUlM0QxMjglMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heC1pbnB1dC1sZW5ndGglMjA0MDk2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1tYXgtb3V0cHV0LWxlbmd0aCUyMDgxOTIlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heC1iZWFtcy13aWR0aCUzRDElMjAlNUMlMEElMjAlMjAlMjAlMjAtLWRlc3RpbmF0aW9uJTIwJTJGZW5naW5lJTIwJTVDJTBBJTIwJTIwJTIwJTIwJTI0TU9ERUxfTkFNRQ==",highlighted:`MODEL_NAME=<span class="hljs-string">&quot;meta-llama/Llama-3.1-8B-Instruct&quot;</span>

<span class="hljs-comment"># Install huggingface_cli</span>
python -m pip install huggingface-cli[hf_transfer]

<span class="hljs-comment"># Login to the Hugging Face Hub</span>
huggingface-cli login

<span class="hljs-comment"># Create a directory to store the model</span>
<span class="hljs-built_in">mkdir</span> -p /tmp/models/<span class="hljs-variable">$MODEL_NAME</span>

<span class="hljs-comment"># Create a directory to store the compiled engine</span>
<span class="hljs-built_in">mkdir</span> -p /tmp/engines/<span class="hljs-variable">$MODEL_NAME</span>

<span class="hljs-comment"># Download the model</span>
HF_HUB_ENABLE_HF_TRANSFER=1 huggingface-cli download --local-dir /tmp/models/<span class="hljs-variable">$MODEL_NAME</span> <span class="hljs-variable">$MODEL_NAME</span>

<span class="hljs-comment"># Compile the engine using Optimum-NVIDIA</span>
docker run \\
  --<span class="hljs-built_in">rm</span> \\
  -it \\
  --gpus=1 \\
  -v /tmp/models/<span class="hljs-variable">$MODEL_NAME</span>:/model \\
  -v /tmp/engines/<span class="hljs-variable">$MODEL_NAME</span>:/engine \\
  huggingface/optimum-nvidia \\
    optimum-cli <span class="hljs-built_in">export</span> trtllm \\
    --tp=1 \\
    --pp=1 \\
    --max-batch-size=128 \\
    --max-input-length 4096 \\
    --max-output-length 8192 \\
    --max-beams-width=1 \\
    --destination /engine \\
    <span class="hljs-variable">$MODEL_NAME</span>`,wrap:!1}}),y=new N({props:{title:"Using the TRTLLM backend",local:"using-the-trtllm-backend",headingTag:"h2"}}),I=new pe({props:{code:"ZG9ja2VyJTIwcnVuJTIwJTVDJTBBJTIwJTIwLS1ncHVzJTIwMSUyMCU1QyUwQSUyMCUyMC1pdCUyMCU1QyUwQSUyMCUyMC0tcm0lMjAlNUMlMEElMjAlMjAtcCUyMDMwMDAlM0EzMDAwJTIwJTVDJTBBJTIwJTIwLWUlMjBNT0RFTCUzRCUyNE1PREVMX05BTUUlMjAlNUMlMEElMjAlMjAtZSUyMFBPUlQlM0QzMDAwJTIwJTVDJTBBJTIwJTIwLWUlMjBIRl9UT0tFTiUzRCdoZl9YWFgnJTIwJTVDJTBBJTIwJTIwLXYlMjAlMkZ0bXAlMkZlbmdpbmVzJTJGJTI0TU9ERUxfTkFNRSUzQSUyRmRhdGElMjAlNUMlMEElMjAlMjBnaGNyLmlvJTJGaHVnZ2luZ2ZhY2UlMkZ0ZXh0LWdlbmVyYXRpb24taW5mZXJlbmNlJTNBbGF0ZXN0LXRydGxsbSUyMCU1QyUwQSUyMCUyMC0tZXhlY3V0b3Itd29ya2VyJTIwZXhlY3V0b3JXb3JrZXIlMjAlNUMlMEElMjAlMjAtLW1vZGVsLWlkJTIwJTJGZGF0YSUyRiUyNE1PREVMX05BTUU=",highlighted:`docker run \\
  --gpus 1 \\
  -it \\
  --<span class="hljs-built_in">rm</span> \\
  -p 3000:3000 \\
  -e MODEL=<span class="hljs-variable">$MODEL_NAME</span> \\
  -e PORT=3000 \\
  -e HF_TOKEN=<span class="hljs-string">&#x27;hf_XXX&#x27;</span> \\
  -v /tmp/engines/<span class="hljs-variable">$MODEL_NAME</span>:/data \\
  ghcr.io/huggingface/text-generation-inference:latest-trtllm \\
  --executor-worker executorWorker \\
  --model-id /data/<span class="hljs-variable">$MODEL_NAME</span>`,wrap:!1}}),$=new N({props:{title:"Development",local:"development",headingTag:"h2"}}),A=new de({props:{source:"https://github.com/huggingface/text-generation-inference/blob/main/docs/source/backends/trtllm.md"}}),{c(){p=M("meta"),k=a(),Z=M("p"),B=a(),m(J.$$.fragment),W=a(),d=M("p"),d.textContent=K,G=a(),h=M("p"),h.innerHTML=ee,v=a(),m(w.$$.fragment),x=a(),u=M("p"),u.innerHTML=te,_=a(),m(E.$$.fragment),V=a(),j=M("p"),j.innerHTML=le,S=a(),m(b.$$.fragment),D=a(),f=M("p"),f.innerHTML=ne,H=a(),m(y.$$.fragment),F=a(),g=M("p"),g.textContent=ae,X=a(),m(I.$$.fragment),Q=a(),m($.$$.fragment),Y=a(),L=M("p"),L.innerHTML=se,O=a(),m(A.$$.fragment),z=a(),C=M("p"),this.h()},l(e){const t=Ue("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),k=s(e),Z=i(e,"P",{}),Me(Z).forEach(l),B=s(e),T(J.$$.fragment,e),W=s(e),d=i(e,"P",{"data-svelte-h":!0}),R(d)!=="svelte-epnzkj"&&(d.textContent=K),G=s(e),h=i(e,"P",{"data-svelte-h":!0}),R(h)!=="svelte-16zyru5"&&(h.innerHTML=ee),v=s(e),T(w.$$.fragment,e),x=s(e),u=i(e,"P",{"data-svelte-h":!0}),R(u)!=="svelte-rn0qcd"&&(u.innerHTML=te),_=s(e),T(E.$$.fragment,e),V=s(e),j=i(e,"P",{"data-svelte-h":!0}),R(j)!=="svelte-9xp6zc"&&(j.innerHTML=le),S=s(e),T(b.$$.fragment,e),D=s(e),f=i(e,"P",{"data-svelte-h":!0}),R(f)!=="svelte-1ty5xye"&&(f.innerHTML=ne),H=s(e),T(y.$$.fragment,e),F=s(e),g=i(e,"P",{"data-svelte-h":!0}),R(g)!=="svelte-1c6w5xw"&&(g.textContent=ae),X=s(e),T(I.$$.fragment,e),Q=s(e),T($.$$.fragment,e),Y=s(e),L=i(e,"P",{"data-svelte-h":!0}),R(L)!=="svelte-18bkxzv"&&(L.innerHTML=se),O=s(e),T(A.$$.fragment,e),z=s(e),C=i(e,"P",{}),Me(C).forEach(l),this.h()},h(){ie(p,"name","hf:doc:metadata"),ie(p,"content",we)},m(e,t){Je(document.head,p),n(e,k,t),n(e,Z,t),n(e,B,t),o(J,e,t),n(e,W,t),n(e,d,t),n(e,G,t),n(e,h,t),n(e,v,t),o(w,e,t),n(e,x,t),n(e,u,t),n(e,_,t),o(E,e,t),n(e,V,t),n(e,j,t),n(e,S,t),o(b,e,t),n(e,D,t),n(e,f,t),n(e,H,t),o(y,e,t),n(e,F,t),n(e,g,t),n(e,X,t),o(I,e,t),n(e,Q,t),o($,e,t),n(e,Y,t),n(e,L,t),n(e,O,t),o(A,e,t),n(e,z,t),n(e,C,t),P=!0},p:Te,i(e){P||(r(J.$$.fragment,e),r(w.$$.fragment,e),r(E.$$.fragment,e),r(b.$$.fragment,e),r(y.$$.fragment,e),r(I.$$.fragment,e),r($.$$.fragment,e),r(A.$$.fragment,e),P=!0)},o(e){c(J.$$.fragment,e),c(w.$$.fragment,e),c(E.$$.fragment,e),c(b.$$.fragment,e),c(y.$$.fragment,e),c(I.$$.fragment,e),c($.$$.fragment,e),c(A.$$.fragment,e),P=!1},d(e){e&&(l(k),l(Z),l(B),l(W),l(d),l(G),l(h),l(v),l(x),l(u),l(_),l(V),l(j),l(S),l(D),l(f),l(H),l(F),l(g),l(X),l(Q),l(Y),l(L),l(O),l(z),l(C)),l(p),U(J,e),U(w,e),U(E,e),U(b,e),U(y,e),U(I,e),U($,e),U(A,e)}}}const we='{"title":"TensorRT-LLM backend","local":"tensorrt-llm-backend","sections":[{"title":"Supported models","local":"supported-models","sections":[],"depth":2},{"title":"Compiling engines","local":"compiling-engines","sections":[],"depth":2},{"title":"Using the TRTLLM backend","local":"using-the-trtllm-backend","sections":[],"depth":2},{"title":"Development","local":"development","sections":[],"depth":2}],"depth":1}';function ue(q){return oe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends re{constructor(p){super(),ce(this,p,ue,he,me,{})}}export{ye as component};
