import{s as es,o as ts,n as ls}from"../chunks/scheduler.8c3d61f6.js";import{S as ns,i as ss,g as o,s,r as m,A as as,h as p,f as l,c as a,j as Kn,u as c,x as i,k as On,y as os,a as n,v as d,d as r,t as u,w as M}from"../chunks/index.da70eac4.js";import{T as ps}from"../chunks/Tip.1d9b8c37.js";import{C as b}from"../chunks/CodeBlock.a9c4becf.js";import{H as f,E as is}from"../chunks/getInferenceSnippets.fffe7af1.js";function ms(ct){let h,w="🧪 <strong>Experimental Feature</strong>: This is an experimental feature we are actively developing. The API may be subject to breaking changes.";return{c(){h=o("p"),h.innerHTML=w},l(y){h=p(y,"P",{"data-svelte-h":!0}),i(h)!=="svelte-1r0wgxy"&&(h.innerHTML=w)},m(y,it){n(y,h,it)},p:ls,d(y){y&&l(h)}}}function cs(ct){let h,w,y,it,g,dt,j,rt,J,en="The Components Manager is a central model registry and management system in diffusers. It lets you add models then reuse them across multiple pipelines and workflows. It tracks all models in one place with useful metadata such as model size, device placement and loaded adapters (LoRA, IP-Adapter). It has mechanisms in place to prevent duplicate model instances, enables memory-efficient sharing. Most significantly, it offers offloading that works across pipelines — unlike regular DiffusionPipeline offloading (i.e. <code>enable_model_cpu_offload</code> and <code>enable_sequential_cpu_offload</code>) which is limited to one pipeline with predefined sequences, the Components Manager automatically manages your device memory across all your models and workflows.",ut,Z,Mt,T,tn="Let’s start with the most basic operations. First, create a Components Manager:",bt,_,ht,x,ln="Use the <code>add(name, component)</code> method to register a component. It returns a unique ID that combines the component name with the object’s unique identifier (using Python’s <code>id()</code> function):",yt,U,ft,C,nn="You can view all registered components and their metadata:",jt,G,wt,v,sn="And remove components using their unique ID:",gt,W,Jt,$,Zt,B,an="The Components Manager automatically detects and prevents duplicate model instances to save memory and avoid confusion. Let’s walk through how this works in practice.",Tt,I,on="When you try to add the same object twice, the manager will warn you and return the existing ID:",_t,V,xt,X,pn="Even if you add the same object under a different name, it will still be detected as a duplicate:",Ut,R,Ct,k,mn="However, there’s a more subtle case where duplicate detection becomes tricky. When you load the same model into different objects, the manager can’t detect duplicates unless you use <code>ComponentSpec</code>. For example:",Gt,N,vt,Y,cn="This creates a problem - you now have two copies of the same model consuming double the memory:",Wt,z,$t,H,dn="We recommend using <code>ComponentSpec</code> to load your models. Models loaded with <code>ComponentSpec</code> get tagged with a unique ID that encodes their loading parameters, allowing the Components Manager to detect when different objects represent the same underlying checkpoint:",Bt,Q,It,q,rn="Now the manager detects the duplicate and warns you:",Vt,F,Xt,E,un="Both models now show the same <code>load_id</code>, making it clear they’re the same model:",Rt,S,kt,L,Nt,D,Mn="Collections are labels you can assign to components for better organization and management. You add a component under a collection by passing the <code>collection=</code> parameter when you add the component to the manager, i.e. <code>add(name, component, collection=...)</code>. Within each collection, only one component per name is allowed - if you add a second component with the same name, the first one is automatically removed.",Yt,A,bn="Here’s how collections work in practice:",zt,P,Ht,K,hn="The manager automatically removes the old UNet and adds the new one:",Qt,O,qt,ee,yn="Only one UNet remains in the collection:",Ft,te,Et,le,fn="For example, in node-based systems, you can mark all models loaded from one node with the same collection label, automatically replace models when user loads new checkpoints under same name, batch delete all models in a collection when a node is removed.",St,ne,Lt,se,jn="The Components Manager provides several methods to retrieve registered components.",Dt,ae,wn="The <code>get_one()</code> method returns a single component and supports pattern matching for the <code>name</code> parameter. You can use:",At,oe,gn="<li>exact matches like <code>comp.get_one(name=&quot;unet&quot;)</code></li> <li>wildcards like <code>comp.get_one(name=&quot;unet*&quot;)</code> for components starting with “unet”</li> <li>exclusion patterns like <code>comp.get_one(name=&quot;!unet&quot;)</code> to exclude components named “unet”</li> <li>OR patterns like <code>comp.get_one(name=&quot;unet|vae&quot;)</code> to match either “unet” OR “vae”.</li>",Pt,pe,Jn="Optionally, You can add collection and load_id as filters e.g. <code>comp.get_one(name=&quot;unet&quot;, collection=&quot;sdxl&quot;)</code>. If multiple components match, <code>get_one()</code> throws an error.",Kt,ie,Zn="Another useful method is <code>get_components_by_names()</code>, which takes a list of names and returns a dictionary mapping names to components. This is particularly helpful with modular pipelines since they provide lists of required component names, and the returned dictionary can be directly passed to <code>pipeline.update_components()</code>.",Ot,me,el,ce,tl,de,Tn="The Components Manager integrates seamlessly with Modular Pipelines. All you need to do is pass a Components Manager instance to <code>from_pretrained()</code> or <code>init_pipeline()</code> with an optional <code>collection</code> parameter:",ll,re,nl,ue,_n="By default, modular pipelines don’t load components immediately, so both the pipeline and Components Manager start empty:",sl,Me,al,be,xn="When you load components on the pipeline, they are automatically registered in the Components Manager:",ol,he,pl,ye,Un="Now let’s load all default components and then create a second pipeline that reuses all components from the first one. We pass the same Components Manager to the second pipeline but with a different collection:",il,fe,ml,je,Cn="As mentioned earlier, <code>ModularPipeline</code> has a property <code>null_component_names</code> that returns a list of component names it needs to load. We can conveniently use this list with the <code>get_components_by_names</code> method on the Components Manager:",cl,we,dl,ge,Gn="The warnings that follow are expected and indicate that the Components Manager is correctly identifying that these components already exist and will be reused rather than creating duplicates:",rl,Je,ul,Ze,vn="The pipeline is now fully loaded:",Ml,Te,bl,_e,Wn="No new components were added to the Components Manager - we’re reusing everything. All models are now associated with both <code>test1</code> and <code>test2</code> collections, showing that these components are shared across multiple pipelines:",hl,xe,yl,Ue,fl,Ce,$n="The Components Manager provides a global offloading strategy across all models, regardless of which pipeline is using them:",jl,Ge,wl,ve,Bn="When enabled, all models start on CPU. The manager moves models to the device right before they’re used and moves other models back to CPU when GPU memory runs low. You can set your own rules for which models to offload first. This works smoothly as you add or remove components. Once it’s on, you don’t need to worry about device placement - you can focus on your workflow.",gl,We,Jl,$e,In="Now that we’ve covered the basics of the Components Manager, let’s walk through a practical example that shows how to build workflows in a modular setting and use the Components Manager to reuse components across multiple pipelines. This example demonstrates the true power of Modular Diffusers by working with multiple pipelines that can share components.",Zl,Be,Vn="In this example, we’ll generate latents from a text-to-image pipeline, then refine them with an image-to-image pipeline.",Tl,Ie,Xn="Let’s create a modular text-to-image workflow by separating it into three workflows: <code>text_blocks</code> for encoding prompts, <code>t2i_blocks</code> for generating latents, and <code>decoder_blocks</code> for creating final images.",_l,Ve,xl,Xe,Rn="Now we will convert them into runnalbe pipelines and set up the Components Manager with auto offloading and organize components under a “t2i” collection",Ul,Re,kn="Since we now have 3 different workflows that share components, we create a separate pipeline that serves as a dedicated loader to load all the components, register them to the component manager, and then reuse them across different workflows.",Cl,ke,Gl,Ne,Nn="Load all components into the loader pipeline, they should all be automatically registered to Components Manager under the “t2i” collection:",vl,Ye,Wl,ze,Yn="Now distribute the loaded components to each pipeline:",$l,He,Bl,Qe,zn="Now we can generate images using our modular workflow:",Il,qe,Vl,Fe,Hn="Let’s add a LoRA:",Xl,Ee,Rl,Se,Qn="You can see that the Components Manager tracks adapters metadata for all models it manages, and in our case, only Unet has lora loaded. This means we can reuse existing text embeddings.",kl,Le,Nl,De,qn="Now let’s create a refiner pipeline that reuses components from our text-to-image workflow:",Yl,Ae,zl,Pe,Fn="We pass the <strong>same Components Manager</strong> (<code>components</code>) to the refiner pipeline, but with a <strong>different collection</strong> (<code>&quot;refiner&quot;</code>). This allows the refiner to access and reuse components from the “t2i” collection while organizing its own components (like the refiner UNet) under the “refiner” collection.",Hl,Ke,Ql,Oe,En="When we reuse components from the “t2i” collection, they automatically get added to the “refiner” collection as well. You can verify this by checking the Components Manager - you’ll see components like <code>vae</code>, <code>scheduler</code>, etc. listed under both collections, indicating they’re shared between workflows.",ql,et,Sn="Now we can refine any of our generated latents:",Fl,tt,El,lt,Ln="Here are the results from our modular pipeline examples.",Sl,nt,Ll,st,Dn='<thead><tr><th>Base Text-to-Image</th> <th>Base Text-to-Image (Refined)</th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/modular_quicktour/modular_part2_t2i.png" alt="Base T2I"/></td> <td><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/modular_quicktour/modular_part2_t2i_refine_out.png" alt="Base T2I Refined"/></td></tr></tbody>',Dl,at,Al,ot,An='<thead><tr><th>LoRA</th> <th>LoRA               (Refined)</th></tr></thead> <tbody><tr><td><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/modular_quicktour/modular_part2_lora.png" alt="LoRA"/></td> <td><img src="https://huggingface.co/datasets/YiYiXu/testing-images/resolve/main/modular_quicktour/modular_part2_lora_refine_out.png" alt="LoRA Refined"/></td></tr></tbody>',Pl,pt,Kl,mt,Ol;return g=new f({props:{title:"Components Manager",local:"components-manager",headingTag:"h1"}}),j=new ps({props:{warning:!0,$$slots:{default:[ms]},$$scope:{ctx:ct}}}),Z=new f({props:{title:"Basic Operations",local:"basic-operations",headingTag:"h2"}}),_=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTBBY29tcCUyMCUzRCUyMENvbXBvbmVudHNNYW5hZ2VyKCk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentsManager
comp = ComponentsManager()`,wrap:!1}}),U=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9Nb2RlbCUwQXRleHRfZW5jb2RlciUyMCUzRCUyMEF1dG9Nb2RlbC5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyKSUwQSUyMyUyMFJldHVybnMlMjBjb21wb25lbnRfaWQlMjBsaWtlJTIwJ3RleHRfZW5jb2Rlcl8xMzk5MTc3MzMwNDI4NjQnJTBBY29tcG9uZW50X2lkJTIwJTNEJTIwY29tcC5hZGQoJTIydGV4dF9lbmNvZGVyJTIyJTJDJTIwdGV4dF9lbmNvZGVyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoModel
text_encoder = AutoModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)
<span class="hljs-comment"># Returns component_id like &#x27;text_encoder_139917733042864&#x27;</span>
component_id = comp.add(<span class="hljs-string">&quot;text_encoder&quot;</span>, text_encoder)`,wrap:!1}}),G=new b({props:{code:"Y29tcCUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
===============================================================================================================================================
Models:
-----------------------------------------------------------------------------------------------------------------------------------------------
Name_ID                      | Class                     | Device: act(<span class="hljs-built_in">exec</span>)    | Dtype           | Size (GB)  | Load ID         | Collection
-----------------------------------------------------------------------------------------------------------------------------------------------
text_encoder_139917733042864 | CLIPTextModel             | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | N/A             | N/A
-----------------------------------------------------------------------------------------------------------------------------------------------

Additional Component Info:
==================================================`,wrap:!1}}),W=new b({props:{code:"Y29tcC5yZW1vdmUoJTIydGV4dF9lbmNvZGVyXzEzOTkxNzczMzA0Mjg2NCUyMik=",highlighted:'comp.remove(<span class="hljs-string">&quot;text_encoder_139917733042864&quot;</span>)',wrap:!1}}),$=new f({props:{title:"Duplicate Detection",local:"duplicate-detection",headingTag:"h2"}}),V=new b({props:{code:"Y29tcC5hZGQoJTIydGV4dF9lbmNvZGVyJTIyJTJDJTIwdGV4dF9lbmNvZGVyKSUwQWNvbXAuYWRkKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHRleHRfZW5jb2Rlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp.add(<span class="hljs-string">&quot;text_encoder&quot;</span>, text_encoder)
<span class="hljs-string">&#x27;text_encoder_139917733042864&#x27;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>comp.add(<span class="hljs-string">&quot;text_encoder&quot;</span>, text_encoder)
ComponentsManager: component <span class="hljs-string">&#x27;text_encoder&#x27;</span> already exists <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;text_encoder_139917733042864&#x27;</span>
<span class="hljs-string">&#x27;text_encoder_139917733042864&#x27;</span>`,wrap:!1}}),R=new b({props:{code:"Y29tcC5hZGQoJTIyY2xpcCUyMiUyQyUyMHRleHRfZW5jb2Rlcik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp.add(<span class="hljs-string">&quot;clip&quot;</span>, text_encoder)
ComponentsManager: adding component <span class="hljs-string">&#x27;clip&#x27;</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;clip_139917733042864&#x27;</span>, but it <span class="hljs-keyword">is</span> duplicate of <span class="hljs-string">&#x27;text_encoder_139917733042864&#x27;</span>
To remove a duplicate, call \`components_manager.remove(<span class="hljs-string">&#x27;&lt;component_id&gt;&#x27;</span>)\`.
<span class="hljs-string">&#x27;clip_139917733042864&#x27;</span>`,wrap:!1}}),N=new b({props:{code:"dGV4dF9lbmNvZGVyXzIlMjAlM0QlMjBBdXRvTW9kZWwuZnJvbV9wcmV0cmFpbmVkKCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiklMEFjb21wLmFkZCglMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMjB0ZXh0X2VuY29kZXJfMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>text_encoder_2 = AutoModel.from_pretrained(<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>comp.add(<span class="hljs-string">&quot;text_encoder&quot;</span>, text_encoder_2)
<span class="hljs-string">&#x27;text_encoder_139917732983664&#x27;</span>`,wrap:!1}}),z=new b({props:{code:"Y29tcCUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
===============================================================================================================================================
Models:
-----------------------------------------------------------------------------------------------------------------------------------------------
Name_ID                      | Class                     | Device: act(<span class="hljs-built_in">exec</span>)    | Dtype           | Size (GB)  | Load ID         | Collection
-----------------------------------------------------------------------------------------------------------------------------------------------
text_encoder_139917733042864 | CLIPTextModel             | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | N/A             | N/A
clip_139917733042864         | CLIPTextModel             | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | N/A             | N/A
text_encoder_139917732983664 | CLIPTextModel             | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | N/A             | N/A
-----------------------------------------------------------------------------------------------------------------------------------------------

Additional Component Info:
==================================================`,wrap:!1}}),Q=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudFNwZWMlMkMlMjBDb21wb25lbnRzTWFuYWdlciUwQWZyb20lMjB0cmFuc2Zvcm1lcnMlMjBpbXBvcnQlMjBDTElQVGV4dE1vZGVsJTBBY29tcCUyMCUzRCUyMENvbXBvbmVudHNNYW5hZ2VyKCklMEElMEElMjMlMjBDcmVhdGUlMjBDb21wb25lbnRTcGVjJTIwZm9yJTIwdGhlJTIwZmlyc3QlMjB0ZXh0JTIwZW5jb2RlciUwQXNwZWMlMjAlM0QlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMjByZXBvJTNEJTIyc3RhYmlsaXR5YWklMkZzdGFibGUtZGlmZnVzaW9uLXhsLWJhc2UtMS4wJTIyJTJDJTIwc3ViZm9sZGVyJTNEJTIydGV4dF9lbmNvZGVyJTIyJTJDJTIwdHlwZV9oaW50JTNEQXV0b01vZGVsKSUwQSUyMyUyMENyZWF0ZSUyMENvbXBvbmVudFNwZWMlMjBmb3IlMjBhJTIwZHVwbGljYXRlJTIwdGV4dCUyMGVuY29kZXIlMjAoaXQlMjBpcyUyMHNhbWUlMjBjaGVja3BvaW50JTJDJTIwZnJvbSUyMHNhbWUlMjByZXBvJTJGc3ViZm9sZGVyKSUwQXNwZWNfZHVwbGljYXRlZCUyMCUzRCUyMENvbXBvbmVudFNwZWMobmFtZSUzRCUyMnRleHRfZW5jb2Rlcl9kdXBsaWNhdGVkJTIyJTJDJTIwcmVwbyUzRCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHR5cGVfaGludCUzRENMSVBUZXh0TW9kZWwpJTBBJTBBJTIzJTIwTG9hZCUyMGFuZCUyMGFkZCUyMGJvdGglMjBjb21wb25lbnRzJTIwLSUyMHRoZSUyMG1hbmFnZXIlMjB3aWxsJTIwZGV0ZWN0JTIwdGhleSdyZSUyMHRoZSUyMHNhbWUlMjBtb2RlbCUwQWNvbXAuYWRkKCUyMnRleHRfZW5jb2RlciUyMiUyQyUyMHNwZWMubG9hZCgpKSUwQWNvbXAuYWRkKCUyMnRleHRfZW5jb2Rlcl9kdXBsaWNhdGVkJTIyJTJDJTIwc3BlY19kdXBsaWNhdGVkLmxvYWQoKSk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentSpec, ComponentsManager
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> CLIPTextModel
comp = ComponentsManager()

<span class="hljs-comment"># Create ComponentSpec for the first text encoder</span>
spec = ComponentSpec(name=<span class="hljs-string">&quot;text_encoder&quot;</span>, repo=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, type_hint=AutoModel)
<span class="hljs-comment"># Create ComponentSpec for a duplicate text encoder (it is same checkpoint, from same repo/subfolder)</span>
spec_duplicated = ComponentSpec(name=<span class="hljs-string">&quot;text_encoder_duplicated&quot;</span>, repo=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;text_encoder&quot;</span>, type_hint=CLIPTextModel)

<span class="hljs-comment"># Load and add both components - the manager will detect they&#x27;re the same model</span>
comp.add(<span class="hljs-string">&quot;text_encoder&quot;</span>, spec.load())
comp.add(<span class="hljs-string">&quot;text_encoder_duplicated&quot;</span>, spec_duplicated.load())`,wrap:!1}}),F=new b({props:{code:"Q29tcG9uZW50c01hbmFnZXIlM0ElMjBhZGRpbmclMjBjb21wb25lbnQlMjAndGV4dF9lbmNvZGVyX2R1cGxpY2F0ZWRfMTM5OTE3NTgwNjgyNjcyJyUyQyUyMGJ1dCUyMGl0JTIwaGFzJTIwZHVwbGljYXRlJTIwbG9hZF9pZCUyMCdzdGFiaWxpdHlhaSUyRnN0YWJsZS1kaWZmdXNpb24teGwtYmFzZS0xLjAlN0N0ZXh0X2VuY29kZXIlN0NudWxsJTdDbnVsbCclMjB3aXRoJTIwZXhpc3RpbmclMjBjb21wb25lbnRzJTNBJTIwdGV4dF9lbmNvZGVyXzEzOTkxODUwNjI0NjgzMi4lMjBUbyUyMHJlbW92ZSUyMGElMjBkdXBsaWNhdGUlMkMlMjBjYWxsJTIwJTYwY29tcG9uZW50c19tYW5hZ2VyLnJlbW92ZSgnJTNDY29tcG9uZW50X2lkJTNFJyklNjAuJTBBJ3RleHRfZW5jb2Rlcl9kdXBsaWNhdGVkXzEzOTkxNzU4MDY4MjY3Mic=",highlighted:'ComponentsManager: adding component <span class="hljs-string">&#x27;text_encoder_duplicated_139917580682672&#x27;</span>, but it has duplicate load_id <span class="hljs-string">&#x27;stabilityai/stable-diffusion-xl-base-1.0|text_encoder|null|null&#x27;</span> with existing components: text_encoder_139918506246832. <span class="hljs-keyword">To</span> <span class="hljs-built_in">remove</span> a duplicate, call `components_manager.<span class="hljs-built_in">remove</span>(<span class="hljs-string">&#x27;&lt;component_id&gt;&#x27;</span>)`.\n<span class="hljs-string">&#x27;text_encoder_duplicated_139917580682672&#x27;</span>',wrap:!1}}),S=new b({props:{code:"Y29tcCUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
======================================================================================================================================================================================================
Models:
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name_ID                                 | Class                     | Device: act(<span class="hljs-built_in">exec</span>)    | Dtype           | Size (GB)  | Load ID                                                         | Collection
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
text_encoder_139918506246832            | CLIPTextModel             | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | stabilityai/stable-diffusion-xl-base-<span class="hljs-number">1.0</span>|text_encoder|null|null | N/A
text_encoder_duplicated_139917580682672 | CLIPTextModel             | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | stabilityai/stable-diffusion-xl-base-<span class="hljs-number">1.0</span>|text_encoder|null|null | N/A
------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Additional Component Info:
==================================================`,wrap:!1}}),L=new f({props:{title:"Collections",local:"collections",headingTag:"h2"}}),P=new b({props:{code:"Y29tcCUyMCUzRCUyMENvbXBvbmVudHNNYW5hZ2VyKCklMEElMjMlMjBDcmVhdGUlMjBDb21wb25lbnRTcGVjJTIwZm9yJTIwdGhlJTIwZmlyc3QlMjBVTmV0JTIwKFNEWEwlMjBiYXNlKSUwQXNwZWMlMjAlM0QlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJ1bmV0JTIyJTJDJTIwcmVwbyUzRCUyMnN0YWJpbGl0eWFpJTJGc3RhYmxlLWRpZmZ1c2lvbi14bC1iYXNlLTEuMCUyMiUyQyUyMHN1YmZvbGRlciUzRCUyMnVuZXQlMjIlMkMlMjB0eXBlX2hpbnQlM0RBdXRvTW9kZWwpJTBBJTIzJTIwQ3JlYXRlJTIwQ29tcG9uZW50U3BlYyUyMGZvciUyMGElMjBkaWZmZXJlbnQlMjBVTmV0JTIwKEp1Z2dlcm5hdXQtWEwpJTBBc3BlYzIlMjAlM0QlMjBDb21wb25lbnRTcGVjKG5hbWUlM0QlMjJ1bmV0JTIyJTJDJTIwcmVwbyUzRCUyMlJ1bkRpZmZ1c2lvbiUyRkp1Z2dlcm5hdXQtWEwtdjklMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJ1bmV0JTIyJTJDJTIwdHlwZV9oaW50JTNEQXV0b01vZGVsJTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBJTBBJTIzJTIwQWRkJTIwYm90aCUyMFVOZXRzJTIwdG8lMjB0aGUlMjBzYW1lJTIwY29sbGVjdGlvbiUyMC0lMjB0aGUlMjBzZWNvbmQlMjBvbmUlMjB3aWxsJTIwcmVwbGFjZSUyMHRoZSUyMGZpcnN0JTBBY29tcC5hZGQoJTIydW5ldCUyMiUyQyUyMHNwZWMubG9hZCgpJTJDJTIwY29sbGVjdGlvbiUzRCUyMnNkeGwlMjIpJTBBY29tcC5hZGQoJTIydW5ldCUyMiUyQyUyMHNwZWMyLmxvYWQoKSUyQyUyMGNvbGxlY3Rpb24lM0QlMjJzZHhsJTIyKQ==",highlighted:`comp = ComponentsManager()
<span class="hljs-comment"># Create ComponentSpec for the first UNet (SDXL base)</span>
spec = ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>, repo=<span class="hljs-string">&quot;stabilityai/stable-diffusion-xl-base-1.0&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, type_hint=AutoModel)
<span class="hljs-comment"># Create ComponentSpec for a different UNet (Juggernaut-XL)</span>
spec2 = ComponentSpec(name=<span class="hljs-string">&quot;unet&quot;</span>, repo=<span class="hljs-string">&quot;RunDiffusion/Juggernaut-XL-v9&quot;</span>, subfolder=<span class="hljs-string">&quot;unet&quot;</span>, type_hint=AutoModel, variant=<span class="hljs-string">&quot;fp16&quot;</span>)

<span class="hljs-comment"># Add both UNets to the same collection - the second one will replace the first</span>
comp.add(<span class="hljs-string">&quot;unet&quot;</span>, spec.load(), collection=<span class="hljs-string">&quot;sdxl&quot;</span>)
comp.add(<span class="hljs-string">&quot;unet&quot;</span>, spec2.load(), collection=<span class="hljs-string">&quot;sdxl&quot;</span>)`,wrap:!1}}),O=new b({props:{code:"Q29tcG9uZW50c01hbmFnZXIlM0ElMjByZW1vdmluZyUyMGV4aXN0aW5nJTIwdW5ldCUyMGZyb20lMjBjb2xsZWN0aW9uJTIwJ3NkeGwnJTNBJTIwdW5ldF8xMzk5MTc3MjM4OTE4ODglMEEndW5ldF8xMzk5MTc3MjM4OTMxMzYn",highlighted:`<span class="hljs-symbol">ComponentsManager:</span> removing existing unet <span class="hljs-keyword">from</span> collection <span class="hljs-comment">&#x27;sdxl&#x27;: unet_139917723891888</span>
<span class="hljs-comment">&#x27;unet_139917723893136&#x27;</span>`,wrap:!1}}),te=new b({props:{code:"Y29tcCUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
====================================================================================================================================================================
Models:
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name_ID              | Class                     | Device: act(<span class="hljs-built_in">exec</span>)    | Dtype           | Size (GB)  | Load ID                                      | Collection
--------------------------------------------------------------------------------------------------------------------------------------------------------------------
unet_139917723893136 | UNet2DConditionModel      | cpu                  | torch.float32   | <span class="hljs-number">9.56</span>       | RunDiffusion/Juggernaut-XL-v9|unet|fp16|null | sdxl
--------------------------------------------------------------------------------------------------------------------------------------------------------------------

Additional Component Info:
==================================================`,wrap:!1}}),ne=new f({props:{title:"Retrieving Components",local:"retrieving-components",headingTag:"h2"}}),me=new b({props:{code:"JTIzJTIwR2V0JTIwY29tcG9uZW50cyUyMGJ5JTIwbmFtZSUyMGxpc3QlMEFjb21wb25lbnRfZGljdCUyMCUzRCUyMGNvbXAuZ2V0X2NvbXBvbmVudHNfYnlfbmFtZXMobmFtZXMlM0QlNUIlMjJ0ZXh0X2VuY29kZXIlMjIlMkMlMjAlMjJ1bmV0JTIyJTJDJTIwJTIydmFlJTIyJTVEKSUwQSUyMyUyMFJldHVybnMlM0ElMjAlN0IlMjJ0ZXh0X2VuY29kZXIlMjIlM0ElMjBjb21wb25lbnQxJTJDJTIwJTIydW5ldCUyMiUzQSUyMGNvbXBvbmVudDIlMkMlMjAlMjJ2YWUlMjIlM0ElMjBjb21wb25lbnQzJTdE",highlighted:`<span class="hljs-comment"># Get components by name list</span>
component_dict = comp.get_components_by_names(names=[<span class="hljs-string">&quot;text_encoder&quot;</span>, <span class="hljs-string">&quot;unet&quot;</span>, <span class="hljs-string">&quot;vae&quot;</span>])
<span class="hljs-comment"># Returns: {&quot;text_encoder&quot;: component1, &quot;unet&quot;: component2, &quot;vae&quot;: component3}</span>`,wrap:!1}}),ce=new f({props:{title:"Using Components Manager with Modular Pipelines",local:"using-components-manager-with-modular-pipelines",headingTag:"h2"}}),re=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyME1vZHVsYXJQaXBlbGluZSUyQyUyMENvbXBvbmVudHNNYW5hZ2VyJTBBY29tcCUyMCUzRCUyMENvbXBvbmVudHNNYW5hZ2VyKCklMEFwaXBlJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCglMjJZaVlpWHUlMkZtb2R1bGFyLWRlbW8tYXV0byUyMiUyQyUyMGNvbXBvbmVudHNfbWFuYWdlciUzRGNvbXAlMkMlMjBjb2xsZWN0aW9uJTNEJTIydGVzdDElMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ModularPipeline, ComponentsManager
comp = ComponentsManager()
pipe = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=comp, collection=<span class="hljs-string">&quot;test1&quot;</span>)`,wrap:!1}}),Me=new b({props:{code:"Y29tcA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
==================================================
No components registered.
==================================================`,wrap:!1}}),he=new b({props:{code:"cGlwZS5sb2FkX2NvbXBvbmVudHMobmFtZXMlM0QlMjJ1bmV0JTIyKSUwQWNvbXAlMEE=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_components(names=<span class="hljs-string">&quot;unet&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
==============================================================================================================================================================
Models:
--------------------------------------------------------------------------------------------------------------------------------------------------------------
Name_ID              | Class                     | Device: act(<span class="hljs-built_in">exec</span>)    | Dtype           | Size (GB)  | Load ID                                | Collection
--------------------------------------------------------------------------------------------------------------------------------------------------------------
unet_139917726686304 | UNet2DConditionModel      | cpu                  | torch.float32   | <span class="hljs-number">9.56</span>       | SG161222/RealVisXL_V4<span class="hljs-number">.0</span>|unet|null|null | test1
--------------------------------------------------------------------------------------------------------------------------------------------------------------

Additional Component Info:
==================================================`,wrap:!1}}),fe=new b({props:{code:"cGlwZS5sb2FkX2RlZmF1bHRfY29tcG9uZW50cygpJTBBJTBBcGlwZTIlMjAlM0QlMjBNb2R1bGFyUGlwZWxpbmUuZnJvbV9wcmV0cmFpbmVkKCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTJDJTIwY29tcG9uZW50c19tYW5hZ2VyJTNEY29tcCUyQyUyMGNvbGxlY3Rpb24lM0QlMjJ0ZXN0MiUyMik=",highlighted:`<span class="hljs-comment"># Load all default components </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe.load_default_components()

<span class="hljs-comment"># Create a second pipeline using the same Components Manager but with a different collection</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe2 = ModularPipeline.from_pretrained(<span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>, components_manager=comp, collection=<span class="hljs-string">&quot;test2&quot;</span>)`,wrap:!1}}),we=new b({props:{code:"cGlwZTIubnVsbF9jb21wb25lbnRfbmFtZXMlMjAlMEElMEFjb21wX2RpY3QlMjAlM0QlMjBjb21wLmdldF9jb21wb25lbnRzX2J5X25hbWVzKG5hbWVzJTNEcGlwZTIubnVsbF9jb21wb25lbnRfbmFtZXMpJTBBJTBBcGlwZTIudXBkYXRlX2NvbXBvbmVudHMoKipjb21wX2RpY3Qp",highlighted:`<span class="hljs-comment"># Get the list of components that pipe2 needs to load</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe2.null_component_names 
[<span class="hljs-string">&#x27;text_encoder&#x27;</span>, <span class="hljs-string">&#x27;text_encoder_2&#x27;</span>, <span class="hljs-string">&#x27;tokenizer&#x27;</span>, <span class="hljs-string">&#x27;tokenizer_2&#x27;</span>, <span class="hljs-string">&#x27;image_encoder&#x27;</span>, <span class="hljs-string">&#x27;unet&#x27;</span>, <span class="hljs-string">&#x27;vae&#x27;</span>, <span class="hljs-string">&#x27;scheduler&#x27;</span>, <span class="hljs-string">&#x27;controlnet&#x27;</span>]

<span class="hljs-comment"># Retrieve all required components from the Components Manager</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>comp_dict = comp.get_components_by_names(names=pipe2.null_component_names)

<span class="hljs-comment"># Update the pipeline with the retrieved components</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe2.update_components(**comp_dict)`,wrap:!1}}),Je=new b({props:{code:"Q29tcG9uZW50c01hbmFnZXIlM0ElMjBjb21wb25lbnQlMjAndGV4dF9lbmNvZGVyJyUyMGFscmVhZHklMjBleGlzdHMlMjBhcyUyMCd0ZXh0X2VuY29kZXJfMTM5OTE3NTg2MDE2NDAwJyUwQUNvbXBvbmVudHNNYW5hZ2VyJTNBJTIwY29tcG9uZW50JTIwJ3RleHRfZW5jb2Rlcl8yJyUyMGFscmVhZHklMjBleGlzdHMlMjBhcyUyMCd0ZXh0X2VuY29kZXJfMl8xMzk5MTc2OTk5NzM0MjQnJTBBQ29tcG9uZW50c01hbmFnZXIlM0ElMjBjb21wb25lbnQlMjAndG9rZW5pemVyJyUyMGFscmVhZHklMjBleGlzdHMlMjBhcyUyMCd0b2tlbml6ZXJfMTM5OTE3NTgwNTk5NTA0JyUwQUNvbXBvbmVudHNNYW5hZ2VyJTNBJTIwY29tcG9uZW50JTIwJ3Rva2VuaXplcl8yJyUyMGFscmVhZHklMjBleGlzdHMlMjBhcyUyMCd0b2tlbml6ZXJfMl8xMzk5MTU3NjM0NDM5MDQnJTBBQ29tcG9uZW50c01hbmFnZXIlM0ElMjBjb21wb25lbnQlMjAnaW1hZ2VfZW5jb2RlciclMjBhbHJlYWR5JTIwZXhpc3RzJTIwYXMlMjAnaW1hZ2VfZW5jb2Rlcl8xMzk5MTc3MjI0NjgzMDQnJTBBQ29tcG9uZW50c01hbmFnZXIlM0ElMjBjb21wb25lbnQlMjAndW5ldCclMjBhbHJlYWR5JTIwZXhpc3RzJTIwYXMlMjAndW5ldF8xMzk5MTc1ODA2MDk2MzInJTBBQ29tcG9uZW50c01hbmFnZXIlM0ElMjBjb21wb25lbnQlMjAndmFlJyUyMGFscmVhZHklMjBleGlzdHMlMjBhcyUyMCd2YWVfMTM5OTE3NzIyNDU5MDQwJyUwQUNvbXBvbmVudHNNYW5hZ2VyJTNBJTIwY29tcG9uZW50JTIwJ3NjaGVkdWxlciclMjBhbHJlYWR5JTIwZXhpc3RzJTIwYXMlMjAnc2NoZWR1bGVyXzEzOTkxNjI2NjU1OTQwOCclMEFDb21wb25lbnRzTWFuYWdlciUzQSUyMGNvbXBvbmVudCUyMCdjb250cm9sbmV0JyUyMGFscmVhZHklMjBleGlzdHMlMjBhcyUyMCdjb250cm9sbmV0XzEzOTkxNzcyMjQ1NDQzMic=",highlighted:`ComponentsManager: component <span class="hljs-string">&#x27;text_encoder&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;text_encoder_139917586016400&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;text_encoder_2&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;text_encoder_2_139917699973424&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;tokenizer&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;tokenizer_139917580599504&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;tokenizer_2&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;tokenizer_2_139915763443904&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;image_encoder&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;image_encoder_139917722468304&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;unet&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;unet_139917580609632&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;vae&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;vae_139917722459040&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;scheduler&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;scheduler_139916266559408&#x27;</span>
ComponentsManager: component <span class="hljs-string">&#x27;controlnet&#x27;</span> already<span class="hljs-built_in"> exists</span> <span class="hljs-keyword">as</span> <span class="hljs-string">&#x27;controlnet_139917722454432&#x27;</span>`,wrap:!1}}),Te=new b({props:{code:"cGlwZTIubnVsbF9jb21wb25lbnRfbmFtZXM=",highlighted:`<span class="hljs-comment"># null_component_names return empty list, meaning everything are loaded</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe2.null_component_names
[]`,wrap:!1}}),xe=new b({props:{code:"Y29tcCUwQSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>comp
Components:
========================================================================================================================================================================================
Models:
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
Name_ID                        | Class                         | Device: act(<span class="hljs-built_in">exec</span>)    | Dtype           | Size (GB)  | Load ID                                            | Collection
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
text_encoder_139917586016400   | CLIPTextModel                 | cpu                  | torch.float32   | <span class="hljs-number">0.46</span>       | SG161222/RealVisXL_V4<span class="hljs-number">.0</span>|text_encoder|null|null     | test1
                               |                               |                      |                 |            |                                                    | test2
text_encoder_2_139917699973424 | CLIPTextModelWithProjection   | cpu                  | torch.float32   | <span class="hljs-number">2.59</span>       | SG161222/RealVisXL_V4<span class="hljs-number">.0</span>|text_encoder_2|null|null   | test1
                               |                               |                      |                 |            |                                                    | test2
unet_139917580609632           | UNet2DConditionModel          | cpu                  | torch.float32   | <span class="hljs-number">9.56</span>       | SG161222/RealVisXL_V4<span class="hljs-number">.0</span>|unet|null|null             | test1
                               |                               |                      |                 |            |                                                    | test2
controlnet_139917722454432     | ControlNetModel               | cpu                  | torch.float32   | <span class="hljs-number">4.66</span>       | diffusers/controlnet-canny-sdxl-<span class="hljs-number">1.0</span>|null|null|null | test1
                               |                               |                      |                 |            |                                                    | test2
vae_139917722459040            | AutoencoderKL                 | cpu                  | torch.float32   | <span class="hljs-number">0.31</span>       | SG161222/RealVisXL_V4<span class="hljs-number">.0</span>|vae|null|null              | test1
                               |                               |                      |                 |            |                                                    | test2
image_encoder_139917722468304  | CLIPVisionModelWithProjection | cpu                  | torch.float32   | <span class="hljs-number">6.87</span>       | h94/IP-Adapter|sdxl_models/image_encoder|null|null | test1
                               |                               |                      |                 |            |                                                    | test2
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Other Components:
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
ID                             | Class                         | Collection
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
tokenizer_139917580599504      | CLIPTokenizer                 | test1
                               |                               | test2
scheduler_139916266559408      | EulerDiscreteScheduler        | test1
                               |                               | test2
tokenizer_2_139915763443904    | CLIPTokenizer                 | test1
                               |                               | test2
----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

Additional Component Info:
==================================================`,wrap:!1}}),Ue=new f({props:{title:"Automatic Memory Management",local:"automatic-memory-management",headingTag:"h2"}}),Ge=new b({props:{code:"Y29tcC5lbmFibGVfYXV0b19jcHVfb2ZmbG9hZChkZXZpY2UlM0QlMjJjdWRhJTIyKQ==",highlighted:'comp.enable_auto_cpu_offload(device=<span class="hljs-string">&quot;cuda&quot;</span>)',wrap:!1}}),We=new f({props:{title:"Practical Example: Building Modular Workflows with Component Reuse",local:"practical-example-building-modular-workflows-with-component-reuse",headingTag:"h2"}}),Ve=new b({props:{code:"aW1wb3J0JTIwdG9yY2glMEFmcm9tJTIwZGlmZnVzZXJzLm1vZHVsYXJfcGlwZWxpbmVzJTIwaW1wb3J0JTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzJTBBZnJvbSUyMGRpZmZ1c2Vycy5tb2R1bGFyX3BpcGVsaW5lcy5zdGFibGVfZGlmZnVzaW9uX3hsJTIwaW1wb3J0JTIwQUxMX0JMT0NLUyUwQSUwQSUyMyUyMENyZWF0ZSUyMG1vZHVsYXIlMjBibG9ja3MlMjBhbmQlMjBzZXBhcmF0ZSUyMHRleHQlMjBlbmNvZGluZyUyMGFuZCUyMGRlY29kaW5nJTIwc3RlcHMlMEF0MmlfYmxvY2tzJTIwJTNEJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzLmZyb21fYmxvY2tzX2RpY3QoQUxMX0JMT0NLUyU1QiUyMnRleHQyaW1nJTIyJTVEKSUwQXRleHRfYmxvY2tzJTIwJTNEJTIwdDJpX2Jsb2Nrcy5zdWJfYmxvY2tzLnBvcCglMjJ0ZXh0X2VuY29kZXIlMjIpJTBBZGVjb2Rlcl9ibG9ja3MlMjAlM0QlMjB0MmlfYmxvY2tzLnN1Yl9ibG9ja3MucG9wKCUyMmRlY29kZSUyMik=",highlighted:`<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers.modular_pipelines <span class="hljs-keyword">import</span> SequentialPipelineBlocks
<span class="hljs-keyword">from</span> diffusers.modular_pipelines.stable_diffusion_xl <span class="hljs-keyword">import</span> ALL_BLOCKS

<span class="hljs-comment"># Create modular blocks and separate text encoding and decoding steps</span>
t2i_blocks = SequentialPipelineBlocks.from_blocks_dict(ALL_BLOCKS[<span class="hljs-string">&quot;text2img&quot;</span>])
text_blocks = t2i_blocks.sub_blocks.pop(<span class="hljs-string">&quot;text_encoder&quot;</span>)
decoder_blocks = t2i_blocks.sub_blocks.pop(<span class="hljs-string">&quot;decode&quot;</span>)`,wrap:!1}}),ke=new b({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMENvbXBvbmVudHNNYW5hZ2VyJTJDJTIwTW9kdWxhclBpcGVsaW5lJTBBJTBBJTIzJTIwU2V0JTIwdXAlMjBDb21wb25lbnRzJTIwTWFuYWdlciUyMHdpdGglMjBhdXRvJTIwb2ZmbG9hZGluZyUwQWNvbXBvbmVudHMlMjAlM0QlMjBDb21wb25lbnRzTWFuYWdlcigpJTBBY29tcG9uZW50cy5lbmFibGVfYXV0b19jcHVfb2ZmbG9hZChkZXZpY2UlM0QlMjJjdWRhJTIyKSUwQSUwQSUyMyUyMENyZWF0ZSUyMGElMjBuZXclMjBwaXBlbGluZSUyMHRvJTIwbG9hZCUyMHRoZSUyMGNvbXBvbmVudHMlMEF0MmlfcmVwbyUyMCUzRCUyMCUyMllpWWlYdSUyRm1vZHVsYXItZGVtby1hdXRvJTIyJTBBdDJpX2xvYWRlcl9waXBlJTIwJTNEJTIwTW9kdWxhclBpcGVsaW5lLmZyb21fcHJldHJhaW5lZCh0MmlfcmVwbyUyQyUyMGNvbXBvbmVudHNfbWFuYWdlciUzRGNvbXBvbmVudHMlMkMlMjBjb2xsZWN0aW9uJTNEJTIydDJpJTIyKSUwQSUwQSUyMyUyMGNvbnZlcnQlMjB0aGUlMjAzJTIwYmxvY2tzJTIwaW50byUyMHBpcGVsaW5lcyUyMGFuZCUyMGF0dGFjaCUyMHRoZSUyMHNhbWUlMjBjb21wb25lbnRzJTIwbWFuYWdlciUyMHRvJTIwYWxsJTIwMyUwQXRleHRfbm9kZSUyMCUzRCUyMHRleHRfYmxvY2tzLmluaXRfcGlwZWxpbmUodDJpX3JlcG8lMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzKSUwQWRlY29kZXJfbm9kZSUyMCUzRCUyMGRlY29kZXJfYmxvY2tzLmluaXRfcGlwZWxpbmUodDJpX3JlcG8lMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzKSUwQXQyaV9waXBlJTIwJTNEJTIwdDJpX2Jsb2Nrcy5pbml0X3BpcGVsaW5lKHQyaV9yZXBvJTJDJTIwY29tcG9uZW50c19tYW5hZ2VyJTNEY29tcG9uZW50cyk=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> ComponentsManager, ModularPipeline

<span class="hljs-comment"># Set up Components Manager with auto offloading</span>
components = ComponentsManager()
components.enable_auto_cpu_offload(device=<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-comment"># Create a new pipeline to load the components</span>
t2i_repo = <span class="hljs-string">&quot;YiYiXu/modular-demo-auto&quot;</span>
t2i_loader_pipe = ModularPipeline.from_pretrained(t2i_repo, components_manager=components, collection=<span class="hljs-string">&quot;t2i&quot;</span>)

<span class="hljs-comment"># convert the 3 blocks into pipelines and attach the same components manager to all 3</span>
text_node = text_blocks.init_pipeline(t2i_repo, components_manager=components)
decoder_node = decoder_blocks.init_pipeline(t2i_repo, components_manager=components)
t2i_pipe = t2i_blocks.init_pipeline(t2i_repo, components_manager=components)`,wrap:!1}}),Ye=new b({props:{code:"JTIzJTIwTG9hZCUyMGFsbCUyMGNvbXBvbmVudHMlMjAoaW5jbHVkaW5nJTIwSVAtQWRhcHRlciUyMGFuZCUyMENvbnRyb2xOZXQlMjBmb3IlMjBsYXRlciUyMHVzZSklMEF0MmlfbG9hZGVyX3BpcGUubG9hZF9kZWZhdWx0X2NvbXBvbmVudHModG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KQ==",highlighted:`<span class="hljs-comment"># Load all components (including IP-Adapter and ControlNet for later use)</span>
t2i_loader_pipe.load_default_components(torch_dtype=torch.float16)`,wrap:!1}}),He=new b({props:{code:"JTIzJTIwR2V0JTIwVkFFJTIwZm9yJTIwZGVjb2RlciUyMCh1c2luZyUyMGdldF9vbmUlMjBzaW5jZSUyMHRoZXJlJ3MlMjBvbmx5JTIwb25lKSUwQXZhZSUyMCUzRCUyMGNvbXBvbmVudHMuZ2V0X29uZShsb2FkX2lkJTNEJTIyU0cxNjEyMjIlMkZSZWFsVmlzWExfVjQuMCU3Q3ZhZSU3Q251bGwlN0NudWxsJTIyKSUwQWRlY29kZXJfbm9kZS51cGRhdGVfY29tcG9uZW50cyh2YWUlM0R2YWUpJTBBJTBBJTIzJTIwR2V0JTIwdGV4dCUyMGNvbXBvbmVudHMlMjBmb3IlMjB0ZXh0JTIwbm9kZSUyMCh1c2luZyUyMGdldF9jb21wb25lbnRzX2J5X25hbWVzJTIwZm9yJTIwbXVsdGlwbGUlMjBjb21wb25lbnRzKSUwQXRleHRfY29tcG9uZW50cyUyMCUzRCUyMGNvbXBvbmVudHMuZ2V0X2NvbXBvbmVudHNfYnlfbmFtZXModGV4dF9ub2RlLm51bGxfY29tcG9uZW50X25hbWVzKSUwQXRleHRfbm9kZS51cGRhdGVfY29tcG9uZW50cygqKnRleHRfY29tcG9uZW50cyklMEElMEElMjMlMjBHZXQlMjByZW1haW5pbmclMjBjb21wb25lbnRzJTIwZm9yJTIwdDJpJTIwcGlwZWxpbmUlMEF0MmlfY29tcG9uZW50cyUyMCUzRCUyMGNvbXBvbmVudHMuZ2V0X2NvbXBvbmVudHNfYnlfbmFtZXModDJpX3BpcGUubnVsbF9jb21wb25lbnRfbmFtZXMpJTBBdDJpX3BpcGUudXBkYXRlX2NvbXBvbmVudHMoKip0MmlfY29tcG9uZW50cyk=",highlighted:`<span class="hljs-comment"># Get VAE for decoder (using get_one since there&#x27;s only one)</span>
vae = components.get_one(load_id=<span class="hljs-string">&quot;SG161222/RealVisXL_V4.0|vae|null|null&quot;</span>)
decoder_node.update_components(vae=vae)

<span class="hljs-comment"># Get text components for text node (using get_components_by_names for multiple components)</span>
text_components = components.get_components_by_names(text_node.null_component_names)
text_node.update_components(**text_components)

<span class="hljs-comment"># Get remaining components for t2i pipeline</span>
t2i_components = components.get_components_by_names(t2i_pipe.null_component_names)
t2i_pipe.update_components(**t2i_components)`,wrap:!1}}),qe=new b({props:{code:"JTIzJTIwR2VuZXJhdGUlMjB0ZXh0JTIwZW1iZWRkaW5ncyUwQXByb21wdCUyMCUzRCUyMCUyMmFuJTIwYXN0cm9uYXV0JTIyJTBBdGV4dF9lbWJlZGRpbmdzJTIwJTNEJTIwdGV4dF9ub2RlKHByb21wdCUzRHByb21wdCUyQyUyMG91dHB1dCUzRCU1QiUyMnByb21wdF9lbWJlZHMlMjIlMkMlMjJuZWdhdGl2ZV9wcm9tcHRfZW1iZWRzJTIyJTJDJTIwJTIycG9vbGVkX3Byb21wdF9lbWJlZHMlMjIlMkMlMjAlMjJuZWdhdGl2ZV9wb29sZWRfcHJvbXB0X2VtYmVkcyUyMiU1RCklMEElMEElMjMlMjBHZW5lcmF0ZSUyMGxhdGVudHMlMjBhbmQlMjBkZWNvZGUlMjB0byUyMGltYWdlJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKGRldmljZSUzRCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBbGF0ZW50c190MmklMjAlM0QlMjB0MmlfcGlwZSgqKnRleHRfZW1iZWRkaW5ncyUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG91dHB1dCUzRCUyMmxhdGVudHMlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZWNvZGVyX25vZGUobGF0ZW50cyUzRGxhdGVudHNfdDJpJTJDJTIwb3V0cHV0JTNEJTIyaW1hZ2VzJTIyKSU1QjAlNUQlMEFpbWFnZS5zYXZlKCUyMm1vZHVsYXJfcGFydDJfdDJpLnBuZyUyMik=",highlighted:`<span class="hljs-comment"># Generate text embeddings</span>
prompt = <span class="hljs-string">&quot;an astronaut&quot;</span>
text_embeddings = text_node(prompt=prompt, output=[<span class="hljs-string">&quot;prompt_embeds&quot;</span>,<span class="hljs-string">&quot;negative_prompt_embeds&quot;</span>, <span class="hljs-string">&quot;pooled_prompt_embeds&quot;</span>, <span class="hljs-string">&quot;negative_pooled_prompt_embeds&quot;</span>])

<span class="hljs-comment"># Generate latents and decode to image</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
latents_t2i = t2i_pipe(**text_embeddings, num_inference_steps=<span class="hljs-number">25</span>, generator=generator, output=<span class="hljs-string">&quot;latents&quot;</span>)
image = decoder_node(latents=latents_t2i, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;modular_part2_t2i.png&quot;</span>)`,wrap:!1}}),Ee=new b({props:{code:"dDJpX2xvYWRlcl9waXBlLmxvYWRfbG9yYV93ZWlnaHRzKCUyMkNpcm9OMjAyMiUyRnRveS1mYWNlJTIyJTJDJTIwd2VpZ2h0X25hbWUlM0QlMjJ0b3lfZmFjZV9zZHhsLnNhZmV0ZW5zb3JzJTIyJTJDJTIwYWRhcHRlcl9uYW1lJTNEJTIydG95X2ZhY2UlMjIpJTBBY29tcG9uZW50cyUwQQ==",highlighted:`<span class="hljs-comment"># Load LoRA weights </span>
<span class="hljs-meta">&gt;&gt;&gt; </span>t2i_loader_pipe.load_lora_weights(<span class="hljs-string">&quot;CiroN2022/toy-face&quot;</span>, weight_name=<span class="hljs-string">&quot;toy_face_sdxl.safetensors&quot;</span>, adapter_name=<span class="hljs-string">&quot;toy_face&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>components
Components:
============================================================================================================================================================
...
Additional Component Info:
==================================================

unet:
  Adapters: [<span class="hljs-string">&#x27;toy_face&#x27;</span>]`,wrap:!1}}),Le=new b({props:{code:"JTIzJTIwR2VuZXJhdGUlMjB3aXRoJTIwTG9SQSUyMChyZXVzaW5nJTIwZXhpc3RpbmclMjB0ZXh0JTIwZW1iZWRkaW5ncyklMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoZGV2aWNlJTNEJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEFsYXRlbnRzX2xvcmElMjAlM0QlMjB0MmlfcGlwZSgqKnRleHRfZW1iZWRkaW5ncyUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyNSUyQyUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUyMG91dHB1dCUzRCUyMmxhdGVudHMlMjIpJTBBaW1hZ2UlMjAlM0QlMjBkZWNvZGVyX25vZGUobGF0ZW50cyUzRGxhdGVudHNfbG9yYSUyQyUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiklNUIwJTVEJTBBaW1hZ2Uuc2F2ZSglMjJtb2R1bGFyX3BhcnQyX2xvcmEucG5nJTIyKQ==",highlighted:`<span class="hljs-comment"># Generate with LoRA (reusing existing text embeddings)</span>
generator = torch.Generator(device=<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)
latents_lora = t2i_pipe(**text_embeddings, num_inference_steps=<span class="hljs-number">25</span>, generator=generator, output=<span class="hljs-string">&quot;latents&quot;</span>)
image = decoder_node(latents=latents_lora, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
image.save(<span class="hljs-string">&quot;modular_part2_lora.png&quot;</span>)`,wrap:!1}}),Ae=new b({props:{code:"JTIzJTIwQ3JlYXRlJTIwcmVmaW5lciUyMGJsb2NrcyUyMChyZW1vdmluZyUyMGltYWdlX2VuY29kZXIlMjBhbmQlMjBkZWNvZGUlMjBzaW5jZSUyMHdlJTIwd29yayUyMHdpdGglMjBsYXRlbnRzKSUwQXJlZmluZXJfYmxvY2tzJTIwJTNEJTIwU2VxdWVudGlhbFBpcGVsaW5lQmxvY2tzLmZyb21fYmxvY2tzX2RpY3QoQUxMX0JMT0NLUyU1QiUyMmltZzJpbWclMjIlNUQpJTBBcmVmaW5lcl9ibG9ja3Muc3ViX2Jsb2Nrcy5wb3AoJTIyaW1hZ2VfZW5jb2RlciUyMiklMEFyZWZpbmVyX2Jsb2Nrcy5zdWJfYmxvY2tzLnBvcCglMjJkZWNvZGUlMjIpJTBBJTBBJTIzJTIwQ3JlYXRlJTIwcmVmaW5lciUyMHBpcGVsaW5lJTIwd2l0aCUyMGRpZmZlcmVudCUyMHJlcG8lMjBhbmQlMjBjb2xsZWN0aW9uJTJDJTBBJTIzJTIwQXR0YWNoJTIwdGhlJTIwc2FtZSUyMGNvbXBvbmVudCUyMG1hbmFnZXIlMjB0byUyMGl0JTBBcmVmaW5lcl9yZXBvJTIwJTNEJTIwJTIyWWlZaVh1JTJGbW9kdWxhcl9yZWZpbmVyJTIyJTBBcmVmaW5lcl9waXBlJTIwJTNEJTIwcmVmaW5lcl9ibG9ja3MuaW5pdF9waXBlbGluZShyZWZpbmVyX3JlcG8lMkMlMjBjb21wb25lbnRzX21hbmFnZXIlM0Rjb21wb25lbnRzJTJDJTIwY29sbGVjdGlvbiUzRCUyMnJlZmluZXIlMjIp",highlighted:`<span class="hljs-comment"># Create refiner blocks (removing image_encoder and decode since we work with latents)</span>
refiner_blocks = SequentialPipelineBlocks.from_blocks_dict(ALL_BLOCKS[<span class="hljs-string">&quot;img2img&quot;</span>])
refiner_blocks.sub_blocks.pop(<span class="hljs-string">&quot;image_encoder&quot;</span>)
refiner_blocks.sub_blocks.pop(<span class="hljs-string">&quot;decode&quot;</span>)

<span class="hljs-comment"># Create refiner pipeline with different repo and collection,</span>
<span class="hljs-comment"># Attach the same component manager to it</span>
refiner_repo = <span class="hljs-string">&quot;YiYiXu/modular_refiner&quot;</span>
refiner_pipe = refiner_blocks.init_pipeline(refiner_repo, components_manager=components, collection=<span class="hljs-string">&quot;refiner&quot;</span>)`,wrap:!1}}),Ke=new b({props:{code:"JTIzJTIwTG9hZCUyMG9ubHklMjB0aGUlMjByZWZpbmVyJTIwVU5ldCUyMChkaWZmZXJlbnQlMjBmcm9tJTIwdDJpJTIwVU5ldCklMEFyZWZpbmVyX3BpcGUubG9hZF9jb21wb25lbnRzKG5hbWVzJTNEJTIydW5ldCUyMiUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEElMEElMjMlMjBSZXVzZSUyMGNvbXBvbmVudHMlMjBmcm9tJTIwdDJpJTIwcGlwZWxpbmUlMjB1c2luZyUyMHBhdHRlcm4lMjBtYXRjaGluZyUwQXJldXNlX2NvbXBvbmVudHMlMjAlM0QlMjBjb21wb25lbnRzLnNlYXJjaF9jb21wb25lbnRzKCUyMnRleHRfZW5jb2Rlcl8yJTdDc2NoZWR1bGVyJTdDdmFlJTdDdG9rZW5pemVyXzIlMjIpJTBBcmVmaW5lcl9waXBlLnVwZGF0ZV9jb21wb25lbnRzKCoqcmV1c2VfY29tcG9uZW50cyk=",highlighted:`<span class="hljs-comment"># Load only the refiner UNet (different from t2i UNet)</span>
refiner_pipe.load_components(names=<span class="hljs-string">&quot;unet&quot;</span>, torch_dtype=torch.float16)

<span class="hljs-comment"># Reuse components from t2i pipeline using pattern matching</span>
reuse_components = components.search_components(<span class="hljs-string">&quot;text_encoder_2|scheduler|vae|tokenizer_2&quot;</span>)
refiner_pipe.update_components(**reuse_components)`,wrap:!1}}),tt=new b({props:{code:"JTIzJTIwUmVmaW5lJTIwYWxsJTIwb3VyJTIwZGlmZmVyZW50JTIwbGF0ZW50cyUwQXJlZmluZWRfbGF0ZW50cyUyMCUzRCUyMHJlZmluZXJfcGlwZShpbWFnZV9sYXRlbnRzJTNEbGF0ZW50c190MmklMkMlMjBwcm9tcHQlM0Rwcm9tcHQlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMTAlMkMlMjBvdXRwdXQlM0QlMjJsYXRlbnRzJTIyKSUwQXJlZmluZWRfaW1hZ2UlMjAlM0QlMjBkZWNvZGVyX25vZGUobGF0ZW50cyUzRHJlZmluZWRfbGF0ZW50cyUyQyUyMG91dHB1dCUzRCUyMmltYWdlcyUyMiklNUIwJTVEJTBBcmVmaW5lZF9pbWFnZS5zYXZlKCUyMm1vZHVsYXJfcGFydDJfdDJpX3JlZmluZV9vdXQucG5nJTIyKSUwQSUwQXJlZmluZWRfbGF0ZW50cyUyMCUzRCUyMHJlZmluZXJfcGlwZShpbWFnZV9sYXRlbnRzJTNEbGF0ZW50c19sb3JhJTJDJTIwcHJvbXB0JTNEcHJvbXB0JTJDJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRDEwJTJDJTIwb3V0cHV0JTNEJTIybGF0ZW50cyUyMiklMEFyZWZpbmVkX2ltYWdlJTIwJTNEJTIwZGVjb2Rlcl9ub2RlKGxhdGVudHMlM0RyZWZpbmVkX2xhdGVudHMlMkMlMjBvdXRwdXQlM0QlMjJpbWFnZXMlMjIpJTVCMCU1RCUwQXJlZmluZWRfaW1hZ2Uuc2F2ZSglMjJtb2R1bGFyX3BhcnQyX2xvcmFfcmVmaW5lX291dC5wbmclMjIp",highlighted:`<span class="hljs-comment"># Refine all our different latents</span>
refined_latents = refiner_pipe(image_latents=latents_t2i, prompt=prompt, num_inference_steps=<span class="hljs-number">10</span>, output=<span class="hljs-string">&quot;latents&quot;</span>)
refined_image = decoder_node(latents=refined_latents, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
refined_image.save(<span class="hljs-string">&quot;modular_part2_t2i_refine_out.png&quot;</span>)

refined_latents = refiner_pipe(image_latents=latents_lora, prompt=prompt, num_inference_steps=<span class="hljs-number">10</span>, output=<span class="hljs-string">&quot;latents&quot;</span>)
refined_image = decoder_node(latents=refined_latents, output=<span class="hljs-string">&quot;images&quot;</span>)[<span class="hljs-number">0</span>]
refined_image.save(<span class="hljs-string">&quot;modular_part2_lora_refine_out.png&quot;</span>)`,wrap:!1}}),nt=new f({props:{title:"Base Text-to-Image Generation",local:"base-text-to-image-generation",headingTag:"h4"}}),at=new f({props:{title:"LoRA",local:"lora",headingTag:"h4"}}),pt=new is({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/modular_diffusers/components_manager.md"}}),{c(){h=o("meta"),w=s(),y=o("p"),it=s(),m(g.$$.fragment),dt=s(),m(j.$$.fragment),rt=s(),J=o("p"),J.innerHTML=en,ut=s(),m(Z.$$.fragment),Mt=s(),T=o("p"),T.textContent=tn,bt=s(),m(_.$$.fragment),ht=s(),x=o("p"),x.innerHTML=ln,yt=s(),m(U.$$.fragment),ft=s(),C=o("p"),C.textContent=nn,jt=s(),m(G.$$.fragment),wt=s(),v=o("p"),v.textContent=sn,gt=s(),m(W.$$.fragment),Jt=s(),m($.$$.fragment),Zt=s(),B=o("p"),B.textContent=an,Tt=s(),I=o("p"),I.textContent=on,_t=s(),m(V.$$.fragment),xt=s(),X=o("p"),X.textContent=pn,Ut=s(),m(R.$$.fragment),Ct=s(),k=o("p"),k.innerHTML=mn,Gt=s(),m(N.$$.fragment),vt=s(),Y=o("p"),Y.textContent=cn,Wt=s(),m(z.$$.fragment),$t=s(),H=o("p"),H.innerHTML=dn,Bt=s(),m(Q.$$.fragment),It=s(),q=o("p"),q.textContent=rn,Vt=s(),m(F.$$.fragment),Xt=s(),E=o("p"),E.innerHTML=un,Rt=s(),m(S.$$.fragment),kt=s(),m(L.$$.fragment),Nt=s(),D=o("p"),D.innerHTML=Mn,Yt=s(),A=o("p"),A.textContent=bn,zt=s(),m(P.$$.fragment),Ht=s(),K=o("p"),K.textContent=hn,Qt=s(),m(O.$$.fragment),qt=s(),ee=o("p"),ee.textContent=yn,Ft=s(),m(te.$$.fragment),Et=s(),le=o("p"),le.textContent=fn,St=s(),m(ne.$$.fragment),Lt=s(),se=o("p"),se.textContent=jn,Dt=s(),ae=o("p"),ae.innerHTML=wn,At=s(),oe=o("ul"),oe.innerHTML=gn,Pt=s(),pe=o("p"),pe.innerHTML=Jn,Kt=s(),ie=o("p"),ie.innerHTML=Zn,Ot=s(),m(me.$$.fragment),el=s(),m(ce.$$.fragment),tl=s(),de=o("p"),de.innerHTML=Tn,ll=s(),m(re.$$.fragment),nl=s(),ue=o("p"),ue.textContent=_n,sl=s(),m(Me.$$.fragment),al=s(),be=o("p"),be.textContent=xn,ol=s(),m(he.$$.fragment),pl=s(),ye=o("p"),ye.textContent=Un,il=s(),m(fe.$$.fragment),ml=s(),je=o("p"),je.innerHTML=Cn,cl=s(),m(we.$$.fragment),dl=s(),ge=o("p"),ge.textContent=Gn,rl=s(),m(Je.$$.fragment),ul=s(),Ze=o("p"),Ze.textContent=vn,Ml=s(),m(Te.$$.fragment),bl=s(),_e=o("p"),_e.innerHTML=Wn,hl=s(),m(xe.$$.fragment),yl=s(),m(Ue.$$.fragment),fl=s(),Ce=o("p"),Ce.textContent=$n,jl=s(),m(Ge.$$.fragment),wl=s(),ve=o("p"),ve.textContent=Bn,gl=s(),m(We.$$.fragment),Jl=s(),$e=o("p"),$e.textContent=In,Zl=s(),Be=o("p"),Be.textContent=Vn,Tl=s(),Ie=o("p"),Ie.innerHTML=Xn,_l=s(),m(Ve.$$.fragment),xl=s(),Xe=o("p"),Xe.textContent=Rn,Ul=s(),Re=o("p"),Re.textContent=kn,Cl=s(),m(ke.$$.fragment),Gl=s(),Ne=o("p"),Ne.textContent=Nn,vl=s(),m(Ye.$$.fragment),Wl=s(),ze=o("p"),ze.textContent=Yn,$l=s(),m(He.$$.fragment),Bl=s(),Qe=o("p"),Qe.textContent=zn,Il=s(),m(qe.$$.fragment),Vl=s(),Fe=o("p"),Fe.textContent=Hn,Xl=s(),m(Ee.$$.fragment),Rl=s(),Se=o("p"),Se.textContent=Qn,kl=s(),m(Le.$$.fragment),Nl=s(),De=o("p"),De.textContent=qn,Yl=s(),m(Ae.$$.fragment),zl=s(),Pe=o("p"),Pe.innerHTML=Fn,Hl=s(),m(Ke.$$.fragment),Ql=s(),Oe=o("p"),Oe.innerHTML=En,ql=s(),et=o("p"),et.textContent=Sn,Fl=s(),m(tt.$$.fragment),El=s(),lt=o("p"),lt.textContent=Ln,Sl=s(),m(nt.$$.fragment),Ll=s(),st=o("table"),st.innerHTML=Dn,Dl=s(),m(at.$$.fragment),Al=s(),ot=o("table"),ot.innerHTML=An,Pl=s(),m(pt.$$.fragment),Kl=s(),mt=o("p"),this.h()},l(e){const t=as("svelte-u9bgzb",document.head);h=p(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),y=p(e,"P",{}),Kn(y).forEach(l),it=a(e),c(g.$$.fragment,e),dt=a(e),c(j.$$.fragment,e),rt=a(e),J=p(e,"P",{"data-svelte-h":!0}),i(J)!=="svelte-1w209h4"&&(J.innerHTML=en),ut=a(e),c(Z.$$.fragment,e),Mt=a(e),T=p(e,"P",{"data-svelte-h":!0}),i(T)!=="svelte-1jd1wvz"&&(T.textContent=tn),bt=a(e),c(_.$$.fragment,e),ht=a(e),x=p(e,"P",{"data-svelte-h":!0}),i(x)!=="svelte-11yvvp9"&&(x.innerHTML=ln),yt=a(e),c(U.$$.fragment,e),ft=a(e),C=p(e,"P",{"data-svelte-h":!0}),i(C)!=="svelte-5b3kbr"&&(C.textContent=nn),jt=a(e),c(G.$$.fragment,e),wt=a(e),v=p(e,"P",{"data-svelte-h":!0}),i(v)!=="svelte-hpt7hf"&&(v.textContent=sn),gt=a(e),c(W.$$.fragment,e),Jt=a(e),c($.$$.fragment,e),Zt=a(e),B=p(e,"P",{"data-svelte-h":!0}),i(B)!=="svelte-zjrc8z"&&(B.textContent=an),Tt=a(e),I=p(e,"P",{"data-svelte-h":!0}),i(I)!=="svelte-x2x0fp"&&(I.textContent=on),_t=a(e),c(V.$$.fragment,e),xt=a(e),X=p(e,"P",{"data-svelte-h":!0}),i(X)!=="svelte-1fdibg"&&(X.textContent=pn),Ut=a(e),c(R.$$.fragment,e),Ct=a(e),k=p(e,"P",{"data-svelte-h":!0}),i(k)!=="svelte-xjmzxa"&&(k.innerHTML=mn),Gt=a(e),c(N.$$.fragment,e),vt=a(e),Y=p(e,"P",{"data-svelte-h":!0}),i(Y)!=="svelte-x1j705"&&(Y.textContent=cn),Wt=a(e),c(z.$$.fragment,e),$t=a(e),H=p(e,"P",{"data-svelte-h":!0}),i(H)!=="svelte-12ddzhy"&&(H.innerHTML=dn),Bt=a(e),c(Q.$$.fragment,e),It=a(e),q=p(e,"P",{"data-svelte-h":!0}),i(q)!=="svelte-ai97qv"&&(q.textContent=rn),Vt=a(e),c(F.$$.fragment,e),Xt=a(e),E=p(e,"P",{"data-svelte-h":!0}),i(E)!=="svelte-19e2m6t"&&(E.innerHTML=un),Rt=a(e),c(S.$$.fragment,e),kt=a(e),c(L.$$.fragment,e),Nt=a(e),D=p(e,"P",{"data-svelte-h":!0}),i(D)!=="svelte-ou2ao8"&&(D.innerHTML=Mn),Yt=a(e),A=p(e,"P",{"data-svelte-h":!0}),i(A)!=="svelte-1iqgs84"&&(A.textContent=bn),zt=a(e),c(P.$$.fragment,e),Ht=a(e),K=p(e,"P",{"data-svelte-h":!0}),i(K)!=="svelte-1stmhlk"&&(K.textContent=hn),Qt=a(e),c(O.$$.fragment,e),qt=a(e),ee=p(e,"P",{"data-svelte-h":!0}),i(ee)!=="svelte-dmlykf"&&(ee.textContent=yn),Ft=a(e),c(te.$$.fragment,e),Et=a(e),le=p(e,"P",{"data-svelte-h":!0}),i(le)!=="svelte-m4cg8p"&&(le.textContent=fn),St=a(e),c(ne.$$.fragment,e),Lt=a(e),se=p(e,"P",{"data-svelte-h":!0}),i(se)!=="svelte-1004hs3"&&(se.textContent=jn),Dt=a(e),ae=p(e,"P",{"data-svelte-h":!0}),i(ae)!=="svelte-1jdz6wh"&&(ae.innerHTML=wn),At=a(e),oe=p(e,"UL",{"data-svelte-h":!0}),i(oe)!=="svelte-12ybnqe"&&(oe.innerHTML=gn),Pt=a(e),pe=p(e,"P",{"data-svelte-h":!0}),i(pe)!=="svelte-xsqm04"&&(pe.innerHTML=Jn),Kt=a(e),ie=p(e,"P",{"data-svelte-h":!0}),i(ie)!=="svelte-147rt0c"&&(ie.innerHTML=Zn),Ot=a(e),c(me.$$.fragment,e),el=a(e),c(ce.$$.fragment,e),tl=a(e),de=p(e,"P",{"data-svelte-h":!0}),i(de)!=="svelte-100blqs"&&(de.innerHTML=Tn),ll=a(e),c(re.$$.fragment,e),nl=a(e),ue=p(e,"P",{"data-svelte-h":!0}),i(ue)!=="svelte-1r9a5l6"&&(ue.textContent=_n),sl=a(e),c(Me.$$.fragment,e),al=a(e),be=p(e,"P",{"data-svelte-h":!0}),i(be)!=="svelte-1c1n8d7"&&(be.textContent=xn),ol=a(e),c(he.$$.fragment,e),pl=a(e),ye=p(e,"P",{"data-svelte-h":!0}),i(ye)!=="svelte-plz8fi"&&(ye.textContent=Un),il=a(e),c(fe.$$.fragment,e),ml=a(e),je=p(e,"P",{"data-svelte-h":!0}),i(je)!=="svelte-1hkf10a"&&(je.innerHTML=Cn),cl=a(e),c(we.$$.fragment,e),dl=a(e),ge=p(e,"P",{"data-svelte-h":!0}),i(ge)!=="svelte-1s0kisf"&&(ge.textContent=Gn),rl=a(e),c(Je.$$.fragment,e),ul=a(e),Ze=p(e,"P",{"data-svelte-h":!0}),i(Ze)!=="svelte-1hje7f8"&&(Ze.textContent=vn),Ml=a(e),c(Te.$$.fragment,e),bl=a(e),_e=p(e,"P",{"data-svelte-h":!0}),i(_e)!=="svelte-1fm9inz"&&(_e.innerHTML=Wn),hl=a(e),c(xe.$$.fragment,e),yl=a(e),c(Ue.$$.fragment,e),fl=a(e),Ce=p(e,"P",{"data-svelte-h":!0}),i(Ce)!=="svelte-tj9te6"&&(Ce.textContent=$n),jl=a(e),c(Ge.$$.fragment,e),wl=a(e),ve=p(e,"P",{"data-svelte-h":!0}),i(ve)!=="svelte-10kvsgb"&&(ve.textContent=Bn),gl=a(e),c(We.$$.fragment,e),Jl=a(e),$e=p(e,"P",{"data-svelte-h":!0}),i($e)!=="svelte-1ai6bmw"&&($e.textContent=In),Zl=a(e),Be=p(e,"P",{"data-svelte-h":!0}),i(Be)!=="svelte-1ihez8m"&&(Be.textContent=Vn),Tl=a(e),Ie=p(e,"P",{"data-svelte-h":!0}),i(Ie)!=="svelte-1ktoiwm"&&(Ie.innerHTML=Xn),_l=a(e),c(Ve.$$.fragment,e),xl=a(e),Xe=p(e,"P",{"data-svelte-h":!0}),i(Xe)!=="svelte-x1zvdc"&&(Xe.textContent=Rn),Ul=a(e),Re=p(e,"P",{"data-svelte-h":!0}),i(Re)!=="svelte-hnydim"&&(Re.textContent=kn),Cl=a(e),c(ke.$$.fragment,e),Gl=a(e),Ne=p(e,"P",{"data-svelte-h":!0}),i(Ne)!=="svelte-lrhgu2"&&(Ne.textContent=Nn),vl=a(e),c(Ye.$$.fragment,e),Wl=a(e),ze=p(e,"P",{"data-svelte-h":!0}),i(ze)!=="svelte-1yc206b"&&(ze.textContent=Yn),$l=a(e),c(He.$$.fragment,e),Bl=a(e),Qe=p(e,"P",{"data-svelte-h":!0}),i(Qe)!=="svelte-9f8rck"&&(Qe.textContent=zn),Il=a(e),c(qe.$$.fragment,e),Vl=a(e),Fe=p(e,"P",{"data-svelte-h":!0}),i(Fe)!=="svelte-1hml0o7"&&(Fe.textContent=Hn),Xl=a(e),c(Ee.$$.fragment,e),Rl=a(e),Se=p(e,"P",{"data-svelte-h":!0}),i(Se)!=="svelte-1rm09xq"&&(Se.textContent=Qn),kl=a(e),c(Le.$$.fragment,e),Nl=a(e),De=p(e,"P",{"data-svelte-h":!0}),i(De)!=="svelte-7t7tuj"&&(De.textContent=qn),Yl=a(e),c(Ae.$$.fragment,e),zl=a(e),Pe=p(e,"P",{"data-svelte-h":!0}),i(Pe)!=="svelte-1af9qgx"&&(Pe.innerHTML=Fn),Hl=a(e),c(Ke.$$.fragment,e),Ql=a(e),Oe=p(e,"P",{"data-svelte-h":!0}),i(Oe)!=="svelte-1a2xck9"&&(Oe.innerHTML=En),ql=a(e),et=p(e,"P",{"data-svelte-h":!0}),i(et)!=="svelte-znyiac"&&(et.textContent=Sn),Fl=a(e),c(tt.$$.fragment,e),El=a(e),lt=p(e,"P",{"data-svelte-h":!0}),i(lt)!=="svelte-19x7rhc"&&(lt.textContent=Ln),Sl=a(e),c(nt.$$.fragment,e),Ll=a(e),st=p(e,"TABLE",{"data-svelte-h":!0}),i(st)!=="svelte-1g0nloy"&&(st.innerHTML=Dn),Dl=a(e),c(at.$$.fragment,e),Al=a(e),ot=p(e,"TABLE",{"data-svelte-h":!0}),i(ot)!=="svelte-tl7ulg"&&(ot.innerHTML=An),Pl=a(e),c(pt.$$.fragment,e),Kl=a(e),mt=p(e,"P",{}),Kn(mt).forEach(l),this.h()},h(){On(h,"name","hf:doc:metadata"),On(h,"content",ds)},m(e,t){os(document.head,h),n(e,w,t),n(e,y,t),n(e,it,t),d(g,e,t),n(e,dt,t),d(j,e,t),n(e,rt,t),n(e,J,t),n(e,ut,t),d(Z,e,t),n(e,Mt,t),n(e,T,t),n(e,bt,t),d(_,e,t),n(e,ht,t),n(e,x,t),n(e,yt,t),d(U,e,t),n(e,ft,t),n(e,C,t),n(e,jt,t),d(G,e,t),n(e,wt,t),n(e,v,t),n(e,gt,t),d(W,e,t),n(e,Jt,t),d($,e,t),n(e,Zt,t),n(e,B,t),n(e,Tt,t),n(e,I,t),n(e,_t,t),d(V,e,t),n(e,xt,t),n(e,X,t),n(e,Ut,t),d(R,e,t),n(e,Ct,t),n(e,k,t),n(e,Gt,t),d(N,e,t),n(e,vt,t),n(e,Y,t),n(e,Wt,t),d(z,e,t),n(e,$t,t),n(e,H,t),n(e,Bt,t),d(Q,e,t),n(e,It,t),n(e,q,t),n(e,Vt,t),d(F,e,t),n(e,Xt,t),n(e,E,t),n(e,Rt,t),d(S,e,t),n(e,kt,t),d(L,e,t),n(e,Nt,t),n(e,D,t),n(e,Yt,t),n(e,A,t),n(e,zt,t),d(P,e,t),n(e,Ht,t),n(e,K,t),n(e,Qt,t),d(O,e,t),n(e,qt,t),n(e,ee,t),n(e,Ft,t),d(te,e,t),n(e,Et,t),n(e,le,t),n(e,St,t),d(ne,e,t),n(e,Lt,t),n(e,se,t),n(e,Dt,t),n(e,ae,t),n(e,At,t),n(e,oe,t),n(e,Pt,t),n(e,pe,t),n(e,Kt,t),n(e,ie,t),n(e,Ot,t),d(me,e,t),n(e,el,t),d(ce,e,t),n(e,tl,t),n(e,de,t),n(e,ll,t),d(re,e,t),n(e,nl,t),n(e,ue,t),n(e,sl,t),d(Me,e,t),n(e,al,t),n(e,be,t),n(e,ol,t),d(he,e,t),n(e,pl,t),n(e,ye,t),n(e,il,t),d(fe,e,t),n(e,ml,t),n(e,je,t),n(e,cl,t),d(we,e,t),n(e,dl,t),n(e,ge,t),n(e,rl,t),d(Je,e,t),n(e,ul,t),n(e,Ze,t),n(e,Ml,t),d(Te,e,t),n(e,bl,t),n(e,_e,t),n(e,hl,t),d(xe,e,t),n(e,yl,t),d(Ue,e,t),n(e,fl,t),n(e,Ce,t),n(e,jl,t),d(Ge,e,t),n(e,wl,t),n(e,ve,t),n(e,gl,t),d(We,e,t),n(e,Jl,t),n(e,$e,t),n(e,Zl,t),n(e,Be,t),n(e,Tl,t),n(e,Ie,t),n(e,_l,t),d(Ve,e,t),n(e,xl,t),n(e,Xe,t),n(e,Ul,t),n(e,Re,t),n(e,Cl,t),d(ke,e,t),n(e,Gl,t),n(e,Ne,t),n(e,vl,t),d(Ye,e,t),n(e,Wl,t),n(e,ze,t),n(e,$l,t),d(He,e,t),n(e,Bl,t),n(e,Qe,t),n(e,Il,t),d(qe,e,t),n(e,Vl,t),n(e,Fe,t),n(e,Xl,t),d(Ee,e,t),n(e,Rl,t),n(e,Se,t),n(e,kl,t),d(Le,e,t),n(e,Nl,t),n(e,De,t),n(e,Yl,t),d(Ae,e,t),n(e,zl,t),n(e,Pe,t),n(e,Hl,t),d(Ke,e,t),n(e,Ql,t),n(e,Oe,t),n(e,ql,t),n(e,et,t),n(e,Fl,t),d(tt,e,t),n(e,El,t),n(e,lt,t),n(e,Sl,t),d(nt,e,t),n(e,Ll,t),n(e,st,t),n(e,Dl,t),d(at,e,t),n(e,Al,t),n(e,ot,t),n(e,Pl,t),d(pt,e,t),n(e,Kl,t),n(e,mt,t),Ol=!0},p(e,[t]){const Pn={};t&2&&(Pn.$$scope={dirty:t,ctx:e}),j.$set(Pn)},i(e){Ol||(r(g.$$.fragment,e),r(j.$$.fragment,e),r(Z.$$.fragment,e),r(_.$$.fragment,e),r(U.$$.fragment,e),r(G.$$.fragment,e),r(W.$$.fragment,e),r($.$$.fragment,e),r(V.$$.fragment,e),r(R.$$.fragment,e),r(N.$$.fragment,e),r(z.$$.fragment,e),r(Q.$$.fragment,e),r(F.$$.fragment,e),r(S.$$.fragment,e),r(L.$$.fragment,e),r(P.$$.fragment,e),r(O.$$.fragment,e),r(te.$$.fragment,e),r(ne.$$.fragment,e),r(me.$$.fragment,e),r(ce.$$.fragment,e),r(re.$$.fragment,e),r(Me.$$.fragment,e),r(he.$$.fragment,e),r(fe.$$.fragment,e),r(we.$$.fragment,e),r(Je.$$.fragment,e),r(Te.$$.fragment,e),r(xe.$$.fragment,e),r(Ue.$$.fragment,e),r(Ge.$$.fragment,e),r(We.$$.fragment,e),r(Ve.$$.fragment,e),r(ke.$$.fragment,e),r(Ye.$$.fragment,e),r(He.$$.fragment,e),r(qe.$$.fragment,e),r(Ee.$$.fragment,e),r(Le.$$.fragment,e),r(Ae.$$.fragment,e),r(Ke.$$.fragment,e),r(tt.$$.fragment,e),r(nt.$$.fragment,e),r(at.$$.fragment,e),r(pt.$$.fragment,e),Ol=!0)},o(e){u(g.$$.fragment,e),u(j.$$.fragment,e),u(Z.$$.fragment,e),u(_.$$.fragment,e),u(U.$$.fragment,e),u(G.$$.fragment,e),u(W.$$.fragment,e),u($.$$.fragment,e),u(V.$$.fragment,e),u(R.$$.fragment,e),u(N.$$.fragment,e),u(z.$$.fragment,e),u(Q.$$.fragment,e),u(F.$$.fragment,e),u(S.$$.fragment,e),u(L.$$.fragment,e),u(P.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ne.$$.fragment,e),u(me.$$.fragment,e),u(ce.$$.fragment,e),u(re.$$.fragment,e),u(Me.$$.fragment,e),u(he.$$.fragment,e),u(fe.$$.fragment,e),u(we.$$.fragment,e),u(Je.$$.fragment,e),u(Te.$$.fragment,e),u(xe.$$.fragment,e),u(Ue.$$.fragment,e),u(Ge.$$.fragment,e),u(We.$$.fragment,e),u(Ve.$$.fragment,e),u(ke.$$.fragment,e),u(Ye.$$.fragment,e),u(He.$$.fragment,e),u(qe.$$.fragment,e),u(Ee.$$.fragment,e),u(Le.$$.fragment,e),u(Ae.$$.fragment,e),u(Ke.$$.fragment,e),u(tt.$$.fragment,e),u(nt.$$.fragment,e),u(at.$$.fragment,e),u(pt.$$.fragment,e),Ol=!1},d(e){e&&(l(w),l(y),l(it),l(dt),l(rt),l(J),l(ut),l(Mt),l(T),l(bt),l(ht),l(x),l(yt),l(ft),l(C),l(jt),l(wt),l(v),l(gt),l(Jt),l(Zt),l(B),l(Tt),l(I),l(_t),l(xt),l(X),l(Ut),l(Ct),l(k),l(Gt),l(vt),l(Y),l(Wt),l($t),l(H),l(Bt),l(It),l(q),l(Vt),l(Xt),l(E),l(Rt),l(kt),l(Nt),l(D),l(Yt),l(A),l(zt),l(Ht),l(K),l(Qt),l(qt),l(ee),l(Ft),l(Et),l(le),l(St),l(Lt),l(se),l(Dt),l(ae),l(At),l(oe),l(Pt),l(pe),l(Kt),l(ie),l(Ot),l(el),l(tl),l(de),l(ll),l(nl),l(ue),l(sl),l(al),l(be),l(ol),l(pl),l(ye),l(il),l(ml),l(je),l(cl),l(dl),l(ge),l(rl),l(ul),l(Ze),l(Ml),l(bl),l(_e),l(hl),l(yl),l(fl),l(Ce),l(jl),l(wl),l(ve),l(gl),l(Jl),l($e),l(Zl),l(Be),l(Tl),l(Ie),l(_l),l(xl),l(Xe),l(Ul),l(Re),l(Cl),l(Gl),l(Ne),l(vl),l(Wl),l(ze),l($l),l(Bl),l(Qe),l(Il),l(Vl),l(Fe),l(Xl),l(Rl),l(Se),l(kl),l(Nl),l(De),l(Yl),l(zl),l(Pe),l(Hl),l(Ql),l(Oe),l(ql),l(et),l(Fl),l(El),l(lt),l(Sl),l(Ll),l(st),l(Dl),l(Al),l(ot),l(Pl),l(Kl),l(mt)),l(h),M(g,e),M(j,e),M(Z,e),M(_,e),M(U,e),M(G,e),M(W,e),M($,e),M(V,e),M(R,e),M(N,e),M(z,e),M(Q,e),M(F,e),M(S,e),M(L,e),M(P,e),M(O,e),M(te,e),M(ne,e),M(me,e),M(ce,e),M(re,e),M(Me,e),M(he,e),M(fe,e),M(we,e),M(Je,e),M(Te,e),M(xe,e),M(Ue,e),M(Ge,e),M(We,e),M(Ve,e),M(ke,e),M(Ye,e),M(He,e),M(qe,e),M(Ee,e),M(Le,e),M(Ae,e),M(Ke,e),M(tt,e),M(nt,e),M(at,e),M(pt,e)}}}const ds='{"title":"Components Manager","local":"components-manager","sections":[{"title":"Basic Operations","local":"basic-operations","sections":[],"depth":2},{"title":"Duplicate Detection","local":"duplicate-detection","sections":[],"depth":2},{"title":"Collections","local":"collections","sections":[],"depth":2},{"title":"Retrieving Components","local":"retrieving-components","sections":[],"depth":2},{"title":"Using Components Manager with Modular Pipelines","local":"using-components-manager-with-modular-pipelines","sections":[],"depth":2},{"title":"Automatic Memory Management","local":"automatic-memory-management","sections":[],"depth":2},{"title":"Practical Example: Building Modular Workflows with Component Reuse","local":"practical-example-building-modular-workflows-with-component-reuse","sections":[{"title":"Base Text-to-Image Generation","local":"base-text-to-image-generation","sections":[],"depth":4},{"title":"LoRA","local":"lora","sections":[],"depth":4}],"depth":2}],"depth":1}';function rs(ct){return ts(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class fs extends ns{constructor(h){super(),ss(this,h,rs,cs,es,{})}}export{fs as component};
