import{s as al,o as sl,n as jt}from"../chunks/scheduler.8c3d61f6.js";import{S as pl,i as rl,g as s,s as n,r as m,A as ol,h as p,f as l,c as a,j as il,u as c,x as r,k as nl,y as ml,a as i,v as d,d as u,t as M,w as f}from"../chunks/index.da70eac4.js";import{T as _t}from"../chunks/Tip.1d9b8c37.js";import{C as g}from"../chunks/CodeBlock.a9c4becf.js";import{H as _e,E as cl}from"../chunks/getInferenceSnippets.fffe7af1.js";function dl(U){let o,w='🤗 Accelerate is a library for helping you train on multiple GPUs/TPUs or with mixed-precision. It’ll automatically configure your training setup based on your hardware and environment. Take a look at the 🤗 Accelerate <a href="https://huggingface.co/docs/accelerate/quicktour" rel="nofollow">Quick tour</a> to learn more.';return{c(){o=s("p"),o.innerHTML=w},l(h){o=p(h,"P",{"data-svelte-h":!0}),r(o)!=="svelte-1qbiqsn"&&(o.innerHTML=w)},m(h,b){i(h,o,b)},p:jt,d(h){h&&l(o)}}}function ul(U){let o,w='The following sections highlight parts of the training script that are important for understanding how to modify it, but it doesn’t cover every aspect of the script in detail. If you’re interested in learning more, feel free to read through the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">script</a> and let us know if you have any questions or concerns.';return{c(){o=s("p"),o.innerHTML=w},l(h){o=p(h,"P",{"data-svelte-h":!0}),r(o)!=="svelte-8co3s8"&&(o.innerHTML=w)},m(h,b){i(h,o,b)},p:jt,d(h){h&&l(o)}}}function Ml(U){let o,w="For better results, try longer training runs with a larger dataset. We’ve only tested this training script on a smaller-scale dataset.",h,b,T,J,_="To monitor training progress with Weights and Biases, add the <code>--report_to=wandb</code> parameter to the training command and specify a validation image with <code>--val_image_url</code> and a validation prompt with <code>--validation_prompt</code>. This can be really useful for debugging the model.";return{c(){o=s("p"),o.textContent=w,h=n(),b=s("br"),T=n(),J=s("p"),J.innerHTML=_},l(y){o=p(y,"P",{"data-svelte-h":!0}),r(o)!=="svelte-5d8n8o"&&(o.textContent=w),h=a(y),b=p(y,"BR",{}),T=a(y),J=p(y,"P",{"data-svelte-h":!0}),r(J)!=="svelte-yvr867"&&(J.innerHTML=_)},m(y,j){i(y,o,j),i(y,h,j),i(y,b,j),i(y,T,j),i(y,J,j)},p:jt,d(y){y&&(l(o),l(h),l(b),l(T),l(J))}}}function fl(U){let o,w,h,b,T,J,_,y='<a href="https://hf.co/papers/2211.09800" rel="nofollow">InstructPix2Pix</a> is a Stable Diffusion model trained to edit images from human-provided instructions. For example, your prompt can be “turn the clouds rainy” and the model will edit the input image accordingly. This model is conditioned on the text prompt (or editing instruction) and the input image.',j,$,Ut='This guide will explore the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix.py" rel="nofollow">train_instruct_pix2pix.py</a> training script to help you become familiar with it, and how you can adapt it for your own use case.',Ue,C,xt="Before running the script, make sure you install the library from source:",xe,X,Ze,v,Zt="Then navigate to the example folder containing the training script and install the required dependencies for the script you’re using:",We,I,$e,x,Ce,B,Wt="Initialize an 🤗 Accelerate environment:",Xe,k,ve,G,$t="To setup a default 🤗 Accelerate environment without choosing any configurations:",Ie,N,Be,R,Ct="Or if your environment doesn’t support an interactive shell, like a notebook, you can use:",ke,V,Ge,F,Xt='Lastly, if you want to train a model on your own dataset, take a look at the <a href="create_dataset">Create a dataset for training</a> guide to learn how to create a dataset that works with the training script.',Ne,Z,Re,Y,Ve,A,vt='The training script has many parameters to help you customize your training run. All of the parameters and their descriptions are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L65" rel="nofollow"><code>parse_args()</code></a> function. Default values are provided for most parameters that work pretty well, but you can also set your own values in the training command if you’d like.',Fe,H,It="For example, to increase the resolution of the input image:",Ye,L,Ae,S,Bt='Many of the basic and important parameters are described in the <a href="text2image#script-parameters">Text-to-image</a> training guide, so this guide just focuses on the relevant parameters for InstructPix2Pix:',He,Q,kt="<li><code>--original_image_column</code>: the original image before the edits are made</li> <li><code>--edited_image_column</code>: the image after the edits are made</li> <li><code>--edit_prompt_column</code>: the instructions to edit the image</li> <li><code>--conditioning_dropout_prob</code>: the dropout probability for the edited image and edit prompts during training which enables classifier-free guidance (CFG) for one or both conditioning inputs</li>",Le,z,Se,E,Gt='The dataset preprocessing code and training loop are found in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L374" rel="nofollow"><code>main()</code></a> function. This is where you’ll make your changes to the training script to adapt it for your own use-case.',Qe,P,Nt='As with the script parameters, a walkthrough of the training script is provided in the <a href="text2image#training-script">Text-to-image</a> training guide. Instead, this guide takes a look at the InstructPix2Pix relevant parts of the script.',ze,D,Rt='The script begins by modifying the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L445" rel="nofollow">number of input channels</a> in the first convolutional layer of the UNet to account for InstructPix2Pix’s additional conditioning image:',Ee,q,Pe,K,Vt='These UNet parameters are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L545C1-L551C6" rel="nofollow">updated</a> by the optimizer:',De,O,qe,ee,Ft='Next, the edited images and edit instructions are <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L624" rel="nofollow">preprocessed</a> and <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L610C24-L610C24" rel="nofollow">tokenized</a>. It is important the same image transformations are applied to the original and edited images.',Ke,te,Oe,le,Yt='Finally, in the <a href="https://github.com/huggingface/diffusers/blob/64603389da01082055a901f2883c4810d1144edb/examples/instruct_pix2pix/train_instruct_pix2pix.py#L730" rel="nofollow">training loop</a>, it starts by encoding the edited images into latent space:',et,ie,tt,ne,At="Then, the script applies dropout to the original image and edit instruction embeddings to support CFG. This is what enables the model to modulate the influence of the edit instruction and original image on the edited image.",lt,ae,it,se,Ht='That’s pretty much it! Aside from the differences described here, the rest of the script is very similar to the <a href="text2image#training-script">Text-to-image</a> training script, so feel free to check it out for more details. If you want to learn more about how the training loop works, check out the <a href="../using-diffusers/write_own_pipeline">Understanding pipelines, models and schedulers</a> tutorial which breaks down the basic pattern of the denoising process.',nt,pe,at,re,Lt="Once you’re happy with the changes to your script or if you’re okay with the default configuration, you’re ready to launch the training script! 🚀",st,oe,St='This guide uses the <a href="https://huggingface.co/datasets/fusing/instructpix2pix-1000-samples" rel="nofollow">fusing/instructpix2pix-1000-samples</a> dataset, which is a smaller version of the <a href="https://huggingface.co/datasets/timbrooks/instructpix2pix-clip-filtered" rel="nofollow">original dataset</a>. You can also create and use your own dataset if you’d like (see the <a href="create_dataset">Create a dataset for training</a> guide).',pt,me,Qt="Set the <code>MODEL_NAME</code> environment variable to the name of the model (can be a model id on the Hub or a path to a local model), and the <code>DATASET_ID</code> to the name of the dataset on the Hub. The script creates and saves all the components (feature extractor, scheduler, text encoder, UNet, etc.) to a subfolder in your repository.",rt,W,ot,ce,zt="If you’re training on more than one GPU, add the <code>--multi_gpu</code> parameter to the <code>accelerate launch</code> command.",mt,de,ct,ue,Et="After training is finished, you can use your new InstructPix2Pix for inference:",dt,Me,ut,fe,Pt="You should experiment with different <code>num_inference_steps</code>, <code>image_guidance_scale</code>, and <code>guidance_scale</code> values to see how they affect inference speed and quality. The guidance scale parameters are especially impactful because they control how much the original image and edit instructions affect the edited image.",Mt,he,ft,ye,Dt='Stable Diffusion XL (SDXL) is a powerful text-to-image model that generates high-resolution images, and it adds a second text-encoder to its architecture. Use the <a href="https://github.com/huggingface/diffusers/blob/main/examples/instruct_pix2pix/train_instruct_pix2pix_sdxl.py" rel="nofollow"><code>train_instruct_pix2pix_sdxl.py</code></a> script to train a SDXL model to follow image editing instructions.',ht,we,qt='The SDXL training script is discussed in more detail in the <a href="sdxl">SDXL training</a> guide.',yt,be,wt,ge,Kt="Congratulations on training your own InstructPix2Pix model! 🥳 To learn more about the model, it may be helpful to:",bt,Te,Ot='<li>Read the <a href="https://huggingface.co/blog/instruction-tuning-sd" rel="nofollow">Instruction-tuning Stable Diffusion with InstructPix2Pix</a> blog post to learn more about some experiments we’ve done with InstructPix2Pix, dataset preparation, and results for different instructions.</li>',gt,Je,Tt,je,Jt;return T=new _e({props:{title:"InstructPix2Pix",local:"instructpix2pix",headingTag:"h1"}}),X=new g({props:{code:"Z2l0JTIwY2xvbmUlMjBodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZodWdnaW5nZmFjZSUyRmRpZmZ1c2VycyUwQWNkJTIwZGlmZnVzZXJzJTBBcGlwJTIwaW5zdGFsbCUyMC4=",highlighted:`git <span class="hljs-built_in">clone</span> https://github.com/huggingface/diffusers
<span class="hljs-built_in">cd</span> diffusers
pip install .`,wrap:!1}}),I=new g({props:{code:"Y2QlMjBleGFtcGxlcyUyRmluc3RydWN0X3BpeDJwaXglMEFwaXAlMjBpbnN0YWxsJTIwLXIlMjByZXF1aXJlbWVudHMudHh0",highlighted:`<span class="hljs-built_in">cd</span> examples/instruct_pix2pix
pip install -r requirements.txt`,wrap:!1}}),x=new _t({props:{$$slots:{default:[dl]},$$scope:{ctx:U}}}),k=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZw==",highlighted:"accelerate config",wrap:!1}}),N=new g({props:{code:"YWNjZWxlcmF0ZSUyMGNvbmZpZyUyMGRlZmF1bHQ=",highlighted:"accelerate config default",wrap:!1}}),V=new g({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUudXRpbHMlMjBpbXBvcnQlMjB3cml0ZV9iYXNpY19jb25maWclMEElMEF3cml0ZV9iYXNpY19jb25maWcoKQ==",highlighted:`<span class="hljs-keyword">from</span> accelerate.utils <span class="hljs-keyword">import</span> write_basic_config

write_basic_config()`,wrap:!1}}),Z=new _t({props:{$$slots:{default:[ul]},$$scope:{ctx:U}}}),Y=new _e({props:{title:"Script parameters",local:"script-parameters",headingTag:"h2"}}),L=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAtLXJlc29sdXRpb24lM0Q1MTIlMjAlNUM=",highlighted:`accelerate launch train_instruct_pix2pix.py \\
  --resolution=512 \\`,wrap:!1}}),z=new _e({props:{title:"Training script",local:"training-script",headingTag:"h2"}}),q=new g({props:{code:"aW5fY2hhbm5lbHMlMjAlM0QlMjA4JTBBb3V0X2NoYW5uZWxzJTIwJTNEJTIwdW5ldC5jb252X2luLm91dF9jaGFubmVscyUwQXVuZXQucmVnaXN0ZXJfdG9fY29uZmlnKGluX2NoYW5uZWxzJTNEaW5fY2hhbm5lbHMpJTBBJTBBd2l0aCUyMHRvcmNoLm5vX2dyYWQoKSUzQSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luJTIwJTNEJTIwbm4uQ29udjJkKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGluX2NoYW5uZWxzJTJDJTIwb3V0X2NoYW5uZWxzJTJDJTIwdW5ldC5jb252X2luLmtlcm5lbF9zaXplJTJDJTIwdW5ldC5jb252X2luLnN0cmlkZSUyQyUyMHVuZXQuY29udl9pbi5wYWRkaW5nJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMG5ld19jb252X2luLndlaWdodC56ZXJvXygpJTBBJTIwJTIwJTIwJTIwbmV3X2NvbnZfaW4ud2VpZ2h0JTVCJTNBJTJDJTIwJTNBNCUyQyUyMCUzQSUyQyUyMCUzQSU1RC5jb3B5Xyh1bmV0LmNvbnZfaW4ud2VpZ2h0KSUwQSUyMCUyMCUyMCUyMHVuZXQuY29udl9pbiUyMCUzRCUyMG5ld19jb252X2lu",highlighted:`in_channels = <span class="hljs-number">8</span>
out_channels = unet.conv_in.out_channels
unet.register_to_config(in_channels=in_channels)

<span class="hljs-keyword">with</span> torch.no_grad():
    new_conv_in = nn.Conv2d(
        in_channels, out_channels, unet.conv_in.kernel_size, unet.conv_in.stride, unet.conv_in.padding
    )
    new_conv_in.weight.zero_()
    new_conv_in.weight[:, :<span class="hljs-number">4</span>, :, :].copy_(unet.conv_in.weight)
    unet.conv_in = new_conv_in`,wrap:!1}}),O=new g({props:{code:"b3B0aW1pemVyJTIwJTNEJTIwb3B0aW1pemVyX2NscyglMEElMjAlMjAlMjAlMjB1bmV0LnBhcmFtZXRlcnMoKSUyQyUwQSUyMCUyMCUyMCUyMGxyJTNEYXJncy5sZWFybmluZ19yYXRlJTJDJTBBJTIwJTIwJTIwJTIwYmV0YXMlM0QoYXJncy5hZGFtX2JldGExJTJDJTIwYXJncy5hZGFtX2JldGEyKSUyQyUwQSUyMCUyMCUyMCUyMHdlaWdodF9kZWNheSUzRGFyZ3MuYWRhbV93ZWlnaHRfZGVjYXklMkMlMEElMjAlMjAlMjAlMjBlcHMlM0RhcmdzLmFkYW1fZXBzaWxvbiUyQyUwQSk=",highlighted:`optimizer = optimizer_cls(
    unet.parameters(),
    lr=args.learning_rate,
    betas=(args.adam_beta1, args.adam_beta2),
    weight_decay=args.adam_weight_decay,
    eps=args.adam_epsilon,
)`,wrap:!1}}),te=new g({props:{code:"ZGVmJTIwcHJlcHJvY2Vzc190cmFpbihleGFtcGxlcyklM0ElMEElMjAlMjAlMjAlMjBwcmVwcm9jZXNzZWRfaW1hZ2VzJTIwJTNEJTIwcHJlcHJvY2Vzc19pbWFnZXMoZXhhbXBsZXMpJTBBJTBBJTIwJTIwJTIwJTIwb3JpZ2luYWxfaW1hZ2VzJTJDJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMHByZXByb2Nlc3NlZF9pbWFnZXMuY2h1bmsoMiklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZXMlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTIwJTIwJTIwJTIwZWRpdGVkX2ltYWdlcyUyMCUzRCUyMGVkaXRlZF9pbWFnZXMucmVzaGFwZSgtMSUyQyUyMDMlMkMlMjBhcmdzLnJlc29sdXRpb24lMkMlMjBhcmdzLnJlc29sdXRpb24pJTBBJTBBJTIwJTIwJTIwJTIwZXhhbXBsZXMlNUIlMjJvcmlnaW5hbF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBvcmlnaW5hbF9pbWFnZXMlMEElMjAlMjAlMjAlMjBleGFtcGxlcyU1QiUyMmVkaXRlZF9waXhlbF92YWx1ZXMlMjIlNUQlMjAlM0QlMjBlZGl0ZWRfaW1hZ2VzJTBBJTBBJTIwJTIwJTIwJTIwY2FwdGlvbnMlMjAlM0QlMjBsaXN0KGV4YW1wbGVzJTVCZWRpdF9wcm9tcHRfY29sdW1uJTVEKSUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTVCJTIyaW5wdXRfaWRzJTIyJTVEJTIwJTNEJTIwdG9rZW5pemVfY2FwdGlvbnMoY2FwdGlvbnMpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwZXhhbXBsZXM=",highlighted:`<span class="hljs-keyword">def</span> <span class="hljs-title function_">preprocess_train</span>(<span class="hljs-params">examples</span>):
    preprocessed_images = preprocess_images(examples)

    original_images, edited_images = preprocessed_images.chunk(<span class="hljs-number">2</span>)
    original_images = original_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)
    edited_images = edited_images.reshape(-<span class="hljs-number">1</span>, <span class="hljs-number">3</span>, args.resolution, args.resolution)

    examples[<span class="hljs-string">&quot;original_pixel_values&quot;</span>] = original_images
    examples[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>] = edited_images

    captions = <span class="hljs-built_in">list</span>(examples[edit_prompt_column])
    examples[<span class="hljs-string">&quot;input_ids&quot;</span>] = tokenize_captions(captions)
    <span class="hljs-keyword">return</span> examples`,wrap:!1}}),ie=new g({props:{code:"bGF0ZW50cyUyMCUzRCUyMHZhZS5lbmNvZGUoYmF0Y2glNUIlMjJlZGl0ZWRfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0LnNhbXBsZSgpJTBBbGF0ZW50cyUyMCUzRCUyMGxhdGVudHMlMjAqJTIwdmFlLmNvbmZpZy5zY2FsaW5nX2ZhY3Rvcg==",highlighted:`latents = vae.encode(batch[<span class="hljs-string">&quot;edited_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.sample()
latents = latents * vae.config.scaling_factor`,wrap:!1}}),ae=new g({props:{code:"ZW5jb2Rlcl9oaWRkZW5fc3RhdGVzJTIwJTNEJTIwdGV4dF9lbmNvZGVyKGJhdGNoJTVCJTIyaW5wdXRfaWRzJTIyJTVEKSU1QjAlNUQlMEFvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjB2YWUuZW5jb2RlKGJhdGNoJTVCJTIyb3JpZ2luYWxfcGl4ZWxfdmFsdWVzJTIyJTVELnRvKHdlaWdodF9kdHlwZSkpLmxhdGVudF9kaXN0Lm1vZGUoKSUwQSUwQWlmJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwcmFuZG9tX3AlMjAlM0QlMjB0b3JjaC5yYW5kKGJzeiUyQyUyMGRldmljZSUzRGxhdGVudHMuZGV2aWNlJTJDJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yKSUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcmFuZG9tX3AlMjAlM0MlMjAyJTIwKiUyMGFyZ3MuY29uZGl0aW9uaW5nX2Ryb3BvdXRfcHJvYiUwQSUyMCUyMCUyMCUyMHByb21wdF9tYXNrJTIwJTNEJTIwcHJvbXB0X21hc2sucmVzaGFwZShic3olMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBudWxsX2NvbmRpdGlvbmluZyUyMCUzRCUyMHRleHRfZW5jb2Rlcih0b2tlbml6ZV9jYXB0aW9ucyglNUIlMjIlMjIlNUQpLnRvKGFjY2VsZXJhdG9yLmRldmljZSkpJTVCMCU1RCUwQSUyMCUyMCUyMCUyMGVuY29kZXJfaGlkZGVuX3N0YXRlcyUyMCUzRCUyMHRvcmNoLndoZXJlKHByb21wdF9tYXNrJTJDJTIwbnVsbF9jb25kaXRpb25pbmclMkMlMjBlbmNvZGVyX2hpZGRlbl9zdGF0ZXMpJTBBJTBBJTIwJTIwJTIwJTIwaW1hZ2VfbWFza19kdHlwZSUyMCUzRCUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcy5kdHlwZSUwQSUyMCUyMCUyMCUyMGltYWdlX21hc2slMjAlM0QlMjAxJTIwLSUyMCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAocmFuZG9tX3AlMjAlM0UlM0QlMjBhcmdzLmNvbmRpdGlvbmluZ19kcm9wb3V0X3Byb2IpLnRvKGltYWdlX21hc2tfZHR5cGUpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwKiUyMChyYW5kb21fcCUyMCUzQyUyMDMlMjAqJTIwYXJncy5jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iKS50byhpbWFnZV9tYXNrX2R0eXBlKSUwQSUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjBpbWFnZV9tYXNrJTIwJTNEJTIwaW1hZ2VfbWFzay5yZXNoYXBlKGJzeiUyQyUyMDElMkMlMjAxJTJDJTIwMSklMEElMjAlMjAlMjAlMjBvcmlnaW5hbF9pbWFnZV9lbWJlZHMlMjAlM0QlMjBpbWFnZV9tYXNrJTIwKiUyMG9yaWdpbmFsX2ltYWdlX2VtYmVkcw==",highlighted:`encoder_hidden_states = text_encoder(batch[<span class="hljs-string">&quot;input_ids&quot;</span>])[<span class="hljs-number">0</span>]
original_image_embeds = vae.encode(batch[<span class="hljs-string">&quot;original_pixel_values&quot;</span>].to(weight_dtype)).latent_dist.mode()

<span class="hljs-keyword">if</span> args.conditioning_dropout_prob <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    random_p = torch.rand(bsz, device=latents.device, generator=generator)
    prompt_mask = random_p &lt; <span class="hljs-number">2</span> * args.conditioning_dropout_prob
    prompt_mask = prompt_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    null_conditioning = text_encoder(tokenize_captions([<span class="hljs-string">&quot;&quot;</span>]).to(accelerator.device))[<span class="hljs-number">0</span>]
    encoder_hidden_states = torch.where(prompt_mask, null_conditioning, encoder_hidden_states)

    image_mask_dtype = original_image_embeds.dtype
    image_mask = <span class="hljs-number">1</span> - (
        (random_p &gt;= args.conditioning_dropout_prob).to(image_mask_dtype)
        * (random_p &lt; <span class="hljs-number">3</span> * args.conditioning_dropout_prob).to(image_mask_dtype)
    )
    image_mask = image_mask.reshape(bsz, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>, <span class="hljs-number">1</span>)
    original_image_embeds = image_mask * original_image_embeds`,wrap:!1}}),pe=new _e({props:{title:"Launch the script",local:"launch-the-script",headingTag:"h2"}}),W=new _t({props:{$$slots:{default:[Ml]},$$scope:{ctx:U}}}),de=new g({props:{code:"YWNjZWxlcmF0ZSUyMGxhdW5jaCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEJTIyZnAxNiUyMiUyMHRyYWluX2luc3RydWN0X3BpeDJwaXgucHklMjAlNUMlMEElMjAlMjAlMjAlMjAtLXByZXRyYWluZWRfbW9kZWxfbmFtZV9vcl9wYXRoJTNEJTI0TU9ERUxfTkFNRSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZGF0YXNldF9uYW1lJTNEJTI0REFUQVNFVF9JRCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tZW5hYmxlX3hmb3JtZXJzX21lbW9yeV9lZmZpY2llbnRfYXR0ZW50aW9uJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yZXNvbHV0aW9uJTNEMjU2JTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1yYW5kb21fZmxpcCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tdHJhaW5fYmF0Y2hfc2l6ZSUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2FjY3VtdWxhdGlvbl9zdGVwcyUzRDQlMjAlNUMlMEElMjAlMjAlMjAlMjAtLWdyYWRpZW50X2NoZWNrcG9pbnRpbmclMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF90cmFpbl9zdGVwcyUzRDE1MDAwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jaGVja3BvaW50aW5nX3N0ZXBzJTNENTAwMCUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tY2hlY2twb2ludHNfdG90YWxfbGltaXQlM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1sZWFybmluZ19yYXRlJTNENWUtMDUlMjAlNUMlMEElMjAlMjAlMjAlMjAtLW1heF9ncmFkX25vcm0lM0QxJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1scl93YXJtdXBfc3RlcHMlM0QwJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1jb25kaXRpb25pbmdfZHJvcG91dF9wcm9iJTNEMC4wNSUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tbWl4ZWRfcHJlY2lzaW9uJTNEZnAxNiUyMCU1QyUwQSUyMCUyMCUyMCUyMC0tc2VlZCUzRDQyJTIwJTVDJTBBJTIwJTIwJTIwJTIwLS1wdXNoX3RvX2h1Yg==",highlighted:`accelerate launch --mixed_precision=<span class="hljs-string">&quot;fp16&quot;</span> train_instruct_pix2pix.py \\
    --pretrained_model_name_or_path=<span class="hljs-variable">$MODEL_NAME</span> \\
    --dataset_name=<span class="hljs-variable">$DATASET_ID</span> \\
    --enable_xformers_memory_efficient_attention \\
    --resolution=256 \\
    --random_flip \\
    --train_batch_size=4 \\
    --gradient_accumulation_steps=4 \\
    --gradient_checkpointing \\
    --max_train_steps=15000 \\
    --checkpointing_steps=5000 \\
    --checkpoints_total_limit=1 \\
    --learning_rate=5e-05 \\
    --max_grad_norm=1 \\
    --lr_warmup_steps=0 \\
    --conditioning_dropout_prob=0.05 \\
    --mixed_precision=fp16 \\
    --seed=42 \\
    --push_to_hub`,wrap:!1}}),Me=new g({props:{code:"aW1wb3J0JTIwUElMJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZSUwQWZyb20lMjBkaWZmdXNlcnMudXRpbHMlMjBpbXBvcnQlMjBsb2FkX2ltYWdlJTBBJTBBcGlwZWxpbmUlMjAlM0QlMjBTdGFibGVEaWZmdXNpb25JbnN0cnVjdFBpeDJQaXhQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTIyeW91cl9jb29sX21vZGVsJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2KS50byglMjJjdWRhJTIyKSUwQWdlbmVyYXRvciUyMCUzRCUyMHRvcmNoLkdlbmVyYXRvciglMjJjdWRhJTIyKS5tYW51YWxfc2VlZCgwKSUwQSUwQWltYWdlJTIwJTNEJTIwbG9hZF9pbWFnZSglMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZzYXlha3BhdWwlMkZzYW1wbGUtZGF0YXNldHMlMkZyZXNvbHZlJTJGbWFpbiUyRnRlc3RfcGl4MnBpeF80LnBuZyUyMiklMEFwcm9tcHQlMjAlM0QlMjAlMjJhZGQlMjBzb21lJTIwZHVja3MlMjB0byUyMHRoZSUyMGxha2UlMjIlMEFudW1faW5mZXJlbmNlX3N0ZXBzJTIwJTNEJTIwMjAlMEFpbWFnZV9ndWlkYW5jZV9zY2FsZSUyMCUzRCUyMDEuNSUwQWd1aWRhbmNlX3NjYWxlJTIwJTNEJTIwMTAlMEElMEFlZGl0ZWRfaW1hZ2UlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjBpbWFnZSUzRGltYWdlJTJDJTBBJTIwJTIwJTIwbnVtX2luZmVyZW5jZV9zdGVwcyUzRG51bV9pbmZlcmVuY2Vfc3RlcHMlMkMlMEElMjAlMjAlMjBpbWFnZV9ndWlkYW5jZV9zY2FsZSUzRGltYWdlX2d1aWRhbmNlX3NjYWxlJTJDJTBBJTIwJTIwJTIwZ3VpZGFuY2Vfc2NhbGUlM0RndWlkYW5jZV9zY2FsZSUyQyUwQSUyMCUyMCUyMGdlbmVyYXRvciUzRGdlbmVyYXRvciUyQyUwQSkuaW1hZ2VzJTVCMCU1RCUwQWVkaXRlZF9pbWFnZS5zYXZlKCUyMmVkaXRlZF9pbWFnZS5wbmclMjIp",highlighted:`<span class="hljs-keyword">import</span> PIL
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionInstructPix2PixPipeline
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image

pipeline = StableDiffusionInstructPix2PixPipeline.from_pretrained(<span class="hljs-string">&quot;your_cool_model&quot;</span>, torch_dtype=torch.float16).to(<span class="hljs-string">&quot;cuda&quot;</span>)
generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/sayakpaul/sample-datasets/resolve/main/test_pix2pix_4.png&quot;</span>)
prompt = <span class="hljs-string">&quot;add some ducks to the lake&quot;</span>
num_inference_steps = <span class="hljs-number">20</span>
image_guidance_scale = <span class="hljs-number">1.5</span>
guidance_scale = <span class="hljs-number">10</span>

edited_image = pipeline(
   prompt,
   image=image,
   num_inference_steps=num_inference_steps,
   image_guidance_scale=image_guidance_scale,
   guidance_scale=guidance_scale,
   generator=generator,
).images[<span class="hljs-number">0</span>]
edited_image.save(<span class="hljs-string">&quot;edited_image.png&quot;</span>)`,wrap:!1}}),he=new _e({props:{title:"Stable Diffusion XL",local:"stable-diffusion-xl",headingTag:"h2"}}),be=new _e({props:{title:"Next steps",local:"next-steps",headingTag:"h2"}}),Je=new cl({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/training/instructpix2pix.md"}}),{c(){o=s("meta"),w=n(),h=s("p"),b=n(),m(T.$$.fragment),J=n(),_=s("p"),_.innerHTML=y,j=n(),$=s("p"),$.innerHTML=Ut,Ue=n(),C=s("p"),C.textContent=xt,xe=n(),m(X.$$.fragment),Ze=n(),v=s("p"),v.textContent=Zt,We=n(),m(I.$$.fragment),$e=n(),m(x.$$.fragment),Ce=n(),B=s("p"),B.textContent=Wt,Xe=n(),m(k.$$.fragment),ve=n(),G=s("p"),G.textContent=$t,Ie=n(),m(N.$$.fragment),Be=n(),R=s("p"),R.textContent=Ct,ke=n(),m(V.$$.fragment),Ge=n(),F=s("p"),F.innerHTML=Xt,Ne=n(),m(Z.$$.fragment),Re=n(),m(Y.$$.fragment),Ve=n(),A=s("p"),A.innerHTML=vt,Fe=n(),H=s("p"),H.textContent=It,Ye=n(),m(L.$$.fragment),Ae=n(),S=s("p"),S.innerHTML=Bt,He=n(),Q=s("ul"),Q.innerHTML=kt,Le=n(),m(z.$$.fragment),Se=n(),E=s("p"),E.innerHTML=Gt,Qe=n(),P=s("p"),P.innerHTML=Nt,ze=n(),D=s("p"),D.innerHTML=Rt,Ee=n(),m(q.$$.fragment),Pe=n(),K=s("p"),K.innerHTML=Vt,De=n(),m(O.$$.fragment),qe=n(),ee=s("p"),ee.innerHTML=Ft,Ke=n(),m(te.$$.fragment),Oe=n(),le=s("p"),le.innerHTML=Yt,et=n(),m(ie.$$.fragment),tt=n(),ne=s("p"),ne.textContent=At,lt=n(),m(ae.$$.fragment),it=n(),se=s("p"),se.innerHTML=Ht,nt=n(),m(pe.$$.fragment),at=n(),re=s("p"),re.textContent=Lt,st=n(),oe=s("p"),oe.innerHTML=St,pt=n(),me=s("p"),me.innerHTML=Qt,rt=n(),m(W.$$.fragment),ot=n(),ce=s("p"),ce.innerHTML=zt,mt=n(),m(de.$$.fragment),ct=n(),ue=s("p"),ue.textContent=Et,dt=n(),m(Me.$$.fragment),ut=n(),fe=s("p"),fe.innerHTML=Pt,Mt=n(),m(he.$$.fragment),ft=n(),ye=s("p"),ye.innerHTML=Dt,ht=n(),we=s("p"),we.innerHTML=qt,yt=n(),m(be.$$.fragment),wt=n(),ge=s("p"),ge.textContent=Kt,bt=n(),Te=s("ul"),Te.innerHTML=Ot,gt=n(),m(Je.$$.fragment),Tt=n(),je=s("p"),this.h()},l(e){const t=ol("svelte-u9bgzb",document.head);o=p(t,"META",{name:!0,content:!0}),t.forEach(l),w=a(e),h=p(e,"P",{}),il(h).forEach(l),b=a(e),c(T.$$.fragment,e),J=a(e),_=p(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-1wbq6mw"&&(_.innerHTML=y),j=a(e),$=p(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-5rcc6r"&&($.innerHTML=Ut),Ue=a(e),C=p(e,"P",{"data-svelte-h":!0}),r(C)!=="svelte-l7dm2q"&&(C.textContent=xt),xe=a(e),c(X.$$.fragment,e),Ze=a(e),v=p(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-z4z0b9"&&(v.textContent=Zt),We=a(e),c(I.$$.fragment,e),$e=a(e),c(x.$$.fragment,e),Ce=a(e),B=p(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-60q53m"&&(B.textContent=Wt),Xe=a(e),c(k.$$.fragment,e),ve=a(e),G=p(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-di6juu"&&(G.textContent=$t),Ie=a(e),c(N.$$.fragment,e),Be=a(e),R=p(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-tsz4qp"&&(R.textContent=Ct),ke=a(e),c(V.$$.fragment,e),Ge=a(e),F=p(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-1fkfdql"&&(F.innerHTML=Xt),Ne=a(e),c(Z.$$.fragment,e),Re=a(e),c(Y.$$.fragment,e),Ve=a(e),A=p(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-1ouxjve"&&(A.innerHTML=vt),Fe=a(e),H=p(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-10dyj7s"&&(H.textContent=It),Ye=a(e),c(L.$$.fragment,e),Ae=a(e),S=p(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-4ua73s"&&(S.innerHTML=Bt),He=a(e),Q=p(e,"UL",{"data-svelte-h":!0}),r(Q)!=="svelte-xkub9r"&&(Q.innerHTML=kt),Le=a(e),c(z.$$.fragment,e),Se=a(e),E=p(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1opaho7"&&(E.innerHTML=Gt),Qe=a(e),P=p(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1urxowy"&&(P.innerHTML=Nt),ze=a(e),D=p(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-8vjj60"&&(D.innerHTML=Rt),Ee=a(e),c(q.$$.fragment,e),Pe=a(e),K=p(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1nq4njr"&&(K.innerHTML=Vt),De=a(e),c(O.$$.fragment,e),qe=a(e),ee=p(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-1mob6kq"&&(ee.innerHTML=Ft),Ke=a(e),c(te.$$.fragment,e),Oe=a(e),le=p(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-15k4bki"&&(le.innerHTML=Yt),et=a(e),c(ie.$$.fragment,e),tt=a(e),ne=p(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1f46pf0"&&(ne.textContent=At),lt=a(e),c(ae.$$.fragment,e),it=a(e),se=p(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-rm72af"&&(se.innerHTML=Ht),nt=a(e),c(pe.$$.fragment,e),at=a(e),re=p(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-191xcj8"&&(re.textContent=Lt),st=a(e),oe=p(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-1jl92wm"&&(oe.innerHTML=St),pt=a(e),me=p(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-1pi9kmf"&&(me.innerHTML=Qt),rt=a(e),c(W.$$.fragment,e),ot=a(e),ce=p(e,"P",{"data-svelte-h":!0}),r(ce)!=="svelte-mj0rx7"&&(ce.innerHTML=zt),mt=a(e),c(de.$$.fragment,e),ct=a(e),ue=p(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-aiofgl"&&(ue.textContent=Et),dt=a(e),c(Me.$$.fragment,e),ut=a(e),fe=p(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-3mecu5"&&(fe.innerHTML=Pt),Mt=a(e),c(he.$$.fragment,e),ft=a(e),ye=p(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-tzsz20"&&(ye.innerHTML=Dt),ht=a(e),we=p(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-6dxtva"&&(we.innerHTML=qt),yt=a(e),c(be.$$.fragment,e),wt=a(e),ge=p(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-ldm0c5"&&(ge.textContent=Kt),bt=a(e),Te=p(e,"UL",{"data-svelte-h":!0}),r(Te)!=="svelte-eqz35e"&&(Te.innerHTML=Ot),gt=a(e),c(Je.$$.fragment,e),Tt=a(e),je=p(e,"P",{}),il(je).forEach(l),this.h()},h(){nl(o,"name","hf:doc:metadata"),nl(o,"content",hl)},m(e,t){ml(document.head,o),i(e,w,t),i(e,h,t),i(e,b,t),d(T,e,t),i(e,J,t),i(e,_,t),i(e,j,t),i(e,$,t),i(e,Ue,t),i(e,C,t),i(e,xe,t),d(X,e,t),i(e,Ze,t),i(e,v,t),i(e,We,t),d(I,e,t),i(e,$e,t),d(x,e,t),i(e,Ce,t),i(e,B,t),i(e,Xe,t),d(k,e,t),i(e,ve,t),i(e,G,t),i(e,Ie,t),d(N,e,t),i(e,Be,t),i(e,R,t),i(e,ke,t),d(V,e,t),i(e,Ge,t),i(e,F,t),i(e,Ne,t),d(Z,e,t),i(e,Re,t),d(Y,e,t),i(e,Ve,t),i(e,A,t),i(e,Fe,t),i(e,H,t),i(e,Ye,t),d(L,e,t),i(e,Ae,t),i(e,S,t),i(e,He,t),i(e,Q,t),i(e,Le,t),d(z,e,t),i(e,Se,t),i(e,E,t),i(e,Qe,t),i(e,P,t),i(e,ze,t),i(e,D,t),i(e,Ee,t),d(q,e,t),i(e,Pe,t),i(e,K,t),i(e,De,t),d(O,e,t),i(e,qe,t),i(e,ee,t),i(e,Ke,t),d(te,e,t),i(e,Oe,t),i(e,le,t),i(e,et,t),d(ie,e,t),i(e,tt,t),i(e,ne,t),i(e,lt,t),d(ae,e,t),i(e,it,t),i(e,se,t),i(e,nt,t),d(pe,e,t),i(e,at,t),i(e,re,t),i(e,st,t),i(e,oe,t),i(e,pt,t),i(e,me,t),i(e,rt,t),d(W,e,t),i(e,ot,t),i(e,ce,t),i(e,mt,t),d(de,e,t),i(e,ct,t),i(e,ue,t),i(e,dt,t),d(Me,e,t),i(e,ut,t),i(e,fe,t),i(e,Mt,t),d(he,e,t),i(e,ft,t),i(e,ye,t),i(e,ht,t),i(e,we,t),i(e,yt,t),d(be,e,t),i(e,wt,t),i(e,ge,t),i(e,bt,t),i(e,Te,t),i(e,gt,t),d(Je,e,t),i(e,Tt,t),i(e,je,t),Jt=!0},p(e,[t]){const el={};t&2&&(el.$$scope={dirty:t,ctx:e}),x.$set(el);const tl={};t&2&&(tl.$$scope={dirty:t,ctx:e}),Z.$set(tl);const ll={};t&2&&(ll.$$scope={dirty:t,ctx:e}),W.$set(ll)},i(e){Jt||(u(T.$$.fragment,e),u(X.$$.fragment,e),u(I.$$.fragment,e),u(x.$$.fragment,e),u(k.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(Z.$$.fragment,e),u(Y.$$.fragment,e),u(L.$$.fragment,e),u(z.$$.fragment,e),u(q.$$.fragment,e),u(O.$$.fragment,e),u(te.$$.fragment,e),u(ie.$$.fragment,e),u(ae.$$.fragment,e),u(pe.$$.fragment,e),u(W.$$.fragment,e),u(de.$$.fragment,e),u(Me.$$.fragment,e),u(he.$$.fragment,e),u(be.$$.fragment,e),u(Je.$$.fragment,e),Jt=!0)},o(e){M(T.$$.fragment,e),M(X.$$.fragment,e),M(I.$$.fragment,e),M(x.$$.fragment,e),M(k.$$.fragment,e),M(N.$$.fragment,e),M(V.$$.fragment,e),M(Z.$$.fragment,e),M(Y.$$.fragment,e),M(L.$$.fragment,e),M(z.$$.fragment,e),M(q.$$.fragment,e),M(O.$$.fragment,e),M(te.$$.fragment,e),M(ie.$$.fragment,e),M(ae.$$.fragment,e),M(pe.$$.fragment,e),M(W.$$.fragment,e),M(de.$$.fragment,e),M(Me.$$.fragment,e),M(he.$$.fragment,e),M(be.$$.fragment,e),M(Je.$$.fragment,e),Jt=!1},d(e){e&&(l(w),l(h),l(b),l(J),l(_),l(j),l($),l(Ue),l(C),l(xe),l(Ze),l(v),l(We),l($e),l(Ce),l(B),l(Xe),l(ve),l(G),l(Ie),l(Be),l(R),l(ke),l(Ge),l(F),l(Ne),l(Re),l(Ve),l(A),l(Fe),l(H),l(Ye),l(Ae),l(S),l(He),l(Q),l(Le),l(Se),l(E),l(Qe),l(P),l(ze),l(D),l(Ee),l(Pe),l(K),l(De),l(qe),l(ee),l(Ke),l(Oe),l(le),l(et),l(tt),l(ne),l(lt),l(it),l(se),l(nt),l(at),l(re),l(st),l(oe),l(pt),l(me),l(rt),l(ot),l(ce),l(mt),l(ct),l(ue),l(dt),l(ut),l(fe),l(Mt),l(ft),l(ye),l(ht),l(we),l(yt),l(wt),l(ge),l(bt),l(Te),l(gt),l(Tt),l(je)),l(o),f(T,e),f(X,e),f(I,e),f(x,e),f(k,e),f(N,e),f(V,e),f(Z,e),f(Y,e),f(L,e),f(z,e),f(q,e),f(O,e),f(te,e),f(ie,e),f(ae,e),f(pe,e),f(W,e),f(de,e),f(Me,e),f(he,e),f(be,e),f(Je,e)}}}const hl='{"title":"InstructPix2Pix","local":"instructpix2pix","sections":[{"title":"Script parameters","local":"script-parameters","sections":[],"depth":2},{"title":"Training script","local":"training-script","sections":[],"depth":2},{"title":"Launch the script","local":"launch-the-script","sections":[],"depth":2},{"title":"Stable Diffusion XL","local":"stable-diffusion-xl","sections":[],"depth":2},{"title":"Next steps","local":"next-steps","sections":[],"depth":2}],"depth":1}';function yl(U){return sl(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class _l extends pl{constructor(o){super(),rl(this,o,yl,fl,al,{})}}export{_l as component};
