import{s as Ie,n as Ce,o as Ve}from"../chunks/scheduler.8c3d61f6.js";import{S as He,i as Qe,g as n,s as a,r as p,A as Ne,h as o,f as l,c as i,j as Se,u as m,x as f,k as Ze,y as Le,a as s,v as r,d as u,t as c,w as d}from"../chunks/index.da70eac4.js";import{C as Q}from"../chunks/CodeBlock.a9c4becf.js";import{D as Ee}from"../chunks/DocNotebookDropdown.48852948.js";import{H as E,E as qe}from"../chunks/getInferenceSnippets.fffe7af1.js";function ze(Te){let b,q,N,z,y,D,M,A,w,je=`SDXL Turbo is an adversarial time-distilled <a href="https://huggingface.co/papers/2307.01952" rel="nofollow">Stable Diffusion XL</a> (SDXL) model capable
of running inference in as little as 1 step.`,P,J,$e="This guide will show you how to use SDXL-Turbo for text-to-image and image-to-image.",K,U,We="Before you begin, make sure you have the following libraries installed:",O,Z,ee,T,te,j,Ge='Model weights may be stored in separate subfolders on the Hub or locally, in which case, you should use the <a href="/docs/diffusers/main/en/api/pipelines/overview#diffusers.DiffusionPipeline.from_pretrained">from_pretrained()</a> method:',le,$,se,W,ve='You can also use the <a href="/docs/diffusers/main/en/api/loaders/single_file#diffusers.loaders.FromSingleFileMixin.from_single_file">from_single_file()</a> method to load a model checkpoint stored in a single file format (<code>.ckpt</code> or <code>.safetensors</code>) from the Hub or locally. For this loading method, you need to set <code>timestep_spacing=&quot;trailing&quot;</code> (feel free to experiment with the other scheduler config values to get better results):',ae,G,ie,v,ne,_,_e="For text-to-image, pass a text prompt. By default, SDXL Turbo generates a 512x512 image, and that resolution gives the best results. You can try setting the <code>height</code> and <code>width</code> parameters to 768x768 or 1024x1024, but you should expect quality degradations when doing so.",oe,k,ke=`Make sure to set <code>guidance_scale</code> to 0.0 to disable, as the model was trained without it. A single inference step is enough to generate high quality images.
Increasing the number of steps to 2, 3 or 4 should improve image quality.`,pe,x,me,g,xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-text2img.png" alt="generated image of a racoon in a robe"/>',re,B,ue,X,Be=`For image-to-image generation, make sure that <code>num_inference_steps * strength</code> is larger or equal to 1.
The image-to-image pipeline will run for <code>int(num_inference_steps * strength)</code> steps, e.g. <code>0.5 * 2.0 = 1</code> step in
our example below.`,ce,Y,de,h,Xe='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/sdxl-turbo-img2img.png" alt="Image-to-image generation sample using SDXL Turbo"/>',fe,F,be,R,Ye="<li>Compile the UNet if you are using PyTorch version 2.0 or higher. The first inference run will be very slow, but subsequent ones will be much faster.</li>",ge,S,he,I,Fe="<li>When using the default VAE, keep it in <code>float32</code> to avoid costly <code>dtype</code> conversions before and after each generation. You only need to do this one before your first generation:</li>",ye,C,Me,V,Re='As an alternative, you can also use a <a href="https://huggingface.co/madebyollin/sdxl-vae-fp16-fix" rel="nofollow">16-bit VAE</a> created by community member <a href="https://huggingface.co/madebyollin" rel="nofollow"><code>@madebyollin</code></a> that does not need to be upcasted to <code>float32</code>.',we,H,Je,L,Ue;return y=new E({props:{title:"Stable Diffusion XL Turbo",local:"stable-diffusion-xl-turbo",headingTag:"h1"}}),M=new Ee({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/sdxl_turbo.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/pytorch/sdxl_turbo.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/diffusers_doc/en/tensorflow/sdxl_turbo.ipynb"}]}}),Z=new Q({props:{code:"JTIzJTIwdW5jb21tZW50JTIwdG8lMjBpbnN0YWxsJTIwdGhlJTIwbmVjZXNzYXJ5JTIwbGlicmFyaWVzJTIwaW4lMjBDb2xhYiUwQSUyMyFwaXAlMjBpbnN0YWxsJTIwLXElMjBkaWZmdXNlcnMlMjB0cmFuc2Zvcm1lcnMlMjBhY2NlbGVyYXRl",highlighted:`<span class="hljs-comment"># uncomment to install the necessary libraries in Colab</span>
<span class="hljs-comment">#!pip install -q diffusers transformers accelerate</span>`,wrap:!1}}),T=new E({props:{title:"Load model checkpoints",local:"load-model-checkpoints",headingTag:"h2"}}),$=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lJTIwJTNEJTIwQXV0b1BpcGVsaW5lRm9yVGV4dDJJbWFnZS5mcm9tX3ByZXRyYWluZWQoJTIyc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTIyJTJDJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTIwdmFyaWFudCUzRCUyMmZwMTYlMjIpJTBBcGlwZWxpbmUlMjAlM0QlMjBwaXBlbGluZS50byglMjJjdWRhJTIyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),G=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUlMkMlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyJTBBaW1wb3J0JTIwdG9yY2glMEElMEFwaXBlbGluZSUyMCUzRCUyMFN0YWJsZURpZmZ1c2lvblhMUGlwZWxpbmUuZnJvbV9zaW5nbGVfZmlsZSglMEElMjAlMjAlMjAlMjAlMjJodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGc3RhYmlsaXR5YWklMkZzZHhsLXR1cmJvJTJGYmxvYiUyRm1haW4lMkZzZF94bF90dXJib18xLjBfZnAxNi5zYWZldGVuc29ycyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUyMHZhcmlhbnQlM0QlMjJmcDE2JTIyKSUwQXBpcGVsaW5lJTIwJTNEJTIwcGlwZWxpbmUudG8oJTIyY3VkYSUyMiklMEFwaXBlbGluZS5zY2hlZHVsZXIlMjAlM0QlMjBFdWxlckFuY2VzdHJhbERpc2NyZXRlU2NoZWR1bGVyLmZyb21fY29uZmlnKHBpcGVsaW5lLnNjaGVkdWxlci5jb25maWclMkMlMjB0aW1lc3RlcF9zcGFjaW5nJTNEJTIydHJhaWxpbmclMjIp",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> StableDiffusionXLPipeline, EulerAncestralDiscreteScheduler
<span class="hljs-keyword">import</span> torch

pipeline = StableDiffusionXLPipeline.from_single_file(
    <span class="hljs-string">&quot;https://huggingface.co/stabilityai/sdxl-turbo/blob/main/sd_xl_turbo_1.0_fp16.safetensors&quot;</span>,
    torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline = pipeline.to(<span class="hljs-string">&quot;cuda&quot;</span>)
pipeline.scheduler = EulerAncestralDiscreteScheduler.from_config(pipeline.scheduler.config, timestep_spacing=<span class="hljs-string">&quot;trailing&quot;</span>)`,wrap:!1}}),v=new E({props:{title:"Text-to-image",local:"text-to-image",headingTag:"h2"}}),x=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvclRleHQySW1hZ2UlMEFpbXBvcnQlMjB0b3JjaCUwQSUwQXBpcGVsaW5lX3RleHQyaW1hZ2UlMjAlM0QlMjBBdXRvUGlwZWxpbmVGb3JUZXh0MkltYWdlLmZyb21fcHJldHJhaW5lZCglMjJzdGFiaWxpdHlhaSUyRnNkeGwtdHVyYm8lMjIlMkMlMjB0b3JjaF9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMjB2YXJpYW50JTNEJTIyZnAxNiUyMiklMEFwaXBlbGluZV90ZXh0MmltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZS50byglMjJjdWRhJTIyKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMkElMjBjaW5lbWF0aWMlMjBzaG90JTIwb2YlMjBhJTIwYmFieSUyMHJhY29vbiUyMHdlYXJpbmclMjBhbiUyMGludHJpY2F0ZSUyMGl0YWxpYW4lMjBwcmllc3QlMjByb2JlLiUyMiUwQSUwQWltYWdlJTIwJTNEJTIwcGlwZWxpbmVfdGV4dDJpbWFnZShwcm9tcHQlM0Rwcm9tcHQlMkMlMjBndWlkYW5jZV9zY2FsZSUzRDAuMCUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QxKS5pbWFnZXMlNUIwJTVEJTBBaW1hZ2U=",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForText2Image
<span class="hljs-keyword">import</span> torch

pipeline_text2image = AutoPipelineForText2Image.from_pretrained(<span class="hljs-string">&quot;stabilityai/sdxl-turbo&quot;</span>, torch_dtype=torch.float16, variant=<span class="hljs-string">&quot;fp16&quot;</span>)
pipeline_text2image = pipeline_text2image.to(<span class="hljs-string">&quot;cuda&quot;</span>)

prompt = <span class="hljs-string">&quot;A cinematic shot of a baby racoon wearing an intricate italian priest robe.&quot;</span>

image = pipeline_text2image(prompt=prompt, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">1</span>).images[<span class="hljs-number">0</span>]
image`,wrap:!1}}),B=new E({props:{title:"Image-to-image",local:"image-to-image",headingTag:"h2"}}),Y=new Q({props:{code:"ZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlJTBBZnJvbSUyMGRpZmZ1c2Vycy51dGlscyUyMGltcG9ydCUyMGxvYWRfaW1hZ2UlMkMlMjBtYWtlX2ltYWdlX2dyaWQlMEElMEElMjMlMjB1c2UlMjBmcm9tX3BpcGUlMjB0byUyMGF2b2lkJTIwY29uc3VtaW5nJTIwYWRkaXRpb25hbCUyMG1lbW9yeSUyMHdoZW4lMjBsb2FkaW5nJTIwYSUyMGNoZWNrcG9pbnQlMEFwaXBlbGluZV9pbWFnZTJpbWFnZSUyMCUzRCUyMEF1dG9QaXBlbGluZUZvckltYWdlMkltYWdlLmZyb21fcGlwZShwaXBlbGluZV90ZXh0MmltYWdlKS50byglMjJjdWRhJTIyKSUwQSUwQWluaXRfaW1hZ2UlMjAlM0QlMjBsb2FkX2ltYWdlKCUyMmh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRmh1Z2dpbmdmYWNlJTJGZG9jdW1lbnRhdGlvbi1pbWFnZXMlMkZyZXNvbHZlJTJGbWFpbiUyRmRpZmZ1c2VycyUyRmNhdC5wbmclMjIpJTBBaW5pdF9pbWFnZSUyMCUzRCUyMGluaXRfaW1hZ2UucmVzaXplKCg1MTIlMkMlMjA1MTIpKSUwQSUwQXByb21wdCUyMCUzRCUyMCUyMmNhdCUyMHdpemFyZCUyQyUyMGdhbmRhbGYlMkMlMjBsb3JkJTIwb2YlMjB0aGUlMjByaW5ncyUyQyUyMGRldGFpbGVkJTJDJTIwZmFudGFzeSUyQyUyMGN1dGUlMkMlMjBhZG9yYWJsZSUyQyUyMFBpeGFyJTJDJTIwRGlzbmV5JTJDJTIwOGslMjIlMEElMEFpbWFnZSUyMCUzRCUyMHBpcGVsaW5lX2ltYWdlMmltYWdlKHByb21wdCUyQyUyMGltYWdlJTNEaW5pdF9pbWFnZSUyQyUyMHN0cmVuZ3RoJTNEMC41JTJDJTIwZ3VpZGFuY2Vfc2NhbGUlM0QwLjAlMkMlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMikuaW1hZ2VzJTVCMCU1RCUwQW1ha2VfaW1hZ2VfZ3JpZCglNUJpbml0X2ltYWdlJTJDJTIwaW1hZ2UlNUQlMkMlMjByb3dzJTNEMSUyQyUyMGNvbHMlM0QyKQ==",highlighted:`<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AutoPipelineForImage2Image
<span class="hljs-keyword">from</span> diffusers.utils <span class="hljs-keyword">import</span> load_image, make_image_grid

<span class="hljs-comment"># use from_pipe to avoid consuming additional memory when loading a checkpoint</span>
pipeline_image2image = AutoPipelineForImage2Image.from_pipe(pipeline_text2image).to(<span class="hljs-string">&quot;cuda&quot;</span>)

init_image = load_image(<span class="hljs-string">&quot;https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/diffusers/cat.png&quot;</span>)
init_image = init_image.resize((<span class="hljs-number">512</span>, <span class="hljs-number">512</span>))

prompt = <span class="hljs-string">&quot;cat wizard, gandalf, lord of the rings, detailed, fantasy, cute, adorable, Pixar, Disney, 8k&quot;</span>

image = pipeline_image2image(prompt, image=init_image, strength=<span class="hljs-number">0.5</span>, guidance_scale=<span class="hljs-number">0.0</span>, num_inference_steps=<span class="hljs-number">2</span>).images[<span class="hljs-number">0</span>]
make_image_grid([init_image, image], rows=<span class="hljs-number">1</span>, cols=<span class="hljs-number">2</span>)`,wrap:!1}}),F=new E({props:{title:"Speed-up SDXL Turbo even more",local:"speed-up-sdxl-turbo-even-more",headingTag:"h2"}}),S=new Q({props:{code:"cGlwZS51bmV0JTIwJTNEJTIwdG9yY2guY29tcGlsZShwaXBlLnVuZXQlMkMlMjBtb2RlJTNEJTIycmVkdWNlLW92ZXJoZWFkJTIyJTJDJTIwZnVsbGdyYXBoJTNEVHJ1ZSk=",highlighted:'pipe.unet = torch.<span class="hljs-built_in">compile</span>(pipe.unet, mode=<span class="hljs-string">&quot;reduce-overhead&quot;</span>, fullgraph=<span class="hljs-literal">True</span>)',wrap:!1}}),C=new Q({props:{code:"cGlwZS51cGNhc3RfdmFlKCk=",highlighted:"pipe.upcast_vae()",wrap:!1}}),H=new qe({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/using-diffusers/sdxl_turbo.md"}}),{c(){b=n("meta"),q=a(),N=n("p"),z=a(),p(y.$$.fragment),D=a(),p(M.$$.fragment),A=a(),w=n("p"),w.innerHTML=je,P=a(),J=n("p"),J.textContent=$e,K=a(),U=n("p"),U.textContent=We,O=a(),p(Z.$$.fragment),ee=a(),p(T.$$.fragment),te=a(),j=n("p"),j.innerHTML=Ge,le=a(),p($.$$.fragment),se=a(),W=n("p"),W.innerHTML=ve,ae=a(),p(G.$$.fragment),ie=a(),p(v.$$.fragment),ne=a(),_=n("p"),_.innerHTML=_e,oe=a(),k=n("p"),k.innerHTML=ke,pe=a(),p(x.$$.fragment),me=a(),g=n("div"),g.innerHTML=xe,re=a(),p(B.$$.fragment),ue=a(),X=n("p"),X.innerHTML=Be,ce=a(),p(Y.$$.fragment),de=a(),h=n("div"),h.innerHTML=Xe,fe=a(),p(F.$$.fragment),be=a(),R=n("ul"),R.innerHTML=Ye,ge=a(),p(S.$$.fragment),he=a(),I=n("ul"),I.innerHTML=Fe,ye=a(),p(C.$$.fragment),Me=a(),V=n("p"),V.innerHTML=Re,we=a(),p(H.$$.fragment),Je=a(),L=n("p"),this.h()},l(e){const t=Ne("svelte-u9bgzb",document.head);b=o(t,"META",{name:!0,content:!0}),t.forEach(l),q=i(e),N=o(e,"P",{}),Se(N).forEach(l),z=i(e),m(y.$$.fragment,e),D=i(e),m(M.$$.fragment,e),A=i(e),w=o(e,"P",{"data-svelte-h":!0}),f(w)!=="svelte-1465uj8"&&(w.innerHTML=je),P=i(e),J=o(e,"P",{"data-svelte-h":!0}),f(J)!=="svelte-851pbc"&&(J.textContent=$e),K=i(e),U=o(e,"P",{"data-svelte-h":!0}),f(U)!=="svelte-cwruts"&&(U.textContent=We),O=i(e),m(Z.$$.fragment,e),ee=i(e),m(T.$$.fragment,e),te=i(e),j=o(e,"P",{"data-svelte-h":!0}),f(j)!=="svelte-hva56b"&&(j.innerHTML=Ge),le=i(e),m($.$$.fragment,e),se=i(e),W=o(e,"P",{"data-svelte-h":!0}),f(W)!=="svelte-w1f5rc"&&(W.innerHTML=ve),ae=i(e),m(G.$$.fragment,e),ie=i(e),m(v.$$.fragment,e),ne=i(e),_=o(e,"P",{"data-svelte-h":!0}),f(_)!=="svelte-1urqyhr"&&(_.innerHTML=_e),oe=i(e),k=o(e,"P",{"data-svelte-h":!0}),f(k)!=="svelte-d70s1"&&(k.innerHTML=ke),pe=i(e),m(x.$$.fragment,e),me=i(e),g=o(e,"DIV",{class:!0,"data-svelte-h":!0}),f(g)!=="svelte-1lx4ppg"&&(g.innerHTML=xe),re=i(e),m(B.$$.fragment,e),ue=i(e),X=o(e,"P",{"data-svelte-h":!0}),f(X)!=="svelte-1rvgn5v"&&(X.innerHTML=Be),ce=i(e),m(Y.$$.fragment,e),de=i(e),h=o(e,"DIV",{class:!0,"data-svelte-h":!0}),f(h)!=="svelte-ovbosa"&&(h.innerHTML=Xe),fe=i(e),m(F.$$.fragment,e),be=i(e),R=o(e,"UL",{"data-svelte-h":!0}),f(R)!=="svelte-1k6q17l"&&(R.innerHTML=Ye),ge=i(e),m(S.$$.fragment,e),he=i(e),I=o(e,"UL",{"data-svelte-h":!0}),f(I)!=="svelte-jn62ws"&&(I.innerHTML=Fe),ye=i(e),m(C.$$.fragment,e),Me=i(e),V=o(e,"P",{"data-svelte-h":!0}),f(V)!=="svelte-1pt3hz0"&&(V.innerHTML=Re),we=i(e),m(H.$$.fragment,e),Je=i(e),L=o(e,"P",{}),Se(L).forEach(l),this.h()},h(){Ze(b,"name","hf:doc:metadata"),Ze(b,"content",De),Ze(g,"class","flex justify-center"),Ze(h,"class","flex justify-center")},m(e,t){Le(document.head,b),s(e,q,t),s(e,N,t),s(e,z,t),r(y,e,t),s(e,D,t),r(M,e,t),s(e,A,t),s(e,w,t),s(e,P,t),s(e,J,t),s(e,K,t),s(e,U,t),s(e,O,t),r(Z,e,t),s(e,ee,t),r(T,e,t),s(e,te,t),s(e,j,t),s(e,le,t),r($,e,t),s(e,se,t),s(e,W,t),s(e,ae,t),r(G,e,t),s(e,ie,t),r(v,e,t),s(e,ne,t),s(e,_,t),s(e,oe,t),s(e,k,t),s(e,pe,t),r(x,e,t),s(e,me,t),s(e,g,t),s(e,re,t),r(B,e,t),s(e,ue,t),s(e,X,t),s(e,ce,t),r(Y,e,t),s(e,de,t),s(e,h,t),s(e,fe,t),r(F,e,t),s(e,be,t),s(e,R,t),s(e,ge,t),r(S,e,t),s(e,he,t),s(e,I,t),s(e,ye,t),r(C,e,t),s(e,Me,t),s(e,V,t),s(e,we,t),r(H,e,t),s(e,Je,t),s(e,L,t),Ue=!0},p:Ce,i(e){Ue||(u(y.$$.fragment,e),u(M.$$.fragment,e),u(Z.$$.fragment,e),u(T.$$.fragment,e),u($.$$.fragment,e),u(G.$$.fragment,e),u(v.$$.fragment,e),u(x.$$.fragment,e),u(B.$$.fragment,e),u(Y.$$.fragment,e),u(F.$$.fragment,e),u(S.$$.fragment,e),u(C.$$.fragment,e),u(H.$$.fragment,e),Ue=!0)},o(e){c(y.$$.fragment,e),c(M.$$.fragment,e),c(Z.$$.fragment,e),c(T.$$.fragment,e),c($.$$.fragment,e),c(G.$$.fragment,e),c(v.$$.fragment,e),c(x.$$.fragment,e),c(B.$$.fragment,e),c(Y.$$.fragment,e),c(F.$$.fragment,e),c(S.$$.fragment,e),c(C.$$.fragment,e),c(H.$$.fragment,e),Ue=!1},d(e){e&&(l(q),l(N),l(z),l(D),l(A),l(w),l(P),l(J),l(K),l(U),l(O),l(ee),l(te),l(j),l(le),l(se),l(W),l(ae),l(ie),l(ne),l(_),l(oe),l(k),l(pe),l(me),l(g),l(re),l(ue),l(X),l(ce),l(de),l(h),l(fe),l(be),l(R),l(ge),l(he),l(I),l(ye),l(Me),l(V),l(we),l(Je),l(L)),l(b),d(y,e),d(M,e),d(Z,e),d(T,e),d($,e),d(G,e),d(v,e),d(x,e),d(B,e),d(Y,e),d(F,e),d(S,e),d(C,e),d(H,e)}}}const De='{"title":"Stable Diffusion XL Turbo","local":"stable-diffusion-xl-turbo","sections":[{"title":"Load model checkpoints","local":"load-model-checkpoints","sections":[],"depth":2},{"title":"Text-to-image","local":"text-to-image","sections":[],"depth":2},{"title":"Image-to-image","local":"image-to-image","sections":[],"depth":2},{"title":"Speed-up SDXL Turbo even more","local":"speed-up-sdxl-turbo-even-more","sections":[],"depth":2}],"depth":1}';function Ae(Te){return Ve(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lt extends He{constructor(b){super(),Qe(this,b,Ae,ze,Ie,{})}}export{lt as component};
