import{s as te,n as ae,o as le}from"../chunks/scheduler.22bf70d2.js";import{S as se,i as ce,g as n,s,r as W,A as ne,h as o,f as a,c,j as q,u as F,x as f,k as D,y as oe,a as l,v as V,d as E,t as N,w as S}from"../chunks/index.59178e06.js";import{C as O}from"../chunks/CodeBlock.f7047b13.js";import{H as ee}from"../chunks/Heading.f8746c79.js";function re(z){let r,B,J,_,i,T,p,H=`When training a PyTorch model with 🤗 Accelerate, you may often want to save and continue a state of training. Doing so requires
saving and loading the model, optimizer, RNG generators, and the GradScaler. Inside 🤗 Accelerate are two convenience functions to achieve this quickly:`,v,M,Q='<li>Use <a href="/docs/accelerate/v0.29.1/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> for saving everything mentioned above to a folder location</li> <li>Use <a href="/docs/accelerate/v0.29.1/en/package_reference/accelerator#accelerate.Accelerator.load_state">load_state()</a> for loading everything stored from an earlier <code>save_state</code></li>',k,d,$=`To further customize where and how states are saved through <a href="/docs/accelerate/v0.29.1/en/package_reference/accelerator#accelerate.Accelerator.save_state">save_state()</a> the <a href="/docs/accelerate/v0.29.1/en/package_reference/utilities#accelerate.utils.ProjectConfiguration">ProjectConfiguration</a> class can be used. For example
if <code>automatic_checkpoint_naming</code> is enabled each saved checkpoint will be located then at <code>Accelerator.project_dir/checkpoints/checkpoint_{checkpoint_number}</code>.`,G,h,x="It should be noted that the expectation is that those states come from the same training script, they should not be from two separate scripts.",Z,m,L=`<li>By using <a href="/docs/accelerate/v0.29.1/en/package_reference/accelerator#accelerate.Accelerator.register_for_checkpointing">register_for_checkpointing()</a>, you can register custom objects to be automatically stored or loaded from the two prior functions,
so long as the object has a <code>state_dict</code> <strong>and</strong> a <code>load_state_dict</code> functionality. This could include objects such as a learning rate scheduler.</li>`,X,y,K="Below is a brief example using checkpointing to save and reload a state during training:",g,j,Y,w,R,u,P=`After resuming from a checkpoint, it may also be desirable to resume from a particular point in the active <code>DataLoader</code> if
the state was saved during the middle of an epoch. You can use <a href="/docs/accelerate/v0.29.1/en/package_reference/accelerator#accelerate.Accelerator.skip_first_batches">skip_first_batches()</a> to do so.`,I,U,C,b,A;return i=new ee({props:{title:"Checkpointing",local:"checkpointing",headingTag:"h1"}}),j=new O({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQWltcG9ydCUyMHRvcmNoJTBBJTBBYWNjZWxlcmF0b3IlMjAlM0QlMjBBY2NlbGVyYXRvcihwcm9qZWN0X2RpciUzRCUyMm15JTJGc2F2ZSUyRnBhdGglMjIpJTBBJTBBbXlfc2NoZWR1bGVyJTIwJTNEJTIwdG9yY2gub3B0aW0ubHJfc2NoZWR1bGVyLlN0ZXBMUihteV9vcHRpbWl6ZXIlMkMlMjBzdGVwX3NpemUlM0QxJTJDJTIwZ2FtbWElM0QwLjk5KSUwQW15X21vZGVsJTJDJTIwbXlfb3B0aW1pemVyJTJDJTIwbXlfdHJhaW5pbmdfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnByZXBhcmUobXlfbW9kZWwlMkMlMjBteV9vcHRpbWl6ZXIlMkMlMjBteV90cmFpbmluZ19kYXRhbG9hZGVyKSUwQSUwQSUyMyUyMFJlZ2lzdGVyJTIwdGhlJTIwTFIlMjBzY2hlZHVsZXIlMEFhY2NlbGVyYXRvci5yZWdpc3Rlcl9mb3JfY2hlY2twb2ludGluZyhteV9zY2hlZHVsZXIpJTBBJTBBJTIzJTIwU2F2ZSUyMHRoZSUyMHN0YXJ0aW5nJTIwc3RhdGUlMEFhY2NlbGVyYXRvci5zYXZlX3N0YXRlKCklMEElMEFkZXZpY2UlMjAlM0QlMjBhY2NlbGVyYXRvci5kZXZpY2UlMEFteV9tb2RlbC50byhkZXZpY2UpJTBBJTBBJTIzJTIwUGVyZm9ybSUyMHRyYWluaW5nJTBBZm9yJTIwZXBvY2glMjBpbiUyMHJhbmdlKG51bV9lcG9jaHMpJTNBJTBBJTIwJTIwJTIwJTIwZm9yJTIwYmF0Y2glMjBpbiUyMG15X3RyYWluaW5nX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBteV9vcHRpbWl6ZXIuemVyb19ncmFkKCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMkMlMjB0YXJnZXRzJTIwJTNEJTIwYmF0Y2glMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBpbnB1dHMlMjAlM0QlMjBpbnB1dHMudG8oZGV2aWNlKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHRhcmdldHMlMjAlM0QlMjB0YXJnZXRzLnRvKGRldmljZSklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBvdXRwdXRzJTIwJTNEJTIwbXlfbW9kZWwoaW5wdXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGxvc3MlMjAlM0QlMjBteV9sb3NzX2Z1bmN0aW9uKG91dHB1dHMlMkMlMjB0YXJnZXRzKSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMGFjY2VsZXJhdG9yLmJhY2t3YXJkKGxvc3MpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbXlfb3B0aW1pemVyLnN0ZXAoKSUwQSUyMCUyMCUyMCUyMG15X3NjaGVkdWxlci5zdGVwKCklMEElMEElMjMlMjBSZXN0b3JlJTIwdGhlJTIwcHJldmlvdXMlMjBzdGF0ZSUwQWFjY2VsZXJhdG9yLmxvYWRfc3RhdGUoJTIybXklMkZzYXZlJTJGcGF0aCUyRmNoZWNrcG9pbnRpbmclMkZjaGVja3BvaW50XzAlMjIp",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator
<span class="hljs-keyword">import</span> torch

accelerator = Accelerator(project_dir=<span class="hljs-string">&quot;my/save/path&quot;</span>)

my_scheduler = torch.optim.lr_scheduler.StepLR(my_optimizer, step_size=<span class="hljs-number">1</span>, gamma=<span class="hljs-number">0.99</span>)
my_model, my_optimizer, my_training_dataloader = accelerator.prepare(my_model, my_optimizer, my_training_dataloader)

<span class="hljs-comment"># Register the LR scheduler</span>
accelerator.register_for_checkpointing(my_scheduler)

<span class="hljs-comment"># Save the starting state</span>
accelerator.save_state()

device = accelerator.device
my_model.to(device)

<span class="hljs-comment"># Perform training</span>
<span class="hljs-keyword">for</span> epoch <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(num_epochs):
    <span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> my_training_dataloader:
        my_optimizer.zero_grad()
        inputs, targets = batch
        inputs = inputs.to(device)
        targets = targets.to(device)
        outputs = my_model(inputs)
        loss = my_loss_function(outputs, targets)
        accelerator.backward(loss)
        my_optimizer.step()
    my_scheduler.step()

<span class="hljs-comment"># Restore the previous state</span>
accelerator.load_state(<span class="hljs-string">&quot;my/save/path/checkpointing/checkpoint_0&quot;</span>)`,wrap:!1}}),w=new ee({props:{title:"Restoring the state of the DataLoader",local:"restoring-the-state-of-the-dataloader",headingTag:"h2"}}),U=new O({props:{code:"ZnJvbSUyMGFjY2VsZXJhdGUlMjBpbXBvcnQlMjBBY2NlbGVyYXRvciUwQSUwQWFjY2VsZXJhdG9yJTIwJTNEJTIwQWNjZWxlcmF0b3IocHJvamVjdF9kaXIlM0QlMjJteSUyRnNhdmUlMkZwYXRoJTIyKSUwQSUwQXRyYWluX2RhdGFsb2FkZXIlMjAlM0QlMjBhY2NlbGVyYXRvci5wcmVwYXJlKHRyYWluX2RhdGFsb2FkZXIpJTBBYWNjZWxlcmF0b3IubG9hZF9zdGF0ZSglMjJteV9zdGF0ZSUyMiklMEElMEElMjMlMjBBc3N1bWUlMjB0aGUlMjBjaGVja3BvaW50JTIwd2FzJTIwc2F2ZWQlMjAxMDAlMjBzdGVwcyUyMGludG8lMjB0aGUlMjBlcG9jaCUwQXNraXBwZWRfZGF0YWxvYWRlciUyMCUzRCUyMGFjY2VsZXJhdG9yLnNraXBfZmlyc3RfYmF0Y2hlcyh0cmFpbl9kYXRhbG9hZGVyJTJDJTIwMTAwKSUwQSUwQSUyMyUyMEFmdGVyJTIwdGhlJTIwZmlyc3QlMjBpdGVyYXRpb24lMkMlMjBnbyUyMGJhY2slMjB0byUyMCU2MHRyYWluX2RhdGFsb2FkZXIlNjAlMEElMEElMjMlMjBGaXJzdCUyMGVwb2NoJTBBZm9yJTIwYmF0Y2glMjBpbiUyMHNraXBwZWRfZGF0YWxvYWRlciUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMERvJTIwc29tZXRoaW5nJTBBJTIwJTIwJTIwJTIwcGFzcyUwQSUwQSUyMyUyMFNlY29uZCUyMGVwb2NoJTBBZm9yJTIwYmF0Y2glMjBpbiUyMHRyYWluX2RhdGFsb2FkZXIlM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBEbyUyMHNvbWV0aGluZyUwQSUyMCUyMCUyMCUyMHBhc3M=",highlighted:`<span class="hljs-keyword">from</span> accelerate <span class="hljs-keyword">import</span> Accelerator

accelerator = Accelerator(project_dir=<span class="hljs-string">&quot;my/save/path&quot;</span>)

train_dataloader = accelerator.prepare(train_dataloader)
accelerator.load_state(<span class="hljs-string">&quot;my_state&quot;</span>)

<span class="hljs-comment"># Assume the checkpoint was saved 100 steps into the epoch</span>
skipped_dataloader = accelerator.skip_first_batches(train_dataloader, <span class="hljs-number">100</span>)

<span class="hljs-comment"># After the first iteration, go back to \`train_dataloader\`</span>

<span class="hljs-comment"># First epoch</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> skipped_dataloader:
    <span class="hljs-comment"># Do something</span>
    <span class="hljs-keyword">pass</span>

<span class="hljs-comment"># Second epoch</span>
<span class="hljs-keyword">for</span> batch <span class="hljs-keyword">in</span> train_dataloader:
    <span class="hljs-comment"># Do something</span>
    <span class="hljs-keyword">pass</span>`,wrap:!1}}),{c(){r=n("meta"),B=s(),J=n("p"),_=s(),W(i.$$.fragment),T=s(),p=n("p"),p.textContent=H,v=s(),M=n("ul"),M.innerHTML=Q,k=s(),d=n("p"),d.innerHTML=$,G=s(),h=n("p"),h.textContent=x,Z=s(),m=n("ul"),m.innerHTML=L,X=s(),y=n("p"),y.textContent=K,g=s(),W(j.$$.fragment),Y=s(),W(w.$$.fragment),R=s(),u=n("p"),u.innerHTML=P,I=s(),W(U.$$.fragment),C=s(),b=n("p"),this.h()},l(e){const t=ne("svelte-u9bgzb",document.head);r=o(t,"META",{name:!0,content:!0}),t.forEach(a),B=c(e),J=o(e,"P",{}),q(J).forEach(a),_=c(e),F(i.$$.fragment,e),T=c(e),p=o(e,"P",{"data-svelte-h":!0}),f(p)!=="svelte-1s6ik36"&&(p.textContent=H),v=c(e),M=o(e,"UL",{"data-svelte-h":!0}),f(M)!=="svelte-1e9dj4t"&&(M.innerHTML=Q),k=c(e),d=o(e,"P",{"data-svelte-h":!0}),f(d)!=="svelte-1xfoije"&&(d.innerHTML=$),G=c(e),h=o(e,"P",{"data-svelte-h":!0}),f(h)!=="svelte-iddkef"&&(h.textContent=x),Z=c(e),m=o(e,"UL",{"data-svelte-h":!0}),f(m)!=="svelte-dg5ro4"&&(m.innerHTML=L),X=c(e),y=o(e,"P",{"data-svelte-h":!0}),f(y)!=="svelte-3hrue1"&&(y.textContent=K),g=c(e),F(j.$$.fragment,e),Y=c(e),F(w.$$.fragment,e),R=c(e),u=o(e,"P",{"data-svelte-h":!0}),f(u)!=="svelte-11utsz8"&&(u.innerHTML=P),I=c(e),F(U.$$.fragment,e),C=c(e),b=o(e,"P",{}),q(b).forEach(a),this.h()},h(){D(r,"name","hf:doc:metadata"),D(r,"content",ie)},m(e,t){oe(document.head,r),l(e,B,t),l(e,J,t),l(e,_,t),V(i,e,t),l(e,T,t),l(e,p,t),l(e,v,t),l(e,M,t),l(e,k,t),l(e,d,t),l(e,G,t),l(e,h,t),l(e,Z,t),l(e,m,t),l(e,X,t),l(e,y,t),l(e,g,t),V(j,e,t),l(e,Y,t),V(w,e,t),l(e,R,t),l(e,u,t),l(e,I,t),V(U,e,t),l(e,C,t),l(e,b,t),A=!0},p:ae,i(e){A||(E(i.$$.fragment,e),E(j.$$.fragment,e),E(w.$$.fragment,e),E(U.$$.fragment,e),A=!0)},o(e){N(i.$$.fragment,e),N(j.$$.fragment,e),N(w.$$.fragment,e),N(U.$$.fragment,e),A=!1},d(e){e&&(a(B),a(J),a(_),a(T),a(p),a(v),a(M),a(k),a(d),a(G),a(h),a(Z),a(m),a(X),a(y),a(g),a(Y),a(R),a(u),a(I),a(C),a(b)),a(r),S(i,e),S(j,e),S(w,e),S(U,e)}}}const ie='{"title":"Checkpointing","local":"checkpointing","sections":[{"title":"Restoring the state of the DataLoader","local":"restoring-the-state-of-the-dataloader","sections":[],"depth":2}],"depth":1}';function pe(z){return le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ye extends se{constructor(r){super(),ce(this,r,pe,re,te,{})}}export{ye as component};
