import{s as Ye,n as Se,o as Le}from"../chunks/scheduler.389d799c.js";import{S as qe,i as Fe,g as r,s as n,r as p,A as De,h as m,f as t,c as a,j as Ae,u as i,x as u,k as Qe,y as Pe,a as s,v as M,d as J,t as o,w as T}from"../chunks/index.8f81d18f.js";import{C as L}from"../chunks/CodeBlock.c0898180.js";import{H as w,E as Ke}from"../chunks/index.0c3503fb.js";function Oe($e){let y,D,q,P,c,K,d,Ce='<a href="https://githubtocolab.com/dylanebert/ml-for-3d-course-notebooks/blob/main/capstone.ipynb" rel="nofollow"><img src="https://colab.research.google.com/assets/colab-badge.svg" alt="Open In Colab"/></a>',O,h,ke="The first open is to run in a Colab notebook. This is the easiest way to validate the code quickly.",ee,f,le,U,We="<li>Click the “Open in Colab” button above.</li> <li>Change the runtime type to GPU.</li> <li>Scroll down to the <code>Run in this notebook section</code>.</li>",te,b,se,j,Re="Start by installing dependencies.",ne,I,ae,Z,Xe="Then, run the demo code. This is exactly the same as in the space <code>app.py</code>. To ensure your model is working as expected, replace both instances of <code>dylanebert/LGM-full</code> with your <code>{username}/{model_name}</code>. Then, run the code.",pe,g,ie,G,Me,B,Ve="Let’s break down the demo code.",Je,$,oe,C,Ne="Import the required libraries.",Te,k,re,W,me,R,ve='For the gaussian splatting step of LGM, we need to install a custom wheel. This is a workaround for the space to run on <a href="https://huggingface.co/zero-gpu-explorers" rel="nofollow">ZeroGPU</a>.',ue,X,ye,V,we,N,Ee='Construct the <a href="https://huggingface.co/dylanebert/LGM-full" rel="nofollow">LGM</a> pipeline. Replace <code>dylanebert/LGM-full</code> with your <code>{username}/{model_name}</code>.',ce,v,de,E,he,x,xe="Define the run function that takes an image and returns a ply file.",fe,H,He="<li>Convert the image to a numpy array and normalize it to [0, 1].</li> <li>Run the pipeline with the default parameters.</li> <li>Save the ply file to <code>/tmp/output.ply</code>.</li> <li>Return the ply file.</li>",Ue,_,be,z,je,A,_e='Create the demo using <a href="https://www.gradio.app/guides/quickstart" rel="nofollow">Gradio</a>, which handles the UI for us.',Ie,Q,Ze,Y,ze='<img src="https://huggingface.co/datasets/dylanebert/ml-for-3d-course/resolve/main/lgm-tiny.png" alt="LGM Tiny Demo"/>',ge,S,Ge,F,Be;return c=new w({props:{title:"Run in notebook",local:"run-in-notebook",headingTag:"h1"}}),f=new w({props:{title:"Setup",local:"setup",headingTag:"h2"}}),b=new w({props:{title:"Run the demo",local:"run-the-demo",headingTag:"h2"}}),I=new L({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtciUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZkeWxhbmViZXJ0JTJGTEdNLXRpbnklMkZyYXclMkZtYWluJTJGcmVxdWlyZW1lbnRzLnR4dA==",highlighted:"!pip install -r https://huggingface.co/spaces/dylanebert/LGM-tiny/raw/main/requirements.txt",wrap:!1}}),g=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> shlex
<span class="hljs-keyword">import</span> subprocess

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline

subprocess.run(
    shlex.split(
        <span class="hljs-string">&quot;pip install https://huggingface.co/spaces/dylanebert/LGM-mini/resolve/main/wheel/diff_gaussian_rasterization-0.0.0-cp310-cp310-linux_x86_64.whl&quot;</span>
    )
)

pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;dylanebert/LGM-full&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;dylanebert/LGM-full&quot;</span>,
    torch_dtype=torch.float16,
    trust_remote_code=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)


<span class="hljs-keyword">def</span> <span class="hljs-title function_">run</span>(<span class="hljs-params">image</span>):
    input_image = np.array(image, dtype=np.float32) / <span class="hljs-number">255.0</span>
    splat = pipeline(
        <span class="hljs-string">&quot;&quot;</span>, input_image, guidance_scale=<span class="hljs-number">5</span>, num_inference_steps=<span class="hljs-number">30</span>, elevation=<span class="hljs-number">0</span>
    )
    splat_file = <span class="hljs-string">&quot;/tmp/output.ply&quot;</span>
    pipeline.save_ply(splat, splat_file)
    <span class="hljs-keyword">return</span> splat_file


demo = gr.Interface(
    fn=run,
    title=<span class="hljs-string">&quot;LGM Tiny&quot;</span>,
    description=<span class="hljs-string">&quot;An extremely simplified version of [LGM](https://huggingface.co/ashawkey/LGM). Intended as resource for the [ML for 3D Course](https://huggingface.co/learn/ml-for-3d-course/unit0/introduction).&quot;</span>,
    inputs=<span class="hljs-string">&quot;image&quot;</span>,
    outputs=gr.Model3D(),
    examples=[
        <span class="hljs-string">&quot;https://huggingface.co/datasets/dylanebert/iso3d/resolve/main/jpg@512/a_cat_statue.jpg&quot;</span>
    ],
    cache_examples=<span class="hljs-literal">True</span>,
    allow_duplication=<span class="hljs-literal">True</span>,
)
demo.queue().launch()`,wrap:!1}}),G=new w({props:{title:"Demo breakdown",local:"demo-breakdown",headingTag:"h2"}}),$=new w({props:{title:"Import dependencies",local:"import-dependencies",headingTag:"h3"}}),k=new L({props:{code:"aW1wb3J0JTIwc2hsZXglMEFpbXBvcnQlMjBzdWJwcm9jZXNzJTBBJTBBaW1wb3J0JTIwZ3JhZGlvJTIwYXMlMjBnciUwQWltcG9ydCUyMG51bXB5JTIwYXMlMjBucCUwQWltcG9ydCUyMHNwYWNlcyUwQWltcG9ydCUyMHRvcmNoJTBBZnJvbSUyMGRpZmZ1c2VycyUyMGltcG9ydCUyMERpZmZ1c2lvblBpcGVsaW5l",highlighted:`<span class="hljs-keyword">import</span> shlex
<span class="hljs-keyword">import</span> subprocess

<span class="hljs-keyword">import</span> gradio <span class="hljs-keyword">as</span> gr
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> spaces
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> DiffusionPipeline`,wrap:!1}}),W=new w({props:{title:"Install diff-gaussian-rasterization",local:"install-diff-gaussian-rasterization",headingTag:"h3"}}),X=new L({props:{code:"c3VicHJvY2Vzcy5ydW4oJTBBJTIwJTIwJTIwJTIwc2hsZXguc3BsaXQoJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIycGlwJTIwaW5zdGFsbCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZzcGFjZXMlMkZkeWxhbmViZXJ0JTJGTEdNLW1pbmklMkZyZXNvbHZlJTJGbWFpbiUyRndoZWVsJTJGZGlmZl9nYXVzc2lhbl9yYXN0ZXJpemF0aW9uLTAuMC4wLWNwMzEwLWNwMzEwLWxpbnV4X3g4Nl82NC53aGwlMjIlMEElMjAlMjAlMjAlMjApJTBBKQ==",highlighted:`subprocess.run(
    shlex.split(
        <span class="hljs-string">&quot;pip install https://huggingface.co/spaces/dylanebert/LGM-mini/resolve/main/wheel/diff_gaussian_rasterization-0.0.0-cp310-cp310-linux_x86_64.whl&quot;</span>
    )
)`,wrap:!1}}),V=new w({props:{title:"Construct the pipeline",local:"construct-the-pipeline",headingTag:"h3"}}),v=new L({props:{code:"cGlwZWxpbmUlMjAlM0QlMjBEaWZmdXNpb25QaXBlbGluZS5mcm9tX3ByZXRyYWluZWQoJTBBJTIwJTIwJTIwJTIwJTIyZHlsYW5lYmVydCUyRkxHTS1mdWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwY3VzdG9tX3BpcGVsaW5lJTNEJTIyZHlsYW5lYmVydCUyRkxHTS1mdWxsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9yY2hfZHR5cGUlM0R0b3JjaC5mbG9hdDE2JTJDJTBBJTIwJTIwJTIwJTIwdHJ1c3RfcmVtb3RlX2NvZGUlM0RUcnVlJTJDJTBBKS50byglMjJjdWRhJTIyKQ==",highlighted:`pipeline = DiffusionPipeline.from_pretrained(
    <span class="hljs-string">&quot;dylanebert/LGM-full&quot;</span>,
    custom_pipeline=<span class="hljs-string">&quot;dylanebert/LGM-full&quot;</span>,
    torch_dtype=torch.float16,
    trust_remote_code=<span class="hljs-literal">True</span>,
).to(<span class="hljs-string">&quot;cuda&quot;</span>)`,wrap:!1}}),E=new w({props:{title:"Define the run function",local:"define-the-run-function",headingTag:"h3"}}),_=new L({props:{code:"JTQwc3BhY2VzLkdQVSUwQWRlZiUyMHJ1bihpbWFnZSklM0ElMEElMjAlMjAlMjAlMjBpbnB1dF9pbWFnZSUyMCUzRCUyMG5wLmFycmF5KGltYWdlJTJDJTIwZHR5cGUlM0RucC5mbG9hdDMyKSUyMCUyRiUyMDI1NS4wJTBBJTIwJTIwJTIwJTIwc3BsYXQlMjAlM0QlMjBwaXBlbGluZSglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjIlMjIlMkMlMjBpbnB1dF9pbWFnZSUyQyUyMGd1aWRhbmNlX3NjYWxlJTNENSUyQyUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QzMCUyQyUyMGVsZXZhdGlvbiUzRDAlMEElMjAlMjAlMjAlMjApJTBBJTIwJTIwJTIwJTIwc3BsYXRfZmlsZSUyMCUzRCUyMCUyMiUyRnRtcCUyRm91dHB1dC5wbHklMjIlMEElMjAlMjAlMjAlMjBwaXBlbGluZS5zYXZlX3BseShzcGxhdCUyQyUyMHNwbGF0X2ZpbGUpJTBBJTIwJTIwJTIwJTIwcmV0dXJuJTIwc3BsYXRfZmlsZQ==",highlighted:`<span class="hljs-meta">@spaces.GPU</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">run</span>(<span class="hljs-params">image</span>):
    input_image = np.array(image, dtype=np.float32) / <span class="hljs-number">255.0</span>
    splat = pipeline(
        <span class="hljs-string">&quot;&quot;</span>, input_image, guidance_scale=<span class="hljs-number">5</span>, num_inference_steps=<span class="hljs-number">30</span>, elevation=<span class="hljs-number">0</span>
    )
    splat_file = <span class="hljs-string">&quot;/tmp/output.ply&quot;</span>
    pipeline.save_ply(splat, splat_file)
    <span class="hljs-keyword">return</span> splat_file`,wrap:!1}}),z=new w({props:{title:"Create the demo",local:"create-the-demo",headingTag:"h3"}}),Q=new L({props:{code:"ZGVtbyUyMCUzRCUyMGdyLkludGVyZmFjZSglMEElMjAlMjAlMjAlMjBmbiUzRHJ1biUyQyUwQSUyMCUyMCUyMCUyMHRpdGxlJTNEJTIyTEdNJTIwVGlueSUyMiUyQyUwQSUyMCUyMCUyMCUyMGRlc2NyaXB0aW9uJTNEJTIyQW4lMjBleHRyZW1lbHklMjBzaW1wbGlmaWVkJTIwdmVyc2lvbiUyMG9mJTIwJTVCTEdNJTVEKGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZhc2hhd2tleSUyRkxHTSkuJTIwSW50ZW5kZWQlMjBhcyUyMHJlc291cmNlJTIwZm9yJTIwdGhlJTIwJTVCTUwlMjBmb3IlMjAzRCUyMENvdXJzZSU1RChodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGbGVhcm4lMkZtbC1mb3ItM2QtY291cnNlJTJGdW5pdDAlMkZpbnRyb2R1Y3Rpb24pLiUyMiUyQyUwQSUyMCUyMCUyMCUyMGlucHV0cyUzRCUyMmltYWdlJTIyJTJDJTBBJTIwJTIwJTIwJTIwb3V0cHV0cyUzRGdyLk1vZGVsM0QoKSUyQyUwQSUyMCUyMCUyMCUyMGV4YW1wbGVzJTNEJTVCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGZHlsYW5lYmVydCUyRmlzbzNkJTJGcmVzb2x2ZSUyRm1haW4lMkZqcGclNDA1MTIlMkZhX2NhdF9zdGF0dWUuanBnJTIyJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwY2FjaGVfZXhhbXBsZXMlM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwYWxsb3dfZHVwbGljYXRpb24lM0RUcnVlJTJDJTBBKSUwQWRlbW8ucXVldWUoKS5sYXVuY2goKQ==",highlighted:`demo = gr.Interface(
    fn=run,
    title=<span class="hljs-string">&quot;LGM Tiny&quot;</span>,
    description=<span class="hljs-string">&quot;An extremely simplified version of [LGM](https://huggingface.co/ashawkey/LGM). Intended as resource for the [ML for 3D Course](https://huggingface.co/learn/ml-for-3d-course/unit0/introduction).&quot;</span>,
    inputs=<span class="hljs-string">&quot;image&quot;</span>,
    outputs=gr.Model3D(),
    examples=[
        <span class="hljs-string">&quot;https://huggingface.co/datasets/dylanebert/iso3d/resolve/main/jpg@512/a_cat_statue.jpg&quot;</span>
    ],
    cache_examples=<span class="hljs-literal">True</span>,
    allow_duplication=<span class="hljs-literal">True</span>,
)
demo.queue().launch()`,wrap:!1}}),S=new Ke({props:{source:"https://github.com/huggingface/ml-for-3d-course/blob/main/units/en/unit5/run-in-notebook.mdx"}}),{c(){y=r("meta"),D=n(),q=r("p"),P=n(),p(c.$$.fragment),K=n(),d=r("p"),d.innerHTML=Ce,O=n(),h=r("p"),h.textContent=ke,ee=n(),p(f.$$.fragment),le=n(),U=r("ol"),U.innerHTML=We,te=n(),p(b.$$.fragment),se=n(),j=r("p"),j.textContent=Re,ne=n(),p(I.$$.fragment),ae=n(),Z=r("p"),Z.innerHTML=Xe,pe=n(),p(g.$$.fragment),ie=n(),p(G.$$.fragment),Me=n(),B=r("p"),B.textContent=Ve,Je=n(),p($.$$.fragment),oe=n(),C=r("p"),C.textContent=Ne,Te=n(),p(k.$$.fragment),re=n(),p(W.$$.fragment),me=n(),R=r("p"),R.innerHTML=ve,ue=n(),p(X.$$.fragment),ye=n(),p(V.$$.fragment),we=n(),N=r("p"),N.innerHTML=Ee,ce=n(),p(v.$$.fragment),de=n(),p(E.$$.fragment),he=n(),x=r("p"),x.textContent=xe,fe=n(),H=r("ol"),H.innerHTML=He,Ue=n(),p(_.$$.fragment),be=n(),p(z.$$.fragment),je=n(),A=r("p"),A.innerHTML=_e,Ie=n(),p(Q.$$.fragment),Ze=n(),Y=r("p"),Y.innerHTML=ze,ge=n(),p(S.$$.fragment),Ge=n(),F=r("p"),this.h()},l(e){const l=De("svelte-u9bgzb",document.head);y=m(l,"META",{name:!0,content:!0}),l.forEach(t),D=a(e),q=m(e,"P",{}),Ae(q).forEach(t),P=a(e),i(c.$$.fragment,e),K=a(e),d=m(e,"P",{"data-svelte-h":!0}),u(d)!=="svelte-1yy8ynf"&&(d.innerHTML=Ce),O=a(e),h=m(e,"P",{"data-svelte-h":!0}),u(h)!=="svelte-1a8y28g"&&(h.textContent=ke),ee=a(e),i(f.$$.fragment,e),le=a(e),U=m(e,"OL",{"data-svelte-h":!0}),u(U)!=="svelte-3gf4ec"&&(U.innerHTML=We),te=a(e),i(b.$$.fragment,e),se=a(e),j=m(e,"P",{"data-svelte-h":!0}),u(j)!=="svelte-t8fr6f"&&(j.textContent=Re),ne=a(e),i(I.$$.fragment,e),ae=a(e),Z=m(e,"P",{"data-svelte-h":!0}),u(Z)!=="svelte-16n1p5"&&(Z.innerHTML=Xe),pe=a(e),i(g.$$.fragment,e),ie=a(e),i(G.$$.fragment,e),Me=a(e),B=m(e,"P",{"data-svelte-h":!0}),u(B)!=="svelte-11z254p"&&(B.textContent=Ve),Je=a(e),i($.$$.fragment,e),oe=a(e),C=m(e,"P",{"data-svelte-h":!0}),u(C)!=="svelte-10vnweu"&&(C.textContent=Ne),Te=a(e),i(k.$$.fragment,e),re=a(e),i(W.$$.fragment,e),me=a(e),R=m(e,"P",{"data-svelte-h":!0}),u(R)!=="svelte-1p6m3po"&&(R.innerHTML=ve),ue=a(e),i(X.$$.fragment,e),ye=a(e),i(V.$$.fragment,e),we=a(e),N=m(e,"P",{"data-svelte-h":!0}),u(N)!=="svelte-ddiem2"&&(N.innerHTML=Ee),ce=a(e),i(v.$$.fragment,e),de=a(e),i(E.$$.fragment,e),he=a(e),x=m(e,"P",{"data-svelte-h":!0}),u(x)!=="svelte-4hg4c"&&(x.textContent=xe),fe=a(e),H=m(e,"OL",{"data-svelte-h":!0}),u(H)!=="svelte-ix411w"&&(H.innerHTML=He),Ue=a(e),i(_.$$.fragment,e),be=a(e),i(z.$$.fragment,e),je=a(e),A=m(e,"P",{"data-svelte-h":!0}),u(A)!=="svelte-17ui4qw"&&(A.innerHTML=_e),Ie=a(e),i(Q.$$.fragment,e),Ze=a(e),Y=m(e,"P",{"data-svelte-h":!0}),u(Y)!=="svelte-rd3hkv"&&(Y.innerHTML=ze),ge=a(e),i(S.$$.fragment,e),Ge=a(e),F=m(e,"P",{}),Ae(F).forEach(t),this.h()},h(){Qe(y,"name","hf:doc:metadata"),Qe(y,"content",el)},m(e,l){Pe(document.head,y),s(e,D,l),s(e,q,l),s(e,P,l),M(c,e,l),s(e,K,l),s(e,d,l),s(e,O,l),s(e,h,l),s(e,ee,l),M(f,e,l),s(e,le,l),s(e,U,l),s(e,te,l),M(b,e,l),s(e,se,l),s(e,j,l),s(e,ne,l),M(I,e,l),s(e,ae,l),s(e,Z,l),s(e,pe,l),M(g,e,l),s(e,ie,l),M(G,e,l),s(e,Me,l),s(e,B,l),s(e,Je,l),M($,e,l),s(e,oe,l),s(e,C,l),s(e,Te,l),M(k,e,l),s(e,re,l),M(W,e,l),s(e,me,l),s(e,R,l),s(e,ue,l),M(X,e,l),s(e,ye,l),M(V,e,l),s(e,we,l),s(e,N,l),s(e,ce,l),M(v,e,l),s(e,de,l),M(E,e,l),s(e,he,l),s(e,x,l),s(e,fe,l),s(e,H,l),s(e,Ue,l),M(_,e,l),s(e,be,l),M(z,e,l),s(e,je,l),s(e,A,l),s(e,Ie,l),M(Q,e,l),s(e,Ze,l),s(e,Y,l),s(e,ge,l),M(S,e,l),s(e,Ge,l),s(e,F,l),Be=!0},p:Se,i(e){Be||(J(c.$$.fragment,e),J(f.$$.fragment,e),J(b.$$.fragment,e),J(I.$$.fragment,e),J(g.$$.fragment,e),J(G.$$.fragment,e),J($.$$.fragment,e),J(k.$$.fragment,e),J(W.$$.fragment,e),J(X.$$.fragment,e),J(V.$$.fragment,e),J(v.$$.fragment,e),J(E.$$.fragment,e),J(_.$$.fragment,e),J(z.$$.fragment,e),J(Q.$$.fragment,e),J(S.$$.fragment,e),Be=!0)},o(e){o(c.$$.fragment,e),o(f.$$.fragment,e),o(b.$$.fragment,e),o(I.$$.fragment,e),o(g.$$.fragment,e),o(G.$$.fragment,e),o($.$$.fragment,e),o(k.$$.fragment,e),o(W.$$.fragment,e),o(X.$$.fragment,e),o(V.$$.fragment,e),o(v.$$.fragment,e),o(E.$$.fragment,e),o(_.$$.fragment,e),o(z.$$.fragment,e),o(Q.$$.fragment,e),o(S.$$.fragment,e),Be=!1},d(e){e&&(t(D),t(q),t(P),t(K),t(d),t(O),t(h),t(ee),t(le),t(U),t(te),t(se),t(j),t(ne),t(ae),t(Z),t(pe),t(ie),t(Me),t(B),t(Je),t(oe),t(C),t(Te),t(re),t(me),t(R),t(ue),t(ye),t(we),t(N),t(ce),t(de),t(he),t(x),t(fe),t(H),t(Ue),t(be),t(je),t(A),t(Ie),t(Ze),t(Y),t(ge),t(Ge),t(F)),t(y),T(c,e),T(f,e),T(b,e),T(I,e),T(g,e),T(G,e),T($,e),T(k,e),T(W,e),T(X,e),T(V,e),T(v,e),T(E,e),T(_,e),T(z,e),T(Q,e),T(S,e)}}}const el='{"title":"Run in notebook","local":"run-in-notebook","sections":[{"title":"Setup","local":"setup","sections":[],"depth":2},{"title":"Run the demo","local":"run-the-demo","sections":[],"depth":2},{"title":"Demo breakdown","local":"demo-breakdown","sections":[{"title":"Import dependencies","local":"import-dependencies","sections":[],"depth":3},{"title":"Install diff-gaussian-rasterization","local":"install-diff-gaussian-rasterization","sections":[],"depth":3},{"title":"Construct the pipeline","local":"construct-the-pipeline","sections":[],"depth":3},{"title":"Define the run function","local":"define-the-run-function","sections":[],"depth":3},{"title":"Create the demo","local":"create-the-demo","sections":[],"depth":3}],"depth":2}],"depth":1}';function ll($e){return Le(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class pl extends qe{constructor(y){super(),Fe(this,y,ll,Oe,Ye,{})}}export{pl as component};
