import{s as xs,n as Hs,o as qs}from"../chunks/scheduler.39a43cde.js";import{S as Xs,i as Ys,g as m,s as n,r as p,A as zs,h as r,f as s,c as a,j as _s,u as i,x as u,k as Ss,y as Fs,a as l,v as M,d as o,t as d,w as j}from"../chunks/index.23ec2204.js";import{D as Ls,C as c}from"../chunks/DocNotebookDropdown.21a75b74.js";import{H as h,E as Ds}from"../chunks/EditOnGithub.f2d09226.js";function Ps(as){let y,vt,Qt,Vt,w,_t,T,St,U,ps='<em>Authored by: <a href="https://huggingface.co/derek-thomas" rel="nofollow">Derek Thomas</a></em>',xt,g,Ht,b,is="I have a dataset I want to embed for semantic search (or QA, or RAG), I want the easiest way to do embed this and put it in a new dataset.",qt,J,Xt,f,Ms='I’m using a dataset from my favorite subreddit <a href="https://www.reddit.com/r/bestofredditorupdates/" rel="nofollow">r/bestofredditorupdates</a>. Because it has long entries, I will use the new <a href="https://huggingface.co/jinaai/jina-embeddings-v2-base-en" rel="nofollow">jinaai/jina-embeddings-v2-base-en</a> since it has an 8k context length. I will deploy this using <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a> to save time and money. To follow this tutorial, you will need to <strong>have already added a payment method</strong>. If you haven’t, you can add one here in <a href="https://huggingface.co/docs/hub/billing#billing" rel="nofollow">billing</a>. To make it even easier, I’ll make this fully API based.',Yt,I,os='To make this MUCH faster I will use the <a href="https://github.com/huggingface/text-embeddings-inference" rel="nofollow">Text Embeddings Inference</a> image. This has many benefits like:',zt,$,ds="<li>No model graph compilation step</li> <li>Small docker images and fast boot times. Get ready for true serverless!</li> <li>Token based dynamic batching</li> <li>Optimized transformers code for inference using Flash Attention, Candle and cuBLASLt</li> <li>Safetensors weight loading</li> <li>Production ready (distributed tracing with Open Telemetry, Prometheus metrics)</li>",Ft,A,js='<img src="https://media.githubusercontent.com/media/huggingface/text-embeddings-inference/main/assets/bs1-tp.png" alt="img"/>',Lt,C,Dt,B,Pt,k,Kt,W,Ot,Z,te,G,ms=`<code>DATASET_IN</code> is where your text data is
<code>DATASET_OUT</code> is where your embeddings will be stored`,ee,R,rs="Note I used 5 for the <code>MAX_WORKERS</code> since <code>jina-embeddings-v2</code> are quite memory hungry.",se,E,le,Q,us="Hugging Face offers a number of GPUs that you can choose from a number of GPUs that you can choose in Inference Endpoints. Here they are in table form:",ne,N,cs="<thead><tr><th>GPU</th> <th>instanceType</th> <th>instanceSize</th> <th>vRAM</th></tr></thead> <tbody><tr><td>1x Nvidia Tesla T4</td> <td>g4dn.xlarge</td> <td>small</td> <td>16GB</td></tr> <tr><td>4x Nvidia Tesla T4</td> <td>g4dn.12xlarge</td> <td>large</td> <td>64GB</td></tr> <tr><td>1x Nvidia A10G</td> <td>g5.2xlarge</td> <td>medium</td> <td>24GB</td></tr> <tr><td>4x Nvidia A10G</td> <td>g5.12xlarge</td> <td>xxlarge</td> <td>96GB</td></tr> <tr><td>1x Nvidia A100*</td> <td>p4de</td> <td>xlarge</td> <td>80GB</td></tr> <tr><td>2x Nvidia A100*</td> <td>p4de</td> <td>2xlarge</td> <td>160GB</td></tr></tbody>",ae,v,hs="*Note that for A100s you might get a note to email us to get access.",pe,V,ie,_,Me,S,ys="Some users might have payment registered in an organization. This allows you to connect to an organization (that you are a member of) with a payment method.",oe,x,ws="Leave it blank is you want to use your username.",de,H,je,q,me,X,re,Y,ue,z,ce,F,he,L,Ts='We are going to use the <a href="https://huggingface.co/docs/inference-endpoints/api_reference" rel="nofollow">API</a> to create an <a href="https://huggingface.co/inference-endpoints" rel="nofollow">Inference Endpoint</a>. This should provide a few main benefits:',ye,D,Us="<li>It’s convenient (No clicking)</li> <li>It’s repeatable (We have the code to run it easily)</li> <li>It’s cheaper (No time spent waiting for it to load, and automatically shut it down)</li>",we,P,Te,K,gs="There are a few design choices here:",Ue,O,bs='<li>As discussed before we are using <code>jinaai/jina-embeddings-v2-base-en</code> as our model. <ul><li>For reproducibility we are pinning it to a specific revision.</li></ul></li> <li>If you are interested in more models, check out the supported list <a href="https://huggingface.co/docs/text-embeddings-inference/supported_models" rel="nofollow">here</a>. <ul><li>Note that most embedding models are based on the BERT architecture.</li></ul></li> <li><code>MAX_BATCH_TOKENS</code> is chosen based on our number of workers and the context window of our embedding model.</li> <li><code>type=&quot;protected&quot;</code> utilized the security from Inference Endpoints detailed here.</li> <li>I’m using <strong>1x Nvidia A10</strong> since <code>jina-embeddings-v2</code> is memory hungry (remember the 8k context length).</li> <li>You should consider further tuning <code>MAX_BATCH_TOKENS</code> and <code>MAX_CONCURRENT_REQUESTS</code> if you have high workloads</li>',ge,tt,be,et,Je,st,Js=`CPU times: user 48.1 ms, sys: 15.7 ms, total: 63.8 ms
Wall time: 52.6 s
`,fe,lt,fs="When we use <code>endpoint.client.post</code> we get a bytes string back. This is a little tedious because we need to convert this to an <code>np.array</code>, but it’s just a couple quick lines in python.",Ie,nt,$e,at,Is="You may have inputs that exceed the context. In such scenarios, it’s up to you to handle them. In my case, I’d like to truncate rather than have an error. Let’s test that it works.",Ae,pt,Ce,it,$s=`The length of the embedding_input is: 300000
`,Be,Mt,ke,ot,As="Here I send a document, update it with the embedding, and return it. This happens in parallel with <code>MAX_WORKERS</code>.",We,dt,Ze,jt,Ge,mt,Cs=`Embeddings = 100 documents = 100
0 min 21.33 sec
`,Re,rt,Ee,ut,Bs="Now that we have finished, let’s pause the endpoint so we don’t incur any extra charges, this will also allow us to analyze the cost.",Qe,ct,Ne,ht,ks=`Endpoint Status: paused
`,ve,yt,Ve,wt,Ws="We now have our documents updated with the embeddings we wanted. First we need to convert it back to a <code>Dataset</code> format. I find it easiest to go from list of dicts -&gt; <code>pd.DataFrame</code> -&gt; <code>Dataset</code>",_e,Tt,Se,Ut,Zs="I’m uploading it to the user’s account by default (as opposed to uploading to an organization) but feel free to push to wherever you want by setting the user in the <code>repo_id</code> or in the config by setting <code>DATASET_OUT</code>",xe,gt,He,bt,qe,Jt,Gs=`Dataset is at https://huggingface.co/datasets/derek-thomas/processed-subset-bestofredditorupdates
`,Xe,ft,Ye,It,Rs="<li>Go to your <code>dashboard_url</code> printed below</li> <li>Click on the Usage &amp; Cost tab</li> <li>See how much you have spent</li>",ze,$t,Fe,At,Es=`https://ui.endpoints.huggingface.co/HF-test-lab/endpoints/boru-jina-embeddings-demo-ie
`,Le,Ct,De,Bt,Qs="We can see that it only took <code>$0.04</code> to pay for this!",Pe,kt,Ke,Wt,Ns="Now that we are done, we don’t need our endpoint anymore. We can delete our endpoint programmatically.",Oe,Zt,vs='<img src="https://huggingface.co/datasets/huggingface/cookbook-images/resolve/main/automatic_embedding_tei_inference_endpoints.png" alt="Cost"/>',ts,Gt,es,Rt,Vs=`Endpoint deleted successfully
`,ss,Et,ls,Nt,ns;return w=new Ls({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Google Colab",value:"https://colab.research.google.com/github/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.ipynb"}]}}),T=new h({props:{title:"How to use Inference Endpoints to Embed Documents",local:"how-to-use-inference-endpoints-to-embed-documents",headingTag:"h1"}}),g=new h({props:{title:"Goal",local:"goal",headingTag:"h2"}}),J=new h({props:{title:"Approach",local:"approach",headingTag:"h2"}}),C=new h({props:{title:"Requirements",local:"requirements",headingTag:"h2"}}),B=new c({props:{code:"IXBpcCUyMGluc3RhbGwlMjAtcSUyMGFpb2h0dHAlM0QlM0QzLjguMyUyMGRhdGFzZXRzJTNEJTNEMi4xNC42JTIwcGFuZGFzJTNEJTNEMS41LjMlMjByZXF1ZXN0cyUzRCUzRDIuMzEuMCUyMHRxZG0lM0QlM0Q0LjY2LjElMjBodWdnaW5nZmFjZS1odWIlM0UlM0QwLjIw",highlighted:'!pip install -q aiohttp==<span class="hljs-number">3.8</span><span class="hljs-number">.3</span> datasets==<span class="hljs-number">2.14</span><span class="hljs-number">.6</span> pandas==<span class="hljs-number">1.5</span><span class="hljs-number">.3</span> requests==<span class="hljs-number">2.31</span><span class="hljs-number">.0</span> tqdm==<span class="hljs-number">4.66</span><span class="hljs-number">.1</span> huggingface-hub&gt;=<span class="hljs-number">0.20</span>',wrap:!1}}),k=new h({props:{title:"Imports",local:"imports",headingTag:"h2"}}),W=new c({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQWZyb20lMjBnZXRwYXNzJTIwaW1wb3J0JTIwZ2V0cGFzcyUwQWltcG9ydCUyMGpzb24lMEFmcm9tJTIwcGF0aGxpYiUyMGltcG9ydCUyMFBhdGglMEFpbXBvcnQlMjB0aW1lJTBBZnJvbSUyMHR5cGluZyUyMGltcG9ydCUyME9wdGlvbmFsJTBBJTBBZnJvbSUyMGFpb2h0dHAlMjBpbXBvcnQlMjBDbGllbnRTZXNzaW9uJTJDJTIwQ2xpZW50VGltZW91dCUwQWZyb20lMjBkYXRhc2V0cyUyMGltcG9ydCUyMGxvYWRfZGF0YXNldCUyQyUyMERhdGFzZXQlMkMlMjBEYXRhc2V0RGljdCUwQWZyb20lMjBodWdnaW5nZmFjZV9odWIlMjBpbXBvcnQlMjBub3RlYm9va19sb2dpbiUyQyUyMGNyZWF0ZV9pbmZlcmVuY2VfZW5kcG9pbnQlMkMlMjBsaXN0X2luZmVyZW5jZV9lbmRwb2ludHMlMkMlMjB3aG9hbWklMEFpbXBvcnQlMjBudW1weSUyMGFzJTIwbnAlMEFpbXBvcnQlMjBwYW5kYXMlMjBhcyUyMHBkJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHFkbS5hdXRvJTIwaW1wb3J0JTIwdHFkbQ==",highlighted:`<span class="hljs-keyword">import</span> asyncio
<span class="hljs-keyword">from</span> getpass <span class="hljs-keyword">import</span> getpass
<span class="hljs-keyword">import</span> json
<span class="hljs-keyword">from</span> pathlib <span class="hljs-keyword">import</span> Path
<span class="hljs-keyword">import</span> time
<span class="hljs-keyword">from</span> typing <span class="hljs-keyword">import</span> <span class="hljs-type">Optional</span>

<span class="hljs-keyword">from</span> aiohttp <span class="hljs-keyword">import</span> ClientSession, ClientTimeout
<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset, Dataset, DatasetDict
<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> notebook_login, create_inference_endpoint, list_inference_endpoints, whoami
<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd
<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> tqdm.auto <span class="hljs-keyword">import</span> tqdm`,wrap:!1}}),Z=new h({props:{title:"Config",local:"config",headingTag:"h2"}}),E=new c({props:{code:"REFUQVNFVF9JTiUyMCUzRCUyMCUyMmRlcmVrLXRob21hcyUyRmRhdGFzZXQtY3JlYXRvci1yZWRkaXQtYmVzdG9mcmVkZGl0b3J1cGRhdGVzJTIyJTBBREFUQVNFVF9PVVQlMjAlM0QlMjAlMjJwcm9jZXNzZWQtc3Vic2V0LWJlc3RvZnJlZGRpdG9ydXBkYXRlcyUyMiUwQUVORFBPSU5UX05BTUUlMjAlM0QlMjAlMjJib3J1LWppbmEtZW1iZWRkaW5ncy1kZW1vLWllJTIyJTBBJTBBTUFYX1dPUktFUlMlMjAlM0QlMjA1JTIwJTIwJTIzJTIwVGhpcyUyMGlzJTIwZm9yJTIwaG93JTIwbWFueSUyMGFzeW5jJTIwd29ya2VycyUyMHlvdSUyMHdhbnQuJTIwQ2hvb3NlJTIwYmFzZWQlMjBvbiUyMHRoZSUyMG1vZGVsJTIwYW5kJTIwaGFyZHdhcmUlMEFST1dfQ09VTlQlMjAlM0QlMjAxMDAlMjAlMjAlMjMlMjBDaG9vc2UlMjBOb25lJTIwdG8lMjB1c2UlMjBhbGwlMjByb3dzJTJDJTIwSW0lMjB1c2luZyUyMDEwMCUyMGp1c3QlMjBmb3IlMjBhJTIwZGVtbw==",highlighted:`DATASET_IN = <span class="hljs-string">&quot;derek-thomas/dataset-creator-reddit-bestofredditorupdates&quot;</span>
DATASET_OUT = <span class="hljs-string">&quot;processed-subset-bestofredditorupdates&quot;</span>
ENDPOINT_NAME = <span class="hljs-string">&quot;boru-jina-embeddings-demo-ie&quot;</span>

MAX_WORKERS = <span class="hljs-number">5</span>  <span class="hljs-comment"># This is for how many async workers you want. Choose based on the model and hardware</span>
ROW_COUNT = <span class="hljs-number">100</span>  <span class="hljs-comment"># Choose None to use all rows, Im using 100 just for a demo</span>`,wrap:!1}}),V=new c({props:{code:"JTIzJTIwR1BVJTIwQ2hvaWNlJTBBVkVORE9SJTIwJTNEJTIwJTIyYXdzJTIyJTBBUkVHSU9OJTIwJTNEJTIwJTIydXMtZWFzdC0xJTIyJTBBSU5TVEFOQ0VfU0laRSUyMCUzRCUyMCUyMm1lZGl1bSUyMiUwQUlOU1RBTkNFX1RZUEUlMjAlM0QlMjAlMjJnNS4yeGxhcmdlJTIy",highlighted:`<span class="hljs-comment"># GPU Choice</span>
VENDOR = <span class="hljs-string">&quot;aws&quot;</span>
REGION = <span class="hljs-string">&quot;us-east-1&quot;</span>
INSTANCE_SIZE = <span class="hljs-string">&quot;medium&quot;</span>
INSTANCE_TYPE = <span class="hljs-string">&quot;g5.2xlarge&quot;</span>`,wrap:!1}}),_=new c({props:{code:"bm90ZWJvb2tfbG9naW4oKQ==",highlighted:"notebook_login()",wrap:!1}}),H=new c({props:{code:"d2hvJTIwJTNEJTIwd2hvYW1pKCklMEFvcmdhbml6YXRpb24lMjAlM0QlMjBnZXRwYXNzKHByb21wdCUzRCUyMldoYXQlMjBpcyUyMHlvdXIlMjBIdWdnaW5nJTIwRmFjZSUyMCVGMCU5RiVBNCU5NyUyMHVzZXJuYW1lJTIwb3IlMjBvcmdhbml6YXRpb24lM0YlMjAod2l0aCUyMGFuJTIwYWRkZWQlMjBwYXltZW50JTIwbWV0aG9kKSUyMiklMEElMEFuYW1lc3BhY2UlMjAlM0QlMjBvcmdhbml6YXRpb24lMjBvciUyMHdobyU1QiUyMm5hbWUlMjIlNUQ=",highlighted:`who = whoami()
organization = getpass(prompt=<span class="hljs-string">&quot;What is your Hugging Face 🤗 username or organization? (with an added payment method)&quot;</span>)

namespace = organization <span class="hljs-keyword">or</span> who[<span class="hljs-string">&quot;name&quot;</span>]`,wrap:!1}}),q=new h({props:{title:"Get Dataset",local:"get-dataset",headingTag:"h2"}}),X=new c({props:{code:"ZGF0YXNldCUyMCUzRCUyMGxvYWRfZGF0YXNldChEQVRBU0VUX0lOKSUwQWRhdGFzZXQlNUIlMjJ0cmFpbiUyMiU1RA==",highlighted:`dataset = load_dataset(DATASET_IN)
dataset[<span class="hljs-string">&quot;train&quot;</span>]`,wrap:!1}}),Y=new c({props:{code:"ZG9jdW1lbnRzJTIwJTNEJTIwZGF0YXNldCU1QiUyMnRyYWluJTIyJTVELnRvX3BhbmRhcygpLnRvX2RpY3QoJTIycmVjb3JkcyUyMiklNUIlM0FST1dfQ09VTlQlNUQlMEFsZW4oZG9jdW1lbnRzKSUyQyUyMGRvY3VtZW50cyU1QjAlNUQ=",highlighted:`documents = dataset[<span class="hljs-string">&quot;train&quot;</span>].to_pandas().to_dict(<span class="hljs-string">&quot;records&quot;</span>)[:ROW_COUNT]
<span class="hljs-built_in">len</span>(documents), documents[<span class="hljs-number">0</span>]`,wrap:!1}}),z=new h({props:{title:"Inference Endpoints",local:"inference-endpoints",headingTag:"h1"}}),F=new h({props:{title:"Create Inference Endpoint",local:"create-inference-endpoint",headingTag:"h2"}}),P=new c({props:{code:"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",highlighted:`<span class="hljs-keyword">try</span>:
    endpoint = create_inference_endpoint(
        ENDPOINT_NAME,
        repository=<span class="hljs-string">&quot;jinaai/jina-embeddings-v2-base-en&quot;</span>,
        revision=<span class="hljs-string">&quot;7302ac470bed880590f9344bfeee32ff8722d0e5&quot;</span>,
        task=<span class="hljs-string">&quot;sentence-embeddings&quot;</span>,
        framework=<span class="hljs-string">&quot;pytorch&quot;</span>,
        accelerator=<span class="hljs-string">&quot;gpu&quot;</span>,
        instance_size=INSTANCE_SIZE,
        instance_type=INSTANCE_TYPE,
        region=REGION,
        vendor=VENDOR,
        namespace=namespace,
        custom_image={
            <span class="hljs-string">&quot;health_route&quot;</span>: <span class="hljs-string">&quot;/health&quot;</span>,
            <span class="hljs-string">&quot;env&quot;</span>: {
                <span class="hljs-string">&quot;MAX_BATCH_TOKENS&quot;</span>: <span class="hljs-built_in">str</span>(MAX_WORKERS * <span class="hljs-number">2048</span>),
                <span class="hljs-string">&quot;MAX_CONCURRENT_REQUESTS&quot;</span>: <span class="hljs-string">&quot;512&quot;</span>,
                <span class="hljs-string">&quot;MODEL_ID&quot;</span>: <span class="hljs-string">&quot;/repository&quot;</span>,
            },
            <span class="hljs-string">&quot;url&quot;</span>: <span class="hljs-string">&quot;ghcr.io/huggingface/text-embeddings-inference:0.5.0&quot;</span>,
        },
        <span class="hljs-built_in">type</span>=<span class="hljs-string">&quot;protected&quot;</span>,
    )
<span class="hljs-keyword">except</span>:
    endpoint = [ie <span class="hljs-keyword">for</span> ie <span class="hljs-keyword">in</span> list_inference_endpoints(namespace=namespace) <span class="hljs-keyword">if</span> ie.name == ENDPOINT_NAME][<span class="hljs-number">0</span>]
    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Loaded endpoint&quot;</span>)`,wrap:!1}}),tt=new h({props:{title:"Wait until it’s running",local:"wait-until-its-running",headingTag:"h2"}}),et=new c({props:{code:"JTI1JTI1dGltZSUwQWVuZHBvaW50LndhaXQoKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>%%time
<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint.wait()`,wrap:!1}}),nt=new c({props:{code:"cmVzcG9uc2UlMjAlM0QlMjBlbmRwb2ludC5jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjBqc29uJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIyaW5wdXRzJTIyJTNBJTIwJTIyVGhpcyUyMHNvdW5kJTIwdHJhY2slMjB3YXMlMjBiZWF1dGlmdWwhJTIwSXQlMjBwYWludHMlMjB0aGUlMjBzZW5lcnklMjBpbiUyMHlvdXIlMjBtaW5kJTIwc28lMjB3ZWxsJTIwSSUyMHdvdWxkJTIwcmVjb21lbmQlMjBpdCUyMGV2ZW4lMjB0byUyMHBlb3BsZSUyMHdobyUyMGhhdGUlMjB2aWQuJTIwZ2FtZSUyMG11c2ljISUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMCU3RCUyQyUwQSUyMCUyMCUyMCUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIlMkMlMEEpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`response = endpoint.client.post(
    json={
        <span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;This sound track was beautiful! It paints the senery in your mind so well I would recomend it even to people who hate vid. game music!&quot;</span>,
        <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>,
    },
    task=<span class="hljs-string">&quot;feature-extraction&quot;</span>,
)
response = np.array(json.loads(response.decode()))
response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),pt=new c({props:{code:"ZW1iZWRkaW5nX2lucHV0JTIwJTNEJTIwJTIyVGhpcyUyMGlucHV0JTIwd2lsbCUyMGdldCUyMG11bHRpcGxpZWQlMjIlMjAqJTIwMTAwMDAlMEFwcmludChmJTIyVGhlJTIwbGVuZ3RoJTIwb2YlMjB0aGUlMjBlbWJlZGRpbmdfaW5wdXQlMjBpcyUzQSUyMCU3QmxlbihlbWJlZGRpbmdfaW5wdXQpJTdEJTIyKSUwQXJlc3BvbnNlJTIwJTNEJTIwZW5kcG9pbnQuY2xpZW50LnBvc3QoanNvbiUzRCU3QiUyMmlucHV0cyUyMiUzQSUyMGVtYmVkZGluZ19pbnB1dCUyQyUyMCUyMnRydW5jYXRlJTIyJTNBJTIwVHJ1ZSU3RCUyQyUyMHRhc2slM0QlMjJmZWF0dXJlLWV4dHJhY3Rpb24lMjIpJTBBcmVzcG9uc2UlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3BvbnNlLmRlY29kZSgpKSklMEFyZXNwb25zZSU1QjAlNUQlNUIlM0EyMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>embedding_input = <span class="hljs-string">&quot;This input will get multiplied&quot;</span> * <span class="hljs-number">10000</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;The length of the embedding_input is: <span class="hljs-subst">{<span class="hljs-built_in">len</span>(embedding_input)}</span>&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = endpoint.client.post(json={<span class="hljs-string">&quot;inputs&quot;</span>: embedding_input, <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>response = np.array(json.loads(response.decode()))
<span class="hljs-meta">&gt;&gt;&gt; </span>response[<span class="hljs-number">0</span>][:<span class="hljs-number">20</span>]`,wrap:!1}}),Mt=new h({props:{title:"Get Embeddings",local:"get-embeddings",headingTag:"h1"}}),dt=new c({props:{code:"YXN5bmMlMjBkZWYlMjByZXF1ZXN0KGRvY3VtZW50JTJDJTIwc2VtYXBob3JlKSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMFNlbWFwaG9yZSUyMGd1YXJkJTBBJTIwJTIwJTIwJTIwYXN5bmMlMjB3aXRoJTIwc2VtYXBob3JlJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwcmVzdWx0JTIwJTNEJTIwYXdhaXQlMjBlbmRwb2ludC5hc3luY19jbGllbnQucG9zdCglMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBqc29uJTNEJTdCJTIyaW5wdXRzJTIyJTNBJTIwZG9jdW1lbnQlNUIlMjJjb250ZW50JTIyJTVEJTJDJTIwJTIydHJ1bmNhdGUlMjIlM0ElMjBUcnVlJTdEJTJDJTIwdGFzayUzRCUyMmZlYXR1cmUtZXh0cmFjdGlvbiUyMiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCklMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjByZXN1bHQlMjAlM0QlMjBucC5hcnJheShqc29uLmxvYWRzKHJlc3VsdC5kZWNvZGUoKSkpJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQlMjAlM0QlMjByZXN1bHQlNUIwJTVEJTIwJTIwJTIzJTIwQXNzdW1pbmclMjB0aGUlMjBBUEkncyUyMG91dHB1dCUyMGNhbiUyMGJlJTIwZGlyZWN0bHklMjBhc3NpZ25lZCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHJldHVybiUyMGRvY3VtZW50JTBBJTBBJTBBYXN5bmMlMjBkZWYlMjBtYWluKGRvY3VtZW50cyklM0ElMEElMjAlMjAlMjAlMjAlMjMlMjBTZW1hcGhvcmUlMjB0byUyMGxpbWl0JTIwY29uY3VycmVudCUyMHJlcXVlc3RzLiUyMEFkanVzdCUyMHRoZSUyMG51bWJlciUyMGFzJTIwbmVlZGVkLiUwQSUyMCUyMCUyMCUyMHNlbWFwaG9yZSUyMCUzRCUyMGFzeW5jaW8uQm91bmRlZFNlbWFwaG9yZShNQVhfV09SS0VSUyklMEElMEElMjAlMjAlMjAlMjAlMjMlMjBDcmVhdGluZyUyMGElMjBsaXN0JTIwb2YlMjB0YXNrcyUwQSUyMCUyMCUyMCUyMHRhc2tzJTIwJTNEJTIwJTVCcmVxdWVzdChkb2N1bWVudCUyQyUyMHNlbWFwaG9yZSklMjBmb3IlMjBkb2N1bWVudCUyMGluJTIwZG9jdW1lbnRzJTVEJTBBJTBBJTIwJTIwJTIwJTIwJTIzJTIwVXNpbmclMjB0cWRtJTIwdG8lMjBzaG93JTIwcHJvZ3Jlc3MuJTIwSXQncyUyMGJlZW4lMjBpbnRlZ3JhdGVkJTIwaW50byUyMHRoZSUyMGFzeW5jJTIwbG9vcC4lMEElMjAlMjAlMjAlMjBmb3IlMjBmJTIwaW4lMjB0cWRtKGFzeW5jaW8uYXNfY29tcGxldGVkKHRhc2tzKSUyQyUyMHRvdGFsJTNEbGVuKGRvY3VtZW50cykpJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwYXdhaXQlMjBm",highlighted:`<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">request</span>(<span class="hljs-params">document, semaphore</span>):
    <span class="hljs-comment"># Semaphore guard</span>
    <span class="hljs-keyword">async</span> <span class="hljs-keyword">with</span> semaphore:
        result = <span class="hljs-keyword">await</span> endpoint.async_client.post(
            json={<span class="hljs-string">&quot;inputs&quot;</span>: document[<span class="hljs-string">&quot;content&quot;</span>], <span class="hljs-string">&quot;truncate&quot;</span>: <span class="hljs-literal">True</span>}, task=<span class="hljs-string">&quot;feature-extraction&quot;</span>
        )
        result = np.array(json.loads(result.decode()))
        document[<span class="hljs-string">&quot;embedding&quot;</span>] = result[<span class="hljs-number">0</span>]  <span class="hljs-comment"># Assuming the API&#x27;s output can be directly assigned</span>
        <span class="hljs-keyword">return</span> document


<span class="hljs-keyword">async</span> <span class="hljs-keyword">def</span> <span class="hljs-title function_">main</span>(<span class="hljs-params">documents</span>):
    <span class="hljs-comment"># Semaphore to limit concurrent requests. Adjust the number as needed.</span>
    semaphore = asyncio.BoundedSemaphore(MAX_WORKERS)

    <span class="hljs-comment"># Creating a list of tasks</span>
    tasks = [request(document, semaphore) <span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents]

    <span class="hljs-comment"># Using tqdm to show progress. It&#x27;s been integrated into the async loop.</span>
    <span class="hljs-keyword">for</span> f <span class="hljs-keyword">in</span> tqdm(asyncio.as_completed(tasks), total=<span class="hljs-built_in">len</span>(documents)):
        <span class="hljs-keyword">await</span> f`,wrap:!1}}),jt=new c({props:{code:"c3RhcnQlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTBBJTBBJTIzJTIwR2V0JTIwZW1iZWRkaW5ncyUwQWF3YWl0JTIwbWFpbihkb2N1bWVudHMpJTBBJTBBJTIzJTIwTWFrZSUyMHN1cmUlMjB3ZSUyMGdvdCUyMGl0JTIwYWxsJTBBY291bnQlMjAlM0QlMjAwJTBBZm9yJTIwZG9jdW1lbnQlMjBpbiUyMGRvY3VtZW50cyUzQSUwQSUyMCUyMCUyMCUyMGlmJTIwJTIyZW1iZWRkaW5nJTIyJTIwaW4lMjBkb2N1bWVudC5rZXlzKCklMjBhbmQlMjBsZW4oZG9jdW1lbnQlNUIlMjJlbWJlZGRpbmclMjIlNUQpJTIwJTNEJTNEJTIwNzY4JTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwY291bnQlMjAlMkIlM0QlMjAxJTBBcHJpbnQoZiUyMkVtYmVkZGluZ3MlMjAlM0QlMjAlN0Jjb3VudCU3RCUyMGRvY3VtZW50cyUyMCUzRCUyMCU3Qmxlbihkb2N1bWVudHMpJTdEJTIyKSUwQSUwQSUwQSUyMyUyMFByaW50JTIwZWxhcHNlZCUyMHRpbWUlMEFlbGFwc2VkX3RpbWUlMjAlM0QlMjB0aW1lLnBlcmZfY291bnRlcigpJTIwLSUyMHN0YXJ0JTBBbWludXRlcyUyQyUyMHNlY29uZHMlMjAlM0QlMjBkaXZtb2QoZWxhcHNlZF90aW1lJTJDJTIwNjApJTBBcHJpbnQoZiUyMiU3QmludChtaW51dGVzKSU3RCUyMG1pbiUyMCU3QnNlY29uZHMlM0EuMmYlN0QlMjBzZWMlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>start = time.perf_counter()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">await</span> main(documents)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Make sure we got it all</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>count = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> document <span class="hljs-keyword">in</span> documents:
<span class="hljs-meta">... </span>    <span class="hljs-keyword">if</span> <span class="hljs-string">&quot;embedding&quot;</span> <span class="hljs-keyword">in</span> document.keys() <span class="hljs-keyword">and</span> <span class="hljs-built_in">len</span>(document[<span class="hljs-string">&quot;embedding&quot;</span>]) == <span class="hljs-number">768</span>:
<span class="hljs-meta">... </span>        count += <span class="hljs-number">1</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Embeddings = <span class="hljs-subst">{count}</span> documents = <span class="hljs-subst">{<span class="hljs-built_in">len</span>(documents)}</span>&quot;</span>)


<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print elapsed time</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>elapsed_time = time.perf_counter() - start
<span class="hljs-meta">&gt;&gt;&gt; </span>minutes, seconds = <span class="hljs-built_in">divmod</span>(elapsed_time, <span class="hljs-number">60</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;<span class="hljs-subst">{<span class="hljs-built_in">int</span>(minutes)}</span> min <span class="hljs-subst">{seconds:<span class="hljs-number">.2</span>f}</span> sec&quot;</span>)`,wrap:!1}}),rt=new h({props:{title:"Pause Inference Endpoint",local:"pause-inference-endpoint",headingTag:"h2"}}),ct=new c({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5wYXVzZSgpJTBBJTBBcHJpbnQoZiUyMkVuZHBvaW50JTIwU3RhdHVzJTNBJTIwJTdCZW5kcG9pbnQuc3RhdHVzJTdEJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.pause()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&quot;Endpoint Status: <span class="hljs-subst">{endpoint.status}</span>&quot;</span>)`,wrap:!1}}),yt=new h({props:{title:"Push updated dataset to Hub",local:"push-updated-dataset-to-hub",headingTag:"h1"}}),Tt=new c({props:{code:"ZGYlMjAlM0QlMjBwZC5EYXRhRnJhbWUoZG9jdW1lbnRzKSUwQWRkJTIwJTNEJTIwRGF0YXNldERpY3QoJTdCJTIydHJhaW4lMjIlM0ElMjBEYXRhc2V0LmZyb21fcGFuZGFzKGRmKSU3RCk=",highlighted:`df = pd.DataFrame(documents)
dd = DatasetDict({<span class="hljs-string">&quot;train&quot;</span>: Dataset.from_pandas(df)})`,wrap:!1}}),gt=new c({props:{code:"ZGQucHVzaF90b19odWIocmVwb19pZCUzRERBVEFTRVRfT1VUKQ==",highlighted:"dd.push_to_hub(repo_id=DATASET_OUT)",wrap:!1}}),bt=new c({props:{code:"cHJpbnQoZidEYXRhc2V0JTIwaXMlMjBhdCUyMGh0dHBzJTNBJTJGJTJGaHVnZ2luZ2ZhY2UuY28lMkZkYXRhc2V0cyUyRiU3QndobyU1QiUyMm5hbWUlMjIlNUQlN0QlMkYlN0JEQVRBU0VUX09VVCU3RCcp",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Dataset is at https://huggingface.co/datasets/<span class="hljs-subst">{who[<span class="hljs-string">&quot;name&quot;</span>]}</span>/<span class="hljs-subst">{DATASET_OUT}</span>&#x27;</span>)',wrap:!1}}),ft=new h({props:{title:"Analyze Usage",local:"analyze-usage",headingTag:"h1"}}),$t=new c({props:{code:"ZGFzaGJvYXJkX3VybCUyMCUzRCUyMGYlMjJodHRwcyUzQSUyRiUyRnVpLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbyUyRiU3Qm5hbWVzcGFjZSU3RCUyRmVuZHBvaW50cyUyRiU3QkVORFBPSU5UX05BTUUlN0QlMjIlMEFwcmludChkYXNoYm9hcmRfdXJsKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>dashboard_url = <span class="hljs-string">f&quot;https://ui.endpoints.huggingface.co/<span class="hljs-subst">{namespace}</span>/endpoints/<span class="hljs-subst">{ENDPOINT_NAME}</span>&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(dashboard_url)`,wrap:!1}}),Ct=new c({props:{code:"aW5wdXQoJTIySGl0JTIwZW50ZXIlMjB0byUyMGNvbnRpbnVlJTIwd2l0aCUyMHRoZSUyMG5vdGVib29rJTIyKQ==",highlighted:'<span class="hljs-built_in">input</span>(<span class="hljs-string">&quot;Hit enter to continue with the notebook&quot;</span>)',wrap:!1}}),kt=new h({props:{title:"Delete Endpoint",local:"delete-endpoint",headingTag:"h1"}}),Gt=new c({props:{code:"ZW5kcG9pbnQlMjAlM0QlMjBlbmRwb2ludC5kZWxldGUoKSUwQSUwQWlmJTIwbm90JTIwZW5kcG9pbnQlM0ElMEElMjAlMjAlMjAlMjBwcmludCglMjJFbmRwb2ludCUyMGRlbGV0ZWQlMjBzdWNjZXNzZnVsbHklMjIpJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkRlbGV0ZSUyMEVuZHBvaW50JTIwaW4lMjBtYW51YWxseSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>endpoint = endpoint.delete()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">if</span> <span class="hljs-keyword">not</span> endpoint:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Endpoint deleted successfully&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">else</span>:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Delete Endpoint in manually&quot;</span>)`,wrap:!1}}),Et=new Ds({props:{source:"https://github.com/huggingface/cookbook/blob/main/notebooks/en/automatic_embedding_tei_inference_endpoints.md"}}),{c(){y=m("meta"),vt=n(),Qt=m("p"),Vt=n(),p(w.$$.fragment),_t=n(),p(T.$$.fragment),St=n(),U=m("p"),U.innerHTML=ps,xt=n(),p(g.$$.fragment),Ht=n(),b=m("p"),b.textContent=is,qt=n(),p(J.$$.fragment),Xt=n(),f=m("p"),f.innerHTML=Ms,Yt=n(),I=m("p"),I.innerHTML=os,zt=n(),$=m("ul"),$.innerHTML=ds,Ft=n(),A=m("p"),A.innerHTML=js,Lt=n(),p(C.$$.fragment),Dt=n(),p(B.$$.fragment),Pt=n(),p(k.$$.fragment),Kt=n(),p(W.$$.fragment),Ot=n(),p(Z.$$.fragment),te=n(),G=m("p"),G.innerHTML=ms,ee=n(),R=m("p"),R.innerHTML=rs,se=n(),p(E.$$.fragment),le=n(),Q=m("p"),Q.textContent=us,ne=n(),N=m("table"),N.innerHTML=cs,ae=n(),v=m("p"),v.textContent=hs,pe=n(),p(V.$$.fragment),ie=n(),p(_.$$.fragment),Me=n(),S=m("p"),S.textContent=ys,oe=n(),x=m("p"),x.textContent=ws,de=n(),p(H.$$.fragment),je=n(),p(q.$$.fragment),me=n(),p(X.$$.fragment),re=n(),p(Y.$$.fragment),ue=n(),p(z.$$.fragment),ce=n(),p(F.$$.fragment),he=n(),L=m("p"),L.innerHTML=Ts,ye=n(),D=m("ul"),D.innerHTML=Us,we=n(),p(P.$$.fragment),Te=n(),K=m("p"),K.textContent=gs,Ue=n(),O=m("ul"),O.innerHTML=bs,ge=n(),p(tt.$$.fragment),be=n(),p(et.$$.fragment),Je=n(),st=m("pre"),st.textContent=Js,fe=n(),lt=m("p"),lt.innerHTML=fs,Ie=n(),p(nt.$$.fragment),$e=n(),at=m("p"),at.textContent=Is,Ae=n(),p(pt.$$.fragment),Ce=n(),it=m("pre"),it.textContent=$s,Be=n(),p(Mt.$$.fragment),ke=n(),ot=m("p"),ot.innerHTML=As,We=n(),p(dt.$$.fragment),Ze=n(),p(jt.$$.fragment),Ge=n(),mt=m("pre"),mt.textContent=Cs,Re=n(),p(rt.$$.fragment),Ee=n(),ut=m("p"),ut.textContent=Bs,Qe=n(),p(ct.$$.fragment),Ne=n(),ht=m("pre"),ht.textContent=ks,ve=n(),p(yt.$$.fragment),Ve=n(),wt=m("p"),wt.innerHTML=Ws,_e=n(),p(Tt.$$.fragment),Se=n(),Ut=m("p"),Ut.innerHTML=Zs,xe=n(),p(gt.$$.fragment),He=n(),p(bt.$$.fragment),qe=n(),Jt=m("pre"),Jt.textContent=Gs,Xe=n(),p(ft.$$.fragment),Ye=n(),It=m("ol"),It.innerHTML=Rs,ze=n(),p($t.$$.fragment),Fe=n(),At=m("pre"),At.textContent=Es,Le=n(),p(Ct.$$.fragment),De=n(),Bt=m("p"),Bt.innerHTML=Qs,Pe=n(),p(kt.$$.fragment),Ke=n(),Wt=m("p"),Wt.textContent=Ns,Oe=n(),Zt=m("p"),Zt.innerHTML=vs,ts=n(),p(Gt.$$.fragment),es=n(),Rt=m("pre"),Rt.textContent=Vs,ss=n(),p(Et.$$.fragment),ls=n(),Nt=m("p"),this.h()},l(t){const e=zs("svelte-u9bgzb",document.head);y=r(e,"META",{name:!0,content:!0}),e.forEach(s),vt=a(t),Qt=r(t,"P",{}),_s(Qt).forEach(s),Vt=a(t),i(w.$$.fragment,t),_t=a(t),i(T.$$.fragment,t),St=a(t),U=r(t,"P",{"data-svelte-h":!0}),u(U)!=="svelte-kkdsiw"&&(U.innerHTML=ps),xt=a(t),i(g.$$.fragment,t),Ht=a(t),b=r(t,"P",{"data-svelte-h":!0}),u(b)!=="svelte-1qwdsg4"&&(b.textContent=is),qt=a(t),i(J.$$.fragment,t),Xt=a(t),f=r(t,"P",{"data-svelte-h":!0}),u(f)!=="svelte-cznpu6"&&(f.innerHTML=Ms),Yt=a(t),I=r(t,"P",{"data-svelte-h":!0}),u(I)!=="svelte-1bpd7g5"&&(I.innerHTML=os),zt=a(t),$=r(t,"UL",{"data-svelte-h":!0}),u($)!=="svelte-amjqu"&&($.innerHTML=ds),Ft=a(t),A=r(t,"P",{"data-svelte-h":!0}),u(A)!=="svelte-12ly3c2"&&(A.innerHTML=js),Lt=a(t),i(C.$$.fragment,t),Dt=a(t),i(B.$$.fragment,t),Pt=a(t),i(k.$$.fragment,t),Kt=a(t),i(W.$$.fragment,t),Ot=a(t),i(Z.$$.fragment,t),te=a(t),G=r(t,"P",{"data-svelte-h":!0}),u(G)!=="svelte-roo1xs"&&(G.innerHTML=ms),ee=a(t),R=r(t,"P",{"data-svelte-h":!0}),u(R)!=="svelte-10xqojr"&&(R.innerHTML=rs),se=a(t),i(E.$$.fragment,t),le=a(t),Q=r(t,"P",{"data-svelte-h":!0}),u(Q)!=="svelte-1gpfxhe"&&(Q.textContent=us),ne=a(t),N=r(t,"TABLE",{"data-svelte-h":!0}),u(N)!=="svelte-e98cgk"&&(N.innerHTML=cs),ae=a(t),v=r(t,"P",{"data-svelte-h":!0}),u(v)!=="svelte-a1rv50"&&(v.textContent=hs),pe=a(t),i(V.$$.fragment,t),ie=a(t),i(_.$$.fragment,t),Me=a(t),S=r(t,"P",{"data-svelte-h":!0}),u(S)!=="svelte-1oubx8o"&&(S.textContent=ys),oe=a(t),x=r(t,"P",{"data-svelte-h":!0}),u(x)!=="svelte-13so4pe"&&(x.textContent=ws),de=a(t),i(H.$$.fragment,t),je=a(t),i(q.$$.fragment,t),me=a(t),i(X.$$.fragment,t),re=a(t),i(Y.$$.fragment,t),ue=a(t),i(z.$$.fragment,t),ce=a(t),i(F.$$.fragment,t),he=a(t),L=r(t,"P",{"data-svelte-h":!0}),u(L)!=="svelte-8d5fhe"&&(L.innerHTML=Ts),ye=a(t),D=r(t,"UL",{"data-svelte-h":!0}),u(D)!=="svelte-16ejamp"&&(D.innerHTML=Us),we=a(t),i(P.$$.fragment,t),Te=a(t),K=r(t,"P",{"data-svelte-h":!0}),u(K)!=="svelte-1whwkpr"&&(K.textContent=gs),Ue=a(t),O=r(t,"UL",{"data-svelte-h":!0}),u(O)!=="svelte-9i31ws"&&(O.innerHTML=bs),ge=a(t),i(tt.$$.fragment,t),be=a(t),i(et.$$.fragment,t),Je=a(t),st=r(t,"PRE",{"data-svelte-h":!0}),u(st)!=="svelte-19liytu"&&(st.textContent=Js),fe=a(t),lt=r(t,"P",{"data-svelte-h":!0}),u(lt)!=="svelte-il5t0k"&&(lt.innerHTML=fs),Ie=a(t),i(nt.$$.fragment,t),$e=a(t),at=r(t,"P",{"data-svelte-h":!0}),u(at)!=="svelte-16s019k"&&(at.textContent=Is),Ae=a(t),i(pt.$$.fragment,t),Ce=a(t),it=r(t,"PRE",{"data-svelte-h":!0}),u(it)!=="svelte-11ebe9s"&&(it.textContent=$s),Be=a(t),i(Mt.$$.fragment,t),ke=a(t),ot=r(t,"P",{"data-svelte-h":!0}),u(ot)!=="svelte-iwjedl"&&(ot.innerHTML=As),We=a(t),i(dt.$$.fragment,t),Ze=a(t),i(jt.$$.fragment,t),Ge=a(t),mt=r(t,"PRE",{"data-svelte-h":!0}),u(mt)!=="svelte-ff4u6w"&&(mt.textContent=Cs),Re=a(t),i(rt.$$.fragment,t),Ee=a(t),ut=r(t,"P",{"data-svelte-h":!0}),u(ut)!=="svelte-80w8ff"&&(ut.textContent=Bs),Qe=a(t),i(ct.$$.fragment,t),Ne=a(t),ht=r(t,"PRE",{"data-svelte-h":!0}),u(ht)!=="svelte-v5xolv"&&(ht.textContent=ks),ve=a(t),i(yt.$$.fragment,t),Ve=a(t),wt=r(t,"P",{"data-svelte-h":!0}),u(wt)!=="svelte-13ozgsg"&&(wt.innerHTML=Ws),_e=a(t),i(Tt.$$.fragment,t),Se=a(t),Ut=r(t,"P",{"data-svelte-h":!0}),u(Ut)!=="svelte-1t2e8el"&&(Ut.innerHTML=Zs),xe=a(t),i(gt.$$.fragment,t),He=a(t),i(bt.$$.fragment,t),qe=a(t),Jt=r(t,"PRE",{"data-svelte-h":!0}),u(Jt)!=="svelte-dj57zs"&&(Jt.textContent=Gs),Xe=a(t),i(ft.$$.fragment,t),Ye=a(t),It=r(t,"OL",{"data-svelte-h":!0}),u(It)!=="svelte-seqler"&&(It.innerHTML=Rs),ze=a(t),i($t.$$.fragment,t),Fe=a(t),At=r(t,"PRE",{"data-svelte-h":!0}),u(At)!=="svelte-109618w"&&(At.textContent=Es),Le=a(t),i(Ct.$$.fragment,t),De=a(t),Bt=r(t,"P",{"data-svelte-h":!0}),u(Bt)!=="svelte-1ga4kzi"&&(Bt.innerHTML=Qs),Pe=a(t),i(kt.$$.fragment,t),Ke=a(t),Wt=r(t,"P",{"data-svelte-h":!0}),u(Wt)!=="svelte-3kjw6t"&&(Wt.textContent=Ns),Oe=a(t),Zt=r(t,"P",{"data-svelte-h":!0}),u(Zt)!=="svelte-1124toy"&&(Zt.innerHTML=vs),ts=a(t),i(Gt.$$.fragment,t),es=a(t),Rt=r(t,"PRE",{"data-svelte-h":!0}),u(Rt)!=="svelte-ulyp9n"&&(Rt.textContent=Vs),ss=a(t),i(Et.$$.fragment,t),ls=a(t),Nt=r(t,"P",{}),_s(Nt).forEach(s),this.h()},h(){Ss(y,"name","hf:doc:metadata"),Ss(y,"content",Ks)},m(t,e){Fs(document.head,y),l(t,vt,e),l(t,Qt,e),l(t,Vt,e),M(w,t,e),l(t,_t,e),M(T,t,e),l(t,St,e),l(t,U,e),l(t,xt,e),M(g,t,e),l(t,Ht,e),l(t,b,e),l(t,qt,e),M(J,t,e),l(t,Xt,e),l(t,f,e),l(t,Yt,e),l(t,I,e),l(t,zt,e),l(t,$,e),l(t,Ft,e),l(t,A,e),l(t,Lt,e),M(C,t,e),l(t,Dt,e),M(B,t,e),l(t,Pt,e),M(k,t,e),l(t,Kt,e),M(W,t,e),l(t,Ot,e),M(Z,t,e),l(t,te,e),l(t,G,e),l(t,ee,e),l(t,R,e),l(t,se,e),M(E,t,e),l(t,le,e),l(t,Q,e),l(t,ne,e),l(t,N,e),l(t,ae,e),l(t,v,e),l(t,pe,e),M(V,t,e),l(t,ie,e),M(_,t,e),l(t,Me,e),l(t,S,e),l(t,oe,e),l(t,x,e),l(t,de,e),M(H,t,e),l(t,je,e),M(q,t,e),l(t,me,e),M(X,t,e),l(t,re,e),M(Y,t,e),l(t,ue,e),M(z,t,e),l(t,ce,e),M(F,t,e),l(t,he,e),l(t,L,e),l(t,ye,e),l(t,D,e),l(t,we,e),M(P,t,e),l(t,Te,e),l(t,K,e),l(t,Ue,e),l(t,O,e),l(t,ge,e),M(tt,t,e),l(t,be,e),M(et,t,e),l(t,Je,e),l(t,st,e),l(t,fe,e),l(t,lt,e),l(t,Ie,e),M(nt,t,e),l(t,$e,e),l(t,at,e),l(t,Ae,e),M(pt,t,e),l(t,Ce,e),l(t,it,e),l(t,Be,e),M(Mt,t,e),l(t,ke,e),l(t,ot,e),l(t,We,e),M(dt,t,e),l(t,Ze,e),M(jt,t,e),l(t,Ge,e),l(t,mt,e),l(t,Re,e),M(rt,t,e),l(t,Ee,e),l(t,ut,e),l(t,Qe,e),M(ct,t,e),l(t,Ne,e),l(t,ht,e),l(t,ve,e),M(yt,t,e),l(t,Ve,e),l(t,wt,e),l(t,_e,e),M(Tt,t,e),l(t,Se,e),l(t,Ut,e),l(t,xe,e),M(gt,t,e),l(t,He,e),M(bt,t,e),l(t,qe,e),l(t,Jt,e),l(t,Xe,e),M(ft,t,e),l(t,Ye,e),l(t,It,e),l(t,ze,e),M($t,t,e),l(t,Fe,e),l(t,At,e),l(t,Le,e),M(Ct,t,e),l(t,De,e),l(t,Bt,e),l(t,Pe,e),M(kt,t,e),l(t,Ke,e),l(t,Wt,e),l(t,Oe,e),l(t,Zt,e),l(t,ts,e),M(Gt,t,e),l(t,es,e),l(t,Rt,e),l(t,ss,e),M(Et,t,e),l(t,ls,e),l(t,Nt,e),ns=!0},p:Hs,i(t){ns||(o(w.$$.fragment,t),o(T.$$.fragment,t),o(g.$$.fragment,t),o(J.$$.fragment,t),o(C.$$.fragment,t),o(B.$$.fragment,t),o(k.$$.fragment,t),o(W.$$.fragment,t),o(Z.$$.fragment,t),o(E.$$.fragment,t),o(V.$$.fragment,t),o(_.$$.fragment,t),o(H.$$.fragment,t),o(q.$$.fragment,t),o(X.$$.fragment,t),o(Y.$$.fragment,t),o(z.$$.fragment,t),o(F.$$.fragment,t),o(P.$$.fragment,t),o(tt.$$.fragment,t),o(et.$$.fragment,t),o(nt.$$.fragment,t),o(pt.$$.fragment,t),o(Mt.$$.fragment,t),o(dt.$$.fragment,t),o(jt.$$.fragment,t),o(rt.$$.fragment,t),o(ct.$$.fragment,t),o(yt.$$.fragment,t),o(Tt.$$.fragment,t),o(gt.$$.fragment,t),o(bt.$$.fragment,t),o(ft.$$.fragment,t),o($t.$$.fragment,t),o(Ct.$$.fragment,t),o(kt.$$.fragment,t),o(Gt.$$.fragment,t),o(Et.$$.fragment,t),ns=!0)},o(t){d(w.$$.fragment,t),d(T.$$.fragment,t),d(g.$$.fragment,t),d(J.$$.fragment,t),d(C.$$.fragment,t),d(B.$$.fragment,t),d(k.$$.fragment,t),d(W.$$.fragment,t),d(Z.$$.fragment,t),d(E.$$.fragment,t),d(V.$$.fragment,t),d(_.$$.fragment,t),d(H.$$.fragment,t),d(q.$$.fragment,t),d(X.$$.fragment,t),d(Y.$$.fragment,t),d(z.$$.fragment,t),d(F.$$.fragment,t),d(P.$$.fragment,t),d(tt.$$.fragment,t),d(et.$$.fragment,t),d(nt.$$.fragment,t),d(pt.$$.fragment,t),d(Mt.$$.fragment,t),d(dt.$$.fragment,t),d(jt.$$.fragment,t),d(rt.$$.fragment,t),d(ct.$$.fragment,t),d(yt.$$.fragment,t),d(Tt.$$.fragment,t),d(gt.$$.fragment,t),d(bt.$$.fragment,t),d(ft.$$.fragment,t),d($t.$$.fragment,t),d(Ct.$$.fragment,t),d(kt.$$.fragment,t),d(Gt.$$.fragment,t),d(Et.$$.fragment,t),ns=!1},d(t){t&&(s(vt),s(Qt),s(Vt),s(_t),s(St),s(U),s(xt),s(Ht),s(b),s(qt),s(Xt),s(f),s(Yt),s(I),s(zt),s($),s(Ft),s(A),s(Lt),s(Dt),s(Pt),s(Kt),s(Ot),s(te),s(G),s(ee),s(R),s(se),s(le),s(Q),s(ne),s(N),s(ae),s(v),s(pe),s(ie),s(Me),s(S),s(oe),s(x),s(de),s(je),s(me),s(re),s(ue),s(ce),s(he),s(L),s(ye),s(D),s(we),s(Te),s(K),s(Ue),s(O),s(ge),s(be),s(Je),s(st),s(fe),s(lt),s(Ie),s($e),s(at),s(Ae),s(Ce),s(it),s(Be),s(ke),s(ot),s(We),s(Ze),s(Ge),s(mt),s(Re),s(Ee),s(ut),s(Qe),s(Ne),s(ht),s(ve),s(Ve),s(wt),s(_e),s(Se),s(Ut),s(xe),s(He),s(qe),s(Jt),s(Xe),s(Ye),s(It),s(ze),s(Fe),s(At),s(Le),s(De),s(Bt),s(Pe),s(Ke),s(Wt),s(Oe),s(Zt),s(ts),s(es),s(Rt),s(ss),s(ls),s(Nt)),s(y),j(w,t),j(T,t),j(g,t),j(J,t),j(C,t),j(B,t),j(k,t),j(W,t),j(Z,t),j(E,t),j(V,t),j(_,t),j(H,t),j(q,t),j(X,t),j(Y,t),j(z,t),j(F,t),j(P,t),j(tt,t),j(et,t),j(nt,t),j(pt,t),j(Mt,t),j(dt,t),j(jt,t),j(rt,t),j(ct,t),j(yt,t),j(Tt,t),j(gt,t),j(bt,t),j(ft,t),j($t,t),j(Ct,t),j(kt,t),j(Gt,t),j(Et,t)}}}const Ks='{"title":"How to use Inference Endpoints to Embed Documents","local":"how-to-use-inference-endpoints-to-embed-documents","sections":[{"title":"Goal","local":"goal","sections":[],"depth":2},{"title":"Approach","local":"approach","sections":[],"depth":2},{"title":"Requirements","local":"requirements","sections":[],"depth":2},{"title":"Imports","local":"imports","sections":[],"depth":2},{"title":"Config","local":"config","sections":[],"depth":2},{"title":"Get Dataset","local":"get-dataset","sections":[],"depth":2}],"depth":1}';function Os(as){return qs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class nl extends Xs{constructor(y){super(),Ys(this,y,Os,Ps,xs,{})}}export{nl as component};
