import{S as I2,i as M2,s as q2,e as t,k as l,w as _,t as a,M as z2,c as s,d as r,m as d,a as n,x as P,h as i,b as c,N as D2,G as e,g as h,y as b,q as w,o as y,B as $,v as A2,L as ko}from"../../chunks/vendor-hf-doc-builder.js";import{T as Or}from"../../chunks/Tip-hf-doc-builder.js";import{D as x}from"../../chunks/Docstring-hf-doc-builder.js";import{C as To}from"../../chunks/CodeBlock-hf-doc-builder.js";import{I as C}from"../../chunks/IconCopyLink-hf-doc-builder.js";import{E as $o}from"../../chunks/ExampleCodeBlock-hf-doc-builder.js";function O2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverModel, PerceiverConfig

# Initializing a Perceiver deepmind/language-perceiver style configuration
configuration = PerceiverConfig()

# Initializing a model from the deepmind/language-perceiver style configuration
model = PerceiverModel(configuration)

# Accessing the model configuration
configuration = model.config`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverModel, PerceiverConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Perceiver deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = PerceiverConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the deepmind/language-perceiver style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`}}),{c(){u=t("p"),T=a("Example:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Example:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function N2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function L2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
from transformers.models.perceiver.modeling_perceiver import (
    PerceiverTextPreprocessor,
    PerceiverImagePreprocessor,
    PerceiverClassificationDecoder,
)
import torch
import requests
from PIL import Image

# EXAMPLE 1: using the Perceiver to classify texts
# - we define a TextPreprocessor, which can be used to embed tokens
# - we define a ClassificationDecoder, which can be used to decode the
# final hidden states of the latents to classification logits
# using trainable position embeddings
config = PerceiverConfig()
preprocessor = PerceiverTextPreprocessor(config)
decoder = PerceiverClassificationDecoder(
    config,
    num_channels=config.d_latents,
    trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
    use_query_residual=True,
)
model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

# you can then do a forward pass as follows:
tokenizer = PerceiverTokenizer()
text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)

# EXAMPLE 2: using the Perceiver to classify images
# - we define an ImagePreprocessor, which can be used to embed images
config = PerceiverConfig(image_size=224)
preprocessor = PerceiverImagePreprocessor(
    config,
    prep_type="conv1x1",
    spatial_downsample=1,
    out_channels=256,
    position_encoding_type="trainable",
    concat_or_add_pos="concat",
    project_pos_dim=256,
    trainable_position_encoding_kwargs=dict(
        num_channels=256,
        index_dims=config.image_size**2,
    ),
)

model = PerceiverModel(
    config,
    input_preprocessor=preprocessor,
    decoder=PerceiverClassificationDecoder(
        config,
        num_channels=config.d_latents,
        trainable_position_encoding_kwargs=dict(num_channels=config.d_latents, index_dims=1),
        use_query_residual=True,
    ),
)

# you can then do a forward pass as follows:
image_processor = PerceiverImageProcessor()
url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)
inputs = image_processor(image, return_tensors="pt").pixel_values

with torch.no_grad():
    outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# to train, one can train the model using standard cross-entropy:
criterion = torch.nn.CrossEntropyLoss()

labels = torch.tensor([1])
loss = criterion(logits, labels)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverConfig, PerceiverTokenizer, PerceiverImageProcessor, PerceiverModel
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers.models.perceiver.modeling_perceiver <span class="hljs-keyword">import</span> (
<span class="hljs-meta">... </span>    PerceiverTextPreprocessor,
<span class="hljs-meta">... </span>    PerceiverImagePreprocessor,
<span class="hljs-meta">... </span>    PerceiverClassificationDecoder,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 1: using the Perceiver to classify texts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a TextPreprocessor, which can be used to embed tokens</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define a ClassificationDecoder, which can be used to decode the</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># final hidden states of the latents to classification logits</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># using trainable position embeddings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig()
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverTextPreprocessor(config)
<span class="hljs-meta">&gt;&gt;&gt; </span>decoder = PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    num_channels=config.d_latents,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>    use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(config, input_preprocessor=preprocessor, decoder=decoder)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer()
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># EXAMPLE 2: using the Perceiver to classify images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># - we define an ImagePreprocessor, which can be used to embed images</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>config = PerceiverConfig(image_size=<span class="hljs-number">224</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>preprocessor = PerceiverImagePreprocessor(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    prep_type=<span class="hljs-string">&quot;conv1x1&quot;</span>,
<span class="hljs-meta">... </span>    spatial_downsample=<span class="hljs-number">1</span>,
<span class="hljs-meta">... </span>    out_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    position_encoding_type=<span class="hljs-string">&quot;trainable&quot;</span>,
<span class="hljs-meta">... </span>    concat_or_add_pos=<span class="hljs-string">&quot;concat&quot;</span>,
<span class="hljs-meta">... </span>    project_pos_dim=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>    trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(
<span class="hljs-meta">... </span>        num_channels=<span class="hljs-number">256</span>,
<span class="hljs-meta">... </span>        index_dims=config.image_size**<span class="hljs-number">2</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverModel(
<span class="hljs-meta">... </span>    config,
<span class="hljs-meta">... </span>    input_preprocessor=preprocessor,
<span class="hljs-meta">... </span>    decoder=PerceiverClassificationDecoder(
<span class="hljs-meta">... </span>        config,
<span class="hljs-meta">... </span>        num_channels=config.d_latents,
<span class="hljs-meta">... </span>        trainable_position_encoding_kwargs=<span class="hljs-built_in">dict</span>(num_channels=config.d_latents, index_dims=<span class="hljs-number">1</span>),
<span class="hljs-meta">... </span>        use_query_residual=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>    ),
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># you can then do a forward pass as follows:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor()
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># to train, one can train the model using standard cross-entropy:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>criterion = torch.nn.CrossEntropyLoss()

<span class="hljs-meta">&gt;&gt;&gt; </span>labels = torch.tensor([<span class="hljs-number">1</span>])
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = criterion(logits, labels)`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function S2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function B2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverTokenizer, PerceiverForMaskedLM
import torch

tokenizer = PerceiverTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForMaskedLM.from_pretrained("deepmind/language-perceiver")

# training
text = "This is an incomplete sentence where some words are missing."
inputs = tokenizer(text, padding="max_length", return_tensors="pt")
# mask " missing."
inputs["input_ids"][0, 52:61] = tokenizer.mask_token_id
labels = tokenizer(text, padding="max_length", return_tensors="pt").input_ids

outputs = model(**inputs, labels=labels)
loss = outputs.loss
round(loss.item(), 2)

logits = outputs.logits
list(logits.shape)

# inference
text = "This is an incomplete sentence where some words are missing."
encoding = tokenizer(text, padding="max_length", return_tensors="pt")

# mask bytes corresponding to " missing.". Note that the model performs much better if the masked span starts with a space.
encoding["input_ids"][0, 52:61] = tokenizer.mask_token_id

# forward pass
with torch.no_grad():
    outputs = model(**encoding)
logits = outputs.logits
list(logits.shape)

masked_tokens_predictions = logits[0, 52:61].argmax(dim=-1).tolist()
tokenizer.decode(masked_tokens_predictions)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverTokenizer, PerceiverForMaskedLM
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMaskedLM.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># training</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask &quot; missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id
<span class="hljs-meta">&gt;&gt;&gt; </span>labels = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(**inputs, labels=labels)
<span class="hljs-meta">&gt;&gt;&gt; </span>loss = outputs.loss
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">round</span>(loss.item(), <span class="hljs-number">2</span>)
<span class="hljs-number">19.87</span>

<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># inference</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;This is an incomplete sentence where some words are missing.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding = tokenizer(text, padding=<span class="hljs-string">&quot;max_length&quot;</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># mask bytes corresponding to &quot; missing.&quot;. Note that the model performs much better if the masked span starts with a space.</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>encoding[<span class="hljs-string">&quot;input_ids&quot;</span>][<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>] = tokenizer.mask_token_id

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># forward pass</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    outputs = model(**encoding)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2048</span>, <span class="hljs-number">262</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span>masked_tokens_predictions = logits[<span class="hljs-number">0</span>, <span class="hljs-number">52</span>:<span class="hljs-number">61</span>].argmax(dim=-<span class="hljs-number">1</span>).tolist()
<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer.decode(masked_tokens_predictions)
<span class="hljs-string">&#x27; missing.&#x27;</span>`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function W2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function H2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverTokenizer, PerceiverForSequenceClassification

tokenizer = PerceiverTokenizer.from_pretrained("deepmind/language-perceiver")
model = PerceiverForSequenceClassification.from_pretrained("deepmind/language-perceiver")

text = "hello world"
inputs = tokenizer(text, return_tensors="pt").input_ids
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverTokenizer, PerceiverForSequenceClassification

<span class="hljs-meta">&gt;&gt;&gt; </span>tokenizer = PerceiverTokenizer.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForSequenceClassification.from_pretrained(<span class="hljs-string">&quot;deepmind/language-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>text = <span class="hljs-string">&quot;hello world&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = tokenizer(text, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).input_ids
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">2</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function R2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function V2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverImageProcessor, PerceiverForImageClassificationLearned
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = PerceiverImageProcessor.from_pretrained("deepmind/vision-perceiver-learned")
model = PerceiverForImageClassificationLearned.from_pretrained("deepmind/vision-perceiver-learned")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverImageProcessor, PerceiverForImageClassificationLearned
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationLearned.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-learned&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function U2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function K2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverImageProcessor, PerceiverForImageClassificationFourier
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = PerceiverImageProcessor.from_pretrained("deepmind/vision-perceiver-fourier")
model = PerceiverForImageClassificationFourier.from_pretrained("deepmind/vision-perceiver-fourier")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverImageProcessor, PerceiverForImageClassificationFourier
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationFourier.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-fourier&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function G2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function J2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverImageProcessor, PerceiverForImageClassificationConvProcessing
from PIL import Image
import requests

url = "http://images.cocodataset.org/val2017/000000039769.jpg"
image = Image.open(requests.get(url, stream=True).raw)

image_processor = PerceiverImageProcessor.from_pretrained("deepmind/vision-perceiver-conv")
model = PerceiverForImageClassificationConvProcessing.from_pretrained("deepmind/vision-perceiver-conv")

inputs = image_processor(images=image, return_tensors="pt").pixel_values
outputs = model(inputs=inputs)
logits = outputs.logits
list(logits.shape)

# model predicts one of the 1000 ImageNet classes
predicted_class_idx = logits.argmax(-1).item()
print("Predicted class:", model.config.id2label[predicted_class_idx])`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverImageProcessor, PerceiverForImageClassificationConvProcessing
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests

<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>image_processor = PerceiverImageProcessor.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForImageClassificationConvProcessing.from_pretrained(<span class="hljs-string">&quot;deepmind/vision-perceiver-conv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = image_processor(images=image, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).pixel_values
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">1000</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># model predicts one of the 1000 ImageNet classes</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>predicted_class_idx = logits.argmax(-<span class="hljs-number">1</span>).item()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Predicted class:&quot;</span>, model.config.id2label[predicted_class_idx])
Predicted <span class="hljs-keyword">class</span>: tabby, tabby cat`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function X2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Z2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverForOpticalFlow
import torch

model = PerceiverForOpticalFlow.from_pretrained("deepmind/optical-flow-perceiver")

# in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,
# leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)
# patches have shape (batch_size, num_frames, num_channels, height, width)
# the authors train on resolutions of 368 x 496
patches = torch.randn(1, 2, 27, 368, 496)
outputs = model(inputs=patches)
logits = outputs.logits
list(logits.shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForOpticalFlow
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForOpticalFlow.from_pretrained(<span class="hljs-string">&quot;deepmind/optical-flow-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, the authors extract a 3 x 3 patch around each pixel,</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># leading to 3 x 3 x 3 = 27 values for each pixel (as each pixel also has 3 color channels)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># patches have shape (batch_size, num_frames, num_channels, height, width)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># the authors train on resolutions of 368 x 496</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>patches = torch.randn(<span class="hljs-number">1</span>, <span class="hljs-number">2</span>, <span class="hljs-number">27</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=patches)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits.shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">368</span>, <span class="hljs-number">496</span>, <span class="hljs-number">2</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function Y2(E){let u,T,v,g,k;return{c(){u=t("p"),T=a("Although the recipe for forward pass needs to be defined within this function, one should call the "),v=t("code"),g=a("Module"),k=a(`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Although the recipe for forward pass needs to be defined within this function, one should call the "),v=s(f,"CODE",{});var j=n(v);g=i(j,"Module"),j.forEach(r),k=i(f,`
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`),f.forEach(r)},m(p,f){h(p,u,f),e(u,T),e(u,v),e(v,g),e(u,k)},d(p){p&&r(u)}}}function Q2(E){let u,T,v,g,k;return g=new To({props:{code:`from transformers import PerceiverForMultimodalAutoencoding
import torch
import numpy as np

# create multimodal inputs
images = torch.randn((1, 16, 3, 224, 224))
audio = torch.randn((1, 30720, 1))
inputs = dict(image=images, audio=audio, label=torch.zeros((images.shape[0], 700)))

model = PerceiverForMultimodalAutoencoding.from_pretrained("deepmind/multimodal-perceiver")

# in the Perceiver IO paper, videos are auto-encoded in chunks
# each chunk subsamples different index dimensions of the image and audio modality decoder queries
nchunks = 128
image_chunk_size = np.prod((16, 224, 224)) // nchunks
audio_chunk_size = audio.shape[1] // model.config.samples_per_patch // nchunks
# process the first chunk
chunk_idx = 0
subsampling = {
    "image": torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + 1)),
    "audio": torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + 1)),
    "label": None,
}

outputs = model(inputs=inputs, subsampled_output_points=subsampling)
logits = outputs.logits
list(logits["audio"].shape)

list(logits["image"].shape)

list(logits["label"].shape)`,highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> PerceiverForMultimodalAutoencoding
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># create multimodal inputs</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>images = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">16</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = torch.randn((<span class="hljs-number">1</span>, <span class="hljs-number">30720</span>, <span class="hljs-number">1</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = <span class="hljs-built_in">dict</span>(image=images, audio=audio, label=torch.zeros((images.shape[<span class="hljs-number">0</span>], <span class="hljs-number">700</span>)))

<span class="hljs-meta">&gt;&gt;&gt; </span>model = PerceiverForMultimodalAutoencoding.from_pretrained(<span class="hljs-string">&quot;deepmind/multimodal-perceiver&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># in the Perceiver IO paper, videos are auto-encoded in chunks</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># each chunk subsamples different index dimensions of the image and audio modality decoder queries</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>nchunks = <span class="hljs-number">128</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image_chunk_size = np.prod((<span class="hljs-number">16</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>)) // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span>audio_chunk_size = audio.shape[<span class="hljs-number">1</span>] // model.config.samples_per_patch // nchunks
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># process the first chunk</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>chunk_idx = <span class="hljs-number">0</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>subsampling = {
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;image&quot;</span>: torch.arange(image_chunk_size * chunk_idx, image_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;audio&quot;</span>: torch.arange(audio_chunk_size * chunk_idx, audio_chunk_size * (chunk_idx + <span class="hljs-number">1</span>)),
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;label&quot;</span>: <span class="hljs-literal">None</span>,
<span class="hljs-meta">... </span>}

<span class="hljs-meta">&gt;&gt;&gt; </span>outputs = model(inputs=inputs, subsampled_output_points=subsampling)
<span class="hljs-meta">&gt;&gt;&gt; </span>logits = outputs.logits
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;audio&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">240</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;image&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">6272</span>, <span class="hljs-number">3</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">list</span>(logits[<span class="hljs-string">&quot;label&quot;</span>].shape)
[<span class="hljs-number">1</span>, <span class="hljs-number">700</span>]`}}),{c(){u=t("p"),T=a("Examples:"),v=l(),_(g.$$.fragment)},l(p){u=s(p,"P",{});var f=n(u);T=i(f,"Examples:"),f.forEach(r),v=d(p),P(g.$$.fragment,p)},m(p,f){h(p,u,f),e(u,T),h(p,v,f),b(g,p,f),k=!0},p:ko,i(p){k||(w(g.$$.fragment,p),k=!0)},o(p){y(g.$$.fragment,p),k=!1},d(p){p&&r(u),p&&r(v),$(g,p)}}}function ew(E){let u,T,v,g,k,p,f,j,mp,zc,$e,xo,ea,Nr,hp,oa,up,Dc,Eo,fp,Lr,gp,vp,Ac,Co,_p,Sr,Pp,bp,Oc,Ws,wp,Nc,Hs,ra,yp,Lc,Rs,$p,Sc,Vs,kp,Bc,A,Tp,Us,xp,Ep,ta,Cp,jp,sa,Fp,Ip,na,Mp,qp,aa,zp,Dp,Wc,Ks,Ap,Hc,I,Op,ia,Np,Lp,ca,Sp,Bp,la,Wp,Hp,da,Rp,Vp,pa,Up,Kp,ma,Gp,Jp,Rc,jo,S_,Vc,Br,Xp,Gs,Zp,Uc,_e,Yp,Wr,Qp,em,Hr,om,rm,Kc,Js,tm,Gc,Fo,Rr,sm,Vr,nm,am,im,Ur,cm,Kr,lm,dm,Jc,Gr,ha,pm,mm,Xc,Xs,Pe,hm,ua,um,fm,fa,gm,vm,Jr,_m,Zc,ke,Io,ga,Xr,Pm,va,bm,Yc,Te,Zr,wm,_a,ym,Qc,xe,Yr,$m,Pa,km,el,Ee,Qr,Tm,ba,xm,ol,Ce,et,Em,wa,Cm,rl,je,Mo,ya,ot,jm,$a,Fm,tl,H,rt,Im,Fe,Mm,Zs,qm,zm,tt,Dm,Am,Om,Ie,Nm,Ys,Lm,Sm,Qs,Bm,Wm,Hm,qo,sl,Me,zo,ka,st,Rm,Ta,Vm,nl,R,nt,Um,xa,Km,Gm,at,Jm,en,Xm,Zm,Ym,Do,it,Qm,Ea,eh,al,qe,Ao,Ca,ct,oh,ja,rh,il,ne,lt,th,Fa,sh,nh,Oo,dt,ah,Ia,ih,cl,ze,No,Ma,pt,ch,qa,lh,ll,ae,mt,dh,za,ph,mh,Lo,ht,hh,Da,uh,dl,De,So,Aa,ut,fh,Oa,gh,pl,ie,ft,vh,gt,_h,Na,Ph,bh,wh,vt,yh,La,$h,kh,ml,Ae,Bo,Sa,_t,Th,Ba,xh,hl,ce,Pt,Eh,Wa,Ch,jh,V,Fh,Ha,Ih,Mh,Ra,qh,zh,Va,Dh,Ah,Ua,Oh,Nh,ul,Oe,Wo,Ka,bt,Lh,Ga,Sh,fl,Ne,wt,Bh,Ja,Wh,gl,Le,Ho,Xa,yt,Hh,Za,Rh,vl,Se,$t,Vh,Ya,Uh,_l,Be,Ro,Qa,kt,Kh,ei,Gh,Pl,le,Tt,Jh,oi,Xh,Zh,ri,Yh,bl,We,Vo,ti,xt,Qh,si,eu,wl,He,Et,ou,ni,ru,yl,Re,Uo,ai,Ct,tu,ii,su,$l,de,jt,nu,ci,au,iu,li,cu,kl,Ve,Ko,di,Ft,lu,pi,du,Tl,Ue,It,pu,Mt,mu,mi,hu,uu,xl,Ke,Go,hi,qt,fu,ui,gu,El,Ge,zt,vu,fi,_u,Cl,Je,Jo,gi,Dt,Pu,vi,bu,jl,Xe,At,wu,Ot,yu,_i,$u,ku,Fl,Ze,Xo,Pi,Nt,Tu,bi,xu,Il,pe,Lt,Eu,St,Cu,wi,ju,Fu,Iu,yi,Mu,Ml,Ye,Zo,$i,Bt,qu,ki,zu,ql,Qe,Wt,Du,Ti,Au,zl,eo,Yo,xi,Ht,Ou,Ei,Nu,Dl,oo,Rt,Lu,Ci,Su,Al,ro,Qo,ji,Vt,Bu,Fi,Wu,Ol,to,Ut,Hu,Ii,Ru,Nl,so,er,Mi,Kt,Vu,qi,Uu,Ll,no,Gt,Ku,zi,Gu,Sl,ao,or,Di,Jt,Ju,Ai,Xu,Bl,me,Xt,Zu,Zt,Yu,Yt,Qu,ef,of,U,Qt,rf,io,tf,on,sf,nf,Oi,af,cf,lf,rr,df,tr,Wl,co,sr,Ni,es,pf,Li,mf,Hl,he,os,hf,rs,uf,ts,ff,gf,vf,K,ss,_f,lo,Pf,rn,bf,wf,Si,yf,$f,kf,nr,Tf,ar,Rl,po,ir,Bi,ns,xf,Wi,Ef,Vl,ue,as,Cf,is,jf,cs,Ff,If,Mf,G,ls,qf,mo,zf,tn,Df,Af,Hi,Of,Nf,Lf,cr,Sf,lr,Ul,ho,dr,Ri,ds,Bf,Vi,Wf,Kl,q,ps,Hf,Ui,Rf,Vf,Ki,Uf,Kf,L,sn,Gf,Jf,nn,Xf,Zf,Gi,Yf,Qf,an,eg,og,cn,rg,tg,sg,ms,ng,hs,ag,ig,cg,J,us,lg,uo,dg,ln,pg,mg,Ji,hg,ug,fg,pr,gg,mr,Gl,fo,hr,Xi,fs,vg,Zi,_g,Jl,z,gs,Pg,Yi,bg,wg,Qi,yg,$g,S,dn,kg,Tg,pn,xg,Eg,ec,Cg,jg,mn,Fg,Ig,hn,Mg,qg,zg,vs,Dg,_s,Ag,Og,Ng,X,Ps,Lg,go,Sg,un,Bg,Wg,oc,Hg,Rg,Vg,ur,Ug,fr,Xl,vo,gr,rc,bs,Kg,tc,Gg,Zl,D,ws,Jg,sc,Xg,Zg,nc,Yg,Qg,B,fn,ev,ov,gn,rv,tv,ac,sv,nv,vn,av,iv,_n,cv,lv,dv,ys,pv,$s,mv,hv,uv,Z,ks,fv,_o,gv,Pn,vv,_v,ic,Pv,bv,wv,vr,yv,_r,Yl,Po,Pr,cc,Ts,$v,lc,kv,Ql,O,xs,Tv,N,xv,bn,Ev,Cv,wn,jv,Fv,dc,Iv,Mv,yn,qv,zv,$n,Dv,Av,Ov,pc,Nv,Lv,Es,Sv,Cs,Bv,Wv,Hv,Y,js,Rv,bo,Vv,kn,Uv,Kv,mc,Gv,Jv,Xv,br,Zv,wr,ed,wo,yr,hc,Fs,Yv,uc,Qv,od,F,Is,e_,fc,o_,r_,$r,Tn,t_,s_,xn,n_,a_,i_,be,En,c_,l_,Cn,d_,p_,jn,m_,h_,u_,kr,Fn,f_,g_,In,v_,__,P_,Ms,b_,gc,w_,y_,$_,vc,k_,T_,qs,x_,zs,E_,C_,j_,Q,Ds,F_,yo,I_,Mn,M_,q_,_c,z_,D_,A_,Tr,O_,xr,rd;return p=new C({}),Nr=new C({}),Xr=new C({}),Zr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"last_hidden_state",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.last_hidden_state",description:`<strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
Sequence of hidden-states at the output of the last layer of the model.`,name:"last_hidden_state"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L62"}}),Yr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput",parameters:[{name:"logits",val:": FloatTensor = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) &#x2014;
Output of the basic decoder.`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverDecoderOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L93"}}),Qr=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Masked language modeling (MLM) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) &#x2014;
Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L111"}}),et=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput",parameters:[{name:"loss",val:": typing.Optional[torch.FloatTensor] = None"},{name:"logits",val:": FloatTensor = None"},{name:"hidden_states",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"},{name:"cross_attentions",val:": typing.Optional[typing.Tuple[torch.FloatTensor]] = None"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.loss",description:`<strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) &#x2014;
Classification (or regression if config.num_labels==1) loss.`,name:"loss"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.logits",description:`<strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) &#x2014;
Classification (or regression if config.num_labels==1) scores (before SoftMax).`,name:"logits"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.hidden_states",description:`<strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.`,name:"hidden_states"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.attentions",description:`<strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.`,name:"attentions"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput.cross_attentions",description:`<strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) &#x2014;
Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder&#x2019;s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.`,name:"cross_attentions"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L142"}}),ot=new C({}),rt=new x({props:{name:"class transformers.PerceiverConfig",anchor:"transformers.PerceiverConfig",parameters:[{name:"num_latents",val:" = 256"},{name:"d_latents",val:" = 1280"},{name:"d_model",val:" = 768"},{name:"num_blocks",val:" = 1"},{name:"num_self_attends_per_block",val:" = 26"},{name:"num_self_attention_heads",val:" = 8"},{name:"num_cross_attention_heads",val:" = 8"},{name:"qk_channels",val:" = None"},{name:"v_channels",val:" = None"},{name:"cross_attention_shape_for_attention",val:" = 'kv'"},{name:"self_attention_widening_factor",val:" = 1"},{name:"cross_attention_widening_factor",val:" = 1"},{name:"hidden_act",val:" = 'gelu'"},{name:"attention_probs_dropout_prob",val:" = 0.1"},{name:"position_embedding_init_scale",val:" = 0.02"},{name:"initializer_range",val:" = 0.02"},{name:"layer_norm_eps",val:" = 1e-12"},{name:"is_encoder_decoder",val:" = False"},{name:"use_query_residual",val:" = True"},{name:"vocab_size",val:" = 262"},{name:"max_position_embeddings",val:" = 2048"},{name:"image_size",val:" = 56"},{name:"train_size",val:" = [368, 496]"},{name:"num_frames",val:" = 16"},{name:"audio_samples_per_frame",val:" = 1920"},{name:"samples_per_patch",val:" = 16"},{name:"output_shape",val:" = [1, 16, 224, 224]"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverConfig.num_latents",description:`<strong>num_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 256) &#x2014;
The number of latents.`,name:"num_latents"},{anchor:"transformers.PerceiverConfig.d_latents",description:`<strong>d_latents</strong> (<code>int</code>, <em>optional</em>, defaults to 1280) &#x2014;
Dimension of the latent embeddings.`,name:"d_latents"},{anchor:"transformers.PerceiverConfig.d_model",description:`<strong>d_model</strong> (<code>int</code>, <em>optional</em>, defaults to 768) &#x2014;
Dimension of the inputs. Should only be provided in case [<em>PerceiverTextPreprocessor</em>] is used or no
preprocessor is provided.`,name:"d_model"},{anchor:"transformers.PerceiverConfig.num_blocks",description:`<strong>num_blocks</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Number of blocks in the Transformer encoder.`,name:"num_blocks"},{anchor:"transformers.PerceiverConfig.num_self_attends_per_block",description:`<strong>num_self_attends_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 26) &#x2014;
The number of self-attention layers per block.`,name:"num_self_attends_per_block"},{anchor:"transformers.PerceiverConfig.num_self_attention_heads",description:`<strong>num_self_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each self-attention layer in the Transformer encoder.`,name:"num_self_attention_heads"},{anchor:"transformers.PerceiverConfig.num_cross_attention_heads",description:`<strong>num_cross_attention_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014;
Number of attention heads for each cross-attention layer in the Transformer encoder.`,name:"num_cross_attention_heads"},{anchor:"transformers.PerceiverConfig.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the queries + keys before applying attention in the cross-attention and self-attention
layers of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"qk_channels"},{anchor:"transformers.PerceiverConfig.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Dimension to project the values before applying attention in the cross-attention and self-attention layers
of the encoder. Will default to preserving the dimension of the queries if not specified.`,name:"v_channels"},{anchor:"transformers.PerceiverConfig.cross_attention_shape_for_attention",description:`<strong>cross_attention_shape_for_attention</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&apos;kv&apos;</code>) &#x2014;
Dimension to use when downsampling the queries and keys in the cross-attention layer of the encoder.`,name:"cross_attention_shape_for_attention"},{anchor:"transformers.PerceiverConfig.self_attention_widening_factor",description:`<strong>self_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the cross-attention layer of the Transformer encoder.`,name:"self_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.cross_attention_widening_factor",description:`<strong>cross_attention_widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Dimension of the feed-forward layer in the self-attention layers of the Transformer encoder.`,name:"cross_attention_widening_factor"},{anchor:"transformers.PerceiverConfig.hidden_act",description:`<strong>hidden_act</strong> (<code>str</code> or <code>function</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The non-linear activation function (function or string) in the encoder and pooler. If string, <code>&quot;gelu&quot;</code>,
<code>&quot;relu&quot;</code>, <code>&quot;selu&quot;</code> and <code>&quot;gelu_new&quot;</code> are supported.`,name:"hidden_act"},{anchor:"transformers.PerceiverConfig.attention_probs_dropout_prob",description:`<strong>attention_probs_dropout_prob</strong> (<code>float</code>, <em>optional</em>, defaults to 0.1) &#x2014;
The dropout ratio for the attention probabilities.`,name:"attention_probs_dropout_prob"},{anchor:"transformers.PerceiverConfig.initializer_range",description:`<strong>initializer_range</strong> (<code>float</code>, <em>optional</em>, defaults to 0.02) &#x2014;
The standard deviation of the truncated_normal_initializer for initializing all weight matrices.`,name:"initializer_range"},{anchor:"transformers.PerceiverConfig.layer_norm_eps",description:`<strong>layer_norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-12) &#x2014;
The epsilon used by the layer normalization layers.`,name:"layer_norm_eps"},{anchor:"transformers.PerceiverConfig.use_query_residual",description:`<strong>use_query_residual</strong> (<code>float</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to add a query residual in the cross-attention layer of the encoder.`,name:"use_query_residual"},{anchor:"transformers.PerceiverConfig.vocab_size",description:`<strong>vocab_size</strong> (<code>int</code>, <em>optional</em>, defaults to 262) &#x2014;
Vocabulary size for the masked language modeling model.`,name:"vocab_size"},{anchor:"transformers.PerceiverConfig.max_position_embeddings",description:`<strong>max_position_embeddings</strong> (<code>int</code>, <em>optional</em>, defaults to 2048) &#x2014;
The maximum sequence length that the masked language modeling model might ever be used with. Typically set
this to something large just in case (e.g., 512 or 1024 or 2048).`,name:"max_position_embeddings"},{anchor:"transformers.PerceiverConfig.image_size",description:`<strong>image_size</strong> (<code>int</code>, <em>optional</em>, defaults to 56) &#x2014;
Size of the images after preprocessing, for <a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned">PerceiverForImageClassificationLearned</a>.`,name:"image_size"},{anchor:"transformers.PerceiverConfig.train_size",description:`<strong>train_size</strong> (<code>List[int]</code>, <em>optional</em>, defaults to [368, 496]) &#x2014;
Training size of the images for the optical flow model.`,name:"train_size"},{anchor:"transformers.PerceiverConfig.num_frames",description:`<strong>num_frames</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of video frames used for the multimodal autoencoding model.`,name:"num_frames"},{anchor:"transformers.PerceiverConfig.audio_samples_per_frame",description:`<strong>audio_samples_per_frame</strong> (<code>int</code>, <em>optional</em>, defaults to 1920) &#x2014;
Number of audio samples per frame for the multimodal autoencoding model.`,name:"audio_samples_per_frame"},{anchor:"transformers.PerceiverConfig.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 16) &#x2014;
Number of audio samples per patch when preprocessing the audio for the multimodal autoencoding model.`,name:"samples_per_patch"},{anchor:"transformers.PerceiverConfig.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>, <em>optional</em>, defaults to <code>[1, 16, 224, 224]</code>) &#x2014;
Shape of the output (batch_size, num_frames, height, width) for the video decoder queries of the multimodal
autoencoding model. This excludes the channel dimension.`,name:"output_shape"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/configuration_perceiver.py#L36"}}),qo=new $o({props:{anchor:"transformers.PerceiverConfig.example",$$slots:{default:[O2]},$$scope:{ctx:E}}}),st=new C({}),nt=new x({props:{name:"class transformers.PerceiverTokenizer",anchor:"transformers.PerceiverTokenizer",parameters:[{name:"pad_token",val:" = '[PAD]'"},{name:"bos_token",val:" = '[BOS]'"},{name:"eos_token",val:" = '[EOS]'"},{name:"mask_token",val:" = '[MASK]'"},{name:"cls_token",val:" = '[CLS]'"},{name:"sep_token",val:" = '[SEP]'"},{name:"model_max_length",val:" = 2048"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.pad_token",description:`<strong>pad_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[PAD]&quot;</code>) &#x2014;
The token used for padding, for example when batching sequences of different lengths.`,name:"pad_token"},{anchor:"transformers.PerceiverTokenizer.bos_token",description:`<strong>bos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[BOS]&quot;</code>) &#x2014;
The BOS token (reserved in the vocab, but not actually used).`,name:"bos_token"},{anchor:"transformers.PerceiverTokenizer.eos_token",description:`<strong>eos_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[EOS]&quot;</code>) &#x2014;
The end of sequence token (reserved in the vocab, but not actually used).</p>
<div class="course-tip  bg-gradient-to-br dark:bg-gradient-to-r before:border-green-500 dark:before:border-green-800 from-green-50 dark:from-gray-900 to-white dark:to-gray-950 border border-green-50 text-green-700 dark:text-gray-400">
						
<p>When building a sequence using special tokens, this is not the token that is used for the end of sequence.
The token used is the <code>sep_token</code>.</p>

					</div>`,name:"eos_token"},{anchor:"transformers.PerceiverTokenizer.mask_token",description:`<strong>mask_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[MASK]&quot;</code>) &#x2014;
The MASK token, useful for masked language modeling.`,name:"mask_token"},{anchor:"transformers.PerceiverTokenizer.cls_token",description:`<strong>cls_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[CLS]&quot;</code>) &#x2014;
The CLS token (reserved in the vocab, but not actually used).`,name:"cls_token"},{anchor:"transformers.PerceiverTokenizer.sep_token",description:`<strong>sep_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;[SEP]&quot;</code>) &#x2014;
The separator token, which is used when building a sequence from two sequences.`,name:"sep_token"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/tokenization_perceiver.py#L27"}}),it=new x({props:{name:"__call__",anchor:"transformers.PerceiverTokenizer.__call__",parameters:[{name:"text",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"text_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]]] = None"},{name:"text_pair_target",val:": typing.Union[str, typing.List[str], typing.List[typing.List[str]], NoneType] = None"},{name:"add_special_tokens",val:": bool = True"},{name:"padding",val:": typing.Union[bool, str, transformers.utils.generic.PaddingStrategy] = False"},{name:"truncation",val:": typing.Union[bool, str, transformers.tokenization_utils_base.TruncationStrategy] = None"},{name:"max_length",val:": typing.Optional[int] = None"},{name:"stride",val:": int = 0"},{name:"is_split_into_words",val:": bool = False"},{name:"pad_to_multiple_of",val:": typing.Optional[int] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"return_token_type_ids",val:": typing.Optional[bool] = None"},{name:"return_attention_mask",val:": typing.Optional[bool] = None"},{name:"return_overflowing_tokens",val:": bool = False"},{name:"return_special_tokens_mask",val:": bool = False"},{name:"return_offsets_mapping",val:": bool = False"},{name:"return_length",val:": bool = False"},{name:"verbose",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverTokenizer.__call__.text",description:`<strong>text</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair",description:`<strong>text_pair</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded. Each sequence can be a string or a list of strings
(pretokenized string). If the sequences are provided as list of strings (pretokenized), you must set
<code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair"},{anchor:"transformers.PerceiverTokenizer.__call__.text_target",description:`<strong>text_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_target"},{anchor:"transformers.PerceiverTokenizer.__call__.text_pair_target",description:`<strong>text_pair_target</strong> (<code>str</code>, <code>List[str]</code>, <code>List[List[str]]</code>, <em>optional</em>) &#x2014;
The sequence or batch of sequences to be encoded as target texts. Each sequence can be a string or a
list of strings (pretokenized string). If the sequences are provided as list of strings (pretokenized),
you must set <code>is_split_into_words=True</code> (to lift the ambiguity with a batch of sequences).`,name:"text_pair_target"},{anchor:"transformers.PerceiverTokenizer.__call__.add_special_tokens",description:`<strong>add_special_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to encode the sequences with the special tokens relative to their model.`,name:"add_special_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.padding",description:`<strong>padding</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.25.1/en/internal/file_utils#transformers.utils.PaddingStrategy">PaddingStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls padding. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest&apos;</code>: Pad to the longest sequence in the batch (or no padding if only a single
sequence if provided).</li>
<li><code>&apos;max_length&apos;</code>: Pad to a maximum length specified with the argument <code>max_length</code> or to the maximum
acceptable input length for the model if that argument is not provided.</li>
<li><code>False</code> or <code>&apos;do_not_pad&apos;</code> (default): No padding (i.e., can output a batch with sequences of different
lengths).</li>
</ul>`,name:"padding"},{anchor:"transformers.PerceiverTokenizer.__call__.truncation",description:`<strong>truncation</strong> (<code>bool</code>, <code>str</code> or <a href="/docs/transformers/v4.25.1/en/internal/tokenization_utils#transformers.tokenization_utils_base.TruncationStrategy">TruncationStrategy</a>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Activates and controls truncation. Accepts the following values:</p>
<ul>
<li><code>True</code> or <code>&apos;longest_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or
to the maximum acceptable input length for the model if that argument is not provided. This will
truncate token by token, removing a token from the longest sequence in the pair if a pair of
sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_first&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the first sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>&apos;only_second&apos;</code>: Truncate to a maximum length specified with the argument <code>max_length</code> or to the
maximum acceptable input length for the model if that argument is not provided. This will only
truncate the second sequence of a pair if a pair of sequences (or a batch of pairs) is provided.</li>
<li><code>False</code> or <code>&apos;do_not_truncate&apos;</code> (default): No truncation (i.e., can output batch with sequence lengths
greater than the model maximum admissible input size).</li>
</ul>`,name:"truncation"},{anchor:"transformers.PerceiverTokenizer.__call__.max_length",description:`<strong>max_length</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Controls the maximum length to use by one of the truncation/padding parameters.</p>
<p>If left unset or set to <code>None</code>, this will use the predefined model maximum length if a maximum length
is required by one of the truncation/padding parameters. If the model has no specific maximum input
length (like XLNet) truncation/padding to a maximum length will be deactivated.`,name:"max_length"},{anchor:"transformers.PerceiverTokenizer.__call__.stride",description:`<strong>stride</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
If set to a number along with <code>max_length</code>, the overflowing tokens returned when
<code>return_overflowing_tokens=True</code> will contain some tokens from the end of the truncated sequence
returned to provide some overlap between truncated and overflowing sequences. The value of this
argument defines the number of overlapping tokens.`,name:"stride"},{anchor:"transformers.PerceiverTokenizer.__call__.is_split_into_words",description:`<strong>is_split_into_words</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not the input is already pre-tokenized (e.g., split into words). If set to <code>True</code>, the
tokenizer assumes the input is already split into words (for instance, by splitting it on whitespace)
which it will tokenize. This is useful for NER or token classification.`,name:"is_split_into_words"},{anchor:"transformers.PerceiverTokenizer.__call__.pad_to_multiple_of",description:`<strong>pad_to_multiple_of</strong> (<code>int</code>, <em>optional</em>) &#x2014;
If set will pad the sequence to a multiple of the provided value. This is especially useful to enable
the use of Tensor Cores on NVIDIA hardware with compute capability &gt;= 7.5 (Volta).`,name:"pad_to_multiple_of"},{anchor:"transformers.PerceiverTokenizer.__call__.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <a href="/docs/transformers/v4.25.1/en/internal/file_utils#transformers.TensorType">TensorType</a>, <em>optional</em>) &#x2014;
If set, will return tensors instead of list of python integers. Acceptable values are:</p>
<ul>
<li><code>&apos;tf&apos;</code>: Return TensorFlow <code>tf.constant</code> objects.</li>
<li><code>&apos;pt&apos;</code>: Return PyTorch <code>torch.Tensor</code> objects.</li>
<li><code>&apos;np&apos;</code>: Return Numpy <code>np.ndarray</code> objects.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverTokenizer.__call__.return_token_type_ids",description:`<strong>return_token_type_ids</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return token type IDs. If left to the default, will return the token type IDs according to
the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a>`,name:"return_token_type_ids"},{anchor:"transformers.PerceiverTokenizer.__call__.return_attention_mask",description:`<strong>return_attention_mask</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to return the attention mask. If left to the default, will return the attention mask according
to the specific tokenizer&#x2019;s default, defined by the <code>return_outputs</code> attribute.</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"return_attention_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_overflowing_tokens",description:`<strong>return_overflowing_tokens</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return overflowing token sequences. If a pair of sequences of input ids (or a batch
of pairs) is provided with <code>truncation_strategy = longest_first</code> or <code>True</code>, an error is raised instead
of returning overflowing tokens.`,name:"return_overflowing_tokens"},{anchor:"transformers.PerceiverTokenizer.__call__.return_special_tokens_mask",description:`<strong>return_special_tokens_mask</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return special tokens mask information.`,name:"return_special_tokens_mask"},{anchor:"transformers.PerceiverTokenizer.__call__.return_offsets_mapping",description:`<strong>return_offsets_mapping</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return <code>(char_start, char_end)</code> for each token.</p>
<p>This is only available on fast tokenizers inheriting from <a href="/docs/transformers/v4.25.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizerFast">PreTrainedTokenizerFast</a>, if using
Python&#x2019;s tokenizer, this method will raise <code>NotImplementedError</code>.`,name:"return_offsets_mapping"},{anchor:"transformers.PerceiverTokenizer.__call__.return_length",description:`<strong>return_length</strong>  (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether or not to return the lengths of the encoded inputs.`,name:"return_length"},{anchor:"transformers.PerceiverTokenizer.__call__.verbose",description:`<strong>verbose</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to print more information and warnings.
**kwargs &#x2014; passed to the <code>self.tokenize()</code> method`,name:"verbose"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/tokenization_utils_base.py#L2446",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a> with the following fields:</p>
<ul>
<li>
<p><strong>input_ids</strong> \u2014 List of token ids to be fed to a model.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a></p>
</li>
<li>
<p><strong>token_type_ids</strong> \u2014 List of token type ids to be fed to a model (when <code>return_token_type_ids=True</code> or
if <em>\u201Ctoken_type_ids\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#token-type-ids">What are token type IDs?</a></p>
</li>
<li>
<p><strong>attention_mask</strong> \u2014 List of indices specifying which tokens should be attended to by the model (when
<code>return_attention_mask=True</code> or if <em>\u201Cattention_mask\u201D</em> is in <code>self.model_input_names</code>).</p>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
</li>
<li>
<p><strong>overflowing_tokens</strong> \u2014 List of overflowing tokens sequences (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>num_truncated_tokens</strong> \u2014 Number of tokens truncated (when a <code>max_length</code> is specified and
<code>return_overflowing_tokens=True</code>).</p>
</li>
<li>
<p><strong>special_tokens_mask</strong> \u2014 List of 0s and 1s, with 1 specifying added special tokens and 0 specifying
regular sequence tokens (when <code>add_special_tokens=True</code> and <code>return_special_tokens_mask=True</code>).</p>
</li>
<li>
<p><strong>length</strong> \u2014 The length of the inputs (when <code>return_length=True</code>)</p>
</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/main_classes/tokenizer#transformers.BatchEncoding"
>BatchEncoding</a></p>
`}}),ct=new C({}),lt=new x({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/image_processing_perceiver.py#L47"}}),dt=new x({props:{name:"__call__",anchor:"transformers.PerceiverImageProcessor.__call__",parameters:[{name:"images",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/image_processing_utils.py#L435"}}),pt=new C({}),mt=new x({props:{name:"class transformers.PerceiverImageProcessor",anchor:"transformers.PerceiverImageProcessor",parameters:[{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <code>optional</code>, defaults to <code>True</code>) &#x2014;
Whether or not to center crop the image. If the input size if smaller than <code>crop_size</code> along any edge, the
image will be padded with zeros and then center cropped. Can be overridden by the <code>do_center_crop</code>
parameter in the <code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>{&quot;height&quot; -- 256, &quot;width&quot;: 256}</code>):
Desired output size when applying center-cropping. Can be overridden by the <code>crop_size</code> parameter in the
<code>preprocess</code> method.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image to <code>(size[&quot;height&quot;], size[&quot;width&quot;])</code>. Can be overridden by the <code>do_resize</code>
parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;height&quot; -- 224, &quot;width&quot;: 224}</code>):
Size of the image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code> method.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>PILImageResampling.BICUBIC</code>) &#x2014;
Defines the resampling filter to use if resizing the image. Can be overridden by the <code>resample</code> parameter
in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the <code>do_rescale</code>
parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Defines the scale factor to use if rescaling the image. Can be overridden by the <code>rescale_factor</code> parameter
in the <code>preprocess</code> method.
do_normalize &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_MEAN</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>IMAGENET_STANDARD_STD</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/image_processing_perceiver.py#L47"}}),ht=new x({props:{name:"preprocess",anchor:"transformers.PerceiverImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), typing.List[ForwardRef('PIL.Image.Image')], typing.List[numpy.ndarray], typing.List[ForwardRef('torch.Tensor')]]"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Union[typing.Dict[str, int], NoneType] = None"},{name:"resample",val:": Resampling = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": ChannelDimension = <ChannelDimension.FIRST: 'channels_first'>"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.PerceiverImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess.`,name:"images"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to <code>crop_size</code>.`,name:"do_center_crop"},{anchor:"transformers.PerceiverImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Desired output size after applying the center crop.`,name:"crop_size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing.`,name:"size"},{anchor:"transformers.PerceiverImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>, Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.PerceiverImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.PerceiverImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean.`,name:"image_mean"},{anchor:"transformers.PerceiverImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation.`,name:"image_std"},{anchor:"transformers.PerceiverImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.PerceiverImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
</ul>`,name:"data_format"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/image_processing_perceiver.py#L223"}}),ut=new C({}),ft=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2832"}}),_t=new C({}),Pt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:" = 'conv'"},{name:"spatial_downsample",val:": int = 4"},{name:"temporal_downsample",val:": int = 1"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"in_channels",val:": int = 3"},{name:"out_channels",val:": int = 64"},{name:"conv_after_patching",val:": bool = False"},{name:"conv_after_patching_in_channels",val:": int = 54"},{name:"conv2d_use_batchnorm",val:": bool = True"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"project_pos_dim",val:": int = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;conv&quot;</code>) &#x2014;
Preprocessing type. Can be &#x201C;conv1x1&#x201D;, &#x201C;conv&#x201D;, &#x201C;patches&#x201D;, &#x201C;pixels&#x201D;.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.spatial_downsample",description:`<strong>spatial_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014;
Spatial downsampling factor.`,name:"spatial_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.temporal_downsample",description:`<strong>temporal_downsample</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
Temporal downsampling factor (only relevant in case a time dimension is present).`,name:"temporal_downsample"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Position encoding type. Can be &#x201C;fourier&#x201D; or &#x201C;trainable&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 3) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching",description:`<strong>conv_after_patching</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to apply a convolutional layer after patching.`,name:"conv_after_patching"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv_after_patching_in_channels",description:`<strong>conv_after_patching_in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 54) &#x2014;
Number of channels in the input of the convolutional layer after patching.`,name:"conv_after_patching_in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.conv2d_use_batchnorm",description:`<strong>conv2d_use_batchnorm</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use batch normalization in the convolutional layer.`,name:"conv2d_use_batchnorm"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2989"}}),bt=new C({}),wt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",parameters:[{name:"config",val:": PerceiverConfig"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L3218"}}),yt=new C({}),$t=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",parameters:[{name:"config",val:""},{name:"prep_type",val:": str = 'patches'"},{name:"samples_per_patch",val:": int = 96"},{name:"position_encoding_type",val:": str = 'fourier'"},{name:"concat_or_add_pos",val:": str = 'concat'"},{name:"out_channels",val:" = 64"},{name:"project_pos_dim",val:" = -1"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.prep_type",description:`<strong>prep_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Preprocessor type to use. Only &#x201C;patches&#x201D; is supported.`,name:"prep_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.samples_per_patch",description:`<strong>samples_per_patch</strong> (<code>int</code>, <em>optional</em>, defaults to 96) &#x2014;
Number of samples per patch.`,name:"samples_per_patch"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;fourier&quot;</code>) &#x2014;
Type of position encoding to use. Can be &#x201C;trainable&#x201D; or &#x201C;fourier&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.concat_or_add_pos",description:`<strong>concat_or_add_pos</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;concat&quot;</code>) &#x2014;
How to concatenate the position encoding to the input. Can be &#x201C;concat&#x201D; or &#x201C;add&#x201D;.`,name:"concat_or_add_pos"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 64) &#x2014;
Number of channels in the output.`,name:"out_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.project_pos_dim",description:`<strong>project_pos_dim</strong> (<code>int</code>, <em>optional</em>, defaults to -1) &#x2014;
Dimension of the position encoding to project to. If -1, no projection is applied.`,name:"project_pos_dim"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor.*position_encoding_kwargs",description:`*<strong>*position_encoding_kwargs</strong> (<code>Dict</code>, <em>optional</em>) &#x2014;
Keyword arguments for the position encoding.`,name:"*position_encoding_kwargs"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L3244"}}),kt=new C({}),Tt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]]]"},{name:"mask_probs",val:": typing.Union[typing.Mapping[str, float], NoneType] = None"},{name:"min_padding_size",val:": int = 2"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PreprocessorType]</code>) &#x2014;
Dict mapping modality name to preprocessor.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.mask_probs",description:`<strong>mask_probs</strong> (<code>Dict[str, float]</code>) &#x2014;
Dict mapping modality name to masking probability of that modality.`,name:"mask_probs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L3341"}}),xt=new C({}),Et=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2042"}}),Ct=new C({}),jt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_num_channels",val:": int"},{name:"position_encoding_type",val:": typing.Optional[str] = 'trainable'"},{name:"output_index_dims",val:": typing.Optional[int] = None"},{name:"num_channels",val:": typing.Optional[int] = 128"},{name:"subsampled_index_dims",val:": typing.Optional[int] = None"},{name:"qk_channels",val:": typing.Optional[int] = None"},{name:"v_channels",val:": typing.Optional[int] = None"},{name:"num_heads",val:": typing.Optional[int] = 1"},{name:"widening_factor",val:": typing.Optional[int] = 1"},{name:"use_query_residual",val:": typing.Optional[bool] = False"},{name:"concat_preprocessed_input",val:": typing.Optional[bool] = False"},{name:"final_project",val:": typing.Optional[bool] = True"},{name:"position_encoding_only",val:": typing.Optional[bool] = False"},{name:"**position_encoding_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels in the output. Will only be used in case <em>final_project</em> is set to <code>True</code>.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;trainable&#x201D;) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.output_index_dims",description:`<strong>output_index_dims</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of dimensions of the output queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"output_index_dims"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_channels",description:`<strong>num_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 128) &#x2014;
The number of channels of the decoder queries. Ignored if &#x2018;position_encoding_type&#x2019; == &#x2018;none&#x2019;.`,name:"num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.qk_channels",description:`<strong>qk_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the queries and keys in the cross-attention layer.`,name:"qk_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.v_channels",description:`<strong>v_channels</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of channels of the values in the cross-attention layer.`,name:"v_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.num_heads",description:`<strong>num_heads</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of attention heads in the cross-attention layer.`,name:"num_heads"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.widening_factor",description:`<strong>widening_factor</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The widening factor of the cross-attention layer.`,name:"widening_factor"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.use_query_residual",description:`<strong>use_query_residual</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use a residual connection between the query and the output of the cross-attention layer.`,name:"use_query_residual"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.concat_preprocessed_input",description:`<strong>concat_preprocessed_input</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to concatenate the preprocessed input to the query.`,name:"concat_preprocessed_input"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.final_project",description:`<strong>final_project</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to project the output of the cross-attention layer to a target dimension.`,name:"final_project"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder.position_encoding_only",description:`<strong>position_encoding_only</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to only use this class to define output queries.`,name:"position_encoding_only"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2068"}}),Ft=new C({}),It=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",parameters:[{name:"config",val:""},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014;
Model configuration.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2254"}}),qt=new C({}),zt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",parameters:[{name:"config",val:""},{name:"output_image_shape",val:""},{name:"output_num_channels",val:" = 2"},{name:"rescale_factor",val:" = 100.0"},{name:"**decoder_kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2300"}}),Dt=new C({}),At=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"output_shape",val:": typing.List[int]"},{name:"position_encoding_type",val:": str"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.output_shape",description:`<strong>output_shape</strong> (<code>List[int]</code>) &#x2014;
Shape of the output as (batch_size, num_frames, height, width), excluding the channel dimension.`,name:"output_shape"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder.position_encoding_type",description:`<strong>position_encoding_type</strong> (<code>str</code>) &#x2014;
The type of position encoding to use. Can be either &#x201C;trainable&#x201D;, &#x201C;fourier&#x201D;, or &#x201C;none&#x201D;.`,name:"position_encoding_type"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2335"}}),Nt=new C({}),Lt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",parameters:[{name:"config",val:": PerceiverConfig"},{name:"modalities",val:": typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder]"},{name:"num_outputs",val:": int"},{name:"output_num_channels",val:": int"},{name:"min_padding_size",val:": typing.Optional[int] = 2"},{name:"subsampled_index_dims",val:": typing.Union[typing.Dict[str, transformers.models.perceiver.modeling_perceiver.PerceiverAbstractDecoder], NoneType] = None"},{name:"**decoder_kwargs",val:""}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>) &#x2014;
Dictionary mapping modality name to the decoder of that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.num_outputs",description:`<strong>num_outputs</strong> (<code>int</code>) &#x2014;
The number of outputs of the decoder.`,name:"num_outputs"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.output_num_channels",description:`<strong>output_num_channels</strong> (<code>int</code>) &#x2014;
The number of channels in the output.`,name:"output_num_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.min_padding_size",description:`<strong>min_padding_size</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014;
The minimum padding size for all modalities. The final output will have num_channels equal to the maximum
channels across all modalities plus min_padding_size.`,name:"min_padding_size"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder.subsampled_index_dims",description:`<strong>subsampled_index_dims</strong> (<code>Dict[str, PerceiverAbstractDecoder]</code>, <em>optional</em>) &#x2014;
Dictionary mapping modality name to the subsampled index dimensions to use for the decoder query of that
modality.`,name:"subsampled_index_dims"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2412"}}),Bt=new C({}),Wt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",parameters:[{name:"in_channels",val:": int"},{name:"out_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor.out_channels",description:`<strong>out_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the output.`,name:"out_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2968"}}),Ht=new C({}),Rt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"},{name:"postproc_type",val:": str = 'patches'"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor.postproc_type",description:`<strong>postproc_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;patches&quot;</code>) &#x2014;
Postprocessor type to use. Currently, only &#x201C;patches&#x201D; is supported.`,name:"postproc_type"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2941"}}),Vt=new C({}),Ut=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",parameters:[{name:"config",val:": PerceiverConfig"},{name:"in_channels",val:": int"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.config",description:`<strong>config</strong> ([<em>PerceiverConfig</em>]) &#x2014;
Model configuration.`,name:"config"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor.in_channels",description:`<strong>in_channels</strong> (<code>int</code>) &#x2014;
Number of channels in the input.`,name:"in_channels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2921"}}),Kt=new C({}),Gt=new x({props:{name:"class transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",parameters:[{name:"modalities",val:": typing.Mapping[str, typing.Callable[..., typing.Any]]"},{name:"input_is_dict",val:": bool = False"}],parametersDescription:[{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.modalities",description:`<strong>modalities</strong> (<code>Dict[str, PostprocessorType]</code>) &#x2014;
Dictionary mapping modality name to postprocessor class for that modality.`,name:"modalities"},{anchor:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor.input_is_dict",description:`<strong>input_is_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
If True, input is assumed to be dictionary structured, and outputs keep the same dictionary shape. If
False, input is a tensor which is sliced up during postprocessing by <em>modality_sizes</em>.`,name:"input_is_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L2887"}}),Jt=new C({}),Xt=new x({props:{name:"class transformers.PerceiverModel",anchor:"transformers.PerceiverModel",parameters:[{name:"config",val:""},{name:"decoder",val:" = None"},{name:"input_preprocessor",val:": typing.Callable[..., typing.Tuple[torch.Tensor, typing.Optional[torch.Tensor], torch.Tensor]] = None"},{name:"output_postprocessor",val:": typing.Callable[..., typing.Any] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"},{anchor:"transformers.PerceiverModel.decoder",description:`<strong>decoder</strong> (<em>DecoderType</em>, <em>optional</em>) &#x2014;
Optional decoder to use to decode the latent representation of the encoder. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder</em>.`,name:"decoder"},{anchor:"transformers.PerceiverModel.input_preprocessor",description:`<strong>input_preprocessor</strong> (<em>PreprocessorType</em>, <em>optional</em>) &#x2014;
Optional input preprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor</em>.`,name:"input_preprocessor"},{anchor:"transformers.PerceiverModel.output_postprocessor",description:`<strong>output_postprocessor</strong> (<em>PostprocessorType</em>, <em>optional</em>) &#x2014;
Optional output postprocessor to use. Examples include
<em>transformers.models.perceiver.modeling_perceiver.PerceiverImagePostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor</em>,
<em>transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor</em>.`,name:"output_postprocessor"},{anchor:"transformers.PerceiverModel.Note",description:"<strong>Note</strong> that you can define your own decoders, preprocessors and/or postprocessors to fit your use-case. &#x2014;",name:"Note"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L717"}}),Qt=new x({props:{name:"forward",anchor:"transformers.PerceiverModel.forward",parameters:[{name:"inputs",val:": FloatTensor"},{name:"attention_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.FloatTensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverModel.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverModel.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverModel.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverModel.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverModel.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L753",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>last_hidden_state</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) \u2014 Sequence of hidden-states at the output of the last layer of the model.</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),rr=new Or({props:{$$slots:{default:[N2]},$$scope:{ctx:E}}}),tr=new $o({props:{anchor:"transformers.PerceiverModel.forward.example",$$slots:{default:[L2]},$$scope:{ctx:E}}}),es=new C({}),os=new x({props:{name:"class transformers.PerceiverForMaskedLM",anchor:"transformers.PerceiverForMaskedLM",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L955"}}),ss=new x({props:{name:"forward",anchor:"transformers.PerceiverForMaskedLM.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMaskedLM.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMaskedLM.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMaskedLM.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMaskedLM.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMaskedLM.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should be in <code>[-100, 0, ..., config.vocab_size]</code> (see <code>input_ids</code> docstring) Tokens with indices set to <code>-100</code> are ignored (masked), the
loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L986",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Masked language modeling (MLM) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) \u2014 Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, num_latents, num_latents)</code>. Attentions weights after the attention softmax, used to compute the weighted average in the
self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverMaskedLMOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),nr=new Or({props:{$$slots:{default:[S2]},$$scope:{ctx:E}}}),ar=new $o({props:{anchor:"transformers.PerceiverForMaskedLM.forward.example",$$slots:{default:[B2]},$$scope:{ctx:E}}}),ns=new C({}),as=new x({props:{name:"class transformers.PerceiverForSequenceClassification",anchor:"transformers.PerceiverForSequenceClassification",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1089"}}),ls=new x({props:{name:"forward",anchor:"transformers.PerceiverForSequenceClassification.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"input_ids",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForSequenceClassification.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForSequenceClassification.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForSequenceClassification.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForSequenceClassification.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForSequenceClassification.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If <code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1110",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),cr=new Or({props:{$$slots:{default:[W2]},$$scope:{ctx:E}}}),lr=new $o({props:{anchor:"transformers.PerceiverForSequenceClassification.forward.example",$$slots:{default:[H2]},$$scope:{ctx:E}}}),ds=new C({}),ps=new x({props:{name:"class transformers.PerceiverForImageClassificationLearned",anchor:"transformers.PerceiverForImageClassificationLearned",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1214"}}),us=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationLearned.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationLearned.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationLearned.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1245",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),pr=new Or({props:{$$slots:{default:[R2]},$$scope:{ctx:E}}}),mr=new $o({props:{anchor:"transformers.PerceiverForImageClassificationLearned.forward.example",$$slots:{default:[V2]},$$scope:{ctx:E}}}),fs=new C({}),gs=new x({props:{name:"class transformers.PerceiverForImageClassificationFourier",anchor:"transformers.PerceiverForImageClassificationFourier",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1357"}}),Ps=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationFourier.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationFourier.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationFourier.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1386",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),ur=new Or({props:{$$slots:{default:[U2]},$$scope:{ctx:E}}}),fr=new $o({props:{anchor:"transformers.PerceiverForImageClassificationFourier.forward.example",$$slots:{default:[K2]},$$scope:{ctx:E}}}),bs=new C({}),ws=new x({props:{name:"class transformers.PerceiverForImageClassificationConvProcessing",anchor:"transformers.PerceiverForImageClassificationConvProcessing",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1497"}}),ks=new x({props:{name:"forward",anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"pixel_values",val:": typing.Optional[torch.Tensor] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1527",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),vr=new Or({props:{$$slots:{default:[G2]},$$scope:{ctx:E}}}),_r=new $o({props:{anchor:"transformers.PerceiverForImageClassificationConvProcessing.forward.example",$$slots:{default:[J2]},$$scope:{ctx:E}}}),Ts=new C({}),xs=new x({props:{name:"class transformers.PerceiverForOpticalFlow",anchor:"transformers.PerceiverForOpticalFlow",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1638"}}),js=new x({props:{name:"forward",anchor:"transformers.PerceiverForOpticalFlow.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForOpticalFlow.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForOpticalFlow.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForOpticalFlow.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForOpticalFlow.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForOpticalFlow.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the optical flow loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>.`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1685",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),br=new Or({props:{$$slots:{default:[X2]},$$scope:{ctx:E}}}),wr=new $o({props:{anchor:"transformers.PerceiverForOpticalFlow.forward.example",$$slots:{default:[Z2]},$$scope:{ctx:E}}}),Fs=new C({}),Is=new x({props:{name:"class transformers.PerceiverForMultimodalAutoencoding",anchor:"transformers.PerceiverForMultimodalAutoencoding",parameters:[{name:"config",val:""}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.config",description:`<strong>config</strong> (<a href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig">PerceiverConfig</a>) &#x2014; Model configuration class with all the parameters of the model.
Initializing with a config file does not load the weights associated with the model, only the
configuration. Check out the <a href="/docs/transformers/v4.25.1/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1780"}}),Ds=new x({props:{name:"forward",anchor:"transformers.PerceiverForMultimodalAutoencoding.forward",parameters:[{name:"inputs",val:": typing.Optional[torch.Tensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"subsampled_output_points",val:": typing.Union[typing.Dict[str, torch.Tensor], NoneType] = None"},{name:"head_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"labels",val:": typing.Optional[torch.Tensor] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"}],parametersDescription:[{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.inputs",description:`<strong>inputs</strong> (<code>torch.FloatTensor</code>) &#x2014;
Inputs to the perceiver. Can be anything: images, text, audio, video, etc.`,name:"inputs"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.FloatTensor</code> of shape <code>batch_size, sequence_length</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a>`,name:"attention_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.head_mask",description:`<strong>head_mask</strong> (<code>torch.FloatTensor</code> of shape <code>(num_heads,)</code> or <code>(num_layers, num_heads)</code>, <em>optional</em>) &#x2014;
Mask to nullify selected heads of the self-attention modules. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"head_mask"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/v4.25.1/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size,)</code>, <em>optional</em>) &#x2014;
Labels for computing the image classification/regression loss. Indices should be in <code>[0, ..., config.num_labels - 1]</code>. If <code>config.num_labels == 1</code> a regression loss is computed (Mean-Square loss), If
<code>config.num_labels &gt; 1</code> a classification loss is computed (Cross-Entropy).`,name:"labels"}],source:"https://github.com/huggingface/transformers/blob/v4.25.1/src/transformers/models/perceiver/modeling_perceiver.py#L1896",returnDescription:`
<p>A <a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverConfig"
>PerceiverConfig</a>) and inputs.</p>
<ul>
<li><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) \u2014 Classification (or regression if config.num_labels==1) loss.</li>
<li><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, config.num_labels)</code>) \u2014 Classification (or regression if config.num_labels==1) scores (before SoftMax).</li>
<li><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings + one for the output of each layer) of
shape <code>(batch_size, sequence_length, hidden_size)</code>. Hidden-states of the model at the output of each layer
plus the initial embedding outputs.</li>
<li><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights after the attention softmax, used to compute the weighted average in
the self-attention heads.</li>
<li><strong>cross_attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) \u2014 Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>. Attentions weights of the decoder\u2019s cross-attention layer, after the attention softmax,
used to compute the weighted average in the cross-attention heads.</li>
</ul>
`,returnType:`
<p><a
  href="/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput"
>transformers.models.perceiver.modeling_perceiver.PerceiverClassifierOutput</a> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Tr=new Or({props:{$$slots:{default:[Y2]},$$scope:{ctx:E}}}),xr=new $o({props:{anchor:"transformers.PerceiverForMultimodalAutoencoding.forward.example",$$slots:{default:[Q2]},$$scope:{ctx:E}}}),{c(){u=t("meta"),T=l(),v=t("h1"),g=t("a"),k=t("span"),_(p.$$.fragment),f=l(),j=t("span"),mp=a("Perceiver"),zc=l(),$e=t("h2"),xo=t("a"),ea=t("span"),_(Nr.$$.fragment),hp=l(),oa=t("span"),up=a("Overview"),Dc=l(),Eo=t("p"),fp=a("The Perceiver IO model was proposed in "),Lr=t("a"),gp=a(`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),vp=a(` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Ac=l(),Co=t("p"),_p=a("Perceiver IO is a generalization of "),Sr=t("a"),Pp=a("Perceiver"),bp=a(` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Oc=l(),Ws=t("p"),wp=a("The abstract from the paper is the following:"),Nc=l(),Hs=t("p"),ra=t("em"),yp=a(`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),Lc=l(),Rs=t("p"),$p=a("Here\u2019s a TLDR explaining how Perceiver works:"),Sc=l(),Vs=t("p"),kp=a(`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),Bc=l(),A=t("p"),Tp=a("Internally, "),Us=t("a"),xp=a("PerceiverModel"),Ep=a(" will create the latents, which is a tensor of shape "),ta=t("code"),Cp=a("(batch_size, num_latents, d_latents)"),jp=a(". One must provide "),sa=t("code"),Fp=a("inputs"),Ip=a(` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),na=t("code"),Mp=a("d_latents"),qp=a(" to "),aa=t("code"),zp=a("num_labels"),Dp=a("."),Wc=l(),Ks=t("p"),Ap=a(`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),Hc=l(),I=t("p"),Op=a(`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),ia=t("code"),Np=a("inputs"),Lp=a(` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),ca=t("code"),Sp=a("outputs"),Bp=a(" as being of shape: "),la=t("code"),Wp=a("(batch_size, 2048, 768)"),Hp=a(`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),da=t("code"),Rp=a("outputs"),Vp=a(" tensor. After cross-attention, one still has a tensor of shape "),pa=t("code"),Up=a("(batch_size, 2048, 768)"),Kp=a(`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),ma=t("code"),Gp=a("(batch_size, 2048, 262)"),Jp=a(` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),Rc=l(),jo=t("img"),Vc=l(),Br=t("small"),Xp=a("Perceiver IO architecture. Taken from the "),Gs=t("a"),Zp=a("original paper"),Uc=l(),_e=t("p"),Yp=a("This model was contributed by "),Wr=t("a"),Qp=a("nielsr"),em=a(`. The original code can be found
`),Hr=t("a"),om=a("here"),rm=a("."),Kc=l(),Js=t("p"),tm=a("Tips:"),Gc=l(),Fo=t("ul"),Rr=t("li"),sm=a("The quickest way to get started with the Perceiver is by checking the "),Vr=t("a"),nm=a(`tutorial
notebooks`),am=a("."),im=l(),Ur=t("li"),cm=a("Refer to the "),Kr=t("a"),lm=a("blog post"),dm=a(` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),Jc=l(),Gr=t("p"),ha=t("strong"),pm=a("Note"),mm=a(":"),Xc=l(),Xs=t("ul"),Pe=t("li"),hm=a("Perceiver does "),ua=t("strong"),um=a("not"),fm=a(" work with "),fa=t("code"),gm=a("torch.nn.DataParallel"),vm=a(" due to a bug in PyTorch, see "),Jr=t("a"),_m=a("issue #36035"),Zc=l(),ke=t("h2"),Io=t("a"),ga=t("span"),_(Xr.$$.fragment),Pm=l(),va=t("span"),bm=a("Perceiver specific outputs"),Yc=l(),Te=t("div"),_(Zr.$$.fragment),wm=l(),_a=t("p"),ym=a("Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),Qc=l(),xe=t("div"),_(Yr.$$.fragment),$m=l(),Pa=t("p"),km=a("Base class for Perceiver decoder outputs, with potential cross-attentions."),el=l(),Ee=t("div"),_(Qr.$$.fragment),Tm=l(),ba=t("p"),xm=a("Base class for Perceiver\u2019s masked language model outputs."),ol=l(),Ce=t("div"),_(et.$$.fragment),Em=l(),wa=t("p"),Cm=a(`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),rl=l(),je=t("h2"),Mo=t("a"),ya=t("span"),_(ot.$$.fragment),jm=l(),$a=t("span"),Fm=a("PerceiverConfig"),tl=l(),H=t("div"),_(rt.$$.fragment),Im=l(),Fe=t("p"),Mm=a("This is the configuration class to store the configuration of a "),Zs=t("a"),qm=a("PerceiverModel"),zm=a(`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),tt=t("a"),Dm=a("deepmind/language-perceiver"),Am=a(" architecture."),Om=l(),Ie=t("p"),Nm=a("Configuration objects inherit from "),Ys=t("a"),Lm=a("PretrainedConfig"),Sm=a(` and can be used to control the model outputs. Read the
documentation from `),Qs=t("a"),Bm=a("PretrainedConfig"),Wm=a(" for more information."),Hm=l(),_(qo.$$.fragment),sl=l(),Me=t("h2"),zo=t("a"),ka=t("span"),_(st.$$.fragment),Rm=l(),Ta=t("span"),Vm=a("PerceiverTokenizer"),nl=l(),R=t("div"),_(nt.$$.fragment),Um=l(),xa=t("p"),Km=a("Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),Gm=l(),at=t("p"),Jm=a("This tokenizer inherits from "),en=t("a"),Xm=a("PreTrainedTokenizer"),Zm=a(` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),Ym=l(),Do=t("div"),_(it.$$.fragment),Qm=l(),Ea=t("p"),eh=a(`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),al=l(),qe=t("h2"),Ao=t("a"),Ca=t("span"),_(ct.$$.fragment),oh=l(),ja=t("span"),rh=a("PerceiverFeatureExtractor"),il=l(),ne=t("div"),_(lt.$$.fragment),th=l(),Fa=t("p"),sh=a("Constructs a Perceiver image processor."),nh=l(),Oo=t("div"),_(dt.$$.fragment),ah=l(),Ia=t("p"),ih=a("Preprocess an image or a batch of images."),cl=l(),ze=t("h2"),No=t("a"),Ma=t("span"),_(pt.$$.fragment),ch=l(),qa=t("span"),lh=a("PerceiverImageProcessor"),ll=l(),ae=t("div"),_(mt.$$.fragment),dh=l(),za=t("p"),ph=a("Constructs a Perceiver image processor."),mh=l(),Lo=t("div"),_(ht.$$.fragment),hh=l(),Da=t("p"),uh=a("Preprocess an image or batch of images."),dl=l(),De=t("h2"),So=t("a"),Aa=t("span"),_(ut.$$.fragment),fh=l(),Oa=t("span"),gh=a("PerceiverTextPreprocessor"),pl=l(),ie=t("div"),_(ft.$$.fragment),vh=l(),gt=t("p"),_h=a("Text preprocessing for Perceiver Encoder. Can be used to embed "),Na=t("code"),Ph=a("inputs"),bh=a(" and add positional encodings."),wh=l(),vt=t("p"),yh=a("The dimensionality of the embeddings is determined by the "),La=t("code"),$h=a("d_model"),kh=a(" attribute of the configuration."),ml=l(),Ae=t("h2"),Bo=t("a"),Sa=t("span"),_(_t.$$.fragment),Th=l(),Ba=t("span"),xh=a("PerceiverImagePreprocessor"),hl=l(),ce=t("div"),_(Pt.$$.fragment),Eh=l(),Wa=t("p"),Ch=a("Image preprocessing for Perceiver Encoder."),jh=l(),V=t("p"),Fh=a("Note: the "),Ha=t("em"),Ih=a("out_channels"),Mh=a(" argument refers to the output channels of a convolutional layer, if "),Ra=t("em"),qh=a("prep_type"),zh=a(` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Va=t("em"),Dh=a("num_channels"),Ah=a(` of the
position encoding kwargs are set equal to the `),Ua=t("em"),Oh=a("out_channels"),Nh=a("."),ul=l(),Oe=t("h2"),Wo=t("a"),Ka=t("span"),_(bt.$$.fragment),Lh=l(),Ga=t("span"),Sh=a("PerceiverOneHotPreprocessor"),fl=l(),Ne=t("div"),_(wt.$$.fragment),Bh=l(),Ja=t("p"),Wh=a("One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),gl=l(),Le=t("h2"),Ho=t("a"),Xa=t("span"),_(yt.$$.fragment),Hh=l(),Za=t("span"),Rh=a("PerceiverAudioPreprocessor"),vl=l(),Se=t("div"),_($t.$$.fragment),Vh=l(),Ya=t("p"),Uh=a("Audio preprocessing for Perceiver Encoder."),_l=l(),Be=t("h2"),Ro=t("a"),Qa=t("span"),_(kt.$$.fragment),Kh=l(),ei=t("span"),Gh=a("PerceiverMultimodalPreprocessor"),Pl=l(),le=t("div"),_(Tt.$$.fragment),Jh=l(),oi=t("p"),Xh=a("Multimodal preprocessing for Perceiver Encoder."),Zh=l(),ri=t("p"),Yh=a(`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),bl=l(),We=t("h2"),Vo=t("a"),ti=t("span"),_(xt.$$.fragment),Qh=l(),si=t("span"),eu=a("PerceiverProjectionDecoder"),wl=l(),He=t("div"),_(Et.$$.fragment),ou=l(),ni=t("p"),ru=a("Baseline projection decoder (no cross-attention)."),yl=l(),Re=t("h2"),Uo=t("a"),ai=t("span"),_(Ct.$$.fragment),tu=l(),ii=t("span"),su=a("PerceiverBasicDecoder"),$l=l(),de=t("div"),_(jt.$$.fragment),nu=l(),ci=t("p"),au=a(`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),iu=l(),li=t("p"),cu=a("The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),kl=l(),Ve=t("h2"),Ko=t("a"),di=t("span"),_(Ft.$$.fragment),lu=l(),pi=t("span"),du=a("PerceiverClassificationDecoder"),Tl=l(),Ue=t("div"),_(It.$$.fragment),pu=l(),Mt=t("p"),mu=a("Cross-attention based classification decoder. Light-weight wrapper of "),mi=t("code"),hu=a("PerceiverBasicDecoder"),uu=a(` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),xl=l(),Ke=t("h2"),Go=t("a"),hi=t("span"),_(qt.$$.fragment),fu=l(),ui=t("span"),gu=a("PerceiverOpticalFlowDecoder"),El=l(),Ge=t("div"),_(zt.$$.fragment),vu=l(),fi=t("p"),_u=a("Cross-attention based optical flow decoder."),Cl=l(),Je=t("h2"),Jo=t("a"),gi=t("span"),_(Dt.$$.fragment),Pu=l(),vi=t("span"),bu=a("PerceiverBasicVideoAutoencodingDecoder"),jl=l(),Xe=t("div"),_(At.$$.fragment),wu=l(),Ot=t("p"),yu=a("Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),_i=t("em"),$u=a("PerceiverBasicDecoder"),ku=a(`] with video
reshaping logic.`),Fl=l(),Ze=t("h2"),Xo=t("a"),Pi=t("span"),_(Nt.$$.fragment),Tu=l(),bi=t("span"),xu=a("PerceiverMultimodalDecoder"),Il=l(),pe=t("div"),_(Lt.$$.fragment),Eu=l(),St=t("p"),Cu=a("Multimodal decoding by composing uni-modal decoders. The "),wi=t("em"),ju=a("modalities"),Fu=a(` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),Iu=l(),yi=t("p"),Mu=a("Next, there is a shared cross attention operation across all modalities."),Ml=l(),Ye=t("h2"),Zo=t("a"),$i=t("span"),_(Bt.$$.fragment),qu=l(),ki=t("span"),zu=a("PerceiverProjectionPostprocessor"),ql=l(),Qe=t("div"),_(Wt.$$.fragment),Du=l(),Ti=t("p"),Au=a(`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),zl=l(),eo=t("h2"),Yo=t("a"),xi=t("span"),_(Ht.$$.fragment),Ou=l(),Ei=t("span"),Nu=a("PerceiverAudioPostprocessor"),Dl=l(),oo=t("div"),_(Rt.$$.fragment),Lu=l(),Ci=t("p"),Su=a("Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),Al=l(),ro=t("h2"),Qo=t("a"),ji=t("span"),_(Vt.$$.fragment),Bu=l(),Fi=t("span"),Wu=a("PerceiverClassificationPostprocessor"),Ol=l(),to=t("div"),_(Ut.$$.fragment),Hu=l(),Ii=t("p"),Ru=a("Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Nl=l(),so=t("h2"),er=t("a"),Mi=t("span"),_(Kt.$$.fragment),Vu=l(),qi=t("span"),Uu=a("PerceiverMultimodalPostprocessor"),Ll=l(),no=t("div"),_(Gt.$$.fragment),Ku=l(),zi=t("p"),Gu=a(`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),Sl=l(),ao=t("h2"),or=t("a"),Di=t("span"),_(Jt.$$.fragment),Ju=l(),Ai=t("span"),Xu=a("PerceiverModel"),Bl=l(),me=t("div"),_(Xt.$$.fragment),Zu=l(),Zt=t("p"),Yu=a(`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Yt=t("a"),Qu=a("torch.nn.Module"),ef=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),of=l(),U=t("div"),_(Qt.$$.fragment),rf=l(),io=t("p"),tf=a("The "),on=t("a"),sf=a("PerceiverModel"),nf=a(" forward method, overrides the "),Oi=t("code"),af=a("__call__"),cf=a(" special method."),lf=l(),_(rr.$$.fragment),df=l(),_(tr.$$.fragment),Wl=l(),co=t("h2"),sr=t("a"),Ni=t("span"),_(es.$$.fragment),pf=l(),Li=t("span"),mf=a("PerceiverForMaskedLM"),Hl=l(),he=t("div"),_(os.$$.fragment),hf=l(),rs=t("p"),uf=a(`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),ts=t("a"),ff=a("torch.nn.Module"),gf=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),vf=l(),K=t("div"),_(ss.$$.fragment),_f=l(),lo=t("p"),Pf=a("The "),rn=t("a"),bf=a("PerceiverForMaskedLM"),wf=a(" forward method, overrides the "),Si=t("code"),yf=a("__call__"),$f=a(" special method."),kf=l(),_(nr.$$.fragment),Tf=l(),_(ar.$$.fragment),Rl=l(),po=t("h2"),ir=t("a"),Bi=t("span"),_(ns.$$.fragment),xf=l(),Wi=t("span"),Ef=a("PerceiverForSequenceClassification"),Vl=l(),ue=t("div"),_(as.$$.fragment),Cf=l(),is=t("p"),jf=a(`Example use of Perceiver for text classification.
This model is a PyTorch `),cs=t("a"),Ff=a("torch.nn.Module"),If=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Mf=l(),G=t("div"),_(ls.$$.fragment),qf=l(),mo=t("p"),zf=a("The "),tn=t("a"),Df=a("PerceiverForSequenceClassification"),Af=a(" forward method, overrides the "),Hi=t("code"),Of=a("__call__"),Nf=a(" special method."),Lf=l(),_(cr.$$.fragment),Sf=l(),_(lr.$$.fragment),Ul=l(),ho=t("h2"),dr=t("a"),Ri=t("span"),_(ds.$$.fragment),Bf=l(),Vi=t("span"),Wf=a("PerceiverForImageClassificationLearned"),Kl=l(),q=t("div"),_(ps.$$.fragment),Hf=l(),Ui=t("p"),Rf=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Vf=l(),Ki=t("p"),Uf=a(`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),Kf=l(),L=t("p"),sn=t("a"),Gf=a("PerceiverForImageClassificationLearned"),Jf=a(" uses "),nn=t("a"),Xf=a("PerceiverImagePreprocessor"),Zf=a(`
(with `),Gi=t("code"),Yf=a('prep_type="conv1x1"'),Qf=a(`) to preprocess the input images, and
`),an=t("a"),eg=a("PerceiverClassificationDecoder"),og=a(` to decode the latent representation of
`),cn=t("a"),rg=a("PerceiverModel"),tg=a(" into classification logits."),sg=l(),ms=t("p"),ng=a("This model is a PyTorch "),hs=t("a"),ag=a("torch.nn.Module"),ig=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),cg=l(),J=t("div"),_(us.$$.fragment),lg=l(),uo=t("p"),dg=a("The "),ln=t("a"),pg=a("PerceiverForImageClassificationLearned"),mg=a(" forward method, overrides the "),Ji=t("code"),hg=a("__call__"),ug=a(" special method."),fg=l(),_(pr.$$.fragment),gg=l(),_(mr.$$.fragment),Gl=l(),fo=t("h2"),hr=t("a"),Xi=t("span"),_(fs.$$.fragment),vg=l(),Zi=t("span"),_g=a("PerceiverForImageClassificationFourier"),Jl=l(),z=t("div"),_(gs.$$.fragment),Pg=l(),Yi=t("p"),bg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),wg=l(),Qi=t("p"),yg=a(`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),$g=l(),S=t("p"),dn=t("a"),kg=a("PerceiverForImageClassificationLearned"),Tg=a(" uses "),pn=t("a"),xg=a("PerceiverImagePreprocessor"),Eg=a(`
(with `),ec=t("code"),Cg=a('prep_type="pixels"'),jg=a(`) to preprocess the input images, and
`),mn=t("a"),Fg=a("PerceiverClassificationDecoder"),Ig=a(` to decode the latent representation of
`),hn=t("a"),Mg=a("PerceiverModel"),qg=a(" into classification logits."),zg=l(),vs=t("p"),Dg=a("This model is a PyTorch "),_s=t("a"),Ag=a("torch.nn.Module"),Og=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Ng=l(),X=t("div"),_(Ps.$$.fragment),Lg=l(),go=t("p"),Sg=a("The "),un=t("a"),Bg=a("PerceiverForImageClassificationFourier"),Wg=a(" forward method, overrides the "),oc=t("code"),Hg=a("__call__"),Rg=a(" special method."),Vg=l(),_(ur.$$.fragment),Ug=l(),_(fr.$$.fragment),Xl=l(),vo=t("h2"),gr=t("a"),rc=t("span"),_(bs.$$.fragment),Kg=l(),tc=t("span"),Gg=a("PerceiverForImageClassificationConvProcessing"),Zl=l(),D=t("div"),_(ws.$$.fragment),Jg=l(),sc=t("p"),Xg=a("Example use of Perceiver for image classification, for tasks such as ImageNet."),Zg=l(),nc=t("p"),Yg=a(`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),Qg=l(),B=t("p"),fn=t("a"),ev=a("PerceiverForImageClassificationLearned"),ov=a(" uses "),gn=t("a"),rv=a("PerceiverImagePreprocessor"),tv=a(`
(with `),ac=t("code"),sv=a('prep_type="conv"'),nv=a(`) to preprocess the input images, and
`),vn=t("a"),av=a("PerceiverClassificationDecoder"),iv=a(` to decode the latent representation of
`),_n=t("a"),cv=a("PerceiverModel"),lv=a(" into classification logits."),dv=l(),ys=t("p"),pv=a("This model is a PyTorch "),$s=t("a"),mv=a("torch.nn.Module"),hv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),uv=l(),Z=t("div"),_(ks.$$.fragment),fv=l(),_o=t("p"),gv=a("The "),Pn=t("a"),vv=a("PerceiverForImageClassificationConvProcessing"),_v=a(" forward method, overrides the "),ic=t("code"),Pv=a("__call__"),bv=a(" special method."),wv=l(),_(vr.$$.fragment),yv=l(),_(_r.$$.fragment),Yl=l(),Po=t("h2"),Pr=t("a"),cc=t("span"),_(Ts.$$.fragment),$v=l(),lc=t("span"),kv=a("PerceiverForOpticalFlow"),Ql=l(),O=t("div"),_(xs.$$.fragment),Tv=l(),N=t("p"),xv=a("Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),bn=t("a"),Ev=a("PerceiverForOpticalFlow"),Cv=a(` uses
`),wn=t("a"),jv=a("PerceiverImagePreprocessor"),Fv=a(" (with "),dc=t("em"),Iv=a("prep_type=\u201Cpatches\u201D"),Mv=a(`) to preprocess the
input images, and `),yn=t("a"),qv=a("PerceiverOpticalFlowDecoder"),zv=a(` to decode the latent
representation of `),$n=t("a"),Dv=a("PerceiverModel"),Av=a("."),Ov=l(),pc=t("p"),Nv=a(`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),Lv=l(),Es=t("p"),Sv=a("This model is a PyTorch "),Cs=t("a"),Bv=a("torch.nn.Module"),Wv=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Hv=l(),Y=t("div"),_(js.$$.fragment),Rv=l(),bo=t("p"),Vv=a("The "),kn=t("a"),Uv=a("PerceiverForOpticalFlow"),Kv=a(" forward method, overrides the "),mc=t("code"),Gv=a("__call__"),Jv=a(" special method."),Xv=l(),_(br.$$.fragment),Zv=l(),_(wr.$$.fragment),ed=l(),wo=t("h2"),yr=t("a"),hc=t("span"),_(Fs.$$.fragment),Yv=l(),uc=t("span"),Qv=a("PerceiverForMultimodalAutoencoding"),od=l(),F=t("div"),_(Is.$$.fragment),e_=l(),fc=t("p"),o_=a("Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),r_=l(),$r=t("p"),Tn=t("a"),t_=a("PerceiverForMultimodalAutoencoding"),s_=a(" uses "),xn=t("a"),n_=a("PerceiverMultimodalPreprocessor"),a_=a(` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),i_=l(),be=t("p"),En=t("a"),c_=a("PerceiverMultimodalDecoder"),l_=a(` is used to decode the latent representation of
`),Cn=t("a"),d_=a("PerceiverModel"),p_=a(`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),jn=t("a"),m_=a("PerceiverForMultimodalAutoencoding"),h_=a("."),u_=l(),kr=t("p"),Fn=t("a"),f_=a("PerceiverMultimodalDecoder"),g_=a(` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),In=t("a"),v_=a("PerceiverModel"),__=a("."),P_=l(),Ms=t("p"),b_=a("Finally, "),gc=t("code"),w_=a("~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor"),y_=a(` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),$_=l(),vc=t("p"),k_=a(`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),T_=l(),qs=t("p"),x_=a("This model is a PyTorch "),zs=t("a"),E_=a("torch.nn.Module"),C_=a(` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),j_=l(),Q=t("div"),_(Ds.$$.fragment),F_=l(),yo=t("p"),I_=a("The "),Mn=t("a"),M_=a("PerceiverForMultimodalAutoencoding"),q_=a(" forward method, overrides the "),_c=t("code"),z_=a("__call__"),D_=a(" special method."),A_=l(),_(Tr.$$.fragment),O_=l(),_(xr.$$.fragment),this.h()},l(o){const m=z2('[data-svelte="svelte-1phssyn"]',document.head);u=s(m,"META",{name:!0,content:!0}),m.forEach(r),T=d(o),v=s(o,"H1",{class:!0});var As=n(v);g=s(As,"A",{id:!0,class:!0,href:!0});var Pc=n(g);k=s(Pc,"SPAN",{});var bc=n(k);P(p.$$.fragment,bc),bc.forEach(r),Pc.forEach(r),f=d(As),j=s(As,"SPAN",{});var wc=n(j);mp=i(wc,"Perceiver"),wc.forEach(r),As.forEach(r),zc=d(o),$e=s(o,"H2",{class:!0});var Os=n($e);xo=s(Os,"A",{id:!0,class:!0,href:!0});var yc=n(xo);ea=s(yc,"SPAN",{});var $c=n(ea);P(Nr.$$.fragment,$c),$c.forEach(r),yc.forEach(r),hp=d(Os),oa=s(Os,"SPAN",{});var kc=n(oa);up=i(kc,"Overview"),kc.forEach(r),Os.forEach(r),Dc=d(o),Eo=s(o,"P",{});var Ns=n(Eo);fp=i(Ns,"The Perceiver IO model was proposed in "),Lr=s(Ns,"A",{href:!0,rel:!0});var Tc=n(Lr);gp=i(Tc,`Perceiver IO: A General Architecture for Structured Inputs &
Outputs`),Tc.forEach(r),vp=i(Ns,` by Andrew Jaegle, Sebastian Borgeaud, Jean-Baptiste Alayrac, Carl Doersch,
Catalin Ionescu, David Ding, Skanda Koppula, Daniel Zoran, Andrew Brock, Evan Shelhamer, Olivier H\xE9naff, Matthew M.
Botvinick, Andrew Zisserman, Oriol Vinyals, Jo\xE3o Carreira.`),Ns.forEach(r),Ac=d(o),Co=s(o,"P",{});var Ls=n(Co);_p=i(Ls,"Perceiver IO is a generalization of "),Sr=s(Ls,"A",{href:!0,rel:!0});var xc=n(Sr);Pp=i(xc,"Perceiver"),xc.forEach(r),bp=i(Ls,` to handle arbitrary outputs in
addition to arbitrary inputs. The original Perceiver only produced a single classification label. In addition to
classification labels, Perceiver IO can produce (for example) language, optical flow, and multimodal videos with audio.
This is done using the same building blocks as the original Perceiver. The computational complexity of Perceiver IO is
linear in the input and output size and the bulk of the processing occurs in the latent space, allowing us to process
inputs and outputs that are much larger than can be handled by standard Transformers. This means, for example,
Perceiver IO can do BERT-style masked language modeling directly using bytes instead of tokenized inputs.`),Ls.forEach(r),Oc=d(o),Ws=s(o,"P",{});var Ec=n(Ws);wp=i(Ec,"The abstract from the paper is the following:"),Ec.forEach(r),Nc=d(o),Hs=s(o,"P",{});var Cc=n(Hs);ra=s(Cc,"EM",{});var jc=n(ra);yp=i(jc,`The recently-proposed Perceiver model obtains good results on several domains (images, audio, multimodal, point
clouds) while scaling linearly in compute and memory with the input size. While the Perceiver supports many kinds of
inputs, it can only produce very simple outputs such as class scores. Perceiver IO overcomes this limitation without
sacrificing the original\u2019s appealing properties by learning to flexibly query the model\u2019s latent space to produce
outputs of arbitrary size and semantics. Perceiver IO still decouples model depth from data size and still scales
linearly with data size, but now with respect to both input and output sizes. The full Perceiver IO model achieves
strong results on tasks with highly structured output spaces, such as natural language and visual understanding,
StarCraft II, and multi-task and multi-modal domains. As highlights, Perceiver IO matches a Transformer-based BERT
baseline on the GLUE language benchmark without the need for input tokenization and achieves state-of-the-art
performance on Sintel optical flow estimation.`),jc.forEach(r),Cc.forEach(r),Lc=d(o),Rs=s(o,"P",{});var Fc=n(Rs);$p=i(Fc,"Here\u2019s a TLDR explaining how Perceiver works:"),Fc.forEach(r),Sc=d(o),Vs=s(o,"P",{});var Ic=n(Vs);kp=i(Ic,`The main problem with the self-attention mechanism of the Transformer is that the time and memory requirements scale
quadratically with the sequence length. Hence, models like BERT and RoBERTa are limited to a max sequence length of 512
tokens. Perceiver aims to solve this issue by, instead of performing self-attention on the inputs, perform it on a set
of latent variables, and only use the inputs for cross-attention. In this way, the time and memory requirements don\u2019t
depend on the length of the inputs anymore, as one uses a fixed amount of latent variables, like 256 or 512. These are
randomly initialized, after which they are trained end-to-end using backpropagation.`),Ic.forEach(r),Bc=d(o),A=s(o,"P",{});var ee=n(A);Tp=i(ee,"Internally, "),Us=s(ee,"A",{href:!0});var B_=n(Us);xp=i(B_,"PerceiverModel"),B_.forEach(r),Ep=i(ee," will create the latents, which is a tensor of shape "),ta=s(ee,"CODE",{});var W_=n(ta);Cp=i(W_,"(batch_size, num_latents, d_latents)"),W_.forEach(r),jp=i(ee,". One must provide "),sa=s(ee,"CODE",{});var H_=n(sa);Fp=i(H_,"inputs"),H_.forEach(r),Ip=i(ee,` (which could be text, images, audio, you name it!) to the model, which it will
use to perform cross-attention with the latents. The output of the Perceiver encoder is a tensor of the same shape. One
can then, similar to BERT, convert the last hidden states of the latents to classification logits by averaging along
the sequence dimension, and placing a linear layer on top of that to project the `),na=s(ee,"CODE",{});var R_=n(na);Mp=i(R_,"d_latents"),R_.forEach(r),qp=i(ee," to "),aa=s(ee,"CODE",{});var V_=n(aa);zp=i(V_,"num_labels"),V_.forEach(r),Dp=i(ee,"."),ee.forEach(r),Wc=d(o),Ks=s(o,"P",{});var U_=n(Ks);Ap=i(U_,`This was the idea of the original Perceiver paper. However, it could only output classification logits. In a follow-up
work, PerceiverIO, they generalized it to let the model also produce outputs of arbitrary size. How, you might ask? The
idea is actually relatively simple: one defines outputs of an arbitrary size, and then applies cross-attention with the
last hidden states of the latents, using the outputs as queries, and the latents as keys and values.`),U_.forEach(r),Hc=d(o),I=s(o,"P",{});var W=n(I);Op=i(W,`So let\u2019s say one wants to perform masked language modeling (BERT-style) with the Perceiver. As the Perceiver\u2019s input
length will not have an impact on the computation time of the self-attention layers, one can provide raw bytes,
providing `),ia=s(W,"CODE",{});var K_=n(ia);Np=i(K_,"inputs"),K_.forEach(r),Lp=i(W,` of length 2048 to the model. If one now masks out certain of these 2048 tokens, one can define the
`),ca=s(W,"CODE",{});var G_=n(ca);Sp=i(G_,"outputs"),G_.forEach(r),Bp=i(W," as being of shape: "),la=s(W,"CODE",{});var J_=n(la);Wp=i(J_,"(batch_size, 2048, 768)"),J_.forEach(r),Hp=i(W,`. Next, one performs cross-attention with the final hidden states
of the latents to update the `),da=s(W,"CODE",{});var X_=n(da);Rp=i(X_,"outputs"),X_.forEach(r),Vp=i(W," tensor. After cross-attention, one still has a tensor of shape "),pa=s(W,"CODE",{});var Z_=n(pa);Up=i(Z_,"(batch_size, 2048, 768)"),Z_.forEach(r),Kp=i(W,`. One can then place a regular language modeling head on top, to project the last dimension to the
vocabulary size of the model, i.e. creating logits of shape `),ma=s(W,"CODE",{});var Y_=n(ma);Gp=i(Y_,"(batch_size, 2048, 262)"),Y_.forEach(r),Jp=i(W,` (as Perceiver uses a vocabulary
size of 262 byte IDs).`),W.forEach(r),Rc=d(o),jo=s(o,"IMG",{src:!0,alt:!0,width:!0}),Vc=d(o),Br=s(o,"SMALL",{});var N_=n(Br);Xp=i(N_,"Perceiver IO architecture. Taken from the "),Gs=s(N_,"A",{href:!0});var Q_=n(Gs);Zp=i(Q_,"original paper"),Q_.forEach(r),N_.forEach(r),Uc=d(o),_e=s(o,"P",{});var qn=n(_e);Yp=i(qn,"This model was contributed by "),Wr=s(qn,"A",{href:!0,rel:!0});var eP=n(Wr);Qp=i(eP,"nielsr"),eP.forEach(r),em=i(qn,`. The original code can be found
`),Hr=s(qn,"A",{href:!0,rel:!0});var oP=n(Hr);om=i(oP,"here"),oP.forEach(r),rm=i(qn,"."),qn.forEach(r),Kc=d(o),Js=s(o,"P",{});var rP=n(Js);tm=i(rP,"Tips:"),rP.forEach(r),Gc=d(o),Fo=s(o,"UL",{});var td=n(Fo);Rr=s(td,"LI",{});var sd=n(Rr);sm=i(sd,"The quickest way to get started with the Perceiver is by checking the "),Vr=s(sd,"A",{href:!0,rel:!0});var tP=n(Vr);nm=i(tP,`tutorial
notebooks`),tP.forEach(r),am=i(sd,"."),sd.forEach(r),im=d(td),Ur=s(td,"LI",{});var nd=n(Ur);cm=i(nd,"Refer to the "),Kr=s(nd,"A",{href:!0,rel:!0});var sP=n(Kr);lm=i(sP,"blog post"),sP.forEach(r),dm=i(nd,` if you want to fully understand how the model works and
is implemented in the library. Note that the models available in the library only showcase some examples of what you can do
with the Perceiver. There are many more use cases, including question answering, named-entity recognition, object detection,
audio classification, video classification, etc.`),nd.forEach(r),td.forEach(r),Jc=d(o),Gr=s(o,"P",{});var L_=n(Gr);ha=s(L_,"STRONG",{});var nP=n(ha);pm=i(nP,"Note"),nP.forEach(r),mm=i(L_,":"),L_.forEach(r),Xc=d(o),Xs=s(o,"UL",{});var aP=n(Xs);Pe=s(aP,"LI",{});var Ss=n(Pe);hm=i(Ss,"Perceiver does "),ua=s(Ss,"STRONG",{});var iP=n(ua);um=i(iP,"not"),iP.forEach(r),fm=i(Ss," work with "),fa=s(Ss,"CODE",{});var cP=n(fa);gm=i(cP,"torch.nn.DataParallel"),cP.forEach(r),vm=i(Ss," due to a bug in PyTorch, see "),Jr=s(Ss,"A",{href:!0,rel:!0});var lP=n(Jr);_m=i(lP,"issue #36035"),lP.forEach(r),Ss.forEach(r),aP.forEach(r),Zc=d(o),ke=s(o,"H2",{class:!0});var ad=n(ke);Io=s(ad,"A",{id:!0,class:!0,href:!0});var dP=n(Io);ga=s(dP,"SPAN",{});var pP=n(ga);P(Xr.$$.fragment,pP),pP.forEach(r),dP.forEach(r),Pm=d(ad),va=s(ad,"SPAN",{});var mP=n(va);bm=i(mP,"Perceiver specific outputs"),mP.forEach(r),ad.forEach(r),Yc=d(o),Te=s(o,"DIV",{class:!0});var id=n(Te);P(Zr.$$.fragment,id),wm=d(id),_a=s(id,"P",{});var hP=n(_a);ym=i(hP,"Base class for Perceiver base model\u2019s outputs, with potential hidden states, attentions and cross-attentions."),hP.forEach(r),id.forEach(r),Qc=d(o),xe=s(o,"DIV",{class:!0});var cd=n(xe);P(Yr.$$.fragment,cd),$m=d(cd),Pa=s(cd,"P",{});var uP=n(Pa);km=i(uP,"Base class for Perceiver decoder outputs, with potential cross-attentions."),uP.forEach(r),cd.forEach(r),el=d(o),Ee=s(o,"DIV",{class:!0});var ld=n(Ee);P(Qr.$$.fragment,ld),Tm=d(ld),ba=s(ld,"P",{});var fP=n(ba);xm=i(fP,"Base class for Perceiver\u2019s masked language model outputs."),fP.forEach(r),ld.forEach(r),ol=d(o),Ce=s(o,"DIV",{class:!0});var dd=n(Ce);P(et.$$.fragment,dd),Em=d(dd),wa=s(dd,"P",{});var gP=n(wa);Cm=i(gP,`Base class for Perceiver\u2019s outputs of sequence/image classification models, optical flow and multimodal
autoencoding.`),gP.forEach(r),dd.forEach(r),rl=d(o),je=s(o,"H2",{class:!0});var pd=n(je);Mo=s(pd,"A",{id:!0,class:!0,href:!0});var vP=n(Mo);ya=s(vP,"SPAN",{});var _P=n(ya);P(ot.$$.fragment,_P),_P.forEach(r),vP.forEach(r),jm=d(pd),$a=s(pd,"SPAN",{});var PP=n($a);Fm=i(PP,"PerceiverConfig"),PP.forEach(r),pd.forEach(r),tl=d(o),H=s(o,"DIV",{class:!0});var Er=n(H);P(rt.$$.fragment,Er),Im=d(Er),Fe=s(Er,"P",{});var zn=n(Fe);Mm=i(zn,"This is the configuration class to store the configuration of a "),Zs=s(zn,"A",{href:!0});var bP=n(Zs);qm=i(bP,"PerceiverModel"),bP.forEach(r),zm=i(zn,`. It is used to instantiate an
Perceiver model according to the specified arguments, defining the model architecture. Instantiating a
configuration with the defaults will yield a similar configuration to that of the Perceiver
`),tt=s(zn,"A",{href:!0,rel:!0});var wP=n(tt);Dm=i(wP,"deepmind/language-perceiver"),wP.forEach(r),Am=i(zn," architecture."),zn.forEach(r),Om=d(Er),Ie=s(Er,"P",{});var Dn=n(Ie);Nm=i(Dn,"Configuration objects inherit from "),Ys=s(Dn,"A",{href:!0});var yP=n(Ys);Lm=i(yP,"PretrainedConfig"),yP.forEach(r),Sm=i(Dn,` and can be used to control the model outputs. Read the
documentation from `),Qs=s(Dn,"A",{href:!0});var $P=n(Qs);Bm=i($P,"PretrainedConfig"),$P.forEach(r),Wm=i(Dn," for more information."),Dn.forEach(r),Hm=d(Er),P(qo.$$.fragment,Er),Er.forEach(r),sl=d(o),Me=s(o,"H2",{class:!0});var md=n(Me);zo=s(md,"A",{id:!0,class:!0,href:!0});var kP=n(zo);ka=s(kP,"SPAN",{});var TP=n(ka);P(st.$$.fragment,TP),TP.forEach(r),kP.forEach(r),Rm=d(md),Ta=s(md,"SPAN",{});var xP=n(Ta);Vm=i(xP,"PerceiverTokenizer"),xP.forEach(r),md.forEach(r),nl=d(o),R=s(o,"DIV",{class:!0});var Cr=n(R);P(nt.$$.fragment,Cr),Um=d(Cr),xa=s(Cr,"P",{});var EP=n(xa);Km=i(EP,"Construct a Perceiver tokenizer. The Perceiver simply uses raw bytes utf-8 encoding."),EP.forEach(r),Gm=d(Cr),at=s(Cr,"P",{});var hd=n(at);Jm=i(hd,"This tokenizer inherits from "),en=s(hd,"A",{href:!0});var CP=n(en);Xm=i(CP,"PreTrainedTokenizer"),CP.forEach(r),Zm=i(hd,` which contains most of the main methods. Users should refer to
this superclass for more information regarding those methods.`),hd.forEach(r),Ym=d(Cr),Do=s(Cr,"DIV",{class:!0});var ud=n(Do);P(it.$$.fragment,ud),Qm=d(ud),Ea=s(ud,"P",{});var jP=n(Ea);eh=i(jP,`Main method to tokenize and prepare for the model one or several sequence(s) or one or several pair(s) of
sequences.`),jP.forEach(r),ud.forEach(r),Cr.forEach(r),al=d(o),qe=s(o,"H2",{class:!0});var fd=n(qe);Ao=s(fd,"A",{id:!0,class:!0,href:!0});var FP=n(Ao);Ca=s(FP,"SPAN",{});var IP=n(Ca);P(ct.$$.fragment,IP),IP.forEach(r),FP.forEach(r),oh=d(fd),ja=s(fd,"SPAN",{});var MP=n(ja);rh=i(MP,"PerceiverFeatureExtractor"),MP.forEach(r),fd.forEach(r),il=d(o),ne=s(o,"DIV",{class:!0});var An=n(ne);P(lt.$$.fragment,An),th=d(An),Fa=s(An,"P",{});var qP=n(Fa);sh=i(qP,"Constructs a Perceiver image processor."),qP.forEach(r),nh=d(An),Oo=s(An,"DIV",{class:!0});var gd=n(Oo);P(dt.$$.fragment,gd),ah=d(gd),Ia=s(gd,"P",{});var zP=n(Ia);ih=i(zP,"Preprocess an image or a batch of images."),zP.forEach(r),gd.forEach(r),An.forEach(r),cl=d(o),ze=s(o,"H2",{class:!0});var vd=n(ze);No=s(vd,"A",{id:!0,class:!0,href:!0});var DP=n(No);Ma=s(DP,"SPAN",{});var AP=n(Ma);P(pt.$$.fragment,AP),AP.forEach(r),DP.forEach(r),ch=d(vd),qa=s(vd,"SPAN",{});var OP=n(qa);lh=i(OP,"PerceiverImageProcessor"),OP.forEach(r),vd.forEach(r),ll=d(o),ae=s(o,"DIV",{class:!0});var On=n(ae);P(mt.$$.fragment,On),dh=d(On),za=s(On,"P",{});var NP=n(za);ph=i(NP,"Constructs a Perceiver image processor."),NP.forEach(r),mh=d(On),Lo=s(On,"DIV",{class:!0});var _d=n(Lo);P(ht.$$.fragment,_d),hh=d(_d),Da=s(_d,"P",{});var LP=n(Da);uh=i(LP,"Preprocess an image or batch of images."),LP.forEach(r),_d.forEach(r),On.forEach(r),dl=d(o),De=s(o,"H2",{class:!0});var Pd=n(De);So=s(Pd,"A",{id:!0,class:!0,href:!0});var SP=n(So);Aa=s(SP,"SPAN",{});var BP=n(Aa);P(ut.$$.fragment,BP),BP.forEach(r),SP.forEach(r),fh=d(Pd),Oa=s(Pd,"SPAN",{});var WP=n(Oa);gh=i(WP,"PerceiverTextPreprocessor"),WP.forEach(r),Pd.forEach(r),pl=d(o),ie=s(o,"DIV",{class:!0});var Nn=n(ie);P(ft.$$.fragment,Nn),vh=d(Nn),gt=s(Nn,"P",{});var bd=n(gt);_h=i(bd,"Text preprocessing for Perceiver Encoder. Can be used to embed "),Na=s(bd,"CODE",{});var HP=n(Na);Ph=i(HP,"inputs"),HP.forEach(r),bh=i(bd," and add positional encodings."),bd.forEach(r),wh=d(Nn),vt=s(Nn,"P",{});var wd=n(vt);yh=i(wd,"The dimensionality of the embeddings is determined by the "),La=s(wd,"CODE",{});var RP=n(La);$h=i(RP,"d_model"),RP.forEach(r),kh=i(wd," attribute of the configuration."),wd.forEach(r),Nn.forEach(r),ml=d(o),Ae=s(o,"H2",{class:!0});var yd=n(Ae);Bo=s(yd,"A",{id:!0,class:!0,href:!0});var VP=n(Bo);Sa=s(VP,"SPAN",{});var UP=n(Sa);P(_t.$$.fragment,UP),UP.forEach(r),VP.forEach(r),Th=d(yd),Ba=s(yd,"SPAN",{});var KP=n(Ba);xh=i(KP,"PerceiverImagePreprocessor"),KP.forEach(r),yd.forEach(r),hl=d(o),ce=s(o,"DIV",{class:!0});var Ln=n(ce);P(Pt.$$.fragment,Ln),Eh=d(Ln),Wa=s(Ln,"P",{});var GP=n(Wa);Ch=i(GP,"Image preprocessing for Perceiver Encoder."),GP.forEach(r),jh=d(Ln),V=s(Ln,"P",{});var we=n(V);Fh=i(we,"Note: the "),Ha=s(we,"EM",{});var JP=n(Ha);Ih=i(JP,"out_channels"),JP.forEach(r),Mh=i(we," argument refers to the output channels of a convolutional layer, if "),Ra=s(we,"EM",{});var XP=n(Ra);qh=i(XP,"prep_type"),XP.forEach(r),zh=i(we,` is set to
\u201Cconv1x1\u201D or \u201Cconv\u201D. If one adds absolute position embeddings, one must make sure the `),Va=s(we,"EM",{});var ZP=n(Va);Dh=i(ZP,"num_channels"),ZP.forEach(r),Ah=i(we,` of the
position encoding kwargs are set equal to the `),Ua=s(we,"EM",{});var YP=n(Ua);Oh=i(YP,"out_channels"),YP.forEach(r),Nh=i(we,"."),we.forEach(r),Ln.forEach(r),ul=d(o),Oe=s(o,"H2",{class:!0});var $d=n(Oe);Wo=s($d,"A",{id:!0,class:!0,href:!0});var QP=n(Wo);Ka=s(QP,"SPAN",{});var eb=n(Ka);P(bt.$$.fragment,eb),eb.forEach(r),QP.forEach(r),Lh=d($d),Ga=s($d,"SPAN",{});var ob=n(Ga);Sh=i(ob,"PerceiverOneHotPreprocessor"),ob.forEach(r),$d.forEach(r),fl=d(o),Ne=s(o,"DIV",{class:!0});var kd=n(Ne);P(wt.$$.fragment,kd),Bh=d(kd),Ja=s(kd,"P",{});var rb=n(Ja);Wh=i(rb,"One-hot preprocessor for Perceiver Encoder. Can be used to add a dummy index dimension to the input."),rb.forEach(r),kd.forEach(r),gl=d(o),Le=s(o,"H2",{class:!0});var Td=n(Le);Ho=s(Td,"A",{id:!0,class:!0,href:!0});var tb=n(Ho);Xa=s(tb,"SPAN",{});var sb=n(Xa);P(yt.$$.fragment,sb),sb.forEach(r),tb.forEach(r),Hh=d(Td),Za=s(Td,"SPAN",{});var nb=n(Za);Rh=i(nb,"PerceiverAudioPreprocessor"),nb.forEach(r),Td.forEach(r),vl=d(o),Se=s(o,"DIV",{class:!0});var xd=n(Se);P($t.$$.fragment,xd),Vh=d(xd),Ya=s(xd,"P",{});var ab=n(Ya);Uh=i(ab,"Audio preprocessing for Perceiver Encoder."),ab.forEach(r),xd.forEach(r),_l=d(o),Be=s(o,"H2",{class:!0});var Ed=n(Be);Ro=s(Ed,"A",{id:!0,class:!0,href:!0});var ib=n(Ro);Qa=s(ib,"SPAN",{});var cb=n(Qa);P(kt.$$.fragment,cb),cb.forEach(r),ib.forEach(r),Kh=d(Ed),ei=s(Ed,"SPAN",{});var lb=n(ei);Gh=i(lb,"PerceiverMultimodalPreprocessor"),lb.forEach(r),Ed.forEach(r),Pl=d(o),le=s(o,"DIV",{class:!0});var Sn=n(le);P(Tt.$$.fragment,Sn),Jh=d(Sn),oi=s(Sn,"P",{});var db=n(oi);Xh=i(db,"Multimodal preprocessing for Perceiver Encoder."),db.forEach(r),Zh=d(Sn),ri=s(Sn,"P",{});var pb=n(ri);Yh=i(pb,`Inputs for each modality are preprocessed, then padded with trainable position embeddings to have the same number
of channels.`),pb.forEach(r),Sn.forEach(r),bl=d(o),We=s(o,"H2",{class:!0});var Cd=n(We);Vo=s(Cd,"A",{id:!0,class:!0,href:!0});var mb=n(Vo);ti=s(mb,"SPAN",{});var hb=n(ti);P(xt.$$.fragment,hb),hb.forEach(r),mb.forEach(r),Qh=d(Cd),si=s(Cd,"SPAN",{});var ub=n(si);eu=i(ub,"PerceiverProjectionDecoder"),ub.forEach(r),Cd.forEach(r),wl=d(o),He=s(o,"DIV",{class:!0});var jd=n(He);P(Et.$$.fragment,jd),ou=d(jd),ni=s(jd,"P",{});var fb=n(ni);ru=i(fb,"Baseline projection decoder (no cross-attention)."),fb.forEach(r),jd.forEach(r),yl=d(o),Re=s(o,"H2",{class:!0});var Fd=n(Re);Uo=s(Fd,"A",{id:!0,class:!0,href:!0});var gb=n(Uo);ai=s(gb,"SPAN",{});var vb=n(ai);P(Ct.$$.fragment,vb),vb.forEach(r),gb.forEach(r),tu=d(Fd),ii=s(Fd,"SPAN",{});var _b=n(ii);su=i(_b,"PerceiverBasicDecoder"),_b.forEach(r),Fd.forEach(r),$l=d(o),de=s(o,"DIV",{class:!0});var Bn=n(de);P(jt.$$.fragment,Bn),nu=d(Bn),ci=s(Bn,"P",{});var Pb=n(ci);au=i(Pb,`Cross-attention-based decoder. This class can be used to decode the final hidden states of the latents using a
cross-attention operation, in which the latents produce keys and values.`),Pb.forEach(r),iu=d(Bn),li=s(Bn,"P",{});var bb=n(li);cu=i(bb,"The shape of the output of this class depends on how one defines the output queries (also called decoder queries)."),bb.forEach(r),Bn.forEach(r),kl=d(o),Ve=s(o,"H2",{class:!0});var Id=n(Ve);Ko=s(Id,"A",{id:!0,class:!0,href:!0});var wb=n(Ko);di=s(wb,"SPAN",{});var yb=n(di);P(Ft.$$.fragment,yb),yb.forEach(r),wb.forEach(r),lu=d(Id),pi=s(Id,"SPAN",{});var $b=n(pi);du=i($b,"PerceiverClassificationDecoder"),$b.forEach(r),Id.forEach(r),Tl=d(o),Ue=s(o,"DIV",{class:!0});var Md=n(Ue);P(It.$$.fragment,Md),pu=d(Md),Mt=s(Md,"P",{});var qd=n(Mt);mu=i(qd,"Cross-attention based classification decoder. Light-weight wrapper of "),mi=s(qd,"CODE",{});var kb=n(mi);hu=i(kb,"PerceiverBasicDecoder"),kb.forEach(r),uu=i(qd,` for logit output.
Will turn the output of the Perceiver encoder which is of shape (batch_size, num_latents, d_latents) to a tensor of
shape (batch_size, num_labels). The queries are of shape (batch_size, 1, num_labels).`),qd.forEach(r),Md.forEach(r),xl=d(o),Ke=s(o,"H2",{class:!0});var zd=n(Ke);Go=s(zd,"A",{id:!0,class:!0,href:!0});var Tb=n(Go);hi=s(Tb,"SPAN",{});var xb=n(hi);P(qt.$$.fragment,xb),xb.forEach(r),Tb.forEach(r),fu=d(zd),ui=s(zd,"SPAN",{});var Eb=n(ui);gu=i(Eb,"PerceiverOpticalFlowDecoder"),Eb.forEach(r),zd.forEach(r),El=d(o),Ge=s(o,"DIV",{class:!0});var Dd=n(Ge);P(zt.$$.fragment,Dd),vu=d(Dd),fi=s(Dd,"P",{});var Cb=n(fi);_u=i(Cb,"Cross-attention based optical flow decoder."),Cb.forEach(r),Dd.forEach(r),Cl=d(o),Je=s(o,"H2",{class:!0});var Ad=n(Je);Jo=s(Ad,"A",{id:!0,class:!0,href:!0});var jb=n(Jo);gi=s(jb,"SPAN",{});var Fb=n(gi);P(Dt.$$.fragment,Fb),Fb.forEach(r),jb.forEach(r),Pu=d(Ad),vi=s(Ad,"SPAN",{});var Ib=n(vi);bu=i(Ib,"PerceiverBasicVideoAutoencodingDecoder"),Ib.forEach(r),Ad.forEach(r),jl=d(o),Xe=s(o,"DIV",{class:!0});var Od=n(Xe);P(At.$$.fragment,Od),wu=d(Od),Ot=s(Od,"P",{});var Nd=n(Ot);yu=i(Nd,"Cross-attention based video-autoencoding decoder. Light-weight wrapper of ["),_i=s(Nd,"EM",{});var Mb=n(_i);$u=i(Mb,"PerceiverBasicDecoder"),Mb.forEach(r),ku=i(Nd,`] with video
reshaping logic.`),Nd.forEach(r),Od.forEach(r),Fl=d(o),Ze=s(o,"H2",{class:!0});var Ld=n(Ze);Xo=s(Ld,"A",{id:!0,class:!0,href:!0});var qb=n(Xo);Pi=s(qb,"SPAN",{});var zb=n(Pi);P(Nt.$$.fragment,zb),zb.forEach(r),qb.forEach(r),Tu=d(Ld),bi=s(Ld,"SPAN",{});var Db=n(bi);xu=i(Db,"PerceiverMultimodalDecoder"),Db.forEach(r),Ld.forEach(r),Il=d(o),pe=s(o,"DIV",{class:!0});var Wn=n(pe);P(Lt.$$.fragment,Wn),Eu=d(Wn),St=s(Wn,"P",{});var Sd=n(St);Cu=i(Sd,"Multimodal decoding by composing uni-modal decoders. The "),wi=s(Sd,"EM",{});var Ab=n(wi);ju=i(Ab,"modalities"),Ab.forEach(r),Fu=i(Sd,` argument of the constructor is a dictionary
mapping modality name to the decoder of that modality. That decoder will be used to construct queries for that
modality. Modality-specific queries are padded with trainable modality-specific parameters, after which they are
concatenated along the time dimension.`),Sd.forEach(r),Iu=d(Wn),yi=s(Wn,"P",{});var Ob=n(yi);Mu=i(Ob,"Next, there is a shared cross attention operation across all modalities."),Ob.forEach(r),Wn.forEach(r),Ml=d(o),Ye=s(o,"H2",{class:!0});var Bd=n(Ye);Zo=s(Bd,"A",{id:!0,class:!0,href:!0});var Nb=n(Zo);$i=s(Nb,"SPAN",{});var Lb=n($i);P(Bt.$$.fragment,Lb),Lb.forEach(r),Nb.forEach(r),qu=d(Bd),ki=s(Bd,"SPAN",{});var Sb=n(ki);zu=i(Sb,"PerceiverProjectionPostprocessor"),Sb.forEach(r),Bd.forEach(r),ql=d(o),Qe=s(o,"DIV",{class:!0});var Wd=n(Qe);P(Wt.$$.fragment,Wd),Du=d(Wd),Ti=s(Wd,"P",{});var Bb=n(Ti);Au=i(Bb,`Projection postprocessing for Perceiver. Can be used to project the channels of the decoder output to a lower
dimension.`),Bb.forEach(r),Wd.forEach(r),zl=d(o),eo=s(o,"H2",{class:!0});var Hd=n(eo);Yo=s(Hd,"A",{id:!0,class:!0,href:!0});var Wb=n(Yo);xi=s(Wb,"SPAN",{});var Hb=n(xi);P(Ht.$$.fragment,Hb),Hb.forEach(r),Wb.forEach(r),Ou=d(Hd),Ei=s(Hd,"SPAN",{});var Rb=n(Ei);Nu=i(Rb,"PerceiverAudioPostprocessor"),Rb.forEach(r),Hd.forEach(r),Dl=d(o),oo=s(o,"DIV",{class:!0});var Rd=n(oo);P(Rt.$$.fragment,Rd),Lu=d(Rd),Ci=s(Rd,"P",{});var Vb=n(Ci);Su=i(Vb,"Audio postprocessing for Perceiver. Can be used to convert the decoder output to audio features."),Vb.forEach(r),Rd.forEach(r),Al=d(o),ro=s(o,"H2",{class:!0});var Vd=n(ro);Qo=s(Vd,"A",{id:!0,class:!0,href:!0});var Ub=n(Qo);ji=s(Ub,"SPAN",{});var Kb=n(ji);P(Vt.$$.fragment,Kb),Kb.forEach(r),Ub.forEach(r),Bu=d(Vd),Fi=s(Vd,"SPAN",{});var Gb=n(Fi);Wu=i(Gb,"PerceiverClassificationPostprocessor"),Gb.forEach(r),Vd.forEach(r),Ol=d(o),to=s(o,"DIV",{class:!0});var Ud=n(to);P(Ut.$$.fragment,Ud),Hu=d(Ud),Ii=s(Ud,"P",{});var Jb=n(Ii);Ru=i(Jb,"Classification postprocessing for Perceiver. Can be used to convert the decoder output to classification logits."),Jb.forEach(r),Ud.forEach(r),Nl=d(o),so=s(o,"H2",{class:!0});var Kd=n(so);er=s(Kd,"A",{id:!0,class:!0,href:!0});var Xb=n(er);Mi=s(Xb,"SPAN",{});var Zb=n(Mi);P(Kt.$$.fragment,Zb),Zb.forEach(r),Xb.forEach(r),Vu=d(Kd),qi=s(Kd,"SPAN",{});var Yb=n(qi);Uu=i(Yb,"PerceiverMultimodalPostprocessor"),Yb.forEach(r),Kd.forEach(r),Ll=d(o),no=s(o,"DIV",{class:!0});var Gd=n(no);P(Gt.$$.fragment,Gd),Ku=d(Gd),zi=s(Gd,"P",{});var Qb=n(zi);Gu=i(Qb,`Multimodal postprocessing for Perceiver. Can be used to combine modality-specific postprocessors into a single
postprocessor.`),Qb.forEach(r),Gd.forEach(r),Sl=d(o),ao=s(o,"H2",{class:!0});var Jd=n(ao);or=s(Jd,"A",{id:!0,class:!0,href:!0});var e1=n(or);Di=s(e1,"SPAN",{});var o1=n(Di);P(Jt.$$.fragment,o1),o1.forEach(r),e1.forEach(r),Ju=d(Jd),Ai=s(Jd,"SPAN",{});var r1=n(Ai);Xu=i(r1,"PerceiverModel"),r1.forEach(r),Jd.forEach(r),Bl=d(o),me=s(o,"DIV",{class:!0});var Hn=n(me);P(Xt.$$.fragment,Hn),Zu=d(Hn),Zt=s(Hn,"P",{});var Xd=n(Zt);Yu=i(Xd,`The Perceiver: a scalable, fully attentional architecture.
This model is a PyTorch `),Yt=s(Xd,"A",{href:!0,rel:!0});var t1=n(Yt);Qu=i(t1,"torch.nn.Module"),t1.forEach(r),ef=i(Xd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Xd.forEach(r),of=d(Hn),U=s(Hn,"DIV",{class:!0});var jr=n(U);P(Qt.$$.fragment,jr),rf=d(jr),io=s(jr,"P",{});var Rn=n(io);tf=i(Rn,"The "),on=s(Rn,"A",{href:!0});var s1=n(on);sf=i(s1,"PerceiverModel"),s1.forEach(r),nf=i(Rn," forward method, overrides the "),Oi=s(Rn,"CODE",{});var n1=n(Oi);af=i(n1,"__call__"),n1.forEach(r),cf=i(Rn," special method."),Rn.forEach(r),lf=d(jr),P(rr.$$.fragment,jr),df=d(jr),P(tr.$$.fragment,jr),jr.forEach(r),Hn.forEach(r),Wl=d(o),co=s(o,"H2",{class:!0});var Zd=n(co);sr=s(Zd,"A",{id:!0,class:!0,href:!0});var a1=n(sr);Ni=s(a1,"SPAN",{});var i1=n(Ni);P(es.$$.fragment,i1),i1.forEach(r),a1.forEach(r),pf=d(Zd),Li=s(Zd,"SPAN",{});var c1=n(Li);mf=i(c1,"PerceiverForMaskedLM"),c1.forEach(r),Zd.forEach(r),Hl=d(o),he=s(o,"DIV",{class:!0});var Vn=n(he);P(os.$$.fragment,Vn),hf=d(Vn),rs=s(Vn,"P",{});var Yd=n(rs);uf=i(Yd,`Example use of Perceiver for masked language modeling.
This model is a PyTorch `),ts=s(Yd,"A",{href:!0,rel:!0});var l1=n(ts);ff=i(l1,"torch.nn.Module"),l1.forEach(r),gf=i(Yd,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),Yd.forEach(r),vf=d(Vn),K=s(Vn,"DIV",{class:!0});var Fr=n(K);P(ss.$$.fragment,Fr),_f=d(Fr),lo=s(Fr,"P",{});var Un=n(lo);Pf=i(Un,"The "),rn=s(Un,"A",{href:!0});var d1=n(rn);bf=i(d1,"PerceiverForMaskedLM"),d1.forEach(r),wf=i(Un," forward method, overrides the "),Si=s(Un,"CODE",{});var p1=n(Si);yf=i(p1,"__call__"),p1.forEach(r),$f=i(Un," special method."),Un.forEach(r),kf=d(Fr),P(nr.$$.fragment,Fr),Tf=d(Fr),P(ar.$$.fragment,Fr),Fr.forEach(r),Vn.forEach(r),Rl=d(o),po=s(o,"H2",{class:!0});var Qd=n(po);ir=s(Qd,"A",{id:!0,class:!0,href:!0});var m1=n(ir);Bi=s(m1,"SPAN",{});var h1=n(Bi);P(ns.$$.fragment,h1),h1.forEach(r),m1.forEach(r),xf=d(Qd),Wi=s(Qd,"SPAN",{});var u1=n(Wi);Ef=i(u1,"PerceiverForSequenceClassification"),u1.forEach(r),Qd.forEach(r),Vl=d(o),ue=s(o,"DIV",{class:!0});var Kn=n(ue);P(as.$$.fragment,Kn),Cf=d(Kn),is=s(Kn,"P",{});var ep=n(is);jf=i(ep,`Example use of Perceiver for text classification.
This model is a PyTorch `),cs=s(ep,"A",{href:!0,rel:!0});var f1=n(cs);Ff=i(f1,"torch.nn.Module"),f1.forEach(r),If=i(ep,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),ep.forEach(r),Mf=d(Kn),G=s(Kn,"DIV",{class:!0});var Ir=n(G);P(ls.$$.fragment,Ir),qf=d(Ir),mo=s(Ir,"P",{});var Gn=n(mo);zf=i(Gn,"The "),tn=s(Gn,"A",{href:!0});var g1=n(tn);Df=i(g1,"PerceiverForSequenceClassification"),g1.forEach(r),Af=i(Gn," forward method, overrides the "),Hi=s(Gn,"CODE",{});var v1=n(Hi);Of=i(v1,"__call__"),v1.forEach(r),Nf=i(Gn," special method."),Gn.forEach(r),Lf=d(Ir),P(cr.$$.fragment,Ir),Sf=d(Ir),P(lr.$$.fragment,Ir),Ir.forEach(r),Kn.forEach(r),Ul=d(o),ho=s(o,"H2",{class:!0});var op=n(ho);dr=s(op,"A",{id:!0,class:!0,href:!0});var _1=n(dr);Ri=s(_1,"SPAN",{});var P1=n(Ri);P(ds.$$.fragment,P1),P1.forEach(r),_1.forEach(r),Bf=d(op),Vi=s(op,"SPAN",{});var b1=n(Vi);Wf=i(b1,"PerceiverForImageClassificationLearned"),b1.forEach(r),op.forEach(r),Kl=d(o),q=s(o,"DIV",{class:!0});var oe=n(q);P(ps.$$.fragment,oe),Hf=d(oe),Ui=s(oe,"P",{});var w1=n(Ui);Rf=i(w1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),w1.forEach(r),Vf=d(oe),Ki=s(oe,"P",{});var y1=n(Ki);Uf=i(y1,`This model uses learned position embeddings. In other words, this model is not given any privileged information about
the structure of images. As shown in the paper, this model can achieve a top-1 accuracy of 72.7 on ImageNet.`),y1.forEach(r),Kf=d(oe),L=s(oe,"P",{});var fe=n(L);sn=s(fe,"A",{href:!0});var $1=n(sn);Gf=i($1,"PerceiverForImageClassificationLearned"),$1.forEach(r),Jf=i(fe," uses "),nn=s(fe,"A",{href:!0});var k1=n(nn);Xf=i(k1,"PerceiverImagePreprocessor"),k1.forEach(r),Zf=i(fe,`
(with `),Gi=s(fe,"CODE",{});var T1=n(Gi);Yf=i(T1,'prep_type="conv1x1"'),T1.forEach(r),Qf=i(fe,`) to preprocess the input images, and
`),an=s(fe,"A",{href:!0});var x1=n(an);eg=i(x1,"PerceiverClassificationDecoder"),x1.forEach(r),og=i(fe,` to decode the latent representation of
`),cn=s(fe,"A",{href:!0});var E1=n(cn);rg=i(E1,"PerceiverModel"),E1.forEach(r),tg=i(fe," into classification logits."),fe.forEach(r),sg=d(oe),ms=s(oe,"P",{});var rp=n(ms);ng=i(rp,"This model is a PyTorch "),hs=s(rp,"A",{href:!0,rel:!0});var C1=n(hs);ag=i(C1,"torch.nn.Module"),C1.forEach(r),ig=i(rp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),rp.forEach(r),cg=d(oe),J=s(oe,"DIV",{class:!0});var Mr=n(J);P(us.$$.fragment,Mr),lg=d(Mr),uo=s(Mr,"P",{});var Jn=n(uo);dg=i(Jn,"The "),ln=s(Jn,"A",{href:!0});var j1=n(ln);pg=i(j1,"PerceiverForImageClassificationLearned"),j1.forEach(r),mg=i(Jn," forward method, overrides the "),Ji=s(Jn,"CODE",{});var F1=n(Ji);hg=i(F1,"__call__"),F1.forEach(r),ug=i(Jn," special method."),Jn.forEach(r),fg=d(Mr),P(pr.$$.fragment,Mr),gg=d(Mr),P(mr.$$.fragment,Mr),Mr.forEach(r),oe.forEach(r),Gl=d(o),fo=s(o,"H2",{class:!0});var tp=n(fo);hr=s(tp,"A",{id:!0,class:!0,href:!0});var I1=n(hr);Xi=s(I1,"SPAN",{});var M1=n(Xi);P(fs.$$.fragment,M1),M1.forEach(r),I1.forEach(r),vg=d(tp),Zi=s(tp,"SPAN",{});var q1=n(Zi);_g=i(q1,"PerceiverForImageClassificationFourier"),q1.forEach(r),tp.forEach(r),Jl=d(o),z=s(o,"DIV",{class:!0});var re=n(z);P(gs.$$.fragment,re),Pg=d(re),Yi=s(re,"P",{});var z1=n(Yi);bg=i(z1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),z1.forEach(r),wg=d(re),Qi=s(re,"P",{});var D1=n(Qi);yg=i(D1,`This model uses fixed 2D Fourier position embeddings. As shown in the paper, this model can achieve a top-1 accuracy of
79.0 on ImageNet, and 84.5 when pre-trained on a large-scale dataset (i.e. JFT).`),D1.forEach(r),$g=d(re),S=s(re,"P",{});var ge=n(S);dn=s(ge,"A",{href:!0});var A1=n(dn);kg=i(A1,"PerceiverForImageClassificationLearned"),A1.forEach(r),Tg=i(ge," uses "),pn=s(ge,"A",{href:!0});var O1=n(pn);xg=i(O1,"PerceiverImagePreprocessor"),O1.forEach(r),Eg=i(ge,`
(with `),ec=s(ge,"CODE",{});var N1=n(ec);Cg=i(N1,'prep_type="pixels"'),N1.forEach(r),jg=i(ge,`) to preprocess the input images, and
`),mn=s(ge,"A",{href:!0});var L1=n(mn);Fg=i(L1,"PerceiverClassificationDecoder"),L1.forEach(r),Ig=i(ge,` to decode the latent representation of
`),hn=s(ge,"A",{href:!0});var S1=n(hn);Mg=i(S1,"PerceiverModel"),S1.forEach(r),qg=i(ge," into classification logits."),ge.forEach(r),zg=d(re),vs=s(re,"P",{});var sp=n(vs);Dg=i(sp,"This model is a PyTorch "),_s=s(sp,"A",{href:!0,rel:!0});var B1=n(_s);Ag=i(B1,"torch.nn.Module"),B1.forEach(r),Og=i(sp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),sp.forEach(r),Ng=d(re),X=s(re,"DIV",{class:!0});var qr=n(X);P(Ps.$$.fragment,qr),Lg=d(qr),go=s(qr,"P",{});var Xn=n(go);Sg=i(Xn,"The "),un=s(Xn,"A",{href:!0});var W1=n(un);Bg=i(W1,"PerceiverForImageClassificationFourier"),W1.forEach(r),Wg=i(Xn," forward method, overrides the "),oc=s(Xn,"CODE",{});var H1=n(oc);Hg=i(H1,"__call__"),H1.forEach(r),Rg=i(Xn," special method."),Xn.forEach(r),Vg=d(qr),P(ur.$$.fragment,qr),Ug=d(qr),P(fr.$$.fragment,qr),qr.forEach(r),re.forEach(r),Xl=d(o),vo=s(o,"H2",{class:!0});var np=n(vo);gr=s(np,"A",{id:!0,class:!0,href:!0});var R1=n(gr);rc=s(R1,"SPAN",{});var V1=n(rc);P(bs.$$.fragment,V1),V1.forEach(r),R1.forEach(r),Kg=d(np),tc=s(np,"SPAN",{});var U1=n(tc);Gg=i(U1,"PerceiverForImageClassificationConvProcessing"),U1.forEach(r),np.forEach(r),Zl=d(o),D=s(o,"DIV",{class:!0});var te=n(D);P(ws.$$.fragment,te),Jg=d(te),sc=s(te,"P",{});var K1=n(sc);Xg=i(K1,"Example use of Perceiver for image classification, for tasks such as ImageNet."),K1.forEach(r),Zg=d(te),nc=s(te,"P",{});var G1=n(nc);Yg=i(G1,`This model uses a 2D conv+maxpool preprocessing network. As shown in the paper, this model can achieve a top-1 accuracy
of 82.1 on ImageNet.`),G1.forEach(r),Qg=d(te),B=s(te,"P",{});var ve=n(B);fn=s(ve,"A",{href:!0});var J1=n(fn);ev=i(J1,"PerceiverForImageClassificationLearned"),J1.forEach(r),ov=i(ve," uses "),gn=s(ve,"A",{href:!0});var X1=n(gn);rv=i(X1,"PerceiverImagePreprocessor"),X1.forEach(r),tv=i(ve,`
(with `),ac=s(ve,"CODE",{});var Z1=n(ac);sv=i(Z1,'prep_type="conv"'),Z1.forEach(r),nv=i(ve,`) to preprocess the input images, and
`),vn=s(ve,"A",{href:!0});var Y1=n(vn);av=i(Y1,"PerceiverClassificationDecoder"),Y1.forEach(r),iv=i(ve,` to decode the latent representation of
`),_n=s(ve,"A",{href:!0});var Q1=n(_n);cv=i(Q1,"PerceiverModel"),Q1.forEach(r),lv=i(ve," into classification logits."),ve.forEach(r),dv=d(te),ys=s(te,"P",{});var ap=n(ys);pv=i(ap,"This model is a PyTorch "),$s=s(ap,"A",{href:!0,rel:!0});var e2=n($s);mv=i(e2,"torch.nn.Module"),e2.forEach(r),hv=i(ap,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),ap.forEach(r),uv=d(te),Z=s(te,"DIV",{class:!0});var zr=n(Z);P(ks.$$.fragment,zr),fv=d(zr),_o=s(zr,"P",{});var Zn=n(_o);gv=i(Zn,"The "),Pn=s(Zn,"A",{href:!0});var o2=n(Pn);vv=i(o2,"PerceiverForImageClassificationConvProcessing"),o2.forEach(r),_v=i(Zn," forward method, overrides the "),ic=s(Zn,"CODE",{});var r2=n(ic);Pv=i(r2,"__call__"),r2.forEach(r),bv=i(Zn," special method."),Zn.forEach(r),wv=d(zr),P(vr.$$.fragment,zr),yv=d(zr),P(_r.$$.fragment,zr),zr.forEach(r),te.forEach(r),Yl=d(o),Po=s(o,"H2",{class:!0});var ip=n(Po);Pr=s(ip,"A",{id:!0,class:!0,href:!0});var t2=n(Pr);cc=s(t2,"SPAN",{});var s2=n(cc);P(Ts.$$.fragment,s2),s2.forEach(r),t2.forEach(r),$v=d(ip),lc=s(ip,"SPAN",{});var n2=n(lc);kv=i(n2,"PerceiverForOpticalFlow"),n2.forEach(r),ip.forEach(r),Ql=d(o),O=s(o,"DIV",{class:!0});var ye=n(O);P(xs.$$.fragment,ye),Tv=d(ye),N=s(ye,"P",{});var se=n(N);xv=i(se,"Example use of Perceiver for optical flow, for tasks such as Sintel and KITTI. "),bn=s(se,"A",{href:!0});var a2=n(bn);Ev=i(a2,"PerceiverForOpticalFlow"),a2.forEach(r),Cv=i(se,` uses
`),wn=s(se,"A",{href:!0});var i2=n(wn);jv=i(i2,"PerceiverImagePreprocessor"),i2.forEach(r),Fv=i(se," (with "),dc=s(se,"EM",{});var c2=n(dc);Iv=i(c2,"prep_type=\u201Cpatches\u201D"),c2.forEach(r),Mv=i(se,`) to preprocess the
input images, and `),yn=s(se,"A",{href:!0});var l2=n(yn);qv=i(l2,"PerceiverOpticalFlowDecoder"),l2.forEach(r),zv=i(se,` to decode the latent
representation of `),$n=s(se,"A",{href:!0});var d2=n($n);Dv=i(d2,"PerceiverModel"),d2.forEach(r),Av=i(se,"."),se.forEach(r),Ov=d(ye),pc=s(ye,"P",{});var p2=n(pc);Nv=i(p2,`As input, one concatenates 2 subsequent frames along the channel dimension and extract a 3 x 3 patch around each pixel
(leading to 3 x 3 x 3 x 2 = 54 values for each pixel). Fixed Fourier position encodings are used to encode the position
of each pixel in the patch. Next, one applies the Perceiver encoder. To decode, one queries the latent representation
using the same encoding used for the input.`),p2.forEach(r),Lv=d(ye),Es=s(ye,"P",{});var cp=n(Es);Sv=i(cp,"This model is a PyTorch "),Cs=s(cp,"A",{href:!0,rel:!0});var m2=n(Cs);Bv=i(m2,"torch.nn.Module"),m2.forEach(r),Wv=i(cp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),cp.forEach(r),Hv=d(ye),Y=s(ye,"DIV",{class:!0});var Dr=n(Y);P(js.$$.fragment,Dr),Rv=d(Dr),bo=s(Dr,"P",{});var Yn=n(bo);Vv=i(Yn,"The "),kn=s(Yn,"A",{href:!0});var h2=n(kn);Uv=i(h2,"PerceiverForOpticalFlow"),h2.forEach(r),Kv=i(Yn," forward method, overrides the "),mc=s(Yn,"CODE",{});var u2=n(mc);Gv=i(u2,"__call__"),u2.forEach(r),Jv=i(Yn," special method."),Yn.forEach(r),Xv=d(Dr),P(br.$$.fragment,Dr),Zv=d(Dr),P(wr.$$.fragment,Dr),Dr.forEach(r),ye.forEach(r),ed=d(o),wo=s(o,"H2",{class:!0});var lp=n(wo);yr=s(lp,"A",{id:!0,class:!0,href:!0});var f2=n(yr);hc=s(f2,"SPAN",{});var g2=n(hc);P(Fs.$$.fragment,g2),g2.forEach(r),f2.forEach(r),Yv=d(lp),uc=s(lp,"SPAN",{});var v2=n(uc);Qv=i(v2,"PerceiverForMultimodalAutoencoding"),v2.forEach(r),lp.forEach(r),od=d(o),F=s(o,"DIV",{class:!0});var M=n(F);P(Is.$$.fragment,M),e_=d(M),fc=s(M,"P",{});var _2=n(fc);o_=i(_2,"Example use of Perceiver for multimodal (video) autoencoding, for tasks such as Kinetics-700."),_2.forEach(r),r_=d(M),$r=s(M,"P",{});var Mc=n($r);Tn=s(Mc,"A",{href:!0});var P2=n(Tn);t_=i(P2,"PerceiverForMultimodalAutoencoding"),P2.forEach(r),s_=i(Mc," uses "),xn=s(Mc,"A",{href:!0});var b2=n(xn);n_=i(b2,"PerceiverMultimodalPreprocessor"),b2.forEach(r),a_=i(Mc,` to
preprocess the 3 modalities: images, audio and class labels. This preprocessor uses modality-specific preprocessors to
preprocess every modality separately, after which they are concatenated. Trainable position embeddings are used to pad
each modality to the same number of channels to make concatenation along the time dimension possible. Next, one applies
the Perceiver encoder.`),Mc.forEach(r),i_=d(M),be=s(M,"P",{});var Bs=n(be);En=s(Bs,"A",{href:!0});var w2=n(En);c_=i(w2,"PerceiverMultimodalDecoder"),w2.forEach(r),l_=i(Bs,` is used to decode the latent representation of
`),Cn=s(Bs,"A",{href:!0});var y2=n(Cn);d_=i(y2,"PerceiverModel"),y2.forEach(r),p_=i(Bs,`. This decoder uses each modality-specific decoder to construct queries. The decoder queries are
created based on the inputs after preprocessing. However, autoencoding an entire video in a single forward pass is
computationally infeasible, hence one only uses parts of the decoder queries to do cross-attention with the latent
representation. This is determined by the subsampled indices for each modality, which can be provided as additional
input to the forward pass of `),jn=s(Bs,"A",{href:!0});var $2=n(jn);m_=i($2,"PerceiverForMultimodalAutoencoding"),$2.forEach(r),h_=i(Bs,"."),Bs.forEach(r),u_=d(M),kr=s(M,"P",{});var qc=n(kr);Fn=s(qc,"A",{href:!0});var k2=n(Fn);f_=i(k2,"PerceiverMultimodalDecoder"),k2.forEach(r),g_=i(qc,` also pads the decoder queries of the different
modalities to the same number of channels, in order to concatenate them along the time dimension. Next, cross-attention
is performed with the latent representation of `),In=s(qc,"A",{href:!0});var T2=n(In);v_=i(T2,"PerceiverModel"),T2.forEach(r),__=i(qc,"."),qc.forEach(r),P_=d(M),Ms=s(M,"P",{});var dp=n(Ms);b_=i(dp,"Finally, "),gc=s(dp,"CODE",{});var x2=n(gc);w_=i(x2,"~models.perceiver.modeling_perceiver.PerceiverMultiModalPostprocessor"),x2.forEach(r),y_=i(dp,` is used to turn this tensor into an
actual video. It first splits up the output into the different modalities, and then applies the respective
postprocessor for each modality.`),dp.forEach(r),$_=d(M),vc=s(M,"P",{});var E2=n(vc);k_=i(E2,`Note that, by masking the classification label during evaluation (i.e. simply providing a tensor of zeros for the
\u201Clabel\u201D modality), this auto-encoding model becomes a Kinetics 700 video classifier.`),E2.forEach(r),T_=d(M),qs=s(M,"P",{});var pp=n(qs);x_=i(pp,"This model is a PyTorch "),zs=s(pp,"A",{href:!0,rel:!0});var C2=n(zs);E_=i(C2,"torch.nn.Module"),C2.forEach(r),C_=i(pp,` sub-class. Use
it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage and
behavior.`),pp.forEach(r),j_=d(M),Q=s(M,"DIV",{class:!0});var Ar=n(Q);P(Ds.$$.fragment,Ar),F_=d(Ar),yo=s(Ar,"P",{});var Qn=n(yo);I_=i(Qn,"The "),Mn=s(Qn,"A",{href:!0});var j2=n(Mn);M_=i(j2,"PerceiverForMultimodalAutoencoding"),j2.forEach(r),q_=i(Qn," forward method, overrides the "),_c=s(Qn,"CODE",{});var F2=n(_c);z_=i(F2,"__call__"),F2.forEach(r),D_=i(Qn," special method."),Qn.forEach(r),A_=d(Ar),P(Tr.$$.fragment,Ar),O_=d(Ar),P(xr.$$.fragment,Ar),Ar.forEach(r),M.forEach(r),this.h()},h(){c(u,"name","hf:doc:metadata"),c(u,"content",JSON.stringify(ow)),c(g,"id","perceiver"),c(g,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(g,"href","#perceiver"),c(v,"class","relative group"),c(xo,"id","overview"),c(xo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(xo,"href","#overview"),c($e,"class","relative group"),c(Lr,"href","https://arxiv.org/abs/2107.14795"),c(Lr,"rel","nofollow"),c(Sr,"href","https://arxiv.org/abs/2103.03206"),c(Sr,"rel","nofollow"),c(Us,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),D2(jo.src,S_="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/perceiver_architecture.jpg")||c(jo,"src",S_),c(jo,"alt","drawing"),c(jo,"width","600"),c(Gs,"href","https://arxiv.org/abs/2105.15203"),c(Wr,"href","https://huggingface.co/nielsr"),c(Wr,"rel","nofollow"),c(Hr,"href","https://github.com/deepmind/deepmind-research/tree/master/perceiver"),c(Hr,"rel","nofollow"),c(Vr,"href","https://github.com/NielsRogge/Transformers-Tutorials/tree/master/Perceiver"),c(Vr,"rel","nofollow"),c(Kr,"href","https://huggingface.co/blog/perceiver"),c(Kr,"rel","nofollow"),c(Jr,"href","https://github.com/pytorch/pytorch/issues/36035"),c(Jr,"rel","nofollow"),c(Io,"id","transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(Io,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Io,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput"),c(ke,"class","relative group"),c(Te,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ee,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Mo,"id","transformers.PerceiverConfig"),c(Mo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Mo,"href","#transformers.PerceiverConfig"),c(je,"class","relative group"),c(Zs,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(tt,"href","https://huggingface.co/deepmind/language-perceiver"),c(tt,"rel","nofollow"),c(Ys,"href","/docs/transformers/v4.25.1/en/main_classes/configuration#transformers.PretrainedConfig"),c(Qs,"href","/docs/transformers/v4.25.1/en/main_classes/configuration#transformers.PretrainedConfig"),c(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(zo,"id","transformers.PerceiverTokenizer"),c(zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(zo,"href","#transformers.PerceiverTokenizer"),c(Me,"class","relative group"),c(en,"href","/docs/transformers/v4.25.1/en/main_classes/tokenizer#transformers.PreTrainedTokenizer"),c(Do,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ao,"id","transformers.PerceiverImageProcessor"),c(Ao,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ao,"href","#transformers.PerceiverImageProcessor"),c(qe,"class","relative group"),c(Oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(No,"id","transformers.PerceiverImageProcessor"),c(No,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(No,"href","#transformers.PerceiverImageProcessor"),c(ze,"class","relative group"),c(Lo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(So,"id","transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(So,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(So,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor"),c(De,"class","relative group"),c(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Bo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Bo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Bo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(Ae,"class","relative group"),c(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Wo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Wo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Wo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor"),c(Oe,"class","relative group"),c(Ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ho,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Ho,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ho,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor"),c(Le,"class","relative group"),c(Se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ro,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Ro,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ro,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(Be,"class","relative group"),c(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Vo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(Vo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Vo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder"),c(We,"class","relative group"),c(He,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Uo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Uo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Uo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder"),c(Re,"class","relative group"),c(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Ko,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Ko,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Ko,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(Ve,"class","relative group"),c(Ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Go,"id","transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Go,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Go,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c(Ke,"class","relative group"),c(Ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Jo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Jo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Jo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder"),c(Je,"class","relative group"),c(Xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Xo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Xo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Xo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Ze,"class","relative group"),c(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Zo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Zo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Zo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor"),c(Ye,"class","relative group"),c(Qe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Yo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(Yo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Yo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor"),c(eo,"class","relative group"),c(oo,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Qo,"id","transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(Qo,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Qo,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor"),c(ro,"class","relative group"),c(to,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(er,"id","transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(er,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(er,"href","#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor"),c(so,"class","relative group"),c(no,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(or,"id","transformers.PerceiverModel"),c(or,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(or,"href","#transformers.PerceiverModel"),c(ao,"class","relative group"),c(Yt,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Yt,"rel","nofollow"),c(on,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(sr,"id","transformers.PerceiverForMaskedLM"),c(sr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(sr,"href","#transformers.PerceiverForMaskedLM"),c(co,"class","relative group"),c(ts,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(ts,"rel","nofollow"),c(rn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForMaskedLM"),c(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ir,"id","transformers.PerceiverForSequenceClassification"),c(ir,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(ir,"href","#transformers.PerceiverForSequenceClassification"),c(po,"class","relative group"),c(cs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(cs,"rel","nofollow"),c(tn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForSequenceClassification"),c(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(dr,"id","transformers.PerceiverForImageClassificationLearned"),c(dr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(dr,"href","#transformers.PerceiverForImageClassificationLearned"),c(ho,"class","relative group"),c(sn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(nn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(an,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(cn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(hs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(hs,"rel","nofollow"),c(ln,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(hr,"id","transformers.PerceiverForImageClassificationFourier"),c(hr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(hr,"href","#transformers.PerceiverForImageClassificationFourier"),c(fo,"class","relative group"),c(dn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(pn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(mn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(hn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(_s,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(_s,"rel","nofollow"),c(un,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationFourier"),c(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(gr,"id","transformers.PerceiverForImageClassificationConvProcessing"),c(gr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(gr,"href","#transformers.PerceiverForImageClassificationConvProcessing"),c(vo,"class","relative group"),c(fn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationLearned"),c(gn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(vn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder"),c(_n,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c($s,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c($s,"rel","nofollow"),c(Pn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForImageClassificationConvProcessing"),c(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(Pr,"id","transformers.PerceiverForOpticalFlow"),c(Pr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(Pr,"href","#transformers.PerceiverForOpticalFlow"),c(Po,"class","relative group"),c(bn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(wn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor"),c(yn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder"),c($n,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(Cs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(Cs,"rel","nofollow"),c(kn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForOpticalFlow"),c(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(yr,"id","transformers.PerceiverForMultimodalAutoencoding"),c(yr,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),c(yr,"href","#transformers.PerceiverForMultimodalAutoencoding"),c(wo,"class","relative group"),c(Tn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(xn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor"),c(En,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(Cn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(jn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(Fn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder"),c(In,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverModel"),c(zs,"href","https://pytorch.org/docs/stable/nn.html#torch.nn.Module"),c(zs,"rel","nofollow"),c(Mn,"href","/docs/transformers/v4.25.1/en/model_doc/perceiver#transformers.PerceiverForMultimodalAutoencoding"),c(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),c(F,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(o,m){e(document.head,u),h(o,T,m),h(o,v,m),e(v,g),e(g,k),b(p,k,null),e(v,f),e(v,j),e(j,mp),h(o,zc,m),h(o,$e,m),e($e,xo),e(xo,ea),b(Nr,ea,null),e($e,hp),e($e,oa),e(oa,up),h(o,Dc,m),h(o,Eo,m),e(Eo,fp),e(Eo,Lr),e(Lr,gp),e(Eo,vp),h(o,Ac,m),h(o,Co,m),e(Co,_p),e(Co,Sr),e(Sr,Pp),e(Co,bp),h(o,Oc,m),h(o,Ws,m),e(Ws,wp),h(o,Nc,m),h(o,Hs,m),e(Hs,ra),e(ra,yp),h(o,Lc,m),h(o,Rs,m),e(Rs,$p),h(o,Sc,m),h(o,Vs,m),e(Vs,kp),h(o,Bc,m),h(o,A,m),e(A,Tp),e(A,Us),e(Us,xp),e(A,Ep),e(A,ta),e(ta,Cp),e(A,jp),e(A,sa),e(sa,Fp),e(A,Ip),e(A,na),e(na,Mp),e(A,qp),e(A,aa),e(aa,zp),e(A,Dp),h(o,Wc,m),h(o,Ks,m),e(Ks,Ap),h(o,Hc,m),h(o,I,m),e(I,Op),e(I,ia),e(ia,Np),e(I,Lp),e(I,ca),e(ca,Sp),e(I,Bp),e(I,la),e(la,Wp),e(I,Hp),e(I,da),e(da,Rp),e(I,Vp),e(I,pa),e(pa,Up),e(I,Kp),e(I,ma),e(ma,Gp),e(I,Jp),h(o,Rc,m),h(o,jo,m),h(o,Vc,m),h(o,Br,m),e(Br,Xp),e(Br,Gs),e(Gs,Zp),h(o,Uc,m),h(o,_e,m),e(_e,Yp),e(_e,Wr),e(Wr,Qp),e(_e,em),e(_e,Hr),e(Hr,om),e(_e,rm),h(o,Kc,m),h(o,Js,m),e(Js,tm),h(o,Gc,m),h(o,Fo,m),e(Fo,Rr),e(Rr,sm),e(Rr,Vr),e(Vr,nm),e(Rr,am),e(Fo,im),e(Fo,Ur),e(Ur,cm),e(Ur,Kr),e(Kr,lm),e(Ur,dm),h(o,Jc,m),h(o,Gr,m),e(Gr,ha),e(ha,pm),e(Gr,mm),h(o,Xc,m),h(o,Xs,m),e(Xs,Pe),e(Pe,hm),e(Pe,ua),e(ua,um),e(Pe,fm),e(Pe,fa),e(fa,gm),e(Pe,vm),e(Pe,Jr),e(Jr,_m),h(o,Zc,m),h(o,ke,m),e(ke,Io),e(Io,ga),b(Xr,ga,null),e(ke,Pm),e(ke,va),e(va,bm),h(o,Yc,m),h(o,Te,m),b(Zr,Te,null),e(Te,wm),e(Te,_a),e(_a,ym),h(o,Qc,m),h(o,xe,m),b(Yr,xe,null),e(xe,$m),e(xe,Pa),e(Pa,km),h(o,el,m),h(o,Ee,m),b(Qr,Ee,null),e(Ee,Tm),e(Ee,ba),e(ba,xm),h(o,ol,m),h(o,Ce,m),b(et,Ce,null),e(Ce,Em),e(Ce,wa),e(wa,Cm),h(o,rl,m),h(o,je,m),e(je,Mo),e(Mo,ya),b(ot,ya,null),e(je,jm),e(je,$a),e($a,Fm),h(o,tl,m),h(o,H,m),b(rt,H,null),e(H,Im),e(H,Fe),e(Fe,Mm),e(Fe,Zs),e(Zs,qm),e(Fe,zm),e(Fe,tt),e(tt,Dm),e(Fe,Am),e(H,Om),e(H,Ie),e(Ie,Nm),e(Ie,Ys),e(Ys,Lm),e(Ie,Sm),e(Ie,Qs),e(Qs,Bm),e(Ie,Wm),e(H,Hm),b(qo,H,null),h(o,sl,m),h(o,Me,m),e(Me,zo),e(zo,ka),b(st,ka,null),e(Me,Rm),e(Me,Ta),e(Ta,Vm),h(o,nl,m),h(o,R,m),b(nt,R,null),e(R,Um),e(R,xa),e(xa,Km),e(R,Gm),e(R,at),e(at,Jm),e(at,en),e(en,Xm),e(at,Zm),e(R,Ym),e(R,Do),b(it,Do,null),e(Do,Qm),e(Do,Ea),e(Ea,eh),h(o,al,m),h(o,qe,m),e(qe,Ao),e(Ao,Ca),b(ct,Ca,null),e(qe,oh),e(qe,ja),e(ja,rh),h(o,il,m),h(o,ne,m),b(lt,ne,null),e(ne,th),e(ne,Fa),e(Fa,sh),e(ne,nh),e(ne,Oo),b(dt,Oo,null),e(Oo,ah),e(Oo,Ia),e(Ia,ih),h(o,cl,m),h(o,ze,m),e(ze,No),e(No,Ma),b(pt,Ma,null),e(ze,ch),e(ze,qa),e(qa,lh),h(o,ll,m),h(o,ae,m),b(mt,ae,null),e(ae,dh),e(ae,za),e(za,ph),e(ae,mh),e(ae,Lo),b(ht,Lo,null),e(Lo,hh),e(Lo,Da),e(Da,uh),h(o,dl,m),h(o,De,m),e(De,So),e(So,Aa),b(ut,Aa,null),e(De,fh),e(De,Oa),e(Oa,gh),h(o,pl,m),h(o,ie,m),b(ft,ie,null),e(ie,vh),e(ie,gt),e(gt,_h),e(gt,Na),e(Na,Ph),e(gt,bh),e(ie,wh),e(ie,vt),e(vt,yh),e(vt,La),e(La,$h),e(vt,kh),h(o,ml,m),h(o,Ae,m),e(Ae,Bo),e(Bo,Sa),b(_t,Sa,null),e(Ae,Th),e(Ae,Ba),e(Ba,xh),h(o,hl,m),h(o,ce,m),b(Pt,ce,null),e(ce,Eh),e(ce,Wa),e(Wa,Ch),e(ce,jh),e(ce,V),e(V,Fh),e(V,Ha),e(Ha,Ih),e(V,Mh),e(V,Ra),e(Ra,qh),e(V,zh),e(V,Va),e(Va,Dh),e(V,Ah),e(V,Ua),e(Ua,Oh),e(V,Nh),h(o,ul,m),h(o,Oe,m),e(Oe,Wo),e(Wo,Ka),b(bt,Ka,null),e(Oe,Lh),e(Oe,Ga),e(Ga,Sh),h(o,fl,m),h(o,Ne,m),b(wt,Ne,null),e(Ne,Bh),e(Ne,Ja),e(Ja,Wh),h(o,gl,m),h(o,Le,m),e(Le,Ho),e(Ho,Xa),b(yt,Xa,null),e(Le,Hh),e(Le,Za),e(Za,Rh),h(o,vl,m),h(o,Se,m),b($t,Se,null),e(Se,Vh),e(Se,Ya),e(Ya,Uh),h(o,_l,m),h(o,Be,m),e(Be,Ro),e(Ro,Qa),b(kt,Qa,null),e(Be,Kh),e(Be,ei),e(ei,Gh),h(o,Pl,m),h(o,le,m),b(Tt,le,null),e(le,Jh),e(le,oi),e(oi,Xh),e(le,Zh),e(le,ri),e(ri,Yh),h(o,bl,m),h(o,We,m),e(We,Vo),e(Vo,ti),b(xt,ti,null),e(We,Qh),e(We,si),e(si,eu),h(o,wl,m),h(o,He,m),b(Et,He,null),e(He,ou),e(He,ni),e(ni,ru),h(o,yl,m),h(o,Re,m),e(Re,Uo),e(Uo,ai),b(Ct,ai,null),e(Re,tu),e(Re,ii),e(ii,su),h(o,$l,m),h(o,de,m),b(jt,de,null),e(de,nu),e(de,ci),e(ci,au),e(de,iu),e(de,li),e(li,cu),h(o,kl,m),h(o,Ve,m),e(Ve,Ko),e(Ko,di),b(Ft,di,null),e(Ve,lu),e(Ve,pi),e(pi,du),h(o,Tl,m),h(o,Ue,m),b(It,Ue,null),e(Ue,pu),e(Ue,Mt),e(Mt,mu),e(Mt,mi),e(mi,hu),e(Mt,uu),h(o,xl,m),h(o,Ke,m),e(Ke,Go),e(Go,hi),b(qt,hi,null),e(Ke,fu),e(Ke,ui),e(ui,gu),h(o,El,m),h(o,Ge,m),b(zt,Ge,null),e(Ge,vu),e(Ge,fi),e(fi,_u),h(o,Cl,m),h(o,Je,m),e(Je,Jo),e(Jo,gi),b(Dt,gi,null),e(Je,Pu),e(Je,vi),e(vi,bu),h(o,jl,m),h(o,Xe,m),b(At,Xe,null),e(Xe,wu),e(Xe,Ot),e(Ot,yu),e(Ot,_i),e(_i,$u),e(Ot,ku),h(o,Fl,m),h(o,Ze,m),e(Ze,Xo),e(Xo,Pi),b(Nt,Pi,null),e(Ze,Tu),e(Ze,bi),e(bi,xu),h(o,Il,m),h(o,pe,m),b(Lt,pe,null),e(pe,Eu),e(pe,St),e(St,Cu),e(St,wi),e(wi,ju),e(St,Fu),e(pe,Iu),e(pe,yi),e(yi,Mu),h(o,Ml,m),h(o,Ye,m),e(Ye,Zo),e(Zo,$i),b(Bt,$i,null),e(Ye,qu),e(Ye,ki),e(ki,zu),h(o,ql,m),h(o,Qe,m),b(Wt,Qe,null),e(Qe,Du),e(Qe,Ti),e(Ti,Au),h(o,zl,m),h(o,eo,m),e(eo,Yo),e(Yo,xi),b(Ht,xi,null),e(eo,Ou),e(eo,Ei),e(Ei,Nu),h(o,Dl,m),h(o,oo,m),b(Rt,oo,null),e(oo,Lu),e(oo,Ci),e(Ci,Su),h(o,Al,m),h(o,ro,m),e(ro,Qo),e(Qo,ji),b(Vt,ji,null),e(ro,Bu),e(ro,Fi),e(Fi,Wu),h(o,Ol,m),h(o,to,m),b(Ut,to,null),e(to,Hu),e(to,Ii),e(Ii,Ru),h(o,Nl,m),h(o,so,m),e(so,er),e(er,Mi),b(Kt,Mi,null),e(so,Vu),e(so,qi),e(qi,Uu),h(o,Ll,m),h(o,no,m),b(Gt,no,null),e(no,Ku),e(no,zi),e(zi,Gu),h(o,Sl,m),h(o,ao,m),e(ao,or),e(or,Di),b(Jt,Di,null),e(ao,Ju),e(ao,Ai),e(Ai,Xu),h(o,Bl,m),h(o,me,m),b(Xt,me,null),e(me,Zu),e(me,Zt),e(Zt,Yu),e(Zt,Yt),e(Yt,Qu),e(Zt,ef),e(me,of),e(me,U),b(Qt,U,null),e(U,rf),e(U,io),e(io,tf),e(io,on),e(on,sf),e(io,nf),e(io,Oi),e(Oi,af),e(io,cf),e(U,lf),b(rr,U,null),e(U,df),b(tr,U,null),h(o,Wl,m),h(o,co,m),e(co,sr),e(sr,Ni),b(es,Ni,null),e(co,pf),e(co,Li),e(Li,mf),h(o,Hl,m),h(o,he,m),b(os,he,null),e(he,hf),e(he,rs),e(rs,uf),e(rs,ts),e(ts,ff),e(rs,gf),e(he,vf),e(he,K),b(ss,K,null),e(K,_f),e(K,lo),e(lo,Pf),e(lo,rn),e(rn,bf),e(lo,wf),e(lo,Si),e(Si,yf),e(lo,$f),e(K,kf),b(nr,K,null),e(K,Tf),b(ar,K,null),h(o,Rl,m),h(o,po,m),e(po,ir),e(ir,Bi),b(ns,Bi,null),e(po,xf),e(po,Wi),e(Wi,Ef),h(o,Vl,m),h(o,ue,m),b(as,ue,null),e(ue,Cf),e(ue,is),e(is,jf),e(is,cs),e(cs,Ff),e(is,If),e(ue,Mf),e(ue,G),b(ls,G,null),e(G,qf),e(G,mo),e(mo,zf),e(mo,tn),e(tn,Df),e(mo,Af),e(mo,Hi),e(Hi,Of),e(mo,Nf),e(G,Lf),b(cr,G,null),e(G,Sf),b(lr,G,null),h(o,Ul,m),h(o,ho,m),e(ho,dr),e(dr,Ri),b(ds,Ri,null),e(ho,Bf),e(ho,Vi),e(Vi,Wf),h(o,Kl,m),h(o,q,m),b(ps,q,null),e(q,Hf),e(q,Ui),e(Ui,Rf),e(q,Vf),e(q,Ki),e(Ki,Uf),e(q,Kf),e(q,L),e(L,sn),e(sn,Gf),e(L,Jf),e(L,nn),e(nn,Xf),e(L,Zf),e(L,Gi),e(Gi,Yf),e(L,Qf),e(L,an),e(an,eg),e(L,og),e(L,cn),e(cn,rg),e(L,tg),e(q,sg),e(q,ms),e(ms,ng),e(ms,hs),e(hs,ag),e(ms,ig),e(q,cg),e(q,J),b(us,J,null),e(J,lg),e(J,uo),e(uo,dg),e(uo,ln),e(ln,pg),e(uo,mg),e(uo,Ji),e(Ji,hg),e(uo,ug),e(J,fg),b(pr,J,null),e(J,gg),b(mr,J,null),h(o,Gl,m),h(o,fo,m),e(fo,hr),e(hr,Xi),b(fs,Xi,null),e(fo,vg),e(fo,Zi),e(Zi,_g),h(o,Jl,m),h(o,z,m),b(gs,z,null),e(z,Pg),e(z,Yi),e(Yi,bg),e(z,wg),e(z,Qi),e(Qi,yg),e(z,$g),e(z,S),e(S,dn),e(dn,kg),e(S,Tg),e(S,pn),e(pn,xg),e(S,Eg),e(S,ec),e(ec,Cg),e(S,jg),e(S,mn),e(mn,Fg),e(S,Ig),e(S,hn),e(hn,Mg),e(S,qg),e(z,zg),e(z,vs),e(vs,Dg),e(vs,_s),e(_s,Ag),e(vs,Og),e(z,Ng),e(z,X),b(Ps,X,null),e(X,Lg),e(X,go),e(go,Sg),e(go,un),e(un,Bg),e(go,Wg),e(go,oc),e(oc,Hg),e(go,Rg),e(X,Vg),b(ur,X,null),e(X,Ug),b(fr,X,null),h(o,Xl,m),h(o,vo,m),e(vo,gr),e(gr,rc),b(bs,rc,null),e(vo,Kg),e(vo,tc),e(tc,Gg),h(o,Zl,m),h(o,D,m),b(ws,D,null),e(D,Jg),e(D,sc),e(sc,Xg),e(D,Zg),e(D,nc),e(nc,Yg),e(D,Qg),e(D,B),e(B,fn),e(fn,ev),e(B,ov),e(B,gn),e(gn,rv),e(B,tv),e(B,ac),e(ac,sv),e(B,nv),e(B,vn),e(vn,av),e(B,iv),e(B,_n),e(_n,cv),e(B,lv),e(D,dv),e(D,ys),e(ys,pv),e(ys,$s),e($s,mv),e(ys,hv),e(D,uv),e(D,Z),b(ks,Z,null),e(Z,fv),e(Z,_o),e(_o,gv),e(_o,Pn),e(Pn,vv),e(_o,_v),e(_o,ic),e(ic,Pv),e(_o,bv),e(Z,wv),b(vr,Z,null),e(Z,yv),b(_r,Z,null),h(o,Yl,m),h(o,Po,m),e(Po,Pr),e(Pr,cc),b(Ts,cc,null),e(Po,$v),e(Po,lc),e(lc,kv),h(o,Ql,m),h(o,O,m),b(xs,O,null),e(O,Tv),e(O,N),e(N,xv),e(N,bn),e(bn,Ev),e(N,Cv),e(N,wn),e(wn,jv),e(N,Fv),e(N,dc),e(dc,Iv),e(N,Mv),e(N,yn),e(yn,qv),e(N,zv),e(N,$n),e($n,Dv),e(N,Av),e(O,Ov),e(O,pc),e(pc,Nv),e(O,Lv),e(O,Es),e(Es,Sv),e(Es,Cs),e(Cs,Bv),e(Es,Wv),e(O,Hv),e(O,Y),b(js,Y,null),e(Y,Rv),e(Y,bo),e(bo,Vv),e(bo,kn),e(kn,Uv),e(bo,Kv),e(bo,mc),e(mc,Gv),e(bo,Jv),e(Y,Xv),b(br,Y,null),e(Y,Zv),b(wr,Y,null),h(o,ed,m),h(o,wo,m),e(wo,yr),e(yr,hc),b(Fs,hc,null),e(wo,Yv),e(wo,uc),e(uc,Qv),h(o,od,m),h(o,F,m),b(Is,F,null),e(F,e_),e(F,fc),e(fc,o_),e(F,r_),e(F,$r),e($r,Tn),e(Tn,t_),e($r,s_),e($r,xn),e(xn,n_),e($r,a_),e(F,i_),e(F,be),e(be,En),e(En,c_),e(be,l_),e(be,Cn),e(Cn,d_),e(be,p_),e(be,jn),e(jn,m_),e(be,h_),e(F,u_),e(F,kr),e(kr,Fn),e(Fn,f_),e(kr,g_),e(kr,In),e(In,v_),e(kr,__),e(F,P_),e(F,Ms),e(Ms,b_),e(Ms,gc),e(gc,w_),e(Ms,y_),e(F,$_),e(F,vc),e(vc,k_),e(F,T_),e(F,qs),e(qs,x_),e(qs,zs),e(zs,E_),e(qs,C_),e(F,j_),e(F,Q),b(Ds,Q,null),e(Q,F_),e(Q,yo),e(yo,I_),e(yo,Mn),e(Mn,M_),e(yo,q_),e(yo,_c),e(_c,z_),e(yo,D_),e(Q,A_),b(Tr,Q,null),e(Q,O_),b(xr,Q,null),rd=!0},p(o,[m]){const As={};m&2&&(As.$$scope={dirty:m,ctx:o}),qo.$set(As);const Pc={};m&2&&(Pc.$$scope={dirty:m,ctx:o}),rr.$set(Pc);const bc={};m&2&&(bc.$$scope={dirty:m,ctx:o}),tr.$set(bc);const wc={};m&2&&(wc.$$scope={dirty:m,ctx:o}),nr.$set(wc);const Os={};m&2&&(Os.$$scope={dirty:m,ctx:o}),ar.$set(Os);const yc={};m&2&&(yc.$$scope={dirty:m,ctx:o}),cr.$set(yc);const $c={};m&2&&($c.$$scope={dirty:m,ctx:o}),lr.$set($c);const kc={};m&2&&(kc.$$scope={dirty:m,ctx:o}),pr.$set(kc);const Ns={};m&2&&(Ns.$$scope={dirty:m,ctx:o}),mr.$set(Ns);const Tc={};m&2&&(Tc.$$scope={dirty:m,ctx:o}),ur.$set(Tc);const Ls={};m&2&&(Ls.$$scope={dirty:m,ctx:o}),fr.$set(Ls);const xc={};m&2&&(xc.$$scope={dirty:m,ctx:o}),vr.$set(xc);const Ec={};m&2&&(Ec.$$scope={dirty:m,ctx:o}),_r.$set(Ec);const Cc={};m&2&&(Cc.$$scope={dirty:m,ctx:o}),br.$set(Cc);const jc={};m&2&&(jc.$$scope={dirty:m,ctx:o}),wr.$set(jc);const Fc={};m&2&&(Fc.$$scope={dirty:m,ctx:o}),Tr.$set(Fc);const Ic={};m&2&&(Ic.$$scope={dirty:m,ctx:o}),xr.$set(Ic)},i(o){rd||(w(p.$$.fragment,o),w(Nr.$$.fragment,o),w(Xr.$$.fragment,o),w(Zr.$$.fragment,o),w(Yr.$$.fragment,o),w(Qr.$$.fragment,o),w(et.$$.fragment,o),w(ot.$$.fragment,o),w(rt.$$.fragment,o),w(qo.$$.fragment,o),w(st.$$.fragment,o),w(nt.$$.fragment,o),w(it.$$.fragment,o),w(ct.$$.fragment,o),w(lt.$$.fragment,o),w(dt.$$.fragment,o),w(pt.$$.fragment,o),w(mt.$$.fragment,o),w(ht.$$.fragment,o),w(ut.$$.fragment,o),w(ft.$$.fragment,o),w(_t.$$.fragment,o),w(Pt.$$.fragment,o),w(bt.$$.fragment,o),w(wt.$$.fragment,o),w(yt.$$.fragment,o),w($t.$$.fragment,o),w(kt.$$.fragment,o),w(Tt.$$.fragment,o),w(xt.$$.fragment,o),w(Et.$$.fragment,o),w(Ct.$$.fragment,o),w(jt.$$.fragment,o),w(Ft.$$.fragment,o),w(It.$$.fragment,o),w(qt.$$.fragment,o),w(zt.$$.fragment,o),w(Dt.$$.fragment,o),w(At.$$.fragment,o),w(Nt.$$.fragment,o),w(Lt.$$.fragment,o),w(Bt.$$.fragment,o),w(Wt.$$.fragment,o),w(Ht.$$.fragment,o),w(Rt.$$.fragment,o),w(Vt.$$.fragment,o),w(Ut.$$.fragment,o),w(Kt.$$.fragment,o),w(Gt.$$.fragment,o),w(Jt.$$.fragment,o),w(Xt.$$.fragment,o),w(Qt.$$.fragment,o),w(rr.$$.fragment,o),w(tr.$$.fragment,o),w(es.$$.fragment,o),w(os.$$.fragment,o),w(ss.$$.fragment,o),w(nr.$$.fragment,o),w(ar.$$.fragment,o),w(ns.$$.fragment,o),w(as.$$.fragment,o),w(ls.$$.fragment,o),w(cr.$$.fragment,o),w(lr.$$.fragment,o),w(ds.$$.fragment,o),w(ps.$$.fragment,o),w(us.$$.fragment,o),w(pr.$$.fragment,o),w(mr.$$.fragment,o),w(fs.$$.fragment,o),w(gs.$$.fragment,o),w(Ps.$$.fragment,o),w(ur.$$.fragment,o),w(fr.$$.fragment,o),w(bs.$$.fragment,o),w(ws.$$.fragment,o),w(ks.$$.fragment,o),w(vr.$$.fragment,o),w(_r.$$.fragment,o),w(Ts.$$.fragment,o),w(xs.$$.fragment,o),w(js.$$.fragment,o),w(br.$$.fragment,o),w(wr.$$.fragment,o),w(Fs.$$.fragment,o),w(Is.$$.fragment,o),w(Ds.$$.fragment,o),w(Tr.$$.fragment,o),w(xr.$$.fragment,o),rd=!0)},o(o){y(p.$$.fragment,o),y(Nr.$$.fragment,o),y(Xr.$$.fragment,o),y(Zr.$$.fragment,o),y(Yr.$$.fragment,o),y(Qr.$$.fragment,o),y(et.$$.fragment,o),y(ot.$$.fragment,o),y(rt.$$.fragment,o),y(qo.$$.fragment,o),y(st.$$.fragment,o),y(nt.$$.fragment,o),y(it.$$.fragment,o),y(ct.$$.fragment,o),y(lt.$$.fragment,o),y(dt.$$.fragment,o),y(pt.$$.fragment,o),y(mt.$$.fragment,o),y(ht.$$.fragment,o),y(ut.$$.fragment,o),y(ft.$$.fragment,o),y(_t.$$.fragment,o),y(Pt.$$.fragment,o),y(bt.$$.fragment,o),y(wt.$$.fragment,o),y(yt.$$.fragment,o),y($t.$$.fragment,o),y(kt.$$.fragment,o),y(Tt.$$.fragment,o),y(xt.$$.fragment,o),y(Et.$$.fragment,o),y(Ct.$$.fragment,o),y(jt.$$.fragment,o),y(Ft.$$.fragment,o),y(It.$$.fragment,o),y(qt.$$.fragment,o),y(zt.$$.fragment,o),y(Dt.$$.fragment,o),y(At.$$.fragment,o),y(Nt.$$.fragment,o),y(Lt.$$.fragment,o),y(Bt.$$.fragment,o),y(Wt.$$.fragment,o),y(Ht.$$.fragment,o),y(Rt.$$.fragment,o),y(Vt.$$.fragment,o),y(Ut.$$.fragment,o),y(Kt.$$.fragment,o),y(Gt.$$.fragment,o),y(Jt.$$.fragment,o),y(Xt.$$.fragment,o),y(Qt.$$.fragment,o),y(rr.$$.fragment,o),y(tr.$$.fragment,o),y(es.$$.fragment,o),y(os.$$.fragment,o),y(ss.$$.fragment,o),y(nr.$$.fragment,o),y(ar.$$.fragment,o),y(ns.$$.fragment,o),y(as.$$.fragment,o),y(ls.$$.fragment,o),y(cr.$$.fragment,o),y(lr.$$.fragment,o),y(ds.$$.fragment,o),y(ps.$$.fragment,o),y(us.$$.fragment,o),y(pr.$$.fragment,o),y(mr.$$.fragment,o),y(fs.$$.fragment,o),y(gs.$$.fragment,o),y(Ps.$$.fragment,o),y(ur.$$.fragment,o),y(fr.$$.fragment,o),y(bs.$$.fragment,o),y(ws.$$.fragment,o),y(ks.$$.fragment,o),y(vr.$$.fragment,o),y(_r.$$.fragment,o),y(Ts.$$.fragment,o),y(xs.$$.fragment,o),y(js.$$.fragment,o),y(br.$$.fragment,o),y(wr.$$.fragment,o),y(Fs.$$.fragment,o),y(Is.$$.fragment,o),y(Ds.$$.fragment,o),y(Tr.$$.fragment,o),y(xr.$$.fragment,o),rd=!1},d(o){r(u),o&&r(T),o&&r(v),$(p),o&&r(zc),o&&r($e),$(Nr),o&&r(Dc),o&&r(Eo),o&&r(Ac),o&&r(Co),o&&r(Oc),o&&r(Ws),o&&r(Nc),o&&r(Hs),o&&r(Lc),o&&r(Rs),o&&r(Sc),o&&r(Vs),o&&r(Bc),o&&r(A),o&&r(Wc),o&&r(Ks),o&&r(Hc),o&&r(I),o&&r(Rc),o&&r(jo),o&&r(Vc),o&&r(Br),o&&r(Uc),o&&r(_e),o&&r(Kc),o&&r(Js),o&&r(Gc),o&&r(Fo),o&&r(Jc),o&&r(Gr),o&&r(Xc),o&&r(Xs),o&&r(Zc),o&&r(ke),$(Xr),o&&r(Yc),o&&r(Te),$(Zr),o&&r(Qc),o&&r(xe),$(Yr),o&&r(el),o&&r(Ee),$(Qr),o&&r(ol),o&&r(Ce),$(et),o&&r(rl),o&&r(je),$(ot),o&&r(tl),o&&r(H),$(rt),$(qo),o&&r(sl),o&&r(Me),$(st),o&&r(nl),o&&r(R),$(nt),$(it),o&&r(al),o&&r(qe),$(ct),o&&r(il),o&&r(ne),$(lt),$(dt),o&&r(cl),o&&r(ze),$(pt),o&&r(ll),o&&r(ae),$(mt),$(ht),o&&r(dl),o&&r(De),$(ut),o&&r(pl),o&&r(ie),$(ft),o&&r(ml),o&&r(Ae),$(_t),o&&r(hl),o&&r(ce),$(Pt),o&&r(ul),o&&r(Oe),$(bt),o&&r(fl),o&&r(Ne),$(wt),o&&r(gl),o&&r(Le),$(yt),o&&r(vl),o&&r(Se),$($t),o&&r(_l),o&&r(Be),$(kt),o&&r(Pl),o&&r(le),$(Tt),o&&r(bl),o&&r(We),$(xt),o&&r(wl),o&&r(He),$(Et),o&&r(yl),o&&r(Re),$(Ct),o&&r($l),o&&r(de),$(jt),o&&r(kl),o&&r(Ve),$(Ft),o&&r(Tl),o&&r(Ue),$(It),o&&r(xl),o&&r(Ke),$(qt),o&&r(El),o&&r(Ge),$(zt),o&&r(Cl),o&&r(Je),$(Dt),o&&r(jl),o&&r(Xe),$(At),o&&r(Fl),o&&r(Ze),$(Nt),o&&r(Il),o&&r(pe),$(Lt),o&&r(Ml),o&&r(Ye),$(Bt),o&&r(ql),o&&r(Qe),$(Wt),o&&r(zl),o&&r(eo),$(Ht),o&&r(Dl),o&&r(oo),$(Rt),o&&r(Al),o&&r(ro),$(Vt),o&&r(Ol),o&&r(to),$(Ut),o&&r(Nl),o&&r(so),$(Kt),o&&r(Ll),o&&r(no),$(Gt),o&&r(Sl),o&&r(ao),$(Jt),o&&r(Bl),o&&r(me),$(Xt),$(Qt),$(rr),$(tr),o&&r(Wl),o&&r(co),$(es),o&&r(Hl),o&&r(he),$(os),$(ss),$(nr),$(ar),o&&r(Rl),o&&r(po),$(ns),o&&r(Vl),o&&r(ue),$(as),$(ls),$(cr),$(lr),o&&r(Ul),o&&r(ho),$(ds),o&&r(Kl),o&&r(q),$(ps),$(us),$(pr),$(mr),o&&r(Gl),o&&r(fo),$(fs),o&&r(Jl),o&&r(z),$(gs),$(Ps),$(ur),$(fr),o&&r(Xl),o&&r(vo),$(bs),o&&r(Zl),o&&r(D),$(ws),$(ks),$(vr),$(_r),o&&r(Yl),o&&r(Po),$(Ts),o&&r(Ql),o&&r(O),$(xs),$(js),$(br),$(wr),o&&r(ed),o&&r(wo),$(Fs),o&&r(od),o&&r(F),$(Is),$(Ds),$(Tr),$(xr)}}}const ow={local:"perceiver",sections:[{local:"overview",title:"Overview"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverModelOutput",title:"Perceiver specific outputs"},{local:"transformers.PerceiverConfig",title:"PerceiverConfig"},{local:"transformers.PerceiverTokenizer",title:"PerceiverTokenizer"},{local:"transformers.PerceiverImageProcessor",title:"PerceiverFeatureExtractor"},{local:"transformers.PerceiverImageProcessor",title:"PerceiverImageProcessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverTextPreprocessor",title:"PerceiverTextPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverImagePreprocessor",title:"PerceiverImagePreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOneHotPreprocessor",title:"PerceiverOneHotPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPreprocessor",title:"PerceiverAudioPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPreprocessor",title:"PerceiverMultimodalPreprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionDecoder",title:"PerceiverProjectionDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicDecoder",title:"PerceiverBasicDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationDecoder",title:"PerceiverClassificationDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverOpticalFlowDecoder",title:"PerceiverOpticalFlowDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverBasicVideoAutoencodingDecoder",title:"PerceiverBasicVideoAutoencodingDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalDecoder",title:"PerceiverMultimodalDecoder"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverProjectionPostprocessor",title:"PerceiverProjectionPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverAudioPostprocessor",title:"PerceiverAudioPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverClassificationPostprocessor",title:"PerceiverClassificationPostprocessor"},{local:"transformers.models.perceiver.modeling_perceiver.PerceiverMultimodalPostprocessor",title:"PerceiverMultimodalPostprocessor"},{local:"transformers.PerceiverModel",title:"PerceiverModel"},{local:"transformers.PerceiverForMaskedLM",title:"PerceiverForMaskedLM"},{local:"transformers.PerceiverForSequenceClassification",title:"PerceiverForSequenceClassification"},{local:"transformers.PerceiverForImageClassificationLearned",title:"PerceiverForImageClassificationLearned"},{local:"transformers.PerceiverForImageClassificationFourier",title:"PerceiverForImageClassificationFourier"},{local:"transformers.PerceiverForImageClassificationConvProcessing",title:"PerceiverForImageClassificationConvProcessing"},{local:"transformers.PerceiverForOpticalFlow",title:"PerceiverForOpticalFlow"},{local:"transformers.PerceiverForMultimodalAutoencoding",title:"PerceiverForMultimodalAutoencoding"}],title:"Perceiver"};function rw(E){return A2(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class lw extends I2{constructor(u){super();M2(this,u,rw,ew,q2,{})}}export{lw as default,ow as metadata};
