import{s as ot,n as st,o as rt}from"../chunks/scheduler.924d507e.js";import{S as dt,i as mt,g as o,s as l,r as F,A as pt,h as s,f as i,c as n,j as nt,u as X,x as r,k as ze,y as ft,a,v as G,d as Q,t as S,w as E}from"../chunks/index.0ece89e8.js";import{C as ht}from"../chunks/CodeBlock.d01ac312.js";import{H as Y}from"../chunks/Heading.c9bff43c.js";function ct(Pe){let d,N,V,K,p,O,f,Je=`This conceptual guide gives a brief overview of <a href="https://arxiv.org/abs/2106.09685" rel="nofollow">LoRA</a>, a technique that accelerates
the fine-tuning of large models while consuming less memory.`,ee,h,Ie=`To make fine-tuning more efficient, LoRA’s approach is to represent the weight updates with two smaller
matrices (called <strong>update matrices</strong>) through low-rank decomposition. These new matrices can be trained to adapt to the
new data while keeping the overall number of changes low. The original weight matrix remains frozen and doesn’t receive
any further adjustments. To produce the final results, both the original and the adapted weights are combined.`,te,c,Ue="This approach has a number of advantages:",ie,u,qe="<li>LoRA makes fine-tuning more efficient by drastically reducing the number of trainable parameters.</li> <li>The original pre-trained weights are kept frozen, which means you can have multiple lightweight and portable LoRA models for various downstream tasks built on top of them.</li> <li>LoRA is orthogonal to many other parameter-efficient methods and can be combined with many of them.</li> <li>Performance of models fine-tuned using LoRA is comparable to the performance of fully fine-tuned models.</li> <li>LoRA does not add any inference latency because adapter weights can be merged with the base model.</li>",ae,g,je=`In principle, LoRA can be applied to any subset of weight matrices in a neural network to reduce the number of trainable
parameters. However, for simplicity and further parameter efficiency, in Transformer models LoRA is typically applied to
attention blocks only. The resulting number of trainable parameters in a LoRA model depends on the size of the low-rank
update matrices, which is determined mainly by the rank <code>r</code> and the shape of the original weight matrix.`,le,w,ne,b,Be='While LoRA is significantly smaller and faster to train, you may encounter latency issues during inference due to separately loading the base model and the LoRA model. To eliminate latency, use the <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.merge_and_unload">merge_and_unload()</a> function to merge the adapter weights with the base model which allows you to effectively use the newly merged model as a standalone model.',oe,m,Ze='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/peft/lora_diagram.png"/>',se,_,We="This works because during training, the smaller weight matrices (<em>A</em> and <em>B</em> in the diagram above) are separate. But once training is complete, the weights can actually be merged into a new weight matrix that is identical.",re,T,de,L,Fe=`Use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.merge_adapter">merge_adapter()</a> to merge the LoRa layers into the base model while retaining the PeftModel.
This will help in later unmerging, deleting, loading different adapters and so on.`,me,y,Xe=`Use <a href="/docs/peft/main/en/package_reference/tuners#peft.tuners.tuners_utils.BaseTuner.unmerge_adapter">unmerge_adapter()</a> to unmerge the LoRa layers from the base model while retaining the PeftModel.
This will help in later merging, deleting, loading different adapters and so on.`,pe,v,Ge=`Use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.unload">unload()</a> to get back the base model without the merging of the active lora modules.
This will help when you want to get back the pretrained base model in some applications when you want to reset the model to its original state.
For example, in Stable Diffusion WebUi, when the user wants to infer with base model post trying out LoRAs.`,fe,M,Qe='Use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.delete_adapter">delete_adapter()</a> to delete an existing adapter.',he,x,Se='Use <a href="/docs/peft/main/en/package_reference/lora#peft.LoraModel.add_weighted_adapter">add_weighted_adapter()</a> to combine multiple LoRAs into a new adapter based on the user provided weighing scheme.',ce,R,ue,A,Ee="As with other methods supported by PEFT, to fine-tune a model using LoRA, you need to:",ge,$,Ye="<li>Instantiate a base model.</li> <li>Create a configuration (<code>LoraConfig</code>) where you define LoRA-specific parameters.</li> <li>Wrap the base model with <code>get_peft_model()</code> to get a trainable <code>PeftModel</code>.</li> <li>Train the <code>PeftModel</code> as you normally would train the base model.</li>",we,k,Ve="<code>LoraConfig</code> allows you to control how LoRA is applied to the base model through the following parameters:",be,H,De='<li><code>r</code>: the rank of the update matrices, expressed in <code>int</code>. Lower rank results in smaller update matrices with fewer trainable parameters.</li> <li><code>target_modules</code>: The modules (for example, attention blocks) to apply the LoRA update matrices.</li> <li><code>lora_alpha</code>: LoRA scaling factor.</li> <li><code>bias</code>: Specifies if the <code>bias</code> parameters should be trained. Can be <code>&#39;none&#39;</code>, <code>&#39;all&#39;</code> or <code>&#39;lora_only&#39;</code>.</li> <li><code>use_rslora</code>: When set to True, uses <a href="https://doi.org/10.48550/arXiv.2312.03732">Rank-Stabilized LoRA</a> which sets the adapter scaling factor to <code>lora_alpha/math.sqrt(r)</code>, since it was proven to work better. Otherwise, it will use the original default value of <code>lora_alpha/r</code>.</li> <li><code>modules_to_save</code>: List of modules apart from LoRA layers to be set as trainable and saved in the final checkpoint. These typically include model’s custom head that is randomly initialized for the fine-tuning task.</li> <li><code>layers_to_transform</code>: List of layers to be transformed by LoRA. If not specified, all layers in <code>target_modules</code> are transformed.</li> <li><code>layers_pattern</code>: Pattern to match layer names in <code>target_modules</code>, if <code>layers_to_transform</code> is specified. By default <code>PeftModel</code> will look at common layer pattern (<code>layers</code>, <code>h</code>, <code>blocks</code>, etc.), use it for exotic and custom models.</li> <li><code>rank_pattern</code>: The mapping from layer names or regexp expression to ranks which are different from the default rank specified by <code>r</code>.</li> <li><code>alpha_pattern</code>: The mapping from layer names or regexp expression to alphas which are different from the default alpha specified by <code>lora_alpha</code>.</li>',_e,C,Te,z,Ne="For an example of LoRA method application to various downstream tasks, please refer to the following guides:",Le,P,Ke='<li><a href="../task_guides/image_classification_lora">Image classification using LoRA</a></li> <li><a href="../task_guides/semantic_segmentation_lora">Semantic segmentation</a></li>',ye,J,Oe=`While the original paper focuses on language models, the technique can be applied to any dense layers in deep learning
models. As such, you can leverage this technique with diffusion models. See <a href="../task_guides/task_guides/dreambooth_lora">Dreambooth fine-tuning with LoRA</a> task guide for an example.`,ve,I,Me,U,et='The initialization of LoRA weights is controlled by the parameter <code>init_lora_weights</code> of the <code>LoraConfig</code>. By default, PEFT initializes LoRA weights the same way as the <a href="https://github.com/microsoft/LoRA" rel="nofollow">reference implementation</a>, i.e. using Kaiming-uniform for weight A and initializing weight B as zeros, resulting in an identity transform.',xe,q,tt='It is also possible to pass <code>init_lora_weights=&quot;gaussian&quot;</code>. As the name suggests, this results in initializing weight A with a Gaussian distribution (weight B is still zeros). This corresponds to the way that <a href="https://huggingface.co/docs/diffusers/index" rel="nofollow">diffusers</a> initializes LoRA weights.',Re,j,it='When quantizing the base model, e.g. for QLoRA training, consider using the <a href="https://arxiv.org/abs/2310.08659" rel="nofollow">LoftQ initialization</a>, which has been shown to improve the performance with quantization. The idea is that the LoRA weights are initialized such that the quantization error is minimized. To use this option, <em>do not</em> quantize the base model. Instead, proceed as follows:',Ae,B,$e,Z,at="There is also an option to set <code>initialize_lora_weights=False</code>. When choosing this option, the LoRA weights are initialized such that they do <em>not</em> result in an identity transform. This is useful for debugging and testing purposes and should not be used otherwise.",ke,W,lt='Finally, the LoRA architecture scales each adapter during every forward pass by a fixed scalar, which is set at initialization, and depends on the rank <code>r</code>. Although the original LoRA method uses the scalar function <code>lora_alpha/r</code>, the research <a href="https://doi.org/10.48550/arXiv.2312.03732" rel="nofollow">Rank-Stabilized LoRA</a> proves that instead using <code>lora_alpha/math.sqrt(r)</code>, stabilizes the adapters and unlocks the increased performance potential from higher ranks. Set <code>use_rslora=True</code> to use the rank-stabilized scaling <code>lora_alpha/math.sqrt(r)</code>.',He,D,Ce;return p=new Y({props:{title:"LoRA",local:"lora",headingTag:"h1"}}),w=new Y({props:{title:"Merge LoRA weights into the base model",local:"merge-lora-weights-into-the-base-model",headingTag:"h2"}}),T=new Y({props:{title:"Utils for LoRA",local:"utils-for-lora",headingTag:"h2"}}),R=new Y({props:{title:"Common LoRA parameters in PEFT",local:"common-lora-parameters-in-peft",headingTag:"h2"}}),C=new Y({props:{title:"LoRA examples",local:"lora-examples",headingTag:"h2"}}),I=new Y({props:{title:"Initialization options",local:"initialization-options",headingTag:"h2"}}),B=new ht({props:{code:"ZnJvbSUyMHBlZnQlMjBpbXBvcnQlMjBMb2Z0UUNvbmZpZyUyQyUyMExvcmFDb25maWclMkMlMjBnZXRfcGVmdF9tb2RlbCUwQSUwQWJhc2VfbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JDYXVzYWxMTS5mcm9tX3ByZXRyYWluZWQoLi4uKSUyMCUyMCUyMyUyMGRvbid0JTIwcXVhbnRpemUlMjBoZXJlJTBBbG9mdHFfY29uZmlnJTIwJTNEJTIwTG9mdFFDb25maWcobG9mdHFfYml0cyUzRDQlMkMlMjAuLi4pJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwc2V0JTIwNGJpdCUyMHF1YW50aXphdGlvbiUwQWxvcmFfY29uZmlnJTIwJTNEJTIwTG9yYUNvbmZpZyguLi4lMkMlMjBpbml0X2xvcmFfd2VpZ2h0cyUzRCUyMmxvZnRxJTIyJTJDJTIwbG9mdHFfY29uZmlnJTNEbG9mdHFfY29uZmlnKSUwQXBlZnRfbW9kZWwlMjAlM0QlMjBnZXRfcGVmdF9tb2RlbChiYXNlX21vZGVsJTJDJTIwbG9yYV9jb25maWcp",highlighted:`<span class="hljs-keyword">from</span> peft <span class="hljs-keyword">import</span> LoftQConfig, LoraConfig, get_peft_model

base_model = AutoModelForCausalLM.from_pretrained(...)  <span class="hljs-comment"># don&#x27;t quantize here</span>
loftq_config = LoftQConfig(loftq_bits=<span class="hljs-number">4</span>, ...)           <span class="hljs-comment"># set 4bit quantization</span>
lora_config = LoraConfig(..., init_lora_weights=<span class="hljs-string">&quot;loftq&quot;</span>, loftq_config=loftq_config)
peft_model = get_peft_model(base_model, lora_config)`,wrap:!1}}),{c(){d=o("meta"),N=l(),V=o("p"),K=l(),F(p.$$.fragment),O=l(),f=o("p"),f.innerHTML=Je,ee=l(),h=o("p"),h.innerHTML=Ie,te=l(),c=o("p"),c.textContent=Ue,ie=l(),u=o("ul"),u.innerHTML=qe,ae=l(),g=o("p"),g.innerHTML=je,le=l(),F(w.$$.fragment),ne=l(),b=o("p"),b.innerHTML=Be,oe=l(),m=o("div"),m.innerHTML=Ze,se=l(),_=o("p"),_.innerHTML=We,re=l(),F(T.$$.fragment),de=l(),L=o("p"),L.innerHTML=Fe,me=l(),y=o("p"),y.innerHTML=Xe,pe=l(),v=o("p"),v.innerHTML=Ge,fe=l(),M=o("p"),M.innerHTML=Qe,he=l(),x=o("p"),x.innerHTML=Se,ce=l(),F(R.$$.fragment),ue=l(),A=o("p"),A.textContent=Ee,ge=l(),$=o("ol"),$.innerHTML=Ye,we=l(),k=o("p"),k.innerHTML=Ve,be=l(),H=o("ul"),H.innerHTML=De,_e=l(),F(C.$$.fragment),Te=l(),z=o("p"),z.textContent=Ne,Le=l(),P=o("ul"),P.innerHTML=Ke,ye=l(),J=o("p"),J.innerHTML=Oe,ve=l(),F(I.$$.fragment),Me=l(),U=o("p"),U.innerHTML=et,xe=l(),q=o("p"),q.innerHTML=tt,Re=l(),j=o("p"),j.innerHTML=it,Ae=l(),F(B.$$.fragment),$e=l(),Z=o("p"),Z.innerHTML=at,ke=l(),W=o("p"),W.innerHTML=lt,He=l(),D=o("p"),this.h()},l(e){const t=pt("svelte-u9bgzb",document.head);d=s(t,"META",{name:!0,content:!0}),t.forEach(i),N=n(e),V=s(e,"P",{}),nt(V).forEach(i),K=n(e),X(p.$$.fragment,e),O=n(e),f=s(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-10j2kq5"&&(f.innerHTML=Je),ee=n(e),h=s(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-yvfnx3"&&(h.innerHTML=Ie),te=n(e),c=s(e,"P",{"data-svelte-h":!0}),r(c)!=="svelte-1usho35"&&(c.textContent=Ue),ie=n(e),u=s(e,"UL",{"data-svelte-h":!0}),r(u)!=="svelte-b91w2n"&&(u.innerHTML=qe),ae=n(e),g=s(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-1pnerbz"&&(g.innerHTML=je),le=n(e),X(w.$$.fragment,e),ne=n(e),b=s(e,"P",{"data-svelte-h":!0}),r(b)!=="svelte-1lsy0sj"&&(b.innerHTML=Be),oe=n(e),m=s(e,"DIV",{class:!0,"data-svelte-h":!0}),r(m)!=="svelte-1f6iuw5"&&(m.innerHTML=Ze),se=n(e),_=s(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-6quaur"&&(_.innerHTML=We),re=n(e),X(T.$$.fragment,e),de=n(e),L=s(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-u1h9r6"&&(L.innerHTML=Fe),me=n(e),y=s(e,"P",{"data-svelte-h":!0}),r(y)!=="svelte-121m51a"&&(y.innerHTML=Xe),pe=n(e),v=s(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-12mnxsd"&&(v.innerHTML=Ge),fe=n(e),M=s(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-33nb0p"&&(M.innerHTML=Qe),he=n(e),x=s(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-v3as9t"&&(x.innerHTML=Se),ce=n(e),X(R.$$.fragment,e),ue=n(e),A=s(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-kdwy7m"&&(A.textContent=Ee),ge=n(e),$=s(e,"OL",{"data-svelte-h":!0}),r($)!=="svelte-yij1ed"&&($.innerHTML=Ye),we=n(e),k=s(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-ezuo7y"&&(k.innerHTML=Ve),be=n(e),H=s(e,"UL",{"data-svelte-h":!0}),r(H)!=="svelte-4i1ypv"&&(H.innerHTML=De),_e=n(e),X(C.$$.fragment,e),Te=n(e),z=s(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-aryync"&&(z.textContent=Ne),Le=n(e),P=s(e,"UL",{"data-svelte-h":!0}),r(P)!=="svelte-19vcsei"&&(P.innerHTML=Ke),ye=n(e),J=s(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1moq18d"&&(J.innerHTML=Oe),ve=n(e),X(I.$$.fragment,e),Me=n(e),U=s(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1uqxl8x"&&(U.innerHTML=et),xe=n(e),q=s(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-hcpclp"&&(q.innerHTML=tt),Re=n(e),j=s(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-158barj"&&(j.innerHTML=it),Ae=n(e),X(B.$$.fragment,e),$e=n(e),Z=s(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-hj6det"&&(Z.innerHTML=at),ke=n(e),W=s(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-2yp7s3"&&(W.innerHTML=lt),He=n(e),D=s(e,"P",{}),nt(D).forEach(i),this.h()},h(){ze(d,"name","hf:doc:metadata"),ze(d,"content",ut),ze(m,"class","flex justify-center")},m(e,t){ft(document.head,d),a(e,N,t),a(e,V,t),a(e,K,t),G(p,e,t),a(e,O,t),a(e,f,t),a(e,ee,t),a(e,h,t),a(e,te,t),a(e,c,t),a(e,ie,t),a(e,u,t),a(e,ae,t),a(e,g,t),a(e,le,t),G(w,e,t),a(e,ne,t),a(e,b,t),a(e,oe,t),a(e,m,t),a(e,se,t),a(e,_,t),a(e,re,t),G(T,e,t),a(e,de,t),a(e,L,t),a(e,me,t),a(e,y,t),a(e,pe,t),a(e,v,t),a(e,fe,t),a(e,M,t),a(e,he,t),a(e,x,t),a(e,ce,t),G(R,e,t),a(e,ue,t),a(e,A,t),a(e,ge,t),a(e,$,t),a(e,we,t),a(e,k,t),a(e,be,t),a(e,H,t),a(e,_e,t),G(C,e,t),a(e,Te,t),a(e,z,t),a(e,Le,t),a(e,P,t),a(e,ye,t),a(e,J,t),a(e,ve,t),G(I,e,t),a(e,Me,t),a(e,U,t),a(e,xe,t),a(e,q,t),a(e,Re,t),a(e,j,t),a(e,Ae,t),G(B,e,t),a(e,$e,t),a(e,Z,t),a(e,ke,t),a(e,W,t),a(e,He,t),a(e,D,t),Ce=!0},p:st,i(e){Ce||(Q(p.$$.fragment,e),Q(w.$$.fragment,e),Q(T.$$.fragment,e),Q(R.$$.fragment,e),Q(C.$$.fragment,e),Q(I.$$.fragment,e),Q(B.$$.fragment,e),Ce=!0)},o(e){S(p.$$.fragment,e),S(w.$$.fragment,e),S(T.$$.fragment,e),S(R.$$.fragment,e),S(C.$$.fragment,e),S(I.$$.fragment,e),S(B.$$.fragment,e),Ce=!1},d(e){e&&(i(N),i(V),i(K),i(O),i(f),i(ee),i(h),i(te),i(c),i(ie),i(u),i(ae),i(g),i(le),i(ne),i(b),i(oe),i(m),i(se),i(_),i(re),i(de),i(L),i(me),i(y),i(pe),i(v),i(fe),i(M),i(he),i(x),i(ce),i(ue),i(A),i(ge),i($),i(we),i(k),i(be),i(H),i(_e),i(Te),i(z),i(Le),i(P),i(ye),i(J),i(ve),i(Me),i(U),i(xe),i(q),i(Re),i(j),i(Ae),i($e),i(Z),i(ke),i(W),i(He),i(D)),i(d),E(p,e),E(w,e),E(T,e),E(R,e),E(C,e),E(I,e),E(B,e)}}}const ut='{"title":"LoRA","local":"lora","sections":[{"title":"Merge LoRA weights into the base model","local":"merge-lora-weights-into-the-base-model","sections":[],"depth":2},{"title":"Utils for LoRA","local":"utils-for-lora","sections":[],"depth":2},{"title":"Common LoRA parameters in PEFT","local":"common-lora-parameters-in-peft","sections":[],"depth":2},{"title":"LoRA examples","local":"lora-examples","sections":[],"depth":2},{"title":"Initialization options","local":"initialization-options","sections":[],"depth":2}],"depth":1}';function gt(Pe){return rt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Lt extends dt{constructor(d){super(),mt(this,d,gt,ct,ot,{})}}export{Lt as component};
