import{s as yd,n as vd,o as wd}from"../chunks/scheduler.b108d059.js";import{S as Md,i as $d,g as l,s as o,r as p,A as Ed,h as d,f as r,c as a,j as f,u as n,x as c,k as i,y as Cd,a as s,v as m,d as u,t as h,w as _}from"../chunks/index.008de539.js";import{C as Xa}from"../chunks/CodeBlock.3968c746.js";import{H as g}from"../chunks/Heading.88bfeb84.js";function Jd(Va){let x,rr,er,sr,T,or,b,ar,y,Ya="Processors are used to prepare non-textual inputs (e.g., image or audio) for a model.",lr,v,Sa="<strong>Example:</strong> Using a <code>WhisperProcessor</code> to prepare an audio input for a model.",dr,w,cr,M,qa='<li><a href="#module_processors">processors</a><ul><li><em>static</em><ul><li><a href="#module_processors.FeatureExtractor">.FeatureExtractor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.FeatureExtractor_new"><code>new FeatureExtractor(config)</code></a></li></ul></li> <li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li> <li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li> <li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.WhisperProcessor">.WhisperProcessor</a> ⇐ <code>Processor</code><ul><li><a href="#module_processors.WhisperProcessor+_call"><code>._call(audio)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li> <li><a href="#module_processors.AutoProcessor">.AutoProcessor</a><ul><li><a href="#module_processors.AutoProcessor.from_pretrained"><code>.from_pretrained(pretrained_model_name_or_path, options)</code></a> ⇒ <code>Promise.&lt;Processor&gt;</code></li></ul></li></ul></li> <li><em>inner</em><ul><li><a href="#module_processors..center_to_corners_format"><code>~center_to_corners_format(arr)</code></a> ⇒ <code>Array.&lt;number&gt;</code></li> <li><a href="#module_processors..HeightWidth"><code>~HeightWidth</code></a> : <code>*</code></li> <li><a href="#module_processors..ImageFeatureExtractorResult"><code>~ImageFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..PreprocessedImage"><code>~PreprocessedImage</code></a> : <code>object</code></li> <li><a href="#module_processors..DetrFeatureExtractorResult"><code>~DetrFeatureExtractorResult</code></a> : <code>object</code></li> <li><a href="#module_processors..SamImageProcessorResult"><code>~SamImageProcessorResult</code></a> : <code>object</code></li></ul></li></ul></li>',ir,pr,nr,$,mr,E,ur,C,Ka="Base class for feature extractors.",hr,J,Oa='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',_r,fr,gr,P,xr,k,Tr,j,el="Constructs a new FeatureExtractor instance.",br,H,tl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td></tr></tbody>",yr,vr,wr,I,Mr,F,$r,L,rl="Feature extractor for image models.",Er,A,sl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>FeatureExtractor</code>',Cr,R,ol='<li><a href="#module_processors.ImageFeatureExtractor">.ImageFeatureExtractor</a> ⇐ <code>FeatureExtractor</code><ul><li><a href="#new_module_processors.ImageFeatureExtractor_new"><code>new ImageFeatureExtractor(config)</code></a></li> <li><a href="#module_processors.ImageFeatureExtractor+thumbnail"><code>.thumbnail(image, size, [resample])</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+crop_margin"><code>.crop_margin(image, gray_threshold)</code></a> ⇒ <code>Promise.&lt;RawImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+pad_image"><code>.pad_image(pixelData, imgDims, padSize, options)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.ImageFeatureExtractor+preprocess"><code>.preprocess(image, overrides)</code></a> ⇒ <code>Promise.&lt;PreprocessedImage&gt;</code></li> <li><a href="#module_processors.ImageFeatureExtractor+_call"><code>._call(images, ...args)</code></a> ⇒ <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code></li></ul></li>',Jr,Pr,kr,U,jr,z,Hr,D,al="Constructs a new ImageFeatureExtractor instance.",Ir,B,ll="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>config</td><td><code>Object</code></td><td><p>The configuration for the feature extractor.</p></td> </tr><tr><td>config.image_mean</td><td><code>Array.&lt;number&gt;</code></td><td><p>The mean values for image normalization.</p></td> </tr><tr><td>config.image_std</td><td><code>Array.&lt;number&gt;</code></td><td><p>The standard deviation values for image normalization.</p></td> </tr><tr><td>config.do_rescale</td><td><code>boolean</code></td><td><p>Whether to rescale the image pixel values to the [0,1] range.</p></td> </tr><tr><td>config.rescale_factor</td><td><code>number</code></td><td><p>The factor to use for rescaling the image pixel values.</p></td> </tr><tr><td>config.do_normalize</td><td><code>boolean</code></td><td><p>Whether to normalize the image pixel values.</p></td> </tr><tr><td>config.do_resize</td><td><code>boolean</code></td><td><p>Whether to resize the image.</p></td> </tr><tr><td>config.resample</td><td><code>number</code></td><td><p>What method to use for resampling.</p></td> </tr><tr><td>config.size</td><td><code>number</code></td><td><p>The size to resize the image to.</p></td></tr></tbody>",Fr,Lr,Ar,W,Rr,N,Ur,G,dl=`Resize the image to make a thumbnail. The image is resized so that no dimension is larger than any
corresponding dimension of the specified size.`,zr,Z,cl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The resized image.',Dr,Q,il="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be resized.</p></td> </tr><tr><td>size</td><td><code>Object</code></td><td></td><td><p>The size <code>{&quot;height&quot;: h, &quot;width&quot;: w}</code> to resize the image to.</p></td> </tr><tr><td>[resample]</td><td><code>string</code> | <code>0</code> | <code>1</code> | <code>2</code> | <code>3</code> | <code>4</code> | <code>5</code></td><td><code>2</code></td><td><p>The resampling filter to use.</p></td></tr></tbody>",Br,Wr,Nr,X,Gr,V,Zr,Y,pl="Crops the margin of the image. Gray pixels are considered margin (i.e., pixels with a value below the threshold).",Qr,S,nl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;RawImage&gt;</code> - The cropped image.',Xr,q,ml="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td></td><td><p>The image to be cropped.</p></td> </tr><tr><td>gray_threshold</td><td><code>number</code></td><td><code>200</code></td><td><p>Value below which pixels are considered to be gray.</p></td></tr></tbody>",Vr,Yr,Sr,K,qr,O,Kr,ee,ul="Pad the image by a certain amount.",Or,te,hl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The padded pixel data and image dimensions.',es,re,_l="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>pixelData</td><td><code>Float32Array</code></td><td></td><td><p>The pixel data to pad.</p></td> </tr><tr><td>imgDims</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The dimensions of the image.</p></td> </tr><tr><td>padSize</td><td><code>*</code></td><td></td><td><p>The dimensions of the padded image.</p></td> </tr><tr><td>options</td><td><code>Object</code></td><td></td><td><p>The options for padding.</p></td> </tr><tr><td>[options.mode]</td><td><code>&#39;constant&#39;</code> | <code>&#39;symmetric&#39;</code></td><td><code>&#39;constant&#39;</code></td><td><p>The type of padding to add.</p></td> </tr><tr><td>[options.center]</td><td><code>boolean</code></td><td><code>false</code></td><td><p>Whether to center the image.</p></td> </tr><tr><td>[options.constant_values]</td><td><code>number</code></td><td><code>0</code></td><td><p>The constant value to use for padding.</p></td></tr></tbody>",ts,rs,ss,se,os,oe,as,ae,fl="Preprocesses the given image.",ls,le,gl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;PreprocessedImage&gt;</code> - The preprocessed image.',ds,de,xl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>image</td><td><code>RawImage</code></td><td><p>The image to preprocess.</p></td> </tr><tr><td>overrides</td><td><code>Object</code></td><td><p>The overrides for the preprocessing options.</p></td></tr></tbody>",cs,is,ps,ce,ns,ie,ms,pe,Tl=`Calls the feature extraction process on an array of images,
preprocesses each image, and concatenates the resulting
features into a single Tensor.`,us,ne,bl='<strong>Kind</strong>: instance method of <a href="#module_processors.ImageFeatureExtractor"><code>ImageFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;ImageFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values (and other metadata) of the preprocessed images.',hs,me,yl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",_s,fs,gs,ue,xs,he,Ts,_e,vl="Detr Feature Extractor.",bs,fe,wl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>ImageFeatureExtractor</code>',ys,ge,Ml='<li><a href="#module_processors.DetrFeatureExtractor">.DetrFeatureExtractor</a> ⇐ <code>ImageFeatureExtractor</code><ul><li><a href="#module_processors.DetrFeatureExtractor+_call"><code>._call(images)</code></a> ⇒ <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_object_detection"><code>.post_process_object_detection()</code></a> : <code>post_process_object_detection</code></li> <li><a href="#module_processors.DetrFeatureExtractor+remove_low_and_no_objects"><code>.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+check_segment_validity"><code>.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+compute_segments"><code>.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size)</code></a> ⇒ <code>*</code></li> <li><a href="#module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"><code>.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes])</code></a> ⇒ <code>Array.&lt;{segmentation: Tensor, segments_info: Array&lt;{id: number, label_id: number, score: number}&gt;}&gt;</code></li></ul></li>',vs,ws,Ms,xe,$s,Te,Es,be,$l=`Calls the feature extraction process on an array of images, preprocesses
each image, and concatenates the resulting features into a single Tensor.`,Cs,ye,El='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;DetrFeatureExtractorResult&gt;</code> - An object containing the concatenated pixel values of the preprocessed images.',Js,ve,Cl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>images</td><td><code>Array.&lt;RawImage&gt;</code></td><td><p>The image(s) to extract features from.</p></td></tr></tbody>",Ps,ks,js,we,Hs,Me,Is,$e,Jl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',Fs,Ls,As,Ee,Rs,Ce,Us,Je,Pl="Binarize the given masks using <code>object_mask_threshold</code>, it returns the associated values of <code>masks</code>, <code>scores</code> and <code>labels</code>.",zs,Pe,kl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The binarized masks, the scores, and the labels.',Ds,ke,jl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>class_logits</td><td><code>Tensor</code></td><td><p>The class logits.</p></td> </tr><tr><td>mask_logits</td><td><code>Tensor</code></td><td><p>The mask logits.</p></td> </tr><tr><td>object_mask_threshold</td><td><code>number</code></td><td><p>A number between 0 and 1 used to binarize the masks.</p></td> </tr><tr><td>num_labels</td><td><code>number</code></td><td><p>The number of labels.</p></td></tr></tbody>",Bs,Ws,Ns,je,Gs,He,Zs,Ie,Hl="Checks whether the segment is valid or not.",Qs,Fe,Il='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - Whether the segment is valid or not, and the indices of the valid labels.',Xs,Le,Fl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_labels</td><td><code>Int32Array</code></td><td></td><td><p>Labels for each pixel in the mask.</p></td> </tr><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>Probabilities for each pixel in the masks.</p></td> </tr><tr><td>k</td><td><code>number</code></td><td></td><td><p>The class id of the segment.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold.</p></td></tr></tbody>",Vs,Ys,Ss,Ae,qs,Re,Ks,Ue,Ll="Computes the segments.",Os,ze,Al='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a><br/> <strong>Returns</strong>: <code>*</code> - The computed segments.',eo,De,Rl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>mask_probs</td><td><code>Array.&lt;Tensor&gt;</code></td><td></td><td><p>The mask probabilities.</p></td> </tr><tr><td>pred_scores</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted scores.</p></td> </tr><tr><td>pred_labels</td><td><code>Array.&lt;number&gt;</code></td><td></td><td><p>The predicted labels.</p></td> </tr><tr><td>mask_threshold</td><td><code>number</code></td><td></td><td><p>The mask threshold.</p></td> </tr><tr><td>overlap_mask_area_threshold</td><td><code>number</code></td><td></td><td><p>The overlap mask area threshold.</p></td> </tr><tr><td>label_ids_to_fuse</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The label ids to fuse.</p></td> </tr><tr><td>target_size</td><td><code>Array.&lt;number&gt;</code></td><td><code></code></td><td><p>The target size of the image.</p></td></tr></tbody>",to,ro,so,Be,oo,We,ao,Ne,Ul="Post-process the model output to generate the final panoptic segmentation.",lo,Ge,zl='<strong>Kind</strong>: instance method of <a href="#module_processors.DetrFeatureExtractor"><code>DetrFeatureExtractor</code></a>',co,Ze,Dl="<thead><tr><th>Param</th><th>Type</th><th>Default</th><th>Description</th></tr></thead> <tbody><tr><td>outputs</td><td><code>*</code></td><td></td><td><p>The model output to post process</p></td> </tr><tr><td>[threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>The probability score threshold to keep predicted instance masks.</p></td> </tr><tr><td>[mask_threshold]</td><td><code>number</code></td><td><code>0.5</code></td><td><p>Threshold to use when turning the predicted masks into binary values.</p></td> </tr><tr><td>[overlap_mask_area_threshold]</td><td><code>number</code></td><td><code>0.8</code></td><td><p>The overlap mask area threshold to merge or discard small disconnected parts within each binary instance mask.</p></td> </tr><tr><td>[label_ids_to_fuse]</td><td><code>Set.&lt;number&gt;</code></td><td><code></code></td><td><p>The labels in this state will have all their instances be fused together.</p></td> </tr><tr><td>[target_sizes]</td><td><code>Array.&lt;Array&lt;number&gt;&gt;</code></td><td><code></code></td><td><p>The target sizes to resize the masks to.</p></td></tr></tbody>",io,po,no,Qe,mo,Xe,uo,Ve,Bl="Represents a Processor that extracts features from an input.",ho,Ye,Wl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Callable</code>',_o,Se,Nl='<li><a href="#module_processors.Processor">.Processor</a> ⇐ <code>Callable</code><ul><li><a href="#new_module_processors.Processor_new"><code>new Processor(feature_extractor)</code></a></li> <li><a href="#module_processors.Processor+_call"><code>._call(input, ...args)</code></a> ⇒ <code>Promise.&lt;any&gt;</code></li></ul></li>',fo,go,xo,qe,To,Ke,bo,Oe,Gl="Creates a new Processor with the given feature extractor.",yo,et,Zl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>feature_extractor</td><td><code>FeatureExtractor</code></td><td><p>The function used to extract features from the input.</p></td></tr></tbody>",vo,wo,Mo,tt,$o,rt,Eo,st,Ql="Calls the feature_extractor function with the given input.",Co,ot,Xl='<strong>Kind</strong>: instance method of <a href="#module_processors.Processor"><code>Processor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Jo,at,Vl="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>input</td><td><code>any</code></td><td><p>The input to extract features from.</p></td> </tr><tr><td>...args</td><td><code>any</code></td><td><p>Additional arguments.</p></td></tr></tbody>",Po,ko,jo,lt,Ho,dt,Io,ct,Yl="Represents a WhisperProcessor that extracts features from an audio input.",Fo,it,Sl='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a><br/> <strong>Extends</strong>: <code>Processor</code>',Lo,Ao,Ro,pt,Uo,nt,zo,mt,ql="Calls the feature_extractor function with the given audio input.",Do,ut,Kl='<strong>Kind</strong>: instance method of <a href="#module_processors.WhisperProcessor"><code>WhisperProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;any&gt;</code> - A Promise that resolves with the extracted features.',Bo,ht,Ol="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>audio</td><td><code>any</code></td><td><p>The audio input to extract features from.</p></td></tr></tbody>",Wo,No,Go,_t,Zo,ft,Qo,gt,ed=`Helper class which is used to instantiate pretrained processors with the <code>from_pretrained</code> function.
The chosen processor class is determined by the type specified in the processor config.`,Xo,xt,td="<strong>Example:</strong> Load a processor using <code>from_pretrained</code>.",Vo,Tt,Yo,bt,rd="<strong>Example:</strong> Run an image through a processor.",So,yt,qo,vt,sd='<strong>Kind</strong>: static class of <a href="#module_processors"><code>processors</code></a>',Ko,Oo,ea,wt,ta,Mt,ra,$t,od="Instantiate one of the processor classes of the library from a pretrained model.",sa,Et,ad=`The processor class to instantiate is selected based on the <code>feature_extractor_type</code> property of the config object
(either passed as an argument or loaded from <code>pretrained_model_name_or_path</code> if possible)`,oa,Ct,ld='<strong>Kind</strong>: static method of <a href="#module_processors.AutoProcessor"><code>AutoProcessor</code></a><br/> <strong>Returns</strong>: <code>Promise.&lt;Processor&gt;</code> - A new instance of the Processor class.',aa,Jt,dd=`<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pretrained_model_name_or_path</td><td><code>string</code></td><td><p>The name or path of the pretrained model. Can be either:</p> <ul><li>A string, the <em>model id</em> of a pretrained processor hosted inside a model repo on huggingface.co.
Valid model ids can be located at the root-level, like <code>bert-base-uncased</code>, or namespaced under a
user or organization name, like <code>dbmdz/bert-base-german-cased</code>.</li> <li>A path to a <em>directory</em> containing processor files, e.g., <code>./my_model_directory/</code>.</li></ul></td> </tr><tr><td>options</td><td><code>*</code></td><td><p>Additional options for loading the processor.</p></td></tr></tbody>`,la,da,ca,Pt,ia,kt,pa,jt,cd="Converts bounding boxes from center format to corners format.",na,Ht,id='<strong>Kind</strong>: inner method of <a href="#module_processors"><code>processors</code></a><br/> <strong>Returns</strong>: <code>Array.&lt;number&gt;</code> - The coodinates for the top-left and bottom-right corners of the box (top_left_x, top_left_y, bottom_right_x, bottom_right_y)',ma,It,pd="<thead><tr><th>Param</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>arr</td><td><code>Array.&lt;number&gt;</code></td><td><p>The coordinate for the center of the box and its width, height dimensions (center_x, center_y, width, height)</p></td></tr></tbody>",ua,ha,_a,Ft,fa,Lt,ga,At,nd=`Named tuple to indicate the order we are using is (height x width), even though
the Graphics’ industry standard is (width x height).`,xa,Rt,md='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a>',Ta,ba,ya,Ut,va,zt,wa,Dt,ud='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Ma,Bt,hd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the batched preprocessed images.</p></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[480, 640]].</p></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td><td><p>Array of two-dimensional tuples like [[1000, 1330]].</p></td></tr></tbody>",$a,Ea,Ca,Wt,Ja,Nt,Pa,Gt,_d='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',ka,Zt,fd="<thead><tr><th>Name</th><th>Type</th><th>Description</th></tr></thead> <tbody><tr><td>original_size</td><td><code>HeightWidth</code></td><td><p>The original size of the image.</p></td> </tr><tr><td>reshaped_input_size</td><td><code>HeightWidth</code></td><td><p>The reshaped input size of the image.</p></td> </tr><tr><td>pixel_values</td><td><code>Tensor</code></td><td><p>The pixel values of the preprocessed image.</p></td></tr></tbody>",ja,Ha,Ia,Qt,Fa,Xt,La,Vt,gd='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Aa,Yt,xd="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_mask</td><td><code>Tensor</code></td></tr></tbody>",Ra,Ua,za,St,Da,qt,Ba,Kt,Td='<strong>Kind</strong>: inner typedef of <a href="#module_processors"><code>processors</code></a><br/> <strong>Properties</strong>',Wa,Ot,bd="<thead><tr><th>Name</th><th>Type</th></tr></thead> <tbody><tr><td>pixel_values</td><td><code>Tensor</code></td> </tr><tr><td>original_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>reshaped_input_sizes</td><td><code>Array.&lt;HeightWidth&gt;</code></td> </tr><tr><td>input_points</td><td><code>Tensor</code></td></tr></tbody>",Na,Ga,Za,tr,Qa;return b=new g({props:{title:"processors",local:"processors",headingTag:"h1"}}),w=new Xa({props:{code:"aW1wb3J0JTIwJTdCJTIwQXV0b1Byb2Nlc3NvciUyQyUyMHJlYWRfYXVkaW8lMjAlN0QlMjBmcm9tJTIwJyU0MHhlbm92YSUyRnRyYW5zZm9ybWVycyclM0IlMEElMEFsZXQlMjBwcm9jZXNzb3IlMjAlM0QlMjBhd2FpdCUyMEF1dG9Qcm9jZXNzb3IuZnJvbV9wcmV0cmFpbmVkKCdvcGVuYWklMkZ3aGlzcGVyLXRpbnkuZW4nKSUzQiUwQWxldCUyMGF1ZGlvJTIwJTNEJTIwYXdhaXQlMjByZWFkX2F1ZGlvKCdodHRwcyUzQSUyRiUyRmh1Z2dpbmdmYWNlLmNvJTJGZGF0YXNldHMlMkZOYXJzaWwlMkZhc3JfZHVtbXklMkZyZXNvbHZlJTJGbWFpbiUyRm1say5mbGFjJyUyQyUyMDE2MDAwKSUzQiUwQWxldCUyMCU3QiUyMGlucHV0X2ZlYXR1cmVzJTIwJTdEJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoYXVkaW8pJTNCJTBBJTJGJTJGJTIwVGVuc29yJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwZGF0YSUzQSUyMEZsb2F0MzJBcnJheSgyNDAwMDApJTIwJTVCMC40NzUyOTg0NjQyOTgyNDgzJTJDJTIwMC41NTk3MjU4ODA2MjI4NjM4JTJDJTIwMC41NjQzNDE2NjQzMTQyNyUyQyUyMC4uLiU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMGRpbXMlM0ElMjAlNUIxJTJDJTIwODAlMkMlMjAzMDAwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwdHlwZSUzQSUyMCdmbG9hdDMyJyUyQyUwQSUyRiUyRiUyMCUyMCUyMHNpemUlM0ElMjAyNDAwMDAlMkMlMEElMkYlMkYlMjAlN0Q=",highlighted:`<span class="hljs-keyword">import</span> { <span class="hljs-title class_">AutoProcessor</span>, read_audio } <span class="hljs-keyword">from</span> <span class="hljs-string">&#x27;@xenova/transformers&#x27;</span>;

<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);
<span class="hljs-keyword">let</span> audio = <span class="hljs-keyword">await</span> <span class="hljs-title function_">read_audio</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Narsil/asr_dummy/resolve/main/mlk.flac&#x27;</span>, <span class="hljs-number">16000</span>);
<span class="hljs-keyword">let</span> { input_features } = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(audio);
<span class="hljs-comment">// Tensor {</span>
<span class="hljs-comment">//   data: Float32Array(240000) [0.4752984642982483, 0.5597258806228638, 0.56434166431427, ...],</span>
<span class="hljs-comment">//   dims: [1, 80, 3000],</span>
<span class="hljs-comment">//   type: &#x27;float32&#x27;,</span>
<span class="hljs-comment">//   size: 240000,</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),E=new g({props:{title:"processors.FeatureExtractor ⇐ <code> Callable </code>",local:"processorsfeatureextractor--code-callable-code",headingTag:"h2"}}),k=new g({props:{title:"new FeatureExtractor(config)",local:"new-featureextractorconfig",headingTag:"h3"}}),F=new g({props:{title:"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>",local:"processorsimagefeatureextractor--code-featureextractor-code",headingTag:"h2"}}),z=new g({props:{title:"new ImageFeatureExtractor(config)",local:"new-imagefeatureextractorconfig",headingTag:"h3"}}),N=new g({props:{title:"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code",headingTag:"h3"}}),V=new g({props:{title:"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>",local:"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code",headingTag:"h3"}}),O=new g({props:{title:"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>",local:"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code",headingTag:"h3"}}),oe=new g({props:{title:"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>",local:"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code",headingTag:"h3"}}),ie=new g({props:{title:"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>",local:"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code",headingTag:"h3"}}),he=new g({props:{title:"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>",local:"processorsdetrfeatureextractor--code-imagefeatureextractor-code",headingTag:"h2"}}),Te=new g({props:{title:"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>",local:"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code",headingTag:"h3"}}),Me=new g({props:{title:"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>",local:"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code",headingTag:"h3"}}),Ce=new g({props:{title:"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>",local:"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code",headingTag:"h3"}}),He=new g({props:{title:"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>",local:"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code",headingTag:"h3"}}),Re=new g({props:{title:"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>",local:"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code",headingTag:"h3"}}),We=new g({props:{title:"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>",local:"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code",headingTag:"h3"}}),Xe=new g({props:{title:"processors.Processor ⇐ <code> Callable </code>",local:"processorsprocessor--code-callable-code",headingTag:"h2"}}),Ke=new g({props:{title:"new Processor(feature_extractor)",local:"new-processorfeatureextractor",headingTag:"h3"}}),rt=new g({props:{title:"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>",local:"processorcallinput-args--code-promise--any--code",headingTag:"h3"}}),dt=new g({props:{title:"processors.WhisperProcessor ⇐ <code> Processor </code>",local:"processorswhisperprocessor--code-processor-code",headingTag:"h2"}}),nt=new g({props:{title:"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>",local:"whisperprocessorcallaudio--code-promise--any--code",headingTag:"h3"}}),ft=new g({props:{title:"processors.AutoProcessor",local:"processorsautoprocessor",headingTag:"h2"}}),Tt=new Xa({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnb3BlbmFpJTJGd2hpc3Blci10aW55LmVuJyklM0I=",highlighted:'<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;openai/whisper-tiny.en&#x27;</span>);',wrap:!1}}),yt=new Xa({props:{code:"bGV0JTIwcHJvY2Vzc29yJTIwJTNEJTIwYXdhaXQlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCgnWGVub3ZhJTJGY2xpcC12aXQtYmFzZS1wYXRjaDE2JyklM0IlMEFsZXQlMjBpbWFnZSUyMCUzRCUyMGF3YWl0JTIwUmF3SW1hZ2UucmVhZCgnaHR0cHMlM0ElMkYlMkZodWdnaW5nZmFjZS5jbyUyRmRhdGFzZXRzJTJGWGVub3ZhJTJGdHJhbnNmb3JtZXJzLmpzLWRvY3MlMkZyZXNvbHZlJTJGbWFpbiUyRmZvb3RiYWxsLW1hdGNoLmpwZycpJTNCJTBBbGV0JTIwaW1hZ2VfaW5wdXRzJTIwJTNEJTIwYXdhaXQlMjBwcm9jZXNzb3IoaW1hZ2UpJTNCJTBBJTJGJTJGJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIycGl4ZWxfdmFsdWVzJTIyJTNBJTIwJTdCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIyZGltcyUyMiUzQSUyMCU1QiUyMDElMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTJDJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTIydHlwZSUyMiUzQSUyMCUyMmZsb2F0MzIlMjIlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjAlMjAlMjJkYXRhJTIyJTNBJTIwRmxvYXQzMkFycmF5JTIwJTVCJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTU4Njg3Njg2OTIwMTY2JTJDJTIwLTEuNTQ0MDg5MzE3MzIxNzc3MyUyQyUyMC4uLiUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCUyMnNpemUlMjIlM0ElMjAxNTA1MjglMEElMkYlMkYlMjAlMjAlMjAlN0QlMkMlMEElMkYlMkYlMjAlMjAlMjAlMjJvcmlnaW5hbF9zaXplcyUyMiUzQSUyMCU1QiUwQSUyRiUyRiUyMCUyMCUyMCUyMCUyMCU1QiUyMDUzMyUyQyUyMDgwMCUyMCU1RCUwQSUyRiUyRiUyMCUyMCUyMCU1RCUyQyUwQSUyRiUyRiUyMCUyMCUyMCUyMnJlc2hhcGVkX2lucHV0X3NpemVzJTIyJTNBJTIwJTVCJTBBJTJGJTJGJTIwJTIwJTIwJTIwJTIwJTVCJTIwMjI0JTJDJTIwMjI0JTIwJTVEJTBBJTJGJTJGJTIwJTIwJTIwJTVEJTBBJTJGJTJGJTIwJTdE",highlighted:`<span class="hljs-keyword">let</span> processor = <span class="hljs-keyword">await</span> <span class="hljs-title class_">AutoProcessor</span>.<span class="hljs-title function_">from_pretrained</span>(<span class="hljs-string">&#x27;Xenova/clip-vit-base-patch16&#x27;</span>);
<span class="hljs-keyword">let</span> image = <span class="hljs-keyword">await</span> <span class="hljs-title class_">RawImage</span>.<span class="hljs-title function_">read</span>(<span class="hljs-string">&#x27;https://huggingface.co/datasets/Xenova/transformers.js-docs/resolve/main/football-match.jpg&#x27;</span>);
<span class="hljs-keyword">let</span> image_inputs = <span class="hljs-keyword">await</span> <span class="hljs-title function_">processor</span>(image);
<span class="hljs-comment">// {</span>
<span class="hljs-comment">//   &quot;pixel_values&quot;: {</span>
<span class="hljs-comment">//     &quot;dims&quot;: [ 1, 3, 224, 224 ],</span>
<span class="hljs-comment">//     &quot;type&quot;: &quot;float32&quot;,</span>
<span class="hljs-comment">//     &quot;data&quot;: Float32Array [ -1.558687686920166, -1.558687686920166, -1.5440893173217773, ... ],</span>
<span class="hljs-comment">//     &quot;size&quot;: 150528</span>
<span class="hljs-comment">//   },</span>
<span class="hljs-comment">//   &quot;original_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 533, 800 ]</span>
<span class="hljs-comment">//   ],</span>
<span class="hljs-comment">//   &quot;reshaped_input_sizes&quot;: [</span>
<span class="hljs-comment">//     [ 224, 224 ]</span>
<span class="hljs-comment">//   ]</span>
<span class="hljs-comment">// }</span>`,wrap:!1}}),Mt=new g({props:{title:"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>",local:"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code",headingTag:"h3"}}),kt=new g({props:{title:"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>",local:"processorscentertocornersformatarr--code-array--number--code",headingTag:"h2"}}),Lt=new g({props:{title:"processors~HeightWidth : <code> * </code>",local:"processorsheightwidth--code--code",headingTag:"h2"}}),zt=new g({props:{title:"processors~ImageFeatureExtractorResult : <code> object </code>",local:"processorsimagefeatureextractorresult--code-object-code",headingTag:"h2"}}),Nt=new g({props:{title:"processors~PreprocessedImage : <code> object </code>",local:"processorspreprocessedimage--code-object-code",headingTag:"h2"}}),Xt=new g({props:{title:"processors~DetrFeatureExtractorResult : <code> object </code>",local:"processorsdetrfeatureextractorresult--code-object-code",headingTag:"h2"}}),qt=new g({props:{title:"processors~SamImageProcessorResult : <code> object </code>",local:"processorssamimageprocessorresult--code-object-code",headingTag:"h2"}}),{c(){x=l("meta"),rr=o(),er=l("p"),sr=o(),T=l("a"),or=o(),p(b.$$.fragment),ar=o(),y=l("p"),y.textContent=Ya,lr=o(),v=l("p"),v.innerHTML=Sa,dr=o(),p(w.$$.fragment),cr=o(),M=l("ul"),M.innerHTML=qa,ir=o(),pr=l("hr"),nr=o(),$=l("a"),mr=o(),p(E.$$.fragment),ur=o(),C=l("p"),C.textContent=Ka,hr=o(),J=l("p"),J.innerHTML=Oa,_r=o(),fr=l("hr"),gr=o(),P=l("a"),xr=o(),p(k.$$.fragment),Tr=o(),j=l("p"),j.textContent=el,br=o(),H=l("table"),H.innerHTML=tl,yr=o(),vr=l("hr"),wr=o(),I=l("a"),Mr=o(),p(F.$$.fragment),$r=o(),L=l("p"),L.textContent=rl,Er=o(),A=l("p"),A.innerHTML=sl,Cr=o(),R=l("ul"),R.innerHTML=ol,Jr=o(),Pr=l("hr"),kr=o(),U=l("a"),jr=o(),p(z.$$.fragment),Hr=o(),D=l("p"),D.textContent=al,Ir=o(),B=l("table"),B.innerHTML=ll,Fr=o(),Lr=l("hr"),Ar=o(),W=l("a"),Rr=o(),p(N.$$.fragment),Ur=o(),G=l("p"),G.textContent=dl,zr=o(),Z=l("p"),Z.innerHTML=cl,Dr=o(),Q=l("table"),Q.innerHTML=il,Br=o(),Wr=l("hr"),Nr=o(),X=l("a"),Gr=o(),p(V.$$.fragment),Zr=o(),Y=l("p"),Y.textContent=pl,Qr=o(),S=l("p"),S.innerHTML=nl,Xr=o(),q=l("table"),q.innerHTML=ml,Vr=o(),Yr=l("hr"),Sr=o(),K=l("a"),qr=o(),p(O.$$.fragment),Kr=o(),ee=l("p"),ee.textContent=ul,Or=o(),te=l("p"),te.innerHTML=hl,es=o(),re=l("table"),re.innerHTML=_l,ts=o(),rs=l("hr"),ss=o(),se=l("a"),os=o(),p(oe.$$.fragment),as=o(),ae=l("p"),ae.textContent=fl,ls=o(),le=l("p"),le.innerHTML=gl,ds=o(),de=l("table"),de.innerHTML=xl,cs=o(),is=l("hr"),ps=o(),ce=l("a"),ns=o(),p(ie.$$.fragment),ms=o(),pe=l("p"),pe.textContent=Tl,us=o(),ne=l("p"),ne.innerHTML=bl,hs=o(),me=l("table"),me.innerHTML=yl,_s=o(),fs=l("hr"),gs=o(),ue=l("a"),xs=o(),p(he.$$.fragment),Ts=o(),_e=l("p"),_e.textContent=vl,bs=o(),fe=l("p"),fe.innerHTML=wl,ys=o(),ge=l("ul"),ge.innerHTML=Ml,vs=o(),ws=l("hr"),Ms=o(),xe=l("a"),$s=o(),p(Te.$$.fragment),Es=o(),be=l("p"),be.textContent=$l,Cs=o(),ye=l("p"),ye.innerHTML=El,Js=o(),ve=l("table"),ve.innerHTML=Cl,Ps=o(),ks=l("hr"),js=o(),we=l("a"),Hs=o(),p(Me.$$.fragment),Is=o(),$e=l("p"),$e.innerHTML=Jl,Fs=o(),Ls=l("hr"),As=o(),Ee=l("a"),Rs=o(),p(Ce.$$.fragment),Us=o(),Je=l("p"),Je.innerHTML=Pl,zs=o(),Pe=l("p"),Pe.innerHTML=kl,Ds=o(),ke=l("table"),ke.innerHTML=jl,Bs=o(),Ws=l("hr"),Ns=o(),je=l("a"),Gs=o(),p(He.$$.fragment),Zs=o(),Ie=l("p"),Ie.textContent=Hl,Qs=o(),Fe=l("p"),Fe.innerHTML=Il,Xs=o(),Le=l("table"),Le.innerHTML=Fl,Vs=o(),Ys=l("hr"),Ss=o(),Ae=l("a"),qs=o(),p(Re.$$.fragment),Ks=o(),Ue=l("p"),Ue.textContent=Ll,Os=o(),ze=l("p"),ze.innerHTML=Al,eo=o(),De=l("table"),De.innerHTML=Rl,to=o(),ro=l("hr"),so=o(),Be=l("a"),oo=o(),p(We.$$.fragment),ao=o(),Ne=l("p"),Ne.textContent=Ul,lo=o(),Ge=l("p"),Ge.innerHTML=zl,co=o(),Ze=l("table"),Ze.innerHTML=Dl,io=o(),po=l("hr"),no=o(),Qe=l("a"),mo=o(),p(Xe.$$.fragment),uo=o(),Ve=l("p"),Ve.textContent=Bl,ho=o(),Ye=l("p"),Ye.innerHTML=Wl,_o=o(),Se=l("ul"),Se.innerHTML=Nl,fo=o(),go=l("hr"),xo=o(),qe=l("a"),To=o(),p(Ke.$$.fragment),bo=o(),Oe=l("p"),Oe.textContent=Gl,yo=o(),et=l("table"),et.innerHTML=Zl,vo=o(),wo=l("hr"),Mo=o(),tt=l("a"),$o=o(),p(rt.$$.fragment),Eo=o(),st=l("p"),st.textContent=Ql,Co=o(),ot=l("p"),ot.innerHTML=Xl,Jo=o(),at=l("table"),at.innerHTML=Vl,Po=o(),ko=l("hr"),jo=o(),lt=l("a"),Ho=o(),p(dt.$$.fragment),Io=o(),ct=l("p"),ct.textContent=Yl,Fo=o(),it=l("p"),it.innerHTML=Sl,Lo=o(),Ao=l("hr"),Ro=o(),pt=l("a"),Uo=o(),p(nt.$$.fragment),zo=o(),mt=l("p"),mt.textContent=ql,Do=o(),ut=l("p"),ut.innerHTML=Kl,Bo=o(),ht=l("table"),ht.innerHTML=Ol,Wo=o(),No=l("hr"),Go=o(),_t=l("a"),Zo=o(),p(ft.$$.fragment),Qo=o(),gt=l("p"),gt.innerHTML=ed,Xo=o(),xt=l("p"),xt.innerHTML=td,Vo=o(),p(Tt.$$.fragment),Yo=o(),bt=l("p"),bt.innerHTML=rd,So=o(),p(yt.$$.fragment),qo=o(),vt=l("p"),vt.innerHTML=sd,Ko=o(),Oo=l("hr"),ea=o(),wt=l("a"),ta=o(),p(Mt.$$.fragment),ra=o(),$t=l("p"),$t.textContent=od,sa=o(),Et=l("p"),Et.innerHTML=ad,oa=o(),Ct=l("p"),Ct.innerHTML=ld,aa=o(),Jt=l("table"),Jt.innerHTML=dd,la=o(),da=l("hr"),ca=o(),Pt=l("a"),ia=o(),p(kt.$$.fragment),pa=o(),jt=l("p"),jt.textContent=cd,na=o(),Ht=l("p"),Ht.innerHTML=id,ma=o(),It=l("table"),It.innerHTML=pd,ua=o(),ha=l("hr"),_a=o(),Ft=l("a"),fa=o(),p(Lt.$$.fragment),ga=o(),At=l("p"),At.textContent=nd,xa=o(),Rt=l("p"),Rt.innerHTML=md,Ta=o(),ba=l("hr"),ya=o(),Ut=l("a"),va=o(),p(zt.$$.fragment),wa=o(),Dt=l("p"),Dt.innerHTML=ud,Ma=o(),Bt=l("table"),Bt.innerHTML=hd,$a=o(),Ea=l("hr"),Ca=o(),Wt=l("a"),Ja=o(),p(Nt.$$.fragment),Pa=o(),Gt=l("p"),Gt.innerHTML=_d,ka=o(),Zt=l("table"),Zt.innerHTML=fd,ja=o(),Ha=l("hr"),Ia=o(),Qt=l("a"),Fa=o(),p(Xt.$$.fragment),La=o(),Vt=l("p"),Vt.innerHTML=gd,Aa=o(),Yt=l("table"),Yt.innerHTML=xd,Ra=o(),Ua=l("hr"),za=o(),St=l("a"),Da=o(),p(qt.$$.fragment),Ba=o(),Kt=l("p"),Kt.innerHTML=Td,Wa=o(),Ot=l("table"),Ot.innerHTML=bd,Na=o(),Ga=l("hr"),Za=o(),tr=l("p"),this.h()},l(e){const t=Ed("svelte-u9bgzb",document.head);x=d(t,"META",{name:!0,content:!0}),t.forEach(r),rr=a(e),er=d(e,"P",{}),f(er).forEach(r),sr=a(e),T=d(e,"A",{id:!0,class:!0}),f(T).forEach(r),or=a(e),n(b.$$.fragment,e),ar=a(e),y=d(e,"P",{"data-svelte-h":!0}),c(y)!=="svelte-w0rx8m"&&(y.textContent=Ya),lr=a(e),v=d(e,"P",{"data-svelte-h":!0}),c(v)!=="svelte-1olsie5"&&(v.innerHTML=Sa),dr=a(e),n(w.$$.fragment,e),cr=a(e),M=d(e,"UL",{"data-svelte-h":!0}),c(M)!=="svelte-16dz0k8"&&(M.innerHTML=qa),ir=a(e),pr=d(e,"HR",{}),nr=a(e),$=d(e,"A",{id:!0,class:!0}),f($).forEach(r),mr=a(e),n(E.$$.fragment,e),ur=a(e),C=d(e,"P",{"data-svelte-h":!0}),c(C)!=="svelte-14r3pvv"&&(C.textContent=Ka),hr=a(e),J=d(e,"P",{"data-svelte-h":!0}),c(J)!=="svelte-fac4cj"&&(J.innerHTML=Oa),_r=a(e),fr=d(e,"HR",{}),gr=a(e),P=d(e,"A",{id:!0,class:!0}),f(P).forEach(r),xr=a(e),n(k.$$.fragment,e),Tr=a(e),j=d(e,"P",{"data-svelte-h":!0}),c(j)!=="svelte-k3m2wg"&&(j.textContent=el),br=a(e),H=d(e,"TABLE",{"data-svelte-h":!0}),c(H)!=="svelte-rd7ds7"&&(H.innerHTML=tl),yr=a(e),vr=d(e,"HR",{}),wr=a(e),I=d(e,"A",{id:!0,class:!0}),f(I).forEach(r),Mr=a(e),n(F.$$.fragment,e),$r=a(e),L=d(e,"P",{"data-svelte-h":!0}),c(L)!=="svelte-8k8cys"&&(L.textContent=rl),Er=a(e),A=d(e,"P",{"data-svelte-h":!0}),c(A)!=="svelte-18p52n5"&&(A.innerHTML=sl),Cr=a(e),R=d(e,"UL",{"data-svelte-h":!0}),c(R)!=="svelte-9fhp8s"&&(R.innerHTML=ol),Jr=a(e),Pr=d(e,"HR",{}),kr=a(e),U=d(e,"A",{id:!0,class:!0}),f(U).forEach(r),jr=a(e),n(z.$$.fragment,e),Hr=a(e),D=d(e,"P",{"data-svelte-h":!0}),c(D)!=="svelte-1mp2vol"&&(D.textContent=al),Ir=a(e),B=d(e,"TABLE",{"data-svelte-h":!0}),c(B)!=="svelte-eb9kev"&&(B.innerHTML=ll),Fr=a(e),Lr=d(e,"HR",{}),Ar=a(e),W=d(e,"A",{id:!0,class:!0}),f(W).forEach(r),Rr=a(e),n(N.$$.fragment,e),Ur=a(e),G=d(e,"P",{"data-svelte-h":!0}),c(G)!=="svelte-1q6eyx4"&&(G.textContent=dl),zr=a(e),Z=d(e,"P",{"data-svelte-h":!0}),c(Z)!=="svelte-ar7q77"&&(Z.innerHTML=cl),Dr=a(e),Q=d(e,"TABLE",{"data-svelte-h":!0}),c(Q)!=="svelte-klyf4z"&&(Q.innerHTML=il),Br=a(e),Wr=d(e,"HR",{}),Nr=a(e),X=d(e,"A",{id:!0,class:!0}),f(X).forEach(r),Gr=a(e),n(V.$$.fragment,e),Zr=a(e),Y=d(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-7fx89a"&&(Y.textContent=pl),Qr=a(e),S=d(e,"P",{"data-svelte-h":!0}),c(S)!=="svelte-65os4c"&&(S.innerHTML=nl),Xr=a(e),q=d(e,"TABLE",{"data-svelte-h":!0}),c(q)!=="svelte-1dnvwno"&&(q.innerHTML=ml),Vr=a(e),Yr=d(e,"HR",{}),Sr=a(e),K=d(e,"A",{id:!0,class:!0}),f(K).forEach(r),qr=a(e),n(O.$$.fragment,e),Kr=a(e),ee=d(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1mmkb9p"&&(ee.textContent=ul),Or=a(e),te=d(e,"P",{"data-svelte-h":!0}),c(te)!=="svelte-110o3sn"&&(te.innerHTML=hl),es=a(e),re=d(e,"TABLE",{"data-svelte-h":!0}),c(re)!=="svelte-iqjbgm"&&(re.innerHTML=_l),ts=a(e),rs=d(e,"HR",{}),ss=a(e),se=d(e,"A",{id:!0,class:!0}),f(se).forEach(r),os=a(e),n(oe.$$.fragment,e),as=a(e),ae=d(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-10g8wi9"&&(ae.textContent=fl),ls=a(e),le=d(e,"P",{"data-svelte-h":!0}),c(le)!=="svelte-cd20o3"&&(le.innerHTML=gl),ds=a(e),de=d(e,"TABLE",{"data-svelte-h":!0}),c(de)!=="svelte-1773mps"&&(de.innerHTML=xl),cs=a(e),is=d(e,"HR",{}),ps=a(e),ce=d(e,"A",{id:!0,class:!0}),f(ce).forEach(r),ns=a(e),n(ie.$$.fragment,e),ms=a(e),pe=d(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1uytqp8"&&(pe.textContent=Tl),us=a(e),ne=d(e,"P",{"data-svelte-h":!0}),c(ne)!=="svelte-1pa0uk8"&&(ne.innerHTML=bl),hs=a(e),me=d(e,"TABLE",{"data-svelte-h":!0}),c(me)!=="svelte-hch5rz"&&(me.innerHTML=yl),_s=a(e),fs=d(e,"HR",{}),gs=a(e),ue=d(e,"A",{id:!0,class:!0}),f(ue).forEach(r),xs=a(e),n(he.$$.fragment,e),Ts=a(e),_e=d(e,"P",{"data-svelte-h":!0}),c(_e)!=="svelte-y1gxwn"&&(_e.textContent=vl),bs=a(e),fe=d(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-1xz91ac"&&(fe.innerHTML=wl),ys=a(e),ge=d(e,"UL",{"data-svelte-h":!0}),c(ge)!=="svelte-1obx36y"&&(ge.innerHTML=Ml),vs=a(e),ws=d(e,"HR",{}),Ms=a(e),xe=d(e,"A",{id:!0,class:!0}),f(xe).forEach(r),$s=a(e),n(Te.$$.fragment,e),Es=a(e),be=d(e,"P",{"data-svelte-h":!0}),c(be)!=="svelte-1ec3vsm"&&(be.textContent=$l),Cs=a(e),ye=d(e,"P",{"data-svelte-h":!0}),c(ye)!=="svelte-6tjpr7"&&(ye.innerHTML=El),Js=a(e),ve=d(e,"TABLE",{"data-svelte-h":!0}),c(ve)!=="svelte-1px7bnv"&&(ve.innerHTML=Cl),Ps=a(e),ks=d(e,"HR",{}),js=a(e),we=d(e,"A",{id:!0,class:!0}),f(we).forEach(r),Hs=a(e),n(Me.$$.fragment,e),Is=a(e),$e=d(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-j2v54d"&&($e.innerHTML=Jl),Fs=a(e),Ls=d(e,"HR",{}),As=a(e),Ee=d(e,"A",{id:!0,class:!0}),f(Ee).forEach(r),Rs=a(e),n(Ce.$$.fragment,e),Us=a(e),Je=d(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-75c7d5"&&(Je.innerHTML=Pl),zs=a(e),Pe=d(e,"P",{"data-svelte-h":!0}),c(Pe)!=="svelte-o8p6wm"&&(Pe.innerHTML=kl),Ds=a(e),ke=d(e,"TABLE",{"data-svelte-h":!0}),c(ke)!=="svelte-yqya7v"&&(ke.innerHTML=jl),Bs=a(e),Ws=d(e,"HR",{}),Ns=a(e),je=d(e,"A",{id:!0,class:!0}),f(je).forEach(r),Gs=a(e),n(He.$$.fragment,e),Zs=a(e),Ie=d(e,"P",{"data-svelte-h":!0}),c(Ie)!=="svelte-gl8gb6"&&(Ie.textContent=Hl),Qs=a(e),Fe=d(e,"P",{"data-svelte-h":!0}),c(Fe)!=="svelte-1qxvzd2"&&(Fe.innerHTML=Il),Xs=a(e),Le=d(e,"TABLE",{"data-svelte-h":!0}),c(Le)!=="svelte-1f7z42u"&&(Le.innerHTML=Fl),Vs=a(e),Ys=d(e,"HR",{}),Ss=a(e),Ae=d(e,"A",{id:!0,class:!0}),f(Ae).forEach(r),qs=a(e),n(Re.$$.fragment,e),Ks=a(e),Ue=d(e,"P",{"data-svelte-h":!0}),c(Ue)!=="svelte-7vs1p7"&&(Ue.textContent=Ll),Os=a(e),ze=d(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-15rcpil"&&(ze.innerHTML=Al),eo=a(e),De=d(e,"TABLE",{"data-svelte-h":!0}),c(De)!=="svelte-3xdz32"&&(De.innerHTML=Rl),to=a(e),ro=d(e,"HR",{}),so=a(e),Be=d(e,"A",{id:!0,class:!0}),f(Be).forEach(r),oo=a(e),n(We.$$.fragment,e),ao=a(e),Ne=d(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-frdp8m"&&(Ne.textContent=Ul),lo=a(e),Ge=d(e,"P",{"data-svelte-h":!0}),c(Ge)!=="svelte-j2v54d"&&(Ge.innerHTML=zl),co=a(e),Ze=d(e,"TABLE",{"data-svelte-h":!0}),c(Ze)!=="svelte-11rkhka"&&(Ze.innerHTML=Dl),io=a(e),po=d(e,"HR",{}),no=a(e),Qe=d(e,"A",{id:!0,class:!0}),f(Qe).forEach(r),mo=a(e),n(Xe.$$.fragment,e),uo=a(e),Ve=d(e,"P",{"data-svelte-h":!0}),c(Ve)!=="svelte-o9f953"&&(Ve.textContent=Bl),ho=a(e),Ye=d(e,"P",{"data-svelte-h":!0}),c(Ye)!=="svelte-fac4cj"&&(Ye.innerHTML=Wl),_o=a(e),Se=d(e,"UL",{"data-svelte-h":!0}),c(Se)!=="svelte-1v579im"&&(Se.innerHTML=Nl),fo=a(e),go=d(e,"HR",{}),xo=a(e),qe=d(e,"A",{id:!0,class:!0}),f(qe).forEach(r),To=a(e),n(Ke.$$.fragment,e),bo=a(e),Oe=d(e,"P",{"data-svelte-h":!0}),c(Oe)!=="svelte-1naom0u"&&(Oe.textContent=Gl),yo=a(e),et=d(e,"TABLE",{"data-svelte-h":!0}),c(et)!=="svelte-ilxs6c"&&(et.innerHTML=Zl),vo=a(e),wo=d(e,"HR",{}),Mo=a(e),tt=d(e,"A",{id:!0,class:!0}),f(tt).forEach(r),$o=a(e),n(rt.$$.fragment,e),Eo=a(e),st=d(e,"P",{"data-svelte-h":!0}),c(st)!=="svelte-zbbm3j"&&(st.textContent=Ql),Co=a(e),ot=d(e,"P",{"data-svelte-h":!0}),c(ot)!=="svelte-kflsb2"&&(ot.innerHTML=Xl),Jo=a(e),at=d(e,"TABLE",{"data-svelte-h":!0}),c(at)!=="svelte-pm1u9z"&&(at.innerHTML=Vl),Po=a(e),ko=d(e,"HR",{}),jo=a(e),lt=d(e,"A",{id:!0,class:!0}),f(lt).forEach(r),Ho=a(e),n(dt.$$.fragment,e),Io=a(e),ct=d(e,"P",{"data-svelte-h":!0}),c(ct)!=="svelte-17pib55"&&(ct.textContent=Yl),Fo=a(e),it=d(e,"P",{"data-svelte-h":!0}),c(it)!=="svelte-1ljhyyr"&&(it.innerHTML=Sl),Lo=a(e),Ao=d(e,"HR",{}),Ro=a(e),pt=d(e,"A",{id:!0,class:!0}),f(pt).forEach(r),Uo=a(e),n(nt.$$.fragment,e),zo=a(e),mt=d(e,"P",{"data-svelte-h":!0}),c(mt)!=="svelte-r5x3fh"&&(mt.textContent=ql),Do=a(e),ut=d(e,"P",{"data-svelte-h":!0}),c(ut)!=="svelte-1vpvonk"&&(ut.innerHTML=Kl),Bo=a(e),ht=d(e,"TABLE",{"data-svelte-h":!0}),c(ht)!=="svelte-nv3lon"&&(ht.innerHTML=Ol),Wo=a(e),No=d(e,"HR",{}),Go=a(e),_t=d(e,"A",{id:!0,class:!0}),f(_t).forEach(r),Zo=a(e),n(ft.$$.fragment,e),Qo=a(e),gt=d(e,"P",{"data-svelte-h":!0}),c(gt)!=="svelte-62dsf9"&&(gt.innerHTML=ed),Xo=a(e),xt=d(e,"P",{"data-svelte-h":!0}),c(xt)!=="svelte-11vd43e"&&(xt.innerHTML=td),Vo=a(e),n(Tt.$$.fragment,e),Yo=a(e),bt=d(e,"P",{"data-svelte-h":!0}),c(bt)!=="svelte-c0cgha"&&(bt.innerHTML=rd),So=a(e),n(yt.$$.fragment,e),qo=a(e),vt=d(e,"P",{"data-svelte-h":!0}),c(vt)!=="svelte-wmyz1o"&&(vt.innerHTML=sd),Ko=a(e),Oo=d(e,"HR",{}),ea=a(e),wt=d(e,"A",{id:!0,class:!0}),f(wt).forEach(r),ta=a(e),n(Mt.$$.fragment,e),ra=a(e),$t=d(e,"P",{"data-svelte-h":!0}),c($t)!=="svelte-jwfdp9"&&($t.textContent=od),sa=a(e),Et=d(e,"P",{"data-svelte-h":!0}),c(Et)!=="svelte-t85gxq"&&(Et.innerHTML=ad),oa=a(e),Ct=d(e,"P",{"data-svelte-h":!0}),c(Ct)!=="svelte-y7m8db"&&(Ct.innerHTML=ld),aa=a(e),Jt=d(e,"TABLE",{"data-svelte-h":!0}),c(Jt)!=="svelte-1oj79mt"&&(Jt.innerHTML=dd),la=a(e),da=d(e,"HR",{}),ca=a(e),Pt=d(e,"A",{id:!0,class:!0}),f(Pt).forEach(r),ia=a(e),n(kt.$$.fragment,e),pa=a(e),jt=d(e,"P",{"data-svelte-h":!0}),c(jt)!=="svelte-kjzox5"&&(jt.textContent=cd),na=a(e),Ht=d(e,"P",{"data-svelte-h":!0}),c(Ht)!=="svelte-19qboln"&&(Ht.innerHTML=id),ma=a(e),It=d(e,"TABLE",{"data-svelte-h":!0}),c(It)!=="svelte-1bv5sxq"&&(It.innerHTML=pd),ua=a(e),ha=d(e,"HR",{}),_a=a(e),Ft=d(e,"A",{id:!0,class:!0}),f(Ft).forEach(r),fa=a(e),n(Lt.$$.fragment,e),ga=a(e),At=d(e,"P",{"data-svelte-h":!0}),c(At)!=="svelte-2u8xbp"&&(At.textContent=nd),xa=a(e),Rt=d(e,"P",{"data-svelte-h":!0}),c(Rt)!=="svelte-3xndnt"&&(Rt.innerHTML=md),Ta=a(e),ba=d(e,"HR",{}),ya=a(e),Ut=d(e,"A",{id:!0,class:!0}),f(Ut).forEach(r),va=a(e),n(zt.$$.fragment,e),wa=a(e),Dt=d(e,"P",{"data-svelte-h":!0}),c(Dt)!=="svelte-cy5pwv"&&(Dt.innerHTML=ud),Ma=a(e),Bt=d(e,"TABLE",{"data-svelte-h":!0}),c(Bt)!=="svelte-1dyar84"&&(Bt.innerHTML=hd),$a=a(e),Ea=d(e,"HR",{}),Ca=a(e),Wt=d(e,"A",{id:!0,class:!0}),f(Wt).forEach(r),Ja=a(e),n(Nt.$$.fragment,e),Pa=a(e),Gt=d(e,"P",{"data-svelte-h":!0}),c(Gt)!=="svelte-cy5pwv"&&(Gt.innerHTML=_d),ka=a(e),Zt=d(e,"TABLE",{"data-svelte-h":!0}),c(Zt)!=="svelte-1cnys15"&&(Zt.innerHTML=fd),ja=a(e),Ha=d(e,"HR",{}),Ia=a(e),Qt=d(e,"A",{id:!0,class:!0}),f(Qt).forEach(r),Fa=a(e),n(Xt.$$.fragment,e),La=a(e),Vt=d(e,"P",{"data-svelte-h":!0}),c(Vt)!=="svelte-cy5pwv"&&(Vt.innerHTML=gd),Aa=a(e),Yt=d(e,"TABLE",{"data-svelte-h":!0}),c(Yt)!=="svelte-179cln2"&&(Yt.innerHTML=xd),Ra=a(e),Ua=d(e,"HR",{}),za=a(e),St=d(e,"A",{id:!0,class:!0}),f(St).forEach(r),Da=a(e),n(qt.$$.fragment,e),Ba=a(e),Kt=d(e,"P",{"data-svelte-h":!0}),c(Kt)!=="svelte-cy5pwv"&&(Kt.innerHTML=Td),Wa=a(e),Ot=d(e,"TABLE",{"data-svelte-h":!0}),c(Ot)!=="svelte-1btb1vt"&&(Ot.innerHTML=bd),Na=a(e),Ga=d(e,"HR",{}),Za=a(e),tr=d(e,"P",{}),f(tr).forEach(r),this.h()},h(){i(x,"name","hf:doc:metadata"),i(x,"content",Pd),i(T,"id","module_processors"),i(T,"class","group"),i($,"id","module_processors.FeatureExtractor"),i($,"class","group"),i(P,"id","new_module_processors.FeatureExtractor_new"),i(P,"class","group"),i(I,"id","module_processors.ImageFeatureExtractor"),i(I,"class","group"),i(U,"id","new_module_processors.ImageFeatureExtractor_new"),i(U,"class","group"),i(W,"id","module_processors.ImageFeatureExtractor+thumbnail"),i(W,"class","group"),i(X,"id","module_processors.ImageFeatureExtractor+crop_margin"),i(X,"class","group"),i(K,"id","module_processors.ImageFeatureExtractor+pad_image"),i(K,"class","group"),i(se,"id","module_processors.ImageFeatureExtractor+preprocess"),i(se,"class","group"),i(ce,"id","module_processors.ImageFeatureExtractor+_call"),i(ce,"class","group"),i(ue,"id","module_processors.DetrFeatureExtractor"),i(ue,"class","group"),i(xe,"id","module_processors.DetrFeatureExtractor+_call"),i(xe,"class","group"),i(we,"id","module_processors.DetrFeatureExtractor+post_process_object_detection"),i(we,"class","group"),i(Ee,"id","module_processors.DetrFeatureExtractor+remove_low_and_no_objects"),i(Ee,"class","group"),i(je,"id","module_processors.DetrFeatureExtractor+check_segment_validity"),i(je,"class","group"),i(Ae,"id","module_processors.DetrFeatureExtractor+compute_segments"),i(Ae,"class","group"),i(Be,"id","module_processors.DetrFeatureExtractor+post_process_panoptic_segmentation"),i(Be,"class","group"),i(Qe,"id","module_processors.Processor"),i(Qe,"class","group"),i(qe,"id","new_module_processors.Processor_new"),i(qe,"class","group"),i(tt,"id","module_processors.Processor+_call"),i(tt,"class","group"),i(lt,"id","module_processors.WhisperProcessor"),i(lt,"class","group"),i(pt,"id","module_processors.WhisperProcessor+_call"),i(pt,"class","group"),i(_t,"id","module_processors.AutoProcessor"),i(_t,"class","group"),i(wt,"id","module_processors.AutoProcessor.from_pretrained"),i(wt,"class","group"),i(Pt,"id","module_processors..center_to_corners_format"),i(Pt,"class","group"),i(Ft,"id","module_processors..HeightWidth"),i(Ft,"class","group"),i(Ut,"id","module_processors..ImageFeatureExtractorResult"),i(Ut,"class","group"),i(Wt,"id","module_processors..PreprocessedImage"),i(Wt,"class","group"),i(Qt,"id","module_processors..DetrFeatureExtractorResult"),i(Qt,"class","group"),i(St,"id","module_processors..SamImageProcessorResult"),i(St,"class","group")},m(e,t){Cd(document.head,x),s(e,rr,t),s(e,er,t),s(e,sr,t),s(e,T,t),s(e,or,t),m(b,e,t),s(e,ar,t),s(e,y,t),s(e,lr,t),s(e,v,t),s(e,dr,t),m(w,e,t),s(e,cr,t),s(e,M,t),s(e,ir,t),s(e,pr,t),s(e,nr,t),s(e,$,t),s(e,mr,t),m(E,e,t),s(e,ur,t),s(e,C,t),s(e,hr,t),s(e,J,t),s(e,_r,t),s(e,fr,t),s(e,gr,t),s(e,P,t),s(e,xr,t),m(k,e,t),s(e,Tr,t),s(e,j,t),s(e,br,t),s(e,H,t),s(e,yr,t),s(e,vr,t),s(e,wr,t),s(e,I,t),s(e,Mr,t),m(F,e,t),s(e,$r,t),s(e,L,t),s(e,Er,t),s(e,A,t),s(e,Cr,t),s(e,R,t),s(e,Jr,t),s(e,Pr,t),s(e,kr,t),s(e,U,t),s(e,jr,t),m(z,e,t),s(e,Hr,t),s(e,D,t),s(e,Ir,t),s(e,B,t),s(e,Fr,t),s(e,Lr,t),s(e,Ar,t),s(e,W,t),s(e,Rr,t),m(N,e,t),s(e,Ur,t),s(e,G,t),s(e,zr,t),s(e,Z,t),s(e,Dr,t),s(e,Q,t),s(e,Br,t),s(e,Wr,t),s(e,Nr,t),s(e,X,t),s(e,Gr,t),m(V,e,t),s(e,Zr,t),s(e,Y,t),s(e,Qr,t),s(e,S,t),s(e,Xr,t),s(e,q,t),s(e,Vr,t),s(e,Yr,t),s(e,Sr,t),s(e,K,t),s(e,qr,t),m(O,e,t),s(e,Kr,t),s(e,ee,t),s(e,Or,t),s(e,te,t),s(e,es,t),s(e,re,t),s(e,ts,t),s(e,rs,t),s(e,ss,t),s(e,se,t),s(e,os,t),m(oe,e,t),s(e,as,t),s(e,ae,t),s(e,ls,t),s(e,le,t),s(e,ds,t),s(e,de,t),s(e,cs,t),s(e,is,t),s(e,ps,t),s(e,ce,t),s(e,ns,t),m(ie,e,t),s(e,ms,t),s(e,pe,t),s(e,us,t),s(e,ne,t),s(e,hs,t),s(e,me,t),s(e,_s,t),s(e,fs,t),s(e,gs,t),s(e,ue,t),s(e,xs,t),m(he,e,t),s(e,Ts,t),s(e,_e,t),s(e,bs,t),s(e,fe,t),s(e,ys,t),s(e,ge,t),s(e,vs,t),s(e,ws,t),s(e,Ms,t),s(e,xe,t),s(e,$s,t),m(Te,e,t),s(e,Es,t),s(e,be,t),s(e,Cs,t),s(e,ye,t),s(e,Js,t),s(e,ve,t),s(e,Ps,t),s(e,ks,t),s(e,js,t),s(e,we,t),s(e,Hs,t),m(Me,e,t),s(e,Is,t),s(e,$e,t),s(e,Fs,t),s(e,Ls,t),s(e,As,t),s(e,Ee,t),s(e,Rs,t),m(Ce,e,t),s(e,Us,t),s(e,Je,t),s(e,zs,t),s(e,Pe,t),s(e,Ds,t),s(e,ke,t),s(e,Bs,t),s(e,Ws,t),s(e,Ns,t),s(e,je,t),s(e,Gs,t),m(He,e,t),s(e,Zs,t),s(e,Ie,t),s(e,Qs,t),s(e,Fe,t),s(e,Xs,t),s(e,Le,t),s(e,Vs,t),s(e,Ys,t),s(e,Ss,t),s(e,Ae,t),s(e,qs,t),m(Re,e,t),s(e,Ks,t),s(e,Ue,t),s(e,Os,t),s(e,ze,t),s(e,eo,t),s(e,De,t),s(e,to,t),s(e,ro,t),s(e,so,t),s(e,Be,t),s(e,oo,t),m(We,e,t),s(e,ao,t),s(e,Ne,t),s(e,lo,t),s(e,Ge,t),s(e,co,t),s(e,Ze,t),s(e,io,t),s(e,po,t),s(e,no,t),s(e,Qe,t),s(e,mo,t),m(Xe,e,t),s(e,uo,t),s(e,Ve,t),s(e,ho,t),s(e,Ye,t),s(e,_o,t),s(e,Se,t),s(e,fo,t),s(e,go,t),s(e,xo,t),s(e,qe,t),s(e,To,t),m(Ke,e,t),s(e,bo,t),s(e,Oe,t),s(e,yo,t),s(e,et,t),s(e,vo,t),s(e,wo,t),s(e,Mo,t),s(e,tt,t),s(e,$o,t),m(rt,e,t),s(e,Eo,t),s(e,st,t),s(e,Co,t),s(e,ot,t),s(e,Jo,t),s(e,at,t),s(e,Po,t),s(e,ko,t),s(e,jo,t),s(e,lt,t),s(e,Ho,t),m(dt,e,t),s(e,Io,t),s(e,ct,t),s(e,Fo,t),s(e,it,t),s(e,Lo,t),s(e,Ao,t),s(e,Ro,t),s(e,pt,t),s(e,Uo,t),m(nt,e,t),s(e,zo,t),s(e,mt,t),s(e,Do,t),s(e,ut,t),s(e,Bo,t),s(e,ht,t),s(e,Wo,t),s(e,No,t),s(e,Go,t),s(e,_t,t),s(e,Zo,t),m(ft,e,t),s(e,Qo,t),s(e,gt,t),s(e,Xo,t),s(e,xt,t),s(e,Vo,t),m(Tt,e,t),s(e,Yo,t),s(e,bt,t),s(e,So,t),m(yt,e,t),s(e,qo,t),s(e,vt,t),s(e,Ko,t),s(e,Oo,t),s(e,ea,t),s(e,wt,t),s(e,ta,t),m(Mt,e,t),s(e,ra,t),s(e,$t,t),s(e,sa,t),s(e,Et,t),s(e,oa,t),s(e,Ct,t),s(e,aa,t),s(e,Jt,t),s(e,la,t),s(e,da,t),s(e,ca,t),s(e,Pt,t),s(e,ia,t),m(kt,e,t),s(e,pa,t),s(e,jt,t),s(e,na,t),s(e,Ht,t),s(e,ma,t),s(e,It,t),s(e,ua,t),s(e,ha,t),s(e,_a,t),s(e,Ft,t),s(e,fa,t),m(Lt,e,t),s(e,ga,t),s(e,At,t),s(e,xa,t),s(e,Rt,t),s(e,Ta,t),s(e,ba,t),s(e,ya,t),s(e,Ut,t),s(e,va,t),m(zt,e,t),s(e,wa,t),s(e,Dt,t),s(e,Ma,t),s(e,Bt,t),s(e,$a,t),s(e,Ea,t),s(e,Ca,t),s(e,Wt,t),s(e,Ja,t),m(Nt,e,t),s(e,Pa,t),s(e,Gt,t),s(e,ka,t),s(e,Zt,t),s(e,ja,t),s(e,Ha,t),s(e,Ia,t),s(e,Qt,t),s(e,Fa,t),m(Xt,e,t),s(e,La,t),s(e,Vt,t),s(e,Aa,t),s(e,Yt,t),s(e,Ra,t),s(e,Ua,t),s(e,za,t),s(e,St,t),s(e,Da,t),m(qt,e,t),s(e,Ba,t),s(e,Kt,t),s(e,Wa,t),s(e,Ot,t),s(e,Na,t),s(e,Ga,t),s(e,Za,t),s(e,tr,t),Qa=!0},p:vd,i(e){Qa||(u(b.$$.fragment,e),u(w.$$.fragment,e),u(E.$$.fragment,e),u(k.$$.fragment,e),u(F.$$.fragment,e),u(z.$$.fragment,e),u(N.$$.fragment,e),u(V.$$.fragment,e),u(O.$$.fragment,e),u(oe.$$.fragment,e),u(ie.$$.fragment,e),u(he.$$.fragment,e),u(Te.$$.fragment,e),u(Me.$$.fragment,e),u(Ce.$$.fragment,e),u(He.$$.fragment,e),u(Re.$$.fragment,e),u(We.$$.fragment,e),u(Xe.$$.fragment,e),u(Ke.$$.fragment,e),u(rt.$$.fragment,e),u(dt.$$.fragment,e),u(nt.$$.fragment,e),u(ft.$$.fragment,e),u(Tt.$$.fragment,e),u(yt.$$.fragment,e),u(Mt.$$.fragment,e),u(kt.$$.fragment,e),u(Lt.$$.fragment,e),u(zt.$$.fragment,e),u(Nt.$$.fragment,e),u(Xt.$$.fragment,e),u(qt.$$.fragment,e),Qa=!0)},o(e){h(b.$$.fragment,e),h(w.$$.fragment,e),h(E.$$.fragment,e),h(k.$$.fragment,e),h(F.$$.fragment,e),h(z.$$.fragment,e),h(N.$$.fragment,e),h(V.$$.fragment,e),h(O.$$.fragment,e),h(oe.$$.fragment,e),h(ie.$$.fragment,e),h(he.$$.fragment,e),h(Te.$$.fragment,e),h(Me.$$.fragment,e),h(Ce.$$.fragment,e),h(He.$$.fragment,e),h(Re.$$.fragment,e),h(We.$$.fragment,e),h(Xe.$$.fragment,e),h(Ke.$$.fragment,e),h(rt.$$.fragment,e),h(dt.$$.fragment,e),h(nt.$$.fragment,e),h(ft.$$.fragment,e),h(Tt.$$.fragment,e),h(yt.$$.fragment,e),h(Mt.$$.fragment,e),h(kt.$$.fragment,e),h(Lt.$$.fragment,e),h(zt.$$.fragment,e),h(Nt.$$.fragment,e),h(Xt.$$.fragment,e),h(qt.$$.fragment,e),Qa=!1},d(e){e&&(r(rr),r(er),r(sr),r(T),r(or),r(ar),r(y),r(lr),r(v),r(dr),r(cr),r(M),r(ir),r(pr),r(nr),r($),r(mr),r(ur),r(C),r(hr),r(J),r(_r),r(fr),r(gr),r(P),r(xr),r(Tr),r(j),r(br),r(H),r(yr),r(vr),r(wr),r(I),r(Mr),r($r),r(L),r(Er),r(A),r(Cr),r(R),r(Jr),r(Pr),r(kr),r(U),r(jr),r(Hr),r(D),r(Ir),r(B),r(Fr),r(Lr),r(Ar),r(W),r(Rr),r(Ur),r(G),r(zr),r(Z),r(Dr),r(Q),r(Br),r(Wr),r(Nr),r(X),r(Gr),r(Zr),r(Y),r(Qr),r(S),r(Xr),r(q),r(Vr),r(Yr),r(Sr),r(K),r(qr),r(Kr),r(ee),r(Or),r(te),r(es),r(re),r(ts),r(rs),r(ss),r(se),r(os),r(as),r(ae),r(ls),r(le),r(ds),r(de),r(cs),r(is),r(ps),r(ce),r(ns),r(ms),r(pe),r(us),r(ne),r(hs),r(me),r(_s),r(fs),r(gs),r(ue),r(xs),r(Ts),r(_e),r(bs),r(fe),r(ys),r(ge),r(vs),r(ws),r(Ms),r(xe),r($s),r(Es),r(be),r(Cs),r(ye),r(Js),r(ve),r(Ps),r(ks),r(js),r(we),r(Hs),r(Is),r($e),r(Fs),r(Ls),r(As),r(Ee),r(Rs),r(Us),r(Je),r(zs),r(Pe),r(Ds),r(ke),r(Bs),r(Ws),r(Ns),r(je),r(Gs),r(Zs),r(Ie),r(Qs),r(Fe),r(Xs),r(Le),r(Vs),r(Ys),r(Ss),r(Ae),r(qs),r(Ks),r(Ue),r(Os),r(ze),r(eo),r(De),r(to),r(ro),r(so),r(Be),r(oo),r(ao),r(Ne),r(lo),r(Ge),r(co),r(Ze),r(io),r(po),r(no),r(Qe),r(mo),r(uo),r(Ve),r(ho),r(Ye),r(_o),r(Se),r(fo),r(go),r(xo),r(qe),r(To),r(bo),r(Oe),r(yo),r(et),r(vo),r(wo),r(Mo),r(tt),r($o),r(Eo),r(st),r(Co),r(ot),r(Jo),r(at),r(Po),r(ko),r(jo),r(lt),r(Ho),r(Io),r(ct),r(Fo),r(it),r(Lo),r(Ao),r(Ro),r(pt),r(Uo),r(zo),r(mt),r(Do),r(ut),r(Bo),r(ht),r(Wo),r(No),r(Go),r(_t),r(Zo),r(Qo),r(gt),r(Xo),r(xt),r(Vo),r(Yo),r(bt),r(So),r(qo),r(vt),r(Ko),r(Oo),r(ea),r(wt),r(ta),r(ra),r($t),r(sa),r(Et),r(oa),r(Ct),r(aa),r(Jt),r(la),r(da),r(ca),r(Pt),r(ia),r(pa),r(jt),r(na),r(Ht),r(ma),r(It),r(ua),r(ha),r(_a),r(Ft),r(fa),r(ga),r(At),r(xa),r(Rt),r(Ta),r(ba),r(ya),r(Ut),r(va),r(wa),r(Dt),r(Ma),r(Bt),r($a),r(Ea),r(Ca),r(Wt),r(Ja),r(Pa),r(Gt),r(ka),r(Zt),r(ja),r(Ha),r(Ia),r(Qt),r(Fa),r(La),r(Vt),r(Aa),r(Yt),r(Ra),r(Ua),r(za),r(St),r(Da),r(Ba),r(Kt),r(Wa),r(Ot),r(Na),r(Ga),r(Za),r(tr)),r(x),_(b,e),_(w,e),_(E,e),_(k,e),_(F,e),_(z,e),_(N,e),_(V,e),_(O,e),_(oe,e),_(ie,e),_(he,e),_(Te,e),_(Me,e),_(Ce,e),_(He,e),_(Re,e),_(We,e),_(Xe,e),_(Ke,e),_(rt,e),_(dt,e),_(nt,e),_(ft,e),_(Tt,e),_(yt,e),_(Mt,e),_(kt,e),_(Lt,e),_(zt,e),_(Nt,e),_(Xt,e),_(qt,e)}}}const Pd='{"title":"processors","local":"processors","sections":[{"title":"processors.FeatureExtractor ⇐ <code> Callable </code>","local":"processorsfeatureextractor--code-callable-code","sections":[{"title":"new FeatureExtractor(config)","local":"new-featureextractorconfig","sections":[],"depth":3}],"depth":2},{"title":"processors.ImageFeatureExtractor ⇐ <code> FeatureExtractor </code>","local":"processorsimagefeatureextractor--code-featureextractor-code","sections":[{"title":"new ImageFeatureExtractor(config)","local":"new-imagefeatureextractorconfig","sections":[],"depth":3},{"title":"imageFeatureExtractor.thumbnail(image, size, [resample]) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorthumbnailimage-size-resample--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.crop_margin(image, gray_threshold) ⇒ <code> Promise. < RawImage > </code>","local":"imagefeatureextractorcropmarginimage-graythreshold--code-promise--rawimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.pad_image(pixelData, imgDims, padSize, options) ⇒ <code> * </code>","local":"imagefeatureextractorpadimagepixeldata-imgdims-padsize-options--code--code","sections":[],"depth":3},{"title":"imageFeatureExtractor.preprocess(image, overrides) ⇒ <code> Promise. < PreprocessedImage > </code>","local":"imagefeatureextractorpreprocessimage-overrides--code-promise--preprocessedimage--code","sections":[],"depth":3},{"title":"imageFeatureExtractor._call(images, ...args) ⇒ <code> Promise. < ImageFeatureExtractorResult > </code>","local":"imagefeatureextractorcallimages-args--code-promise--imagefeatureextractorresult--code","sections":[],"depth":3}],"depth":2},{"title":"processors.DetrFeatureExtractor ⇐ <code> ImageFeatureExtractor </code>","local":"processorsdetrfeatureextractor--code-imagefeatureextractor-code","sections":[{"title":"detrFeatureExtractor._call(images) ⇒ <code> Promise. < DetrFeatureExtractorResult > </code>","local":"detrfeatureextractorcallimages--code-promise--detrfeatureextractorresult--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_object_detection() : <code> post_process_object_detection </code>","local":"detrfeatureextractorpostprocessobjectdetection--code-postprocessobjectdetection-code","sections":[],"depth":3},{"title":"detrFeatureExtractor.remove_low_and_no_objects(class_logits, mask_logits, object_mask_threshold, num_labels) ⇒ <code> * </code>","local":"detrfeatureextractorremovelowandnoobjectsclasslogits-masklogits-objectmaskthreshold-numlabels--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.check_segment_validity(mask_labels, mask_probs, k, mask_threshold, overlap_mask_area_threshold) ⇒ <code> * </code>","local":"detrfeatureextractorchecksegmentvaliditymasklabels-maskprobs-k-maskthreshold-overlapmaskareathreshold--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.compute_segments(mask_probs, pred_scores, pred_labels, mask_threshold, overlap_mask_area_threshold, label_ids_to_fuse, target_size) ⇒ <code> * </code>","local":"detrfeatureextractorcomputesegmentsmaskprobs-predscores-predlabels-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsize--code--code","sections":[],"depth":3},{"title":"detrFeatureExtractor.post_process_panoptic_segmentation(outputs, [threshold], [mask_threshold], [overlap_mask_area_threshold], [label_ids_to_fuse], [target_sizes]) ⇒ <code> Array. < {segmentation: Tensor, segments_info: Array < {id: number, label_id: number, score: number} > } > </code>","local":"detrfeatureextractorpostprocesspanopticsegmentationoutputs-threshold-maskthreshold-overlapmaskareathreshold-labelidstofuse-targetsizes--code-array--segmentation-tensor-segmentsinfo-array--id-number-labelid-number-score-number----code","sections":[],"depth":3}],"depth":2},{"title":"processors.Processor ⇐ <code> Callable </code>","local":"processorsprocessor--code-callable-code","sections":[{"title":"new Processor(feature_extractor)","local":"new-processorfeatureextractor","sections":[],"depth":3},{"title":"processor._call(input, ...args) ⇒ <code> Promise. < any > </code>","local":"processorcallinput-args--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.WhisperProcessor ⇐ <code> Processor </code>","local":"processorswhisperprocessor--code-processor-code","sections":[{"title":"whisperProcessor._call(audio) ⇒ <code> Promise. < any > </code>","local":"whisperprocessorcallaudio--code-promise--any--code","sections":[],"depth":3}],"depth":2},{"title":"processors.AutoProcessor","local":"processorsautoprocessor","sections":[{"title":"AutoProcessor.from_pretrained(pretrained_model_name_or_path, options) ⇒ <code> Promise. < Processor > </code>","local":"autoprocessorfrompretrainedpretrainedmodelnameorpath-options--code-promise--processor--code","sections":[],"depth":3}],"depth":2},{"title":"processors~center_to_corners_format(arr) ⇒ <code> Array. < number > </code>","local":"processorscentertocornersformatarr--code-array--number--code","sections":[],"depth":2},{"title":"processors~HeightWidth : <code> * </code>","local":"processorsheightwidth--code--code","sections":[],"depth":2},{"title":"processors~ImageFeatureExtractorResult : <code> object </code>","local":"processorsimagefeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~PreprocessedImage : <code> object </code>","local":"processorspreprocessedimage--code-object-code","sections":[],"depth":2},{"title":"processors~DetrFeatureExtractorResult : <code> object </code>","local":"processorsdetrfeatureextractorresult--code-object-code","sections":[],"depth":2},{"title":"processors~SamImageProcessorResult : <code> object </code>","local":"processorssamimageprocessorresult--code-object-code","sections":[],"depth":2}],"depth":1}';function kd(Va){return wd(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ld extends Md{constructor(x){super(),$d(this,x,kd,Jd,yd,{})}}export{Ld as component};
