import{s as ye,f as me,n as de,o as ce}from"../chunks/scheduler.389d799c.js";import{S as ue,i as je,g as i,s as a,r as o,A as he,h as M,f as l,c as n,j as qt,u as p,x as r,k as J,y as Je,a as s,v as y,d as m,t as d,w as c}from"../chunks/index.8f81d18f.js";import{C as j}from"../chunks/CodeBlock.3845caa1.js";import{H as et,E as we}from"../chunks/EditOnGithub.33306dfe.js";function Te(St){let h,at,lt,nt,w,it,T,Qt="The get started guide will show you how to quickly use Hugging Face on Amazon SageMaker. Learn how to fine-tune and deploy a pretrained 🤗 Transformers model on SageMaker for a binary text classification task.",Mt,f,xt='💡 If you are new to Hugging Face, we recommend first reading the 🤗 Transformers <a href="https://huggingface.co/docs/transformers/quicktour" rel="nofollow">quick tour</a>.',ot,u,Et,pt,U,Lt='📓 Open the <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/sagemaker-notebook.ipynb" rel="nofollow">agemaker-notebook.ipynb file</a> to follow along!',rt,g,yt,b,Pt='Get started by installing the necessary Hugging Face libraries and SageMaker. You will also need to install <a href="https://pytorch.org/get-started/locally/" rel="nofollow">PyTorch</a> and <a href="https://www.tensorflow.org/install/pip#tensorflow-2-packages-are-available" rel="nofollow">TensorFlow</a> if you don’t already have it installed.',mt,I,dt,C,Dt='If you want to run this example in <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/studio.html" rel="nofollow">SageMaker Studio</a>, upgrade <a href="https://ipywidgets.readthedocs.io/en/latest/" rel="nofollow">ipywidgets</a> for the 🤗 Datasets library and restart the kernel:',ct,k,ut,Z,Kt='Next, you should set up your environment: a SageMaker session and an S3 bucket. The S3 bucket will store data, models, and logs. You will need access to an <a href="https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html" rel="nofollow">IAM execution role</a> with the required permissions.',jt,$,Ot='If you are planning on using SageMaker in a local environment, you need to provide the <code>role</code> yourself. Learn more about how to set this up <a href="https://huggingface.co/docs/sagemaker/train#installation-and-setup" rel="nofollow">here</a>.',ht,A,te="⚠️ The execution role is only available when you run a notebook within SageMaker. If you try to run <code>get_execution_role</code> in a notebook not on SageMaker, you will get a region error.",Jt,X,wt,G,Tt,W,ee='The 🤗 Datasets library makes it easy to download and preprocess a dataset for training. Download and tokenize the <a href="https://huggingface.co/datasets/imdb" rel="nofollow">IMDb</a> dataset:',ft,_,Ut,B,gt,z,le='Next, upload the preprocessed dataset to your S3 session bucket with 🤗 Datasets S3 <a href="https://huggingface.co/docs/datasets/filesystems.html" rel="nofollow">filesystem</a> implementation:',bt,Y,It,V,Ct,N,se="Create a Hugging Face Estimator to handle end-to-end SageMaker training and deployment. The most important parameters to pay attention to are:",kt,R,ae='<li><code>entry_point</code> refers to the fine-tuning script which you can find in <a href="https://github.com/huggingface/notebooks/blob/main/sagemaker/01_getting_started_pytorch/scripts/train.py" rel="nofollow">train.py file</a>.</li> <li><code>instance_type</code> refers to the SageMaker instance that will be launched. Take a look <a href="https://aws.amazon.com/sagemaker/pricing/" rel="nofollow">here</a> for a complete list of instance types.</li> <li><code>hyperparameters</code> refers to the training hyperparameters the model will be fine-tuned with.</li>',Zt,F,$t,H,ne="Begin training with one line of code:",At,v,Xt,q,Gt,S,ie="Once the training job is complete, deploy your fine-tuned model by calling <code>deploy()</code> with the number of instances and instance type:",Wt,Q,_t,x,Me="Call <code>predict()</code> on your data:",Bt,E,zt,L,oe="After running your request, delete the endpoint:",Yt,P,Vt,D,Nt,K,pe="Congratulations, you’ve just fine-tuned and deployed a pretrained 🤗 Transformers model on SageMaker! 🎉",Rt,O,re='For your next steps, keep reading our documentation for more details about training and deployment. There are many interesting features such as <a href="/docs/sagemaker/train#distributed-training">distributed training</a> and <a href="/docs/sagemaker/train#spot-instances">Spot instances</a>.',Ft,tt,Ht,st,vt;return w=new et({props:{title:"Train and deploy Hugging Face on Amazon SageMaker",local:"train-and-deploy-hugging-face-on-amazon-sagemaker",headingTag:"h1"}}),g=new et({props:{title:"Installation and setup",local:"installation-and-setup",headingTag:"h2"}}),I=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMCUyMnNhZ2VtYWtlciUzRSUzRDIuMTQwLjAlMjIlMjAlMjJ0cmFuc2Zvcm1lcnMlM0QlM0Q0LjI2LjElMjIlMjAlMjJkYXRhc2V0cyU1QnMzJTVEJTNEJTNEMi4xMC4xJTIyJTIwLS11cGdyYWRl",highlighted:'pip install <span class="hljs-string">&quot;sagemaker&gt;=2.140.0&quot;</span> <span class="hljs-string">&quot;transformers==4.26.1&quot;</span> <span class="hljs-string">&quot;datasets[s3]==2.10.1&quot;</span> --upgrade',wrap:!1}}),k=new j({props:{code:"JTI1JTI1Y2FwdHVyZSUwQWltcG9ydCUyMElQeXRob24lMEEhY29uZGElMjBpbnN0YWxsJTIwLWMlMjBjb25kYS1mb3JnZSUyMGlweXdpZGdldHMlMjAteSUwQUlQeXRob24uQXBwbGljYXRpb24uaW5zdGFuY2UoKS5rZXJuZWwuZG9fc2h1dGRvd24oVHJ1ZSk=",highlighted:`%%capture
<span class="hljs-keyword">import</span> IPython
!conda install -c conda-forge ipywidgets -y
IPython.Application.instance().kernel.do_shutdown(<span class="hljs-literal">True</span>)`,wrap:!1}}),X=new j({props:{code:"aW1wb3J0JTIwc2FnZW1ha2VyJTBBJTBBc2VzcyUyMCUzRCUyMHNhZ2VtYWtlci5TZXNzaW9uKCklMEFzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjAlM0QlMjBOb25lJTBBaWYlMjBzYWdlbWFrZXJfc2Vzc2lvbl9idWNrZXQlMjBpcyUyME5vbmUlMjBhbmQlMjBzZXNzJTIwaXMlMjBub3QlMjBOb25lJTNBJTBBJTIwJTIwJTIwJTIwc2FnZW1ha2VyX3Nlc3Npb25fYnVja2V0JTIwJTNEJTIwc2Vzcy5kZWZhdWx0X2J1Y2tldCgpJTBBJTBBcm9sZSUyMCUzRCUyMHNhZ2VtYWtlci5nZXRfZXhlY3V0aW9uX3JvbGUoKSUwQXNlc3MlMjAlM0QlMjBzYWdlbWFrZXIuU2Vzc2lvbihkZWZhdWx0X2J1Y2tldCUzRHNhZ2VtYWtlcl9zZXNzaW9uX2J1Y2tldCk=",highlighted:`<span class="hljs-keyword">import</span> sagemaker

sess = sagemaker.Session()
sagemaker_session_bucket = <span class="hljs-literal">None</span>
<span class="hljs-keyword">if</span> sagemaker_session_bucket <span class="hljs-keyword">is</span> <span class="hljs-literal">None</span> <span class="hljs-keyword">and</span> sess <span class="hljs-keyword">is</span> <span class="hljs-keyword">not</span> <span class="hljs-literal">None</span>:
    sagemaker_session_bucket = sess.default_bucket()

role = sagemaker.get_execution_role()
sess = sagemaker.Session(default_bucket=sagemaker_session_bucket)`,wrap:!1}}),G=new et({props:{title:"Preprocess",local:"preprocess",headingTag:"h2"}}),_=new j({props:{code:"ZnJvbSUyMGRhdGFzZXRzJTIwaW1wb3J0JTIwbG9hZF9kYXRhc2V0JTBBZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Ub2tlbml6ZXIlMEElMEElMjMlMjBsb2FkJTIwZGF0YXNldCUwQXRyYWluX2RhdGFzZXQlMkMlMjB0ZXN0X2RhdGFzZXQlMjAlM0QlMjBsb2FkX2RhdGFzZXQoJTIyaW1kYiUyMiUyQyUyMHNwbGl0JTNEJTVCJTIydHJhaW4lMjIlMkMlMjAlMjJ0ZXN0JTIyJTVEKSUwQSUwQSUyMyUyMGxvYWQlMjB0b2tlbml6ZXIlMEF0b2tlbml6ZXIlMjAlM0QlMjBBdXRvVG9rZW5pemVyLmZyb21fcHJldHJhaW5lZCglMjJkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIpJTBBJTBBJTIzJTIwY3JlYXRlJTIwdG9rZW5pemF0aW9uJTIwZnVuY3Rpb24lMEFkZWYlMjB0b2tlbml6ZShiYXRjaCklM0ElMEElMjAlMjAlMjAlMjByZXR1cm4lMjB0b2tlbml6ZXIoYmF0Y2glNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwcGFkZGluZyUzRCUyMm1heF9sZW5ndGglMjIlMkMlMjB0cnVuY2F0aW9uJTNEVHJ1ZSklMEElMEElMjMlMjB0b2tlbml6ZSUyMHRyYWluJTIwYW5kJTIwdGVzdCUyMGRhdGFzZXRzJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMHRyYWluX2RhdGFzZXQubWFwKHRva2VuaXplJTJDJTIwYmF0Y2hlZCUzRFRydWUpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0Lm1hcCh0b2tlbml6ZSUyQyUyMGJhdGNoZWQlM0RUcnVlKSUwQSUwQSUyMyUyMHNldCUyMGRhdGFzZXQlMjBmb3JtYXQlMjBmb3IlMjBQeVRvcmNoJTBBdHJhaW5fZGF0YXNldCUyMCUzRCUyMCUyMHRyYWluX2RhdGFzZXQucmVuYW1lX2NvbHVtbiglMjJsYWJlbCUyMiUyQyUyMCUyMmxhYmVscyUyMiklMEF0cmFpbl9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQpJTBBdGVzdF9kYXRhc2V0JTIwJTNEJTIwdGVzdF9kYXRhc2V0LnJlbmFtZV9jb2x1bW4oJTIybGFiZWwlMjIlMkMlMjAlMjJsYWJlbHMlMjIpJTBBdGVzdF9kYXRhc2V0LnNldF9mb3JtYXQoJTIydG9yY2glMjIlMkMlMjBjb2x1bW5zJTNEJTVCJTIyaW5wdXRfaWRzJTIyJTJDJTIwJTIyYXR0ZW50aW9uX21hc2slMjIlMkMlMjAlMjJsYWJlbHMlMjIlNUQp",highlighted:`<span class="hljs-keyword">from</span> datasets <span class="hljs-keyword">import</span> load_dataset
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoTokenizer

<span class="hljs-comment"># load dataset</span>
train_dataset, test_dataset = load_dataset(<span class="hljs-string">&quot;imdb&quot;</span>, split=[<span class="hljs-string">&quot;train&quot;</span>, <span class="hljs-string">&quot;test&quot;</span>])

<span class="hljs-comment"># load tokenizer</span>
tokenizer = AutoTokenizer.from_pretrained(<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>)

<span class="hljs-comment"># create tokenization function</span>
<span class="hljs-keyword">def</span> <span class="hljs-title function_">tokenize</span>(<span class="hljs-params">batch</span>):
    <span class="hljs-keyword">return</span> tokenizer(batch[<span class="hljs-string">&quot;text&quot;</span>], padding=<span class="hljs-string">&quot;max_length&quot;</span>, truncation=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># tokenize train and test datasets</span>
train_dataset = train_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)
test_dataset = test_dataset.<span class="hljs-built_in">map</span>(tokenize, batched=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># set dataset format for PyTorch</span>
train_dataset =  train_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
train_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])
test_dataset = test_dataset.rename_column(<span class="hljs-string">&quot;label&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>)
test_dataset.set_format(<span class="hljs-string">&quot;torch&quot;</span>, columns=[<span class="hljs-string">&quot;input_ids&quot;</span>, <span class="hljs-string">&quot;attention_mask&quot;</span>, <span class="hljs-string">&quot;labels&quot;</span>])`,wrap:!1}}),B=new et({props:{title:"Upload dataset to S3 bucket",local:"upload-dataset-to-s3-bucket",headingTag:"h2"}}),Y=new j({props:{code:"JTIzJTIwc2F2ZSUyMHRyYWluX2RhdGFzZXQlMjB0byUyMHMzJTBBdHJhaW5pbmdfaW5wdXRfcGF0aCUyMCUzRCUyMGYnczMlM0ElMkYlMkYlN0JzZXNzLmRlZmF1bHRfYnVja2V0KCklN0QlMkYlN0JzM19wcmVmaXglN0QlMkZ0cmFpbiclMEF0cmFpbl9kYXRhc2V0LnNhdmVfdG9fZGlzayh0cmFpbmluZ19pbnB1dF9wYXRoKSUwQSUwQSUyMyUyMHNhdmUlMjB0ZXN0X2RhdGFzZXQlMjB0byUyMHMzJTBBdGVzdF9pbnB1dF9wYXRoJTIwJTNEJTIwZidzMyUzQSUyRiUyRiU3QnNlc3MuZGVmYXVsdF9idWNrZXQoKSU3RCUyRiU3QnMzX3ByZWZpeCU3RCUyRnRlc3QnJTBBdGVzdF9kYXRhc2V0LnNhdmVfdG9fZGlzayh0ZXN0X2lucHV0X3BhdGgp",highlighted:`<span class="hljs-comment"># save train_dataset to s3</span>
training_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/train&#x27;</span>
train_dataset.save_to_disk(training_input_path)

<span class="hljs-comment"># save test_dataset to s3</span>
test_input_path = <span class="hljs-string">f&#x27;s3://<span class="hljs-subst">{sess.default_bucket()}</span>/<span class="hljs-subst">{s3_prefix}</span>/test&#x27;</span>
test_dataset.save_to_disk(test_input_path)`,wrap:!1}}),V=new et({props:{title:"Start a training job",local:"start-a-training-job",headingTag:"h2"}}),F=new j({props:{code:"ZnJvbSUyMHNhZ2VtYWtlci5odWdnaW5nZmFjZSUyMGltcG9ydCUyMEh1Z2dpbmdGYWNlJTBBJTBBaHlwZXJwYXJhbWV0ZXJzJTNEJTdCJTBBJTIwJTIwJTIwJTIwJTIyZXBvY2hzJTIyJTNBJTIwMSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG51bWJlciUyMG9mJTIwdHJhaW5pbmclMjBlcG9jaHMlMEElMjAlMjAlMjAlMjAlMjJ0cmFpbl9iYXRjaF9zaXplJTIyJTNBJTIwMzIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjB0cmFpbmluZyUyMGJhdGNoJTIwc2l6ZSUwQSUyMCUyMCUyMCUyMCUyMm1vZGVsX25hbWUlMjIlM0ElMjJkaXN0aWxiZXJ0JTJGZGlzdGlsYmVydC1iYXNlLXVuY2FzZWQlMjIlMjAlMjAlMjMlMjBuYW1lJTIwb2YlMjBwcmV0cmFpbmVkJTIwbW9kZWwlMEElN0QlMEElMEFodWdnaW5nZmFjZV9lc3RpbWF0b3IlMjAlM0QlMjBIdWdnaW5nRmFjZSglMEElMjAlMjAlMjAlMjBlbnRyeV9wb2ludCUzRCUyMnRyYWluLnB5JTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwZmluZS10dW5pbmclMjBzY3JpcHQlMjB0byUyMHVzZSUyMGluJTIwdHJhaW5pbmclMjBqb2IlMEElMjAlMjAlMjAlMjBzb3VyY2VfZGlyJTNEJTIyLiUyRnNjcmlwdHMlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBkaXJlY3RvcnklMjB3aGVyZSUyMGZpbmUtdHVuaW5nJTIwc2NyaXB0JTIwaXMlMjBzdG9yZWQlMEElMjAlMjAlMjAlMjBpbnN0YW5jZV90eXBlJTNEJTIybWwucDMuMnhsYXJnZSUyMiUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGluc3RhbmNlJTIwdHlwZSUwQSUyMCUyMCUyMCUyMGluc3RhbmNlX2NvdW50JTNEMSUyQyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMG51bWJlciUyMG9mJTIwaW5zdGFuY2VzJTBBJTIwJTIwJTIwJTIwcm9sZSUzRHJvbGUlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBJQU0lMjByb2xlJTIwdXNlZCUyMGluJTIwdHJhaW5pbmclMjBqb2IlMjB0byUyMGFjY2Nlc3MlMjBBV1MlMjByZXNvdXJjZXMlMjAoUzMpJTBBJTIwJTIwJTIwJTIwdHJhbnNmb3JtZXJzX3ZlcnNpb24lM0QlMjI0LjI2JTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwVHJhbnNmb3JtZXJzJTIwdmVyc2lvbiUwQSUyMCUyMCUyMCUyMHB5dG9yY2hfdmVyc2lvbiUzRCUyMjEuMTMlMjIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjMlMjBQeVRvcmNoJTIwdmVyc2lvbiUwQSUyMCUyMCUyMCUyMHB5X3ZlcnNpb24lM0QlMjJweTM5JTIyJTJDJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIzJTIwUHl0aG9uJTIwdmVyc2lvbiUwQSUyMCUyMCUyMCUyMGh5cGVycGFyYW1ldGVycyUzRGh5cGVycGFyYW1ldGVycyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMyUyMGh5cGVycGFyYW1ldGVycyUyMHRvJTIwdXNlJTIwaW4lMjB0cmFpbmluZyUyMGpvYiUwQSk=",highlighted:`<span class="hljs-keyword">from</span> sagemaker.huggingface <span class="hljs-keyword">import</span> HuggingFace

hyperparameters={
    <span class="hljs-string">&quot;epochs&quot;</span>: <span class="hljs-number">1</span>,                                       <span class="hljs-comment"># number of training epochs</span>
    <span class="hljs-string">&quot;train_batch_size&quot;</span>: <span class="hljs-number">32</span>,                            <span class="hljs-comment"># training batch size</span>
    <span class="hljs-string">&quot;model_name&quot;</span>:<span class="hljs-string">&quot;distilbert/distilbert-base-uncased&quot;</span>  <span class="hljs-comment"># name of pretrained model</span>
}

huggingface_estimator = HuggingFace(
    entry_point=<span class="hljs-string">&quot;train.py&quot;</span>,                 <span class="hljs-comment"># fine-tuning script to use in training job</span>
    source_dir=<span class="hljs-string">&quot;./scripts&quot;</span>,                 <span class="hljs-comment"># directory where fine-tuning script is stored</span>
    instance_type=<span class="hljs-string">&quot;ml.p3.2xlarge&quot;</span>,          <span class="hljs-comment"># instance type</span>
    instance_count=<span class="hljs-number">1</span>,                       <span class="hljs-comment"># number of instances</span>
    role=role,                              <span class="hljs-comment"># IAM role used in training job to acccess AWS resources (S3)</span>
    transformers_version=<span class="hljs-string">&quot;4.26&quot;</span>,             <span class="hljs-comment"># Transformers version</span>
    pytorch_version=<span class="hljs-string">&quot;1.13&quot;</span>,                  <span class="hljs-comment"># PyTorch version</span>
    py_version=<span class="hljs-string">&quot;py39&quot;</span>,                      <span class="hljs-comment"># Python version</span>
    hyperparameters=hyperparameters         <span class="hljs-comment"># hyperparameters to use in training job</span>
)`,wrap:!1}}),v=new j({props:{code:"aHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmZpdCglN0IlMjJ0cmFpbiUyMiUzQSUyMHRyYWluaW5nX2lucHV0X3BhdGglMkMlMjAlMjJ0ZXN0JTIyJTNBJTIwdGVzdF9pbnB1dF9wYXRoJTdEKQ==",highlighted:'huggingface_estimator.fit({<span class="hljs-string">&quot;train&quot;</span>: training_input_path, <span class="hljs-string">&quot;test&quot;</span>: test_input_path})',wrap:!1}}),q=new et({props:{title:"Deploy model",local:"deploy-model",headingTag:"h2"}}),Q=new j({props:{code:"cHJlZGljdG9yJTIwJTNEJTIwaHVnZ2luZ2ZhY2VfZXN0aW1hdG9yLmRlcGxveShpbml0aWFsX2luc3RhbmNlX2NvdW50JTNEMSUyQyUyMm1sLmc0ZG4ueGxhcmdlJTIyKQ==",highlighted:'predictor = huggingface_estimator.deploy(initial_instance_count=<span class="hljs-number">1</span>,<span class="hljs-string">&quot;ml.g4dn.xlarge&quot;</span>)',wrap:!1}}),E=new j({props:{code:"c2VudGltZW50X2lucHV0JTIwJTNEJTIwJTdCJTIyaW5wdXRzJTIyJTNBJTIwJTIySXQlMjBmZWVscyUyMGxpa2UlMjBhJTIwY3VydGFpbiUyMGNsb3NpbmcuLi50aGVyZSUyMHdhcyUyMGFuJTIwZWxlZ2FuY2UlMjBpbiUyMHRoZSUyMHdheSUyMHRoZXklMjBtb3ZlZCUyMHRvd2FyZCUyMGNvbmNsdXNpb24uJTIwTm8lMjBmYW4lMjBpcyUyMGdvaW5nJTIwdG8lMjB3YXRjaCUyMGFuZCUyMGZlZWwlMjBzaG9ydC1jaGFuZ2VkLiUyMiU3RCUwQSUwQXByZWRpY3Rvci5wcmVkaWN0KHNlbnRpbWVudF9pbnB1dCk=",highlighted:`sentiment_input = {<span class="hljs-string">&quot;inputs&quot;</span>: <span class="hljs-string">&quot;It feels like a curtain closing...there was an elegance in the way they moved toward conclusion. No fan is going to watch and feel short-changed.&quot;</span>}

predictor.predict(sentiment_input)`,wrap:!1}}),P=new j({props:{code:"cHJlZGljdG9yLmRlbGV0ZV9lbmRwb2ludCgp",highlighted:"predictor.delete_endpoint()",wrap:!1}}),D=new et({props:{title:"What’s next?",local:"whats-next",headingTag:"h2"}}),tt=new we({props:{source:"https://github.com/huggingface/hub-docs/blob/main/docs/sagemaker/getting-started.md"}}),{c(){h=i("meta"),at=a(),lt=i("p"),nt=a(),o(w.$$.fragment),it=a(),T=i("p"),T.textContent=Qt,Mt=a(),f=i("p"),f.innerHTML=xt,ot=a(),u=i("iframe"),pt=a(),U=i("p"),U.innerHTML=Lt,rt=a(),o(g.$$.fragment),yt=a(),b=i("p"),b.innerHTML=Pt,mt=a(),o(I.$$.fragment),dt=a(),C=i("p"),C.innerHTML=Dt,ct=a(),o(k.$$.fragment),ut=a(),Z=i("p"),Z.innerHTML=Kt,jt=a(),$=i("p"),$.innerHTML=Ot,ht=a(),A=i("p"),A.innerHTML=te,Jt=a(),o(X.$$.fragment),wt=a(),o(G.$$.fragment),Tt=a(),W=i("p"),W.innerHTML=ee,ft=a(),o(_.$$.fragment),Ut=a(),o(B.$$.fragment),gt=a(),z=i("p"),z.innerHTML=le,bt=a(),o(Y.$$.fragment),It=a(),o(V.$$.fragment),Ct=a(),N=i("p"),N.textContent=se,kt=a(),R=i("ul"),R.innerHTML=ae,Zt=a(),o(F.$$.fragment),$t=a(),H=i("p"),H.textContent=ne,At=a(),o(v.$$.fragment),Xt=a(),o(q.$$.fragment),Gt=a(),S=i("p"),S.innerHTML=ie,Wt=a(),o(Q.$$.fragment),_t=a(),x=i("p"),x.innerHTML=Me,Bt=a(),o(E.$$.fragment),zt=a(),L=i("p"),L.textContent=oe,Yt=a(),o(P.$$.fragment),Vt=a(),o(D.$$.fragment),Nt=a(),K=i("p"),K.textContent=pe,Rt=a(),O=i("p"),O.innerHTML=re,Ft=a(),o(tt.$$.fragment),Ht=a(),st=i("p"),this.h()},l(t){const e=he("svelte-u9bgzb",document.head);h=M(e,"META",{name:!0,content:!0}),e.forEach(l),at=n(t),lt=M(t,"P",{}),qt(lt).forEach(l),nt=n(t),p(w.$$.fragment,t),it=n(t),T=M(t,"P",{"data-svelte-h":!0}),r(T)!=="svelte-n7q5fy"&&(T.textContent=Qt),Mt=n(t),f=M(t,"P",{"data-svelte-h":!0}),r(f)!=="svelte-uamv5h"&&(f.innerHTML=xt),ot=n(t),u=M(t,"IFRAME",{width:!0,height:!0,src:!0,title:!0,frameborder:!0,allow:!0}),qt(u).forEach(l),pt=n(t),U=M(t,"P",{"data-svelte-h":!0}),r(U)!=="svelte-rt6seb"&&(U.innerHTML=Lt),rt=n(t),p(g.$$.fragment,t),yt=n(t),b=M(t,"P",{"data-svelte-h":!0}),r(b)!=="svelte-10ldwp9"&&(b.innerHTML=Pt),mt=n(t),p(I.$$.fragment,t),dt=n(t),C=M(t,"P",{"data-svelte-h":!0}),r(C)!=="svelte-yozy2b"&&(C.innerHTML=Dt),ct=n(t),p(k.$$.fragment,t),ut=n(t),Z=M(t,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1sllt2f"&&(Z.innerHTML=Kt),jt=n(t),$=M(t,"P",{"data-svelte-h":!0}),r($)!=="svelte-tg9h77"&&($.innerHTML=Ot),ht=n(t),A=M(t,"P",{"data-svelte-h":!0}),r(A)!=="svelte-y9vgbx"&&(A.innerHTML=te),Jt=n(t),p(X.$$.fragment,t),wt=n(t),p(G.$$.fragment,t),Tt=n(t),W=M(t,"P",{"data-svelte-h":!0}),r(W)!=="svelte-b8daui"&&(W.innerHTML=ee),ft=n(t),p(_.$$.fragment,t),Ut=n(t),p(B.$$.fragment,t),gt=n(t),z=M(t,"P",{"data-svelte-h":!0}),r(z)!=="svelte-nm384r"&&(z.innerHTML=le),bt=n(t),p(Y.$$.fragment,t),It=n(t),p(V.$$.fragment,t),Ct=n(t),N=M(t,"P",{"data-svelte-h":!0}),r(N)!=="svelte-16p4w97"&&(N.textContent=se),kt=n(t),R=M(t,"UL",{"data-svelte-h":!0}),r(R)!=="svelte-1bnefx4"&&(R.innerHTML=ae),Zt=n(t),p(F.$$.fragment,t),$t=n(t),H=M(t,"P",{"data-svelte-h":!0}),r(H)!=="svelte-b865q9"&&(H.textContent=ne),At=n(t),p(v.$$.fragment,t),Xt=n(t),p(q.$$.fragment,t),Gt=n(t),S=M(t,"P",{"data-svelte-h":!0}),r(S)!=="svelte-twh61n"&&(S.innerHTML=ie),Wt=n(t),p(Q.$$.fragment,t),_t=n(t),x=M(t,"P",{"data-svelte-h":!0}),r(x)!=="svelte-19s4ndj"&&(x.innerHTML=Me),Bt=n(t),p(E.$$.fragment,t),zt=n(t),L=M(t,"P",{"data-svelte-h":!0}),r(L)!=="svelte-l180zc"&&(L.textContent=oe),Yt=n(t),p(P.$$.fragment,t),Vt=n(t),p(D.$$.fragment,t),Nt=n(t),K=M(t,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1rjk4za"&&(K.textContent=pe),Rt=n(t),O=M(t,"P",{"data-svelte-h":!0}),r(O)!=="svelte-1qzgnqe"&&(O.innerHTML=re),Ft=n(t),p(tt.$$.fragment,t),Ht=n(t),st=M(t,"P",{}),qt(st).forEach(l),this.h()},h(){J(h,"name","hf:doc:metadata"),J(h,"content",fe),J(u,"width","560"),J(u,"height","315"),me(u.src,Et="https://www.youtube.com/embed/pYqjCzoyWyo")||J(u,"src",Et),J(u,"title","YouTube video player"),J(u,"frameborder","0"),J(u,"allow","accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"),u.allowFullscreen=""},m(t,e){Je(document.head,h),s(t,at,e),s(t,lt,e),s(t,nt,e),y(w,t,e),s(t,it,e),s(t,T,e),s(t,Mt,e),s(t,f,e),s(t,ot,e),s(t,u,e),s(t,pt,e),s(t,U,e),s(t,rt,e),y(g,t,e),s(t,yt,e),s(t,b,e),s(t,mt,e),y(I,t,e),s(t,dt,e),s(t,C,e),s(t,ct,e),y(k,t,e),s(t,ut,e),s(t,Z,e),s(t,jt,e),s(t,$,e),s(t,ht,e),s(t,A,e),s(t,Jt,e),y(X,t,e),s(t,wt,e),y(G,t,e),s(t,Tt,e),s(t,W,e),s(t,ft,e),y(_,t,e),s(t,Ut,e),y(B,t,e),s(t,gt,e),s(t,z,e),s(t,bt,e),y(Y,t,e),s(t,It,e),y(V,t,e),s(t,Ct,e),s(t,N,e),s(t,kt,e),s(t,R,e),s(t,Zt,e),y(F,t,e),s(t,$t,e),s(t,H,e),s(t,At,e),y(v,t,e),s(t,Xt,e),y(q,t,e),s(t,Gt,e),s(t,S,e),s(t,Wt,e),y(Q,t,e),s(t,_t,e),s(t,x,e),s(t,Bt,e),y(E,t,e),s(t,zt,e),s(t,L,e),s(t,Yt,e),y(P,t,e),s(t,Vt,e),y(D,t,e),s(t,Nt,e),s(t,K,e),s(t,Rt,e),s(t,O,e),s(t,Ft,e),y(tt,t,e),s(t,Ht,e),s(t,st,e),vt=!0},p:de,i(t){vt||(m(w.$$.fragment,t),m(g.$$.fragment,t),m(I.$$.fragment,t),m(k.$$.fragment,t),m(X.$$.fragment,t),m(G.$$.fragment,t),m(_.$$.fragment,t),m(B.$$.fragment,t),m(Y.$$.fragment,t),m(V.$$.fragment,t),m(F.$$.fragment,t),m(v.$$.fragment,t),m(q.$$.fragment,t),m(Q.$$.fragment,t),m(E.$$.fragment,t),m(P.$$.fragment,t),m(D.$$.fragment,t),m(tt.$$.fragment,t),vt=!0)},o(t){d(w.$$.fragment,t),d(g.$$.fragment,t),d(I.$$.fragment,t),d(k.$$.fragment,t),d(X.$$.fragment,t),d(G.$$.fragment,t),d(_.$$.fragment,t),d(B.$$.fragment,t),d(Y.$$.fragment,t),d(V.$$.fragment,t),d(F.$$.fragment,t),d(v.$$.fragment,t),d(q.$$.fragment,t),d(Q.$$.fragment,t),d(E.$$.fragment,t),d(P.$$.fragment,t),d(D.$$.fragment,t),d(tt.$$.fragment,t),vt=!1},d(t){t&&(l(at),l(lt),l(nt),l(it),l(T),l(Mt),l(f),l(ot),l(u),l(pt),l(U),l(rt),l(yt),l(b),l(mt),l(dt),l(C),l(ct),l(ut),l(Z),l(jt),l($),l(ht),l(A),l(Jt),l(wt),l(Tt),l(W),l(ft),l(Ut),l(gt),l(z),l(bt),l(It),l(Ct),l(N),l(kt),l(R),l(Zt),l($t),l(H),l(At),l(Xt),l(Gt),l(S),l(Wt),l(_t),l(x),l(Bt),l(zt),l(L),l(Yt),l(Vt),l(Nt),l(K),l(Rt),l(O),l(Ft),l(Ht),l(st)),l(h),c(w,t),c(g,t),c(I,t),c(k,t),c(X,t),c(G,t),c(_,t),c(B,t),c(Y,t),c(V,t),c(F,t),c(v,t),c(q,t),c(Q,t),c(E,t),c(P,t),c(D,t),c(tt,t)}}}const fe='{"title":"Train and deploy Hugging Face on Amazon SageMaker","local":"train-and-deploy-hugging-face-on-amazon-sagemaker","sections":[{"title":"Installation and setup","local":"installation-and-setup","sections":[],"depth":2},{"title":"Preprocess","local":"preprocess","sections":[],"depth":2},{"title":"Upload dataset to S3 bucket","local":"upload-dataset-to-s3-bucket","sections":[],"depth":2},{"title":"Start a training job","local":"start-a-training-job","sections":[],"depth":2},{"title":"Deploy model","local":"deploy-model","sections":[],"depth":2},{"title":"What’s next?","local":"whats-next","sections":[],"depth":2}],"depth":1}';function Ue(St){return ce(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ke extends ue{constructor(h){super(),je(this,h,Ue,Te,ye,{})}}export{ke as component};
