import{s as yo,o as To,n as yt}from"../chunks/scheduler.8c3d61f6.js";import{S as xo,i as jo,g as d,s as n,r as m,A as Do,h as r,f as o,c as s,j,u,x as M,k as D,y as i,a,v as f,d as g,t as h,w as _}from"../chunks/index.da70eac4.js";import{T as ko}from"../chunks/Tip.1d9b8c37.js";import{D as $}from"../chunks/Docstring.6b390b9a.js";import{C as Ft}from"../chunks/CodeBlock.00a903b3.js";import{E as Vt}from"../chunks/ExampleCodeBlock.db12be95.js";import{H as N,E as Ao}from"../chunks/EditOnGithub.1e64e623.js";function $o(C){let l,y='Make sure to check out the Schedulers <a href="../../using-diffusers/schedulers">guide</a> to learn how to explore the tradeoff between scheduler speed and quality, and see the <a href="../../using-diffusers/loading#reuse-components-across-pipelines">reuse components across pipelines</a> section to learn how to efficiently load the same components into multiple pipelines.';return{c(){l=d("p"),l.innerHTML=y},l(p){l=r(p,"P",{"data-svelte-h":!0}),M(l)!=="svelte-1wmc0l4"&&(l.innerHTML=y)},m(p,b){a(p,l,b)},p:yt,d(p){p&&o(l)}}}function Uo(C){let l,y="Examples:",p,b,T;return b=new Ft({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMHByb21wdHMlMEFwcm9tcHQlMjAlM0QlMjAlMjJUaGUlMjBzb3VuZCUyMG9mJTIwYSUyMGhhbW1lciUyMGhpdHRpbmclMjBhJTIwd29vZGVuJTIwc3VyZmFjZS4lMjIlMEFuZWdhdGl2ZV9wcm9tcHQlMjAlM0QlMjAlMjJMb3clMjBxdWFsaXR5LiUyMiUwQSUwQSUyMyUyMHNldCUyMHRoZSUyMHNlZWQlMjBmb3IlMjBnZW5lcmF0b3IlMEFnZW5lcmF0b3IlMjAlM0QlMjB0b3JjaC5HZW5lcmF0b3IoJTIyY3VkYSUyMikubWFudWFsX3NlZWQoMCklMEElMEElMjMlMjBydW4lMjB0aGUlMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdCUyQyUwQSUyMCUyMCUyMCUyMG5lZ2F0aXZlX3Byb21wdCUzRG5lZ2F0aXZlX3Byb21wdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDEwLjAlMkMlMEElMjAlMjAlMjAlMjBudW1fd2F2ZWZvcm1zX3Blcl9wcm9tcHQlM0QzJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBKS5hdWRpb3MlMEElMEElMjMlMjBzYXZlJTIwdGhlJTIwYmVzdCUyMGF1ZGlvJTIwc2FtcGxlJTIwKGluZGV4JTIwMCklMjBhcyUyMGElMjAud2F2JTIwZmlsZSUwQXNjaXB5LmlvLndhdmZpbGUud3JpdGUoJTIydGVjaG5vLndhdiUyMiUyQyUyMHJhdGUlM0QxNjAwMCUyQyUyMGRhdGElM0RhdWRpbyU1QjAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># define the prompts</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;The sound of a hammer hitting a wooden surface.&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>negative_prompt = <span class="hljs-string">&quot;Low quality.&quot;</span>

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># set the seed for generator</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># run the generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt,
<span class="hljs-meta">... </span>    negative_prompt=negative_prompt,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>    num_waveforms_per_prompt=<span class="hljs-number">3</span>,
<span class="hljs-meta">... </span>    generator=generator,
<span class="hljs-meta">... </span>).audios

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save the best audio sample (index 0) as a .wav file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio[<span class="hljs-number">0</span>])`,wrap:!1}}),{c(){l=d("p"),l.textContent=y,p=n(),m(b.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),M(l)!=="svelte-kvfsh7"&&(l.textContent=y),p=s(c),u(b.$$.fragment,c)},m(c,x){a(c,l,x),a(c,p,x),f(b,c,x),T=!0},p:yt,i(c){T||(g(b.$$.fragment,c),T=!0)},o(c){h(b.$$.fragment,c),T=!1},d(c){c&&(o(l),o(p)),_(b,c)}}}function Lo(C){let l,y;return l=new Ft({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJhbmhuY3QlMkZhdWRpb2xkbTJfZ2lnYXNwZWVjaCUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMGRlZmluZSUyMHRoZSUyMHByb21wdHMlMEFwcm9tcHQlMjAlM0QlMjAlMjJBJTIwZmVtYWxlJTIwcmVwb3J0ZXIlMjBpcyUyMHNwZWFraW5nJTIyJTBBdHJhbnNjcmlwdCUyMCUzRCUyMCUyMndpc2glMjB5b3UlMjBoYXZlJTIwYSUyMGdvb2QlMjBkYXklMjIlMEElMEElMjMlMjBzZXQlMjB0aGUlMjBzZWVkJTIwZm9yJTIwZ2VuZXJhdG9yJTBBZ2VuZXJhdG9yJTIwJTNEJTIwdG9yY2guR2VuZXJhdG9yKCUyMmN1ZGElMjIpLm1hbnVhbF9zZWVkKDApJTBBJTBBJTIzJTIwcnVuJTIwdGhlJTIwZ2VuZXJhdGlvbiUwQWF1ZGlvJTIwJTNEJTIwcGlwZSglMEElMjAlMjAlMjAlMjBwcm9tcHQlMkMlMEElMjAlMjAlMjAlMjB0cmFuc2NyaXB0aW9uJTNEdHJhbnNjcmlwdCUyQyUwQSUyMCUyMCUyMCUyMG51bV9pbmZlcmVuY2Vfc3RlcHMlM0QyMDAlMkMlMEElMjAlMjAlMjAlMjBhdWRpb19sZW5ndGhfaW5fcyUzRDEwLjAlMkMlMEElMjAlMjAlMjAlMjBudW1fd2F2ZWZvcm1zX3Blcl9wcm9tcHQlM0QyJTJDJTBBJTIwJTIwJTIwJTIwZ2VuZXJhdG9yJTNEZ2VuZXJhdG9yJTJDJTBBJTIwJTIwJTIwJTIwbWF4X25ld190b2tlbnMlM0Q1MTIlMkMlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjNNdXN0JTIwc2V0JTIwbWF4X25ld190b2tlbnMlMjBlcXVhJTIwdG8lMjA1MTIlMjBmb3IlMjBUVFMlMEEpLmF1ZGlvcyUwQSUwQSUyMyUyMHNhdmUlMjB0aGUlMjBiZXN0JTIwYXVkaW8lMjBzYW1wbGUlMjAoaW5kZXglMjAwKSUyMGFzJTIwYSUyMC53YXYlMjBmaWxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0dHMud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvJTVCMCU1RCk=",highlighted:`#Using AudioLDM2 for Text To Speech
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">import</span> scipy</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">import</span> torch</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">repo_id = <span class="hljs-string">&quot;anhnct/audioldm2_gigaspeech&quot;</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)</span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># define the prompts</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">prompt = <span class="hljs-string">&quot;A female reporter is speaking&quot;</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">transcript = <span class="hljs-string">&quot;wish you have a good day&quot;</span></span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># set the seed for generator</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">generator = torch.Generator(<span class="hljs-string">&quot;cuda&quot;</span>).manual_seed(<span class="hljs-number">0</span>)</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># run the generation</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">audio = pipe(</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    prompt,</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    transcription=transcript,</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    num_inference_steps=<span class="hljs-number">200</span>,</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    audio_length_in_s=<span class="hljs-number">10.0</span>,</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    num_waveforms_per_prompt=<span class="hljs-number">2</span>,</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    generator=generator,</span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">    max_new_tokens=<span class="hljs-number">512</span>,          <span class="hljs-comment">#Must set max_new_tokens equa to 512 for TTS</span></span>
<span class="hljs-meta prompt_">...</span> <span class="language-python">).audios</span>

<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python"><span class="hljs-comment"># save the best audio sample (index 0) as a .wav file</span></span>
<span class="hljs-meta prompt_">&gt;&gt;&gt;</span> <span class="language-python">scipy.io.wavfile.write(<span class="hljs-string">&quot;tts.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio[<span class="hljs-number">0</span>])</span>`,wrap:!1}}),{c(){m(l.$$.fragment)},l(p){u(l.$$.fragment,p)},m(p,b){f(l,p,b),y=!0},p:yt,i(p){y||(g(l.$$.fragment,p),y=!0)},o(p){h(l.$$.fragment,p),y=!1},d(p){_(l,p)}}}function Co(C){let l,y="Example:",p,b,T;return b=new Ft({props:{code:"aW1wb3J0JTIwc2NpcHklMEFpbXBvcnQlMjB0b3JjaCUwQWZyb20lMjBkaWZmdXNlcnMlMjBpbXBvcnQlMjBBdWRpb0xETTJQaXBlbGluZSUwQSUwQXJlcG9faWQlMjAlM0QlMjAlMjJjdnNzcCUyRmF1ZGlvbGRtMiUyMiUwQXBpcGUlMjAlM0QlMjBBdWRpb0xETTJQaXBlbGluZS5mcm9tX3ByZXRyYWluZWQocmVwb19pZCUyQyUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiklMEFwaXBlJTIwJTNEJTIwcGlwZS50byglMjJjdWRhJTIyKSUwQSUwQSUyMyUyMEdldCUyMHRleHQlMjBlbWJlZGRpbmclMjB2ZWN0b3JzJTBBcHJvbXB0X2VtYmVkcyUyQyUyMGF0dGVudGlvbl9tYXNrJTJDJTIwZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMjAlM0QlMjBwaXBlLmVuY29kZV9wcm9tcHQoJTBBJTIwJTIwJTIwJTIwcHJvbXB0JTNEJTIyVGVjaG5vJTIwbXVzaWMlMjB3aXRoJTIwYSUyMHN0cm9uZyUyQyUyMHVwYmVhdCUyMHRlbXBvJTIwYW5kJTIwaGlnaCUyMG1lbG9kaWMlMjByaWZmcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGRldmljZSUzRCUyMmN1ZGElMjIlMkMlMEElMjAlMjAlMjAlMjBkb19jbGFzc2lmaWVyX2ZyZWVfZ3VpZGFuY2UlM0RUcnVlJTJDJTBBKSUwQSUwQSUyMyUyMFBhc3MlMjB0ZXh0JTIwZW1iZWRkaW5ncyUyMHRvJTIwcGlwZWxpbmUlMjBmb3IlMjB0ZXh0LWNvbmRpdGlvbmFsJTIwYXVkaW8lMjBnZW5lcmF0aW9uJTBBYXVkaW8lMjAlM0QlMjBwaXBlKCUwQSUyMCUyMCUyMCUyMHByb21wdF9lbWJlZHMlM0Rwcm9tcHRfZW1iZWRzJTJDJTBBJTIwJTIwJTIwJTIwYXR0ZW50aW9uX21hc2slM0RhdHRlbnRpb25fbWFzayUyQyUwQSUyMCUyMCUyMCUyMGdlbmVyYXRlZF9wcm9tcHRfZW1iZWRzJTNEZ2VuZXJhdGVkX3Byb21wdF9lbWJlZHMlMkMlMEElMjAlMjAlMjAlMjBudW1faW5mZXJlbmNlX3N0ZXBzJTNEMjAwJTJDJTBBJTIwJTIwJTIwJTIwYXVkaW9fbGVuZ3RoX2luX3MlM0QxMC4wJTJDJTBBKS5hdWRpb3MlNUIwJTVEJTBBJTBBJTIzJTIwc2F2ZSUyMGdlbmVyYXRlZCUyMGF1ZGlvJTIwc2FtcGxlJTBBc2NpcHkuaW8ud2F2ZmlsZS53cml0ZSglMjJ0ZWNobm8ud2F2JTIyJTJDJTIwcmF0ZSUzRDE2MDAwJTJDJTIwZGF0YSUzRGF1ZGlvKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> scipy
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> diffusers <span class="hljs-keyword">import</span> AudioLDM2Pipeline

<span class="hljs-meta">&gt;&gt;&gt; </span>repo_id = <span class="hljs-string">&quot;cvssp/audioldm2&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = AudioLDM2Pipeline.from_pretrained(repo_id, torch_dtype=torch.float16)
<span class="hljs-meta">&gt;&gt;&gt; </span>pipe = pipe.to(<span class="hljs-string">&quot;cuda&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get text embedding vectors</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>prompt_embeds, attention_mask, generated_prompt_embeds = pipe.encode_prompt(
<span class="hljs-meta">... </span>    prompt=<span class="hljs-string">&quot;Techno music with a strong, upbeat tempo and high melodic riffs&quot;</span>,
<span class="hljs-meta">... </span>    device=<span class="hljs-string">&quot;cuda&quot;</span>,
<span class="hljs-meta">... </span>    do_classifier_free_guidance=<span class="hljs-literal">True</span>,
<span class="hljs-meta">... </span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Pass text embeddings to pipeline for text-conditional audio generation</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>audio = pipe(
<span class="hljs-meta">... </span>    prompt_embeds=prompt_embeds,
<span class="hljs-meta">... </span>    attention_mask=attention_mask,
<span class="hljs-meta">... </span>    generated_prompt_embeds=generated_prompt_embeds,
<span class="hljs-meta">... </span>    num_inference_steps=<span class="hljs-number">200</span>,
<span class="hljs-meta">... </span>    audio_length_in_s=<span class="hljs-number">10.0</span>,
<span class="hljs-meta">... </span>).audios[<span class="hljs-number">0</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># save generated audio sample</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>scipy.io.wavfile.write(<span class="hljs-string">&quot;techno.wav&quot;</span>, rate=<span class="hljs-number">16000</span>, data=audio)`,wrap:!1}}),{c(){l=d("p"),l.textContent=y,p=n(),m(b.$$.fragment)},l(c){l=r(c,"P",{"data-svelte-h":!0}),M(l)!=="svelte-11lpom8"&&(l.textContent=y),p=s(c),u(b.$$.fragment,c)},m(c,x){a(c,l,x),a(c,p,x),f(b,c,x),T=!0},p:yt,i(c){T||(g(b.$$.fragment,c),T=!0)},o(c){h(b.$$.fragment,c),T=!1},d(c){c&&(o(l),o(p)),_(b,c)}}}function Jo(C){let l,y,p,b,T,c,x,Rt='AudioLDM 2 was proposed in <a href="https://arxiv.org/abs/2308.05734" rel="nofollow">AudioLDM 2: Learning Holistic Audio Generation with Self-supervised Pretraining</a> by Haohe Liu et al. AudioLDM 2 takes a text prompt as input and predicts the corresponding audio. It can generate text-conditional sound effects, human speech and music.',Qe,H,zt='Inspired by <a href="https://huggingface.co/docs/diffusers/api/pipelines/stable_diffusion/overview" rel="nofollow">Stable Diffusion</a>, AudioLDM 2 is a text-to-audio <em>latent diffusion model (LDM)</em> that learns continuous audio representations from text embeddings. Two text encoder models are used to compute the text embeddings from a prompt input: the text-branch of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/clap" rel="nofollow">CLAP</a> and the encoder of <a href="https://huggingface.co/docs/transformers/main/en/model_doc/flan-t5" rel="nofollow">Flan-T5</a>. These text embeddings are then projected to a shared embedding space by an <a href="https://huggingface.co/docs/diffusers/main/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel" rel="nofollow">AudioLDM2ProjectionModel</a>. A <a href="https://huggingface.co/docs/transformers/main/en/model_doc/gpt2" rel="nofollow">GPT2</a> <em>language model (LM)</em> is used to auto-regressively predict eight new embedding vectors, conditional on the projected CLAP and Flan-T5 embeddings. The generated embedding vectors and Flan-T5 text embeddings are used as cross-attention conditioning in the LDM. The <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel" rel="nofollow">UNet</a> of AudioLDM 2 is unique in the sense that it takes <strong>two</strong> cross-attention embeddings, as opposed to one cross-attention conditioning, as in most other LDMs.',Xe,V,Ot="The abstract of the paper is the following:",He,F,Yt='<em>Although audio generation shares commonalities across different types of audio, such as speech, music, and sound effects, designing models for each type requires careful consideration of specific objectives and biases that can significantly differ from those of other types. To bring us closer to a unified perspective of audio generation, this paper proposes a framework that utilizes the same learning method for speech, music, and sound effect generation. Our framework introduces a general representation of audio, called “language of audio” (LOA). Any audio can be translated into LOA based on AudioMAE, a self-supervised pre-trained representation learning model. In the generation process, we translate any modalities into LOA by using a GPT-2 model, and we perform self-supervised audio generation learning with a latent diffusion model conditioned on LOA. The proposed framework naturally brings advantages such as in-context learning abilities and reusable self-supervised pretrained AudioMAE and latent diffusion models. Experiments on the major benchmarks of text-to-audio, text-to-music, and text-to-speech demonstrate state-of-the-art or competitive performance against previous approaches. Our code, pretrained model, and demo are available at <a href="https://audioldm.github.io/audioldm2" rel="nofollow">this https URL</a>.</em>',Ve,R,Kt=`This pipeline was contributed by <a href="https://huggingface.co/sanchit-gandhi" rel="nofollow">sanchit-gandhi</a> and <a href="https://github.com/tuanh123789" rel="nofollow">Nguyễn Công Tú Anh</a>. The original codebase can be
found at <a href="https://github.com/haoheliu/audioldm2" rel="nofollow">haoheliu/audioldm2</a>.`,Fe,z,Re,O,ze,Y,eo="AudioLDM2 comes in three variants. Two of these checkpoints are applicable to the general task of text-to-audio generation. The third checkpoint is trained exclusively on text-to-music generation.",Oe,K,to=`All checkpoints share the same model size for the text encoders and VAE. They differ in the size and depth of the UNet.
See table below for details on the three checkpoints:`,Ye,ee,oo='<thead><tr><th>Checkpoint</th> <th>Task</th> <th>UNet Model Size</th> <th>Total Model Size</th> <th>Training Data / h</th></tr></thead> <tbody><tr><td><a href="https://huggingface.co/cvssp/audioldm2" rel="nofollow">audioldm2</a></td> <td>Text-to-audio</td> <td>350M</td> <td>1.1B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-large" rel="nofollow">audioldm2-large</a></td> <td>Text-to-audio</td> <td>750M</td> <td>1.5B</td> <td>1150k</td></tr> <tr><td><a href="https://huggingface.co/cvssp/audioldm2-music" rel="nofollow">audioldm2-music</a></td> <td>Text-to-music</td> <td>350M</td> <td>1.1B</td> <td>665k</td></tr> <tr><td><a href="https://huggingface.co/anhnct/audioldm2_gigaspeech" rel="nofollow">audioldm2-gigaspeech</a></td> <td>Text-to-speech</td> <td>350M</td> <td>1.1B</td> <td>10k</td></tr> <tr><td><a href="https://huggingface.co/anhnct/audioldm2_ljspeech" rel="nofollow">audioldm2-ljspeech</a></td> <td>Text-to-speech</td> <td>350M</td> <td>1.1B</td> <td></td></tr></tbody>',Ke,te,et,oe,no="<li>Descriptive prompt inputs work best: use adjectives to describe the sound (e.g. “high quality” or “clear”) and make the prompt context specific (e.g. “water stream in a forest” instead of “stream”).</li> <li>It’s best to use general terms like “cat” or “dog” instead of specific names or abstract objects the model may not be familiar with.</li> <li>Using a <strong>negative prompt</strong> can significantly improve the quality of the generated waveform, by guiding the generation away from terms that correspond to poor quality audio. Try using a negative prompt of “Low quality.”</li>",tt,ne,ot,se,so="<li>The <em>quality</em> of the predicted audio sample can be controlled by the <code>num_inference_steps</code> argument; higher steps give higher quality audio at the expense of slower inference.</li> <li>The <em>length</em> of the predicted audio sample can be controlled by varying the <code>audio_length_in_s</code> argument.</li>",nt,ae,st,ie,ao="<li>The quality of the generated waveforms can vary significantly based on the seed. Try generating with different seeds until you find a satisfactory generation.</li> <li>Multiple waveforms can be generated in one go: set <code>num_waveforms_per_prompt</code> to a value greater than 1. Automatic scoring will be performed between the generated waveforms and prompt text, and the audios ranked from best to worst accordingly.</li>",at,de,io='The following example demonstrates how to construct good music and speech generation using the aforementioned tips: <a href="https://huggingface.co/docs/diffusers/main/en/api/pipelines/audioldm2#diffusers.AudioLDM2Pipeline.__call__.example" rel="nofollow">example</a>.',it,P,dt,re,rt,v,le,Tt,ke,ro="Pipeline for text-to-audio generation using AudioLDM2.",xt,Ae,lo=`This model inherits from <a href="/docs/diffusers/v0.30.3/en/api/pipelines/overview#diffusers.DiffusionPipeline">DiffusionPipeline</a>. Check the superclass documentation for the generic methods
implemented for all pipelines (downloading, saving, running on a particular device, etc.).`,jt,A,ce,Dt,$e,co="The call function to the pipeline for generation.",kt,I,At,Z,$t,G,pe,Ut,Ue,po=`Disable sliced VAE decoding. If <code>enable_vae_slicing</code> was previously enabled, this method will go back to
computing decoding in one step.`,Lt,q,me,Ct,Le,mo=`Offloads all models to CPU using accelerate, reducing memory usage with a low impact on performance. Compared
to <code>enable_sequential_cpu_offload</code>, this method moves one whole model at a time to the GPU when its <code>forward</code>
method is called, and the model remains in GPU until the next model runs. Memory savings are lower than with
<code>enable_sequential_cpu_offload</code>, but performance is much better due to the iterative execution of the <code>unet</code>.`,Jt,E,ue,Nt,Ce,uo=`Enable sliced VAE decoding. When this option is enabled, the VAE will split the input tensor in slices to
compute decoding in several steps. This is useful to save some memory and allow larger batch sizes.`,Bt,J,fe,Pt,Je,fo="Encodes the prompt into text encoder hidden states.",It,W,Zt,S,ge,Gt,Ne,go="Generates a sequence of hidden-states from the language model, conditioned on the embedding inputs.",lt,he,ct,U,_e,qt,Be,ho=`A simple linear projection model to map two text embeddings to a shared latent space. It also inserts learned
embedding vectors at the start and end of each text embedding sequence respectively. Each variable appended with
<code>_1</code> refers to that corresponding to the second text encoder. Otherwise, it is from the first.`,Et,Pe,Me,pt,be,mt,k,ve,Wt,Ie,_o=`A conditional 2D UNet model that takes a noisy sample, conditional state, and a timestep and returns a sample
shaped output. Compared to the vanilla <a href="/docs/diffusers/v0.30.3/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>, this variant optionally includes an additional
self-attention layer in each Transformer block, as well as multiple cross-attention layers. It also allows for up
to two cross-attention embeddings, <code>encoder_hidden_states</code> and <code>encoder_hidden_states_1</code>.`,St,Ze,Mo=`This model inherits from <a href="/docs/diffusers/v0.30.3/en/api/models/overview#diffusers.ModelMixin">ModelMixin</a>. Check the superclass documentation for it’s generic methods implemented
for all models (such as downloading or saving).`,Qt,Q,we,Xt,Ge,bo='The <a href="/docs/diffusers/v0.30.3/en/api/pipelines/audioldm2#diffusers.AudioLDM2UNet2DConditionModel">AudioLDM2UNet2DConditionModel</a> forward method.',ut,ye,ft,B,Te,Ht,qe,vo="Output class for audio pipelines.",gt,xe,ht,Se,_t;return T=new N({props:{title:"AudioLDM 2",local:"audioldm-2",headingTag:"h1"}}),z=new N({props:{title:"Tips",local:"tips",headingTag:"h2"}}),O=new N({props:{title:"Choosing a checkpoint",local:"choosing-a-checkpoint",headingTag:"h3"}}),te=new N({props:{title:"Constructing a prompt",local:"constructing-a-prompt",headingTag:"h3"}}),ne=new N({props:{title:"Controlling inference",local:"controlling-inference",headingTag:"h3"}}),ae=new N({props:{title:"Evaluating generated waveforms:",local:"evaluating-generated-waveforms",headingTag:"h3"}}),P=new ko({props:{$$slots:{default:[$o]},$$scope:{ctx:C}}}),re=new N({props:{title:"AudioLDM2Pipeline",local:"diffusers.AudioLDM2Pipeline",headingTag:"h2"}}),le=new $({props:{name:"class diffusers.AudioLDM2Pipeline",anchor:"diffusers.AudioLDM2Pipeline",parameters:[{name:"vae",val:": AutoencoderKL"},{name:"text_encoder",val:": ClapModel"},{name:"text_encoder_2",val:": Union"},{name:"projection_model",val:": AudioLDM2ProjectionModel"},{name:"language_model",val:": GPT2Model"},{name:"tokenizer",val:": Union"},{name:"tokenizer_2",val:": Union"},{name:"feature_extractor",val:": ClapFeatureExtractor"},{name:"unet",val:": AudioLDM2UNet2DConditionModel"},{name:"scheduler",val:": KarrasDiffusionSchedulers"},{name:"vocoder",val:": SpeechT5HifiGan"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.vae",description:`<strong>vae</strong> (<a href="/docs/diffusers/v0.30.3/en/api/models/autoencoderkl#diffusers.AutoencoderKL">AutoencoderKL</a>) &#x2014;
Variational Auto-Encoder (VAE) model to encode and decode images to and from latent representations.`,name:"vae"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder",description:`<strong>text_encoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.44.2/en/model_doc/clap#transformers.ClapModel" rel="nofollow">ClapModel</a>) &#x2014;
First frozen text-encoder. AudioLDM2 uses the joint audio-text embedding model
<a href="https://huggingface.co/docs/transformers/model_doc/clap#transformers.CLAPTextModelWithProjection" rel="nofollow">CLAP</a>,
specifically the <a href="https://huggingface.co/laion/clap-htsat-unfused" rel="nofollow">laion/clap-htsat-unfused</a> variant. The
text branch is used to encode the text prompt to a prompt embedding. The full audio-text model is used to
rank generated waveforms against the text prompt by computing similarity scores.`,name:"text_encoder"},{anchor:"diffusers.AudioLDM2Pipeline.text_encoder_2",description:`<strong>text_encoder_2</strong> ([<code>~transformers.T5EncoderModel</code>, <code>~transformers.VitsModel</code>]) &#x2014;
Second frozen text-encoder. AudioLDM2 uses the encoder of
<a href="https://huggingface.co/docs/transformers/model_doc/t5#transformers.T5EncoderModel" rel="nofollow">T5</a>, specifically the
<a href="https://huggingface.co/google/flan-t5-large" rel="nofollow">google/flan-t5-large</a> variant. Second frozen text-encoder use
for TTS. AudioLDM2 uses the encoder of
<a href="https://huggingface.co/docs/transformers/model_doc/vits#transformers.VitsModel" rel="nofollow">Vits</a>.`,name:"text_encoder_2"},{anchor:"diffusers.AudioLDM2Pipeline.projection_model",description:`<strong>projection_model</strong> (<a href="/docs/diffusers/v0.30.3/en/api/pipelines/audioldm2#diffusers.AudioLDM2ProjectionModel">AudioLDM2ProjectionModel</a>) &#x2014;
A trained model used to linearly project the hidden-states from the first and second text encoder models
and insert learned SOS and EOS token embeddings. The projected hidden-states from the two text encoders are
concatenated to give the input to the language model. A Learned Position Embedding for the Vits
hidden-states`,name:"projection_model"},{anchor:"diffusers.AudioLDM2Pipeline.language_model",description:`<strong>language_model</strong> (<a href="https://huggingface.co/docs/transformers/v4.44.2/en/model_doc/gpt2#transformers.GPT2Model" rel="nofollow">GPT2Model</a>) &#x2014;
An auto-regressive language model used to generate a sequence of hidden-states conditioned on the projected
outputs from the two text encoders.`,name:"language_model"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer",description:`<strong>tokenizer</strong> (<a href="https://huggingface.co/docs/transformers/v4.44.2/en/model_doc/roberta#transformers.RobertaTokenizer" rel="nofollow">RobertaTokenizer</a>) &#x2014;
Tokenizer to tokenize text for the first frozen text-encoder.`,name:"tokenizer"},{anchor:"diffusers.AudioLDM2Pipeline.tokenizer_2",description:`<strong>tokenizer_2</strong> ([<code>~transformers.T5Tokenizer</code>, <code>~transformers.VitsTokenizer</code>]) &#x2014;
Tokenizer to tokenize text for the second frozen text-encoder.`,name:"tokenizer_2"},{anchor:"diffusers.AudioLDM2Pipeline.feature_extractor",description:`<strong>feature_extractor</strong> (<a href="https://huggingface.co/docs/transformers/v4.44.2/en/model_doc/clap#transformers.ClapFeatureExtractor" rel="nofollow">ClapFeatureExtractor</a>) &#x2014;
Feature extractor to pre-process generated audio waveforms to log-mel spectrograms for automatic scoring.`,name:"feature_extractor"},{anchor:"diffusers.AudioLDM2Pipeline.unet",description:`<strong>unet</strong> (<a href="/docs/diffusers/v0.30.3/en/api/models/unet2d-cond#diffusers.UNet2DConditionModel">UNet2DConditionModel</a>) &#x2014;
A <code>UNet2DConditionModel</code> to denoise the encoded audio latents.`,name:"unet"},{anchor:"diffusers.AudioLDM2Pipeline.scheduler",description:`<strong>scheduler</strong> (<a href="/docs/diffusers/v0.30.3/en/api/schedulers/overview#diffusers.SchedulerMixin">SchedulerMixin</a>) &#x2014;
A scheduler to be used in combination with <code>unet</code> to denoise the encoded audio latents. Can be one of
<a href="/docs/diffusers/v0.30.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, <a href="/docs/diffusers/v0.30.3/en/api/schedulers/lms_discrete#diffusers.LMSDiscreteScheduler">LMSDiscreteScheduler</a>, or <a href="/docs/diffusers/v0.30.3/en/api/schedulers/pndm#diffusers.PNDMScheduler">PNDMScheduler</a>.`,name:"scheduler"},{anchor:"diffusers.AudioLDM2Pipeline.vocoder",description:`<strong>vocoder</strong> (<a href="https://huggingface.co/docs/transformers/v4.44.2/en/model_doc/speecht5#transformers.SpeechT5HifiGan" rel="nofollow">SpeechT5HifiGan</a>) &#x2014;
Vocoder of class <code>SpeechT5HifiGan</code> to convert the mel-spectrogram latents to the final audio waveform.`,name:"vocoder"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L136"}}),ce=new $({props:{name:"__call__",anchor:"diffusers.AudioLDM2Pipeline.__call__",parameters:[{name:"prompt",val:": Union = None"},{name:"transcription",val:": Union = None"},{name:"audio_length_in_s",val:": Optional = None"},{name:"num_inference_steps",val:": int = 200"},{name:"guidance_scale",val:": float = 3.5"},{name:"negative_prompt",val:": Union = None"},{name:"num_waveforms_per_prompt",val:": Optional = 1"},{name:"eta",val:": float = 0.0"},{name:"generator",val:": Union = None"},{name:"latents",val:": Optional = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"generated_prompt_embeds",val:": Optional = None"},{name:"negative_generated_prompt_embeds",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"negative_attention_mask",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"callback",val:": Optional = None"},{name:"callback_steps",val:": Optional = 1"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"output_type",val:": Optional = 'np'"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide audio generation. If not defined, you need to pass <code>prompt_embeds</code>.`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.transcription",description:`<strong>transcription</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;\\
The transcript for text to speech.`,name:"transcription"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.audio_length_in_s",description:`<strong>audio_length_in_s</strong> (<code>int</code>, <em>optional</em>, defaults to 10.24) &#x2014;
The length of the generated audio sample in seconds.`,name:"audio_length_in_s"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_inference_steps",description:`<strong>num_inference_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 200) &#x2014;
The number of denoising steps. More denoising steps usually lead to a higher quality audio at the
expense of slower inference.`,name:"num_inference_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.guidance_scale",description:`<strong>guidance_scale</strong> (<code>float</code>, <em>optional</em>, defaults to 3.5) &#x2014;
A higher guidance scale value encourages the model to generate audio that is closely linked to the text
<code>prompt</code> at the expense of lower sound quality. Guidance scale is enabled when <code>guidance_scale &gt; 1</code>.`,name:"guidance_scale"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts to guide what to not include in audio generation. If not defined, you need to
pass <code>negative_prompt_embeds</code> instead. Ignored when not using guidance (<code>guidance_scale &lt; 1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of waveforms to generate per prompt. If <code>num_waveforms_per_prompt &gt; 1</code>, then automatic
scoring is performed between the generated outputs and the text prompt. This scoring ranks the
generated waveforms based on their cosine similarity with the text input in the joint text-audio
embedding space.`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.eta",description:`<strong>eta</strong> (<code>float</code>, <em>optional</em>, defaults to 0.0) &#x2014;
Corresponds to parameter eta (&#x3B7;) from the <a href="https://arxiv.org/abs/2010.02502" rel="nofollow">DDIM</a> paper. Only applies
to the <a href="/docs/diffusers/v0.30.3/en/api/schedulers/ddim#diffusers.DDIMScheduler">DDIMScheduler</a>, and is ignored in other schedulers.`,name:"eta"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generator",description:`<strong>generator</strong> (<code>torch.Generator</code> or <code>List[torch.Generator]</code>, <em>optional</em>) &#x2014;
A <a href="https://pytorch.org/docs/stable/generated/torch.Generator.html" rel="nofollow"><code>torch.Generator</code></a> to make
generation deterministic.`,name:"generator"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.latents",description:`<strong>latents</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated noisy latents sampled from a Gaussian distribution, to be used as inputs for spectrogram
generation. Can be used to tweak the same generation with different prompts. If not provided, a latents
tensor is generated by sampling using the supplied random <code>generator</code>.`,name:"latents"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings. Can be used to easily tweak text inputs (prompt weighting). If not
provided, text embeddings are generated from the <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings. Can be used to easily tweak text inputs (prompt weighting). If
not provided, <code>negative_prompt_embeds</code> are generated from the <code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
Number of new tokens to generate with the GPT2 language model. If not provided, number of tokens will
be taken from the config of the model.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.30.3/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput">StableDiffusionPipelineOutput</a> instead of a
plain tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback",description:`<strong>callback</strong> (<code>Callable</code>, <em>optional</em>) &#x2014;
A function that calls every <code>callback_steps</code> steps during inference. The function is called with the
following arguments: <code>callback(step: int, timestep: int, latents: torch.Tensor)</code>.`,name:"callback"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.callback_steps",description:`<strong>callback_steps</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014;
The frequency at which the <code>callback</code> function is called. If not specified, the callback is called at
every step.`,name:"callback_steps"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttentionProcessor</code> as defined in
<a href="https://github.com/huggingface/diffusers/blob/main/src/diffusers/models/attention_processor.py" rel="nofollow"><code>self.processor</code></a>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2Pipeline.__call__.output_type",description:`<strong>output_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;np&quot;</code>) &#x2014;
The output format of the generated audio. Choose between <code>&quot;np&quot;</code> to return a NumPy <code>np.ndarray</code> or
<code>&quot;pt&quot;</code> to return a PyTorch <code>torch.Tensor</code> object. Set to <code>&quot;latent&quot;</code> to return the latent diffusion
model (LDM) output.`,name:"output_type"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L812",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is <code>True</code>, <a
  href="/docs/diffusers/v0.30.3/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is a list with the generated audio.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.30.3/en/api/pipelines/stable_diffusion/img2img#diffusers.pipelines.stable_diffusion.StableDiffusionPipelineOutput"
>StableDiffusionPipelineOutput</a> or <code>tuple</code></p>
`}}),I=new Vt({props:{anchor:"diffusers.AudioLDM2Pipeline.__call__.example",$$slots:{default:[Uo]},$$scope:{ctx:C}}}),Z=new Vt({props:{anchor:"diffusers.AudioLDM2Pipeline.__call__.example-2",$$slots:{default:[Lo]},$$scope:{ctx:C}}}),pe=new $({props:{name:"disable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.disable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L221"}}),me=new $({props:{name:"enable_model_cpu_offload",anchor:"diffusers.AudioLDM2Pipeline.enable_model_cpu_offload",parameters:[{name:"gpu_id",val:" = 0"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L228"}}),ue=new $({props:{name:"enable_vae_slicing",anchor:"diffusers.AudioLDM2Pipeline.enable_vae_slicing",parameters:[],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L213"}}),fe=new $({props:{name:"encode_prompt",anchor:"diffusers.AudioLDM2Pipeline.encode_prompt",parameters:[{name:"prompt",val:""},{name:"device",val:""},{name:"num_waveforms_per_prompt",val:""},{name:"do_classifier_free_guidance",val:""},{name:"transcription",val:" = None"},{name:"negative_prompt",val:" = None"},{name:"prompt_embeds",val:": Optional = None"},{name:"negative_prompt_embeds",val:": Optional = None"},{name:"generated_prompt_embeds",val:": Optional = None"},{name:"negative_generated_prompt_embeds",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"negative_attention_mask",val:": Optional = None"},{name:"max_new_tokens",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt",description:`<strong>prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
prompt to be encoded`,name:"prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.transcription",description:`<strong>transcription</strong> (<code>str</code> or <code>List[str]</code>) &#x2014;
transcription of text to speech`,name:"transcription"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.device",description:`<strong>device</strong> (<code>torch.device</code>) &#x2014;
torch device`,name:"device"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.num_waveforms_per_prompt",description:`<strong>num_waveforms_per_prompt</strong> (<code>int</code>) &#x2014;
number of waveforms that should be generated per prompt`,name:"num_waveforms_per_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.do_classifier_free_guidance",description:`<strong>do_classifier_free_guidance</strong> (<code>bool</code>) &#x2014;
whether to use classifier free guidance or not`,name:"do_classifier_free_guidance"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt",description:`<strong>negative_prompt</strong> (<code>str</code> or <code>List[str]</code>, <em>optional</em>) &#x2014;
The prompt or prompts not to guide the audio generation. If not defined, one has to pass
<code>negative_prompt_embeds</code> instead. Ignored when not using guidance (i.e., ignored if <code>guidance_scale</code> is
less than <code>1</code>).`,name:"negative_prompt"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.prompt_embeds",description:`<strong>prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-computed text embeddings from the Flan T5 model. Can be used to easily tweak text inputs, <em>e.g.</em>
prompt weighting. If not provided, text embeddings will be computed from <code>prompt</code> input argument.`,name:"prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_prompt_embeds",description:`<strong>negative_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-computed negative text embeddings from the Flan T5 model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.generated_prompt_embeds",description:`<strong>generated_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated text embeddings from the GPT2 langauge model. Can be used to easily tweak text inputs,
<em>e.g.</em> prompt weighting. If not provided, text embeddings will be generated from <code>prompt</code> input
argument.`,name:"generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_generated_prompt_embeds",description:`<strong>negative_generated_prompt_embeds</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
Pre-generated negative text embeddings from the GPT2 language model. Can be used to easily tweak text
inputs, <em>e.g.</em> prompt weighting. If not provided, negative_prompt_embeds will be computed from
<code>negative_prompt</code> input argument.`,name:"negative_generated_prompt_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>prompt_embeds</code>. If not provided, attention mask will
be computed from <code>prompt</code> input argument.`,name:"attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.negative_attention_mask",description:`<strong>negative_attention_mask</strong> (<code>torch.LongTensor</code>, <em>optional</em>) &#x2014;
Pre-computed attention mask to be applied to the <code>negative_prompt_embeds</code>. If not provided, attention
mask will be computed from <code>negative_prompt</code> input argument.`,name:"negative_attention_mask"},{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to None) &#x2014;
The number of new tokens to generate with the GPT2 language model.`,name:"max_new_tokens"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L307",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>Text embeddings from the Flan T5 model.
attention_mask (<code>torch.LongTensor</code>):
Attention mask to be applied to the <code>prompt_embeds</code>.
generated_prompt_embeds (<code>torch.Tensor</code>):
Text embeddings generated from the GPT2 langauge model.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p>prompt_embeds (<code>torch.Tensor</code>)</p>
`}}),W=new Vt({props:{anchor:"diffusers.AudioLDM2Pipeline.encode_prompt.example",$$slots:{default:[Co]},$$scope:{ctx:C}}}),ge=new $({props:{name:"generate_language_model",anchor:"diffusers.AudioLDM2Pipeline.generate_language_model",parameters:[{name:"inputs_embeds",val:": Tensor = None"},{name:"max_new_tokens",val:": int = 8"},{name:"**model_kwargs",val:""}],parametersDescription:[{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>) &#x2014;
The sequence used as a prompt for the generation.`,name:"inputs_embeds"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.max_new_tokens",description:`<strong>max_new_tokens</strong> (<code>int</code>) &#x2014;
Number of new tokens to generate.`,name:"max_new_tokens"},{anchor:"diffusers.AudioLDM2Pipeline.generate_language_model.model_kwargs",description:`<strong>model_kwargs</strong> (<code>Dict[str, Any]</code>, <em>optional</em>) &#x2014;
Ad hoc parametrization of additional model-specific kwargs that will be forwarded to the <code>forward</code>
function of the model.`,name:"model_kwargs"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/pipeline_audioldm2.py#L265",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>The sequence of generated hidden-states.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>inputs_embeds (</code>torch.Tensor<code>of shape</code>(batch_size, sequence_length, hidden_size)\`)</p>
`}}),he=new N({props:{title:"AudioLDM2ProjectionModel",local:"diffusers.AudioLDM2ProjectionModel",headingTag:"h2"}}),_e=new $({props:{name:"class diffusers.AudioLDM2ProjectionModel",anchor:"diffusers.AudioLDM2ProjectionModel",parameters:[{name:"text_encoder_dim",val:""},{name:"text_encoder_1_dim",val:""},{name:"langauge_model_dim",val:""},{name:"use_learned_position_embedding",val:" = None"},{name:"max_seq_length",val:" = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_dim",description:`<strong>text_encoder_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the first text encoder (CLAP).`,name:"text_encoder_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.text_encoder_1_dim",description:`<strong>text_encoder_1_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the second text encoder (T5 or VITS).`,name:"text_encoder_1_dim"},{anchor:"diffusers.AudioLDM2ProjectionModel.langauge_model_dim",description:`<strong>langauge_model_dim</strong> (<code>int</code>) &#x2014;
Dimensionality of the text embeddings from the language model (GPT2).`,name:"langauge_model_dim"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L82"}}),Me=new $({props:{name:"forward",anchor:"diffusers.AudioLDM2ProjectionModel.forward",parameters:[{name:"hidden_states",val:": Optional = None"},{name:"hidden_states_1",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"attention_mask_1",val:": Optional = None"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L126"}}),be=new N({props:{title:"AudioLDM2UNet2DConditionModel",local:"diffusers.AudioLDM2UNet2DConditionModel",headingTag:"h2"}}),ve=new $({props:{name:"class diffusers.AudioLDM2UNet2DConditionModel",anchor:"diffusers.AudioLDM2UNet2DConditionModel",parameters:[{name:"sample_size",val:": Optional = None"},{name:"in_channels",val:": int = 4"},{name:"out_channels",val:": int = 4"},{name:"flip_sin_to_cos",val:": bool = True"},{name:"freq_shift",val:": int = 0"},{name:"down_block_types",val:": Tuple = ('CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'CrossAttnDownBlock2D', 'DownBlock2D')"},{name:"mid_block_type",val:": Optional = 'UNetMidBlock2DCrossAttn'"},{name:"up_block_types",val:": Tuple = ('UpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D', 'CrossAttnUpBlock2D')"},{name:"only_cross_attention",val:": Union = False"},{name:"block_out_channels",val:": Tuple = (320, 640, 1280, 1280)"},{name:"layers_per_block",val:": Union = 2"},{name:"downsample_padding",val:": int = 1"},{name:"mid_block_scale_factor",val:": float = 1"},{name:"act_fn",val:": str = 'silu'"},{name:"norm_num_groups",val:": Optional = 32"},{name:"norm_eps",val:": float = 1e-05"},{name:"cross_attention_dim",val:": Union = 1280"},{name:"transformer_layers_per_block",val:": Union = 1"},{name:"attention_head_dim",val:": Union = 8"},{name:"num_attention_heads",val:": Union = None"},{name:"use_linear_projection",val:": bool = False"},{name:"class_embed_type",val:": Optional = None"},{name:"num_class_embeds",val:": Optional = None"},{name:"upcast_attention",val:": bool = False"},{name:"resnet_time_scale_shift",val:": str = 'default'"},{name:"time_embedding_type",val:": str = 'positional'"},{name:"time_embedding_dim",val:": Optional = None"},{name:"time_embedding_act_fn",val:": Optional = None"},{name:"timestep_post_act",val:": Optional = None"},{name:"time_cond_proj_dim",val:": Optional = None"},{name:"conv_in_kernel",val:": int = 3"},{name:"conv_out_kernel",val:": int = 3"},{name:"projection_class_embeddings_input_dim",val:": Optional = None"},{name:"class_embeddings_concat",val:": bool = False"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.sample_size",description:`<strong>sample_size</strong> (<code>int</code> or <code>Tuple[int, int]</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Height and width of input/output sample.`,name:"sample_size"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.in_channels",description:"<strong>in_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the input sample.",name:"in_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.out_channels",description:"<strong>out_channels</strong> (<code>int</code>, <em>optional</em>, defaults to 4) &#x2014; Number of channels in the output.",name:"out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.flip_sin_to_cos",description:`<strong>flip_sin_to_cos</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to flip the sin to cos in the time embedding.`,name:"flip_sin_to_cos"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.freq_shift",description:"<strong>freq_shift</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014; The frequency shift to apply to the time embedding.",name:"freq_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.down_block_types",description:`<strong>down_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;CrossAttnDownBlock2D&quot;, &quot;DownBlock2D&quot;)</code>) &#x2014;
The tuple of downsample blocks to use.`,name:"down_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_type",description:`<strong>mid_block_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;UNetMidBlock2DCrossAttn&quot;</code>) &#x2014;
Block type for middle of UNet, it can only be <code>UNetMidBlock2DCrossAttn</code> for AudioLDM2.`,name:"mid_block_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.up_block_types",description:`<strong>up_block_types</strong> (<code>Tuple[str]</code>, <em>optional</em>, defaults to <code>(&quot;UpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;, &quot;CrossAttnUpBlock2D&quot;)</code>) &#x2014;
The tuple of upsample blocks to use.`,name:"up_block_types"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.only_cross_attention",description:`<strong>only_cross_attention</strong> (<code>bool</code> or <code>Tuple[bool]</code>, <em>optional</em>, default to <code>False</code>) &#x2014;
Whether to include self-attention in the basic transformer blocks, see
<code>BasicTransformerBlock</code>.`,name:"only_cross_attention"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.block_out_channels",description:`<strong>block_out_channels</strong> (<code>Tuple[int]</code>, <em>optional</em>, defaults to <code>(320, 640, 1280, 1280)</code>) &#x2014;
The tuple of output channels for each block.`,name:"block_out_channels"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.layers_per_block",description:"<strong>layers_per_block</strong> (<code>int</code>, <em>optional</em>, defaults to 2) &#x2014; The number of layers per block.",name:"layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.downsample_padding",description:"<strong>downsample_padding</strong> (<code>int</code>, <em>optional</em>, defaults to 1) &#x2014; The padding to use for the downsampling convolution.",name:"downsample_padding"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.mid_block_scale_factor",description:"<strong>mid_block_scale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to 1.0) &#x2014; The scale factor to use for the mid block.",name:"mid_block_scale_factor"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.act_fn",description:"<strong>act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;silu&quot;</code>) &#x2014; The activation function to use.",name:"act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_num_groups",description:`<strong>norm_num_groups</strong> (<code>int</code>, <em>optional</em>, defaults to 32) &#x2014; The number of groups to use for the normalization.
If <code>None</code>, normalization and activation layers is skipped in post-processing.`,name:"norm_num_groups"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.norm_eps",description:"<strong>norm_eps</strong> (<code>float</code>, <em>optional</em>, defaults to 1e-5) &#x2014; The epsilon to use for the normalization.",name:"norm_eps"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.cross_attention_dim",description:`<strong>cross_attention_dim</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1280) &#x2014;
The dimension of the cross attention features.`,name:"cross_attention_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.transformer_layers_per_block",description:`<strong>transformer_layers_per_block</strong> (<code>int</code> or <code>Tuple[int]</code>, <em>optional</em>, defaults to 1) &#x2014;
The number of transformer blocks of type <code>BasicTransformerBlock</code>. Only relevant for
<code>~models.unet_2d_blocks.CrossAttnDownBlock2D</code>, <code>~models.unet_2d_blocks.CrossAttnUpBlock2D</code>,
<code>~models.unet_2d_blocks.UNetMidBlock2DCrossAttn</code>.`,name:"transformer_layers_per_block"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.attention_head_dim",description:"<strong>attention_head_dim</strong> (<code>int</code>, <em>optional</em>, defaults to 8) &#x2014; The dimension of the attention heads.",name:"attention_head_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_attention_heads",description:`<strong>num_attention_heads</strong> (<code>int</code>, <em>optional</em>) &#x2014;
The number of attention heads. If not defined, defaults to <code>attention_head_dim</code>`,name:"num_attention_heads"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.resnet_time_scale_shift",description:`<strong>resnet_time_scale_shift</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014; Time scale shift config
for ResNet blocks (see <code>ResnetBlock2D</code>). Choose from <code>default</code> or <code>scale_shift</code>.`,name:"resnet_time_scale_shift"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embed_type",description:`<strong>class_embed_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The type of class embedding to use which is ultimately summed with the time embeddings. Choose from <code>None</code>,
<code>&quot;timestep&quot;</code>, <code>&quot;identity&quot;</code>, <code>&quot;projection&quot;</code>, or <code>&quot;simple_projection&quot;</code>.`,name:"class_embed_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.num_class_embeds",description:`<strong>num_class_embeds</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Input dimension of the learnable embedding matrix to be projected to <code>time_embed_dim</code>, when performing
class conditioning with <code>class_embed_type</code> equal to <code>None</code>.`,name:"num_class_embeds"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_type",description:`<strong>time_embedding_type</strong> (<code>str</code>, <em>optional</em>, defaults to <code>positional</code>) &#x2014;
The type of position embedding to use for timesteps. Choose from <code>positional</code> or <code>fourier</code>.`,name:"time_embedding_type"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_dim",description:`<strong>time_embedding_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
An optional override for the dimension of the projected time embedding.`,name:"time_embedding_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_embedding_act_fn",description:`<strong>time_embedding_act_fn</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
Optional activation function to use only once on the time embeddings before they are passed to the rest of
the UNet. Choose from <code>silu</code>, <code>mish</code>, <code>gelu</code>, and <code>swish</code>.`,name:"time_embedding_act_fn"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.timestep_post_act",description:`<strong>timestep_post_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The second activation function to use in timestep embedding. Choose from <code>silu</code>, <code>mish</code> and <code>gelu</code>.`,name:"timestep_post_act"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.time_cond_proj_dim",description:`<strong>time_cond_proj_dim</strong> (<code>int</code>, <em>optional</em>, defaults to <code>None</code>) &#x2014;
The dimension of <code>cond_proj</code> layer in the timestep embedding.`,name:"time_cond_proj_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_in_kernel",description:"<strong>conv_in_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_in</code> layer.",name:"conv_in_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.conv_out_kernel",description:"<strong>conv_out_kernel</strong> (<code>int</code>, <em>optional</em>, default to <code>3</code>) &#x2014; The kernel size of <code>conv_out</code> layer.",name:"conv_out_kernel"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.projection_class_embeddings_input_dim",description:`<strong>projection_class_embeddings_input_dim</strong> (<code>int</code>, <em>optional</em>) &#x2014; The dimension of the <code>class_labels</code> input when
<code>class_embed_type=&quot;projection&quot;</code>. Required when <code>class_embed_type=&quot;projection&quot;</code>.`,name:"projection_class_embeddings_input_dim"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.class_embeddings_concat",description:`<strong>class_embeddings_concat</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014; Whether to concatenate the time
embeddings with the class embeddings.`,name:"class_embeddings_concat"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L167"}}),we=new $({props:{name:"forward",anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward",parameters:[{name:"sample",val:": Tensor"},{name:"timestep",val:": Union"},{name:"encoder_hidden_states",val:": Tensor"},{name:"class_labels",val:": Optional = None"},{name:"timestep_cond",val:": Optional = None"},{name:"attention_mask",val:": Optional = None"},{name:"cross_attention_kwargs",val:": Optional = None"},{name:"encoder_attention_mask",val:": Optional = None"},{name:"return_dict",val:": bool = True"},{name:"encoder_hidden_states_1",val:": Optional = None"},{name:"encoder_attention_mask_1",val:": Optional = None"}],parametersDescription:[{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.sample",description:`<strong>sample</strong> (<code>torch.Tensor</code>) &#x2014;
The noisy input tensor with the following shape <code>(batch, channel, height, width)</code>.`,name:"sample"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.timestep",description:"<strong>timestep</strong> (<code>torch.Tensor</code> or <code>float</code> or <code>int</code>) &#x2014; The number of timesteps to denoise an input.",name:"timestep"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states",description:`<strong>encoder_hidden_states</strong> (<code>torch.Tensor</code>) &#x2014;
The encoder hidden states with shape <code>(batch, sequence_length, feature_dim)</code>.`,name:"encoder_hidden_states"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask",description:`<strong>encoder_attention_mask</strong> (<code>torch.Tensor</code>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length)</code> is applied to <code>encoder_hidden_states</code>. If
<code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether or not to return a <a href="/docs/diffusers/v0.30.3/en/api/models/unet2d-cond#diffusers.models.unets.unet_2d_condition.UNet2DConditionOutput">UNet2DConditionOutput</a> instead of a plain
tuple.`,name:"return_dict"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.cross_attention_kwargs",description:`<strong>cross_attention_kwargs</strong> (<code>dict</code>, <em>optional</em>) &#x2014;
A kwargs dictionary that if specified is passed along to the <code>AttnProcessor</code>.`,name:"cross_attention_kwargs"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_hidden_states_1",description:`<strong>encoder_hidden_states_1</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
A second set of encoder hidden states with shape <code>(batch, sequence_length_2, feature_dim_2)</code>. Can be
used to condition the model on a different set of embeddings to <code>encoder_hidden_states</code>.`,name:"encoder_hidden_states_1"},{anchor:"diffusers.AudioLDM2UNet2DConditionModel.forward.encoder_attention_mask_1",description:`<strong>encoder_attention_mask_1</strong> (<code>torch.Tensor</code>, <em>optional</em>) &#x2014;
A cross-attention mask of shape <code>(batch, sequence_length_2)</code> is applied to <code>encoder_hidden_states_1</code>.
If <code>True</code> the mask is kept, otherwise if <code>False</code> it is discarded. Mask will be converted into a bias,
which adds large negative values to the attention scores corresponding to &#x201C;discard&#x201D; tokens.`,name:"encoder_attention_mask_1"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/audioldm2/modeling_audioldm2.py#L681",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>If <code>return_dict</code> is True, an <a
  href="/docs/diffusers/v0.30.3/en/api/models/unet2d-cond#diffusers.models.unets.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> is returned,
otherwise a <code>tuple</code> is returned where the first element is the sample tensor.</p>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><a
  href="/docs/diffusers/v0.30.3/en/api/models/unet2d-cond#diffusers.models.unets.unet_2d_condition.UNet2DConditionOutput"
>UNet2DConditionOutput</a> or <code>tuple</code></p>
`}}),ye=new N({props:{title:"AudioPipelineOutput",local:"diffusers.AudioPipelineOutput",headingTag:"h2"}}),Te=new $({props:{name:"class diffusers.AudioPipelineOutput",anchor:"diffusers.AudioPipelineOutput",parameters:[{name:"audios",val:": ndarray"}],parametersDescription:[{anchor:"diffusers.AudioPipelineOutput.audios",description:`<strong>audios</strong> (<code>np.ndarray</code>) &#x2014;
List of denoised audio samples of a NumPy array of shape <code>(batch_size, num_channels, sample_rate)</code>.`,name:"audios"}],source:"https://github.com/huggingface/diffusers/blob/v0.30.3/src/diffusers/pipelines/pipeline_utils.py#L114"}}),xe=new Ao({props:{source:"https://github.com/huggingface/diffusers/blob/main/docs/source/en/api/pipelines/audioldm2.md"}}),{c(){l=d("meta"),y=n(),p=d("p"),b=n(),m(T.$$.fragment),c=n(),x=d("p"),x.innerHTML=Rt,Qe=n(),H=d("p"),H.innerHTML=zt,Xe=n(),V=d("p"),V.textContent=Ot,He=n(),F=d("p"),F.innerHTML=Yt,Ve=n(),R=d("p"),R.innerHTML=Kt,Fe=n(),m(z.$$.fragment),Re=n(),m(O.$$.fragment),ze=n(),Y=d("p"),Y.textContent=eo,Oe=n(),K=d("p"),K.textContent=to,Ye=n(),ee=d("table"),ee.innerHTML=oo,Ke=n(),m(te.$$.fragment),et=n(),oe=d("ul"),oe.innerHTML=no,tt=n(),m(ne.$$.fragment),ot=n(),se=d("ul"),se.innerHTML=so,nt=n(),m(ae.$$.fragment),st=n(),ie=d("ul"),ie.innerHTML=ao,at=n(),de=d("p"),de.innerHTML=io,it=n(),m(P.$$.fragment),dt=n(),m(re.$$.fragment),rt=n(),v=d("div"),m(le.$$.fragment),Tt=n(),ke=d("p"),ke.textContent=ro,xt=n(),Ae=d("p"),Ae.innerHTML=lo,jt=n(),A=d("div"),m(ce.$$.fragment),Dt=n(),$e=d("p"),$e.textContent=co,kt=n(),m(I.$$.fragment),At=n(),m(Z.$$.fragment),$t=n(),G=d("div"),m(pe.$$.fragment),Ut=n(),Ue=d("p"),Ue.innerHTML=po,Lt=n(),q=d("div"),m(me.$$.fragment),Ct=n(),Le=d("p"),Le.innerHTML=mo,Jt=n(),E=d("div"),m(ue.$$.fragment),Nt=n(),Ce=d("p"),Ce.textContent=uo,Bt=n(),J=d("div"),m(fe.$$.fragment),Pt=n(),Je=d("p"),Je.textContent=fo,It=n(),m(W.$$.fragment),Zt=n(),S=d("div"),m(ge.$$.fragment),Gt=n(),Ne=d("p"),Ne.textContent=go,lt=n(),m(he.$$.fragment),ct=n(),U=d("div"),m(_e.$$.fragment),qt=n(),Be=d("p"),Be.innerHTML=ho,Et=n(),Pe=d("div"),m(Me.$$.fragment),pt=n(),m(be.$$.fragment),mt=n(),k=d("div"),m(ve.$$.fragment),Wt=n(),Ie=d("p"),Ie.innerHTML=_o,St=n(),Ze=d("p"),Ze.innerHTML=Mo,Qt=n(),Q=d("div"),m(we.$$.fragment),Xt=n(),Ge=d("p"),Ge.innerHTML=bo,ut=n(),m(ye.$$.fragment),ft=n(),B=d("div"),m(Te.$$.fragment),Ht=n(),qe=d("p"),qe.textContent=vo,gt=n(),m(xe.$$.fragment),ht=n(),Se=d("p"),this.h()},l(e){const t=Do("svelte-u9bgzb",document.head);l=r(t,"META",{name:!0,content:!0}),t.forEach(o),y=s(e),p=r(e,"P",{}),j(p).forEach(o),b=s(e),u(T.$$.fragment,e),c=s(e),x=r(e,"P",{"data-svelte-h":!0}),M(x)!=="svelte-ta0apn"&&(x.innerHTML=Rt),Qe=s(e),H=r(e,"P",{"data-svelte-h":!0}),M(H)!=="svelte-117z0zb"&&(H.innerHTML=zt),Xe=s(e),V=r(e,"P",{"data-svelte-h":!0}),M(V)!=="svelte-wu27l3"&&(V.textContent=Ot),He=s(e),F=r(e,"P",{"data-svelte-h":!0}),M(F)!=="svelte-1ddltfs"&&(F.innerHTML=Yt),Ve=s(e),R=r(e,"P",{"data-svelte-h":!0}),M(R)!=="svelte-1gmtu0s"&&(R.innerHTML=Kt),Fe=s(e),u(z.$$.fragment,e),Re=s(e),u(O.$$.fragment,e),ze=s(e),Y=r(e,"P",{"data-svelte-h":!0}),M(Y)!=="svelte-1hmv6lf"&&(Y.textContent=eo),Oe=s(e),K=r(e,"P",{"data-svelte-h":!0}),M(K)!=="svelte-1hmqwck"&&(K.textContent=to),Ye=s(e),ee=r(e,"TABLE",{"data-svelte-h":!0}),M(ee)!=="svelte-bgni2t"&&(ee.innerHTML=oo),Ke=s(e),u(te.$$.fragment,e),et=s(e),oe=r(e,"UL",{"data-svelte-h":!0}),M(oe)!=="svelte-1ry6k60"&&(oe.innerHTML=no),tt=s(e),u(ne.$$.fragment,e),ot=s(e),se=r(e,"UL",{"data-svelte-h":!0}),M(se)!=="svelte-jm9a2k"&&(se.innerHTML=so),nt=s(e),u(ae.$$.fragment,e),st=s(e),ie=r(e,"UL",{"data-svelte-h":!0}),M(ie)!=="svelte-9fhj5v"&&(ie.innerHTML=ao),at=s(e),de=r(e,"P",{"data-svelte-h":!0}),M(de)!=="svelte-16dt629"&&(de.innerHTML=io),it=s(e),u(P.$$.fragment,e),dt=s(e),u(re.$$.fragment,e),rt=s(e),v=r(e,"DIV",{class:!0});var w=j(v);u(le.$$.fragment,w),Tt=s(w),ke=r(w,"P",{"data-svelte-h":!0}),M(ke)!=="svelte-m23e7a"&&(ke.textContent=ro),xt=s(w),Ae=r(w,"P",{"data-svelte-h":!0}),M(Ae)!=="svelte-riyhnb"&&(Ae.innerHTML=lo),jt=s(w),A=r(w,"DIV",{class:!0});var L=j(A);u(ce.$$.fragment,L),Dt=s(L),$e=r(L,"P",{"data-svelte-h":!0}),M($e)!=="svelte-50j04k"&&($e.textContent=co),kt=s(L),u(I.$$.fragment,L),At=s(L),u(Z.$$.fragment,L),L.forEach(o),$t=s(w),G=r(w,"DIV",{class:!0});var je=j(G);u(pe.$$.fragment,je),Ut=s(je),Ue=r(je,"P",{"data-svelte-h":!0}),M(Ue)!=="svelte-1s3c06i"&&(Ue.innerHTML=po),je.forEach(o),Lt=s(w),q=r(w,"DIV",{class:!0});var De=j(q);u(me.$$.fragment,De),Ct=s(De),Le=r(De,"P",{"data-svelte-h":!0}),M(Le)!=="svelte-d7vywi"&&(Le.innerHTML=mo),De.forEach(o),Jt=s(w),E=r(w,"DIV",{class:!0});var Mt=j(E);u(ue.$$.fragment,Mt),Nt=s(Mt),Ce=r(Mt,"P",{"data-svelte-h":!0}),M(Ce)!=="svelte-14bnrb6"&&(Ce.textContent=uo),Mt.forEach(o),Bt=s(w),J=r(w,"DIV",{class:!0});var Ee=j(J);u(fe.$$.fragment,Ee),Pt=s(Ee),Je=r(Ee,"P",{"data-svelte-h":!0}),M(Je)!=="svelte-16q0ax1"&&(Je.textContent=fo),It=s(Ee),u(W.$$.fragment,Ee),Ee.forEach(o),Zt=s(w),S=r(w,"DIV",{class:!0});var bt=j(S);u(ge.$$.fragment,bt),Gt=s(bt),Ne=r(bt,"P",{"data-svelte-h":!0}),M(Ne)!=="svelte-1whwjf0"&&(Ne.textContent=go),bt.forEach(o),w.forEach(o),lt=s(e),u(he.$$.fragment,e),ct=s(e),U=r(e,"DIV",{class:!0});var We=j(U);u(_e.$$.fragment,We),qt=s(We),Be=r(We,"P",{"data-svelte-h":!0}),M(Be)!=="svelte-eyi7ar"&&(Be.innerHTML=ho),Et=s(We),Pe=r(We,"DIV",{class:!0});var wo=j(Pe);u(Me.$$.fragment,wo),wo.forEach(o),We.forEach(o),pt=s(e),u(be.$$.fragment,e),mt=s(e),k=r(e,"DIV",{class:!0});var X=j(k);u(ve.$$.fragment,X),Wt=s(X),Ie=r(X,"P",{"data-svelte-h":!0}),M(Ie)!=="svelte-17wh1ci"&&(Ie.innerHTML=_o),St=s(X),Ze=r(X,"P",{"data-svelte-h":!0}),M(Ze)!=="svelte-ygoux9"&&(Ze.innerHTML=Mo),Qt=s(X),Q=r(X,"DIV",{class:!0});var vt=j(Q);u(we.$$.fragment,vt),Xt=s(vt),Ge=r(vt,"P",{"data-svelte-h":!0}),M(Ge)!=="svelte-17gjn6k"&&(Ge.innerHTML=bo),vt.forEach(o),X.forEach(o),ut=s(e),u(ye.$$.fragment,e),ft=s(e),B=r(e,"DIV",{class:!0});var wt=j(B);u(Te.$$.fragment,wt),Ht=s(wt),qe=r(wt,"P",{"data-svelte-h":!0}),M(qe)!=="svelte-19ryw33"&&(qe.textContent=vo),wt.forEach(o),gt=s(e),u(xe.$$.fragment,e),ht=s(e),Se=r(e,"P",{}),j(Se).forEach(o),this.h()},h(){D(l,"name","hf:doc:metadata"),D(l,"content",No),D(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(G,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(E,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(v,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),D(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){i(document.head,l),a(e,y,t),a(e,p,t),a(e,b,t),f(T,e,t),a(e,c,t),a(e,x,t),a(e,Qe,t),a(e,H,t),a(e,Xe,t),a(e,V,t),a(e,He,t),a(e,F,t),a(e,Ve,t),a(e,R,t),a(e,Fe,t),f(z,e,t),a(e,Re,t),f(O,e,t),a(e,ze,t),a(e,Y,t),a(e,Oe,t),a(e,K,t),a(e,Ye,t),a(e,ee,t),a(e,Ke,t),f(te,e,t),a(e,et,t),a(e,oe,t),a(e,tt,t),f(ne,e,t),a(e,ot,t),a(e,se,t),a(e,nt,t),f(ae,e,t),a(e,st,t),a(e,ie,t),a(e,at,t),a(e,de,t),a(e,it,t),f(P,e,t),a(e,dt,t),f(re,e,t),a(e,rt,t),a(e,v,t),f(le,v,null),i(v,Tt),i(v,ke),i(v,xt),i(v,Ae),i(v,jt),i(v,A),f(ce,A,null),i(A,Dt),i(A,$e),i(A,kt),f(I,A,null),i(A,At),f(Z,A,null),i(v,$t),i(v,G),f(pe,G,null),i(G,Ut),i(G,Ue),i(v,Lt),i(v,q),f(me,q,null),i(q,Ct),i(q,Le),i(v,Jt),i(v,E),f(ue,E,null),i(E,Nt),i(E,Ce),i(v,Bt),i(v,J),f(fe,J,null),i(J,Pt),i(J,Je),i(J,It),f(W,J,null),i(v,Zt),i(v,S),f(ge,S,null),i(S,Gt),i(S,Ne),a(e,lt,t),f(he,e,t),a(e,ct,t),a(e,U,t),f(_e,U,null),i(U,qt),i(U,Be),i(U,Et),i(U,Pe),f(Me,Pe,null),a(e,pt,t),f(be,e,t),a(e,mt,t),a(e,k,t),f(ve,k,null),i(k,Wt),i(k,Ie),i(k,St),i(k,Ze),i(k,Qt),i(k,Q),f(we,Q,null),i(Q,Xt),i(Q,Ge),a(e,ut,t),f(ye,e,t),a(e,ft,t),a(e,B,t),f(Te,B,null),i(B,Ht),i(B,qe),a(e,gt,t),f(xe,e,t),a(e,ht,t),a(e,Se,t),_t=!0},p(e,[t]){const w={};t&2&&(w.$$scope={dirty:t,ctx:e}),P.$set(w);const L={};t&2&&(L.$$scope={dirty:t,ctx:e}),I.$set(L);const je={};t&2&&(je.$$scope={dirty:t,ctx:e}),Z.$set(je);const De={};t&2&&(De.$$scope={dirty:t,ctx:e}),W.$set(De)},i(e){_t||(g(T.$$.fragment,e),g(z.$$.fragment,e),g(O.$$.fragment,e),g(te.$$.fragment,e),g(ne.$$.fragment,e),g(ae.$$.fragment,e),g(P.$$.fragment,e),g(re.$$.fragment,e),g(le.$$.fragment,e),g(ce.$$.fragment,e),g(I.$$.fragment,e),g(Z.$$.fragment,e),g(pe.$$.fragment,e),g(me.$$.fragment,e),g(ue.$$.fragment,e),g(fe.$$.fragment,e),g(W.$$.fragment,e),g(ge.$$.fragment,e),g(he.$$.fragment,e),g(_e.$$.fragment,e),g(Me.$$.fragment,e),g(be.$$.fragment,e),g(ve.$$.fragment,e),g(we.$$.fragment,e),g(ye.$$.fragment,e),g(Te.$$.fragment,e),g(xe.$$.fragment,e),_t=!0)},o(e){h(T.$$.fragment,e),h(z.$$.fragment,e),h(O.$$.fragment,e),h(te.$$.fragment,e),h(ne.$$.fragment,e),h(ae.$$.fragment,e),h(P.$$.fragment,e),h(re.$$.fragment,e),h(le.$$.fragment,e),h(ce.$$.fragment,e),h(I.$$.fragment,e),h(Z.$$.fragment,e),h(pe.$$.fragment,e),h(me.$$.fragment,e),h(ue.$$.fragment,e),h(fe.$$.fragment,e),h(W.$$.fragment,e),h(ge.$$.fragment,e),h(he.$$.fragment,e),h(_e.$$.fragment,e),h(Me.$$.fragment,e),h(be.$$.fragment,e),h(ve.$$.fragment,e),h(we.$$.fragment,e),h(ye.$$.fragment,e),h(Te.$$.fragment,e),h(xe.$$.fragment,e),_t=!1},d(e){e&&(o(y),o(p),o(b),o(c),o(x),o(Qe),o(H),o(Xe),o(V),o(He),o(F),o(Ve),o(R),o(Fe),o(Re),o(ze),o(Y),o(Oe),o(K),o(Ye),o(ee),o(Ke),o(et),o(oe),o(tt),o(ot),o(se),o(nt),o(st),o(ie),o(at),o(de),o(it),o(dt),o(rt),o(v),o(lt),o(ct),o(U),o(pt),o(mt),o(k),o(ut),o(ft),o(B),o(gt),o(ht),o(Se)),o(l),_(T,e),_(z,e),_(O,e),_(te,e),_(ne,e),_(ae,e),_(P,e),_(re,e),_(le),_(ce),_(I),_(Z),_(pe),_(me),_(ue),_(fe),_(W),_(ge),_(he,e),_(_e),_(Me),_(be,e),_(ve),_(we),_(ye,e),_(Te),_(xe,e)}}}const No='{"title":"AudioLDM 2","local":"audioldm-2","sections":[{"title":"Tips","local":"tips","sections":[{"title":"Choosing a checkpoint","local":"choosing-a-checkpoint","sections":[],"depth":3},{"title":"Constructing a prompt","local":"constructing-a-prompt","sections":[],"depth":3},{"title":"Controlling inference","local":"controlling-inference","sections":[],"depth":3},{"title":"Evaluating generated waveforms:","local":"evaluating-generated-waveforms","sections":[],"depth":3}],"depth":2},{"title":"AudioLDM2Pipeline","local":"diffusers.AudioLDM2Pipeline","sections":[],"depth":2},{"title":"AudioLDM2ProjectionModel","local":"diffusers.AudioLDM2ProjectionModel","sections":[],"depth":2},{"title":"AudioLDM2UNet2DConditionModel","local":"diffusers.AudioLDM2UNet2DConditionModel","sections":[],"depth":2},{"title":"AudioPipelineOutput","local":"diffusers.AudioPipelineOutput","sections":[],"depth":2}],"depth":1}';function Bo(C){return To(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class So extends xo{constructor(l){super(),jo(this,l,Bo,Jo,yo,{})}}export{So as component};
