import{s as Ae,o as Pe,n as De}from"../chunks/scheduler.6062bdaf.js";import{S as Ke,i as Oe,g as i,s as l,r as c,A as es,h as p,f as t,c as n,j as L,u as r,x as m,k as Fe,y,a,v as h,d as g,t as d,w as f}from"../chunks/index.4bca734e.js";import{T as ss}from"../chunks/Tip.b9ac1f03.js";import{C as K}from"../chunks/CodeBlock.cbbddafc.js";import{H as _e,E as ts}from"../chunks/index.fb1f0efe.js";function as(se){let o,T=`<a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> provides fsspec compatibility, which is useful for libraries that require it (e.g., reading
Hugging Face datasets directly with <code>pandas</code>). However, it introduces additional overhead due to this compatibility
layer. For better performance and reliability, it’s recommended to use <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> methods when possible.`;return{c(){o=i("p"),o.innerHTML=T},l(u){o=p(u,"P",{"data-svelte-h":!0}),m(o)!=="svelte-18fsjkr"&&(o.innerHTML=T)},m(u,N){a(u,o,N)},p:De,d(u){u&&t(o)}}}function ls(se){let o,T,u,N,j,te,b,Se='In addition to the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a>, the <code>huggingface_hub</code> library provides <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>, a pythonic <a href="https://filesystem-spec.readthedocs.io/en/latest/" rel="nofollow">fsspec-compatible</a> file interface to the Hugging Face Hub. The <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> builds on top of the <a href="/docs/huggingface_hub/main/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> and offers typical filesystem style operations like <code>cp</code>, <code>mv</code>, <code>ls</code>, <code>du</code>, <code>glob</code>, <code>get_file</code>, and <code>put_file</code>.',ae,M,le,U,ne,k,ie,Z,He="The optional <code>revision</code> argument can be passed to run an operation from a specific commit such as a branch, tag name, or a commit hash.",pe,I,Be="Unlike Python’s built-in <code>open</code>, <code>fsspec</code>’s <code>open</code> defaults to binary mode, <code>&quot;rb&quot;</code>. This means you must explicitly set mode as <code>&quot;r&quot;</code> for reading and <code>&quot;w&quot;</code> for writing in text mode. Appending to a file (modes <code>&quot;a&quot;</code> and <code>&quot;ab&quot;</code>) is not supported yet.",oe,G,me,_,We='The <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> can be used with any library that integrates <code>fsspec</code>, provided the URL follows the scheme:',ce,$,re,J,Ye='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/huggingface_hub/hf_urls.png"/>',he,v,Ce="The <code>repo_type_prefix</code> is <code>datasets/</code> for datasets, <code>spaces/</code> for spaces, and models don’t need a prefix in the URL.",ge,X,xe='Some interesting integrations where <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a> simplifies interacting with the Hub are listed below:',de,Q,R,A,Ee='Reading/writing a <a href="https://pandas.pydata.org/pandas-docs/stable/user_guide/io.html#reading-writing-remote-files" rel="nofollow">Pandas</a> DataFrame from/to a Hub repository:',$e,F,fe,S,qe='The same workflow can also be used for <a href="https://docs.dask.org/en/stable/how-to/connect-to-remote-data.html" rel="nofollow">Dask</a> and <a href="https://pola-rs.github.io/polars/py-polars/html/reference/io.html" rel="nofollow">Polars</a> DataFrames.',ue,w,H,P,ze='Querying (remote) Hub files with <a href="https://duckdb.org/docs/guides/python/filesystems" rel="nofollow">DuckDB</a>:',ve,B,Xe,W,D,Ve='Using the Hub as an array store with <a href="https://zarr.readthedocs.io/en/stable/tutorial.html#io-with-fsspec" rel="nofollow">Zarr</a>:',Re,Y,ye,C,Me,x,Le='In many cases, you must be logged in with a Hugging Face account to interact with the Hub. Refer to the <a href="../quick-start#authentication">Authentication</a> section of the documentation to learn more about authentication methods on the Hub.',Je,E,Ne='It is also possible to log in programmatically by passing your <code>token</code> as an argument to <a href="/docs/huggingface_hub/main/en/package_reference/hf_file_system#huggingface_hub.HfFileSystem">HfFileSystem</a>:',we,q,Te,z,Qe="If you log in this way, be careful not to accidentally leak the token when sharing your source code!",je,V,be,O,Ue;return j=new _e({props:{title:"Interact with the Hub through the Filesystem API",local:"interact-with-the-hub-through-the-filesystem-api",headingTag:"h1"}}),M=new ss({props:{warning:!0,$$slots:{default:[as]},$$scope:{ctx:se}}}),U=new _e({props:{title:"Usage",local:"usage",headingTag:"h2"}}),k=new K({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEElMEElMjMlMjBMaXN0JTIwYWxsJTIwZmlsZXMlMjBpbiUyMGElMjBkaXJlY3RvcnklMEFmcy5scyglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyMiUyQyUyMGRldGFpbCUzREZhbHNlKSUwQSUwQSUyMyUyMExpc3QlMjBhbGwlMjAlMjIuY3N2JTIyJTIwZmlsZXMlMjBpbiUyMGElMjByZXBvJTBBZnMuZ2xvYiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGKiolMkYqLmNzdiUyMiklMEElMEElMjMlMjBSZWFkJTIwYSUyMHJlbW90ZSUyMGZpbGUlMEF3aXRoJTIwZnMub3BlbiglMjJkYXRhc2V0cyUyRm15LXVzZXJuYW1lJTJGbXktZGF0YXNldC1yZXBvJTJGZGF0YSUyRnRyYWluLmNzdiUyMiUyQyUyMCUyMnIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwdHJhaW5fZGF0YSUyMCUzRCUyMGYucmVhZGxpbmVzKCklMEElMEElMjMlMjBSZWFkJTIwdGhlJTIwY29udGVudCUyMG9mJTIwYSUyMHJlbW90ZSUyMGZpbGUlMjBhcyUyMGElMjBzdHJpbmclMEF0cmFpbl9kYXRhJTIwJTNEJTIwZnMucmVhZF90ZXh0KCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdHJhaW4uY3N2JTIyJTJDJTIwcmV2aXNpb24lM0QlMjJkZXYlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwcmVtb3RlJTIwZmlsZSUwQXdpdGglMjBmcy5vcGVuKCUyMmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhJTJGdmFsaWRhdGlvbi5jc3YlMjIlMkMlMjAlMjJ3JTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIydGV4dCUyQ2xhYmVsJTIyKSUwQSUyMCUyMCUyMCUyMGYud3JpdGUoJTIyRmFudGFzdGljJTIwbW92aWUhJTJDZ29vZCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all files in a directory</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.ls(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data&quot;</span>, detail=<span class="hljs-literal">False</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># List all &quot;.csv&quot; files in a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs.glob(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/**/*.csv&quot;</span>)
[<span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/train.csv&#x27;</span>, <span class="hljs-string">&#x27;datasets/my-username/my-dataset-repo/data/test.csv&#x27;</span>]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    train_data = f.readlines()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read the content of a remote file as a string</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>train_data = fs.read_text(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/train.csv&quot;</span>, revision=<span class="hljs-string">&quot;dev&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a remote file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> fs.<span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;datasets/my-username/my-dataset-repo/data/validation.csv&quot;</span>, <span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;text,label&quot;</span>)
<span class="hljs-meta">... </span>    f.write(<span class="hljs-string">&quot;Fantastic movie!,good&quot;</span>)`,wrap:!1}}),G=new _e({props:{title:"Integrations",local:"integrations",headingTag:"h2"}}),$=new K({props:{code:"aGYlM0ElMkYlMkYlNUIlM0NyZXBvX3R5cGVfcHJlZml4JTNFJTVEJTNDcmVwb19pZCUzRSU1QiU0MCUzQ3JldmlzaW9uJTNFJTVEJTJGJTNDcGF0aCUyRmluJTJGcmVwbyUzRQ==",highlighted:'hf:<span class="hljs-regexp">//</span>[&lt;repo_type_prefix&gt;]&lt;repo_id&gt;[@&lt;revision&gt;]<span class="hljs-regexp">/&lt;path/i</span>n/repo&gt;',wrap:!1}}),F=new K({props:{code:"aW1wb3J0JTIwcGFuZGFzJTIwYXMlMjBwZCUwQSUwQSUyMyUyMFJlYWQlMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUyMGludG8lMjBhJTIwZGF0YWZyYW1lJTBBZGYlMjAlM0QlMjBwZC5yZWFkX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0cmFpbi5jc3YlMjIpJTBBJTBBJTIzJTIwV3JpdGUlMjBhJTIwZGF0YWZyYW1lJTIwdG8lMjBhJTIwcmVtb3RlJTIwQ1NWJTIwZmlsZSUwQWRmLnRvX2NzdiglMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZ0ZXN0LmNzdiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> pandas <span class="hljs-keyword">as</span> pd

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read a remote CSV file into a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = pd.read_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/train.csv&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write a dataframe to a remote CSV file</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df.to_csv(<span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/test.csv&quot;</span>)`,wrap:!1}}),B=new K({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWltcG9ydCUyMGR1Y2tkYiUwQSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKCklMEFkdWNrZGIucmVnaXN0ZXJfZmlsZXN5c3RlbShmcyklMEElMjMlMjBRdWVyeSUyMGElMjByZW1vdGUlMjBmaWxlJTIwYW5kJTIwZ2V0JTIwdGhlJTIwcmVzdWx0JTIwYmFjayUyMGFzJTIwYSUyMGRhdGFmcmFtZSUwQWZzX3F1ZXJ5X2ZpbGUlMjAlM0QlMjAlMjJoZiUzQSUyRiUyRmRhdGFzZXRzJTJGbXktdXNlcm5hbWUlMkZteS1kYXRhc2V0LXJlcG8lMkZkYXRhX2RpciUyRmRhdGEucGFycXVldCUyMiUwQWRmJTIwJTNEJTIwZHVja2RiLnF1ZXJ5KGYlMjJTRUxFQ1QlMjAqJTIwRlJPTSUyMCclN0Jmc19xdWVyeV9maWxlJTdEJyUyMExJTUlUJTIwMTAlMjIpLmRmKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> duckdb

<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem()
<span class="hljs-meta">&gt;&gt;&gt; </span>duckdb.register_filesystem(fs)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Query a remote file and get the result back as a dataframe</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>fs_query_file = <span class="hljs-string">&quot;hf://datasets/my-username/my-dataset-repo/data_dir/data.parquet&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>df = duckdb.query(<span class="hljs-string">f&quot;SELECT * FROM &#x27;<span class="hljs-subst">{fs_query_file}</span>&#x27; LIMIT 10&quot;</span>).df()`,wrap:!1}}),Y=new K({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBaW1wb3J0JTIwemFyciUwQSUwQWVtYmVkZGluZ3MlMjAlM0QlMjBucC5yYW5kb20ucmFuZG4oNTAwMDAlMkMlMjAxMDAwKS5hc3R5cGUoJTIyZmxvYXQzMiUyMiklMEElMEElMjMlMjBXcml0ZSUyMGFuJTIwYXJyYXklMjB0byUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnclMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZm9vJTIwJTNEJTIwcm9vdC5jcmVhdGVfZ3JvdXAoJTIyZW1iZWRkaW5ncyUyMiklMEElMjAlMjAlMjBmb29iYXIlMjAlM0QlMjBmb28uemVyb3MoJ2V4cGVyaW1lbnRfMCclMkMlMjBzaGFwZSUzRCg1MDAwMCUyQyUyMDEwMDApJTJDJTIwY2h1bmtzJTNEKDEwMDAwJTJDJTIwMTAwMCklMkMlMjBkdHlwZSUzRCdmNCcpJTBBJTIwJTIwJTIwZm9vYmFyJTVCJTNBJTVEJTIwJTNEJTIwZW1iZWRkaW5ncyUwQSUwQSUyMyUyMFJlYWQlMjBhbiUyMGFycmF5JTIwZnJvbSUyMGElMjByZXBvJTBBd2l0aCUyMHphcnIub3Blbl9ncm91cCglMjJoZiUzQSUyRiUyRm15LXVzZXJuYW1lJTJGbXktbW9kZWwtcmVwbyUyRmFycmF5LXN0b3JlJTIyJTJDJTIwbW9kZSUzRCUyMnIlMjIpJTIwYXMlMjByb290JTNBJTBBJTIwJTIwJTIwZmlyc3Rfcm93JTIwJTNEJTIwcm9vdCU1QiUyMmVtYmVkZGluZ3MlMkZleHBlcmltZW50XzAlMjIlNUQlNUIwJTVE",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> zarr

<span class="hljs-meta">&gt;&gt;&gt; </span>embeddings = np.random.randn(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>).astype(<span class="hljs-string">&quot;float32&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Write an array to a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;w&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   foo = root.create_group(<span class="hljs-string">&quot;embeddings&quot;</span>)
<span class="hljs-meta">... </span>   foobar = foo.zeros(<span class="hljs-string">&#x27;experiment_0&#x27;</span>, shape=(<span class="hljs-number">50000</span>, <span class="hljs-number">1000</span>), chunks=(<span class="hljs-number">10000</span>, <span class="hljs-number">1000</span>), dtype=<span class="hljs-string">&#x27;f4&#x27;</span>)
<span class="hljs-meta">... </span>   foobar[:] = embeddings

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Read an array from a repo</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> zarr.open_group(<span class="hljs-string">&quot;hf://my-username/my-model-repo/array-store&quot;</span>, mode=<span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> root:
<span class="hljs-meta">... </span>   first_row = root[<span class="hljs-string">&quot;embeddings/experiment_0&quot;</span>][<span class="hljs-number">0</span>]`,wrap:!1}}),C=new _e({props:{title:"Authentication",local:"authentication",headingTag:"h2"}}),q=new K({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEhmRmlsZVN5c3RlbSUwQWZzJTIwJTNEJTIwSGZGaWxlU3lzdGVtKHRva2VuJTNEdG9rZW4p",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> HfFileSystem
<span class="hljs-meta">&gt;&gt;&gt; </span>fs = HfFileSystem(token=token)`,wrap:!1}}),V=new ts({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/hf_file_system.md"}}),{c(){o=i("meta"),T=l(),u=i("p"),N=l(),c(j.$$.fragment),te=l(),b=i("p"),b.innerHTML=Se,ae=l(),c(M.$$.fragment),le=l(),c(U.$$.fragment),ne=l(),c(k.$$.fragment),ie=l(),Z=i("p"),Z.innerHTML=He,pe=l(),I=i("p"),I.innerHTML=Be,oe=l(),c(G.$$.fragment),me=l(),_=i("p"),_.innerHTML=We,ce=l(),c($.$$.fragment),re=l(),J=i("div"),J.innerHTML=Ye,he=l(),v=i("p"),v.innerHTML=Ce,ge=l(),X=i("p"),X.innerHTML=xe,de=l(),Q=i("ul"),R=i("li"),A=i("p"),A.innerHTML=Ee,$e=l(),c(F.$$.fragment),fe=l(),S=i("p"),S.innerHTML=qe,ue=l(),w=i("ul"),H=i("li"),P=i("p"),P.innerHTML=ze,ve=l(),c(B.$$.fragment),Xe=l(),W=i("li"),D=i("p"),D.innerHTML=Ve,Re=l(),c(Y.$$.fragment),ye=l(),c(C.$$.fragment),Me=l(),x=i("p"),x.innerHTML=Le,Je=l(),E=i("p"),E.innerHTML=Ne,we=l(),c(q.$$.fragment),Te=l(),z=i("p"),z.textContent=Qe,je=l(),c(V.$$.fragment),be=l(),O=i("p"),this.h()},l(e){const s=es("svelte-u9bgzb",document.head);o=p(s,"META",{name:!0,content:!0}),s.forEach(t),T=n(e),u=p(e,"P",{}),L(u).forEach(t),N=n(e),r(j.$$.fragment,e),te=n(e),b=p(e,"P",{"data-svelte-h":!0}),m(b)!=="svelte-1tojfmw"&&(b.innerHTML=Se),ae=n(e),r(M.$$.fragment,e),le=n(e),r(U.$$.fragment,e),ne=n(e),r(k.$$.fragment,e),ie=n(e),Z=p(e,"P",{"data-svelte-h":!0}),m(Z)!=="svelte-fkc5g9"&&(Z.innerHTML=He),pe=n(e),I=p(e,"P",{"data-svelte-h":!0}),m(I)!=="svelte-2xrojz"&&(I.innerHTML=Be),oe=n(e),r(G.$$.fragment,e),me=n(e),_=p(e,"P",{"data-svelte-h":!0}),m(_)!=="svelte-qh16s5"&&(_.innerHTML=We),ce=n(e),r($.$$.fragment,e),re=n(e),J=p(e,"DIV",{class:!0,"data-svelte-h":!0}),m(J)!=="svelte-167v4fl"&&(J.innerHTML=Ye),he=n(e),v=p(e,"P",{"data-svelte-h":!0}),m(v)!=="svelte-1x0g0bv"&&(v.innerHTML=Ce),ge=n(e),X=p(e,"P",{"data-svelte-h":!0}),m(X)!=="svelte-v2qldv"&&(X.innerHTML=xe),de=n(e),Q=p(e,"UL",{});var ee=L(Q);R=p(ee,"LI",{});var ke=L(R);A=p(ke,"P",{"data-svelte-h":!0}),m(A)!=="svelte-8bmxp4"&&(A.innerHTML=Ee),$e=n(ke),r(F.$$.fragment,ke),ke.forEach(t),ee.forEach(t),fe=n(e),S=p(e,"P",{"data-svelte-h":!0}),m(S)!=="svelte-evo4u9"&&(S.innerHTML=qe),ue=n(e),w=p(e,"UL",{});var Ze=L(w);H=p(Ze,"LI",{});var Ie=L(H);P=p(Ie,"P",{"data-svelte-h":!0}),m(P)!=="svelte-14x5nlf"&&(P.innerHTML=ze),ve=n(Ie),r(B.$$.fragment,Ie),Ie.forEach(t),Xe=n(Ze),W=p(Ze,"LI",{});var Ge=L(W);D=p(Ge,"P",{"data-svelte-h":!0}),m(D)!=="svelte-1abwu1e"&&(D.innerHTML=Ve),Re=n(Ge),r(Y.$$.fragment,Ge),Ge.forEach(t),Ze.forEach(t),ye=n(e),r(C.$$.fragment,e),Me=n(e),x=p(e,"P",{"data-svelte-h":!0}),m(x)!=="svelte-kwqcxw"&&(x.innerHTML=Le),Je=n(e),E=p(e,"P",{"data-svelte-h":!0}),m(E)!=="svelte-cxfkyz"&&(E.innerHTML=Ne),we=n(e),r(q.$$.fragment,e),Te=n(e),z=p(e,"P",{"data-svelte-h":!0}),m(z)!=="svelte-172urp9"&&(z.textContent=Qe),je=n(e),r(V.$$.fragment,e),be=n(e),O=p(e,"P",{}),L(O).forEach(t),this.h()},h(){Fe(o,"name","hf:doc:metadata"),Fe(o,"content",ns),Fe(J,"class","flex justify-center")},m(e,s){y(document.head,o),a(e,T,s),a(e,u,s),a(e,N,s),h(j,e,s),a(e,te,s),a(e,b,s),a(e,ae,s),h(M,e,s),a(e,le,s),h(U,e,s),a(e,ne,s),h(k,e,s),a(e,ie,s),a(e,Z,s),a(e,pe,s),a(e,I,s),a(e,oe,s),h(G,e,s),a(e,me,s),a(e,_,s),a(e,ce,s),h($,e,s),a(e,re,s),a(e,J,s),a(e,he,s),a(e,v,s),a(e,ge,s),a(e,X,s),a(e,de,s),a(e,Q,s),y(Q,R),y(R,A),y(R,$e),h(F,R,null),a(e,fe,s),a(e,S,s),a(e,ue,s),a(e,w,s),y(w,H),y(H,P),y(H,ve),h(B,H,null),y(w,Xe),y(w,W),y(W,D),y(W,Re),h(Y,W,null),a(e,ye,s),h(C,e,s),a(e,Me,s),a(e,x,s),a(e,Je,s),a(e,E,s),a(e,we,s),h(q,e,s),a(e,Te,s),a(e,z,s),a(e,je,s),h(V,e,s),a(e,be,s),a(e,O,s),Ue=!0},p(e,[s]){const ee={};s&2&&(ee.$$scope={dirty:s,ctx:e}),M.$set(ee)},i(e){Ue||(g(j.$$.fragment,e),g(M.$$.fragment,e),g(U.$$.fragment,e),g(k.$$.fragment,e),g(G.$$.fragment,e),g($.$$.fragment,e),g(F.$$.fragment,e),g(B.$$.fragment,e),g(Y.$$.fragment,e),g(C.$$.fragment,e),g(q.$$.fragment,e),g(V.$$.fragment,e),Ue=!0)},o(e){d(j.$$.fragment,e),d(M.$$.fragment,e),d(U.$$.fragment,e),d(k.$$.fragment,e),d(G.$$.fragment,e),d($.$$.fragment,e),d(F.$$.fragment,e),d(B.$$.fragment,e),d(Y.$$.fragment,e),d(C.$$.fragment,e),d(q.$$.fragment,e),d(V.$$.fragment,e),Ue=!1},d(e){e&&(t(T),t(u),t(N),t(te),t(b),t(ae),t(le),t(ne),t(ie),t(Z),t(pe),t(I),t(oe),t(me),t(_),t(ce),t(re),t(J),t(he),t(v),t(ge),t(X),t(de),t(Q),t(fe),t(S),t(ue),t(w),t(ye),t(Me),t(x),t(Je),t(E),t(we),t(Te),t(z),t(je),t(be),t(O)),t(o),f(j,e),f(M,e),f(U,e),f(k,e),f(G,e),f($,e),f(F),f(B),f(Y),f(C,e),f(q,e),f(V,e)}}}const ns='{"title":"Interact with the Hub through the Filesystem API","local":"interact-with-the-hub-through-the-filesystem-api","sections":[{"title":"Usage","local":"usage","sections":[],"depth":2},{"title":"Integrations","local":"integrations","sections":[],"depth":2},{"title":"Authentication","local":"authentication","sections":[],"depth":2}],"depth":1}';function is(se){return Pe(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class hs extends Ke{constructor(o){super(),Oe(this,o,is,ls,Ae,{})}}export{hs as component};
