import{s as Nn,o as En,n as Ve}from"../chunks/scheduler.6062bdaf.js";import{S as An,i as Bn,g as d,s,r as o,A as Qn,h as c,f as n,c as i,j as Vn,u as p,x as r,k as Ot,y as Yn,a,v as u,d as g,t as f,w as h}from"../chunks/index.4bca734e.js";import{T as Le}from"../chunks/Tip.b9ac1f03.js";import{C as w}from"../chunks/CodeBlock.cbbddafc.js";import{H as I,E as Sn}from"../chunks/index.fb1f0efe.js";function Fn(j){let l,_=`<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is a Python client making HTTP calls to our APIs. If you want to make the HTTP calls directly using
your preferred tool (curl, postman,…), please refer to the <a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">Inference API</a>
or to the <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> documentation pages.`,m,y,C=`For web development, a <a href="https://huggingface.co/docs/huggingface.js/inference/README" rel="nofollow">JS client</a> has been released.
If you are interested in game development, you might have a look at our <a href="https://github.com/huggingface/unity-api" rel="nofollow">C# project</a>.`;return{c(){l=d("p"),l.innerHTML=_,m=s(),y=d("p"),y.innerHTML=C},l(b){l=c(b,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1be8gtn"&&(l.innerHTML=_),m=i(b),y=c(b,"P",{"data-svelte-h":!0}),r(y)!=="svelte-22w7rm"&&(y.innerHTML=C)},m(b,M){a(b,l,M),a(b,m,M),a(b,y,M)},p:Ve,d(b){b&&(n(l),n(m),n(y))}}}function Xn(j){let l,_=`The API is designed to be simple. Not all parameters and options are available or described for the end user. Check out
<a href="https://huggingface.co/docs/api-inference/detailed_parameters" rel="nofollow">this page</a> if you are interested in learning more about
all the parameters available for each task.`;return{c(){l=d("p"),l.innerHTML=_},l(m){l=c(m,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1o4uc5e"&&(l.innerHTML=_)},m(m,y){a(m,l,y)},p:Ve,d(m){m&&n(l)}}}function zn(j){let l,_=`When using the Hugging Face Inference API (default provider), each task comes with a recommended model from the 200k+ models available on the Hub.
However, this recommendation can change over time, so it’s best to explicitly set a model once you’ve decided which one to use.
For third-party providers, you must always specify a model that is compatible with that provider.`,m,y,C='Visit the <a href="https://huggingface.co/models?inference=warm" rel="nofollow">Models</a> page on the Hub to explore models available through the Inference API, or check the provider’s documentation for their supported models.';return{c(){l=d("p"),l.textContent=_,m=s(),y=d("p"),y.innerHTML=C},l(b){l=c(b,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1bqi6ra"&&(l.textContent=_),m=i(b),y=c(b,"P",{"data-svelte-h":!0}),r(y)!=="svelte-riv991"&&(y.innerHTML=C)},m(b,M){a(b,l,M),a(b,m,M),a(b,y,M)},p:Ve,d(b){b&&(n(l),n(m),n(y))}}}function Rn(j){let l,_='Check out the <a href="https://huggingface.co/tasks" rel="nofollow">Tasks</a> page to learn more about each task.';return{c(){l=d("p"),l.innerHTML=_},l(m){l=c(m,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1odjvkm"&&(l.innerHTML=_)},m(m,y){a(m,l,y)},p:Ve,d(m){m&&n(l)}}}function Pn(j){let l,_='<code>InferenceClient.chat.completions.create</code> is simply an alias for <code>InferenceClient.chat_completion</code>. Check out the package reference of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> for more details. <code>base_url</code> and <code>api_key</code> parameters when instantiating the client are also aliases for <code>model</code> and <code>token</code>. These aliases have been defined to reduce friction when switching from <code>OpenAI</code> to <code>InferenceClient</code>.';return{c(){l=d("p"),l.innerHTML=_},l(m){l=c(m,"P",{"data-svelte-h":!0}),r(l)!=="svelte-1dpcgfo"&&(l.innerHTML=_)},m(m,y){a(m,l,y)},p:Ve,d(m){m&&n(l)}}}function Kn(j){let l,_,m,y,C,b,M,Dt=`Inference is the process of using a trained model to make predictions on new data. Because this process can be compute-intensive, running on a dedicated or external service can be an interesting option.
The <code>huggingface_hub</code> library provides a unified interface to run inference across multiple services for models hosted on the Hugging Face Hub:`,Ne,Z,en='<li><a href="https://huggingface.co/docs/api-inference/index" rel="nofollow">HF Inference API</a>: a serverless solution that allows you to run model inference on Hugging Face’s infrastructure for free. This service is a fast way to get started, test different models, and prototype AI products.</li> <li><a href="#supported-providers-and-tasks">Third-party providers</a>: various serverless solution provided by external providers (Together, Sambanova, etc.). These providers offer production-ready APIs on a pay-as-you-go model. This is the fastest way to integrate AI in your products with a maintenance-free and scalable solution. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.</li> <li><a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a>: a product to easily deploy models to production. Inference is run by Hugging Face in a dedicated, fully managed infrastructure on a cloud provider of your choice.</li>',Ee,W,tn=`These services can all be called from the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> object. It acts as a replacement for the legacy
<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceApi">InferenceApi</a> client, adding specific support for tasks and third-party providers.
Learn how to migrate to the new client in the <a href="#legacy-inferenceapi-client">Legacy InferenceAPI client</a> section.`,Ae,$,Be,x,Qe,q,nn="Let’s get started with a text-to-image task:",Ye,G,Se,H,an=`In the example above, we initialized an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> with a third-party provider, <a href="https://replicate.com/" rel="nofollow">Replicate</a>. When using a provider, you must specify the model you want to use. The model id must be the id of the model on the Hugging Face Hub, not the id of the model from the third-party provider.
In our example, we generated an image from a text prompt. The returned value is a <code>PIL.Image</code> object that can be saved to a file. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a> documentation.`,Fe,L,sn='Let’s now see an example using the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> API. This task uses an LLM to generate a response from a list of messages:',Xe,V,ze,N,ln='In the example above, we used a third-party provider (<a href="https://www.together.ai/" rel="nofollow">Together AI</a>) and specified which model we want to use (<code>&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</code>). We then gave a list of messages to complete (here, a single question) and passed an additional parameter to the API (<code>max_token=100</code>). The output is a <code>ChatCompletionOutput</code> object that follows the OpenAI specification. The generated content can be accessed with <code>output.choices[0].message.content</code>. For more details, check out the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a> documentation.',Re,T,Pe,E,Ke,A,dn='If you want to use a specific provider, you can specify it when initializing the client. The default provider is “hf-inference”, the Hugging Face Serverless Inference API. Refer to the <a href="#supported-providers-and-tasks">Supported providers and tasks</a> section for a list of supported providers.',Oe,B,De,Q,et,Y,cn="What if you want to use a specific model? You can specify it either as a parameter or directly at an instance level:",tt,S,nt,U,at,F,st,X,rn=`The examples we saw above use either the Hugging Face Inference API or third-party providers. While these prove to be very useful for prototyping
and testing things quickly. Once you’re ready to deploy your model to production, you’ll need to use a dedicated infrastructure.
That’s where <a href="https://huggingface.co/docs/inference-endpoints/index" rel="nofollow">Inference Endpoints</a> comes into play. It allows you to deploy
any model and expose it as a private API. Once deployed, you’ll get a URL that you can connect to using exactly the same
code as before, changing only the <code>model</code> parameter:`,it,z,lt,R,on="Note that you cannot specify both a URL and a provider - they are mutually exclusive. URLs are used to connect directly to deployed endpoints.",dt,P,ct,K,pn="Authentication depends on which provider you are using:",rt,O,un='<li>For the default Hugging Face Inference API, you can authenticate using a <a href="https://huggingface.co/docs/hub/security-tokens" rel="nofollow">User Access Token</a>:</li>',ot,D,pt,ee,gn='By default, it will use the token saved on your machine if you are logged in (see <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">how to authenticate</a>).',ut,v,fn="<li>For third-party providers, you have two options:</li>",gt,te,hn="<strong>Direct access to provider</strong>: Use your own API key to interact directly with the provider’s service:",ft,ne,ht,ae,mn=`<strong>Routed through Hugging Face</strong> : Use Hugging Face as a proxy to access third-party providers. Simply specify
your Hugging Face token and the provider you want to use. The calls will be routed through Hugging Face’s infrastructure
using our provider keys, and the usage will be billed directly to your Hugging Face account:`,mt,se,yt,ie,bt,le,yn='<a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>’s goal is to provide the easiest interface to run inference on Hugging Face models, on any provider. It has a simple API that supports the most common tasks. Here is a table showing which providers support which tasks:',_t,de,bn='<thead><tr><th>Task</th> <th>Black Forest Labs</th> <th>Cerebras</th> <th>Cohere</th> <th>fal-ai</th> <th>Fireworks AI</th> <th>HF Inference</th> <th>Hyperbolic</th> <th>Nebius AI Studio</th> <th>Novita AI</th> <th>Replicate</th> <th>Sambanova</th> <th>Together</th></tr></thead> <tbody><tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_classification">audio_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.audio_to_audio">audio_to_audio()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.automatic_speech_recognition">automatic_speech_recognition()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.chat_completion">chat_completion()</a></td> <td>❌</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.document_question_answering">document_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.feature_extraction">feature_extraction()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.fill_mask">fill_mask()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_classification">image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_segmentation">image_segmentation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_image">image_to_image()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.image_to_text">image_to_text()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.object_detection">object_detection()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.question_answering">question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.sentence_similarity">sentence_similarity()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.summarization">summarization()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.table_question_answering">table_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_classification">text_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_generation">text_generation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_image">text_to_image()</a></td> <td>✅</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>✅</td> <td>✅</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>✅</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_speech">text_to_speech()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.text_to_video">text_to_video()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_classification">tabular_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.tabular_regression">tabular_regression()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.token_classification">token_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.translation">translation()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.visual_question_answering">visual_question_answering()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_image_classification">zero_shot_image_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr> <tr><td><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient.zero_shot_classification">zero_shot_classification()</a></td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>✅</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td> <td>❌</td></tr></tbody>',Mt,k,wt,ce,Ct,re,_n='The <code>chat_completion</code> task follows <a href="https://github.com/openai/openai-python" rel="nofollow">OpenAI’s Python client</a> syntax. What does it mean for you? It means that if you are used to play with <code>OpenAI</code>’s APIs you will be able to switch to <code>huggingface_hub.InferenceClient</code> to work with open-source models by updating just 2 line of code!',It,oe,jt,pe,Mn='And that’s it! The only required changes are to replace <code>from openai import OpenAI</code> by <code>from huggingface_hub import InferenceClient</code> and <code>client = OpenAI(...)</code> by <code>client = InferenceClient(...)</code>. You can choose any LLM model from the Hugging Face Hub by passing its model id as <code>model</code> parameter. <a href="https://huggingface.co/models?pipeline_tag=text-generation&amp;other=conversational,text-generation-inference&amp;sort=trending" rel="nofollow">Here is a list</a> of supported models. For authentication, you should pass a valid <a href="https://huggingface.co/settings/tokens" rel="nofollow">User Access Token</a> as <code>api_key</code> or authenticate using <code>huggingface_hub</code> (see the <a href="https://huggingface.co/docs/huggingface_hub/quick-start#authentication" rel="nofollow">authentication guide</a>).',$t,ue,wn='All input parameters and output format are strictly the same. In particular, you can pass <code>stream=True</code> to receive tokens as they are generated. You can also use the <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a> to run inference using <code>asyncio</code>:',Tt,ge,Ut,fe,Cn='You might wonder why using <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> instead of OpenAI’s client? There are a few reasons for that:',vt,he,In='<li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is configured for Hugging Face services. You don’t need to provide a <code>base_url</code> to run models on the serverless Inference API. You also don’t need to provide a <code>token</code> or <code>api_key</code> if your machine is already correctly logged in.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is tailored for both Text-Generation-Inference (TGI) and <code>transformers</code> frameworks, meaning you are assured it will always be on-par with the latest updates.</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> is integrated with our Inference Endpoints service, making it easier to launch an Inference Endpoint, check its status and run inference on it. Check out the <a href="./inference_endpoints.md">Inference Endpoints</a> guide for more details.</li>',kt,J,Jt,me,Zt,ye,jn=`An async version of the client is also provided, based on <code>asyncio</code> and <code>aiohttp</code>. You can either install <code>aiohttp</code>
directly or use the <code>[inference]</code> extra:`,Wt,be,xt,_e,$n=`After installation all async API endpoints are available via <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.AsyncInferenceClient">AsyncInferenceClient</a>. Its initialization and APIs are
strictly the same as the sync-only version.`,qt,Me,Gt,we,Tn='For more information about the <code>asyncio</code> module, please refer to the <a href="https://docs.python.org/3/library/asyncio.html" rel="nofollow">official documentation</a>.',Ht,Ce,Lt,Ie,Un='In the above section, we saw the main aspects of <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>. Let’s dive into some more advanced tips.',Vt,je,Nt,$e,vn='As an HF user, you get monthly credits to run inference through various providers on the Hub. The amount of credits you get depends on your type of account (Free or PRO or Enterprise Hub). You get charged for every inference request, depending on the provider’s pricing table. By default, the requests are billed to your personal account. However, it is possible to set the billing so that requests are charged to an organization you are part of by simply passing <code>bill_to=&quot;&lt;your_org_name&gt;&quot;</code> to <code>InferenceClient</code>. For this to work, your organization must be subscribed to Enterprise Hub. For more details about billing, check out <a href="https://huggingface.co/docs/api-inference/pricing#features-using-inference-providers" rel="nofollow">this guide</a>.',Et,Te,At,Ue,kn="Note that it is NOT possible to charge another user or an organization you are not part of. If you want to grant someone else some credits, you must create a joint organization with them.",Bt,ve,Qt,ke,Jn='Inference calls can take a significant amount of time. By default, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a> will wait “indefinitely” until the inference complete. If you want more control in your workflow, you can set the <code>timeout</code> parameter to a specific value in seconds. If the timeout delay expires, an <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceTimeoutError">InferenceTimeoutError</a> is raised, which you can catch in your code:',Yt,Je,St,Ze,Ft,We,Zn=`Some tasks require binary inputs, for example, when dealing with images or audio files. In this case, <a href="/docs/huggingface_hub/main/en/package_reference/inference_client#huggingface_hub.InferenceClient">InferenceClient</a>
tries to be as permissive as possible and accept different types:`,Xt,xe,Wn=`<li>raw <code>bytes</code></li> <li>a file-like object, opened as binary (<code>with open(&quot;audio.flac&quot;, &quot;rb&quot;) as f: ...</code>)</li> <li>a path (<code>str</code> or <code>Path</code>) pointing to a local file</li> <li>a URL (<code>str</code>) pointing to a remote file (e.g. <code>https://...</code>). In this case, the file will be downloaded locally before
sending it to the Inference API.</li>`,zt,qe,Rt,Ge,Pt,He,Kt;return C=new I({props:{title:"Run Inference on servers",local:"run-inference-on-servers",headingTag:"h1"}}),$=new Le({props:{$$slots:{default:[Fn]},$$scope:{ctx:j}}}),x=new I({props:{title:"Getting started",local:"getting-started",headingTag:"h2"}}),G=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQSUwQXJlcGxpY2F0ZV9jbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBcmVwbGljYXRlX2ltYWdlJTIwJTNEJTIwcmVwbGljYXRlX2NsaWVudC50ZXh0X3RvX2ltYWdlKCUwQXJlcGxpY2F0ZV9pbWFnZS5zYXZlKCUyMmZseWluZ19jYXIucG5nJTIyKSUwQQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient

<span class="hljs-comment"># Example with an external provider (e.g. replicate)</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image = replicate_client.text_to_image(
    <span class="hljs-string">&quot;A flying car crossing a futuristic cityscape.&quot;</span>,
    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>replicate_image.save(<span class="hljs-string">&quot;flying_car.png&quot;</span>)
`,wrap:!1}}),V=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQW1lc3NhZ2VzJTIwJTNEJTIwJTVCJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCUwQWNsaWVudC5jaGF0X2NvbXBsZXRpb24obWVzc2FnZXMlMkMlMjBtYXhfdG9rZW5zJTNEMTAwKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>messages = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: <span class="hljs-string">&quot;What is the capital of France?&quot;</span>,
    }
]
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;together&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    api_key=<span class="hljs-string">&quot;my_together_api_key&quot;</span>,
)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.chat_completion(messages, max_tokens=<span class="hljs-number">100</span>)
ChatCompletionOutput(
    choices=[
        ChatCompletionOutputComplete(
            finish_reason=<span class="hljs-string">&quot;eos_token&quot;</span>,
            index=<span class="hljs-number">0</span>,
            message=ChatCompletionOutputMessage(
                role=<span class="hljs-string">&quot;assistant&quot;</span>, content=<span class="hljs-string">&quot;The capital of France is Paris.&quot;</span>, name=<span class="hljs-literal">None</span>, tool_calls=<span class="hljs-literal">None</span>
            ),
            logprobs=<span class="hljs-literal">None</span>,
        )
    ],
    created=<span class="hljs-number">1719907176</span>,
    <span class="hljs-built_in">id</span>=<span class="hljs-string">&quot;&quot;</span>,
    model=<span class="hljs-string">&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;</span>,
    <span class="hljs-built_in">object</span>=<span class="hljs-string">&quot;text_completion&quot;</span>,
    system_fingerprint=<span class="hljs-string">&quot;2.0.4-sha-f426a33&quot;</span>,
    usage=ChatCompletionOutputUsage(completion_tokens=<span class="hljs-number">8</span>, prompt_tokens=<span class="hljs-number">17</span>, total_tokens=<span class="hljs-number">25</span>),
)`,wrap:!1}}),T=new Le({props:{warning:!0,$$slots:{default:[Xn]},$$scope:{ctx:j}}}),E=new I({props:{title:"Using a specific provider",local:"using-a-specific-provider",headingTag:"h3"}}),B=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMnJlcGxpY2F0ZSUyMiUyQyUyMGFwaV9rZXklM0QlMjJteV9yZXBsaWNhdGVfYXBpX2tleSUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;replicate&quot;</span>, api_key=<span class="hljs-string">&quot;my_replicate_api_key&quot;</span>)`,wrap:!1}}),Q=new I({props:{title:"Using a specific model",local:"using-a-specific-model",headingTag:"h3"}}),S=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMiklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4pJTBBY2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KCklMEFjbGllbnQudGV4dF90b19pbWFnZSguLi4lMkMlMjBtb2RlbCUzRCUyMnByb21wdGhlcm8lMkZvcGVuam91cm5leS12NCUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-comment"># Initialize client for a specific model</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(...)
<span class="hljs-comment"># Or use a generic client but pass your model as an argument</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;prompthero/openjourney-v4&quot;</span>)`,wrap:!1}}),U=new Le({props:{$$slots:{default:[zn]},$$scope:{ctx:j}}}),F=new I({props:{title:"Using a specific URL",local:"using-a-specific-url",headingTag:"h3"}}),z=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChtb2RlbCUzRCUyMmh0dHBzJTNBJTJGJTJGdXUxNDlyZXo2Z3c5ZWhlai5ldS13ZXN0LTEuYXdzLmVuZHBvaW50cy5odWdnaW5nZmFjZS5jbG91ZCUyRmRlZXBmbG95ZC1pZiUyMiklMEFjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoKSUwQWNsaWVudC50ZXh0X3RvX2ltYWdlKC4uLiUyQyUyMG1vZGVsJTNEJTIyaHR0cHMlM0ElMkYlMkZ1dTE0OXJlejZndzllaGVqLmV1LXdlc3QtMS5hd3MuZW5kcG9pbnRzLmh1Z2dpbmdmYWNlLmNsb3VkJTJGZGVlcGZsb3lkLWlmJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)
<span class="hljs-comment"># or</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.text_to_image(..., model=<span class="hljs-string">&quot;https://uu149rez6gw9ehej.eu-west-1.aws.endpoints.huggingface.cloud/deepfloyd-if&quot;</span>)`,wrap:!1}}),P=new I({props:{title:"Authentication",local:"authentication",headingTag:"h3"}}),D=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0b2tlbiUzRCUyMmhmXyoqKiUyMik=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(token=<span class="hljs-string">&quot;hf_***&quot;</span>)`,wrap:!1}}),ne=new w({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    api_key=<span class="hljs-string">&quot;r8_****&quot;</span>  <span class="hljs-comment"># Your Replicate API key</span>
)`,wrap:!1}}),se=new w({props:{code:"Y2xpZW50JTIwJTNEJTIwSW5mZXJlbmNlQ2xpZW50KA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(
    provider=<span class="hljs-string">&quot;replicate&quot;</span>,
    token=<span class="hljs-string">&quot;hf_****&quot;</span>  <span class="hljs-comment"># Your HF token</span>
)`,wrap:!1}}),ie=new I({props:{title:"Supported providers and tasks",local:"supported-providers-and-tasks",headingTag:"h2"}}),k=new Le({props:{$$slots:{default:[Rn]},$$scope:{ctx:j}}}),ce=new I({props:{title:"OpenAI compatibility",local:"openai-compatibility",headingTag:"h2"}}),oe=new w({props:{code:"LSUyMGZyb20lMjBvcGVuYWklMjBpbXBvcnQlMjBPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwSW5mZXJlbmNlQ2xpZW50JTBBJTBBLSUyMGNsaWVudCUyMCUzRCUyME9wZW5BSSglMEElMkIlMjBjbGllbnQlMjAlM0QlMjBJbmZlcmVuY2VDbGllbnQoJTBBJTIwJTIwJTIwJTIwYmFzZV91cmwlM0QuLi4lMkMlMEElMjAlMjAlMjAlMjBhcGlfa2V5JTNELi4uJTJDJTBBKSUwQSUwQSUwQW91dHB1dCUyMCUzRCUyMGNsaWVudC5jaGF0LmNvbXBsZXRpb25zLmNyZWF0ZSglMEElMjAlMjAlMjAlMjBtb2RlbCUzRCUyMm1ldGEtbGxhbWElMkZNZXRhLUxsYW1hLTMtOEItSW5zdHJ1Y3QlMjIlMkMlMEElMjAlMjAlMjAlMjBtZXNzYWdlcyUzRCU1QiUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCU3QiUyMnJvbGUlMjIlM0ElMjAlMjJzeXN0ZW0lMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyQ291bnQlMjB0byUyMDEwJTIyJTdEJTJDJTBBJTIwJTIwJTIwJTIwJTVEJTJDJTBBJTIwJTIwJTIwJTIwc3RyZWFtJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMG1heF90b2tlbnMlM0QxMDI0JTJDJTBBKSUwQSUwQWZvciUyMGNodW5rJTIwaW4lMjBvdXRwdXQlM0ElMEElMjAlMjAlMjAlMjBwcmludChjaHVuay5jaG9pY2VzJTVCMCU1RC5kZWx0YS5jb250ZW50KQ==",highlighted:`<span class="hljs-deletion">- from openai import OpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import InferenceClient</span>

<span class="hljs-deletion">- client = OpenAI(</span>
<span class="hljs-addition">+ client = InferenceClient(</span>
    base_url=...,
    api_key=...,
)


output = client.chat.completions.create(
    model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
    messages=[
        {&quot;role&quot;: &quot;system&quot;, &quot;content&quot;: &quot;You are a helpful assistant.&quot;},
        {&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Count to 10&quot;},
    ],
    stream=True,
    max_tokens=1024,
)

for chunk in output:
    print(chunk.choices[0].delta.content)`,wrap:!1}}),ge=new w({props:{code:"aW1wb3J0JTIwYXN5bmNpbyUwQS0lMjBmcm9tJTIwb3BlbmFpJTIwaW1wb3J0JTIwQXN5bmNPcGVuQUklMEElMkIlMjBmcm9tJTIwaHVnZ2luZ2ZhY2VfaHViJTIwaW1wb3J0JTIwQXN5bmNJbmZlcmVuY2VDbGllbnQlMEElMEEtJTIwY2xpZW50JTIwJTNEJTIwQXN5bmNPcGVuQUkoKSUwQSUyQiUyMGNsaWVudCUyMCUzRCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50KCklMEElMEFhc3luYyUyMGRlZiUyMG1haW4oKSUzQSUwQSUyMCUyMCUyMCUyMHN0cmVhbSUyMCUzRCUyMGF3YWl0JTIwY2xpZW50LmNoYXQuY29tcGxldGlvbnMuY3JlYXRlKCUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1vZGVsJTNEJTIybWV0YS1sbGFtYSUyRk1ldGEtTGxhbWEtMy04Qi1JbnN0cnVjdCUyMiUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMG1lc3NhZ2VzJTNEJTVCJTdCJTIycm9sZSUyMiUzQSUyMCUyMnVzZXIlMjIlMkMlMjAlMjJjb250ZW50JTIyJTNBJTIwJTIyU2F5JTIwdGhpcyUyMGlzJTIwYSUyMHRlc3QlMjIlN0QlNUQlMkMlMEElMjAlMjAlMjAlMjAlMjAlMjAlMjAlMjBzdHJlYW0lM0RUcnVlJTJDJTBBJTIwJTIwJTIwJTIwKSUwQSUyMCUyMCUyMCUyMGFzeW5jJTIwZm9yJTIwY2h1bmslMjBpbiUyMHN0cmVhbSUzQSUwQSUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMHByaW50KGNodW5rLmNob2ljZXMlNUIwJTVELmRlbHRhLmNvbnRlbnQlMjBvciUyMCUyMiUyMiUyQyUyMGVuZCUzRCUyMiUyMiklMEElMEFhc3luY2lvLnJ1bihtYWluKCkp",highlighted:`import asyncio
<span class="hljs-deletion">- from openai import AsyncOpenAI</span>
<span class="hljs-addition">+ from huggingface_hub import AsyncInferenceClient</span>

<span class="hljs-deletion">- client = AsyncOpenAI()</span>
<span class="hljs-addition">+ client = AsyncInferenceClient()</span>

async def main():
    stream = await client.chat.completions.create(
        model=&quot;meta-llama/Meta-Llama-3-8B-Instruct&quot;,
        messages=[{&quot;role&quot;: &quot;user&quot;, &quot;content&quot;: &quot;Say this is a test&quot;}],
        stream=True,
    )
    async for chunk in stream:
        print(chunk.choices[0].delta.content or &quot;&quot;, end=&quot;&quot;)

asyncio.run(main())`,wrap:!1}}),J=new Le({props:{$$slots:{default:[Pn]},$$scope:{ctx:j}}}),me=new I({props:{title:"Async client",local:"async-client",headingTag:"h2"}}),be=new w({props:{code:"cGlwJTIwaW5zdGFsbCUyMC0tdXBncmFkZSUyMGh1Z2dpbmdmYWNlX2h1YiU1QmluZmVyZW5jZSU1RCUwQSUyMyUyMG9yJTBBJTIzJTIwcGlwJTIwaW5zdGFsbCUyMGFpb2h0dHA=",highlighted:`pip install --upgrade huggingface_hub[inference]
<span class="hljs-comment"># or</span>
<span class="hljs-comment"># pip install aiohttp</span>`,wrap:!1}}),Me=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEFzeW5jSW5mZXJlbmNlQ2xpZW50JTBBY2xpZW50JTIwJTNEJTIwQXN5bmNJbmZlcmVuY2VDbGllbnQoKSUwQSUwQWltYWdlJTIwJTNEJTIwYXdhaXQlMjBjbGllbnQudGV4dF90b19pbWFnZSglMjJBbiUyMGFzdHJvbmF1dCUyMHJpZGluZyUyMGElMjBob3JzZSUyMG9uJTIwdGhlJTIwbW9vbi4lMjIpJTBBaW1hZ2Uuc2F2ZSglMjJhc3Ryb25hdXQucG5nJTIyKSUwQSUwQWFzeW5jJTIwZm9yJTIwdG9rZW4lMjBpbiUyMGF3YWl0JTIwY2xpZW50LnRleHRfZ2VuZXJhdGlvbiglMjJUaGUlMjBIdWdnaW5nZmFjZSUyMEh1YiUyMGlzJTIyJTJDJTIwc3RyZWFtJTNEVHJ1ZSklM0ElMEElMjAlMjAlMjAlMjBwcmludCh0b2tlbiUyQyUyMGVuZCUzRCUyMiUyMik=",highlighted:`<span class="hljs-comment"># Code must be run in an asyncio concurrent context.</span>
<span class="hljs-comment"># $ python -m asyncio</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> AsyncInferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = AsyncInferenceClient()

<span class="hljs-meta">&gt;&gt;&gt; </span>image = <span class="hljs-keyword">await</span> client.text_to_image(<span class="hljs-string">&quot;An astronaut riding a horse on the moon.&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;astronaut.png&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">async</span> <span class="hljs-keyword">for</span> token <span class="hljs-keyword">in</span> <span class="hljs-keyword">await</span> client.text_generation(<span class="hljs-string">&quot;The Huggingface Hub is&quot;</span>, stream=<span class="hljs-literal">True</span>):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(token, end=<span class="hljs-string">&quot;&quot;</span>)
 a platform <span class="hljs-keyword">for</span> sharing <span class="hljs-keyword">and</span> discussing ML-related content.`,wrap:!1}}),Ce=new I({props:{title:"Advanced tips",local:"advanced-tips",headingTag:"h2"}}),je=new I({props:{title:"Billing",local:"billing",headingTag:"h3"}}),Te=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudChwcm92aWRlciUzRCUyMmZhbC1haSUyMiUyQyUyMGJpbGxfdG8lM0QlMjJvcGVuYWklMjIpJTBBaW1hZ2UlMjAlM0QlMjBjbGllbnQudGV4dF90b19pbWFnZSglMEElMjAlMjAlMjAlMjAlMjJBJTIwbWFqZXN0aWMlMjBsaW9uJTIwaW4lMjBhJTIwZmFudGFzeSUyMGZvcmVzdCUyMiUyQyUwQSUyMCUyMCUyMCUyMG1vZGVsJTNEJTIyYmxhY2stZm9yZXN0LWxhYnMlMkZGTFVYLjEtc2NobmVsbCUyMiUyQyUwQSklMEFpbWFnZS5zYXZlKCUyMmxpb24ucG5nJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(provider=<span class="hljs-string">&quot;fal-ai&quot;</span>, bill_to=<span class="hljs-string">&quot;openai&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image = client.text_to_image(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;A majestic lion in a fantasy forest&quot;</span>,
<span class="hljs-meta">... </span>    model=<span class="hljs-string">&quot;black-forest-labs/FLUX.1-schnell&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>image.save(<span class="hljs-string">&quot;lion.png&quot;</span>)`,wrap:!1}}),ve=new I({props:{title:"Timeout",local:"timeout",headingTag:"h3"}}),Je=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUyQyUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCh0aW1lb3V0JTNEMzApJTBBdHJ5JTNBJTBBJTIwJTIwJTIwJTIwY2xpZW50LnRleHRfdG9faW1hZ2UoLi4uKSUwQWV4Y2VwdCUyMEluZmVyZW5jZVRpbWVvdXRFcnJvciUzQSUwQSUyMCUyMCUyMCUyMHByaW50KCUyMkluZmVyZW5jZSUyMHRpbWVkJTIwb3V0JTIwYWZ0ZXIlMjAzMHMuJTIyKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient, InferenceTimeoutError
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient(timeout=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">try</span>:
<span class="hljs-meta">... </span>    client.text_to_image(...)
<span class="hljs-meta">... </span><span class="hljs-keyword">except</span> InferenceTimeoutError:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Inference timed out after 30s.&quot;</span>)`,wrap:!1}}),Ze=new I({props:{title:"Binary inputs",local:"binary-inputs",headingTag:"h3"}}),qe=new w({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMEluZmVyZW5jZUNsaWVudCUwQWNsaWVudCUyMCUzRCUyMEluZmVyZW5jZUNsaWVudCgpJTBBY2xpZW50LmltYWdlX2NsYXNzaWZpY2F0aW9uKCUyMmh0dHBzJTNBJTJGJTJGdXBsb2FkLndpa2ltZWRpYS5vcmclMkZ3aWtpcGVkaWElMkZjb21tb25zJTJGdGh1bWIlMkY0JTJGNDMlMkZDdXRlX2RvZy5qcGclMkYzMjBweC1DdXRlX2RvZy5qcGclMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> InferenceClient
<span class="hljs-meta">&gt;&gt;&gt; </span>client = InferenceClient()
<span class="hljs-meta">&gt;&gt;&gt; </span>client.image_classification(<span class="hljs-string">&quot;https://upload.wikimedia.org/wikipedia/commons/thumb/4/43/Cute_dog.jpg/320px-Cute_dog.jpg&quot;</span>)
[{<span class="hljs-string">&#x27;score&#x27;</span>: <span class="hljs-number">0.9779096841812134</span>, <span class="hljs-string">&#x27;label&#x27;</span>: <span class="hljs-string">&#x27;Blenheim spaniel&#x27;</span>}, ...]`,wrap:!1}}),Ge=new Sn({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/inference.md"}}),{c(){l=d("meta"),_=s(),m=d("p"),y=s(),o(C.$$.fragment),b=s(),M=d("p"),M.innerHTML=Dt,Ne=s(),Z=d("ol"),Z.innerHTML=en,Ee=s(),W=d("p"),W.innerHTML=tn,Ae=s(),o($.$$.fragment),Be=s(),o(x.$$.fragment),Qe=s(),q=d("p"),q.textContent=nn,Ye=s(),o(G.$$.fragment),Se=s(),H=d("p"),H.innerHTML=an,Fe=s(),L=d("p"),L.innerHTML=sn,Xe=s(),o(V.$$.fragment),ze=s(),N=d("p"),N.innerHTML=ln,Re=s(),o(T.$$.fragment),Pe=s(),o(E.$$.fragment),Ke=s(),A=d("p"),A.innerHTML=dn,Oe=s(),o(B.$$.fragment),De=s(),o(Q.$$.fragment),et=s(),Y=d("p"),Y.textContent=cn,tt=s(),o(S.$$.fragment),nt=s(),o(U.$$.fragment),at=s(),o(F.$$.fragment),st=s(),X=d("p"),X.innerHTML=rn,it=s(),o(z.$$.fragment),lt=s(),R=d("p"),R.textContent=on,dt=s(),o(P.$$.fragment),ct=s(),K=d("p"),K.textContent=pn,rt=s(),O=d("ol"),O.innerHTML=un,ot=s(),o(D.$$.fragment),pt=s(),ee=d("p"),ee.innerHTML=gn,ut=s(),v=d("ol"),v.innerHTML=fn,gt=s(),te=d("p"),te.innerHTML=hn,ft=s(),o(ne.$$.fragment),ht=s(),ae=d("p"),ae.innerHTML=mn,mt=s(),o(se.$$.fragment),yt=s(),o(ie.$$.fragment),bt=s(),le=d("p"),le.innerHTML=yn,_t=s(),de=d("table"),de.innerHTML=bn,Mt=s(),o(k.$$.fragment),wt=s(),o(ce.$$.fragment),Ct=s(),re=d("p"),re.innerHTML=_n,It=s(),o(oe.$$.fragment),jt=s(),pe=d("p"),pe.innerHTML=Mn,$t=s(),ue=d("p"),ue.innerHTML=wn,Tt=s(),o(ge.$$.fragment),Ut=s(),fe=d("p"),fe.innerHTML=Cn,vt=s(),he=d("ol"),he.innerHTML=In,kt=s(),o(J.$$.fragment),Jt=s(),o(me.$$.fragment),Zt=s(),ye=d("p"),ye.innerHTML=jn,Wt=s(),o(be.$$.fragment),xt=s(),_e=d("p"),_e.innerHTML=$n,qt=s(),o(Me.$$.fragment),Gt=s(),we=d("p"),we.innerHTML=Tn,Ht=s(),o(Ce.$$.fragment),Lt=s(),Ie=d("p"),Ie.innerHTML=Un,Vt=s(),o(je.$$.fragment),Nt=s(),$e=d("p"),$e.innerHTML=vn,Et=s(),o(Te.$$.fragment),At=s(),Ue=d("p"),Ue.textContent=kn,Bt=s(),o(ve.$$.fragment),Qt=s(),ke=d("p"),ke.innerHTML=Jn,Yt=s(),o(Je.$$.fragment),St=s(),o(Ze.$$.fragment),Ft=s(),We=d("p"),We.innerHTML=Zn,Xt=s(),xe=d("ul"),xe.innerHTML=Wn,zt=s(),o(qe.$$.fragment),Rt=s(),o(Ge.$$.fragment),Pt=s(),He=d("p"),this.h()},l(e){const t=Qn("svelte-u9bgzb",document.head);l=c(t,"META",{name:!0,content:!0}),t.forEach(n),_=i(e),m=c(e,"P",{}),Vn(m).forEach(n),y=i(e),p(C.$$.fragment,e),b=i(e),M=c(e,"P",{"data-svelte-h":!0}),r(M)!=="svelte-zsbuba"&&(M.innerHTML=Dt),Ne=i(e),Z=c(e,"OL",{"data-svelte-h":!0}),r(Z)!=="svelte-1x7s1wa"&&(Z.innerHTML=en),Ee=i(e),W=c(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1vbf08n"&&(W.innerHTML=tn),Ae=i(e),p($.$$.fragment,e),Be=i(e),p(x.$$.fragment,e),Qe=i(e),q=c(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-8lplub"&&(q.textContent=nn),Ye=i(e),p(G.$$.fragment,e),Se=i(e),H=c(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-181xjky"&&(H.innerHTML=an),Fe=i(e),L=c(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-1d6dn6"&&(L.innerHTML=sn),Xe=i(e),p(V.$$.fragment,e),ze=i(e),N=c(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-19dgkah"&&(N.innerHTML=ln),Re=i(e),p(T.$$.fragment,e),Pe=i(e),p(E.$$.fragment,e),Ke=i(e),A=c(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-ukpcrh"&&(A.innerHTML=dn),Oe=i(e),p(B.$$.fragment,e),De=i(e),p(Q.$$.fragment,e),et=i(e),Y=c(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-1npu22n"&&(Y.textContent=cn),tt=i(e),p(S.$$.fragment,e),nt=i(e),p(U.$$.fragment,e),at=i(e),p(F.$$.fragment,e),st=i(e),X=c(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-u8akyu"&&(X.innerHTML=rn),it=i(e),p(z.$$.fragment,e),lt=i(e),R=c(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-1yhw21f"&&(R.textContent=on),dt=i(e),p(P.$$.fragment,e),ct=i(e),K=c(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-1gwnv0n"&&(K.textContent=pn),rt=i(e),O=c(e,"OL",{"data-svelte-h":!0}),r(O)!=="svelte-1luo03y"&&(O.innerHTML=un),ot=i(e),p(D.$$.fragment,e),pt=i(e),ee=c(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-cgnawa"&&(ee.innerHTML=gn),ut=i(e),v=c(e,"OL",{start:!0,"data-svelte-h":!0}),r(v)!=="svelte-11t1tnm"&&(v.innerHTML=fn),gt=i(e),te=c(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-zxs6jj"&&(te.innerHTML=hn),ft=i(e),p(ne.$$.fragment,e),ht=i(e),ae=c(e,"P",{"data-svelte-h":!0}),r(ae)!=="svelte-y7q25h"&&(ae.innerHTML=mn),mt=i(e),p(se.$$.fragment,e),yt=i(e),p(ie.$$.fragment,e),bt=i(e),le=c(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-qhknp8"&&(le.innerHTML=yn),_t=i(e),de=c(e,"TABLE",{"data-svelte-h":!0}),r(de)!=="svelte-1vb91nf"&&(de.innerHTML=bn),Mt=i(e),p(k.$$.fragment,e),wt=i(e),p(ce.$$.fragment,e),Ct=i(e),re=c(e,"P",{"data-svelte-h":!0}),r(re)!=="svelte-bmxago"&&(re.innerHTML=_n),It=i(e),p(oe.$$.fragment,e),jt=i(e),pe=c(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-94ddrt"&&(pe.innerHTML=Mn),$t=i(e),ue=c(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1wef96y"&&(ue.innerHTML=wn),Tt=i(e),p(ge.$$.fragment,e),Ut=i(e),fe=c(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-u2g99k"&&(fe.innerHTML=Cn),vt=i(e),he=c(e,"OL",{"data-svelte-h":!0}),r(he)!=="svelte-1oyc4dd"&&(he.innerHTML=In),kt=i(e),p(J.$$.fragment,e),Jt=i(e),p(me.$$.fragment,e),Zt=i(e),ye=c(e,"P",{"data-svelte-h":!0}),r(ye)!=="svelte-1gqwj00"&&(ye.innerHTML=jn),Wt=i(e),p(be.$$.fragment,e),xt=i(e),_e=c(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-1bdjfju"&&(_e.innerHTML=$n),qt=i(e),p(Me.$$.fragment,e),Gt=i(e),we=c(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-q492az"&&(we.innerHTML=Tn),Ht=i(e),p(Ce.$$.fragment,e),Lt=i(e),Ie=c(e,"P",{"data-svelte-h":!0}),r(Ie)!=="svelte-2b1sa3"&&(Ie.innerHTML=Un),Vt=i(e),p(je.$$.fragment,e),Nt=i(e),$e=c(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-6rcpvw"&&($e.innerHTML=vn),Et=i(e),p(Te.$$.fragment,e),At=i(e),Ue=c(e,"P",{"data-svelte-h":!0}),r(Ue)!=="svelte-1hpvtqi"&&(Ue.textContent=kn),Bt=i(e),p(ve.$$.fragment,e),Qt=i(e),ke=c(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-t8yvyu"&&(ke.innerHTML=Jn),Yt=i(e),p(Je.$$.fragment,e),St=i(e),p(Ze.$$.fragment,e),Ft=i(e),We=c(e,"P",{"data-svelte-h":!0}),r(We)!=="svelte-4hhs15"&&(We.innerHTML=Zn),Xt=i(e),xe=c(e,"UL",{"data-svelte-h":!0}),r(xe)!=="svelte-vaeuct"&&(xe.innerHTML=Wn),zt=i(e),p(qe.$$.fragment,e),Rt=i(e),p(Ge.$$.fragment,e),Pt=i(e),He=c(e,"P",{}),Vn(He).forEach(n),this.h()},h(){Ot(l,"name","hf:doc:metadata"),Ot(l,"content",On),Ot(v,"start","2")},m(e,t){Yn(document.head,l),a(e,_,t),a(e,m,t),a(e,y,t),u(C,e,t),a(e,b,t),a(e,M,t),a(e,Ne,t),a(e,Z,t),a(e,Ee,t),a(e,W,t),a(e,Ae,t),u($,e,t),a(e,Be,t),u(x,e,t),a(e,Qe,t),a(e,q,t),a(e,Ye,t),u(G,e,t),a(e,Se,t),a(e,H,t),a(e,Fe,t),a(e,L,t),a(e,Xe,t),u(V,e,t),a(e,ze,t),a(e,N,t),a(e,Re,t),u(T,e,t),a(e,Pe,t),u(E,e,t),a(e,Ke,t),a(e,A,t),a(e,Oe,t),u(B,e,t),a(e,De,t),u(Q,e,t),a(e,et,t),a(e,Y,t),a(e,tt,t),u(S,e,t),a(e,nt,t),u(U,e,t),a(e,at,t),u(F,e,t),a(e,st,t),a(e,X,t),a(e,it,t),u(z,e,t),a(e,lt,t),a(e,R,t),a(e,dt,t),u(P,e,t),a(e,ct,t),a(e,K,t),a(e,rt,t),a(e,O,t),a(e,ot,t),u(D,e,t),a(e,pt,t),a(e,ee,t),a(e,ut,t),a(e,v,t),a(e,gt,t),a(e,te,t),a(e,ft,t),u(ne,e,t),a(e,ht,t),a(e,ae,t),a(e,mt,t),u(se,e,t),a(e,yt,t),u(ie,e,t),a(e,bt,t),a(e,le,t),a(e,_t,t),a(e,de,t),a(e,Mt,t),u(k,e,t),a(e,wt,t),u(ce,e,t),a(e,Ct,t),a(e,re,t),a(e,It,t),u(oe,e,t),a(e,jt,t),a(e,pe,t),a(e,$t,t),a(e,ue,t),a(e,Tt,t),u(ge,e,t),a(e,Ut,t),a(e,fe,t),a(e,vt,t),a(e,he,t),a(e,kt,t),u(J,e,t),a(e,Jt,t),u(me,e,t),a(e,Zt,t),a(e,ye,t),a(e,Wt,t),u(be,e,t),a(e,xt,t),a(e,_e,t),a(e,qt,t),u(Me,e,t),a(e,Gt,t),a(e,we,t),a(e,Ht,t),u(Ce,e,t),a(e,Lt,t),a(e,Ie,t),a(e,Vt,t),u(je,e,t),a(e,Nt,t),a(e,$e,t),a(e,Et,t),u(Te,e,t),a(e,At,t),a(e,Ue,t),a(e,Bt,t),u(ve,e,t),a(e,Qt,t),a(e,ke,t),a(e,Yt,t),u(Je,e,t),a(e,St,t),u(Ze,e,t),a(e,Ft,t),a(e,We,t),a(e,Xt,t),a(e,xe,t),a(e,zt,t),u(qe,e,t),a(e,Rt,t),u(Ge,e,t),a(e,Pt,t),a(e,He,t),Kt=!0},p(e,[t]){const xn={};t&2&&(xn.$$scope={dirty:t,ctx:e}),$.$set(xn);const qn={};t&2&&(qn.$$scope={dirty:t,ctx:e}),T.$set(qn);const Gn={};t&2&&(Gn.$$scope={dirty:t,ctx:e}),U.$set(Gn);const Hn={};t&2&&(Hn.$$scope={dirty:t,ctx:e}),k.$set(Hn);const Ln={};t&2&&(Ln.$$scope={dirty:t,ctx:e}),J.$set(Ln)},i(e){Kt||(g(C.$$.fragment,e),g($.$$.fragment,e),g(x.$$.fragment,e),g(G.$$.fragment,e),g(V.$$.fragment,e),g(T.$$.fragment,e),g(E.$$.fragment,e),g(B.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(U.$$.fragment,e),g(F.$$.fragment,e),g(z.$$.fragment,e),g(P.$$.fragment,e),g(D.$$.fragment,e),g(ne.$$.fragment,e),g(se.$$.fragment,e),g(ie.$$.fragment,e),g(k.$$.fragment,e),g(ce.$$.fragment,e),g(oe.$$.fragment,e),g(ge.$$.fragment,e),g(J.$$.fragment,e),g(me.$$.fragment,e),g(be.$$.fragment,e),g(Me.$$.fragment,e),g(Ce.$$.fragment,e),g(je.$$.fragment,e),g(Te.$$.fragment,e),g(ve.$$.fragment,e),g(Je.$$.fragment,e),g(Ze.$$.fragment,e),g(qe.$$.fragment,e),g(Ge.$$.fragment,e),Kt=!0)},o(e){f(C.$$.fragment,e),f($.$$.fragment,e),f(x.$$.fragment,e),f(G.$$.fragment,e),f(V.$$.fragment,e),f(T.$$.fragment,e),f(E.$$.fragment,e),f(B.$$.fragment,e),f(Q.$$.fragment,e),f(S.$$.fragment,e),f(U.$$.fragment,e),f(F.$$.fragment,e),f(z.$$.fragment,e),f(P.$$.fragment,e),f(D.$$.fragment,e),f(ne.$$.fragment,e),f(se.$$.fragment,e),f(ie.$$.fragment,e),f(k.$$.fragment,e),f(ce.$$.fragment,e),f(oe.$$.fragment,e),f(ge.$$.fragment,e),f(J.$$.fragment,e),f(me.$$.fragment,e),f(be.$$.fragment,e),f(Me.$$.fragment,e),f(Ce.$$.fragment,e),f(je.$$.fragment,e),f(Te.$$.fragment,e),f(ve.$$.fragment,e),f(Je.$$.fragment,e),f(Ze.$$.fragment,e),f(qe.$$.fragment,e),f(Ge.$$.fragment,e),Kt=!1},d(e){e&&(n(_),n(m),n(y),n(b),n(M),n(Ne),n(Z),n(Ee),n(W),n(Ae),n(Be),n(Qe),n(q),n(Ye),n(Se),n(H),n(Fe),n(L),n(Xe),n(ze),n(N),n(Re),n(Pe),n(Ke),n(A),n(Oe),n(De),n(et),n(Y),n(tt),n(nt),n(at),n(st),n(X),n(it),n(lt),n(R),n(dt),n(ct),n(K),n(rt),n(O),n(ot),n(pt),n(ee),n(ut),n(v),n(gt),n(te),n(ft),n(ht),n(ae),n(mt),n(yt),n(bt),n(le),n(_t),n(de),n(Mt),n(wt),n(Ct),n(re),n(It),n(jt),n(pe),n($t),n(ue),n(Tt),n(Ut),n(fe),n(vt),n(he),n(kt),n(Jt),n(Zt),n(ye),n(Wt),n(xt),n(_e),n(qt),n(Gt),n(we),n(Ht),n(Lt),n(Ie),n(Vt),n(Nt),n($e),n(Et),n(At),n(Ue),n(Bt),n(Qt),n(ke),n(Yt),n(St),n(Ft),n(We),n(Xt),n(xe),n(zt),n(Rt),n(Pt),n(He)),n(l),h(C,e),h($,e),h(x,e),h(G,e),h(V,e),h(T,e),h(E,e),h(B,e),h(Q,e),h(S,e),h(U,e),h(F,e),h(z,e),h(P,e),h(D,e),h(ne,e),h(se,e),h(ie,e),h(k,e),h(ce,e),h(oe,e),h(ge,e),h(J,e),h(me,e),h(be,e),h(Me,e),h(Ce,e),h(je,e),h(Te,e),h(ve,e),h(Je,e),h(Ze,e),h(qe,e),h(Ge,e)}}}const On='{"title":"Run Inference on servers","local":"run-inference-on-servers","sections":[{"title":"Getting started","local":"getting-started","sections":[{"title":"Using a specific provider","local":"using-a-specific-provider","sections":[],"depth":3},{"title":"Using a specific model","local":"using-a-specific-model","sections":[],"depth":3},{"title":"Using a specific URL","local":"using-a-specific-url","sections":[],"depth":3},{"title":"Authentication","local":"authentication","sections":[],"depth":3}],"depth":2},{"title":"Supported providers and tasks","local":"supported-providers-and-tasks","sections":[],"depth":2},{"title":"OpenAI compatibility","local":"openai-compatibility","sections":[],"depth":2},{"title":"Async client","local":"async-client","sections":[],"depth":2},{"title":"Advanced tips","local":"advanced-tips","sections":[{"title":"Billing","local":"billing","sections":[],"depth":3},{"title":"Timeout","local":"timeout","sections":[],"depth":3},{"title":"Binary inputs","local":"binary-inputs","sections":[],"depth":3}],"depth":2}],"depth":1}';function Dn(j){return En(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ia extends An{constructor(l){super(),Bn(this,l,Dn,Kn,Nn,{})}}export{ia as component};
