import{s as Ut,n as It,o as Ct}from"../chunks/scheduler.85c25b89.js";import{S as $t,i as kt,g as p,s as a,r as i,A as Zt,h as m,f as e,c as n,j as ft,u as o,x as y,k as bt,y as Wt,a as l,v as c,d as r,t as h,w as M}from"../chunks/index.c9837788.js";import{C as Q}from"../chunks/CodeBlock.52fa569e.js";import{H as _}from"../chunks/Heading.3097d2ed.js";function Nt(rt){let d,v,R,S,g,Y,w,ht='<strong>SE ResNet</strong> is a variant of a <a href="https://www.paperswithcode.com/method/resnet" rel="nofollow">ResNet</a> that employs <a href="https://paperswithcode.com/method/squeeze-and-excitation-block" rel="nofollow">squeeze-and-excitation blocks</a> to enable the network to perform dynamic channel-wise feature recalibration.',z,J,F,j,Mt="To load a pretrained model:",H,u,A,T,yt="To load and preprocess the image:",L,f,q,b,dt="To get the model predictions:",D,U,P,I,gt="To get the top-5 predictions class names:",K,C,O,$,wt="Replace the model name with the variant you want to use, e.g. <code>legacy_seresnet101</code>. You can find the IDs in the model summaries at the top of this page.",tt,k,Jt='To extract image features with this model, follow the <a href="../feature_extraction">timm feature extraction examples</a>, just change the name of the model you want to use.',st,Z,et,W,jt="You can finetune any of the pre-trained models just by changing the classifier (the last layer).",lt,N,at,B,ut=`To finetune on your own dataset, you have to write a training loop or adapt <a href="https://github.com/rwightman/pytorch-image-models/blob/master/train.py" rel="nofollow">timm’s training
script</a> to use your dataset.`,nt,x,pt,G,Tt='You can follow the <a href="../scripts">timm recipe scripts</a> for training a new model afresh.',mt,E,it,V,ot,X,ct;return g=new _({props:{title:"(Legacy) SE-ResNet",local:"legacy-se-resnet",headingTag:"h1"}}),J=new _({props:{title:"How do I use this model on an image?",local:"how-do-i-use-this-model-on-an-image",headingTag:"h2"}}),u=new Q({props:{code:"aW1wb3J0JTIwdGltbSUwQW1vZGVsJTIwJTNEJTIwdGltbS5jcmVhdGVfbW9kZWwoJ2xlZ2FjeV9zZXJlc25ldDEwMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFtb2RlbC5ldmFsKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnet101&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>model.<span class="hljs-built_in">eval</span>()`,wrap:!1}}),f=new Q({props:{code:"aW1wb3J0JTIwdXJsbGliJTBBZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBZnJvbSUyMHRpbW0uZGF0YSUyMGltcG9ydCUyMHJlc29sdmVfZGF0YV9jb25maWclMEFmcm9tJTIwdGltbS5kYXRhLnRyYW5zZm9ybXNfZmFjdG9yeSUyMGltcG9ydCUyMGNyZWF0ZV90cmFuc2Zvcm0lMEElMEFjb25maWclMjAlM0QlMjByZXNvbHZlX2RhdGFfY29uZmlnKCU3QiU3RCUyQyUyMG1vZGVsJTNEbW9kZWwpJTBBdHJhbnNmb3JtJTIwJTNEJTIwY3JlYXRlX3RyYW5zZm9ybSgqKmNvbmZpZyklMEElMEF1cmwlMkMlMjBmaWxlbmFtZSUyMCUzRCUyMCglMjJodHRwcyUzQSUyRiUyRmdpdGh1Yi5jb20lMkZweXRvcmNoJTJGaHViJTJGcmF3JTJGbWFzdGVyJTJGaW1hZ2VzJTJGZG9nLmpwZyUyMiUyQyUyMCUyMmRvZy5qcGclMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTBBaW1nJTIwJTNEJTIwSW1hZ2Uub3BlbihmaWxlbmFtZSkuY29udmVydCgnUkdCJyklMEF0ZW5zb3IlMjAlM0QlMjB0cmFuc2Zvcm0oaW1nKS51bnNxdWVlemUoMCklMjAlMjMlMjB0cmFuc2Zvcm0lMjBhbmQlMjBhZGQlMjBiYXRjaCUyMGRpbWVuc2lvbg==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> urllib
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data <span class="hljs-keyword">import</span> resolve_data_config
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> timm.data.transforms_factory <span class="hljs-keyword">import</span> create_transform

<span class="hljs-meta">&gt;&gt;&gt; </span>config = resolve_data_config({}, model=model)
<span class="hljs-meta">&gt;&gt;&gt; </span>transform = create_transform(**config)

<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://github.com/pytorch/hub/raw/master/images/dog.jpg&quot;</span>, <span class="hljs-string">&quot;dog.jpg&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename)
<span class="hljs-meta">&gt;&gt;&gt; </span>img = Image.<span class="hljs-built_in">open</span>(filename).convert(<span class="hljs-string">&#x27;RGB&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>tensor = transform(img).unsqueeze(<span class="hljs-number">0</span>) <span class="hljs-comment"># transform and add batch dimension</span>`,wrap:!1}}),U=new Q({props:{code:"aW1wb3J0JTIwdG9yY2glMEF3aXRoJTIwdG9yY2gubm9fZ3JhZCgpJTNBJTBBJTIwJTIwJTIwJTIwb3V0JTIwJTNEJTIwbW9kZWwodGVuc29yKSUwQXByb2JhYmlsaXRpZXMlMjAlM0QlMjB0b3JjaC5ubi5mdW5jdGlvbmFsLnNvZnRtYXgob3V0JTVCMCU1RCUyQyUyMGRpbSUzRDApJTBBcHJpbnQocHJvYmFiaWxpdGllcy5zaGFwZSklMEElMjMlMjBwcmludHMlM0ElMjB0b3JjaC5TaXplKCU1QjEwMDAlNUQp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> torch.no_grad():
<span class="hljs-meta">... </span>    out = model(tensor)
<span class="hljs-meta">&gt;&gt;&gt; </span>probabilities = torch.nn.functional.softmax(out[<span class="hljs-number">0</span>], dim=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(probabilities.shape)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints: torch.Size([1000])</span>`,wrap:!1}}),C=new Q({props:{code:"JTIzJTIwR2V0JTIwaW1hZ2VuZXQlMjBjbGFzcyUyMG1hcHBpbmdzJTBBdXJsJTJDJTIwZmlsZW5hbWUlMjAlM0QlMjAoJTIyaHR0cHMlM0ElMkYlMkZyYXcuZ2l0aHVidXNlcmNvbnRlbnQuY29tJTJGcHl0b3JjaCUyRmh1YiUyRm1hc3RlciUyRmltYWdlbmV0X2NsYXNzZXMudHh0JTIyJTJDJTIwJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIpJTBBdXJsbGliLnJlcXVlc3QudXJscmV0cmlldmUodXJsJTJDJTIwZmlsZW5hbWUpJTIwJTBBd2l0aCUyMG9wZW4oJTIyaW1hZ2VuZXRfY2xhc3Nlcy50eHQlMjIlMkMlMjAlMjJyJTIyKSUyMGFzJTIwZiUzQSUwQSUyMCUyMCUyMCUyMGNhdGVnb3JpZXMlMjAlM0QlMjAlNUJzLnN0cmlwKCklMjBmb3IlMjBzJTIwaW4lMjBmLnJlYWRsaW5lcygpJTVEJTBBJTBBJTIzJTIwUHJpbnQlMjB0b3AlMjBjYXRlZ29yaWVzJTIwcGVyJTIwaW1hZ2UlMEF0b3A1X3Byb2IlMkMlMjB0b3A1X2NhdGlkJTIwJTNEJTIwdG9yY2gudG9wayhwcm9iYWJpbGl0aWVzJTJDJTIwNSklMEFmb3IlMjBpJTIwaW4lMjByYW5nZSh0b3A1X3Byb2Iuc2l6ZSgwKSklM0ElMEElMjAlMjAlMjAlMjBwcmludChjYXRlZ29yaWVzJTVCdG9wNV9jYXRpZCU1QmklNUQlNUQlMkMlMjB0b3A1X3Byb2IlNUJpJTVELml0ZW0oKSklMEElMjMlMjBwcmludHMlMjBjbGFzcyUyMG5hbWVzJTIwYW5kJTIwcHJvYmFiaWxpdGllcyUyMGxpa2UlM0ElMEElMjMlMjAlNUIoJ1NhbW95ZWQnJTJDJTIwMC42NDI1MTk2NTI4NDM0NzUzKSUyQyUyMCgnUG9tZXJhbmlhbiclMkMlMjAwLjA0MDYyMTAyMzYyNTEzNTQyKSUyQyUyMCgna2Vlc2hvbmQnJTJDJTIwMC4wMzE4NjQyNDQ0OTA4NjE4OSklMkMlMjAoJ3doaXRlJTIwd29sZiclMkMlMjAwLjAxNzM5Njc2Mjk2NzEwOTY4KSUyQyUyMCgnRXNraW1vJTIwZG9nJyUyQyUyMDAuMDExNzE3OTQ3MTk5OTQwNjgxKSU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Get imagenet class mappings</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url, filename = (<span class="hljs-string">&quot;https://raw.githubusercontent.com/pytorch/hub/master/imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>urllib.request.urlretrieve(url, filename) 
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;imagenet_classes.txt&quot;</span>, <span class="hljs-string">&quot;r&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>    categories = [s.strip() <span class="hljs-keyword">for</span> s <span class="hljs-keyword">in</span> f.readlines()]

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Print top categories per image</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>top5_prob, top5_catid = torch.topk(probabilities, <span class="hljs-number">5</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> i <span class="hljs-keyword">in</span> <span class="hljs-built_in">range</span>(top5_prob.size(<span class="hljs-number">0</span>)):
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(categories[top5_catid[i]], top5_prob[i].item())
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># prints class names and probabilities like:</span>
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># [(&#x27;Samoyed&#x27;, 0.6425196528434753), (&#x27;Pomeranian&#x27;, 0.04062102362513542), (&#x27;keeshond&#x27;, 0.03186424449086189), (&#x27;white wolf&#x27;, 0.01739676296710968), (&#x27;Eskimo dog&#x27;, 0.011717947199940681)]</span>`,wrap:!1}}),Z=new _({props:{title:"How do I finetune this model?",local:"how-do-i-finetune-this-model",headingTag:"h2"}}),N=new Q({props:{code:"bW9kZWwlMjAlM0QlMjB0aW1tLmNyZWF0ZV9tb2RlbCgnbGVnYWN5X3NlcmVzbmV0MTAxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlJTJDJTIwbnVtX2NsYXNzZXMlM0ROVU1fRklORVRVTkVfQ0xBU1NFUyk=",highlighted:'<span class="hljs-meta">&gt;&gt;&gt; </span>model = timm.create_model(<span class="hljs-string">&#x27;legacy_seresnet101&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=NUM_FINETUNE_CLASSES)',wrap:!1}}),x=new _({props:{title:"How do I train this model?",local:"how-do-i-train-this-model",headingTag:"h2"}}),E=new _({props:{title:"Citation",local:"citation",headingTag:"h2"}}),V=new Q({props:{code:"JTQwbWlzYyU3Qmh1MjAxOXNxdWVlemVhbmRleGNpdGF0aW9uJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwdGl0bGUlM0QlN0JTcXVlZXplLWFuZC1FeGNpdGF0aW9uJTIwTmV0d29ya3MlN0QlMkMlMjAlMEElMjAlMjAlMjAlMjAlMjAlMjBhdXRob3IlM0QlN0JKaWUlMjBIdSUyMGFuZCUyMExpJTIwU2hlbiUyMGFuZCUyMFNhbXVlbCUyMEFsYmFuaWUlMjBhbmQlMjBHYW5nJTIwU3VuJTIwYW5kJTIwRW5odWElMjBXdSU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHllYXIlM0QlN0IyMDE5JTdEJTJDJTBBJTIwJTIwJTIwJTIwJTIwJTIwZXByaW50JTNEJTdCMTcwOS4wMTUwNyU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMGFyY2hpdmVQcmVmaXglM0QlN0JhclhpdiU3RCUyQyUwQSUyMCUyMCUyMCUyMCUyMCUyMHByaW1hcnlDbGFzcyUzRCU3QmNzLkNWJTdEJTBBJTdE",highlighted:`@misc{hu2019squeezeandexcitation,
      title={Squeeze-<span class="hljs-keyword">and-Excitation </span>Networks}, 
      author={<span class="hljs-keyword">Jie </span>Hu <span class="hljs-keyword">and </span>Li <span class="hljs-keyword">Shen </span><span class="hljs-keyword">and </span>Samuel Albanie <span class="hljs-keyword">and </span>Gang Sun <span class="hljs-keyword">and </span>Enhua Wu},
      year={<span class="hljs-number">2019</span>},
      eprint={<span class="hljs-number">1709</span>.<span class="hljs-number">01507</span>},
      archivePrefix={arXiv},
      primaryClass={cs.CV}
}`,wrap:!1}}),{c(){d=p("meta"),v=a(),R=p("p"),S=a(),i(g.$$.fragment),Y=a(),w=p("p"),w.innerHTML=ht,z=a(),i(J.$$.fragment),F=a(),j=p("p"),j.textContent=Mt,H=a(),i(u.$$.fragment),A=a(),T=p("p"),T.textContent=yt,L=a(),i(f.$$.fragment),q=a(),b=p("p"),b.textContent=dt,D=a(),i(U.$$.fragment),P=a(),I=p("p"),I.textContent=gt,K=a(),i(C.$$.fragment),O=a(),$=p("p"),$.innerHTML=wt,tt=a(),k=p("p"),k.innerHTML=Jt,st=a(),i(Z.$$.fragment),et=a(),W=p("p"),W.textContent=jt,lt=a(),i(N.$$.fragment),at=a(),B=p("p"),B.innerHTML=ut,nt=a(),i(x.$$.fragment),pt=a(),G=p("p"),G.innerHTML=Tt,mt=a(),i(E.$$.fragment),it=a(),i(V.$$.fragment),ot=a(),X=p("p"),this.h()},l(t){const s=Zt("svelte-u9bgzb",document.head);d=m(s,"META",{name:!0,content:!0}),s.forEach(e),v=n(t),R=m(t,"P",{}),ft(R).forEach(e),S=n(t),o(g.$$.fragment,t),Y=n(t),w=m(t,"P",{"data-svelte-h":!0}),y(w)!=="svelte-1b8qp0g"&&(w.innerHTML=ht),z=n(t),o(J.$$.fragment,t),F=n(t),j=m(t,"P",{"data-svelte-h":!0}),y(j)!=="svelte-18ywhxh"&&(j.textContent=Mt),H=n(t),o(u.$$.fragment,t),A=n(t),T=m(t,"P",{"data-svelte-h":!0}),y(T)!=="svelte-1c2ipa8"&&(T.textContent=yt),L=n(t),o(f.$$.fragment,t),q=n(t),b=m(t,"P",{"data-svelte-h":!0}),y(b)!=="svelte-1n9qsq1"&&(b.textContent=dt),D=n(t),o(U.$$.fragment,t),P=n(t),I=m(t,"P",{"data-svelte-h":!0}),y(I)!=="svelte-19cnvx1"&&(I.textContent=gt),K=n(t),o(C.$$.fragment,t),O=n(t),$=m(t,"P",{"data-svelte-h":!0}),y($)!=="svelte-ez0uq1"&&($.innerHTML=wt),tt=n(t),k=m(t,"P",{"data-svelte-h":!0}),y(k)!=="svelte-1wmi3ea"&&(k.innerHTML=Jt),st=n(t),o(Z.$$.fragment,t),et=n(t),W=m(t,"P",{"data-svelte-h":!0}),y(W)!=="svelte-9sr7nh"&&(W.textContent=jt),lt=n(t),o(N.$$.fragment,t),at=n(t),B=m(t,"P",{"data-svelte-h":!0}),y(B)!=="svelte-1kguc51"&&(B.innerHTML=ut),nt=n(t),o(x.$$.fragment,t),pt=n(t),G=m(t,"P",{"data-svelte-h":!0}),y(G)!=="svelte-1n0coha"&&(G.innerHTML=Tt),mt=n(t),o(E.$$.fragment,t),it=n(t),o(V.$$.fragment,t),ot=n(t),X=m(t,"P",{}),ft(X).forEach(e),this.h()},h(){bt(d,"name","hf:doc:metadata"),bt(d,"content",Bt)},m(t,s){Wt(document.head,d),l(t,v,s),l(t,R,s),l(t,S,s),c(g,t,s),l(t,Y,s),l(t,w,s),l(t,z,s),c(J,t,s),l(t,F,s),l(t,j,s),l(t,H,s),c(u,t,s),l(t,A,s),l(t,T,s),l(t,L,s),c(f,t,s),l(t,q,s),l(t,b,s),l(t,D,s),c(U,t,s),l(t,P,s),l(t,I,s),l(t,K,s),c(C,t,s),l(t,O,s),l(t,$,s),l(t,tt,s),l(t,k,s),l(t,st,s),c(Z,t,s),l(t,et,s),l(t,W,s),l(t,lt,s),c(N,t,s),l(t,at,s),l(t,B,s),l(t,nt,s),c(x,t,s),l(t,pt,s),l(t,G,s),l(t,mt,s),c(E,t,s),l(t,it,s),c(V,t,s),l(t,ot,s),l(t,X,s),ct=!0},p:It,i(t){ct||(r(g.$$.fragment,t),r(J.$$.fragment,t),r(u.$$.fragment,t),r(f.$$.fragment,t),r(U.$$.fragment,t),r(C.$$.fragment,t),r(Z.$$.fragment,t),r(N.$$.fragment,t),r(x.$$.fragment,t),r(E.$$.fragment,t),r(V.$$.fragment,t),ct=!0)},o(t){h(g.$$.fragment,t),h(J.$$.fragment,t),h(u.$$.fragment,t),h(f.$$.fragment,t),h(U.$$.fragment,t),h(C.$$.fragment,t),h(Z.$$.fragment,t),h(N.$$.fragment,t),h(x.$$.fragment,t),h(E.$$.fragment,t),h(V.$$.fragment,t),ct=!1},d(t){t&&(e(v),e(R),e(S),e(Y),e(w),e(z),e(F),e(j),e(H),e(A),e(T),e(L),e(q),e(b),e(D),e(P),e(I),e(K),e(O),e($),e(tt),e(k),e(st),e(et),e(W),e(lt),e(at),e(B),e(nt),e(pt),e(G),e(mt),e(it),e(ot),e(X)),e(d),M(g,t),M(J,t),M(u,t),M(f,t),M(U,t),M(C,t),M(Z,t),M(N,t),M(x,t),M(E,t),M(V,t)}}}const Bt='{"title":"(Legacy) SE-ResNet","local":"legacy-se-resnet","sections":[{"title":"How do I use this model on an image?","local":"how-do-i-use-this-model-on-an-image","sections":[],"depth":2},{"title":"How do I finetune this model?","local":"how-do-i-finetune-this-model","sections":[],"depth":2},{"title":"How do I train this model?","local":"how-do-i-train-this-model","sections":[],"depth":2},{"title":"Citation","local":"citation","sections":[],"depth":2}],"depth":1}';function xt(rt){return Ct(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Rt extends $t{constructor(d){super(),kt(this,d,xt,Nt,Ut,{})}}export{Rt as component};
