import{s as Ls,o as Rs,n as MM}from"../chunks/scheduler.6062bdaf.js";import{S as Ss,i as Bs,g as i,s as M,r as c,A as xs,h as n,f as t,c as s,j as vs,u as J,x as T,k as tM,y as Qs,a,v as o,d as h,t as U,w as y}from"../chunks/index.4bca734e.js";import{T as aM}from"../chunks/Tip.b9ac1f03.js";import{C as j}from"../chunks/CodeBlock.cbbddafc.js";import{H as I,E as Ds}from"../chunks/index.6c92e143.js";function Fs(r){let d,m=`<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a> is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!`;return{c(){d=i("p"),d.innerHTML=m},l(w){d=n(w,"P",{"data-svelte-h":!0}),T(d)!=="svelte-1d1cydk"&&(d.innerHTML=m)},m(w,f){a(w,d,f)},p:MM,d(w){w&&t(d)}}}function $s(r){let d,m=`Revision hashes are unique across all repositories. This means you don’t need to
provide any <code>repo_id</code> or <code>repo_type</code> when removing revisions.`;return{c(){d=i("p"),d.innerHTML=m},l(w){d=n(w,"P",{"data-svelte-h":!0}),T(d)!=="svelte-pge9b4"&&(d.innerHTML=m)},m(w,f){a(w,d,f)},p:MM,d(w){w&&t(d)}}}function Os(r){let d,m=`If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.`;return{c(){d=i("p"),d.innerHTML=m},l(w){d=n(w,"P",{"data-svelte-h":!0}),T(d)!=="svelte-y56bqo"&&(d.innerHTML=m)},m(w,f){a(w,d,f)},p:MM,d(w){w&&t(d)}}}function Es(r){let d,m,w,f,A,xl,g,sM="<code>huggingface_hub</code> utilizes the local disk as two caches, which avoid re-downloading items again. The first cache is a file-based cache, which caches individual files downloaded from the Hub and ensures that the same file is not downloaded again when a repo gets updated. The second cache is a chunk cache, where each chunk represents a byte range from a file and ensures that chunks that are shared across files are only downloaded once.",Ql,Z,Dl,k,iM=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,Fl,N,nM="The caching system is designed as follows:",$l,Y,Ol,G,TM="The default <code>&lt;CACHE_DIR&gt;</code> is <code>~/.cache/huggingface/hub</code>. However, it is customizable with the <code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or <code>HF_HUB_CACHE</code> environment variable.",El,W,cM=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,Vl,v,_l,L,JM=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,zl,R,oM="In order to achieve this, all folders contain the same skeleton:",Hl,S,Xl,B,hM="Each folder is designed to contain the following:",Pl,x,ql,Q,UM=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,Kl,D,yM="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",et,F,dM=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,lt,$,tt,O,wM="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",at,E,Mt,V,jM=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,st,_,IM=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,it,z,mM=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,nt,H,Tt,X,fM="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",ct,P,rM=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,Jt,q,ot,K,pM=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,ht,ee,Ut,le,CM=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable in term of disk usage.`,yt,te,uM=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exist (and
which doesn’t) to make the loading time faster for the next initializations.`,dt,ae,bM=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,wt,Me,jt,se,It,ie,AM="In practice, your cache should look like the following tree:",mt,ne,ft,Te,rt,ce,gM=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,pt,Je,ZM=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,Ct,oe,kM=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,ut,he,bt,Ue,NM='To provide more efficient file transfers, <code>hf_xet</code> adds a <code>xet</code> directory to the existing <code>huggingface_hub</code> cache, creating additional caching layer to enable chunk-based deduplication. This cache holds chunks, which are immutable byte ranges from files (up to 64KB) that are created using content-defined chunking. For more information on the Xet Storage system, see this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',At,ye,YM="The <code>xet</code> directory, located at <code>~/.cache/huggingface/xet</code> by default, contains two caches, utilized for uploads and downloads with the following structure",gt,de,Zt,we,GM="The <code>xet</code> cache, like the rest of <code>hf_xet</code> is fully integrated with <code>huggingface_hub</code>.  If you use the existing APIs for interacting with cached assets, there is no need to update your workflow. The <code>xet</code> cache is built as an optimization layer on top of the existing <code>hf_xet</code> chunk-based deduplication and <code>huggingface_hub</code> cache system.",kt,je,WM="The <code>chunk-cache</code> directory contains cached data chunks that are used to speed up downloads while the <code>shard-cache</code> directory contains cached shards that are utilized on the upload path.",Nt,Ie,Yt,me,vM="This cache is used on the download path. The cache directory structure is based on a base-64 encoded hash from the content-addressed store (CAS) that backs each Xet-enabled repository. A CAS hash serves as the key to lookup the offsets of where the data is stored.",Gt,fe,LM="At the topmost level, the first two letters of the base 64 encoded CAS hash are used to create a subdirectory in the <code>chunk_cache</code> (keys that share these first two letters are grouped here).  The inner levels are comprised of subdirectories with the full key as the directory name. At the base are the cache items which are ranges of blocks that contain the cached chunks.",Wt,re,vt,pe,RM="When requesting a file, the first thing <code>hf_xet</code> does is communicate with Xet storage’s content addressed store (CAS) for reconstruction information. The reconstruction information contains information about the CAS keys required to download the file in its entirety.",Lt,Ce,SM="Before executing the requests for the CAS keys, the <code>chunk_cache</code> is consulted. If a key in the cache matches a CAS key, then there is no reason to issue a request for that content. <code>hf_xet</code> uses the chunks stored in the directory instead.",Rt,ue,BM="As the <code>chunk_cache</code> is purely an optimization, not a guarantee, <code>hf_xet</code> utilizes a computationally efficient eviction policy. When the <code>chunk_cache</code> is full (see <code>Limits and Limitations</code> below), <code>hf_xet</code> implements a random eviction policy when selecting an eviction candidate. This significantly reduces the overhead of managing a robust caching system (e.g., LRU) while still providing most of the benefits of caching chunks.",St,be,Bt,Ae,xM="This cache is used when uploading content to the Hub. The directory is flat, comprising only of shard files, each using an ID for the shard name.",xt,ge,Qt,Ze,QM="The <code>shard_cache</code> contains shards that are:",Dt,ke,DM="<li>Locally generated and successfully uploaded to the CAS</li> <li>Downloaded from CAS as part of the global deduplication algorithm</li>",Ft,Ne,FM="Shards provide a mapping between files and chunks. During uploads, each file is chunked and the hash of the chunk is saved. Every shard in the cache is then consulted. If a shard contains a chunk hash that is present in the local file being uploaded, then that chunk can be discarded as it is already stored in CAS.",$t,Ye,$M="All shards have an expiration date of 3-4 weeks from when they are downloaded. Shards that are expired are not loaded during upload and are deleted one week after expiration.",Ot,Ge,Et,We,OM="The <code>chunk_cache</code> is limited to 10GB in size while the <code>shard_cache</code> is technically without limits (in practice, the size and use of shards are such that limiting the cache is unnecessary).",Vt,ve,EM='By design, both caches are without high-level APIs. These caches are used primarily to facilitate the reconstruction (download) or upload of a file. To interact with the assets themselves, it’s recommended that you use the <a href="https://huggingface.co/docs/huggingface_hub/guides/manage-cache" rel="nofollow"><code>huggingface_hub</code> cache system APIs</a>.',_t,Le,VM="If you need to reclaim the space utilized by either cache or need to debug any potential cache-related issues, simply remove the <code>xet</code> cache entirely by running <code>rm -rf ~/&lt;cache_dir&gt;/xet</code> where <code>&lt;cache_dir&gt;</code> is the location of your Hugging Face cache, typically <code>~/.cache/huggingface</code>",zt,Re,_M="Example full <code>xet</code>cache directory tree:",Ht,Se,Xt,Be,zM='To learn more about Xet Storage, see this <a href="https://huggingface.co/docs/hub/storage-backends" rel="nofollow">section</a>.',Pt,xe,qt,Qe,HM=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,Kt,De,ea,p,la,Fe,ta,$e,XM="In practice, your assets cache should look like the following tree:",aa,Oe,Ma,Ee,sa,Ve,ia,_e,PM=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to scan your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides an helper to
do so that can be used via <code>huggingface-cli</code> or in a python script.`,na,ze,qM="<strong>Scan cache from the terminal</strong>",Ta,He,KM=`The easiest way to scan your HF cache-system is to use the <code>scan-cache</code> command from
<code>huggingface-cli</code> tool. This command scans the cache and prints a report with information
like repo id, repo type, disk usage, refs and full local path.`,ca,Xe,es=`The snippet below shows a scan report in a folder in which 4 models and 2 datasets are
cached.`,Ja,Pe,oa,qe,ls=`To get a more detailed report, use the <code>--verbose</code> option. For each repo, you get a
list of all revisions that have been downloaded. As explained above, the files that don’t
change between 2 revisions are shared thanks to the symlinks. This means that the size of
the repo on disk is expected to be less than the sum of the size of each of its revisions.
For example, here <code>bert-base-cased</code> has 2 revisions of 1.4G and 1.5G but the total disk
usage is only 1.9G.`,ha,Ke,Ua,el,ts="<strong>Grep example</strong>",ya,ll,as=`Since the output is in tabular format, you can combine it with any <code>grep</code>-like tools to
filter the entries. Here is an example to filter only revisions from the “t5-small”
model on a Unix-based machine.`,da,tl,wa,al,Ms="<strong>Scan cache from Python</strong>",ja,Ml,ss=`For a more advanced usage, use <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,Ia,sl,is="You can use it to get a detailed report structured around 4 dataclasses:",ma,il,ns='<li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',fa,nl,Ts="Here is a simple usage example. See reference for details.",ra,Tl,pa,cl,Ca,Jl,cs=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>delete-cache</code> CLI command. One can also programmatically use the
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,ua,ol,Js="<strong>Delete strategy</strong>",ba,hl,os=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,Aa,Ul,hs="The strategy to delete revisions is the following:",ga,yl,Us="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",Za,C,ka,u,Na,dl,ys="<strong>Clean cache from the terminal</strong>",Ya,wl,ds=`The easiest way to delete some revisions from your HF cache-system is to use the
<code>delete-cache</code> command from <code>huggingface-cli</code> tool. The command has two modes. By
default, a TUI (Terminal User Interface) is displayed to the user to select which
revisions to delete. This TUI is currently in beta as it has not been tested on all
platforms. If the TUI doesn’t work on your machine, you can disable it using the
<code>--disable-tui</code> flag.`,Ga,jl,ws="<strong>Using the TUI</strong>",Wa,Il,js=`This is the default mode. To use it, you first need to install extra dependencies by
running the following command:`,va,ml,La,fl,Is="Then run the command:",Ra,rl,Sa,pl,ms="You should now see a list of revisions that you can select/deselect:",Ba,b,fs='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/delete-cache-tui.png"/>',xa,Cl,rs="Instructions:",Qa,ul,ps=`<li>Press keyboard arrow keys <code>&lt;up&gt;</code> and <code>&lt;down&gt;</code> to move the cursor.</li> <li>Press <code>&lt;space&gt;</code> to toggle (select/unselect) an item.</li> <li>When a revision is selected, the first line is updated to show you how much space
will be freed.</li> <li>Press <code>&lt;enter&gt;</code> to confirm your selection.</li> <li>If you want to cancel the operation and quit, you can select the first item
(“None of the following”). If this item is selected, the delete process will be
cancelled, no matter what other items are selected. Otherwise you can also press
<code>&lt;ctrl+c&gt;</code> to quit the TUI.</li>`,Da,bl,Cs=`Once you’ve selected the revisions you want to delete and pressed <code>&lt;enter&gt;</code>, a last
confirmation message will be prompted. Press <code>&lt;enter&gt;</code> again and the deletion will be
effective. If you want to cancel, enter <code>n</code>.`,Fa,Al,$a,gl,us="<strong>Without TUI</strong>",Oa,Zl,bs=`As mentioned above, the TUI mode is currently in beta and is optional. It may be the
case that it doesn’t work on your machine or that you don’t find it convenient.`,Ea,kl,As=`Another approach is to use the <code>--disable-tui</code> flag. The process is very similar as you
will be asked to manually review the list of revisions to delete. However, this manual
step will not take place in the terminal directly but in a temporary file generated on
the fly and that you can manually edit.`,Va,Nl,gs=`This file has all the instructions you need in the header. Open it in your favorite text
editor. To select/deselect a revision, simply comment/uncomment it with a <code>#</code>. Once the
manual review is done and the file is edited, you can save it. Go back to your terminal
and press <code>&lt;enter&gt;</code>. By default it will compute how much space would be freed with the
updated list of revisions. You can continue to edit the file or confirm with <code>&quot;y&quot;</code>.`,_a,Yl,za,Gl,Zs="Example of command file:",Ha,Wl,Xa,vl,ks="<strong>Clean cache from Python</strong>",Pa,Ll,Ns=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/main/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,qa,Rl,Ka,Sl,eM,Bl,lM;return A=new I({props:{title:"Understand caching",local:"understand-caching",headingTag:"h1"}}),Z=new I({props:{title:"File-based caching",local:"file-based-caching",headingTag:"h2"}}),Y=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),v=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),S=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),x=new I({props:{title:"Refs",local:"refs",headingTag:"h3"}}),$=new I({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),E=new I({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),H=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),q=new I({props:{title:".no_exist (advanced)",local:"noexist-advanced",headingTag:"h3"}}),ee=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),Me=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),se=new I({props:{title:"In practice",local:"in-practice",headingTag:"h3"}}),ne=new j({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),Te=new I({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),he=new I({props:{title:"Chunk-based caching (Xet)",local:"chunk-based-caching-xet",headingTag:"h2"}}),de=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBzaGFyZF9jYWNoZQ==",highlighted:`&lt;CACHE_DIR&gt;
├─ chunk_cache
├─ shard_cache`,wrap:!1}}),Ie=new I({props:{title:"chunk_cache",local:"chunkcache",headingTag:"h3"}}),re=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEExR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQQ==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ A1
│  │  │  ├─ A1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
`,wrap:!1}}),be=new I({props:{title:"shard_cache",local:"shardcache",headingTag:"h3"}}),ge=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwc2hhcmRfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjAxZmU0ZmZkNWNmMGMzMzc1ZjFlZjlhZWM1MDE2Y2Y3NzNjY2M1Y2EyOTQyOTNkM2Y5MmQ5Mjc3MWRhY2ZjMTVkLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMDkwNmVlMTg0ZGMxY2QwNjE1MTY0YTg5ZWQ2NGU4MTQ3YjNmZGNjZDExNjNkODBkNzk0YzY2ODE0YjNiMDk5OTIubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2VlZWI3ZWE0Y2Y2YzBhOGQzOTVhMmNmOWMwODg3MTIxMWZiYmQxN2I5YjVkYzEwMDU4MTE4NDUzMDdlNmI4Zi5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBlODUzNTE1NWIxYjExZWJkODk0YzkwOGU5MWExZTE0ZTM0NjFkZGRkMTM5MjY5NWRkYzkwYWU1NGE1NDhkOGIyLm1kYg==",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb`,wrap:!1}}),Ge=new I({props:{title:"Limits and Limitations",local:"limits-and-limitations",headingTag:"h3"}}),Se=new j({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIweGV0JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwY2h1bmtfY2FjaGUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBMMSUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMEwxR2VyVVJMVWNJU1ZpdmRzZWVvWTFQbllpZllrT2FDQ0o3VjVROWZqZ3hrWldaaGRXeDAlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBBQUFBQUFFQUFBQTVEUUFBQUFBQUFJaFJMakRJM1NTNWpZczR5c05LWmlKeTlYRkk4Q043V3cwVXlFQTlLUEQ5JTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwQVFBQUFBSUFBQUJ6bmdBQUFBQUFBUE5xUGpkNVpieTVhQnZhYkY3WjFpdEN4MHJ5TXdvQ251UWNEd3E3OWpsQiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMHNoYXJkX2NhY2hlJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwMWZlNGZmZDVjZjBjMzM3NWYxZWY5YWVjNTAxNmNmNzczY2NjNWNhMjk0MjkzZDNmOTJkOTI3NzFkYWNmYzE1ZC5tZGIlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjA5MDZlZTE4NGRjMWNkMDYxNTE2NGE4OWVkNjRlODE0N2IzZmRjY2QxMTYzZDgwZDc5NGM2NjgxNGIzYjA5OTkyLm1kYiUwQSVFMiU5NCU4MiUyMCUyMCVFMiU5NCU4MiUyMCUyMCVFMiU5NCU5QyVFMiU5NCU4MCUyMGNlZWViN2VhNGNmNmMwYThkMzk1YTJjZjljMDg4NzEyMTFmYmJkMTdiOWI1ZGMxMDA1ODExODQ1MzA3ZTZiOGYubWRiJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwZTg1MzUxNTViMWIxMWViZDg5NGM5MDhlOTFhMWUxNGUzNDYxZGRkZDEzOTI2OTVkZGM5MGFlNTRhNTQ4ZDhiMi5tZGI=",highlighted:`&lt;CACHE_DIR&gt;
├─ xet
│  ├─ chunk_cache
│  │  ├─ L1
│  │  │  ├─ L1GerURLUcISVivdseeoY1PnYifYkOaCCJ7V5Q9fjgxkZWZhdWx0
│  │  │  │  ├─ AAAAAAEAAAA5DQAAAAAAAIhRLjDI3SS5jYs4ysNKZiJy9XFI8CN7Ww0UyEA9KPD9
│  │  │  │  ├─ AQAAAAIAAABzngAAAAAAAPNqPjd5Zby5aBvabF7Z1itCx0ryMwoCnuQcDwq79jlB
│  ├─ shard_cache
│  │  ├─ 1fe4ffd5cf0c3375f1ef9aec5016cf773ccc5ca294293d3f92d92771dacfc15d.mdb
│  │  ├─ 906ee184dc1cd0615164a89ed64e8147b3fdccd1163d80d794c66814b3b09992.mdb
│  │  ├─ ceeeb7ea4cf6c0a8d395a2cf9c08871211fbbd17b9b5dc1005811845307e6b8f.mdb
│  │  ├─ e8535155b1b11ebd894c908e91a1e14e3461dddd1392695ddc90ae54a548d8b2.mdb`,wrap:!1}}),xe=new I({props:{title:"Caching assets",local:"caching-assets",headingTag:"h2"}}),De=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`,wrap:!1}}),p=new aM({props:{$$slots:{default:[Fs]},$$scope:{ctx:r}}}),Fe=new I({props:{title:"Assets in practice",local:"assets-in-practice",headingTag:"h3"}}),Oe=new j({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),Ee=new I({props:{title:"Manage your file-based cache",local:"manage-your-file-based-cache",headingTag:"h2"}}),Ve=new I({props:{title:"Scan your cache",local:"scan-your-cache",headingTag:"h3"}}),Pe=new j({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache
REPO ID                     REPO TYPE SIZE ON DISK NB FILES LAST_ACCESSED LAST_MODIFIED REFS                LOCAL PATH
--------------------------- --------- ------------ -------- ------------- ------------- ------------------- -------------------------------------------------------------------------
glue                        dataset         116.3K       15 4 days ago    4 days ago    2.4.0, main, 1.17.0 /home/wauplin/.cache/huggingface/hub/datasets--glue
google/fleurs               dataset          64.9M        6 1 week ago    1 week ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs
Jean-Baptiste/camembert-ner model           441.0M        7 2 weeks ago   16 hours ago  main                /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner
bert-base-cased             model             1.9G       13 1 week ago    2 years ago                       /home/wauplin/.cache/huggingface/hub/models--bert-base-cased
t5-base                     model            10.1K        3 3 months ago  3 months ago  main                /home/wauplin/.cache/huggingface/hub/models--t5-base
t5-small                    model           970.7M       11 3 days ago    3 days ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/models--t5-small

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),Ke=new j({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache -v
REPO ID                     REPO TYPE REVISION                                 SIZE ON DISK NB FILES LAST_MODIFIED REFS        LOCAL PATH
--------------------------- --------- ---------------------------------------- ------------ -------- ------------- ----------- ----------------------------------------------------------------------------------------------------------------------------
glue                        dataset   9338f7b671827df886678df2bdd7cc7b4f36dffd        97.7K       14 4 days ago    main, 2.4.0 /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/9338f7b671827df886678df2bdd7cc7b4f36dffd
glue                        dataset   f021ae41c879fcabcf823648ec685e3fead91fe7        97.8K       14 1 week ago    1.17.0      /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/f021ae41c879fcabcf823648ec685e3fead91fe7
google/fleurs               dataset   129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8        25.4K        3 2 weeks ago   refs/pr/1   /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8
google/fleurs               dataset   24f85a01eb955224ca3946e70050869c56446805        64.9M        4 1 week ago    main        /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/24f85a01eb955224ca3946e70050869c56446805
Jean-Baptiste/camembert-ner model     dbec8489a1c44ecad9da8a9185115bccabd799fe       441.0M        7 16 hours ago  main        /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner/snapshots/dbec8489a1c44ecad9da8a9185115bccabd799fe
bert-base-cased             model     378aa1bda6387fd00e824948ebe3488630ad8565         1.5G        9 2 years ago               /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/378aa1bda6387fd00e824948ebe3488630ad8565
bert-base-cased             model     a8d257ba9925ef39f3036bfc338acf5283c512d9         1.4G        9 3 days ago    main        /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/a8d257ba9925ef39f3036bfc338acf5283c512d9
t5-base                     model     23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9        10.1K        3 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-base/snapshots/23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),tl=new j({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmh1Z2dpbmdmYWNlLWNsaSUyMHNjYW4tY2FjaGUlMjAtdiUyMiUyMCU3QyUyMGdyZXAlMjAlMjJ0NS1zbWFsbCUyMiUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjA5OGZmZWJiYjI3MzQwZWMxYjFhYmQ3YzQ1ZGExMmMyNTNlZTE4ODJhJTIwJTIwJTIwJTIwJTIwJTIwJTIwNzI2LjJNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwcmVmcyUyRnByJTJGMSUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGOThmZmViYmIyNzM0MGVjMWIxYWJkN2M0NWRhMTJjMjUzZWUxODgyYSUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkMGExMTllZWRiMzcxOGUzNGM2NDhlNTk0Mzk0NDc0Y2Y5NWUwNjE3JTIwJTIwJTIwJTIwJTIwJTIwJTIwNDg1LjhNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDQlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDBhMTE5ZWVkYjM3MThlMzRjNjQ4ZTU5NDM5NDQ3NGNmOTVlMDYxNyUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkNzhhZWExM2ZhN2VjZDA2YzI5ZTNlNDYxOTVkNjM0MTI1NTA2NWQ1JTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwbWFpbiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDc4YWVhMTNmYTdlY2QwNmMyOWUzZTQ2MTk1ZDYzNDEyNTUwNjVkNQ==",highlighted:`➜ eval &quot;huggingface-cli scan-cache -v&quot; | grep &quot;t5-small&quot;
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5`,wrap:!1}}),Tl=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),cl=new I({props:{title:"Clean your cache",local:"clean-your-cache",headingTag:"h3"}}),C=new aM({props:{$$slots:{default:[$s]},$$scope:{ctx:r}}}),u=new aM({props:{warning:!0,$$slots:{default:[Os]},$$scope:{ctx:r}}}),ml=new j({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiU1QiUyMmNsaSUyMiU1RA==",highlighted:'pip <span class="hljs-keyword">install</span> huggingface_hub[<span class="hljs-string">&quot;cli&quot;</span>]',wrap:!1}}),rl=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hl",highlighted:'huggingface-cli <span class="hljs-keyword">delete</span>-<span class="hljs-keyword">cache</span>',wrap:!1}}),Al=new j({props:{code:"JUUyJTlDJTk3JTIwaHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXIlMjB+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMEElM0YlMjBTZWxlY3QlMjByZXZpc2lvbnMlMjB0byUyMGRlbGV0ZSUzQSUyMDIlMjByZXZpc2lvbihzKSUyMHNlbGVjdGVkLiUwQSUzRiUyMDIlMjByZXZpc2lvbnMlMjBzZWxlY3RlZCUyMGNvdW50aW5nJTIwZm9yJTIwMy4xRy4lMjBDb25maXJtJTIwZGVsZXRpb24lMjAlM0YlMjBZZXMlMEFTdGFydCUyMGRlbGV0aW9uLiUwQURvbmUuJTIwRGVsZXRlZCUyMDElMjByZXBvKHMpJTIwYW5kJTIwMCUyMHJldmlzaW9uKHMpJTIwZm9yJTIwYSUyMHRvdGFsJTIwb2YlMjAzLjFHLg==",highlighted:`✗ huggingface-cli delete-cache --dir ~/.cache/huggingface/hub
? Select revisions to delete: 2 revision(s) selected.
? 2 revisions selected counting for 3.1G. Confirm deletion ? Yes
Start deletion.
Done. Deleted 1 repo(s) and 0 revision(s) for a total of 3.1G.`,wrap:!1}}),Yl=new j({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXNhYmxlLXR1aQ==",highlighted:"huggingface-cli delete-cache --disable-tui",wrap:!1}}),Wl=new j({props:{code:"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",highlighted:`# INSTRUCTIONS
# ------------
# This is a temporary file created by running \`huggingface-cli delete-cache\` with the
# \`--disable-tui\` option. It contains a set of revisions that can be deleted from your
# local cache directory.
#
# Please manually review the revisions you want to delete:
#   - Revision hashes can be commented out with &#x27;#&#x27;.
#   - Only non-commented revisions in this file will be deleted.
#   - Revision hashes that are removed from this file are ignored as well.
#   - If \`CANCEL_DELETION\` line is uncommented, the all cache deletion is cancelled and
#     no changes will be applied.
#
# Once you&#x27;ve manually reviewed this file, please confirm deletion in the terminal. This
# file will be automatically removed once done.
# ------------

# KILL SWITCH
# ------------
# Un-comment following line to completely cancel the deletion process
# CANCEL_DELETION
# ------------

# REVISIONS
# ------------
# Dataset chrisjay/crowd-speech-africa (761.7M, used 5 days ago)
    ebedcd8c55c90d39fd27126d29d8484566cd27ca # Refs: main # modified 5 days ago

# Dataset oscar (3.3M, used 4 days ago)
#    916f956518279c5e60c63902ebdf3ddf9fa9d629 # Refs: main # modified 4 days ago

# Dataset wikiann (804.1K, used 2 weeks ago)
    89d089624b6323d69dcd9e5eb2def0551887a73a # Refs: main # modified 2 weeks ago

# Dataset z-uo/male-LJSpeech-italian (5.5G, used 5 days ago)
#    9cfa5647b32c0a30d0adfca06bf198d82192a0d1 # Refs: main # modified 5 days ago`,wrap:!1}}),Rl=new j({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),Sl=new Ds({props:{source:"https://github.com/huggingface/huggingface_hub/blob/main/docs/source/en/guides/manage-cache.md"}}),{c(){d=i("meta"),m=M(),w=i("p"),f=M(),c(A.$$.fragment),xl=M(),g=i("p"),g.innerHTML=sM,Ql=M(),c(Z.$$.fragment),Dl=M(),k=i("p"),k.textContent=iM,Fl=M(),N=i("p"),N.textContent=nM,$l=M(),c(Y.$$.fragment),Ol=M(),G=i("p"),G.innerHTML=TM,El=M(),W=i("p"),W.textContent=cM,Vl=M(),c(v.$$.fragment),_l=M(),L=i("p"),L.textContent=JM,zl=M(),R=i("p"),R.textContent=oM,Hl=M(),c(S.$$.fragment),Xl=M(),B=i("p"),B.textContent=hM,Pl=M(),c(x.$$.fragment),ql=M(),Q=i("p"),Q.innerHTML=UM,Kl=M(),D=i("p"),D.innerHTML=yM,et=M(),F=i("p"),F.innerHTML=dM,lt=M(),c($.$$.fragment),tt=M(),O=i("p"),O.innerHTML=wM,at=M(),c(E.$$.fragment),Mt=M(),V=i("p"),V.innerHTML=jM,st=M(),_=i("p"),_.innerHTML=IM,it=M(),z=i("p"),z.innerHTML=mM,nt=M(),c(H.$$.fragment),Tt=M(),X=i("p"),X.innerHTML=fM,ct=M(),P=i("p"),P.innerHTML=rM,Jt=M(),c(q.$$.fragment),ot=M(),K=i("p"),K.innerHTML=pM,ht=M(),c(ee.$$.fragment),Ut=M(),le=i("p"),le.innerHTML=CM,yt=M(),te=i("p"),te.innerHTML=uM,dt=M(),ae=i("p"),ae.innerHTML=bM,wt=M(),c(Me.$$.fragment),jt=M(),c(se.$$.fragment),It=M(),ie=i("p"),ie.textContent=AM,mt=M(),c(ne.$$.fragment),ft=M(),c(Te.$$.fragment),rt=M(),ce=i("p"),ce.innerHTML=gM,pt=M(),Je=i("p"),Je.innerHTML=ZM,Ct=M(),oe=i("p"),oe.innerHTML=kM,ut=M(),c(he.$$.fragment),bt=M(),Ue=i("p"),Ue.innerHTML=NM,At=M(),ye=i("p"),ye.innerHTML=YM,gt=M(),c(de.$$.fragment),Zt=M(),we=i("p"),we.innerHTML=GM,kt=M(),je=i("p"),je.innerHTML=WM,Nt=M(),c(Ie.$$.fragment),Yt=M(),me=i("p"),me.textContent=vM,Gt=M(),fe=i("p"),fe.innerHTML=LM,Wt=M(),c(re.$$.fragment),vt=M(),pe=i("p"),pe.innerHTML=RM,Lt=M(),Ce=i("p"),Ce.innerHTML=SM,Rt=M(),ue=i("p"),ue.innerHTML=BM,St=M(),c(be.$$.fragment),Bt=M(),Ae=i("p"),Ae.textContent=xM,xt=M(),c(ge.$$.fragment),Qt=M(),Ze=i("p"),Ze.innerHTML=QM,Dt=M(),ke=i("ul"),ke.innerHTML=DM,Ft=M(),Ne=i("p"),Ne.textContent=FM,$t=M(),Ye=i("p"),Ye.textContent=$M,Ot=M(),c(Ge.$$.fragment),Et=M(),We=i("p"),We.innerHTML=OM,Vt=M(),ve=i("p"),ve.innerHTML=EM,_t=M(),Le=i("p"),Le.innerHTML=VM,zt=M(),Re=i("p"),Re.innerHTML=_M,Ht=M(),c(Se.$$.fragment),Xt=M(),Be=i("p"),Be.innerHTML=zM,Pt=M(),c(xe.$$.fragment),qt=M(),Qe=i("p"),Qe.innerHTML=HM,Kt=M(),c(De.$$.fragment),ea=M(),c(p.$$.fragment),la=M(),c(Fe.$$.fragment),ta=M(),$e=i("p"),$e.textContent=XM,aa=M(),c(Oe.$$.fragment),Ma=M(),c(Ee.$$.fragment),sa=M(),c(Ve.$$.fragment),ia=M(),_e=i("p"),_e.innerHTML=PM,na=M(),ze=i("p"),ze.innerHTML=qM,Ta=M(),He=i("p"),He.innerHTML=KM,ca=M(),Xe=i("p"),Xe.textContent=es,Ja=M(),c(Pe.$$.fragment),oa=M(),qe=i("p"),qe.innerHTML=ls,ha=M(),c(Ke.$$.fragment),Ua=M(),el=i("p"),el.innerHTML=ts,ya=M(),ll=i("p"),ll.innerHTML=as,da=M(),c(tl.$$.fragment),wa=M(),al=i("p"),al.innerHTML=Ms,ja=M(),Ml=i("p"),Ml.innerHTML=ss,Ia=M(),sl=i("p"),sl.textContent=is,ma=M(),il=i("ul"),il.innerHTML=ns,fa=M(),nl=i("p"),nl.textContent=Ts,ra=M(),c(Tl.$$.fragment),pa=M(),c(cl.$$.fragment),Ca=M(),Jl=i("p"),Jl.innerHTML=cs,ua=M(),ol=i("p"),ol.innerHTML=Js,ba=M(),hl=i("p"),hl.innerHTML=os,Aa=M(),Ul=i("p"),Ul.textContent=hs,ga=M(),yl=i("ul"),yl.innerHTML=Us,Za=M(),c(C.$$.fragment),ka=M(),c(u.$$.fragment),Na=M(),dl=i("p"),dl.innerHTML=ys,Ya=M(),wl=i("p"),wl.innerHTML=ds,Ga=M(),jl=i("p"),jl.innerHTML=ws,Wa=M(),Il=i("p"),Il.textContent=js,va=M(),c(ml.$$.fragment),La=M(),fl=i("p"),fl.textContent=Is,Ra=M(),c(rl.$$.fragment),Sa=M(),pl=i("p"),pl.textContent=ms,Ba=M(),b=i("div"),b.innerHTML=fs,xa=M(),Cl=i("p"),Cl.textContent=rs,Qa=M(),ul=i("ul"),ul.innerHTML=ps,Da=M(),bl=i("p"),bl.innerHTML=Cs,Fa=M(),c(Al.$$.fragment),$a=M(),gl=i("p"),gl.innerHTML=us,Oa=M(),Zl=i("p"),Zl.textContent=bs,Ea=M(),kl=i("p"),kl.innerHTML=As,Va=M(),Nl=i("p"),Nl.innerHTML=gs,_a=M(),c(Yl.$$.fragment),za=M(),Gl=i("p"),Gl.textContent=Zs,Ha=M(),c(Wl.$$.fragment),Xa=M(),vl=i("p"),vl.innerHTML=ks,Pa=M(),Ll=i("p"),Ll.innerHTML=Ns,qa=M(),c(Rl.$$.fragment),Ka=M(),c(Sl.$$.fragment),eM=M(),Bl=i("p"),this.h()},l(e){const l=xs("svelte-u9bgzb",document.head);d=n(l,"META",{name:!0,content:!0}),l.forEach(t),m=s(e),w=n(e,"P",{}),vs(w).forEach(t),f=s(e),J(A.$$.fragment,e),xl=s(e),g=n(e,"P",{"data-svelte-h":!0}),T(g)!=="svelte-1s3yler"&&(g.innerHTML=sM),Ql=s(e),J(Z.$$.fragment,e),Dl=s(e),k=n(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-7434pt"&&(k.textContent=iM),Fl=s(e),N=n(e,"P",{"data-svelte-h":!0}),T(N)!=="svelte-bm5pxs"&&(N.textContent=nM),$l=s(e),J(Y.$$.fragment,e),Ol=s(e),G=n(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-lw0yzm"&&(G.innerHTML=TM),El=s(e),W=n(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-1xsylbb"&&(W.textContent=cM),Vl=s(e),J(v.$$.fragment,e),_l=s(e),L=n(e,"P",{"data-svelte-h":!0}),T(L)!=="svelte-smirw4"&&(L.textContent=JM),zl=s(e),R=n(e,"P",{"data-svelte-h":!0}),T(R)!=="svelte-hxzvg9"&&(R.textContent=oM),Hl=s(e),J(S.$$.fragment,e),Xl=s(e),B=n(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-1o80jr1"&&(B.textContent=hM),Pl=s(e),J(x.$$.fragment,e),ql=s(e),Q=n(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-z6cr2z"&&(Q.innerHTML=UM),Kl=s(e),D=n(e,"P",{"data-svelte-h":!0}),T(D)!=="svelte-15cx8ge"&&(D.innerHTML=yM),et=s(e),F=n(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1u7b6sn"&&(F.innerHTML=dM),lt=s(e),J($.$$.fragment,e),tt=s(e),O=n(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-9jec47"&&(O.innerHTML=wM),at=s(e),J(E.$$.fragment,e),Mt=s(e),V=n(e,"P",{"data-svelte-h":!0}),T(V)!=="svelte-1mswky"&&(V.innerHTML=jM),st=s(e),_=n(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1f9g1u2"&&(_.innerHTML=IM),it=s(e),z=n(e,"P",{"data-svelte-h":!0}),T(z)!=="svelte-1ezxfdw"&&(z.innerHTML=mM),nt=s(e),J(H.$$.fragment,e),Tt=s(e),X=n(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-7nae39"&&(X.innerHTML=fM),ct=s(e),P=n(e,"P",{"data-svelte-h":!0}),T(P)!=="svelte-sjd8l1"&&(P.innerHTML=rM),Jt=s(e),J(q.$$.fragment,e),ot=s(e),K=n(e,"P",{"data-svelte-h":!0}),T(K)!=="svelte-dxew1x"&&(K.innerHTML=pM),ht=s(e),J(ee.$$.fragment,e),Ut=s(e),le=n(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-f64xkc"&&(le.innerHTML=CM),yt=s(e),te=n(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-178rlr8"&&(te.innerHTML=uM),dt=s(e),ae=n(e,"P",{"data-svelte-h":!0}),T(ae)!=="svelte-lua08t"&&(ae.innerHTML=bM),wt=s(e),J(Me.$$.fragment,e),jt=s(e),J(se.$$.fragment,e),It=s(e),ie=n(e,"P",{"data-svelte-h":!0}),T(ie)!=="svelte-1cw24ss"&&(ie.textContent=AM),mt=s(e),J(ne.$$.fragment,e),ft=s(e),J(Te.$$.fragment,e),rt=s(e),ce=n(e,"P",{"data-svelte-h":!0}),T(ce)!=="svelte-1foktgq"&&(ce.innerHTML=gM),pt=s(e),Je=n(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-x8ev9q"&&(Je.innerHTML=ZM),Ct=s(e),oe=n(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-1ue61z6"&&(oe.innerHTML=kM),ut=s(e),J(he.$$.fragment,e),bt=s(e),Ue=n(e,"P",{"data-svelte-h":!0}),T(Ue)!=="svelte-1c7cy9h"&&(Ue.innerHTML=NM),At=s(e),ye=n(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-1rhvv9m"&&(ye.innerHTML=YM),gt=s(e),J(de.$$.fragment,e),Zt=s(e),we=n(e,"P",{"data-svelte-h":!0}),T(we)!=="svelte-15ugur5"&&(we.innerHTML=GM),kt=s(e),je=n(e,"P",{"data-svelte-h":!0}),T(je)!=="svelte-1c841w2"&&(je.innerHTML=WM),Nt=s(e),J(Ie.$$.fragment,e),Yt=s(e),me=n(e,"P",{"data-svelte-h":!0}),T(me)!=="svelte-jcytje"&&(me.textContent=vM),Gt=s(e),fe=n(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-im7pgk"&&(fe.innerHTML=LM),Wt=s(e),J(re.$$.fragment,e),vt=s(e),pe=n(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-gkyc1z"&&(pe.innerHTML=RM),Lt=s(e),Ce=n(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-16gi99u"&&(Ce.innerHTML=SM),Rt=s(e),ue=n(e,"P",{"data-svelte-h":!0}),T(ue)!=="svelte-1nna80w"&&(ue.innerHTML=BM),St=s(e),J(be.$$.fragment,e),Bt=s(e),Ae=n(e,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-1shtud2"&&(Ae.textContent=xM),xt=s(e),J(ge.$$.fragment,e),Qt=s(e),Ze=n(e,"P",{"data-svelte-h":!0}),T(Ze)!=="svelte-h63bo"&&(Ze.innerHTML=QM),Dt=s(e),ke=n(e,"UL",{"data-svelte-h":!0}),T(ke)!=="svelte-1sf7fpu"&&(ke.innerHTML=DM),Ft=s(e),Ne=n(e,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-5htz2c"&&(Ne.textContent=FM),$t=s(e),Ye=n(e,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-imyi1b"&&(Ye.textContent=$M),Ot=s(e),J(Ge.$$.fragment,e),Et=s(e),We=n(e,"P",{"data-svelte-h":!0}),T(We)!=="svelte-1ehbkqu"&&(We.innerHTML=OM),Vt=s(e),ve=n(e,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-l27c1a"&&(ve.innerHTML=EM),_t=s(e),Le=n(e,"P",{"data-svelte-h":!0}),T(Le)!=="svelte-yngdyh"&&(Le.innerHTML=VM),zt=s(e),Re=n(e,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-er0a1o"&&(Re.innerHTML=_M),Ht=s(e),J(Se.$$.fragment,e),Xt=s(e),Be=n(e,"P",{"data-svelte-h":!0}),T(Be)!=="svelte-7cx0vv"&&(Be.innerHTML=zM),Pt=s(e),J(xe.$$.fragment,e),qt=s(e),Qe=n(e,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-1r0ndhn"&&(Qe.innerHTML=HM),Kt=s(e),J(De.$$.fragment,e),ea=s(e),J(p.$$.fragment,e),la=s(e),J(Fe.$$.fragment,e),ta=s(e),$e=n(e,"P",{"data-svelte-h":!0}),T($e)!=="svelte-1lsljsl"&&($e.textContent=XM),aa=s(e),J(Oe.$$.fragment,e),Ma=s(e),J(Ee.$$.fragment,e),sa=s(e),J(Ve.$$.fragment,e),ia=s(e),_e=n(e,"P",{"data-svelte-h":!0}),T(_e)!=="svelte-1ppewq"&&(_e.innerHTML=PM),na=s(e),ze=n(e,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-1ycn1eb"&&(ze.innerHTML=qM),Ta=s(e),He=n(e,"P",{"data-svelte-h":!0}),T(He)!=="svelte-18l68mc"&&(He.innerHTML=KM),ca=s(e),Xe=n(e,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-1ss2857"&&(Xe.textContent=es),Ja=s(e),J(Pe.$$.fragment,e),oa=s(e),qe=n(e,"P",{"data-svelte-h":!0}),T(qe)!=="svelte-2cqqt0"&&(qe.innerHTML=ls),ha=s(e),J(Ke.$$.fragment,e),Ua=s(e),el=n(e,"P",{"data-svelte-h":!0}),T(el)!=="svelte-4zvnaj"&&(el.innerHTML=ts),ya=s(e),ll=n(e,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-1h7dpll"&&(ll.innerHTML=as),da=s(e),J(tl.$$.fragment,e),wa=s(e),al=n(e,"P",{"data-svelte-h":!0}),T(al)!=="svelte-b9d1g2"&&(al.innerHTML=Ms),ja=s(e),Ml=n(e,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-1bx4n8u"&&(Ml.innerHTML=ss),Ia=s(e),sl=n(e,"P",{"data-svelte-h":!0}),T(sl)!=="svelte-83019z"&&(sl.textContent=is),ma=s(e),il=n(e,"UL",{"data-svelte-h":!0}),T(il)!=="svelte-qwuhrl"&&(il.innerHTML=ns),fa=s(e),nl=n(e,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-xp69b3"&&(nl.textContent=Ts),ra=s(e),J(Tl.$$.fragment,e),pa=s(e),J(cl.$$.fragment,e),Ca=s(e),Jl=n(e,"P",{"data-svelte-h":!0}),T(Jl)!=="svelte-1jpuvb3"&&(Jl.innerHTML=cs),ua=s(e),ol=n(e,"P",{"data-svelte-h":!0}),T(ol)!=="svelte-s9tc9t"&&(ol.innerHTML=Js),ba=s(e),hl=n(e,"P",{"data-svelte-h":!0}),T(hl)!=="svelte-1wode1b"&&(hl.innerHTML=os),Aa=s(e),Ul=n(e,"P",{"data-svelte-h":!0}),T(Ul)!=="svelte-19y0r7c"&&(Ul.textContent=hs),ga=s(e),yl=n(e,"UL",{"data-svelte-h":!0}),T(yl)!=="svelte-o7nsmh"&&(yl.innerHTML=Us),Za=s(e),J(C.$$.fragment,e),ka=s(e),J(u.$$.fragment,e),Na=s(e),dl=n(e,"P",{"data-svelte-h":!0}),T(dl)!=="svelte-13xgrrb"&&(dl.innerHTML=ys),Ya=s(e),wl=n(e,"P",{"data-svelte-h":!0}),T(wl)!=="svelte-1arrz5p"&&(wl.innerHTML=ds),Ga=s(e),jl=n(e,"P",{"data-svelte-h":!0}),T(jl)!=="svelte-vbosxs"&&(jl.innerHTML=ws),Wa=s(e),Il=n(e,"P",{"data-svelte-h":!0}),T(Il)!=="svelte-yr0mit"&&(Il.textContent=js),va=s(e),J(ml.$$.fragment,e),La=s(e),fl=n(e,"P",{"data-svelte-h":!0}),T(fl)!=="svelte-gq4pgy"&&(fl.textContent=Is),Ra=s(e),J(rl.$$.fragment,e),Sa=s(e),pl=n(e,"P",{"data-svelte-h":!0}),T(pl)!=="svelte-20gxv"&&(pl.textContent=ms),Ba=s(e),b=n(e,"DIV",{class:!0,"data-svelte-h":!0}),T(b)!=="svelte-17iq48i"&&(b.innerHTML=fs),xa=s(e),Cl=n(e,"P",{"data-svelte-h":!0}),T(Cl)!=="svelte-7awvfp"&&(Cl.textContent=rs),Qa=s(e),ul=n(e,"UL",{"data-svelte-h":!0}),T(ul)!=="svelte-76obk"&&(ul.innerHTML=ps),Da=s(e),bl=n(e,"P",{"data-svelte-h":!0}),T(bl)!=="svelte-aoo47g"&&(bl.innerHTML=Cs),Fa=s(e),J(Al.$$.fragment,e),$a=s(e),gl=n(e,"P",{"data-svelte-h":!0}),T(gl)!=="svelte-ewwg27"&&(gl.innerHTML=us),Oa=s(e),Zl=n(e,"P",{"data-svelte-h":!0}),T(Zl)!=="svelte-ymcz12"&&(Zl.textContent=bs),Ea=s(e),kl=n(e,"P",{"data-svelte-h":!0}),T(kl)!=="svelte-u5k7vk"&&(kl.innerHTML=As),Va=s(e),Nl=n(e,"P",{"data-svelte-h":!0}),T(Nl)!=="svelte-1baaith"&&(Nl.innerHTML=gs),_a=s(e),J(Yl.$$.fragment,e),za=s(e),Gl=n(e,"P",{"data-svelte-h":!0}),T(Gl)!=="svelte-15nmp2q"&&(Gl.textContent=Zs),Ha=s(e),J(Wl.$$.fragment,e),Xa=s(e),vl=n(e,"P",{"data-svelte-h":!0}),T(vl)!=="svelte-1ayyols"&&(vl.innerHTML=ks),Pa=s(e),Ll=n(e,"P",{"data-svelte-h":!0}),T(Ll)!=="svelte-qm6d3g"&&(Ll.innerHTML=Ns),qa=s(e),J(Rl.$$.fragment,e),Ka=s(e),J(Sl.$$.fragment,e),eM=s(e),Bl=n(e,"P",{}),vs(Bl).forEach(t),this.h()},h(){tM(d,"name","hf:doc:metadata"),tM(d,"content",Vs),tM(b,"class","flex justify-center")},m(e,l){Qs(document.head,d),a(e,m,l),a(e,w,l),a(e,f,l),o(A,e,l),a(e,xl,l),a(e,g,l),a(e,Ql,l),o(Z,e,l),a(e,Dl,l),a(e,k,l),a(e,Fl,l),a(e,N,l),a(e,$l,l),o(Y,e,l),a(e,Ol,l),a(e,G,l),a(e,El,l),a(e,W,l),a(e,Vl,l),o(v,e,l),a(e,_l,l),a(e,L,l),a(e,zl,l),a(e,R,l),a(e,Hl,l),o(S,e,l),a(e,Xl,l),a(e,B,l),a(e,Pl,l),o(x,e,l),a(e,ql,l),a(e,Q,l),a(e,Kl,l),a(e,D,l),a(e,et,l),a(e,F,l),a(e,lt,l),o($,e,l),a(e,tt,l),a(e,O,l),a(e,at,l),o(E,e,l),a(e,Mt,l),a(e,V,l),a(e,st,l),a(e,_,l),a(e,it,l),a(e,z,l),a(e,nt,l),o(H,e,l),a(e,Tt,l),a(e,X,l),a(e,ct,l),a(e,P,l),a(e,Jt,l),o(q,e,l),a(e,ot,l),a(e,K,l),a(e,ht,l),o(ee,e,l),a(e,Ut,l),a(e,le,l),a(e,yt,l),a(e,te,l),a(e,dt,l),a(e,ae,l),a(e,wt,l),o(Me,e,l),a(e,jt,l),o(se,e,l),a(e,It,l),a(e,ie,l),a(e,mt,l),o(ne,e,l),a(e,ft,l),o(Te,e,l),a(e,rt,l),a(e,ce,l),a(e,pt,l),a(e,Je,l),a(e,Ct,l),a(e,oe,l),a(e,ut,l),o(he,e,l),a(e,bt,l),a(e,Ue,l),a(e,At,l),a(e,ye,l),a(e,gt,l),o(de,e,l),a(e,Zt,l),a(e,we,l),a(e,kt,l),a(e,je,l),a(e,Nt,l),o(Ie,e,l),a(e,Yt,l),a(e,me,l),a(e,Gt,l),a(e,fe,l),a(e,Wt,l),o(re,e,l),a(e,vt,l),a(e,pe,l),a(e,Lt,l),a(e,Ce,l),a(e,Rt,l),a(e,ue,l),a(e,St,l),o(be,e,l),a(e,Bt,l),a(e,Ae,l),a(e,xt,l),o(ge,e,l),a(e,Qt,l),a(e,Ze,l),a(e,Dt,l),a(e,ke,l),a(e,Ft,l),a(e,Ne,l),a(e,$t,l),a(e,Ye,l),a(e,Ot,l),o(Ge,e,l),a(e,Et,l),a(e,We,l),a(e,Vt,l),a(e,ve,l),a(e,_t,l),a(e,Le,l),a(e,zt,l),a(e,Re,l),a(e,Ht,l),o(Se,e,l),a(e,Xt,l),a(e,Be,l),a(e,Pt,l),o(xe,e,l),a(e,qt,l),a(e,Qe,l),a(e,Kt,l),o(De,e,l),a(e,ea,l),o(p,e,l),a(e,la,l),o(Fe,e,l),a(e,ta,l),a(e,$e,l),a(e,aa,l),o(Oe,e,l),a(e,Ma,l),o(Ee,e,l),a(e,sa,l),o(Ve,e,l),a(e,ia,l),a(e,_e,l),a(e,na,l),a(e,ze,l),a(e,Ta,l),a(e,He,l),a(e,ca,l),a(e,Xe,l),a(e,Ja,l),o(Pe,e,l),a(e,oa,l),a(e,qe,l),a(e,ha,l),o(Ke,e,l),a(e,Ua,l),a(e,el,l),a(e,ya,l),a(e,ll,l),a(e,da,l),o(tl,e,l),a(e,wa,l),a(e,al,l),a(e,ja,l),a(e,Ml,l),a(e,Ia,l),a(e,sl,l),a(e,ma,l),a(e,il,l),a(e,fa,l),a(e,nl,l),a(e,ra,l),o(Tl,e,l),a(e,pa,l),o(cl,e,l),a(e,Ca,l),a(e,Jl,l),a(e,ua,l),a(e,ol,l),a(e,ba,l),a(e,hl,l),a(e,Aa,l),a(e,Ul,l),a(e,ga,l),a(e,yl,l),a(e,Za,l),o(C,e,l),a(e,ka,l),o(u,e,l),a(e,Na,l),a(e,dl,l),a(e,Ya,l),a(e,wl,l),a(e,Ga,l),a(e,jl,l),a(e,Wa,l),a(e,Il,l),a(e,va,l),o(ml,e,l),a(e,La,l),a(e,fl,l),a(e,Ra,l),o(rl,e,l),a(e,Sa,l),a(e,pl,l),a(e,Ba,l),a(e,b,l),a(e,xa,l),a(e,Cl,l),a(e,Qa,l),a(e,ul,l),a(e,Da,l),a(e,bl,l),a(e,Fa,l),o(Al,e,l),a(e,$a,l),a(e,gl,l),a(e,Oa,l),a(e,Zl,l),a(e,Ea,l),a(e,kl,l),a(e,Va,l),a(e,Nl,l),a(e,_a,l),o(Yl,e,l),a(e,za,l),a(e,Gl,l),a(e,Ha,l),o(Wl,e,l),a(e,Xa,l),a(e,vl,l),a(e,Pa,l),a(e,Ll,l),a(e,qa,l),o(Rl,e,l),a(e,Ka,l),o(Sl,e,l),a(e,eM,l),a(e,Bl,l),lM=!0},p(e,[l]){const Ys={};l&2&&(Ys.$$scope={dirty:l,ctx:e}),p.$set(Ys);const Gs={};l&2&&(Gs.$$scope={dirty:l,ctx:e}),C.$set(Gs);const Ws={};l&2&&(Ws.$$scope={dirty:l,ctx:e}),u.$set(Ws)},i(e){lM||(h(A.$$.fragment,e),h(Z.$$.fragment,e),h(Y.$$.fragment,e),h(v.$$.fragment,e),h(S.$$.fragment,e),h(x.$$.fragment,e),h($.$$.fragment,e),h(E.$$.fragment,e),h(H.$$.fragment,e),h(q.$$.fragment,e),h(ee.$$.fragment,e),h(Me.$$.fragment,e),h(se.$$.fragment,e),h(ne.$$.fragment,e),h(Te.$$.fragment,e),h(he.$$.fragment,e),h(de.$$.fragment,e),h(Ie.$$.fragment,e),h(re.$$.fragment,e),h(be.$$.fragment,e),h(ge.$$.fragment,e),h(Ge.$$.fragment,e),h(Se.$$.fragment,e),h(xe.$$.fragment,e),h(De.$$.fragment,e),h(p.$$.fragment,e),h(Fe.$$.fragment,e),h(Oe.$$.fragment,e),h(Ee.$$.fragment,e),h(Ve.$$.fragment,e),h(Pe.$$.fragment,e),h(Ke.$$.fragment,e),h(tl.$$.fragment,e),h(Tl.$$.fragment,e),h(cl.$$.fragment,e),h(C.$$.fragment,e),h(u.$$.fragment,e),h(ml.$$.fragment,e),h(rl.$$.fragment,e),h(Al.$$.fragment,e),h(Yl.$$.fragment,e),h(Wl.$$.fragment,e),h(Rl.$$.fragment,e),h(Sl.$$.fragment,e),lM=!0)},o(e){U(A.$$.fragment,e),U(Z.$$.fragment,e),U(Y.$$.fragment,e),U(v.$$.fragment,e),U(S.$$.fragment,e),U(x.$$.fragment,e),U($.$$.fragment,e),U(E.$$.fragment,e),U(H.$$.fragment,e),U(q.$$.fragment,e),U(ee.$$.fragment,e),U(Me.$$.fragment,e),U(se.$$.fragment,e),U(ne.$$.fragment,e),U(Te.$$.fragment,e),U(he.$$.fragment,e),U(de.$$.fragment,e),U(Ie.$$.fragment,e),U(re.$$.fragment,e),U(be.$$.fragment,e),U(ge.$$.fragment,e),U(Ge.$$.fragment,e),U(Se.$$.fragment,e),U(xe.$$.fragment,e),U(De.$$.fragment,e),U(p.$$.fragment,e),U(Fe.$$.fragment,e),U(Oe.$$.fragment,e),U(Ee.$$.fragment,e),U(Ve.$$.fragment,e),U(Pe.$$.fragment,e),U(Ke.$$.fragment,e),U(tl.$$.fragment,e),U(Tl.$$.fragment,e),U(cl.$$.fragment,e),U(C.$$.fragment,e),U(u.$$.fragment,e),U(ml.$$.fragment,e),U(rl.$$.fragment,e),U(Al.$$.fragment,e),U(Yl.$$.fragment,e),U(Wl.$$.fragment,e),U(Rl.$$.fragment,e),U(Sl.$$.fragment,e),lM=!1},d(e){e&&(t(m),t(w),t(f),t(xl),t(g),t(Ql),t(Dl),t(k),t(Fl),t(N),t($l),t(Ol),t(G),t(El),t(W),t(Vl),t(_l),t(L),t(zl),t(R),t(Hl),t(Xl),t(B),t(Pl),t(ql),t(Q),t(Kl),t(D),t(et),t(F),t(lt),t(tt),t(O),t(at),t(Mt),t(V),t(st),t(_),t(it),t(z),t(nt),t(Tt),t(X),t(ct),t(P),t(Jt),t(ot),t(K),t(ht),t(Ut),t(le),t(yt),t(te),t(dt),t(ae),t(wt),t(jt),t(It),t(ie),t(mt),t(ft),t(rt),t(ce),t(pt),t(Je),t(Ct),t(oe),t(ut),t(bt),t(Ue),t(At),t(ye),t(gt),t(Zt),t(we),t(kt),t(je),t(Nt),t(Yt),t(me),t(Gt),t(fe),t(Wt),t(vt),t(pe),t(Lt),t(Ce),t(Rt),t(ue),t(St),t(Bt),t(Ae),t(xt),t(Qt),t(Ze),t(Dt),t(ke),t(Ft),t(Ne),t($t),t(Ye),t(Ot),t(Et),t(We),t(Vt),t(ve),t(_t),t(Le),t(zt),t(Re),t(Ht),t(Xt),t(Be),t(Pt),t(qt),t(Qe),t(Kt),t(ea),t(la),t(ta),t($e),t(aa),t(Ma),t(sa),t(ia),t(_e),t(na),t(ze),t(Ta),t(He),t(ca),t(Xe),t(Ja),t(oa),t(qe),t(ha),t(Ua),t(el),t(ya),t(ll),t(da),t(wa),t(al),t(ja),t(Ml),t(Ia),t(sl),t(ma),t(il),t(fa),t(nl),t(ra),t(pa),t(Ca),t(Jl),t(ua),t(ol),t(ba),t(hl),t(Aa),t(Ul),t(ga),t(yl),t(Za),t(ka),t(Na),t(dl),t(Ya),t(wl),t(Ga),t(jl),t(Wa),t(Il),t(va),t(La),t(fl),t(Ra),t(Sa),t(pl),t(Ba),t(b),t(xa),t(Cl),t(Qa),t(ul),t(Da),t(bl),t(Fa),t($a),t(gl),t(Oa),t(Zl),t(Ea),t(kl),t(Va),t(Nl),t(_a),t(za),t(Gl),t(Ha),t(Xa),t(vl),t(Pa),t(Ll),t(qa),t(Ka),t(eM),t(Bl)),t(d),y(A,e),y(Z,e),y(Y,e),y(v,e),y(S,e),y(x,e),y($,e),y(E,e),y(H,e),y(q,e),y(ee,e),y(Me,e),y(se,e),y(ne,e),y(Te,e),y(he,e),y(de,e),y(Ie,e),y(re,e),y(be,e),y(ge,e),y(Ge,e),y(Se,e),y(xe,e),y(De,e),y(p,e),y(Fe,e),y(Oe,e),y(Ee,e),y(Ve,e),y(Pe,e),y(Ke,e),y(tl,e),y(Tl,e),y(cl,e),y(C,e),y(u,e),y(ml,e),y(rl,e),y(Al,e),y(Yl,e),y(Wl,e),y(Rl,e),y(Sl,e)}}}const Vs='{"title":"Understand caching","local":"understand-caching","sections":[{"title":"File-based caching","local":"file-based-caching","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (advanced)","local":"noexist-advanced","sections":[],"depth":3},{"title":"In practice","local":"in-practice","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Chunk-based caching (Xet)","local":"chunk-based-caching-xet","sections":[{"title":"chunk_cache","local":"chunkcache","sections":[],"depth":3},{"title":"shard_cache","local":"shardcache","sections":[],"depth":3},{"title":"Limits and Limitations","local":"limits-and-limitations","sections":[],"depth":3}],"depth":2},{"title":"Caching assets","local":"caching-assets","sections":[{"title":"Assets in practice","local":"assets-in-practice","sections":[],"depth":3}],"depth":2},{"title":"Manage your file-based cache","local":"manage-your-file-based-cache","sections":[{"title":"Scan your cache","local":"scan-your-cache","sections":[],"depth":3},{"title":"Clean your cache","local":"clean-your-cache","sections":[],"depth":3}],"depth":2}],"depth":1}';function _s(r){return Rs(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ks extends Ss{constructor(d){super(),Bs(this,d,_s,Es,Ls,{})}}export{Ks as component};
