import{s as js,o as Us,n as Es}from"../chunks/scheduler.6062bdaf.js";import{S as Hs,i as Js,g as o,s as r,r as p,A as Ns,h as n,f as s,c as a,j as h,u as d,x as l,k as g,y as e,a as v,v as u,d as m,t as f,w as _}from"../chunks/index.4bca734e.js";import{T as Vs}from"../chunks/Tip.b9ac1f03.js";import{D as y}from"../chunks/Docstring.1e02b952.js";import{C as Fs}from"../chunks/CodeBlock.f213e6a5.js";import{I as Hn}from"../chunks/IconCopyLink.68a13644.js";import{E as As}from"../chunks/ExampleCodeBlock.082a8242.js";function Ss(xt){let x,E="Raises the following error:",C,w,T=`<li><p><a href="https://docs.python.org/3/library/exceptions.html#ValueError" rel="nofollow"><code>ValueError</code></a>
if an organization token (starts with “api_org”) is passed. Use must use
your own personal access token (see <a href="https://hf.co/settings/tokens" rel="nofollow">https://hf.co/settings/tokens</a>).</p></li> <li><p><a href="https://docs.python.org/3/library/exceptions.html#EnvironmentError" rel="nofollow"><code>EnvironmentError</code></a>
if you are trying to clone the repository in a non-empty folder, or if the
<code>git</code> operations raise errors.</p></li>`;return{c(){x=o("p"),x.textContent=E,C=r(),w=o("ul"),w.innerHTML=T},l($){x=n($,"P",{"data-svelte-h":!0}),l(x)!=="svelte-1f6kjc7"&&(x.textContent=E),C=a($),w=n($,"UL",{"data-svelte-h":!0}),l(w)!=="svelte-dnmxmk"&&(w.innerHTML=T)},m($,L){v($,x,L),v($,C,L),v($,w,L)},p:Es,d($){$&&(s(x),s(C),s(w))}}}function qs(xt){let x,E="Examples:",C,w,T;return w=new Fs({props:{code:"d2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMGNsb25lX2Zyb20lM0QlMjIlM0N1c2VyJTNFJTJGdGV4dC1maWxlcyUyMiUyQyUwQSUyMCUyMCUyMCUyMHRva2VuJTNEVHJ1ZSUyQyUwQSkuY29tbWl0KCUyMk15JTIwZmlyc3QlMjBmaWxlJTIwJTNBKSUyMiklM0ElMEElMjAlMjAlMjAlMjB3aXRoJTIwb3BlbiglMjJmaWxlLnR4dCUyMiUyQyUyMCUyMnclMkIlMjIpJTIwYXMlMjBmJTNBJTBBJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwZi53cml0ZShqc29uLmR1bXBzKCU3QiUyMmhleSUyMiUzQSUyMDglN0QpKSUwQSUwQWltcG9ydCUyMHRvcmNoJTBBJTBBbW9kZWwlMjAlM0QlMjB0b3JjaC5ubi5UcmFuc2Zvcm1lcigpJTBBd2l0aCUyMFJlcG9zaXRvcnkoJTBBJTIwJTIwJTIwJTIwJTIydG9yY2gtbW9kZWwlMjIlMkMlMEElMjAlMjAlMjAlMjBjbG9uZV9mcm9tJTNEJTIyJTNDdXNlciUzRSUyRnRvcmNoLW1vZGVsJTIyJTJDJTBBJTIwJTIwJTIwJTIwdG9rZW4lM0RUcnVlJTJDJTBBKS5jb21taXQoJTIyTXklMjBjb29sJTIwbW9kZWwlMjAlM0EpJTIyKSUzQSUwQSUyMCUyMCUyMCUyMHRvcmNoLnNhdmUobW9kZWwuc3RhdGVfZGljdCgpJTJDJTIwJTIybW9kZWwucHQlMjIp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;text-files&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/text-files&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My first file :)&quot;</span>):
<span class="hljs-meta">... </span>    <span class="hljs-keyword">with</span> <span class="hljs-built_in">open</span>(<span class="hljs-string">&quot;file.txt&quot;</span>, <span class="hljs-string">&quot;w+&quot;</span>) <span class="hljs-keyword">as</span> f:
<span class="hljs-meta">... </span>        f.write(json.dumps({<span class="hljs-string">&quot;hey&quot;</span>: <span class="hljs-number">8</span>}))

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch

<span class="hljs-meta">&gt;&gt;&gt; </span>model = torch.nn.Transformer()
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">with</span> Repository(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;torch-model&quot;</span>,
<span class="hljs-meta">... </span>    clone_from=<span class="hljs-string">&quot;&lt;user&gt;/torch-model&quot;</span>,
<span class="hljs-meta">... </span>    token=<span class="hljs-literal">True</span>,
<span class="hljs-meta">&gt;&gt;&gt; </span>).commit(<span class="hljs-string">&quot;My cool model :)&quot;</span>):
<span class="hljs-meta">... </span>    torch.save(model.state_dict(), <span class="hljs-string">&quot;model.pt&quot;</span>)`}}),{c(){x=o("p"),x.textContent=E,C=r(),p(w.$$.fragment)},l($){x=n($,"P",{"data-svelte-h":!0}),l(x)!=="svelte-kvfsh7"&&(x.textContent=E),C=a($),d(w.$$.fragment,$)},m($,L){v($,x,L),v($,C,L),u(w,$,L),T=!0},p:Es,i($){T||(m(w.$$.fragment,$),T=!0)},o($){f(w.$$.fragment,$),T=!1},d($){$&&(s(x),s(C)),_(w,$)}}}function Ws(xt){let x,E,C,w,T,$,L,wt,ba="Managing local and online repositories",Jo,Te,va=`The <code>Repository</code> class is a helper class that wraps <code>git</code> and <code>git-lfs</code> commands. It provides tooling adapted
for managing repositories which can be very large.`,No,Re,ya=`It is the recommended tool as soon as any <code>git</code> operation is involved, or when collaboration will be a point
of focus with the repository itself.`,Vo,V,G,Eo,Ie,Jn,Ct,$a="The Repository class",Fo,i,De,Nn,kt,xa="Helper class to wrap the git and git-lfs commands.",Vn,Tt,wa=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,Fn,R,Me,An,Rt,Ca="Instantiate a local clone of a git repo.",Sn,It,ka=`If <code>clone_from</code> is set, the repo will be cloned from an existing remote repository.
If the remote repo does not exist, a <code>EnvironmentError</code> exception will be thrown.
Please create the remote repo first using <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi.create_repo">create_repo()</a>.`,qn,Dt,Ta=`<code>Repository</code> uses the local git credentials by default. If explicitly set, the <code>token</code>
or the <code>git_user</code>/<code>git_email</code> pair will be used instead.`,Wn,Z,Le,Bn,Mt,Ra="Returns the current checked out branch.",On,I,Pe,zn,Lt,Ia="Add a tag at the current head and push it",Qn,Pt,Da="If remote is None, will just be updated locally",Gn,Et,Ma=`If no message is provided, the tag will be lightweight. if a message is
provided, the tag will be annotated.`,Zn,X,Ee,Xn,jt,La="Automatically track binary files with git-lfs.",Kn,K,je,Yn,Ut,Pa=`Automatically track large files (files that weigh more than 10MBs) with
git-lfs.`,er,Y,Ue,tr,Ht,Ea="Checks that <code>git</code> and <code>git-lfs</code> can be run.",or,D,He,nr,Jt,ja=`Clone from a remote. If the folder already exists, will try to clone the
repository within it.`,rr,Nt,Ua=`If this folder is a git repository with linked history, will try to
update the repository.`,ar,ee,sr,j,Je,ir,Vt,Ha=`Context manager utility to handle committing to a repository. This
automatically tracks large files (&gt;10Mb) with git-lfs. Set the
<code>track_large_files</code> argument to <code>False</code> if you wish to ignore that
behavior.`,lr,te,cr,oe,Ne,gr,Ft,Ja="Delete a tag, both local and remote, if it exists",hr,U,Ve,pr,At,Na="git add",dr,St,Va=`Setting the <code>auto_lfs_track</code> parameter to <code>True</code> will automatically
track files that are larger than 10MB with <code>git-lfs</code>.`,ur,H,Fe,mr,qt,Fa="git checkout a given revision",fr,Wt,Aa=`Specifying <code>create_branch_ok</code> to <code>True</code> will create the branch to the
given revision if that revision doesn’t exist.`,_r,ne,Ae,br,Bt,Sa="git commit",vr,re,Se,yr,Ot,qa="Sets git username and email (only in the current repo).",$r,ae,qe,xr,zt,Wa="Sets the git credential helper to <code>store</code>",wr,se,We,Cr,Qt,Ba=`Get URL to last commit on HEAD. We assume it’s been pushed, and the url
scheme is the same one as for GitHub or HuggingFace.`,kr,ie,Be,Tr,Gt,Oa="Get commit sha on top of HEAD.",Rr,le,Oe,Ir,Zt,za="git pull",Dr,J,ze,Mr,Xt,Qa="git push",Lr,Kt,Ga=`If used without setting <code>blocking</code>, will return url to commit on remote
repo. If used with <code>blocking=True</code>, will return a tuple containing the
url to commit and the command object to follow for information about the
process.`,Pr,ce,Qe,Er,Yt,Za="Get URL to origin remote.",jr,ge,Ge,Ur,eo,Xa="Return whether or not the git status is clean or not",Hr,he,Ze,Jr,to,Ka="HF-specific. This enables upload support of files >5GB.",Nr,pe,Xe,Vr,oo,Ya="git lfs prune",Fr,N,Ke,Ar,no,es="Tell git-lfs to track files according to a pattern.",Sr,ro,ts=`Setting the <code>filename</code> argument to <code>True</code> will treat the arguments as
literal filenames, not as patterns. Any special glob characters in the
filename will be escaped when writing to the <code>.gitattributes</code> file.`,qr,de,Ye,Wr,ao,os="Tell git-lfs to untrack those files.",Br,ue,et,Or,so,ns=`Returns a list of the files that are deleted in the working directory or
index.`,zr,me,tt,Qr,io,rs=`Helper to add, commit, and push files to remote repository on the
HuggingFace Hub. Will automatically track large files (>10MB).`,Gr,fe,ot,Zr,lo,as="Check if a tag exists or not.",Xr,_e,nt,Kr,co,ss=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,Ao,F,be,jo,rt,Yr,go,is="Helper methods",So,A,at,ea,ho,ls="Check if the folder is the root or part of a git repository",qo,S,st,ta,po,cs="Check if the folder is a local clone of the remote_url",Wo,q,it,oa,uo,gs="Check if the file passed is tracked with git-lfs.",Bo,W,lt,na,mo,hs="Check if file is git-ignored. Supports nested .gitignore files.",Oo,B,ct,ra,fo,ps="Returns a list of filenames that are to be staged.",zo,O,gt,aa,_o,ds="Check if the current checked-out branch is tracked upstream.",Qo,P,ht,sa,bo,us="Check the number of commits that would be pushed upstream",ia,vo,ms=`The name of the upstream repository with which the comparison should be
made.`,Go,z,ve,Uo,pt,la,yo,fs="Following asynchronous commands",Zo,dt,_s="The <code>Repository</code> utility offers several methods which can be launched asynchronously:",Xo,ut,bs="<li><code>git_push</code></li> <li><code>git_pull</code></li> <li><code>push_to_hub</code></li> <li>The <code>commit</code> context manager</li>",Ko,mt,vs="See below for utilities to manage such asynchronous methods.",Yo,k,ft,ca,$o,ys="Helper class to wrap the git and git-lfs commands.",ga,xo,$s=`The aim is to facilitate interacting with huggingface.co hosted model or
dataset repos, though not a lot here (if any) is actually specific to
huggingface.co.`,ha,ye,_t,pa,wo,xs="Returns the asynchronous commands that failed.",da,$e,bt,ua,Co,ws="Returns the asynchronous commands that are currently in progress.",ma,xe,vt,fa,ko,Cs=`Blocking method: blocks all subsequent execution until all commands have
been processed.`,en,Q,yt,_a,To,ks="Utility to follow commands launched asynchronously.",tn;return $=new Hn({}),Ie=new Hn({}),De=new y({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": typing.Union[str, pathlib.Path]"},{name:"clone_from",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str] = True"},{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": typing.Optional[huggingface_hub.hf_api.HfApi] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L424"}}),Me=new y({props:{name:"__init__",anchor:"huggingface_hub.Repository.__init__",parameters:[{name:"local_dir",val:": typing.Union[str, pathlib.Path]"},{name:"clone_from",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str] = True"},{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": typing.Optional[huggingface_hub.hf_api.HfApi] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.__init__.local_dir",description:`<strong>local_dir</strong> (<code>str</code> or <code>Path</code>) &#x2014;
path (e.g. <code>&apos;my_trained_model/&apos;</code>) to the local directory, where
the <code>Repository</code> will be initialized.`,name:"local_dir"},{anchor:"huggingface_hub.Repository.__init__.clone_from",description:`<strong>clone_from</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Either a repository url or <code>repo_id</code>.
Example:<ul>
<li><code>&quot;https://huggingface.co/philschmid/playground-tests&quot;</code></li>
<li><code>&quot;philschmid/playground-tests&quot;</code></li>
</ul>`,name:"clone_from"},{anchor:"huggingface_hub.Repository.__init__.repo_type",description:`<strong>repo_type</strong> (<code>str</code>, <em>optional</em>) &#x2014;
To set when cloning a repo from a repo_id. Default is model.`,name:"repo_type"},{anchor:"huggingface_hub.Repository.__init__.token",description:`<strong>token</strong> (<code>bool</code> or <code>str</code>, <em>optional</em>) &#x2014;
A valid authentication token (see <a href="https://huggingface.co/settings/token" rel="nofollow">https://huggingface.co/settings/token</a>).
If <code>None</code> or <code>True</code> and machine is logged in (through <code>huggingface-cli login</code>
or <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/login#huggingface_hub.login">login()</a>), token will be retrieved from the cache.
If <code>False</code>, token is not sent in the request header.`,name:"token"},{anchor:"huggingface_hub.Repository.__init__.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.name</code> for committing and
pushing files to the hub.`,name:"git_user"},{anchor:"huggingface_hub.Repository.__init__.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
will override the <code>git config user.email</code> for committing and
pushing files to the hub.`,name:"git_email"},{anchor:"huggingface_hub.Repository.__init__.revision",description:`<strong>revision</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Revision to checkout after initializing the repository. If the
revision doesn&#x2019;t exist, a branch will be created with that
revision name from the default branch&#x2019;s current HEAD.`,name:"revision"},{anchor:"huggingface_hub.Repository.__init__.skip_lfs_files",description:`<strong>skip_lfs_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
whether to skip git-LFS files or not.`,name:"skip_lfs_files"},{anchor:"huggingface_hub.Repository.__init__.client",description:`<strong>client</strong> (<code>HfApi</code>, <em>optional</em>) &#x2014;
Instance of <a href="/docs/huggingface_hub/v0.17.3/en/package_reference/hf_api#huggingface_hub.HfApi">HfApi</a> to use when calling the HF Hub API. A new
instance will be created if this is left to <code>None</code>.`,name:"client"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L435",raiseDescription:`
<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if the remote repository set in <code>clone_from</code> does not exist.</li>
</ul></li>
</ul>
`,raiseType:`
<ul>
<li></li>
</ul>
`}}),Le=new y({props:{name:"current_branch",anchor:"huggingface_hub.Repository.current_branch",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L544",returnDescription:`
<p>Current checked out branch.</p>
`,returnType:`
<p><code>str</code></p>
`}}),Pe=new y({props:{name:"add_tag",anchor:"huggingface_hub.Repository.add_tag",parameters:[{name:"tag_name",val:": str"},{name:"message",val:": typing.Optional[str] = None"},{name:"remote",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.add_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to be added.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.add_tag.message",description:`<strong>message</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The message that accompanies the tag. The tag will turn into an
annotated tag if a message is passed.`,name:"message"},{anchor:"huggingface_hub.Repository.add_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to add the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1228"}}),Ee=new y({props:{name:"auto_track_binary_files",anchor:"huggingface_hub.Repository.auto_track_binary_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_binary_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are binary.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L870",returnDescription:`
<p>List of filenames that are now tracked due to being
binary files</p>
`,returnType:`
<p><code>List[str]</code></p>
`}}),je=new y({props:{name:"auto_track_large_files",anchor:"huggingface_hub.Repository.auto_track_large_files",parameters:[{name:"pattern",val:": str = '.'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.auto_track_large_files.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to track files that are above 10MBs.`,name:"pattern"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L913",returnDescription:`
<p>List of filenames that are now tracked due to their
size.</p>
`,returnType:`
<p><code>List[str]</code></p>
`}}),Ue=new y({props:{name:"check_git_versions",anchor:"huggingface_hub.Repository.check_git_versions",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L559",raiseDescription:`
<ul>
<li><ul>
<li>— <a
  href="https://docs.python.org/3/library/exceptions.html#EnvironmentError"
  rel="nofollow"
><code>EnvironmentError</code></a>
if <code>git</code> or <code>git-lfs</code> are not installed.</li>
</ul></li>
</ul>
`,raiseType:`
<ul>
<li></li>
</ul>
`}}),He=new y({props:{name:"clone_from",anchor:"huggingface_hub.Repository.clone_from",parameters:[{name:"repo_url",val:": str"},{name:"token",val:": typing.Union[bool, str, NoneType] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.clone_from.repo_url",description:`<strong>repo_url</strong> (<code>str</code>) &#x2014;
The URL from which to clone the repository`,name:"repo_url"},{anchor:"huggingface_hub.Repository.clone_from.token",description:`<strong>token</strong> (<code>Union[str, bool]</code>, <em>optional</em>) &#x2014;
Whether to use the authentication token. It can be:<ul>
<li>a string which is the token itself</li>
<li><code>False</code>, which would not use the authentication token</li>
<li><code>True</code>, which would fetch the authentication token from the
local folder and use it (you should be logged in for this to
work).</li>
<li><code>None</code>, which would retrieve the value of
<code>self.huggingface_token</code>.</li>
</ul>`,name:"token"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L582"}}),ee=new Vs({props:{$$slots:{default:[Ss]},$$scope:{ctx:xt}}}),Je=new y({props:{name:"commit",anchor:"huggingface_hub.Repository.commit",parameters:[{name:"commit_message",val:": str"},{name:"branch",val:": typing.Optional[str] = None"},{name:"track_large_files",val:": bool = True"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.commit.branch",description:`<strong>branch</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The branch on which the commit will appear. This branch will be
checked-out before any operation.`,name:"branch"},{anchor:"huggingface_hub.Repository.commit.track_large_files",description:`<strong>track_large_files</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to automatically track large files or not. Will do so by
default.`,name:"track_large_files"},{anchor:"huggingface_hub.Repository.commit.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.commit.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, defaults to <code>True</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1312"}}),te=new As({props:{anchor:"huggingface_hub.Repository.commit.example",$$slots:{default:[qs]},$$scope:{ctx:xt}}}),Ne=new y({props:{name:"delete_tag",anchor:"huggingface_hub.Repository.delete_tag",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.delete_tag.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The tag name to delete.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.delete_tag.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The remote on which to delete the tag.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1191",returnDescription:`
<p><code>True</code> if deleted, <code>False</code> if the tag didn’t exist.
If remote is not passed, will just be updated locally</p>
`,returnType:`
<p><code>bool</code></p>
`}}),Ve=new y({props:{name:"git_add",anchor:"huggingface_hub.Repository.git_add",parameters:[{name:"pattern",val:": str = '.'"},{name:"auto_lfs_track",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_add.pattern",description:`<strong>pattern</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201D;.&#x201C;) &#x2014;
The pattern with which to add files to staging.`,name:"pattern"},{anchor:"huggingface_hub.Repository.git_add.auto_lfs_track",description:`<strong>auto_lfs_track</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically track large and binary files with
git-lfs. Any file over 10MB in size, or in binary format, will
be automatically tracked.`,name:"auto_lfs_track"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L988"}}),Fe=new y({props:{name:"git_checkout",anchor:"huggingface_hub.Repository.git_checkout",parameters:[{name:"revision",val:": str"},{name:"create_branch_ok",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_checkout.revision",description:`<strong>revision</strong> (<code>str</code>) &#x2014;
The revision to checkout.`,name:"revision"},{anchor:"huggingface_hub.Repository.git_checkout.create_branch_ok",description:`<strong>create_branch_ok</strong> (<code>str</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether creating a branch named with the <code>revision</code> passed at
the current checked-out reference if <code>revision</code> isn&#x2019;t an
existing revision is allowed.`,name:"create_branch_ok"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1129"}}),Ae=new y({props:{name:"git_commit",anchor:"huggingface_hub.Repository.git_commit",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_commit.commit_message",description:`<strong>commit_message</strong> (<code>str</code>, <em>optional</em>, defaults to &#x201C;commit files to HF hub&#x201D;) &#x2014;
The message attributed to the commit.`,name:"commit_message"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1022"}}),Se=new y({props:{name:"git_config_username_and_email",anchor:"huggingface_hub.Repository.git_config_username_and_email",parameters:[{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_user",description:`<strong>git_user</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The username to register through <code>git</code>.`,name:"git_user"},{anchor:"huggingface_hub.Repository.git_config_username_and_email.git_email",description:`<strong>git_email</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The email to register through <code>git</code>.`,name:"git_email"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L710"}}),qe=new y({props:{name:"git_credential_helper_store",anchor:"huggingface_hub.Repository.git_credential_helper_store",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L729"}}),We=new y({props:{name:"git_head_commit_url",anchor:"huggingface_hub.Repository.git_head_commit_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L766",returnDescription:`
<p>The URL to the current checked-out commit.</p>
`,returnType:`
<p><code>str</code></p>
`}}),Be=new y({props:{name:"git_head_hash",anchor:"huggingface_hub.Repository.git_head_hash",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L738",returnDescription:`
<p>The current checked out commit SHA.</p>
`,returnType:`
<p><code>str</code></p>
`}}),Oe=new y({props:{name:"git_pull",anchor:"huggingface_hub.Repository.git_pull",parameters:[{name:"rebase",val:": bool = False"},{name:"lfs",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_pull.rebase",description:`<strong>rebase</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to rebase the current branch on top of the upstream
branch after fetching.`,name:"rebase"},{anchor:"huggingface_hub.Repository.git_pull.lfs",description:`<strong>lfs</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to fetch the LFS files too. This option only changes the
behavior when a repository was cloned without fetching the LFS
files; calling <code>repo.git_pull(lfs=True)</code> will then fetch the LFS
file from the remote repository.`,name:"lfs"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L964"}}),ze=new y({props:{name:"git_push",anchor:"huggingface_hub.Repository.git_push",parameters:[{name:"upstream",val:": typing.Optional[str] = None"},{name:"blocking",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.git_push.upstream",description:`<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Upstream to which this should push. If not specified, will push
to the lastly defined upstream or to the default one (<code>origin main</code>).`,name:"upstream"},{anchor:"huggingface_hub.Repository.git_push.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the push has
finished. Setting this to <code>False</code> will return an
<code>CommandInProgress</code> object which has an <code>is_done</code> property. This
property will be set to <code>True</code> when the push is finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.git_push.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1039"}}),Qe=new y({props:{name:"git_remote_url",anchor:"huggingface_hub.Repository.git_remote_url",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L751",returnDescription:`
<p>The URL of the <code>origin</code> remote.</p>
`,returnType:`
<p><code>str</code></p>
`}}),Ge=new y({props:{name:"is_repo_clean",anchor:"huggingface_hub.Repository.is_repo_clean",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1262",returnDescription:`
<p><code>True</code> if the git status is clean, <code>False</code> otherwise.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),Ze=new y({props:{name:"lfs_enable_largefiles",anchor:"huggingface_hub.Repository.lfs_enable_largefiles",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L856"}}),Xe=new y({props:{name:"lfs_prune",anchor:"huggingface_hub.Repository.lfs_prune",parameters:[{name:"recent",val:" = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_prune.recent",description:`<strong>recent</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to prune files even if they were referenced by recent
commits. See the following
<a href="https://github.com/git-lfs/git-lfs/blob/f3d43f0428a84fc4f1e5405b76b5a73ec2437e65/docs/man/git-lfs-prune.1.ronn#recent-files" rel="nofollow">link</a>
for more information.`,name:"recent"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L946"}}),Ke=new y({props:{name:"lfs_track",anchor:"huggingface_hub.Repository.lfs_track",parameters:[{name:"patterns",val:": typing.Union[str, typing.List[str]]"},{name:"filename",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_track.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to track with git-lfs.`,name:"patterns"},{anchor:"huggingface_hub.Repository.lfs_track.filename",description:`<strong>filename</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to use the patterns as literal filenames.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L815"}}),Ye=new y({props:{name:"lfs_untrack",anchor:"huggingface_hub.Repository.lfs_untrack",parameters:[{name:"patterns",val:": typing.Union[str, typing.List[str]]"}],parametersDescription:[{anchor:"huggingface_hub.Repository.lfs_untrack.patterns",description:`<strong>patterns</strong> (<code>Union[str, List[str]]</code>) &#x2014;
The pattern, or list of patterns, to untrack with git-lfs.`,name:"patterns"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L840"}}),et=new y({props:{name:"list_deleted_files",anchor:"huggingface_hub.Repository.list_deleted_files",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L780",returnDescription:`
<p>A list of files that have been deleted in the working
directory or index.</p>
`,returnType:`
<p><code>List[str]</code></p>
`}}),tt=new y({props:{name:"push_to_hub",anchor:"huggingface_hub.Repository.push_to_hub",parameters:[{name:"commit_message",val:": str = 'commit files to HF hub'"},{name:"blocking",val:": bool = True"},{name:"clean_ok",val:": bool = True"},{name:"auto_lfs_prune",val:": bool = False"}],parametersDescription:[{anchor:"huggingface_hub.Repository.push_to_hub.commit_message",description:`<strong>commit_message</strong> (<code>str</code>) &#x2014;
Message to use for the commit.`,name:"commit_message"},{anchor:"huggingface_hub.Repository.push_to_hub.blocking",description:`<strong>blocking</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether the function should return only when the <code>git push</code> has
finished.`,name:"blocking"},{anchor:"huggingface_hub.Repository.push_to_hub.clean_ok",description:`<strong>clean_ok</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
If True, this function will return None if the repo is
untouched. Default behavior is to fail because the git command
fails.`,name:"clean_ok"},{anchor:"huggingface_hub.Repository.push_to_hub.auto_lfs_prune",description:`<strong>auto_lfs_prune</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether to automatically prune files once they have been pushed
to the remote.`,name:"auto_lfs_prune"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1276"}}),ot=new y({props:{name:"tag_exists",anchor:"huggingface_hub.Repository.tag_exists",parameters:[{name:"tag_name",val:": str"},{name:"remote",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.Repository.tag_exists.tag_name",description:`<strong>tag_name</strong> (<code>str</code>) &#x2014;
The name of the tag to check.`,name:"tag_name"},{anchor:"huggingface_hub.Repository.tag_exists.remote",description:`<strong>remote</strong> (<code>str</code>, <em>optional</em>) &#x2014;
Whether to check if the tag exists on a remote. This parameter
should be the identifier of the remote.`,name:"remote"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1161",returnDescription:`
<p>Whether the tag exists.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),nt=new y({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1442"}}),rt=new Hn({}),at=new y({props:{name:"huggingface_hub.repository.is_git_repo",anchor:"huggingface_hub.repository.is_git_repo",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_repo.folder",description:`<strong>folder</strong> (<code>str</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L113",returnDescription:`
<p><code>True</code> if the repository is part of a repository, <code>False</code>
otherwise.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),st=new y({props:{name:"huggingface_hub.repository.is_local_clone",anchor:"huggingface_hub.repository.is_local_clone",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"},{name:"remote_url",val:": str"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_local_clone.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.is_local_clone.remote_url",description:`<strong>remote_url</strong> (<code>str</code>) &#x2014;
The url of a git repository.`,name:"remote_url"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L130",returnDescription:`
<p><code>True</code> if the repository is a local clone of the remote
repository specified, <code>False</code> otherwise.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),it=new y({props:{name:"huggingface_hub.repository.is_tracked_with_lfs",anchor:"huggingface_hub.repository.is_tracked_with_lfs",parameters:[{name:"filename",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_with_lfs.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L155",returnDescription:`
<p><code>True</code> if the file passed is tracked with git-lfs, <code>False</code>
otherwise.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),lt=new y({props:{name:"huggingface_hub.repository.is_git_ignored",anchor:"huggingface_hub.repository.is_git_ignored",parameters:[{name:"filename",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_git_ignored.filename",description:`<strong>filename</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The filename to check.`,name:"filename"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L192",returnDescription:`
<p><code>True</code> if the file passed is ignored by <code>git</code>, <code>False</code>
otherwise.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),ct=new y({props:{name:"huggingface_hub.repository.files_to_be_staged",anchor:"huggingface_hub.repository.files_to_be_staged",parameters:[{name:"pattern",val:": str = '.'"},{name:"folder",val:": typing.Union[str, pathlib.Path, NoneType] = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.files_to_be_staged.pattern",description:`<strong>pattern</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The pattern of filenames to check. Put <code>.</code> to get all files.`,name:"pattern"},{anchor:"huggingface_hub.repository.files_to_be_staged.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L240",returnDescription:`
<p>List of files that are to be staged.</p>
`,returnType:`
<p><code>List[str]</code></p>
`}}),gt=new y({props:{name:"huggingface_hub.repository.is_tracked_upstream",anchor:"huggingface_hub.repository.is_tracked_upstream",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"}],parametersDescription:[{anchor:"huggingface_hub.repository.is_tracked_upstream.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L265",returnDescription:`
<p><code>True</code> if the current checked-out branch is tracked upstream,
<code>False</code> otherwise.</p>
`,returnType:`
<p><code>bool</code></p>
`}}),ht=new y({props:{name:"huggingface_hub.repository.commits_to_push",anchor:"huggingface_hub.repository.commits_to_push",parameters:[{name:"folder",val:": typing.Union[str, pathlib.Path]"},{name:"upstream",val:": typing.Optional[str] = None"}],parametersDescription:[{anchor:"huggingface_hub.repository.commits_to_push.folder",description:`<strong>folder</strong> (<code>str</code> or <code>Path</code>) &#x2014;
The folder in which to run the command.`,name:"folder"},{anchor:"huggingface_hub.repository.commits_to_push.upstream",description:"<strong>upstream</strong> (<code>str</code>, <em>optional</em>) &#x2014;",name:"upstream"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L287",returnDescription:`
<p>Number of commits that would be pushed upstream were a <code>git push</code> to proceed.</p>
`,returnType:`
<p><code>int</code></p>
`}}),pt=new Hn({}),ft=new y({props:{name:"class huggingface_hub.Repository",anchor:"huggingface_hub.Repository",parameters:[{name:"local_dir",val:": typing.Union[str, pathlib.Path]"},{name:"clone_from",val:": typing.Optional[str] = None"},{name:"repo_type",val:": typing.Optional[str] = None"},{name:"token",val:": typing.Union[bool, str] = True"},{name:"git_user",val:": typing.Optional[str] = None"},{name:"git_email",val:": typing.Optional[str] = None"},{name:"revision",val:": typing.Optional[str] = None"},{name:"skip_lfs_files",val:": bool = False"},{name:"client",val:": typing.Optional[huggingface_hub.hf_api.HfApi] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L424"}}),_t=new y({props:{name:"commands_failed",anchor:"huggingface_hub.Repository.commands_failed",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1428"}}),bt=new y({props:{name:"commands_in_progress",anchor:"huggingface_hub.Repository.commands_in_progress",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1435"}}),vt=new y({props:{name:"wait_for_commands",anchor:"huggingface_hub.Repository.wait_for_commands",parameters:[],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L1442"}}),yt=new y({props:{name:"class huggingface_hub.repository.CommandInProgress",anchor:"huggingface_hub.repository.CommandInProgress",parameters:[{name:"title",val:": str"},{name:"is_done_method",val:": typing.Callable"},{name:"status_method",val:": typing.Callable"},{name:"process",val:": Popen"},{name:"post_method",val:": typing.Optional[typing.Callable] = None"}],source:"https://github.com/huggingface/huggingface_hub/blob/v0.17.3/src/huggingface_hub/repository.py#L30"}}),{c(){x=o("meta"),E=r(),C=o("h1"),w=o("a"),T=o("span"),p($.$$.fragment),L=r(),wt=o("span"),wt.textContent=ba,Jo=r(),Te=o("p"),Te.innerHTML=va,No=r(),Re=o("p"),Re.innerHTML=ya,Vo=r(),V=o("h2"),G=o("a"),Eo=o("span"),p(Ie.$$.fragment),Jn=r(),Ct=o("span"),Ct.textContent=$a,Fo=r(),i=o("div"),p(De.$$.fragment),Nn=r(),kt=o("p"),kt.textContent=xa,Vn=r(),Tt=o("p"),Tt.textContent=wa,Fn=r(),R=o("div"),p(Me.$$.fragment),An=r(),Rt=o("p"),Rt.textContent=Ca,Sn=r(),It=o("p"),It.innerHTML=ka,qn=r(),Dt=o("p"),Dt.innerHTML=Ta,Wn=r(),Z=o("div"),p(Le.$$.fragment),Bn=r(),Mt=o("p"),Mt.textContent=Ra,On=r(),I=o("div"),p(Pe.$$.fragment),zn=r(),Lt=o("p"),Lt.textContent=Ia,Qn=r(),Pt=o("p"),Pt.textContent=Da,Gn=r(),Et=o("p"),Et.textContent=Ma,Zn=r(),X=o("div"),p(Ee.$$.fragment),Xn=r(),jt=o("p"),jt.textContent=La,Kn=r(),K=o("div"),p(je.$$.fragment),Yn=r(),Ut=o("p"),Ut.textContent=Pa,er=r(),Y=o("div"),p(Ue.$$.fragment),tr=r(),Ht=o("p"),Ht.innerHTML=Ea,or=r(),D=o("div"),p(He.$$.fragment),nr=r(),Jt=o("p"),Jt.textContent=ja,rr=r(),Nt=o("p"),Nt.textContent=Ua,ar=r(),p(ee.$$.fragment),sr=r(),j=o("div"),p(Je.$$.fragment),ir=r(),Vt=o("p"),Vt.innerHTML=Ha,lr=r(),p(te.$$.fragment),cr=r(),oe=o("div"),p(Ne.$$.fragment),gr=r(),Ft=o("p"),Ft.textContent=Ja,hr=r(),U=o("div"),p(Ve.$$.fragment),pr=r(),At=o("p"),At.textContent=Na,dr=r(),St=o("p"),St.innerHTML=Va,ur=r(),H=o("div"),p(Fe.$$.fragment),mr=r(),qt=o("p"),qt.textContent=Fa,fr=r(),Wt=o("p"),Wt.innerHTML=Aa,_r=r(),ne=o("div"),p(Ae.$$.fragment),br=r(),Bt=o("p"),Bt.textContent=Sa,vr=r(),re=o("div"),p(Se.$$.fragment),yr=r(),Ot=o("p"),Ot.textContent=qa,$r=r(),ae=o("div"),p(qe.$$.fragment),xr=r(),zt=o("p"),zt.innerHTML=Wa,wr=r(),se=o("div"),p(We.$$.fragment),Cr=r(),Qt=o("p"),Qt.textContent=Ba,kr=r(),ie=o("div"),p(Be.$$.fragment),Tr=r(),Gt=o("p"),Gt.textContent=Oa,Rr=r(),le=o("div"),p(Oe.$$.fragment),Ir=r(),Zt=o("p"),Zt.textContent=za,Dr=r(),J=o("div"),p(ze.$$.fragment),Mr=r(),Xt=o("p"),Xt.textContent=Qa,Lr=r(),Kt=o("p"),Kt.innerHTML=Ga,Pr=r(),ce=o("div"),p(Qe.$$.fragment),Er=r(),Yt=o("p"),Yt.textContent=Za,jr=r(),ge=o("div"),p(Ge.$$.fragment),Ur=r(),eo=o("p"),eo.textContent=Xa,Hr=r(),he=o("div"),p(Ze.$$.fragment),Jr=r(),to=o("p"),to.textContent=Ka,Nr=r(),pe=o("div"),p(Xe.$$.fragment),Vr=r(),oo=o("p"),oo.textContent=Ya,Fr=r(),N=o("div"),p(Ke.$$.fragment),Ar=r(),no=o("p"),no.textContent=es,Sr=r(),ro=o("p"),ro.innerHTML=ts,qr=r(),de=o("div"),p(Ye.$$.fragment),Wr=r(),ao=o("p"),ao.textContent=os,Br=r(),ue=o("div"),p(et.$$.fragment),Or=r(),so=o("p"),so.textContent=ns,zr=r(),me=o("div"),p(tt.$$.fragment),Qr=r(),io=o("p"),io.textContent=rs,Gr=r(),fe=o("div"),p(ot.$$.fragment),Zr=r(),lo=o("p"),lo.textContent=as,Xr=r(),_e=o("div"),p(nt.$$.fragment),Kr=r(),co=o("p"),co.textContent=ss,Ao=r(),F=o("h2"),be=o("a"),jo=o("span"),p(rt.$$.fragment),Yr=r(),go=o("span"),go.textContent=is,So=r(),A=o("div"),p(at.$$.fragment),ea=r(),ho=o("p"),ho.textContent=ls,qo=r(),S=o("div"),p(st.$$.fragment),ta=r(),po=o("p"),po.textContent=cs,Wo=r(),q=o("div"),p(it.$$.fragment),oa=r(),uo=o("p"),uo.textContent=gs,Bo=r(),W=o("div"),p(lt.$$.fragment),na=r(),mo=o("p"),mo.textContent=hs,Oo=r(),B=o("div"),p(ct.$$.fragment),ra=r(),fo=o("p"),fo.textContent=ps,zo=r(),O=o("div"),p(gt.$$.fragment),aa=r(),_o=o("p"),_o.textContent=ds,Qo=r(),P=o("div"),p(ht.$$.fragment),sa=r(),bo=o("p"),bo.textContent=us,ia=r(),vo=o("p"),vo.textContent=ms,Go=r(),z=o("h2"),ve=o("a"),Uo=o("span"),p(pt.$$.fragment),la=r(),yo=o("span"),yo.textContent=fs,Zo=r(),dt=o("p"),dt.innerHTML=_s,Xo=r(),ut=o("ul"),ut.innerHTML=bs,Ko=r(),mt=o("p"),mt.textContent=vs,Yo=r(),k=o("div"),p(ft.$$.fragment),ca=r(),$o=o("p"),$o.textContent=ys,ga=r(),xo=o("p"),xo.textContent=$s,ha=r(),ye=o("div"),p(_t.$$.fragment),pa=r(),wo=o("p"),wo.textContent=xs,da=r(),$e=o("div"),p(bt.$$.fragment),ua=r(),Co=o("p"),Co.textContent=ws,ma=r(),xe=o("div"),p(vt.$$.fragment),fa=r(),ko=o("p"),ko.textContent=Cs,en=r(),Q=o("div"),p(yt.$$.fragment),_a=r(),To=o("p"),To.textContent=ks,this.h()},l(t){const b=Ns("svelte-1phssyn",document.head);x=n(b,"META",{name:!0,content:!0}),b.forEach(s),E=a(t),C=n(t,"H1",{class:!0});var $t=h(C);w=n($t,"A",{id:!0,class:!0,href:!0});var Ho=h(w);T=n(Ho,"SPAN",{});var Ts=h(T);d($.$$.fragment,Ts),Ts.forEach(s),Ho.forEach(s),L=a($t),wt=n($t,"SPAN",{"data-svelte-h":!0}),l(wt)!=="svelte-1f9pgas"&&(wt.textContent=ba),$t.forEach(s),Jo=a(t),Te=n(t,"P",{"data-svelte-h":!0}),l(Te)!=="svelte-fqtivw"&&(Te.innerHTML=va),No=a(t),Re=n(t,"P",{"data-svelte-h":!0}),l(Re)!=="svelte-1mkssuw"&&(Re.innerHTML=ya),Vo=a(t),V=n(t,"H2",{class:!0});var on=h(V);G=n(on,"A",{id:!0,class:!0,href:!0});var Rs=h(G);Eo=n(Rs,"SPAN",{});var Is=h(Eo);d(Ie.$$.fragment,Is),Is.forEach(s),Rs.forEach(s),Jn=a(on),Ct=n(on,"SPAN",{"data-svelte-h":!0}),l(Ct)!=="svelte-us5o0i"&&(Ct.textContent=$a),on.forEach(s),Fo=a(t),i=n(t,"DIV",{class:!0});var c=h(i);d(De.$$.fragment,c),Nn=a(c),kt=n(c,"P",{"data-svelte-h":!0}),l(kt)!=="svelte-sfljep"&&(kt.textContent=xa),Vn=a(c),Tt=n(c,"P",{"data-svelte-h":!0}),l(Tt)!=="svelte-130r937"&&(Tt.textContent=wa),Fn=a(c),R=n(c,"DIV",{class:!0});var we=h(R);d(Me.$$.fragment,we),An=a(we),Rt=n(we,"P",{"data-svelte-h":!0}),l(Rt)!=="svelte-u91m2x"&&(Rt.textContent=Ca),Sn=a(we),It=n(we,"P",{"data-svelte-h":!0}),l(It)!=="svelte-tk9h9z"&&(It.innerHTML=ka),qn=a(we),Dt=n(we,"P",{"data-svelte-h":!0}),l(Dt)!=="svelte-1rccgws"&&(Dt.innerHTML=Ta),we.forEach(s),Wn=a(c),Z=n(c,"DIV",{class:!0});var nn=h(Z);d(Le.$$.fragment,nn),Bn=a(nn),Mt=n(nn,"P",{"data-svelte-h":!0}),l(Mt)!=="svelte-1931o36"&&(Mt.textContent=Ra),nn.forEach(s),On=a(c),I=n(c,"DIV",{class:!0});var Ce=h(I);d(Pe.$$.fragment,Ce),zn=a(Ce),Lt=n(Ce,"P",{"data-svelte-h":!0}),l(Lt)!=="svelte-63n9b3"&&(Lt.textContent=Ia),Qn=a(Ce),Pt=n(Ce,"P",{"data-svelte-h":!0}),l(Pt)!=="svelte-1mgqvlx"&&(Pt.textContent=Da),Gn=a(Ce),Et=n(Ce,"P",{"data-svelte-h":!0}),l(Et)!=="svelte-10sq8kk"&&(Et.textContent=Ma),Ce.forEach(s),Zn=a(c),X=n(c,"DIV",{class:!0});var rn=h(X);d(Ee.$$.fragment,rn),Xn=a(rn),jt=n(rn,"P",{"data-svelte-h":!0}),l(jt)!=="svelte-1xz8ip4"&&(jt.textContent=La),rn.forEach(s),Kn=a(c),K=n(c,"DIV",{class:!0});var an=h(K);d(je.$$.fragment,an),Yn=a(an),Ut=n(an,"P",{"data-svelte-h":!0}),l(Ut)!=="svelte-gpfomi"&&(Ut.textContent=Pa),an.forEach(s),er=a(c),Y=n(c,"DIV",{class:!0});var sn=h(Y);d(Ue.$$.fragment,sn),tr=a(sn),Ht=n(sn,"P",{"data-svelte-h":!0}),l(Ht)!=="svelte-i6ef2h"&&(Ht.innerHTML=Ea),sn.forEach(s),or=a(c),D=n(c,"DIV",{class:!0});var ke=h(D);d(He.$$.fragment,ke),nr=a(ke),Jt=n(ke,"P",{"data-svelte-h":!0}),l(Jt)!=="svelte-yrpdu4"&&(Jt.textContent=ja),rr=a(ke),Nt=n(ke,"P",{"data-svelte-h":!0}),l(Nt)!=="svelte-kcbb31"&&(Nt.textContent=Ua),ar=a(ke),d(ee.$$.fragment,ke),ke.forEach(s),sr=a(c),j=n(c,"DIV",{class:!0});var Ro=h(j);d(Je.$$.fragment,Ro),ir=a(Ro),Vt=n(Ro,"P",{"data-svelte-h":!0}),l(Vt)!=="svelte-srmdei"&&(Vt.innerHTML=Ha),lr=a(Ro),d(te.$$.fragment,Ro),Ro.forEach(s),cr=a(c),oe=n(c,"DIV",{class:!0});var ln=h(oe);d(Ne.$$.fragment,ln),gr=a(ln),Ft=n(ln,"P",{"data-svelte-h":!0}),l(Ft)!=="svelte-x8sm21"&&(Ft.textContent=Ja),ln.forEach(s),hr=a(c),U=n(c,"DIV",{class:!0});var Io=h(U);d(Ve.$$.fragment,Io),pr=a(Io),At=n(Io,"P",{"data-svelte-h":!0}),l(At)!=="svelte-1eaw53"&&(At.textContent=Na),dr=a(Io),St=n(Io,"P",{"data-svelte-h":!0}),l(St)!=="svelte-1gwi68h"&&(St.innerHTML=Va),Io.forEach(s),ur=a(c),H=n(c,"DIV",{class:!0});var Do=h(H);d(Fe.$$.fragment,Do),mr=a(Do),qt=n(Do,"P",{"data-svelte-h":!0}),l(qt)!=="svelte-fr7o3n"&&(qt.textContent=Fa),fr=a(Do),Wt=n(Do,"P",{"data-svelte-h":!0}),l(Wt)!=="svelte-1f8uww9"&&(Wt.innerHTML=Aa),Do.forEach(s),_r=a(c),ne=n(c,"DIV",{class:!0});var cn=h(ne);d(Ae.$$.fragment,cn),br=a(cn),Bt=n(cn,"P",{"data-svelte-h":!0}),l(Bt)!=="svelte-10kdqwr"&&(Bt.textContent=Sa),cn.forEach(s),vr=a(c),re=n(c,"DIV",{class:!0});var gn=h(re);d(Se.$$.fragment,gn),yr=a(gn),Ot=n(gn,"P",{"data-svelte-h":!0}),l(Ot)!=="svelte-1jc3bks"&&(Ot.textContent=qa),gn.forEach(s),$r=a(c),ae=n(c,"DIV",{class:!0});var hn=h(ae);d(qe.$$.fragment,hn),xr=a(hn),zt=n(hn,"P",{"data-svelte-h":!0}),l(zt)!=="svelte-1pc1msi"&&(zt.innerHTML=Wa),hn.forEach(s),wr=a(c),se=n(c,"DIV",{class:!0});var pn=h(se);d(We.$$.fragment,pn),Cr=a(pn),Qt=n(pn,"P",{"data-svelte-h":!0}),l(Qt)!=="svelte-1v7pd4y"&&(Qt.textContent=Ba),pn.forEach(s),kr=a(c),ie=n(c,"DIV",{class:!0});var dn=h(ie);d(Be.$$.fragment,dn),Tr=a(dn),Gt=n(dn,"P",{"data-svelte-h":!0}),l(Gt)!=="svelte-vce47s"&&(Gt.textContent=Oa),dn.forEach(s),Rr=a(c),le=n(c,"DIV",{class:!0});var un=h(le);d(Oe.$$.fragment,un),Ir=a(un),Zt=n(un,"P",{"data-svelte-h":!0}),l(Zt)!=="svelte-14r2tu1"&&(Zt.textContent=za),un.forEach(s),Dr=a(c),J=n(c,"DIV",{class:!0});var Mo=h(J);d(ze.$$.fragment,Mo),Mr=a(Mo),Xt=n(Mo,"P",{"data-svelte-h":!0}),l(Xt)!=="svelte-7q6b1s"&&(Xt.textContent=Qa),Lr=a(Mo),Kt=n(Mo,"P",{"data-svelte-h":!0}),l(Kt)!=="svelte-13r9fow"&&(Kt.innerHTML=Ga),Mo.forEach(s),Pr=a(c),ce=n(c,"DIV",{class:!0});var mn=h(ce);d(Qe.$$.fragment,mn),Er=a(mn),Yt=n(mn,"P",{"data-svelte-h":!0}),l(Yt)!=="svelte-1gemtfc"&&(Yt.textContent=Za),mn.forEach(s),jr=a(c),ge=n(c,"DIV",{class:!0});var fn=h(ge);d(Ge.$$.fragment,fn),Ur=a(fn),eo=n(fn,"P",{"data-svelte-h":!0}),l(eo)!=="svelte-1szkij9"&&(eo.textContent=Xa),fn.forEach(s),Hr=a(c),he=n(c,"DIV",{class:!0});var _n=h(he);d(Ze.$$.fragment,_n),Jr=a(_n),to=n(_n,"P",{"data-svelte-h":!0}),l(to)!=="svelte-ywq4p5"&&(to.textContent=Ka),_n.forEach(s),Nr=a(c),pe=n(c,"DIV",{class:!0});var bn=h(pe);d(Xe.$$.fragment,bn),Vr=a(bn),oo=n(bn,"P",{"data-svelte-h":!0}),l(oo)!=="svelte-o0hw73"&&(oo.textContent=Ya),bn.forEach(s),Fr=a(c),N=n(c,"DIV",{class:!0});var Lo=h(N);d(Ke.$$.fragment,Lo),Ar=a(Lo),no=n(Lo,"P",{"data-svelte-h":!0}),l(no)!=="svelte-rew8wo"&&(no.textContent=es),Sr=a(Lo),ro=n(Lo,"P",{"data-svelte-h":!0}),l(ro)!=="svelte-9edfgw"&&(ro.innerHTML=ts),Lo.forEach(s),qr=a(c),de=n(c,"DIV",{class:!0});var vn=h(de);d(Ye.$$.fragment,vn),Wr=a(vn),ao=n(vn,"P",{"data-svelte-h":!0}),l(ao)!=="svelte-un1lv4"&&(ao.textContent=os),vn.forEach(s),Br=a(c),ue=n(c,"DIV",{class:!0});var yn=h(ue);d(et.$$.fragment,yn),Or=a(yn),so=n(yn,"P",{"data-svelte-h":!0}),l(so)!=="svelte-1i0xpsk"&&(so.textContent=ns),yn.forEach(s),zr=a(c),me=n(c,"DIV",{class:!0});var $n=h(me);d(tt.$$.fragment,$n),Qr=a($n),io=n($n,"P",{"data-svelte-h":!0}),l(io)!=="svelte-jqquke"&&(io.textContent=rs),$n.forEach(s),Gr=a(c),fe=n(c,"DIV",{class:!0});var xn=h(fe);d(ot.$$.fragment,xn),Zr=a(xn),lo=n(xn,"P",{"data-svelte-h":!0}),l(lo)!=="svelte-j7abay"&&(lo.textContent=as),xn.forEach(s),Xr=a(c),_e=n(c,"DIV",{class:!0});var wn=h(_e);d(nt.$$.fragment,wn),Kr=a(wn),co=n(wn,"P",{"data-svelte-h":!0}),l(co)!=="svelte-11wx7zp"&&(co.textContent=ss),wn.forEach(s),c.forEach(s),Ao=a(t),F=n(t,"H2",{class:!0});var Cn=h(F);be=n(Cn,"A",{id:!0,class:!0,href:!0});var Ds=h(be);jo=n(Ds,"SPAN",{});var Ms=h(jo);d(rt.$$.fragment,Ms),Ms.forEach(s),Ds.forEach(s),Yr=a(Cn),go=n(Cn,"SPAN",{"data-svelte-h":!0}),l(go)!=="svelte-4xvn3j"&&(go.textContent=is),Cn.forEach(s),So=a(t),A=n(t,"DIV",{class:!0});var kn=h(A);d(at.$$.fragment,kn),ea=a(kn),ho=n(kn,"P",{"data-svelte-h":!0}),l(ho)!=="svelte-5hpmfd"&&(ho.textContent=ls),kn.forEach(s),qo=a(t),S=n(t,"DIV",{class:!0});var Tn=h(S);d(st.$$.fragment,Tn),ta=a(Tn),po=n(Tn,"P",{"data-svelte-h":!0}),l(po)!=="svelte-1d1mfv5"&&(po.textContent=cs),Tn.forEach(s),Wo=a(t),q=n(t,"DIV",{class:!0});var Rn=h(q);d(it.$$.fragment,Rn),oa=a(Rn),uo=n(Rn,"P",{"data-svelte-h":!0}),l(uo)!=="svelte-oqtt44"&&(uo.textContent=gs),Rn.forEach(s),Bo=a(t),W=n(t,"DIV",{class:!0});var In=h(W);d(lt.$$.fragment,In),na=a(In),mo=n(In,"P",{"data-svelte-h":!0}),l(mo)!=="svelte-1jg2eg8"&&(mo.textContent=hs),In.forEach(s),Oo=a(t),B=n(t,"DIV",{class:!0});var Dn=h(B);d(ct.$$.fragment,Dn),ra=a(Dn),fo=n(Dn,"P",{"data-svelte-h":!0}),l(fo)!=="svelte-97mwvc"&&(fo.textContent=ps),Dn.forEach(s),zo=a(t),O=n(t,"DIV",{class:!0});var Mn=h(O);d(gt.$$.fragment,Mn),aa=a(Mn),_o=n(Mn,"P",{"data-svelte-h":!0}),l(_o)!=="svelte-vpsey2"&&(_o.textContent=ds),Mn.forEach(s),Qo=a(t),P=n(t,"DIV",{class:!0});var Po=h(P);d(ht.$$.fragment,Po),sa=a(Po),bo=n(Po,"P",{"data-svelte-h":!0}),l(bo)!=="svelte-18uhass"&&(bo.textContent=us),ia=a(Po),vo=n(Po,"P",{"data-svelte-h":!0}),l(vo)!=="svelte-zq2g9v"&&(vo.textContent=ms),Po.forEach(s),Go=a(t),z=n(t,"H2",{class:!0});var Ln=h(z);ve=n(Ln,"A",{id:!0,class:!0,href:!0});var Ls=h(ve);Uo=n(Ls,"SPAN",{});var Ps=h(Uo);d(pt.$$.fragment,Ps),Ps.forEach(s),Ls.forEach(s),la=a(Ln),yo=n(Ln,"SPAN",{"data-svelte-h":!0}),l(yo)!=="svelte-bklsre"&&(yo.textContent=fs),Ln.forEach(s),Zo=a(t),dt=n(t,"P",{"data-svelte-h":!0}),l(dt)!=="svelte-1w5vmm6"&&(dt.innerHTML=_s),Xo=a(t),ut=n(t,"UL",{"data-svelte-h":!0}),l(ut)!=="svelte-1dzo48z"&&(ut.innerHTML=bs),Ko=a(t),mt=n(t,"P",{"data-svelte-h":!0}),l(mt)!=="svelte-1k7k7po"&&(mt.textContent=vs),Yo=a(t),k=n(t,"DIV",{class:!0});var M=h(k);d(ft.$$.fragment,M),ca=a(M),$o=n(M,"P",{"data-svelte-h":!0}),l($o)!=="svelte-sfljep"&&($o.textContent=ys),ga=a(M),xo=n(M,"P",{"data-svelte-h":!0}),l(xo)!=="svelte-130r937"&&(xo.textContent=$s),ha=a(M),ye=n(M,"DIV",{class:!0});var Pn=h(ye);d(_t.$$.fragment,Pn),pa=a(Pn),wo=n(Pn,"P",{"data-svelte-h":!0}),l(wo)!=="svelte-1qshjwq"&&(wo.textContent=xs),Pn.forEach(s),da=a(M),$e=n(M,"DIV",{class:!0});var En=h($e);d(bt.$$.fragment,En),ua=a(En),Co=n(En,"P",{"data-svelte-h":!0}),l(Co)!=="svelte-54rv4h"&&(Co.textContent=ws),En.forEach(s),ma=a(M),xe=n(M,"DIV",{class:!0});var jn=h(xe);d(vt.$$.fragment,jn),fa=a(jn),ko=n(jn,"P",{"data-svelte-h":!0}),l(ko)!=="svelte-11wx7zp"&&(ko.textContent=Cs),jn.forEach(s),M.forEach(s),en=a(t),Q=n(t,"DIV",{class:!0});var Un=h(Q);d(yt.$$.fragment,Un),_a=a(Un),To=n(Un,"P",{"data-svelte-h":!0}),l(To)!=="svelte-1na97wh"&&(To.textContent=ks),Un.forEach(s),this.h()},h(){g(x,"name","hf:doc:metadata"),g(x,"content",JSON.stringify(Bs)),g(w,"id","managing-local-and-online-repositories"),g(w,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(w,"href","#managing-local-and-online-repositories"),g(C,"class","relative group"),g(G,"id","huggingface_hub.Repository"),g(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(G,"href","#huggingface_hub.Repository"),g(V,"class","relative group"),g(R,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(I,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(K,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Y,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(D,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(j,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(oe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ne,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(re,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ae,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(se,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ie,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(le,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ce,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ge,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(he,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(pe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(N,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(de,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ue,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(me,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(fe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(_e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(i,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(be,"id","huggingface_hub.repository.is_git_repo"),g(be,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(be,"href","#huggingface_hub.repository.is_git_repo"),g(F,"class","relative group"),g(A,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(S,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(W,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(B,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(O,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(ve,"id","huggingface_hub.Repository"),g(ve,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),g(ve,"href","#huggingface_hub.Repository"),g(z,"class","relative group"),g(ye,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g($e,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(xe,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(k,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),g(Q,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(t,b){e(document.head,x),v(t,E,b),v(t,C,b),e(C,w),e(w,T),u($,T,null),e(C,L),e(C,wt),v(t,Jo,b),v(t,Te,b),v(t,No,b),v(t,Re,b),v(t,Vo,b),v(t,V,b),e(V,G),e(G,Eo),u(Ie,Eo,null),e(V,Jn),e(V,Ct),v(t,Fo,b),v(t,i,b),u(De,i,null),e(i,Nn),e(i,kt),e(i,Vn),e(i,Tt),e(i,Fn),e(i,R),u(Me,R,null),e(R,An),e(R,Rt),e(R,Sn),e(R,It),e(R,qn),e(R,Dt),e(i,Wn),e(i,Z),u(Le,Z,null),e(Z,Bn),e(Z,Mt),e(i,On),e(i,I),u(Pe,I,null),e(I,zn),e(I,Lt),e(I,Qn),e(I,Pt),e(I,Gn),e(I,Et),e(i,Zn),e(i,X),u(Ee,X,null),e(X,Xn),e(X,jt),e(i,Kn),e(i,K),u(je,K,null),e(K,Yn),e(K,Ut),e(i,er),e(i,Y),u(Ue,Y,null),e(Y,tr),e(Y,Ht),e(i,or),e(i,D),u(He,D,null),e(D,nr),e(D,Jt),e(D,rr),e(D,Nt),e(D,ar),u(ee,D,null),e(i,sr),e(i,j),u(Je,j,null),e(j,ir),e(j,Vt),e(j,lr),u(te,j,null),e(i,cr),e(i,oe),u(Ne,oe,null),e(oe,gr),e(oe,Ft),e(i,hr),e(i,U),u(Ve,U,null),e(U,pr),e(U,At),e(U,dr),e(U,St),e(i,ur),e(i,H),u(Fe,H,null),e(H,mr),e(H,qt),e(H,fr),e(H,Wt),e(i,_r),e(i,ne),u(Ae,ne,null),e(ne,br),e(ne,Bt),e(i,vr),e(i,re),u(Se,re,null),e(re,yr),e(re,Ot),e(i,$r),e(i,ae),u(qe,ae,null),e(ae,xr),e(ae,zt),e(i,wr),e(i,se),u(We,se,null),e(se,Cr),e(se,Qt),e(i,kr),e(i,ie),u(Be,ie,null),e(ie,Tr),e(ie,Gt),e(i,Rr),e(i,le),u(Oe,le,null),e(le,Ir),e(le,Zt),e(i,Dr),e(i,J),u(ze,J,null),e(J,Mr),e(J,Xt),e(J,Lr),e(J,Kt),e(i,Pr),e(i,ce),u(Qe,ce,null),e(ce,Er),e(ce,Yt),e(i,jr),e(i,ge),u(Ge,ge,null),e(ge,Ur),e(ge,eo),e(i,Hr),e(i,he),u(Ze,he,null),e(he,Jr),e(he,to),e(i,Nr),e(i,pe),u(Xe,pe,null),e(pe,Vr),e(pe,oo),e(i,Fr),e(i,N),u(Ke,N,null),e(N,Ar),e(N,no),e(N,Sr),e(N,ro),e(i,qr),e(i,de),u(Ye,de,null),e(de,Wr),e(de,ao),e(i,Br),e(i,ue),u(et,ue,null),e(ue,Or),e(ue,so),e(i,zr),e(i,me),u(tt,me,null),e(me,Qr),e(me,io),e(i,Gr),e(i,fe),u(ot,fe,null),e(fe,Zr),e(fe,lo),e(i,Xr),e(i,_e),u(nt,_e,null),e(_e,Kr),e(_e,co),v(t,Ao,b),v(t,F,b),e(F,be),e(be,jo),u(rt,jo,null),e(F,Yr),e(F,go),v(t,So,b),v(t,A,b),u(at,A,null),e(A,ea),e(A,ho),v(t,qo,b),v(t,S,b),u(st,S,null),e(S,ta),e(S,po),v(t,Wo,b),v(t,q,b),u(it,q,null),e(q,oa),e(q,uo),v(t,Bo,b),v(t,W,b),u(lt,W,null),e(W,na),e(W,mo),v(t,Oo,b),v(t,B,b),u(ct,B,null),e(B,ra),e(B,fo),v(t,zo,b),v(t,O,b),u(gt,O,null),e(O,aa),e(O,_o),v(t,Qo,b),v(t,P,b),u(ht,P,null),e(P,sa),e(P,bo),e(P,ia),e(P,vo),v(t,Go,b),v(t,z,b),e(z,ve),e(ve,Uo),u(pt,Uo,null),e(z,la),e(z,yo),v(t,Zo,b),v(t,dt,b),v(t,Xo,b),v(t,ut,b),v(t,Ko,b),v(t,mt,b),v(t,Yo,b),v(t,k,b),u(ft,k,null),e(k,ca),e(k,$o),e(k,ga),e(k,xo),e(k,ha),e(k,ye),u(_t,ye,null),e(ye,pa),e(ye,wo),e(k,da),e(k,$e),u(bt,$e,null),e($e,ua),e($e,Co),e(k,ma),e(k,xe),u(vt,xe,null),e(xe,fa),e(xe,ko),v(t,en,b),v(t,Q,b),u(yt,Q,null),e(Q,_a),e(Q,To),tn=!0},p(t,[b]){const $t={};b&2&&($t.$$scope={dirty:b,ctx:t}),ee.$set($t);const Ho={};b&2&&(Ho.$$scope={dirty:b,ctx:t}),te.$set(Ho)},i(t){tn||(m($.$$.fragment,t),m(Ie.$$.fragment,t),m(De.$$.fragment,t),m(Me.$$.fragment,t),m(Le.$$.fragment,t),m(Pe.$$.fragment,t),m(Ee.$$.fragment,t),m(je.$$.fragment,t),m(Ue.$$.fragment,t),m(He.$$.fragment,t),m(ee.$$.fragment,t),m(Je.$$.fragment,t),m(te.$$.fragment,t),m(Ne.$$.fragment,t),m(Ve.$$.fragment,t),m(Fe.$$.fragment,t),m(Ae.$$.fragment,t),m(Se.$$.fragment,t),m(qe.$$.fragment,t),m(We.$$.fragment,t),m(Be.$$.fragment,t),m(Oe.$$.fragment,t),m(ze.$$.fragment,t),m(Qe.$$.fragment,t),m(Ge.$$.fragment,t),m(Ze.$$.fragment,t),m(Xe.$$.fragment,t),m(Ke.$$.fragment,t),m(Ye.$$.fragment,t),m(et.$$.fragment,t),m(tt.$$.fragment,t),m(ot.$$.fragment,t),m(nt.$$.fragment,t),m(rt.$$.fragment,t),m(at.$$.fragment,t),m(st.$$.fragment,t),m(it.$$.fragment,t),m(lt.$$.fragment,t),m(ct.$$.fragment,t),m(gt.$$.fragment,t),m(ht.$$.fragment,t),m(pt.$$.fragment,t),m(ft.$$.fragment,t),m(_t.$$.fragment,t),m(bt.$$.fragment,t),m(vt.$$.fragment,t),m(yt.$$.fragment,t),tn=!0)},o(t){f($.$$.fragment,t),f(Ie.$$.fragment,t),f(De.$$.fragment,t),f(Me.$$.fragment,t),f(Le.$$.fragment,t),f(Pe.$$.fragment,t),f(Ee.$$.fragment,t),f(je.$$.fragment,t),f(Ue.$$.fragment,t),f(He.$$.fragment,t),f(ee.$$.fragment,t),f(Je.$$.fragment,t),f(te.$$.fragment,t),f(Ne.$$.fragment,t),f(Ve.$$.fragment,t),f(Fe.$$.fragment,t),f(Ae.$$.fragment,t),f(Se.$$.fragment,t),f(qe.$$.fragment,t),f(We.$$.fragment,t),f(Be.$$.fragment,t),f(Oe.$$.fragment,t),f(ze.$$.fragment,t),f(Qe.$$.fragment,t),f(Ge.$$.fragment,t),f(Ze.$$.fragment,t),f(Xe.$$.fragment,t),f(Ke.$$.fragment,t),f(Ye.$$.fragment,t),f(et.$$.fragment,t),f(tt.$$.fragment,t),f(ot.$$.fragment,t),f(nt.$$.fragment,t),f(rt.$$.fragment,t),f(at.$$.fragment,t),f(st.$$.fragment,t),f(it.$$.fragment,t),f(lt.$$.fragment,t),f(ct.$$.fragment,t),f(gt.$$.fragment,t),f(ht.$$.fragment,t),f(pt.$$.fragment,t),f(ft.$$.fragment,t),f(_t.$$.fragment,t),f(bt.$$.fragment,t),f(vt.$$.fragment,t),f(yt.$$.fragment,t),tn=!1},d(t){t&&(s(E),s(C),s(Jo),s(Te),s(No),s(Re),s(Vo),s(V),s(Fo),s(i),s(Ao),s(F),s(So),s(A),s(qo),s(S),s(Wo),s(q),s(Bo),s(W),s(Oo),s(B),s(zo),s(O),s(Qo),s(P),s(Go),s(z),s(Zo),s(dt),s(Xo),s(ut),s(Ko),s(mt),s(Yo),s(k),s(en),s(Q)),s(x),_($),_(Ie),_(De),_(Me),_(Le),_(Pe),_(Ee),_(je),_(Ue),_(He),_(ee),_(Je),_(te),_(Ne),_(Ve),_(Fe),_(Ae),_(Se),_(qe),_(We),_(Be),_(Oe),_(ze),_(Qe),_(Ge),_(Ze),_(Xe),_(Ke),_(Ye),_(et),_(tt),_(ot),_(nt),_(rt),_(at),_(st),_(it),_(lt),_(ct),_(gt),_(ht),_(pt),_(ft),_(_t),_(bt),_(vt),_(yt)}}}const Bs={local:"managing-local-and-online-repositories",sections:[{local:"huggingface_hub.Repository",title:"The Repository class"},{local:"huggingface_hub.repository.is_git_repo",title:"Helper methods"},{local:"huggingface_hub.Repository",title:"Following asynchronous commands"}],title:"Managing local and online repositories"};function Os(xt){return Us(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ei extends Hs{constructor(x){super(),Js(this,x,Os,Ws,js,{})}}export{ei as component};
