import{s as Ka,o as Oa}from"../chunks/scheduler.f7e1785c.js";import{S as es,i as ts,g as l,s as i,r as m,A as as,h as o,f as a,c as n,j as Na,u as h,x as r,k as qe,y as ss,a as s,v as c,d,t as f,w as g,m as Qa,n as Aa}from"../chunks/index.9f8f0838.js";import{T as Da}from"../chunks/Tip.4575d9cf.js";import{C as Ge}from"../chunks/CodeBlock.b3510e34.js";import{H as je}from"../chunks/Heading.6643a2f7.js";function is(ze){let p;return{c(){p=Qa(`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},l(u){p=Aa(u,`💡 In practice, people use the term FFT interchangeably with DFT, as the FFT or Fast Fourier Transform is the only efficient
way to calculate the DFT on a computer.`)},m(u,w){s(u,p,w)},d(u){u&&a(p)}}}function ns(ze){let p;return{c(){p=Qa(`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},l(u){p=Aa(u,`💡 Not all mel spectrograms are the same! There are two different mel scales in common use ("htk" and "slaney"),
and instead of the power spectrogram the amplitude spectrogram may be used. The conversion to a log-mel spectrogram doesn't
always compute true decibels but may simply take the \`log\`. Therefore, if a machine learning model expects a mel spectrogram
as input, double check to make sure you're computing it the same way.`)},m(u,w){s(u,p,w)},d(u){u&&a(p)}}}function ls(ze){let p,u,w,Ie,k,Fe,$,Dt=`By nature, a sound wave is a continuous signal, meaning it contains an infinite number of signal values in a given time.
This poses problems for digital devices which expect finite arrays. To be processed, stored, and transmitted by digital
devices, the continuous sound wave needs to be converted into a series of discrete values, known as a digital representation.`,Le,_,Qt=`If you look at any audio dataset, you’ll find digital files with sound excerpts, such as text narration or music.
You may encounter different file formats such as <code>.wav</code> (Waveform Audio File), <code>.flac</code> (Free Lossless Audio Codec)
and <code>.mp3</code> (MPEG-1 Audio Layer 3). These formats mainly differ in how they compress the digital representation of the audio signal.`,Ze,J,At=`Let’s take a look at how we arrive from a continuous signal to this representation. The analog signal is first captured by
a microphone, which converts the sound waves into an electrical signal. The electrical signal is then digitized by an
Analog-to-Digital Converter to get the digital representation through sampling.`,Se,H,Ue,q,Kt=`Sampling is the process of measuring the value of a continuous signal at fixed time steps. The sampled waveform is <em>discrete</em>,
since it contains a finite number of signal values at uniform intervals.`,Pe,v,Ot='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/Signal_Sampling.png" alt="Signal sampling illustration"/>',Xe,j,ea='<em>Illustration from Wikipedia article: <a href="https://en.wikipedia.org/wiki/Sampling_(signal_processing)" rel="nofollow">Sampling (signal processing)</a></em>',We,z,ta=`The <strong>sampling rate</strong> (also called sampling frequency) is the number of samples taken in one second and is measured in
hertz (Hz). To give you a point of reference, CD-quality audio has a sampling rate of 44,100 Hz, meaning samples are taken
44,100 times per second. For comparison, high-resolution audio has a sampling rate of 192,000 Hz or 192 kHz. A common
sampling rate used in training speech models is 16,000 Hz or 16 kHz.`,Ee,G,aa=`The choice of sampling rate primarily determines the highest frequency that can be captured from the signal. This is also
known as the Nyquist limit and is exactly half the sampling rate. The audible frequencies in human speech are below 8 kHz
and therefore sampling speech at 16 kHz is sufficient. Using a higher sampling rate will not capture more information and
merely leads to an increase in the computational cost of processing such files. On the other hand, sampling audio at too
low a sampling rate will result in information loss. Speech sampled at 8 kHz will sound muffled, as the higher frequencies
cannot be captured at this rate.`,Ye,B,sa=`It’s important to ensure that all audio examples in your dataset have the same sampling rate when working on any audio task.
If you plan to use custom audio data to fine-tune a pre-trained model, the sampling rate of your data should match the
sampling rate of the data the model was pre-trained on. The sampling rate determines the time interval between successive
audio samples, which impacts the temporal resolution of the audio data. Consider an example: a 5-second sound at a sampling
rate of 16,000 Hz will be represented as a series of 80,000 values, while the same 5-second sound at a sampling rate of
8,000 Hz will be represented as a series of 40,000 values. Transformer models that solve audio tasks treat examples as
sequences and rely on attention mechanisms to learn audio or multimodal representation. Since sequences are different for
audio examples at different sampling rates, it will be challenging for models to generalize between sampling rates.
<strong>Resampling</strong> is the process of making the sampling rates match, and is part of <a href="preprocessing#resampling-the-audio-data">preprocessing</a> the audio data.`,Re,I,Ve,F,ia="While the sampling rate tells you how often the samples are taken, what exactly are the values in each sample?",Ne,L,na=`Sound is made by changes in air pressure at frequencies that are audible to humans. The <strong>amplitude</strong> of a sound describes
the sound pressure level at any given instant and is measured in decibels (dB). We perceive the amplitude as loudness.
To give you an example, a normal speaking voice is under 60 dB, and a rock concert can be at around 125 dB, pushing the
limits of human hearing.`,De,Z,la=`In digital audio, each audio sample records the amplitude of the audio wave at a point in time. The <strong>bit depth</strong> of the
sample determines with how much precision this amplitude value can be described. The higher the bit depth, the more
faithfully the digital representation approximates the original continuous sound wave.`,Qe,S,oa=`The most common audio bit depths are 16-bit and 24-bit. Each is a binary term, representing the number of possible steps
to which the amplitude value can be quantized when it’s converted from continuous to discrete: 65,536 steps for 16-bit audio,
a whopping 16,777,216 steps for 24-bit audio. Because quantizing involves rounding off the continuous value to a discrete
value, the sampling process introduces noise. The higher the bit depth, the smaller this quantization noise. In practice,
the quantization noise of 16-bit audio is already small enough to be inaudible, and using higher bit depths is generally
not necessary.`,Ae,U,ra=`You may also come across 32-bit audio. This stores the samples as floating-point values, whereas 16-bit and 24-bit audio
use integer samples. The precision of a 32-bit floating-point value is 24 bits, giving it the same bit depth as 24-bit audio.
Floating-point audio samples are expected to lie within the [-1.0, 1.0] range. Since machine learning models naturally
work on floating-point data, the audio must first be converted into floating-point format before it can be used to train
the model. We’ll see how to do this in the next section on <a href="preprocessing">Preprocessing</a>.`,Ke,P,pa=`Just as with continuous audio signals, the amplitude of digital audio is typically expressed in decibels (dB). Since
human hearing is logarithmic in nature — our ears are more sensitive to small fluctuations in quiet sounds than in loud
sounds — the loudness of a sound is easier to interpret if the amplitudes are in decibels, which are also logarithmic.
The decibel scale for real-world audio starts at 0 dB, which represents the quietest possible sound humans can hear, and
louder sounds have larger values. However, for digital audio signals, 0 dB is the loudest possible amplitude, while all
other amplitudes are negative. As a quick rule of thumb: every -6 dB is a halving of the amplitude, and anything below -60 dB
is generally inaudible unless you really crank up the volume.`,Oe,X,et,W,ua=`You may have seen sounds visualized as a <strong>waveform</strong>, which plots the sample values over time and illustrates the changes
in the sound’s amplitude. This is also known as the <em>time domain</em> representation of sound.`,tt,E,ma=`This type of visualization is useful for identifying specific features of the audio signal such as the timing of individual
sound events, the overall loudness of the signal, and any irregularities or noise present in the audio.`,at,Y,ha="To plot the waveform for an audio signal, we can use a Python library called <code>librosa</code>:",st,R,it,V,ca="Let’s take an example sound called “trumpet” that comes with the library:",nt,N,lt,D,da=`The example is loaded as a tuple of audio time series (here we call it <code>array</code>), and sampling rate (<code>sampling_rate</code>).
Let’s take a look at this sound’s waveform by using librosa’s <code>waveshow()</code> function:`,ot,Q,rt,y,fa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/waveform_plot.png" alt="Waveform plot"/>',pt,A,ga=`This plots the amplitude of the signal on the y-axis and time along the x-axis. In other words, each point corresponds
to a single sample value that was taken when this sound was sampled. Also note that librosa returns the audio as
floating-point values already, and that the amplitude values are indeed within the [-1.0, 1.0] range.`,ut,K,wa=`Visualizing the audio along with listening to it can be a useful tool for understanding the data you are working with.
You can see the shape of the signal, observe patterns, learn to spot noise or distortion. If you preprocess data in some
ways, such as normalization, resampling, or filtering, you can visually confirm that preprocessing steps have been applied as expected.
After training a model, you can also visualize samples where errors occur (e.g. in audio classification task) to debug
the issue.`,mt,O,ht,ee,va=`Another way to visualize audio data is to plot the <strong>frequency spectrum</strong> of an audio signal, also known as the <em>frequency domain</em>
representation. The spectrum is computed using the discrete Fourier transform or DFT. It describes the individual frequencies
that make up the signal and how strong they are.`,ct,te,ya=`Let’s plot the frequency spectrum for the same trumpet sound by taking the DFT using numpy’s <code>rfft()</code> function. While it
is possible to plot the spectrum of the entire sound, it’s more useful to look at a small region instead. Here we’ll take
the DFT over the first 4096 samples, which is roughly the length of the first note being played:`,dt,ae,ft,b,ba='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrum_plot.png" alt="Spectrum plot"/>',gt,se,Ta=`This plots the strength of the various frequency components that are present in this audio segment. The frequency values are on
the x-axis, usually plotted on a logarithmic scale, while their amplitudes are on the y-axis.`,wt,ie,xa=`The frequency spectrum that we plotted shows several peaks. These peaks correspond to the harmonics of the note that’s
being played, with the higher harmonics being quieter. Since the first peak is at around 620 Hz, this is the frequency spectrum of an E♭ note.`,vt,ne,Ma=`The output of the DFT is an array of complex numbers, made up of real and imaginary components. Taking
the magnitude with <code>np.abs(dft)</code> extracts the amplitude information from the spectrogram. The angle between the real and
imaginary components provides the so-called phase spectrum, but this is often discarded in machine learning applications.`,yt,le,Ca=`You used <code>librosa.amplitude_to_db()</code> to convert the amplitude values to the decibel scale, making it easier to see
the finer details in the spectrum. Sometimes people use the <strong>power spectrum</strong>, which measures energy rather than amplitude;
this is simply a spectrum with the amplitude values squared.`,bt,T,Tt,oe,ka=`The frequency spectrum of an audio signal contains the exact same information as its waveform — they are simply two different
ways of looking at the same data (here, the first 4096 samples from the trumpet sound). Where the waveform plots the amplitude
of the audio signal over time, the spectrum visualizes the amplitudes of the individual frequencies at a fixed point in time.`,xt,re,Mt,pe,$a=`What if we want to see how the frequencies in an audio signal change? The trumpet plays several notes and they all have
different frequencies. The problem is that the spectrum only shows a frozen snapshot of the frequencies at a given instant.
The solution is to take multiple DFTs, each covering only a small slice of time, and stack the resulting spectra together
into a <strong>spectrogram</strong>.`,Ct,ue,_a=`A spectrogram plots the frequency content of an audio signal as it changes over time. It allows you to see time, frequency,
and amplitude all on one graph. The algorithm that performs this computation is the STFT or Short Time Fourier Transform.`,kt,me,Ja=`The spectrogram is one of the most informative audio tools available to you. For example, when working with a music recording,
you can see the various instruments and vocal tracks and how they contribute to the overall sound. In speech, you can
identify different vowel sounds as each vowel is characterized by particular frequencies.`,$t,he,Ha="Let’s plot a spectrogram for the same trumpet sound, using librosa’s <code>stft()</code> and <code>specshow()</code> functions:",_t,ce,Jt,x,qa='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/spectrogram_plot.png" alt="Spectrogram plot"/>',Ht,de,ja=`In this plot, the x-axis represents time as in the waveform visualization but now the y-axis represents frequency in Hz.
The intensity of the color gives the amplitude or power of the frequency component at each point in time, measured in decibels (dB).`,qt,fe,za=`The spectrogram is created by taking short segments of the audio signal, typically lasting a few milliseconds, and calculating
the discrete Fourier transform of each segment to obtain its frequency spectrum. The resulting spectra are then stacked
together on the time axis to create the spectrogram. Each vertical slice in this image corresponds to a single frequency
spectrum, seen from the top. By default, <code>librosa.stft()</code> splits the audio signal into segments of 2048 samples, which
gives a good trade-off between frequency resolution and time resolution.`,jt,ge,Ga=`Since the spectrogram and the waveform are different views of the same data, it’s possible to turn the spectrogram back
into the original waveform using the inverse STFT. However, this requires the phase information in addition to the amplitude
information. If the spectrogram was generated by a machine learning model, it typically only outputs the amplitudes. In
that case, we can use a phase reconstruction algorithm such as the classic Griffin-Lim algorithm, or using a neural network
called a vocoder, to reconstruct a waveform from the spectrogram.`,zt,we,Ba=`Spectrograms aren’t just used for visualization. Many machine learning models will take spectrograms as input — as opposed
to waveforms — and produce spectrograms as output.`,Gt,ve,Ia="Now that we know what a spectrogram is and how it’s made, let’s take a look at a variant of it widely used for speech processing: the mel spectrogram.",Bt,ye,It,be,Fa=`A mel spectrogram is a variation of the spectrogram that is commonly used in speech processing and machine learning tasks.
It is similar to a spectrogram in that it shows the frequency content of an audio signal over time, but on a different frequency axis.`,Ft,Te,La=`In a standard spectrogram, the frequency axis is linear and is measured in hertz (Hz). However, the human auditory system
is more sensitive to changes in lower frequencies than higher frequencies, and this sensitivity decreases logarithmically
as frequency increases. The mel scale is a perceptual scale that approximates the non-linear frequency response of the human ear.`,Lt,xe,Za=`To create a mel spectrogram, the STFT is used just like before, splitting the audio into short segments to obtain a sequence
of frequency spectra. Additionally, each spectrum is sent through a set of filters, the so-called mel filterbank, to
transform the frequencies to the mel scale.`,Zt,Me,Sa="Let’s see how we can plot a mel spectrogram using librosa’s <code>melspectrogram()</code> function, which performs all of those steps for us:",St,Ce,Ut,M,Ua='<img src="https://huggingface.co/datasets/huggingface-course/audio-course-images/resolve/main/mel-spectrogram.png" alt="Mel spectrogram plot"/>',Pt,ke,Pa=`In the example above, <code>n_mels</code> stands for the number of mel bands to generate. The mel bands define a set of frequency
ranges that divide the spectrum into perceptually meaningful components, using a set of filters whose shape and spacing
are chosen to mimic the way the human ear responds to different frequencies. Common values for <code>n_mels</code> are 40 or 80. <code>fmax</code>
indicates the highest frequency (in Hz) we care about.`,Xt,$e,Xa=`Just as with a regular spectrogram, it’s common practice to express the strength of the mel frequency components in
decibels. This is commonly referred to as a <strong>log-mel spectrogram</strong>, because the conversion to decibels involves a
logarithmic operation. The above example used <code>librosa.power_to_db()</code> as <code>librosa.feature.melspectrogram()</code> creates a power spectrogram.`,Wt,C,Et,_e,Wa=`Creating a mel spectrogram is a lossy operation as it involves filtering the signal. Converting a mel spectrogram back
into a waveform is more difficult than doing this for a regular spectrogram, as it requires estimating the frequencies
that were thrown away. This is why machine learning models such as HiFiGAN vocoder are needed to produce a waveform from a mel
spectrogram.`,Yt,Je,Ea=`Compared to a standard spectrogram, a mel spectrogram can capture more meaningful features of the audio signal for
human perception, making it a popular choice in tasks such as speech recognition, speaker identification, and music genre classification.`,Rt,He,Ya="Now that you know how to visualize audio data examples, go ahead and try to see what your favorite sounds look like. :)",Vt,Be,Nt;return k=new je({props:{title:"Introduction to audio data",local:"introduction-to-audio-data",headingTag:"h1"}}),H=new je({props:{title:"Sampling and sampling rate",local:"sampling-and-sampling-rate",headingTag:"h2"}}),I=new je({props:{title:"Amplitude and bit depth",local:"amplitude-and-bit-depth",headingTag:"h2"}}),X=new je({props:{title:"Audio as a waveform",local:"audio-as-a-waveform",headingTag:"h2"}}),R=new Ge({props:{code:"cGlwJTIwaW5zdGFsbCUyMGxpYnJvc2E=",highlighted:"pip install librosa",wrap:!1}}),N=new Ge({props:{code:"aW1wb3J0JTIwbGlicm9zYSUwQSUwQWFycmF5JTJDJTIwc2FtcGxpbmdfcmF0ZSUyMCUzRCUyMGxpYnJvc2EubG9hZChsaWJyb3NhLmV4KCUyMnRydW1wZXQlMjIpKQ==",highlighted:`<span class="hljs-keyword">import</span> librosa

array, sampling_rate = librosa.load(librosa.ex(<span class="hljs-string">&quot;trumpet&quot;</span>))`,wrap:!1}}),Q=new Ge({props:{code:"aW1wb3J0JTIwbWF0cGxvdGxpYi5weXBsb3QlMjBhcyUyMHBsdCUwQWltcG9ydCUyMGxpYnJvc2EuZGlzcGxheSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LndhdmVzaG93KGFycmF5JTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlKQ==",highlighted:`<span class="hljs-keyword">import</span> matplotlib.pyplot <span class="hljs-keyword">as</span> plt
<span class="hljs-keyword">import</span> librosa.display

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.waveshow(array, sr=sampling_rate)`,wrap:!1}}),O=new je({props:{title:"The frequency spectrum",local:"the-frequency-spectrum",headingTag:"h2"}}),ae=new Ge({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBZGZ0X2lucHV0JTIwJTNEJTIwYXJyYXklNUIlM0E0MDk2JTVEJTBBJTBBJTIzJTIwY2FsY3VsYXRlJTIwdGhlJTIwREZUJTBBd2luZG93JTIwJTNEJTIwbnAuaGFubmluZyhsZW4oZGZ0X2lucHV0KSklMEF3aW5kb3dlZF9pbnB1dCUyMCUzRCUyMGRmdF9pbnB1dCUyMColMjB3aW5kb3clMEFkZnQlMjAlM0QlMjBucC5mZnQucmZmdCh3aW5kb3dlZF9pbnB1dCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBhbXBsaXR1ZGUlMjBzcGVjdHJ1bSUyMGluJTIwZGVjaWJlbHMlMEFhbXBsaXR1ZGUlMjAlM0QlMjBucC5hYnMoZGZ0KSUwQWFtcGxpdHVkZV9kYiUyMCUzRCUyMGxpYnJvc2EuYW1wbGl0dWRlX3RvX2RiKGFtcGxpdHVkZSUyQyUyMHJlZiUzRG5wLm1heCklMEElMEElMjMlMjBnZXQlMjB0aGUlMjBmcmVxdWVuY3klMjBiaW5zJTBBZnJlcXVlbmN5JTIwJTNEJTIwbGlicm9zYS5mZnRfZnJlcXVlbmNpZXMoc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwbl9mZnQlM0RsZW4oZGZ0X2lucHV0KSklMEElMEFwbHQuZmlndXJlKCkuc2V0X2ZpZ3dpZHRoKDEyKSUwQXBsdC5wbG90KGZyZXF1ZW5jeSUyQyUyMGFtcGxpdHVkZV9kYiklMEFwbHQueGxhYmVsKCUyMkZyZXF1ZW5jeSUyMChIeiklMjIpJTBBcGx0LnlsYWJlbCglMjJBbXBsaXR1ZGUlMjAoZEIpJTIyKSUwQXBsdC54c2NhbGUoJTIybG9nJTIyKQ==",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

dft_input = array[:<span class="hljs-number">4096</span>]

<span class="hljs-comment"># calculate the DFT</span>
window = np.hanning(<span class="hljs-built_in">len</span>(dft_input))
windowed_input = dft_input * window
dft = np.fft.rfft(windowed_input)

<span class="hljs-comment"># get the amplitude spectrum in decibels</span>
amplitude = np.<span class="hljs-built_in">abs</span>(dft)
amplitude_db = librosa.amplitude_to_db(amplitude, ref=np.<span class="hljs-built_in">max</span>)

<span class="hljs-comment"># get the frequency bins</span>
frequency = librosa.fft_frequencies(sr=sampling_rate, n_fft=<span class="hljs-built_in">len</span>(dft_input))

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
plt.plot(frequency, amplitude_db)
plt.xlabel(<span class="hljs-string">&quot;Frequency (Hz)&quot;</span>)
plt.ylabel(<span class="hljs-string">&quot;Amplitude (dB)&quot;</span>)
plt.xscale(<span class="hljs-string">&quot;log&quot;</span>)`,wrap:!1}}),T=new Da({props:{$$slots:{default:[is]},$$scope:{ctx:ze}}}),re=new je({props:{title:"Spectrogram",local:"spectrogram",headingTag:"h2"}}),ce=new Ge({props:{code:"aW1wb3J0JTIwbnVtcHklMjBhcyUyMG5wJTBBJTBBRCUyMCUzRCUyMGxpYnJvc2Euc3RmdChhcnJheSklMEFTX2RiJTIwJTNEJTIwbGlicm9zYS5hbXBsaXR1ZGVfdG9fZGIobnAuYWJzKEQpJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZGIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIyaHolMjIpJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`<span class="hljs-keyword">import</span> numpy <span class="hljs-keyword">as</span> np

D = librosa.stft(array)
S_db = librosa.amplitude_to_db(np.<span class="hljs-built_in">abs</span>(D), ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_db, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;hz&quot;</span>)
plt.colorbar()`,wrap:!1}}),ye=new je({props:{title:"Mel spectrogram",local:"mel-spectrogram",headingTag:"h2"}}),Ce=new Ge({props:{code:"UyUyMCUzRCUyMGxpYnJvc2EuZmVhdHVyZS5tZWxzcGVjdHJvZ3JhbSh5JTNEYXJyYXklMkMlMjBzciUzRHNhbXBsaW5nX3JhdGUlMkMlMjBuX21lbHMlM0QxMjglMkMlMjBmbWF4JTNEODAwMCklMEFTX2RCJTIwJTNEJTIwbGlicm9zYS5wb3dlcl90b19kYihTJTJDJTIwcmVmJTNEbnAubWF4KSUwQSUwQXBsdC5maWd1cmUoKS5zZXRfZmlnd2lkdGgoMTIpJTBBbGlicm9zYS5kaXNwbGF5LnNwZWNzaG93KFNfZEIlMkMlMjB4X2F4aXMlM0QlMjJ0aW1lJTIyJTJDJTIweV9heGlzJTNEJTIybWVsJTIyJTJDJTIwc3IlM0RzYW1wbGluZ19yYXRlJTJDJTIwZm1heCUzRDgwMDApJTBBcGx0LmNvbG9yYmFyKCk=",highlighted:`S = librosa.feature.melspectrogram(y=array, sr=sampling_rate, n_mels=<span class="hljs-number">128</span>, fmax=<span class="hljs-number">8000</span>)
S_dB = librosa.power_to_db(S, ref=np.<span class="hljs-built_in">max</span>)

plt.figure().set_figwidth(<span class="hljs-number">12</span>)
librosa.display.specshow(S_dB, x_axis=<span class="hljs-string">&quot;time&quot;</span>, y_axis=<span class="hljs-string">&quot;mel&quot;</span>, sr=sampling_rate, fmax=<span class="hljs-number">8000</span>)
plt.colorbar()`,wrap:!1}}),C=new Da({props:{$$slots:{default:[ns]},$$scope:{ctx:ze}}}),{c(){p=l("meta"),u=i(),w=l("p"),Ie=i(),m(k.$$.fragment),Fe=i(),$=l("p"),$.textContent=Dt,Le=i(),_=l("p"),_.innerHTML=Qt,Ze=i(),J=l("p"),J.textContent=At,Se=i(),m(H.$$.fragment),Ue=i(),q=l("p"),q.innerHTML=Kt,Pe=i(),v=l("div"),v.innerHTML=Ot,Xe=i(),j=l("p"),j.innerHTML=ea,We=i(),z=l("p"),z.innerHTML=ta,Ee=i(),G=l("p"),G.textContent=aa,Ye=i(),B=l("p"),B.innerHTML=sa,Re=i(),m(I.$$.fragment),Ve=i(),F=l("p"),F.textContent=ia,Ne=i(),L=l("p"),L.innerHTML=na,De=i(),Z=l("p"),Z.innerHTML=la,Qe=i(),S=l("p"),S.textContent=oa,Ae=i(),U=l("p"),U.innerHTML=ra,Ke=i(),P=l("p"),P.textContent=pa,Oe=i(),m(X.$$.fragment),et=i(),W=l("p"),W.innerHTML=ua,tt=i(),E=l("p"),E.textContent=ma,at=i(),Y=l("p"),Y.innerHTML=ha,st=i(),m(R.$$.fragment),it=i(),V=l("p"),V.textContent=ca,nt=i(),m(N.$$.fragment),lt=i(),D=l("p"),D.innerHTML=da,ot=i(),m(Q.$$.fragment),rt=i(),y=l("div"),y.innerHTML=fa,pt=i(),A=l("p"),A.textContent=ga,ut=i(),K=l("p"),K.textContent=wa,mt=i(),m(O.$$.fragment),ht=i(),ee=l("p"),ee.innerHTML=va,ct=i(),te=l("p"),te.innerHTML=ya,dt=i(),m(ae.$$.fragment),ft=i(),b=l("div"),b.innerHTML=ba,gt=i(),se=l("p"),se.textContent=Ta,wt=i(),ie=l("p"),ie.textContent=xa,vt=i(),ne=l("p"),ne.innerHTML=Ma,yt=i(),le=l("p"),le.innerHTML=Ca,bt=i(),m(T.$$.fragment),Tt=i(),oe=l("p"),oe.textContent=ka,xt=i(),m(re.$$.fragment),Mt=i(),pe=l("p"),pe.innerHTML=$a,Ct=i(),ue=l("p"),ue.textContent=_a,kt=i(),me=l("p"),me.textContent=Ja,$t=i(),he=l("p"),he.innerHTML=Ha,_t=i(),m(ce.$$.fragment),Jt=i(),x=l("div"),x.innerHTML=qa,Ht=i(),de=l("p"),de.textContent=ja,qt=i(),fe=l("p"),fe.innerHTML=za,jt=i(),ge=l("p"),ge.textContent=Ga,zt=i(),we=l("p"),we.textContent=Ba,Gt=i(),ve=l("p"),ve.textContent=Ia,Bt=i(),m(ye.$$.fragment),It=i(),be=l("p"),be.textContent=Fa,Ft=i(),Te=l("p"),Te.textContent=La,Lt=i(),xe=l("p"),xe.textContent=Za,Zt=i(),Me=l("p"),Me.innerHTML=Sa,St=i(),m(Ce.$$.fragment),Ut=i(),M=l("div"),M.innerHTML=Ua,Pt=i(),ke=l("p"),ke.innerHTML=Pa,Xt=i(),$e=l("p"),$e.innerHTML=Xa,Wt=i(),m(C.$$.fragment),Et=i(),_e=l("p"),_e.textContent=Wa,Yt=i(),Je=l("p"),Je.textContent=Ea,Rt=i(),He=l("p"),He.textContent=Ya,Vt=i(),Be=l("p"),this.h()},l(e){const t=as("svelte-u9bgzb",document.head);p=o(t,"META",{name:!0,content:!0}),t.forEach(a),u=n(e),w=o(e,"P",{}),Na(w).forEach(a),Ie=n(e),h(k.$$.fragment,e),Fe=n(e),$=o(e,"P",{"data-svelte-h":!0}),r($)!=="svelte-1pmkh95"&&($.textContent=Dt),Le=n(e),_=o(e,"P",{"data-svelte-h":!0}),r(_)!=="svelte-bb9jdf"&&(_.innerHTML=Qt),Ze=n(e),J=o(e,"P",{"data-svelte-h":!0}),r(J)!=="svelte-1nxlqp8"&&(J.textContent=At),Se=n(e),h(H.$$.fragment,e),Ue=n(e),q=o(e,"P",{"data-svelte-h":!0}),r(q)!=="svelte-ou5bn8"&&(q.innerHTML=Kt),Pe=n(e),v=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(v)!=="svelte-1g809yq"&&(v.innerHTML=Ot),Xe=n(e),j=o(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-42toji"&&(j.innerHTML=ea),We=n(e),z=o(e,"P",{"data-svelte-h":!0}),r(z)!=="svelte-1bavgg"&&(z.innerHTML=ta),Ee=n(e),G=o(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-erenf"&&(G.textContent=aa),Ye=n(e),B=o(e,"P",{"data-svelte-h":!0}),r(B)!=="svelte-vwfzx1"&&(B.innerHTML=sa),Re=n(e),h(I.$$.fragment,e),Ve=n(e),F=o(e,"P",{"data-svelte-h":!0}),r(F)!=="svelte-aeraln"&&(F.textContent=ia),Ne=n(e),L=o(e,"P",{"data-svelte-h":!0}),r(L)!=="svelte-c1topq"&&(L.innerHTML=na),De=n(e),Z=o(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-17m5t67"&&(Z.innerHTML=la),Qe=n(e),S=o(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-r3waof"&&(S.textContent=oa),Ae=n(e),U=o(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1mkb3me"&&(U.innerHTML=ra),Ke=n(e),P=o(e,"P",{"data-svelte-h":!0}),r(P)!=="svelte-1vo81sc"&&(P.textContent=pa),Oe=n(e),h(X.$$.fragment,e),et=n(e),W=o(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-1cl8jes"&&(W.innerHTML=ua),tt=n(e),E=o(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-1ef6fws"&&(E.textContent=ma),at=n(e),Y=o(e,"P",{"data-svelte-h":!0}),r(Y)!=="svelte-7fbxqn"&&(Y.innerHTML=ha),st=n(e),h(R.$$.fragment,e),it=n(e),V=o(e,"P",{"data-svelte-h":!0}),r(V)!=="svelte-4c289b"&&(V.textContent=ca),nt=n(e),h(N.$$.fragment,e),lt=n(e),D=o(e,"P",{"data-svelte-h":!0}),r(D)!=="svelte-1uo32p8"&&(D.innerHTML=da),ot=n(e),h(Q.$$.fragment,e),rt=n(e),y=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(y)!=="svelte-1cse5se"&&(y.innerHTML=fa),pt=n(e),A=o(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-4i4t88"&&(A.textContent=ga),ut=n(e),K=o(e,"P",{"data-svelte-h":!0}),r(K)!=="svelte-15w4tcn"&&(K.textContent=wa),mt=n(e),h(O.$$.fragment,e),ht=n(e),ee=o(e,"P",{"data-svelte-h":!0}),r(ee)!=="svelte-zbggm7"&&(ee.innerHTML=va),ct=n(e),te=o(e,"P",{"data-svelte-h":!0}),r(te)!=="svelte-pcmpy3"&&(te.innerHTML=ya),dt=n(e),h(ae.$$.fragment,e),ft=n(e),b=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(b)!=="svelte-1eg4i6m"&&(b.innerHTML=ba),gt=n(e),se=o(e,"P",{"data-svelte-h":!0}),r(se)!=="svelte-2gktww"&&(se.textContent=Ta),wt=n(e),ie=o(e,"P",{"data-svelte-h":!0}),r(ie)!=="svelte-1iiz53k"&&(ie.textContent=xa),vt=n(e),ne=o(e,"P",{"data-svelte-h":!0}),r(ne)!=="svelte-1djmz7i"&&(ne.innerHTML=Ma),yt=n(e),le=o(e,"P",{"data-svelte-h":!0}),r(le)!=="svelte-1bt1xj3"&&(le.innerHTML=Ca),bt=n(e),h(T.$$.fragment,e),Tt=n(e),oe=o(e,"P",{"data-svelte-h":!0}),r(oe)!=="svelte-59fha7"&&(oe.textContent=ka),xt=n(e),h(re.$$.fragment,e),Mt=n(e),pe=o(e,"P",{"data-svelte-h":!0}),r(pe)!=="svelte-196s45l"&&(pe.innerHTML=$a),Ct=n(e),ue=o(e,"P",{"data-svelte-h":!0}),r(ue)!=="svelte-1l55l7k"&&(ue.textContent=_a),kt=n(e),me=o(e,"P",{"data-svelte-h":!0}),r(me)!=="svelte-u0c2pj"&&(me.textContent=Ja),$t=n(e),he=o(e,"P",{"data-svelte-h":!0}),r(he)!=="svelte-rcbtf3"&&(he.innerHTML=Ha),_t=n(e),h(ce.$$.fragment,e),Jt=n(e),x=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(x)!=="svelte-b6kbs6"&&(x.innerHTML=qa),Ht=n(e),de=o(e,"P",{"data-svelte-h":!0}),r(de)!=="svelte-1fap1oe"&&(de.textContent=ja),qt=n(e),fe=o(e,"P",{"data-svelte-h":!0}),r(fe)!=="svelte-1v7yz7v"&&(fe.innerHTML=za),jt=n(e),ge=o(e,"P",{"data-svelte-h":!0}),r(ge)!=="svelte-13z5f9l"&&(ge.textContent=Ga),zt=n(e),we=o(e,"P",{"data-svelte-h":!0}),r(we)!=="svelte-fc7u1p"&&(we.textContent=Ba),Gt=n(e),ve=o(e,"P",{"data-svelte-h":!0}),r(ve)!=="svelte-tu7x1"&&(ve.textContent=Ia),Bt=n(e),h(ye.$$.fragment,e),It=n(e),be=o(e,"P",{"data-svelte-h":!0}),r(be)!=="svelte-naa7dr"&&(be.textContent=Fa),Ft=n(e),Te=o(e,"P",{"data-svelte-h":!0}),r(Te)!=="svelte-1x7yj9g"&&(Te.textContent=La),Lt=n(e),xe=o(e,"P",{"data-svelte-h":!0}),r(xe)!=="svelte-9z7nz9"&&(xe.textContent=Za),Zt=n(e),Me=o(e,"P",{"data-svelte-h":!0}),r(Me)!=="svelte-1bkzq64"&&(Me.innerHTML=Sa),St=n(e),h(Ce.$$.fragment,e),Ut=n(e),M=o(e,"DIV",{class:!0,"data-svelte-h":!0}),r(M)!=="svelte-1soplef"&&(M.innerHTML=Ua),Pt=n(e),ke=o(e,"P",{"data-svelte-h":!0}),r(ke)!=="svelte-otxgpj"&&(ke.innerHTML=Pa),Xt=n(e),$e=o(e,"P",{"data-svelte-h":!0}),r($e)!=="svelte-fposmi"&&($e.innerHTML=Xa),Wt=n(e),h(C.$$.fragment,e),Et=n(e),_e=o(e,"P",{"data-svelte-h":!0}),r(_e)!=="svelte-ph55g"&&(_e.textContent=Wa),Yt=n(e),Je=o(e,"P",{"data-svelte-h":!0}),r(Je)!=="svelte-lsf6hk"&&(Je.textContent=Ea),Rt=n(e),He=o(e,"P",{"data-svelte-h":!0}),r(He)!=="svelte-1xaydvu"&&(He.textContent=Ya),Vt=n(e),Be=o(e,"P",{}),Na(Be).forEach(a),this.h()},h(){qe(p,"name","hf:doc:metadata"),qe(p,"content",os),qe(v,"class","flex justify-center"),qe(y,"class","flex justify-center"),qe(b,"class","flex justify-center"),qe(x,"class","flex justify-center"),qe(M,"class","flex justify-center")},m(e,t){ss(document.head,p),s(e,u,t),s(e,w,t),s(e,Ie,t),c(k,e,t),s(e,Fe,t),s(e,$,t),s(e,Le,t),s(e,_,t),s(e,Ze,t),s(e,J,t),s(e,Se,t),c(H,e,t),s(e,Ue,t),s(e,q,t),s(e,Pe,t),s(e,v,t),s(e,Xe,t),s(e,j,t),s(e,We,t),s(e,z,t),s(e,Ee,t),s(e,G,t),s(e,Ye,t),s(e,B,t),s(e,Re,t),c(I,e,t),s(e,Ve,t),s(e,F,t),s(e,Ne,t),s(e,L,t),s(e,De,t),s(e,Z,t),s(e,Qe,t),s(e,S,t),s(e,Ae,t),s(e,U,t),s(e,Ke,t),s(e,P,t),s(e,Oe,t),c(X,e,t),s(e,et,t),s(e,W,t),s(e,tt,t),s(e,E,t),s(e,at,t),s(e,Y,t),s(e,st,t),c(R,e,t),s(e,it,t),s(e,V,t),s(e,nt,t),c(N,e,t),s(e,lt,t),s(e,D,t),s(e,ot,t),c(Q,e,t),s(e,rt,t),s(e,y,t),s(e,pt,t),s(e,A,t),s(e,ut,t),s(e,K,t),s(e,mt,t),c(O,e,t),s(e,ht,t),s(e,ee,t),s(e,ct,t),s(e,te,t),s(e,dt,t),c(ae,e,t),s(e,ft,t),s(e,b,t),s(e,gt,t),s(e,se,t),s(e,wt,t),s(e,ie,t),s(e,vt,t),s(e,ne,t),s(e,yt,t),s(e,le,t),s(e,bt,t),c(T,e,t),s(e,Tt,t),s(e,oe,t),s(e,xt,t),c(re,e,t),s(e,Mt,t),s(e,pe,t),s(e,Ct,t),s(e,ue,t),s(e,kt,t),s(e,me,t),s(e,$t,t),s(e,he,t),s(e,_t,t),c(ce,e,t),s(e,Jt,t),s(e,x,t),s(e,Ht,t),s(e,de,t),s(e,qt,t),s(e,fe,t),s(e,jt,t),s(e,ge,t),s(e,zt,t),s(e,we,t),s(e,Gt,t),s(e,ve,t),s(e,Bt,t),c(ye,e,t),s(e,It,t),s(e,be,t),s(e,Ft,t),s(e,Te,t),s(e,Lt,t),s(e,xe,t),s(e,Zt,t),s(e,Me,t),s(e,St,t),c(Ce,e,t),s(e,Ut,t),s(e,M,t),s(e,Pt,t),s(e,ke,t),s(e,Xt,t),s(e,$e,t),s(e,Wt,t),c(C,e,t),s(e,Et,t),s(e,_e,t),s(e,Yt,t),s(e,Je,t),s(e,Rt,t),s(e,He,t),s(e,Vt,t),s(e,Be,t),Nt=!0},p(e,[t]){const Ra={};t&2&&(Ra.$$scope={dirty:t,ctx:e}),T.$set(Ra);const Va={};t&2&&(Va.$$scope={dirty:t,ctx:e}),C.$set(Va)},i(e){Nt||(d(k.$$.fragment,e),d(H.$$.fragment,e),d(I.$$.fragment,e),d(X.$$.fragment,e),d(R.$$.fragment,e),d(N.$$.fragment,e),d(Q.$$.fragment,e),d(O.$$.fragment,e),d(ae.$$.fragment,e),d(T.$$.fragment,e),d(re.$$.fragment,e),d(ce.$$.fragment,e),d(ye.$$.fragment,e),d(Ce.$$.fragment,e),d(C.$$.fragment,e),Nt=!0)},o(e){f(k.$$.fragment,e),f(H.$$.fragment,e),f(I.$$.fragment,e),f(X.$$.fragment,e),f(R.$$.fragment,e),f(N.$$.fragment,e),f(Q.$$.fragment,e),f(O.$$.fragment,e),f(ae.$$.fragment,e),f(T.$$.fragment,e),f(re.$$.fragment,e),f(ce.$$.fragment,e),f(ye.$$.fragment,e),f(Ce.$$.fragment,e),f(C.$$.fragment,e),Nt=!1},d(e){e&&(a(u),a(w),a(Ie),a(Fe),a($),a(Le),a(_),a(Ze),a(J),a(Se),a(Ue),a(q),a(Pe),a(v),a(Xe),a(j),a(We),a(z),a(Ee),a(G),a(Ye),a(B),a(Re),a(Ve),a(F),a(Ne),a(L),a(De),a(Z),a(Qe),a(S),a(Ae),a(U),a(Ke),a(P),a(Oe),a(et),a(W),a(tt),a(E),a(at),a(Y),a(st),a(it),a(V),a(nt),a(lt),a(D),a(ot),a(rt),a(y),a(pt),a(A),a(ut),a(K),a(mt),a(ht),a(ee),a(ct),a(te),a(dt),a(ft),a(b),a(gt),a(se),a(wt),a(ie),a(vt),a(ne),a(yt),a(le),a(bt),a(Tt),a(oe),a(xt),a(Mt),a(pe),a(Ct),a(ue),a(kt),a(me),a($t),a(he),a(_t),a(Jt),a(x),a(Ht),a(de),a(qt),a(fe),a(jt),a(ge),a(zt),a(we),a(Gt),a(ve),a(Bt),a(It),a(be),a(Ft),a(Te),a(Lt),a(xe),a(Zt),a(Me),a(St),a(Ut),a(M),a(Pt),a(ke),a(Xt),a($e),a(Wt),a(Et),a(_e),a(Yt),a(Je),a(Rt),a(He),a(Vt),a(Be)),a(p),g(k,e),g(H,e),g(I,e),g(X,e),g(R,e),g(N,e),g(Q,e),g(O,e),g(ae,e),g(T,e),g(re,e),g(ce,e),g(ye,e),g(Ce,e),g(C,e)}}}const os='{"title":"Introduction to audio data","local":"introduction-to-audio-data","sections":[{"title":"Sampling and sampling rate","local":"sampling-and-sampling-rate","sections":[],"depth":2},{"title":"Amplitude and bit depth","local":"amplitude-and-bit-depth","sections":[],"depth":2},{"title":"Audio as a waveform","local":"audio-as-a-waveform","sections":[],"depth":2},{"title":"The frequency spectrum","local":"the-frequency-spectrum","sections":[],"depth":2},{"title":"Spectrogram","local":"spectrogram","sections":[],"depth":2},{"title":"Mel spectrogram","local":"mel-spectrogram","sections":[],"depth":2}],"depth":1}';function rs(ze){return Oa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class ds extends es{constructor(p){super(),ts(this,p,rs,ls,Ka,{})}}export{ds as component};
