import{s as Oa,n as qa,o as el}from"../chunks/scheduler.85c25b89.js";import{S as tl,i as sl,g as l,s as r,u as m,A as al,h as n,f as t,c as p,j as h,v as u,y as c,k as i,o,a,w as f,d as y,t as d,x as M}from"../chunks/index.9633332f.js";import{I as j}from"../chunks/IconCopyLink.a4acffac.js";import{C as g}from"../chunks/CodeBlock.00597c71.js";function ll(Ws){let v,gt,at,jt,w,E,lt,F,_s,We,Gs="Feature Extraction",vt,Y,Xs="All of the models in <code>timm</code> have consistent mechanisms for obtaining various types of features from the model for tasks besides classification.",wt,b,B,nt,P,Ns,Ge,Fs="Penultimate Layer Features (Pre-Classifier Features)",bt,K,Ys="The features from the penultimate model layer can be obtained in several ways without requiring model surgery (although feel free to do surgery). One must first decide if they want pooled or un-pooled features.",Ut,U,I,rt,L,Ss,Xe,Ps="Unpooled",Jt,O,Ks="There are three ways to obtain unpooled features.",$t,q,Ls="Without modifying the network, one can call <code>model.forward_features(input)</code> on any model instead of the usual <code>model(input)</code>. This will bypass the head classifier and global pooling for networks.",Ct,ee,Os="If one wants to explicitly modify the network to return unpooled features, they can either create the model without a classifier and pooling, or remove it later. Both paths remove the parameters associated with the classifier from the network.",Tt,J,Z,pt,te,Es,Fe,qs="forward_features()",kt,se,xt,ae,ea="Output:",Qt,le,_t,$,A,it,ne,Bs,Ye,ta="Create with no classifier and pooling",Nt,re,St,pe,sa="Output:",Et,ie,Bt,C,z,ot,oe,Is,Pe,aa="Remove it later",It,he,Zt,ce,la="Output:",At,me,zt,T,R,ht,ue,Zs,Ke,na="Pooled",Rt,fe,ra="To modify the network to return pooled features, one can use <code>forward_features()</code> and pool/flatten the result themselves, or modify the network like above but keep pooling intact.",Vt,k,V,ct,ye,As,Le,pa="Create with no classifier",Dt,de,Ht,Me,ia="Output:",Wt,ge,Gt,x,D,mt,je,zs,Oe,oa="Remove it later",Xt,ve,Ft,we,ha="Output:",Yt,be,Pt,Q,H,ut,Ue,Rs,qe,ca="Multi-scale Feature Maps (Feature Pyramid)",Kt,Je,ma="Object detection, segmentation, keypoint, and a variety of dense pixel tasks require access to feature maps from the backbone network at multiple scales. This is often done by modifying the original classification network. Since each network varies quite a bit in structure, it’s not uncommon to see only a few backbones supported in any given obj detection or segmentation library.",Lt,$e,ua="<code>timm</code> allows a consistent interface for creating any of the included models as feature backbones that output feature maps for selected levels.",Ot,Ce,fa="A feature backbone can be created by adding the argument <code>features_only=True</code> to any <code>create_model</code> call. By default 5 strides will be output from most models (not all have that many), with the first starting at 2 (some start at 1 or 4).",qt,_,W,ft,Te,Vs,et,ya="Create a feature map extraction model",es,ke,ts,xe,da="Output:",ss,Qe,as,N,G,yt,_e,Ds,tt,Ma="Query the feature information",ls,Ne,ga="After a feature backbone has been created, it can be queried to provide channel or resolution reduction information to the downstream heads without requiring static config or hardcoded constants. The <code>.feature_info</code> attribute is a class encapsulating the information about the feature extraction points.",ns,Se,rs,Ee,ja="Output:",ps,Be,is,S,X,dt,Ie,Hs,st,va="Select specific feature levels or limit the stride",os,Ze,wa="There are two additional creation arguments impacting the output features.",hs,Ae,ba="<li><code>out_indices</code> selects which indices to output</li> <li><code>output_stride</code> limits the feature output stride of the network (also works in classification mode BTW)</li>",cs,ze,Ua="<code>out_indices</code> is supported by all models, but not all models have the same index to feature stride mapping. Look at the code or check feature_info to compare. The out indices generally correspond to the <code>C(i+1)th</code> feature level (a <code>2^(i+1)</code> reduction). For most models, index 0 is the stride 2 features, and index 4 is stride 32.",ms,Re,Ja="<code>output_stride</code> is achieved by converting layers to use dilated convolutions. Doing so is not always straightforward, some networks only support <code>output_stride=32</code>.",us,Ve,fs,De,$a="Output:",ys,He,ds,Mt,Ms;return F=new j({}),P=new j({}),L=new j({}),te=new j({}),se=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCd4Y2VwdGlvbjQxJyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFvJTIwJTNEJTIwbS5mb3J3YXJkX2ZlYXR1cmVzKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjk5JTJDJTIwMjk5KSklMEFwcmludChmJ1VucG9vbGVkJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;xception41&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m.forward_features(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">299</span>, <span class="hljs-number">299</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`}}),le=new g({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjAxMCUyQyUyMDEwJTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 2048, 10, 10])`}}),ne=new j({}),re=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCUyQyUyMGdsb2JhbF9wb29sJTNEJycpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQXByaW50KGYnVW5wb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>, global_pool=<span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`}}),ie=new g({props:{code:"VW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:"Unpooled shape: torch.Size([2, 2048, 7, 7])"}}),oe=new j({}),he=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdkZW5zZW5ldDEyMSclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidPcmlnaW5hbCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcpJTBBbS5yZXNldF9jbGFzc2lmaWVyKDAlMkMlMjAnJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidVbnBvb2xlZCUyMHNoYXBlJTNBJTIwJTdCby5zaGFwZSU3RCcp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;densenet121&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>, <span class="hljs-string">&#x27;&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Unpooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`}}),me=new g({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBVW5wb29sZWQlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Original shape: torch.Size([2, 1000])
Unpooled shape: torch.Size([2, 1024, 7, 7])`}}),ue=new j({}),ye=new j({}),de=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXQ1MCclMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSUyQyUyMG51bV9jbGFzc2VzJTNEMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnet50&#x27;</span>, pretrained=<span class="hljs-literal">True</span>, num_classes=<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`}}),ge=new g({props:{code:"UG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAyMDQ4JTVEKQ==",highlighted:"Pooled shape: torch.Size([2, 2048])"}}),je=new j({}),ve=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlc2Vfdm92bmV0MTliX2R3JyUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQW8lMjAlM0QlMjBtKHRvcmNoLnJhbmRuKDIlMkMlMjAzJTJDJTIwMjI0JTJDJTIwMjI0KSklMEFwcmludChmJ09yaWdpbmFsJTIwc2hhcGUlM0ElMjAlN0JvLnNoYXBlJTdEJyklMEFtLnJlc2V0X2NsYXNzaWZpZXIoMCklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDIyNCUyQyUyMDIyNCkpJTBBcHJpbnQoZidQb29sZWQlMjBzaGFwZSUzQSUyMCU3Qm8uc2hhcGUlN0QnKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ese_vovnet19b_dw&#x27;</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Original shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>m.reset_classifier(<span class="hljs-number">0</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Pooled shape: <span class="hljs-subst">{o.shape}</span>&#x27;</span>)`}}),be=new g({props:{code:"T3JpZ2luYWwlMjBzaGFwZSUzQSUyMHRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMDAlNUQpJTBBUG9vbGVkJTIwc2hhcGUlM0ElMjB0b3JjaC5TaXplKCU1QjIlMkMlMjAxMDI0JTVEKQ==",highlighted:`Original shape: torch.Size([2, 1000])
Pooled shape: torch.Size([2, 1024])`}}),Ue=new j({}),Te=new j({}),ke=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZXNuZXN0MjZkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwcHJldHJhaW5lZCUzRFRydWUpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;resnest26d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`}}),Qe=new g({props:{code:"dG9yY2guU2l6ZSglNUIyJTJDJTIwNjQlMkMlMjAxMTIlMkMlMjAxMTIlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjU2JTJDJTIwNTYlMkMlMjA1NiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1MTIlMkMlMjAyOCUyQyUyMDI4JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDEwMjQlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDIwNDglMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`torch.Size([2, 64, 112, 112])
torch.Size([2, 256, 56, 56])
torch.Size([2, 512, 28, 28])
torch.Size([2, 1024, 14, 14])
torch.Size([2, 2048, 7, 7])`}}),_e=new j({}),Se=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdyZWduZXR5XzAzMiclMkMlMjBmZWF0dXJlc19vbmx5JTNEVHJ1ZSUyQyUyMHByZXRyYWluZWQlM0RUcnVlKSUwQXByaW50KGYnRmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTdCbS5mZWF0dXJlX2luZm8uY2hhbm5lbHMoKSU3RCcpJTBBbyUyMCUzRCUyMG0odG9yY2gucmFuZG4oMiUyQyUyMDMlMkMlMjAyMjQlMkMlMjAyMjQpKSUwQWZvciUyMHglMjBpbiUyMG8lM0ElMEElMjAlMjAlMjAlMjBwcmludCh4LnNoYXBlKQ==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;regnety_032&#x27;</span>, features_only=<span class="hljs-literal">True</span>, pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">224</span>, <span class="hljs-number">224</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`}}),Be=new g({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCMzIlMkMlMjA3MiUyQyUyMDIxNiUyQyUyMDU3NiUyQyUyMDE1MTIlNUQlMEF0b3JjaC5TaXplKCU1QjIlMkMlMjAzMiUyQyUyMDExMiUyQyUyMDExMiU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA3MiUyQyUyMDU2JTJDJTIwNTYlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjE2JTJDJTIwMjglMkMlMjAyOCU1RCklMEF0b3JjaC5TaXplKCU1QjIlMkMlMjA1NzYlMkMlMjAxNCUyQyUyMDE0JTVEKSUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDE1MTIlMkMlMjA3JTJDJTIwNyU1RCk=",highlighted:`Feature channels: [32, 72, 216, 576, 1512]
torch.Size([2, 32, 112, 112])
torch.Size([2, 72, 56, 56])
torch.Size([2, 216, 28, 28])
torch.Size([2, 576, 14, 14])
torch.Size([2, 1512, 7, 7])`}}),Ie=new j({}),Ve=new g({props:{code:"aW1wb3J0JTIwdG9yY2glMEFpbXBvcnQlMjB0aW1tJTBBbSUyMCUzRCUyMHRpbW0uY3JlYXRlX21vZGVsKCdlY2FyZXNuZXQxMDFkJyUyQyUyMGZlYXR1cmVzX29ubHklM0RUcnVlJTJDJTIwb3V0cHV0X3N0cmlkZSUzRDglMkMlMjBvdXRfaW5kaWNlcyUzRCgyJTJDJTIwNCklMkMlMjBwcmV0cmFpbmVkJTNEVHJ1ZSklMEFwcmludChmJ0ZlYXR1cmUlMjBjaGFubmVscyUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLmNoYW5uZWxzKCklN0QnKSUwQXByaW50KGYnRmVhdHVyZSUyMHJlZHVjdGlvbiUzQSUyMCU3Qm0uZmVhdHVyZV9pbmZvLnJlZHVjdGlvbigpJTdEJyklMEFvJTIwJTNEJTIwbSh0b3JjaC5yYW5kbigyJTJDJTIwMyUyQyUyMDMyMCUyQyUyMDMyMCkpJTBBZm9yJTIweCUyMGluJTIwbyUzQSUwQSUyMCUyMCUyMCUyMHByaW50KHguc2hhcGUp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> torch
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> timm
<span class="hljs-meta">&gt;&gt;&gt; </span>m = timm.create_model(<span class="hljs-string">&#x27;ecaresnet101d&#x27;</span>, features_only=<span class="hljs-literal">True</span>, output_stride=<span class="hljs-number">8</span>, out_indices=(<span class="hljs-number">2</span>, <span class="hljs-number">4</span>), pretrained=<span class="hljs-literal">True</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature channels: <span class="hljs-subst">{m.feature_info.channels()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">f&#x27;Feature reduction: <span class="hljs-subst">{m.feature_info.reduction()}</span>&#x27;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>o = m(torch.randn(<span class="hljs-number">2</span>, <span class="hljs-number">3</span>, <span class="hljs-number">320</span>, <span class="hljs-number">320</span>))
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">for</span> x <span class="hljs-keyword">in</span> o:
<span class="hljs-meta">... </span>    <span class="hljs-built_in">print</span>(x.shape)`}}),He=new g({props:{code:"RmVhdHVyZSUyMGNoYW5uZWxzJTNBJTIwJTVCNTEyJTJDJTIwMjA0OCU1RCUwQUZlYXR1cmUlMjByZWR1Y3Rpb24lM0ElMjAlNUI4JTJDJTIwOCU1RCUwQXRvcmNoLlNpemUoJTVCMiUyQyUyMDUxMiUyQyUyMDQwJTJDJTIwNDAlNUQpJTBBdG9yY2guU2l6ZSglNUIyJTJDJTIwMjA0OCUyQyUyMDQwJTJDJTIwNDAlNUQp",highlighted:`Feature channels: [512, 2048]
Feature reduction: [8, 8]
torch.Size([2, 512, 40, 40])
torch.Size([2, 2048, 40, 40])`}}),{c(){v=l("meta"),gt=r(),at=l("p"),jt=r(),w=l("h1"),E=l("a"),lt=l("span"),m(F.$$.fragment),_s=r(),We=l("span"),We.textContent=Gs,vt=r(),Y=l("p"),Y.innerHTML=Xs,wt=r(),b=l("h2"),B=l("a"),nt=l("span"),m(P.$$.fragment),Ns=r(),Ge=l("span"),Ge.textContent=Fs,bt=r(),K=l("p"),K.textContent=Ys,Ut=r(),U=l("h3"),I=l("a"),rt=l("span"),m(L.$$.fragment),Ss=r(),Xe=l("span"),Xe.textContent=Ps,Jt=r(),O=l("p"),O.textContent=Ks,$t=r(),q=l("p"),q.innerHTML=Ls,Ct=r(),ee=l("p"),ee.textContent=Os,Tt=r(),J=l("h4"),Z=l("a"),pt=l("span"),m(te.$$.fragment),Es=r(),Fe=l("span"),Fe.textContent=qs,kt=r(),m(se.$$.fragment),xt=r(),ae=l("p"),ae.textContent=ea,Qt=r(),m(le.$$.fragment),_t=r(),$=l("h4"),A=l("a"),it=l("span"),m(ne.$$.fragment),Bs=r(),Ye=l("span"),Ye.textContent=ta,Nt=r(),m(re.$$.fragment),St=r(),pe=l("p"),pe.textContent=sa,Et=r(),m(ie.$$.fragment),Bt=r(),C=l("h4"),z=l("a"),ot=l("span"),m(oe.$$.fragment),Is=r(),Pe=l("span"),Pe.textContent=aa,It=r(),m(he.$$.fragment),Zt=r(),ce=l("p"),ce.textContent=la,At=r(),m(me.$$.fragment),zt=r(),T=l("h3"),R=l("a"),ht=l("span"),m(ue.$$.fragment),Zs=r(),Ke=l("span"),Ke.textContent=na,Rt=r(),fe=l("p"),fe.innerHTML=ra,Vt=r(),k=l("h4"),V=l("a"),ct=l("span"),m(ye.$$.fragment),As=r(),Le=l("span"),Le.textContent=pa,Dt=r(),m(de.$$.fragment),Ht=r(),Me=l("p"),Me.textContent=ia,Wt=r(),m(ge.$$.fragment),Gt=r(),x=l("h4"),D=l("a"),mt=l("span"),m(je.$$.fragment),zs=r(),Oe=l("span"),Oe.textContent=oa,Xt=r(),m(ve.$$.fragment),Ft=r(),we=l("p"),we.textContent=ha,Yt=r(),m(be.$$.fragment),Pt=r(),Q=l("h2"),H=l("a"),ut=l("span"),m(Ue.$$.fragment),Rs=r(),qe=l("span"),qe.textContent=ca,Kt=r(),Je=l("p"),Je.textContent=ma,Lt=r(),$e=l("p"),$e.innerHTML=ua,Ot=r(),Ce=l("p"),Ce.innerHTML=fa,qt=r(),_=l("h3"),W=l("a"),ft=l("span"),m(Te.$$.fragment),Vs=r(),et=l("span"),et.textContent=ya,es=r(),m(ke.$$.fragment),ts=r(),xe=l("p"),xe.textContent=da,ss=r(),m(Qe.$$.fragment),as=r(),N=l("h3"),G=l("a"),yt=l("span"),m(_e.$$.fragment),Ds=r(),tt=l("span"),tt.textContent=Ma,ls=r(),Ne=l("p"),Ne.innerHTML=ga,ns=r(),m(Se.$$.fragment),rs=r(),Ee=l("p"),Ee.textContent=ja,ps=r(),m(Be.$$.fragment),is=r(),S=l("h3"),X=l("a"),dt=l("span"),m(Ie.$$.fragment),Hs=r(),st=l("span"),st.textContent=va,os=r(),Ze=l("p"),Ze.textContent=wa,hs=r(),Ae=l("ul"),Ae.innerHTML=ba,cs=r(),ze=l("p"),ze.innerHTML=Ua,ms=r(),Re=l("p"),Re.innerHTML=Ja,us=r(),m(Ve.$$.fragment),fs=r(),De=l("p"),De.textContent=$a,ys=r(),m(He.$$.fragment),ds=r(),Mt=l("p"),this.h()},l(e){const s=al("svelte-1phssyn",document.head);v=n(s,"META",{name:!0,content:!0}),s.forEach(t),gt=p(e),at=n(e,"P",{}),h(at).forEach(t),jt=p(e),w=n(e,"H1",{class:!0});var gs=h(w);E=n(gs,"A",{id:!0,class:!0,href:!0});var Ca=h(E);lt=n(Ca,"SPAN",{});var Ta=h(lt);u(F.$$.fragment,Ta),Ta.forEach(t),Ca.forEach(t),_s=p(gs),We=n(gs,"SPAN",{"data-svelte-h":!0}),c(We)!=="svelte-462alo"&&(We.textContent=Gs),gs.forEach(t),vt=p(e),Y=n(e,"P",{"data-svelte-h":!0}),c(Y)!=="svelte-1w5xc9e"&&(Y.innerHTML=Xs),wt=p(e),b=n(e,"H2",{class:!0});var js=h(b);B=n(js,"A",{id:!0,class:!0,href:!0});var ka=h(B);nt=n(ka,"SPAN",{});var xa=h(nt);u(P.$$.fragment,xa),xa.forEach(t),ka.forEach(t),Ns=p(js),Ge=n(js,"SPAN",{"data-svelte-h":!0}),c(Ge)!=="svelte-9z472k"&&(Ge.textContent=Fs),js.forEach(t),bt=p(e),K=n(e,"P",{"data-svelte-h":!0}),c(K)!=="svelte-1i0y2af"&&(K.textContent=Ys),Ut=p(e),U=n(e,"H3",{class:!0});var vs=h(U);I=n(vs,"A",{id:!0,class:!0,href:!0});var Qa=h(I);rt=n(Qa,"SPAN",{});var _a=h(rt);u(L.$$.fragment,_a),_a.forEach(t),Qa.forEach(t),Ss=p(vs),Xe=n(vs,"SPAN",{"data-svelte-h":!0}),c(Xe)!=="svelte-wja35d"&&(Xe.textContent=Ps),vs.forEach(t),Jt=p(e),O=n(e,"P",{"data-svelte-h":!0}),c(O)!=="svelte-gzowzl"&&(O.textContent=Ks),$t=p(e),q=n(e,"P",{"data-svelte-h":!0}),c(q)!=="svelte-1c1de84"&&(q.innerHTML=Ls),Ct=p(e),ee=n(e,"P",{"data-svelte-h":!0}),c(ee)!=="svelte-1c79pr0"&&(ee.textContent=Os),Tt=p(e),J=n(e,"H4",{class:!0});var ws=h(J);Z=n(ws,"A",{id:!0,class:!0,href:!0});var Na=h(Z);pt=n(Na,"SPAN",{});var Sa=h(pt);u(te.$$.fragment,Sa),Sa.forEach(t),Na.forEach(t),Es=p(ws),Fe=n(ws,"SPAN",{"data-svelte-h":!0}),c(Fe)!=="svelte-1gu40pv"&&(Fe.textContent=qs),ws.forEach(t),kt=p(e),u(se.$$.fragment,e),xt=p(e),ae=n(e,"P",{"data-svelte-h":!0}),c(ae)!=="svelte-1wuxk0l"&&(ae.textContent=ea),Qt=p(e),u(le.$$.fragment,e),_t=p(e),$=n(e,"H4",{class:!0});var bs=h($);A=n(bs,"A",{id:!0,class:!0,href:!0});var Ea=h(A);it=n(Ea,"SPAN",{});var Ba=h(it);u(ne.$$.fragment,Ba),Ba.forEach(t),Ea.forEach(t),Bs=p(bs),Ye=n(bs,"SPAN",{"data-svelte-h":!0}),c(Ye)!=="svelte-d0ivdg"&&(Ye.textContent=ta),bs.forEach(t),Nt=p(e),u(re.$$.fragment,e),St=p(e),pe=n(e,"P",{"data-svelte-h":!0}),c(pe)!=="svelte-1wuxk0l"&&(pe.textContent=sa),Et=p(e),u(ie.$$.fragment,e),Bt=p(e),C=n(e,"H4",{class:!0});var Us=h(C);z=n(Us,"A",{id:!0,class:!0,href:!0});var Ia=h(z);ot=n(Ia,"SPAN",{});var Za=h(ot);u(oe.$$.fragment,Za),Za.forEach(t),Ia.forEach(t),Is=p(Us),Pe=n(Us,"SPAN",{"data-svelte-h":!0}),c(Pe)!=="svelte-py1j34"&&(Pe.textContent=aa),Us.forEach(t),It=p(e),u(he.$$.fragment,e),Zt=p(e),ce=n(e,"P",{"data-svelte-h":!0}),c(ce)!=="svelte-1wuxk0l"&&(ce.textContent=la),At=p(e),u(me.$$.fragment,e),zt=p(e),T=n(e,"H3",{class:!0});var Js=h(T);R=n(Js,"A",{id:!0,class:!0,href:!0});var Aa=h(R);ht=n(Aa,"SPAN",{});var za=h(ht);u(ue.$$.fragment,za),za.forEach(t),Aa.forEach(t),Zs=p(Js),Ke=n(Js,"SPAN",{"data-svelte-h":!0}),c(Ke)!=="svelte-1x1zhig"&&(Ke.textContent=na),Js.forEach(t),Rt=p(e),fe=n(e,"P",{"data-svelte-h":!0}),c(fe)!=="svelte-jci7dg"&&(fe.innerHTML=ra),Vt=p(e),k=n(e,"H4",{class:!0});var $s=h(k);V=n($s,"A",{id:!0,class:!0,href:!0});var Ra=h(V);ct=n(Ra,"SPAN",{});var Va=h(ct);u(ye.$$.fragment,Va),Va.forEach(t),Ra.forEach(t),As=p($s),Le=n($s,"SPAN",{"data-svelte-h":!0}),c(Le)!=="svelte-1h62v0b"&&(Le.textContent=pa),$s.forEach(t),Dt=p(e),u(de.$$.fragment,e),Ht=p(e),Me=n(e,"P",{"data-svelte-h":!0}),c(Me)!=="svelte-1wuxk0l"&&(Me.textContent=ia),Wt=p(e),u(ge.$$.fragment,e),Gt=p(e),x=n(e,"H4",{class:!0});var Cs=h(x);D=n(Cs,"A",{id:!0,class:!0,href:!0});var Da=h(D);mt=n(Da,"SPAN",{});var Ha=h(mt);u(je.$$.fragment,Ha),Ha.forEach(t),Da.forEach(t),zs=p(Cs),Oe=n(Cs,"SPAN",{"data-svelte-h":!0}),c(Oe)!=="svelte-py1j34"&&(Oe.textContent=oa),Cs.forEach(t),Xt=p(e),u(ve.$$.fragment,e),Ft=p(e),we=n(e,"P",{"data-svelte-h":!0}),c(we)!=="svelte-1wuxk0l"&&(we.textContent=ha),Yt=p(e),u(be.$$.fragment,e),Pt=p(e),Q=n(e,"H2",{class:!0});var Ts=h(Q);H=n(Ts,"A",{id:!0,class:!0,href:!0});var Wa=h(H);ut=n(Wa,"SPAN",{});var Ga=h(ut);u(Ue.$$.fragment,Ga),Ga.forEach(t),Wa.forEach(t),Rs=p(Ts),qe=n(Ts,"SPAN",{"data-svelte-h":!0}),c(qe)!=="svelte-9po0nb"&&(qe.textContent=ca),Ts.forEach(t),Kt=p(e),Je=n(e,"P",{"data-svelte-h":!0}),c(Je)!=="svelte-56ounp"&&(Je.textContent=ma),Lt=p(e),$e=n(e,"P",{"data-svelte-h":!0}),c($e)!=="svelte-1j7o0l4"&&($e.innerHTML=ua),Ot=p(e),Ce=n(e,"P",{"data-svelte-h":!0}),c(Ce)!=="svelte-qgbd6k"&&(Ce.innerHTML=fa),qt=p(e),_=n(e,"H3",{class:!0});var ks=h(_);W=n(ks,"A",{id:!0,class:!0,href:!0});var Xa=h(W);ft=n(Xa,"SPAN",{});var Fa=h(ft);u(Te.$$.fragment,Fa),Fa.forEach(t),Xa.forEach(t),Vs=p(ks),et=n(ks,"SPAN",{"data-svelte-h":!0}),c(et)!=="svelte-fhlqou"&&(et.textContent=ya),ks.forEach(t),es=p(e),u(ke.$$.fragment,e),ts=p(e),xe=n(e,"P",{"data-svelte-h":!0}),c(xe)!=="svelte-1wuxk0l"&&(xe.textContent=da),ss=p(e),u(Qe.$$.fragment,e),as=p(e),N=n(e,"H3",{class:!0});var xs=h(N);G=n(xs,"A",{id:!0,class:!0,href:!0});var Ya=h(G);yt=n(Ya,"SPAN",{});var Pa=h(yt);u(_e.$$.fragment,Pa),Pa.forEach(t),Ya.forEach(t),Ds=p(xs),tt=n(xs,"SPAN",{"data-svelte-h":!0}),c(tt)!=="svelte-3qill4"&&(tt.textContent=Ma),xs.forEach(t),ls=p(e),Ne=n(e,"P",{"data-svelte-h":!0}),c(Ne)!=="svelte-2ryznm"&&(Ne.innerHTML=ga),ns=p(e),u(Se.$$.fragment,e),rs=p(e),Ee=n(e,"P",{"data-svelte-h":!0}),c(Ee)!=="svelte-1wuxk0l"&&(Ee.textContent=ja),ps=p(e),u(Be.$$.fragment,e),is=p(e),S=n(e,"H3",{class:!0});var Qs=h(S);X=n(Qs,"A",{id:!0,class:!0,href:!0});var Ka=h(X);dt=n(Ka,"SPAN",{});var La=h(dt);u(Ie.$$.fragment,La),La.forEach(t),Ka.forEach(t),Hs=p(Qs),st=n(Qs,"SPAN",{"data-svelte-h":!0}),c(st)!=="svelte-zvtipw"&&(st.textContent=va),Qs.forEach(t),os=p(e),Ze=n(e,"P",{"data-svelte-h":!0}),c(Ze)!=="svelte-18fc4zz"&&(Ze.textContent=wa),hs=p(e),Ae=n(e,"UL",{"data-svelte-h":!0}),c(Ae)!=="svelte-1c2ig9e"&&(Ae.innerHTML=ba),cs=p(e),ze=n(e,"P",{"data-svelte-h":!0}),c(ze)!=="svelte-1sy35a7"&&(ze.innerHTML=Ua),ms=p(e),Re=n(e,"P",{"data-svelte-h":!0}),c(Re)!=="svelte-nvrnid"&&(Re.innerHTML=Ja),us=p(e),u(Ve.$$.fragment,e),fs=p(e),De=n(e,"P",{"data-svelte-h":!0}),c(De)!=="svelte-1wuxk0l"&&(De.textContent=$a),ys=p(e),u(He.$$.fragment,e),ds=p(e),Mt=n(e,"P",{}),h(Mt).forEach(t),this.h()},h(){i(v,"name","hf:doc:metadata"),i(v,"content",JSON.stringify(nl)),i(E,"id","feature-extraction"),i(E,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(E,"href","#feature-extraction"),i(w,"class","relative group"),i(B,"id","penultimate-layer-features-preclassifier-features"),i(B,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(B,"href","#penultimate-layer-features-preclassifier-features"),i(b,"class","relative group"),i(I,"id","unpooled"),i(I,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(I,"href","#unpooled"),i(U,"class","relative group"),i(Z,"id","forwardfeatures"),i(Z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(Z,"href","#forwardfeatures"),i(J,"class","relative group"),i(A,"id","create-with-no-classifier-and-pooling"),i(A,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(A,"href","#create-with-no-classifier-and-pooling"),i($,"class","relative group"),i(z,"id","remove-it-later"),i(z,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(z,"href","#remove-it-later"),i(C,"class","relative group"),i(R,"id","pooled"),i(R,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(R,"href","#pooled"),i(T,"class","relative group"),i(V,"id","create-with-no-classifier"),i(V,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(V,"href","#create-with-no-classifier"),i(k,"class","relative group"),i(D,"id","remove-it-later"),i(D,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(D,"href","#remove-it-later"),i(x,"class","relative group"),i(H,"id","multiscale-feature-maps-feature-pyramid"),i(H,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(H,"href","#multiscale-feature-maps-feature-pyramid"),i(Q,"class","relative group"),i(W,"id","create-a-feature-map-extraction-model"),i(W,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(W,"href","#create-a-feature-map-extraction-model"),i(_,"class","relative group"),i(G,"id","query-the-feature-information"),i(G,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(G,"href","#query-the-feature-information"),i(N,"class","relative group"),i(X,"id","select-specific-feature-levels-or-limit-the-stride"),i(X,"class","header-link block pr-1.5 text-lg no-hover:hidden with-hover:absolute with-hover:p-1.5 with-hover:opacity-0 with-hover:group-hover:opacity-100 with-hover:right-full"),i(X,"href","#select-specific-feature-levels-or-limit-the-stride"),i(S,"class","relative group")},m(e,s){o(document.head,v),a(e,gt,s),a(e,at,s),a(e,jt,s),a(e,w,s),o(w,E),o(E,lt),f(F,lt,null),o(w,_s),o(w,We),a(e,vt,s),a(e,Y,s),a(e,wt,s),a(e,b,s),o(b,B),o(B,nt),f(P,nt,null),o(b,Ns),o(b,Ge),a(e,bt,s),a(e,K,s),a(e,Ut,s),a(e,U,s),o(U,I),o(I,rt),f(L,rt,null),o(U,Ss),o(U,Xe),a(e,Jt,s),a(e,O,s),a(e,$t,s),a(e,q,s),a(e,Ct,s),a(e,ee,s),a(e,Tt,s),a(e,J,s),o(J,Z),o(Z,pt),f(te,pt,null),o(J,Es),o(J,Fe),a(e,kt,s),f(se,e,s),a(e,xt,s),a(e,ae,s),a(e,Qt,s),f(le,e,s),a(e,_t,s),a(e,$,s),o($,A),o(A,it),f(ne,it,null),o($,Bs),o($,Ye),a(e,Nt,s),f(re,e,s),a(e,St,s),a(e,pe,s),a(e,Et,s),f(ie,e,s),a(e,Bt,s),a(e,C,s),o(C,z),o(z,ot),f(oe,ot,null),o(C,Is),o(C,Pe),a(e,It,s),f(he,e,s),a(e,Zt,s),a(e,ce,s),a(e,At,s),f(me,e,s),a(e,zt,s),a(e,T,s),o(T,R),o(R,ht),f(ue,ht,null),o(T,Zs),o(T,Ke),a(e,Rt,s),a(e,fe,s),a(e,Vt,s),a(e,k,s),o(k,V),o(V,ct),f(ye,ct,null),o(k,As),o(k,Le),a(e,Dt,s),f(de,e,s),a(e,Ht,s),a(e,Me,s),a(e,Wt,s),f(ge,e,s),a(e,Gt,s),a(e,x,s),o(x,D),o(D,mt),f(je,mt,null),o(x,zs),o(x,Oe),a(e,Xt,s),f(ve,e,s),a(e,Ft,s),a(e,we,s),a(e,Yt,s),f(be,e,s),a(e,Pt,s),a(e,Q,s),o(Q,H),o(H,ut),f(Ue,ut,null),o(Q,Rs),o(Q,qe),a(e,Kt,s),a(e,Je,s),a(e,Lt,s),a(e,$e,s),a(e,Ot,s),a(e,Ce,s),a(e,qt,s),a(e,_,s),o(_,W),o(W,ft),f(Te,ft,null),o(_,Vs),o(_,et),a(e,es,s),f(ke,e,s),a(e,ts,s),a(e,xe,s),a(e,ss,s),f(Qe,e,s),a(e,as,s),a(e,N,s),o(N,G),o(G,yt),f(_e,yt,null),o(N,Ds),o(N,tt),a(e,ls,s),a(e,Ne,s),a(e,ns,s),f(Se,e,s),a(e,rs,s),a(e,Ee,s),a(e,ps,s),f(Be,e,s),a(e,is,s),a(e,S,s),o(S,X),o(X,dt),f(Ie,dt,null),o(S,Hs),o(S,st),a(e,os,s),a(e,Ze,s),a(e,hs,s),a(e,Ae,s),a(e,cs,s),a(e,ze,s),a(e,ms,s),a(e,Re,s),a(e,us,s),f(Ve,e,s),a(e,fs,s),a(e,De,s),a(e,ys,s),f(He,e,s),a(e,ds,s),a(e,Mt,s),Ms=!0},p:qa,i(e){Ms||(y(F.$$.fragment,e),y(P.$$.fragment,e),y(L.$$.fragment,e),y(te.$$.fragment,e),y(se.$$.fragment,e),y(le.$$.fragment,e),y(ne.$$.fragment,e),y(re.$$.fragment,e),y(ie.$$.fragment,e),y(oe.$$.fragment,e),y(he.$$.fragment,e),y(me.$$.fragment,e),y(ue.$$.fragment,e),y(ye.$$.fragment,e),y(de.$$.fragment,e),y(ge.$$.fragment,e),y(je.$$.fragment,e),y(ve.$$.fragment,e),y(be.$$.fragment,e),y(Ue.$$.fragment,e),y(Te.$$.fragment,e),y(ke.$$.fragment,e),y(Qe.$$.fragment,e),y(_e.$$.fragment,e),y(Se.$$.fragment,e),y(Be.$$.fragment,e),y(Ie.$$.fragment,e),y(Ve.$$.fragment,e),y(He.$$.fragment,e),Ms=!0)},o(e){d(F.$$.fragment,e),d(P.$$.fragment,e),d(L.$$.fragment,e),d(te.$$.fragment,e),d(se.$$.fragment,e),d(le.$$.fragment,e),d(ne.$$.fragment,e),d(re.$$.fragment,e),d(ie.$$.fragment,e),d(oe.$$.fragment,e),d(he.$$.fragment,e),d(me.$$.fragment,e),d(ue.$$.fragment,e),d(ye.$$.fragment,e),d(de.$$.fragment,e),d(ge.$$.fragment,e),d(je.$$.fragment,e),d(ve.$$.fragment,e),d(be.$$.fragment,e),d(Ue.$$.fragment,e),d(Te.$$.fragment,e),d(ke.$$.fragment,e),d(Qe.$$.fragment,e),d(_e.$$.fragment,e),d(Se.$$.fragment,e),d(Be.$$.fragment,e),d(Ie.$$.fragment,e),d(Ve.$$.fragment,e),d(He.$$.fragment,e),Ms=!1},d(e){e&&(t(gt),t(at),t(jt),t(w),t(vt),t(Y),t(wt),t(b),t(bt),t(K),t(Ut),t(U),t(Jt),t(O),t($t),t(q),t(Ct),t(ee),t(Tt),t(J),t(kt),t(xt),t(ae),t(Qt),t(_t),t($),t(Nt),t(St),t(pe),t(Et),t(Bt),t(C),t(It),t(Zt),t(ce),t(At),t(zt),t(T),t(Rt),t(fe),t(Vt),t(k),t(Dt),t(Ht),t(Me),t(Wt),t(Gt),t(x),t(Xt),t(Ft),t(we),t(Yt),t(Pt),t(Q),t(Kt),t(Je),t(Lt),t($e),t(Ot),t(Ce),t(qt),t(_),t(es),t(ts),t(xe),t(ss),t(as),t(N),t(ls),t(Ne),t(ns),t(rs),t(Ee),t(ps),t(is),t(S),t(os),t(Ze),t(hs),t(Ae),t(cs),t(ze),t(ms),t(Re),t(us),t(fs),t(De),t(ys),t(ds),t(Mt)),t(v),M(F),M(P),M(L),M(te),M(se,e),M(le,e),M(ne),M(re,e),M(ie,e),M(oe),M(he,e),M(me,e),M(ue),M(ye),M(de,e),M(ge,e),M(je),M(ve,e),M(be,e),M(Ue),M(Te),M(ke,e),M(Qe,e),M(_e),M(Se,e),M(Be,e),M(Ie),M(Ve,e),M(He,e)}}}const nl={local:"feature-extraction",sections:[{local:"penultimate-layer-features-preclassifier-features",sections:[{local:"unpooled",sections:[{local:"forwardfeatures",title:"forward_features()"},{local:"create-with-no-classifier-and-pooling",title:"Create with no classifier and pooling"},{local:"remove-it-later",title:"Remove it later"}],title:"Unpooled"},{local:"pooled",sections:[{local:"create-with-no-classifier",title:"Create with no classifier"},{local:"remove-it-later",title:"Remove it later"}],title:"Pooled"}],title:"Penultimate Layer Features (Pre-Classifier Features)"},{local:"multiscale-feature-maps-feature-pyramid",sections:[{local:"create-a-feature-map-extraction-model",title:"Create a feature map extraction model"},{local:"query-the-feature-information",title:"Query the feature information"},{local:"select-specific-feature-levels-or-limit-the-stride",title:"Select specific feature levels or limit the stride"}],title:"Multi-scale Feature Maps (Feature Pyramid)"}],title:"Feature Extraction"};function rl(Ws){return el(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class cl extends tl{constructor(v){super(),sl(this,v,rl,ll,Oa,{})}}export{cl as component};
