import{s as la,o as ta,n as qt}from"../chunks/scheduler.6062bdaf.js";import{S as Ma,i as aa,g as n,s as a,r as J,A as sa,h as i,f as t,c as s,j as ea,u as y,x as T,k as Xt,y as na,a as M,v as c,d as o,t as U,w}from"../chunks/index.4bca734e.js";import{T as Pt}from"../chunks/Tip.b9ac1f03.js";import{C as I}from"../chunks/CodeBlock.fa01571c.js";import{H as j}from"../chunks/Heading.723dceba.js";function ia(f){let h,m=`<a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a> is the recommended way to store assets but is not mandatory. If
your library already uses its own cache, feel free to use it!`;return{c(){h=n("p"),h.innerHTML=m},l(d){h=i(d,"P",{"data-svelte-h":!0}),T(h)!=="svelte-s4fmvr"&&(h.innerHTML=m)},m(d,p){M(d,h,p)},p:qt,d(d){d&&t(h)}}}function Ta(f){let h,m=`Revision hashes are unique across all repositories. This means you don’t need to
provide any <code>repo_id</code> or <code>repo_type</code> when removing revisions.`;return{c(){h=n("p"),h.innerHTML=m},l(d){h=i(d,"P",{"data-svelte-h":!0}),T(h)!=="svelte-pge9b4"&&(h.innerHTML=m)},m(d,p){M(d,h,p)},p:qt,d(d){d&&t(h)}}}function Ja(f){let h,m=`If a revision is not found in the cache, it will be silently ignored. Besides, if a file
or folder cannot be found while trying to delete it, a warning will be logged but no
error is thrown. The deletion continues for other paths contained in the
<a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object.`;return{c(){h=n("p"),h.innerHTML=m},l(d){h=i(d,"P",{"data-svelte-h":!0}),T(h)!=="svelte-1s7ftpt"&&(h.innerHTML=m)},m(d,p){M(d,h,p)},p:qt,d(d){d&&t(h)}}}function ya(f){let h,m,d,p,A,Jl,g,yl,Z,Kt=`The Hugging Face Hub cache-system is designed to be the central cache shared across libraries
that depend on the Hub. It has been updated in v0.8.0 to prevent re-downloading same files
between revisions.`,cl,Y,eM="The caching system is designed as follows:",ol,N,Ul,k,lM="The <code>&lt;CACHE_DIR&gt;</code> is usually your user’s home directory. However, it is customizable with the <code>cache_dir</code> argument on all methods, or by specifying either <code>HF_HOME</code> or <code>HF_HUB_CACHE</code> environment variable.",wl,G,tM=`Models, datasets and spaces share a common root. Each of these repositories contains the
repository type, the namespace (organization or username) if it exists and the
repository name:`,hl,S,dl,W,MM=`It is within these folders that all files will now be downloaded from the Hub. Caching ensures that
a file isn’t downloaded twice if it already exists and wasn’t updated; but if it was updated,
and you’re asking for the latest file, then it will download the latest file (while keeping
the previous file intact in case you need it again).`,jl,v,aM="In order to achieve this, all folders contain the same skeleton:",Il,L,ml,$,sM="Each folder is designed to contain the following:",pl,R,fl,B,nM=`The <code>refs</code> folder contains files which indicates the latest revision of the given reference. For example,
if we have previously fetched a file from the <code>main</code> branch of a repository, the <code>refs</code>
folder will contain a file named <code>main</code>, which will itself contain the commit identifier of the current head.`,rl,x,iM="If the latest commit of <code>main</code> has <code>aaaaaa</code> as identifier, then it will contain <code>aaaaaa</code>.",Cl,F,TM=`If that same branch gets updated with a new commit, that has <code>bbbbbb</code> as an identifier, then
re-downloading a file from that reference will update the <code>refs/main</code> file to contain <code>bbbbbb</code>.`,ul,D,bl,E,JM="The <code>blobs</code> folder contains the actual files that we have downloaded. The name of each file is their hash.",Al,V,gl,Q,yM=`The <code>snapshots</code> folder contains symlinks to the blobs mentioned above. It is itself made up of several folders:
one per known revision!`,Zl,_,cM=`In the explanation above, we had initially fetched a file from the <code>aaaaaa</code> revision, before fetching a file from
the <code>bbbbbb</code> revision. In this situation, we would now have two folders in the <code>snapshots</code> folder: <code>aaaaaa</code>
and <code>bbbbbb</code>.`,Yl,O,oM=`In each of these folders, live symlinks that have the names of the files that we have downloaded. For example,
if we had downloaded the <code>README.md</code> file at revision <code>aaaaaa</code>, we would have the following path:`,Nl,z,kl,H,UM="That <code>README.md</code> file is actually a symlink linking to the blob that has the hash of the file.",Gl,X,wM=`By creating the skeleton this way we open the mechanism to file sharing: if the same file was fetched in
revision <code>bbbbbb</code>, it would have the same hash and the file would not need to be re-downloaded.`,Sl,P,Wl,q,hM=`In addition to the <code>blobs</code>, <code>refs</code> and <code>snapshots</code> folders, you might also find a <code>.no_exist</code> folder
in your cache. This folder keeps track of files that you’ve tried to download once but don’t exist
on the Hub. Its structure is the same as the <code>snapshots</code> folder with 1 subfolder per known revision:`,vl,K,Ll,ee,dM=`Unlike the <code>snapshots</code> folder, files are simple empty files (no symlinks). In this example,
the file <code>&quot;config_that_does_not_exist.json&quot;</code> does not exist on the Hub for the revision <code>&quot;aaaaaa&quot;</code>.
As it only stores empty files, this folder is neglectable is term of disk usage.`,$l,le,jM=`So now you might wonder, why is this information even relevant?
In some cases, a framework tries to load optional files for a model. Saving the non-existence
of optional files makes it faster to load a model as it saves 1 HTTP call per possible optional file.
This is for example the case in <code>transformers</code> where each tokenizer can support additional files.
The first time you load the tokenizer on your machine, it will cache which optional files exists (and
which doesn’t) to make the loading time faster for the next initializations.`,Rl,te,IM=`To test if a file is cached locally (without making any HTTP request), you can use the <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.try_to_load_from_cache">try_to_load_from_cache()</a>
helper. It will either return the filepath (if exists and cached), the object <code>_CACHED_NO_EXIST</code> (if non-existence
is cached) or <code>None</code> (if we don’t know).`,Bl,Me,xl,ae,Fl,se,mM="In practice, your cache should look like the following tree:",Dl,ne,El,ie,Vl,Te,pM=`In order to have an efficient cache-system, <code>huggingface-hub</code> uses symlinks. However,
symlinks are not supported on all machines. This is a known limitation especially on
Windows. When this is the case, <code>huggingface_hub</code> do not use the <code>blobs/</code> directory but
directly stores the files in the <code>snapshots/</code> directory instead. This workaround allows
users to download and cache files from the Hub exactly the same way. Tools to inspect
and delete the cache (see below) are also supported. However, the cache-system is less
efficient as a single file might be downloaded several times if multiple revisions of
the same repo is downloaded.`,Ql,Je,fM=`If you want to benefit from the symlink-based cache-system on a Windows machine, you
either need to <a href="https://docs.microsoft.com/en-us/windows/apps/get-started/enable-your-device-for-development" rel="nofollow">activate Developer Mode</a>
or to run Python as an administrator.`,_l,ye,rM=`When symlinks are not supported, a warning message is displayed to the user to alert
them they are using a degraded version of the cache-system. This warning can be disabled
by setting the <code>HF_HUB_DISABLE_SYMLINKS_WARNING</code> environment variable to true.`,Ol,ce,zl,oe,CM=`In addition to caching files from the Hub, downstream libraries often requires to cache
other files related to HF but not handled directly by <code>huggingface_hub</code> (example: file
downloaded from GitHub, preprocessed data, logs,…). In order to cache those files,
called <code>assets</code>, one can use <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.cached_assets_path">cached_assets_path()</a>. This small helper generates paths
in the HF cache in a unified way based on the name of the library requesting it and
optionally on a namespace and a subfolder name. The goal is to let every downstream
libraries manage its assets its own way (e.g. no rule on the structure) as long as it
stays in the right assets folder. Those libraries can then leverage tools from
<code>huggingface_hub</code> to manage the cache, in particular scanning and deleting parts of the
assets from a CLI command.`,Hl,Ue,Xl,r,Pl,we,ql,he,uM="In practice, your assets cache should look like the following tree:",Kl,de,et,je,lt,Ie,bM=`At the moment, cached files are never deleted from your local directory: when you download
a new revision of a branch, previous files are kept in case you need them again.
Therefore it can be useful to scan your cache directory in order to know which repos
and revisions are taking the most disk space. <code>huggingface_hub</code> provides an helper to
do so that can be used via <code>huggingface-cli</code> or in a python script.`,tt,me,Mt,pe,AM=`The easiest way to scan your HF cache-system is to use the <code>scan-cache</code> command from
<code>huggingface-cli</code> tool. This command scans the cache and prints a report with information
like repo id, repo type, disk usage, refs and full local path.`,at,fe,gM=`The snippet below shows a scan report in a folder in which 4 models and 2 datasets are
cached.`,st,re,nt,Ce,ZM=`To get a more detailed report, use the <code>--verbose</code> option. For each repo, you get a
list of all revisions that have been downloaded. As explained above, the files that don’t
change between 2 revisions are shared thanks to the symlinks. This means that the size of
the repo on disk is expected to be less than the sum of the size of each of its revisions.
For example, here <code>bert-base-cased</code> has 2 revisions of 1.4G and 1.5G but the total disk
usage is only 1.9G.`,it,ue,Tt,be,Jt,Ae,YM=`Since the output is in tabular format, you can combine it with any <code>grep</code>-like tools to
filter the entries. Here is an example to filter only revisions from the “t5-small”
model on a Unix-based machine.`,yt,ge,ct,Ze,ot,Ye,NM=`For a more advanced usage, use <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a> which is the python utility called by
the CLI tool.`,Ut,Ne,kM="You can use it to get a detailed report structured around 4 dataclasses:",wt,ke,GM='<li><a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a>: complete report returned by <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.scan_cache_dir">scan_cache_dir()</a></li> <li><a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.CachedRepoInfo">CachedRepoInfo</a>: information about a cached repo</li> <li><a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.CachedRevisionInfo">CachedRevisionInfo</a>: information about a cached revision (e.g. “snapshot”) inside a repo</li> <li><a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.CachedFileInfo">CachedFileInfo</a>: information about a cached file in a snapshot</li>',ht,Ge,SM="Here is a simple usage example. See reference for details.",dt,Se,jt,We,It,ve,WM=`Scanning your cache is interesting but what you really want to do next is usually to
delete some portions to free up some space on your drive. This is possible using the
<code>delete-cache</code> CLI command. One can also programmatically use the
<a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> helper from <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.HFCacheInfo">HFCacheInfo</a> object returned when
scanning the cache.`,mt,Le,pt,$e,vM=`To delete some cache, you need to pass a list of revisions to delete. The tool will
define a strategy to free up the space based on this list. It returns a
<a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> object that describes which files and folders will be deleted.
The <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.DeleteCacheStrategy">DeleteCacheStrategy</a> allows give you how much space is expected to be freed.
Once you agree with the deletion, you must execute it to make the deletion effective. In
order to avoid discrepancies, you cannot edit a strategy object manually.`,ft,Re,LM="The strategy to delete revisions is the following:",rt,Be,$M="<li>the <code>snapshot</code> folder containing the revision symlinks is deleted.</li> <li>blobs files that are targeted only by revisions to be deleted are deleted as well.</li> <li>if a revision is linked to 1 or more <code>refs</code>, references are deleted.</li> <li>if all revisions from a repo are deleted, the entire cached repository is deleted.</li>",Ct,C,ut,u,bt,xe,At,Fe,RM=`The easiest way to delete some revisions from your HF cache-system is to use the
<code>delete-cache</code> command from <code>huggingface-cli</code> tool. The command has two modes. By
default, a TUI (Terminal User Interface) is displayed to the user to select which
revisions to delete. This TUI is currently in beta as it has not been tested on all
platforms. If the TUI doesn’t work on your machine, you can disable it using the
<code>--disable-tui</code> flag.`,gt,De,Zt,Ee,BM=`This is the default mode. To use it, you first need to install extra dependencies by
running the following command:`,Yt,Ve,Nt,Qe,xM="Then run the command:",kt,_e,Gt,Oe,FM="You should now see a list of revisions that you can select/deselect:",St,b,DM='<img src="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/hub/delete-cache-tui.png"/>',Wt,ze,EM="Instructions:",vt,He,VM=`<li>Press keyboard arrow keys <code>&lt;up&gt;</code> and <code>&lt;down&gt;</code> to move the cursor.</li> <li>Press <code>&lt;space&gt;</code> to toggle (select/unselect) an item.</li> <li>When a revision is selected, the first line is updated to show you how much space
will be freed.</li> <li>Press <code>&lt;enter&gt;</code> to confirm your selection.</li> <li>If you want to cancel the operation and quit, you can select the first item
(“None of the following”). If this item is selected, the delete process will be
cancelled, no matter what other items are selected. Otherwise you can also press
<code>&lt;ctrl+c&gt;</code> to quit the TUI.</li>`,Lt,Xe,QM=`Once you’ve selected the revisions you want to delete and pressed <code>&lt;enter&gt;</code>, a last
confirmation message will be prompted. Press <code>&lt;enter&gt;</code> again and the deletion will be
effective. If you want to cancel, enter <code>n</code>.`,$t,Pe,Rt,qe,Bt,Ke,_M=`As mentioned above, the TUI mode is currently in beta and is optional. It may be the
case that it doesn’t work on your machine or that you don’t find it convenient.`,xt,el,OM=`Another approach is to use the <code>--disable-tui</code> flag. The process is very similar as you
will be asked to manually review the list of revisions to delete. However, this manual
step will not take place in the terminal directly but in a temporary file generated on
the fly and that you can manually edit.`,Ft,ll,zM=`This file has all the instructions you need in the header. Open it in your favorite text
editor. To select/deselect a revision, simply comment/uncomment it with a <code>#</code>. Once the
manual review is done and the file is edited, you can save it. Go back to your terminal
and press <code>&lt;enter&gt;</code>. By default it will compute how much space would be freed with the
updated list of revisions. You can continue to edit the file or confirm with <code>&quot;y&quot;</code>.`,Dt,tl,Et,Ml,HM="Example of command file:",Vt,al,Qt,sl,_t,nl,XM=`For more flexibility, you can also use the <a href="/docs/huggingface_hub/v0.20.2/en/package_reference/cache#huggingface_hub.HFCacheInfo.delete_revisions">delete_revisions()</a> method
programmatically. Here is a simple example. See reference for details.`,Ot,il,zt,Tl,Ht;return A=new j({props:{title:"Manage huggingface_hub cache-system",local:"manage-huggingfacehub-cache-system",headingTag:"h1"}}),g=new j({props:{title:"Understand caching",local:"understand-caching",headingTag:"h2"}}),N=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDTU9ERUxTJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwJTNDREFUQVNFVFMlM0UlMEElRTIlOTQlOUMlRTIlOTQlODAlMjAlM0NTUEFDRVMlM0U=",highlighted:`<span class="hljs-tag">&lt;<span class="hljs-name">CACHE_DIR</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">MODELS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">DATASETS</span>&gt;</span>
├─ <span class="hljs-tag">&lt;<span class="hljs-name">SPACES</span>&gt;</span>`,wrap:!1}}),S=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwbW9kZWxzLS1qdWxpZW4tYy0tRXNwZXJCRVJUby1zbWFsbCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tbHlzYW5kcmVqaWstLWFyeGl2LW5scCUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMG1vZGVscy0tYmVydC1iYXNlLWNhc2VkJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlOUMlRTIlOTQlODAlMjBkYXRhc2V0cy0taHVnZ2luZ2ZhY2UtLURhdGFNZWFzdXJlbWVudHNGaWxlcyUwQSVFMiU5NCU5QyVFMiU5NCU4MCUyMHNwYWNlcy0tZGFsbGUtbWluaS0tZGFsbGUtbWluaQ==",highlighted:`&lt;<span class="hljs-comment">CACHE_DIR</span>&gt;
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">julien</span><span class="hljs-literal">-</span><span class="hljs-comment">c</span><span class="hljs-literal">--</span><span class="hljs-comment">EsperBERTo</span><span class="hljs-literal">-</span><span class="hljs-comment">small</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">lysandrejik</span><span class="hljs-literal">--</span><span class="hljs-comment">arxiv</span><span class="hljs-literal">-</span><span class="hljs-comment">nlp</span>
<span class="hljs-comment">├─ models</span><span class="hljs-literal">--</span><span class="hljs-comment">bert</span><span class="hljs-literal">-</span><span class="hljs-comment">base</span><span class="hljs-literal">-</span><span class="hljs-comment">cased</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">glue</span>
<span class="hljs-comment">├─ datasets</span><span class="hljs-literal">--</span><span class="hljs-comment">huggingface</span><span class="hljs-literal">--</span><span class="hljs-comment">DataMeasurementsFiles</span>
<span class="hljs-comment">├─ spaces</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span><span class="hljs-literal">--</span><span class="hljs-comment">dalle</span><span class="hljs-literal">-</span><span class="hljs-comment">mini</span>`,wrap:!1}}),L=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTBBJUUyJTk0JTlDJUUyJTk0JTgwJTIwZGF0YXNldHMtLWdsdWUlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjByZWZzJTBBJUUyJTk0JTgyJTIwJTIwJUUyJTk0JTlDJUUyJTk0JTgwJTIwYmxvYnMlMEElRTIlOTQlODIlMjAlMjAlRTIlOTQlOUMlRTIlOTQlODAlMjBzbmFwc2hvdHMlMEEuLi4=",highlighted:`&lt;CACHE_DIR&gt;
├─ datasets<span class="hljs-params">--glue</span>
│  ├─ refs
│  ├─ blobs
│  ├─ snapshots
<span class="hljs-string">...</span>`,wrap:!1}}),R=new j({props:{title:"Refs",local:"refs",headingTag:"h3"}}),D=new j({props:{title:"Blobs",local:"blobs",headingTag:"h3"}}),V=new j({props:{title:"Snapshots",local:"snapshots",headingTag:"h3"}}),z=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGc25hcHNob3RzJTJGYWFhYWFhJTJGUkVBRE1FLm1k",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>snapshots<span class="hljs-regexp">/aaaaaa/</span>README.md',wrap:!1}}),P=new j({props:{title:".no_exist (advanced)",local:"noexist-advanced",headingTag:"h3"}}),K=new I({props:{code:"JTNDQ0FDSEVfRElSJTNFJTJGJTNDUkVQT19OQU1FJTNFJTJGLm5vX2V4aXN0JTJGYWFhYWFhJTJGY29uZmlnX3RoYXRfZG9lc19ub3RfZXhpc3QuanNvbg==",highlighted:'&lt;CACHE_DIR&gt;<span class="hljs-regexp">/&lt;REPO_NAME&gt;/</span>.no_exist<span class="hljs-regexp">/aaaaaa/</span>config_that_does_not_exist.json',wrap:!1}}),Me=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHRyeV90b19sb2FkX2Zyb21fY2FjaGUlMkMlMjBfQ0FDSEVEX05PX0VYSVNUJTBBJTBBZmlsZXBhdGglMjAlM0QlMjB0cnlfdG9fbG9hZF9mcm9tX2NhY2hlKCklMEFpZiUyMGlzaW5zdGFuY2UoZmlsZXBhdGglMkMlMjBzdHIpJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwZmlsZSUyMGV4aXN0cyUyMGFuZCUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxpZiUyMGZpbGVwYXRoJTIwaXMlMjBfQ0FDSEVEX05PX0VYSVNUJTNBJTBBJTIwJTIwJTIwJTIwJTIzJTIwbm9uLWV4aXN0ZW5jZSUyMG9mJTIwZmlsZSUyMGlzJTIwY2FjaGVkJTBBJTIwJTIwJTIwJTIwLi4uJTBBZWxzZSUzQSUwQSUyMCUyMCUyMCUyMCUyMyUyMGZpbGUlMjBpcyUyMG5vdCUyMGNhY2hlZCUwQSUyMCUyMCUyMCUyMC4uLg==",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> try_to_load_from_cache, _CACHED_NO_EXIST

filepath = try_to_load_from_cache()
<span class="hljs-keyword">if</span> <span class="hljs-built_in">isinstance</span>(filepath, <span class="hljs-built_in">str</span>):
    <span class="hljs-comment"># file exists and is cached</span>
    ...
<span class="hljs-keyword">elif</span> filepath <span class="hljs-keyword">is</span> _CACHED_NO_EXIST:
    <span class="hljs-comment"># non-existence of file is cached</span>
    ...
<span class="hljs-keyword">else</span>:
    <span class="hljs-comment"># file is not cached</span>
    ...`,wrap:!1}}),ae=new j({props:{title:"In practice",local:"in-practice",headingTag:"h3"}}),ne=new I({props:{code:"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",highlighted:`    [  96]  .
    └── [ 160]  models--julien-c--EsperBERTo-small
        ├── [ 160]  blobs
        │   ├── [321M]  403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
        │   ├── [ 398]  7cb18dc9bafbfcf74629a4b760af1b160957a83e
        │   └── [1.4K]  d7edf6bd2a681fb0175f7735299831ee1b22b812
        ├── [  96]  refs
        │   └── [  40]  main
        └── [ 128]  snapshots
            ├── [ 128]  2439f60ef33a0d46d85da5001d52aeda5b00ce9f
            │   ├── [  52]  README.md -&gt; ../../blobs/d7edf6bd2a681fb0175f7735299831ee1b22b812
            │   └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd
            └── [ 128]  bbc77c8132af1cc5cf678da3f1ddf2de43606d48
                ├── [  52]  README.md -&gt; ../../blobs/7cb18dc9bafbfcf74629a4b760af1b160957a83e
                └── [  76]  pytorch_model.bin -&gt; ../../blobs/403450e234d65943a7dcf7e05a771ce3c92faa84dd07db4ac20f592037a1e4bd`,wrap:!1}}),ie=new j({props:{title:"Limitations",local:"limitations",headingTag:"h3"}}),ce=new j({props:{title:"Caching assets",local:"caching-assets",headingTag:"h2"}}),Ue=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMGNhY2hlZF9hc3NldHNfcGF0aCUwQSUwQWFzc2V0c19wYXRoJTIwJTNEJTIwY2FjaGVkX2Fzc2V0c19wYXRoKGxpYnJhcnlfbmFtZSUzRCUyMmRhdGFzZXRzJTIyJTJDJTIwbmFtZXNwYWNlJTNEJTIyU1F1QUQlMjIlMkMlMjBzdWJmb2xkZXIlM0QlMjJkb3dubG9hZCUyMiklMEFzb21ldGhpbmdfcGF0aCUyMCUzRCUyMGFzc2V0c19wYXRoJTIwJTJGJTIwJTIyc29tZXRoaW5nLmpzb24lMjIlMjAlMjMlMjBEbyUyMGFueXRoaW5nJTIweW91JTIwbGlrZSUyMGluJTIweW91ciUyMGFzc2V0cyUyMGZvbGRlciUyMCE=",highlighted:`<span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> cached_assets_path

assets_path = cached_assets_path(library_name=<span class="hljs-string">&quot;datasets&quot;</span>, namespace=<span class="hljs-string">&quot;SQuAD&quot;</span>, subfolder=<span class="hljs-string">&quot;download&quot;</span>)
something_path = assets_path / <span class="hljs-string">&quot;something.json&quot;</span> <span class="hljs-comment"># Do anything you like in your assets folder !</span>`,wrap:!1}}),r=new Pt({props:{$$slots:{default:[ia]},$$scope:{ctx:f}}}),we=new j({props:{title:"Assets in practice",local:"assets-in-practice",headingTag:"h3"}}),de=new I({props:{code:"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",highlighted:`    assets/
    └── datasets/
    │   ├── SQuAD/
    │   │   ├── downloaded/
    │   │   ├── extracted/
    │   │   └── processed/
    │   ├── Helsinki-NLP--tatoeba_mt/
    │       ├── downloaded/
    │       ├── extracted/
    │       └── processed/
    └── transformers/
        ├── default/
        │   ├── something/
        ├── bert-base-cased/
        │   ├── default/
        │   └── training/
    hub/
    └── models--julien-c--EsperBERTo-small/
        ├── blobs/
        │   ├── (...)
        │   ├── (...)
        ├── refs/
        │   └── (...)
        └── [ 128]  snapshots/
            ├── 2439f60ef33a0d46d85da5001d52aeda5b00ce9f/
            │   ├── (...)
            └── bbc77c8132af1cc5cf678da3f1ddf2de43606d48/
                └── (...)`,wrap:!1}}),je=new j({props:{title:"Scan your cache",local:"scan-your-cache",headingTag:"h2"}}),me=new j({props:{title:"Scan cache from the terminal",local:"scan-cache-from-the-terminal",headingTag:"h3"}}),re=new I({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache
REPO ID                     REPO TYPE SIZE ON DISK NB FILES LAST_ACCESSED LAST_MODIFIED REFS                LOCAL PATH
--------------------------- --------- ------------ -------- ------------- ------------- ------------------- -------------------------------------------------------------------------
glue                        dataset         116.3K       15 4 days ago    4 days ago    2.4.0, main, 1.17.0 /home/wauplin/.cache/huggingface/hub/datasets--glue
google/fleurs               dataset          64.9M        6 1 week ago    1 week ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs
Jean-Baptiste/camembert-ner model           441.0M        7 2 weeks ago   16 hours ago  main                /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner
bert-base-cased             model             1.9G       13 1 week ago    2 years ago                       /home/wauplin/.cache/huggingface/hub/models--bert-base-cased
t5-base                     model            10.1K        3 3 months ago  3 months ago  main                /home/wauplin/.cache/huggingface/hub/models--t5-base
t5-small                    model           970.7M       11 3 days ago    3 days ago    refs/pr/1, main     /home/wauplin/.cache/huggingface/hub/models--t5-small

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),ue=new I({props:{code:"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",highlighted:`➜ huggingface-cli scan-cache -v
REPO ID                     REPO TYPE REVISION                                 SIZE ON DISK NB FILES LAST_MODIFIED REFS        LOCAL PATH
--------------------------- --------- ---------------------------------------- ------------ -------- ------------- ----------- ----------------------------------------------------------------------------------------------------------------------------
glue                        dataset   9338f7b671827df886678df2bdd7cc7b4f36dffd        97.7K       14 4 days ago    main, 2.4.0 /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/9338f7b671827df886678df2bdd7cc7b4f36dffd
glue                        dataset   f021ae41c879fcabcf823648ec685e3fead91fe7        97.8K       14 1 week ago    1.17.0      /home/wauplin/.cache/huggingface/hub/datasets--glue/snapshots/f021ae41c879fcabcf823648ec685e3fead91fe7
google/fleurs               dataset   129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8        25.4K        3 2 weeks ago   refs/pr/1   /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/129b6e96cf1967cd5d2b9b6aec75ce6cce7c89e8
google/fleurs               dataset   24f85a01eb955224ca3946e70050869c56446805        64.9M        4 1 week ago    main        /home/wauplin/.cache/huggingface/hub/datasets--google--fleurs/snapshots/24f85a01eb955224ca3946e70050869c56446805
Jean-Baptiste/camembert-ner model     dbec8489a1c44ecad9da8a9185115bccabd799fe       441.0M        7 16 hours ago  main        /home/wauplin/.cache/huggingface/hub/models--Jean-Baptiste--camembert-ner/snapshots/dbec8489a1c44ecad9da8a9185115bccabd799fe
bert-base-cased             model     378aa1bda6387fd00e824948ebe3488630ad8565         1.5G        9 2 years ago               /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/378aa1bda6387fd00e824948ebe3488630ad8565
bert-base-cased             model     a8d257ba9925ef39f3036bfc338acf5283c512d9         1.4G        9 3 days ago    main        /home/wauplin/.cache/huggingface/hub/models--bert-base-cased/snapshots/a8d257ba9925ef39f3036bfc338acf5283c512d9
t5-base                     model     23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9        10.1K        3 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-base/snapshots/23aa4f41cb7c08d4b05c8f327b22bfa0eb8c7ad9
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5

Done in 0.0s. Scanned 6 repo(s) for a total of 3.4G.
Got 1 warning(s) while scanning. Use -vvv to print details.`,wrap:!1}}),be=new j({props:{title:"Grep example",local:"grep-example",headingTag:"h4"}}),ge=new I({props:{code:"JUUyJTlFJTlDJTIwZXZhbCUyMCUyMmh1Z2dpbmdmYWNlLWNsaSUyMHNjYW4tY2FjaGUlMjAtdiUyMiUyMCU3QyUyMGdyZXAlMjAlMjJ0NS1zbWFsbCUyMiUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjA5OGZmZWJiYjI3MzQwZWMxYjFhYmQ3YzQ1ZGExMmMyNTNlZTE4ODJhJTIwJTIwJTIwJTIwJTIwJTIwJTIwNzI2LjJNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwcmVmcyUyRnByJTJGMSUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGOThmZmViYmIyNzM0MGVjMWIxYWJkN2M0NWRhMTJjMjUzZWUxODgyYSUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkMGExMTllZWRiMzcxOGUzNGM2NDhlNTk0Mzk0NDc0Y2Y5NWUwNjE3JTIwJTIwJTIwJTIwJTIwJTIwJTIwNDg1LjhNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwNiUyMDQlMjB3ZWVrcyUyMGFnbyUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDBhMTE5ZWVkYjM3MThlMzRjNjQ4ZTU5NDM5NDQ3NGNmOTVlMDYxNyUwQXQ1LXNtYWxsJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwbW9kZWwlMjAlMjAlMjAlMjAlMjBkNzhhZWExM2ZhN2VjZDA2YzI5ZTNlNDYxOTVkNjM0MTI1NTA2NWQ1JTIwJTIwJTIwJTIwJTIwJTIwJTIwOTcwLjdNJTIwJTIwJTIwJTIwJTIwJTIwJTIwJTIwOSUyMDElMjB3ZWVrJTIwYWdvJTIwJTIwJTIwJTIwbWFpbiUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyMCUyRmhvbWUlMkZ3YXVwbGluJTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMkZtb2RlbHMtLXQ1LXNtYWxsJTJGc25hcHNob3RzJTJGZDc4YWVhMTNmYTdlY2QwNmMyOWUzZTQ2MTk1ZDYzNDEyNTUwNjVkNQ==",highlighted:`➜ eval &quot;huggingface-cli scan-cache -v&quot; | grep &quot;t5-small&quot;
t5-small                    model     98ffebbb27340ec1b1abd7c45da12c253ee1882a       726.2M        6 1 week ago    refs/pr/1   /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/98ffebbb27340ec1b1abd7c45da12c253ee1882a
t5-small                    model     d0a119eedb3718e34c648e594394474cf95e0617       485.8M        6 4 weeks ago               /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d0a119eedb3718e34c648e594394474cf95e0617
t5-small                    model     d78aea13fa7ecd06c29e3e46195d6341255065d5       970.7M        9 1 week ago    main        /home/wauplin/.cache/huggingface/hub/models--t5-small/snapshots/d78aea13fa7ecd06c29e3e46195d6341255065d5`,wrap:!1}}),Ze=new j({props:{title:"Scan cache from Python",local:"scan-cache-from-python",headingTag:"h3"}}),Se=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBaGZfY2FjaGVfaW5mbyUyMCUzRCUyMHNjYW5fY2FjaGVfZGlyKCk=",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>hf_cache_info = scan_cache_dir()
HFCacheInfo(
    size_on_disk=<span class="hljs-number">3398085269</span>,
    repos=<span class="hljs-built_in">frozenset</span>({
        CachedRepoInfo(
            repo_id=<span class="hljs-string">&#x27;t5-small&#x27;</span>,
            repo_type=<span class="hljs-string">&#x27;model&#x27;</span>,
            repo_path=PosixPath(...),
            size_on_disk=<span class="hljs-number">970726914</span>,
            nb_files=<span class="hljs-number">11</span>,
            last_accessed=<span class="hljs-number">1662971707.3567169</span>,
            last_modified=<span class="hljs-number">1662971107.3567169</span>,
            revisions=<span class="hljs-built_in">frozenset</span>({
                CachedRevisionInfo(
                    commit_hash=<span class="hljs-string">&#x27;d78aea13fa7ecd06c29e3e46195d6341255065d5&#x27;</span>,
                    size_on_disk=<span class="hljs-number">970726339</span>,
                    snapshot_path=PosixPath(...),
                    <span class="hljs-comment"># No \`last_accessed\` as blobs are shared among revisions</span>
                    last_modified=<span class="hljs-number">1662971107.3567169</span>,
                    files=<span class="hljs-built_in">frozenset</span>({
                        CachedFileInfo(
                            file_name=<span class="hljs-string">&#x27;config.json&#x27;</span>,
                            size_on_disk=<span class="hljs-number">1197</span>
                            file_path=PosixPath(...),
                            blob_path=PosixPath(...),
                            blob_last_accessed=<span class="hljs-number">1662971707.3567169</span>,
                            blob_last_modified=<span class="hljs-number">1662971107.3567169</span>,
                        ),
                        CachedFileInfo(...),
                        ...
                    }),
                ),
                CachedRevisionInfo(...),
                ...
            }),
        ),
        CachedRepoInfo(...),
        ...
    }),
    warnings=[
        CorruptedCacheException(<span class="hljs-string">&quot;Snapshots dir doesn&#x27;t exist in cached repo: ...&quot;</span>),
        CorruptedCacheException(...),
        ...
    ],
)`,wrap:!1}}),We=new j({props:{title:"Clean your cache",local:"clean-your-cache",headingTag:"h2"}}),Le=new j({props:{title:"Delete strategy",local:"delete-strategy",headingTag:"h3"}}),C=new Pt({props:{$$slots:{default:[Ta]},$$scope:{ctx:f}}}),u=new Pt({props:{warning:!0,$$slots:{default:[Ja]},$$scope:{ctx:f}}}),xe=new j({props:{title:"Clean cache from the terminal",local:"clean-cache-from-the-terminal",headingTag:"h3"}}),De=new j({props:{title:"Using the TUI",local:"using-the-tui",headingTag:"h4"}}),Ve=new I({props:{code:"cGlwJTIwaW5zdGFsbCUyMGh1Z2dpbmdmYWNlX2h1YiU1QiUyMmNsaSUyMiU1RA==",highlighted:'pip <span class="hljs-keyword">install</span> huggingface_hub[<span class="hljs-string">&quot;cli&quot;</span>]',wrap:!1}}),_e=new I({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hl",highlighted:'huggingface-cli <span class="hljs-keyword">delete</span>-<span class="hljs-keyword">cache</span>',wrap:!1}}),Pe=new I({props:{code:"JUUyJTlDJTk3JTIwaHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXIlMjB+JTJGLmNhY2hlJTJGaHVnZ2luZ2ZhY2UlMkZodWIlMEElM0YlMjBTZWxlY3QlMjByZXZpc2lvbnMlMjB0byUyMGRlbGV0ZSUzQSUyMDIlMjByZXZpc2lvbihzKSUyMHNlbGVjdGVkLiUwQSUzRiUyMDIlMjByZXZpc2lvbnMlMjBzZWxlY3RlZCUyMGNvdW50aW5nJTIwZm9yJTIwMy4xRy4lMjBDb25maXJtJTIwZGVsZXRpb24lMjAlM0YlMjBZZXMlMEFTdGFydCUyMGRlbGV0aW9uLiUwQURvbmUuJTIwRGVsZXRlZCUyMDElMjByZXBvKHMpJTIwYW5kJTIwMCUyMHJldmlzaW9uKHMpJTIwZm9yJTIwYSUyMHRvdGFsJTIwb2YlMjAzLjFHLg==",highlighted:`✗ huggingface-cli delete-cache --dir ~/.cache/huggingface/hub
? Select revisions to delete: 2 revision(s) selected.
? 2 revisions selected counting for 3.1G. Confirm deletion ? Yes
Start deletion.
Done. Deleted 1 repo(s) and 0 revision(s) for a total of 3.1G.`,wrap:!1}}),qe=new j({props:{title:"Without TUI",local:"without-tui",headingTag:"h4"}}),tl=new I({props:{code:"aHVnZ2luZ2ZhY2UtY2xpJTIwZGVsZXRlLWNhY2hlJTIwLS1kaXNhYmxlLXR1aQ==",highlighted:"huggingface-cli delete-cache --disable-tui",wrap:!1}}),al=new I({props:{code:"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",highlighted:`# INSTRUCTIONS
# ------------
# This is a temporary file created by running \`huggingface-cli delete-cache\` with the
# \`--disable-tui\` option. It contains a set of revisions that can be deleted from your
# local cache directory.
#
# Please manually review the revisions you want to delete:
#   - Revision hashes can be commented out with &#x27;#&#x27;.
#   - Only non-commented revisions in this file will be deleted.
#   - Revision hashes that are removed from this file are ignored as well.
#   - If \`CANCEL_DELETION\` line is uncommented, the all cache deletion is cancelled and
#     no changes will be applied.
#
# Once you&#x27;ve manually reviewed this file, please confirm deletion in the terminal. This
# file will be automatically removed once done.
# ------------

# KILL SWITCH
# ------------
# Un-comment following line to completely cancel the deletion process
# CANCEL_DELETION
# ------------

# REVISIONS
# ------------
# Dataset chrisjay/crowd-speech-africa (761.7M, used 5 days ago)
    ebedcd8c55c90d39fd27126d29d8484566cd27ca # Refs: main # modified 5 days ago

# Dataset oscar (3.3M, used 4 days ago)
#    916f956518279c5e60c63902ebdf3ddf9fa9d629 # Refs: main # modified 4 days ago

# Dataset wikiann (804.1K, used 2 weeks ago)
    89d089624b6323d69dcd9e5eb2def0551887a73a # Refs: main # modified 2 weeks ago

# Dataset z-uo/male-LJSpeech-italian (5.5G, used 5 days ago)
#    9cfa5647b32c0a30d0adfca06bf198d82192a0d1 # Refs: main # modified 5 days ago`,wrap:!1}}),sl=new j({props:{title:"Clean cache from Python",local:"clean-cache-from-python",headingTag:"h3"}}),il=new I({props:{code:"ZnJvbSUyMGh1Z2dpbmdmYWNlX2h1YiUyMGltcG9ydCUyMHNjYW5fY2FjaGVfZGlyJTBBJTBBZGVsZXRlX3N0cmF0ZWd5JTIwJTNEJTIwc2Nhbl9jYWNoZV9kaXIoKS5kZWxldGVfcmV2aXNpb25zKCUwQSUyMCUyMCUyMCUyMCUyMjgxZmQxZDZlNzg0N2M5OWY1ODYyYzlmYjgxMzg3OTU2ZDk5ZWM3YWElMjIlMEElMjAlMjAlMjAlMjAlMjJlMjk4M2IyMzdkY2NmM2FiNDkzN2M5N2ZhNzE3MzE5YTljYTFhOTZkJTIyJTJDJTBBJTIwJTIwJTIwJTIwJTIyNmMwZTYwODA5NTNkYjU2Mzc1NzYwYzA0NzFhOGM1ZjI5MjliYWYxMSUyMiUyQyUwQSklMEFwcmludCglMjJXaWxsJTIwZnJlZSUyMCUyMiUyMCUyQiUyMGRlbGV0ZV9zdHJhdGVneS5leHBlY3RlZF9mcmVlZF9zaXplX3N0ciklMEElMEFkZWxldGVfc3RyYXRlZ3kuZXhlY3V0ZSgp",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> huggingface_hub <span class="hljs-keyword">import</span> scan_cache_dir

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy = scan_cache_dir().delete_revisions(
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;81fd1d6e7847c99f5862c9fb81387956d99ec7aa&quot;</span>
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;e2983b237dccf3ab4937c97fa717319a9ca1a96d&quot;</span>,
<span class="hljs-meta">... </span>    <span class="hljs-string">&quot;6c0e6080953db56375760c0471a8c5f2929baf11&quot;</span>,
<span class="hljs-meta">... </span>)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Will free &quot;</span> + delete_strategy.expected_freed_size_str)
Will free <span class="hljs-number">8.6</span>G

<span class="hljs-meta">&gt;&gt;&gt; </span>delete_strategy.execute()
Cache deletion done. Saved <span class="hljs-number">8.6</span>G.`,wrap:!1}}),{c(){h=n("meta"),m=a(),d=n("p"),p=a(),J(A.$$.fragment),Jl=a(),J(g.$$.fragment),yl=a(),Z=n("p"),Z.textContent=Kt,cl=a(),Y=n("p"),Y.textContent=eM,ol=a(),J(N.$$.fragment),Ul=a(),k=n("p"),k.innerHTML=lM,wl=a(),G=n("p"),G.textContent=tM,hl=a(),J(S.$$.fragment),dl=a(),W=n("p"),W.textContent=MM,jl=a(),v=n("p"),v.textContent=aM,Il=a(),J(L.$$.fragment),ml=a(),$=n("p"),$.textContent=sM,pl=a(),J(R.$$.fragment),fl=a(),B=n("p"),B.innerHTML=nM,rl=a(),x=n("p"),x.innerHTML=iM,Cl=a(),F=n("p"),F.innerHTML=TM,ul=a(),J(D.$$.fragment),bl=a(),E=n("p"),E.innerHTML=JM,Al=a(),J(V.$$.fragment),gl=a(),Q=n("p"),Q.innerHTML=yM,Zl=a(),_=n("p"),_.innerHTML=cM,Yl=a(),O=n("p"),O.innerHTML=oM,Nl=a(),J(z.$$.fragment),kl=a(),H=n("p"),H.innerHTML=UM,Gl=a(),X=n("p"),X.innerHTML=wM,Sl=a(),J(P.$$.fragment),Wl=a(),q=n("p"),q.innerHTML=hM,vl=a(),J(K.$$.fragment),Ll=a(),ee=n("p"),ee.innerHTML=dM,$l=a(),le=n("p"),le.innerHTML=jM,Rl=a(),te=n("p"),te.innerHTML=IM,Bl=a(),J(Me.$$.fragment),xl=a(),J(ae.$$.fragment),Fl=a(),se=n("p"),se.textContent=mM,Dl=a(),J(ne.$$.fragment),El=a(),J(ie.$$.fragment),Vl=a(),Te=n("p"),Te.innerHTML=pM,Ql=a(),Je=n("p"),Je.innerHTML=fM,_l=a(),ye=n("p"),ye.innerHTML=rM,Ol=a(),J(ce.$$.fragment),zl=a(),oe=n("p"),oe.innerHTML=CM,Hl=a(),J(Ue.$$.fragment),Xl=a(),J(r.$$.fragment),Pl=a(),J(we.$$.fragment),ql=a(),he=n("p"),he.textContent=uM,Kl=a(),J(de.$$.fragment),et=a(),J(je.$$.fragment),lt=a(),Ie=n("p"),Ie.innerHTML=bM,tt=a(),J(me.$$.fragment),Mt=a(),pe=n("p"),pe.innerHTML=AM,at=a(),fe=n("p"),fe.textContent=gM,st=a(),J(re.$$.fragment),nt=a(),Ce=n("p"),Ce.innerHTML=ZM,it=a(),J(ue.$$.fragment),Tt=a(),J(be.$$.fragment),Jt=a(),Ae=n("p"),Ae.innerHTML=YM,yt=a(),J(ge.$$.fragment),ct=a(),J(Ze.$$.fragment),ot=a(),Ye=n("p"),Ye.innerHTML=NM,Ut=a(),Ne=n("p"),Ne.textContent=kM,wt=a(),ke=n("ul"),ke.innerHTML=GM,ht=a(),Ge=n("p"),Ge.textContent=SM,dt=a(),J(Se.$$.fragment),jt=a(),J(We.$$.fragment),It=a(),ve=n("p"),ve.innerHTML=WM,mt=a(),J(Le.$$.fragment),pt=a(),$e=n("p"),$e.innerHTML=vM,ft=a(),Re=n("p"),Re.textContent=LM,rt=a(),Be=n("ul"),Be.innerHTML=$M,Ct=a(),J(C.$$.fragment),ut=a(),J(u.$$.fragment),bt=a(),J(xe.$$.fragment),At=a(),Fe=n("p"),Fe.innerHTML=RM,gt=a(),J(De.$$.fragment),Zt=a(),Ee=n("p"),Ee.textContent=BM,Yt=a(),J(Ve.$$.fragment),Nt=a(),Qe=n("p"),Qe.textContent=xM,kt=a(),J(_e.$$.fragment),Gt=a(),Oe=n("p"),Oe.textContent=FM,St=a(),b=n("div"),b.innerHTML=DM,Wt=a(),ze=n("p"),ze.textContent=EM,vt=a(),He=n("ul"),He.innerHTML=VM,Lt=a(),Xe=n("p"),Xe.innerHTML=QM,$t=a(),J(Pe.$$.fragment),Rt=a(),J(qe.$$.fragment),Bt=a(),Ke=n("p"),Ke.textContent=_M,xt=a(),el=n("p"),el.innerHTML=OM,Ft=a(),ll=n("p"),ll.innerHTML=zM,Dt=a(),J(tl.$$.fragment),Et=a(),Ml=n("p"),Ml.textContent=HM,Vt=a(),J(al.$$.fragment),Qt=a(),J(sl.$$.fragment),_t=a(),nl=n("p"),nl.innerHTML=XM,Ot=a(),J(il.$$.fragment),zt=a(),Tl=n("p"),this.h()},l(e){const l=sa("svelte-u9bgzb",document.head);h=i(l,"META",{name:!0,content:!0}),l.forEach(t),m=s(e),d=i(e,"P",{}),ea(d).forEach(t),p=s(e),y(A.$$.fragment,e),Jl=s(e),y(g.$$.fragment,e),yl=s(e),Z=i(e,"P",{"data-svelte-h":!0}),T(Z)!=="svelte-7434pt"&&(Z.textContent=Kt),cl=s(e),Y=i(e,"P",{"data-svelte-h":!0}),T(Y)!=="svelte-bm5pxs"&&(Y.textContent=eM),ol=s(e),y(N.$$.fragment,e),Ul=s(e),k=i(e,"P",{"data-svelte-h":!0}),T(k)!=="svelte-1bjsk1l"&&(k.innerHTML=lM),wl=s(e),G=i(e,"P",{"data-svelte-h":!0}),T(G)!=="svelte-1xsylbb"&&(G.textContent=tM),hl=s(e),y(S.$$.fragment,e),dl=s(e),W=i(e,"P",{"data-svelte-h":!0}),T(W)!=="svelte-smirw4"&&(W.textContent=MM),jl=s(e),v=i(e,"P",{"data-svelte-h":!0}),T(v)!=="svelte-hxzvg9"&&(v.textContent=aM),Il=s(e),y(L.$$.fragment,e),ml=s(e),$=i(e,"P",{"data-svelte-h":!0}),T($)!=="svelte-1o80jr1"&&($.textContent=sM),pl=s(e),y(R.$$.fragment,e),fl=s(e),B=i(e,"P",{"data-svelte-h":!0}),T(B)!=="svelte-z6cr2z"&&(B.innerHTML=nM),rl=s(e),x=i(e,"P",{"data-svelte-h":!0}),T(x)!=="svelte-15cx8ge"&&(x.innerHTML=iM),Cl=s(e),F=i(e,"P",{"data-svelte-h":!0}),T(F)!=="svelte-1u7b6sn"&&(F.innerHTML=TM),ul=s(e),y(D.$$.fragment,e),bl=s(e),E=i(e,"P",{"data-svelte-h":!0}),T(E)!=="svelte-9jec47"&&(E.innerHTML=JM),Al=s(e),y(V.$$.fragment,e),gl=s(e),Q=i(e,"P",{"data-svelte-h":!0}),T(Q)!=="svelte-1mswky"&&(Q.innerHTML=yM),Zl=s(e),_=i(e,"P",{"data-svelte-h":!0}),T(_)!=="svelte-1f9g1u2"&&(_.innerHTML=cM),Yl=s(e),O=i(e,"P",{"data-svelte-h":!0}),T(O)!=="svelte-1ezxfdw"&&(O.innerHTML=oM),Nl=s(e),y(z.$$.fragment,e),kl=s(e),H=i(e,"P",{"data-svelte-h":!0}),T(H)!=="svelte-7nae39"&&(H.innerHTML=UM),Gl=s(e),X=i(e,"P",{"data-svelte-h":!0}),T(X)!=="svelte-sjd8l1"&&(X.innerHTML=wM),Sl=s(e),y(P.$$.fragment,e),Wl=s(e),q=i(e,"P",{"data-svelte-h":!0}),T(q)!=="svelte-dxew1x"&&(q.innerHTML=hM),vl=s(e),y(K.$$.fragment,e),Ll=s(e),ee=i(e,"P",{"data-svelte-h":!0}),T(ee)!=="svelte-1m1e4x3"&&(ee.innerHTML=dM),$l=s(e),le=i(e,"P",{"data-svelte-h":!0}),T(le)!=="svelte-1jb25aj"&&(le.innerHTML=jM),Rl=s(e),te=i(e,"P",{"data-svelte-h":!0}),T(te)!=="svelte-52uly8"&&(te.innerHTML=IM),Bl=s(e),y(Me.$$.fragment,e),xl=s(e),y(ae.$$.fragment,e),Fl=s(e),se=i(e,"P",{"data-svelte-h":!0}),T(se)!=="svelte-1cw24ss"&&(se.textContent=mM),Dl=s(e),y(ne.$$.fragment,e),El=s(e),y(ie.$$.fragment,e),Vl=s(e),Te=i(e,"P",{"data-svelte-h":!0}),T(Te)!=="svelte-1foktgq"&&(Te.innerHTML=pM),Ql=s(e),Je=i(e,"P",{"data-svelte-h":!0}),T(Je)!=="svelte-x8ev9q"&&(Je.innerHTML=fM),_l=s(e),ye=i(e,"P",{"data-svelte-h":!0}),T(ye)!=="svelte-1ue61z6"&&(ye.innerHTML=rM),Ol=s(e),y(ce.$$.fragment,e),zl=s(e),oe=i(e,"P",{"data-svelte-h":!0}),T(oe)!=="svelte-1xnlbyo"&&(oe.innerHTML=CM),Hl=s(e),y(Ue.$$.fragment,e),Xl=s(e),y(r.$$.fragment,e),Pl=s(e),y(we.$$.fragment,e),ql=s(e),he=i(e,"P",{"data-svelte-h":!0}),T(he)!=="svelte-1lsljsl"&&(he.textContent=uM),Kl=s(e),y(de.$$.fragment,e),et=s(e),y(je.$$.fragment,e),lt=s(e),Ie=i(e,"P",{"data-svelte-h":!0}),T(Ie)!=="svelte-1ppewq"&&(Ie.innerHTML=bM),tt=s(e),y(me.$$.fragment,e),Mt=s(e),pe=i(e,"P",{"data-svelte-h":!0}),T(pe)!=="svelte-18l68mc"&&(pe.innerHTML=AM),at=s(e),fe=i(e,"P",{"data-svelte-h":!0}),T(fe)!=="svelte-1ss2857"&&(fe.textContent=gM),st=s(e),y(re.$$.fragment,e),nt=s(e),Ce=i(e,"P",{"data-svelte-h":!0}),T(Ce)!=="svelte-2cqqt0"&&(Ce.innerHTML=ZM),it=s(e),y(ue.$$.fragment,e),Tt=s(e),y(be.$$.fragment,e),Jt=s(e),Ae=i(e,"P",{"data-svelte-h":!0}),T(Ae)!=="svelte-1h7dpll"&&(Ae.innerHTML=YM),yt=s(e),y(ge.$$.fragment,e),ct=s(e),y(Ze.$$.fragment,e),ot=s(e),Ye=i(e,"P",{"data-svelte-h":!0}),T(Ye)!=="svelte-wytgr1"&&(Ye.innerHTML=NM),Ut=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),T(Ne)!=="svelte-83019z"&&(Ne.textContent=kM),wt=s(e),ke=i(e,"UL",{"data-svelte-h":!0}),T(ke)!=="svelte-n7wres"&&(ke.innerHTML=GM),ht=s(e),Ge=i(e,"P",{"data-svelte-h":!0}),T(Ge)!=="svelte-xp69b3"&&(Ge.textContent=SM),dt=s(e),y(Se.$$.fragment,e),jt=s(e),y(We.$$.fragment,e),It=s(e),ve=i(e,"P",{"data-svelte-h":!0}),T(ve)!=="svelte-ophnqn"&&(ve.innerHTML=WM),mt=s(e),y(Le.$$.fragment,e),pt=s(e),$e=i(e,"P",{"data-svelte-h":!0}),T($e)!=="svelte-1igauyx"&&($e.innerHTML=vM),ft=s(e),Re=i(e,"P",{"data-svelte-h":!0}),T(Re)!=="svelte-19y0r7c"&&(Re.textContent=LM),rt=s(e),Be=i(e,"UL",{"data-svelte-h":!0}),T(Be)!=="svelte-o7nsmh"&&(Be.innerHTML=$M),Ct=s(e),y(C.$$.fragment,e),ut=s(e),y(u.$$.fragment,e),bt=s(e),y(xe.$$.fragment,e),At=s(e),Fe=i(e,"P",{"data-svelte-h":!0}),T(Fe)!=="svelte-1arrz5p"&&(Fe.innerHTML=RM),gt=s(e),y(De.$$.fragment,e),Zt=s(e),Ee=i(e,"P",{"data-svelte-h":!0}),T(Ee)!=="svelte-yr0mit"&&(Ee.textContent=BM),Yt=s(e),y(Ve.$$.fragment,e),Nt=s(e),Qe=i(e,"P",{"data-svelte-h":!0}),T(Qe)!=="svelte-gq4pgy"&&(Qe.textContent=xM),kt=s(e),y(_e.$$.fragment,e),Gt=s(e),Oe=i(e,"P",{"data-svelte-h":!0}),T(Oe)!=="svelte-20gxv"&&(Oe.textContent=FM),St=s(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),T(b)!=="svelte-17iq48i"&&(b.innerHTML=DM),Wt=s(e),ze=i(e,"P",{"data-svelte-h":!0}),T(ze)!=="svelte-7awvfp"&&(ze.textContent=EM),vt=s(e),He=i(e,"UL",{"data-svelte-h":!0}),T(He)!=="svelte-76obk"&&(He.innerHTML=VM),Lt=s(e),Xe=i(e,"P",{"data-svelte-h":!0}),T(Xe)!=="svelte-aoo47g"&&(Xe.innerHTML=QM),$t=s(e),y(Pe.$$.fragment,e),Rt=s(e),y(qe.$$.fragment,e),Bt=s(e),Ke=i(e,"P",{"data-svelte-h":!0}),T(Ke)!=="svelte-ymcz12"&&(Ke.textContent=_M),xt=s(e),el=i(e,"P",{"data-svelte-h":!0}),T(el)!=="svelte-u5k7vk"&&(el.innerHTML=OM),Ft=s(e),ll=i(e,"P",{"data-svelte-h":!0}),T(ll)!=="svelte-1baaith"&&(ll.innerHTML=zM),Dt=s(e),y(tl.$$.fragment,e),Et=s(e),Ml=i(e,"P",{"data-svelte-h":!0}),T(Ml)!=="svelte-15nmp2q"&&(Ml.textContent=HM),Vt=s(e),y(al.$$.fragment,e),Qt=s(e),y(sl.$$.fragment,e),_t=s(e),nl=i(e,"P",{"data-svelte-h":!0}),T(nl)!=="svelte-1htpjv"&&(nl.innerHTML=XM),Ot=s(e),y(il.$$.fragment,e),zt=s(e),Tl=i(e,"P",{}),ea(Tl).forEach(t),this.h()},h(){Xt(h,"name","hf:doc:metadata"),Xt(h,"content",ca),Xt(b,"class","flex justify-center")},m(e,l){na(document.head,h),M(e,m,l),M(e,d,l),M(e,p,l),c(A,e,l),M(e,Jl,l),c(g,e,l),M(e,yl,l),M(e,Z,l),M(e,cl,l),M(e,Y,l),M(e,ol,l),c(N,e,l),M(e,Ul,l),M(e,k,l),M(e,wl,l),M(e,G,l),M(e,hl,l),c(S,e,l),M(e,dl,l),M(e,W,l),M(e,jl,l),M(e,v,l),M(e,Il,l),c(L,e,l),M(e,ml,l),M(e,$,l),M(e,pl,l),c(R,e,l),M(e,fl,l),M(e,B,l),M(e,rl,l),M(e,x,l),M(e,Cl,l),M(e,F,l),M(e,ul,l),c(D,e,l),M(e,bl,l),M(e,E,l),M(e,Al,l),c(V,e,l),M(e,gl,l),M(e,Q,l),M(e,Zl,l),M(e,_,l),M(e,Yl,l),M(e,O,l),M(e,Nl,l),c(z,e,l),M(e,kl,l),M(e,H,l),M(e,Gl,l),M(e,X,l),M(e,Sl,l),c(P,e,l),M(e,Wl,l),M(e,q,l),M(e,vl,l),c(K,e,l),M(e,Ll,l),M(e,ee,l),M(e,$l,l),M(e,le,l),M(e,Rl,l),M(e,te,l),M(e,Bl,l),c(Me,e,l),M(e,xl,l),c(ae,e,l),M(e,Fl,l),M(e,se,l),M(e,Dl,l),c(ne,e,l),M(e,El,l),c(ie,e,l),M(e,Vl,l),M(e,Te,l),M(e,Ql,l),M(e,Je,l),M(e,_l,l),M(e,ye,l),M(e,Ol,l),c(ce,e,l),M(e,zl,l),M(e,oe,l),M(e,Hl,l),c(Ue,e,l),M(e,Xl,l),c(r,e,l),M(e,Pl,l),c(we,e,l),M(e,ql,l),M(e,he,l),M(e,Kl,l),c(de,e,l),M(e,et,l),c(je,e,l),M(e,lt,l),M(e,Ie,l),M(e,tt,l),c(me,e,l),M(e,Mt,l),M(e,pe,l),M(e,at,l),M(e,fe,l),M(e,st,l),c(re,e,l),M(e,nt,l),M(e,Ce,l),M(e,it,l),c(ue,e,l),M(e,Tt,l),c(be,e,l),M(e,Jt,l),M(e,Ae,l),M(e,yt,l),c(ge,e,l),M(e,ct,l),c(Ze,e,l),M(e,ot,l),M(e,Ye,l),M(e,Ut,l),M(e,Ne,l),M(e,wt,l),M(e,ke,l),M(e,ht,l),M(e,Ge,l),M(e,dt,l),c(Se,e,l),M(e,jt,l),c(We,e,l),M(e,It,l),M(e,ve,l),M(e,mt,l),c(Le,e,l),M(e,pt,l),M(e,$e,l),M(e,ft,l),M(e,Re,l),M(e,rt,l),M(e,Be,l),M(e,Ct,l),c(C,e,l),M(e,ut,l),c(u,e,l),M(e,bt,l),c(xe,e,l),M(e,At,l),M(e,Fe,l),M(e,gt,l),c(De,e,l),M(e,Zt,l),M(e,Ee,l),M(e,Yt,l),c(Ve,e,l),M(e,Nt,l),M(e,Qe,l),M(e,kt,l),c(_e,e,l),M(e,Gt,l),M(e,Oe,l),M(e,St,l),M(e,b,l),M(e,Wt,l),M(e,ze,l),M(e,vt,l),M(e,He,l),M(e,Lt,l),M(e,Xe,l),M(e,$t,l),c(Pe,e,l),M(e,Rt,l),c(qe,e,l),M(e,Bt,l),M(e,Ke,l),M(e,xt,l),M(e,el,l),M(e,Ft,l),M(e,ll,l),M(e,Dt,l),c(tl,e,l),M(e,Et,l),M(e,Ml,l),M(e,Vt,l),c(al,e,l),M(e,Qt,l),c(sl,e,l),M(e,_t,l),M(e,nl,l),M(e,Ot,l),c(il,e,l),M(e,zt,l),M(e,Tl,l),Ht=!0},p(e,[l]){const PM={};l&2&&(PM.$$scope={dirty:l,ctx:e}),r.$set(PM);const qM={};l&2&&(qM.$$scope={dirty:l,ctx:e}),C.$set(qM);const KM={};l&2&&(KM.$$scope={dirty:l,ctx:e}),u.$set(KM)},i(e){Ht||(o(A.$$.fragment,e),o(g.$$.fragment,e),o(N.$$.fragment,e),o(S.$$.fragment,e),o(L.$$.fragment,e),o(R.$$.fragment,e),o(D.$$.fragment,e),o(V.$$.fragment,e),o(z.$$.fragment,e),o(P.$$.fragment,e),o(K.$$.fragment,e),o(Me.$$.fragment,e),o(ae.$$.fragment,e),o(ne.$$.fragment,e),o(ie.$$.fragment,e),o(ce.$$.fragment,e),o(Ue.$$.fragment,e),o(r.$$.fragment,e),o(we.$$.fragment,e),o(de.$$.fragment,e),o(je.$$.fragment,e),o(me.$$.fragment,e),o(re.$$.fragment,e),o(ue.$$.fragment,e),o(be.$$.fragment,e),o(ge.$$.fragment,e),o(Ze.$$.fragment,e),o(Se.$$.fragment,e),o(We.$$.fragment,e),o(Le.$$.fragment,e),o(C.$$.fragment,e),o(u.$$.fragment,e),o(xe.$$.fragment,e),o(De.$$.fragment,e),o(Ve.$$.fragment,e),o(_e.$$.fragment,e),o(Pe.$$.fragment,e),o(qe.$$.fragment,e),o(tl.$$.fragment,e),o(al.$$.fragment,e),o(sl.$$.fragment,e),o(il.$$.fragment,e),Ht=!0)},o(e){U(A.$$.fragment,e),U(g.$$.fragment,e),U(N.$$.fragment,e),U(S.$$.fragment,e),U(L.$$.fragment,e),U(R.$$.fragment,e),U(D.$$.fragment,e),U(V.$$.fragment,e),U(z.$$.fragment,e),U(P.$$.fragment,e),U(K.$$.fragment,e),U(Me.$$.fragment,e),U(ae.$$.fragment,e),U(ne.$$.fragment,e),U(ie.$$.fragment,e),U(ce.$$.fragment,e),U(Ue.$$.fragment,e),U(r.$$.fragment,e),U(we.$$.fragment,e),U(de.$$.fragment,e),U(je.$$.fragment,e),U(me.$$.fragment,e),U(re.$$.fragment,e),U(ue.$$.fragment,e),U(be.$$.fragment,e),U(ge.$$.fragment,e),U(Ze.$$.fragment,e),U(Se.$$.fragment,e),U(We.$$.fragment,e),U(Le.$$.fragment,e),U(C.$$.fragment,e),U(u.$$.fragment,e),U(xe.$$.fragment,e),U(De.$$.fragment,e),U(Ve.$$.fragment,e),U(_e.$$.fragment,e),U(Pe.$$.fragment,e),U(qe.$$.fragment,e),U(tl.$$.fragment,e),U(al.$$.fragment,e),U(sl.$$.fragment,e),U(il.$$.fragment,e),Ht=!1},d(e){e&&(t(m),t(d),t(p),t(Jl),t(yl),t(Z),t(cl),t(Y),t(ol),t(Ul),t(k),t(wl),t(G),t(hl),t(dl),t(W),t(jl),t(v),t(Il),t(ml),t($),t(pl),t(fl),t(B),t(rl),t(x),t(Cl),t(F),t(ul),t(bl),t(E),t(Al),t(gl),t(Q),t(Zl),t(_),t(Yl),t(O),t(Nl),t(kl),t(H),t(Gl),t(X),t(Sl),t(Wl),t(q),t(vl),t(Ll),t(ee),t($l),t(le),t(Rl),t(te),t(Bl),t(xl),t(Fl),t(se),t(Dl),t(El),t(Vl),t(Te),t(Ql),t(Je),t(_l),t(ye),t(Ol),t(zl),t(oe),t(Hl),t(Xl),t(Pl),t(ql),t(he),t(Kl),t(et),t(lt),t(Ie),t(tt),t(Mt),t(pe),t(at),t(fe),t(st),t(nt),t(Ce),t(it),t(Tt),t(Jt),t(Ae),t(yt),t(ct),t(ot),t(Ye),t(Ut),t(Ne),t(wt),t(ke),t(ht),t(Ge),t(dt),t(jt),t(It),t(ve),t(mt),t(pt),t($e),t(ft),t(Re),t(rt),t(Be),t(Ct),t(ut),t(bt),t(At),t(Fe),t(gt),t(Zt),t(Ee),t(Yt),t(Nt),t(Qe),t(kt),t(Gt),t(Oe),t(St),t(b),t(Wt),t(ze),t(vt),t(He),t(Lt),t(Xe),t($t),t(Rt),t(Bt),t(Ke),t(xt),t(el),t(Ft),t(ll),t(Dt),t(Et),t(Ml),t(Vt),t(Qt),t(_t),t(nl),t(Ot),t(zt),t(Tl)),t(h),w(A,e),w(g,e),w(N,e),w(S,e),w(L,e),w(R,e),w(D,e),w(V,e),w(z,e),w(P,e),w(K,e),w(Me,e),w(ae,e),w(ne,e),w(ie,e),w(ce,e),w(Ue,e),w(r,e),w(we,e),w(de,e),w(je,e),w(me,e),w(re,e),w(ue,e),w(be,e),w(ge,e),w(Ze,e),w(Se,e),w(We,e),w(Le,e),w(C,e),w(u,e),w(xe,e),w(De,e),w(Ve,e),w(_e,e),w(Pe,e),w(qe,e),w(tl,e),w(al,e),w(sl,e),w(il,e)}}}const ca='{"title":"Manage huggingface_hub cache-system","local":"manage-huggingfacehub-cache-system","sections":[{"title":"Understand caching","local":"understand-caching","sections":[{"title":"Refs","local":"refs","sections":[],"depth":3},{"title":"Blobs","local":"blobs","sections":[],"depth":3},{"title":"Snapshots","local":"snapshots","sections":[],"depth":3},{"title":".no_exist (advanced)","local":"noexist-advanced","sections":[],"depth":3},{"title":"In practice","local":"in-practice","sections":[],"depth":3},{"title":"Limitations","local":"limitations","sections":[],"depth":3}],"depth":2},{"title":"Caching assets","local":"caching-assets","sections":[{"title":"Assets in practice","local":"assets-in-practice","sections":[],"depth":3}],"depth":2},{"title":"Scan your cache","local":"scan-your-cache","sections":[{"title":"Scan cache from the terminal","local":"scan-cache-from-the-terminal","sections":[{"title":"Grep example","local":"grep-example","sections":[],"depth":4}],"depth":3},{"title":"Scan cache from Python","local":"scan-cache-from-python","sections":[],"depth":3}],"depth":2},{"title":"Clean your cache","local":"clean-your-cache","sections":[{"title":"Delete strategy","local":"delete-strategy","sections":[],"depth":3},{"title":"Clean cache from the terminal","local":"clean-cache-from-the-terminal","sections":[{"title":"Using the TUI","local":"using-the-tui","sections":[],"depth":4},{"title":"Without TUI","local":"without-tui","sections":[],"depth":4}],"depth":3},{"title":"Clean cache from Python","local":"clean-cache-from-python","sections":[],"depth":3}],"depth":2}],"depth":1}';function oa(f){return ta(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class Ia extends Ma{constructor(h){super(),aa(this,h,oa,ya,la,{})}}export{Ia as component};
