import{s as it,n as rt,o as pt}from"../chunks/scheduler.f6319a2a.js";import{S as Mt,i as ct,g as o,s as n,r as M,A as ut,h as i,f as l,c as a,j as at,u as c,x as r,k as ot,y as dt,a as s,v as u,d,t as y,w}from"../chunks/index.85aa684c.js";import{C as L}from"../chunks/CodeBlock.97b48fd2.js";import{D as yt}from"../chunks/DocNotebookDropdown.316ce48d.js";import{H as wt,E as mt}from"../chunks/EditOnGithub.006048dd.js";function Jt(Ge){let p,K,P,O,m,ee,J,te,h,Ne="Retrieval-Augmented-Generation (RAG) is “using an LLM to answer a user query, but basing the answer on information retrieved from a knowledge base”. It has many advantages over using a vanilla or fine-tuned LLM: to name a few, it allows to ground the answer on true facts and reduce confabulations, it allows to provide the LLM with domain-specific knowledge, and it allows fine-grained control of access to information from the knowledge base.",le,T,xe="But vanilla RAG has limitations, most importantly these two:",se,b,We="<li>It performs only one retrieval step: if the results are bad, the generation in turn will be bad.</li> <li>Semantic similarity is computed with the user query as a reference, which might be suboptimal: for instance, the user query will often be a question and the document containing the true answer will be in affirmative voice, so its similarity score will be downgraded compared to other source documents in the interrogative form, leading to a risk of missing the relevant information.</li>",ne,j,qe="We can alleviate these problems by making a RAG agent: very simply, an agent armed with a retriever tool!",ae,U,He="This agent will: ✅ Formulate the query itself and ✅ Critique to re-retrieve if needed.",oe,f,Xe="So it should naively recover some advanced RAG techniques!",ie,I,Qe=`<li>Instead of directly using the user query as the reference in semantic search, the agent formulates itself a reference sentence that can be closer to the targeted documents, as in <a href="https://huggingface.co/papers/2212.10496" rel="nofollow">HyDE</a>.
The agent can use the generated snippets and re-retrieve if needed, as in <a href="https://docs.llamaindex.ai/en/stable/examples/evaluation/RetryQuery/" rel="nofollow">Self-Query</a>.</li>`,re,g,Ve="Let’s build this system. 🛠️",pe,v,$e="Run the line below to install required dependencies:",Me,C,ce,Z,Fe=`To call the HF Inference API, you will need a valid token as your environment variable <code>HF_TOKEN</code>.
We use python-dotenv to load it.`,ue,B,de,A,Ee="We first load a knowledge base on which we want to perform RAG: this dataset is a compilation of the documentation pages for many Hugging Face libraries, stored as markdown. We will keep only the documentation for the <code>transformers</code> library.",ye,k,Se="Then prepare the knowledge base by processing the dataset and storing it into a vector database to be used by the retriever.",we,R,ze='We use <a href="https://python.langchain.com/docs/introduction/" rel="nofollow">LangChain</a> for its excellent vector database utilities.',me,_,Je,G,Ye="Now the documents are ready.",he,N,Le="So let’s build our agentic RAG system!",Te,x,Pe="👉 We only need a RetrieverTool that our agent can leverage to retrieve information from the knowledge base.",be,W,De='Since we need to add a vectordb as an attribute of the tool, we cannot simply use the simple tool constructor with a <code>@tool</code> decorator: so we will follow the advanced setup highlighted in the <a href="../tutorials/tools">tools tutorial</a>.',je,q,Ue,H,Ke=`We have used BM25, a classic retrieval method, because it’s lightning fast to setup.
To improve retrieval accuracy, you could use replace BM25 with semantic search using vector representations for documents: thus you can head to the <a href="https://huggingface.co/spaces/mteb/leaderboard" rel="nofollow">MTEB Leaderboard</a> to select a good embedding model.`,fe,X,Oe="Now it’s straightforward to create an agent that leverages this <code>retriever_tool</code>!",Ie,Q,et="The agent will need these arguments upon initialization:",ge,V,tt=`<li><code>tools</code>: a list of tools that the agent will be able to call.</li> <li><code>model</code>: the LLM that powers the agent.
Our <code>model</code> must be a callable that takes as input a list of messages and returns text. It also needs to accept a stop_sequences argument that indicates when to stop its generation. For convenience, we directly use the HfEngine class provided in the package to get a LLM engine that calls Hugging Face’s Inference API.</li>`,ve,$,lt='<p>[!NOTE] To use a specific model, pass it like this: <code>HfApiModel(&quot;meta-llama/Llama-3.3-70B-Instruct&quot;)</code>. The Inference API hosts models based on various criteria, and deployed models may be updated or replaced without prior notice. Learn more about it <a href="https://huggingface.co/docs/api-inference/supported-models" rel="nofollow">here</a>.</p>',Ce,F,Ze,E,st="Upon initializing the CodeAgent, it has been automatically given a default system prompt that tells the LLM engine to process step-by-step and generate tool calls as code snippets, but you could replace this prompt template with your own as needed.",Be,S,nt="Then when its <code>.run()</code> method is launched, the agent takes care of calling the LLM engine, and executing the tool calls, all in a loop that ends only when tool <code>final_answer</code> is called with the final answer as its argument.",Ae,z,ke,Y,Re,D,_e;return m=new wt({props:{title:"Agentic RAG",local:"agentic-rag",headingTag:"h1"}}),J=new yt({props:{classNames:"absolute z-10 right-0 top-0",options:[{label:"Mixed",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://colab.research.google.com/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"},{label:"Mixed",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/rag.ipynb"},{label:"PyTorch",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/pytorch/rag.ipynb"},{label:"TensorFlow",value:"https://studiolab.sagemaker.aws/import/github/huggingface/notebooks/blob/main/smolagents_doc/en/tensorflow/rag.ipynb"}]}}),C=new L({props:{code:"IXBpcCUyMGluc3RhbGwlMjBzbW9sYWdlbnRzJTIwcGFuZGFzJTIwbGFuZ2NoYWluJTIwbGFuZ2NoYWluLWNvbW11bml0eSUyMHNlbnRlbmNlLXRyYW5zZm9ybWVycyUyMGRhdGFzZXRzJTIwcHl0aG9uLWRvdGVudiUyMHJhbmtfYm0yNSUyMC0tdXBncmFkZSUyMC1x",highlighted:"!pip install smolagents pandas langchain langchain-community sentence-transformers datasets python-dotenv rank_bm25 --upgrade -q",wrap:!1}}),B=new L({props:{code:"ZnJvbSUyMGRvdGVudiUyMGltcG9ydCUyMGxvYWRfZG90ZW52JTBBbG9hZF9kb3RlbnYoKQ==",highlighted:`<span class="hljs-keyword">from</span> dotenv <span class="hljs-keyword">import</span> load_dotenv
load_dotenv()`,wrap:!1}}),_=new L({props:{code:"aW1wb3J0JTIwZGF0YXNldHMlMEFmcm9tJTIwbGFuZ2NoYWluLmRvY3N0b3JlLmRvY3VtZW50JTIwaW1wb3J0JTIwRG9jdW1lbnQlMEFmcm9tJTIwbGFuZ2NoYWluLnRleHRfc3BsaXR0ZXIlMjBpbXBvcnQlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIlMEFmcm9tJTIwbGFuZ2NoYWluX2NvbW11bml0eS5yZXRyaWV2ZXJzJTIwaW1wb3J0JTIwQk0yNVJldHJpZXZlciUwQSUwQWtub3dsZWRnZV9iYXNlJTIwJTNEJTIwZGF0YXNldHMubG9hZF9kYXRhc2V0KCUyMm0tcmljJTJGaHVnZ2luZ2ZhY2VfZG9jJTIyJTJDJTIwc3BsaXQlM0QlMjJ0cmFpbiUyMiklMEFrbm93bGVkZ2VfYmFzZSUyMCUzRCUyMGtub3dsZWRnZV9iYXNlLmZpbHRlcihsYW1iZGElMjByb3clM0ElMjByb3clNUIlMjJzb3VyY2UlMjIlNUQuc3RhcnRzd2l0aCglMjJodWdnaW5nZmFjZSUyRnRyYW5zZm9ybWVycyUyMikpJTBBJTBBc291cmNlX2RvY3MlMjAlM0QlMjAlNUIlMEElMjAlMjAlMjAlMjBEb2N1bWVudChwYWdlX2NvbnRlbnQlM0Rkb2MlNUIlMjJ0ZXh0JTIyJTVEJTJDJTIwbWV0YWRhdGElM0QlN0IlMjJzb3VyY2UlMjIlM0ElMjBkb2MlNUIlMjJzb3VyY2UlMjIlNUQuc3BsaXQoJTIyJTJGJTIyKSU1QjElNUQlN0QpJTBBJTIwJTIwJTIwJTIwZm9yJTIwZG9jJTIwaW4lMjBrbm93bGVkZ2VfYmFzZSUwQSU1RCUwQSUwQXRleHRfc3BsaXR0ZXIlMjAlM0QlMjBSZWN1cnNpdmVDaGFyYWN0ZXJUZXh0U3BsaXR0ZXIoJTBBJTIwJTIwJTIwJTIwY2h1bmtfc2l6ZSUzRDUwMCUyQyUwQSUyMCUyMCUyMCUyMGNodW5rX292ZXJsYXAlM0Q1MCUyQyUwQSUyMCUyMCUyMCUyMGFkZF9zdGFydF9pbmRleCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBzdHJpcF93aGl0ZXNwYWNlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHNlcGFyYXRvcnMlM0QlNUIlMjIlNUNuJTVDbiUyMiUyQyUyMCUyMiU1Q24lMjIlMkMlMjAlMjIuJTIyJTJDJTIwJTIyJTIwJTIyJTJDJTIwJTIyJTIyJTVEJTJDJTBBKSUwQWRvY3NfcHJvY2Vzc2VkJTIwJTNEJTIwdGV4dF9zcGxpdHRlci5zcGxpdF9kb2N1bWVudHMoc291cmNlX2RvY3Mp",highlighted:`<span class="hljs-keyword">import</span> datasets
<span class="hljs-keyword">from</span> langchain.docstore.document <span class="hljs-keyword">import</span> Document
<span class="hljs-keyword">from</span> langchain.text_splitter <span class="hljs-keyword">import</span> RecursiveCharacterTextSplitter
<span class="hljs-keyword">from</span> langchain_community.retrievers <span class="hljs-keyword">import</span> BM25Retriever

knowledge_base = datasets.load_dataset(<span class="hljs-string">&quot;m-ric/huggingface_doc&quot;</span>, split=<span class="hljs-string">&quot;train&quot;</span>)
knowledge_base = knowledge_base.<span class="hljs-built_in">filter</span>(<span class="hljs-keyword">lambda</span> row: row[<span class="hljs-string">&quot;source&quot;</span>].startswith(<span class="hljs-string">&quot;huggingface/transformers&quot;</span>))

source_docs = [
    Document(page_content=doc[<span class="hljs-string">&quot;text&quot;</span>], metadata={<span class="hljs-string">&quot;source&quot;</span>: doc[<span class="hljs-string">&quot;source&quot;</span>].split(<span class="hljs-string">&quot;/&quot;</span>)[<span class="hljs-number">1</span>]})
    <span class="hljs-keyword">for</span> doc <span class="hljs-keyword">in</span> knowledge_base
]

text_splitter = RecursiveCharacterTextSplitter(
    chunk_size=<span class="hljs-number">500</span>,
    chunk_overlap=<span class="hljs-number">50</span>,
    add_start_index=<span class="hljs-literal">True</span>,
    strip_whitespace=<span class="hljs-literal">True</span>,
    separators=[<span class="hljs-string">&quot;\\n\\n&quot;</span>, <span class="hljs-string">&quot;\\n&quot;</span>, <span class="hljs-string">&quot;.&quot;</span>, <span class="hljs-string">&quot; &quot;</span>, <span class="hljs-string">&quot;&quot;</span>],
)
docs_processed = text_splitter.split_documents(source_docs)`,wrap:!1}}),q=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> Tool

<span class="hljs-keyword">class</span> <span class="hljs-title class_">RetrieverTool</span>(<span class="hljs-title class_ inherited__">Tool</span>):
    name = <span class="hljs-string">&quot;retriever&quot;</span>
    description = <span class="hljs-string">&quot;Uses semantic search to retrieve the parts of transformers documentation that could be most relevant to answer your query.&quot;</span>
    inputs = {
        <span class="hljs-string">&quot;query&quot;</span>: {
            <span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;string&quot;</span>,
            <span class="hljs-string">&quot;description&quot;</span>: <span class="hljs-string">&quot;The query to perform. This should be semantically close to your target documents. Use the affirmative form rather than a question.&quot;</span>,
        }
    }
    output_type = <span class="hljs-string">&quot;string&quot;</span>

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">__init__</span>(<span class="hljs-params">self, docs, **kwargs</span>):
        <span class="hljs-built_in">super</span>().__init__(**kwargs)
        self.retriever = BM25Retriever.from_documents(
            docs, k=<span class="hljs-number">10</span>
        )

    <span class="hljs-keyword">def</span> <span class="hljs-title function_">forward</span>(<span class="hljs-params">self, query: <span class="hljs-built_in">str</span></span>) -&gt; <span class="hljs-built_in">str</span>:
        <span class="hljs-keyword">assert</span> <span class="hljs-built_in">isinstance</span>(query, <span class="hljs-built_in">str</span>), <span class="hljs-string">&quot;Your search query must be a string&quot;</span>

        docs = self.retriever.invoke(
            query,
        )
        <span class="hljs-keyword">return</span> <span class="hljs-string">&quot;\\nRetrieved documents:\\n&quot;</span> + <span class="hljs-string">&quot;&quot;</span>.join(
            [
                <span class="hljs-string">f&quot;\\n\\n===== Document <span class="hljs-subst">{<span class="hljs-built_in">str</span>(i)}</span> =====\\n&quot;</span> + doc.page_content
                <span class="hljs-keyword">for</span> i, doc <span class="hljs-keyword">in</span> <span class="hljs-built_in">enumerate</span>(docs)
            ]
        )

retriever_tool = RetrieverTool(docs_processed)`,wrap:!1}}),F=new L({props:{code:"ZnJvbSUyMHNtb2xhZ2VudHMlMjBpbXBvcnQlMjBIZkFwaU1vZGVsJTJDJTIwQ29kZUFnZW50JTBBJTBBYWdlbnQlMjAlM0QlMjBDb2RlQWdlbnQoJTBBJTIwJTIwJTIwJTIwdG9vbHMlM0QlNUJyZXRyaWV2ZXJfdG9vbCU1RCUyQyUyMG1vZGVsJTNESGZBcGlNb2RlbCgpJTJDJTIwbWF4X3N0ZXBzJTNENCUyQyUyMHZlcmJvc2l0eV9sZXZlbCUzRDIlMEEp",highlighted:`<span class="hljs-keyword">from</span> smolagents <span class="hljs-keyword">import</span> HfApiModel, CodeAgent

agent = CodeAgent(
    tools=[retriever_tool], model=HfApiModel(), max_steps=<span class="hljs-number">4</span>, verbosity_level=<span class="hljs-number">2</span>
)`,wrap:!1}}),z=new L({props:{code:"YWdlbnRfb3V0cHV0JTIwJTNEJTIwYWdlbnQucnVuKCUyMkZvciUyMGElMjB0cmFuc2Zvcm1lcnMlMjBtb2RlbCUyMHRyYWluaW5nJTJDJTIwd2hpY2glMjBpcyUyMHNsb3dlciUyQyUyMHRoZSUyMGZvcndhcmQlMjBvciUyMHRoZSUyMGJhY2t3YXJkJTIwcGFzcyUzRiUyMiklMEElMEFwcmludCglMjJGaW5hbCUyMG91dHB1dCUzQSUyMiklMEFwcmludChhZ2VudF9vdXRwdXQp",highlighted:`agent_output = agent.run(<span class="hljs-string">&quot;For a transformers model training, which is slower, the forward or the backward pass?&quot;</span>)

<span class="hljs-built_in">print</span>(<span class="hljs-string">&quot;Final output:&quot;</span>)
<span class="hljs-built_in">print</span>(agent_output)`,wrap:!1}}),Y=new mt({props:{source:"https://github.com/huggingface/smolagents/blob/main/docs/source/en/examples/rag.md"}}),{c(){p=o("meta"),K=n(),P=o("p"),O=n(),M(m.$$.fragment),ee=n(),M(J.$$.fragment),te=n(),h=o("p"),h.textContent=Ne,le=n(),T=o("p"),T.textContent=xe,se=n(),b=o("ul"),b.innerHTML=We,ne=n(),j=o("p"),j.textContent=qe,ae=n(),U=o("p"),U.textContent=He,oe=n(),f=o("p"),f.textContent=Xe,ie=n(),I=o("ul"),I.innerHTML=Qe,re=n(),g=o("p"),g.textContent=Ve,pe=n(),v=o("p"),v.textContent=$e,Me=n(),M(C.$$.fragment),ce=n(),Z=o("p"),Z.innerHTML=Fe,ue=n(),M(B.$$.fragment),de=n(),A=o("p"),A.innerHTML=Ee,ye=n(),k=o("p"),k.textContent=Se,we=n(),R=o("p"),R.innerHTML=ze,me=n(),M(_.$$.fragment),Je=n(),G=o("p"),G.textContent=Ye,he=n(),N=o("p"),N.textContent=Le,Te=n(),x=o("p"),x.textContent=Pe,be=n(),W=o("p"),W.innerHTML=De,je=n(),M(q.$$.fragment),Ue=n(),H=o("p"),H.innerHTML=Ke,fe=n(),X=o("p"),X.innerHTML=Oe,Ie=n(),Q=o("p"),Q.textContent=et,ge=n(),V=o("ul"),V.innerHTML=tt,ve=n(),$=o("blockquote"),$.innerHTML=lt,Ce=n(),M(F.$$.fragment),Ze=n(),E=o("p"),E.textContent=st,Be=n(),S=o("p"),S.innerHTML=nt,Ae=n(),M(z.$$.fragment),ke=n(),M(Y.$$.fragment),Re=n(),D=o("p"),this.h()},l(e){const t=ut("svelte-u9bgzb",document.head);p=i(t,"META",{name:!0,content:!0}),t.forEach(l),K=a(e),P=i(e,"P",{}),at(P).forEach(l),O=a(e),c(m.$$.fragment,e),ee=a(e),c(J.$$.fragment,e),te=a(e),h=i(e,"P",{"data-svelte-h":!0}),r(h)!=="svelte-vj58on"&&(h.textContent=Ne),le=a(e),T=i(e,"P",{"data-svelte-h":!0}),r(T)!=="svelte-le6dse"&&(T.textContent=xe),se=a(e),b=i(e,"UL",{"data-svelte-h":!0}),r(b)!=="svelte-1sknqqb"&&(b.innerHTML=We),ne=a(e),j=i(e,"P",{"data-svelte-h":!0}),r(j)!=="svelte-c8ziqp"&&(j.textContent=qe),ae=a(e),U=i(e,"P",{"data-svelte-h":!0}),r(U)!=="svelte-1oxrjf8"&&(U.textContent=He),oe=a(e),f=i(e,"P",{"data-svelte-h":!0}),r(f)!=="svelte-i3m4dm"&&(f.textContent=Xe),ie=a(e),I=i(e,"UL",{"data-svelte-h":!0}),r(I)!=="svelte-1hcft9j"&&(I.innerHTML=Qe),re=a(e),g=i(e,"P",{"data-svelte-h":!0}),r(g)!=="svelte-18mh92s"&&(g.textContent=Ve),pe=a(e),v=i(e,"P",{"data-svelte-h":!0}),r(v)!=="svelte-16cuoal"&&(v.textContent=$e),Me=a(e),c(C.$$.fragment,e),ce=a(e),Z=i(e,"P",{"data-svelte-h":!0}),r(Z)!=="svelte-1gx6n4r"&&(Z.innerHTML=Fe),ue=a(e),c(B.$$.fragment,e),de=a(e),A=i(e,"P",{"data-svelte-h":!0}),r(A)!=="svelte-pnr043"&&(A.innerHTML=Ee),ye=a(e),k=i(e,"P",{"data-svelte-h":!0}),r(k)!=="svelte-10fmib9"&&(k.textContent=Se),we=a(e),R=i(e,"P",{"data-svelte-h":!0}),r(R)!=="svelte-15ubgr3"&&(R.innerHTML=ze),me=a(e),c(_.$$.fragment,e),Je=a(e),G=i(e,"P",{"data-svelte-h":!0}),r(G)!=="svelte-zjg126"&&(G.textContent=Ye),he=a(e),N=i(e,"P",{"data-svelte-h":!0}),r(N)!=="svelte-q3vnxy"&&(N.textContent=Le),Te=a(e),x=i(e,"P",{"data-svelte-h":!0}),r(x)!=="svelte-151azqv"&&(x.textContent=Pe),be=a(e),W=i(e,"P",{"data-svelte-h":!0}),r(W)!=="svelte-16enqdj"&&(W.innerHTML=De),je=a(e),c(q.$$.fragment,e),Ue=a(e),H=i(e,"P",{"data-svelte-h":!0}),r(H)!=="svelte-1rtfitb"&&(H.innerHTML=Ke),fe=a(e),X=i(e,"P",{"data-svelte-h":!0}),r(X)!=="svelte-1o6dxyl"&&(X.innerHTML=Oe),Ie=a(e),Q=i(e,"P",{"data-svelte-h":!0}),r(Q)!=="svelte-14g5yev"&&(Q.textContent=et),ge=a(e),V=i(e,"UL",{"data-svelte-h":!0}),r(V)!=="svelte-krum96"&&(V.innerHTML=tt),ve=a(e),$=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),r($)!=="svelte-pmabcr"&&($.innerHTML=lt),Ce=a(e),c(F.$$.fragment,e),Ze=a(e),E=i(e,"P",{"data-svelte-h":!0}),r(E)!=="svelte-45t4kd"&&(E.textContent=st),Be=a(e),S=i(e,"P",{"data-svelte-h":!0}),r(S)!=="svelte-1ytp34t"&&(S.innerHTML=nt),Ae=a(e),c(z.$$.fragment,e),ke=a(e),c(Y.$$.fragment,e),Re=a(e),D=i(e,"P",{}),at(D).forEach(l),this.h()},h(){ot(p,"name","hf:doc:metadata"),ot(p,"content",ht)},m(e,t){dt(document.head,p),s(e,K,t),s(e,P,t),s(e,O,t),u(m,e,t),s(e,ee,t),u(J,e,t),s(e,te,t),s(e,h,t),s(e,le,t),s(e,T,t),s(e,se,t),s(e,b,t),s(e,ne,t),s(e,j,t),s(e,ae,t),s(e,U,t),s(e,oe,t),s(e,f,t),s(e,ie,t),s(e,I,t),s(e,re,t),s(e,g,t),s(e,pe,t),s(e,v,t),s(e,Me,t),u(C,e,t),s(e,ce,t),s(e,Z,t),s(e,ue,t),u(B,e,t),s(e,de,t),s(e,A,t),s(e,ye,t),s(e,k,t),s(e,we,t),s(e,R,t),s(e,me,t),u(_,e,t),s(e,Je,t),s(e,G,t),s(e,he,t),s(e,N,t),s(e,Te,t),s(e,x,t),s(e,be,t),s(e,W,t),s(e,je,t),u(q,e,t),s(e,Ue,t),s(e,H,t),s(e,fe,t),s(e,X,t),s(e,Ie,t),s(e,Q,t),s(e,ge,t),s(e,V,t),s(e,ve,t),s(e,$,t),s(e,Ce,t),u(F,e,t),s(e,Ze,t),s(e,E,t),s(e,Be,t),s(e,S,t),s(e,Ae,t),u(z,e,t),s(e,ke,t),u(Y,e,t),s(e,Re,t),s(e,D,t),_e=!0},p:rt,i(e){_e||(d(m.$$.fragment,e),d(J.$$.fragment,e),d(C.$$.fragment,e),d(B.$$.fragment,e),d(_.$$.fragment,e),d(q.$$.fragment,e),d(F.$$.fragment,e),d(z.$$.fragment,e),d(Y.$$.fragment,e),_e=!0)},o(e){y(m.$$.fragment,e),y(J.$$.fragment,e),y(C.$$.fragment,e),y(B.$$.fragment,e),y(_.$$.fragment,e),y(q.$$.fragment,e),y(F.$$.fragment,e),y(z.$$.fragment,e),y(Y.$$.fragment,e),_e=!1},d(e){e&&(l(K),l(P),l(O),l(ee),l(te),l(h),l(le),l(T),l(se),l(b),l(ne),l(j),l(ae),l(U),l(oe),l(f),l(ie),l(I),l(re),l(g),l(pe),l(v),l(Me),l(ce),l(Z),l(ue),l(de),l(A),l(ye),l(k),l(we),l(R),l(me),l(Je),l(G),l(he),l(N),l(Te),l(x),l(be),l(W),l(je),l(Ue),l(H),l(fe),l(X),l(Ie),l(Q),l(ge),l(V),l(ve),l($),l(Ce),l(Ze),l(E),l(Be),l(S),l(Ae),l(ke),l(Re),l(D)),l(p),w(m,e),w(J,e),w(C,e),w(B,e),w(_,e),w(q,e),w(F,e),w(z,e),w(Y,e)}}}const ht='{"title":"Agentic RAG","local":"agentic-rag","sections":[],"depth":1}';function Tt(Ge){return pt(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class gt extends Mt{constructor(p){super(),ct(this,p,Tt,Jt,it,{})}}export{gt as component};
