import{s as Za,A as qa,o as Wa,n as Tt}from"../chunks/scheduler.01eeda35.js";import{S as Ba,i as Fa,g as r,s as n,r as m,A as Ga,h as i,f as o,c as s,j as N,u as p,x as d,k as w,y as _,a,v as h,d as g,t as f,w as u}from"../chunks/index.6dd51b66.js";import{T as Eo}from"../chunks/Tip.de9bae2b.js";import{D as q}from"../chunks/Docstring.cb556860.js";import{C as L}from"../chunks/CodeBlock.19ec9b8c.js";import{E as ka}from"../chunks/ExampleCodeBlock.69db56ad.js";import{H as I,E as Ra}from"../chunks/index.58fe8f9d.js";function Va(j){let l,M="<li>Llava-Next uses different number of patches for images and thus has to pad the inputs inside modeling code, aside from the padding done when processing the inputs. The default setting is “left-padding” if model is in <code>eval()</code> mode, otherwise “right-padding”.</li>";return{c(){l=r("ul"),l.innerHTML=M},l(T){l=i(T,"UL",{"data-svelte-h":!0}),d(l)!=="svelte-17g7vjy"&&(l.innerHTML=M)},m(T,y){a(T,l,y)},p:Tt,d(T){T&&o(l)}}}function Xa(j){let l,M='bitsandbytes is being refactored to support multiple backends beyond CUDA. Currently, ROCm (AMD GPU) and Intel CPU implementations are mature, with Intel XPU in progress and Apple Silicon support expected by Q4/Q1. For installation instructions and the latest backend updates, visit <a href="https://huggingface.co/docs/bitsandbytes/main/en/installation#multi-backend" rel="nofollow">this link</a>.',T,y,v='We value your feedback to help identify bugs before the full release! Check out <a href="https://huggingface.co/docs/bitsandbytes/main/en/non_cuda_backends" rel="nofollow">these docs</a> for more details and feedback links.';return{c(){l=r("p"),l.innerHTML=M,T=n(),y=r("p"),y.innerHTML=v},l(c){l=i(c,"P",{"data-svelte-h":!0}),d(l)!=="svelte-nz63kd"&&(l.innerHTML=M),T=s(c),y=i(c,"P",{"data-svelte-h":!0}),d(y)!=="svelte-aze40l"&&(y.innerHTML=v)},m(c,b){a(c,l,b),a(c,T,b),a(c,y,b)},p:Tt,d(c){c&&(o(l),o(T),o(y))}}}function Pa(j){let l,M="Example:",T,y,v;return y=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUyQyUyMExsYXZhTmV4dENvbmZpZyUyQyUyMENMSVBWaXNpb25Db25maWclMkMlMjBMbGFtYUNvbmZpZyUwQSUwQSUyMyUyMEluaXRpYWxpemluZyUyMGElMjBDTElQLXZpc2lvbiUyMGNvbmZpZyUwQXZpc2lvbl9jb25maWclMjAlM0QlMjBDTElQVmlzaW9uQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhbWElMjBjb25maWclMEF0ZXh0X2NvbmZpZyUyMCUzRCUyMExsYW1hQ29uZmlnKCklMEElMEElMjMlMjBJbml0aWFsaXppbmclMjBhJTIwTGxhdmEtTmV4dCUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBY29uZmlndXJhdGlvbiUyMCUzRCUyMExsYXZhTmV4dENvbmZpZyh2aXNpb25fY29uZmlnJTJDJTIwdGV4dF9jb25maWcpJTBBJTBBJTIzJTIwSW5pdGlhbGl6aW5nJTIwYSUyMG1vZGVsJTIwZnJvbSUyMHRoZSUyMGxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIwc3R5bGUlMjBjb25maWd1cmF0aW9uJTBBbW9kZWwlMjAlM0QlMjBMbGF2YU5leHRGb3JDb25kaXRpb25hbEdlbmVyYXRpb24oY29uZmlndXJhdGlvbiklMEElMEElMjMlMjBBY2Nlc3NpbmclMjB0aGUlMjBtb2RlbCUyMGNvbmZpZ3VyYXRpb24lMEFjb25maWd1cmF0aW9uJTIwJTNEJTIwbW9kZWwuY29uZmln",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextForConditionalGeneration, LlavaNextConfig, CLIPVisionConfig, LlamaConfig

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a CLIP-vision config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>vision_config = CLIPVisionConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llama config</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>text_config = LlamaConfig()

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a Llava-Next llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = LlavaNextConfig(vision_config, text_config)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Initializing a model from the llava-hf/llava-v1.6-mistral-7b-hf style configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration(configuration)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Accessing the model configuration</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>configuration = model.config`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,T=n(),m(y.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),T=s(c),p(y.$$.fragment,c)},m(c,b){a(c,l,b),a(c,T,b),h(y,c,b),v=!0},p:Tt,i(c){v||(g(y.$$.fragment,c),v=!0)},o(c){f(y.$$.fragment,c),v=!1},d(c){c&&(o(l),o(T)),u(y,c)}}}function Ha(j){let l,M=`Although the recipe for forward pass needs to be defined within this function, one should call the <code>Module</code>
instance afterwards instead of this since the former takes care of running the pre and post processing steps while
the latter silently ignores them.`;return{c(){l=r("p"),l.innerHTML=M},l(T){l=i(T,"P",{"data-svelte-h":!0}),d(l)!=="svelte-fincs2"&&(l.innerHTML=M)},m(T,y){a(T,l,y)},p:Tt,d(T){T&&o(l)}}}function Qa(j){let l,M="Example:",T,y,v;return y=new L({props:{code:"ZnJvbSUyMFBJTCUyMGltcG9ydCUyMEltYWdlJTBBaW1wb3J0JTIwcmVxdWVzdHMlMEFmcm9tJTIwdHJhbnNmb3JtZXJzJTIwaW1wb3J0JTIwQXV0b1Byb2Nlc3NvciUyQyUyMExsYXZhTmV4dEZvckNvbmRpdGlvbmFsR2VuZXJhdGlvbiUwQSUwQW1vZGVsJTIwJTNEJTIwTGxhdmFOZXh0Rm9yQ29uZGl0aW9uYWxHZW5lcmF0aW9uLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEFwcm9jZXNzb3IlMjAlM0QlMjBBdXRvUHJvY2Vzc29yLmZyb21fcHJldHJhaW5lZCglMjJsbGF2YS1oZiUyRmxsYXZhLXYxLjYtbWlzdHJhbC03Yi1oZiUyMiklMEElMEFwcm9tcHQlMjAlM0QlMjAlMjIlNUJJTlNUJTVEJTIwJTNDaW1hZ2UlM0UlNUNuV2hhdCUyMGlzJTIwc2hvd24lMjBpbiUyMHRoaXMlMjBpbWFnZSUzRiUyMCU1QiUyRklOU1QlNUQlMjIlMEF1cmwlMjAlM0QlMjAlMjJodHRwcyUzQSUyRiUyRnd3dy5pbGFua2VsbWFuLm9yZyUyRnN0b3BzaWducyUyRmF1c3RyYWxpYS5qcGclMjIlMEFpbWFnZSUyMCUzRCUyMEltYWdlLm9wZW4ocmVxdWVzdHMuZ2V0KHVybCUyQyUyMHN0cmVhbSUzRFRydWUpLnJhdyklMEElMEFpbnB1dHMlMjAlM0QlMjBwcm9jZXNzb3IoaW1hZ2VzJTNEaW1hZ2UlMkMlMjB0ZXh0JTNEcHJvbXB0JTJDJTIwcmV0dXJuX3RlbnNvcnMlM0QlMjJwdCUyMiklMEElMEElMjMlMjBHZW5lcmF0ZSUwQWdlbmVyYXRlX2lkcyUyMCUzRCUyMG1vZGVsLmdlbmVyYXRlKCoqaW5wdXRzJTJDJTIwbWF4X2xlbmd0aCUzRDMwKSUwQXByb2Nlc3Nvci5iYXRjaF9kZWNvZGUoZ2VuZXJhdGVfaWRzJTJDJTIwc2tpcF9zcGVjaWFsX3Rva2VucyUzRFRydWUlMkMlMjBjbGVhbl91cF90b2tlbml6YXRpb25fc3BhY2VzJTNERmFsc2UpJTVCMCU1RA==",highlighted:`<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">import</span> requests
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, LlavaNextForConditionalGeneration

<span class="hljs-meta">&gt;&gt;&gt; </span>model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span>prompt = <span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-meta">&gt;&gt;&gt; </span>inputs = processor(images=image, text=prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>)

<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-comment"># Generate</span>
<span class="hljs-meta">&gt;&gt;&gt; </span>generate_ids = model.generate(**inputs, max_length=<span class="hljs-number">30</span>)
<span class="hljs-meta">&gt;&gt;&gt; </span>processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)[<span class="hljs-number">0</span>]
<span class="hljs-string">&quot;[INST]  \\nWhat is shown in this image? [/INST] The image appears to be a radar chart, which is a type of multi-dimensional plot (...)&quot;</span>`,wrap:!1}}),{c(){l=r("p"),l.textContent=M,T=n(),m(y.$$.fragment)},l(c){l=i(c,"P",{"data-svelte-h":!0}),d(l)!=="svelte-11lpom8"&&(l.textContent=M),T=s(c),p(y.$$.fragment,c)},m(c,b){a(c,l,b),a(c,T,b),h(y,c,b),v=!0},p:Tt,i(c){v||(g(y.$$.fragment,c),v=!0)},o(c){f(y.$$.fragment,c),v=!1},d(c){c&&(o(l),o(T)),u(y,c)}}}function Sa(j){let l,M,T,y,v,c,b,Yo='<img alt="PyTorch" src="https://img.shields.io/badge/PyTorch-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/> <img alt="FlashAttention" src="https://img.shields.io/badge/%E2%9A%A1%EF%B8%8E%20FlashAttention-eae0c8?style=flat"/> <img alt="SDPA" src="https://img.shields.io/badge/SDPA-DE3412?style=flat&amp;logo=pytorch&amp;logoColor=white"/>',yt,A,vt,D,Ao='The LLaVA-NeXT model was proposed in <a href="https://llava-vl.github.io/blog/2024-01-30-llava-next/" rel="nofollow">LLaVA-NeXT: Improved reasoning, OCR, and world knowledge</a> by Haotian Liu, Chunyuan Li, Yuheng Li, Bo Li, Yuanhan Zhang, Sheng Shen, Yong Jae Lee. LLaVa-NeXT (also called LLaVa-1.6) improves upon <a href="llava">LLaVa</a> by increasing the input image resolution and training on an improved visual instruction tuning dataset to improve OCR and common sense reasoning.',bt,O,Do="The introduction from the blog is the following:",Mt,K,Oo="*In October 2023, we released LLaVA-1.5 with a simple and efficient design along with great performance on a benchmark suite of 12 datasets. It has since served as the foundation of many comprehensive studies of data, model, and capabilities of large multimodal models (LMM), and has enabled various new applications.",wt,ee,Ko="Today, we are thrilled to present LLaVA-NeXT, with improved reasoning, OCR, and world knowledge. LLaVA-NeXT even exceeds Gemini Pro on several benchmarks.",Jt,te,ea="Compared with LLaVA-1.5, LLaVA-NeXT has several improvements:",It,oe,ta=`Increasing the input image resolution to 4x more pixels. This allows it to grasp more visual details. It supports three aspect ratios, up to 672x672, 336x1344, 1344x336 resolution.
Better visual reasoning and OCR capability with an improved visual instruction tuning data mixture.
Better visual conversation for more scenarios, covering different applications. Better world knowledge and logical reasoning.
Efficient deployment and inference with SGLang.
Along with performance improvements, LLaVA-NeXT maintains the minimalist design and data efficiency of LLaVA-1.5. It re-uses the pretrained connector of LLaVA-1.5, and still uses less than 1M visual instruction tuning samples. The largest 34B variant finishes training in ~1 day with 32 A100s.*`,Ut,F,oa,xt,ae,aa='LLaVa-NeXT incorporates a higher input resolution by encoding various patches of the input image. Taken from the <a href="https://arxiv.org/abs/2310.03744">original paper.</a>',jt,ne,na=`This model was contributed by <a href="https://huggingface.co/nielsr" rel="nofollow">nielsr</a>.
The original code can be found <a href="https://github.com/haotian-liu/LLaVA/tree/main" rel="nofollow">here</a>.`,Ct,se,Nt,re,sa="<li>We advise users to use <code>padding_side=&quot;left&quot;</code> when computing batched generation as it leads to more accurate results. Simply make sure to call <code>processor.tokenizer.padding_side = &quot;left&quot;</code> before generating.</li>",Lt,G,zt,ie,ra="<p>[!NOTE]\nLLaVA models after release v4.46 will raise warnings about adding <code>processor.patch_size = {{patch_size}}</code>, <code>processor.num_additional_image_tokens = {{num_additional_image_tokens}}</code> and processor.vision_feature_select_strategy = {{vision_feature_select_strategy}}<code>. It is strongly recommended to add the attributes to the processor if you own the model checkpoint, or open a PR if it is not owned by you. Adding these attributes means that LLaVA will try to infer the number of image tokens required per image and expand the text with as many </code>&lt;image&gt;<code>placeholders as there will be tokens. Usually it is around 500 tokens per image, so make sure that the text is not truncated as otherwise there will be failure when merging the embeddings. The attributes can be obtained from model config, as</code>model.config.vision_config.patch_size<code>or</code>model.config.vision_feature_select_strategy<code>. The </code>num_additional_image_tokens<code>should be</code>1<code>if the vision backbone adds a CLS token or</code>0` if nothing extra is added to the vision patches.</p>",$t,le,kt,ce,ia="Each <strong>checkpoint</strong> is trained with a specific prompt format, depending on the underlying large language model backbone. To ensure correct formatting, use the processor’s <code>apply_chat_template</code> method.",Zt,de,la="<strong>Important:</strong>",qt,me,ca="<li>You must construct a conversation history — passing a plain string won’t work.</li> <li>Each message should be a dictionary with <code>&quot;role&quot;</code> and <code>&quot;content&quot;</code> keys.</li> <li>The <code>&quot;content&quot;</code> should be a list of dictionaries for different modalities like <code>&quot;text&quot;</code> and <code>&quot;image&quot;</code>.</li>",Wt,pe,da='Here’s an example of how to structure your input. We will use <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> and a conversation history of text and image.',Bt,he,Ft,ge,ma=`<li>If you want to construct a chat prompt yourself, below is a list of possible formats
.
<a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-v1.6-mistral-7b-hf</a> requires the following format:</li>`,Gt,fe,Rt,ue,pa='<a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-7b-hf" rel="nofollow">llava-v1.6-vicuna-7b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-v1.6-vicuna-13b-hf" rel="nofollow">llava-v1.6-vicuna-13b-hf</a> require the following format:',Vt,_e,Xt,Te,ha='<a href="https://huggingface.co/llava-hf/llava-v1.6-34b-hf" rel="nofollow">llava-v1.6-34b-hf</a> requires the following format:',Pt,ye,Ht,ve,ga='<a href="https://huggingface.co/llava-hf/llava-next-8b-hf" rel="nofollow">llama3-llava-next-8b-hf</a> requires the following format:',Qt,be,St,Me,fa='<a href="https://huggingface.co/llava-hf/llava-next-72b-hf" rel="nofollow">llava-next-72b-hf</a> and <a href="https://huggingface.co/llava-hf/llava-next-110b-hf" rel="nofollow">llava-next-110b-hf</a> require the following format:',Et,we,Yt,Je,ua="🚀 <strong>Bonus:</strong> If you’re using <code>transformers&gt;=4.49.0</code>, you can also get a vectorized output from <code>apply_chat_template</code>. See the <strong>Usage Examples</strong> below for more details on how to use it.",At,Ie,Dt,Ue,Ot,xe,_a="Here’s how to load the model and perform inference in half-precision (<code>torch.float16</code>):",Kt,je,eo,Ce,to,Ne,Ta="LLaVa-Next can perform inference with multiple images as input, where images either belong to the same prompt or different prompts (in batched inference). Here is how you can do it:",oo,Le,ao,ze,no,$e,so,ke,ya="The model can be loaded in 8 or 4 bits, greatly reducing the memory requirements while maintaining the performance of the original model. First make sure to install bitsandbytes, <code>pip install bitsandbytes</code>, and to have access to a GPU/accelerator that is supported by the library.",ro,R,io,Ze,va="Simply change the snippet above with:",lo,qe,co,We,mo,Be,ba='First make sure to install flash-attn. Refer to the <a href="https://github.com/Dao-AILab/flash-attention" rel="nofollow">original repository of Flash Attention</a> regarding that package installation. Simply change the snippet above with:',po,Fe,ho,Ge,go,U,Re,jo,at,Ma=`This is the configuration class to store the configuration of a <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a>. It is used to instantiate an
Llava-NeXT model according to the specified arguments, defining the model architecture. Instantiating a configuration
with the defaults will yield a similar configuration to that of the <a href="https://huggingface.co/llava-hf/llava-v1.6-mistral-7b-hf" rel="nofollow">llava-hf/llava-v1.6-mistral-7b-hf</a>
model.`,Co,nt,wa=`Configuration objects inherit from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> and can be used to control the model outputs. Read the
documentation from <a href="/docs/transformers/main/en/main_classes/configuration#transformers.PretrainedConfig">PretrainedConfig</a> for more information.`,No,V,fo,Ve,uo,z,Xe,Lo,st,Ja=`Constructs a LLaVa-NeXT image processor. Based on <a href="/docs/transformers/main/en/model_doc/clip#transformers.CLIPImageProcessor">CLIPImageProcessor</a> with incorporation of additional techniques
for processing high resolution images as explained in the <a href="https://arxiv.org/abs/2310.03744" rel="nofollow">LLaVa paper</a>.`,zo,rt,Pe,_o,He,To,$,Qe,$o,it,Ia="Constructs a fast ConvNeXT image processor.",ko,X,Se,Zo,lt,Ua="Preprocess an image or batch of images.",yo,Ee,vo,J,Ye,qo,ct,xa="Constructs a LLaVa-NeXT processor which wraps a LLaVa-NeXT image processor and a LLaMa tokenizer into a single processor.",Wo,dt,ja=`<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor">LlavaNextProcessor</a> offers all the functionalities of <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> and <a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>. See the
<code>__call__()</code> and <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextProcessor.decode">decode()</a> for more information.`,Bo,P,Ae,Fo,mt,Ca=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.batch_decode">batch_decode()</a>. Please
refer to the docstring of this method for more information.`,Go,H,De,Ro,pt,Na=`This method forwards all its arguments to LlamaTokenizerFast’s <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.decode">decode()</a>. Please refer to
the docstring of this method for more information.`,bo,Oe,Mo,x,Ke,Vo,ht,La=`The LLAVA-NeXT model which consists of a vision backbone and a language model.
This model inherits from <a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel">PreTrainedModel</a>. Check the superclass documentation for the generic methods the
library implements for all its model (such as downloading or saving, resizing the input embeddings, pruning heads
etc.)`,Xo,gt,za=`This model is also a PyTorch <a href="https://pytorch.org/docs/stable/nn.html#torch.nn.Module" rel="nofollow">torch.nn.Module</a> subclass.
Use it as a regular PyTorch Module and refer to the PyTorch documentation for all matter related to general usage
and behavior.`,Po,C,et,Ho,ft,$a='The <a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextForConditionalGeneration">LlavaNextForConditionalGeneration</a> forward method, overrides the <code>__call__</code> special method.',Qo,Q,So,S,wo,tt,Jo,ut,Io;return v=new I({props:{title:"LLaVA-NeXT",local:"llava-next",headingTag:"h1"}}),A=new I({props:{title:"Overview",local:"overview",headingTag:"h2"}}),se=new I({props:{title:"Usage tips",local:"usage-tips",headingTag:"h2"}}),G=new Eo({props:{warning:!0,$$slots:{default:[Va]},$$scope:{ctx:j}}}),le=new I({props:{title:"Formatting Prompts with Chat Templates",local:"formatting-prompts-with-chat-templates",headingTag:"h3"}}),he=new L({props:{code:"JTBBJTBBJTBBJTBBJTBBJTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQncyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIwVGhpcyUyMGltYWdlJTIwc2hvd3MlMjBhJTIwcmVkJTIwc3RvcCUyMHNpZ24uJTIwJTVCSU5TVCU1RCUyMERlc2NyaWJlJTIwdGhlJTIwaW1hZ2UlMjBpbiUyMG1vcmUlMjBkZXRhaWxzLiUyMCU1QiUyRklOU1QlNUQlMjI=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What’s shown in this image?&quot;</span>},
        ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [{<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;This image shows a red stop sign.&quot;</span>},]
    },
    {

        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;Describe the image in more details.&quot;</span>},
        ],
    },
]

text_prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)

<span class="hljs-comment"># Note that the template simply formats your prompt, you still have to tokenize it and obtain pixel values for your images</span>
<span class="hljs-built_in">print</span>(text_prompt)
<span class="hljs-meta">&gt;&gt;&gt; </span><span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat&#x27;s shown in this image? [/INST] This image shows a red stop sign. [INST] Describe the image in more details. [/INST]&quot;</span>`,wrap:!1}}),fe=new L({props:{code:"JTIyJTVCSU5TVCU1RCUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjAlNUIlMkZJTlNUJTVEJTIy",highlighted:'<span class="hljs-string">&quot;[INST] &lt;image&gt;\\nWhat is shown in this image? [/INST]&quot;</span>',wrap:!1}}),_e=new L({props:{code:"JTIyQSUyMGNoYXQlMjBiZXR3ZWVuJTIwYSUyMGN1cmlvdXMlMjBodW1hbiUyMGFuZCUyMGFuJTIwYXJ0aWZpY2lhbCUyMGludGVsbGlnZW5jZSUyMGFzc2lzdGFudC4lMjBUaGUlMjBhc3Npc3RhbnQlMjBnaXZlcyUyMGhlbHBmdWwlMkMlMjBkZXRhaWxlZCUyQyUyMGFuZCUyMHBvbGl0ZSUyMGFuc3dlcnMlMjB0byUyMHRoZSUyMGh1bWFuJ3MlMjBxdWVzdGlvbnMuJTIwVVNFUiUzQSUyMCUzQ2ltYWdlJTNFJTVDbldoYXQlMjBpcyUyMHNob3duJTIwaW4lMjB0aGlzJTIwaW1hZ2UlM0YlMjBBU1NJU1RBTlQlM0ElMjI=",highlighted:'<span class="hljs-string">&quot;A chat between a curious human and an artificial intelligence assistant. The assistant gives helpful, detailed, and polite answers to the human&#x27;s questions. USER: &lt;image&gt;\\nWhat is shown in this image? ASSISTANT:&quot;</span>',wrap:!1}}),ye=new L({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuQW5zd2VyJTIwdGhlJTIwcXVlc3Rpb25zLiUzQyU3Q2ltX2VuZCU3QyUzRSUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTNDJTdDaW1fc3RhcnQlN0MlM0Vhc3Npc3RhbnQlNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nAnswer the questions.&lt;|im_end|&gt;&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),be=new L({props:{code:"JTIyJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFc3lzdGVtJTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBsYW5ndWFnZSUyMGFuZCUyMHZpc2lvbiUyMGFzc2lzdGFudC4lMjBZb3UlMjBhcmUlMjBhYmxlJTIwdG8lMjB1bmRlcnN0YW5kJTIwdGhlJTIwdmlzdWFsJTIwY29udGVudCUyMHRoYXQlMjB0aGUlMjB1c2VyJTIwcHJvdmlkZXMlMkMlMjBhbmQlMjBhc3Npc3QlMjB0aGUlMjB1c2VyJTIwd2l0aCUyMGElMjB2YXJpZXR5JTIwb2YlMjB0YXNrcyUyMHVzaW5nJTIwbmF0dXJhbCUyMGxhbmd1YWdlLiUzQyU3Q2VvdF9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRSUzQyU3Q3N0YXJ0X2hlYWRlcl9pZCU3QyUzRXVzZXIlM0MlN0NlbmRfaGVhZGVyX2lkJTdDJTNFJTVDbiU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDZW90X2lkJTdDJTNFJTNDJTdDc3RhcnRfaGVhZGVyX2lkJTdDJTNFYXNzaXN0YW50JTNDJTdDZW5kX2hlYWRlcl9pZCU3QyUzRSU1Q24lNUNuJTIy",highlighted:'<span class="hljs-string">&quot;&lt;|start_header_id|&gt;system&lt;|end_header_id|&gt;\\n\\nYou are a helpful language and vision assistant. You are able to understand the visual content that the user provides, and assist the user with a variety of tasks using natural language.&lt;|eot_id|&gt;&lt;|start_header_id|&gt;&lt;|start_header_id|&gt;user&lt;|end_header_id|&gt;\\n\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|eot_id|&gt;&lt;|start_header_id|&gt;assistant&lt;|end_header_id|&gt;\\n\\n&quot;</span>',wrap:!1}}),we=new L({props:{code:"JTIyJTNDJTdDaW1fc3RhcnQlN0MlM0VzeXN0ZW0lNUNuWW91JTIwYXJlJTIwYSUyMGhlbHBmdWwlMjBhc3Npc3RhbnQuJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFdXNlciU1Q24lM0NpbWFnZSUzRSU1Q25XaGF0JTIwaXMlMjBzaG93biUyMGluJTIwdGhpcyUyMGltYWdlJTNGJTNDJTdDaW1fZW5kJTdDJTNFJTVDbiUzQyU3Q2ltX3N0YXJ0JTdDJTNFYXNzaXN0YW50JTVDbiUyMg==",highlighted:'<span class="hljs-string">&quot;&lt;|im_start|&gt;system\\nYou are a helpful assistant.&lt;|im_end|&gt;\\n&lt;|im_start|&gt;user\\n&lt;image&gt;\\nWhat is shown in this image?&lt;|im_end|&gt;\\n&lt;|im_start|&gt;assistant\\n&quot;</span>',wrap:!1}}),Ie=new I({props:{title:"Usage example",local:"usage-example",headingTag:"h2"}}),Ue=new I({props:{title:"Single image inference",local:"single-image-inference",headingTag:"h3"}}),je=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> LlavaNextProcessor, LlavaNextForConditionalGeneration
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> requests

processor = LlavaNextProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

model = LlavaNextForConditionalGeneration.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, low_cpu_mem_usage=<span class="hljs-literal">True</span>)
model.to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># prepare image and text prompt, using the appropriate prompt template</span>
url = <span class="hljs-string">&quot;https://github.com/haotian-liu/LLaVA/blob/1a91fc274d7c35a9b50b3cb29c4247ae5837ce39/images/llava_v1_5_radar.jpg?raw=true&quot;</span>
image = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

conversation = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
        ],
    },
]
prompt = processor.apply_chat_template(conversation, add_generation_prompt=<span class="hljs-literal">True</span>)
inputs = processor(image, prompt, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(<span class="hljs-string">&quot;cuda:0&quot;</span>)

<span class="hljs-comment"># autoregressively complete prompt</span>
output = model.generate(**inputs, max_new_tokens=<span class="hljs-number">100</span>)

<span class="hljs-built_in">print</span>(processor.decode(output[<span class="hljs-number">0</span>], skip_special_tokens=<span class="hljs-literal">True</span>))`,wrap:!1}}),Ce=new I({props:{title:"Multi image inference",local:"multi-image-inference",headingTag:"h3"}}),Le=new L({props:{code:"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",highlighted:`<span class="hljs-keyword">import</span> requests
<span class="hljs-keyword">from</span> PIL <span class="hljs-keyword">import</span> Image
<span class="hljs-keyword">import</span> torch
<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoProcessor, AutoModelForImageTextToText

<span class="hljs-comment"># Load the model in half-precision</span>
model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, torch_dtype=torch.float16, device_map=<span class="hljs-string">&quot;auto&quot;</span>)
processor = AutoProcessor.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>)

<span class="hljs-comment"># Get three different images</span>
url = <span class="hljs-string">&quot;https://www.ilankelman.org/stopsigns/australia.jpg&quot;</span>
image_stop = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;http://images.cocodataset.org/val2017/000000039769.jpg&quot;</span>
image_cats = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

url = <span class="hljs-string">&quot;https://huggingface.co/microsoft/kosmos-2-patch14-224/resolve/main/snowman.jpg&quot;</span>
image_snowman = Image.<span class="hljs-built_in">open</span>(requests.get(url, stream=<span class="hljs-literal">True</span>).raw)

<span class="hljs-comment"># Prepare a batch of two prompts, where the first one is a multi-turn conversation and the second is not</span>
conversation_1 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;assistant&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;There is a red stop sign in the image.&quot;</span>},
            ],
    },
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What about this image? How many cats do you see?&quot;</span>},
            ],
    },
]

conversation_2 = [
    {
        <span class="hljs-string">&quot;role&quot;</span>: <span class="hljs-string">&quot;user&quot;</span>,
        <span class="hljs-string">&quot;content&quot;</span>: [
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;image&quot;</span>},
            {<span class="hljs-string">&quot;type&quot;</span>: <span class="hljs-string">&quot;text&quot;</span>, <span class="hljs-string">&quot;text&quot;</span>: <span class="hljs-string">&quot;What is shown in this image?&quot;</span>},
            ],
    },
]

prompt_1 = processor.apply_chat_template(conversation_1, add_generation_prompt=<span class="hljs-literal">True</span>)
prompt_2 = processor.apply_chat_template(conversation_2, add_generation_prompt=<span class="hljs-literal">True</span>)
prompts = [prompt_1, prompt_2]

<span class="hljs-comment"># We can simply feed images in the order they have to be used in the text prompt</span>
<span class="hljs-comment"># Each &quot;&lt;image&gt;&quot; token uses one image leaving the next for the subsequent &quot;&lt;image&gt;&quot; tokens</span>
inputs = processor(images=[image_stop, image_cats, image_snowman], text=prompts, padding=<span class="hljs-literal">True</span>, return_tensors=<span class="hljs-string">&quot;pt&quot;</span>).to(model.device)

<span class="hljs-comment"># Generate</span>
generate_ids = model.generate(**inputs, max_new_tokens=<span class="hljs-number">30</span>)
processor.batch_decode(generate_ids, skip_special_tokens=<span class="hljs-literal">True</span>, clean_up_tokenization_spaces=<span class="hljs-literal">False</span>)`,wrap:!1}}),ze=new I({props:{title:"Model optimization",local:"model-optimization",headingTag:"h2"}}),$e=new I({props:{title:"Quantization using Bitsandbytes",local:"quantization-using-bitsandbytes",headingTag:"h3"}}),R=new Eo({props:{$$slots:{default:[Xa]},$$scope:{ctx:j}}}),qe=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUyQyUyMEJpdHNBbmRCeXRlc0NvbmZpZyUwQSUwQSUyMyUyMHNwZWNpZnklMjBob3clMjB0byUyMHF1YW50aXplJTIwdGhlJTIwbW9kZWwlMEFxdWFudGl6YXRpb25fY29uZmlnJTIwJTNEJTIwQml0c0FuZEJ5dGVzQ29uZmlnKCUwQSUyMCUyMCUyMCUyMGxvYWRfaW5fNGJpdCUzRFRydWUlMkMlMEElMjAlMjAlMjAlMjBibmJfNGJpdF9xdWFudF90eXBlJTNEJTIybmY0JTIyJTJDJTBBJTIwJTIwJTIwJTIwYm5iXzRiaXRfY29tcHV0ZV9kdHlwZSUzRHRvcmNoLmZsb2F0MTYlMkMlMEEpJTBBJTBBbW9kZWwlMjAlM0QlMjBBdXRvTW9kZWxGb3JJbWFnZVRleHRUb1RleHQuZnJvbV9wcmV0cmFpbmVkKCUyMmxsYXZhLWhmJTJGbGxhdmEtdjEuNi1taXN0cmFsLTdiLWhmJTIyJTJDJTIwcXVhbnRpemF0aW9uX2NvbmZpZyUzRHF1YW50aXphdGlvbl9jb25maWclMkMlMjBkZXZpY2VfbWFwJTNEJTIyYXV0byUyMik=",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText, BitsAndBytesConfig

<span class="hljs-comment"># specify how to quantize the model</span>
quantization_config = BitsAndBytesConfig(
    load_in_4bit=<span class="hljs-literal">True</span>,
    bnb_4bit_quant_type=<span class="hljs-string">&quot;nf4&quot;</span>,
    bnb_4bit_compute_dtype=torch.float16,
)

model = AutoModelForImageTextToText.from_pretrained(<span class="hljs-string">&quot;llava-hf/llava-v1.6-mistral-7b-hf&quot;</span>, quantization_config=quantization_config, device_map=<span class="hljs-string">&quot;auto&quot;</span>)`,wrap:!1}}),We=new I({props:{title:"Use Flash-Attention 2 to further speed-up generation",local:"use-flash-attention-2-to-further-speed-up-generation",headingTag:"h3"}}),Fe=new L({props:{code:"ZnJvbSUyMHRyYW5zZm9ybWVycyUyMGltcG9ydCUyMEF1dG9Nb2RlbEZvckltYWdlVGV4dFRvVGV4dCUwQSUwQW1vZGVsJTIwJTNEJTIwQXV0b01vZGVsRm9ySW1hZ2VUZXh0VG9UZXh0LmZyb21fcHJldHJhaW5lZCglMEElMjAlMjAlMjAlMjBtb2RlbF9pZCUyQyUwQSUyMCUyMCUyMCUyMHRvcmNoX2R0eXBlJTNEdG9yY2guZmxvYXQxNiUyQyUwQSUyMCUyMCUyMCUyMGxvd19jcHVfbWVtX3VzYWdlJTNEVHJ1ZSUyQyUwQSUyMCUyMCUyMCUyMHVzZV9mbGFzaF9hdHRlbnRpb25fMiUzRFRydWUlMEEpLnRvKDAp",highlighted:`<span class="hljs-keyword">from</span> transformers <span class="hljs-keyword">import</span> AutoModelForImageTextToText

model = AutoModelForImageTextToText.from_pretrained(
    model_id,
    torch_dtype=torch.float16,
    low_cpu_mem_usage=<span class="hljs-literal">True</span>,
    use_flash_attention_2=<span class="hljs-literal">True</span>
).to(<span class="hljs-number">0</span>)`,wrap:!1}}),Ge=new I({props:{title:"LlavaNextConfig",local:"transformers.LlavaNextConfig",headingTag:"h2"}}),Re=new q({props:{name:"class transformers.LlavaNextConfig",anchor:"transformers.LlavaNextConfig",parameters:[{name:"vision_config",val:" = None"},{name:"text_config",val:" = None"},{name:"image_token_index",val:" = 32000"},{name:"projector_hidden_act",val:" = 'gelu'"},{name:"vision_feature_select_strategy",val:" = 'default'"},{name:"vision_feature_layer",val:" = -2"},{name:"image_grid_pinpoints",val:" = None"},{name:"tie_word_embeddings",val:" = False"},{name:"image_seq_length",val:" = 576"},{name:"multimodal_projector_bias",val:" = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextConfig.vision_config",description:`<strong>vision_config</strong> (<code>Union[AutoConfig, dict]</code>,  <em>optional</em>, defaults to <code>CLIPVisionConfig</code>) &#x2014;
The config object or dictionary of the vision backbone.`,name:"vision_config"},{anchor:"transformers.LlavaNextConfig.text_config",description:`<strong>text_config</strong> (<code>Union[AutoConfig, dict]</code>, <em>optional</em>, defaults to <code>LlamaConfig</code>) &#x2014;
The config object or dictionary of the text backbone.`,name:"text_config"},{anchor:"transformers.LlavaNextConfig.image_token_index",description:`<strong>image_token_index</strong> (<code>int</code>, <em>optional</em>, defaults to 32000) &#x2014;
The image token index to encode the image prompt.`,name:"image_token_index"},{anchor:"transformers.LlavaNextConfig.projector_hidden_act",description:`<strong>projector_hidden_act</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;gelu&quot;</code>) &#x2014;
The activation function used by the multimodal projector.`,name:"projector_hidden_act"},{anchor:"transformers.LlavaNextConfig.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextConfig.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]]</code>, <em>optional</em>, defaults to -2) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextConfig.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code>, <em>optional</em>, defaults to <code>[[336, 672], [672, 336], [672, 672], [1008, 336], [336, 1008]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextConfig.tie_word_embeddings",description:`<strong>tie_word_embeddings</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>False</code>) &#x2014;
Whether the model&#x2019;s input and output word embeddings should be tied.`,name:"tie_word_embeddings"},{anchor:"transformers.LlavaNextConfig.image_seq_length",description:`<strong>image_seq_length</strong> (<code>int</code>, <em>optional</em>, defaults to 576) &#x2014;
Sequence length of one image embedding.`,name:"image_seq_length"},{anchor:"transformers.LlavaNextConfig.multimodal_projector_bias",description:`<strong>multimodal_projector_bias</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to use bias in the multimodal projector.`,name:"multimodal_projector_bias"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/configuration_llava_next.py#L24"}}),V=new ka({props:{anchor:"transformers.LlavaNextConfig.example",$$slots:{default:[Pa]},$$scope:{ctx:j}}}),Ve=new I({props:{title:"LlavaNextImageProcessor",local:"transformers.LlavaNextImageProcessor",headingTag:"h2"}}),Xe=new q({props:{name:"class transformers.LlavaNextImageProcessor",anchor:"transformers.LlavaNextImageProcessor",parameters:[{name:"do_resize",val:": bool = True"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = <Resampling.BICUBIC: 3>"},{name:"do_center_crop",val:": bool = True"},{name:"crop_size",val:": typing.Dict[str, int] = None"},{name:"do_rescale",val:": bool = True"},{name:"rescale_factor",val:": typing.Union[int, float] = 0.00392156862745098"},{name:"do_normalize",val:": bool = True"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = True"},{name:"do_convert_rgb",val:": bool = True"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by
<code>do_resize</code> in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.size",description:`<strong>size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>{&quot;shortest_edge&quot; -- 224}</code>):
Size of the image after resizing. The shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio. Can be overridden by <code>size</code> in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>[[672, 336], [336, 672], [672, 672], [336, 1008], [1008, 336]]</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>Resampling.BICUBIC</code>) &#x2014;
Resampling filter to use if resizing the image. Can be overridden by <code>resample</code> in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to 224) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by <code>do_rescale</code> in
the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>1/255</code>) &#x2014;
Scale factor to use if rescaling the image. Can be overridden by <code>rescale_factor</code> in the <code>preprocess</code>
method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to normalize the image. Can be overridden by <code>do_normalize</code> in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.48145466, 0.4578275, 0.40821073]</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>[0.26862954, 0.26130258, 0.27577711]</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>True</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next.py#L119"}}),Pe=new q({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessor.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"do_resize",val:": typing.Optional[bool] = None"},{name:"size",val:": typing.Dict[str, int] = None"},{name:"image_grid_pinpoints",val:": typing.List = None"},{name:"resample",val:": Resampling = None"},{name:"do_center_crop",val:": typing.Optional[bool] = None"},{name:"crop_size",val:": typing.Optional[int] = None"},{name:"do_rescale",val:": typing.Optional[bool] = None"},{name:"rescale_factor",val:": typing.Optional[float] = None"},{name:"do_normalize",val:": typing.Optional[bool] = None"},{name:"image_mean",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"image_std",val:": typing.Union[float, typing.List[float], NoneType] = None"},{name:"do_pad",val:": typing.Optional[bool] = None"},{name:"do_convert_rgb",val:": typing.Optional[bool] = None"},{name:"return_tensors",val:": typing.Union[str, transformers.utils.generic.TensorType, NoneType] = None"},{name:"data_format",val:": typing.Optional[transformers.image_utils.ChannelDimension] = <ChannelDimension.FIRST: 'channels_first'>"},{name:"input_data_format",val:": typing.Union[str, transformers.image_utils.ChannelDimension, NoneType] = None"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessor.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the image after resizing. Shortest edge of the image is resized to size[&#x201C;shortest_edge&#x201D;], with
the longest edge resized to keep the input aspect ratio.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List</code> <em>optional</em>, defaults to <code>self.image_grid_pinpoints</code>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is
selected based on the original size of the image.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.resample",description:`<strong>resample</strong> (<code>int</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the center crop. Only has an effect if <code>do_center_crop</code> is set to <code>True</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_pad</code>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.return_tensors",description:`<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>) &#x2014;
The type of tensors to return. Can be one of:<ul>
<li>Unset: Return a list of <code>np.ndarray</code>.</li>
<li><code>TensorType.TENSORFLOW</code> or <code>&apos;tf&apos;</code>: Return a batch of type <code>tf.Tensor</code>.</li>
<li><code>TensorType.PYTORCH</code> or <code>&apos;pt&apos;</code>: Return a batch of type <code>torch.Tensor</code>.</li>
<li><code>TensorType.NUMPY</code> or <code>&apos;np&apos;</code>: Return a batch of type <code>np.ndarray</code>.</li>
<li><code>TensorType.JAX</code> or <code>&apos;jax&apos;</code>: Return a batch of type <code>jax.numpy.ndarray</code>.</li>
</ul>`,name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>ChannelDimension.FIRST</code>) &#x2014;
The channel dimension format for the output image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li>Unset: Use the channel dimension format of the input image.</li>
</ul>`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessor.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next.py#L558"}}),He=new I({props:{title:"LlavaNextImageProcessorFast",local:"transformers.LlavaNextImageProcessorFast",headingTag:"h2"}}),Qe=new q({props:{name:"class transformers.LlavaNextImageProcessorFast",anchor:"transformers.LlavaNextImageProcessorFast",parameters:[{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next.image_processing_llava_next_fast.LlavaNextFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessorFast.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image&#x2019;s (height, width) dimensions to the specified <code>size</code>. Can be overridden by the
<code>do_resize</code> parameter in the <code>preprocess</code> method.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessorFast.size",description:`<strong>size</strong> (<code>dict</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Size of the output image after resizing. Can be overridden by the <code>size</code> parameter in the <code>preprocess</code>
method.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessorFast.default_to_square",description:`<strong>default_to_square</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.default_to_square</code>) &#x2014;
Whether to default to a square image when resizing, if size is an int.`,name:"default_to_square"},{anchor:"transformers.LlavaNextImageProcessorFast.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. Only has an effect if <code>do_resize</code> is set to <code>True</code>. Can be
overridden by the <code>resample</code> parameter in the <code>preprocess</code> method.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessorFast.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image to the specified <code>crop_size</code>. Can be overridden by <code>do_center_crop</code> in the
<code>preprocess</code> method.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessorFast.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code> <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>. Can be overridden by <code>crop_size</code> in the <code>preprocess</code>
method.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessorFast.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image by the specified scale <code>rescale_factor</code>. Can be overridden by the
<code>do_rescale</code> parameter in the <code>preprocess</code> method.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessorFast.rescale_factor",description:`<strong>rescale_factor</strong> (<code>int</code> or <code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Scale factor to use if rescaling the image. Only has an effect if <code>do_rescale</code> is set to <code>True</code>. Can be
overridden by the <code>rescale_factor</code> parameter in the <code>preprocess</code> method.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessorFast.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code>
method. Can be overridden by the <code>do_normalize</code> parameter in the <code>preprocess</code> method.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessorFast.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Mean to use if normalizing the image. This is a float or list of floats the length of the number of
channels in the image. Can be overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method. Can be
overridden by the <code>image_mean</code> parameter in the <code>preprocess</code> method.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessorFast.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Standard deviation to use if normalizing the image. This is a float or list of floats the length of the
number of channels in the image. Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.
Can be overridden by the <code>image_std</code> parameter in the <code>preprocess</code> method.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessorFast.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessorFast.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessorFast.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.`,name:"device"},{anchor:"transformers.LlavaNextImageProcessorFast.image_grid_pinpoints",description:`<strong>image_grid_pinpoints</strong> (<code>List[List[int]]</code>, <em>optional</em>) &#x2014;
A list of possible resolutions to use for processing high resolution images. The best resolution is selected
based on the original size of the image. Can be overridden by <code>image_grid_pinpoints</code> in the <code>preprocess</code>
method.`,name:"image_grid_pinpoints"},{anchor:"transformers.LlavaNextImageProcessorFast.do_pad",description:`<strong>do_pad</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"do_pad"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next_fast.py#L64"}}),Se=new q({props:{name:"preprocess",anchor:"transformers.LlavaNextImageProcessorFast.preprocess",parameters:[{name:"images",val:": typing.Union[ForwardRef('PIL.Image.Image'), numpy.ndarray, ForwardRef('torch.Tensor'), list['PIL.Image.Image'], list[numpy.ndarray], list['torch.Tensor']]"},{name:"**kwargs",val:": typing_extensions.Unpack[transformers.models.llava_next.image_processing_llava_next_fast.LlavaNextFastImageProcessorKwargs]"}],parametersDescription:[{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.images",description:`<strong>images</strong> (<code>ImageInput</code>) &#x2014;
Image to preprocess. Expects a single or batch of images with pixel values ranging from 0 to 255. If
passing in images with pixel values between 0 and 1, set <code>do_rescale=False</code>.`,name:"images"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_resize",description:`<strong>do_resize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_resize</code>) &#x2014;
Whether to resize the image.`,name:"do_resize"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.size",description:`<strong>size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.size</code>) &#x2014;
Describes the maximum input dimensions to the model.`,name:"size"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.resample",description:`<strong>resample</strong> (<code>PILImageResampling</code> or <code>InterpolationMode</code>, <em>optional</em>, defaults to <code>self.resample</code>) &#x2014;
Resampling filter to use if resizing the image. This can be one of the enum <code>PILImageResampling</code>. Only
has an effect if <code>do_resize</code> is set to <code>True</code>.`,name:"resample"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_center_crop",description:`<strong>do_center_crop</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_center_crop</code>) &#x2014;
Whether to center crop the image.`,name:"do_center_crop"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.crop_size",description:`<strong>crop_size</strong> (<code>Dict[str, int]</code>, <em>optional</em>, defaults to <code>self.crop_size</code>) &#x2014;
Size of the output image after applying <code>center_crop</code>.`,name:"crop_size"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_rescale",description:`<strong>do_rescale</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_rescale</code>) &#x2014;
Whether to rescale the image.`,name:"do_rescale"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.rescale_factor",description:`<strong>rescale_factor</strong> (<code>float</code>, <em>optional</em>, defaults to <code>self.rescale_factor</code>) &#x2014;
Rescale factor to rescale the image by if <code>do_rescale</code> is set to <code>True</code>.`,name:"rescale_factor"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_normalize",description:`<strong>do_normalize</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_normalize</code>) &#x2014;
Whether to normalize the image.`,name:"do_normalize"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.image_mean",description:`<strong>image_mean</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_mean</code>) &#x2014;
Image mean to use for normalization. Only has an effect if <code>do_normalize</code> is set to <code>True</code>.`,name:"image_mean"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.image_std",description:`<strong>image_std</strong> (<code>float</code> or <code>List[float]</code>, <em>optional</em>, defaults to <code>self.image_std</code>) &#x2014;
Image standard deviation to use for normalization. Only has an effect if <code>do_normalize</code> is set to
<code>True</code>.`,name:"image_std"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.do_convert_rgb",description:`<strong>do_convert_rgb</strong> (<code>bool</code>, <em>optional</em>, defaults to <code>self.do_convert_rgb</code>) &#x2014;
Whether to convert the image to RGB.`,name:"do_convert_rgb"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.return_tensors",description:"<strong>return_tensors</strong> (<code>str</code> or <code>TensorType</code>, <em>optional</em>, defaults to <code>self.return_tensors</code>) &#x2014;\nReturns stacked tensors if set to `pt, otherwise returns a list of tensors.",name:"return_tensors"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.data_format",description:`<strong>data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.data_format</code>) &#x2014;
Only <code>ChannelDimension.FIRST</code> is supported. Added for compatibility with slow processors.`,name:"data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.input_data_format",description:`<strong>input_data_format</strong> (<code>ChannelDimension</code> or <code>str</code>, <em>optional</em>, defaults to <code>self.input_data_format</code>) &#x2014;
The channel dimension format for the input image. If unset, the channel dimension format is inferred
from the input image. Can be one of:<ul>
<li><code>&quot;channels_first&quot;</code> or <code>ChannelDimension.FIRST</code>: image in (num_channels, height, width) format.</li>
<li><code>&quot;channels_last&quot;</code> or <code>ChannelDimension.LAST</code>: image in (height, width, num_channels) format.</li>
<li><code>&quot;none&quot;</code> or <code>ChannelDimension.NONE</code>: image in (height, width) format.</li>
</ul>`,name:"input_data_format"},{anchor:"transformers.LlavaNextImageProcessorFast.preprocess.device",description:`<strong>device</strong> (<code>torch.device</code>, <em>optional</em>, defaults to <code>self.device</code>) &#x2014;
The device to process the images on. If unset, the device is inferred from the input images.
image_grid_pinpoints (<code>List</code>, <em>optional</em>):
A list of possible resolutions to use for processing high resolution images. Each item in the list should be a tuple or list
of the form <code>(height, width)</code>.
do_pad (<code>bool</code>, <em>optional</em>):
Whether to pad the image. If <code>True</code>, will pad the patch dimension of the images in the batch to the largest
number of patches in the batch. Padding will be applied to the bottom and right with zeros.`,name:"device"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/image_processing_llava_next_fast.py#L98"}}),Ee=new I({props:{title:"LlavaNextProcessor",local:"transformers.LlavaNextProcessor",headingTag:"h2"}}),Ye=new q({props:{name:"class transformers.LlavaNextProcessor",anchor:"transformers.LlavaNextProcessor",parameters:[{name:"image_processor",val:" = None"},{name:"tokenizer",val:" = None"},{name:"patch_size",val:" = None"},{name:"vision_feature_select_strategy",val:" = None"},{name:"chat_template",val:" = None"},{name:"image_token",val:" = '<image>'"},{name:"num_additional_image_tokens",val:" = 0"},{name:"**kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextProcessor.image_processor",description:`<strong>image_processor</strong> (<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a>, <em>optional</em>) &#x2014;
The image processor is a required input.`,name:"image_processor"},{anchor:"transformers.LlavaNextProcessor.tokenizer",description:`<strong>tokenizer</strong> (<a href="/docs/transformers/main/en/model_doc/llama#transformers.LlamaTokenizerFast">LlamaTokenizerFast</a>, <em>optional</em>) &#x2014;
The tokenizer is a required input.`,name:"tokenizer"},{anchor:"transformers.LlavaNextProcessor.patch_size",description:`<strong>patch_size</strong> (<code>int</code>, <em>optional</em>) &#x2014;
Patch size from the vision tower.`,name:"patch_size"},{anchor:"transformers.LlavaNextProcessor.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Shoudl be same as in model&#x2019;s config`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextProcessor.chat_template",description:`<strong>chat_template</strong> (<code>str</code>, <em>optional</em>) &#x2014; A Jinja template which will be used to convert lists of messages
in a chat into a tokenizable string.`,name:"chat_template"},{anchor:"transformers.LlavaNextProcessor.image_token",description:`<strong>image_token</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;&lt;image&gt;&quot;</code>) &#x2014;
Special token used to denote image location.`,name:"image_token"},{anchor:"transformers.LlavaNextProcessor.num_additional_image_tokens",description:`<strong>num_additional_image_tokens</strong> (<code>int</code>, <em>optional</em>, defaults to 0) &#x2014;
Number of additional tokens added to the image embeddings, such as CLS (+1). If the backbone has no CLS or other
extra tokens appended, no need to set this arg.`,name:"num_additional_image_tokens"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L43"}}),Ae=new q({props:{name:"batch_decode",anchor:"transformers.LlavaNextProcessor.batch_decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L221"}}),De=new q({props:{name:"decode",anchor:"transformers.LlavaNextProcessor.decode",parameters:[{name:"*args",val:""},{name:"**kwargs",val:""}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/processing_llava_next.py#L229"}}),Oe=new I({props:{title:"LlavaNextForConditionalGeneration",local:"transformers.LlavaNextForConditionalGeneration",headingTag:"h2"}}),Ke=new q({props:{name:"class transformers.LlavaNextForConditionalGeneration",anchor:"transformers.LlavaNextForConditionalGeneration",parameters:[{name:"config",val:": LlavaNextConfig"}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.config",description:`<strong>config</strong> (<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextConfig">LlavaNextConfig</a> or <code>LlavaNextVisionConfig</code>) &#x2014;
Model configuration class with all the parameters of the model. Initializing with a config file does not
load the weights associated with the model, only the configuration. Check out the
<a href="/docs/transformers/main/en/main_classes/model#transformers.PreTrainedModel.from_pretrained">from_pretrained()</a> method to load the model weights.`,name:"config"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L355"}}),et=new q({props:{name:"forward",anchor:"transformers.LlavaNextForConditionalGeneration.forward",parameters:[{name:"input_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"pixel_values",val:": typing.Optional[torch.FloatTensor] = None"},{name:"image_sizes",val:": typing.Optional[torch.LongTensor] = None"},{name:"attention_mask",val:": typing.Optional[torch.Tensor] = None"},{name:"position_ids",val:": typing.Optional[torch.LongTensor] = None"},{name:"past_key_values",val:": typing.Optional[typing.List[torch.FloatTensor]] = None"},{name:"inputs_embeds",val:": typing.Optional[torch.FloatTensor] = None"},{name:"vision_feature_layer",val:": typing.Union[int, typing.List[int], NoneType] = None"},{name:"vision_feature_select_strategy",val:": typing.Optional[str] = None"},{name:"labels",val:": typing.Optional[torch.LongTensor] = None"},{name:"use_cache",val:": typing.Optional[bool] = None"},{name:"output_attentions",val:": typing.Optional[bool] = None"},{name:"output_hidden_states",val:": typing.Optional[bool] = None"},{name:"return_dict",val:": typing.Optional[bool] = None"},{name:"cache_position",val:": typing.Optional[torch.LongTensor] = None"},{name:"logits_to_keep",val:": typing.Union[int, torch.Tensor] = 0"},{name:"**lm_kwargs",val:""}],parametersDescription:[{anchor:"transformers.LlavaNextForConditionalGeneration.forward.input_ids",description:`<strong>input_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>) &#x2014;
Indices of input sequence tokens in the vocabulary. Padding will be ignored by default should you provide
it.</p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p><a href="../glossary#input-ids">What are input IDs?</a>`,name:"input_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.pixel_values",description:`<strong>pixel_values</strong> (<code>torch.FloatTensor</code> of shape \`(batch_size, num_channels, image_size, image_size)) &#x2014;
The tensors corresponding to the input images. Pixel values can be obtained using
<a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoImageProcessor">AutoImageProcessor</a>. See <a href="/docs/transformers/main/en/model_doc/vilt#transformers.ViltFeatureExtractor.__call__">LlavaNextImageProcessor.<strong>call</strong>()</a> for details. <a href="/docs/transformers/main/en/model_doc/llava#transformers.LlavaProcessor">LlavaProcessor</a> uses
<a href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextImageProcessor">LlavaNextImageProcessor</a> for processing images.`,name:"pixel_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.image_sizes",description:`<strong>image_sizes</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, 2)</code>, <em>optional</em>) &#x2014;
The sizes of the images in the batch, being (height, width) for each image.`,name:"image_sizes"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.attention_mask",description:`<strong>attention_mask</strong> (<code>torch.Tensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Mask to avoid performing attention on padding token indices. Mask values selected in <code>[0, 1]</code>:</p>
<ul>
<li>1 for tokens that are <strong>not masked</strong>,</li>
<li>0 for tokens that are <strong>masked</strong>.</li>
</ul>
<p><a href="../glossary#attention-mask">What are attention masks?</a></p>
<p>Indices can be obtained using <a href="/docs/transformers/main/en/model_doc/auto#transformers.AutoTokenizer">AutoTokenizer</a>. See <a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.encode">PreTrainedTokenizer.encode()</a> and
<a href="/docs/transformers/main/en/internal/tokenization_utils#transformers.PreTrainedTokenizerBase.__call__">PreTrainedTokenizer.<strong>call</strong>()</a> for details.</p>
<p>If <code>past_key_values</code> is used, optionally only the last <code>decoder_input_ids</code> have to be input (see
<code>past_key_values</code>).</p>
<p>If you want to change padding behavior, you should read <code>modeling_opt._prepare_decoder_attention_mask</code>
and modify to your needs. See diagram 1 in <a href="https://arxiv.org/abs/1910.13461" rel="nofollow">the paper</a> for more
information on the default strategy.</p>
<ul>
<li>1 indicates the head is <strong>not masked</strong>,</li>
<li>0 indicates the head is <strong>masked</strong>.</li>
</ul>`,name:"attention_mask"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.position_ids",description:`<strong>position_ids</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Indices of positions of each input sequence tokens in the position embeddings. Selected in the range <code>[0, config.n_positions - 1]</code>. <a href="../glossary#position-ids">What are position IDs?</a>`,name:"position_ids"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.past_key_values",description:`<strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) &#x2014;
Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>) and 2 additional tensors of shape
<code>(batch_size, num_heads, encoder_sequence_length, embed_size_per_head)</code>.</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks and in the cross-attention
blocks) that can be used (see <code>past_key_values</code> input) to speed up sequential decoding.</p>
<p>If <code>past_key_values</code> are used, the user can optionally input only the last <code>decoder_input_ids</code> (those that
don&#x2019;t have their past key value states given to this model) of shape <code>(batch_size, 1)</code> instead of all
<code>decoder_input_ids</code> of shape <code>(batch_size, sequence_length)</code>.`,name:"past_key_values"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.inputs_embeds",description:`<strong>inputs_embeds</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, hidden_size)</code>, <em>optional</em>) &#x2014;
Optionally, instead of passing <code>input_ids</code> you can choose to directly pass an embedded representation. This
is useful if you want more control over how to convert <code>input_ids</code> indices into associated vectors than the
model&#x2019;s internal embedding lookup matrix.`,name:"inputs_embeds"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_layer",description:`<strong>vision_feature_layer</strong> (<code>Union[int, List[int]], *optional*, defaults to -2</code>) &#x2014;
The index of the layer to select the vision feature. If multiple indices are provided,
the vision feature of the corresponding indices will be concatenated to form the
vision features.`,name:"vision_feature_layer"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.vision_feature_select_strategy",description:`<strong>vision_feature_select_strategy</strong> (<code>str</code>, <em>optional</em>, defaults to <code>&quot;default&quot;</code>) &#x2014;
The feature selection strategy used to select the vision feature from the vision backbone.
Can be one of <code>&quot;default&quot;</code> or <code>&quot;full&quot;</code>. If <code>&quot;default&quot;</code>, the CLS token is removed from the vision features.
If <code>&quot;full&quot;</code>, the full vision features are used.`,name:"vision_feature_select_strategy"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.use_cache",description:`<strong>use_cache</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
If set to <code>True</code>, <code>past_key_values</code> key value states are returned and can be used to speed up decoding (see
<code>past_key_values</code>).`,name:"use_cache"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_attentions",description:`<strong>output_attentions</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the attentions tensors of all attention layers. See <code>attentions</code> under returned
tensors for more detail.`,name:"output_attentions"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.output_hidden_states",description:`<strong>output_hidden_states</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return the hidden states of all layers. See <code>hidden_states</code> under returned tensors for
more detail.`,name:"output_hidden_states"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.return_dict",description:`<strong>return_dict</strong> (<code>bool</code>, <em>optional</em>) &#x2014;
Whether or not to return a <a href="/docs/transformers/main/en/main_classes/output#transformers.utils.ModelOutput">ModelOutput</a> instead of a plain tuple.`,name:"return_dict"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.cache_position",description:`<strong>cache_position</strong> (<code>torch.LongTensor</code> of shape <code>(sequence_length)</code>, <em>optional</em>) &#x2014;
Indices depicting the position of the input sequence tokens in the sequence. Contrarily to <code>position_ids</code>,
this tensor is not affected by padding. It is used to update the cache in the correct position and to infer
the complete sequence length.`,name:"cache_position"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.labels",description:`<strong>labels</strong> (<code>torch.LongTensor</code> of shape <code>(batch_size, sequence_length)</code>, <em>optional</em>) &#x2014;
Labels for computing the masked language modeling loss. Indices should either be in <code>[0, ..., config.vocab_size]</code> or -100 (see <code>input_ids</code> docstring). Tokens with indices set to <code>-100</code> are ignored
(masked), the loss is only computed for the tokens with labels in <code>[0, ..., config.vocab_size]</code>.`,name:"labels"},{anchor:"transformers.LlavaNextForConditionalGeneration.forward.logits_to_keep",description:`<strong>logits_to_keep</strong> (<code>int</code> or <code>torch.Tensor</code>, <em>optional</em>) &#x2014;
If an <code>int</code>, compute logits for the last <code>logits_to_keep</code> tokens. If <code>0</code>, calculate logits for all
<code>input_ids</code> (special case). Only last token logits are needed for generation, and calculating them only for that
token can save memory, which becomes pretty significant for long sequences or large vocabulary size.
If a <code>torch.Tensor</code>, must be 1D corresponding to the indices to keep in the sequence length dimension.
This is useful when using packed tensor format (single dimension for batch and sequence length).`,name:"logits_to_keep"}],source:"https://github.com/huggingface/transformers/blob/main/src/transformers/models/llava_next/modeling_llava_next.py#L540",returnDescription:`<script context="module">export const metadata = 'undefined';<\/script>


<p>A <code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or a tuple of
<code>torch.FloatTensor</code> (if <code>return_dict=False</code> is passed or when <code>config.return_dict=False</code>) comprising various
elements depending on the configuration (<a
  href="/docs/transformers/main/en/model_doc/granitevision#transformers.LlavaNextConfig"
>LlavaNextConfig</a>) and inputs.</p>
<ul>
<li>
<p><strong>loss</strong> (<code>torch.FloatTensor</code> of shape <code>(1,)</code>, <em>optional</em>, returned when <code>labels</code> is provided) — Language modeling loss (for next-token prediction).</p>
</li>
<li>
<p><strong>logits</strong> (<code>torch.FloatTensor</code> of shape <code>(batch_size, sequence_length, config.vocab_size)</code>) — Prediction scores of the language modeling head (scores for each vocabulary token before SoftMax).</p>
</li>
<li>
<p><strong>past_key_values</strong> (<code>tuple(tuple(torch.FloatTensor))</code>, <em>optional</em>, returned when <code>use_cache=True</code> is passed or when <code>config.use_cache=True</code>) — Tuple of <code>tuple(torch.FloatTensor)</code> of length <code>config.n_layers</code>, with each tuple having 2 tensors of shape
<code>(batch_size, num_heads, sequence_length, embed_size_per_head)</code>)</p>
<p>Contains pre-computed hidden-states (key and values in the self-attention blocks) that can be used (see
<code>past_key_values</code> input) to speed up sequential decoding.</p>
</li>
<li>
<p><strong>hidden_states</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_hidden_states=True</code> is passed or when <code>config.output_hidden_states=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for the output of the embeddings, if the model has an embedding layer, +
one for the output of each layer) of shape <code>(batch_size, sequence_length, hidden_size)</code>.</p>
<p>Hidden-states of the model at the output of each layer plus the optional initial embedding outputs.</p>
</li>
<li>
<p><strong>attentions</strong> (<code>tuple(torch.FloatTensor)</code>, <em>optional</em>, returned when <code>output_attentions=True</code> is passed or when <code>config.output_attentions=True</code>) — Tuple of <code>torch.FloatTensor</code> (one for each layer) of shape <code>(batch_size, num_heads, sequence_length, sequence_length)</code>.</p>
<p>Attentions weights after the attention softmax, used to compute the weighted average in the self-attention
heads.</p>
</li>
<li>
<p><strong>image_hidden_states</strong> (<code>torch.FloatTensor</code>, <em>optional</em>) — A <code>torch.FloatTensor</code> of size (batch_size * num_patches, num_images, sequence_length, hidden_size)\`.
image_hidden_states of the model produced by the vision encoder and after projecting the last hidden state.</p>
</li>
</ul>
`,returnType:`<script context="module">export const metadata = 'undefined';<\/script>


<p><code>transformers.models.llava_next.modeling_llava_next.LlavaNextCausalLMOutputWithPast</code> or <code>tuple(torch.FloatTensor)</code></p>
`}}),Q=new Eo({props:{$$slots:{default:[Ha]},$$scope:{ctx:j}}}),S=new ka({props:{anchor:"transformers.LlavaNextForConditionalGeneration.forward.example",$$slots:{default:[Qa]},$$scope:{ctx:j}}}),tt=new Ra({props:{source:"https://github.com/huggingface/transformers/blob/main/docs/source/en/model_doc/llava_next.md"}}),{c(){l=r("meta"),M=n(),T=r("p"),y=n(),m(v.$$.fragment),c=n(),b=r("div"),b.innerHTML=Yo,yt=n(),m(A.$$.fragment),vt=n(),D=r("p"),D.innerHTML=Ao,bt=n(),O=r("p"),O.textContent=Do,Mt=n(),K=r("p"),K.textContent=Oo,wt=n(),ee=r("p"),ee.textContent=Ko,Jt=n(),te=r("p"),te.textContent=ea,It=n(),oe=r("p"),oe.textContent=ta,Ut=n(),F=r("img"),xt=n(),ae=r("small"),ae.innerHTML=aa,jt=n(),ne=r("p"),ne.innerHTML=na,Ct=n(),m(se.$$.fragment),Nt=n(),re=r("ul"),re.innerHTML=sa,Lt=n(),m(G.$$.fragment),zt=n(),ie=r("blockquote"),ie.innerHTML=ra,$t=n(),m(le.$$.fragment),kt=n(),ce=r("p"),ce.innerHTML=ia,Zt=n(),de=r("p"),de.innerHTML=la,qt=n(),me=r("ul"),me.innerHTML=ca,Wt=n(),pe=r("p"),pe.innerHTML=da,Bt=n(),m(he.$$.fragment),Ft=n(),ge=r("ul"),ge.innerHTML=ma,Gt=n(),m(fe.$$.fragment),Rt=n(),ue=r("p"),ue.innerHTML=pa,Vt=n(),m(_e.$$.fragment),Xt=n(),Te=r("p"),Te.innerHTML=ha,Pt=n(),m(ye.$$.fragment),Ht=n(),ve=r("p"),ve.innerHTML=ga,Qt=n(),m(be.$$.fragment),St=n(),Me=r("p"),Me.innerHTML=fa,Et=n(),m(we.$$.fragment),Yt=n(),Je=r("p"),Je.innerHTML=ua,At=n(),m(Ie.$$.fragment),Dt=n(),m(Ue.$$.fragment),Ot=n(),xe=r("p"),xe.innerHTML=_a,Kt=n(),m(je.$$.fragment),eo=n(),m(Ce.$$.fragment),to=n(),Ne=r("p"),Ne.textContent=Ta,oo=n(),m(Le.$$.fragment),ao=n(),m(ze.$$.fragment),no=n(),m($e.$$.fragment),so=n(),ke=r("p"),ke.innerHTML=ya,ro=n(),m(R.$$.fragment),io=n(),Ze=r("p"),Ze.textContent=va,lo=n(),m(qe.$$.fragment),co=n(),m(We.$$.fragment),mo=n(),Be=r("p"),Be.innerHTML=ba,po=n(),m(Fe.$$.fragment),ho=n(),m(Ge.$$.fragment),go=n(),U=r("div"),m(Re.$$.fragment),jo=n(),at=r("p"),at.innerHTML=Ma,Co=n(),nt=r("p"),nt.innerHTML=wa,No=n(),m(V.$$.fragment),fo=n(),m(Ve.$$.fragment),uo=n(),z=r("div"),m(Xe.$$.fragment),Lo=n(),st=r("p"),st.innerHTML=Ja,zo=n(),rt=r("div"),m(Pe.$$.fragment),_o=n(),m(He.$$.fragment),To=n(),$=r("div"),m(Qe.$$.fragment),$o=n(),it=r("p"),it.textContent=Ia,ko=n(),X=r("div"),m(Se.$$.fragment),Zo=n(),lt=r("p"),lt.textContent=Ua,yo=n(),m(Ee.$$.fragment),vo=n(),J=r("div"),m(Ye.$$.fragment),qo=n(),ct=r("p"),ct.textContent=xa,Wo=n(),dt=r("p"),dt.innerHTML=ja,Bo=n(),P=r("div"),m(Ae.$$.fragment),Fo=n(),mt=r("p"),mt.innerHTML=Ca,Go=n(),H=r("div"),m(De.$$.fragment),Ro=n(),pt=r("p"),pt.innerHTML=Na,bo=n(),m(Oe.$$.fragment),Mo=n(),x=r("div"),m(Ke.$$.fragment),Vo=n(),ht=r("p"),ht.innerHTML=La,Xo=n(),gt=r("p"),gt.innerHTML=za,Po=n(),C=r("div"),m(et.$$.fragment),Ho=n(),ft=r("p"),ft.innerHTML=$a,Qo=n(),m(Q.$$.fragment),So=n(),m(S.$$.fragment),wo=n(),m(tt.$$.fragment),Jo=n(),ut=r("p"),this.h()},l(e){const t=Ga("svelte-u9bgzb",document.head);l=i(t,"META",{name:!0,content:!0}),t.forEach(o),M=s(e),T=i(e,"P",{}),N(T).forEach(o),y=s(e),p(v.$$.fragment,e),c=s(e),b=i(e,"DIV",{class:!0,"data-svelte-h":!0}),d(b)!=="svelte-b95w5j"&&(b.innerHTML=Yo),yt=s(e),p(A.$$.fragment,e),vt=s(e),D=i(e,"P",{"data-svelte-h":!0}),d(D)!=="svelte-5h5la5"&&(D.innerHTML=Ao),bt=s(e),O=i(e,"P",{"data-svelte-h":!0}),d(O)!=="svelte-1fhv1nu"&&(O.textContent=Do),Mt=s(e),K=i(e,"P",{"data-svelte-h":!0}),d(K)!=="svelte-1o8aykc"&&(K.textContent=Oo),wt=s(e),ee=i(e,"P",{"data-svelte-h":!0}),d(ee)!=="svelte-106g2gs"&&(ee.textContent=Ko),Jt=s(e),te=i(e,"P",{"data-svelte-h":!0}),d(te)!=="svelte-o65l2n"&&(te.textContent=ea),It=s(e),oe=i(e,"P",{"data-svelte-h":!0}),d(oe)!=="svelte-qaxeu7"&&(oe.textContent=ta),Ut=s(e),F=i(e,"IMG",{src:!0,alt:!0,width:!0}),xt=s(e),ae=i(e,"SMALL",{"data-svelte-h":!0}),d(ae)!=="svelte-1ueeg46"&&(ae.innerHTML=aa),jt=s(e),ne=i(e,"P",{"data-svelte-h":!0}),d(ne)!=="svelte-10gvx7f"&&(ne.innerHTML=na),Ct=s(e),p(se.$$.fragment,e),Nt=s(e),re=i(e,"UL",{"data-svelte-h":!0}),d(re)!=="svelte-b32abk"&&(re.innerHTML=sa),Lt=s(e),p(G.$$.fragment,e),zt=s(e),ie=i(e,"BLOCKQUOTE",{"data-svelte-h":!0}),d(ie)!=="svelte-nygwxc"&&(ie.innerHTML=ra),$t=s(e),p(le.$$.fragment,e),kt=s(e),ce=i(e,"P",{"data-svelte-h":!0}),d(ce)!=="svelte-pavm2p"&&(ce.innerHTML=ia),Zt=s(e),de=i(e,"P",{"data-svelte-h":!0}),d(de)!=="svelte-1uqcr0x"&&(de.innerHTML=la),qt=s(e),me=i(e,"UL",{"data-svelte-h":!0}),d(me)!=="svelte-imbcrg"&&(me.innerHTML=ca),Wt=s(e),pe=i(e,"P",{"data-svelte-h":!0}),d(pe)!=="svelte-1aakomu"&&(pe.innerHTML=da),Bt=s(e),p(he.$$.fragment,e),Ft=s(e),ge=i(e,"UL",{"data-svelte-h":!0}),d(ge)!=="svelte-uiv36d"&&(ge.innerHTML=ma),Gt=s(e),p(fe.$$.fragment,e),Rt=s(e),ue=i(e,"P",{"data-svelte-h":!0}),d(ue)!=="svelte-7fncpd"&&(ue.innerHTML=pa),Vt=s(e),p(_e.$$.fragment,e),Xt=s(e),Te=i(e,"P",{"data-svelte-h":!0}),d(Te)!=="svelte-5xtfcu"&&(Te.innerHTML=ha),Pt=s(e),p(ye.$$.fragment,e),Ht=s(e),ve=i(e,"P",{"data-svelte-h":!0}),d(ve)!=="svelte-ia69dt"&&(ve.innerHTML=ga),Qt=s(e),p(be.$$.fragment,e),St=s(e),Me=i(e,"P",{"data-svelte-h":!0}),d(Me)!=="svelte-cihbm7"&&(Me.innerHTML=fa),Et=s(e),p(we.$$.fragment,e),Yt=s(e),Je=i(e,"P",{"data-svelte-h":!0}),d(Je)!=="svelte-hqx9qk"&&(Je.innerHTML=ua),At=s(e),p(Ie.$$.fragment,e),Dt=s(e),p(Ue.$$.fragment,e),Ot=s(e),xe=i(e,"P",{"data-svelte-h":!0}),d(xe)!=="svelte-19yw9ck"&&(xe.innerHTML=_a),Kt=s(e),p(je.$$.fragment,e),eo=s(e),p(Ce.$$.fragment,e),to=s(e),Ne=i(e,"P",{"data-svelte-h":!0}),d(Ne)!=="svelte-1py9or5"&&(Ne.textContent=Ta),oo=s(e),p(Le.$$.fragment,e),ao=s(e),p(ze.$$.fragment,e),no=s(e),p($e.$$.fragment,e),so=s(e),ke=i(e,"P",{"data-svelte-h":!0}),d(ke)!=="svelte-bd1tou"&&(ke.innerHTML=ya),ro=s(e),p(R.$$.fragment,e),io=s(e),Ze=i(e,"P",{"data-svelte-h":!0}),d(Ze)!=="svelte-gwf9h7"&&(Ze.textContent=va),lo=s(e),p(qe.$$.fragment,e),co=s(e),p(We.$$.fragment,e),mo=s(e),Be=i(e,"P",{"data-svelte-h":!0}),d(Be)!=="svelte-ujer0t"&&(Be.innerHTML=ba),po=s(e),p(Fe.$$.fragment,e),ho=s(e),p(Ge.$$.fragment,e),go=s(e),U=i(e,"DIV",{class:!0});var k=N(U);p(Re.$$.fragment,k),jo=s(k),at=i(k,"P",{"data-svelte-h":!0}),d(at)!=="svelte-br1cgj"&&(at.innerHTML=Ma),Co=s(k),nt=i(k,"P",{"data-svelte-h":!0}),d(nt)!=="svelte-o55m63"&&(nt.innerHTML=wa),No=s(k),p(V.$$.fragment,k),k.forEach(o),fo=s(e),p(Ve.$$.fragment,e),uo=s(e),z=i(e,"DIV",{class:!0});var W=N(z);p(Xe.$$.fragment,W),Lo=s(W),st=i(W,"P",{"data-svelte-h":!0}),d(st)!=="svelte-1wlr4kn"&&(st.innerHTML=Ja),zo=s(W),rt=i(W,"DIV",{class:!0});var _t=N(rt);p(Pe.$$.fragment,_t),_t.forEach(o),W.forEach(o),_o=s(e),p(He.$$.fragment,e),To=s(e),$=i(e,"DIV",{class:!0});var B=N($);p(Qe.$$.fragment,B),$o=s(B),it=i(B,"P",{"data-svelte-h":!0}),d(it)!=="svelte-1bn0s7p"&&(it.textContent=Ia),ko=s(B),X=i(B,"DIV",{class:!0});var ot=N(X);p(Se.$$.fragment,ot),Zo=s(ot),lt=i(ot,"P",{"data-svelte-h":!0}),d(lt)!=="svelte-1x3yxsa"&&(lt.textContent=Ua),ot.forEach(o),B.forEach(o),yo=s(e),p(Ee.$$.fragment,e),vo=s(e),J=i(e,"DIV",{class:!0});var Z=N(J);p(Ye.$$.fragment,Z),qo=s(Z),ct=i(Z,"P",{"data-svelte-h":!0}),d(ct)!=="svelte-qcp8uy"&&(ct.textContent=xa),Wo=s(Z),dt=i(Z,"P",{"data-svelte-h":!0}),d(dt)!=="svelte-vblv8w"&&(dt.innerHTML=ja),Bo=s(Z),P=i(Z,"DIV",{class:!0});var Uo=N(P);p(Ae.$$.fragment,Uo),Fo=s(Uo),mt=i(Uo,"P",{"data-svelte-h":!0}),d(mt)!=="svelte-1o9eza"&&(mt.innerHTML=Ca),Uo.forEach(o),Go=s(Z),H=i(Z,"DIV",{class:!0});var xo=N(H);p(De.$$.fragment,xo),Ro=s(xo),pt=i(xo,"P",{"data-svelte-h":!0}),d(pt)!=="svelte-kk16qw"&&(pt.innerHTML=Na),xo.forEach(o),Z.forEach(o),bo=s(e),p(Oe.$$.fragment,e),Mo=s(e),x=i(e,"DIV",{class:!0});var E=N(x);p(Ke.$$.fragment,E),Vo=s(E),ht=i(E,"P",{"data-svelte-h":!0}),d(ht)!=="svelte-1mgcqn3"&&(ht.innerHTML=La),Xo=s(E),gt=i(E,"P",{"data-svelte-h":!0}),d(gt)!=="svelte-hswkmf"&&(gt.innerHTML=za),Po=s(E),C=i(E,"DIV",{class:!0});var Y=N(C);p(et.$$.fragment,Y),Ho=s(Y),ft=i(Y,"P",{"data-svelte-h":!0}),d(ft)!=="svelte-1m02emh"&&(ft.innerHTML=$a),Qo=s(Y),p(Q.$$.fragment,Y),So=s(Y),p(S.$$.fragment,Y),Y.forEach(o),E.forEach(o),wo=s(e),p(tt.$$.fragment,e),Jo=s(e),ut=i(e,"P",{}),N(ut).forEach(o),this.h()},h(){w(l,"name","hf:doc:metadata"),w(l,"content",Ea),w(b,"class","flex flex-wrap space-x-1"),qa(F.src,oa="https://huggingface.co/datasets/huggingface/documentation-images/resolve/main/transformers/model_doc/llava_next_overview.png")||w(F,"src",oa),w(F,"alt","drawing"),w(F,"width","600"),w(U,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(rt,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(z,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(X,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w($,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(P,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(H,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(J,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(C,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8"),w(x,"class","docstring border-l-2 border-t-2 pl-4 pt-3.5 border-gray-100 rounded-tl-xl mb-6 mt-8")},m(e,t){_(document.head,l),a(e,M,t),a(e,T,t),a(e,y,t),h(v,e,t),a(e,c,t),a(e,b,t),a(e,yt,t),h(A,e,t),a(e,vt,t),a(e,D,t),a(e,bt,t),a(e,O,t),a(e,Mt,t),a(e,K,t),a(e,wt,t),a(e,ee,t),a(e,Jt,t),a(e,te,t),a(e,It,t),a(e,oe,t),a(e,Ut,t),a(e,F,t),a(e,xt,t),a(e,ae,t),a(e,jt,t),a(e,ne,t),a(e,Ct,t),h(se,e,t),a(e,Nt,t),a(e,re,t),a(e,Lt,t),h(G,e,t),a(e,zt,t),a(e,ie,t),a(e,$t,t),h(le,e,t),a(e,kt,t),a(e,ce,t),a(e,Zt,t),a(e,de,t),a(e,qt,t),a(e,me,t),a(e,Wt,t),a(e,pe,t),a(e,Bt,t),h(he,e,t),a(e,Ft,t),a(e,ge,t),a(e,Gt,t),h(fe,e,t),a(e,Rt,t),a(e,ue,t),a(e,Vt,t),h(_e,e,t),a(e,Xt,t),a(e,Te,t),a(e,Pt,t),h(ye,e,t),a(e,Ht,t),a(e,ve,t),a(e,Qt,t),h(be,e,t),a(e,St,t),a(e,Me,t),a(e,Et,t),h(we,e,t),a(e,Yt,t),a(e,Je,t),a(e,At,t),h(Ie,e,t),a(e,Dt,t),h(Ue,e,t),a(e,Ot,t),a(e,xe,t),a(e,Kt,t),h(je,e,t),a(e,eo,t),h(Ce,e,t),a(e,to,t),a(e,Ne,t),a(e,oo,t),h(Le,e,t),a(e,ao,t),h(ze,e,t),a(e,no,t),h($e,e,t),a(e,so,t),a(e,ke,t),a(e,ro,t),h(R,e,t),a(e,io,t),a(e,Ze,t),a(e,lo,t),h(qe,e,t),a(e,co,t),h(We,e,t),a(e,mo,t),a(e,Be,t),a(e,po,t),h(Fe,e,t),a(e,ho,t),h(Ge,e,t),a(e,go,t),a(e,U,t),h(Re,U,null),_(U,jo),_(U,at),_(U,Co),_(U,nt),_(U,No),h(V,U,null),a(e,fo,t),h(Ve,e,t),a(e,uo,t),a(e,z,t),h(Xe,z,null),_(z,Lo),_(z,st),_(z,zo),_(z,rt),h(Pe,rt,null),a(e,_o,t),h(He,e,t),a(e,To,t),a(e,$,t),h(Qe,$,null),_($,$o),_($,it),_($,ko),_($,X),h(Se,X,null),_(X,Zo),_(X,lt),a(e,yo,t),h(Ee,e,t),a(e,vo,t),a(e,J,t),h(Ye,J,null),_(J,qo),_(J,ct),_(J,Wo),_(J,dt),_(J,Bo),_(J,P),h(Ae,P,null),_(P,Fo),_(P,mt),_(J,Go),_(J,H),h(De,H,null),_(H,Ro),_(H,pt),a(e,bo,t),h(Oe,e,t),a(e,Mo,t),a(e,x,t),h(Ke,x,null),_(x,Vo),_(x,ht),_(x,Xo),_(x,gt),_(x,Po),_(x,C),h(et,C,null),_(C,Ho),_(C,ft),_(C,Qo),h(Q,C,null),_(C,So),h(S,C,null),a(e,wo,t),h(tt,e,t),a(e,Jo,t),a(e,ut,t),Io=!0},p(e,[t]){const k={};t&2&&(k.$$scope={dirty:t,ctx:e}),G.$set(k);const W={};t&2&&(W.$$scope={dirty:t,ctx:e}),R.$set(W);const _t={};t&2&&(_t.$$scope={dirty:t,ctx:e}),V.$set(_t);const B={};t&2&&(B.$$scope={dirty:t,ctx:e}),Q.$set(B);const ot={};t&2&&(ot.$$scope={dirty:t,ctx:e}),S.$set(ot)},i(e){Io||(g(v.$$.fragment,e),g(A.$$.fragment,e),g(se.$$.fragment,e),g(G.$$.fragment,e),g(le.$$.fragment,e),g(he.$$.fragment,e),g(fe.$$.fragment,e),g(_e.$$.fragment,e),g(ye.$$.fragment,e),g(be.$$.fragment,e),g(we.$$.fragment,e),g(Ie.$$.fragment,e),g(Ue.$$.fragment,e),g(je.$$.fragment,e),g(Ce.$$.fragment,e),g(Le.$$.fragment,e),g(ze.$$.fragment,e),g($e.$$.fragment,e),g(R.$$.fragment,e),g(qe.$$.fragment,e),g(We.$$.fragment,e),g(Fe.$$.fragment,e),g(Ge.$$.fragment,e),g(Re.$$.fragment,e),g(V.$$.fragment,e),g(Ve.$$.fragment,e),g(Xe.$$.fragment,e),g(Pe.$$.fragment,e),g(He.$$.fragment,e),g(Qe.$$.fragment,e),g(Se.$$.fragment,e),g(Ee.$$.fragment,e),g(Ye.$$.fragment,e),g(Ae.$$.fragment,e),g(De.$$.fragment,e),g(Oe.$$.fragment,e),g(Ke.$$.fragment,e),g(et.$$.fragment,e),g(Q.$$.fragment,e),g(S.$$.fragment,e),g(tt.$$.fragment,e),Io=!0)},o(e){f(v.$$.fragment,e),f(A.$$.fragment,e),f(se.$$.fragment,e),f(G.$$.fragment,e),f(le.$$.fragment,e),f(he.$$.fragment,e),f(fe.$$.fragment,e),f(_e.$$.fragment,e),f(ye.$$.fragment,e),f(be.$$.fragment,e),f(we.$$.fragment,e),f(Ie.$$.fragment,e),f(Ue.$$.fragment,e),f(je.$$.fragment,e),f(Ce.$$.fragment,e),f(Le.$$.fragment,e),f(ze.$$.fragment,e),f($e.$$.fragment,e),f(R.$$.fragment,e),f(qe.$$.fragment,e),f(We.$$.fragment,e),f(Fe.$$.fragment,e),f(Ge.$$.fragment,e),f(Re.$$.fragment,e),f(V.$$.fragment,e),f(Ve.$$.fragment,e),f(Xe.$$.fragment,e),f(Pe.$$.fragment,e),f(He.$$.fragment,e),f(Qe.$$.fragment,e),f(Se.$$.fragment,e),f(Ee.$$.fragment,e),f(Ye.$$.fragment,e),f(Ae.$$.fragment,e),f(De.$$.fragment,e),f(Oe.$$.fragment,e),f(Ke.$$.fragment,e),f(et.$$.fragment,e),f(Q.$$.fragment,e),f(S.$$.fragment,e),f(tt.$$.fragment,e),Io=!1},d(e){e&&(o(M),o(T),o(y),o(c),o(b),o(yt),o(vt),o(D),o(bt),o(O),o(Mt),o(K),o(wt),o(ee),o(Jt),o(te),o(It),o(oe),o(Ut),o(F),o(xt),o(ae),o(jt),o(ne),o(Ct),o(Nt),o(re),o(Lt),o(zt),o(ie),o($t),o(kt),o(ce),o(Zt),o(de),o(qt),o(me),o(Wt),o(pe),o(Bt),o(Ft),o(ge),o(Gt),o(Rt),o(ue),o(Vt),o(Xt),o(Te),o(Pt),o(Ht),o(ve),o(Qt),o(St),o(Me),o(Et),o(Yt),o(Je),o(At),o(Dt),o(Ot),o(xe),o(Kt),o(eo),o(to),o(Ne),o(oo),o(ao),o(no),o(so),o(ke),o(ro),o(io),o(Ze),o(lo),o(co),o(mo),o(Be),o(po),o(ho),o(go),o(U),o(fo),o(uo),o(z),o(_o),o(To),o($),o(yo),o(vo),o(J),o(bo),o(Mo),o(x),o(wo),o(Jo),o(ut)),o(l),u(v,e),u(A,e),u(se,e),u(G,e),u(le,e),u(he,e),u(fe,e),u(_e,e),u(ye,e),u(be,e),u(we,e),u(Ie,e),u(Ue,e),u(je,e),u(Ce,e),u(Le,e),u(ze,e),u($e,e),u(R,e),u(qe,e),u(We,e),u(Fe,e),u(Ge,e),u(Re),u(V),u(Ve,e),u(Xe),u(Pe),u(He,e),u(Qe),u(Se),u(Ee,e),u(Ye),u(Ae),u(De),u(Oe,e),u(Ke),u(et),u(Q),u(S),u(tt,e)}}}const Ea='{"title":"LLaVA-NeXT","local":"llava-next","sections":[{"title":"Overview","local":"overview","sections":[],"depth":2},{"title":"Usage tips","local":"usage-tips","sections":[{"title":"Formatting Prompts with Chat Templates","local":"formatting-prompts-with-chat-templates","sections":[],"depth":3}],"depth":2},{"title":"Usage example","local":"usage-example","sections":[{"title":"Single image inference","local":"single-image-inference","sections":[],"depth":3},{"title":"Multi image inference","local":"multi-image-inference","sections":[],"depth":3}],"depth":2},{"title":"Model optimization","local":"model-optimization","sections":[{"title":"Quantization using Bitsandbytes","local":"quantization-using-bitsandbytes","sections":[],"depth":3},{"title":"Use Flash-Attention 2 to further speed-up generation","local":"use-flash-attention-2-to-further-speed-up-generation","sections":[],"depth":3}],"depth":2},{"title":"LlavaNextConfig","local":"transformers.LlavaNextConfig","sections":[],"depth":2},{"title":"LlavaNextImageProcessor","local":"transformers.LlavaNextImageProcessor","sections":[],"depth":2},{"title":"LlavaNextImageProcessorFast","local":"transformers.LlavaNextImageProcessorFast","sections":[],"depth":2},{"title":"LlavaNextProcessor","local":"transformers.LlavaNextProcessor","sections":[],"depth":2},{"title":"LlavaNextForConditionalGeneration","local":"transformers.LlavaNextForConditionalGeneration","sections":[],"depth":2}],"depth":1}';function Ya(j){return Wa(()=>{new URLSearchParams(window.location.search).get("fw")}),[]}class an extends Ba{constructor(l){super(),Fa(this,l,Ya,Sa,Za,{})}}export{an as component};
